import type { CommunitySortType } from "./CommunitySortType";
import type { ListingType } from "./ListingType";
import type { PaginationCursor } from "./PaginationCursor";
/**
 * Fetches a list of communities.
 */
export type ListCommunities = {
    type_?: ListingType;
    sort?: CommunitySortType;
    /**
     * Filter to within a given time range, in seconds.
     * IE 60 would give results for the past minute.
     */
    time_range_seconds?: number;
    show_nsfw?: boolean;
    page_cursor?: PaginationCursor;
    page_back?: boolean;
    limit?: number;
};
