import type { Comment } from "./Comment";
import type { CommentActions } from "./CommentActions";
import type { CommentReply } from "./CommentReply";
import type { Community } from "./Community";
import type { CommunityActions } from "./CommunityActions";
import type { ImageDetails } from "./ImageDetails";
import type { InboxCombined } from "./InboxCombined";
import type { InstanceActions } from "./InstanceActions";
import type { Person } from "./Person";
import type { PersonActions } from "./PersonActions";
import type { PersonCommentMention } from "./PersonCommentMention";
import type { PersonPostMention } from "./PersonPostMention";
import type { Post } from "./Post";
import type { PostActions } from "./PostActions";
import type { PrivateMessage } from "./PrivateMessage";
import type { TagsView } from "./TagsView";
/**
 * A combined inbox view
 */
export type InboxCombinedViewInternal = {
    inbox_combined: InboxCombined;
    comment_reply?: CommentReply;
    person_comment_mention?: PersonCommentMention;
    person_post_mention?: PersonPostMention;
    private_message?: PrivateMessage;
    comment?: Comment;
    post?: Post;
    community?: Community;
    item_creator: Person;
    item_recipient: Person;
    image_details?: ImageDetails;
    community_actions?: CommunityActions;
    instance_actions?: InstanceActions;
    post_actions?: PostActions;
    person_actions?: PersonActions;
    comment_actions?: CommentActions;
    item_creator_is_admin: boolean;
    post_tags: TagsView;
    can_mod: boolean;
    creator_banned: boolean;
    creator_is_moderator: boolean;
    creator_banned_from_community: boolean;
};
