(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["dashjs"] = factory();
	else
		root["dashjs"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_OBJECT.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_OBJECT.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_OBJECT: function() { return /* binding */ CMCD_OBJECT; }
/* harmony export */ });
/**
 * CMCD object header name.
 *
 * @group CMCD
 *
 * @beta
 */
const CMCD_OBJECT = 'CMCD-Object';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_PARAM.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_PARAM.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_PARAM: function() { return /* binding */ CMCD_PARAM; }
/* harmony export */ });
/**
 * CMCD parameter name.
 *
 * @group CMCD
 *
 * @beta
 */
const CMCD_PARAM = 'CMCD';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_REQUEST.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_REQUEST.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_REQUEST: function() { return /* binding */ CMCD_REQUEST; }
/* harmony export */ });
/**
 * CMCD request header name.
 *
 * @group CMCD
 *
 * @beta
 */
const CMCD_REQUEST = 'CMCD-Request';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_SESSION.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_SESSION.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_SESSION: function() { return /* binding */ CMCD_SESSION; }
/* harmony export */ });
/**
 * CMCD session header name.
 *
 * @group CMCD
 *
 * @beta
 */
const CMCD_SESSION = 'CMCD-Session';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_STATUS.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_STATUS.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_STATUS: function() { return /* binding */ CMCD_STATUS; }
/* harmony export */ });
/**
 * CMCD status header name.
 *
 * @group CMCD
 *
 * @beta
 */
const CMCD_STATUS = 'CMCD-Status';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdFormatters.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdFormatters.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdFormatters: function() { return /* binding */ CmcdFormatters; }
/* harmony export */ });
/* harmony import */ var _utils_urlToRelativePath_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/urlToRelativePath.js */ "./node_modules/@svta/common-media-library/dist/utils/urlToRelativePath.js");

const toRounded = value => Math.round(value);
const toUrlSafe = (value, options) => {
  if (options === null || options === void 0 ? void 0 : options.baseUrl) {
    value = (0,_utils_urlToRelativePath_js__WEBPACK_IMPORTED_MODULE_0__.urlToRelativePath)(value, options.baseUrl);
  }
  return encodeURIComponent(value);
};
const toHundred = value => toRounded(value / 100) * 100;
/**
 * The default formatters for CMCD values.
 *
 * @group CMCD
 *
 * @beta
 */
const CmcdFormatters = {
  /**
   * Bitrate (kbps) rounded integer
   */
  br: toRounded,
  /**
   * Duration (milliseconds) rounded integer
   */
  d: toRounded,
  /**
   * Buffer Length (milliseconds) rounded nearest 100ms
   */
  bl: toHundred,
  /**
   * Deadline (milliseconds) rounded nearest 100ms
   */
  dl: toHundred,
  /**
   * Measured Throughput (kbps) rounded nearest 100kbps
   */
  mtp: toHundred,
  /**
   * Next Object Request URL encoded
   */
  nor: toUrlSafe,
  /**
   * Requested maximum throughput (kbps) rounded nearest 100kbps
   */
  rtp: toHundred,
  /**
   * Top Bitrate (kbps) rounded integer
   */
  tb: toRounded
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdHeaderField: function() { return /* binding */ CmcdHeaderField; }
/* harmony export */ });
/* harmony import */ var _CMCD_OBJECT_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CMCD_OBJECT.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_OBJECT.js");
/* harmony import */ var _CMCD_REQUEST_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CMCD_REQUEST.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_REQUEST.js");
/* harmony import */ var _CMCD_SESSION_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CMCD_SESSION.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_SESSION.js");
/* harmony import */ var _CMCD_STATUS_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CMCD_STATUS.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_STATUS.js");




/**
 * CMCD header fields.
 *
 * @group CMCD
 *
 * @enum
 *
 * @beta
 */
const CmcdHeaderField = {
  /**
   * keys whose values vary with the object being requested.
   */
  OBJECT: _CMCD_OBJECT_js__WEBPACK_IMPORTED_MODULE_0__.CMCD_OBJECT,
  /**
   * keys whose values vary with each request.
   */
  REQUEST: _CMCD_REQUEST_js__WEBPACK_IMPORTED_MODULE_1__.CMCD_REQUEST,
  /**
   * keys whose values are expected to be invariant over the life of the session.
   */
  SESSION: _CMCD_SESSION_js__WEBPACK_IMPORTED_MODULE_2__.CMCD_SESSION,
  /**
   * keys whose values do not vary with every request or object.
   */
  STATUS: _CMCD_STATUS_js__WEBPACK_IMPORTED_MODULE_3__.CMCD_STATUS
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderMap.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderMap.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdHeaderMap: function() { return /* binding */ CmcdHeaderMap; }
/* harmony export */ });
/* harmony import */ var _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CmcdHeaderField.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js");

/**
 * The map of CMCD header fields to official CMCD keys.
 *
 * @internal
 *
 * @group CMCD
 */
const CmcdHeaderMap = {
  [_CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__.CmcdHeaderField.OBJECT]: ['br', 'd', 'ot', 'tb'],
  [_CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__.CmcdHeaderField.REQUEST]: ['bl', 'dl', 'mtp', 'nor', 'nrr', 'su'],
  [_CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__.CmcdHeaderField.SESSION]: ['cid', 'pr', 'sf', 'sid', 'st', 'v'],
  [_CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__.CmcdHeaderField.STATUS]: ['bs', 'rtp']
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdObjectType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdObjectType.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdObjectType: function() { return /* binding */ CmcdObjectType; }
/* harmony export */ });
/* harmony import */ var _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmObjectType.js */ "./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js");

/**
 * Common Media Client Data Object Type
 *
 * @group CMCD
 *
 * @beta
 *
 * @enum
 */
const CmcdObjectType = _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__.CmObjectType;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamType.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdStreamType: function() { return /* binding */ CmcdStreamType; }
/* harmony export */ });
/* harmony import */ var _cta_CmStreamType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmStreamType.js */ "./node_modules/@svta/common-media-library/dist/cta/CmStreamType.js");

/**
 * Common Media Client Data Stream Type
 *
 * @group CMCD
 *
 * @enum
 *
 * @beta
 */
const CmcdStreamType = _cta_CmStreamType_js__WEBPACK_IMPORTED_MODULE_0__.CmStreamType;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamingFormat.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamingFormat.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdStreamingFormat: function() { return /* binding */ CmcdStreamingFormat; }
/* harmony export */ });
/* harmony import */ var _cta_CmStreamingFormat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmStreamingFormat.js */ "./node_modules/@svta/common-media-library/dist/cta/CmStreamingFormat.js");

/**
 * Common Media Client Data Streaming Format
 *
 * @group CMCD
 *
 * @enum
 *
 * @beta
 */
const CmcdStreamingFormat = _cta_CmStreamingFormat_js__WEBPACK_IMPORTED_MODULE_0__.CmStreamingFormat;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/encodeCmcd.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/encodeCmcd.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   encodeCmcd: function() { return /* binding */ encodeCmcd; }
/* harmony export */ });
/* harmony import */ var _structuredfield_encodeSfDict_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../structuredfield/encodeSfDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/encodeSfDict.js");
/* harmony import */ var _utils_processCmcd_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/processCmcd.js */ "./node_modules/@svta/common-media-library/dist/cmcd/utils/processCmcd.js");


/**
 * Encode a CMCD object to a string.
 *
 * @param cmcd - The CMCD object to encode.
 * @param options - Options for encoding.
 *
 * @returns The encoded CMCD string.
 *
 * @group CMCD
 *
 * @beta
 */
function encodeCmcd(cmcd) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (!cmcd) {
    return '';
  }
  return (0,_structuredfield_encodeSfDict_js__WEBPACK_IMPORTED_MODULE_0__.encodeSfDict)((0,_utils_processCmcd_js__WEBPACK_IMPORTED_MODULE_1__.processCmcd)(cmcd, options), Object.assign({
    whitespace: false
  }, options));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/toCmcdHeaders.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/toCmcdHeaders.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toCmcdHeaders: function() { return /* binding */ toCmcdHeaders; }
/* harmony export */ });
/* harmony import */ var _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CmcdHeaderField.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js");
/* harmony import */ var _CmcdHeaderMap_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CmcdHeaderMap.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderMap.js");
/* harmony import */ var _encodeCmcd_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./encodeCmcd.js */ "./node_modules/@svta/common-media-library/dist/cmcd/encodeCmcd.js");



/**
 * Convert a CMCD data object to request headers
 *
 * @param cmcd - The CMCD data object to convert.
 * @param options - Options for encoding the CMCD object.
 *
 * @returns The CMCD header shards.
 *
 * @group CMCD
 *
 * @beta
 */
function toCmcdHeaders(cmcd) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const result = {};
  if (!cmcd) {
    return result;
  }
  const entries = Object.entries(cmcd);
  const headerMap = Object.entries(_CmcdHeaderMap_js__WEBPACK_IMPORTED_MODULE_1__.CmcdHeaderMap).concat(Object.entries((options === null || options === void 0 ? void 0 : options.customHeaderMap) || {}));
  const shards = entries.reduce((acc, entry) => {
    var _a, _b;
    const [key, value] = entry;
    const field = ((_a = headerMap.find(entry => entry[1].includes(key))) === null || _a === void 0 ? void 0 : _a[0]) || _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_0__.CmcdHeaderField.REQUEST;
    (_b = acc[field]) !== null && _b !== void 0 ? _b : acc[field] = {};
    acc[field][key] = value;
    return acc;
  }, {});
  return Object.entries(shards).reduce((acc, _ref) => {
    let [field, value] = _ref;
    acc[field] = (0,_encodeCmcd_js__WEBPACK_IMPORTED_MODULE_2__.encodeCmcd)(value, options);
    return acc;
  }, result);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/utils/processCmcd.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/utils/processCmcd.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processCmcd: function() { return /* binding */ processCmcd; }
/* harmony export */ });
/* harmony import */ var _cta_utils_isTokenField_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../cta/utils/isTokenField.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/isTokenField.js");
/* harmony import */ var _cta_utils_isValid_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../cta/utils/isValid.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/isValid.js");
/* harmony import */ var _structuredfield_SfToken_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../structuredfield/SfToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js");
/* harmony import */ var _CmcdFormatters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../CmcdFormatters.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdFormatters.js");




/**
 * Internal CMCD processing function.
 *
 * @param obj - The CMCD object to process.
 * @param map - The mapping function to use.
 * @param options - Options for encoding.
 *
 * @internal
 *
 * @group CMCD
 */
function processCmcd(obj, options) {
  const results = {};
  if (obj == null || typeof obj !== 'object') {
    return results;
  }
  const keys = Object.keys(obj).sort();
  const formatters = Object.assign({}, _CmcdFormatters_js__WEBPACK_IMPORTED_MODULE_3__.CmcdFormatters, options === null || options === void 0 ? void 0 : options.formatters);
  const filter = options === null || options === void 0 ? void 0 : options.filter;
  keys.forEach(key => {
    if (filter === null || filter === void 0 ? void 0 : filter(key)) {
      return;
    }
    let value = obj[key];
    const formatter = formatters[key];
    if (formatter) {
      value = formatter(value, options);
    }
    // Version should only be reported if not equal to 1.
    if (key === 'v' && value === 1) {
      return;
    }
    // Playback rate should only be sent if not equal to 1.
    if (key == 'pr' && value === 1) {
      return;
    }
    // ignore invalid values
    if (!(0,_cta_utils_isValid_js__WEBPACK_IMPORTED_MODULE_1__.isValid)(value)) {
      return;
    }
    if ((0,_cta_utils_isTokenField_js__WEBPACK_IMPORTED_MODULE_0__.isTokenField)(key) && typeof value === 'string') {
      value = new _structuredfield_SfToken_js__WEBPACK_IMPORTED_MODULE_2__.SfToken(value);
    }
    results[key] = value;
  });
  return results;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/CMSD_DYNAMIC.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/CMSD_DYNAMIC.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMSD_DYNAMIC: function() { return /* binding */ CMSD_DYNAMIC; }
/* harmony export */ });
/**
 * CMSD dynamic header name.
 *
 * @group CMSD
 *
 * @beta
 */
const CMSD_DYNAMIC = 'CMSD-Dynamic';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/CMSD_STATIC.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/CMSD_STATIC.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMSD_STATIC: function() { return /* binding */ CMSD_STATIC; }
/* harmony export */ });
/**
 * CMSD static header name.
 *
 * @group CMSD
 *
 * @beta
 */
const CMSD_STATIC = 'CMSD-Static';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/CmsdObjectType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/CmsdObjectType.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmsdObjectType: function() { return /* binding */ CmsdObjectType; }
/* harmony export */ });
/* harmony import */ var _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmObjectType.js */ "./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js");

/**
 * Common Media Server Data Object Type
 *
 * @group CMSD
 *
 * @enum
 *
 * @beta
 */
const CmsdObjectType = _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__.CmObjectType;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdDynamic.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdDynamic.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeCmsdDynamic: function() { return /* binding */ decodeCmsdDynamic; }
/* harmony export */ });
/* harmony import */ var _structuredfield_decodeSfList_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../structuredfield/decodeSfList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfList.js");

/**
 * Decode a CMSD dynamic string to an object.
 *
 * @param cmsd - The CMSD string to decode.
 *
 * @returns The decoded CMSD object.
 *
 * @group CMSD
 *
 * @beta
 */
function decodeCmsdDynamic(cmsd) {
  if (!cmsd) {
    return [];
  }
  const sfDict = (0,_structuredfield_decodeSfList_js__WEBPACK_IMPORTED_MODULE_0__.decodeSfList)(cmsd);
  return sfDict;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdStatic.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdStatic.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeCmsdStatic: function() { return /* binding */ decodeCmsdStatic; }
/* harmony export */ });
/* harmony import */ var _cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/utils/symbolToStr.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js");
/* harmony import */ var _structuredfield_decodeSfDict_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../structuredfield/decodeSfDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfDict.js");


/**
 * Decode a CMSD Static dict string to an object.
 *
 * @param cmsd - The CMSD string to decode.
 *
 * @returns The decoded CMSD object.
 *
 * @group CMSD
 *
 * @beta
 */
function decodeCmsdStatic(cmsd) {
  if (!cmsd) {
    return {};
  }
  return Object.entries((0,_structuredfield_decodeSfDict_js__WEBPACK_IMPORTED_MODULE_1__.decodeSfDict)(cmsd)).reduce((acc, _ref) => {
    let [key, item] = _ref;
    const {
      value
    } = item;
    acc[key] = typeof value === 'symbol' ? (0,_cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_0__.symbolToStr)(value) : value;
    return acc;
  }, {});
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmObjectType: function() { return /* binding */ CmObjectType; }
/* harmony export */ });
/**
 * Common Media Object Type
 *
 * @internal
 */
const CmObjectType = {
  /**
   * text file, such as a manifest or playlist
   */
  MANIFEST: 'm',
  /**
   * audio only
   */
  AUDIO: 'a',
  /**
   * video only
   */
  VIDEO: 'v',
  /**
   * muxed audio and video
   */
  MUXED: 'av',
  /**
   * init segment
   */
  INIT: 'i',
  /**
   * caption or subtitle
   */
  CAPTION: 'c',
  /**
   * ISOBMFF timed text track
   */
  TIMED_TEXT: 'tt',
  /**
   * cryptographic key, license or certificate.
   */
  KEY: 'k',
  /**
   * other
   */
  OTHER: 'o'
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/CmStreamType.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/CmStreamType.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmStreamType: function() { return /* binding */ CmStreamType; }
/* harmony export */ });
/**
 * Common Media Stream Type
 *
 * @internal
 */
const CmStreamType = {
  /**
   *  All segments are available – e.g., VOD
   */
  VOD: 'v',
  /**
   * Segments become available over time – e.g., LIVE
   */
  LIVE: 'l'
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/CmStreamingFormat.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/CmStreamingFormat.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmStreamingFormat: function() { return /* binding */ CmStreamingFormat; }
/* harmony export */ });
/**
 * Common Media Streaming Format
 *
 * @internal
 */
const CmStreamingFormat = {
  /**
   * MPEG DASH
   */
  DASH: 'd',
  /**
   * HTTP Live Streaming (HLS)
   */
  HLS: 'h',
  /**
   * Smooth Streaming
   */
  SMOOTH: 's',
  /**
   * Other
   */
  OTHER: 'o'
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/utils/isTokenField.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/utils/isTokenField.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isTokenField: function() { return /* binding */ isTokenField; }
/* harmony export */ });
/**
 * Checks if the given key is a token field.
 *
 * @param key - The key to check.
 *
 * @returns `true` if the key is a token field.
 *
 * @internal
 */
function isTokenField(key) {
  return key === 'ot' || key === 'sf' || key === 'st';
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/utils/isValid.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/utils/isValid.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValid: function() { return /* binding */ isValid; }
/* harmony export */ });
/**
 * Checks if the given value is valid
 *
 * @param value - The value to check.
 *
 * @returns `true` if the key is a value is valid.
 *
 * @internal
 */
function isValid(value) {
  if (typeof value === 'number') {
    return Number.isFinite(value);
  }
  return value != null && value !== '' && value !== false;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   symbolToStr: function() { return /* binding */ symbolToStr; }
/* harmony export */ });
/**
 * Converts a symbol to a string.
 *
 * @param symbol - The symbol to convert.
 *
 * @returns The string representation of the symbol.
 *
 * @internal
 */
function symbolToStr(symbol) {
  return symbol.description || symbol.toString().slice(7, -1);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/dash/processUriTemplate.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/dash/processUriTemplate.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processUriTemplate: function() { return /* binding */ processUriTemplate; }
/* harmony export */ });
const TOKENS = /\$(RepresentationID|Number|SubNumber|Bandwidth|Time)?(?:%0([0-9]+)([diouxX]))?\$/g;
/**
 * Process a URI template used in `SegmentTemplate` nodes.
 *
 * @param uriTemplate - URI template to process.
 * @param representationId - Representation ID.
 * @param number - Number.
 * @param subNumber - Sub-number.
 * @param bandwidth - Bandwidth.
 * @param time - Time. Should be passed as a number unless the value is larger than `MAX_SAFE_INTEGER`, then it should be provided as a string. If the value is a string all format tags will be ignored.
 *
 * @returns Processed URI template.
 *
 * @group DASH
 * @beta
 *
 * @example
 * {@includeCode ../../test/dash/processUriTemplate.test.ts#example}
 */
function processUriTemplate(uriTemplate, representationId, number, subNumber, bandwidth, time) {
  const uri = uriTemplate.replace(TOKENS, (match, name, widthStr, format) => {
    let value;
    switch (name) {
      case undefined:
        // $$ case
        return '$';
      case 'RepresentationID':
        value = representationId;
        break;
      case 'Number':
        value = number;
        break;
      case 'SubNumber':
        value = subNumber;
        break;
      case 'Bandwidth':
        value = bandwidth;
        break;
      case 'Time':
        if (typeof time === 'string') {
          return time;
        }
        value = time ? Math.round(time) : time;
        break;
      default:
        value = null;
    }
    if (value == null) {
      return match;
    }
    let valueString;
    switch (format) {
      case undefined: // Happens if there is no format specifier.
      case 'd':
      case 'i':
      case 'u':
        valueString = value.toString();
        break;
      case 'o':
        valueString = value.toString(8);
        break;
      case 'x':
        valueString = value.toString(16);
        break;
      case 'X':
        valueString = value.toString(16).toUpperCase();
        break;
      default:
        valueString = value.toString();
        break;
    }
    const width = parseInt(widthStr, 10) || 1;
    return valueString.padStart(width, '0');
  });
  return uri;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SfItem: function() { return /* binding */ SfItem; }
/* harmony export */ });
/**
 * Structured Field Item
 *
 * @group Structured Field
 *
 * @beta
 */
class SfItem {
  constructor(value, params) {
    if (Array.isArray(value)) {
      value = value.map(v => v instanceof SfItem ? v : new SfItem(v));
    }
    this.value = value;
    this.params = params;
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SfToken: function() { return /* binding */ SfToken; }
/* harmony export */ });
/**
 * A class to represent structured field tokens when `Symbol` is not available.
 *
 * @group Structured Field
 *
 * @beta
 */
class SfToken {
  constructor(description) {
    this.description = description;
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfDict.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfDict.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeSfDict: function() { return /* binding */ decodeSfDict; }
/* harmony export */ });
/* harmony import */ var _parse_parseDict_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parse/parseDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDict.js");
/* harmony import */ var _parse_parseError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse/parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _utils_DICT_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/DICT.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js");



/**
 * Decode a structured field string into a structured field dictionary
 *
 * @param input - The structured field string to decode
 * @returns The structured field dictionary
 *
 * @group Structured Field
 *
 * @beta
 */
function decodeSfDict(input, options) {
  try {
    const {
      src,
      value
    } = (0,_parse_parseDict_js__WEBPACK_IMPORTED_MODULE_0__.parseDict)(input.trim(), options);
    if (src !== '') {
      throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_1__.parseError)(src, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_2__.DICT);
    }
    return value;
  } catch (cause) {
    throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_1__.parseError)(input, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_2__.DICT, cause);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfList.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfList.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeSfList: function() { return /* binding */ decodeSfList; }
/* harmony export */ });
/* harmony import */ var _parse_parseError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parse/parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parse_parseList_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse/parseList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseList.js");
/* harmony import */ var _utils_LIST_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/LIST.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js");



/**
 * Decode a structured field string into a structured field list
 *
 * @param input - The structured field string to decode
 * @returns The structured field list
 *
 * @group Structured Field
 *
 * @beta
 */
function decodeSfList(input, options) {
  try {
    const {
      src,
      value
    } = (0,_parse_parseList_js__WEBPACK_IMPORTED_MODULE_1__.parseList)(input.trim(), options);
    if (src !== '') {
      throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_0__.parseError)(src, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_2__.LIST);
    }
    return value;
  } catch (cause) {
    throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_0__.parseError)(input, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_2__.LIST, cause);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/encodeSfDict.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/encodeSfDict.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   encodeSfDict: function() { return /* binding */ encodeSfDict; }
/* harmony export */ });
/* harmony import */ var _serialize_serializeDict_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./serialize/serializeDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDict.js");

/**
 * Encode an object into a structured field dictionary
 *
 * @param value - The structured field dictionary to encode
 * @param options - Encoding options
 *
 * @returns The structured field string
 *
 * @group Structured Field
 *
 * @beta
 */
function encodeSfDict(value, options) {
  return (0,_serialize_serializeDict_js__WEBPACK_IMPORTED_MODULE_0__.serializeDict)(value, options);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parsedValue: function() { return /* binding */ parsedValue; }
/* harmony export */ });
function parsedValue(value, src) {
  return {
    value,
    src
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseBareItem: function() { return /* binding */ parseBareItem; }
/* harmony export */ });
/* harmony import */ var _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/BARE_ITEM.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js");
/* harmony import */ var _parseBoolean_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseBoolean.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBoolean.js");
/* harmony import */ var _parseByteSequence_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseByteSequence.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseByteSequence.js");
/* harmony import */ var _parseDate_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseDate.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDate.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseIntegerOrDecimal.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js");
/* harmony import */ var _parseString_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./parseString.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseString.js");
/* harmony import */ var _parseToken_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./parseToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseToken.js");








// 4.2.3.1.  Parsing a Bare Item
//
// Given an ASCII string as input_string, return a bare Item.
// input_string is modified to remove the parsed value.
//
// 1.  If the first character of input_string is a "-" or a DIGIT,
//     return the result of running Parsing an Integer or Decimal
//     (Section 4.2.4) with input_string.
//
// 2.  If the first character of input_string is a DQUOTE, return the
//     result of running Parsing a String (Section 4.2.5) with
//     input_string.
//
// 3.  If the first character of input_string is ":", return the result
//     of running Parsing a Byte Sequence (Section 4.2.7) with
//     input_string.
//
// 4.  If the first character of input_string is "?", return the result
//     of running Parsing a Boolean (Section 4.2.8) with input_string.
//
// 5.  If the first character of input_string is an ALPHA or "*", return
//     the result of running Parsing a Token (Section 4.2.6) with
//     input_string.
//
// 6.  If the first character of input_string is "@", return the result
//     of running Parsing a Date (Section 4.2.9) with input_string.
//
// 7.  Otherwise, the item type is unrecognized; fail parsing.
function parseBareItem(src, options) {
  const first = src[0];
  if (first === `"`) {
    return (0,_parseString_js__WEBPACK_IMPORTED_MODULE_6__.parseString)(src);
  }
  if (/^[-0-9]/.test(first)) {
    return (0,_parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_5__.parseIntegerOrDecimal)(src);
  }
  if (first === `?`) {
    return (0,_parseBoolean_js__WEBPACK_IMPORTED_MODULE_1__.parseBoolean)(src);
  }
  if (first === `:`) {
    return (0,_parseByteSequence_js__WEBPACK_IMPORTED_MODULE_2__.parseByteSequence)(src);
  }
  if (/^[a-zA-Z*]/.test(first)) {
    return (0,_parseToken_js__WEBPACK_IMPORTED_MODULE_7__.parseToken)(src, options);
  }
  if (first === `@`) {
    return (0,_parseDate_js__WEBPACK_IMPORTED_MODULE_3__.parseDate)(src);
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(src, _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_0__.BARE_ITEM);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBoolean.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBoolean.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseBoolean: function() { return /* binding */ parseBoolean; }
/* harmony export */ });
/* harmony import */ var _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/BOOLEAN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");



// 4.2.8.  Parsing a Boolean
//
// Given an ASCII string as input_string, return a Boolean. input_string
// is modified to remove the parsed value.
//
// 1.  If the first character of input_string is not "?", fail parsing.
//
// 2.  Discard the first character of input_string.
//
// 3.  If the first character of input_string matches "1", discard the
//     first character, and return true.
//
// 4.  If the first character of input_string matches "0", discard the
//     first character, and return false.
//
// 5.  No value has matched; fail parsing.
function parseBoolean(src) {
  let i = 0;
  if (src[i] !== '?') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
  }
  i++;
  if (src[i] === '1') {
    return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(true, src.substring(++i));
  }
  if (src[i] === '0') {
    return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(false, src.substring(++i));
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseByteSequence.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseByteSequence.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseByteSequence: function() { return /* binding */ parseByteSequence; }
/* harmony export */ });
/* harmony import */ var _utils_base64decode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/base64decode.js */ "./node_modules/@svta/common-media-library/dist/utils/base64decode.js");
/* harmony import */ var _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/BYTES.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");




// 4.2.7.  Parsing a Byte Sequence
//
// Given an ASCII string as input_string, return a Byte Sequence.
// input_string is modified to remove the parsed value.
//
// 1.  If the first character of input_string is not ":", fail parsing.
//
// 2.  Discard the first character of input_string.
//
// 3.  If there is not a ":" character before the end of input_string,
//     fail parsing.
//
// 4.  Let b64_content be the result of consuming content of
//     input_string up to but not including the first instance of the
//     character ":".
//
// 5.  Consume the ":" character at the beginning of input_string.
//
// 6.  If b64_content contains a character not included in ALPHA, DIGIT,
//     "+", "/" and "=", fail parsing.
//
// 7.  Let binary_content be the result of Base 64 Decoding [RFC4648]
//     b64_content, synthesizing padding if necessary (note the
//     requirements about recipient behavior below).
//
// 8.  Return binary_content.
//
// Because some implementations of base64 do not allow rejection of
// encoded data that is not properly "=" padded (see [RFC4648],
// Section 3.2), parsers SHOULD NOT fail when "=" padding is not
// present, unless they cannot be configured to do so.
//
// Because some implementations of base64 do not allow rejection of
// encoded data that has non-zero pad bits (see [RFC4648], Section 3.5),
// parsers SHOULD NOT fail when non-zero pad bits are present, unless
// they cannot be configured to do so.
//
// This specification does not relax the requirements in [RFC4648],
// Section 3.1 and 3.3; therefore, parsers MUST fail on characters
// outside the base64 alphabet, and on line feeds in encoded data.
function parseByteSequence(src) {
  if (src[0] !== ':') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__.BYTES);
  }
  src = src.substring(1);
  if (src.includes(':') === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__.BYTES);
  }
  const re = /(^.*?)(:)/g;
  const b64_content = re.exec(src)[1];
  src = src.substring(re.lastIndex);
  // pass b64_content char check step 6
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)((0,_utils_base64decode_js__WEBPACK_IMPORTED_MODULE_0__.base64decode)(b64_content), src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDate.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDate.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseDate: function() { return /* binding */ parseDate; }
/* harmony export */ });
/* harmony import */ var _utils_DATE_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/DATE.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DATE.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseIntegerOrDecimal.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js");




// 4.2.9.  Parsing a Date
//
// Given an ASCII string as input_string, return a Date. input_string is
// modified to remove the parsed value.
//
// 1.  If the first character of input_string is not "@", fail parsing.
//
// 2.  Discard the first character of input_string.
//
// 3.  Let output_date be the result of running Parsing an Integer or
//     Decimal (Section 4.2.4) with input_string.
//
// 4.  If output_date is a Decimal, fail parsing.
//
// 5.  Return output_date.
function parseDate(src) {
  let i = 0;
  if (src[i] !== '@') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_DATE_js__WEBPACK_IMPORTED_MODULE_0__.DATE);
  }
  i++;
  const date = (0,_parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_3__.parseIntegerOrDecimal)(src.substring(i));
  if (Number.isInteger(date.value) === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_DATE_js__WEBPACK_IMPORTED_MODULE_0__.DATE);
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(new Date(date.value * 1000), date.src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDict.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDict.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseDict: function() { return /* binding */ parseDict; }
/* harmony export */ });
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _utils_DICT_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/DICT.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseItemOrInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js");
/* harmony import */ var _parseKey_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js");
/* harmony import */ var _parseParameters_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./parseParameters.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js");







// 4.2.2.  Parsing a Dictionary
//
// Given an ASCII string as input_string, return an ordered map whose
// values are (item_or_inner_list, parameters) tuples. input_string is
// modified to remove the parsed value.
//
// 1.  Let dictionary be an empty, ordered map.
//
// 2.  While input_string is not empty:
//
//     1.  Let this_key be the result of running Parsing a Key
//         (Section 4.2.3.3) with input_string.
//
//     2.  If the first character of input_string is "=":
//
//         1.  Consume the first character of input_string.
//
//         2.  Let member be the result of running Parsing an Item or
//             Inner List (Section 4.2.1.1) with input_string.
//
//     3.  Otherwise:
//
//         1.  Let value be Boolean true.
//
//         2.  Let parameters be the result of running Parsing
//             Parameters Section 4.2.3.2 with input_string.
//
//         3.  Let member be the tuple (value, parameters).
//
//     4.  Add name this_key with value member to dictionary.  If
//         dictionary already contains a name this_key (comparing
//         character-for-character), overwrite its value.
//
//     5.  Discard any leading OWS characters from input_string.
//
//     6.  If input_string is empty, return dictionary.
//
//     7.  Consume the first character of input_string; if it is not
//         ",", fail parsing.
//
//     8.  Discard any leading OWS characters from input_string.
//
//     9.  If input_string is empty, there is a trailing comma; fail
//         parsing.
//
// 3.  No structured data has been found; return dictionary (which is
//     empty).
//
// Note that when duplicate Dictionary keys are encountered, this has
// the effect of ignoring all but the last instance.
function parseDict(src, options) {
  const value = {};
  while (src.length > 0) {
    let member;
    const parsedKey = (0,_parseKey_js__WEBPACK_IMPORTED_MODULE_5__.parseKey)(src);
    const key = parsedKey.value;
    src = parsedKey.src;
    if (src[0] === '=') {
      const parsedItemOrInnerList = (0,_parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_4__.parseItemOrInnerList)(src.substring(1), options);
      member = parsedItemOrInnerList.value;
      src = parsedItemOrInnerList.src;
    } else {
      const parsedParameters = (0,_parseParameters_js__WEBPACK_IMPORTED_MODULE_6__.parseParameters)(src, options);
      member = new _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem(true, parsedParameters.value);
      src = parsedParameters.src;
    }
    value[key] = member;
    src = src.trim();
    if (src.length === 0) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)(value, src);
    }
    if (src[0] !== ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_1__.DICT);
    }
    src = src.substring(1).trim();
    if (src.length === 0 || src[0] === ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_1__.DICT);
    }
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)(value, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseError: function() { return /* binding */ parseError; }
/* harmony export */ });
/* harmony import */ var _utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/throwError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js");

function parseError(src, type, cause) {
  return (0,_utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__.throwError)('parse', src, type, cause);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseInnerList.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseInnerList.js ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseInnerList: function() { return /* binding */ parseInnerList; }
/* harmony export */ });
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _utils_INNER_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/INNER.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INNER.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseItem_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js");
/* harmony import */ var _parseParameters_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseParameters.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js");






// 4.2.1.2.  Parsing an Inner List
//
// Given an ASCII string as input_string, return the tuple (inner_list,
// parameters), where inner_list is an array of (bare_item, parameters)
// tuples. input_string is modified to remove the parsed value.
//
// 1.  Consume the first character of input_string; if it is not "(",
//     fail parsing.
//
// 2.  Let inner_list be an empty array.
//
// 3.  While input_string is not empty:
//
//     1.  Discard any leading SP characters from input_string.
//
//     2.  If the first character of input_string is ")":
//
//         1.  Consume the first character of input_string.
//
//         2.  Let parameters be the result of running Parsing
//             Parameters (Section 4.2.3.2) with input_string.
//
//         3.  Return the tuple (inner_list, parameters).
//
//     3.  Let item be the result of running Parsing an Item
//         (Section 4.2.3) with input_string.
//
//     4.  Append item to inner_list.
//
//     5.  If the first character of input_string is not SP or ")", fail
//         parsing.
//
// 4.  The end of the inner list was not found; fail parsing.
function parseInnerList(src, options) {
  if (src[0] !== '(') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_INNER_js__WEBPACK_IMPORTED_MODULE_1__.INNER);
  }
  src = src.substring(1);
  const innerList = [];
  while (src.length > 0) {
    src = src.trim();
    if (src[0] === ')') {
      src = src.substring(1);
      const parsedParameters = (0,_parseParameters_js__WEBPACK_IMPORTED_MODULE_5__.parseParameters)(src, options);
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)(new _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem(innerList, parsedParameters.value), parsedParameters.src);
    }
    const parsedItem = (0,_parseItem_js__WEBPACK_IMPORTED_MODULE_4__.parseItem)(src, options);
    innerList.push(parsedItem.value);
    src = parsedItem.src;
    if (src[0] !== ' ' && src[0] !== ')') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_INNER_js__WEBPACK_IMPORTED_MODULE_1__.INNER);
    }
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_INNER_js__WEBPACK_IMPORTED_MODULE_1__.INNER);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseIntegerOrDecimal: function() { return /* binding */ parseIntegerOrDecimal; }
/* harmony export */ });
/* harmony import */ var _utils_INTEGER_DECIMAL_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/INTEGER_DECIMAL.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER_DECIMAL.js");
/* harmony import */ var _utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/isInvalidInt.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");




// 4.2.4.  Parsing an Integer or Decimal
//
// Given an ASCII string as input_string, return an Integer or Decimal.
// input_string is modified to remove the parsed value.
//
// NOTE: This algorithm parses both Integers (Section 3.3.1) and
// Decimals (Section 3.3.2), and returns the corresponding structure.
//
// 1.   Let type be "integer".
//
// 2.   Let sign be 1.
//
// 3.   Let input_number be an empty string.
//
// 4.   If the first character of input_string is "-", consume it and
//      set sign to -1.
//
// 5.   If input_string is empty, there is an empty integer; fail
//      parsing.
//
// 6.   If the first character of input_string is not a DIGIT, fail
//      parsing.
//
// 7.   While input_string is not empty:
//
//      1.  Let char be the result of consuming the first character of
//          input_string.
//
//      2.  If char is a DIGIT, append it to input_number.
//
//      3.  Else, if type is "integer" and char is ".":
//
//          1.  If input_number contains more than 12 characters, fail
//              parsing.
//
//          2.  Otherwise, append char to input_number and set type to
//              "decimal".
//
//      4.  Otherwise, prepend char to input_string, and exit the loop.
//
//      5.  If type is "integer" and input_number contains more than 15
//          characters, fail parsing.
//
//      6.  If type is "decimal" and input_number contains more than 16
//          characters, fail parsing.
//
// 8.   If type is "integer":
//
//      1.  Parse input_number as an integer and let output_number be
//          the product of the result and sign.
//
//      2.  If output_number is outside the range -999,999,999,999,999
//          to 999,999,999,999,999 inclusive, fail parsing.
//
// 9.   Otherwise:
//
//      1.  If the final character of input_number is ".", fail parsing.
//
//      2.  If the number of characters after "." in input_number is
//          greater than three, fail parsing.
//
//      3.  Parse input_number as a decimal number and let output_number
//          be the product of the result and sign.
//
// 10.  Return output_number.
function parseIntegerOrDecimal(src) {
  const orig = src;
  let sign = 1;
  let num = '';
  let value;
  const i = 0;
  const error = (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(orig, _utils_INTEGER_DECIMAL_js__WEBPACK_IMPORTED_MODULE_0__.INTEGER_DECIMAL);
  if (src[i] === '-') {
    sign = -1;
    src = src.substring(1);
  }
  if (src.length <= 0) {
    throw error;
  }
  const re_integer = /^(\d+)?/g;
  const result_integer = re_integer.exec(src);
  if (result_integer[0].length === 0) {
    throw error;
  }
  num += result_integer[1];
  src = src.substring(re_integer.lastIndex);
  if (src[0] === '.') {
    // decimal
    if (num.length > 12) {
      throw error;
    }
    const re_decimal = /^(\.\d+)?/g;
    const result_decimal = re_decimal.exec(src);
    src = src.substring(re_decimal.lastIndex);
    // 9.2.  If the number of characters after "." in input_number is greater than three, fail parsing.
    if (result_decimal[0].length === 0 || result_decimal[1].length > 4) {
      throw error;
    }
    num += result_decimal[1];
    // 7.6.  If type is "decimal" and input_number contains more than 16 characters, fail parsing.
    if (num.length > 16) {
      throw error;
    }
    value = parseFloat(num) * sign;
  } else {
    // integer
    // 7.5.  If type is "integer" and input_number contains more than 15 characters, fail parsing.
    if (num.length > 15) {
      throw error;
    }
    value = parseInt(num) * sign;
    if ((0,_utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_1__.isInvalidInt)(value)) {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(num, _utils_INTEGER_DECIMAL_js__WEBPACK_IMPORTED_MODULE_0__.INTEGER_DECIMAL);
    }
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)(value, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseItem: function() { return /* binding */ parseItem; }
/* harmony export */ });
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseBareItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js");
/* harmony import */ var _parseParameters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseParameters.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js");




// 4.2.3.  Parsing an Item
//
// Given an ASCII string as input_string, return a (bare_item,
// parameters) tuple. input_string is modified to remove the parsed
// value.
//
// 1.  Let bare_item be the result of running Parsing a Bare Item
//     (Section 4.2.3.1) with input_string.
//
// 2.  Let parameters be the result of running Parsing Parameters
//     (Section 4.2.3.2) with input_string.
//
// 3.  Return the tuple (bare_item, parameters).
function parseItem(src, options) {
  const parsedBareItem = (0,_parseBareItem_js__WEBPACK_IMPORTED_MODULE_2__.parseBareItem)(src, options);
  src = parsedBareItem.src;
  const parsedParameters = (0,_parseParameters_js__WEBPACK_IMPORTED_MODULE_3__.parseParameters)(src, options);
  src = parsedParameters.src;
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(new _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem(parsedBareItem.value, parsedParameters.value), src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseItemOrInnerList: function() { return /* binding */ parseItemOrInnerList; }
/* harmony export */ });
/* harmony import */ var _parseInnerList_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parseInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseInnerList.js");
/* harmony import */ var _parseItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js");


// 4.2.1.1.  Parsing an Item or Inner List
//
// Given an ASCII string as input_string, return the tuple
// (item_or_inner_list, parameters), where item_or_inner_list can be
// either a single bare item, or an array of (bare_item, parameters)
// tuples. input_string is modified to remove the parsed value.
//
// 1.  If the first character of input_string is "(", return the result
//     of running Parsing an Inner List (Section 4.2.1.2) with
//     input_string.
//
// 2.  Return the result of running Parsing an Item (Section 4.2.3) with
//     input_string.
function parseItemOrInnerList(src, options) {
  if (src[0] === '(') {
    return (0,_parseInnerList_js__WEBPACK_IMPORTED_MODULE_0__.parseInnerList)(src, options);
  }
  return (0,_parseItem_js__WEBPACK_IMPORTED_MODULE_1__.parseItem)(src, options);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseKey: function() { return /* binding */ parseKey; }
/* harmony export */ });
/* harmony import */ var _utils_KEY_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/KEY.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");



// 4.2.3.3.  Parsing a Key
//
// Given an ASCII string as input_string, return a key. input_string is
// modified to remove the parsed value.
//
// 1.  If the first character of input_string is not lcalpha or "*",
//     fail parsing.
//
// 2.  Let output_string be an empty string.
//
// 3.  While input_string is not empty:
//
//     1.  If the first character of input_string is not one of lcalpha,
//         DIGIT, "_", "-", ".", or "*", return output_string.
//
//     2.  Let char be the result of consuming the first character of
//         input_string.
//
//     3.  Append char to output_string.
//
// 4.  Return output_string.
function parseKey(src) {
  let i = 0;
  if (/^[a-z*]$/.test(src[i]) === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_KEY_js__WEBPACK_IMPORTED_MODULE_0__.KEY);
  }
  let value = '';
  while (src.length > i) {
    if (/^[a-z0-9_\-.*]$/.test(src[i]) === false) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(value, src.substring(i));
    }
    value += src[i];
    i++;
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(value, src.substring(i));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseList.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseList.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseList: function() { return /* binding */ parseList; }
/* harmony export */ });
/* harmony import */ var _utils_LIST_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/LIST.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseItemOrInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js");




// 4.2.1.  Parsing a List
//
// Given an ASCII string as input_string, return an array of
// (item_or_inner_list, parameters) tuples. input_string is modified to
// remove the parsed value.
//
// 1.  Let members be an empty array.
//
// 2.  While input_string is not empty:
//
//     1.  Append the result of running Parsing an Item or Inner List
//         (Section 4.2.1.1) with input_string to members.
//
//     2.  Discard any leading OWS characters from input_string.
//
//     3.  If input_string is empty, return members.
//
//     4.  Consume the first character of input_string; if it is not
//         ",", fail parsing.
//
//     5.  Discard any leading OWS characters from input_string.
//
//     6.  If input_string is empty, there is a trailing comma; fail
//         parsing.
//
// 3.  No structured data has been found; return members (which is
//     empty).
function parseList(src, options) {
  const value = [];
  while (src.length > 0) {
    const parsedItemOrInnerList = (0,_parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_3__.parseItemOrInnerList)(src, options);
    value.push(parsedItemOrInnerList.value);
    src = parsedItemOrInnerList.src.trim();
    if (src.length === 0) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(value, src);
    }
    if (src[0] !== ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_0__.LIST);
    }
    src = src.substring(1).trim();
    if (src.length === 0 || src[0] === ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_0__.LIST);
    }
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(value, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseParameters: function() { return /* binding */ parseParameters; }
/* harmony export */ });
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseBareItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js");
/* harmony import */ var _parseKey_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js");



// 4.2.3.2.  Parsing Parameters
//
// Given an ASCII string as input_string, return an ordered map whose
// values are bare Items. input_string is modified to remove the parsed
// value.
//
// 1.  Let parameters be an empty, ordered map.
//
// 2.  While input_string is not empty:
//
//     1.  If the first character of input_string is not ";", exit the
//         loop.
//
//     2.  Consume a ";" character from the beginning of input_string.
//
//     3.  Discard any leading SP characters from input_string.
//
//     4.  let param_name be the result of running Parsing a Key
//         (Section 4.2.3.3) with input_string.
//
//     5.  Let param_value be Boolean true.
//
//     6.  If the first character of input_string is "=":
//
//         1.  Consume the "=" character at the beginning of
//             input_string.
//
//         2.  Let param_value be the result of running Parsing a Bare
//             Item (Section 4.2.3.1) with input_string.
//
//     7.  Append key param_name with value param_value to parameters.
//         If parameters already contains a name param_name (comparing
//         character-for-character), overwrite its value.
//
// 3.  Return parameters.
//
// Note that when duplicate Parameter keys are encountered, this has the
// effect of ignoring all but the last instance.
function parseParameters(src, options) {
  let parameters = undefined;
  while (src.length > 0) {
    if (src[0] !== ';') {
      break;
    }
    src = src.substring(1).trim();
    const parsedKey = (0,_parseKey_js__WEBPACK_IMPORTED_MODULE_2__.parseKey)(src);
    const key = parsedKey.value;
    let value = true;
    src = parsedKey.src;
    if (src[0] === '=') {
      src = src.substring(1);
      const parsedBareItem = (0,_parseBareItem_js__WEBPACK_IMPORTED_MODULE_1__.parseBareItem)(src, options);
      value = parsedBareItem.value;
      src = parsedBareItem.src;
    }
    // initialize as object when params exists
    if (parameters == null) {
      parameters = {};
    }
    // override if param_name exists
    parameters[key] = value;
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_0__.parsedValue)(parameters, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseString.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseString.js ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseString: function() { return /* binding */ parseString; }
/* harmony export */ });
/* harmony import */ var _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/STRING.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js");
/* harmony import */ var _utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/STRING_REGEX.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");




// 4.2.5.  Parsing a String
//
// Given an ASCII string as input_string, return an unquoted String.
// input_string is modified to remove the parsed value.
//
// 1.  Let output_string be an empty string.
//
// 2.  If the first character of input_string is not DQUOTE, fail
//     parsing.
//
// 3.  Discard the first character of input_string.
//
// 4.  While input_string is not empty:
//
//     1.  Let char be the result of consuming the first character of
//         input_string.
//
//     2.  If char is a backslash ("\"):
//
//         1.  If input_string is now empty, fail parsing.
//
//         2.  Let next_char be the result of consuming the first
//             character of input_string.
//
//         3.  If next_char is not DQUOTE or "\", fail parsing.
//
//         4.  Append next_char to output_string.
//
//     3.  Else, if char is DQUOTE, return output_string.
//
//     4.  Else, if char is in the range %x00-1f or %x7f (i.e., is not
//         in VCHAR or SP), fail parsing.
//
//     5.  Else, append char to output_string.
//
// 5.  Reached the end of input_string without finding a closing DQUOTE;
//     fail parsing.
function parseString(src) {
  let output = '';
  let i = 0;
  if (src[i] !== `"`) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__.STRING);
  }
  i++;
  while (src.length > i) {
    if (src[i] === `\\`) {
      if (src.length <= i + 1) {
        throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__.STRING);
      }
      i++;
      if (src[i] !== `"` && src[i] !== `\\`) {
        throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__.STRING);
      }
      output += src[i];
    } else if (src[i] === `"`) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)(output, src.substring(++i));
    } else if (_utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_1__.STRING_REGEX.test(src[i])) {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__.STRING);
    } else {
      output += src[i];
    }
    i++;
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__.STRING);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseToken.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseToken.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseToken: function() { return /* binding */ parseToken; }
/* harmony export */ });
/* harmony import */ var _SfToken_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js");
/* harmony import */ var _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/TOKEN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");




// 4.2.6.  Parsing a Token
//
// Given an ASCII string as input_string, return a Token. input_string
// is modified to remove the parsed value.
//
// 1.  If the first character of input_string is not ALPHA or "*", fail
//     parsing.
//
// 2.  Let output_string be an empty string.
//
// 3.  While input_string is not empty:
//
//     1.  If the first character of input_string is not in tchar, ":"
//         or "/", return output_string.
//
//     2.  Let char be the result of consuming the first character of
//         input_string.
//
//     3.  Append char to output_string.
//
// 4.  Return output_string.
function parseToken(src, options) {
  if (/^[a-zA-Z*]$/.test(src[0]) === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_1__.TOKEN);
  }
  const re = /^([!#$%&'*+\-.^_`|~\w:/]+)/g;
  const value = re.exec(src)[1];
  src = src.substring(re.lastIndex);
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)((options === null || options === void 0 ? void 0 : options.useSymbol) === false ? new _SfToken_js__WEBPACK_IMPORTED_MODULE_0__.SfToken(value) : Symbol.for(value), src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeBareItem: function() { return /* binding */ serializeBareItem; }
/* harmony export */ });
/* harmony import */ var _SfToken_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js");
/* harmony import */ var _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/BARE_ITEM.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js");
/* harmony import */ var _serializeBoolean_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeBoolean.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBoolean.js");
/* harmony import */ var _serializeByteSequence_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./serializeByteSequence.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeByteSequence.js");
/* harmony import */ var _serializeDate_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serializeDate.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDate.js");
/* harmony import */ var _serializeDecimal_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serializeDecimal.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDecimal.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");
/* harmony import */ var _serializeInteger_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./serializeInteger.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js");
/* harmony import */ var _serializeString_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./serializeString.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeString.js");
/* harmony import */ var _serializeToken_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./serializeToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeToken.js");










// 4.1.3.1.  Serializing a Bare Item
//
// Given an Item as input_item, return an ASCII string suitable for use
// in a HTTP field value.
//
// 1.  If input_item is an Integer, return the result of running
//     Serializing an Integer (Section 4.1.4) with input_item.
//
// 2.  If input_item is a Decimal, return the result of running
//     Serializing a Decimal (Section 4.1.5) with input_item.
//
// 3.  If input_item is a String, return the result of running
//     Serializing a String (Section 4.1.6) with input_item.
//
// 4.  If input_item is a Token, return the result of running
//     Serializing a Token (Section 4.1.7) with input_item.
//
// 5.  If input_item is a Boolean, return the result of running
//     Serializing a Boolean (Section 4.1.9) with input_item.
//
// 6.  If input_item is a Byte Sequence, return the result of running
//     Serializing a Byte Sequence (Section 4.1.8) with input_item.
//
// 7.  If input_item is a Date, return the result of running Serializing
//     a Date (Section 4.1.10) with input_item.
//
// 8.  Otherwise, fail serialization.
function serializeBareItem(value) {
  switch (typeof value) {
    case 'number':
      if (!Number.isFinite(value)) {
        throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_6__.serializeError)(value, _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_1__.BARE_ITEM);
      }
      if (Number.isInteger(value)) {
        return (0,_serializeInteger_js__WEBPACK_IMPORTED_MODULE_7__.serializeInteger)(value);
      }
      return (0,_serializeDecimal_js__WEBPACK_IMPORTED_MODULE_5__.serializeDecimal)(value);
    case 'string':
      return (0,_serializeString_js__WEBPACK_IMPORTED_MODULE_8__.serializeString)(value);
    case 'symbol':
      return (0,_serializeToken_js__WEBPACK_IMPORTED_MODULE_9__.serializeToken)(value);
    case 'boolean':
      return (0,_serializeBoolean_js__WEBPACK_IMPORTED_MODULE_2__.serializeBoolean)(value);
    case 'object':
      if (value instanceof Date) {
        return (0,_serializeDate_js__WEBPACK_IMPORTED_MODULE_4__.serializeDate)(value);
      }
      if (value instanceof Uint8Array) {
        return (0,_serializeByteSequence_js__WEBPACK_IMPORTED_MODULE_3__.serializeByteSequence)(value);
      }
      if (value instanceof _SfToken_js__WEBPACK_IMPORTED_MODULE_0__.SfToken) {
        return (0,_serializeToken_js__WEBPACK_IMPORTED_MODULE_9__.serializeToken)(value);
      }
    default:
      // fail
      throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_6__.serializeError)(value, _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_1__.BARE_ITEM);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBoolean.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBoolean.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeBoolean: function() { return /* binding */ serializeBoolean; }
/* harmony export */ });
/* harmony import */ var _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/BOOLEAN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");


// 4.1.9.  Serializing a Boolean
//
// Given a Boolean as input_boolean, return an ASCII string suitable for
// use in a HTTP field value.
//
// 1.  If input_boolean is not a boolean, fail serialization.
//
// 2.  Let output be an empty string.
//
// 3.  Append "?" to output.
//
// 4.  If input_boolean is true, append "1" to output.
//
// 5.  If input_boolean is false, append "0" to output.
//
// 6.  Return output.
function serializeBoolean(value) {
  if (typeof value !== 'boolean') {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_1__.serializeError)(value, _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
  }
  return value ? '?1' : '?0';
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeByteSequence.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeByteSequence.js ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeByteSequence: function() { return /* binding */ serializeByteSequence; }
/* harmony export */ });
/* harmony import */ var _utils_base64encode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/base64encode.js */ "./node_modules/@svta/common-media-library/dist/utils/base64encode.js");
/* harmony import */ var _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/BYTES.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");



// 4.1.8.  Serializing a Byte Sequence
//
// Given a Byte Sequence as input_bytes, return an ASCII string suitable
// for use in a HTTP field value.
//
// 1.  If input_bytes is not a sequence of bytes, fail serialization.
//
// 2.  Let output be an empty string.
//
// 3.  Append ":" to output.
//
// 4.  Append the result of base64-encoding input_bytes as per
//     [RFC4648], Section 4, taking account of the requirements below.
//
// 5.  Append ":" to output.
//
// 6.  Return output.
//
// The encoded data is required to be padded with "=", as per [RFC4648],
// Section 3.2.
//
// Likewise, encoded data SHOULD have pad bits set to zero, as per
// [RFC4648], Section 3.5, unless it is not possible to do so due to
// implementation constraints.
function serializeByteSequence(value) {
  if (ArrayBuffer.isView(value) === false) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(value, _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__.BYTES);
  }
  return `:${(0,_utils_base64encode_js__WEBPACK_IMPORTED_MODULE_0__.base64encode)(value)}:`;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDate.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDate.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeDate: function() { return /* binding */ serializeDate; }
/* harmony export */ });
/* harmony import */ var _serializeInteger_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./serializeInteger.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js");

// 4.1.10.  Serializing a Date
//
// Given a Date as input_integer, return an ASCII string suitable for
// use in an HTTP field value.
// 1.  Let output be "@".
// 2.  Append to output the result of running Serializing an Integer
//     with input_date (Section 4.1.4).
// 3.  Return output.
function serializeDate(value) {
  return `@${(0,_serializeInteger_js__WEBPACK_IMPORTED_MODULE_0__.serializeInteger)(value.getTime() / 1000)}`;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDecimal.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDecimal.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeDecimal: function() { return /* binding */ serializeDecimal; }
/* harmony export */ });
/* harmony import */ var _utils_roundToEven_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/roundToEven.js */ "./node_modules/@svta/common-media-library/dist/utils/roundToEven.js");
/* harmony import */ var _utils_DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/DECIMAL.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");



// 4.1.5.  Serializing a Decimal
//
// Given a decimal number as input_decimal, return an ASCII string
// suitable for use in a HTTP field value.
//
// 1.   If input_decimal is not a decimal number, fail serialization.
//
// 2.   If input_decimal has more than three significant digits to the
//      right of the decimal point, round it to three decimal places,
//      rounding the final digit to the nearest value, or to the even
//      value if it is equidistant.
//
// 3.   If input_decimal has more than 12 significant digits to the left
//      of the decimal point after rounding, fail serialization.
//
// 4.   Let output be an empty string.
//
// 5.   If input_decimal is less than (but not equal to) 0, append "-"
//      to output.
//
// 6.   Append input_decimal's integer component represented in base 10
//      (using only decimal digits) to output; if it is zero, append
//      "0".
//
// 7.   Append "." to output.
//
// 8.   If input_decimal's fractional component is zero, append "0" to
//      output.
//
// 9.   Otherwise, append the significant digits of input_decimal's
//      fractional component represented in base 10 (using only decimal
//      digits) to output.
//
// 10.  Return output.
function serializeDecimal(value) {
  const roundedValue = (0,_utils_roundToEven_js__WEBPACK_IMPORTED_MODULE_0__.roundToEven)(value, 3); // round to 3 decimal places
  if (Math.floor(Math.abs(roundedValue)).toString().length > 12) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(value, _utils_DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__.DECIMAL);
  }
  const stringValue = roundedValue.toString();
  return stringValue.includes('.') ? stringValue : `${stringValue}.0`;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDict.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDict.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeDict: function() { return /* binding */ serializeDict; }
/* harmony export */ });
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _utils_DICT_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/DICT.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");
/* harmony import */ var _serializeInnerList_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./serializeInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInnerList.js");
/* harmony import */ var _serializeItem_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serializeItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js");
/* harmony import */ var _serializeKey_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serializeKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js");
/* harmony import */ var _serializeParams_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./serializeParams.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js");







// 4.1.2.  Serializing a Dictionary
//
// Given an ordered Dictionary as input_dictionary (each member having a
// member_name and a tuple value of (member_value, parameters)), return
// an ASCII string suitable for use in a HTTP field value.
//
// 1.  Let output be an empty string.
//
// 2.  For each member_name with a value of (member_value, parameters)
//     in input_dictionary:
//
//     1.  Append the result of running Serializing a Key
//         (Section 4.1.1.3) with member's member_name to output.
//
//     2.  If member_value is Boolean true:
//
//         1.  Append the result of running Serializing Parameters
//             (Section 4.1.1.2) with parameters to output.
//
//     3.  Otherwise:
//
//         1.  Append "=" to output.
//
//         2.  If member_value is an array, append the result of running
//             Serializing an Inner List (Section 4.1.1.1) with
//             (member_value, parameters) to output.
//
//         3.  Otherwise, append the result of running Serializing an
//             Item (Section 4.1.3) with (member_value, parameters) to
//             output.
//
//     4.  If more members remain in input_dictionary:
//
//         1.  Append "," to output.
//
//         2.  Append a single SP to output.
//
// 3.  Return output.
function serializeDict(dict) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    whitespace: true
  };
  if (typeof dict !== 'object') {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(dict, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_1__.DICT);
  }
  const entries = dict instanceof Map ? dict.entries() : Object.entries(dict);
  const optionalWhiteSpace = (options === null || options === void 0 ? void 0 : options.whitespace) ? ' ' : '';
  return Array.from(entries).map(_ref => {
    let [key, item] = _ref;
    if (item instanceof _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem === false) {
      item = new _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem(item);
    }
    let output = (0,_serializeKey_js__WEBPACK_IMPORTED_MODULE_5__.serializeKey)(key);
    if (item.value === true) {
      output += (0,_serializeParams_js__WEBPACK_IMPORTED_MODULE_6__.serializeParams)(item.params);
    } else {
      output += '=';
      if (Array.isArray(item.value)) {
        output += (0,_serializeInnerList_js__WEBPACK_IMPORTED_MODULE_3__.serializeInnerList)(item);
      } else {
        output += (0,_serializeItem_js__WEBPACK_IMPORTED_MODULE_4__.serializeItem)(item);
      }
    }
    return output;
  }).join(`,${optionalWhiteSpace}`);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeError: function() { return /* binding */ serializeError; }
/* harmony export */ });
/* harmony import */ var _utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/throwError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js");

function serializeError(src, type, cause) {
  return (0,_utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__.throwError)('serialize', src, type, cause);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInnerList.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInnerList.js ***!
  \******************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeInnerList: function() { return /* binding */ serializeInnerList; }
/* harmony export */ });
/* harmony import */ var _serializeItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./serializeItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js");
/* harmony import */ var _serializeParams_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serializeParams.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js");


// 4.1.1.1.  Serializing an Inner List
//
// Given an array of (member_value, parameters) tuples as inner_list,
// and parameters as list_parameters, return an ASCII string suitable
// for use in a HTTP field value.
//
// 1.  Let output be the string "(".
//
// 2.  For each (member_value, parameters) of inner_list:
//
//     1.  Append the result of running Serializing an Item
//         (Section 4.1.3) with (member_value, parameters) to output.
//
//     2.  If more values remain in inner_list, append a single SP to
//         output.
//
// 3.  Append ")" to output.
//
// 4.  Append the result of running Serializing Parameters
//     (Section 4.1.1.2) with list_parameters to output.
//
// 5.  Return output.
function serializeInnerList(value) {
  return `(${value.value.map(_serializeItem_js__WEBPACK_IMPORTED_MODULE_0__.serializeItem).join(' ')})${(0,_serializeParams_js__WEBPACK_IMPORTED_MODULE_1__.serializeParams)(value.params)}`;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeInteger: function() { return /* binding */ serializeInteger; }
/* harmony export */ });
/* harmony import */ var _utils_INTEGER_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/INTEGER.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js");
/* harmony import */ var _utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/isInvalidInt.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");



// 4.1.4.  Serializing an Integer
//
// Given an Integer as input_integer, return an ASCII string suitable
// for use in a HTTP field value.
//
// 1.  If input_integer is not an integer in the range of
//     -999,999,999,999,999 to 999,999,999,999,999 inclusive, fail
//     serialization.
//
// 2.  Let output be an empty string.
//
// 3.  If input_integer is less than (but not equal to) 0, append "-" to
//     output.
//
// 4.  Append input_integer's numeric value represented in base 10 using
//     only decimal digits to output.
//
// 5.  Return output.
function serializeInteger(value) {
  if ((0,_utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_1__.isInvalidInt)(value)) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(value, _utils_INTEGER_js__WEBPACK_IMPORTED_MODULE_0__.INTEGER);
  }
  return value.toString();
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeItem: function() { return /* binding */ serializeItem; }
/* harmony export */ });
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _serializeBareItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serializeBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js");
/* harmony import */ var _serializeParams_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeParams.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js");



// 4.1.3.  Serializing an Item
//
// Given an Item as bare_item and Parameters as item_parameters, return
// an ASCII string suitable for use in a HTTP field value.
//
// 1.  Let output be an empty string.
//
// 2.  Append the result of running Serializing a Bare Item
//     Section 4.1.3.1 with bare_item to output.
//
// 3.  Append the result of running Serializing Parameters
//     Section 4.1.1.2 with item_parameters to output.
//
// 4.  Return output.
function serializeItem(value) {
  if (value instanceof _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem) {
    return `${(0,_serializeBareItem_js__WEBPACK_IMPORTED_MODULE_1__.serializeBareItem)(value.value)}${(0,_serializeParams_js__WEBPACK_IMPORTED_MODULE_2__.serializeParams)(value.params)}`;
  } else {
    return (0,_serializeBareItem_js__WEBPACK_IMPORTED_MODULE_1__.serializeBareItem)(value);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js ***!
  \************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeKey: function() { return /* binding */ serializeKey; }
/* harmony export */ });
/* harmony import */ var _utils_KEY_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/KEY.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");


// 4.1.1.3.  Serializing a Key
//
// Given a key as input_key, return an ASCII string suitable for use in
// a HTTP field value.
//
// 1.  Convert input_key into a sequence of ASCII characters; if
//     conversion fails, fail serialization.
//
// 2.  If input_key contains characters not in lcalpha, DIGIT, "_", "-",
//     ".", or "*" fail serialization.
//
// 3.  If the first character of input_key is not lcalpha or "*", fail
//     serialization.
//
// 4.  Let output be an empty string.
//
// 5.  Append input_key to output.
//
// 6.  Return output.
function serializeKey(value) {
  if (/^[a-z*][a-z0-9\-_.*]*$/.test(value) === false) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_1__.serializeError)(value, _utils_KEY_js__WEBPACK_IMPORTED_MODULE_0__.KEY);
  }
  return value;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeParams: function() { return /* binding */ serializeParams; }
/* harmony export */ });
/* harmony import */ var _serializeBareItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./serializeBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js");
/* harmony import */ var _serializeKey_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serializeKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js");


// 4.1.1.2.  Serializing Parameters
//
// Given an ordered Dictionary as input_parameters (each member having a
// param_name and a param_value), return an ASCII string suitable for
// use in a HTTP field value.
//
// 1.  Let output be an empty string.
//
// 2.  For each param_name with a value of param_value in
//     input_parameters:
//
//     1.  Append ";" to output.
//
//     2.  Append the result of running Serializing a Key
//         (Section 4.1.1.3) with param_name to output.
//
//     3.  If param_value is not Boolean true:
//
//         1.  Append "=" to output.
//
//         2.  Append the result of running Serializing a bare Item
//             (Section 4.1.3.1) with param_value to output.
//
// 3.  Return output.
function serializeParams(params) {
  if (params == null) {
    return '';
  }
  return Object.entries(params).map(_ref => {
    let [key, value] = _ref;
    if (value === true) {
      return `;${(0,_serializeKey_js__WEBPACK_IMPORTED_MODULE_1__.serializeKey)(key)}`; // omit true
    }
    return `;${(0,_serializeKey_js__WEBPACK_IMPORTED_MODULE_1__.serializeKey)(key)}=${(0,_serializeBareItem_js__WEBPACK_IMPORTED_MODULE_0__.serializeBareItem)(value)}`;
  }).join('');
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeString.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeString.js ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeString: function() { return /* binding */ serializeString; }
/* harmony export */ });
/* harmony import */ var _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/STRING.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js");
/* harmony import */ var _utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/STRING_REGEX.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");



// 4.1.6.  Serializing a String
//
// Given a String as input_string, return an ASCII string suitable for
// use in a HTTP field value.
//
// 1.  Convert input_string into a sequence of ASCII characters; if
//     conversion fails, fail serialization.
//
// 2.  If input_string contains characters in the range %x00-1f or %x7f
//     (i.e., not in VCHAR or SP), fail serialization.
//
// 3.  Let output be the string DQUOTE.
//
// 4.  For each character char in input_string:
//
//     1.  If char is "\" or DQUOTE:
//
//         1.  Append "\" to output.
//
//     2.  Append char to output.
//
// 5.  Append DQUOTE to output.
//
// 6.  Return output.
function serializeString(value) {
  if (_utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_1__.STRING_REGEX.test(value)) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(value, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_0__.STRING);
  }
  return `"${value.replace(/\\/g, `\\\\`).replace(/"/g, `\\"`)}"`;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeToken.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeToken.js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeToken: function() { return /* binding */ serializeToken; }
/* harmony export */ });
/* harmony import */ var _cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../cta/utils/symbolToStr.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js");
/* harmony import */ var _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/TOKEN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");



function serializeToken(token) {
  const value = (0,_cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_0__.symbolToStr)(token);
  if (/^([a-zA-Z*])([!#$%&'*+\-.^_`|~\w:/]*)$/.test(value) === false) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(value, _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_1__.TOKEN);
  }
  return value;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BARE_ITEM: function() { return /* binding */ BARE_ITEM; }
/* harmony export */ });
const BARE_ITEM = 'Bare Item';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BOOLEAN: function() { return /* binding */ BOOLEAN; }
/* harmony export */ });
const BOOLEAN = 'Boolean';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BYTES: function() { return /* binding */ BYTES; }
/* harmony export */ });
const BYTES = 'Byte Sequence';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DATE.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/DATE.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATE: function() { return /* binding */ DATE; }
/* harmony export */ });
const DATE = 'Date';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DECIMAL: function() { return /* binding */ DECIMAL; }
/* harmony export */ });
const DECIMAL = 'Decimal';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DICT: function() { return /* binding */ DICT; }
/* harmony export */ });
const DICT = 'Dict';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INNER.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/INNER.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INNER: function() { return /* binding */ INNER; }
/* harmony export */ });
const INNER = 'Inner List';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INTEGER: function() { return /* binding */ INTEGER; }
/* harmony export */ });
const INTEGER = 'Integer';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER_DECIMAL.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER_DECIMAL.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INTEGER_DECIMAL: function() { return /* binding */ INTEGER_DECIMAL; }
/* harmony export */ });
/* harmony import */ var _DECIMAL_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DECIMAL.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js");
/* harmony import */ var _INTEGER_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./INTEGER.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js");


const INTEGER_DECIMAL = `${_INTEGER_js__WEBPACK_IMPORTED_MODULE_1__.INTEGER} or ${_DECIMAL_js__WEBPACK_IMPORTED_MODULE_0__.DECIMAL}`;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KEY: function() { return /* binding */ KEY; }
/* harmony export */ });
const KEY = 'Key';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LIST: function() { return /* binding */ LIST; }
/* harmony export */ });
const LIST = 'List';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRING: function() { return /* binding */ STRING; }
/* harmony export */ });
const STRING = 'String';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRING_REGEX: function() { return /* binding */ STRING_REGEX; }
/* harmony export */ });
const STRING_REGEX = /[\x00-\x1f\x7f]+/;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TOKEN: function() { return /* binding */ TOKEN; }
/* harmony export */ });
const TOKEN = 'Token';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isInvalidInt: function() { return /* binding */ isInvalidInt; }
/* harmony export */ });
function isInvalidInt(value) {
  return value < -999999999999999 || 999999999999999 < value;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   throwError: function() { return /* binding */ throwError; }
/* harmony export */ });
function format(value) {
  if (Array.isArray(value)) {
    return JSON.stringify(value);
  }
  if (value instanceof Map) {
    return 'Map{}';
  }
  if (value instanceof Set) {
    return 'Set{}';
  }
  if (typeof value === 'object') {
    return JSON.stringify(value);
  }
  return String(value);
}
function throwError(action, src, type, cause) {
  return new Error(`failed to ${action} "${format(src)}" as ${type}`, {
    cause
  });
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/base64decode.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/base64decode.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   base64decode: function() { return /* binding */ base64decode; }
/* harmony export */ });
/**
 * Decodes a base64 encoded string into binary data
 *
 * @param str - The base64 encoded string to decode
 * @returns The decoded binary data
 *
 * @group Utils
 *
 * @beta
 */
function base64decode(str) {
  return new Uint8Array([...atob(str)].map(a => a.charCodeAt(0)));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/base64encode.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/base64encode.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   base64encode: function() { return /* binding */ base64encode; }
/* harmony export */ });
/**
 * Encodes binary data to base64
 *
 * @param binary - The binary data to encode
 * @returns The base64 encoded string
 *
 * @group Utils
 *
 * @beta
 */
function base64encode(binary) {
  return btoa(String.fromCharCode(...binary));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/roundToEven.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/roundToEven.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   roundToEven: function() { return /* binding */ roundToEven; }
/* harmony export */ });
/**
 * This implements the rounding procedure described in step 2 of the "Serializing a Decimal" specification.
 * This rounding style is known as "even rounding", "banker's rounding", or "commercial rounding".
 *
 * @param value - The value to round
 * @param precision - The number of decimal places to round to
 * @returns The rounded value
 *
 * @group Utils
 *
 * @beta
 */
function roundToEven(value, precision) {
  if (value < 0) {
    return -roundToEven(-value, precision);
  }
  const decimalShift = Math.pow(10, precision);
  const isEquidistant = Math.abs(value * decimalShift % 1 - 0.5) < Number.EPSILON;
  if (isEquidistant) {
    // If the tail of the decimal place is 'equidistant' we round to the nearest even value
    const flooredValue = Math.floor(value * decimalShift);
    return (flooredValue % 2 === 0 ? flooredValue : flooredValue + 1) / decimalShift;
  } else {
    // Otherwise, proceed as normal
    return Math.round(value * decimalShift) / decimalShift;
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/urlToRelativePath.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/urlToRelativePath.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   urlToRelativePath: function() { return /* binding */ urlToRelativePath; }
/* harmony export */ });
/**
 * Constructs a relative path from a URL.
 *
 * @param url - The destination URL
 * @param base - The base URL
 * @returns The relative path
 *
 * @group Utils
 *
 * @beta
 */
function urlToRelativePath(url, base) {
  const to = new URL(url);
  const from = new URL(base);
  if (to.origin !== from.origin) {
    return url;
  }
  const toPath = to.pathname.split('/').slice(1);
  const fromPath = from.pathname.split('/').slice(1, -1);
  // remove common parents
  while (toPath[0] === fromPath[0]) {
    toPath.shift();
    fromPath.shift();
  }
  // add back paths
  while (fromPath.length) {
    fromPath.shift();
    toPath.unshift('..');
  }
  return toPath.join('/');
}

/***/ }),

/***/ "./node_modules/fast-deep-equal/index.js":
/*!***********************************************!*\
  !*** ./node_modules/fast-deep-equal/index.js ***!
  \***********************************************/
/***/ (function(module) {

"use strict";


// do not edit .js files directly - edit src/index.jst
module.exports = function equal(a, b) {
  if (a === b) return true;
  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;
    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;) if (!equal(a[i], b[i])) return false;
      return true;
    }
    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;
    for (i = length; i-- !== 0;) if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
    for (i = length; i-- !== 0;) {
      var key = keys[i];
      if (!equal(a[key], b[key])) return false;
    }
    return true;
  }

  // true if both NaN, false otherwise
  return a !== a && b !== b;
};

/***/ }),

/***/ "./node_modules/html-entities/lib/index.js":
/*!*************************************************!*\
  !*** ./node_modules/html-entities/lib/index.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


var __assign = this && this.__assign || function () {
  __assign = Object.assign || function (t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
      s = arguments[i];
      for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
    }
    return t;
  };
  return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", ({
  value: true
}));
var named_references_1 = __webpack_require__(/*! ./named-references */ "./node_modules/html-entities/lib/named-references.js");
var numeric_unicode_map_1 = __webpack_require__(/*! ./numeric-unicode-map */ "./node_modules/html-entities/lib/numeric-unicode-map.js");
var surrogate_pairs_1 = __webpack_require__(/*! ./surrogate-pairs */ "./node_modules/html-entities/lib/surrogate-pairs.js");
var allNamedReferences = __assign(__assign({}, named_references_1.namedReferences), {
  all: named_references_1.namedReferences.html5
});
function replaceUsingRegExp(macroText, macroRegExp, macroReplacer) {
  macroRegExp.lastIndex = 0;
  var replaceMatch = macroRegExp.exec(macroText);
  var replaceResult;
  if (replaceMatch) {
    replaceResult = "";
    var replaceLastIndex = 0;
    do {
      if (replaceLastIndex !== replaceMatch.index) {
        replaceResult += macroText.substring(replaceLastIndex, replaceMatch.index);
      }
      var replaceInput = replaceMatch[0];
      replaceResult += macroReplacer(replaceInput);
      replaceLastIndex = replaceMatch.index + replaceInput.length;
    } while (replaceMatch = macroRegExp.exec(macroText));
    if (replaceLastIndex !== macroText.length) {
      replaceResult += macroText.substring(replaceLastIndex);
    }
  } else {
    replaceResult = macroText;
  }
  return replaceResult;
}
var encodeRegExps = {
  specialChars: /[<>'"&]/g,
  nonAscii: /[<>'"&\u0080-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/g,
  nonAsciiPrintable: /[<>'"&\x01-\x08\x11-\x15\x17-\x1F\x7f-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/g,
  nonAsciiPrintableOnly: /[\x01-\x08\x11-\x15\x17-\x1F\x7f-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/g,
  extensive: /[\x01-\x0c\x0e-\x1f\x21-\x2c\x2e-\x2f\x3a-\x40\x5b-\x60\x7b-\x7d\x7f-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/g
};
var defaultEncodeOptions = {
  mode: "specialChars",
  level: "all",
  numeric: "decimal"
};
function encode(text, _a) {
  var _b = _a === void 0 ? defaultEncodeOptions : _a,
    _c = _b.mode,
    mode = _c === void 0 ? "specialChars" : _c,
    _d = _b.numeric,
    numeric = _d === void 0 ? "decimal" : _d,
    _e = _b.level,
    level = _e === void 0 ? "all" : _e;
  if (!text) {
    return "";
  }
  var encodeRegExp = encodeRegExps[mode];
  var references = allNamedReferences[level].characters;
  var isHex = numeric === "hexadecimal";
  return replaceUsingRegExp(text, encodeRegExp, function (input) {
    var result = references[input];
    if (!result) {
      var code = input.length > 1 ? surrogate_pairs_1.getCodePoint(input, 0) : input.charCodeAt(0);
      result = (isHex ? "&#x" + code.toString(16) : "&#" + code) + ";";
    }
    return result;
  });
}
exports.encode = encode;
var defaultDecodeOptions = {
  scope: "body",
  level: "all"
};
var strict = /&(?:#\d+|#[xX][\da-fA-F]+|[0-9a-zA-Z]+);/g;
var attribute = /&(?:#\d+|#[xX][\da-fA-F]+|[0-9a-zA-Z]+)[;=]?/g;
var baseDecodeRegExps = {
  xml: {
    strict: strict,
    attribute: attribute,
    body: named_references_1.bodyRegExps.xml
  },
  html4: {
    strict: strict,
    attribute: attribute,
    body: named_references_1.bodyRegExps.html4
  },
  html5: {
    strict: strict,
    attribute: attribute,
    body: named_references_1.bodyRegExps.html5
  }
};
var decodeRegExps = __assign(__assign({}, baseDecodeRegExps), {
  all: baseDecodeRegExps.html5
});
var fromCharCode = String.fromCharCode;
var outOfBoundsChar = fromCharCode(65533);
var defaultDecodeEntityOptions = {
  level: "all"
};
function getDecodedEntity(entity, references, isAttribute, isStrict) {
  var decodeResult = entity;
  var decodeEntityLastChar = entity[entity.length - 1];
  if (isAttribute && decodeEntityLastChar === "=") {
    decodeResult = entity;
  } else if (isStrict && decodeEntityLastChar !== ";") {
    decodeResult = entity;
  } else {
    var decodeResultByReference = references[entity];
    if (decodeResultByReference) {
      decodeResult = decodeResultByReference;
    } else if (entity[0] === "&" && entity[1] === "#") {
      var decodeSecondChar = entity[2];
      var decodeCode = decodeSecondChar == "x" || decodeSecondChar == "X" ? parseInt(entity.substr(3), 16) : parseInt(entity.substr(2));
      decodeResult = decodeCode >= 1114111 ? outOfBoundsChar : decodeCode > 65535 ? surrogate_pairs_1.fromCodePoint(decodeCode) : fromCharCode(numeric_unicode_map_1.numericUnicodeMap[decodeCode] || decodeCode);
    }
  }
  return decodeResult;
}
function decodeEntity(entity, _a) {
  var _b = (_a === void 0 ? defaultDecodeEntityOptions : _a).level,
    level = _b === void 0 ? "all" : _b;
  if (!entity) {
    return "";
  }
  return getDecodedEntity(entity, allNamedReferences[level].entities, false, false);
}
exports.decodeEntity = decodeEntity;
function decode(text, _a) {
  var _b = _a === void 0 ? defaultDecodeOptions : _a,
    _c = _b.level,
    level = _c === void 0 ? "all" : _c,
    _d = _b.scope,
    scope = _d === void 0 ? level === "xml" ? "strict" : "body" : _d;
  if (!text) {
    return "";
  }
  var decodeRegExp = decodeRegExps[level][scope];
  var references = allNamedReferences[level].entities;
  var isAttribute = scope === "attribute";
  var isStrict = scope === "strict";
  return replaceUsingRegExp(text, decodeRegExp, function (entity) {
    return getDecodedEntity(entity, references, isAttribute, isStrict);
  });
}
exports.decode = decode;

/***/ }),

/***/ "./node_modules/html-entities/lib/named-references.js":
/*!************************************************************!*\
  !*** ./node_modules/html-entities/lib/named-references.js ***!
  \************************************************************/
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.bodyRegExps = {
  xml: /&(?:#\d+|#[xX][\da-fA-F]+|[0-9a-zA-Z]+);?/g,
  html4: /&notin;|&(?:nbsp|iexcl|cent|pound|curren|yen|brvbar|sect|uml|copy|ordf|laquo|not|shy|reg|macr|deg|plusmn|sup2|sup3|acute|micro|para|middot|cedil|sup1|ordm|raquo|frac14|frac12|frac34|iquest|Agrave|Aacute|Acirc|Atilde|Auml|Aring|AElig|Ccedil|Egrave|Eacute|Ecirc|Euml|Igrave|Iacute|Icirc|Iuml|ETH|Ntilde|Ograve|Oacute|Ocirc|Otilde|Ouml|times|Oslash|Ugrave|Uacute|Ucirc|Uuml|Yacute|THORN|szlig|agrave|aacute|acirc|atilde|auml|aring|aelig|ccedil|egrave|eacute|ecirc|euml|igrave|iacute|icirc|iuml|eth|ntilde|ograve|oacute|ocirc|otilde|ouml|divide|oslash|ugrave|uacute|ucirc|uuml|yacute|thorn|yuml|quot|amp|lt|gt|#\d+|#[xX][\da-fA-F]+|[0-9a-zA-Z]+);?/g,
  html5: /&centerdot;|&copysr;|&divideontimes;|&gtcc;|&gtcir;|&gtdot;|&gtlPar;|&gtquest;|&gtrapprox;|&gtrarr;|&gtrdot;|&gtreqless;|&gtreqqless;|&gtrless;|&gtrsim;|&ltcc;|&ltcir;|&ltdot;|&lthree;|&ltimes;|&ltlarr;|&ltquest;|&ltrPar;|&ltri;|&ltrie;|&ltrif;|&notin;|&notinE;|&notindot;|&notinva;|&notinvb;|&notinvc;|&notni;|&notniva;|&notnivb;|&notnivc;|&parallel;|&timesb;|&timesbar;|&timesd;|&(?:AElig|AMP|Aacute|Acirc|Agrave|Aring|Atilde|Auml|COPY|Ccedil|ETH|Eacute|Ecirc|Egrave|Euml|GT|Iacute|Icirc|Igrave|Iuml|LT|Ntilde|Oacute|Ocirc|Ograve|Oslash|Otilde|Ouml|QUOT|REG|THORN|Uacute|Ucirc|Ugrave|Uuml|Yacute|aacute|acirc|acute|aelig|agrave|amp|aring|atilde|auml|brvbar|ccedil|cedil|cent|copy|curren|deg|divide|eacute|ecirc|egrave|eth|euml|frac12|frac14|frac34|gt|iacute|icirc|iexcl|igrave|iquest|iuml|laquo|lt|macr|micro|middot|nbsp|not|ntilde|oacute|ocirc|ograve|ordf|ordm|oslash|otilde|ouml|para|plusmn|pound|quot|raquo|reg|sect|shy|sup1|sup2|sup3|szlig|thorn|times|uacute|ucirc|ugrave|uml|uuml|yacute|yen|yuml|#\d+|#[xX][\da-fA-F]+|[0-9a-zA-Z]+);?/g
};
exports.namedReferences = {
  xml: {
    entities: {
      "&lt;": "<",
      "&gt;": ">",
      "&quot;": '"',
      "&apos;": "'",
      "&amp;": "&"
    },
    characters: {
      "<": "&lt;",
      ">": "&gt;",
      '"': "&quot;",
      "'": "&apos;",
      "&": "&amp;"
    }
  },
  html4: {
    entities: {
      "&apos;": "'",
      "&nbsp": " ",
      "&nbsp;": " ",
      "&iexcl": "¡",
      "&iexcl;": "¡",
      "&cent": "¢",
      "&cent;": "¢",
      "&pound": "£",
      "&pound;": "£",
      "&curren": "¤",
      "&curren;": "¤",
      "&yen": "¥",
      "&yen;": "¥",
      "&brvbar": "¦",
      "&brvbar;": "¦",
      "&sect": "§",
      "&sect;": "§",
      "&uml": "¨",
      "&uml;": "¨",
      "&copy": "©",
      "&copy;": "©",
      "&ordf": "ª",
      "&ordf;": "ª",
      "&laquo": "«",
      "&laquo;": "«",
      "&not": "¬",
      "&not;": "¬",
      "&shy": "­",
      "&shy;": "­",
      "&reg": "®",
      "&reg;": "®",
      "&macr": "¯",
      "&macr;": "¯",
      "&deg": "°",
      "&deg;": "°",
      "&plusmn": "±",
      "&plusmn;": "±",
      "&sup2": "²",
      "&sup2;": "²",
      "&sup3": "³",
      "&sup3;": "³",
      "&acute": "´",
      "&acute;": "´",
      "&micro": "µ",
      "&micro;": "µ",
      "&para": "¶",
      "&para;": "¶",
      "&middot": "·",
      "&middot;": "·",
      "&cedil": "¸",
      "&cedil;": "¸",
      "&sup1": "¹",
      "&sup1;": "¹",
      "&ordm": "º",
      "&ordm;": "º",
      "&raquo": "»",
      "&raquo;": "»",
      "&frac14": "¼",
      "&frac14;": "¼",
      "&frac12": "½",
      "&frac12;": "½",
      "&frac34": "¾",
      "&frac34;": "¾",
      "&iquest": "¿",
      "&iquest;": "¿",
      "&Agrave": "À",
      "&Agrave;": "À",
      "&Aacute": "Á",
      "&Aacute;": "Á",
      "&Acirc": "Â",
      "&Acirc;": "Â",
      "&Atilde": "Ã",
      "&Atilde;": "Ã",
      "&Auml": "Ä",
      "&Auml;": "Ä",
      "&Aring": "Å",
      "&Aring;": "Å",
      "&AElig": "Æ",
      "&AElig;": "Æ",
      "&Ccedil": "Ç",
      "&Ccedil;": "Ç",
      "&Egrave": "È",
      "&Egrave;": "È",
      "&Eacute": "É",
      "&Eacute;": "É",
      "&Ecirc": "Ê",
      "&Ecirc;": "Ê",
      "&Euml": "Ë",
      "&Euml;": "Ë",
      "&Igrave": "Ì",
      "&Igrave;": "Ì",
      "&Iacute": "Í",
      "&Iacute;": "Í",
      "&Icirc": "Î",
      "&Icirc;": "Î",
      "&Iuml": "Ï",
      "&Iuml;": "Ï",
      "&ETH": "Ð",
      "&ETH;": "Ð",
      "&Ntilde": "Ñ",
      "&Ntilde;": "Ñ",
      "&Ograve": "Ò",
      "&Ograve;": "Ò",
      "&Oacute": "Ó",
      "&Oacute;": "Ó",
      "&Ocirc": "Ô",
      "&Ocirc;": "Ô",
      "&Otilde": "Õ",
      "&Otilde;": "Õ",
      "&Ouml": "Ö",
      "&Ouml;": "Ö",
      "&times": "×",
      "&times;": "×",
      "&Oslash": "Ø",
      "&Oslash;": "Ø",
      "&Ugrave": "Ù",
      "&Ugrave;": "Ù",
      "&Uacute": "Ú",
      "&Uacute;": "Ú",
      "&Ucirc": "Û",
      "&Ucirc;": "Û",
      "&Uuml": "Ü",
      "&Uuml;": "Ü",
      "&Yacute": "Ý",
      "&Yacute;": "Ý",
      "&THORN": "Þ",
      "&THORN;": "Þ",
      "&szlig": "ß",
      "&szlig;": "ß",
      "&agrave": "à",
      "&agrave;": "à",
      "&aacute": "á",
      "&aacute;": "á",
      "&acirc": "â",
      "&acirc;": "â",
      "&atilde": "ã",
      "&atilde;": "ã",
      "&auml": "ä",
      "&auml;": "ä",
      "&aring": "å",
      "&aring;": "å",
      "&aelig": "æ",
      "&aelig;": "æ",
      "&ccedil": "ç",
      "&ccedil;": "ç",
      "&egrave": "è",
      "&egrave;": "è",
      "&eacute": "é",
      "&eacute;": "é",
      "&ecirc": "ê",
      "&ecirc;": "ê",
      "&euml": "ë",
      "&euml;": "ë",
      "&igrave": "ì",
      "&igrave;": "ì",
      "&iacute": "í",
      "&iacute;": "í",
      "&icirc": "î",
      "&icirc;": "î",
      "&iuml": "ï",
      "&iuml;": "ï",
      "&eth": "ð",
      "&eth;": "ð",
      "&ntilde": "ñ",
      "&ntilde;": "ñ",
      "&ograve": "ò",
      "&ograve;": "ò",
      "&oacute": "ó",
      "&oacute;": "ó",
      "&ocirc": "ô",
      "&ocirc;": "ô",
      "&otilde": "õ",
      "&otilde;": "õ",
      "&ouml": "ö",
      "&ouml;": "ö",
      "&divide": "÷",
      "&divide;": "÷",
      "&oslash": "ø",
      "&oslash;": "ø",
      "&ugrave": "ù",
      "&ugrave;": "ù",
      "&uacute": "ú",
      "&uacute;": "ú",
      "&ucirc": "û",
      "&ucirc;": "û",
      "&uuml": "ü",
      "&uuml;": "ü",
      "&yacute": "ý",
      "&yacute;": "ý",
      "&thorn": "þ",
      "&thorn;": "þ",
      "&yuml": "ÿ",
      "&yuml;": "ÿ",
      "&quot": '"',
      "&quot;": '"',
      "&amp": "&",
      "&amp;": "&",
      "&lt": "<",
      "&lt;": "<",
      "&gt": ">",
      "&gt;": ">",
      "&OElig;": "Œ",
      "&oelig;": "œ",
      "&Scaron;": "Š",
      "&scaron;": "š",
      "&Yuml;": "Ÿ",
      "&circ;": "ˆ",
      "&tilde;": "˜",
      "&ensp;": " ",
      "&emsp;": " ",
      "&thinsp;": " ",
      "&zwnj;": "‌",
      "&zwj;": "‍",
      "&lrm;": "‎",
      "&rlm;": "‏",
      "&ndash;": "–",
      "&mdash;": "—",
      "&lsquo;": "‘",
      "&rsquo;": "’",
      "&sbquo;": "‚",
      "&ldquo;": "“",
      "&rdquo;": "”",
      "&bdquo;": "„",
      "&dagger;": "†",
      "&Dagger;": "‡",
      "&permil;": "‰",
      "&lsaquo;": "‹",
      "&rsaquo;": "›",
      "&euro;": "€",
      "&fnof;": "ƒ",
      "&Alpha;": "Α",
      "&Beta;": "Β",
      "&Gamma;": "Γ",
      "&Delta;": "Δ",
      "&Epsilon;": "Ε",
      "&Zeta;": "Ζ",
      "&Eta;": "Η",
      "&Theta;": "Θ",
      "&Iota;": "Ι",
      "&Kappa;": "Κ",
      "&Lambda;": "Λ",
      "&Mu;": "Μ",
      "&Nu;": "Ν",
      "&Xi;": "Ξ",
      "&Omicron;": "Ο",
      "&Pi;": "Π",
      "&Rho;": "Ρ",
      "&Sigma;": "Σ",
      "&Tau;": "Τ",
      "&Upsilon;": "Υ",
      "&Phi;": "Φ",
      "&Chi;": "Χ",
      "&Psi;": "Ψ",
      "&Omega;": "Ω",
      "&alpha;": "α",
      "&beta;": "β",
      "&gamma;": "γ",
      "&delta;": "δ",
      "&epsilon;": "ε",
      "&zeta;": "ζ",
      "&eta;": "η",
      "&theta;": "θ",
      "&iota;": "ι",
      "&kappa;": "κ",
      "&lambda;": "λ",
      "&mu;": "μ",
      "&nu;": "ν",
      "&xi;": "ξ",
      "&omicron;": "ο",
      "&pi;": "π",
      "&rho;": "ρ",
      "&sigmaf;": "ς",
      "&sigma;": "σ",
      "&tau;": "τ",
      "&upsilon;": "υ",
      "&phi;": "φ",
      "&chi;": "χ",
      "&psi;": "ψ",
      "&omega;": "ω",
      "&thetasym;": "ϑ",
      "&upsih;": "ϒ",
      "&piv;": "ϖ",
      "&bull;": "•",
      "&hellip;": "…",
      "&prime;": "′",
      "&Prime;": "″",
      "&oline;": "‾",
      "&frasl;": "⁄",
      "&weierp;": "℘",
      "&image;": "ℑ",
      "&real;": "ℜ",
      "&trade;": "™",
      "&alefsym;": "ℵ",
      "&larr;": "←",
      "&uarr;": "↑",
      "&rarr;": "→",
      "&darr;": "↓",
      "&harr;": "↔",
      "&crarr;": "↵",
      "&lArr;": "⇐",
      "&uArr;": "⇑",
      "&rArr;": "⇒",
      "&dArr;": "⇓",
      "&hArr;": "⇔",
      "&forall;": "∀",
      "&part;": "∂",
      "&exist;": "∃",
      "&empty;": "∅",
      "&nabla;": "∇",
      "&isin;": "∈",
      "&notin;": "∉",
      "&ni;": "∋",
      "&prod;": "∏",
      "&sum;": "∑",
      "&minus;": "−",
      "&lowast;": "∗",
      "&radic;": "√",
      "&prop;": "∝",
      "&infin;": "∞",
      "&ang;": "∠",
      "&and;": "∧",
      "&or;": "∨",
      "&cap;": "∩",
      "&cup;": "∪",
      "&int;": "∫",
      "&there4;": "∴",
      "&sim;": "∼",
      "&cong;": "≅",
      "&asymp;": "≈",
      "&ne;": "≠",
      "&equiv;": "≡",
      "&le;": "≤",
      "&ge;": "≥",
      "&sub;": "⊂",
      "&sup;": "⊃",
      "&nsub;": "⊄",
      "&sube;": "⊆",
      "&supe;": "⊇",
      "&oplus;": "⊕",
      "&otimes;": "⊗",
      "&perp;": "⊥",
      "&sdot;": "⋅",
      "&lceil;": "⌈",
      "&rceil;": "⌉",
      "&lfloor;": "⌊",
      "&rfloor;": "⌋",
      "&lang;": "〈",
      "&rang;": "〉",
      "&loz;": "◊",
      "&spades;": "♠",
      "&clubs;": "♣",
      "&hearts;": "♥",
      "&diams;": "♦"
    },
    characters: {
      "'": "&apos;",
      " ": "&nbsp;",
      "¡": "&iexcl;",
      "¢": "&cent;",
      "£": "&pound;",
      "¤": "&curren;",
      "¥": "&yen;",
      "¦": "&brvbar;",
      "§": "&sect;",
      "¨": "&uml;",
      "©": "&copy;",
      "ª": "&ordf;",
      "«": "&laquo;",
      "¬": "&not;",
      "­": "&shy;",
      "®": "&reg;",
      "¯": "&macr;",
      "°": "&deg;",
      "±": "&plusmn;",
      "²": "&sup2;",
      "³": "&sup3;",
      "´": "&acute;",
      "µ": "&micro;",
      "¶": "&para;",
      "·": "&middot;",
      "¸": "&cedil;",
      "¹": "&sup1;",
      "º": "&ordm;",
      "»": "&raquo;",
      "¼": "&frac14;",
      "½": "&frac12;",
      "¾": "&frac34;",
      "¿": "&iquest;",
      "À": "&Agrave;",
      "Á": "&Aacute;",
      "Â": "&Acirc;",
      "Ã": "&Atilde;",
      "Ä": "&Auml;",
      "Å": "&Aring;",
      "Æ": "&AElig;",
      "Ç": "&Ccedil;",
      "È": "&Egrave;",
      "É": "&Eacute;",
      "Ê": "&Ecirc;",
      "Ë": "&Euml;",
      "Ì": "&Igrave;",
      "Í": "&Iacute;",
      "Î": "&Icirc;",
      "Ï": "&Iuml;",
      "Ð": "&ETH;",
      "Ñ": "&Ntilde;",
      "Ò": "&Ograve;",
      "Ó": "&Oacute;",
      "Ô": "&Ocirc;",
      "Õ": "&Otilde;",
      "Ö": "&Ouml;",
      "×": "&times;",
      "Ø": "&Oslash;",
      "Ù": "&Ugrave;",
      "Ú": "&Uacute;",
      "Û": "&Ucirc;",
      "Ü": "&Uuml;",
      "Ý": "&Yacute;",
      "Þ": "&THORN;",
      "ß": "&szlig;",
      "à": "&agrave;",
      "á": "&aacute;",
      "â": "&acirc;",
      "ã": "&atilde;",
      "ä": "&auml;",
      "å": "&aring;",
      "æ": "&aelig;",
      "ç": "&ccedil;",
      "è": "&egrave;",
      "é": "&eacute;",
      "ê": "&ecirc;",
      "ë": "&euml;",
      "ì": "&igrave;",
      "í": "&iacute;",
      "î": "&icirc;",
      "ï": "&iuml;",
      "ð": "&eth;",
      "ñ": "&ntilde;",
      "ò": "&ograve;",
      "ó": "&oacute;",
      "ô": "&ocirc;",
      "õ": "&otilde;",
      "ö": "&ouml;",
      "÷": "&divide;",
      "ø": "&oslash;",
      "ù": "&ugrave;",
      "ú": "&uacute;",
      "û": "&ucirc;",
      "ü": "&uuml;",
      "ý": "&yacute;",
      "þ": "&thorn;",
      "ÿ": "&yuml;",
      '"': "&quot;",
      "&": "&amp;",
      "<": "&lt;",
      ">": "&gt;",
      "Œ": "&OElig;",
      "œ": "&oelig;",
      "Š": "&Scaron;",
      "š": "&scaron;",
      "Ÿ": "&Yuml;",
      "ˆ": "&circ;",
      "˜": "&tilde;",
      " ": "&ensp;",
      " ": "&emsp;",
      " ": "&thinsp;",
      "‌": "&zwnj;",
      "‍": "&zwj;",
      "‎": "&lrm;",
      "‏": "&rlm;",
      "–": "&ndash;",
      "—": "&mdash;",
      "‘": "&lsquo;",
      "’": "&rsquo;",
      "‚": "&sbquo;",
      "“": "&ldquo;",
      "”": "&rdquo;",
      "„": "&bdquo;",
      "†": "&dagger;",
      "‡": "&Dagger;",
      "‰": "&permil;",
      "‹": "&lsaquo;",
      "›": "&rsaquo;",
      "€": "&euro;",
      "ƒ": "&fnof;",
      "Α": "&Alpha;",
      "Β": "&Beta;",
      "Γ": "&Gamma;",
      "Δ": "&Delta;",
      "Ε": "&Epsilon;",
      "Ζ": "&Zeta;",
      "Η": "&Eta;",
      "Θ": "&Theta;",
      "Ι": "&Iota;",
      "Κ": "&Kappa;",
      "Λ": "&Lambda;",
      "Μ": "&Mu;",
      "Ν": "&Nu;",
      "Ξ": "&Xi;",
      "Ο": "&Omicron;",
      "Π": "&Pi;",
      "Ρ": "&Rho;",
      "Σ": "&Sigma;",
      "Τ": "&Tau;",
      "Υ": "&Upsilon;",
      "Φ": "&Phi;",
      "Χ": "&Chi;",
      "Ψ": "&Psi;",
      "Ω": "&Omega;",
      "α": "&alpha;",
      "β": "&beta;",
      "γ": "&gamma;",
      "δ": "&delta;",
      "ε": "&epsilon;",
      "ζ": "&zeta;",
      "η": "&eta;",
      "θ": "&theta;",
      "ι": "&iota;",
      "κ": "&kappa;",
      "λ": "&lambda;",
      "μ": "&mu;",
      "ν": "&nu;",
      "ξ": "&xi;",
      "ο": "&omicron;",
      "π": "&pi;",
      "ρ": "&rho;",
      "ς": "&sigmaf;",
      "σ": "&sigma;",
      "τ": "&tau;",
      "υ": "&upsilon;",
      "φ": "&phi;",
      "χ": "&chi;",
      "ψ": "&psi;",
      "ω": "&omega;",
      "ϑ": "&thetasym;",
      "ϒ": "&upsih;",
      "ϖ": "&piv;",
      "•": "&bull;",
      "…": "&hellip;",
      "′": "&prime;",
      "″": "&Prime;",
      "‾": "&oline;",
      "⁄": "&frasl;",
      "℘": "&weierp;",
      "ℑ": "&image;",
      "ℜ": "&real;",
      "™": "&trade;",
      "ℵ": "&alefsym;",
      "←": "&larr;",
      "↑": "&uarr;",
      "→": "&rarr;",
      "↓": "&darr;",
      "↔": "&harr;",
      "↵": "&crarr;",
      "⇐": "&lArr;",
      "⇑": "&uArr;",
      "⇒": "&rArr;",
      "⇓": "&dArr;",
      "⇔": "&hArr;",
      "∀": "&forall;",
      "∂": "&part;",
      "∃": "&exist;",
      "∅": "&empty;",
      "∇": "&nabla;",
      "∈": "&isin;",
      "∉": "&notin;",
      "∋": "&ni;",
      "∏": "&prod;",
      "∑": "&sum;",
      "−": "&minus;",
      "∗": "&lowast;",
      "√": "&radic;",
      "∝": "&prop;",
      "∞": "&infin;",
      "∠": "&ang;",
      "∧": "&and;",
      "∨": "&or;",
      "∩": "&cap;",
      "∪": "&cup;",
      "∫": "&int;",
      "∴": "&there4;",
      "∼": "&sim;",
      "≅": "&cong;",
      "≈": "&asymp;",
      "≠": "&ne;",
      "≡": "&equiv;",
      "≤": "&le;",
      "≥": "&ge;",
      "⊂": "&sub;",
      "⊃": "&sup;",
      "⊄": "&nsub;",
      "⊆": "&sube;",
      "⊇": "&supe;",
      "⊕": "&oplus;",
      "⊗": "&otimes;",
      "⊥": "&perp;",
      "⋅": "&sdot;",
      "⌈": "&lceil;",
      "⌉": "&rceil;",
      "⌊": "&lfloor;",
      "⌋": "&rfloor;",
      "〈": "&lang;",
      "〉": "&rang;",
      "◊": "&loz;",
      "♠": "&spades;",
      "♣": "&clubs;",
      "♥": "&hearts;",
      "♦": "&diams;"
    }
  },
  html5: {
    entities: {
      "&AElig": "Æ",
      "&AElig;": "Æ",
      "&AMP": "&",
      "&AMP;": "&",
      "&Aacute": "Á",
      "&Aacute;": "Á",
      "&Abreve;": "Ă",
      "&Acirc": "Â",
      "&Acirc;": "Â",
      "&Acy;": "А",
      "&Afr;": "𝔄",
      "&Agrave": "À",
      "&Agrave;": "À",
      "&Alpha;": "Α",
      "&Amacr;": "Ā",
      "&And;": "⩓",
      "&Aogon;": "Ą",
      "&Aopf;": "𝔸",
      "&ApplyFunction;": "⁡",
      "&Aring": "Å",
      "&Aring;": "Å",
      "&Ascr;": "𝒜",
      "&Assign;": "≔",
      "&Atilde": "Ã",
      "&Atilde;": "Ã",
      "&Auml": "Ä",
      "&Auml;": "Ä",
      "&Backslash;": "∖",
      "&Barv;": "⫧",
      "&Barwed;": "⌆",
      "&Bcy;": "Б",
      "&Because;": "∵",
      "&Bernoullis;": "ℬ",
      "&Beta;": "Β",
      "&Bfr;": "𝔅",
      "&Bopf;": "𝔹",
      "&Breve;": "˘",
      "&Bscr;": "ℬ",
      "&Bumpeq;": "≎",
      "&CHcy;": "Ч",
      "&COPY": "©",
      "&COPY;": "©",
      "&Cacute;": "Ć",
      "&Cap;": "⋒",
      "&CapitalDifferentialD;": "ⅅ",
      "&Cayleys;": "ℭ",
      "&Ccaron;": "Č",
      "&Ccedil": "Ç",
      "&Ccedil;": "Ç",
      "&Ccirc;": "Ĉ",
      "&Cconint;": "∰",
      "&Cdot;": "Ċ",
      "&Cedilla;": "¸",
      "&CenterDot;": "·",
      "&Cfr;": "ℭ",
      "&Chi;": "Χ",
      "&CircleDot;": "⊙",
      "&CircleMinus;": "⊖",
      "&CirclePlus;": "⊕",
      "&CircleTimes;": "⊗",
      "&ClockwiseContourIntegral;": "∲",
      "&CloseCurlyDoubleQuote;": "”",
      "&CloseCurlyQuote;": "’",
      "&Colon;": "∷",
      "&Colone;": "⩴",
      "&Congruent;": "≡",
      "&Conint;": "∯",
      "&ContourIntegral;": "∮",
      "&Copf;": "ℂ",
      "&Coproduct;": "∐",
      "&CounterClockwiseContourIntegral;": "∳",
      "&Cross;": "⨯",
      "&Cscr;": "𝒞",
      "&Cup;": "⋓",
      "&CupCap;": "≍",
      "&DD;": "ⅅ",
      "&DDotrahd;": "⤑",
      "&DJcy;": "Ђ",
      "&DScy;": "Ѕ",
      "&DZcy;": "Џ",
      "&Dagger;": "‡",
      "&Darr;": "↡",
      "&Dashv;": "⫤",
      "&Dcaron;": "Ď",
      "&Dcy;": "Д",
      "&Del;": "∇",
      "&Delta;": "Δ",
      "&Dfr;": "𝔇",
      "&DiacriticalAcute;": "´",
      "&DiacriticalDot;": "˙",
      "&DiacriticalDoubleAcute;": "˝",
      "&DiacriticalGrave;": "`",
      "&DiacriticalTilde;": "˜",
      "&Diamond;": "⋄",
      "&DifferentialD;": "ⅆ",
      "&Dopf;": "𝔻",
      "&Dot;": "¨",
      "&DotDot;": "⃜",
      "&DotEqual;": "≐",
      "&DoubleContourIntegral;": "∯",
      "&DoubleDot;": "¨",
      "&DoubleDownArrow;": "⇓",
      "&DoubleLeftArrow;": "⇐",
      "&DoubleLeftRightArrow;": "⇔",
      "&DoubleLeftTee;": "⫤",
      "&DoubleLongLeftArrow;": "⟸",
      "&DoubleLongLeftRightArrow;": "⟺",
      "&DoubleLongRightArrow;": "⟹",
      "&DoubleRightArrow;": "⇒",
      "&DoubleRightTee;": "⊨",
      "&DoubleUpArrow;": "⇑",
      "&DoubleUpDownArrow;": "⇕",
      "&DoubleVerticalBar;": "∥",
      "&DownArrow;": "↓",
      "&DownArrowBar;": "⤓",
      "&DownArrowUpArrow;": "⇵",
      "&DownBreve;": "̑",
      "&DownLeftRightVector;": "⥐",
      "&DownLeftTeeVector;": "⥞",
      "&DownLeftVector;": "↽",
      "&DownLeftVectorBar;": "⥖",
      "&DownRightTeeVector;": "⥟",
      "&DownRightVector;": "⇁",
      "&DownRightVectorBar;": "⥗",
      "&DownTee;": "⊤",
      "&DownTeeArrow;": "↧",
      "&Downarrow;": "⇓",
      "&Dscr;": "𝒟",
      "&Dstrok;": "Đ",
      "&ENG;": "Ŋ",
      "&ETH": "Ð",
      "&ETH;": "Ð",
      "&Eacute": "É",
      "&Eacute;": "É",
      "&Ecaron;": "Ě",
      "&Ecirc": "Ê",
      "&Ecirc;": "Ê",
      "&Ecy;": "Э",
      "&Edot;": "Ė",
      "&Efr;": "𝔈",
      "&Egrave": "È",
      "&Egrave;": "È",
      "&Element;": "∈",
      "&Emacr;": "Ē",
      "&EmptySmallSquare;": "◻",
      "&EmptyVerySmallSquare;": "▫",
      "&Eogon;": "Ę",
      "&Eopf;": "𝔼",
      "&Epsilon;": "Ε",
      "&Equal;": "⩵",
      "&EqualTilde;": "≂",
      "&Equilibrium;": "⇌",
      "&Escr;": "ℰ",
      "&Esim;": "⩳",
      "&Eta;": "Η",
      "&Euml": "Ë",
      "&Euml;": "Ë",
      "&Exists;": "∃",
      "&ExponentialE;": "ⅇ",
      "&Fcy;": "Ф",
      "&Ffr;": "𝔉",
      "&FilledSmallSquare;": "◼",
      "&FilledVerySmallSquare;": "▪",
      "&Fopf;": "𝔽",
      "&ForAll;": "∀",
      "&Fouriertrf;": "ℱ",
      "&Fscr;": "ℱ",
      "&GJcy;": "Ѓ",
      "&GT": ">",
      "&GT;": ">",
      "&Gamma;": "Γ",
      "&Gammad;": "Ϝ",
      "&Gbreve;": "Ğ",
      "&Gcedil;": "Ģ",
      "&Gcirc;": "Ĝ",
      "&Gcy;": "Г",
      "&Gdot;": "Ġ",
      "&Gfr;": "𝔊",
      "&Gg;": "⋙",
      "&Gopf;": "𝔾",
      "&GreaterEqual;": "≥",
      "&GreaterEqualLess;": "⋛",
      "&GreaterFullEqual;": "≧",
      "&GreaterGreater;": "⪢",
      "&GreaterLess;": "≷",
      "&GreaterSlantEqual;": "⩾",
      "&GreaterTilde;": "≳",
      "&Gscr;": "𝒢",
      "&Gt;": "≫",
      "&HARDcy;": "Ъ",
      "&Hacek;": "ˇ",
      "&Hat;": "^",
      "&Hcirc;": "Ĥ",
      "&Hfr;": "ℌ",
      "&HilbertSpace;": "ℋ",
      "&Hopf;": "ℍ",
      "&HorizontalLine;": "─",
      "&Hscr;": "ℋ",
      "&Hstrok;": "Ħ",
      "&HumpDownHump;": "≎",
      "&HumpEqual;": "≏",
      "&IEcy;": "Е",
      "&IJlig;": "Ĳ",
      "&IOcy;": "Ё",
      "&Iacute": "Í",
      "&Iacute;": "Í",
      "&Icirc": "Î",
      "&Icirc;": "Î",
      "&Icy;": "И",
      "&Idot;": "İ",
      "&Ifr;": "ℑ",
      "&Igrave": "Ì",
      "&Igrave;": "Ì",
      "&Im;": "ℑ",
      "&Imacr;": "Ī",
      "&ImaginaryI;": "ⅈ",
      "&Implies;": "⇒",
      "&Int;": "∬",
      "&Integral;": "∫",
      "&Intersection;": "⋂",
      "&InvisibleComma;": "⁣",
      "&InvisibleTimes;": "⁢",
      "&Iogon;": "Į",
      "&Iopf;": "𝕀",
      "&Iota;": "Ι",
      "&Iscr;": "ℐ",
      "&Itilde;": "Ĩ",
      "&Iukcy;": "І",
      "&Iuml": "Ï",
      "&Iuml;": "Ï",
      "&Jcirc;": "Ĵ",
      "&Jcy;": "Й",
      "&Jfr;": "𝔍",
      "&Jopf;": "𝕁",
      "&Jscr;": "𝒥",
      "&Jsercy;": "Ј",
      "&Jukcy;": "Є",
      "&KHcy;": "Х",
      "&KJcy;": "Ќ",
      "&Kappa;": "Κ",
      "&Kcedil;": "Ķ",
      "&Kcy;": "К",
      "&Kfr;": "𝔎",
      "&Kopf;": "𝕂",
      "&Kscr;": "𝒦",
      "&LJcy;": "Љ",
      "&LT": "<",
      "&LT;": "<",
      "&Lacute;": "Ĺ",
      "&Lambda;": "Λ",
      "&Lang;": "⟪",
      "&Laplacetrf;": "ℒ",
      "&Larr;": "↞",
      "&Lcaron;": "Ľ",
      "&Lcedil;": "Ļ",
      "&Lcy;": "Л",
      "&LeftAngleBracket;": "⟨",
      "&LeftArrow;": "←",
      "&LeftArrowBar;": "⇤",
      "&LeftArrowRightArrow;": "⇆",
      "&LeftCeiling;": "⌈",
      "&LeftDoubleBracket;": "⟦",
      "&LeftDownTeeVector;": "⥡",
      "&LeftDownVector;": "⇃",
      "&LeftDownVectorBar;": "⥙",
      "&LeftFloor;": "⌊",
      "&LeftRightArrow;": "↔",
      "&LeftRightVector;": "⥎",
      "&LeftTee;": "⊣",
      "&LeftTeeArrow;": "↤",
      "&LeftTeeVector;": "⥚",
      "&LeftTriangle;": "⊲",
      "&LeftTriangleBar;": "⧏",
      "&LeftTriangleEqual;": "⊴",
      "&LeftUpDownVector;": "⥑",
      "&LeftUpTeeVector;": "⥠",
      "&LeftUpVector;": "↿",
      "&LeftUpVectorBar;": "⥘",
      "&LeftVector;": "↼",
      "&LeftVectorBar;": "⥒",
      "&Leftarrow;": "⇐",
      "&Leftrightarrow;": "⇔",
      "&LessEqualGreater;": "⋚",
      "&LessFullEqual;": "≦",
      "&LessGreater;": "≶",
      "&LessLess;": "⪡",
      "&LessSlantEqual;": "⩽",
      "&LessTilde;": "≲",
      "&Lfr;": "𝔏",
      "&Ll;": "⋘",
      "&Lleftarrow;": "⇚",
      "&Lmidot;": "Ŀ",
      "&LongLeftArrow;": "⟵",
      "&LongLeftRightArrow;": "⟷",
      "&LongRightArrow;": "⟶",
      "&Longleftarrow;": "⟸",
      "&Longleftrightarrow;": "⟺",
      "&Longrightarrow;": "⟹",
      "&Lopf;": "𝕃",
      "&LowerLeftArrow;": "↙",
      "&LowerRightArrow;": "↘",
      "&Lscr;": "ℒ",
      "&Lsh;": "↰",
      "&Lstrok;": "Ł",
      "&Lt;": "≪",
      "&Map;": "⤅",
      "&Mcy;": "М",
      "&MediumSpace;": " ",
      "&Mellintrf;": "ℳ",
      "&Mfr;": "𝔐",
      "&MinusPlus;": "∓",
      "&Mopf;": "𝕄",
      "&Mscr;": "ℳ",
      "&Mu;": "Μ",
      "&NJcy;": "Њ",
      "&Nacute;": "Ń",
      "&Ncaron;": "Ň",
      "&Ncedil;": "Ņ",
      "&Ncy;": "Н",
      "&NegativeMediumSpace;": "​",
      "&NegativeThickSpace;": "​",
      "&NegativeThinSpace;": "​",
      "&NegativeVeryThinSpace;": "​",
      "&NestedGreaterGreater;": "≫",
      "&NestedLessLess;": "≪",
      "&NewLine;": "\n",
      "&Nfr;": "𝔑",
      "&NoBreak;": "⁠",
      "&NonBreakingSpace;": " ",
      "&Nopf;": "ℕ",
      "&Not;": "⫬",
      "&NotCongruent;": "≢",
      "&NotCupCap;": "≭",
      "&NotDoubleVerticalBar;": "∦",
      "&NotElement;": "∉",
      "&NotEqual;": "≠",
      "&NotEqualTilde;": "≂̸",
      "&NotExists;": "∄",
      "&NotGreater;": "≯",
      "&NotGreaterEqual;": "≱",
      "&NotGreaterFullEqual;": "≧̸",
      "&NotGreaterGreater;": "≫̸",
      "&NotGreaterLess;": "≹",
      "&NotGreaterSlantEqual;": "⩾̸",
      "&NotGreaterTilde;": "≵",
      "&NotHumpDownHump;": "≎̸",
      "&NotHumpEqual;": "≏̸",
      "&NotLeftTriangle;": "⋪",
      "&NotLeftTriangleBar;": "⧏̸",
      "&NotLeftTriangleEqual;": "⋬",
      "&NotLess;": "≮",
      "&NotLessEqual;": "≰",
      "&NotLessGreater;": "≸",
      "&NotLessLess;": "≪̸",
      "&NotLessSlantEqual;": "⩽̸",
      "&NotLessTilde;": "≴",
      "&NotNestedGreaterGreater;": "⪢̸",
      "&NotNestedLessLess;": "⪡̸",
      "&NotPrecedes;": "⊀",
      "&NotPrecedesEqual;": "⪯̸",
      "&NotPrecedesSlantEqual;": "⋠",
      "&NotReverseElement;": "∌",
      "&NotRightTriangle;": "⋫",
      "&NotRightTriangleBar;": "⧐̸",
      "&NotRightTriangleEqual;": "⋭",
      "&NotSquareSubset;": "⊏̸",
      "&NotSquareSubsetEqual;": "⋢",
      "&NotSquareSuperset;": "⊐̸",
      "&NotSquareSupersetEqual;": "⋣",
      "&NotSubset;": "⊂⃒",
      "&NotSubsetEqual;": "⊈",
      "&NotSucceeds;": "⊁",
      "&NotSucceedsEqual;": "⪰̸",
      "&NotSucceedsSlantEqual;": "⋡",
      "&NotSucceedsTilde;": "≿̸",
      "&NotSuperset;": "⊃⃒",
      "&NotSupersetEqual;": "⊉",
      "&NotTilde;": "≁",
      "&NotTildeEqual;": "≄",
      "&NotTildeFullEqual;": "≇",
      "&NotTildeTilde;": "≉",
      "&NotVerticalBar;": "∤",
      "&Nscr;": "𝒩",
      "&Ntilde": "Ñ",
      "&Ntilde;": "Ñ",
      "&Nu;": "Ν",
      "&OElig;": "Œ",
      "&Oacute": "Ó",
      "&Oacute;": "Ó",
      "&Ocirc": "Ô",
      "&Ocirc;": "Ô",
      "&Ocy;": "О",
      "&Odblac;": "Ő",
      "&Ofr;": "𝔒",
      "&Ograve": "Ò",
      "&Ograve;": "Ò",
      "&Omacr;": "Ō",
      "&Omega;": "Ω",
      "&Omicron;": "Ο",
      "&Oopf;": "𝕆",
      "&OpenCurlyDoubleQuote;": "“",
      "&OpenCurlyQuote;": "‘",
      "&Or;": "⩔",
      "&Oscr;": "𝒪",
      "&Oslash": "Ø",
      "&Oslash;": "Ø",
      "&Otilde": "Õ",
      "&Otilde;": "Õ",
      "&Otimes;": "⨷",
      "&Ouml": "Ö",
      "&Ouml;": "Ö",
      "&OverBar;": "‾",
      "&OverBrace;": "⏞",
      "&OverBracket;": "⎴",
      "&OverParenthesis;": "⏜",
      "&PartialD;": "∂",
      "&Pcy;": "П",
      "&Pfr;": "𝔓",
      "&Phi;": "Φ",
      "&Pi;": "Π",
      "&PlusMinus;": "±",
      "&Poincareplane;": "ℌ",
      "&Popf;": "ℙ",
      "&Pr;": "⪻",
      "&Precedes;": "≺",
      "&PrecedesEqual;": "⪯",
      "&PrecedesSlantEqual;": "≼",
      "&PrecedesTilde;": "≾",
      "&Prime;": "″",
      "&Product;": "∏",
      "&Proportion;": "∷",
      "&Proportional;": "∝",
      "&Pscr;": "𝒫",
      "&Psi;": "Ψ",
      "&QUOT": '"',
      "&QUOT;": '"',
      "&Qfr;": "𝔔",
      "&Qopf;": "ℚ",
      "&Qscr;": "𝒬",
      "&RBarr;": "⤐",
      "&REG": "®",
      "&REG;": "®",
      "&Racute;": "Ŕ",
      "&Rang;": "⟫",
      "&Rarr;": "↠",
      "&Rarrtl;": "⤖",
      "&Rcaron;": "Ř",
      "&Rcedil;": "Ŗ",
      "&Rcy;": "Р",
      "&Re;": "ℜ",
      "&ReverseElement;": "∋",
      "&ReverseEquilibrium;": "⇋",
      "&ReverseUpEquilibrium;": "⥯",
      "&Rfr;": "ℜ",
      "&Rho;": "Ρ",
      "&RightAngleBracket;": "⟩",
      "&RightArrow;": "→",
      "&RightArrowBar;": "⇥",
      "&RightArrowLeftArrow;": "⇄",
      "&RightCeiling;": "⌉",
      "&RightDoubleBracket;": "⟧",
      "&RightDownTeeVector;": "⥝",
      "&RightDownVector;": "⇂",
      "&RightDownVectorBar;": "⥕",
      "&RightFloor;": "⌋",
      "&RightTee;": "⊢",
      "&RightTeeArrow;": "↦",
      "&RightTeeVector;": "⥛",
      "&RightTriangle;": "⊳",
      "&RightTriangleBar;": "⧐",
      "&RightTriangleEqual;": "⊵",
      "&RightUpDownVector;": "⥏",
      "&RightUpTeeVector;": "⥜",
      "&RightUpVector;": "↾",
      "&RightUpVectorBar;": "⥔",
      "&RightVector;": "⇀",
      "&RightVectorBar;": "⥓",
      "&Rightarrow;": "⇒",
      "&Ropf;": "ℝ",
      "&RoundImplies;": "⥰",
      "&Rrightarrow;": "⇛",
      "&Rscr;": "ℛ",
      "&Rsh;": "↱",
      "&RuleDelayed;": "⧴",
      "&SHCHcy;": "Щ",
      "&SHcy;": "Ш",
      "&SOFTcy;": "Ь",
      "&Sacute;": "Ś",
      "&Sc;": "⪼",
      "&Scaron;": "Š",
      "&Scedil;": "Ş",
      "&Scirc;": "Ŝ",
      "&Scy;": "С",
      "&Sfr;": "𝔖",
      "&ShortDownArrow;": "↓",
      "&ShortLeftArrow;": "←",
      "&ShortRightArrow;": "→",
      "&ShortUpArrow;": "↑",
      "&Sigma;": "Σ",
      "&SmallCircle;": "∘",
      "&Sopf;": "𝕊",
      "&Sqrt;": "√",
      "&Square;": "□",
      "&SquareIntersection;": "⊓",
      "&SquareSubset;": "⊏",
      "&SquareSubsetEqual;": "⊑",
      "&SquareSuperset;": "⊐",
      "&SquareSupersetEqual;": "⊒",
      "&SquareUnion;": "⊔",
      "&Sscr;": "𝒮",
      "&Star;": "⋆",
      "&Sub;": "⋐",
      "&Subset;": "⋐",
      "&SubsetEqual;": "⊆",
      "&Succeeds;": "≻",
      "&SucceedsEqual;": "⪰",
      "&SucceedsSlantEqual;": "≽",
      "&SucceedsTilde;": "≿",
      "&SuchThat;": "∋",
      "&Sum;": "∑",
      "&Sup;": "⋑",
      "&Superset;": "⊃",
      "&SupersetEqual;": "⊇",
      "&Supset;": "⋑",
      "&THORN": "Þ",
      "&THORN;": "Þ",
      "&TRADE;": "™",
      "&TSHcy;": "Ћ",
      "&TScy;": "Ц",
      "&Tab;": "\t",
      "&Tau;": "Τ",
      "&Tcaron;": "Ť",
      "&Tcedil;": "Ţ",
      "&Tcy;": "Т",
      "&Tfr;": "𝔗",
      "&Therefore;": "∴",
      "&Theta;": "Θ",
      "&ThickSpace;": "  ",
      "&ThinSpace;": " ",
      "&Tilde;": "∼",
      "&TildeEqual;": "≃",
      "&TildeFullEqual;": "≅",
      "&TildeTilde;": "≈",
      "&Topf;": "𝕋",
      "&TripleDot;": "⃛",
      "&Tscr;": "𝒯",
      "&Tstrok;": "Ŧ",
      "&Uacute": "Ú",
      "&Uacute;": "Ú",
      "&Uarr;": "↟",
      "&Uarrocir;": "⥉",
      "&Ubrcy;": "Ў",
      "&Ubreve;": "Ŭ",
      "&Ucirc": "Û",
      "&Ucirc;": "Û",
      "&Ucy;": "У",
      "&Udblac;": "Ű",
      "&Ufr;": "𝔘",
      "&Ugrave": "Ù",
      "&Ugrave;": "Ù",
      "&Umacr;": "Ū",
      "&UnderBar;": "_",
      "&UnderBrace;": "⏟",
      "&UnderBracket;": "⎵",
      "&UnderParenthesis;": "⏝",
      "&Union;": "⋃",
      "&UnionPlus;": "⊎",
      "&Uogon;": "Ų",
      "&Uopf;": "𝕌",
      "&UpArrow;": "↑",
      "&UpArrowBar;": "⤒",
      "&UpArrowDownArrow;": "⇅",
      "&UpDownArrow;": "↕",
      "&UpEquilibrium;": "⥮",
      "&UpTee;": "⊥",
      "&UpTeeArrow;": "↥",
      "&Uparrow;": "⇑",
      "&Updownarrow;": "⇕",
      "&UpperLeftArrow;": "↖",
      "&UpperRightArrow;": "↗",
      "&Upsi;": "ϒ",
      "&Upsilon;": "Υ",
      "&Uring;": "Ů",
      "&Uscr;": "𝒰",
      "&Utilde;": "Ũ",
      "&Uuml": "Ü",
      "&Uuml;": "Ü",
      "&VDash;": "⊫",
      "&Vbar;": "⫫",
      "&Vcy;": "В",
      "&Vdash;": "⊩",
      "&Vdashl;": "⫦",
      "&Vee;": "⋁",
      "&Verbar;": "‖",
      "&Vert;": "‖",
      "&VerticalBar;": "∣",
      "&VerticalLine;": "|",
      "&VerticalSeparator;": "❘",
      "&VerticalTilde;": "≀",
      "&VeryThinSpace;": " ",
      "&Vfr;": "𝔙",
      "&Vopf;": "𝕍",
      "&Vscr;": "𝒱",
      "&Vvdash;": "⊪",
      "&Wcirc;": "Ŵ",
      "&Wedge;": "⋀",
      "&Wfr;": "𝔚",
      "&Wopf;": "𝕎",
      "&Wscr;": "𝒲",
      "&Xfr;": "𝔛",
      "&Xi;": "Ξ",
      "&Xopf;": "𝕏",
      "&Xscr;": "𝒳",
      "&YAcy;": "Я",
      "&YIcy;": "Ї",
      "&YUcy;": "Ю",
      "&Yacute": "Ý",
      "&Yacute;": "Ý",
      "&Ycirc;": "Ŷ",
      "&Ycy;": "Ы",
      "&Yfr;": "𝔜",
      "&Yopf;": "𝕐",
      "&Yscr;": "𝒴",
      "&Yuml;": "Ÿ",
      "&ZHcy;": "Ж",
      "&Zacute;": "Ź",
      "&Zcaron;": "Ž",
      "&Zcy;": "З",
      "&Zdot;": "Ż",
      "&ZeroWidthSpace;": "​",
      "&Zeta;": "Ζ",
      "&Zfr;": "ℨ",
      "&Zopf;": "ℤ",
      "&Zscr;": "𝒵",
      "&aacute": "á",
      "&aacute;": "á",
      "&abreve;": "ă",
      "&ac;": "∾",
      "&acE;": "∾̳",
      "&acd;": "∿",
      "&acirc": "â",
      "&acirc;": "â",
      "&acute": "´",
      "&acute;": "´",
      "&acy;": "а",
      "&aelig": "æ",
      "&aelig;": "æ",
      "&af;": "⁡",
      "&afr;": "𝔞",
      "&agrave": "à",
      "&agrave;": "à",
      "&alefsym;": "ℵ",
      "&aleph;": "ℵ",
      "&alpha;": "α",
      "&amacr;": "ā",
      "&amalg;": "⨿",
      "&amp": "&",
      "&amp;": "&",
      "&and;": "∧",
      "&andand;": "⩕",
      "&andd;": "⩜",
      "&andslope;": "⩘",
      "&andv;": "⩚",
      "&ang;": "∠",
      "&ange;": "⦤",
      "&angle;": "∠",
      "&angmsd;": "∡",
      "&angmsdaa;": "⦨",
      "&angmsdab;": "⦩",
      "&angmsdac;": "⦪",
      "&angmsdad;": "⦫",
      "&angmsdae;": "⦬",
      "&angmsdaf;": "⦭",
      "&angmsdag;": "⦮",
      "&angmsdah;": "⦯",
      "&angrt;": "∟",
      "&angrtvb;": "⊾",
      "&angrtvbd;": "⦝",
      "&angsph;": "∢",
      "&angst;": "Å",
      "&angzarr;": "⍼",
      "&aogon;": "ą",
      "&aopf;": "𝕒",
      "&ap;": "≈",
      "&apE;": "⩰",
      "&apacir;": "⩯",
      "&ape;": "≊",
      "&apid;": "≋",
      "&apos;": "'",
      "&approx;": "≈",
      "&approxeq;": "≊",
      "&aring": "å",
      "&aring;": "å",
      "&ascr;": "𝒶",
      "&ast;": "*",
      "&asymp;": "≈",
      "&asympeq;": "≍",
      "&atilde": "ã",
      "&atilde;": "ã",
      "&auml": "ä",
      "&auml;": "ä",
      "&awconint;": "∳",
      "&awint;": "⨑",
      "&bNot;": "⫭",
      "&backcong;": "≌",
      "&backepsilon;": "϶",
      "&backprime;": "‵",
      "&backsim;": "∽",
      "&backsimeq;": "⋍",
      "&barvee;": "⊽",
      "&barwed;": "⌅",
      "&barwedge;": "⌅",
      "&bbrk;": "⎵",
      "&bbrktbrk;": "⎶",
      "&bcong;": "≌",
      "&bcy;": "б",
      "&bdquo;": "„",
      "&becaus;": "∵",
      "&because;": "∵",
      "&bemptyv;": "⦰",
      "&bepsi;": "϶",
      "&bernou;": "ℬ",
      "&beta;": "β",
      "&beth;": "ℶ",
      "&between;": "≬",
      "&bfr;": "𝔟",
      "&bigcap;": "⋂",
      "&bigcirc;": "◯",
      "&bigcup;": "⋃",
      "&bigodot;": "⨀",
      "&bigoplus;": "⨁",
      "&bigotimes;": "⨂",
      "&bigsqcup;": "⨆",
      "&bigstar;": "★",
      "&bigtriangledown;": "▽",
      "&bigtriangleup;": "△",
      "&biguplus;": "⨄",
      "&bigvee;": "⋁",
      "&bigwedge;": "⋀",
      "&bkarow;": "⤍",
      "&blacklozenge;": "⧫",
      "&blacksquare;": "▪",
      "&blacktriangle;": "▴",
      "&blacktriangledown;": "▾",
      "&blacktriangleleft;": "◂",
      "&blacktriangleright;": "▸",
      "&blank;": "␣",
      "&blk12;": "▒",
      "&blk14;": "░",
      "&blk34;": "▓",
      "&block;": "█",
      "&bne;": "=⃥",
      "&bnequiv;": "≡⃥",
      "&bnot;": "⌐",
      "&bopf;": "𝕓",
      "&bot;": "⊥",
      "&bottom;": "⊥",
      "&bowtie;": "⋈",
      "&boxDL;": "╗",
      "&boxDR;": "╔",
      "&boxDl;": "╖",
      "&boxDr;": "╓",
      "&boxH;": "═",
      "&boxHD;": "╦",
      "&boxHU;": "╩",
      "&boxHd;": "╤",
      "&boxHu;": "╧",
      "&boxUL;": "╝",
      "&boxUR;": "╚",
      "&boxUl;": "╜",
      "&boxUr;": "╙",
      "&boxV;": "║",
      "&boxVH;": "╬",
      "&boxVL;": "╣",
      "&boxVR;": "╠",
      "&boxVh;": "╫",
      "&boxVl;": "╢",
      "&boxVr;": "╟",
      "&boxbox;": "⧉",
      "&boxdL;": "╕",
      "&boxdR;": "╒",
      "&boxdl;": "┐",
      "&boxdr;": "┌",
      "&boxh;": "─",
      "&boxhD;": "╥",
      "&boxhU;": "╨",
      "&boxhd;": "┬",
      "&boxhu;": "┴",
      "&boxminus;": "⊟",
      "&boxplus;": "⊞",
      "&boxtimes;": "⊠",
      "&boxuL;": "╛",
      "&boxuR;": "╘",
      "&boxul;": "┘",
      "&boxur;": "└",
      "&boxv;": "│",
      "&boxvH;": "╪",
      "&boxvL;": "╡",
      "&boxvR;": "╞",
      "&boxvh;": "┼",
      "&boxvl;": "┤",
      "&boxvr;": "├",
      "&bprime;": "‵",
      "&breve;": "˘",
      "&brvbar": "¦",
      "&brvbar;": "¦",
      "&bscr;": "𝒷",
      "&bsemi;": "⁏",
      "&bsim;": "∽",
      "&bsime;": "⋍",
      "&bsol;": "\\",
      "&bsolb;": "⧅",
      "&bsolhsub;": "⟈",
      "&bull;": "•",
      "&bullet;": "•",
      "&bump;": "≎",
      "&bumpE;": "⪮",
      "&bumpe;": "≏",
      "&bumpeq;": "≏",
      "&cacute;": "ć",
      "&cap;": "∩",
      "&capand;": "⩄",
      "&capbrcup;": "⩉",
      "&capcap;": "⩋",
      "&capcup;": "⩇",
      "&capdot;": "⩀",
      "&caps;": "∩︀",
      "&caret;": "⁁",
      "&caron;": "ˇ",
      "&ccaps;": "⩍",
      "&ccaron;": "č",
      "&ccedil": "ç",
      "&ccedil;": "ç",
      "&ccirc;": "ĉ",
      "&ccups;": "⩌",
      "&ccupssm;": "⩐",
      "&cdot;": "ċ",
      "&cedil": "¸",
      "&cedil;": "¸",
      "&cemptyv;": "⦲",
      "&cent": "¢",
      "&cent;": "¢",
      "&centerdot;": "·",
      "&cfr;": "𝔠",
      "&chcy;": "ч",
      "&check;": "✓",
      "&checkmark;": "✓",
      "&chi;": "χ",
      "&cir;": "○",
      "&cirE;": "⧃",
      "&circ;": "ˆ",
      "&circeq;": "≗",
      "&circlearrowleft;": "↺",
      "&circlearrowright;": "↻",
      "&circledR;": "®",
      "&circledS;": "Ⓢ",
      "&circledast;": "⊛",
      "&circledcirc;": "⊚",
      "&circleddash;": "⊝",
      "&cire;": "≗",
      "&cirfnint;": "⨐",
      "&cirmid;": "⫯",
      "&cirscir;": "⧂",
      "&clubs;": "♣",
      "&clubsuit;": "♣",
      "&colon;": ":",
      "&colone;": "≔",
      "&coloneq;": "≔",
      "&comma;": ",",
      "&commat;": "@",
      "&comp;": "∁",
      "&compfn;": "∘",
      "&complement;": "∁",
      "&complexes;": "ℂ",
      "&cong;": "≅",
      "&congdot;": "⩭",
      "&conint;": "∮",
      "&copf;": "𝕔",
      "&coprod;": "∐",
      "&copy": "©",
      "&copy;": "©",
      "&copysr;": "℗",
      "&crarr;": "↵",
      "&cross;": "✗",
      "&cscr;": "𝒸",
      "&csub;": "⫏",
      "&csube;": "⫑",
      "&csup;": "⫐",
      "&csupe;": "⫒",
      "&ctdot;": "⋯",
      "&cudarrl;": "⤸",
      "&cudarrr;": "⤵",
      "&cuepr;": "⋞",
      "&cuesc;": "⋟",
      "&cularr;": "↶",
      "&cularrp;": "⤽",
      "&cup;": "∪",
      "&cupbrcap;": "⩈",
      "&cupcap;": "⩆",
      "&cupcup;": "⩊",
      "&cupdot;": "⊍",
      "&cupor;": "⩅",
      "&cups;": "∪︀",
      "&curarr;": "↷",
      "&curarrm;": "⤼",
      "&curlyeqprec;": "⋞",
      "&curlyeqsucc;": "⋟",
      "&curlyvee;": "⋎",
      "&curlywedge;": "⋏",
      "&curren": "¤",
      "&curren;": "¤",
      "&curvearrowleft;": "↶",
      "&curvearrowright;": "↷",
      "&cuvee;": "⋎",
      "&cuwed;": "⋏",
      "&cwconint;": "∲",
      "&cwint;": "∱",
      "&cylcty;": "⌭",
      "&dArr;": "⇓",
      "&dHar;": "⥥",
      "&dagger;": "†",
      "&daleth;": "ℸ",
      "&darr;": "↓",
      "&dash;": "‐",
      "&dashv;": "⊣",
      "&dbkarow;": "⤏",
      "&dblac;": "˝",
      "&dcaron;": "ď",
      "&dcy;": "д",
      "&dd;": "ⅆ",
      "&ddagger;": "‡",
      "&ddarr;": "⇊",
      "&ddotseq;": "⩷",
      "&deg": "°",
      "&deg;": "°",
      "&delta;": "δ",
      "&demptyv;": "⦱",
      "&dfisht;": "⥿",
      "&dfr;": "𝔡",
      "&dharl;": "⇃",
      "&dharr;": "⇂",
      "&diam;": "⋄",
      "&diamond;": "⋄",
      "&diamondsuit;": "♦",
      "&diams;": "♦",
      "&die;": "¨",
      "&digamma;": "ϝ",
      "&disin;": "⋲",
      "&div;": "÷",
      "&divide": "÷",
      "&divide;": "÷",
      "&divideontimes;": "⋇",
      "&divonx;": "⋇",
      "&djcy;": "ђ",
      "&dlcorn;": "⌞",
      "&dlcrop;": "⌍",
      "&dollar;": "$",
      "&dopf;": "𝕕",
      "&dot;": "˙",
      "&doteq;": "≐",
      "&doteqdot;": "≑",
      "&dotminus;": "∸",
      "&dotplus;": "∔",
      "&dotsquare;": "⊡",
      "&doublebarwedge;": "⌆",
      "&downarrow;": "↓",
      "&downdownarrows;": "⇊",
      "&downharpoonleft;": "⇃",
      "&downharpoonright;": "⇂",
      "&drbkarow;": "⤐",
      "&drcorn;": "⌟",
      "&drcrop;": "⌌",
      "&dscr;": "𝒹",
      "&dscy;": "ѕ",
      "&dsol;": "⧶",
      "&dstrok;": "đ",
      "&dtdot;": "⋱",
      "&dtri;": "▿",
      "&dtrif;": "▾",
      "&duarr;": "⇵",
      "&duhar;": "⥯",
      "&dwangle;": "⦦",
      "&dzcy;": "џ",
      "&dzigrarr;": "⟿",
      "&eDDot;": "⩷",
      "&eDot;": "≑",
      "&eacute": "é",
      "&eacute;": "é",
      "&easter;": "⩮",
      "&ecaron;": "ě",
      "&ecir;": "≖",
      "&ecirc": "ê",
      "&ecirc;": "ê",
      "&ecolon;": "≕",
      "&ecy;": "э",
      "&edot;": "ė",
      "&ee;": "ⅇ",
      "&efDot;": "≒",
      "&efr;": "𝔢",
      "&eg;": "⪚",
      "&egrave": "è",
      "&egrave;": "è",
      "&egs;": "⪖",
      "&egsdot;": "⪘",
      "&el;": "⪙",
      "&elinters;": "⏧",
      "&ell;": "ℓ",
      "&els;": "⪕",
      "&elsdot;": "⪗",
      "&emacr;": "ē",
      "&empty;": "∅",
      "&emptyset;": "∅",
      "&emptyv;": "∅",
      "&emsp13;": " ",
      "&emsp14;": " ",
      "&emsp;": " ",
      "&eng;": "ŋ",
      "&ensp;": " ",
      "&eogon;": "ę",
      "&eopf;": "𝕖",
      "&epar;": "⋕",
      "&eparsl;": "⧣",
      "&eplus;": "⩱",
      "&epsi;": "ε",
      "&epsilon;": "ε",
      "&epsiv;": "ϵ",
      "&eqcirc;": "≖",
      "&eqcolon;": "≕",
      "&eqsim;": "≂",
      "&eqslantgtr;": "⪖",
      "&eqslantless;": "⪕",
      "&equals;": "=",
      "&equest;": "≟",
      "&equiv;": "≡",
      "&equivDD;": "⩸",
      "&eqvparsl;": "⧥",
      "&erDot;": "≓",
      "&erarr;": "⥱",
      "&escr;": "ℯ",
      "&esdot;": "≐",
      "&esim;": "≂",
      "&eta;": "η",
      "&eth": "ð",
      "&eth;": "ð",
      "&euml": "ë",
      "&euml;": "ë",
      "&euro;": "€",
      "&excl;": "!",
      "&exist;": "∃",
      "&expectation;": "ℰ",
      "&exponentiale;": "ⅇ",
      "&fallingdotseq;": "≒",
      "&fcy;": "ф",
      "&female;": "♀",
      "&ffilig;": "ﬃ",
      "&fflig;": "ﬀ",
      "&ffllig;": "ﬄ",
      "&ffr;": "𝔣",
      "&filig;": "ﬁ",
      "&fjlig;": "fj",
      "&flat;": "♭",
      "&fllig;": "ﬂ",
      "&fltns;": "▱",
      "&fnof;": "ƒ",
      "&fopf;": "𝕗",
      "&forall;": "∀",
      "&fork;": "⋔",
      "&forkv;": "⫙",
      "&fpartint;": "⨍",
      "&frac12": "½",
      "&frac12;": "½",
      "&frac13;": "⅓",
      "&frac14": "¼",
      "&frac14;": "¼",
      "&frac15;": "⅕",
      "&frac16;": "⅙",
      "&frac18;": "⅛",
      "&frac23;": "⅔",
      "&frac25;": "⅖",
      "&frac34": "¾",
      "&frac34;": "¾",
      "&frac35;": "⅗",
      "&frac38;": "⅜",
      "&frac45;": "⅘",
      "&frac56;": "⅚",
      "&frac58;": "⅝",
      "&frac78;": "⅞",
      "&frasl;": "⁄",
      "&frown;": "⌢",
      "&fscr;": "𝒻",
      "&gE;": "≧",
      "&gEl;": "⪌",
      "&gacute;": "ǵ",
      "&gamma;": "γ",
      "&gammad;": "ϝ",
      "&gap;": "⪆",
      "&gbreve;": "ğ",
      "&gcirc;": "ĝ",
      "&gcy;": "г",
      "&gdot;": "ġ",
      "&ge;": "≥",
      "&gel;": "⋛",
      "&geq;": "≥",
      "&geqq;": "≧",
      "&geqslant;": "⩾",
      "&ges;": "⩾",
      "&gescc;": "⪩",
      "&gesdot;": "⪀",
      "&gesdoto;": "⪂",
      "&gesdotol;": "⪄",
      "&gesl;": "⋛︀",
      "&gesles;": "⪔",
      "&gfr;": "𝔤",
      "&gg;": "≫",
      "&ggg;": "⋙",
      "&gimel;": "ℷ",
      "&gjcy;": "ѓ",
      "&gl;": "≷",
      "&glE;": "⪒",
      "&gla;": "⪥",
      "&glj;": "⪤",
      "&gnE;": "≩",
      "&gnap;": "⪊",
      "&gnapprox;": "⪊",
      "&gne;": "⪈",
      "&gneq;": "⪈",
      "&gneqq;": "≩",
      "&gnsim;": "⋧",
      "&gopf;": "𝕘",
      "&grave;": "`",
      "&gscr;": "ℊ",
      "&gsim;": "≳",
      "&gsime;": "⪎",
      "&gsiml;": "⪐",
      "&gt": ">",
      "&gt;": ">",
      "&gtcc;": "⪧",
      "&gtcir;": "⩺",
      "&gtdot;": "⋗",
      "&gtlPar;": "⦕",
      "&gtquest;": "⩼",
      "&gtrapprox;": "⪆",
      "&gtrarr;": "⥸",
      "&gtrdot;": "⋗",
      "&gtreqless;": "⋛",
      "&gtreqqless;": "⪌",
      "&gtrless;": "≷",
      "&gtrsim;": "≳",
      "&gvertneqq;": "≩︀",
      "&gvnE;": "≩︀",
      "&hArr;": "⇔",
      "&hairsp;": " ",
      "&half;": "½",
      "&hamilt;": "ℋ",
      "&hardcy;": "ъ",
      "&harr;": "↔",
      "&harrcir;": "⥈",
      "&harrw;": "↭",
      "&hbar;": "ℏ",
      "&hcirc;": "ĥ",
      "&hearts;": "♥",
      "&heartsuit;": "♥",
      "&hellip;": "…",
      "&hercon;": "⊹",
      "&hfr;": "𝔥",
      "&hksearow;": "⤥",
      "&hkswarow;": "⤦",
      "&hoarr;": "⇿",
      "&homtht;": "∻",
      "&hookleftarrow;": "↩",
      "&hookrightarrow;": "↪",
      "&hopf;": "𝕙",
      "&horbar;": "―",
      "&hscr;": "𝒽",
      "&hslash;": "ℏ",
      "&hstrok;": "ħ",
      "&hybull;": "⁃",
      "&hyphen;": "‐",
      "&iacute": "í",
      "&iacute;": "í",
      "&ic;": "⁣",
      "&icirc": "î",
      "&icirc;": "î",
      "&icy;": "и",
      "&iecy;": "е",
      "&iexcl": "¡",
      "&iexcl;": "¡",
      "&iff;": "⇔",
      "&ifr;": "𝔦",
      "&igrave": "ì",
      "&igrave;": "ì",
      "&ii;": "ⅈ",
      "&iiiint;": "⨌",
      "&iiint;": "∭",
      "&iinfin;": "⧜",
      "&iiota;": "℩",
      "&ijlig;": "ĳ",
      "&imacr;": "ī",
      "&image;": "ℑ",
      "&imagline;": "ℐ",
      "&imagpart;": "ℑ",
      "&imath;": "ı",
      "&imof;": "⊷",
      "&imped;": "Ƶ",
      "&in;": "∈",
      "&incare;": "℅",
      "&infin;": "∞",
      "&infintie;": "⧝",
      "&inodot;": "ı",
      "&int;": "∫",
      "&intcal;": "⊺",
      "&integers;": "ℤ",
      "&intercal;": "⊺",
      "&intlarhk;": "⨗",
      "&intprod;": "⨼",
      "&iocy;": "ё",
      "&iogon;": "į",
      "&iopf;": "𝕚",
      "&iota;": "ι",
      "&iprod;": "⨼",
      "&iquest": "¿",
      "&iquest;": "¿",
      "&iscr;": "𝒾",
      "&isin;": "∈",
      "&isinE;": "⋹",
      "&isindot;": "⋵",
      "&isins;": "⋴",
      "&isinsv;": "⋳",
      "&isinv;": "∈",
      "&it;": "⁢",
      "&itilde;": "ĩ",
      "&iukcy;": "і",
      "&iuml": "ï",
      "&iuml;": "ï",
      "&jcirc;": "ĵ",
      "&jcy;": "й",
      "&jfr;": "𝔧",
      "&jmath;": "ȷ",
      "&jopf;": "𝕛",
      "&jscr;": "𝒿",
      "&jsercy;": "ј",
      "&jukcy;": "є",
      "&kappa;": "κ",
      "&kappav;": "ϰ",
      "&kcedil;": "ķ",
      "&kcy;": "к",
      "&kfr;": "𝔨",
      "&kgreen;": "ĸ",
      "&khcy;": "х",
      "&kjcy;": "ќ",
      "&kopf;": "𝕜",
      "&kscr;": "𝓀",
      "&lAarr;": "⇚",
      "&lArr;": "⇐",
      "&lAtail;": "⤛",
      "&lBarr;": "⤎",
      "&lE;": "≦",
      "&lEg;": "⪋",
      "&lHar;": "⥢",
      "&lacute;": "ĺ",
      "&laemptyv;": "⦴",
      "&lagran;": "ℒ",
      "&lambda;": "λ",
      "&lang;": "⟨",
      "&langd;": "⦑",
      "&langle;": "⟨",
      "&lap;": "⪅",
      "&laquo": "«",
      "&laquo;": "«",
      "&larr;": "←",
      "&larrb;": "⇤",
      "&larrbfs;": "⤟",
      "&larrfs;": "⤝",
      "&larrhk;": "↩",
      "&larrlp;": "↫",
      "&larrpl;": "⤹",
      "&larrsim;": "⥳",
      "&larrtl;": "↢",
      "&lat;": "⪫",
      "&latail;": "⤙",
      "&late;": "⪭",
      "&lates;": "⪭︀",
      "&lbarr;": "⤌",
      "&lbbrk;": "❲",
      "&lbrace;": "{",
      "&lbrack;": "[",
      "&lbrke;": "⦋",
      "&lbrksld;": "⦏",
      "&lbrkslu;": "⦍",
      "&lcaron;": "ľ",
      "&lcedil;": "ļ",
      "&lceil;": "⌈",
      "&lcub;": "{",
      "&lcy;": "л",
      "&ldca;": "⤶",
      "&ldquo;": "“",
      "&ldquor;": "„",
      "&ldrdhar;": "⥧",
      "&ldrushar;": "⥋",
      "&ldsh;": "↲",
      "&le;": "≤",
      "&leftarrow;": "←",
      "&leftarrowtail;": "↢",
      "&leftharpoondown;": "↽",
      "&leftharpoonup;": "↼",
      "&leftleftarrows;": "⇇",
      "&leftrightarrow;": "↔",
      "&leftrightarrows;": "⇆",
      "&leftrightharpoons;": "⇋",
      "&leftrightsquigarrow;": "↭",
      "&leftthreetimes;": "⋋",
      "&leg;": "⋚",
      "&leq;": "≤",
      "&leqq;": "≦",
      "&leqslant;": "⩽",
      "&les;": "⩽",
      "&lescc;": "⪨",
      "&lesdot;": "⩿",
      "&lesdoto;": "⪁",
      "&lesdotor;": "⪃",
      "&lesg;": "⋚︀",
      "&lesges;": "⪓",
      "&lessapprox;": "⪅",
      "&lessdot;": "⋖",
      "&lesseqgtr;": "⋚",
      "&lesseqqgtr;": "⪋",
      "&lessgtr;": "≶",
      "&lesssim;": "≲",
      "&lfisht;": "⥼",
      "&lfloor;": "⌊",
      "&lfr;": "𝔩",
      "&lg;": "≶",
      "&lgE;": "⪑",
      "&lhard;": "↽",
      "&lharu;": "↼",
      "&lharul;": "⥪",
      "&lhblk;": "▄",
      "&ljcy;": "љ",
      "&ll;": "≪",
      "&llarr;": "⇇",
      "&llcorner;": "⌞",
      "&llhard;": "⥫",
      "&lltri;": "◺",
      "&lmidot;": "ŀ",
      "&lmoust;": "⎰",
      "&lmoustache;": "⎰",
      "&lnE;": "≨",
      "&lnap;": "⪉",
      "&lnapprox;": "⪉",
      "&lne;": "⪇",
      "&lneq;": "⪇",
      "&lneqq;": "≨",
      "&lnsim;": "⋦",
      "&loang;": "⟬",
      "&loarr;": "⇽",
      "&lobrk;": "⟦",
      "&longleftarrow;": "⟵",
      "&longleftrightarrow;": "⟷",
      "&longmapsto;": "⟼",
      "&longrightarrow;": "⟶",
      "&looparrowleft;": "↫",
      "&looparrowright;": "↬",
      "&lopar;": "⦅",
      "&lopf;": "𝕝",
      "&loplus;": "⨭",
      "&lotimes;": "⨴",
      "&lowast;": "∗",
      "&lowbar;": "_",
      "&loz;": "◊",
      "&lozenge;": "◊",
      "&lozf;": "⧫",
      "&lpar;": "(",
      "&lparlt;": "⦓",
      "&lrarr;": "⇆",
      "&lrcorner;": "⌟",
      "&lrhar;": "⇋",
      "&lrhard;": "⥭",
      "&lrm;": "‎",
      "&lrtri;": "⊿",
      "&lsaquo;": "‹",
      "&lscr;": "𝓁",
      "&lsh;": "↰",
      "&lsim;": "≲",
      "&lsime;": "⪍",
      "&lsimg;": "⪏",
      "&lsqb;": "[",
      "&lsquo;": "‘",
      "&lsquor;": "‚",
      "&lstrok;": "ł",
      "&lt": "<",
      "&lt;": "<",
      "&ltcc;": "⪦",
      "&ltcir;": "⩹",
      "&ltdot;": "⋖",
      "&lthree;": "⋋",
      "&ltimes;": "⋉",
      "&ltlarr;": "⥶",
      "&ltquest;": "⩻",
      "&ltrPar;": "⦖",
      "&ltri;": "◃",
      "&ltrie;": "⊴",
      "&ltrif;": "◂",
      "&lurdshar;": "⥊",
      "&luruhar;": "⥦",
      "&lvertneqq;": "≨︀",
      "&lvnE;": "≨︀",
      "&mDDot;": "∺",
      "&macr": "¯",
      "&macr;": "¯",
      "&male;": "♂",
      "&malt;": "✠",
      "&maltese;": "✠",
      "&map;": "↦",
      "&mapsto;": "↦",
      "&mapstodown;": "↧",
      "&mapstoleft;": "↤",
      "&mapstoup;": "↥",
      "&marker;": "▮",
      "&mcomma;": "⨩",
      "&mcy;": "м",
      "&mdash;": "—",
      "&measuredangle;": "∡",
      "&mfr;": "𝔪",
      "&mho;": "℧",
      "&micro": "µ",
      "&micro;": "µ",
      "&mid;": "∣",
      "&midast;": "*",
      "&midcir;": "⫰",
      "&middot": "·",
      "&middot;": "·",
      "&minus;": "−",
      "&minusb;": "⊟",
      "&minusd;": "∸",
      "&minusdu;": "⨪",
      "&mlcp;": "⫛",
      "&mldr;": "…",
      "&mnplus;": "∓",
      "&models;": "⊧",
      "&mopf;": "𝕞",
      "&mp;": "∓",
      "&mscr;": "𝓂",
      "&mstpos;": "∾",
      "&mu;": "μ",
      "&multimap;": "⊸",
      "&mumap;": "⊸",
      "&nGg;": "⋙̸",
      "&nGt;": "≫⃒",
      "&nGtv;": "≫̸",
      "&nLeftarrow;": "⇍",
      "&nLeftrightarrow;": "⇎",
      "&nLl;": "⋘̸",
      "&nLt;": "≪⃒",
      "&nLtv;": "≪̸",
      "&nRightarrow;": "⇏",
      "&nVDash;": "⊯",
      "&nVdash;": "⊮",
      "&nabla;": "∇",
      "&nacute;": "ń",
      "&nang;": "∠⃒",
      "&nap;": "≉",
      "&napE;": "⩰̸",
      "&napid;": "≋̸",
      "&napos;": "ŉ",
      "&napprox;": "≉",
      "&natur;": "♮",
      "&natural;": "♮",
      "&naturals;": "ℕ",
      "&nbsp": " ",
      "&nbsp;": " ",
      "&nbump;": "≎̸",
      "&nbumpe;": "≏̸",
      "&ncap;": "⩃",
      "&ncaron;": "ň",
      "&ncedil;": "ņ",
      "&ncong;": "≇",
      "&ncongdot;": "⩭̸",
      "&ncup;": "⩂",
      "&ncy;": "н",
      "&ndash;": "–",
      "&ne;": "≠",
      "&neArr;": "⇗",
      "&nearhk;": "⤤",
      "&nearr;": "↗",
      "&nearrow;": "↗",
      "&nedot;": "≐̸",
      "&nequiv;": "≢",
      "&nesear;": "⤨",
      "&nesim;": "≂̸",
      "&nexist;": "∄",
      "&nexists;": "∄",
      "&nfr;": "𝔫",
      "&ngE;": "≧̸",
      "&nge;": "≱",
      "&ngeq;": "≱",
      "&ngeqq;": "≧̸",
      "&ngeqslant;": "⩾̸",
      "&nges;": "⩾̸",
      "&ngsim;": "≵",
      "&ngt;": "≯",
      "&ngtr;": "≯",
      "&nhArr;": "⇎",
      "&nharr;": "↮",
      "&nhpar;": "⫲",
      "&ni;": "∋",
      "&nis;": "⋼",
      "&nisd;": "⋺",
      "&niv;": "∋",
      "&njcy;": "њ",
      "&nlArr;": "⇍",
      "&nlE;": "≦̸",
      "&nlarr;": "↚",
      "&nldr;": "‥",
      "&nle;": "≰",
      "&nleftarrow;": "↚",
      "&nleftrightarrow;": "↮",
      "&nleq;": "≰",
      "&nleqq;": "≦̸",
      "&nleqslant;": "⩽̸",
      "&nles;": "⩽̸",
      "&nless;": "≮",
      "&nlsim;": "≴",
      "&nlt;": "≮",
      "&nltri;": "⋪",
      "&nltrie;": "⋬",
      "&nmid;": "∤",
      "&nopf;": "𝕟",
      "&not": "¬",
      "&not;": "¬",
      "&notin;": "∉",
      "&notinE;": "⋹̸",
      "&notindot;": "⋵̸",
      "&notinva;": "∉",
      "&notinvb;": "⋷",
      "&notinvc;": "⋶",
      "&notni;": "∌",
      "&notniva;": "∌",
      "&notnivb;": "⋾",
      "&notnivc;": "⋽",
      "&npar;": "∦",
      "&nparallel;": "∦",
      "&nparsl;": "⫽⃥",
      "&npart;": "∂̸",
      "&npolint;": "⨔",
      "&npr;": "⊀",
      "&nprcue;": "⋠",
      "&npre;": "⪯̸",
      "&nprec;": "⊀",
      "&npreceq;": "⪯̸",
      "&nrArr;": "⇏",
      "&nrarr;": "↛",
      "&nrarrc;": "⤳̸",
      "&nrarrw;": "↝̸",
      "&nrightarrow;": "↛",
      "&nrtri;": "⋫",
      "&nrtrie;": "⋭",
      "&nsc;": "⊁",
      "&nsccue;": "⋡",
      "&nsce;": "⪰̸",
      "&nscr;": "𝓃",
      "&nshortmid;": "∤",
      "&nshortparallel;": "∦",
      "&nsim;": "≁",
      "&nsime;": "≄",
      "&nsimeq;": "≄",
      "&nsmid;": "∤",
      "&nspar;": "∦",
      "&nsqsube;": "⋢",
      "&nsqsupe;": "⋣",
      "&nsub;": "⊄",
      "&nsubE;": "⫅̸",
      "&nsube;": "⊈",
      "&nsubset;": "⊂⃒",
      "&nsubseteq;": "⊈",
      "&nsubseteqq;": "⫅̸",
      "&nsucc;": "⊁",
      "&nsucceq;": "⪰̸",
      "&nsup;": "⊅",
      "&nsupE;": "⫆̸",
      "&nsupe;": "⊉",
      "&nsupset;": "⊃⃒",
      "&nsupseteq;": "⊉",
      "&nsupseteqq;": "⫆̸",
      "&ntgl;": "≹",
      "&ntilde": "ñ",
      "&ntilde;": "ñ",
      "&ntlg;": "≸",
      "&ntriangleleft;": "⋪",
      "&ntrianglelefteq;": "⋬",
      "&ntriangleright;": "⋫",
      "&ntrianglerighteq;": "⋭",
      "&nu;": "ν",
      "&num;": "#",
      "&numero;": "№",
      "&numsp;": " ",
      "&nvDash;": "⊭",
      "&nvHarr;": "⤄",
      "&nvap;": "≍⃒",
      "&nvdash;": "⊬",
      "&nvge;": "≥⃒",
      "&nvgt;": ">⃒",
      "&nvinfin;": "⧞",
      "&nvlArr;": "⤂",
      "&nvle;": "≤⃒",
      "&nvlt;": "<⃒",
      "&nvltrie;": "⊴⃒",
      "&nvrArr;": "⤃",
      "&nvrtrie;": "⊵⃒",
      "&nvsim;": "∼⃒",
      "&nwArr;": "⇖",
      "&nwarhk;": "⤣",
      "&nwarr;": "↖",
      "&nwarrow;": "↖",
      "&nwnear;": "⤧",
      "&oS;": "Ⓢ",
      "&oacute": "ó",
      "&oacute;": "ó",
      "&oast;": "⊛",
      "&ocir;": "⊚",
      "&ocirc": "ô",
      "&ocirc;": "ô",
      "&ocy;": "о",
      "&odash;": "⊝",
      "&odblac;": "ő",
      "&odiv;": "⨸",
      "&odot;": "⊙",
      "&odsold;": "⦼",
      "&oelig;": "œ",
      "&ofcir;": "⦿",
      "&ofr;": "𝔬",
      "&ogon;": "˛",
      "&ograve": "ò",
      "&ograve;": "ò",
      "&ogt;": "⧁",
      "&ohbar;": "⦵",
      "&ohm;": "Ω",
      "&oint;": "∮",
      "&olarr;": "↺",
      "&olcir;": "⦾",
      "&olcross;": "⦻",
      "&oline;": "‾",
      "&olt;": "⧀",
      "&omacr;": "ō",
      "&omega;": "ω",
      "&omicron;": "ο",
      "&omid;": "⦶",
      "&ominus;": "⊖",
      "&oopf;": "𝕠",
      "&opar;": "⦷",
      "&operp;": "⦹",
      "&oplus;": "⊕",
      "&or;": "∨",
      "&orarr;": "↻",
      "&ord;": "⩝",
      "&order;": "ℴ",
      "&orderof;": "ℴ",
      "&ordf": "ª",
      "&ordf;": "ª",
      "&ordm": "º",
      "&ordm;": "º",
      "&origof;": "⊶",
      "&oror;": "⩖",
      "&orslope;": "⩗",
      "&orv;": "⩛",
      "&oscr;": "ℴ",
      "&oslash": "ø",
      "&oslash;": "ø",
      "&osol;": "⊘",
      "&otilde": "õ",
      "&otilde;": "õ",
      "&otimes;": "⊗",
      "&otimesas;": "⨶",
      "&ouml": "ö",
      "&ouml;": "ö",
      "&ovbar;": "⌽",
      "&par;": "∥",
      "&para": "¶",
      "&para;": "¶",
      "&parallel;": "∥",
      "&parsim;": "⫳",
      "&parsl;": "⫽",
      "&part;": "∂",
      "&pcy;": "п",
      "&percnt;": "%",
      "&period;": ".",
      "&permil;": "‰",
      "&perp;": "⊥",
      "&pertenk;": "‱",
      "&pfr;": "𝔭",
      "&phi;": "φ",
      "&phiv;": "ϕ",
      "&phmmat;": "ℳ",
      "&phone;": "☎",
      "&pi;": "π",
      "&pitchfork;": "⋔",
      "&piv;": "ϖ",
      "&planck;": "ℏ",
      "&planckh;": "ℎ",
      "&plankv;": "ℏ",
      "&plus;": "+",
      "&plusacir;": "⨣",
      "&plusb;": "⊞",
      "&pluscir;": "⨢",
      "&plusdo;": "∔",
      "&plusdu;": "⨥",
      "&pluse;": "⩲",
      "&plusmn": "±",
      "&plusmn;": "±",
      "&plussim;": "⨦",
      "&plustwo;": "⨧",
      "&pm;": "±",
      "&pointint;": "⨕",
      "&popf;": "𝕡",
      "&pound": "£",
      "&pound;": "£",
      "&pr;": "≺",
      "&prE;": "⪳",
      "&prap;": "⪷",
      "&prcue;": "≼",
      "&pre;": "⪯",
      "&prec;": "≺",
      "&precapprox;": "⪷",
      "&preccurlyeq;": "≼",
      "&preceq;": "⪯",
      "&precnapprox;": "⪹",
      "&precneqq;": "⪵",
      "&precnsim;": "⋨",
      "&precsim;": "≾",
      "&prime;": "′",
      "&primes;": "ℙ",
      "&prnE;": "⪵",
      "&prnap;": "⪹",
      "&prnsim;": "⋨",
      "&prod;": "∏",
      "&profalar;": "⌮",
      "&profline;": "⌒",
      "&profsurf;": "⌓",
      "&prop;": "∝",
      "&propto;": "∝",
      "&prsim;": "≾",
      "&prurel;": "⊰",
      "&pscr;": "𝓅",
      "&psi;": "ψ",
      "&puncsp;": " ",
      "&qfr;": "𝔮",
      "&qint;": "⨌",
      "&qopf;": "𝕢",
      "&qprime;": "⁗",
      "&qscr;": "𝓆",
      "&quaternions;": "ℍ",
      "&quatint;": "⨖",
      "&quest;": "?",
      "&questeq;": "≟",
      "&quot": '"',
      "&quot;": '"',
      "&rAarr;": "⇛",
      "&rArr;": "⇒",
      "&rAtail;": "⤜",
      "&rBarr;": "⤏",
      "&rHar;": "⥤",
      "&race;": "∽̱",
      "&racute;": "ŕ",
      "&radic;": "√",
      "&raemptyv;": "⦳",
      "&rang;": "⟩",
      "&rangd;": "⦒",
      "&range;": "⦥",
      "&rangle;": "⟩",
      "&raquo": "»",
      "&raquo;": "»",
      "&rarr;": "→",
      "&rarrap;": "⥵",
      "&rarrb;": "⇥",
      "&rarrbfs;": "⤠",
      "&rarrc;": "⤳",
      "&rarrfs;": "⤞",
      "&rarrhk;": "↪",
      "&rarrlp;": "↬",
      "&rarrpl;": "⥅",
      "&rarrsim;": "⥴",
      "&rarrtl;": "↣",
      "&rarrw;": "↝",
      "&ratail;": "⤚",
      "&ratio;": "∶",
      "&rationals;": "ℚ",
      "&rbarr;": "⤍",
      "&rbbrk;": "❳",
      "&rbrace;": "}",
      "&rbrack;": "]",
      "&rbrke;": "⦌",
      "&rbrksld;": "⦎",
      "&rbrkslu;": "⦐",
      "&rcaron;": "ř",
      "&rcedil;": "ŗ",
      "&rceil;": "⌉",
      "&rcub;": "}",
      "&rcy;": "р",
      "&rdca;": "⤷",
      "&rdldhar;": "⥩",
      "&rdquo;": "”",
      "&rdquor;": "”",
      "&rdsh;": "↳",
      "&real;": "ℜ",
      "&realine;": "ℛ",
      "&realpart;": "ℜ",
      "&reals;": "ℝ",
      "&rect;": "▭",
      "&reg": "®",
      "&reg;": "®",
      "&rfisht;": "⥽",
      "&rfloor;": "⌋",
      "&rfr;": "𝔯",
      "&rhard;": "⇁",
      "&rharu;": "⇀",
      "&rharul;": "⥬",
      "&rho;": "ρ",
      "&rhov;": "ϱ",
      "&rightarrow;": "→",
      "&rightarrowtail;": "↣",
      "&rightharpoondown;": "⇁",
      "&rightharpoonup;": "⇀",
      "&rightleftarrows;": "⇄",
      "&rightleftharpoons;": "⇌",
      "&rightrightarrows;": "⇉",
      "&rightsquigarrow;": "↝",
      "&rightthreetimes;": "⋌",
      "&ring;": "˚",
      "&risingdotseq;": "≓",
      "&rlarr;": "⇄",
      "&rlhar;": "⇌",
      "&rlm;": "‏",
      "&rmoust;": "⎱",
      "&rmoustache;": "⎱",
      "&rnmid;": "⫮",
      "&roang;": "⟭",
      "&roarr;": "⇾",
      "&robrk;": "⟧",
      "&ropar;": "⦆",
      "&ropf;": "𝕣",
      "&roplus;": "⨮",
      "&rotimes;": "⨵",
      "&rpar;": ")",
      "&rpargt;": "⦔",
      "&rppolint;": "⨒",
      "&rrarr;": "⇉",
      "&rsaquo;": "›",
      "&rscr;": "𝓇",
      "&rsh;": "↱",
      "&rsqb;": "]",
      "&rsquo;": "’",
      "&rsquor;": "’",
      "&rthree;": "⋌",
      "&rtimes;": "⋊",
      "&rtri;": "▹",
      "&rtrie;": "⊵",
      "&rtrif;": "▸",
      "&rtriltri;": "⧎",
      "&ruluhar;": "⥨",
      "&rx;": "℞",
      "&sacute;": "ś",
      "&sbquo;": "‚",
      "&sc;": "≻",
      "&scE;": "⪴",
      "&scap;": "⪸",
      "&scaron;": "š",
      "&sccue;": "≽",
      "&sce;": "⪰",
      "&scedil;": "ş",
      "&scirc;": "ŝ",
      "&scnE;": "⪶",
      "&scnap;": "⪺",
      "&scnsim;": "⋩",
      "&scpolint;": "⨓",
      "&scsim;": "≿",
      "&scy;": "с",
      "&sdot;": "⋅",
      "&sdotb;": "⊡",
      "&sdote;": "⩦",
      "&seArr;": "⇘",
      "&searhk;": "⤥",
      "&searr;": "↘",
      "&searrow;": "↘",
      "&sect": "§",
      "&sect;": "§",
      "&semi;": ";",
      "&seswar;": "⤩",
      "&setminus;": "∖",
      "&setmn;": "∖",
      "&sext;": "✶",
      "&sfr;": "𝔰",
      "&sfrown;": "⌢",
      "&sharp;": "♯",
      "&shchcy;": "щ",
      "&shcy;": "ш",
      "&shortmid;": "∣",
      "&shortparallel;": "∥",
      "&shy": "­",
      "&shy;": "­",
      "&sigma;": "σ",
      "&sigmaf;": "ς",
      "&sigmav;": "ς",
      "&sim;": "∼",
      "&simdot;": "⩪",
      "&sime;": "≃",
      "&simeq;": "≃",
      "&simg;": "⪞",
      "&simgE;": "⪠",
      "&siml;": "⪝",
      "&simlE;": "⪟",
      "&simne;": "≆",
      "&simplus;": "⨤",
      "&simrarr;": "⥲",
      "&slarr;": "←",
      "&smallsetminus;": "∖",
      "&smashp;": "⨳",
      "&smeparsl;": "⧤",
      "&smid;": "∣",
      "&smile;": "⌣",
      "&smt;": "⪪",
      "&smte;": "⪬",
      "&smtes;": "⪬︀",
      "&softcy;": "ь",
      "&sol;": "/",
      "&solb;": "⧄",
      "&solbar;": "⌿",
      "&sopf;": "𝕤",
      "&spades;": "♠",
      "&spadesuit;": "♠",
      "&spar;": "∥",
      "&sqcap;": "⊓",
      "&sqcaps;": "⊓︀",
      "&sqcup;": "⊔",
      "&sqcups;": "⊔︀",
      "&sqsub;": "⊏",
      "&sqsube;": "⊑",
      "&sqsubset;": "⊏",
      "&sqsubseteq;": "⊑",
      "&sqsup;": "⊐",
      "&sqsupe;": "⊒",
      "&sqsupset;": "⊐",
      "&sqsupseteq;": "⊒",
      "&squ;": "□",
      "&square;": "□",
      "&squarf;": "▪",
      "&squf;": "▪",
      "&srarr;": "→",
      "&sscr;": "𝓈",
      "&ssetmn;": "∖",
      "&ssmile;": "⌣",
      "&sstarf;": "⋆",
      "&star;": "☆",
      "&starf;": "★",
      "&straightepsilon;": "ϵ",
      "&straightphi;": "ϕ",
      "&strns;": "¯",
      "&sub;": "⊂",
      "&subE;": "⫅",
      "&subdot;": "⪽",
      "&sube;": "⊆",
      "&subedot;": "⫃",
      "&submult;": "⫁",
      "&subnE;": "⫋",
      "&subne;": "⊊",
      "&subplus;": "⪿",
      "&subrarr;": "⥹",
      "&subset;": "⊂",
      "&subseteq;": "⊆",
      "&subseteqq;": "⫅",
      "&subsetneq;": "⊊",
      "&subsetneqq;": "⫋",
      "&subsim;": "⫇",
      "&subsub;": "⫕",
      "&subsup;": "⫓",
      "&succ;": "≻",
      "&succapprox;": "⪸",
      "&succcurlyeq;": "≽",
      "&succeq;": "⪰",
      "&succnapprox;": "⪺",
      "&succneqq;": "⪶",
      "&succnsim;": "⋩",
      "&succsim;": "≿",
      "&sum;": "∑",
      "&sung;": "♪",
      "&sup1": "¹",
      "&sup1;": "¹",
      "&sup2": "²",
      "&sup2;": "²",
      "&sup3": "³",
      "&sup3;": "³",
      "&sup;": "⊃",
      "&supE;": "⫆",
      "&supdot;": "⪾",
      "&supdsub;": "⫘",
      "&supe;": "⊇",
      "&supedot;": "⫄",
      "&suphsol;": "⟉",
      "&suphsub;": "⫗",
      "&suplarr;": "⥻",
      "&supmult;": "⫂",
      "&supnE;": "⫌",
      "&supne;": "⊋",
      "&supplus;": "⫀",
      "&supset;": "⊃",
      "&supseteq;": "⊇",
      "&supseteqq;": "⫆",
      "&supsetneq;": "⊋",
      "&supsetneqq;": "⫌",
      "&supsim;": "⫈",
      "&supsub;": "⫔",
      "&supsup;": "⫖",
      "&swArr;": "⇙",
      "&swarhk;": "⤦",
      "&swarr;": "↙",
      "&swarrow;": "↙",
      "&swnwar;": "⤪",
      "&szlig": "ß",
      "&szlig;": "ß",
      "&target;": "⌖",
      "&tau;": "τ",
      "&tbrk;": "⎴",
      "&tcaron;": "ť",
      "&tcedil;": "ţ",
      "&tcy;": "т",
      "&tdot;": "⃛",
      "&telrec;": "⌕",
      "&tfr;": "𝔱",
      "&there4;": "∴",
      "&therefore;": "∴",
      "&theta;": "θ",
      "&thetasym;": "ϑ",
      "&thetav;": "ϑ",
      "&thickapprox;": "≈",
      "&thicksim;": "∼",
      "&thinsp;": " ",
      "&thkap;": "≈",
      "&thksim;": "∼",
      "&thorn": "þ",
      "&thorn;": "þ",
      "&tilde;": "˜",
      "&times": "×",
      "&times;": "×",
      "&timesb;": "⊠",
      "&timesbar;": "⨱",
      "&timesd;": "⨰",
      "&tint;": "∭",
      "&toea;": "⤨",
      "&top;": "⊤",
      "&topbot;": "⌶",
      "&topcir;": "⫱",
      "&topf;": "𝕥",
      "&topfork;": "⫚",
      "&tosa;": "⤩",
      "&tprime;": "‴",
      "&trade;": "™",
      "&triangle;": "▵",
      "&triangledown;": "▿",
      "&triangleleft;": "◃",
      "&trianglelefteq;": "⊴",
      "&triangleq;": "≜",
      "&triangleright;": "▹",
      "&trianglerighteq;": "⊵",
      "&tridot;": "◬",
      "&trie;": "≜",
      "&triminus;": "⨺",
      "&triplus;": "⨹",
      "&trisb;": "⧍",
      "&tritime;": "⨻",
      "&trpezium;": "⏢",
      "&tscr;": "𝓉",
      "&tscy;": "ц",
      "&tshcy;": "ћ",
      "&tstrok;": "ŧ",
      "&twixt;": "≬",
      "&twoheadleftarrow;": "↞",
      "&twoheadrightarrow;": "↠",
      "&uArr;": "⇑",
      "&uHar;": "⥣",
      "&uacute": "ú",
      "&uacute;": "ú",
      "&uarr;": "↑",
      "&ubrcy;": "ў",
      "&ubreve;": "ŭ",
      "&ucirc": "û",
      "&ucirc;": "û",
      "&ucy;": "у",
      "&udarr;": "⇅",
      "&udblac;": "ű",
      "&udhar;": "⥮",
      "&ufisht;": "⥾",
      "&ufr;": "𝔲",
      "&ugrave": "ù",
      "&ugrave;": "ù",
      "&uharl;": "↿",
      "&uharr;": "↾",
      "&uhblk;": "▀",
      "&ulcorn;": "⌜",
      "&ulcorner;": "⌜",
      "&ulcrop;": "⌏",
      "&ultri;": "◸",
      "&umacr;": "ū",
      "&uml": "¨",
      "&uml;": "¨",
      "&uogon;": "ų",
      "&uopf;": "𝕦",
      "&uparrow;": "↑",
      "&updownarrow;": "↕",
      "&upharpoonleft;": "↿",
      "&upharpoonright;": "↾",
      "&uplus;": "⊎",
      "&upsi;": "υ",
      "&upsih;": "ϒ",
      "&upsilon;": "υ",
      "&upuparrows;": "⇈",
      "&urcorn;": "⌝",
      "&urcorner;": "⌝",
      "&urcrop;": "⌎",
      "&uring;": "ů",
      "&urtri;": "◹",
      "&uscr;": "𝓊",
      "&utdot;": "⋰",
      "&utilde;": "ũ",
      "&utri;": "▵",
      "&utrif;": "▴",
      "&uuarr;": "⇈",
      "&uuml": "ü",
      "&uuml;": "ü",
      "&uwangle;": "⦧",
      "&vArr;": "⇕",
      "&vBar;": "⫨",
      "&vBarv;": "⫩",
      "&vDash;": "⊨",
      "&vangrt;": "⦜",
      "&varepsilon;": "ϵ",
      "&varkappa;": "ϰ",
      "&varnothing;": "∅",
      "&varphi;": "ϕ",
      "&varpi;": "ϖ",
      "&varpropto;": "∝",
      "&varr;": "↕",
      "&varrho;": "ϱ",
      "&varsigma;": "ς",
      "&varsubsetneq;": "⊊︀",
      "&varsubsetneqq;": "⫋︀",
      "&varsupsetneq;": "⊋︀",
      "&varsupsetneqq;": "⫌︀",
      "&vartheta;": "ϑ",
      "&vartriangleleft;": "⊲",
      "&vartriangleright;": "⊳",
      "&vcy;": "в",
      "&vdash;": "⊢",
      "&vee;": "∨",
      "&veebar;": "⊻",
      "&veeeq;": "≚",
      "&vellip;": "⋮",
      "&verbar;": "|",
      "&vert;": "|",
      "&vfr;": "𝔳",
      "&vltri;": "⊲",
      "&vnsub;": "⊂⃒",
      "&vnsup;": "⊃⃒",
      "&vopf;": "𝕧",
      "&vprop;": "∝",
      "&vrtri;": "⊳",
      "&vscr;": "𝓋",
      "&vsubnE;": "⫋︀",
      "&vsubne;": "⊊︀",
      "&vsupnE;": "⫌︀",
      "&vsupne;": "⊋︀",
      "&vzigzag;": "⦚",
      "&wcirc;": "ŵ",
      "&wedbar;": "⩟",
      "&wedge;": "∧",
      "&wedgeq;": "≙",
      "&weierp;": "℘",
      "&wfr;": "𝔴",
      "&wopf;": "𝕨",
      "&wp;": "℘",
      "&wr;": "≀",
      "&wreath;": "≀",
      "&wscr;": "𝓌",
      "&xcap;": "⋂",
      "&xcirc;": "◯",
      "&xcup;": "⋃",
      "&xdtri;": "▽",
      "&xfr;": "𝔵",
      "&xhArr;": "⟺",
      "&xharr;": "⟷",
      "&xi;": "ξ",
      "&xlArr;": "⟸",
      "&xlarr;": "⟵",
      "&xmap;": "⟼",
      "&xnis;": "⋻",
      "&xodot;": "⨀",
      "&xopf;": "𝕩",
      "&xoplus;": "⨁",
      "&xotime;": "⨂",
      "&xrArr;": "⟹",
      "&xrarr;": "⟶",
      "&xscr;": "𝓍",
      "&xsqcup;": "⨆",
      "&xuplus;": "⨄",
      "&xutri;": "△",
      "&xvee;": "⋁",
      "&xwedge;": "⋀",
      "&yacute": "ý",
      "&yacute;": "ý",
      "&yacy;": "я",
      "&ycirc;": "ŷ",
      "&ycy;": "ы",
      "&yen": "¥",
      "&yen;": "¥",
      "&yfr;": "𝔶",
      "&yicy;": "ї",
      "&yopf;": "𝕪",
      "&yscr;": "𝓎",
      "&yucy;": "ю",
      "&yuml": "ÿ",
      "&yuml;": "ÿ",
      "&zacute;": "ź",
      "&zcaron;": "ž",
      "&zcy;": "з",
      "&zdot;": "ż",
      "&zeetrf;": "ℨ",
      "&zeta;": "ζ",
      "&zfr;": "𝔷",
      "&zhcy;": "ж",
      "&zigrarr;": "⇝",
      "&zopf;": "𝕫",
      "&zscr;": "𝓏",
      "&zwj;": "‍",
      "&zwnj;": "‌"
    },
    characters: {
      "Æ": "&AElig;",
      "&": "&amp;",
      "Á": "&Aacute;",
      "Ă": "&Abreve;",
      "Â": "&Acirc;",
      "А": "&Acy;",
      "𝔄": "&Afr;",
      "À": "&Agrave;",
      "Α": "&Alpha;",
      "Ā": "&Amacr;",
      "⩓": "&And;",
      "Ą": "&Aogon;",
      "𝔸": "&Aopf;",
      "⁡": "&af;",
      "Å": "&angst;",
      "𝒜": "&Ascr;",
      "≔": "&coloneq;",
      "Ã": "&Atilde;",
      "Ä": "&Auml;",
      "∖": "&ssetmn;",
      "⫧": "&Barv;",
      "⌆": "&doublebarwedge;",
      "Б": "&Bcy;",
      "∵": "&because;",
      "ℬ": "&bernou;",
      "Β": "&Beta;",
      "𝔅": "&Bfr;",
      "𝔹": "&Bopf;",
      "˘": "&breve;",
      "≎": "&bump;",
      "Ч": "&CHcy;",
      "©": "&copy;",
      "Ć": "&Cacute;",
      "⋒": "&Cap;",
      "ⅅ": "&DD;",
      "ℭ": "&Cfr;",
      "Č": "&Ccaron;",
      "Ç": "&Ccedil;",
      "Ĉ": "&Ccirc;",
      "∰": "&Cconint;",
      "Ċ": "&Cdot;",
      "¸": "&cedil;",
      "·": "&middot;",
      "Χ": "&Chi;",
      "⊙": "&odot;",
      "⊖": "&ominus;",
      "⊕": "&oplus;",
      "⊗": "&otimes;",
      "∲": "&cwconint;",
      "”": "&rdquor;",
      "’": "&rsquor;",
      "∷": "&Proportion;",
      "⩴": "&Colone;",
      "≡": "&equiv;",
      "∯": "&DoubleContourIntegral;",
      "∮": "&oint;",
      "ℂ": "&complexes;",
      "∐": "&coprod;",
      "∳": "&awconint;",
      "⨯": "&Cross;",
      "𝒞": "&Cscr;",
      "⋓": "&Cup;",
      "≍": "&asympeq;",
      "⤑": "&DDotrahd;",
      "Ђ": "&DJcy;",
      "Ѕ": "&DScy;",
      "Џ": "&DZcy;",
      "‡": "&ddagger;",
      "↡": "&Darr;",
      "⫤": "&DoubleLeftTee;",
      "Ď": "&Dcaron;",
      "Д": "&Dcy;",
      "∇": "&nabla;",
      "Δ": "&Delta;",
      "𝔇": "&Dfr;",
      "´": "&acute;",
      "˙": "&dot;",
      "˝": "&dblac;",
      "`": "&grave;",
      "˜": "&tilde;",
      "⋄": "&diamond;",
      "ⅆ": "&dd;",
      "𝔻": "&Dopf;",
      "¨": "&uml;",
      "⃜": "&DotDot;",
      "≐": "&esdot;",
      "⇓": "&dArr;",
      "⇐": "&lArr;",
      "⇔": "&iff;",
      "⟸": "&xlArr;",
      "⟺": "&xhArr;",
      "⟹": "&xrArr;",
      "⇒": "&rArr;",
      "⊨": "&vDash;",
      "⇑": "&uArr;",
      "⇕": "&vArr;",
      "∥": "&spar;",
      "↓": "&downarrow;",
      "⤓": "&DownArrowBar;",
      "⇵": "&duarr;",
      "̑": "&DownBreve;",
      "⥐": "&DownLeftRightVector;",
      "⥞": "&DownLeftTeeVector;",
      "↽": "&lhard;",
      "⥖": "&DownLeftVectorBar;",
      "⥟": "&DownRightTeeVector;",
      "⇁": "&rightharpoondown;",
      "⥗": "&DownRightVectorBar;",
      "⊤": "&top;",
      "↧": "&mapstodown;",
      "𝒟": "&Dscr;",
      "Đ": "&Dstrok;",
      "Ŋ": "&ENG;",
      "Ð": "&ETH;",
      "É": "&Eacute;",
      "Ě": "&Ecaron;",
      "Ê": "&Ecirc;",
      "Э": "&Ecy;",
      "Ė": "&Edot;",
      "𝔈": "&Efr;",
      "È": "&Egrave;",
      "∈": "&isinv;",
      "Ē": "&Emacr;",
      "◻": "&EmptySmallSquare;",
      "▫": "&EmptyVerySmallSquare;",
      "Ę": "&Eogon;",
      "𝔼": "&Eopf;",
      "Ε": "&Epsilon;",
      "⩵": "&Equal;",
      "≂": "&esim;",
      "⇌": "&rlhar;",
      "ℰ": "&expectation;",
      "⩳": "&Esim;",
      "Η": "&Eta;",
      "Ë": "&Euml;",
      "∃": "&exist;",
      "ⅇ": "&exponentiale;",
      "Ф": "&Fcy;",
      "𝔉": "&Ffr;",
      "◼": "&FilledSmallSquare;",
      "▪": "&squf;",
      "𝔽": "&Fopf;",
      "∀": "&forall;",
      "ℱ": "&Fscr;",
      "Ѓ": "&GJcy;",
      ">": "&gt;",
      "Γ": "&Gamma;",
      "Ϝ": "&Gammad;",
      "Ğ": "&Gbreve;",
      "Ģ": "&Gcedil;",
      "Ĝ": "&Gcirc;",
      "Г": "&Gcy;",
      "Ġ": "&Gdot;",
      "𝔊": "&Gfr;",
      "⋙": "&ggg;",
      "𝔾": "&Gopf;",
      "≥": "&geq;",
      "⋛": "&gtreqless;",
      "≧": "&geqq;",
      "⪢": "&GreaterGreater;",
      "≷": "&gtrless;",
      "⩾": "&ges;",
      "≳": "&gtrsim;",
      "𝒢": "&Gscr;",
      "≫": "&gg;",
      "Ъ": "&HARDcy;",
      "ˇ": "&caron;",
      "^": "&Hat;",
      "Ĥ": "&Hcirc;",
      "ℌ": "&Poincareplane;",
      "ℋ": "&hamilt;",
      "ℍ": "&quaternions;",
      "─": "&boxh;",
      "Ħ": "&Hstrok;",
      "≏": "&bumpeq;",
      "Е": "&IEcy;",
      "Ĳ": "&IJlig;",
      "Ё": "&IOcy;",
      "Í": "&Iacute;",
      "Î": "&Icirc;",
      "И": "&Icy;",
      "İ": "&Idot;",
      "ℑ": "&imagpart;",
      "Ì": "&Igrave;",
      "Ī": "&Imacr;",
      "ⅈ": "&ii;",
      "∬": "&Int;",
      "∫": "&int;",
      "⋂": "&xcap;",
      "⁣": "&ic;",
      "⁢": "&it;",
      "Į": "&Iogon;",
      "𝕀": "&Iopf;",
      "Ι": "&Iota;",
      "ℐ": "&imagline;",
      "Ĩ": "&Itilde;",
      "І": "&Iukcy;",
      "Ï": "&Iuml;",
      "Ĵ": "&Jcirc;",
      "Й": "&Jcy;",
      "𝔍": "&Jfr;",
      "𝕁": "&Jopf;",
      "𝒥": "&Jscr;",
      "Ј": "&Jsercy;",
      "Є": "&Jukcy;",
      "Х": "&KHcy;",
      "Ќ": "&KJcy;",
      "Κ": "&Kappa;",
      "Ķ": "&Kcedil;",
      "К": "&Kcy;",
      "𝔎": "&Kfr;",
      "𝕂": "&Kopf;",
      "𝒦": "&Kscr;",
      "Љ": "&LJcy;",
      "<": "&lt;",
      "Ĺ": "&Lacute;",
      "Λ": "&Lambda;",
      "⟪": "&Lang;",
      "ℒ": "&lagran;",
      "↞": "&twoheadleftarrow;",
      "Ľ": "&Lcaron;",
      "Ļ": "&Lcedil;",
      "Л": "&Lcy;",
      "⟨": "&langle;",
      "←": "&slarr;",
      "⇤": "&larrb;",
      "⇆": "&lrarr;",
      "⌈": "&lceil;",
      "⟦": "&lobrk;",
      "⥡": "&LeftDownTeeVector;",
      "⇃": "&downharpoonleft;",
      "⥙": "&LeftDownVectorBar;",
      "⌊": "&lfloor;",
      "↔": "&leftrightarrow;",
      "⥎": "&LeftRightVector;",
      "⊣": "&dashv;",
      "↤": "&mapstoleft;",
      "⥚": "&LeftTeeVector;",
      "⊲": "&vltri;",
      "⧏": "&LeftTriangleBar;",
      "⊴": "&trianglelefteq;",
      "⥑": "&LeftUpDownVector;",
      "⥠": "&LeftUpTeeVector;",
      "↿": "&upharpoonleft;",
      "⥘": "&LeftUpVectorBar;",
      "↼": "&lharu;",
      "⥒": "&LeftVectorBar;",
      "⋚": "&lesseqgtr;",
      "≦": "&leqq;",
      "≶": "&lg;",
      "⪡": "&LessLess;",
      "⩽": "&les;",
      "≲": "&lsim;",
      "𝔏": "&Lfr;",
      "⋘": "&Ll;",
      "⇚": "&lAarr;",
      "Ŀ": "&Lmidot;",
      "⟵": "&xlarr;",
      "⟷": "&xharr;",
      "⟶": "&xrarr;",
      "𝕃": "&Lopf;",
      "↙": "&swarrow;",
      "↘": "&searrow;",
      "↰": "&lsh;",
      "Ł": "&Lstrok;",
      "≪": "&ll;",
      "⤅": "&Map;",
      "М": "&Mcy;",
      " ": "&MediumSpace;",
      "ℳ": "&phmmat;",
      "𝔐": "&Mfr;",
      "∓": "&mp;",
      "𝕄": "&Mopf;",
      "Μ": "&Mu;",
      "Њ": "&NJcy;",
      "Ń": "&Nacute;",
      "Ň": "&Ncaron;",
      "Ņ": "&Ncedil;",
      "Н": "&Ncy;",
      "​": "&ZeroWidthSpace;",
      "\n": "&NewLine;",
      "𝔑": "&Nfr;",
      "⁠": "&NoBreak;",
      " ": "&nbsp;",
      "ℕ": "&naturals;",
      "⫬": "&Not;",
      "≢": "&nequiv;",
      "≭": "&NotCupCap;",
      "∦": "&nspar;",
      "∉": "&notinva;",
      "≠": "&ne;",
      "≂̸": "&nesim;",
      "∄": "&nexists;",
      "≯": "&ngtr;",
      "≱": "&ngeq;",
      "≧̸": "&ngeqq;",
      "≫̸": "&nGtv;",
      "≹": "&ntgl;",
      "⩾̸": "&nges;",
      "≵": "&ngsim;",
      "≎̸": "&nbump;",
      "≏̸": "&nbumpe;",
      "⋪": "&ntriangleleft;",
      "⧏̸": "&NotLeftTriangleBar;",
      "⋬": "&ntrianglelefteq;",
      "≮": "&nlt;",
      "≰": "&nleq;",
      "≸": "&ntlg;",
      "≪̸": "&nLtv;",
      "⩽̸": "&nles;",
      "≴": "&nlsim;",
      "⪢̸": "&NotNestedGreaterGreater;",
      "⪡̸": "&NotNestedLessLess;",
      "⊀": "&nprec;",
      "⪯̸": "&npreceq;",
      "⋠": "&nprcue;",
      "∌": "&notniva;",
      "⋫": "&ntriangleright;",
      "⧐̸": "&NotRightTriangleBar;",
      "⋭": "&ntrianglerighteq;",
      "⊏̸": "&NotSquareSubset;",
      "⋢": "&nsqsube;",
      "⊐̸": "&NotSquareSuperset;",
      "⋣": "&nsqsupe;",
      "⊂⃒": "&vnsub;",
      "⊈": "&nsubseteq;",
      "⊁": "&nsucc;",
      "⪰̸": "&nsucceq;",
      "⋡": "&nsccue;",
      "≿̸": "&NotSucceedsTilde;",
      "⊃⃒": "&vnsup;",
      "⊉": "&nsupseteq;",
      "≁": "&nsim;",
      "≄": "&nsimeq;",
      "≇": "&ncong;",
      "≉": "&napprox;",
      "∤": "&nsmid;",
      "𝒩": "&Nscr;",
      "Ñ": "&Ntilde;",
      "Ν": "&Nu;",
      "Œ": "&OElig;",
      "Ó": "&Oacute;",
      "Ô": "&Ocirc;",
      "О": "&Ocy;",
      "Ő": "&Odblac;",
      "𝔒": "&Ofr;",
      "Ò": "&Ograve;",
      "Ō": "&Omacr;",
      "Ω": "&ohm;",
      "Ο": "&Omicron;",
      "𝕆": "&Oopf;",
      "“": "&ldquo;",
      "‘": "&lsquo;",
      "⩔": "&Or;",
      "𝒪": "&Oscr;",
      "Ø": "&Oslash;",
      "Õ": "&Otilde;",
      "⨷": "&Otimes;",
      "Ö": "&Ouml;",
      "‾": "&oline;",
      "⏞": "&OverBrace;",
      "⎴": "&tbrk;",
      "⏜": "&OverParenthesis;",
      "∂": "&part;",
      "П": "&Pcy;",
      "𝔓": "&Pfr;",
      "Φ": "&Phi;",
      "Π": "&Pi;",
      "±": "&pm;",
      "ℙ": "&primes;",
      "⪻": "&Pr;",
      "≺": "&prec;",
      "⪯": "&preceq;",
      "≼": "&preccurlyeq;",
      "≾": "&prsim;",
      "″": "&Prime;",
      "∏": "&prod;",
      "∝": "&vprop;",
      "𝒫": "&Pscr;",
      "Ψ": "&Psi;",
      '"': "&quot;",
      "𝔔": "&Qfr;",
      "ℚ": "&rationals;",
      "𝒬": "&Qscr;",
      "⤐": "&drbkarow;",
      "®": "&reg;",
      "Ŕ": "&Racute;",
      "⟫": "&Rang;",
      "↠": "&twoheadrightarrow;",
      "⤖": "&Rarrtl;",
      "Ř": "&Rcaron;",
      "Ŗ": "&Rcedil;",
      "Р": "&Rcy;",
      "ℜ": "&realpart;",
      "∋": "&niv;",
      "⇋": "&lrhar;",
      "⥯": "&duhar;",
      "Ρ": "&Rho;",
      "⟩": "&rangle;",
      "→": "&srarr;",
      "⇥": "&rarrb;",
      "⇄": "&rlarr;",
      "⌉": "&rceil;",
      "⟧": "&robrk;",
      "⥝": "&RightDownTeeVector;",
      "⇂": "&downharpoonright;",
      "⥕": "&RightDownVectorBar;",
      "⌋": "&rfloor;",
      "⊢": "&vdash;",
      "↦": "&mapsto;",
      "⥛": "&RightTeeVector;",
      "⊳": "&vrtri;",
      "⧐": "&RightTriangleBar;",
      "⊵": "&trianglerighteq;",
      "⥏": "&RightUpDownVector;",
      "⥜": "&RightUpTeeVector;",
      "↾": "&upharpoonright;",
      "⥔": "&RightUpVectorBar;",
      "⇀": "&rightharpoonup;",
      "⥓": "&RightVectorBar;",
      "ℝ": "&reals;",
      "⥰": "&RoundImplies;",
      "⇛": "&rAarr;",
      "ℛ": "&realine;",
      "↱": "&rsh;",
      "⧴": "&RuleDelayed;",
      "Щ": "&SHCHcy;",
      "Ш": "&SHcy;",
      "Ь": "&SOFTcy;",
      "Ś": "&Sacute;",
      "⪼": "&Sc;",
      "Š": "&Scaron;",
      "Ş": "&Scedil;",
      "Ŝ": "&Scirc;",
      "С": "&Scy;",
      "𝔖": "&Sfr;",
      "↑": "&uparrow;",
      "Σ": "&Sigma;",
      "∘": "&compfn;",
      "𝕊": "&Sopf;",
      "√": "&radic;",
      "□": "&square;",
      "⊓": "&sqcap;",
      "⊏": "&sqsubset;",
      "⊑": "&sqsubseteq;",
      "⊐": "&sqsupset;",
      "⊒": "&sqsupseteq;",
      "⊔": "&sqcup;",
      "𝒮": "&Sscr;",
      "⋆": "&sstarf;",
      "⋐": "&Subset;",
      "⊆": "&subseteq;",
      "≻": "&succ;",
      "⪰": "&succeq;",
      "≽": "&succcurlyeq;",
      "≿": "&succsim;",
      "∑": "&sum;",
      "⋑": "&Supset;",
      "⊃": "&supset;",
      "⊇": "&supseteq;",
      "Þ": "&THORN;",
      "™": "&trade;",
      "Ћ": "&TSHcy;",
      "Ц": "&TScy;",
      "\t": "&Tab;",
      "Τ": "&Tau;",
      "Ť": "&Tcaron;",
      "Ţ": "&Tcedil;",
      "Т": "&Tcy;",
      "𝔗": "&Tfr;",
      "∴": "&therefore;",
      "Θ": "&Theta;",
      "  ": "&ThickSpace;",
      " ": "&thinsp;",
      "∼": "&thksim;",
      "≃": "&simeq;",
      "≅": "&cong;",
      "≈": "&thkap;",
      "𝕋": "&Topf;",
      "⃛": "&tdot;",
      "𝒯": "&Tscr;",
      "Ŧ": "&Tstrok;",
      "Ú": "&Uacute;",
      "↟": "&Uarr;",
      "⥉": "&Uarrocir;",
      "Ў": "&Ubrcy;",
      "Ŭ": "&Ubreve;",
      "Û": "&Ucirc;",
      "У": "&Ucy;",
      "Ű": "&Udblac;",
      "𝔘": "&Ufr;",
      "Ù": "&Ugrave;",
      "Ū": "&Umacr;",
      _: "&lowbar;",
      "⏟": "&UnderBrace;",
      "⎵": "&bbrk;",
      "⏝": "&UnderParenthesis;",
      "⋃": "&xcup;",
      "⊎": "&uplus;",
      "Ų": "&Uogon;",
      "𝕌": "&Uopf;",
      "⤒": "&UpArrowBar;",
      "⇅": "&udarr;",
      "↕": "&varr;",
      "⥮": "&udhar;",
      "⊥": "&perp;",
      "↥": "&mapstoup;",
      "↖": "&nwarrow;",
      "↗": "&nearrow;",
      "ϒ": "&upsih;",
      "Υ": "&Upsilon;",
      "Ů": "&Uring;",
      "𝒰": "&Uscr;",
      "Ũ": "&Utilde;",
      "Ü": "&Uuml;",
      "⊫": "&VDash;",
      "⫫": "&Vbar;",
      "В": "&Vcy;",
      "⊩": "&Vdash;",
      "⫦": "&Vdashl;",
      "⋁": "&xvee;",
      "‖": "&Vert;",
      "∣": "&smid;",
      "|": "&vert;",
      "❘": "&VerticalSeparator;",
      "≀": "&wreath;",
      " ": "&hairsp;",
      "𝔙": "&Vfr;",
      "𝕍": "&Vopf;",
      "𝒱": "&Vscr;",
      "⊪": "&Vvdash;",
      "Ŵ": "&Wcirc;",
      "⋀": "&xwedge;",
      "𝔚": "&Wfr;",
      "𝕎": "&Wopf;",
      "𝒲": "&Wscr;",
      "𝔛": "&Xfr;",
      "Ξ": "&Xi;",
      "𝕏": "&Xopf;",
      "𝒳": "&Xscr;",
      "Я": "&YAcy;",
      "Ї": "&YIcy;",
      "Ю": "&YUcy;",
      "Ý": "&Yacute;",
      "Ŷ": "&Ycirc;",
      "Ы": "&Ycy;",
      "𝔜": "&Yfr;",
      "𝕐": "&Yopf;",
      "𝒴": "&Yscr;",
      "Ÿ": "&Yuml;",
      "Ж": "&ZHcy;",
      "Ź": "&Zacute;",
      "Ž": "&Zcaron;",
      "З": "&Zcy;",
      "Ż": "&Zdot;",
      "Ζ": "&Zeta;",
      "ℨ": "&zeetrf;",
      "ℤ": "&integers;",
      "𝒵": "&Zscr;",
      "á": "&aacute;",
      "ă": "&abreve;",
      "∾": "&mstpos;",
      "∾̳": "&acE;",
      "∿": "&acd;",
      "â": "&acirc;",
      "а": "&acy;",
      "æ": "&aelig;",
      "𝔞": "&afr;",
      "à": "&agrave;",
      "ℵ": "&aleph;",
      "α": "&alpha;",
      "ā": "&amacr;",
      "⨿": "&amalg;",
      "∧": "&wedge;",
      "⩕": "&andand;",
      "⩜": "&andd;",
      "⩘": "&andslope;",
      "⩚": "&andv;",
      "∠": "&angle;",
      "⦤": "&ange;",
      "∡": "&measuredangle;",
      "⦨": "&angmsdaa;",
      "⦩": "&angmsdab;",
      "⦪": "&angmsdac;",
      "⦫": "&angmsdad;",
      "⦬": "&angmsdae;",
      "⦭": "&angmsdaf;",
      "⦮": "&angmsdag;",
      "⦯": "&angmsdah;",
      "∟": "&angrt;",
      "⊾": "&angrtvb;",
      "⦝": "&angrtvbd;",
      "∢": "&angsph;",
      "⍼": "&angzarr;",
      "ą": "&aogon;",
      "𝕒": "&aopf;",
      "⩰": "&apE;",
      "⩯": "&apacir;",
      "≊": "&approxeq;",
      "≋": "&apid;",
      "'": "&apos;",
      "å": "&aring;",
      "𝒶": "&ascr;",
      "*": "&midast;",
      "ã": "&atilde;",
      "ä": "&auml;",
      "⨑": "&awint;",
      "⫭": "&bNot;",
      "≌": "&bcong;",
      "϶": "&bepsi;",
      "‵": "&bprime;",
      "∽": "&bsim;",
      "⋍": "&bsime;",
      "⊽": "&barvee;",
      "⌅": "&barwedge;",
      "⎶": "&bbrktbrk;",
      "б": "&bcy;",
      "„": "&ldquor;",
      "⦰": "&bemptyv;",
      "β": "&beta;",
      "ℶ": "&beth;",
      "≬": "&twixt;",
      "𝔟": "&bfr;",
      "◯": "&xcirc;",
      "⨀": "&xodot;",
      "⨁": "&xoplus;",
      "⨂": "&xotime;",
      "⨆": "&xsqcup;",
      "★": "&starf;",
      "▽": "&xdtri;",
      "△": "&xutri;",
      "⨄": "&xuplus;",
      "⤍": "&rbarr;",
      "⧫": "&lozf;",
      "▴": "&utrif;",
      "▾": "&dtrif;",
      "◂": "&ltrif;",
      "▸": "&rtrif;",
      "␣": "&blank;",
      "▒": "&blk12;",
      "░": "&blk14;",
      "▓": "&blk34;",
      "█": "&block;",
      "=⃥": "&bne;",
      "≡⃥": "&bnequiv;",
      "⌐": "&bnot;",
      "𝕓": "&bopf;",
      "⋈": "&bowtie;",
      "╗": "&boxDL;",
      "╔": "&boxDR;",
      "╖": "&boxDl;",
      "╓": "&boxDr;",
      "═": "&boxH;",
      "╦": "&boxHD;",
      "╩": "&boxHU;",
      "╤": "&boxHd;",
      "╧": "&boxHu;",
      "╝": "&boxUL;",
      "╚": "&boxUR;",
      "╜": "&boxUl;",
      "╙": "&boxUr;",
      "║": "&boxV;",
      "╬": "&boxVH;",
      "╣": "&boxVL;",
      "╠": "&boxVR;",
      "╫": "&boxVh;",
      "╢": "&boxVl;",
      "╟": "&boxVr;",
      "⧉": "&boxbox;",
      "╕": "&boxdL;",
      "╒": "&boxdR;",
      "┐": "&boxdl;",
      "┌": "&boxdr;",
      "╥": "&boxhD;",
      "╨": "&boxhU;",
      "┬": "&boxhd;",
      "┴": "&boxhu;",
      "⊟": "&minusb;",
      "⊞": "&plusb;",
      "⊠": "&timesb;",
      "╛": "&boxuL;",
      "╘": "&boxuR;",
      "┘": "&boxul;",
      "└": "&boxur;",
      "│": "&boxv;",
      "╪": "&boxvH;",
      "╡": "&boxvL;",
      "╞": "&boxvR;",
      "┼": "&boxvh;",
      "┤": "&boxvl;",
      "├": "&boxvr;",
      "¦": "&brvbar;",
      "𝒷": "&bscr;",
      "⁏": "&bsemi;",
      "\\": "&bsol;",
      "⧅": "&bsolb;",
      "⟈": "&bsolhsub;",
      "•": "&bullet;",
      "⪮": "&bumpE;",
      "ć": "&cacute;",
      "∩": "&cap;",
      "⩄": "&capand;",
      "⩉": "&capbrcup;",
      "⩋": "&capcap;",
      "⩇": "&capcup;",
      "⩀": "&capdot;",
      "∩︀": "&caps;",
      "⁁": "&caret;",
      "⩍": "&ccaps;",
      "č": "&ccaron;",
      "ç": "&ccedil;",
      "ĉ": "&ccirc;",
      "⩌": "&ccups;",
      "⩐": "&ccupssm;",
      "ċ": "&cdot;",
      "⦲": "&cemptyv;",
      "¢": "&cent;",
      "𝔠": "&cfr;",
      "ч": "&chcy;",
      "✓": "&checkmark;",
      "χ": "&chi;",
      "○": "&cir;",
      "⧃": "&cirE;",
      "ˆ": "&circ;",
      "≗": "&cire;",
      "↺": "&olarr;",
      "↻": "&orarr;",
      "Ⓢ": "&oS;",
      "⊛": "&oast;",
      "⊚": "&ocir;",
      "⊝": "&odash;",
      "⨐": "&cirfnint;",
      "⫯": "&cirmid;",
      "⧂": "&cirscir;",
      "♣": "&clubsuit;",
      ":": "&colon;",
      ",": "&comma;",
      "@": "&commat;",
      "∁": "&complement;",
      "⩭": "&congdot;",
      "𝕔": "&copf;",
      "℗": "&copysr;",
      "↵": "&crarr;",
      "✗": "&cross;",
      "𝒸": "&cscr;",
      "⫏": "&csub;",
      "⫑": "&csube;",
      "⫐": "&csup;",
      "⫒": "&csupe;",
      "⋯": "&ctdot;",
      "⤸": "&cudarrl;",
      "⤵": "&cudarrr;",
      "⋞": "&curlyeqprec;",
      "⋟": "&curlyeqsucc;",
      "↶": "&curvearrowleft;",
      "⤽": "&cularrp;",
      "∪": "&cup;",
      "⩈": "&cupbrcap;",
      "⩆": "&cupcap;",
      "⩊": "&cupcup;",
      "⊍": "&cupdot;",
      "⩅": "&cupor;",
      "∪︀": "&cups;",
      "↷": "&curvearrowright;",
      "⤼": "&curarrm;",
      "⋎": "&cuvee;",
      "⋏": "&cuwed;",
      "¤": "&curren;",
      "∱": "&cwint;",
      "⌭": "&cylcty;",
      "⥥": "&dHar;",
      "†": "&dagger;",
      "ℸ": "&daleth;",
      "‐": "&hyphen;",
      "⤏": "&rBarr;",
      "ď": "&dcaron;",
      "д": "&dcy;",
      "⇊": "&downdownarrows;",
      "⩷": "&eDDot;",
      "°": "&deg;",
      "δ": "&delta;",
      "⦱": "&demptyv;",
      "⥿": "&dfisht;",
      "𝔡": "&dfr;",
      "♦": "&diams;",
      "ϝ": "&gammad;",
      "⋲": "&disin;",
      "÷": "&divide;",
      "⋇": "&divonx;",
      "ђ": "&djcy;",
      "⌞": "&llcorner;",
      "⌍": "&dlcrop;",
      $: "&dollar;",
      "𝕕": "&dopf;",
      "≑": "&eDot;",
      "∸": "&minusd;",
      "∔": "&plusdo;",
      "⊡": "&sdotb;",
      "⌟": "&lrcorner;",
      "⌌": "&drcrop;",
      "𝒹": "&dscr;",
      "ѕ": "&dscy;",
      "⧶": "&dsol;",
      "đ": "&dstrok;",
      "⋱": "&dtdot;",
      "▿": "&triangledown;",
      "⦦": "&dwangle;",
      "џ": "&dzcy;",
      "⟿": "&dzigrarr;",
      "é": "&eacute;",
      "⩮": "&easter;",
      "ě": "&ecaron;",
      "≖": "&eqcirc;",
      "ê": "&ecirc;",
      "≕": "&eqcolon;",
      "э": "&ecy;",
      "ė": "&edot;",
      "≒": "&fallingdotseq;",
      "𝔢": "&efr;",
      "⪚": "&eg;",
      "è": "&egrave;",
      "⪖": "&eqslantgtr;",
      "⪘": "&egsdot;",
      "⪙": "&el;",
      "⏧": "&elinters;",
      "ℓ": "&ell;",
      "⪕": "&eqslantless;",
      "⪗": "&elsdot;",
      "ē": "&emacr;",
      "∅": "&varnothing;",
      " ": "&emsp13;",
      " ": "&emsp14;",
      " ": "&emsp;",
      "ŋ": "&eng;",
      " ": "&ensp;",
      "ę": "&eogon;",
      "𝕖": "&eopf;",
      "⋕": "&epar;",
      "⧣": "&eparsl;",
      "⩱": "&eplus;",
      "ε": "&epsilon;",
      "ϵ": "&varepsilon;",
      "=": "&equals;",
      "≟": "&questeq;",
      "⩸": "&equivDD;",
      "⧥": "&eqvparsl;",
      "≓": "&risingdotseq;",
      "⥱": "&erarr;",
      "ℯ": "&escr;",
      "η": "&eta;",
      "ð": "&eth;",
      "ë": "&euml;",
      "€": "&euro;",
      "!": "&excl;",
      "ф": "&fcy;",
      "♀": "&female;",
      "ﬃ": "&ffilig;",
      "ﬀ": "&fflig;",
      "ﬄ": "&ffllig;",
      "𝔣": "&ffr;",
      "ﬁ": "&filig;",
      fj: "&fjlig;",
      "♭": "&flat;",
      "ﬂ": "&fllig;",
      "▱": "&fltns;",
      "ƒ": "&fnof;",
      "𝕗": "&fopf;",
      "⋔": "&pitchfork;",
      "⫙": "&forkv;",
      "⨍": "&fpartint;",
      "½": "&half;",
      "⅓": "&frac13;",
      "¼": "&frac14;",
      "⅕": "&frac15;",
      "⅙": "&frac16;",
      "⅛": "&frac18;",
      "⅔": "&frac23;",
      "⅖": "&frac25;",
      "¾": "&frac34;",
      "⅗": "&frac35;",
      "⅜": "&frac38;",
      "⅘": "&frac45;",
      "⅚": "&frac56;",
      "⅝": "&frac58;",
      "⅞": "&frac78;",
      "⁄": "&frasl;",
      "⌢": "&sfrown;",
      "𝒻": "&fscr;",
      "⪌": "&gtreqqless;",
      "ǵ": "&gacute;",
      "γ": "&gamma;",
      "⪆": "&gtrapprox;",
      "ğ": "&gbreve;",
      "ĝ": "&gcirc;",
      "г": "&gcy;",
      "ġ": "&gdot;",
      "⪩": "&gescc;",
      "⪀": "&gesdot;",
      "⪂": "&gesdoto;",
      "⪄": "&gesdotol;",
      "⋛︀": "&gesl;",
      "⪔": "&gesles;",
      "𝔤": "&gfr;",
      "ℷ": "&gimel;",
      "ѓ": "&gjcy;",
      "⪒": "&glE;",
      "⪥": "&gla;",
      "⪤": "&glj;",
      "≩": "&gneqq;",
      "⪊": "&gnapprox;",
      "⪈": "&gneq;",
      "⋧": "&gnsim;",
      "𝕘": "&gopf;",
      "ℊ": "&gscr;",
      "⪎": "&gsime;",
      "⪐": "&gsiml;",
      "⪧": "&gtcc;",
      "⩺": "&gtcir;",
      "⋗": "&gtrdot;",
      "⦕": "&gtlPar;",
      "⩼": "&gtquest;",
      "⥸": "&gtrarr;",
      "≩︀": "&gvnE;",
      "ъ": "&hardcy;",
      "⥈": "&harrcir;",
      "↭": "&leftrightsquigarrow;",
      "ℏ": "&plankv;",
      "ĥ": "&hcirc;",
      "♥": "&heartsuit;",
      "…": "&mldr;",
      "⊹": "&hercon;",
      "𝔥": "&hfr;",
      "⤥": "&searhk;",
      "⤦": "&swarhk;",
      "⇿": "&hoarr;",
      "∻": "&homtht;",
      "↩": "&larrhk;",
      "↪": "&rarrhk;",
      "𝕙": "&hopf;",
      "―": "&horbar;",
      "𝒽": "&hscr;",
      "ħ": "&hstrok;",
      "⁃": "&hybull;",
      "í": "&iacute;",
      "î": "&icirc;",
      "и": "&icy;",
      "е": "&iecy;",
      "¡": "&iexcl;",
      "𝔦": "&ifr;",
      "ì": "&igrave;",
      "⨌": "&qint;",
      "∭": "&tint;",
      "⧜": "&iinfin;",
      "℩": "&iiota;",
      "ĳ": "&ijlig;",
      "ī": "&imacr;",
      "ı": "&inodot;",
      "⊷": "&imof;",
      "Ƶ": "&imped;",
      "℅": "&incare;",
      "∞": "&infin;",
      "⧝": "&infintie;",
      "⊺": "&intercal;",
      "⨗": "&intlarhk;",
      "⨼": "&iprod;",
      "ё": "&iocy;",
      "į": "&iogon;",
      "𝕚": "&iopf;",
      "ι": "&iota;",
      "¿": "&iquest;",
      "𝒾": "&iscr;",
      "⋹": "&isinE;",
      "⋵": "&isindot;",
      "⋴": "&isins;",
      "⋳": "&isinsv;",
      "ĩ": "&itilde;",
      "і": "&iukcy;",
      "ï": "&iuml;",
      "ĵ": "&jcirc;",
      "й": "&jcy;",
      "𝔧": "&jfr;",
      "ȷ": "&jmath;",
      "𝕛": "&jopf;",
      "𝒿": "&jscr;",
      "ј": "&jsercy;",
      "є": "&jukcy;",
      "κ": "&kappa;",
      "ϰ": "&varkappa;",
      "ķ": "&kcedil;",
      "к": "&kcy;",
      "𝔨": "&kfr;",
      "ĸ": "&kgreen;",
      "х": "&khcy;",
      "ќ": "&kjcy;",
      "𝕜": "&kopf;",
      "𝓀": "&kscr;",
      "⤛": "&lAtail;",
      "⤎": "&lBarr;",
      "⪋": "&lesseqqgtr;",
      "⥢": "&lHar;",
      "ĺ": "&lacute;",
      "⦴": "&laemptyv;",
      "λ": "&lambda;",
      "⦑": "&langd;",
      "⪅": "&lessapprox;",
      "«": "&laquo;",
      "⤟": "&larrbfs;",
      "⤝": "&larrfs;",
      "↫": "&looparrowleft;",
      "⤹": "&larrpl;",
      "⥳": "&larrsim;",
      "↢": "&leftarrowtail;",
      "⪫": "&lat;",
      "⤙": "&latail;",
      "⪭": "&late;",
      "⪭︀": "&lates;",
      "⤌": "&lbarr;",
      "❲": "&lbbrk;",
      "{": "&lcub;",
      "[": "&lsqb;",
      "⦋": "&lbrke;",
      "⦏": "&lbrksld;",
      "⦍": "&lbrkslu;",
      "ľ": "&lcaron;",
      "ļ": "&lcedil;",
      "л": "&lcy;",
      "⤶": "&ldca;",
      "⥧": "&ldrdhar;",
      "⥋": "&ldrushar;",
      "↲": "&ldsh;",
      "≤": "&leq;",
      "⇇": "&llarr;",
      "⋋": "&lthree;",
      "⪨": "&lescc;",
      "⩿": "&lesdot;",
      "⪁": "&lesdoto;",
      "⪃": "&lesdotor;",
      "⋚︀": "&lesg;",
      "⪓": "&lesges;",
      "⋖": "&ltdot;",
      "⥼": "&lfisht;",
      "𝔩": "&lfr;",
      "⪑": "&lgE;",
      "⥪": "&lharul;",
      "▄": "&lhblk;",
      "љ": "&ljcy;",
      "⥫": "&llhard;",
      "◺": "&lltri;",
      "ŀ": "&lmidot;",
      "⎰": "&lmoustache;",
      "≨": "&lneqq;",
      "⪉": "&lnapprox;",
      "⪇": "&lneq;",
      "⋦": "&lnsim;",
      "⟬": "&loang;",
      "⇽": "&loarr;",
      "⟼": "&xmap;",
      "↬": "&rarrlp;",
      "⦅": "&lopar;",
      "𝕝": "&lopf;",
      "⨭": "&loplus;",
      "⨴": "&lotimes;",
      "∗": "&lowast;",
      "◊": "&lozenge;",
      "(": "&lpar;",
      "⦓": "&lparlt;",
      "⥭": "&lrhard;",
      "‎": "&lrm;",
      "⊿": "&lrtri;",
      "‹": "&lsaquo;",
      "𝓁": "&lscr;",
      "⪍": "&lsime;",
      "⪏": "&lsimg;",
      "‚": "&sbquo;",
      "ł": "&lstrok;",
      "⪦": "&ltcc;",
      "⩹": "&ltcir;",
      "⋉": "&ltimes;",
      "⥶": "&ltlarr;",
      "⩻": "&ltquest;",
      "⦖": "&ltrPar;",
      "◃": "&triangleleft;",
      "⥊": "&lurdshar;",
      "⥦": "&luruhar;",
      "≨︀": "&lvnE;",
      "∺": "&mDDot;",
      "¯": "&strns;",
      "♂": "&male;",
      "✠": "&maltese;",
      "▮": "&marker;",
      "⨩": "&mcomma;",
      "м": "&mcy;",
      "—": "&mdash;",
      "𝔪": "&mfr;",
      "℧": "&mho;",
      "µ": "&micro;",
      "⫰": "&midcir;",
      "−": "&minus;",
      "⨪": "&minusdu;",
      "⫛": "&mlcp;",
      "⊧": "&models;",
      "𝕞": "&mopf;",
      "𝓂": "&mscr;",
      "μ": "&mu;",
      "⊸": "&mumap;",
      "⋙̸": "&nGg;",
      "≫⃒": "&nGt;",
      "⇍": "&nlArr;",
      "⇎": "&nhArr;",
      "⋘̸": "&nLl;",
      "≪⃒": "&nLt;",
      "⇏": "&nrArr;",
      "⊯": "&nVDash;",
      "⊮": "&nVdash;",
      "ń": "&nacute;",
      "∠⃒": "&nang;",
      "⩰̸": "&napE;",
      "≋̸": "&napid;",
      "ŉ": "&napos;",
      "♮": "&natural;",
      "⩃": "&ncap;",
      "ň": "&ncaron;",
      "ņ": "&ncedil;",
      "⩭̸": "&ncongdot;",
      "⩂": "&ncup;",
      "н": "&ncy;",
      "–": "&ndash;",
      "⇗": "&neArr;",
      "⤤": "&nearhk;",
      "≐̸": "&nedot;",
      "⤨": "&toea;",
      "𝔫": "&nfr;",
      "↮": "&nleftrightarrow;",
      "⫲": "&nhpar;",
      "⋼": "&nis;",
      "⋺": "&nisd;",
      "њ": "&njcy;",
      "≦̸": "&nleqq;",
      "↚": "&nleftarrow;",
      "‥": "&nldr;",
      "𝕟": "&nopf;",
      "¬": "&not;",
      "⋹̸": "&notinE;",
      "⋵̸": "&notindot;",
      "⋷": "&notinvb;",
      "⋶": "&notinvc;",
      "⋾": "&notnivb;",
      "⋽": "&notnivc;",
      "⫽⃥": "&nparsl;",
      "∂̸": "&npart;",
      "⨔": "&npolint;",
      "↛": "&nrightarrow;",
      "⤳̸": "&nrarrc;",
      "↝̸": "&nrarrw;",
      "𝓃": "&nscr;",
      "⊄": "&nsub;",
      "⫅̸": "&nsubseteqq;",
      "⊅": "&nsup;",
      "⫆̸": "&nsupseteqq;",
      "ñ": "&ntilde;",
      "ν": "&nu;",
      "#": "&num;",
      "№": "&numero;",
      " ": "&numsp;",
      "⊭": "&nvDash;",
      "⤄": "&nvHarr;",
      "≍⃒": "&nvap;",
      "⊬": "&nvdash;",
      "≥⃒": "&nvge;",
      ">⃒": "&nvgt;",
      "⧞": "&nvinfin;",
      "⤂": "&nvlArr;",
      "≤⃒": "&nvle;",
      "<⃒": "&nvlt;",
      "⊴⃒": "&nvltrie;",
      "⤃": "&nvrArr;",
      "⊵⃒": "&nvrtrie;",
      "∼⃒": "&nvsim;",
      "⇖": "&nwArr;",
      "⤣": "&nwarhk;",
      "⤧": "&nwnear;",
      "ó": "&oacute;",
      "ô": "&ocirc;",
      "о": "&ocy;",
      "ő": "&odblac;",
      "⨸": "&odiv;",
      "⦼": "&odsold;",
      "œ": "&oelig;",
      "⦿": "&ofcir;",
      "𝔬": "&ofr;",
      "˛": "&ogon;",
      "ò": "&ograve;",
      "⧁": "&ogt;",
      "⦵": "&ohbar;",
      "⦾": "&olcir;",
      "⦻": "&olcross;",
      "⧀": "&olt;",
      "ō": "&omacr;",
      "ω": "&omega;",
      "ο": "&omicron;",
      "⦶": "&omid;",
      "𝕠": "&oopf;",
      "⦷": "&opar;",
      "⦹": "&operp;",
      "∨": "&vee;",
      "⩝": "&ord;",
      "ℴ": "&oscr;",
      "ª": "&ordf;",
      "º": "&ordm;",
      "⊶": "&origof;",
      "⩖": "&oror;",
      "⩗": "&orslope;",
      "⩛": "&orv;",
      "ø": "&oslash;",
      "⊘": "&osol;",
      "õ": "&otilde;",
      "⨶": "&otimesas;",
      "ö": "&ouml;",
      "⌽": "&ovbar;",
      "¶": "&para;",
      "⫳": "&parsim;",
      "⫽": "&parsl;",
      "п": "&pcy;",
      "%": "&percnt;",
      ".": "&period;",
      "‰": "&permil;",
      "‱": "&pertenk;",
      "𝔭": "&pfr;",
      "φ": "&phi;",
      "ϕ": "&varphi;",
      "☎": "&phone;",
      "π": "&pi;",
      "ϖ": "&varpi;",
      "ℎ": "&planckh;",
      "+": "&plus;",
      "⨣": "&plusacir;",
      "⨢": "&pluscir;",
      "⨥": "&plusdu;",
      "⩲": "&pluse;",
      "⨦": "&plussim;",
      "⨧": "&plustwo;",
      "⨕": "&pointint;",
      "𝕡": "&popf;",
      "£": "&pound;",
      "⪳": "&prE;",
      "⪷": "&precapprox;",
      "⪹": "&prnap;",
      "⪵": "&prnE;",
      "⋨": "&prnsim;",
      "′": "&prime;",
      "⌮": "&profalar;",
      "⌒": "&profline;",
      "⌓": "&profsurf;",
      "⊰": "&prurel;",
      "𝓅": "&pscr;",
      "ψ": "&psi;",
      " ": "&puncsp;",
      "𝔮": "&qfr;",
      "𝕢": "&qopf;",
      "⁗": "&qprime;",
      "𝓆": "&qscr;",
      "⨖": "&quatint;",
      "?": "&quest;",
      "⤜": "&rAtail;",
      "⥤": "&rHar;",
      "∽̱": "&race;",
      "ŕ": "&racute;",
      "⦳": "&raemptyv;",
      "⦒": "&rangd;",
      "⦥": "&range;",
      "»": "&raquo;",
      "⥵": "&rarrap;",
      "⤠": "&rarrbfs;",
      "⤳": "&rarrc;",
      "⤞": "&rarrfs;",
      "⥅": "&rarrpl;",
      "⥴": "&rarrsim;",
      "↣": "&rightarrowtail;",
      "↝": "&rightsquigarrow;",
      "⤚": "&ratail;",
      "∶": "&ratio;",
      "❳": "&rbbrk;",
      "}": "&rcub;",
      "]": "&rsqb;",
      "⦌": "&rbrke;",
      "⦎": "&rbrksld;",
      "⦐": "&rbrkslu;",
      "ř": "&rcaron;",
      "ŗ": "&rcedil;",
      "р": "&rcy;",
      "⤷": "&rdca;",
      "⥩": "&rdldhar;",
      "↳": "&rdsh;",
      "▭": "&rect;",
      "⥽": "&rfisht;",
      "𝔯": "&rfr;",
      "⥬": "&rharul;",
      "ρ": "&rho;",
      "ϱ": "&varrho;",
      "⇉": "&rrarr;",
      "⋌": "&rthree;",
      "˚": "&ring;",
      "‏": "&rlm;",
      "⎱": "&rmoustache;",
      "⫮": "&rnmid;",
      "⟭": "&roang;",
      "⇾": "&roarr;",
      "⦆": "&ropar;",
      "𝕣": "&ropf;",
      "⨮": "&roplus;",
      "⨵": "&rotimes;",
      ")": "&rpar;",
      "⦔": "&rpargt;",
      "⨒": "&rppolint;",
      "›": "&rsaquo;",
      "𝓇": "&rscr;",
      "⋊": "&rtimes;",
      "▹": "&triangleright;",
      "⧎": "&rtriltri;",
      "⥨": "&ruluhar;",
      "℞": "&rx;",
      "ś": "&sacute;",
      "⪴": "&scE;",
      "⪸": "&succapprox;",
      "š": "&scaron;",
      "ş": "&scedil;",
      "ŝ": "&scirc;",
      "⪶": "&succneqq;",
      "⪺": "&succnapprox;",
      "⋩": "&succnsim;",
      "⨓": "&scpolint;",
      "с": "&scy;",
      "⋅": "&sdot;",
      "⩦": "&sdote;",
      "⇘": "&seArr;",
      "§": "&sect;",
      ";": "&semi;",
      "⤩": "&tosa;",
      "✶": "&sext;",
      "𝔰": "&sfr;",
      "♯": "&sharp;",
      "щ": "&shchcy;",
      "ш": "&shcy;",
      "­": "&shy;",
      "σ": "&sigma;",
      "ς": "&varsigma;",
      "⩪": "&simdot;",
      "⪞": "&simg;",
      "⪠": "&simgE;",
      "⪝": "&siml;",
      "⪟": "&simlE;",
      "≆": "&simne;",
      "⨤": "&simplus;",
      "⥲": "&simrarr;",
      "⨳": "&smashp;",
      "⧤": "&smeparsl;",
      "⌣": "&ssmile;",
      "⪪": "&smt;",
      "⪬": "&smte;",
      "⪬︀": "&smtes;",
      "ь": "&softcy;",
      "/": "&sol;",
      "⧄": "&solb;",
      "⌿": "&solbar;",
      "𝕤": "&sopf;",
      "♠": "&spadesuit;",
      "⊓︀": "&sqcaps;",
      "⊔︀": "&sqcups;",
      "𝓈": "&sscr;",
      "☆": "&star;",
      "⊂": "&subset;",
      "⫅": "&subseteqq;",
      "⪽": "&subdot;",
      "⫃": "&subedot;",
      "⫁": "&submult;",
      "⫋": "&subsetneqq;",
      "⊊": "&subsetneq;",
      "⪿": "&subplus;",
      "⥹": "&subrarr;",
      "⫇": "&subsim;",
      "⫕": "&subsub;",
      "⫓": "&subsup;",
      "♪": "&sung;",
      "¹": "&sup1;",
      "²": "&sup2;",
      "³": "&sup3;",
      "⫆": "&supseteqq;",
      "⪾": "&supdot;",
      "⫘": "&supdsub;",
      "⫄": "&supedot;",
      "⟉": "&suphsol;",
      "⫗": "&suphsub;",
      "⥻": "&suplarr;",
      "⫂": "&supmult;",
      "⫌": "&supsetneqq;",
      "⊋": "&supsetneq;",
      "⫀": "&supplus;",
      "⫈": "&supsim;",
      "⫔": "&supsub;",
      "⫖": "&supsup;",
      "⇙": "&swArr;",
      "⤪": "&swnwar;",
      "ß": "&szlig;",
      "⌖": "&target;",
      "τ": "&tau;",
      "ť": "&tcaron;",
      "ţ": "&tcedil;",
      "т": "&tcy;",
      "⌕": "&telrec;",
      "𝔱": "&tfr;",
      "θ": "&theta;",
      "ϑ": "&vartheta;",
      "þ": "&thorn;",
      "×": "&times;",
      "⨱": "&timesbar;",
      "⨰": "&timesd;",
      "⌶": "&topbot;",
      "⫱": "&topcir;",
      "𝕥": "&topf;",
      "⫚": "&topfork;",
      "‴": "&tprime;",
      "▵": "&utri;",
      "≜": "&trie;",
      "◬": "&tridot;",
      "⨺": "&triminus;",
      "⨹": "&triplus;",
      "⧍": "&trisb;",
      "⨻": "&tritime;",
      "⏢": "&trpezium;",
      "𝓉": "&tscr;",
      "ц": "&tscy;",
      "ћ": "&tshcy;",
      "ŧ": "&tstrok;",
      "⥣": "&uHar;",
      "ú": "&uacute;",
      "ў": "&ubrcy;",
      "ŭ": "&ubreve;",
      "û": "&ucirc;",
      "у": "&ucy;",
      "ű": "&udblac;",
      "⥾": "&ufisht;",
      "𝔲": "&ufr;",
      "ù": "&ugrave;",
      "▀": "&uhblk;",
      "⌜": "&ulcorner;",
      "⌏": "&ulcrop;",
      "◸": "&ultri;",
      "ū": "&umacr;",
      "ų": "&uogon;",
      "𝕦": "&uopf;",
      "υ": "&upsilon;",
      "⇈": "&uuarr;",
      "⌝": "&urcorner;",
      "⌎": "&urcrop;",
      "ů": "&uring;",
      "◹": "&urtri;",
      "𝓊": "&uscr;",
      "⋰": "&utdot;",
      "ũ": "&utilde;",
      "ü": "&uuml;",
      "⦧": "&uwangle;",
      "⫨": "&vBar;",
      "⫩": "&vBarv;",
      "⦜": "&vangrt;",
      "⊊︀": "&vsubne;",
      "⫋︀": "&vsubnE;",
      "⊋︀": "&vsupne;",
      "⫌︀": "&vsupnE;",
      "в": "&vcy;",
      "⊻": "&veebar;",
      "≚": "&veeeq;",
      "⋮": "&vellip;",
      "𝔳": "&vfr;",
      "𝕧": "&vopf;",
      "𝓋": "&vscr;",
      "⦚": "&vzigzag;",
      "ŵ": "&wcirc;",
      "⩟": "&wedbar;",
      "≙": "&wedgeq;",
      "℘": "&wp;",
      "𝔴": "&wfr;",
      "𝕨": "&wopf;",
      "𝓌": "&wscr;",
      "𝔵": "&xfr;",
      "ξ": "&xi;",
      "⋻": "&xnis;",
      "𝕩": "&xopf;",
      "𝓍": "&xscr;",
      "ý": "&yacute;",
      "я": "&yacy;",
      "ŷ": "&ycirc;",
      "ы": "&ycy;",
      "¥": "&yen;",
      "𝔶": "&yfr;",
      "ї": "&yicy;",
      "𝕪": "&yopf;",
      "𝓎": "&yscr;",
      "ю": "&yucy;",
      "ÿ": "&yuml;",
      "ź": "&zacute;",
      "ž": "&zcaron;",
      "з": "&zcy;",
      "ż": "&zdot;",
      "ζ": "&zeta;",
      "𝔷": "&zfr;",
      "ж": "&zhcy;",
      "⇝": "&zigrarr;",
      "𝕫": "&zopf;",
      "𝓏": "&zscr;",
      "‍": "&zwj;",
      "‌": "&zwnj;"
    }
  }
};

/***/ }),

/***/ "./node_modules/html-entities/lib/numeric-unicode-map.js":
/*!***************************************************************!*\
  !*** ./node_modules/html-entities/lib/numeric-unicode-map.js ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.numericUnicodeMap = {
  0: 65533,
  128: 8364,
  130: 8218,
  131: 402,
  132: 8222,
  133: 8230,
  134: 8224,
  135: 8225,
  136: 710,
  137: 8240,
  138: 352,
  139: 8249,
  140: 338,
  142: 381,
  145: 8216,
  146: 8217,
  147: 8220,
  148: 8221,
  149: 8226,
  150: 8211,
  151: 8212,
  152: 732,
  153: 8482,
  154: 353,
  155: 8250,
  156: 339,
  158: 382,
  159: 376
};

/***/ }),

/***/ "./node_modules/html-entities/lib/surrogate-pairs.js":
/*!***********************************************************!*\
  !*** ./node_modules/html-entities/lib/surrogate-pairs.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports) {

"use strict";


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.fromCodePoint = String.fromCodePoint || function (astralCodePoint) {
  return String.fromCharCode(Math.floor((astralCodePoint - 65536) / 1024) + 55296, (astralCodePoint - 65536) % 1024 + 56320);
};
exports.getCodePoint = String.prototype.codePointAt ? function (input, position) {
  return input.codePointAt(position);
} : function (input, position) {
  return (input.charCodeAt(position) - 55296) * 1024 + input.charCodeAt(position + 1) - 56320 + 65536;
};
exports.highSurrogateFrom = 55296;
exports.highSurrogateTo = 56319;

/***/ }),

/***/ "./node_modules/localforage/dist/localforage.js":
/*!******************************************************!*\
  !*** ./node_modules/localforage/dist/localforage.js ***!
  \******************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

/*!
    localForage -- Offline Storage, Improved
    Version 1.10.0
    https://localforage.github.io/localForage
    (c) 2013-2017 Mozilla, Apache License 2.0
*/
(function (f) {
  if (true) {
    module.exports = f();
  } else { var g; }
})(function () {
  var define, module, exports;
  return function e(t, n, r) {
    function s(o, u) {
      if (!n[o]) {
        if (!t[o]) {
          var a = undefined;
          if (!u && a) return require(o, !0);
          if (i) return i(o, !0);
          var f = new Error("Cannot find module '" + o + "'");
          throw f.code = "MODULE_NOT_FOUND", f;
        }
        var l = n[o] = {
          exports: {}
        };
        t[o][0].call(l.exports, function (e) {
          var n = t[o][1][e];
          return s(n ? n : e);
        }, l, l.exports, e, t, n, r);
      }
      return n[o].exports;
    }
    var i = undefined;
    for (var o = 0; o < r.length; o++) s(r[o]);
    return s;
  }({
    1: [function (_dereq_, module, exports) {
      (function (global) {
        'use strict';

        var Mutation = global.MutationObserver || global.WebKitMutationObserver;
        var scheduleDrain;
        {
          if (Mutation) {
            var called = 0;
            var observer = new Mutation(nextTick);
            var element = global.document.createTextNode('');
            observer.observe(element, {
              characterData: true
            });
            scheduleDrain = function () {
              element.data = called = ++called % 2;
            };
          } else if (!global.setImmediate && typeof global.MessageChannel !== 'undefined') {
            var channel = new global.MessageChannel();
            channel.port1.onmessage = nextTick;
            scheduleDrain = function () {
              channel.port2.postMessage(0);
            };
          } else if ('document' in global && 'onreadystatechange' in global.document.createElement('script')) {
            scheduleDrain = function () {
              // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
              // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
              var scriptEl = global.document.createElement('script');
              scriptEl.onreadystatechange = function () {
                nextTick();
                scriptEl.onreadystatechange = null;
                scriptEl.parentNode.removeChild(scriptEl);
                scriptEl = null;
              };
              global.document.documentElement.appendChild(scriptEl);
            };
          } else {
            scheduleDrain = function () {
              setTimeout(nextTick, 0);
            };
          }
        }
        var draining;
        var queue = [];
        //named nextTick for less confusing stack traces
        function nextTick() {
          draining = true;
          var i, oldQueue;
          var len = queue.length;
          while (len) {
            oldQueue = queue;
            queue = [];
            i = -1;
            while (++i < len) {
              oldQueue[i]();
            }
            len = queue.length;
          }
          draining = false;
        }
        module.exports = immediate;
        function immediate(task) {
          if (queue.push(task) === 1 && !draining) {
            scheduleDrain();
          }
        }
      }).call(this, typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
    }, {}],
    2: [function (_dereq_, module, exports) {
      'use strict';

      var immediate = _dereq_(1);

      /* istanbul ignore next */
      function INTERNAL() {}
      var handlers = {};
      var REJECTED = ['REJECTED'];
      var FULFILLED = ['FULFILLED'];
      var PENDING = ['PENDING'];
      module.exports = Promise;
      function Promise(resolver) {
        if (typeof resolver !== 'function') {
          throw new TypeError('resolver must be a function');
        }
        this.state = PENDING;
        this.queue = [];
        this.outcome = void 0;
        if (resolver !== INTERNAL) {
          safelyResolveThenable(this, resolver);
        }
      }
      Promise.prototype["catch"] = function (onRejected) {
        return this.then(null, onRejected);
      };
      Promise.prototype.then = function (onFulfilled, onRejected) {
        if (typeof onFulfilled !== 'function' && this.state === FULFILLED || typeof onRejected !== 'function' && this.state === REJECTED) {
          return this;
        }
        var promise = new this.constructor(INTERNAL);
        if (this.state !== PENDING) {
          var resolver = this.state === FULFILLED ? onFulfilled : onRejected;
          unwrap(promise, resolver, this.outcome);
        } else {
          this.queue.push(new QueueItem(promise, onFulfilled, onRejected));
        }
        return promise;
      };
      function QueueItem(promise, onFulfilled, onRejected) {
        this.promise = promise;
        if (typeof onFulfilled === 'function') {
          this.onFulfilled = onFulfilled;
          this.callFulfilled = this.otherCallFulfilled;
        }
        if (typeof onRejected === 'function') {
          this.onRejected = onRejected;
          this.callRejected = this.otherCallRejected;
        }
      }
      QueueItem.prototype.callFulfilled = function (value) {
        handlers.resolve(this.promise, value);
      };
      QueueItem.prototype.otherCallFulfilled = function (value) {
        unwrap(this.promise, this.onFulfilled, value);
      };
      QueueItem.prototype.callRejected = function (value) {
        handlers.reject(this.promise, value);
      };
      QueueItem.prototype.otherCallRejected = function (value) {
        unwrap(this.promise, this.onRejected, value);
      };
      function unwrap(promise, func, value) {
        immediate(function () {
          var returnValue;
          try {
            returnValue = func(value);
          } catch (e) {
            return handlers.reject(promise, e);
          }
          if (returnValue === promise) {
            handlers.reject(promise, new TypeError('Cannot resolve promise with itself'));
          } else {
            handlers.resolve(promise, returnValue);
          }
        });
      }
      handlers.resolve = function (self, value) {
        var result = tryCatch(getThen, value);
        if (result.status === 'error') {
          return handlers.reject(self, result.value);
        }
        var thenable = result.value;
        if (thenable) {
          safelyResolveThenable(self, thenable);
        } else {
          self.state = FULFILLED;
          self.outcome = value;
          var i = -1;
          var len = self.queue.length;
          while (++i < len) {
            self.queue[i].callFulfilled(value);
          }
        }
        return self;
      };
      handlers.reject = function (self, error) {
        self.state = REJECTED;
        self.outcome = error;
        var i = -1;
        var len = self.queue.length;
        while (++i < len) {
          self.queue[i].callRejected(error);
        }
        return self;
      };
      function getThen(obj) {
        // Make sure we only access the accessor once as required by the spec
        var then = obj && obj.then;
        if (obj && (typeof obj === 'object' || typeof obj === 'function') && typeof then === 'function') {
          return function appyThen() {
            then.apply(obj, arguments);
          };
        }
      }
      function safelyResolveThenable(self, thenable) {
        // Either fulfill, reject or reject with error
        var called = false;
        function onError(value) {
          if (called) {
            return;
          }
          called = true;
          handlers.reject(self, value);
        }
        function onSuccess(value) {
          if (called) {
            return;
          }
          called = true;
          handlers.resolve(self, value);
        }
        function tryToUnwrap() {
          thenable(onSuccess, onError);
        }
        var result = tryCatch(tryToUnwrap);
        if (result.status === 'error') {
          onError(result.value);
        }
      }
      function tryCatch(func, value) {
        var out = {};
        try {
          out.value = func(value);
          out.status = 'success';
        } catch (e) {
          out.status = 'error';
          out.value = e;
        }
        return out;
      }
      Promise.resolve = resolve;
      function resolve(value) {
        if (value instanceof this) {
          return value;
        }
        return handlers.resolve(new this(INTERNAL), value);
      }
      Promise.reject = reject;
      function reject(reason) {
        var promise = new this(INTERNAL);
        return handlers.reject(promise, reason);
      }
      Promise.all = all;
      function all(iterable) {
        var self = this;
        if (Object.prototype.toString.call(iterable) !== '[object Array]') {
          return this.reject(new TypeError('must be an array'));
        }
        var len = iterable.length;
        var called = false;
        if (!len) {
          return this.resolve([]);
        }
        var values = new Array(len);
        var resolved = 0;
        var i = -1;
        var promise = new this(INTERNAL);
        while (++i < len) {
          allResolver(iterable[i], i);
        }
        return promise;
        function allResolver(value, i) {
          self.resolve(value).then(resolveFromAll, function (error) {
            if (!called) {
              called = true;
              handlers.reject(promise, error);
            }
          });
          function resolveFromAll(outValue) {
            values[i] = outValue;
            if (++resolved === len && !called) {
              called = true;
              handlers.resolve(promise, values);
            }
          }
        }
      }
      Promise.race = race;
      function race(iterable) {
        var self = this;
        if (Object.prototype.toString.call(iterable) !== '[object Array]') {
          return this.reject(new TypeError('must be an array'));
        }
        var len = iterable.length;
        var called = false;
        if (!len) {
          return this.resolve([]);
        }
        var i = -1;
        var promise = new this(INTERNAL);
        while (++i < len) {
          resolver(iterable[i]);
        }
        return promise;
        function resolver(value) {
          self.resolve(value).then(function (response) {
            if (!called) {
              called = true;
              handlers.resolve(promise, response);
            }
          }, function (error) {
            if (!called) {
              called = true;
              handlers.reject(promise, error);
            }
          });
        }
      }
    }, {
      "1": 1
    }],
    3: [function (_dereq_, module, exports) {
      (function (global) {
        'use strict';

        if (typeof global.Promise !== 'function') {
          global.Promise = _dereq_(2);
        }
      }).call(this, typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
    }, {
      "2": 2
    }],
    4: [function (_dereq_, module, exports) {
      'use strict';

      var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
        return typeof obj;
      } : function (obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
      function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
          throw new TypeError("Cannot call a class as a function");
        }
      }
      function getIDB() {
        /* global indexedDB,webkitIndexedDB,mozIndexedDB,OIndexedDB,msIndexedDB */
        try {
          if (typeof indexedDB !== 'undefined') {
            return indexedDB;
          }
          if (typeof webkitIndexedDB !== 'undefined') {
            return webkitIndexedDB;
          }
          if (typeof mozIndexedDB !== 'undefined') {
            return mozIndexedDB;
          }
          if (typeof OIndexedDB !== 'undefined') {
            return OIndexedDB;
          }
          if (typeof msIndexedDB !== 'undefined') {
            return msIndexedDB;
          }
        } catch (e) {
          return;
        }
      }
      var idb = getIDB();
      function isIndexedDBValid() {
        try {
          // Initialize IndexedDB; fall back to vendor-prefixed versions
          // if needed.
          if (!idb || !idb.open) {
            return false;
          }
          // We mimic PouchDB here;
          //
          // We test for openDatabase because IE Mobile identifies itself
          // as Safari. Oh the lulz...
          var isSafari = typeof openDatabase !== 'undefined' && /(Safari|iPhone|iPad|iPod)/.test(navigator.userAgent) && !/Chrome/.test(navigator.userAgent) && !/BlackBerry/.test(navigator.platform);
          var hasFetch = typeof fetch === 'function' && fetch.toString().indexOf('[native code') !== -1;

          // Safari <10.1 does not meet our requirements for IDB support
          // (see: https://github.com/pouchdb/pouchdb/issues/5572).
          // Safari 10.1 shipped with fetch, we can use that to detect it.
          // Note: this creates issues with `window.fetch` polyfills and
          // overrides; see:
          // https://github.com/localForage/localForage/issues/856
          return (!isSafari || hasFetch) && typeof indexedDB !== 'undefined' &&
          // some outdated implementations of IDB that appear on Samsung
          // and HTC Android devices <4.4 are missing IDBKeyRange
          // See: https://github.com/mozilla/localForage/issues/128
          // See: https://github.com/mozilla/localForage/issues/272
          typeof IDBKeyRange !== 'undefined';
        } catch (e) {
          return false;
        }
      }

      // Abstracts constructing a Blob object, so it also works in older
      // browsers that don't support the native Blob constructor. (i.e.
      // old QtWebKit versions, at least).
      // Abstracts constructing a Blob object, so it also works in older
      // browsers that don't support the native Blob constructor. (i.e.
      // old QtWebKit versions, at least).
      function createBlob(parts, properties) {
        /* global BlobBuilder,MSBlobBuilder,MozBlobBuilder,WebKitBlobBuilder */
        parts = parts || [];
        properties = properties || {};
        try {
          return new Blob(parts, properties);
        } catch (e) {
          if (e.name !== 'TypeError') {
            throw e;
          }
          var Builder = typeof BlobBuilder !== 'undefined' ? BlobBuilder : typeof MSBlobBuilder !== 'undefined' ? MSBlobBuilder : typeof MozBlobBuilder !== 'undefined' ? MozBlobBuilder : WebKitBlobBuilder;
          var builder = new Builder();
          for (var i = 0; i < parts.length; i += 1) {
            builder.append(parts[i]);
          }
          return builder.getBlob(properties.type);
        }
      }

      // This is CommonJS because lie is an external dependency, so Rollup
      // can just ignore it.
      if (typeof Promise === 'undefined') {
        // In the "nopromises" build this will just throw if you don't have
        // a global promise object, but it would throw anyway later.
        _dereq_(3);
      }
      var Promise$1 = Promise;
      function executeCallback(promise, callback) {
        if (callback) {
          promise.then(function (result) {
            callback(null, result);
          }, function (error) {
            callback(error);
          });
        }
      }
      function executeTwoCallbacks(promise, callback, errorCallback) {
        if (typeof callback === 'function') {
          promise.then(callback);
        }
        if (typeof errorCallback === 'function') {
          promise["catch"](errorCallback);
        }
      }
      function normalizeKey(key) {
        // Cast the key to a string, as that's all we can set as a key.
        if (typeof key !== 'string') {
          console.warn(key + ' used as a key, but it is not a string.');
          key = String(key);
        }
        return key;
      }
      function getCallback() {
        if (arguments.length && typeof arguments[arguments.length - 1] === 'function') {
          return arguments[arguments.length - 1];
        }
      }

      // Some code originally from async_storage.js in
      // [Gaia](https://github.com/mozilla-b2g/gaia).

      var DETECT_BLOB_SUPPORT_STORE = 'local-forage-detect-blob-support';
      var supportsBlobs = void 0;
      var dbContexts = {};
      var toString = Object.prototype.toString;

      // Transaction Modes
      var READ_ONLY = 'readonly';
      var READ_WRITE = 'readwrite';

      // Transform a binary string to an array buffer, because otherwise
      // weird stuff happens when you try to work with the binary string directly.
      // It is known.
      // From http://stackoverflow.com/questions/14967647/ (continues on next line)
      // encode-decode-image-with-base64-breaks-image (2013-04-21)
      function _binStringToArrayBuffer(bin) {
        var length = bin.length;
        var buf = new ArrayBuffer(length);
        var arr = new Uint8Array(buf);
        for (var i = 0; i < length; i++) {
          arr[i] = bin.charCodeAt(i);
        }
        return buf;
      }

      //
      // Blobs are not supported in all versions of IndexedDB, notably
      // Chrome <37 and Android <5. In those versions, storing a blob will throw.
      //
      // Various other blob bugs exist in Chrome v37-42 (inclusive).
      // Detecting them is expensive and confusing to users, and Chrome 37-42
      // is at very low usage worldwide, so we do a hacky userAgent check instead.
      //
      // content-type bug: https://code.google.com/p/chromium/issues/detail?id=408120
      // 404 bug: https://code.google.com/p/chromium/issues/detail?id=447916
      // FileReader bug: https://code.google.com/p/chromium/issues/detail?id=447836
      //
      // Code borrowed from PouchDB. See:
      // https://github.com/pouchdb/pouchdb/blob/master/packages/node_modules/pouchdb-adapter-idb/src/blobSupport.js
      //
      function _checkBlobSupportWithoutCaching(idb) {
        return new Promise$1(function (resolve) {
          var txn = idb.transaction(DETECT_BLOB_SUPPORT_STORE, READ_WRITE);
          var blob = createBlob(['']);
          txn.objectStore(DETECT_BLOB_SUPPORT_STORE).put(blob, 'key');
          txn.onabort = function (e) {
            // If the transaction aborts now its due to not being able to
            // write to the database, likely due to the disk being full
            e.preventDefault();
            e.stopPropagation();
            resolve(false);
          };
          txn.oncomplete = function () {
            var matchedChrome = navigator.userAgent.match(/Chrome\/(\d+)/);
            var matchedEdge = navigator.userAgent.match(/Edge\//);
            // MS Edge pretends to be Chrome 42:
            // https://msdn.microsoft.com/en-us/library/hh869301%28v=vs.85%29.aspx
            resolve(matchedEdge || !matchedChrome || parseInt(matchedChrome[1], 10) >= 43);
          };
        })["catch"](function () {
          return false; // error, so assume unsupported
        });
      }
      function _checkBlobSupport(idb) {
        if (typeof supportsBlobs === 'boolean') {
          return Promise$1.resolve(supportsBlobs);
        }
        return _checkBlobSupportWithoutCaching(idb).then(function (value) {
          supportsBlobs = value;
          return supportsBlobs;
        });
      }
      function _deferReadiness(dbInfo) {
        var dbContext = dbContexts[dbInfo.name];

        // Create a deferred object representing the current database operation.
        var deferredOperation = {};
        deferredOperation.promise = new Promise$1(function (resolve, reject) {
          deferredOperation.resolve = resolve;
          deferredOperation.reject = reject;
        });

        // Enqueue the deferred operation.
        dbContext.deferredOperations.push(deferredOperation);

        // Chain its promise to the database readiness.
        if (!dbContext.dbReady) {
          dbContext.dbReady = deferredOperation.promise;
        } else {
          dbContext.dbReady = dbContext.dbReady.then(function () {
            return deferredOperation.promise;
          });
        }
      }
      function _advanceReadiness(dbInfo) {
        var dbContext = dbContexts[dbInfo.name];

        // Dequeue a deferred operation.
        var deferredOperation = dbContext.deferredOperations.pop();

        // Resolve its promise (which is part of the database readiness
        // chain of promises).
        if (deferredOperation) {
          deferredOperation.resolve();
          return deferredOperation.promise;
        }
      }
      function _rejectReadiness(dbInfo, err) {
        var dbContext = dbContexts[dbInfo.name];

        // Dequeue a deferred operation.
        var deferredOperation = dbContext.deferredOperations.pop();

        // Reject its promise (which is part of the database readiness
        // chain of promises).
        if (deferredOperation) {
          deferredOperation.reject(err);
          return deferredOperation.promise;
        }
      }
      function _getConnection(dbInfo, upgradeNeeded) {
        return new Promise$1(function (resolve, reject) {
          dbContexts[dbInfo.name] = dbContexts[dbInfo.name] || createDbContext();
          if (dbInfo.db) {
            if (upgradeNeeded) {
              _deferReadiness(dbInfo);
              dbInfo.db.close();
            } else {
              return resolve(dbInfo.db);
            }
          }
          var dbArgs = [dbInfo.name];
          if (upgradeNeeded) {
            dbArgs.push(dbInfo.version);
          }
          var openreq = idb.open.apply(idb, dbArgs);
          if (upgradeNeeded) {
            openreq.onupgradeneeded = function (e) {
              var db = openreq.result;
              try {
                db.createObjectStore(dbInfo.storeName);
                if (e.oldVersion <= 1) {
                  // Added when support for blob shims was added
                  db.createObjectStore(DETECT_BLOB_SUPPORT_STORE);
                }
              } catch (ex) {
                if (ex.name === 'ConstraintError') {
                  console.warn('The database "' + dbInfo.name + '"' + ' has been upgraded from version ' + e.oldVersion + ' to version ' + e.newVersion + ', but the storage "' + dbInfo.storeName + '" already exists.');
                } else {
                  throw ex;
                }
              }
            };
          }
          openreq.onerror = function (e) {
            e.preventDefault();
            reject(openreq.error);
          };
          openreq.onsuccess = function () {
            var db = openreq.result;
            db.onversionchange = function (e) {
              // Triggered when the database is modified (e.g. adding an objectStore) or
              // deleted (even when initiated by other sessions in different tabs).
              // Closing the connection here prevents those operations from being blocked.
              // If the database is accessed again later by this instance, the connection
              // will be reopened or the database recreated as needed.
              e.target.close();
            };
            resolve(db);
            _advanceReadiness(dbInfo);
          };
        });
      }
      function _getOriginalConnection(dbInfo) {
        return _getConnection(dbInfo, false);
      }
      function _getUpgradedConnection(dbInfo) {
        return _getConnection(dbInfo, true);
      }
      function _isUpgradeNeeded(dbInfo, defaultVersion) {
        if (!dbInfo.db) {
          return true;
        }
        var isNewStore = !dbInfo.db.objectStoreNames.contains(dbInfo.storeName);
        var isDowngrade = dbInfo.version < dbInfo.db.version;
        var isUpgrade = dbInfo.version > dbInfo.db.version;
        if (isDowngrade) {
          // If the version is not the default one
          // then warn for impossible downgrade.
          if (dbInfo.version !== defaultVersion) {
            console.warn('The database "' + dbInfo.name + '"' + " can't be downgraded from version " + dbInfo.db.version + ' to version ' + dbInfo.version + '.');
          }
          // Align the versions to prevent errors.
          dbInfo.version = dbInfo.db.version;
        }
        if (isUpgrade || isNewStore) {
          // If the store is new then increment the version (if needed).
          // This will trigger an "upgradeneeded" event which is required
          // for creating a store.
          if (isNewStore) {
            var incVersion = dbInfo.db.version + 1;
            if (incVersion > dbInfo.version) {
              dbInfo.version = incVersion;
            }
          }
          return true;
        }
        return false;
      }

      // encode a blob for indexeddb engines that don't support blobs
      function _encodeBlob(blob) {
        return new Promise$1(function (resolve, reject) {
          var reader = new FileReader();
          reader.onerror = reject;
          reader.onloadend = function (e) {
            var base64 = btoa(e.target.result || '');
            resolve({
              __local_forage_encoded_blob: true,
              data: base64,
              type: blob.type
            });
          };
          reader.readAsBinaryString(blob);
        });
      }

      // decode an encoded blob
      function _decodeBlob(encodedBlob) {
        var arrayBuff = _binStringToArrayBuffer(atob(encodedBlob.data));
        return createBlob([arrayBuff], {
          type: encodedBlob.type
        });
      }

      // is this one of our fancy encoded blobs?
      function _isEncodedBlob(value) {
        return value && value.__local_forage_encoded_blob;
      }

      // Specialize the default `ready()` function by making it dependent
      // on the current database operations. Thus, the driver will be actually
      // ready when it's been initialized (default) *and* there are no pending
      // operations on the database (initiated by some other instances).
      function _fullyReady(callback) {
        var self = this;
        var promise = self._initReady().then(function () {
          var dbContext = dbContexts[self._dbInfo.name];
          if (dbContext && dbContext.dbReady) {
            return dbContext.dbReady;
          }
        });
        executeTwoCallbacks(promise, callback, callback);
        return promise;
      }

      // Try to establish a new db connection to replace the
      // current one which is broken (i.e. experiencing
      // InvalidStateError while creating a transaction).
      function _tryReconnect(dbInfo) {
        _deferReadiness(dbInfo);
        var dbContext = dbContexts[dbInfo.name];
        var forages = dbContext.forages;
        for (var i = 0; i < forages.length; i++) {
          var forage = forages[i];
          if (forage._dbInfo.db) {
            forage._dbInfo.db.close();
            forage._dbInfo.db = null;
          }
        }
        dbInfo.db = null;
        return _getOriginalConnection(dbInfo).then(function (db) {
          dbInfo.db = db;
          if (_isUpgradeNeeded(dbInfo)) {
            // Reopen the database for upgrading.
            return _getUpgradedConnection(dbInfo);
          }
          return db;
        }).then(function (db) {
          // store the latest db reference
          // in case the db was upgraded
          dbInfo.db = dbContext.db = db;
          for (var i = 0; i < forages.length; i++) {
            forages[i]._dbInfo.db = db;
          }
        })["catch"](function (err) {
          _rejectReadiness(dbInfo, err);
          throw err;
        });
      }

      // FF doesn't like Promises (micro-tasks) and IDDB store operations,
      // so we have to do it with callbacks
      function createTransaction(dbInfo, mode, callback, retries) {
        if (retries === undefined) {
          retries = 1;
        }
        try {
          var tx = dbInfo.db.transaction(dbInfo.storeName, mode);
          callback(null, tx);
        } catch (err) {
          if (retries > 0 && (!dbInfo.db || err.name === 'InvalidStateError' || err.name === 'NotFoundError')) {
            return Promise$1.resolve().then(function () {
              if (!dbInfo.db || err.name === 'NotFoundError' && !dbInfo.db.objectStoreNames.contains(dbInfo.storeName) && dbInfo.version <= dbInfo.db.version) {
                // increase the db version, to create the new ObjectStore
                if (dbInfo.db) {
                  dbInfo.version = dbInfo.db.version + 1;
                }
                // Reopen the database for upgrading.
                return _getUpgradedConnection(dbInfo);
              }
            }).then(function () {
              return _tryReconnect(dbInfo).then(function () {
                createTransaction(dbInfo, mode, callback, retries - 1);
              });
            })["catch"](callback);
          }
          callback(err);
        }
      }
      function createDbContext() {
        return {
          // Running localForages sharing a database.
          forages: [],
          // Shared database.
          db: null,
          // Database readiness (promise).
          dbReady: null,
          // Deferred operations on the database.
          deferredOperations: []
        };
      }

      // Open the IndexedDB database (automatically creates one if one didn't
      // previously exist), using any options set in the config.
      function _initStorage(options) {
        var self = this;
        var dbInfo = {
          db: null
        };
        if (options) {
          for (var i in options) {
            dbInfo[i] = options[i];
          }
        }

        // Get the current context of the database;
        var dbContext = dbContexts[dbInfo.name];

        // ...or create a new context.
        if (!dbContext) {
          dbContext = createDbContext();
          // Register the new context in the global container.
          dbContexts[dbInfo.name] = dbContext;
        }

        // Register itself as a running localForage in the current context.
        dbContext.forages.push(self);

        // Replace the default `ready()` function with the specialized one.
        if (!self._initReady) {
          self._initReady = self.ready;
          self.ready = _fullyReady;
        }

        // Create an array of initialization states of the related localForages.
        var initPromises = [];
        function ignoreErrors() {
          // Don't handle errors here,
          // just makes sure related localForages aren't pending.
          return Promise$1.resolve();
        }
        for (var j = 0; j < dbContext.forages.length; j++) {
          var forage = dbContext.forages[j];
          if (forage !== self) {
            // Don't wait for itself...
            initPromises.push(forage._initReady()["catch"](ignoreErrors));
          }
        }

        // Take a snapshot of the related localForages.
        var forages = dbContext.forages.slice(0);

        // Initialize the connection process only when
        // all the related localForages aren't pending.
        return Promise$1.all(initPromises).then(function () {
          dbInfo.db = dbContext.db;
          // Get the connection or open a new one without upgrade.
          return _getOriginalConnection(dbInfo);
        }).then(function (db) {
          dbInfo.db = db;
          if (_isUpgradeNeeded(dbInfo, self._defaultConfig.version)) {
            // Reopen the database for upgrading.
            return _getUpgradedConnection(dbInfo);
          }
          return db;
        }).then(function (db) {
          dbInfo.db = dbContext.db = db;
          self._dbInfo = dbInfo;
          // Share the final connection amongst related localForages.
          for (var k = 0; k < forages.length; k++) {
            var forage = forages[k];
            if (forage !== self) {
              // Self is already up-to-date.
              forage._dbInfo.db = dbInfo.db;
              forage._dbInfo.version = dbInfo.version;
            }
          }
        });
      }
      function getItem(key, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                var req = store.get(key);
                req.onsuccess = function () {
                  var value = req.result;
                  if (value === undefined) {
                    value = null;
                  }
                  if (_isEncodedBlob(value)) {
                    value = _decodeBlob(value);
                  }
                  resolve(value);
                };
                req.onerror = function () {
                  reject(req.error);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Iterate over all items stored in database.
      function iterate(iterator, callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                var req = store.openCursor();
                var iterationNumber = 1;
                req.onsuccess = function () {
                  var cursor = req.result;
                  if (cursor) {
                    var value = cursor.value;
                    if (_isEncodedBlob(value)) {
                      value = _decodeBlob(value);
                    }
                    var result = iterator(value, cursor.key, iterationNumber++);

                    // when the iterator callback returns any
                    // (non-`undefined`) value, then we stop
                    // the iteration immediately
                    if (result !== void 0) {
                      resolve(result);
                    } else {
                      cursor["continue"]();
                    }
                  } else {
                    resolve();
                  }
                };
                req.onerror = function () {
                  reject(req.error);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function setItem(key, value, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = new Promise$1(function (resolve, reject) {
          var dbInfo;
          self.ready().then(function () {
            dbInfo = self._dbInfo;
            if (toString.call(value) === '[object Blob]') {
              return _checkBlobSupport(dbInfo.db).then(function (blobSupport) {
                if (blobSupport) {
                  return value;
                }
                return _encodeBlob(value);
              });
            }
            return value;
          }).then(function (value) {
            createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);

                // The reason we don't _save_ null is because IE 10 does
                // not support saving the `null` type in IndexedDB. How
                // ironic, given the bug below!
                // See: https://github.com/mozilla/localForage/issues/161
                if (value === null) {
                  value = undefined;
                }
                var req = store.put(value, key);
                transaction.oncomplete = function () {
                  // Cast to undefined so the value passed to
                  // callback/promise is the same as what one would get out
                  // of `getItem()` later. This leads to some weirdness
                  // (setItem('foo', undefined) will return `null`), but
                  // it's not my fault localStorage is our baseline and that
                  // it's weird.
                  if (value === undefined) {
                    value = null;
                  }
                  resolve(value);
                };
                transaction.onabort = transaction.onerror = function () {
                  var err = req.error ? req.error : req.transaction.error;
                  reject(err);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function removeItem(key, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                // We use a Grunt task to make this safe for IE and some
                // versions of Android (including those used by Cordova).
                // Normally IE won't like `.delete()` and will insist on
                // using `['delete']()`, but we have a build step that
                // fixes this for us now.
                var req = store["delete"](key);
                transaction.oncomplete = function () {
                  resolve();
                };
                transaction.onerror = function () {
                  reject(req.error);
                };

                // The request will be also be aborted if we've exceeded our storage
                // space.
                transaction.onabort = function () {
                  var err = req.error ? req.error : req.transaction.error;
                  reject(err);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function clear(callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_WRITE, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                var req = store.clear();
                transaction.oncomplete = function () {
                  resolve();
                };
                transaction.onabort = transaction.onerror = function () {
                  var err = req.error ? req.error : req.transaction.error;
                  reject(err);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function length(callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                var req = store.count();
                req.onsuccess = function () {
                  resolve(req.result);
                };
                req.onerror = function () {
                  reject(req.error);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function key(n, callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          if (n < 0) {
            resolve(null);
            return;
          }
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                var advanced = false;
                var req = store.openKeyCursor();
                req.onsuccess = function () {
                  var cursor = req.result;
                  if (!cursor) {
                    // this means there weren't enough keys
                    resolve(null);
                    return;
                  }
                  if (n === 0) {
                    // We have the first key, return it if that's what they
                    // wanted.
                    resolve(cursor.key);
                  } else {
                    if (!advanced) {
                      // Otherwise, ask the cursor to skip ahead n
                      // records.
                      advanced = true;
                      cursor.advance(n);
                    } else {
                      // When we get here, we've got the nth key.
                      resolve(cursor.key);
                    }
                  }
                };
                req.onerror = function () {
                  reject(req.error);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function keys(callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            createTransaction(self._dbInfo, READ_ONLY, function (err, transaction) {
              if (err) {
                return reject(err);
              }
              try {
                var store = transaction.objectStore(self._dbInfo.storeName);
                var req = store.openKeyCursor();
                var keys = [];
                req.onsuccess = function () {
                  var cursor = req.result;
                  if (!cursor) {
                    resolve(keys);
                    return;
                  }
                  keys.push(cursor.key);
                  cursor["continue"]();
                };
                req.onerror = function () {
                  reject(req.error);
                };
              } catch (e) {
                reject(e);
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function dropInstance(options, callback) {
        callback = getCallback.apply(this, arguments);
        var currentConfig = this.config();
        options = typeof options !== 'function' && options || {};
        if (!options.name) {
          options.name = options.name || currentConfig.name;
          options.storeName = options.storeName || currentConfig.storeName;
        }
        var self = this;
        var promise;
        if (!options.name) {
          promise = Promise$1.reject('Invalid arguments');
        } else {
          var isCurrentDb = options.name === currentConfig.name && self._dbInfo.db;
          var dbPromise = isCurrentDb ? Promise$1.resolve(self._dbInfo.db) : _getOriginalConnection(options).then(function (db) {
            var dbContext = dbContexts[options.name];
            var forages = dbContext.forages;
            dbContext.db = db;
            for (var i = 0; i < forages.length; i++) {
              forages[i]._dbInfo.db = db;
            }
            return db;
          });
          if (!options.storeName) {
            promise = dbPromise.then(function (db) {
              _deferReadiness(options);
              var dbContext = dbContexts[options.name];
              var forages = dbContext.forages;
              db.close();
              for (var i = 0; i < forages.length; i++) {
                var forage = forages[i];
                forage._dbInfo.db = null;
              }
              var dropDBPromise = new Promise$1(function (resolve, reject) {
                var req = idb.deleteDatabase(options.name);
                req.onerror = function () {
                  var db = req.result;
                  if (db) {
                    db.close();
                  }
                  reject(req.error);
                };
                req.onblocked = function () {
                  // Closing all open connections in onversionchange handler should prevent this situation, but if
                  // we do get here, it just means the request remains pending - eventually it will succeed or error
                  console.warn('dropInstance blocked for database "' + options.name + '" until all open connections are closed');
                };
                req.onsuccess = function () {
                  var db = req.result;
                  if (db) {
                    db.close();
                  }
                  resolve(db);
                };
              });
              return dropDBPromise.then(function (db) {
                dbContext.db = db;
                for (var i = 0; i < forages.length; i++) {
                  var _forage = forages[i];
                  _advanceReadiness(_forage._dbInfo);
                }
              })["catch"](function (err) {
                (_rejectReadiness(options, err) || Promise$1.resolve())["catch"](function () {});
                throw err;
              });
            });
          } else {
            promise = dbPromise.then(function (db) {
              if (!db.objectStoreNames.contains(options.storeName)) {
                return;
              }
              var newVersion = db.version + 1;
              _deferReadiness(options);
              var dbContext = dbContexts[options.name];
              var forages = dbContext.forages;
              db.close();
              for (var i = 0; i < forages.length; i++) {
                var forage = forages[i];
                forage._dbInfo.db = null;
                forage._dbInfo.version = newVersion;
              }
              var dropObjectPromise = new Promise$1(function (resolve, reject) {
                var req = idb.open(options.name, newVersion);
                req.onerror = function (err) {
                  var db = req.result;
                  db.close();
                  reject(err);
                };
                req.onupgradeneeded = function () {
                  var db = req.result;
                  db.deleteObjectStore(options.storeName);
                };
                req.onsuccess = function () {
                  var db = req.result;
                  db.close();
                  resolve(db);
                };
              });
              return dropObjectPromise.then(function (db) {
                dbContext.db = db;
                for (var j = 0; j < forages.length; j++) {
                  var _forage2 = forages[j];
                  _forage2._dbInfo.db = db;
                  _advanceReadiness(_forage2._dbInfo);
                }
              })["catch"](function (err) {
                (_rejectReadiness(options, err) || Promise$1.resolve())["catch"](function () {});
                throw err;
              });
            });
          }
        }
        executeCallback(promise, callback);
        return promise;
      }
      var asyncStorage = {
        _driver: 'asyncStorage',
        _initStorage: _initStorage,
        _support: isIndexedDBValid(),
        iterate: iterate,
        getItem: getItem,
        setItem: setItem,
        removeItem: removeItem,
        clear: clear,
        length: length,
        key: key,
        keys: keys,
        dropInstance: dropInstance
      };
      function isWebSQLValid() {
        return typeof openDatabase === 'function';
      }

      // Sadly, the best way to save binary data in WebSQL/localStorage is serializing
      // it to Base64, so this is how we store it to prevent very strange errors with less
      // verbose ways of binary <-> string data storage.
      var BASE_CHARS = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
      var BLOB_TYPE_PREFIX = '~~local_forage_type~';
      var BLOB_TYPE_PREFIX_REGEX = /^~~local_forage_type~([^~]+)~/;
      var SERIALIZED_MARKER = '__lfsc__:';
      var SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER.length;

      // OMG the serializations!
      var TYPE_ARRAYBUFFER = 'arbf';
      var TYPE_BLOB = 'blob';
      var TYPE_INT8ARRAY = 'si08';
      var TYPE_UINT8ARRAY = 'ui08';
      var TYPE_UINT8CLAMPEDARRAY = 'uic8';
      var TYPE_INT16ARRAY = 'si16';
      var TYPE_INT32ARRAY = 'si32';
      var TYPE_UINT16ARRAY = 'ur16';
      var TYPE_UINT32ARRAY = 'ui32';
      var TYPE_FLOAT32ARRAY = 'fl32';
      var TYPE_FLOAT64ARRAY = 'fl64';
      var TYPE_SERIALIZED_MARKER_LENGTH = SERIALIZED_MARKER_LENGTH + TYPE_ARRAYBUFFER.length;
      var toString$1 = Object.prototype.toString;
      function stringToBuffer(serializedString) {
        // Fill the string into a ArrayBuffer.
        var bufferLength = serializedString.length * 0.75;
        var len = serializedString.length;
        var i;
        var p = 0;
        var encoded1, encoded2, encoded3, encoded4;
        if (serializedString[serializedString.length - 1] === '=') {
          bufferLength--;
          if (serializedString[serializedString.length - 2] === '=') {
            bufferLength--;
          }
        }
        var buffer = new ArrayBuffer(bufferLength);
        var bytes = new Uint8Array(buffer);
        for (i = 0; i < len; i += 4) {
          encoded1 = BASE_CHARS.indexOf(serializedString[i]);
          encoded2 = BASE_CHARS.indexOf(serializedString[i + 1]);
          encoded3 = BASE_CHARS.indexOf(serializedString[i + 2]);
          encoded4 = BASE_CHARS.indexOf(serializedString[i + 3]);

          /*jslint bitwise: true */
          bytes[p++] = encoded1 << 2 | encoded2 >> 4;
          bytes[p++] = (encoded2 & 15) << 4 | encoded3 >> 2;
          bytes[p++] = (encoded3 & 3) << 6 | encoded4 & 63;
        }
        return buffer;
      }

      // Converts a buffer to a string to store, serialized, in the backend
      // storage library.
      function bufferToString(buffer) {
        // base64-arraybuffer
        var bytes = new Uint8Array(buffer);
        var base64String = '';
        var i;
        for (i = 0; i < bytes.length; i += 3) {
          /*jslint bitwise: true */
          base64String += BASE_CHARS[bytes[i] >> 2];
          base64String += BASE_CHARS[(bytes[i] & 3) << 4 | bytes[i + 1] >> 4];
          base64String += BASE_CHARS[(bytes[i + 1] & 15) << 2 | bytes[i + 2] >> 6];
          base64String += BASE_CHARS[bytes[i + 2] & 63];
        }
        if (bytes.length % 3 === 2) {
          base64String = base64String.substring(0, base64String.length - 1) + '=';
        } else if (bytes.length % 3 === 1) {
          base64String = base64String.substring(0, base64String.length - 2) + '==';
        }
        return base64String;
      }

      // Serialize a value, afterwards executing a callback (which usually
      // instructs the `setItem()` callback/promise to be executed). This is how
      // we store binary data with localStorage.
      function serialize(value, callback) {
        var valueType = '';
        if (value) {
          valueType = toString$1.call(value);
        }

        // Cannot use `value instanceof ArrayBuffer` or such here, as these
        // checks fail when running the tests using casper.js...
        //
        // TODO: See why those tests fail and use a better solution.
        if (value && (valueType === '[object ArrayBuffer]' || value.buffer && toString$1.call(value.buffer) === '[object ArrayBuffer]')) {
          // Convert binary arrays to a string and prefix the string with
          // a special marker.
          var buffer;
          var marker = SERIALIZED_MARKER;
          if (value instanceof ArrayBuffer) {
            buffer = value;
            marker += TYPE_ARRAYBUFFER;
          } else {
            buffer = value.buffer;
            if (valueType === '[object Int8Array]') {
              marker += TYPE_INT8ARRAY;
            } else if (valueType === '[object Uint8Array]') {
              marker += TYPE_UINT8ARRAY;
            } else if (valueType === '[object Uint8ClampedArray]') {
              marker += TYPE_UINT8CLAMPEDARRAY;
            } else if (valueType === '[object Int16Array]') {
              marker += TYPE_INT16ARRAY;
            } else if (valueType === '[object Uint16Array]') {
              marker += TYPE_UINT16ARRAY;
            } else if (valueType === '[object Int32Array]') {
              marker += TYPE_INT32ARRAY;
            } else if (valueType === '[object Uint32Array]') {
              marker += TYPE_UINT32ARRAY;
            } else if (valueType === '[object Float32Array]') {
              marker += TYPE_FLOAT32ARRAY;
            } else if (valueType === '[object Float64Array]') {
              marker += TYPE_FLOAT64ARRAY;
            } else {
              callback(new Error('Failed to get type for BinaryArray'));
            }
          }
          callback(marker + bufferToString(buffer));
        } else if (valueType === '[object Blob]') {
          // Conver the blob to a binaryArray and then to a string.
          var fileReader = new FileReader();
          fileReader.onload = function () {
            // Backwards-compatible prefix for the blob type.
            var str = BLOB_TYPE_PREFIX + value.type + '~' + bufferToString(this.result);
            callback(SERIALIZED_MARKER + TYPE_BLOB + str);
          };
          fileReader.readAsArrayBuffer(value);
        } else {
          try {
            callback(JSON.stringify(value));
          } catch (e) {
            console.error("Couldn't convert value into a JSON string: ", value);
            callback(null, e);
          }
        }
      }

      // Deserialize data we've inserted into a value column/field. We place
      // special markers into our strings to mark them as encoded; this isn't
      // as nice as a meta field, but it's the only sane thing we can do whilst
      // keeping localStorage support intact.
      //
      // Oftentimes this will just deserialize JSON content, but if we have a
      // special marker (SERIALIZED_MARKER, defined above), we will extract
      // some kind of arraybuffer/binary data/typed array out of the string.
      function deserialize(value) {
        // If we haven't marked this string as being specially serialized (i.e.
        // something other than serialized JSON), we can just return it and be
        // done with it.
        if (value.substring(0, SERIALIZED_MARKER_LENGTH) !== SERIALIZED_MARKER) {
          return JSON.parse(value);
        }

        // The following code deals with deserializing some kind of Blob or
        // TypedArray. First we separate out the type of data we're dealing
        // with from the data itself.
        var serializedString = value.substring(TYPE_SERIALIZED_MARKER_LENGTH);
        var type = value.substring(SERIALIZED_MARKER_LENGTH, TYPE_SERIALIZED_MARKER_LENGTH);
        var blobType;
        // Backwards-compatible blob type serialization strategy.
        // DBs created with older versions of localForage will simply not have the blob type.
        if (type === TYPE_BLOB && BLOB_TYPE_PREFIX_REGEX.test(serializedString)) {
          var matcher = serializedString.match(BLOB_TYPE_PREFIX_REGEX);
          blobType = matcher[1];
          serializedString = serializedString.substring(matcher[0].length);
        }
        var buffer = stringToBuffer(serializedString);

        // Return the right type based on the code/type set during
        // serialization.
        switch (type) {
          case TYPE_ARRAYBUFFER:
            return buffer;
          case TYPE_BLOB:
            return createBlob([buffer], {
              type: blobType
            });
          case TYPE_INT8ARRAY:
            return new Int8Array(buffer);
          case TYPE_UINT8ARRAY:
            return new Uint8Array(buffer);
          case TYPE_UINT8CLAMPEDARRAY:
            return new Uint8ClampedArray(buffer);
          case TYPE_INT16ARRAY:
            return new Int16Array(buffer);
          case TYPE_UINT16ARRAY:
            return new Uint16Array(buffer);
          case TYPE_INT32ARRAY:
            return new Int32Array(buffer);
          case TYPE_UINT32ARRAY:
            return new Uint32Array(buffer);
          case TYPE_FLOAT32ARRAY:
            return new Float32Array(buffer);
          case TYPE_FLOAT64ARRAY:
            return new Float64Array(buffer);
          default:
            throw new Error('Unkown type: ' + type);
        }
      }
      var localforageSerializer = {
        serialize: serialize,
        deserialize: deserialize,
        stringToBuffer: stringToBuffer,
        bufferToString: bufferToString
      };

      /*
       * Includes code from:
       *
       * base64-arraybuffer
       * https://github.com/niklasvh/base64-arraybuffer
       *
       * Copyright (c) 2012 Niklas von Hertzen
       * Licensed under the MIT license.
       */

      function createDbTable(t, dbInfo, callback, errorCallback) {
        t.executeSql('CREATE TABLE IF NOT EXISTS ' + dbInfo.storeName + ' ' + '(id INTEGER PRIMARY KEY, key unique, value)', [], callback, errorCallback);
      }

      // Open the WebSQL database (automatically creates one if one didn't
      // previously exist), using any options set in the config.
      function _initStorage$1(options) {
        var self = this;
        var dbInfo = {
          db: null
        };
        if (options) {
          for (var i in options) {
            dbInfo[i] = typeof options[i] !== 'string' ? options[i].toString() : options[i];
          }
        }
        var dbInfoPromise = new Promise$1(function (resolve, reject) {
          // Open the database; the openDatabase API will automatically
          // create it for us if it doesn't exist.
          try {
            dbInfo.db = openDatabase(dbInfo.name, String(dbInfo.version), dbInfo.description, dbInfo.size);
          } catch (e) {
            return reject(e);
          }

          // Create our key/value table if it doesn't exist.
          dbInfo.db.transaction(function (t) {
            createDbTable(t, dbInfo, function () {
              self._dbInfo = dbInfo;
              resolve();
            }, function (t, error) {
              reject(error);
            });
          }, reject);
        });
        dbInfo.serializer = localforageSerializer;
        return dbInfoPromise;
      }
      function tryExecuteSql(t, dbInfo, sqlStatement, args, callback, errorCallback) {
        t.executeSql(sqlStatement, args, callback, function (t, error) {
          if (error.code === error.SYNTAX_ERR) {
            t.executeSql('SELECT name FROM sqlite_master ' + "WHERE type='table' AND name = ?", [dbInfo.storeName], function (t, results) {
              if (!results.rows.length) {
                // if the table is missing (was deleted)
                // re-create it table and retry
                createDbTable(t, dbInfo, function () {
                  t.executeSql(sqlStatement, args, callback, errorCallback);
                }, errorCallback);
              } else {
                errorCallback(t, error);
              }
            }, errorCallback);
          } else {
            errorCallback(t, error);
          }
        }, errorCallback);
      }
      function getItem$1(key, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              tryExecuteSql(t, dbInfo, 'SELECT * FROM ' + dbInfo.storeName + ' WHERE key = ? LIMIT 1', [key], function (t, results) {
                var result = results.rows.length ? results.rows.item(0).value : null;

                // Check to see if this is serialized content we need to
                // unpack.
                if (result) {
                  result = dbInfo.serializer.deserialize(result);
                }
                resolve(result);
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function iterate$1(iterator, callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              tryExecuteSql(t, dbInfo, 'SELECT * FROM ' + dbInfo.storeName, [], function (t, results) {
                var rows = results.rows;
                var length = rows.length;
                for (var i = 0; i < length; i++) {
                  var item = rows.item(i);
                  var result = item.value;

                  // Check to see if this is serialized content
                  // we need to unpack.
                  if (result) {
                    result = dbInfo.serializer.deserialize(result);
                  }
                  result = iterator(result, item.key, i + 1);

                  // void(0) prevents problems with redefinition
                  // of `undefined`.
                  if (result !== void 0) {
                    resolve(result);
                    return;
                  }
                }
                resolve();
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function _setItem(key, value, callback, retriesLeft) {
        var self = this;
        key = normalizeKey(key);
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            // The localStorage API doesn't return undefined values in an
            // "expected" way, so undefined is always cast to null in all
            // drivers. See: https://github.com/mozilla/localForage/pull/42
            if (value === undefined) {
              value = null;
            }

            // Save the original value to pass to the callback.
            var originalValue = value;
            var dbInfo = self._dbInfo;
            dbInfo.serializer.serialize(value, function (value, error) {
              if (error) {
                reject(error);
              } else {
                dbInfo.db.transaction(function (t) {
                  tryExecuteSql(t, dbInfo, 'INSERT OR REPLACE INTO ' + dbInfo.storeName + ' ' + '(key, value) VALUES (?, ?)', [key, value], function () {
                    resolve(originalValue);
                  }, function (t, error) {
                    reject(error);
                  });
                }, function (sqlError) {
                  // The transaction failed; check
                  // to see if it's a quota error.
                  if (sqlError.code === sqlError.QUOTA_ERR) {
                    // We reject the callback outright for now, but
                    // it's worth trying to re-run the transaction.
                    // Even if the user accepts the prompt to use
                    // more storage on Safari, this error will
                    // be called.
                    //
                    // Try to re-run the transaction.
                    if (retriesLeft > 0) {
                      resolve(_setItem.apply(self, [key, originalValue, callback, retriesLeft - 1]));
                      return;
                    }
                    reject(sqlError);
                  }
                });
              }
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function setItem$1(key, value, callback) {
        return _setItem.apply(this, [key, value, callback, 1]);
      }
      function removeItem$1(key, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              tryExecuteSql(t, dbInfo, 'DELETE FROM ' + dbInfo.storeName + ' WHERE key = ?', [key], function () {
                resolve();
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Deletes every item in the table.
      // TODO: Find out if this resets the AUTO_INCREMENT number.
      function clear$1(callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              tryExecuteSql(t, dbInfo, 'DELETE FROM ' + dbInfo.storeName, [], function () {
                resolve();
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Does a simple `COUNT(key)` to get the number of items stored in
      // localForage.
      function length$1(callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              // Ahhh, SQL makes this one soooooo easy.
              tryExecuteSql(t, dbInfo, 'SELECT COUNT(key) as c FROM ' + dbInfo.storeName, [], function (t, results) {
                var result = results.rows.item(0).c;
                resolve(result);
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Return the key located at key index X; essentially gets the key from a
      // `WHERE id = ?`. This is the most efficient way I can think to implement
      // this rarely-used (in my experience) part of the API, but it can seem
      // inconsistent, because we do `INSERT OR REPLACE INTO` on `setItem()`, so
      // the ID of each key will change every time it's updated. Perhaps a stored
      // procedure for the `setItem()` SQL would solve this problem?
      // TODO: Don't change ID on `setItem()`.
      function key$1(n, callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              tryExecuteSql(t, dbInfo, 'SELECT key FROM ' + dbInfo.storeName + ' WHERE id = ? LIMIT 1', [n + 1], function (t, results) {
                var result = results.rows.length ? results.rows.item(0).key : null;
                resolve(result);
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }
      function keys$1(callback) {
        var self = this;
        var promise = new Promise$1(function (resolve, reject) {
          self.ready().then(function () {
            var dbInfo = self._dbInfo;
            dbInfo.db.transaction(function (t) {
              tryExecuteSql(t, dbInfo, 'SELECT key FROM ' + dbInfo.storeName, [], function (t, results) {
                var keys = [];
                for (var i = 0; i < results.rows.length; i++) {
                  keys.push(results.rows.item(i).key);
                }
                resolve(keys);
              }, function (t, error) {
                reject(error);
              });
            });
          })["catch"](reject);
        });
        executeCallback(promise, callback);
        return promise;
      }

      // https://www.w3.org/TR/webdatabase/#databases
      // > There is no way to enumerate or delete the databases available for an origin from this API.
      function getAllStoreNames(db) {
        return new Promise$1(function (resolve, reject) {
          db.transaction(function (t) {
            t.executeSql('SELECT name FROM sqlite_master ' + "WHERE type='table' AND name <> '__WebKitDatabaseInfoTable__'", [], function (t, results) {
              var storeNames = [];
              for (var i = 0; i < results.rows.length; i++) {
                storeNames.push(results.rows.item(i).name);
              }
              resolve({
                db: db,
                storeNames: storeNames
              });
            }, function (t, error) {
              reject(error);
            });
          }, function (sqlError) {
            reject(sqlError);
          });
        });
      }
      function dropInstance$1(options, callback) {
        callback = getCallback.apply(this, arguments);
        var currentConfig = this.config();
        options = typeof options !== 'function' && options || {};
        if (!options.name) {
          options.name = options.name || currentConfig.name;
          options.storeName = options.storeName || currentConfig.storeName;
        }
        var self = this;
        var promise;
        if (!options.name) {
          promise = Promise$1.reject('Invalid arguments');
        } else {
          promise = new Promise$1(function (resolve) {
            var db;
            if (options.name === currentConfig.name) {
              // use the db reference of the current instance
              db = self._dbInfo.db;
            } else {
              db = openDatabase(options.name, '', '', 0);
            }
            if (!options.storeName) {
              // drop all database tables
              resolve(getAllStoreNames(db));
            } else {
              resolve({
                db: db,
                storeNames: [options.storeName]
              });
            }
          }).then(function (operationInfo) {
            return new Promise$1(function (resolve, reject) {
              operationInfo.db.transaction(function (t) {
                function dropTable(storeName) {
                  return new Promise$1(function (resolve, reject) {
                    t.executeSql('DROP TABLE IF EXISTS ' + storeName, [], function () {
                      resolve();
                    }, function (t, error) {
                      reject(error);
                    });
                  });
                }
                var operations = [];
                for (var i = 0, len = operationInfo.storeNames.length; i < len; i++) {
                  operations.push(dropTable(operationInfo.storeNames[i]));
                }
                Promise$1.all(operations).then(function () {
                  resolve();
                })["catch"](function (e) {
                  reject(e);
                });
              }, function (sqlError) {
                reject(sqlError);
              });
            });
          });
        }
        executeCallback(promise, callback);
        return promise;
      }
      var webSQLStorage = {
        _driver: 'webSQLStorage',
        _initStorage: _initStorage$1,
        _support: isWebSQLValid(),
        iterate: iterate$1,
        getItem: getItem$1,
        setItem: setItem$1,
        removeItem: removeItem$1,
        clear: clear$1,
        length: length$1,
        key: key$1,
        keys: keys$1,
        dropInstance: dropInstance$1
      };
      function isLocalStorageValid() {
        try {
          return typeof localStorage !== 'undefined' && 'setItem' in localStorage &&
          // in IE8 typeof localStorage.setItem === 'object'
          !!localStorage.setItem;
        } catch (e) {
          return false;
        }
      }
      function _getKeyPrefix(options, defaultConfig) {
        var keyPrefix = options.name + '/';
        if (options.storeName !== defaultConfig.storeName) {
          keyPrefix += options.storeName + '/';
        }
        return keyPrefix;
      }

      // Check if localStorage throws when saving an item
      function checkIfLocalStorageThrows() {
        var localStorageTestKey = '_localforage_support_test';
        try {
          localStorage.setItem(localStorageTestKey, true);
          localStorage.removeItem(localStorageTestKey);
          return false;
        } catch (e) {
          return true;
        }
      }

      // Check if localStorage is usable and allows to save an item
      // This method checks if localStorage is usable in Safari Private Browsing
      // mode, or in any other case where the available quota for localStorage
      // is 0 and there wasn't any saved items yet.
      function _isLocalStorageUsable() {
        return !checkIfLocalStorageThrows() || localStorage.length > 0;
      }

      // Config the localStorage backend, using options set in the config.
      function _initStorage$2(options) {
        var self = this;
        var dbInfo = {};
        if (options) {
          for (var i in options) {
            dbInfo[i] = options[i];
          }
        }
        dbInfo.keyPrefix = _getKeyPrefix(options, self._defaultConfig);
        if (!_isLocalStorageUsable()) {
          return Promise$1.reject();
        }
        self._dbInfo = dbInfo;
        dbInfo.serializer = localforageSerializer;
        return Promise$1.resolve();
      }

      // Remove all keys from the datastore, effectively destroying all data in
      // the app's key/value store!
      function clear$2(callback) {
        var self = this;
        var promise = self.ready().then(function () {
          var keyPrefix = self._dbInfo.keyPrefix;
          for (var i = localStorage.length - 1; i >= 0; i--) {
            var key = localStorage.key(i);
            if (key.indexOf(keyPrefix) === 0) {
              localStorage.removeItem(key);
            }
          }
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Retrieve an item from the store. Unlike the original async_storage
      // library in Gaia, we don't modify return values at all. If a key's value
      // is `undefined`, we pass that value to the callback function.
      function getItem$2(key, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = self.ready().then(function () {
          var dbInfo = self._dbInfo;
          var result = localStorage.getItem(dbInfo.keyPrefix + key);

          // If a result was found, parse it from the serialized
          // string into a JS object. If result isn't truthy, the key
          // is likely undefined and we'll pass it straight to the
          // callback.
          if (result) {
            result = dbInfo.serializer.deserialize(result);
          }
          return result;
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Iterate over all items in the store.
      function iterate$2(iterator, callback) {
        var self = this;
        var promise = self.ready().then(function () {
          var dbInfo = self._dbInfo;
          var keyPrefix = dbInfo.keyPrefix;
          var keyPrefixLength = keyPrefix.length;
          var length = localStorage.length;

          // We use a dedicated iterator instead of the `i` variable below
          // so other keys we fetch in localStorage aren't counted in
          // the `iterationNumber` argument passed to the `iterate()`
          // callback.
          //
          // See: github.com/mozilla/localForage/pull/435#discussion_r38061530
          var iterationNumber = 1;
          for (var i = 0; i < length; i++) {
            var key = localStorage.key(i);
            if (key.indexOf(keyPrefix) !== 0) {
              continue;
            }
            var value = localStorage.getItem(key);

            // If a result was found, parse it from the serialized
            // string into a JS object. If result isn't truthy, the
            // key is likely undefined and we'll pass it straight
            // to the iterator.
            if (value) {
              value = dbInfo.serializer.deserialize(value);
            }
            value = iterator(value, key.substring(keyPrefixLength), iterationNumber++);
            if (value !== void 0) {
              return value;
            }
          }
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Same as localStorage's key() method, except takes a callback.
      function key$2(n, callback) {
        var self = this;
        var promise = self.ready().then(function () {
          var dbInfo = self._dbInfo;
          var result;
          try {
            result = localStorage.key(n);
          } catch (error) {
            result = null;
          }

          // Remove the prefix from the key, if a key is found.
          if (result) {
            result = result.substring(dbInfo.keyPrefix.length);
          }
          return result;
        });
        executeCallback(promise, callback);
        return promise;
      }
      function keys$2(callback) {
        var self = this;
        var promise = self.ready().then(function () {
          var dbInfo = self._dbInfo;
          var length = localStorage.length;
          var keys = [];
          for (var i = 0; i < length; i++) {
            var itemKey = localStorage.key(i);
            if (itemKey.indexOf(dbInfo.keyPrefix) === 0) {
              keys.push(itemKey.substring(dbInfo.keyPrefix.length));
            }
          }
          return keys;
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Supply the number of keys in the datastore to the callback function.
      function length$2(callback) {
        var self = this;
        var promise = self.keys().then(function (keys) {
          return keys.length;
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Remove an item from the store, nice and simple.
      function removeItem$2(key, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = self.ready().then(function () {
          var dbInfo = self._dbInfo;
          localStorage.removeItem(dbInfo.keyPrefix + key);
        });
        executeCallback(promise, callback);
        return promise;
      }

      // Set a key's value and run an optional callback once the value is set.
      // Unlike Gaia's implementation, the callback function is passed the value,
      // in case you want to operate on that value only after you're sure it
      // saved, or something like that.
      function setItem$2(key, value, callback) {
        var self = this;
        key = normalizeKey(key);
        var promise = self.ready().then(function () {
          // Convert undefined values to null.
          // https://github.com/mozilla/localForage/pull/42
          if (value === undefined) {
            value = null;
          }

          // Save the original value to pass to the callback.
          var originalValue = value;
          return new Promise$1(function (resolve, reject) {
            var dbInfo = self._dbInfo;
            dbInfo.serializer.serialize(value, function (value, error) {
              if (error) {
                reject(error);
              } else {
                try {
                  localStorage.setItem(dbInfo.keyPrefix + key, value);
                  resolve(originalValue);
                } catch (e) {
                  // localStorage capacity exceeded.
                  // TODO: Make this a specific error/event.
                  if (e.name === 'QuotaExceededError' || e.name === 'NS_ERROR_DOM_QUOTA_REACHED') {
                    reject(e);
                  }
                  reject(e);
                }
              }
            });
          });
        });
        executeCallback(promise, callback);
        return promise;
      }
      function dropInstance$2(options, callback) {
        callback = getCallback.apply(this, arguments);
        options = typeof options !== 'function' && options || {};
        if (!options.name) {
          var currentConfig = this.config();
          options.name = options.name || currentConfig.name;
          options.storeName = options.storeName || currentConfig.storeName;
        }
        var self = this;
        var promise;
        if (!options.name) {
          promise = Promise$1.reject('Invalid arguments');
        } else {
          promise = new Promise$1(function (resolve) {
            if (!options.storeName) {
              resolve(options.name + '/');
            } else {
              resolve(_getKeyPrefix(options, self._defaultConfig));
            }
          }).then(function (keyPrefix) {
            for (var i = localStorage.length - 1; i >= 0; i--) {
              var key = localStorage.key(i);
              if (key.indexOf(keyPrefix) === 0) {
                localStorage.removeItem(key);
              }
            }
          });
        }
        executeCallback(promise, callback);
        return promise;
      }
      var localStorageWrapper = {
        _driver: 'localStorageWrapper',
        _initStorage: _initStorage$2,
        _support: isLocalStorageValid(),
        iterate: iterate$2,
        getItem: getItem$2,
        setItem: setItem$2,
        removeItem: removeItem$2,
        clear: clear$2,
        length: length$2,
        key: key$2,
        keys: keys$2,
        dropInstance: dropInstance$2
      };
      var sameValue = function sameValue(x, y) {
        return x === y || typeof x === 'number' && typeof y === 'number' && isNaN(x) && isNaN(y);
      };
      var includes = function includes(array, searchElement) {
        var len = array.length;
        var i = 0;
        while (i < len) {
          if (sameValue(array[i], searchElement)) {
            return true;
          }
          i++;
        }
        return false;
      };
      var isArray = Array.isArray || function (arg) {
        return Object.prototype.toString.call(arg) === '[object Array]';
      };

      // Drivers are stored here when `defineDriver()` is called.
      // They are shared across all instances of localForage.
      var DefinedDrivers = {};
      var DriverSupport = {};
      var DefaultDrivers = {
        INDEXEDDB: asyncStorage,
        WEBSQL: webSQLStorage,
        LOCALSTORAGE: localStorageWrapper
      };
      var DefaultDriverOrder = [DefaultDrivers.INDEXEDDB._driver, DefaultDrivers.WEBSQL._driver, DefaultDrivers.LOCALSTORAGE._driver];
      var OptionalDriverMethods = ['dropInstance'];
      var LibraryMethods = ['clear', 'getItem', 'iterate', 'key', 'keys', 'length', 'removeItem', 'setItem'].concat(OptionalDriverMethods);
      var DefaultConfig = {
        description: '',
        driver: DefaultDriverOrder.slice(),
        name: 'localforage',
        // Default DB size is _JUST UNDER_ 5MB, as it's the highest size
        // we can use without a prompt.
        size: 4980736,
        storeName: 'keyvaluepairs',
        version: 1.0
      };
      function callWhenReady(localForageInstance, libraryMethod) {
        localForageInstance[libraryMethod] = function () {
          var _args = arguments;
          return localForageInstance.ready().then(function () {
            return localForageInstance[libraryMethod].apply(localForageInstance, _args);
          });
        };
      }
      function extend() {
        for (var i = 1; i < arguments.length; i++) {
          var arg = arguments[i];
          if (arg) {
            for (var _key in arg) {
              if (arg.hasOwnProperty(_key)) {
                if (isArray(arg[_key])) {
                  arguments[0][_key] = arg[_key].slice();
                } else {
                  arguments[0][_key] = arg[_key];
                }
              }
            }
          }
        }
        return arguments[0];
      }
      var LocalForage = function () {
        function LocalForage(options) {
          _classCallCheck(this, LocalForage);
          for (var driverTypeKey in DefaultDrivers) {
            if (DefaultDrivers.hasOwnProperty(driverTypeKey)) {
              var driver = DefaultDrivers[driverTypeKey];
              var driverName = driver._driver;
              this[driverTypeKey] = driverName;
              if (!DefinedDrivers[driverName]) {
                // we don't need to wait for the promise,
                // since the default drivers can be defined
                // in a blocking manner
                this.defineDriver(driver);
              }
            }
          }
          this._defaultConfig = extend({}, DefaultConfig);
          this._config = extend({}, this._defaultConfig, options);
          this._driverSet = null;
          this._initDriver = null;
          this._ready = false;
          this._dbInfo = null;
          this._wrapLibraryMethodsWithReady();
          this.setDriver(this._config.driver)["catch"](function () {});
        }

        // Set any config values for localForage; can be called anytime before
        // the first API call (e.g. `getItem`, `setItem`).
        // We loop through options so we don't overwrite existing config
        // values.

        LocalForage.prototype.config = function config(options) {
          // If the options argument is an object, we use it to set values.
          // Otherwise, we return either a specified config value or all
          // config values.
          if ((typeof options === 'undefined' ? 'undefined' : _typeof(options)) === 'object') {
            // If localforage is ready and fully initialized, we can't set
            // any new configuration values. Instead, we return an error.
            if (this._ready) {
              return new Error("Can't call config() after localforage " + 'has been used.');
            }
            for (var i in options) {
              if (i === 'storeName') {
                options[i] = options[i].replace(/\W/g, '_');
              }
              if (i === 'version' && typeof options[i] !== 'number') {
                return new Error('Database version must be a number.');
              }
              this._config[i] = options[i];
            }

            // after all config options are set and
            // the driver option is used, try setting it
            if ('driver' in options && options.driver) {
              return this.setDriver(this._config.driver);
            }
            return true;
          } else if (typeof options === 'string') {
            return this._config[options];
          } else {
            return this._config;
          }
        };

        // Used to define a custom driver, shared across all instances of
        // localForage.

        LocalForage.prototype.defineDriver = function defineDriver(driverObject, callback, errorCallback) {
          var promise = new Promise$1(function (resolve, reject) {
            try {
              var driverName = driverObject._driver;
              var complianceError = new Error('Custom driver not compliant; see ' + 'https://mozilla.github.io/localForage/#definedriver');

              // A driver name should be defined and not overlap with the
              // library-defined, default drivers.
              if (!driverObject._driver) {
                reject(complianceError);
                return;
              }
              var driverMethods = LibraryMethods.concat('_initStorage');
              for (var i = 0, len = driverMethods.length; i < len; i++) {
                var driverMethodName = driverMethods[i];

                // when the property is there,
                // it should be a method even when optional
                var isRequired = !includes(OptionalDriverMethods, driverMethodName);
                if ((isRequired || driverObject[driverMethodName]) && typeof driverObject[driverMethodName] !== 'function') {
                  reject(complianceError);
                  return;
                }
              }
              var configureMissingMethods = function configureMissingMethods() {
                var methodNotImplementedFactory = function methodNotImplementedFactory(methodName) {
                  return function () {
                    var error = new Error('Method ' + methodName + ' is not implemented by the current driver');
                    var promise = Promise$1.reject(error);
                    executeCallback(promise, arguments[arguments.length - 1]);
                    return promise;
                  };
                };
                for (var _i = 0, _len = OptionalDriverMethods.length; _i < _len; _i++) {
                  var optionalDriverMethod = OptionalDriverMethods[_i];
                  if (!driverObject[optionalDriverMethod]) {
                    driverObject[optionalDriverMethod] = methodNotImplementedFactory(optionalDriverMethod);
                  }
                }
              };
              configureMissingMethods();
              var setDriverSupport = function setDriverSupport(support) {
                if (DefinedDrivers[driverName]) {
                  console.info('Redefining LocalForage driver: ' + driverName);
                }
                DefinedDrivers[driverName] = driverObject;
                DriverSupport[driverName] = support;
                // don't use a then, so that we can define
                // drivers that have simple _support methods
                // in a blocking manner
                resolve();
              };
              if ('_support' in driverObject) {
                if (driverObject._support && typeof driverObject._support === 'function') {
                  driverObject._support().then(setDriverSupport, reject);
                } else {
                  setDriverSupport(!!driverObject._support);
                }
              } else {
                setDriverSupport(true);
              }
            } catch (e) {
              reject(e);
            }
          });
          executeTwoCallbacks(promise, callback, errorCallback);
          return promise;
        };
        LocalForage.prototype.driver = function driver() {
          return this._driver || null;
        };
        LocalForage.prototype.getDriver = function getDriver(driverName, callback, errorCallback) {
          var getDriverPromise = DefinedDrivers[driverName] ? Promise$1.resolve(DefinedDrivers[driverName]) : Promise$1.reject(new Error('Driver not found.'));
          executeTwoCallbacks(getDriverPromise, callback, errorCallback);
          return getDriverPromise;
        };
        LocalForage.prototype.getSerializer = function getSerializer(callback) {
          var serializerPromise = Promise$1.resolve(localforageSerializer);
          executeTwoCallbacks(serializerPromise, callback);
          return serializerPromise;
        };
        LocalForage.prototype.ready = function ready(callback) {
          var self = this;
          var promise = self._driverSet.then(function () {
            if (self._ready === null) {
              self._ready = self._initDriver();
            }
            return self._ready;
          });
          executeTwoCallbacks(promise, callback, callback);
          return promise;
        };
        LocalForage.prototype.setDriver = function setDriver(drivers, callback, errorCallback) {
          var self = this;
          if (!isArray(drivers)) {
            drivers = [drivers];
          }
          var supportedDrivers = this._getSupportedDrivers(drivers);
          function setDriverToConfig() {
            self._config.driver = self.driver();
          }
          function extendSelfWithDriver(driver) {
            self._extend(driver);
            setDriverToConfig();
            self._ready = self._initStorage(self._config);
            return self._ready;
          }
          function initDriver(supportedDrivers) {
            return function () {
              var currentDriverIndex = 0;
              function driverPromiseLoop() {
                while (currentDriverIndex < supportedDrivers.length) {
                  var driverName = supportedDrivers[currentDriverIndex];
                  currentDriverIndex++;
                  self._dbInfo = null;
                  self._ready = null;
                  return self.getDriver(driverName).then(extendSelfWithDriver)["catch"](driverPromiseLoop);
                }
                setDriverToConfig();
                var error = new Error('No available storage method found.');
                self._driverSet = Promise$1.reject(error);
                return self._driverSet;
              }
              return driverPromiseLoop();
            };
          }

          // There might be a driver initialization in progress
          // so wait for it to finish in order to avoid a possible
          // race condition to set _dbInfo
          var oldDriverSetDone = this._driverSet !== null ? this._driverSet["catch"](function () {
            return Promise$1.resolve();
          }) : Promise$1.resolve();
          this._driverSet = oldDriverSetDone.then(function () {
            var driverName = supportedDrivers[0];
            self._dbInfo = null;
            self._ready = null;
            return self.getDriver(driverName).then(function (driver) {
              self._driver = driver._driver;
              setDriverToConfig();
              self._wrapLibraryMethodsWithReady();
              self._initDriver = initDriver(supportedDrivers);
            });
          })["catch"](function () {
            setDriverToConfig();
            var error = new Error('No available storage method found.');
            self._driverSet = Promise$1.reject(error);
            return self._driverSet;
          });
          executeTwoCallbacks(this._driverSet, callback, errorCallback);
          return this._driverSet;
        };
        LocalForage.prototype.supports = function supports(driverName) {
          return !!DriverSupport[driverName];
        };
        LocalForage.prototype._extend = function _extend(libraryMethodsAndProperties) {
          extend(this, libraryMethodsAndProperties);
        };
        LocalForage.prototype._getSupportedDrivers = function _getSupportedDrivers(drivers) {
          var supportedDrivers = [];
          for (var i = 0, len = drivers.length; i < len; i++) {
            var driverName = drivers[i];
            if (this.supports(driverName)) {
              supportedDrivers.push(driverName);
            }
          }
          return supportedDrivers;
        };
        LocalForage.prototype._wrapLibraryMethodsWithReady = function _wrapLibraryMethodsWithReady() {
          // Add a stub for each driver API method that delays the call to the
          // corresponding driver method until localForage is ready. These stubs
          // will be replaced by the driver methods as soon as the driver is
          // loaded, so there is no performance impact.
          for (var i = 0, len = LibraryMethods.length; i < len; i++) {
            callWhenReady(this, LibraryMethods[i]);
          }
        };
        LocalForage.prototype.createInstance = function createInstance(options) {
          return new LocalForage(options);
        };
        return LocalForage;
      }();

      // The actual localForage object that we expose as a module or via a
      // global. It's extended by pulling in one of our other libraries.

      var localforage_js = new LocalForage();
      module.exports = localforage_js;
    }, {
      "3": 3
    }]
  }, {}, [4])(4);
});

/***/ }),

/***/ "./node_modules/path-browserify/index.js":
/*!***********************************************!*\
  !*** ./node_modules/path-browserify/index.js ***!
  \***********************************************/
/***/ (function(module) {

"use strict";
// 'path' module extracted from Node.js v8.11.1 (only the posix part)
// transplited with Babel

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



function assertPath(path) {
  if (typeof path !== 'string') {
    throw new TypeError('Path must be a string. Received ' + JSON.stringify(path));
  }
}

// Resolves . and .. elements in a path with directory names
function normalizeStringPosix(path, allowAboveRoot) {
  var res = '';
  var lastSegmentLength = 0;
  var lastSlash = -1;
  var dots = 0;
  var code;
  for (var i = 0; i <= path.length; ++i) {
    if (i < path.length) code = path.charCodeAt(i);else if (code === 47 /*/*/) break;else code = 47 /*/*/;
    if (code === 47 /*/*/) {
      if (lastSlash === i - 1 || dots === 1) {
        // NOOP
      } else if (lastSlash !== i - 1 && dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 /*.*/ || res.charCodeAt(res.length - 2) !== 46 /*.*/) {
          if (res.length > 2) {
            var lastSlashIndex = res.lastIndexOf('/');
            if (lastSlashIndex !== res.length - 1) {
              if (lastSlashIndex === -1) {
                res = '';
                lastSegmentLength = 0;
              } else {
                res = res.slice(0, lastSlashIndex);
                lastSegmentLength = res.length - 1 - res.lastIndexOf('/');
              }
              lastSlash = i;
              dots = 0;
              continue;
            }
          } else if (res.length === 2 || res.length === 1) {
            res = '';
            lastSegmentLength = 0;
            lastSlash = i;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          if (res.length > 0) res += '/..';else res = '..';
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) res += '/' + path.slice(lastSlash + 1, i);else res = path.slice(lastSlash + 1, i);
        lastSegmentLength = i - lastSlash - 1;
      }
      lastSlash = i;
      dots = 0;
    } else if (code === 46 /*.*/ && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
function _format(sep, pathObject) {
  var dir = pathObject.dir || pathObject.root;
  var base = pathObject.base || (pathObject.name || '') + (pathObject.ext || '');
  if (!dir) {
    return base;
  }
  if (dir === pathObject.root) {
    return dir + base;
  }
  return dir + sep + base;
}
var posix = {
  // path.resolve([from ...], to)
  resolve: function resolve() {
    var resolvedPath = '';
    var resolvedAbsolute = false;
    var cwd;
    for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      var path;
      if (i >= 0) path = arguments[i];else {
        if (cwd === undefined) cwd = process.cwd();
        path = cwd;
      }
      assertPath(path);

      // Skip empty entries
      if (path.length === 0) {
        continue;
      }
      resolvedPath = path + '/' + resolvedPath;
      resolvedAbsolute = path.charCodeAt(0) === 47 /*/*/;
    }

    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)

    // Normalize the path
    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
    if (resolvedAbsolute) {
      if (resolvedPath.length > 0) return '/' + resolvedPath;else return '/';
    } else if (resolvedPath.length > 0) {
      return resolvedPath;
    } else {
      return '.';
    }
  },
  normalize: function normalize(path) {
    assertPath(path);
    if (path.length === 0) return '.';
    var isAbsolute = path.charCodeAt(0) === 47 /*/*/;
    var trailingSeparator = path.charCodeAt(path.length - 1) === 47 /*/*/;

    // Normalize the path
    path = normalizeStringPosix(path, !isAbsolute);
    if (path.length === 0 && !isAbsolute) path = '.';
    if (path.length > 0 && trailingSeparator) path += '/';
    if (isAbsolute) return '/' + path;
    return path;
  },
  isAbsolute: function isAbsolute(path) {
    assertPath(path);
    return path.length > 0 && path.charCodeAt(0) === 47 /*/*/;
  },
  join: function join() {
    if (arguments.length === 0) return '.';
    var joined;
    for (var i = 0; i < arguments.length; ++i) {
      var arg = arguments[i];
      assertPath(arg);
      if (arg.length > 0) {
        if (joined === undefined) joined = arg;else joined += '/' + arg;
      }
    }
    if (joined === undefined) return '.';
    return posix.normalize(joined);
  },
  relative: function relative(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return '';
    from = posix.resolve(from);
    to = posix.resolve(to);
    if (from === to) return '';

    // Trim any leading backslashes
    var fromStart = 1;
    for (; fromStart < from.length; ++fromStart) {
      if (from.charCodeAt(fromStart) !== 47 /*/*/) break;
    }
    var fromEnd = from.length;
    var fromLen = fromEnd - fromStart;

    // Trim any leading backslashes
    var toStart = 1;
    for (; toStart < to.length; ++toStart) {
      if (to.charCodeAt(toStart) !== 47 /*/*/) break;
    }
    var toEnd = to.length;
    var toLen = toEnd - toStart;

    // Compare paths to find the longest common path from root
    var length = fromLen < toLen ? fromLen : toLen;
    var lastCommonSep = -1;
    var i = 0;
    for (; i <= length; ++i) {
      if (i === length) {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === 47 /*/*/) {
            // We get here if `from` is the exact base path for `to`.
            // For example: from='/foo/bar'; to='/foo/bar/baz'
            return to.slice(toStart + i + 1);
          } else if (i === 0) {
            // We get here if `from` is the root
            // For example: from='/'; to='/foo'
            return to.slice(toStart + i);
          }
        } else if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === 47 /*/*/) {
            // We get here if `to` is the exact base path for `from`.
            // For example: from='/foo/bar/baz'; to='/foo/bar'
            lastCommonSep = i;
          } else if (i === 0) {
            // We get here if `to` is the root.
            // For example: from='/foo'; to='/'
            lastCommonSep = 0;
          }
        }
        break;
      }
      var fromCode = from.charCodeAt(fromStart + i);
      var toCode = to.charCodeAt(toStart + i);
      if (fromCode !== toCode) break;else if (fromCode === 47 /*/*/) lastCommonSep = i;
    }
    var out = '';
    // Generate the relative path based on the path difference between `to`
    // and `from`
    for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
      if (i === fromEnd || from.charCodeAt(i) === 47 /*/*/) {
        if (out.length === 0) out += '..';else out += '/..';
      }
    }

    // Lastly, append the rest of the destination (`to`) path that comes after
    // the common path parts
    if (out.length > 0) return out + to.slice(toStart + lastCommonSep);else {
      toStart += lastCommonSep;
      if (to.charCodeAt(toStart) === 47 /*/*/) ++toStart;
      return to.slice(toStart);
    }
  },
  _makeLong: function _makeLong(path) {
    return path;
  },
  dirname: function dirname(path) {
    assertPath(path);
    if (path.length === 0) return '.';
    var code = path.charCodeAt(0);
    var hasRoot = code === 47 /*/*/;
    var end = -1;
    var matchedSlash = true;
    for (var i = path.length - 1; i >= 1; --i) {
      code = path.charCodeAt(i);
      if (code === 47 /*/*/) {
        if (!matchedSlash) {
          end = i;
          break;
        }
      } else {
        // We saw the first non-path separator
        matchedSlash = false;
      }
    }
    if (end === -1) return hasRoot ? '/' : '.';
    if (hasRoot && end === 1) return '//';
    return path.slice(0, end);
  },
  basename: function basename(path, ext) {
    if (ext !== undefined && typeof ext !== 'string') throw new TypeError('"ext" argument must be a string');
    assertPath(path);
    var start = 0;
    var end = -1;
    var matchedSlash = true;
    var i;
    if (ext !== undefined && ext.length > 0 && ext.length <= path.length) {
      if (ext.length === path.length && ext === path) return '';
      var extIdx = ext.length - 1;
      var firstNonSlashEnd = -1;
      for (i = path.length - 1; i >= 0; --i) {
        var code = path.charCodeAt(i);
        if (code === 47 /*/*/) {
          // If we reached a path separator that was not part of a set of path
          // separators at the end of the string, stop now
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else {
          if (firstNonSlashEnd === -1) {
            // We saw the first non-path separator, remember this index in case
            // we need it if the extension ends up not matching
            matchedSlash = false;
            firstNonSlashEnd = i + 1;
          }
          if (extIdx >= 0) {
            // Try to match the explicit extension
            if (code === ext.charCodeAt(extIdx)) {
              if (--extIdx === -1) {
                // We matched the extension, so mark this as the end of our path
                // component
                end = i;
              }
            } else {
              // Extension does not match, so our result is the entire path
              // component
              extIdx = -1;
              end = firstNonSlashEnd;
            }
          }
        }
      }
      if (start === end) end = firstNonSlashEnd;else if (end === -1) end = path.length;
      return path.slice(start, end);
    } else {
      for (i = path.length - 1; i >= 0; --i) {
        if (path.charCodeAt(i) === 47 /*/*/) {
          // If we reached a path separator that was not part of a set of path
          // separators at the end of the string, stop now
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else if (end === -1) {
          // We saw the first non-path separator, mark this as the end of our
          // path component
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) return '';
      return path.slice(start, end);
    }
  },
  extname: function extname(path) {
    assertPath(path);
    var startDot = -1;
    var startPart = 0;
    var end = -1;
    var matchedSlash = true;
    // Track the state of characters (if any) we see before our first dot and
    // after any path separator we find
    var preDotState = 0;
    for (var i = path.length - 1; i >= 0; --i) {
      var code = path.charCodeAt(i);
      if (code === 47 /*/*/) {
        // If we reached a path separator that was not part of a set of path
        // separators at the end of the string, stop now
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        // We saw the first non-path separator, mark this as the end of our
        // extension
        matchedSlash = false;
        end = i + 1;
      }
      if (code === 46 /*.*/) {
        // If this is our first dot, mark it as the start of our extension
        if (startDot === -1) startDot = i;else if (preDotState !== 1) preDotState = 1;
      } else if (startDot !== -1) {
        // We saw a non-dot and non-path separator before our dot, so we should
        // have a good chance at having a non-empty extension
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 ||
    // We saw a non-dot character immediately before the dot
    preDotState === 0 ||
    // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      return '';
    }
    return path.slice(startDot, end);
  },
  format: function format(pathObject) {
    if (pathObject === null || typeof pathObject !== 'object') {
      throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof pathObject);
    }
    return _format('/', pathObject);
  },
  parse: function parse(path) {
    assertPath(path);
    var ret = {
      root: '',
      dir: '',
      base: '',
      ext: '',
      name: ''
    };
    if (path.length === 0) return ret;
    var code = path.charCodeAt(0);
    var isAbsolute = code === 47 /*/*/;
    var start;
    if (isAbsolute) {
      ret.root = '/';
      start = 1;
    } else {
      start = 0;
    }
    var startDot = -1;
    var startPart = 0;
    var end = -1;
    var matchedSlash = true;
    var i = path.length - 1;

    // Track the state of characters (if any) we see before our first dot and
    // after any path separator we find
    var preDotState = 0;

    // Get non-dir info
    for (; i >= start; --i) {
      code = path.charCodeAt(i);
      if (code === 47 /*/*/) {
        // If we reached a path separator that was not part of a set of path
        // separators at the end of the string, stop now
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        // We saw the first non-path separator, mark this as the end of our
        // extension
        matchedSlash = false;
        end = i + 1;
      }
      if (code === 46 /*.*/) {
        // If this is our first dot, mark it as the start of our extension
        if (startDot === -1) startDot = i;else if (preDotState !== 1) preDotState = 1;
      } else if (startDot !== -1) {
        // We saw a non-dot and non-path separator before our dot, so we should
        // have a good chance at having a non-empty extension
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 ||
    // We saw a non-dot character immediately before the dot
    preDotState === 0 ||
    // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      if (end !== -1) {
        if (startPart === 0 && isAbsolute) ret.base = ret.name = path.slice(1, end);else ret.base = ret.name = path.slice(startPart, end);
      }
    } else {
      if (startPart === 0 && isAbsolute) {
        ret.name = path.slice(1, startDot);
        ret.base = path.slice(1, end);
      } else {
        ret.name = path.slice(startPart, startDot);
        ret.base = path.slice(startPart, end);
      }
      ret.ext = path.slice(startDot, end);
    }
    if (startPart > 0) ret.dir = path.slice(0, startPart - 1);else if (isAbsolute) ret.dir = '/';
    return ret;
  },
  sep: '/',
  delimiter: ':',
  win32: null,
  posix: null
};
posix.posix = posix;
module.exports = posix;

/***/ }),

/***/ "./node_modules/ua-parser-js/src/ua-parser.js":
/*!****************************************************!*\
  !*** ./node_modules/ua-parser-js/src/ua-parser.js ***!
  \****************************************************/
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;/////////////////////////////////////////////////////////////////////////////////
/* UAParser.js v1.0.38
   Copyright © 2012-2021 Faisal Salman <f@faisalman.com>
   MIT License */ /*
                  Detect Browser, Engine, OS, CPU, and Device type/model from User-Agent data.
                  Supports browser & node.js environment. 
                  Demo   : https://faisalman.github.io/ua-parser-js
                  Source : https://github.com/faisalman/ua-parser-js */
/////////////////////////////////////////////////////////////////////////////////

(function (window, undefined) {
  'use strict';

  //////////////
  // Constants
  /////////////
  var LIBVERSION = '1.0.38',
    EMPTY = '',
    UNKNOWN = '?',
    FUNC_TYPE = 'function',
    UNDEF_TYPE = 'undefined',
    OBJ_TYPE = 'object',
    STR_TYPE = 'string',
    MAJOR = 'major',
    MODEL = 'model',
    NAME = 'name',
    TYPE = 'type',
    VENDOR = 'vendor',
    VERSION = 'version',
    ARCHITECTURE = 'architecture',
    CONSOLE = 'console',
    MOBILE = 'mobile',
    TABLET = 'tablet',
    SMARTTV = 'smarttv',
    WEARABLE = 'wearable',
    EMBEDDED = 'embedded',
    UA_MAX_LENGTH = 500;
  var AMAZON = 'Amazon',
    APPLE = 'Apple',
    ASUS = 'ASUS',
    BLACKBERRY = 'BlackBerry',
    BROWSER = 'Browser',
    CHROME = 'Chrome',
    EDGE = 'Edge',
    FIREFOX = 'Firefox',
    GOOGLE = 'Google',
    HUAWEI = 'Huawei',
    LG = 'LG',
    MICROSOFT = 'Microsoft',
    MOTOROLA = 'Motorola',
    OPERA = 'Opera',
    SAMSUNG = 'Samsung',
    SHARP = 'Sharp',
    SONY = 'Sony',
    XIAOMI = 'Xiaomi',
    ZEBRA = 'Zebra',
    FACEBOOK = 'Facebook',
    CHROMIUM_OS = 'Chromium OS',
    MAC_OS = 'Mac OS';

  ///////////
  // Helper
  //////////

  var extend = function (regexes, extensions) {
      var mergedRegexes = {};
      for (var i in regexes) {
        if (extensions[i] && extensions[i].length % 2 === 0) {
          mergedRegexes[i] = extensions[i].concat(regexes[i]);
        } else {
          mergedRegexes[i] = regexes[i];
        }
      }
      return mergedRegexes;
    },
    enumerize = function (arr) {
      var enums = {};
      for (var i = 0; i < arr.length; i++) {
        enums[arr[i].toUpperCase()] = arr[i];
      }
      return enums;
    },
    has = function (str1, str2) {
      return typeof str1 === STR_TYPE ? lowerize(str2).indexOf(lowerize(str1)) !== -1 : false;
    },
    lowerize = function (str) {
      return str.toLowerCase();
    },
    majorize = function (version) {
      return typeof version === STR_TYPE ? version.replace(/[^\d\.]/g, EMPTY).split('.')[0] : undefined;
    },
    trim = function (str, len) {
      if (typeof str === STR_TYPE) {
        str = str.replace(/^\s\s*/, EMPTY);
        return typeof len === UNDEF_TYPE ? str : str.substring(0, UA_MAX_LENGTH);
      }
    };

  ///////////////
  // Map helper
  //////////////

  var rgxMapper = function (ua, arrays) {
      var i = 0,
        j,
        k,
        p,
        q,
        matches,
        match;

      // loop through all regexes maps
      while (i < arrays.length && !matches) {
        var regex = arrays[i],
          // even sequence (0,2,4,..)
          props = arrays[i + 1]; // odd sequence (1,3,5,..)
        j = k = 0;

        // try matching uastring with regexes
        while (j < regex.length && !matches) {
          if (!regex[j]) {
            break;
          }
          matches = regex[j++].exec(ua);
          if (!!matches) {
            for (p = 0; p < props.length; p++) {
              match = matches[++k];
              q = props[p];
              // check if given property is actually array
              if (typeof q === OBJ_TYPE && q.length > 0) {
                if (q.length === 2) {
                  if (typeof q[1] == FUNC_TYPE) {
                    // assign modified match
                    this[q[0]] = q[1].call(this, match);
                  } else {
                    // assign given value, ignore regex match
                    this[q[0]] = q[1];
                  }
                } else if (q.length === 3) {
                  // check whether function or regex
                  if (typeof q[1] === FUNC_TYPE && !(q[1].exec && q[1].test)) {
                    // call function (usually string mapper)
                    this[q[0]] = match ? q[1].call(this, match, q[2]) : undefined;
                  } else {
                    // sanitize match using given regex
                    this[q[0]] = match ? match.replace(q[1], q[2]) : undefined;
                  }
                } else if (q.length === 4) {
                  this[q[0]] = match ? q[3].call(this, match.replace(q[1], q[2])) : undefined;
                }
              } else {
                this[q] = match ? match : undefined;
              }
            }
          }
        }
        i += 2;
      }
    },
    strMapper = function (str, map) {
      for (var i in map) {
        // check if current value is array
        if (typeof map[i] === OBJ_TYPE && map[i].length > 0) {
          for (var j = 0; j < map[i].length; j++) {
            if (has(map[i][j], str)) {
              return i === UNKNOWN ? undefined : i;
            }
          }
        } else if (has(map[i], str)) {
          return i === UNKNOWN ? undefined : i;
        }
      }
      return str;
    };

  ///////////////
  // String map
  //////////////

  // Safari < 3.0
  var oldSafariMap = {
      '1.0': '/8',
      '1.2': '/1',
      '1.3': '/3',
      '2.0': '/412',
      '2.0.2': '/416',
      '2.0.3': '/417',
      '2.0.4': '/419',
      '?': '/'
    },
    windowsVersionMap = {
      'ME': '4.90',
      'NT 3.11': 'NT3.51',
      'NT 4.0': 'NT4.0',
      '2000': 'NT 5.0',
      'XP': ['NT 5.1', 'NT 5.2'],
      'Vista': 'NT 6.0',
      '7': 'NT 6.1',
      '8': 'NT 6.2',
      '8.1': 'NT 6.3',
      '10': ['NT 6.4', 'NT 10.0'],
      'RT': 'ARM'
    };

  //////////////
  // Regex map
  /////////////

  var regexes = {
    browser: [[/\b(?:crmo|crios)\/([\w\.]+)/i // Chrome for Android/iOS
    ], [VERSION, [NAME, 'Chrome']], [/edg(?:e|ios|a)?\/([\w\.]+)/i // Microsoft Edge
    ], [VERSION, [NAME, 'Edge']], [
    // Presto based
    /(opera mini)\/([-\w\.]+)/i,
    // Opera Mini
    /(opera [mobiletab]{3,6})\b.+version\/([-\w\.]+)/i,
    // Opera Mobi/Tablet
    /(opera)(?:.+version\/|[\/ ]+)([\w\.]+)/i // Opera
    ], [NAME, VERSION], [/opios[\/ ]+([\w\.]+)/i // Opera mini on iphone >= 8.0
    ], [VERSION, [NAME, OPERA + ' Mini']], [/\bop(?:rg)?x\/([\w\.]+)/i // Opera GX
    ], [VERSION, [NAME, OPERA + ' GX']], [/\bopr\/([\w\.]+)/i // Opera Webkit
    ], [VERSION, [NAME, OPERA]], [
    // Mixed
    /\bb[ai]*d(?:uhd|[ub]*[aekoprswx]{5,6})[\/ ]?([\w\.]+)/i // Baidu
    ], [VERSION, [NAME, 'Baidu']], [/(kindle)\/([\w\.]+)/i,
    // Kindle
    /(lunascape|maxthon|netfront|jasmine|blazer)[\/ ]?([\w\.]*)/i,
    // Lunascape/Maxthon/Netfront/Jasmine/Blazer
    // Trident based
    /(avant|iemobile|slim)\s?(?:browser)?[\/ ]?([\w\.]*)/i,
    // Avant/IEMobile/SlimBrowser
    /(?:ms|\()(ie) ([\w\.]+)/i,
    // Internet Explorer

    // Webkit/KHTML based                                               // Flock/RockMelt/Midori/Epiphany/Silk/Skyfire/Bolt/Iron/Iridium/PhantomJS/Bowser/QupZilla/Falkon
    /(flock|rockmelt|midori|epiphany|silk|skyfire|bolt|iron|vivaldi|iridium|phantomjs|bowser|quark|qupzilla|falkon|rekonq|puffin|brave|whale(?!.+naver)|qqbrowserlite|qq|duckduckgo)\/([-\w\.]+)/i,
    // Rekonq/Puffin/Brave/Whale/QQBrowserLite/QQ, aka ShouQ
    /(heytap|ovi)browser\/([\d\.]+)/i,
    // Heytap/Ovi
    /(weibo)__([\d\.]+)/i // Weibo
    ], [NAME, VERSION], [/\bddg\/([\w\.]+)/i // DuckDuckGo
    ], [VERSION, [NAME, 'DuckDuckGo']], [/(?:\buc? ?browser|(?:juc.+)ucweb)[\/ ]?([\w\.]+)/i // UCBrowser
    ], [VERSION, [NAME, 'UC' + BROWSER]], [/microm.+\bqbcore\/([\w\.]+)/i,
    // WeChat Desktop for Windows Built-in Browser
    /\bqbcore\/([\w\.]+).+microm/i, /micromessenger\/([\w\.]+)/i // WeChat
    ], [VERSION, [NAME, 'WeChat']], [/konqueror\/([\w\.]+)/i // Konqueror
    ], [VERSION, [NAME, 'Konqueror']], [/trident.+rv[: ]([\w\.]{1,9})\b.+like gecko/i // IE11
    ], [VERSION, [NAME, 'IE']], [/ya(?:search)?browser\/([\w\.]+)/i // Yandex
    ], [VERSION, [NAME, 'Yandex']], [/slbrowser\/([\w\.]+)/i // Smart Lenovo Browser
    ], [VERSION, [NAME, 'Smart Lenovo ' + BROWSER]], [/(avast|avg)\/([\w\.]+)/i // Avast/AVG Secure Browser
    ], [[NAME, /(.+)/, '$1 Secure ' + BROWSER], VERSION], [/\bfocus\/([\w\.]+)/i // Firefox Focus
    ], [VERSION, [NAME, FIREFOX + ' Focus']], [/\bopt\/([\w\.]+)/i // Opera Touch
    ], [VERSION, [NAME, OPERA + ' Touch']], [/coc_coc\w+\/([\w\.]+)/i // Coc Coc Browser
    ], [VERSION, [NAME, 'Coc Coc']], [/dolfin\/([\w\.]+)/i // Dolphin
    ], [VERSION, [NAME, 'Dolphin']], [/coast\/([\w\.]+)/i // Opera Coast
    ], [VERSION, [NAME, OPERA + ' Coast']], [/miuibrowser\/([\w\.]+)/i // MIUI Browser
    ], [VERSION, [NAME, 'MIUI ' + BROWSER]], [/fxios\/([-\w\.]+)/i // Firefox for iOS
    ], [VERSION, [NAME, FIREFOX]], [/\bqihu|(qi?ho?o?|360)browser/i // 360
    ], [[NAME, '360 ' + BROWSER]], [/(oculus|sailfish|huawei|vivo)browser\/([\w\.]+)/i], [[NAME, /(.+)/, '$1 ' + BROWSER], VERSION], [
    // Oculus/Sailfish/HuaweiBrowser/VivoBrowser
    /samsungbrowser\/([\w\.]+)/i // Samsung Internet
    ], [VERSION, [NAME, SAMSUNG + ' Internet']], [/(comodo_dragon)\/([\w\.]+)/i // Comodo Dragon
    ], [[NAME, /_/g, ' '], VERSION], [/metasr[\/ ]?([\d\.]+)/i // Sogou Explorer
    ], [VERSION, [NAME, 'Sogou Explorer']], [/(sogou)mo\w+\/([\d\.]+)/i // Sogou Mobile
    ], [[NAME, 'Sogou Mobile'], VERSION], [/(electron)\/([\w\.]+) safari/i,
    // Electron-based App
    /(tesla)(?: qtcarbrowser|\/(20\d\d\.[-\w\.]+))/i,
    // Tesla
    /m?(qqbrowser|2345Explorer)[\/ ]?([\w\.]+)/i // QQBrowser/2345 Browser
    ], [NAME, VERSION], [/(lbbrowser)/i,
    // LieBao Browser
    /\[(linkedin)app\]/i // LinkedIn App for iOS & Android
    ], [NAME], [
    // WebView
    /((?:fban\/fbios|fb_iab\/fb4a)(?!.+fbav)|;fbav\/([\w\.]+);)/i // Facebook App for iOS & Android
    ], [[NAME, FACEBOOK], VERSION], [/(Klarna)\/([\w\.]+)/i,
    // Klarna Shopping Browser for iOS & Android
    /(kakao(?:talk|story))[\/ ]([\w\.]+)/i,
    // Kakao App
    /(naver)\(.*?(\d+\.[\w\.]+).*\)/i,
    // Naver InApp
    /safari (line)\/([\w\.]+)/i,
    // Line App for iOS
    /\b(line)\/([\w\.]+)\/iab/i,
    // Line App for Android
    /(alipay)client\/([\w\.]+)/i,
    // Alipay
    /(twitter)(?:and| f.+e\/([\w\.]+))/i,
    // Twitter
    /(chromium|instagram|snapchat)[\/ ]([-\w\.]+)/i // Chromium/Instagram/Snapchat
    ], [NAME, VERSION], [/\bgsa\/([\w\.]+) .*safari\//i // Google Search Appliance on iOS
    ], [VERSION, [NAME, 'GSA']], [/musical_ly(?:.+app_?version\/|_)([\w\.]+)/i // TikTok
    ], [VERSION, [NAME, 'TikTok']], [/headlesschrome(?:\/([\w\.]+)| )/i // Chrome Headless
    ], [VERSION, [NAME, CHROME + ' Headless']], [/ wv\).+(chrome)\/([\w\.]+)/i // Chrome WebView
    ], [[NAME, CHROME + ' WebView'], VERSION], [/droid.+ version\/([\w\.]+)\b.+(?:mobile safari|safari)/i // Android Browser
    ], [VERSION, [NAME, 'Android ' + BROWSER]], [/(chrome|omniweb|arora|[tizenoka]{5} ?browser)\/v?([\w\.]+)/i // Chrome/OmniWeb/Arora/Tizen/Nokia
    ], [NAME, VERSION], [/version\/([\w\.\,]+) .*mobile\/\w+ (safari)/i // Mobile Safari
    ], [VERSION, [NAME, 'Mobile Safari']], [/version\/([\w(\.|\,)]+) .*(mobile ?safari|safari)/i // Safari & Safari Mobile
    ], [VERSION, NAME], [/webkit.+?(mobile ?safari|safari)(\/[\w\.]+)/i // Safari < 3.0
    ], [NAME, [VERSION, strMapper, oldSafariMap]], [/(webkit|khtml)\/([\w\.]+)/i], [NAME, VERSION], [
    // Gecko based
    /(navigator|netscape\d?)\/([-\w\.]+)/i // Netscape
    ], [[NAME, 'Netscape'], VERSION], [/mobile vr; rv:([\w\.]+)\).+firefox/i // Firefox Reality
    ], [VERSION, [NAME, FIREFOX + ' Reality']], [/ekiohf.+(flow)\/([\w\.]+)/i,
    // Flow
    /(swiftfox)/i,
    // Swiftfox
    /(icedragon|iceweasel|camino|chimera|fennec|maemo browser|minimo|conkeror|klar)[\/ ]?([\w\.\+]+)/i,
    // IceDragon/Iceweasel/Camino/Chimera/Fennec/Maemo/Minimo/Conkeror/Klar
    /(seamonkey|k-meleon|icecat|iceape|firebird|phoenix|palemoon|basilisk|waterfox)\/([-\w\.]+)$/i,
    // Firefox/SeaMonkey/K-Meleon/IceCat/IceApe/Firebird/Phoenix
    /(firefox)\/([\w\.]+)/i,
    // Other Firefox-based
    /(mozilla)\/([\w\.]+) .+rv\:.+gecko\/\d+/i,
    // Mozilla

    // Other
    /(polaris|lynx|dillo|icab|doris|amaya|w3m|netsurf|sleipnir|obigo|mosaic|(?:go|ice|up)[\. ]?browser)[-\/ ]?v?([\w\.]+)/i,
    // Polaris/Lynx/Dillo/iCab/Doris/Amaya/w3m/NetSurf/Sleipnir/Obigo/Mosaic/Go/ICE/UP.Browser
    /(links) \(([\w\.]+)/i,
    // Links
    /panasonic;(viera)/i // Panasonic Viera
    ], [NAME, VERSION], [/(cobalt)\/([\w\.]+)/i // Cobalt
    ], [NAME, [VERSION, /master.|lts./, ""]]],
    cpu: [[/(?:(amd|x(?:(?:86|64)[-_])?|wow|win)64)[;\)]/i // AMD64 (x64)
    ], [[ARCHITECTURE, 'amd64']], [/(ia32(?=;))/i // IA32 (quicktime)
    ], [[ARCHITECTURE, lowerize]], [/((?:i[346]|x)86)[;\)]/i // IA32 (x86)
    ], [[ARCHITECTURE, 'ia32']], [/\b(aarch64|arm(v?8e?l?|_?64))\b/i // ARM64
    ], [[ARCHITECTURE, 'arm64']], [/\b(arm(?:v[67])?ht?n?[fl]p?)\b/i // ARMHF
    ], [[ARCHITECTURE, 'armhf']], [
    // PocketPC mistakenly identified as PowerPC
    /windows (ce|mobile); ppc;/i], [[ARCHITECTURE, 'arm']], [/((?:ppc|powerpc)(?:64)?)(?: mac|;|\))/i // PowerPC
    ], [[ARCHITECTURE, /ower/, EMPTY, lowerize]], [/(sun4\w)[;\)]/i // SPARC
    ], [[ARCHITECTURE, 'sparc']], [/((?:avr32|ia64(?=;))|68k(?=\))|\barm(?=v(?:[1-7]|[5-7]1)l?|;|eabi)|(?=atmel )avr|(?:irix|mips|sparc)(?:64)?\b|pa-risc)/i
    // IA64, 68K, ARM/64, AVR/32, IRIX/64, MIPS/64, SPARC/64, PA-RISC
    ], [[ARCHITECTURE, lowerize]]],
    device: [[
    //////////////////////////
    // MOBILES & TABLETS
    /////////////////////////

    // Samsung
    /\b(sch-i[89]0\d|shw-m380s|sm-[ptx]\w{2,4}|gt-[pn]\d{2,4}|sgh-t8[56]9|nexus 10)/i], [MODEL, [VENDOR, SAMSUNG], [TYPE, TABLET]], [/\b((?:s[cgp]h|gt|sm)-\w+|sc[g-]?[\d]+a?|galaxy nexus)/i, /samsung[- ]([-\w]+)/i, /sec-(sgh\w+)/i], [MODEL, [VENDOR, SAMSUNG], [TYPE, MOBILE]], [
    // Apple
    /(?:\/|\()(ip(?:hone|od)[\w, ]*)(?:\/|;)/i // iPod/iPhone
    ], [MODEL, [VENDOR, APPLE], [TYPE, MOBILE]], [/\((ipad);[-\w\),; ]+apple/i,
    // iPad
    /applecoremedia\/[\w\.]+ \((ipad)/i, /\b(ipad)\d\d?,\d\d?[;\]].+ios/i], [MODEL, [VENDOR, APPLE], [TYPE, TABLET]], [/(macintosh);/i], [MODEL, [VENDOR, APPLE]], [
    // Sharp
    /\b(sh-?[altvz]?\d\d[a-ekm]?)/i], [MODEL, [VENDOR, SHARP], [TYPE, MOBILE]], [
    // Huawei
    /\b((?:ag[rs][23]?|bah2?|sht?|btv)-a?[lw]\d{2})\b(?!.+d\/s)/i], [MODEL, [VENDOR, HUAWEI], [TYPE, TABLET]], [/(?:huawei|honor)([-\w ]+)[;\)]/i, /\b(nexus 6p|\w{2,4}e?-[atu]?[ln][\dx][012359c][adn]?)\b(?!.+d\/s)/i], [MODEL, [VENDOR, HUAWEI], [TYPE, MOBILE]], [
    // Xiaomi
    /\b(poco[\w ]+|m2\d{3}j\d\d[a-z]{2})(?: bui|\))/i,
    // Xiaomi POCO
    /\b; (\w+) build\/hm\1/i,
    // Xiaomi Hongmi 'numeric' models
    /\b(hm[-_ ]?note?[_ ]?(?:\d\w)?) bui/i,
    // Xiaomi Hongmi
    /\b(redmi[\-_ ]?(?:note|k)?[\w_ ]+)(?: bui|\))/i,
    // Xiaomi Redmi
    /oid[^\)]+; (m?[12][0-389][01]\w{3,6}[c-y])( bui|; wv|\))/i,
    // Xiaomi Redmi 'numeric' models
    /\b(mi[-_ ]?(?:a\d|one|one[_ ]plus|note lte|max|cc)?[_ ]?(?:\d?\w?)[_ ]?(?:plus|se|lite)?)(?: bui|\))/i // Xiaomi Mi
    ], [[MODEL, /_/g, ' '], [VENDOR, XIAOMI], [TYPE, MOBILE]], [/oid[^\)]+; (2\d{4}(283|rpbf)[cgl])( bui|\))/i,
    // Redmi Pad
    /\b(mi[-_ ]?(?:pad)(?:[\w_ ]+))(?: bui|\))/i // Mi Pad tablets
    ], [[MODEL, /_/g, ' '], [VENDOR, XIAOMI], [TYPE, TABLET]], [
    // OPPO
    /; (\w+) bui.+ oppo/i, /\b(cph[12]\d{3}|p(?:af|c[al]|d\w|e[ar])[mt]\d0|x9007|a101op)\b/i], [MODEL, [VENDOR, 'OPPO'], [TYPE, MOBILE]], [/\b(opd2\d{3}a?) bui/i], [MODEL, [VENDOR, 'OPPO'], [TYPE, TABLET]], [
    // Vivo
    /vivo (\w+)(?: bui|\))/i, /\b(v[12]\d{3}\w?[at])(?: bui|;)/i], [MODEL, [VENDOR, 'Vivo'], [TYPE, MOBILE]], [
    // Realme
    /\b(rmx[1-3]\d{3})(?: bui|;|\))/i], [MODEL, [VENDOR, 'Realme'], [TYPE, MOBILE]], [
    // Motorola
    /\b(milestone|droid(?:[2-4x]| (?:bionic|x2|pro|razr))?:?( 4g)?)\b[\w ]+build\//i, /\bmot(?:orola)?[- ](\w*)/i, /((?:moto[\w\(\) ]+|xt\d{3,4}|nexus 6)(?= bui|\)))/i], [MODEL, [VENDOR, MOTOROLA], [TYPE, MOBILE]], [/\b(mz60\d|xoom[2 ]{0,2}) build\//i], [MODEL, [VENDOR, MOTOROLA], [TYPE, TABLET]], [
    // LG
    /((?=lg)?[vl]k\-?\d{3}) bui| 3\.[-\w; ]{10}lg?-([06cv9]{3,4})/i], [MODEL, [VENDOR, LG], [TYPE, TABLET]], [/(lm(?:-?f100[nv]?|-[\w\.]+)(?= bui|\))|nexus [45])/i, /\blg[-e;\/ ]+((?!browser|netcast|android tv)\w+)/i, /\blg-?([\d\w]+) bui/i], [MODEL, [VENDOR, LG], [TYPE, MOBILE]], [
    // Lenovo
    /(ideatab[-\w ]+)/i, /lenovo ?(s[56]000[-\w]+|tab(?:[\w ]+)|yt[-\d\w]{6}|tb[-\d\w]{6})/i], [MODEL, [VENDOR, 'Lenovo'], [TYPE, TABLET]], [
    // Nokia
    /(?:maemo|nokia).*(n900|lumia \d+)/i, /nokia[-_ ]?([-\w\.]*)/i], [[MODEL, /_/g, ' '], [VENDOR, 'Nokia'], [TYPE, MOBILE]], [
    // Google
    /(pixel c)\b/i // Google Pixel C
    ], [MODEL, [VENDOR, GOOGLE], [TYPE, TABLET]], [/droid.+; (pixel[\daxl ]{0,6})(?: bui|\))/i // Google Pixel
    ], [MODEL, [VENDOR, GOOGLE], [TYPE, MOBILE]], [
    // Sony
    /droid.+ (a?\d[0-2]{2}so|[c-g]\d{4}|so[-gl]\w+|xq-a\w[4-7][12])(?= bui|\).+chrome\/(?![1-6]{0,1}\d\.))/i], [MODEL, [VENDOR, SONY], [TYPE, MOBILE]], [/sony tablet [ps]/i, /\b(?:sony)?sgp\w+(?: bui|\))/i], [[MODEL, 'Xperia Tablet'], [VENDOR, SONY], [TYPE, TABLET]], [
    // OnePlus
    / (kb2005|in20[12]5|be20[12][59])\b/i, /(?:one)?(?:plus)? (a\d0\d\d)(?: b|\))/i], [MODEL, [VENDOR, 'OnePlus'], [TYPE, MOBILE]], [
    // Amazon
    /(alexa)webm/i, /(kf[a-z]{2}wi|aeo[c-r]{2})( bui|\))/i,
    // Kindle Fire without Silk / Echo Show
    /(kf[a-z]+)( bui|\)).+silk\//i // Kindle Fire HD
    ], [MODEL, [VENDOR, AMAZON], [TYPE, TABLET]], [/((?:sd|kf)[0349hijorstuw]+)( bui|\)).+silk\//i // Fire Phone
    ], [[MODEL, /(.+)/g, 'Fire Phone $1'], [VENDOR, AMAZON], [TYPE, MOBILE]], [
    // BlackBerry
    /(playbook);[-\w\),; ]+(rim)/i // BlackBerry PlayBook
    ], [MODEL, VENDOR, [TYPE, TABLET]], [/\b((?:bb[a-f]|st[hv])100-\d)/i, /\(bb10; (\w+)/i // BlackBerry 10
    ], [MODEL, [VENDOR, BLACKBERRY], [TYPE, MOBILE]], [
    // Asus
    /(?:\b|asus_)(transfo[prime ]{4,10} \w+|eeepc|slider \w+|nexus 7|padfone|p00[cj])/i], [MODEL, [VENDOR, ASUS], [TYPE, TABLET]], [/ (z[bes]6[027][012][km][ls]|zenfone \d\w?)\b/i], [MODEL, [VENDOR, ASUS], [TYPE, MOBILE]], [
    // HTC
    /(nexus 9)/i // HTC Nexus 9
    ], [MODEL, [VENDOR, 'HTC'], [TYPE, TABLET]], [/(htc)[-;_ ]{1,2}([\w ]+(?=\)| bui)|\w+)/i,
    // HTC

    // ZTE
    /(zte)[- ]([\w ]+?)(?: bui|\/|\))/i, /(alcatel|geeksphone|nexian|panasonic(?!(?:;|\.))|sony(?!-bra))[-_ ]?([-\w]*)/i // Alcatel/GeeksPhone/Nexian/Panasonic/Sony
    ], [VENDOR, [MODEL, /_/g, ' '], [TYPE, MOBILE]], [
    // Acer
    /droid.+; ([ab][1-7]-?[0178a]\d\d?)/i], [MODEL, [VENDOR, 'Acer'], [TYPE, TABLET]], [
    // Meizu
    /droid.+; (m[1-5] note) bui/i, /\bmz-([-\w]{2,})/i], [MODEL, [VENDOR, 'Meizu'], [TYPE, MOBILE]], [
    // Ulefone
    /; ((?:power )?armor(?:[\w ]{0,8}))(?: bui|\))/i], [MODEL, [VENDOR, 'Ulefone'], [TYPE, MOBILE]], [
    // MIXED
    /(blackberry|benq|palm(?=\-)|sonyericsson|acer|asus|dell|meizu|motorola|polytron|infinix|tecno)[-_ ]?([-\w]*)/i,
    // BlackBerry/BenQ/Palm/Sony-Ericsson/Acer/Asus/Dell/Meizu/Motorola/Polytron
    /(hp) ([\w ]+\w)/i,
    // HP iPAQ
    /(asus)-?(\w+)/i,
    // Asus
    /(microsoft); (lumia[\w ]+)/i,
    // Microsoft Lumia
    /(lenovo)[-_ ]?([-\w]+)/i,
    // Lenovo
    /(jolla)/i,
    // Jolla
    /(oppo) ?([\w ]+) bui/i // OPPO
    ], [VENDOR, MODEL, [TYPE, MOBILE]], [/(kobo)\s(ereader|touch)/i,
    // Kobo
    /(archos) (gamepad2?)/i,
    // Archos
    /(hp).+(touchpad(?!.+tablet)|tablet)/i,
    // HP TouchPad
    /(kindle)\/([\w\.]+)/i,
    // Kindle
    /(nook)[\w ]+build\/(\w+)/i,
    // Nook
    /(dell) (strea[kpr\d ]*[\dko])/i,
    // Dell Streak
    /(le[- ]+pan)[- ]+(\w{1,9}) bui/i,
    // Le Pan Tablets
    /(trinity)[- ]*(t\d{3}) bui/i,
    // Trinity Tablets
    /(gigaset)[- ]+(q\w{1,9}) bui/i,
    // Gigaset Tablets
    /(vodafone) ([\w ]+)(?:\)| bui)/i // Vodafone
    ], [VENDOR, MODEL, [TYPE, TABLET]], [/(surface duo)/i // Surface Duo
    ], [MODEL, [VENDOR, MICROSOFT], [TYPE, TABLET]], [/droid [\d\.]+; (fp\du?)(?: b|\))/i // Fairphone
    ], [MODEL, [VENDOR, 'Fairphone'], [TYPE, MOBILE]], [/(u304aa)/i // AT&T
    ], [MODEL, [VENDOR, 'AT&T'], [TYPE, MOBILE]], [/\bsie-(\w*)/i // Siemens
    ], [MODEL, [VENDOR, 'Siemens'], [TYPE, MOBILE]], [/\b(rct\w+) b/i // RCA Tablets
    ], [MODEL, [VENDOR, 'RCA'], [TYPE, TABLET]], [/\b(venue[\d ]{2,7}) b/i // Dell Venue Tablets
    ], [MODEL, [VENDOR, 'Dell'], [TYPE, TABLET]], [/\b(q(?:mv|ta)\w+) b/i // Verizon Tablet
    ], [MODEL, [VENDOR, 'Verizon'], [TYPE, TABLET]], [/\b(?:barnes[& ]+noble |bn[rt])([\w\+ ]*) b/i // Barnes & Noble Tablet
    ], [MODEL, [VENDOR, 'Barnes & Noble'], [TYPE, TABLET]], [/\b(tm\d{3}\w+) b/i], [MODEL, [VENDOR, 'NuVision'], [TYPE, TABLET]], [/\b(k88) b/i // ZTE K Series Tablet
    ], [MODEL, [VENDOR, 'ZTE'], [TYPE, TABLET]], [/\b(nx\d{3}j) b/i // ZTE Nubia
    ], [MODEL, [VENDOR, 'ZTE'], [TYPE, MOBILE]], [/\b(gen\d{3}) b.+49h/i // Swiss GEN Mobile
    ], [MODEL, [VENDOR, 'Swiss'], [TYPE, MOBILE]], [/\b(zur\d{3}) b/i // Swiss ZUR Tablet
    ], [MODEL, [VENDOR, 'Swiss'], [TYPE, TABLET]], [/\b((zeki)?tb.*\b) b/i // Zeki Tablets
    ], [MODEL, [VENDOR, 'Zeki'], [TYPE, TABLET]], [/\b([yr]\d{2}) b/i, /\b(dragon[- ]+touch |dt)(\w{5}) b/i // Dragon Touch Tablet
    ], [[VENDOR, 'Dragon Touch'], MODEL, [TYPE, TABLET]], [/\b(ns-?\w{0,9}) b/i // Insignia Tablets
    ], [MODEL, [VENDOR, 'Insignia'], [TYPE, TABLET]], [/\b((nxa|next)-?\w{0,9}) b/i // NextBook Tablets
    ], [MODEL, [VENDOR, 'NextBook'], [TYPE, TABLET]], [/\b(xtreme\_)?(v(1[045]|2[015]|[3469]0|7[05])) b/i // Voice Xtreme Phones
    ], [[VENDOR, 'Voice'], MODEL, [TYPE, MOBILE]], [/\b(lvtel\-)?(v1[12]) b/i // LvTel Phones
    ], [[VENDOR, 'LvTel'], MODEL, [TYPE, MOBILE]], [/\b(ph-1) /i // Essential PH-1
    ], [MODEL, [VENDOR, 'Essential'], [TYPE, MOBILE]], [/\b(v(100md|700na|7011|917g).*\b) b/i // Envizen Tablets
    ], [MODEL, [VENDOR, 'Envizen'], [TYPE, TABLET]], [/\b(trio[-\w\. ]+) b/i // MachSpeed Tablets
    ], [MODEL, [VENDOR, 'MachSpeed'], [TYPE, TABLET]], [/\btu_(1491) b/i // Rotor Tablets
    ], [MODEL, [VENDOR, 'Rotor'], [TYPE, TABLET]], [/(shield[\w ]+) b/i // Nvidia Shield Tablets
    ], [MODEL, [VENDOR, 'Nvidia'], [TYPE, TABLET]], [/(sprint) (\w+)/i // Sprint Phones
    ], [VENDOR, MODEL, [TYPE, MOBILE]], [/(kin\.[onetw]{3})/i // Microsoft Kin
    ], [[MODEL, /\./g, ' '], [VENDOR, MICROSOFT], [TYPE, MOBILE]], [/droid.+; (cc6666?|et5[16]|mc[239][23]x?|vc8[03]x?)\)/i // Zebra
    ], [MODEL, [VENDOR, ZEBRA], [TYPE, TABLET]], [/droid.+; (ec30|ps20|tc[2-8]\d[kx])\)/i], [MODEL, [VENDOR, ZEBRA], [TYPE, MOBILE]], [
    ///////////////////
    // SMARTTVS
    ///////////////////

    /smart-tv.+(samsung)/i // Samsung
    ], [VENDOR, [TYPE, SMARTTV]], [/hbbtv.+maple;(\d+)/i], [[MODEL, /^/, 'SmartTV'], [VENDOR, SAMSUNG], [TYPE, SMARTTV]], [/(nux; netcast.+smarttv|lg (netcast\.tv-201\d|android tv))/i // LG SmartTV
    ], [[VENDOR, LG], [TYPE, SMARTTV]], [/(apple) ?tv/i // Apple TV
    ], [VENDOR, [MODEL, APPLE + ' TV'], [TYPE, SMARTTV]], [/crkey/i // Google Chromecast
    ], [[MODEL, CHROME + 'cast'], [VENDOR, GOOGLE], [TYPE, SMARTTV]], [/droid.+aft(\w+)( bui|\))/i // Fire TV
    ], [MODEL, [VENDOR, AMAZON], [TYPE, SMARTTV]], [/\(dtv[\);].+(aquos)/i, /(aquos-tv[\w ]+)\)/i // Sharp
    ], [MODEL, [VENDOR, SHARP], [TYPE, SMARTTV]], [/(bravia[\w ]+)( bui|\))/i // Sony
    ], [MODEL, [VENDOR, SONY], [TYPE, SMARTTV]], [/(mitv-\w{5}) bui/i // Xiaomi
    ], [MODEL, [VENDOR, XIAOMI], [TYPE, SMARTTV]], [/Hbbtv.*(technisat) (.*);/i // TechniSAT
    ], [VENDOR, MODEL, [TYPE, SMARTTV]], [/\b(roku)[\dx]*[\)\/]((?:dvp-)?[\d\.]*)/i,
    // Roku
    /hbbtv\/\d+\.\d+\.\d+ +\([\w\+ ]*; *([\w\d][^;]*);([^;]*)/i // HbbTV devices
    ], [[VENDOR, trim], [MODEL, trim], [TYPE, SMARTTV]], [/\b(android tv|smart[- ]?tv|opera tv|tv; rv:)\b/i // SmartTV from Unidentified Vendors
    ], [[TYPE, SMARTTV]], [
    ///////////////////
    // CONSOLES
    ///////////////////

    /(ouya)/i,
    // Ouya
    /(nintendo) ([wids3utch]+)/i // Nintendo
    ], [VENDOR, MODEL, [TYPE, CONSOLE]], [/droid.+; (shield) bui/i // Nvidia
    ], [MODEL, [VENDOR, 'Nvidia'], [TYPE, CONSOLE]], [/(playstation [345portablevi]+)/i // Playstation
    ], [MODEL, [VENDOR, SONY], [TYPE, CONSOLE]], [/\b(xbox(?: one)?(?!; xbox))[\); ]/i // Microsoft Xbox
    ], [MODEL, [VENDOR, MICROSOFT], [TYPE, CONSOLE]], [
    ///////////////////
    // WEARABLES
    ///////////////////

    /((pebble))app/i // Pebble
    ], [VENDOR, MODEL, [TYPE, WEARABLE]], [/(watch)(?: ?os[,\/]|\d,\d\/)[\d\.]+/i // Apple Watch
    ], [MODEL, [VENDOR, APPLE], [TYPE, WEARABLE]], [/droid.+; (glass) \d/i // Google Glass
    ], [MODEL, [VENDOR, GOOGLE], [TYPE, WEARABLE]], [/droid.+; (wt63?0{2,3})\)/i], [MODEL, [VENDOR, ZEBRA], [TYPE, WEARABLE]], [/(quest( \d| pro)?)/i // Oculus Quest
    ], [MODEL, [VENDOR, FACEBOOK], [TYPE, WEARABLE]], [
    ///////////////////
    // EMBEDDED
    ///////////////////

    /(tesla)(?: qtcarbrowser|\/[-\w\.]+)/i // Tesla
    ], [VENDOR, [TYPE, EMBEDDED]], [/(aeobc)\b/i // Echo Dot
    ], [MODEL, [VENDOR, AMAZON], [TYPE, EMBEDDED]], [
    ////////////////////
    // MIXED (GENERIC)
    ///////////////////

    /droid .+?; ([^;]+?)(?: bui|; wv\)|\) applew).+? mobile safari/i // Android Phones from Unidentified Vendors
    ], [MODEL, [TYPE, MOBILE]], [/droid .+?; ([^;]+?)(?: bui|\) applew).+?(?! mobile) safari/i // Android Tablets from Unidentified Vendors
    ], [MODEL, [TYPE, TABLET]], [/\b((tablet|tab)[;\/]|focus\/\d(?!.+mobile))/i // Unidentifiable Tablet
    ], [[TYPE, TABLET]], [/(phone|mobile(?:[;\/]| [ \w\/\.]*safari)|pda(?=.+windows ce))/i // Unidentifiable Mobile
    ], [[TYPE, MOBILE]], [/(android[-\w\. ]{0,9});.+buil/i // Generic Android Device
    ], [MODEL, [VENDOR, 'Generic']]],
    engine: [[/windows.+ edge\/([\w\.]+)/i // EdgeHTML
    ], [VERSION, [NAME, EDGE + 'HTML']], [/webkit\/537\.36.+chrome\/(?!27)([\w\.]+)/i // Blink
    ], [VERSION, [NAME, 'Blink']], [/(presto)\/([\w\.]+)/i,
    // Presto
    /(webkit|trident|netfront|netsurf|amaya|lynx|w3m|goanna)\/([\w\.]+)/i,
    // WebKit/Trident/NetFront/NetSurf/Amaya/Lynx/w3m/Goanna
    /ekioh(flow)\/([\w\.]+)/i,
    // Flow
    /(khtml|tasman|links)[\/ ]\(?([\w\.]+)/i,
    // KHTML/Tasman/Links
    /(icab)[\/ ]([23]\.[\d\.]+)/i,
    // iCab
    /\b(libweb)/i], [NAME, VERSION], [/rv\:([\w\.]{1,9})\b.+(gecko)/i // Gecko
    ], [VERSION, NAME]],
    os: [[
    // Windows
    /microsoft (windows) (vista|xp)/i // Windows (iTunes)
    ], [NAME, VERSION], [/(windows (?:phone(?: os)?|mobile))[\/ ]?([\d\.\w ]*)/i // Windows Phone
    ], [NAME, [VERSION, strMapper, windowsVersionMap]], [/windows nt 6\.2; (arm)/i,
    // Windows RT
    /windows[\/ ]?([ntce\d\. ]+\w)(?!.+xbox)/i, /(?:win(?=3|9|n)|win 9x )([nt\d\.]+)/i], [[VERSION, strMapper, windowsVersionMap], [NAME, 'Windows']], [
    // iOS/macOS
    /ip[honead]{2,4}\b(?:.*os ([\w]+) like mac|; opera)/i,
    // iOS
    /(?:ios;fbsv\/|iphone.+ios[\/ ])([\d\.]+)/i, /cfnetwork\/.+darwin/i], [[VERSION, /_/g, '.'], [NAME, 'iOS']], [/(mac os x) ?([\w\. ]*)/i, /(macintosh|mac_powerpc\b)(?!.+haiku)/i // Mac OS
    ], [[NAME, MAC_OS], [VERSION, /_/g, '.']], [
    // Mobile OSes
    /droid ([\w\.]+)\b.+(android[- ]x86|harmonyos)/i // Android-x86/HarmonyOS
    ], [VERSION, NAME], [
    // Android/WebOS/QNX/Bada/RIM/Maemo/MeeGo/Sailfish OS
    /(android|webos|qnx|bada|rim tablet os|maemo|meego|sailfish)[-\/ ]?([\w\.]*)/i, /(blackberry)\w*\/([\w\.]*)/i,
    // Blackberry
    /(tizen|kaios)[\/ ]([\w\.]+)/i,
    // Tizen/KaiOS
    /\((series40);/i // Series 40
    ], [NAME, VERSION], [/\(bb(10);/i // BlackBerry 10
    ], [VERSION, [NAME, BLACKBERRY]], [/(?:symbian ?os|symbos|s60(?=;)|series60)[-\/ ]?([\w\.]*)/i // Symbian
    ], [VERSION, [NAME, 'Symbian']], [/mozilla\/[\d\.]+ \((?:mobile|tablet|tv|mobile; [\w ]+); rv:.+ gecko\/([\w\.]+)/i // Firefox OS
    ], [VERSION, [NAME, FIREFOX + ' OS']], [/web0s;.+rt(tv)/i, /\b(?:hp)?wos(?:browser)?\/([\w\.]+)/i // WebOS
    ], [VERSION, [NAME, 'webOS']], [/watch(?: ?os[,\/]|\d,\d\/)([\d\.]+)/i // watchOS
    ], [VERSION, [NAME, 'watchOS']], [
    // Google Chromecast
    /crkey\/([\d\.]+)/i // Google Chromecast
    ], [VERSION, [NAME, CHROME + 'cast']], [/(cros) [\w]+(?:\)| ([\w\.]+)\b)/i // Chromium OS
    ], [[NAME, CHROMIUM_OS], VERSION], [
    // Smart TVs
    /panasonic;(viera)/i,
    // Panasonic Viera
    /(netrange)mmh/i,
    // Netrange
    /(nettv)\/(\d+\.[\w\.]+)/i,
    // NetTV

    // Console
    /(nintendo|playstation) ([wids345portablevuch]+)/i,
    // Nintendo/Playstation
    /(xbox); +xbox ([^\);]+)/i,
    // Microsoft Xbox (360, One, X, S, Series X, Series S)

    // Other
    /\b(joli|palm)\b ?(?:os)?\/?([\w\.]*)/i,
    // Joli/Palm
    /(mint)[\/\(\) ]?(\w*)/i,
    // Mint
    /(mageia|vectorlinux)[; ]/i,
    // Mageia/VectorLinux
    /([kxln]?ubuntu|debian|suse|opensuse|gentoo|arch(?= linux)|slackware|fedora|mandriva|centos|pclinuxos|red ?hat|zenwalk|linpus|raspbian|plan 9|minix|risc os|contiki|deepin|manjaro|elementary os|sabayon|linspire)(?: gnu\/linux)?(?: enterprise)?(?:[- ]linux)?(?:-gnu)?[-\/ ]?(?!chrom|package)([-\w\.]*)/i,
    // Ubuntu/Debian/SUSE/Gentoo/Arch/Slackware/Fedora/Mandriva/CentOS/PCLinuxOS/RedHat/Zenwalk/Linpus/Raspbian/Plan9/Minix/RISCOS/Contiki/Deepin/Manjaro/elementary/Sabayon/Linspire
    /(hurd|linux) ?([\w\.]*)/i,
    // Hurd/Linux
    /(gnu) ?([\w\.]*)/i,
    // GNU
    /\b([-frentopcghs]{0,5}bsd|dragonfly)[\/ ]?(?!amd|[ix346]{1,2}86)([\w\.]*)/i,
    // FreeBSD/NetBSD/OpenBSD/PC-BSD/GhostBSD/DragonFly
    /(haiku) (\w+)/i // Haiku
    ], [NAME, VERSION], [/(sunos) ?([\w\.\d]*)/i // Solaris
    ], [[NAME, 'Solaris'], VERSION], [/((?:open)?solaris)[-\/ ]?([\w\.]*)/i,
    // Solaris
    /(aix) ((\d)(?=\.|\)| )[\w\.])*/i,
    // AIX
    /\b(beos|os\/2|amigaos|morphos|openvms|fuchsia|hp-ux|serenityos)/i,
    // BeOS/OS2/AmigaOS/MorphOS/OpenVMS/Fuchsia/HP-UX/SerenityOS
    /(unix) ?([\w\.]*)/i // UNIX
    ], [NAME, VERSION]]
  };

  /////////////////
  // Constructor
  ////////////////

  var UAParser = function (ua, extensions) {
    if (typeof ua === OBJ_TYPE) {
      extensions = ua;
      ua = undefined;
    }
    if (!(this instanceof UAParser)) {
      return new UAParser(ua, extensions).getResult();
    }
    var _navigator = typeof window !== UNDEF_TYPE && window.navigator ? window.navigator : undefined;
    var _ua = ua || (_navigator && _navigator.userAgent ? _navigator.userAgent : EMPTY);
    var _uach = _navigator && _navigator.userAgentData ? _navigator.userAgentData : undefined;
    var _rgxmap = extensions ? extend(regexes, extensions) : regexes;
    var _isSelfNav = _navigator && _navigator.userAgent == _ua;
    this.getBrowser = function () {
      var _browser = {};
      _browser[NAME] = undefined;
      _browser[VERSION] = undefined;
      rgxMapper.call(_browser, _ua, _rgxmap.browser);
      _browser[MAJOR] = majorize(_browser[VERSION]);
      // Brave-specific detection
      if (_isSelfNav && _navigator && _navigator.brave && typeof _navigator.brave.isBrave == FUNC_TYPE) {
        _browser[NAME] = 'Brave';
      }
      return _browser;
    };
    this.getCPU = function () {
      var _cpu = {};
      _cpu[ARCHITECTURE] = undefined;
      rgxMapper.call(_cpu, _ua, _rgxmap.cpu);
      return _cpu;
    };
    this.getDevice = function () {
      var _device = {};
      _device[VENDOR] = undefined;
      _device[MODEL] = undefined;
      _device[TYPE] = undefined;
      rgxMapper.call(_device, _ua, _rgxmap.device);
      if (_isSelfNav && !_device[TYPE] && _uach && _uach.mobile) {
        _device[TYPE] = MOBILE;
      }
      // iPadOS-specific detection: identified as Mac, but has some iOS-only properties
      if (_isSelfNav && _device[MODEL] == 'Macintosh' && _navigator && typeof _navigator.standalone !== UNDEF_TYPE && _navigator.maxTouchPoints && _navigator.maxTouchPoints > 2) {
        _device[MODEL] = 'iPad';
        _device[TYPE] = TABLET;
      }
      return _device;
    };
    this.getEngine = function () {
      var _engine = {};
      _engine[NAME] = undefined;
      _engine[VERSION] = undefined;
      rgxMapper.call(_engine, _ua, _rgxmap.engine);
      return _engine;
    };
    this.getOS = function () {
      var _os = {};
      _os[NAME] = undefined;
      _os[VERSION] = undefined;
      rgxMapper.call(_os, _ua, _rgxmap.os);
      if (_isSelfNav && !_os[NAME] && _uach && _uach.platform && _uach.platform != 'Unknown') {
        _os[NAME] = _uach.platform.replace(/chrome os/i, CHROMIUM_OS).replace(/macos/i, MAC_OS); // backward compatibility
      }
      return _os;
    };
    this.getResult = function () {
      return {
        ua: this.getUA(),
        browser: this.getBrowser(),
        engine: this.getEngine(),
        os: this.getOS(),
        device: this.getDevice(),
        cpu: this.getCPU()
      };
    };
    this.getUA = function () {
      return _ua;
    };
    this.setUA = function (ua) {
      _ua = typeof ua === STR_TYPE && ua.length > UA_MAX_LENGTH ? trim(ua, UA_MAX_LENGTH) : ua;
      return this;
    };
    this.setUA(_ua);
    return this;
  };
  UAParser.VERSION = LIBVERSION;
  UAParser.BROWSER = enumerize([NAME, VERSION, MAJOR]);
  UAParser.CPU = enumerize([ARCHITECTURE]);
  UAParser.DEVICE = enumerize([MODEL, VENDOR, TYPE, CONSOLE, MOBILE, SMARTTV, TABLET, WEARABLE, EMBEDDED]);
  UAParser.ENGINE = UAParser.OS = enumerize([NAME, VERSION]);

  ///////////
  // Export
  //////////

  // check js environment
  if (typeof exports !== UNDEF_TYPE) {
    // nodejs env
    if ("object" !== UNDEF_TYPE && module.exports) {
      exports = module.exports = UAParser;
    }
    exports.UAParser = UAParser;
  } else {
    // requirejs env (optional)
    if ("function" === FUNC_TYPE && __webpack_require__.amdO) {
      !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
        return UAParser;
      }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (typeof window !== UNDEF_TYPE) {
      // browser env
      window.UAParser = UAParser;
    }
  }

  // jQuery/Zepto specific (optional)
  // Note:
  //   In AMD env the global scope should be kept clean, but jQuery is an exception.
  //   jQuery always exports to global scope, unless jQuery.noConflict(true) is used,
  //   and we should catch that.
  var $ = typeof window !== UNDEF_TYPE && (window.jQuery || window.Zepto);
  if ($ && !$.ua) {
    var parser = new UAParser();
    $.ua = parser.getResult();
    $.ua.get = function () {
      return parser.getUA();
    };
    $.ua.set = function (ua) {
      parser.setUA(ua);
      var result = parser.getResult();
      for (var prop in result) {
        $.ua[prop] = result[prop];
      }
    };
  }
})(typeof window === 'object' ? window : this);

/***/ }),

/***/ "./externals/tXml.js":
/*!***************************!*\
  !*** ./externals/tXml.js ***!
  \***************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   XML_ENTITIES: function() { return /* binding */ XML_ENTITIES; },
/* harmony export */   filter: function() { return /* binding */ filter; },
/* harmony export */   getElementById: function() { return /* binding */ getElementById; },
/* harmony export */   getElementsByClassName: function() { return /* binding */ getElementsByClassName; },
/* harmony export */   parse: function() { return /* binding */ parse; },
/* harmony export */   simplify: function() { return /* binding */ simplify; },
/* harmony export */   simplifyLostLess: function() { return /* binding */ simplifyLostLess; },
/* harmony export */   stringify: function() { return /* binding */ stringify; },
/* harmony export */   toContentString: function() { return /* binding */ toContentString; },
/* harmony export */   translateEntitiesAndCharacterReferences: function() { return /* binding */ translateEntitiesAndCharacterReferences; }
/* harmony export */ });
// ==ClosureCompiler==
// @output_file_name default.js
// @compilation_level SIMPLE_OPTIMIZATIONS
// ==/ClosureCompiler==
// module.exports = {
//     parse: parse,
//     simplify: simplify,
//     simplifyLostLess: simplifyLostLess,
//     filter: filter,
//     stringify: stringify,
//     toContentString: toContentString,
//     getElementById: getElementById,
//     getElementsByClassName: getElementsByClassName,
//     transformStream: transformStream,
// };

/**
 * @author: Tobias Nickel
 * @created: 06.04.2015
 * I needed a small xmlparser chat can be used in a worker.
 */

/**
 * @typedef tNode
 * @property {string} tagName
 * @property {object} attributes
 * @property {(tNode|string)[]} children
 **/

/**
 * @typedef TParseOptions
 * @property {number} [pos]
 * @property {string[]} [noChildNodes]
 * @property {boolean} [setPos]
 * @property {boolean} [keepComments]
 * @property {boolean} [keepWhitespace]
 * @property {boolean} [simplify]
 * @property {(a: tNode, b: tNode) => boolean} [filter]
 */

/**
 * Predefined general entities used in XML
 * See https://www.w3.org/TR/xml/#sec-predefined-ent
 */
const XML_ENTITIES = {
  '&amp;': '&',
  '&gt;': '>',
  '&lt;': '<',
  '&quot;': '"',
  '&apos;': "'"
};

/**
 * Translates XML predefined entities and character references to their respective characters.
 * @param {Object} entitiesList
 * @param {String} str
 * @returns {String}
 */
function translateEntitiesAndCharacterReferences(entitiesList, str) {
  const entitySplit = str.split(/(&[#a-zA-Z0-9]+;)/);
  if (entitySplit.length <= 1) {
    // No entities. Skip the rest of the function.
    return str;
  }
  for (let i = 1; i < entitySplit.length; i += 2) {
    const reference = entitySplit[i];

    /*
     * Check if it is a character reference of the form
     * /&#[0-9]+;/ - Encoded in decimal, or
     * /&#x[0-9a-fA-F]+;/ - Encoded in hexadecimal
     * See https://www.w3.org/TR/xml/#sec-references
     */
    if (reference.charAt(1) === '#') {
      let code;
      if (reference.charAt(2) === 'x') {
        // Hexadecimal
        code = parseInt(reference.substring(3, reference.length - 1), 16);
      } else {
        // Decimal
        code = parseInt(reference.substring(2, reference.length - 1), 10);
      }

      // Translate into string according to ISO/IEC 10646
      if (!isNaN(code) && code >= 0 && code <= 0x10FFFF) {
        entitySplit[i] = String.fromCodePoint(code);
      }
    }
    /*
     * Translate entity references using a dictionary.
     */else if (entitiesList.hasOwnProperty(reference)) {
      entitySplit[i] = entitiesList[reference];
    }
  }
  return entitySplit.join('');
}
;

/**
 * parseXML / html into a DOM Object. with no validation and some failur tolerance
 * @param {string} S your XML to parse
 * @param {TParseOptions} [options]  all other options:
 * @return {(tNode | string)[]}
 */
function parse(S, options) {
  "txml";

  options = options || {};
  var pos = options.pos || 0;
  var keepComments = !!options.keepComments;
  var keepWhitespace = !!options.keepWhitespace;
  // dash.js - BEGIN
  // Attributes matchers to post-process attributes (for ex to transform from xs:duration format to number of seconds)
  var attrMatchers = options.attrMatchers || [];
  // List od node names that must be stored as array within their parent
  var nodesAsArray = options.nodesAsArray || [];
  // dash.js - END

  var openBracket = "<";
  var openBracketCC = "<".charCodeAt(0);
  var closeBracket = ">";
  var closeBracketCC = ">".charCodeAt(0);
  var minusCC = "-".charCodeAt(0);
  var slashCC = "/".charCodeAt(0);
  var exclamationCC = '!'.charCodeAt(0);
  var singleQuoteCC = "'".charCodeAt(0);
  var doubleQuoteCC = '"'.charCodeAt(0);
  var openCornerBracketCC = '['.charCodeAt(0);
  var closeCornerBracketCC = ']'.charCodeAt(0);

  /**
   * parsing a list of entries
   */
  function parseChildren(tagName, parent) {
    var children = [];
    while (S[pos]) {
      if (S.charCodeAt(pos) == openBracketCC) {
        if (S.charCodeAt(pos + 1) === slashCC) {
          var closeStart = pos + 2;
          pos = S.indexOf(closeBracket, pos);
          var closeTag = S.substring(closeStart, pos);
          if (closeTag.indexOf(tagName) == -1) {
            var parsedText = S.substring(0, pos).split('\n');
            throw new Error('Unexpected close tag\nLine: ' + (parsedText.length - 1) + '\nColumn: ' + (parsedText[parsedText.length - 1].length + 1) + '\nChar: ' + S[pos]);
          }
          if (pos + 1) pos += 1;
          return children;
        } else if (S.charCodeAt(pos + 1) === exclamationCC) {
          if (S.charCodeAt(pos + 2) == minusCC) {
            //comment support
            const startCommentPos = pos;
            while (pos !== -1 && !(S.charCodeAt(pos) === closeBracketCC && S.charCodeAt(pos - 1) == minusCC && S.charCodeAt(pos - 2) == minusCC && pos != -1)) {
              pos = S.indexOf(closeBracket, pos + 1);
            }
            if (pos === -1) {
              pos = S.length;
            }
            if (keepComments) {
              children.push(S.substring(startCommentPos, pos + 1));
            }
          } else if (S.charCodeAt(pos + 2) === openCornerBracketCC && S.charCodeAt(pos + 8) === openCornerBracketCC && S.substr(pos + 3, 5).toLowerCase() === 'cdata') {
            // cdata
            var cdataEndIndex = S.indexOf(']]>', pos);
            if (cdataEndIndex == -1) {
              children.push(S.substr(pos + 9));
              pos = S.length;
            } else {
              children.push(S.substring(pos + 9, cdataEndIndex));
              pos = cdataEndIndex + 3;
            }
            continue;
          } else {
            // doctypesupport
            const startDoctype = pos + 1;
            pos += 2;
            var encapsuled = false;
            while ((S.charCodeAt(pos) !== closeBracketCC || encapsuled === true) && S[pos]) {
              if (S.charCodeAt(pos) === openCornerBracketCC) {
                encapsuled = true;
              } else if (encapsuled === true && S.charCodeAt(pos) === closeCornerBracketCC) {
                encapsuled = false;
              }
              pos++;
            }
            children.push(S.substring(startDoctype, pos));
          }
          pos++;
          continue;
        }
        var node = parseNode();
        children.push(node);
        if (node.tagName[0] === '?') {
          children.push(...node.children);
          node.children = [];
        }

        // dash.js - BEGIN
        // Transform/process on the fly child nodes to add them to their parent as an array or an object
        if (parent) {
          let tagName = node.tagName;
          if (nodesAsArray.indexOf(tagName) !== -1) {
            if (!parent[tagName]) {
              parent[tagName] = [];
            }
            parent[tagName].push(node);
          } else {
            parent[tagName] = node;
          }
        }
        // dash.js - END
      } else {
        var text = parseText();
        if (!keepWhitespace) {
          text = text.trim();
        }
        // dash.js - BEGIN
        // Transform/process on the fly text values to add them to their parent as its "_text" property
        if (parent) {
          parent.__text = text;
        } else {
          children.push(text);
        }
        // dash.js - END
        pos++;
      }
    }
    return children;
  }

  // dash.js - BEGIN
  // Add function processAttr() used to process node attributes on the fly when parsing nodes (see parseNode()))
  function processAttr(tagName, attrName, value) {
    // Specific use case for SegmentTimeline <S> tag
    if (tagName === 'S') {
      return parseInt(value);
    }
    let attrValue = translateEntitiesAndCharacterReferences(XML_ENTITIES, value);
    attrMatchers.forEach(matcher => {
      if (matcher.test(tagName, attrName, value)) {
        attrValue = matcher.converter(value);
      }
    });
    return attrValue;
  }
  // dash.js - END

  /**
   *    returns the text outside of texts until the first '<'
   */
  function parseText() {
    var start = pos;
    pos = S.indexOf(openBracket, pos) - 1;
    if (pos === -2) pos = S.length;
    return translateEntitiesAndCharacterReferences(XML_ENTITIES, S.slice(start, pos + 1));
  }
  /**
   *    returns text until the first nonAlphabetic letter
   */
  var nameSpacer = '\r\n\t>/= ';
  function parseName() {
    var start = pos;
    while (nameSpacer.indexOf(S[pos]) === -1 && S[pos]) {
      pos++;
    }
    return S.slice(start, pos);
  }
  /**
   *    is parsing a node, including tagName, Attributes and its children,
   * to parse children it uses the parseChildren again, that makes the parsing recursive
   */
  var NoChildNodes = options.noChildNodes || ['img', 'br', 'input', 'meta', 'link', 'hr'];
  function parseNode() {
    pos++;
    const tagName = parseName();
    // dash.js - BEGIN
    // Set attributes as node properties which names are the attributes names
    // For child nodes, see parseChildren() function where children are added as object properties
    // const attributes = {};
    let children = [];
    let node = {
      tagName: tagName
    };

    // Support tag namespace
    let p = node.tagName.indexOf(':');
    if (p !== -1) {
      node.__prefix = node.tagName.substr(0, p);
      node.tagName = node.tagName.substr(p + 1);
    }
    // dash.js - END

    // parsing attributes
    while (S.charCodeAt(pos) !== closeBracketCC && S[pos]) {
      var c = S.charCodeAt(pos);
      if (c > 64 && c < 91 || c > 96 && c < 123) {
        //if('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'.indexOf(S[pos])!==-1 ){
        var name = parseName();
        // search beginning of the string
        var code = S.charCodeAt(pos);
        while (code && code !== singleQuoteCC && code !== doubleQuoteCC && !(code > 64 && code < 91 || code > 96 && code < 123) && code !== closeBracketCC) {
          pos++;
          code = S.charCodeAt(pos);
        }
        if (code === singleQuoteCC || code === doubleQuoteCC) {
          var value = parseString();
          if (pos === -1) {
            return node;
          }
        } else {
          value = null;
          pos--;
        }
        // dash.js - BEGIN
        // Process attributes and add them as node properties which names are the attributes names
        value = processAttr(node.tagName, name, value);
        node[name] = value;
        // dash.js - END
      }
      pos++;
    }
    // optional parsing of children
    if (S.charCodeAt(pos - 1) !== slashCC) {
      if (tagName == "script") {
        var start = pos + 1;
        pos = S.indexOf('</script>', pos);
        children = [S.slice(start, pos)];
        pos += 9;
      } else if (tagName == "style") {
        var start = pos + 1;
        pos = S.indexOf('</style>', pos);
        children = [S.slice(start, pos)];
        pos += 8;
      } else if (NoChildNodes.indexOf(tagName) === -1) {
        pos++;
        // dash.js - BEGIN
        // Add parent to parseChildren()
        children = parseChildren(tagName, node);
        // dash.js - END
      } else {
        pos++;
      }
    } else {
      pos++;
    }
    // dash.js - BEGIN
    node.__children = children;
    return node;
    // dash.js - END
  }

  /**
   *    is parsing a string, that starts with a char and with the same usually  ' or "
   */

  function parseString() {
    var startChar = S[pos];
    var startpos = pos + 1;
    pos = S.indexOf(startChar, startpos);
    return S.slice(startpos, pos);
  }

  /**
   *
   */
  function findElements() {
    var r = new RegExp('\\s' + options.attrName + '\\s*=[\'"]' + options.attrValue + '[\'"]').exec(S);
    if (r) {
      return r.index;
    } else {
      return -1;
    }
  }
  var out = null;
  if (options.attrValue !== undefined) {
    options.attrName = options.attrName || 'id';
    var out = [];
    while ((pos = findElements()) !== -1) {
      pos = S.lastIndexOf('<', pos);
      if (pos !== -1) {
        out.push(parseNode());
      }
      S = S.substr(pos);
      pos = 0;
    }
  } else if (options.parseNode) {
    out = parseNode();
  } else {
    out = parseChildren('');
  }
  if (options.filter) {
    out = filter(out, options.filter);
  }
  if (options.simplify) {
    return simplify(Array.isArray(out) ? out : [out]);
  }
  if (options.setPos) {
    out.pos = pos;
  }
  return out;
}

/**
 * transform the DomObject to an object that is like the object of PHP`s simple_xmp_load_*() methods.
 * this format helps you to write that is more likely to keep your program working, even if there a small changes in the XML schema.
 * be aware, that it is not possible to reproduce the original xml from a simplified version, because the order of elements is not saved.
 * therefore your program will be more flexible and easier to read.
 *
 * @param {tNode[]} children the childrenList
 */
function simplify(children) {
  var out = {};
  if (!children.length) {
    return '';
  }
  if (children.length === 1 && typeof children[0] == 'string') {
    return children[0];
  }
  // map each object
  children.forEach(function (child) {
    if (typeof child !== 'object') {
      return;
    }
    if (!out[child.tagName]) out[child.tagName] = [];
    var kids = simplify(child.children);
    out[child.tagName].push(kids);
    if (Object.keys(child.attributes).length && typeof kids !== 'string') {
      kids._attributes = child.attributes;
    }
  });
  for (var i in out) {
    if (out[i].length == 1) {
      out[i] = out[i][0];
    }
  }
  return out;
}
;

/**
 * similar to simplify, but lost less
 *
 * @param {tNode[]} children the childrenList
 */
function simplifyLostLess(children) {
  let parentAttributes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var out = {};
  if (!children.length) {
    return out;
  }
  if (children.length === 1 && typeof children[0] == 'string') {
    return Object.keys(parentAttributes).length ? {
      _attributes: parentAttributes,
      value: children[0]
    } : children[0];
  }
  // map each object
  children.forEach(function (child) {
    if (typeof child !== 'object') {
      return;
    }
    if (!out[child.tagName]) out[child.tagName] = [];
    var kids = simplifyLostLess(child.children || [], child.attributes);
    out[child.tagName].push(kids);
    if (Object.keys(child.attributes).length) {
      kids._attributes = child.attributes;
    }
  });
  return out;
}
;

/**
 * behaves the same way as Array.filter, if the filter method return true, the element is in the resultList
 * @params children{Array} the children of a node
 * @param f{function} the filter method
 */
function filter(children, f) {
  let dept = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  let path = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
  var out = [];
  children.forEach(function (child, i) {
    if (typeof child === 'object' && f(child, i, dept, path)) out.push(child);
    if (child.children) {
      var kids = filter(child.children, f, dept + 1, (path ? path + '.' : '') + i + '.' + child.tagName);
      out = out.concat(kids);
    }
  });
  return out;
}
;

/**
 * stringify a previously parsed string object.
 * this is useful,
 *  1. to remove whitespace
 * 2. to recreate xml data, with some changed data.
 * @param {tNode} O the object to Stringify
 */
function stringify(O) {
  var out = '';
  function writeChildren(O) {
    if (O) {
      for (var i = 0; i < O.length; i++) {
        if (typeof O[i] == 'string') {
          out += O[i].trim();
        } else {
          writeNode(O[i]);
        }
      }
    }
  }
  function writeNode(N) {
    out += "<" + N.tagName;
    for (var i in N.attributes) {
      if (N.attributes[i] === null) {
        out += ' ' + i;
      } else if (N.attributes[i].indexOf('"') === -1) {
        out += ' ' + i + '="' + N.attributes[i].trim() + '"';
      } else {
        out += ' ' + i + "='" + N.attributes[i].trim() + "'";
      }
    }
    if (N.tagName[0] === '?') {
      out += '?>';
      return;
    }
    out += '>';
    writeChildren(N.children);
    out += '</' + N.tagName + '>';
  }
  writeChildren(O);
  return out;
}
;

/**
 * use this method to read the text content, of some node.
 * It is great if you have mixed content like:
 * this text has some <b>big</b> text and a <a href=''>link</a>
 * @return {string}
 */
function toContentString(tDom) {
  if (Array.isArray(tDom)) {
    var out = '';
    tDom.forEach(function (e) {
      out += ' ' + toContentString(e);
      out = out.trim();
    });
    return out;
  } else if (typeof tDom === 'object') {
    return toContentString(tDom.children);
  } else {
    return ' ' + tDom;
  }
}
;
function getElementById(S, id, simplified) {
  var out = parse(S, {
    attrValue: id
  });
  return simplified ? tXml.simplify(out) : out[0];
}
;
function getElementsByClassName(S, classname, simplified) {
  const out = parse(S, {
    attrName: 'class',
    attrValue: '[a-zA-Z0-9- ]*' + classname + '[a-zA-Z0-9- ]*'
  });
  return simplified ? tXml.simplify(out) : out;
}
;

/***/ }),

/***/ "./node_modules/bcp-47-match/index.js":
/*!********************************************!*\
  !*** ./node_modules/bcp-47-match/index.js ***!
  \********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   basicFilter: function() { return /* binding */ basicFilter; },
/* harmony export */   extendedFilter: function() { return /* binding */ extendedFilter; },
/* harmony export */   lookup: function() { return /* binding */ lookup; }
/* harmony export */ });
/**
 * See <https://tools.ietf.org/html/rfc4647#section-3.1>
 * for more info on the algorithms.
 */

/**
 * @typedef {string} Tag
 *   BCP-47 tag.
 * @typedef {Array<Tag>} Tags
 *   List of BCP-47 tags.
 * @typedef {string} Range
 *   RFC 4647 range.
 * @typedef {Array<Range>} Ranges
 *   List of RFC 4647 range.
 *
 * @callback Check
 *   An internal check.
 * @param {Tag} tag
 *   BCP-47 tag.
 * @param {Range} range
 *   RFC 4647 range.
 * @returns {boolean}
 *   Whether the range matches the tag.
 *
 * @typedef {FilterOrLookup<true>} Filter
 *   Filter: yields all tags that match a range.
 * @typedef {FilterOrLookup<false>} Lookup
 *   Lookup: yields the best tag that matches a range.
 */

/**
 * @template {boolean} IsFilter
 *   Whether to filter or perform a lookup.
 * @callback FilterOrLookup
 *   A check.
 * @param {Tag|Tags} tags
 *   One or more BCP-47 tags.
 * @param {Range|Ranges|undefined} [ranges='*']
 *   One or more RFC 4647 ranges.
 * @returns {IsFilter extends true ? Tags : Tag|undefined}
 *   Result.
 */

/**
 * Factory to perform a filter or a lookup.
 *
 * This factory creates a function that accepts a list of tags and a list of
 * ranges, and contains logic to exit early for lookups.
 * `check` just has to deal with one tag and one range.
 * This match function iterates over ranges, and for each range,
 * iterates over tags.
 * That way, earlier ranges matching any tag have precedence over later ranges.
 *
 * @template {boolean} IsFilter
 * @param {Check} check
 *   A check.
 * @param {IsFilter} filter
 *   Whether to filter or perform a lookup.
 * @returns {FilterOrLookup<IsFilter>}
 *   Filter or lookup.
 */
function factory(check, filter) {
  /**
   * @param {Tag|Tags} tags
   *   One or more BCP-47 tags.
   * @param {Range|Ranges|undefined} [ranges='*']
   *   One or more RFC 4647 ranges.
   * @returns {IsFilter extends true ? Tags : Tag|undefined}
   *   Result.
   */
  return function (tags, ranges) {
    let left = cast(tags, 'tag');
    const right = cast(ranges === null || ranges === undefined ? '*' : ranges, 'range');
    /** @type {Tags} */
    const matches = [];
    let rightIndex = -1;
    while (++rightIndex < right.length) {
      const range = right[rightIndex].toLowerCase();

      // Ignore wildcards in lookup mode.
      if (!filter && range === '*') continue;
      let leftIndex = -1;
      /** @type {Tags} */
      const next = [];
      while (++leftIndex < left.length) {
        if (check(left[leftIndex].toLowerCase(), range)) {
          // Exit if this is a lookup and we have a match.
          if (!filter) {
            return /** @type {IsFilter extends true ? Tags : Tag|undefined} */left[leftIndex];
          }
          matches.push(left[leftIndex]);
        } else {
          next.push(left[leftIndex]);
        }
      }
      left = next;
    }

    // If this is a filter, return the list.  If it’s a lookup, we didn’t find
    // a match, so return `undefined`.
    return /** @type {IsFilter extends true ? Tags : Tag|undefined} */filter ? matches : undefined;
  };
}

/**
 * Basic Filtering (Section 3.3.1) matches a language priority list consisting
 * of basic language ranges (Section 2.1) to sets of language tags.
 *
 * @param {Tag|Tags} tags
 *   One or more BCP-47 tags.
 * @param {Range|Ranges|undefined} [ranges='*']
 *   One or more RFC 4647 ranges.
 * @returns {Tags}
 *   List of BCP-47 tags.
 */
const basicFilter = factory(function (tag, range) {
  return range === '*' || tag === range || tag.includes(range + '-');
}, true);

/**
 * Extended Filtering (Section 3.3.2) matches a language priority list
 * consisting of extended language ranges (Section 2.2) to sets of language
 * tags.
 *
 * @param {Tag|Tags} tags
 *   One or more BCP-47 tags.
 * @param {Range|Ranges|undefined} [ranges='*']
 *   One or more RFC 4647 ranges.
 * @returns {Tags}
 *   List of BCP-47 tags.
 */
const extendedFilter = factory(function (tag, range) {
  // 3.3.2.1
  const left = tag.split('-');
  const right = range.split('-');
  let leftIndex = 0;
  let rightIndex = 0;

  // 3.3.2.2
  if (right[rightIndex] !== '*' && left[leftIndex] !== right[rightIndex]) {
    return false;
  }
  leftIndex++;
  rightIndex++;

  // 3.3.2.3
  while (rightIndex < right.length) {
    // 3.3.2.3.A
    if (right[rightIndex] === '*') {
      rightIndex++;
      continue;
    }

    // 3.3.2.3.B
    if (!left[leftIndex]) return false;

    // 3.3.2.3.C
    if (left[leftIndex] === right[rightIndex]) {
      leftIndex++;
      rightIndex++;
      continue;
    }

    // 3.3.2.3.D
    if (left[leftIndex].length === 1) return false;

    // 3.3.2.3.E
    leftIndex++;
  }

  // 3.3.2.4
  return true;
}, true);

/**
 * Lookup (Section 3.4) matches a language priority list consisting of basic
 * language ranges to sets of language tags to find the one exact language tag
 * that best matches the range.
 *
 * @param {Tag|Tags} tags
 *   One or more BCP-47 tags.
 * @param {Range|Ranges|undefined} [ranges='*']
 *   One or more RFC 4647 ranges.
 * @returns {Tag|undefined}
 *   BCP-47 tag.
 */
const lookup = factory(function (tag, range) {
  let right = range;

  /* eslint-disable-next-line no-constant-condition */
  while (true) {
    if (right === '*' || tag === right) return true;
    let index = right.lastIndexOf('-');
    if (index < 0) return false;
    if (right.charAt(index - 2) === '-') index -= 2;
    right = right.slice(0, index);
  }
}, false);

/**
 * Validate tags or ranges, and cast them to arrays.
 *
 * @param {string|Array<string>} values
 * @param {string} name
 * @returns {Array<string>}
 */
function cast(values, name) {
  const value = values && typeof values === 'string' ? [values] : values;
  if (!value || typeof value !== 'object' || !('length' in value)) {
    throw new Error('Invalid ' + name + ' `' + value + '`, expected non-empty string');
  }
  return value;
}

/***/ }),

/***/ "./node_modules/bcp-47-normalize/lib/fields.js":
/*!*****************************************************!*\
  !*** ./node_modules/bcp-47-normalize/lib/fields.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fields: function() { return /* binding */ fields; }
/* harmony export */ });
/**
 * @typedef {'script'|'region'|'variants'} Field
 *
 * @typedef AddOrRemove
 * @property {Field} field
 * @property {string} value
 *
 * @typedef Change
 * @property {AddOrRemove} from
 * @property {AddOrRemove} to
 */

/**
 * @type {Array<Change>}
 */
const fields = [{
  from: {
    field: 'script',
    value: 'qaai'
  },
  to: {
    field: 'script',
    value: 'zinh'
  }
}, {
  from: {
    field: 'region',
    value: 'bu'
  },
  to: {
    field: 'region',
    value: 'mm'
  }
}, {
  from: {
    field: 'region',
    value: 'ct'
  },
  to: {
    field: 'region',
    value: 'ki'
  }
}, {
  from: {
    field: 'region',
    value: 'dd'
  },
  to: {
    field: 'region',
    value: 'de'
  }
}, {
  from: {
    field: 'region',
    value: 'dy'
  },
  to: {
    field: 'region',
    value: 'bj'
  }
}, {
  from: {
    field: 'region',
    value: 'fx'
  },
  to: {
    field: 'region',
    value: 'fr'
  }
}, {
  from: {
    field: 'region',
    value: 'hv'
  },
  to: {
    field: 'region',
    value: 'bf'
  }
}, {
  from: {
    field: 'region',
    value: 'jt'
  },
  to: {
    field: 'region',
    value: 'um'
  }
}, {
  from: {
    field: 'region',
    value: 'mi'
  },
  to: {
    field: 'region',
    value: 'um'
  }
}, {
  from: {
    field: 'region',
    value: 'nh'
  },
  to: {
    field: 'region',
    value: 'vu'
  }
}, {
  from: {
    field: 'region',
    value: 'nq'
  },
  to: {
    field: 'region',
    value: 'aq'
  }
}, {
  from: {
    field: 'region',
    value: 'pu'
  },
  to: {
    field: 'region',
    value: 'um'
  }
}, {
  from: {
    field: 'region',
    value: 'pz'
  },
  to: {
    field: 'region',
    value: 'pa'
  }
}, {
  from: {
    field: 'region',
    value: 'qu'
  },
  to: {
    field: 'region',
    value: 'eu'
  }
}, {
  from: {
    field: 'region',
    value: 'rh'
  },
  to: {
    field: 'region',
    value: 'zw'
  }
}, {
  from: {
    field: 'region',
    value: 'tp'
  },
  to: {
    field: 'region',
    value: 'tl'
  }
}, {
  from: {
    field: 'region',
    value: 'uk'
  },
  to: {
    field: 'region',
    value: 'gb'
  }
}, {
  from: {
    field: 'region',
    value: 'vd'
  },
  to: {
    field: 'region',
    value: 'vn'
  }
}, {
  from: {
    field: 'region',
    value: 'wk'
  },
  to: {
    field: 'region',
    value: 'um'
  }
}, {
  from: {
    field: 'region',
    value: 'yd'
  },
  to: {
    field: 'region',
    value: 'ye'
  }
}, {
  from: {
    field: 'region',
    value: 'zr'
  },
  to: {
    field: 'region',
    value: 'cd'
  }
}, {
  from: {
    field: 'region',
    value: '230'
  },
  to: {
    field: 'region',
    value: 'et'
  }
}, {
  from: {
    field: 'region',
    value: '280'
  },
  to: {
    field: 'region',
    value: 'de'
  }
}, {
  from: {
    field: 'region',
    value: '736'
  },
  to: {
    field: 'region',
    value: 'sd'
  }
}, {
  from: {
    field: 'region',
    value: '886'
  },
  to: {
    field: 'region',
    value: 'ye'
  }
}, {
  from: {
    field: 'region',
    value: '958'
  },
  to: {
    field: 'region',
    value: 'aa'
  }
}, {
  from: {
    field: 'region',
    value: '020'
  },
  to: {
    field: 'region',
    value: 'ad'
  }
}, {
  from: {
    field: 'region',
    value: '784'
  },
  to: {
    field: 'region',
    value: 'ae'
  }
}, {
  from: {
    field: 'region',
    value: '004'
  },
  to: {
    field: 'region',
    value: 'af'
  }
}, {
  from: {
    field: 'region',
    value: '028'
  },
  to: {
    field: 'region',
    value: 'ag'
  }
}, {
  from: {
    field: 'region',
    value: '660'
  },
  to: {
    field: 'region',
    value: 'ai'
  }
}, {
  from: {
    field: 'region',
    value: '008'
  },
  to: {
    field: 'region',
    value: 'al'
  }
}, {
  from: {
    field: 'region',
    value: '051'
  },
  to: {
    field: 'region',
    value: 'am'
  }
}, {
  from: {
    field: 'region',
    value: '024'
  },
  to: {
    field: 'region',
    value: 'ao'
  }
}, {
  from: {
    field: 'region',
    value: '010'
  },
  to: {
    field: 'region',
    value: 'aq'
  }
}, {
  from: {
    field: 'region',
    value: '032'
  },
  to: {
    field: 'region',
    value: 'ar'
  }
}, {
  from: {
    field: 'region',
    value: '016'
  },
  to: {
    field: 'region',
    value: 'as'
  }
}, {
  from: {
    field: 'region',
    value: '040'
  },
  to: {
    field: 'region',
    value: 'at'
  }
}, {
  from: {
    field: 'region',
    value: '036'
  },
  to: {
    field: 'region',
    value: 'au'
  }
}, {
  from: {
    field: 'region',
    value: '533'
  },
  to: {
    field: 'region',
    value: 'aw'
  }
}, {
  from: {
    field: 'region',
    value: '248'
  },
  to: {
    field: 'region',
    value: 'ax'
  }
}, {
  from: {
    field: 'region',
    value: '031'
  },
  to: {
    field: 'region',
    value: 'az'
  }
}, {
  from: {
    field: 'region',
    value: '070'
  },
  to: {
    field: 'region',
    value: 'ba'
  }
}, {
  from: {
    field: 'region',
    value: '052'
  },
  to: {
    field: 'region',
    value: 'bb'
  }
}, {
  from: {
    field: 'region',
    value: '050'
  },
  to: {
    field: 'region',
    value: 'bd'
  }
}, {
  from: {
    field: 'region',
    value: '056'
  },
  to: {
    field: 'region',
    value: 'be'
  }
}, {
  from: {
    field: 'region',
    value: '854'
  },
  to: {
    field: 'region',
    value: 'bf'
  }
}, {
  from: {
    field: 'region',
    value: '100'
  },
  to: {
    field: 'region',
    value: 'bg'
  }
}, {
  from: {
    field: 'region',
    value: '048'
  },
  to: {
    field: 'region',
    value: 'bh'
  }
}, {
  from: {
    field: 'region',
    value: '108'
  },
  to: {
    field: 'region',
    value: 'bi'
  }
}, {
  from: {
    field: 'region',
    value: '204'
  },
  to: {
    field: 'region',
    value: 'bj'
  }
}, {
  from: {
    field: 'region',
    value: '652'
  },
  to: {
    field: 'region',
    value: 'bl'
  }
}, {
  from: {
    field: 'region',
    value: '060'
  },
  to: {
    field: 'region',
    value: 'bm'
  }
}, {
  from: {
    field: 'region',
    value: '096'
  },
  to: {
    field: 'region',
    value: 'bn'
  }
}, {
  from: {
    field: 'region',
    value: '068'
  },
  to: {
    field: 'region',
    value: 'bo'
  }
}, {
  from: {
    field: 'region',
    value: '535'
  },
  to: {
    field: 'region',
    value: 'bq'
  }
}, {
  from: {
    field: 'region',
    value: '076'
  },
  to: {
    field: 'region',
    value: 'br'
  }
}, {
  from: {
    field: 'region',
    value: '044'
  },
  to: {
    field: 'region',
    value: 'bs'
  }
}, {
  from: {
    field: 'region',
    value: '064'
  },
  to: {
    field: 'region',
    value: 'bt'
  }
}, {
  from: {
    field: 'region',
    value: '104'
  },
  to: {
    field: 'region',
    value: 'mm'
  }
}, {
  from: {
    field: 'region',
    value: '074'
  },
  to: {
    field: 'region',
    value: 'bv'
  }
}, {
  from: {
    field: 'region',
    value: '072'
  },
  to: {
    field: 'region',
    value: 'bw'
  }
}, {
  from: {
    field: 'region',
    value: '112'
  },
  to: {
    field: 'region',
    value: 'by'
  }
}, {
  from: {
    field: 'region',
    value: '084'
  },
  to: {
    field: 'region',
    value: 'bz'
  }
}, {
  from: {
    field: 'region',
    value: '124'
  },
  to: {
    field: 'region',
    value: 'ca'
  }
}, {
  from: {
    field: 'region',
    value: '166'
  },
  to: {
    field: 'region',
    value: 'cc'
  }
}, {
  from: {
    field: 'region',
    value: '180'
  },
  to: {
    field: 'region',
    value: 'cd'
  }
}, {
  from: {
    field: 'region',
    value: '140'
  },
  to: {
    field: 'region',
    value: 'cf'
  }
}, {
  from: {
    field: 'region',
    value: '178'
  },
  to: {
    field: 'region',
    value: 'cg'
  }
}, {
  from: {
    field: 'region',
    value: '756'
  },
  to: {
    field: 'region',
    value: 'ch'
  }
}, {
  from: {
    field: 'region',
    value: '384'
  },
  to: {
    field: 'region',
    value: 'ci'
  }
}, {
  from: {
    field: 'region',
    value: '184'
  },
  to: {
    field: 'region',
    value: 'ck'
  }
}, {
  from: {
    field: 'region',
    value: '152'
  },
  to: {
    field: 'region',
    value: 'cl'
  }
}, {
  from: {
    field: 'region',
    value: '120'
  },
  to: {
    field: 'region',
    value: 'cm'
  }
}, {
  from: {
    field: 'region',
    value: '156'
  },
  to: {
    field: 'region',
    value: 'cn'
  }
}, {
  from: {
    field: 'region',
    value: '170'
  },
  to: {
    field: 'region',
    value: 'co'
  }
}, {
  from: {
    field: 'region',
    value: '188'
  },
  to: {
    field: 'region',
    value: 'cr'
  }
}, {
  from: {
    field: 'region',
    value: '192'
  },
  to: {
    field: 'region',
    value: 'cu'
  }
}, {
  from: {
    field: 'region',
    value: '132'
  },
  to: {
    field: 'region',
    value: 'cv'
  }
}, {
  from: {
    field: 'region',
    value: '531'
  },
  to: {
    field: 'region',
    value: 'cw'
  }
}, {
  from: {
    field: 'region',
    value: '162'
  },
  to: {
    field: 'region',
    value: 'cx'
  }
}, {
  from: {
    field: 'region',
    value: '196'
  },
  to: {
    field: 'region',
    value: 'cy'
  }
}, {
  from: {
    field: 'region',
    value: '203'
  },
  to: {
    field: 'region',
    value: 'cz'
  }
}, {
  from: {
    field: 'region',
    value: '278'
  },
  to: {
    field: 'region',
    value: 'de'
  }
}, {
  from: {
    field: 'region',
    value: '276'
  },
  to: {
    field: 'region',
    value: 'de'
  }
}, {
  from: {
    field: 'region',
    value: '262'
  },
  to: {
    field: 'region',
    value: 'dj'
  }
}, {
  from: {
    field: 'region',
    value: '208'
  },
  to: {
    field: 'region',
    value: 'dk'
  }
}, {
  from: {
    field: 'region',
    value: '212'
  },
  to: {
    field: 'region',
    value: 'dm'
  }
}, {
  from: {
    field: 'region',
    value: '214'
  },
  to: {
    field: 'region',
    value: 'do'
  }
}, {
  from: {
    field: 'region',
    value: '012'
  },
  to: {
    field: 'region',
    value: 'dz'
  }
}, {
  from: {
    field: 'region',
    value: '218'
  },
  to: {
    field: 'region',
    value: 'ec'
  }
}, {
  from: {
    field: 'region',
    value: '233'
  },
  to: {
    field: 'region',
    value: 'ee'
  }
}, {
  from: {
    field: 'region',
    value: '818'
  },
  to: {
    field: 'region',
    value: 'eg'
  }
}, {
  from: {
    field: 'region',
    value: '732'
  },
  to: {
    field: 'region',
    value: 'eh'
  }
}, {
  from: {
    field: 'region',
    value: '232'
  },
  to: {
    field: 'region',
    value: 'er'
  }
}, {
  from: {
    field: 'region',
    value: '724'
  },
  to: {
    field: 'region',
    value: 'es'
  }
}, {
  from: {
    field: 'region',
    value: '231'
  },
  to: {
    field: 'region',
    value: 'et'
  }
}, {
  from: {
    field: 'region',
    value: '246'
  },
  to: {
    field: 'region',
    value: 'fi'
  }
}, {
  from: {
    field: 'region',
    value: '242'
  },
  to: {
    field: 'region',
    value: 'fj'
  }
}, {
  from: {
    field: 'region',
    value: '238'
  },
  to: {
    field: 'region',
    value: 'fk'
  }
}, {
  from: {
    field: 'region',
    value: '583'
  },
  to: {
    field: 'region',
    value: 'fm'
  }
}, {
  from: {
    field: 'region',
    value: '234'
  },
  to: {
    field: 'region',
    value: 'fo'
  }
}, {
  from: {
    field: 'region',
    value: '250'
  },
  to: {
    field: 'region',
    value: 'fr'
  }
}, {
  from: {
    field: 'region',
    value: '249'
  },
  to: {
    field: 'region',
    value: 'fr'
  }
}, {
  from: {
    field: 'region',
    value: '266'
  },
  to: {
    field: 'region',
    value: 'ga'
  }
}, {
  from: {
    field: 'region',
    value: '826'
  },
  to: {
    field: 'region',
    value: 'gb'
  }
}, {
  from: {
    field: 'region',
    value: '308'
  },
  to: {
    field: 'region',
    value: 'gd'
  }
}, {
  from: {
    field: 'region',
    value: '268'
  },
  to: {
    field: 'region',
    value: 'ge'
  }
}, {
  from: {
    field: 'region',
    value: '254'
  },
  to: {
    field: 'region',
    value: 'gf'
  }
}, {
  from: {
    field: 'region',
    value: '831'
  },
  to: {
    field: 'region',
    value: 'gg'
  }
}, {
  from: {
    field: 'region',
    value: '288'
  },
  to: {
    field: 'region',
    value: 'gh'
  }
}, {
  from: {
    field: 'region',
    value: '292'
  },
  to: {
    field: 'region',
    value: 'gi'
  }
}, {
  from: {
    field: 'region',
    value: '304'
  },
  to: {
    field: 'region',
    value: 'gl'
  }
}, {
  from: {
    field: 'region',
    value: '270'
  },
  to: {
    field: 'region',
    value: 'gm'
  }
}, {
  from: {
    field: 'region',
    value: '324'
  },
  to: {
    field: 'region',
    value: 'gn'
  }
}, {
  from: {
    field: 'region',
    value: '312'
  },
  to: {
    field: 'region',
    value: 'gp'
  }
}, {
  from: {
    field: 'region',
    value: '226'
  },
  to: {
    field: 'region',
    value: 'gq'
  }
}, {
  from: {
    field: 'region',
    value: '300'
  },
  to: {
    field: 'region',
    value: 'gr'
  }
}, {
  from: {
    field: 'region',
    value: '239'
  },
  to: {
    field: 'region',
    value: 'gs'
  }
}, {
  from: {
    field: 'region',
    value: '320'
  },
  to: {
    field: 'region',
    value: 'gt'
  }
}, {
  from: {
    field: 'region',
    value: '316'
  },
  to: {
    field: 'region',
    value: 'gu'
  }
}, {
  from: {
    field: 'region',
    value: '624'
  },
  to: {
    field: 'region',
    value: 'gw'
  }
}, {
  from: {
    field: 'region',
    value: '328'
  },
  to: {
    field: 'region',
    value: 'gy'
  }
}, {
  from: {
    field: 'region',
    value: '344'
  },
  to: {
    field: 'region',
    value: 'hk'
  }
}, {
  from: {
    field: 'region',
    value: '334'
  },
  to: {
    field: 'region',
    value: 'hm'
  }
}, {
  from: {
    field: 'region',
    value: '340'
  },
  to: {
    field: 'region',
    value: 'hn'
  }
}, {
  from: {
    field: 'region',
    value: '191'
  },
  to: {
    field: 'region',
    value: 'hr'
  }
}, {
  from: {
    field: 'region',
    value: '332'
  },
  to: {
    field: 'region',
    value: 'ht'
  }
}, {
  from: {
    field: 'region',
    value: '348'
  },
  to: {
    field: 'region',
    value: 'hu'
  }
}, {
  from: {
    field: 'region',
    value: '360'
  },
  to: {
    field: 'region',
    value: 'id'
  }
}, {
  from: {
    field: 'region',
    value: '372'
  },
  to: {
    field: 'region',
    value: 'ie'
  }
}, {
  from: {
    field: 'region',
    value: '376'
  },
  to: {
    field: 'region',
    value: 'il'
  }
}, {
  from: {
    field: 'region',
    value: '833'
  },
  to: {
    field: 'region',
    value: 'im'
  }
}, {
  from: {
    field: 'region',
    value: '356'
  },
  to: {
    field: 'region',
    value: 'in'
  }
}, {
  from: {
    field: 'region',
    value: '086'
  },
  to: {
    field: 'region',
    value: 'io'
  }
}, {
  from: {
    field: 'region',
    value: '368'
  },
  to: {
    field: 'region',
    value: 'iq'
  }
}, {
  from: {
    field: 'region',
    value: '364'
  },
  to: {
    field: 'region',
    value: 'ir'
  }
}, {
  from: {
    field: 'region',
    value: '352'
  },
  to: {
    field: 'region',
    value: 'is'
  }
}, {
  from: {
    field: 'region',
    value: '380'
  },
  to: {
    field: 'region',
    value: 'it'
  }
}, {
  from: {
    field: 'region',
    value: '832'
  },
  to: {
    field: 'region',
    value: 'je'
  }
}, {
  from: {
    field: 'region',
    value: '388'
  },
  to: {
    field: 'region',
    value: 'jm'
  }
}, {
  from: {
    field: 'region',
    value: '400'
  },
  to: {
    field: 'region',
    value: 'jo'
  }
}, {
  from: {
    field: 'region',
    value: '392'
  },
  to: {
    field: 'region',
    value: 'jp'
  }
}, {
  from: {
    field: 'region',
    value: '404'
  },
  to: {
    field: 'region',
    value: 'ke'
  }
}, {
  from: {
    field: 'region',
    value: '417'
  },
  to: {
    field: 'region',
    value: 'kg'
  }
}, {
  from: {
    field: 'region',
    value: '116'
  },
  to: {
    field: 'region',
    value: 'kh'
  }
}, {
  from: {
    field: 'region',
    value: '296'
  },
  to: {
    field: 'region',
    value: 'ki'
  }
}, {
  from: {
    field: 'region',
    value: '174'
  },
  to: {
    field: 'region',
    value: 'km'
  }
}, {
  from: {
    field: 'region',
    value: '659'
  },
  to: {
    field: 'region',
    value: 'kn'
  }
}, {
  from: {
    field: 'region',
    value: '408'
  },
  to: {
    field: 'region',
    value: 'kp'
  }
}, {
  from: {
    field: 'region',
    value: '410'
  },
  to: {
    field: 'region',
    value: 'kr'
  }
}, {
  from: {
    field: 'region',
    value: '414'
  },
  to: {
    field: 'region',
    value: 'kw'
  }
}, {
  from: {
    field: 'region',
    value: '136'
  },
  to: {
    field: 'region',
    value: 'ky'
  }
}, {
  from: {
    field: 'region',
    value: '398'
  },
  to: {
    field: 'region',
    value: 'kz'
  }
}, {
  from: {
    field: 'region',
    value: '418'
  },
  to: {
    field: 'region',
    value: 'la'
  }
}, {
  from: {
    field: 'region',
    value: '422'
  },
  to: {
    field: 'region',
    value: 'lb'
  }
}, {
  from: {
    field: 'region',
    value: '662'
  },
  to: {
    field: 'region',
    value: 'lc'
  }
}, {
  from: {
    field: 'region',
    value: '438'
  },
  to: {
    field: 'region',
    value: 'li'
  }
}, {
  from: {
    field: 'region',
    value: '144'
  },
  to: {
    field: 'region',
    value: 'lk'
  }
}, {
  from: {
    field: 'region',
    value: '430'
  },
  to: {
    field: 'region',
    value: 'lr'
  }
}, {
  from: {
    field: 'region',
    value: '426'
  },
  to: {
    field: 'region',
    value: 'ls'
  }
}, {
  from: {
    field: 'region',
    value: '440'
  },
  to: {
    field: 'region',
    value: 'lt'
  }
}, {
  from: {
    field: 'region',
    value: '442'
  },
  to: {
    field: 'region',
    value: 'lu'
  }
}, {
  from: {
    field: 'region',
    value: '428'
  },
  to: {
    field: 'region',
    value: 'lv'
  }
}, {
  from: {
    field: 'region',
    value: '434'
  },
  to: {
    field: 'region',
    value: 'ly'
  }
}, {
  from: {
    field: 'region',
    value: '504'
  },
  to: {
    field: 'region',
    value: 'ma'
  }
}, {
  from: {
    field: 'region',
    value: '492'
  },
  to: {
    field: 'region',
    value: 'mc'
  }
}, {
  from: {
    field: 'region',
    value: '498'
  },
  to: {
    field: 'region',
    value: 'md'
  }
}, {
  from: {
    field: 'region',
    value: '499'
  },
  to: {
    field: 'region',
    value: 'me'
  }
}, {
  from: {
    field: 'region',
    value: '663'
  },
  to: {
    field: 'region',
    value: 'mf'
  }
}, {
  from: {
    field: 'region',
    value: '450'
  },
  to: {
    field: 'region',
    value: 'mg'
  }
}, {
  from: {
    field: 'region',
    value: '584'
  },
  to: {
    field: 'region',
    value: 'mh'
  }
}, {
  from: {
    field: 'region',
    value: '807'
  },
  to: {
    field: 'region',
    value: 'mk'
  }
}, {
  from: {
    field: 'region',
    value: '466'
  },
  to: {
    field: 'region',
    value: 'ml'
  }
}, {
  from: {
    field: 'region',
    value: '496'
  },
  to: {
    field: 'region',
    value: 'mn'
  }
}, {
  from: {
    field: 'region',
    value: '446'
  },
  to: {
    field: 'region',
    value: 'mo'
  }
}, {
  from: {
    field: 'region',
    value: '580'
  },
  to: {
    field: 'region',
    value: 'mp'
  }
}, {
  from: {
    field: 'region',
    value: '474'
  },
  to: {
    field: 'region',
    value: 'mq'
  }
}, {
  from: {
    field: 'region',
    value: '478'
  },
  to: {
    field: 'region',
    value: 'mr'
  }
}, {
  from: {
    field: 'region',
    value: '500'
  },
  to: {
    field: 'region',
    value: 'ms'
  }
}, {
  from: {
    field: 'region',
    value: '470'
  },
  to: {
    field: 'region',
    value: 'mt'
  }
}, {
  from: {
    field: 'region',
    value: '480'
  },
  to: {
    field: 'region',
    value: 'mu'
  }
}, {
  from: {
    field: 'region',
    value: '462'
  },
  to: {
    field: 'region',
    value: 'mv'
  }
}, {
  from: {
    field: 'region',
    value: '454'
  },
  to: {
    field: 'region',
    value: 'mw'
  }
}, {
  from: {
    field: 'region',
    value: '484'
  },
  to: {
    field: 'region',
    value: 'mx'
  }
}, {
  from: {
    field: 'region',
    value: '458'
  },
  to: {
    field: 'region',
    value: 'my'
  }
}, {
  from: {
    field: 'region',
    value: '508'
  },
  to: {
    field: 'region',
    value: 'mz'
  }
}, {
  from: {
    field: 'region',
    value: '516'
  },
  to: {
    field: 'region',
    value: 'na'
  }
}, {
  from: {
    field: 'region',
    value: '540'
  },
  to: {
    field: 'region',
    value: 'nc'
  }
}, {
  from: {
    field: 'region',
    value: '562'
  },
  to: {
    field: 'region',
    value: 'ne'
  }
}, {
  from: {
    field: 'region',
    value: '574'
  },
  to: {
    field: 'region',
    value: 'nf'
  }
}, {
  from: {
    field: 'region',
    value: '566'
  },
  to: {
    field: 'region',
    value: 'ng'
  }
}, {
  from: {
    field: 'region',
    value: '558'
  },
  to: {
    field: 'region',
    value: 'ni'
  }
}, {
  from: {
    field: 'region',
    value: '528'
  },
  to: {
    field: 'region',
    value: 'nl'
  }
}, {
  from: {
    field: 'region',
    value: '578'
  },
  to: {
    field: 'region',
    value: 'no'
  }
}, {
  from: {
    field: 'region',
    value: '524'
  },
  to: {
    field: 'region',
    value: 'np'
  }
}, {
  from: {
    field: 'region',
    value: '520'
  },
  to: {
    field: 'region',
    value: 'nr'
  }
}, {
  from: {
    field: 'region',
    value: '570'
  },
  to: {
    field: 'region',
    value: 'nu'
  }
}, {
  from: {
    field: 'region',
    value: '554'
  },
  to: {
    field: 'region',
    value: 'nz'
  }
}, {
  from: {
    field: 'region',
    value: '512'
  },
  to: {
    field: 'region',
    value: 'om'
  }
}, {
  from: {
    field: 'region',
    value: '591'
  },
  to: {
    field: 'region',
    value: 'pa'
  }
}, {
  from: {
    field: 'region',
    value: '604'
  },
  to: {
    field: 'region',
    value: 'pe'
  }
}, {
  from: {
    field: 'region',
    value: '258'
  },
  to: {
    field: 'region',
    value: 'pf'
  }
}, {
  from: {
    field: 'region',
    value: '598'
  },
  to: {
    field: 'region',
    value: 'pg'
  }
}, {
  from: {
    field: 'region',
    value: '608'
  },
  to: {
    field: 'region',
    value: 'ph'
  }
}, {
  from: {
    field: 'region',
    value: '586'
  },
  to: {
    field: 'region',
    value: 'pk'
  }
}, {
  from: {
    field: 'region',
    value: '616'
  },
  to: {
    field: 'region',
    value: 'pl'
  }
}, {
  from: {
    field: 'region',
    value: '666'
  },
  to: {
    field: 'region',
    value: 'pm'
  }
}, {
  from: {
    field: 'region',
    value: '612'
  },
  to: {
    field: 'region',
    value: 'pn'
  }
}, {
  from: {
    field: 'region',
    value: '630'
  },
  to: {
    field: 'region',
    value: 'pr'
  }
}, {
  from: {
    field: 'region',
    value: '275'
  },
  to: {
    field: 'region',
    value: 'ps'
  }
}, {
  from: {
    field: 'region',
    value: '620'
  },
  to: {
    field: 'region',
    value: 'pt'
  }
}, {
  from: {
    field: 'region',
    value: '585'
  },
  to: {
    field: 'region',
    value: 'pw'
  }
}, {
  from: {
    field: 'region',
    value: '600'
  },
  to: {
    field: 'region',
    value: 'py'
  }
}, {
  from: {
    field: 'region',
    value: '634'
  },
  to: {
    field: 'region',
    value: 'qa'
  }
}, {
  from: {
    field: 'region',
    value: '959'
  },
  to: {
    field: 'region',
    value: 'qm'
  }
}, {
  from: {
    field: 'region',
    value: '960'
  },
  to: {
    field: 'region',
    value: 'qn'
  }
}, {
  from: {
    field: 'region',
    value: '962'
  },
  to: {
    field: 'region',
    value: 'qp'
  }
}, {
  from: {
    field: 'region',
    value: '963'
  },
  to: {
    field: 'region',
    value: 'qq'
  }
}, {
  from: {
    field: 'region',
    value: '964'
  },
  to: {
    field: 'region',
    value: 'qr'
  }
}, {
  from: {
    field: 'region',
    value: '965'
  },
  to: {
    field: 'region',
    value: 'qs'
  }
}, {
  from: {
    field: 'region',
    value: '966'
  },
  to: {
    field: 'region',
    value: 'qt'
  }
}, {
  from: {
    field: 'region',
    value: '967'
  },
  to: {
    field: 'region',
    value: 'eu'
  }
}, {
  from: {
    field: 'region',
    value: '968'
  },
  to: {
    field: 'region',
    value: 'qv'
  }
}, {
  from: {
    field: 'region',
    value: '969'
  },
  to: {
    field: 'region',
    value: 'qw'
  }
}, {
  from: {
    field: 'region',
    value: '970'
  },
  to: {
    field: 'region',
    value: 'qx'
  }
}, {
  from: {
    field: 'region',
    value: '971'
  },
  to: {
    field: 'region',
    value: 'qy'
  }
}, {
  from: {
    field: 'region',
    value: '972'
  },
  to: {
    field: 'region',
    value: 'qz'
  }
}, {
  from: {
    field: 'region',
    value: '638'
  },
  to: {
    field: 'region',
    value: 're'
  }
}, {
  from: {
    field: 'region',
    value: '642'
  },
  to: {
    field: 'region',
    value: 'ro'
  }
}, {
  from: {
    field: 'region',
    value: '688'
  },
  to: {
    field: 'region',
    value: 'rs'
  }
}, {
  from: {
    field: 'region',
    value: '643'
  },
  to: {
    field: 'region',
    value: 'ru'
  }
}, {
  from: {
    field: 'region',
    value: '646'
  },
  to: {
    field: 'region',
    value: 'rw'
  }
}, {
  from: {
    field: 'region',
    value: '682'
  },
  to: {
    field: 'region',
    value: 'sa'
  }
}, {
  from: {
    field: 'region',
    value: '090'
  },
  to: {
    field: 'region',
    value: 'sb'
  }
}, {
  from: {
    field: 'region',
    value: '690'
  },
  to: {
    field: 'region',
    value: 'sc'
  }
}, {
  from: {
    field: 'region',
    value: '729'
  },
  to: {
    field: 'region',
    value: 'sd'
  }
}, {
  from: {
    field: 'region',
    value: '752'
  },
  to: {
    field: 'region',
    value: 'se'
  }
}, {
  from: {
    field: 'region',
    value: '702'
  },
  to: {
    field: 'region',
    value: 'sg'
  }
}, {
  from: {
    field: 'region',
    value: '654'
  },
  to: {
    field: 'region',
    value: 'sh'
  }
}, {
  from: {
    field: 'region',
    value: '705'
  },
  to: {
    field: 'region',
    value: 'si'
  }
}, {
  from: {
    field: 'region',
    value: '744'
  },
  to: {
    field: 'region',
    value: 'sj'
  }
}, {
  from: {
    field: 'region',
    value: '703'
  },
  to: {
    field: 'region',
    value: 'sk'
  }
}, {
  from: {
    field: 'region',
    value: '694'
  },
  to: {
    field: 'region',
    value: 'sl'
  }
}, {
  from: {
    field: 'region',
    value: '674'
  },
  to: {
    field: 'region',
    value: 'sm'
  }
}, {
  from: {
    field: 'region',
    value: '686'
  },
  to: {
    field: 'region',
    value: 'sn'
  }
}, {
  from: {
    field: 'region',
    value: '706'
  },
  to: {
    field: 'region',
    value: 'so'
  }
}, {
  from: {
    field: 'region',
    value: '740'
  },
  to: {
    field: 'region',
    value: 'sr'
  }
}, {
  from: {
    field: 'region',
    value: '728'
  },
  to: {
    field: 'region',
    value: 'ss'
  }
}, {
  from: {
    field: 'region',
    value: '678'
  },
  to: {
    field: 'region',
    value: 'st'
  }
}, {
  from: {
    field: 'region',
    value: '222'
  },
  to: {
    field: 'region',
    value: 'sv'
  }
}, {
  from: {
    field: 'region',
    value: '534'
  },
  to: {
    field: 'region',
    value: 'sx'
  }
}, {
  from: {
    field: 'region',
    value: '760'
  },
  to: {
    field: 'region',
    value: 'sy'
  }
}, {
  from: {
    field: 'region',
    value: '748'
  },
  to: {
    field: 'region',
    value: 'sz'
  }
}, {
  from: {
    field: 'region',
    value: '796'
  },
  to: {
    field: 'region',
    value: 'tc'
  }
}, {
  from: {
    field: 'region',
    value: '148'
  },
  to: {
    field: 'region',
    value: 'td'
  }
}, {
  from: {
    field: 'region',
    value: '260'
  },
  to: {
    field: 'region',
    value: 'tf'
  }
}, {
  from: {
    field: 'region',
    value: '768'
  },
  to: {
    field: 'region',
    value: 'tg'
  }
}, {
  from: {
    field: 'region',
    value: '764'
  },
  to: {
    field: 'region',
    value: 'th'
  }
}, {
  from: {
    field: 'region',
    value: '762'
  },
  to: {
    field: 'region',
    value: 'tj'
  }
}, {
  from: {
    field: 'region',
    value: '772'
  },
  to: {
    field: 'region',
    value: 'tk'
  }
}, {
  from: {
    field: 'region',
    value: '626'
  },
  to: {
    field: 'region',
    value: 'tl'
  }
}, {
  from: {
    field: 'region',
    value: '795'
  },
  to: {
    field: 'region',
    value: 'tm'
  }
}, {
  from: {
    field: 'region',
    value: '788'
  },
  to: {
    field: 'region',
    value: 'tn'
  }
}, {
  from: {
    field: 'region',
    value: '776'
  },
  to: {
    field: 'region',
    value: 'to'
  }
}, {
  from: {
    field: 'region',
    value: '792'
  },
  to: {
    field: 'region',
    value: 'tr'
  }
}, {
  from: {
    field: 'region',
    value: '780'
  },
  to: {
    field: 'region',
    value: 'tt'
  }
}, {
  from: {
    field: 'region',
    value: '798'
  },
  to: {
    field: 'region',
    value: 'tv'
  }
}, {
  from: {
    field: 'region',
    value: '158'
  },
  to: {
    field: 'region',
    value: 'tw'
  }
}, {
  from: {
    field: 'region',
    value: '834'
  },
  to: {
    field: 'region',
    value: 'tz'
  }
}, {
  from: {
    field: 'region',
    value: '804'
  },
  to: {
    field: 'region',
    value: 'ua'
  }
}, {
  from: {
    field: 'region',
    value: '800'
  },
  to: {
    field: 'region',
    value: 'ug'
  }
}, {
  from: {
    field: 'region',
    value: '581'
  },
  to: {
    field: 'region',
    value: 'um'
  }
}, {
  from: {
    field: 'region',
    value: '840'
  },
  to: {
    field: 'region',
    value: 'us'
  }
}, {
  from: {
    field: 'region',
    value: '858'
  },
  to: {
    field: 'region',
    value: 'uy'
  }
}, {
  from: {
    field: 'region',
    value: '860'
  },
  to: {
    field: 'region',
    value: 'uz'
  }
}, {
  from: {
    field: 'region',
    value: '336'
  },
  to: {
    field: 'region',
    value: 'va'
  }
}, {
  from: {
    field: 'region',
    value: '670'
  },
  to: {
    field: 'region',
    value: 'vc'
  }
}, {
  from: {
    field: 'region',
    value: '862'
  },
  to: {
    field: 'region',
    value: 've'
  }
}, {
  from: {
    field: 'region',
    value: '092'
  },
  to: {
    field: 'region',
    value: 'vg'
  }
}, {
  from: {
    field: 'region',
    value: '850'
  },
  to: {
    field: 'region',
    value: 'vi'
  }
}, {
  from: {
    field: 'region',
    value: '704'
  },
  to: {
    field: 'region',
    value: 'vn'
  }
}, {
  from: {
    field: 'region',
    value: '548'
  },
  to: {
    field: 'region',
    value: 'vu'
  }
}, {
  from: {
    field: 'region',
    value: '876'
  },
  to: {
    field: 'region',
    value: 'wf'
  }
}, {
  from: {
    field: 'region',
    value: '882'
  },
  to: {
    field: 'region',
    value: 'ws'
  }
}, {
  from: {
    field: 'region',
    value: '973'
  },
  to: {
    field: 'region',
    value: 'xa'
  }
}, {
  from: {
    field: 'region',
    value: '974'
  },
  to: {
    field: 'region',
    value: 'xb'
  }
}, {
  from: {
    field: 'region',
    value: '975'
  },
  to: {
    field: 'region',
    value: 'xc'
  }
}, {
  from: {
    field: 'region',
    value: '976'
  },
  to: {
    field: 'region',
    value: 'xd'
  }
}, {
  from: {
    field: 'region',
    value: '977'
  },
  to: {
    field: 'region',
    value: 'xe'
  }
}, {
  from: {
    field: 'region',
    value: '978'
  },
  to: {
    field: 'region',
    value: 'xf'
  }
}, {
  from: {
    field: 'region',
    value: '979'
  },
  to: {
    field: 'region',
    value: 'xg'
  }
}, {
  from: {
    field: 'region',
    value: '980'
  },
  to: {
    field: 'region',
    value: 'xh'
  }
}, {
  from: {
    field: 'region',
    value: '981'
  },
  to: {
    field: 'region',
    value: 'xi'
  }
}, {
  from: {
    field: 'region',
    value: '982'
  },
  to: {
    field: 'region',
    value: 'xj'
  }
}, {
  from: {
    field: 'region',
    value: '983'
  },
  to: {
    field: 'region',
    value: 'xk'
  }
}, {
  from: {
    field: 'region',
    value: '984'
  },
  to: {
    field: 'region',
    value: 'xl'
  }
}, {
  from: {
    field: 'region',
    value: '985'
  },
  to: {
    field: 'region',
    value: 'xm'
  }
}, {
  from: {
    field: 'region',
    value: '986'
  },
  to: {
    field: 'region',
    value: 'xn'
  }
}, {
  from: {
    field: 'region',
    value: '987'
  },
  to: {
    field: 'region',
    value: 'xo'
  }
}, {
  from: {
    field: 'region',
    value: '988'
  },
  to: {
    field: 'region',
    value: 'xp'
  }
}, {
  from: {
    field: 'region',
    value: '989'
  },
  to: {
    field: 'region',
    value: 'xq'
  }
}, {
  from: {
    field: 'region',
    value: '990'
  },
  to: {
    field: 'region',
    value: 'xr'
  }
}, {
  from: {
    field: 'region',
    value: '991'
  },
  to: {
    field: 'region',
    value: 'xs'
  }
}, {
  from: {
    field: 'region',
    value: '992'
  },
  to: {
    field: 'region',
    value: 'xt'
  }
}, {
  from: {
    field: 'region',
    value: '993'
  },
  to: {
    field: 'region',
    value: 'xu'
  }
}, {
  from: {
    field: 'region',
    value: '994'
  },
  to: {
    field: 'region',
    value: 'xv'
  }
}, {
  from: {
    field: 'region',
    value: '995'
  },
  to: {
    field: 'region',
    value: 'xw'
  }
}, {
  from: {
    field: 'region',
    value: '996'
  },
  to: {
    field: 'region',
    value: 'xx'
  }
}, {
  from: {
    field: 'region',
    value: '997'
  },
  to: {
    field: 'region',
    value: 'xy'
  }
}, {
  from: {
    field: 'region',
    value: '998'
  },
  to: {
    field: 'region',
    value: 'xz'
  }
}, {
  from: {
    field: 'region',
    value: '720'
  },
  to: {
    field: 'region',
    value: 'ye'
  }
}, {
  from: {
    field: 'region',
    value: '887'
  },
  to: {
    field: 'region',
    value: 'ye'
  }
}, {
  from: {
    field: 'region',
    value: '175'
  },
  to: {
    field: 'region',
    value: 'yt'
  }
}, {
  from: {
    field: 'region',
    value: '710'
  },
  to: {
    field: 'region',
    value: 'za'
  }
}, {
  from: {
    field: 'region',
    value: '894'
  },
  to: {
    field: 'region',
    value: 'zm'
  }
}, {
  from: {
    field: 'region',
    value: '716'
  },
  to: {
    field: 'region',
    value: 'zw'
  }
}, {
  from: {
    field: 'region',
    value: '999'
  },
  to: {
    field: 'region',
    value: 'zz'
  }
}, {
  from: {
    field: 'variants',
    value: 'polytoni'
  },
  to: {
    field: 'variants',
    value: 'polyton'
  }
}, {
  from: {
    field: 'variants',
    value: 'heploc'
  },
  to: {
    field: 'variants',
    value: 'alalc97'
  }
}];

/***/ }),

/***/ "./node_modules/bcp-47-normalize/lib/index.js":
/*!****************************************************!*\
  !*** ./node_modules/bcp-47-normalize/lib/index.js ***!
  \****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   bcp47Normalize: function() { return /* binding */ bcp47Normalize; }
/* harmony export */ });
/* harmony import */ var bcp_47__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! bcp-47 */ "./node_modules/bcp-47/lib/stringify.js");
/* harmony import */ var bcp_47__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bcp-47 */ "./node_modules/bcp-47/lib/parse.js");
/* harmony import */ var bcp_47_match__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! bcp-47-match */ "./node_modules/bcp-47-match/index.js");
/* harmony import */ var _matches_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./matches.js */ "./node_modules/bcp-47-normalize/lib/matches.js");
/* harmony import */ var _fields_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./fields.js */ "./node_modules/bcp-47-normalize/lib/fields.js");
/* harmony import */ var _many_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./many.js */ "./node_modules/bcp-47-normalize/lib/many.js");
/* harmony import */ var _likely_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./likely.js */ "./node_modules/bcp-47-normalize/lib/likely.js");
/**
 * @typedef {import('bcp-47').Warning} Warning
 * @typedef {import('bcp-47').Schema} Schema
 * @typedef {import('bcp-47').Extension} Extension
 *
 * @typedef Options
 *   Configuration (optional).
 * @property {boolean} [forgiving]
 *   Passed to `bcp-47` as `options.forgiving`.
 * @property {Warning} [warning]
 *   Passed to `bcp-47` as `options.warning`.
 *
 *   One additional warning is given:
 *
 *   | code | reason                                                     |
 *   | :--- | :--------------------------------------------------------- |
 *   | 7    | Deprecated region `CURRENT`, expected one of `SUGGESTIONS` |
 *
 *   This warning is only given if the region cannot be automatically fixed
 *   (when regions split into multiple regions).
 */







const own = {}.hasOwnProperty;

/**
 * @param {Schema} base
 * @param {Partial<Schema>} changes
 * @returns {Schema}
 */
function merge(base, changes) {
  if (!base.language) base.language = changes.language;
  if (!base.script) base.script = changes.script;
  if (!base.region) base.region = changes.region;
  if (changes.variants) base.variants.push(...changes.variants);
  return base;
}

/**
 * Mostly like:
 * <https://github.com/formatjs/formatjs/blob/a15e757/packages/intl-locale/index.ts#L254>
 * But doesn’t crash.
 *
 * @param {Schema} schema
 * @returns {string}
 */
function addLikelySubtags(schema) {
  const {
    language,
    script,
    region
  } = schema;
  /** @type {string|undefined} */
  let match;
  if (script && region && (match = _likely_js__WEBPACK_IMPORTED_MODULE_0__.likely[(0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)({
    language,
    script,
    region
  })])) {
    schema.script = undefined;
    schema.region = undefined;
  } else if (script && (match = _likely_js__WEBPACK_IMPORTED_MODULE_0__.likely[(0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)({
    language,
    script
  })])) {
    schema.script = undefined;
  } else if (region && (match = _likely_js__WEBPACK_IMPORTED_MODULE_0__.likely[(0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)({
    language,
    region
  })])) {
    schema.region = undefined;
  } else if (language && (match = _likely_js__WEBPACK_IMPORTED_MODULE_0__.likely[language])) {
    // Empty.
  }
  if (match) {
    schema.language = undefined;
    merge(schema, (0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(match));
  }
  return (0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)(schema);
}

/**
 * @param {Schema} schema
 */
function removeLikelySubtags(schema) {
  addLikelySubtags(schema);
  const {
    language,
    script,
    region
  } = schema;
  if (!language) return schema;
  const maxLocale = (0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)({
    language,
    script,
    region
  });
  if (maxLocale === addLikelySubtags((0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(language))) {
    schema.script = undefined;
    schema.region = undefined;
  } else if (region && maxLocale === addLikelySubtags((0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(language + '-' + region))) {
    schema.script = undefined;
  } else if (script && maxLocale === addLikelySubtags((0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(language + '-' + script))) {
    schema.region = undefined;
  }
  return schema;
}

/**
 * Normalize the given BCP 47 tag according to Unicode CLDR suggestions.
 *
 * @param {string} tag
 *   BCP 47 tag.
 * @param {Options} [options]
 *   Configuration (optional).
 * @returns {string}
 *   Normal, canonical, and pretty BCP 47 tag.
 */
function bcp47Normalize(tag, options) {
  const settings = options || {};
  // 1. normalize and lowercase the tag (`sgn-be-fr` -> `sfb`).
  const schema = (0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(String(tag || '').toLowerCase(), settings);
  const value = (0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)(schema);
  if (!value) {
    return value;
  }
  let index = -1;

  // 2. Do fancy, expensive replaces (`ha-latn-gh` -> `ha-gh`).
  while (++index < _matches_js__WEBPACK_IMPORTED_MODULE_3__.matches.length) {
    let from = _matches_js__WEBPACK_IMPORTED_MODULE_3__.matches[index].from;
    if (from.slice(0, 4) === 'und-' && schema.language) {
      from = schema.language + from.slice(3);
    }
    if ((0,bcp_47_match__WEBPACK_IMPORTED_MODULE_4__.extendedFilter)(value, from).length > 0) {
      replace(schema, from, _matches_js__WEBPACK_IMPORTED_MODULE_3__.matches[index].to);
    }
  }

  // 3. Do basic field replaces (`en-840` -> `en-us`).
  index = -1;
  while (++index < _fields_js__WEBPACK_IMPORTED_MODULE_5__.fields.length) {
    if (remove(schema, _fields_js__WEBPACK_IMPORTED_MODULE_5__.fields[index].from.field, _fields_js__WEBPACK_IMPORTED_MODULE_5__.fields[index].from.value)) {
      add(schema, _fields_js__WEBPACK_IMPORTED_MODULE_5__.fields[index].to.field, _fields_js__WEBPACK_IMPORTED_MODULE_5__.fields[index].to.value);
    }
  }

  // 4. Minimize.
  removeLikelySubtags(schema);

  // 5. Sort variants, and sort extensions on singleton.
  schema.variants.sort();
  schema.extensions.sort(compareSingleton);

  // 6. Warn if fields (currently only regions) should be updated but have
  // multiple choices.
  if (settings.warning) {
    /** @type {keyof many} */
    let key;
    for (key in _many_js__WEBPACK_IMPORTED_MODULE_6__.many) {
      if (own.call(_many_js__WEBPACK_IMPORTED_MODULE_6__.many, key)) {
        const map = _many_js__WEBPACK_IMPORTED_MODULE_6__.many[key];
        const value = schema[key];
        if (value && own.call(map, value)) {
          const replacements = map[value];
          settings.warning('Deprecated ' + key + ' `' + value + '`, expected one of `' + replacements.join('`, `') + '`', -1, 7);
        }
      }
    }
  }

  // 7. Add proper casing back.
  // Format script (ISO 15924) as titlecase (example: `Latn`):
  if (schema.script) {
    schema.script = schema.script.charAt(0).toUpperCase() + schema.script.slice(1);
  }

  // Format region (ISO 3166) as uppercase (note: this doesn’t affect numeric
  // codes, which is fine):
  if (schema.region) {
    schema.region = schema.region.toUpperCase();
  }
  return (0,bcp_47__WEBPACK_IMPORTED_MODULE_1__.stringify)(schema);
}

/**
 * @param {Schema} schema
 * @param {string} from
 * @param {string} to
 * @returns {void}
 */
function replace(schema, from, to) {
  const left = (0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(from);
  const right = (0,bcp_47__WEBPACK_IMPORTED_MODULE_2__.parse)(to);
  /** @type {Array<string>} */
  const removed = [];
  /** @type {string|null|undefined} */
  const lang = left.language;
  /** @type {keyof schema} */
  let key;

  // Remove values from `from`:
  for (key in left) {
    if (own.call(left, key)) {
      const value = left[key];
      if (value && remove(schema, key, value)) {
        removed.push(key);
      }
    }
  }

  // Add values from `to`:
  for (key in right) {
    if (own.call(right, key)) {
      const value = right[key];
      // Only add values that are defined on `to`, and that were either removed by
      // `from` or are currently empty.
      if (lang && value && (removed.includes(key) || !schema[key])) {
        add(schema, key, key === 'language' && value === 'und' ? lang : value);
      }
    }
  }
}

/**
 * @param {Schema} object
 * @param {keyof Schema} key
 * @param {string|Array<string>|Array<Extension>} value
 * @returns {boolean}
 */
function remove(object, key, value) {
  let removed = false;
  /** @type {string|Array<string>|Array<Extension>|null|undefined} */
  let result;
  if (value) {
    const current = object[key];
    result = current;
    if (Array.isArray(current)) {
      result = [];
      let index = -1;
      while (++index < current.length) {
        const item = current[index];

        // @ts-expect-error: TS can’t handle the two lists.
        if (value.includes(item)) {
          removed = true;
        } else {
          // @ts-expect-error: TS can’t handle the two lists.
          result.push(item);
        }
      }
    } else if (current === value) {
      result = null;
      removed = true;
    }

    // @ts-expect-error: Assume the value matches.
    object[key] = result;
  }
  return removed;
}

/**
 * @param {Schema} object
 * @param {keyof Schema} key
 * @param {string|Array<string>|Array<Extension>} value
 * @returns {void}
 */
function add(object, key, value) {
  /** @type {string|Array<string>|Array<Extension>|null|undefined} */
  const current = object[key];
  if (Array.isArray(current)) {
    const list = Array.isArray(value) ? value : [value];
    /** @type {number} */
    let index = -1;
    while (++index < list.length) {
      const item = list[index];

      // @ts-expect-error: TS can’t handle the two lists.
      if (!current.includes(item)) {
        // @ts-expect-error: TS can’t handle the two lists.
        current.push(item);
      }
    }
  } else {
    // @ts-expect-error: Assume the value matches.
    object[key] = value;
  }
}

/**
 * @param {Extension} left
 * @param {Extension} right
 * @returns {number}
 */
function compareSingleton(left, right) {
  if (left.singleton > right.singleton) {
    return 1;
  }
  if (left.singleton < right.singleton) {
    return -1;
  }

  // It is invalid to have more than one extension with the same singleton so
  // we should never reach this code.
  return 0;
}

/***/ }),

/***/ "./node_modules/bcp-47-normalize/lib/likely.js":
/*!*****************************************************!*\
  !*** ./node_modules/bcp-47-normalize/lib/likely.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   likely: function() { return /* binding */ likely; }
/* harmony export */ });
/**
 * @type {Record<string, string>}
 */
const likely = {
  aa: 'aa-latn-et',
  aaa: 'aaa-latn-ng',
  aab: 'aab-latn-ng',
  aac: 'aac-latn-pg',
  aad: 'aad-latn-pg',
  aae: 'aae-latn-it',
  'aae-grek': 'aae-grek-it',
  aaf: 'aaf-mlym-in',
  'aaf-arab': 'aaf-arab-in',
  aag: 'aag-latn-pg',
  aah: 'aah-latn-pg',
  aai: 'aai-latn-zz',
  aak: 'aak-latn-zz',
  aal: 'aal-latn-cm',
  aan: 'aan-latn-br',
  aao: 'aao-arab-dz',
  aap: 'aap-latn-br',
  aaq: 'aaq-latn-us',
  aas: 'aas-latn-tz',
  aat: 'aat-grek-gr',
  aau: 'aau-latn-zz',
  aaw: 'aaw-latn-pg',
  aax: 'aax-latn-id',
  aaz: 'aaz-latn-id',
  ab: 'ab-cyrl-ge',
  aba: 'aba-latn-ci',
  abb: 'abb-latn-cm',
  abc: 'abc-latn-ph',
  abd: 'abd-latn-ph',
  abe: 'abe-latn-ca',
  abf: 'abf-latn-my',
  abg: 'abg-latn-pg',
  abh: 'abh-arab-tj',
  abi: 'abi-latn-zz',
  abl: 'abl-rjng-id',
  'abl-latn': 'abl-latn-id',
  abm: 'abm-latn-ng',
  abn: 'abn-latn-ng',
  abo: 'abo-latn-ng',
  abp: 'abp-latn-ph',
  abq: 'abq-cyrl-zz',
  abr: 'abr-latn-gh',
  abs: 'abs-latn-id',
  abt: 'abt-latn-zz',
  abu: 'abu-latn-ci',
  abv: 'abv-arab-bh',
  abw: 'abw-latn-pg',
  abx: 'abx-latn-ph',
  aby: 'aby-latn-zz',
  abz: 'abz-latn-id',
  aca: 'aca-latn-co',
  acb: 'acb-latn-ng',
  acd: 'acd-latn-zz',
  ace: 'ace-latn-id',
  acf: 'acf-latn-lc',
  ach: 'ach-latn-ug',
  acm: 'acm-arab-iq',
  acn: 'acn-latn-cn',
  acp: 'acp-latn-ng',
  acq: 'acq-arab-ye',
  acr: 'acr-latn-gt',
  acs: 'acs-latn-br',
  act: 'act-latn-nl',
  acu: 'acu-latn-ec',
  acv: 'acv-latn-us',
  acw: 'acw-arab-sa',
  acx: 'acx-arab-om',
  acy: 'acy-latn-cy',
  'acy-arab': 'acy-arab-cy',
  'acy-grek': 'acy-grek-cy',
  acz: 'acz-latn-sd',
  ada: 'ada-latn-gh',
  adb: 'adb-latn-tl',
  add: 'add-latn-cm',
  ade: 'ade-latn-zz',
  adf: 'adf-arab-om',
  adg: 'adg-latn-au',
  adh: 'adh-latn-ug',
  adi: 'adi-latn-in',
  'adi-tibt': 'adi-tibt-cn',
  adj: 'adj-latn-zz',
  adl: 'adl-latn-in',
  adn: 'adn-latn-id',
  ado: 'ado-latn-pg',
  adp: 'adp-tibt-bt',
  adq: 'adq-latn-gh',
  adr: 'adr-latn-id',
  adt: 'adt-latn-au',
  adu: 'adu-latn-ng',
  adw: 'adw-latn-br',
  adx: 'adx-tibt-cn',
  ady: 'ady-cyrl-ru',
  adz: 'adz-latn-zz',
  ae: 'ae-avst-ir',
  aea: 'aea-latn-au',
  aeb: 'aeb-arab-tn',
  aec: 'aec-arab-eg',
  aee: 'aee-arab-af',
  aek: 'aek-latn-nc',
  ael: 'ael-latn-cm',
  aem: 'aem-latn-vn',
  aeq: 'aeq-arab-pk',
  aer: 'aer-latn-au',
  aeu: 'aeu-latn-cn',
  aew: 'aew-latn-pg',
  aey: 'aey-latn-zz',
  aez: 'aez-latn-pg',
  af: 'af-latn-za',
  afb: 'afb-arab-kw',
  afd: 'afd-latn-pg',
  afe: 'afe-latn-ng',
  afh: 'afh-latn-gh',
  afi: 'afi-latn-pg',
  afk: 'afk-latn-pg',
  afn: 'afn-latn-ng',
  afo: 'afo-latn-ng',
  afp: 'afp-latn-pg',
  afs: 'afs-latn-mx',
  afu: 'afu-latn-gh',
  afz: 'afz-latn-id',
  aga: 'aga-latn-pe',
  agb: 'agb-latn-ng',
  agc: 'agc-latn-zz',
  agd: 'agd-latn-zz',
  age: 'age-latn-pg',
  agf: 'agf-latn-id',
  agg: 'agg-latn-zz',
  agh: 'agh-latn-cd',
  agi: 'agi-deva-in',
  agj: 'agj-ethi-et',
  'agj-arab': 'agj-arab-et',
  agk: 'agk-latn-ph',
  agl: 'agl-latn-pg',
  agm: 'agm-latn-zz',
  agn: 'agn-latn-ph',
  ago: 'ago-latn-zz',
  agq: 'agq-latn-cm',
  agr: 'agr-latn-pe',
  ags: 'ags-latn-cm',
  agt: 'agt-latn-ph',
  agu: 'agu-latn-gt',
  agv: 'agv-latn-ph',
  agw: 'agw-latn-sb',
  agx: 'agx-cyrl-ru',
  agy: 'agy-latn-ph',
  agz: 'agz-latn-ph',
  aha: 'aha-latn-zz',
  ahb: 'ahb-latn-vu',
  ahg: 'ahg-ethi-et',
  ahh: 'ahh-latn-id',
  ahi: 'ahi-latn-ci',
  ahk: 'ahk-latn-mm',
  'ahk-mymr': 'ahk-mymr-mm',
  'ahk-th': 'ahk-latn-th',
  'ahk-thai': 'ahk-thai-th',
  ahl: 'ahl-latn-zz',
  ahm: 'ahm-latn-ci',
  ahn: 'ahn-latn-ng',
  aho: 'aho-ahom-in',
  ahp: 'ahp-latn-ci',
  ahr: 'ahr-deva-in',
  ahs: 'ahs-latn-ng',
  aht: 'aht-latn-us',
  aia: 'aia-latn-sb',
  aib: 'aib-arab-cn',
  aic: 'aic-latn-pg',
  aid: 'aid-latn-au',
  aie: 'aie-latn-pg',
  aif: 'aif-latn-pg',
  aig: 'aig-latn-ag',
  aij: 'aij-hebr-il',
  aik: 'aik-latn-ng',
  ail: 'ail-latn-pg',
  aim: 'aim-latn-in',
  ain: 'ain-kana-jp',
  'ain-latn': 'ain-latn-jp',
  aio: 'aio-mymr-in',
  aip: 'aip-latn-id',
  aiq: 'aiq-arab-af',
  air: 'air-latn-id',
  ait: 'ait-latn-br',
  aiw: 'aiw-latn-et',
  'aiw-arab': 'aiw-arab-et',
  'aiw-ethi': 'aiw-ethi-et',
  aix: 'aix-latn-pg',
  aiy: 'aiy-latn-cf',
  aja: 'aja-latn-ss',
  ajg: 'ajg-latn-zz',
  aji: 'aji-latn-nc',
  ajn: 'ajn-latn-au',
  ajp: 'ajp-arab-jo',
  ajt: 'ajt-arab-tn',
  ajw: 'ajw-latn-ng',
  ajz: 'ajz-latn-in',
  ak: 'ak-latn-gh',
  akb: 'akb-latn-id',
  'akb-batk': 'akb-batk-id',
  akc: 'akc-latn-id',
  akd: 'akd-latn-ng',
  ake: 'ake-latn-gy',
  akf: 'akf-latn-ng',
  akg: 'akg-latn-id',
  akh: 'akh-latn-pg',
  aki: 'aki-latn-pg',
  akk: 'akk-xsux-iq',
  akl: 'akl-latn-ph',
  ako: 'ako-latn-sr',
  akp: 'akp-latn-gh',
  akq: 'akq-latn-pg',
  akr: 'akr-latn-vu',
  aks: 'aks-latn-tg',
  akt: 'akt-latn-pg',
  aku: 'aku-latn-cm',
  akv: 'akv-cyrl-ru',
  akw: 'akw-latn-cg',
  akz: 'akz-latn-us',
  ala: 'ala-latn-zz',
  alc: 'alc-latn-cl',
  ald: 'ald-latn-ci',
  ale: 'ale-latn-us',
  alf: 'alf-latn-ng',
  alh: 'alh-latn-au',
  ali: 'ali-latn-zz',
  alj: 'alj-latn-ph',
  alk: 'alk-laoo-la',
  all: 'all-mlym-in',
  alm: 'alm-latn-vu',
  aln: 'aln-latn-xk',
  alo: 'alo-latn-id',
  alp: 'alp-latn-id',
  alq: 'alq-latn-ca',
  alr: 'alr-cyrl-ru',
  alt: 'alt-cyrl-ru',
  alu: 'alu-latn-sb',
  alw: 'alw-ethi-et',
  alx: 'alx-latn-pg',
  aly: 'aly-latn-au',
  alz: 'alz-latn-cd',
  am: 'am-ethi-et',
  ama: 'ama-latn-br',
  amb: 'amb-latn-ng',
  amc: 'amc-latn-pe',
  ame: 'ame-latn-pe',
  amf: 'amf-latn-et',
  'amf-ethi': 'amf-ethi-et',
  amg: 'amg-latn-au',
  ami: 'ami-latn-tw',
  amj: 'amj-latn-td',
  amk: 'amk-latn-id',
  amm: 'amm-latn-zz',
  amn: 'amn-latn-zz',
  amo: 'amo-latn-ng',
  amp: 'amp-latn-zz',
  amq: 'amq-latn-id',
  amr: 'amr-latn-pe',
  ams: 'ams-jpan-jp',
  amt: 'amt-latn-pg',
  amu: 'amu-latn-mx',
  amv: 'amv-latn-id',
  amw: 'amw-syrc-sy',
  'amw-arab': 'amw-arab-sy',
  'amw-armi': 'amw-armi-sy',
  'amw-latn': 'amw-latn-sy',
  amx: 'amx-latn-au',
  amy: 'amy-latn-au',
  amz: 'amz-latn-au',
  an: 'an-latn-es',
  ana: 'ana-latn-co',
  anb: 'anb-latn-pe',
  anc: 'anc-latn-zz',
  and: 'and-latn-id',
  ane: 'ane-latn-nc',
  anf: 'anf-latn-gh',
  ang: 'ang-latn-gb',
  anh: 'anh-latn-pg',
  ani: 'ani-cyrl-ru',
  anj: 'anj-latn-pg',
  ank: 'ank-latn-zz',
  anl: 'anl-latn-mm',
  anm: 'anm-latn-in',
  ann: 'ann-latn-ng',
  ano: 'ano-latn-co',
  anp: 'anp-deva-in',
  anr: 'anr-deva-in',
  ans: 'ans-latn-co',
  ant: 'ant-latn-au',
  anu: 'anu-ethi-et',
  'anu-arab': 'anu-arab-ss',
  'anu-latn': 'anu-latn-ss',
  anv: 'anv-latn-cm',
  anw: 'anw-latn-ng',
  anx: 'anx-latn-pg',
  any: 'any-latn-zz',
  anz: 'anz-latn-pg',
  aoa: 'aoa-latn-st',
  aob: 'aob-latn-pg',
  aoc: 'aoc-latn-ve',
  aod: 'aod-latn-pg',
  aoe: 'aoe-latn-pg',
  aof: 'aof-latn-pg',
  aog: 'aog-latn-pg',
  aoi: 'aoi-latn-au',
  aoj: 'aoj-latn-zz',
  aok: 'aok-latn-nc',
  aol: 'aol-latn-id',
  aom: 'aom-latn-zz',
  aon: 'aon-latn-pg',
  aor: 'aor-latn-vu',
  aos: 'aos-latn-id',
  aot: 'aot-beng-bd',
  'aot-latn': 'aot-latn-in',
  aox: 'aox-latn-gy',
  aoz: 'aoz-latn-id',
  apb: 'apb-latn-sb',
  apc: 'apc-arab-sy',
  apd: 'apd-arab-tg',
  ape: 'ape-latn-zz',
  apf: 'apf-latn-ph',
  apg: 'apg-latn-id',
  aph: 'aph-deva-np',
  api: 'api-latn-br',
  apj: 'apj-latn-us',
  apk: 'apk-latn-us',
  apl: 'apl-latn-us',
  apm: 'apm-latn-us',
  apn: 'apn-latn-br',
  apo: 'apo-latn-pg',
  app: 'app-latn-vu',
  apr: 'apr-latn-zz',
  aps: 'aps-latn-zz',
  apt: 'apt-latn-in',
  apu: 'apu-latn-br',
  apv: 'apv-latn-br',
  apw: 'apw-latn-us',
  apx: 'apx-latn-id',
  apy: 'apy-latn-br',
  apz: 'apz-latn-zz',
  aqc: 'aqc-cyrl-ru',
  aqd: 'aqd-latn-ml',
  aqg: 'aqg-latn-ng',
  aqk: 'aqk-latn-ng',
  aqm: 'aqm-latn-id',
  aqn: 'aqn-latn-ph',
  aqr: 'aqr-latn-nc',
  aqt: 'aqt-latn-py',
  aqz: 'aqz-latn-br',
  ar: 'ar-arab-eg',
  arc: 'arc-armi-ir',
  'arc-nbat': 'arc-nbat-jo',
  'arc-palm': 'arc-palm-sy',
  ard: 'ard-latn-au',
  are: 'are-latn-au',
  arh: 'arh-latn-zz',
  ari: 'ari-latn-us',
  arj: 'arj-latn-br',
  ark: 'ark-latn-br',
  arl: 'arl-latn-pe',
  arn: 'arn-latn-cl',
  aro: 'aro-latn-bo',
  arp: 'arp-latn-us',
  arq: 'arq-arab-dz',
  arr: 'arr-latn-br',
  ars: 'ars-arab-sa',
  aru: 'aru-latn-br',
  arw: 'arw-latn-sr',
  arx: 'arx-latn-br',
  ary: 'ary-arab-ma',
  arz: 'arz-arab-eg',
  as: 'as-beng-in',
  asa: 'asa-latn-tz',
  asb: 'asb-latn-ca',
  asc: 'asc-latn-id',
  ase: 'ase-sgnw-us',
  asg: 'asg-latn-zz',
  ash: 'ash-latn-pe',
  asi: 'asi-latn-id',
  asj: 'asj-latn-cm',
  ask: 'ask-arab-af',
  asl: 'asl-latn-id',
  asn: 'asn-latn-br',
  aso: 'aso-latn-zz',
  ass: 'ass-latn-cm',
  ast: 'ast-latn-es',
  asu: 'asu-latn-br',
  asv: 'asv-latn-cd',
  asx: 'asx-latn-pg',
  asy: 'asy-latn-id',
  asz: 'asz-latn-id',
  ata: 'ata-latn-zz',
  atb: 'atb-latn-cn',
  'atb-lisu': 'atb-lisu-cn',
  atc: 'atc-latn-pe',
  atd: 'atd-latn-ph',
  ate: 'ate-latn-pg',
  atg: 'atg-latn-zz',
  ati: 'ati-latn-ci',
  atj: 'atj-latn-ca',
  atk: 'atk-latn-ph',
  atl: 'atl-latn-ph',
  atm: 'atm-latn-ph',
  atn: 'atn-arab-ir',
  ato: 'ato-latn-cm',
  atp: 'atp-latn-ph',
  atq: 'atq-latn-id',
  atr: 'atr-latn-br',
  ats: 'ats-latn-us',
  att: 'att-latn-ph',
  atu: 'atu-latn-ss',
  atv: 'atv-cyrl-ru',
  atw: 'atw-latn-us',
  atx: 'atx-latn-br',
  aty: 'aty-latn-vu',
  atz: 'atz-latn-ph',
  aua: 'aua-latn-sb',
  auc: 'auc-latn-ec',
  aud: 'aud-latn-sb',
  aug: 'aug-latn-bj',
  auh: 'auh-latn-zm',
  aui: 'aui-latn-pg',
  auj: 'auj-arab-ly',
  'auj-latn': 'auj-latn-ly',
  'auj-tfng': 'auj-tfng-ly',
  auk: 'auk-latn-pg',
  aul: 'aul-latn-vu',
  aum: 'aum-latn-ng',
  aun: 'aun-latn-pg',
  auo: 'auo-latn-ng',
  aup: 'aup-latn-pg',
  auq: 'auq-latn-id',
  aur: 'aur-latn-pg',
  aut: 'aut-latn-pf',
  auu: 'auu-latn-id',
  auw: 'auw-latn-id',
  auy: 'auy-latn-zz',
  auz: 'auz-arab-uz',
  av: 'av-cyrl-ru',
  avb: 'avb-latn-pg',
  avd: 'avd-arab-ir',
  avi: 'avi-latn-ci',
  avk: 'avk-latn-001',
  avl: 'avl-arab-zz',
  avm: 'avm-latn-au',
  avn: 'avn-latn-zz',
  avo: 'avo-latn-br',
  avs: 'avs-latn-pe',
  avt: 'avt-latn-zz',
  avu: 'avu-latn-zz',
  avv: 'avv-latn-br',
  awa: 'awa-deva-in',
  awb: 'awb-latn-zz',
  awc: 'awc-latn-ng',
  awe: 'awe-latn-br',
  awg: 'awg-latn-au',
  awh: 'awh-latn-id',
  awi: 'awi-latn-pg',
  awk: 'awk-latn-au',
  awm: 'awm-latn-pg',
  awn: 'awn-ethi-et',
  awo: 'awo-latn-zz',
  awr: 'awr-latn-id',
  aws: 'aws-latn-id',
  awt: 'awt-latn-br',
  awu: 'awu-latn-id',
  awv: 'awv-latn-id',
  aww: 'aww-latn-pg',
  awx: 'awx-latn-zz',
  awy: 'awy-latn-id',
  axb: 'axb-latn-ar',
  axe: 'axe-latn-au',
  axg: 'axg-latn-br',
  axk: 'axk-latn-cf',
  axl: 'axl-latn-au',
  axm: 'axm-armn-am',
  axx: 'axx-latn-nc',
  ay: 'ay-latn-bo',
  aya: 'aya-latn-pg',
  ayb: 'ayb-latn-zz',
  ayc: 'ayc-latn-pe',
  ayd: 'ayd-latn-au',
  aye: 'aye-latn-ng',
  ayg: 'ayg-latn-tg',
  ayh: 'ayh-arab-ye',
  ayi: 'ayi-latn-ng',
  ayk: 'ayk-latn-ng',
  ayl: 'ayl-arab-ly',
  ayn: 'ayn-arab-ye',
  ayo: 'ayo-latn-py',
  ayp: 'ayp-arab-iq',
  ayq: 'ayq-latn-pg',
  ays: 'ays-latn-ph',
  ayt: 'ayt-latn-ph',
  ayu: 'ayu-latn-ng',
  ayz: 'ayz-latn-id',
  az: 'az-latn-az',
  'az-arab': 'az-arab-ir',
  'az-iq': 'az-arab-iq',
  'az-ir': 'az-arab-ir',
  'az-ru': 'az-cyrl-ru',
  azb: 'azb-arab-ir',
  'azb-cyrl': 'azb-cyrl-az',
  'azb-latn': 'azb-latn-az',
  azd: 'azd-latn-mx',
  azg: 'azg-latn-mx',
  azm: 'azm-latn-mx',
  azn: 'azn-latn-mx',
  azo: 'azo-latn-cm',
  azt: 'azt-latn-ph',
  azz: 'azz-latn-mx',
  ba: 'ba-cyrl-ru',
  baa: 'baa-latn-sb',
  bab: 'bab-latn-gw',
  bac: 'bac-latn-id',
  bae: 'bae-latn-ve',
  baf: 'baf-latn-cm',
  bag: 'bag-latn-cm',
  bah: 'bah-latn-bs',
  baj: 'baj-latn-id',
  bal: 'bal-arab-pk',
  ban: 'ban-latn-id',
  bao: 'bao-latn-co',
  bap: 'bap-deva-np',
  bar: 'bar-latn-at',
  bas: 'bas-latn-cm',
  bau: 'bau-latn-ng',
  bav: 'bav-latn-zz',
  baw: 'baw-latn-cm',
  bax: 'bax-bamu-cm',
  bay: 'bay-latn-id',
  bba: 'bba-latn-zz',
  bbb: 'bbb-latn-zz',
  bbc: 'bbc-latn-id',
  bbd: 'bbd-latn-zz',
  bbe: 'bbe-latn-cd',
  bbf: 'bbf-latn-pg',
  bbg: 'bbg-latn-ga',
  bbi: 'bbi-latn-cm',
  bbj: 'bbj-latn-cm',
  bbk: 'bbk-latn-cm',
  bbl: 'bbl-geor-ge',
  bbm: 'bbm-latn-cd',
  bbn: 'bbn-latn-pg',
  bbo: 'bbo-latn-bf',
  bbp: 'bbp-latn-zz',
  bbq: 'bbq-latn-cm',
  bbr: 'bbr-latn-zz',
  bbs: 'bbs-latn-ng',
  bbt: 'bbt-latn-ng',
  bbu: 'bbu-latn-ng',
  bbv: 'bbv-latn-pg',
  bbw: 'bbw-latn-cm',
  bbx: 'bbx-latn-cm',
  bby: 'bby-latn-cm',
  bca: 'bca-latn-cn',
  'bca-hani': 'bca-hani-cn',
  bcb: 'bcb-latn-sn',
  bcd: 'bcd-latn-id',
  bce: 'bce-latn-cm',
  bcf: 'bcf-latn-zz',
  bcg: 'bcg-latn-gn',
  bch: 'bch-latn-zz',
  bci: 'bci-latn-ci',
  bcj: 'bcj-latn-au',
  bck: 'bck-latn-au',
  bcm: 'bcm-latn-zz',
  bcn: 'bcn-latn-zz',
  bco: 'bco-latn-zz',
  bcp: 'bcp-latn-cd',
  bcq: 'bcq-ethi-zz',
  bcr: 'bcr-latn-ca',
  bcs: 'bcs-latn-ng',
  bct: 'bct-latn-cd',
  bcu: 'bcu-latn-zz',
  bcv: 'bcv-latn-ng',
  bcw: 'bcw-latn-cm',
  bcy: 'bcy-latn-ng',
  bcz: 'bcz-latn-sn',
  bda: 'bda-latn-sn',
  bdb: 'bdb-latn-id',
  bdc: 'bdc-latn-co',
  bdd: 'bdd-latn-zz',
  bde: 'bde-latn-ng',
  bdf: 'bdf-latn-pg',
  bdg: 'bdg-latn-my',
  bdh: 'bdh-latn-ss',
  bdi: 'bdi-latn-sd',
  bdj: 'bdj-latn-ss',
  bdk: 'bdk-latn-az',
  bdl: 'bdl-latn-id',
  bdm: 'bdm-latn-td',
  bdn: 'bdn-latn-cm',
  bdo: 'bdo-latn-td',
  bdp: 'bdp-latn-tz',
  bdq: 'bdq-latn-vn',
  bdr: 'bdr-latn-my',
  bds: 'bds-latn-tz',
  bdt: 'bdt-latn-cf',
  bdu: 'bdu-latn-cm',
  bdv: 'bdv-orya-in',
  bdw: 'bdw-latn-id',
  bdx: 'bdx-latn-id',
  bdy: 'bdy-latn-au',
  bdz: 'bdz-arab-pk',
  be: 'be-cyrl-by',
  bea: 'bea-latn-ca',
  'bea-cans': 'bea-cans-ca',
  beb: 'beb-latn-cm',
  bec: 'bec-latn-cm',
  bed: 'bed-latn-id',
  bee: 'bee-deva-in',
  bef: 'bef-latn-zz',
  beh: 'beh-latn-zz',
  bei: 'bei-latn-id',
  bej: 'bej-arab-sd',
  bek: 'bek-latn-pg',
  bem: 'bem-latn-zm',
  beo: 'beo-latn-pg',
  bep: 'bep-latn-id',
  beq: 'beq-latn-cg',
  bes: 'bes-latn-td',
  bet: 'bet-latn-zz',
  beu: 'beu-latn-id',
  bev: 'bev-latn-ci',
  bew: 'bew-latn-id',
  bex: 'bex-latn-zz',
  bey: 'bey-latn-pg',
  bez: 'bez-latn-tz',
  bfa: 'bfa-latn-ss',
  'bfa-arab': 'bfa-arab-ss',
  bfb: 'bfb-deva-in',
  bfc: 'bfc-latn-cn',
  bfd: 'bfd-latn-cm',
  bfe: 'bfe-latn-id',
  bff: 'bff-latn-cf',
  bfg: 'bfg-latn-id',
  bfh: 'bfh-latn-pg',
  bfj: 'bfj-latn-cm',
  bfl: 'bfl-latn-cf',
  bfm: 'bfm-latn-cm',
  bfn: 'bfn-latn-tl',
  bfo: 'bfo-latn-bf',
  bfp: 'bfp-latn-cm',
  bfq: 'bfq-taml-in',
  bfs: 'bfs-latn-cn',
  'bfs-hani': 'bfs-hani-cn',
  bft: 'bft-arab-pk',
  bfu: 'bfu-tibt-in',
  'bfu-takr': 'bfu-takr-in',
  bfw: 'bfw-orya-in',
  bfx: 'bfx-latn-ph',
  bfy: 'bfy-deva-in',
  bfz: 'bfz-deva-in',
  bg: 'bg-cyrl-bg',
  bga: 'bga-latn-ng',
  bgb: 'bgb-latn-id',
  bgc: 'bgc-deva-in',
  bgd: 'bgd-deva-in',
  bgf: 'bgf-latn-cm',
  bgg: 'bgg-latn-in',
  bgi: 'bgi-latn-ph',
  bgj: 'bgj-latn-cm',
  bgn: 'bgn-arab-pk',
  bgo: 'bgo-latn-gn',
  bgp: 'bgp-arab-pk',
  bgq: 'bgq-deva-in',
  bgr: 'bgr-latn-in',
  bgs: 'bgs-latn-ph',
  bgt: 'bgt-latn-sb',
  bgu: 'bgu-latn-ng',
  bgv: 'bgv-latn-id',
  bgw: 'bgw-deva-in',
  bgx: 'bgx-grek-tr',
  bgy: 'bgy-latn-id',
  bgz: 'bgz-latn-id',
  bha: 'bha-deva-in',
  bhb: 'bhb-deva-in',
  bhc: 'bhc-latn-id',
  bhd: 'bhd-deva-in',
  'bhd-arab': 'bhd-arab-in',
  'bhd-takr': 'bhd-takr-in',
  bhe: 'bhe-arab-pk',
  bhf: 'bhf-latn-pg',
  bhg: 'bhg-latn-zz',
  bhh: 'bhh-cyrl-il',
  'bhh-hebr': 'bhh-hebr-il',
  'bhh-latn': 'bhh-latn-il',
  bhi: 'bhi-deva-in',
  bhj: 'bhj-deva-np',
  bhl: 'bhl-latn-zz',
  bhm: 'bhm-arab-om',
  bhn: 'bhn-syrc-ge',
  bho: 'bho-deva-in',
  bhp: 'bhp-latn-id',
  bhq: 'bhq-latn-id',
  bhr: 'bhr-latn-mg',
  bhs: 'bhs-latn-cm',
  bht: 'bht-takr-in',
  'bht-deva': 'bht-deva-in',
  'bht-latn': 'bht-latn-in',
  bhu: 'bhu-deva-in',
  bhv: 'bhv-latn-id',
  bhw: 'bhw-latn-id',
  bhy: 'bhy-latn-zz',
  bhz: 'bhz-latn-id',
  bi: 'bi-latn-vu',
  bia: 'bia-latn-au',
  bib: 'bib-latn-zz',
  bid: 'bid-latn-td',
  bie: 'bie-latn-pg',
  bif: 'bif-latn-gw',
  big: 'big-latn-zz',
  bik: 'bik-latn-ph',
  bil: 'bil-latn-ng',
  bim: 'bim-latn-zz',
  bin: 'bin-latn-ng',
  bio: 'bio-latn-zz',
  bip: 'bip-latn-cd',
  biq: 'biq-latn-zz',
  bir: 'bir-latn-pg',
  bit: 'bit-latn-pg',
  biu: 'biu-latn-in',
  biv: 'biv-latn-gh',
  biw: 'biw-latn-cm',
  biy: 'biy-deva-in',
  biz: 'biz-latn-cd',
  bja: 'bja-latn-cd',
  bjb: 'bjb-latn-au',
  bjc: 'bjc-latn-pg',
  bjf: 'bjf-syrc-il',
  bjg: 'bjg-latn-gw',
  bjh: 'bjh-latn-zz',
  bji: 'bji-ethi-zz',
  bjj: 'bjj-deva-in',
  bjk: 'bjk-latn-pg',
  bjl: 'bjl-latn-pg',
  bjm: 'bjm-arab-iq',
  bjn: 'bjn-latn-id',
  bjo: 'bjo-latn-zz',
  bjp: 'bjp-latn-pg',
  bjr: 'bjr-latn-zz',
  bjs: 'bjs-latn-bb',
  bjt: 'bjt-latn-sn',
  bju: 'bju-latn-cm',
  bjv: 'bjv-latn-td',
  bjw: 'bjw-latn-ci',
  bjx: 'bjx-latn-ph',
  bjy: 'bjy-latn-au',
  bjz: 'bjz-latn-zz',
  bka: 'bka-latn-ng',
  bkc: 'bkc-latn-zz',
  bkd: 'bkd-latn-ph',
  bkf: 'bkf-latn-cd',
  bkg: 'bkg-latn-cf',
  bkh: 'bkh-latn-cm',
  bki: 'bki-latn-vu',
  bkj: 'bkj-latn-cf',
  bkl: 'bkl-latn-id',
  bkm: 'bkm-latn-cm',
  bkn: 'bkn-latn-id',
  bko: 'bko-latn-cm',
  bkp: 'bkp-latn-cd',
  bkq: 'bkq-latn-zz',
  bkr: 'bkr-latn-id',
  bks: 'bks-latn-ph',
  bkt: 'bkt-latn-cd',
  bku: 'bku-latn-ph',
  bkv: 'bkv-latn-zz',
  bkw: 'bkw-latn-cg',
  bkx: 'bkx-latn-tl',
  bky: 'bky-latn-ng',
  bkz: 'bkz-latn-id',
  bla: 'bla-latn-ca',
  blb: 'blb-latn-sb',
  blc: 'blc-latn-ca',
  bld: 'bld-latn-id',
  ble: 'ble-latn-gw',
  blf: 'blf-latn-id',
  blg: 'blg-latn-my',
  blh: 'blh-latn-lr',
  bli: 'bli-latn-cd',
  blj: 'blj-latn-id',
  blk: 'blk-mymr-mm',
  blm: 'blm-latn-ss',
  bln: 'bln-latn-ph',
  blo: 'blo-latn-bj',
  blp: 'blp-latn-sb',
  blq: 'blq-latn-pg',
  blr: 'blr-latn-cn',
  'blr-tale': 'blr-tale-cn',
  'blr-thai': 'blr-thai-th',
  bls: 'bls-latn-id',
  blt: 'blt-tavt-vn',
  blv: 'blv-latn-ao',
  blw: 'blw-latn-ph',
  blx: 'blx-latn-ph',
  bly: 'bly-latn-bj',
  blz: 'blz-latn-id',
  bm: 'bm-latn-ml',
  bma: 'bma-latn-ng',
  bmb: 'bmb-latn-cd',
  bmc: 'bmc-latn-pg',
  bmd: 'bmd-latn-gn',
  bme: 'bme-latn-cf',
  bmf: 'bmf-latn-sl',
  bmg: 'bmg-latn-cd',
  bmh: 'bmh-latn-zz',
  bmi: 'bmi-latn-td',
  bmj: 'bmj-deva-np',
  bmk: 'bmk-latn-zz',
  bml: 'bml-latn-cd',
  bmm: 'bmm-latn-mg',
  bmn: 'bmn-latn-pg',
  bmo: 'bmo-latn-cm',
  bmp: 'bmp-latn-pg',
  bmq: 'bmq-latn-ml',
  bmr: 'bmr-latn-co',
  bms: 'bms-latn-ne',
  bmu: 'bmu-latn-zz',
  bmv: 'bmv-latn-cm',
  bmw: 'bmw-latn-cg',
  bmx: 'bmx-latn-pg',
  bmz: 'bmz-latn-pg',
  bn: 'bn-beng-bd',
  bna: 'bna-latn-id',
  bnb: 'bnb-latn-my',
  bnc: 'bnc-latn-ph',
  bnd: 'bnd-latn-id',
  bne: 'bne-latn-id',
  bnf: 'bnf-latn-id',
  bng: 'bng-latn-zz',
  bni: 'bni-latn-cd',
  bnj: 'bnj-latn-ph',
  bnk: 'bnk-latn-vu',
  bnm: 'bnm-latn-zz',
  bnn: 'bnn-latn-tw',
  bno: 'bno-latn-ph',
  bnp: 'bnp-latn-zz',
  bnq: 'bnq-latn-id',
  bnr: 'bnr-latn-vu',
  bns: 'bns-deva-in',
  bnu: 'bnu-latn-id',
  bnv: 'bnv-latn-id',
  bnw: 'bnw-latn-pg',
  bnx: 'bnx-latn-cd',
  bny: 'bny-latn-my',
  bnz: 'bnz-latn-cm',
  bo: 'bo-tibt-cn',
  boa: 'boa-latn-pe',
  bob: 'bob-latn-ke',
  boe: 'boe-latn-cm',
  bof: 'bof-latn-bf',
  boh: 'boh-latn-cd',
  boj: 'boj-latn-zz',
  bok: 'bok-latn-cg',
  bol: 'bol-latn-ng',
  bom: 'bom-latn-zz',
  bon: 'bon-latn-zz',
  boo: 'boo-latn-ml',
  bop: 'bop-latn-pg',
  boq: 'boq-latn-pg',
  bor: 'bor-latn-br',
  bot: 'bot-latn-ss',
  bou: 'bou-latn-tz',
  bov: 'bov-latn-gh',
  bow: 'bow-latn-pg',
  box: 'box-latn-bf',
  boy: 'boy-latn-cf',
  boz: 'boz-latn-ml',
  'boz-arab': 'boz-arab-ml',
  bpa: 'bpa-latn-vu',
  bpc: 'bpc-latn-cm',
  bpd: 'bpd-latn-cf',
  bpe: 'bpe-latn-pg',
  bpg: 'bpg-latn-id',
  bph: 'bph-cyrl-ru',
  bpi: 'bpi-latn-pg',
  bpj: 'bpj-latn-cd',
  bpk: 'bpk-latn-nc',
  bpl: 'bpl-latn-au',
  bpm: 'bpm-latn-pg',
  bpo: 'bpo-latn-id',
  bpp: 'bpp-latn-id',
  bpq: 'bpq-latn-id',
  bpr: 'bpr-latn-ph',
  bps: 'bps-latn-ph',
  bpt: 'bpt-latn-au',
  bpu: 'bpu-latn-pg',
  bpv: 'bpv-latn-id',
  bpw: 'bpw-latn-pg',
  bpx: 'bpx-deva-in',
  bpy: 'bpy-beng-in',
  bpz: 'bpz-latn-id',
  bqa: 'bqa-latn-bj',
  bqb: 'bqb-latn-id',
  bqc: 'bqc-latn-zz',
  bqd: 'bqd-latn-cm',
  bqf: 'bqf-latn-gn',
  'bqf-arab': 'bqf-arab-gn',
  bqg: 'bqg-latn-tg',
  bqi: 'bqi-arab-ir',
  bqj: 'bqj-latn-sn',
  bqk: 'bqk-latn-cf',
  bql: 'bql-latn-pg',
  bqm: 'bqm-latn-cm',
  bqo: 'bqo-latn-cm',
  bqp: 'bqp-latn-zz',
  bqq: 'bqq-latn-id',
  bqr: 'bqr-latn-id',
  bqs: 'bqs-latn-pg',
  bqt: 'bqt-latn-cm',
  bqu: 'bqu-latn-cd',
  bqv: 'bqv-latn-ci',
  bqw: 'bqw-latn-ng',
  bqx: 'bqx-latn-ng',
  bqz: 'bqz-latn-cm',
  br: 'br-latn-fr',
  bra: 'bra-deva-in',
  brb: 'brb-khmr-kh',
  'brb-laoo': 'brb-laoo-la',
  'brb-latn': 'brb-latn-vn',
  brc: 'brc-latn-gy',
  brd: 'brd-deva-np',
  brf: 'brf-latn-cd',
  brg: 'brg-latn-bo',
  brh: 'brh-arab-pk',
  bri: 'bri-latn-cm',
  brj: 'brj-latn-vu',
  brk: 'brk-arab-sd',
  brl: 'brl-latn-bw',
  brm: 'brm-latn-cd',
  brn: 'brn-latn-cr',
  brp: 'brp-latn-id',
  brq: 'brq-latn-pg',
  brr: 'brr-latn-sb',
  brs: 'brs-latn-id',
  brt: 'brt-latn-ng',
  bru: 'bru-latn-vn',
  'bru-laoo': 'bru-laoo-la',
  'bru-thai': 'bru-thai-la',
  brv: 'brv-laoo-la',
  brx: 'brx-deva-in',
  bry: 'bry-latn-pg',
  brz: 'brz-latn-zz',
  bs: 'bs-latn-ba',
  bsa: 'bsa-latn-id',
  bsb: 'bsb-latn-bn',
  bsc: 'bsc-latn-sn',
  bse: 'bse-latn-cm',
  bsf: 'bsf-latn-ng',
  bsh: 'bsh-arab-af',
  bsi: 'bsi-latn-cm',
  bsj: 'bsj-latn-zz',
  bsk: 'bsk-arab-pk',
  'bsk-latn': 'bsk-latn-pk',
  bsl: 'bsl-latn-ng',
  bsm: 'bsm-latn-id',
  bsn: 'bsn-latn-co',
  bso: 'bso-latn-td',
  bsp: 'bsp-latn-gn',
  bsq: 'bsq-bass-lr',
  bsr: 'bsr-latn-ng',
  bss: 'bss-latn-cm',
  bst: 'bst-ethi-zz',
  bsu: 'bsu-latn-id',
  bsv: 'bsv-latn-gn',
  'bsv-arab': 'bsv-arab-gn',
  bsw: 'bsw-latn-et',
  'bsw-ethi': 'bsw-ethi-et',
  bsx: 'bsx-latn-ng',
  bsy: 'bsy-latn-my',
  bta: 'bta-latn-ng',
  btc: 'btc-latn-cm',
  btd: 'btd-batk-id',
  bte: 'bte-latn-ng',
  btf: 'btf-latn-td',
  btg: 'btg-latn-ci',
  bth: 'bth-latn-my',
  bti: 'bti-latn-id',
  btj: 'btj-latn-id',
  btm: 'btm-batk-id',
  btn: 'btn-latn-ph',
  bto: 'bto-latn-ph',
  btp: 'btp-latn-pg',
  btq: 'btq-latn-my',
  btr: 'btr-latn-vu',
  bts: 'bts-latn-id',
  'bts-batk': 'bts-batk-id',
  btt: 'btt-latn-zz',
  btu: 'btu-latn-ng',
  btv: 'btv-deva-pk',
  btw: 'btw-latn-ph',
  btx: 'btx-latn-id',
  'btx-batk': 'btx-batk-id',
  bty: 'bty-latn-id',
  btz: 'btz-latn-id',
  bua: 'bua-cyrl-ru',
  bub: 'bub-latn-td',
  buc: 'buc-latn-yt',
  bud: 'bud-latn-zz',
  bue: 'bue-latn-ca',
  buf: 'buf-latn-cd',
  bug: 'bug-latn-id',
  buh: 'buh-latn-cn',
  bui: 'bui-latn-cg',
  buj: 'buj-latn-ng',
  buk: 'buk-latn-zz',
  bum: 'bum-latn-cm',
  bun: 'bun-latn-sl',
  buo: 'buo-latn-zz',
  bup: 'bup-latn-id',
  buq: 'buq-latn-pg',
  bus: 'bus-latn-zz',
  but: 'but-latn-pg',
  buu: 'buu-latn-zz',
  buv: 'buv-latn-pg',
  buw: 'buw-latn-ga',
  bux: 'bux-latn-ng',
  buy: 'buy-latn-sl',
  buz: 'buz-latn-ng',
  bva: 'bva-latn-td',
  bvb: 'bvb-latn-gq',
  bvc: 'bvc-latn-sb',
  bvd: 'bvd-latn-sb',
  bve: 'bve-latn-id',
  bvf: 'bvf-latn-td',
  bvg: 'bvg-latn-cm',
  bvh: 'bvh-latn-ng',
  bvi: 'bvi-latn-ss',
  bvj: 'bvj-latn-ng',
  bvk: 'bvk-latn-id',
  bvm: 'bvm-latn-cm',
  bvn: 'bvn-latn-pg',
  bvo: 'bvo-latn-td',
  bvq: 'bvq-latn-cf',
  bvr: 'bvr-latn-au',
  bvt: 'bvt-latn-id',
  bvu: 'bvu-latn-id',
  bvv: 'bvv-latn-ve',
  bvw: 'bvw-latn-ng',
  bvx: 'bvx-latn-cg',
  bvy: 'bvy-latn-ph',
  bvz: 'bvz-latn-id',
  bwa: 'bwa-latn-nc',
  bwb: 'bwb-latn-fj',
  bwc: 'bwc-latn-zm',
  bwd: 'bwd-latn-zz',
  bwe: 'bwe-mymr-mm',
  'bwe-latn': 'bwe-latn-mm',
  bwf: 'bwf-latn-pg',
  bwg: 'bwg-latn-mz',
  bwh: 'bwh-latn-cm',
  bwi: 'bwi-latn-ve',
  bwj: 'bwj-latn-bf',
  bwk: 'bwk-latn-pg',
  bwl: 'bwl-latn-cd',
  bwm: 'bwm-latn-pg',
  bwo: 'bwo-latn-et',
  'bwo-ethi': 'bwo-ethi-et',
  bwp: 'bwp-latn-id',
  bwq: 'bwq-latn-bf',
  bwr: 'bwr-latn-zz',
  bws: 'bws-latn-cd',
  bwt: 'bwt-latn-cm',
  bwu: 'bwu-latn-gh',
  bww: 'bww-latn-cd',
  bwx: 'bwx-latn-cn',
  bwy: 'bwy-latn-bf',
  bwz: 'bwz-latn-cg',
  bxa: 'bxa-latn-sb',
  bxb: 'bxb-latn-ss',
  bxc: 'bxc-latn-gq',
  bxf: 'bxf-latn-pg',
  bxg: 'bxg-latn-cd',
  bxh: 'bxh-latn-zz',
  bxi: 'bxi-latn-au',
  bxj: 'bxj-latn-au',
  bxl: 'bxl-latn-bf',
  bxm: 'bxm-cyrl-mn',
  'bxm-latn': 'bxm-latn-mn',
  'bxm-mong': 'bxm-mong-mn',
  bxn: 'bxn-latn-au',
  bxo: 'bxo-latn-ng',
  bxp: 'bxp-latn-cm',
  bxq: 'bxq-latn-ng',
  bxs: 'bxs-latn-cm',
  bxu: 'bxu-mong-cn',
  'bxu-cyrl': 'bxu-cyrl-cn',
  'bxu-latn': 'bxu-latn-cn',
  bxv: 'bxv-latn-td',
  bxw: 'bxw-latn-ml',
  bxz: 'bxz-latn-pg',
  bya: 'bya-latn-ph',
  byb: 'byb-latn-cm',
  byc: 'byc-latn-ng',
  byd: 'byd-latn-id',
  bye: 'bye-latn-zz',
  byf: 'byf-latn-ng',
  byh: 'byh-deva-np',
  byi: 'byi-latn-cd',
  byj: 'byj-latn-ng',
  byk: 'byk-latn-cn',
  byl: 'byl-latn-id',
  bym: 'bym-latn-au',
  byn: 'byn-ethi-er',
  byp: 'byp-latn-ng',
  byr: 'byr-latn-zz',
  bys: 'bys-latn-zz',
  byv: 'byv-latn-cm',
  byw: 'byw-deva-np',
  byx: 'byx-latn-zz',
  byz: 'byz-latn-pg',
  bza: 'bza-latn-zz',
  bzb: 'bzb-latn-id',
  bzc: 'bzc-latn-mg',
  bzd: 'bzd-latn-cr',
  bze: 'bze-latn-ml',
  bzf: 'bzf-latn-zz',
  bzh: 'bzh-latn-zz',
  bzi: 'bzi-thai-th',
  bzj: 'bzj-latn-bz',
  bzk: 'bzk-latn-ni',
  bzl: 'bzl-latn-id',
  bzm: 'bzm-latn-cd',
  bzn: 'bzn-latn-id',
  bzo: 'bzo-latn-cd',
  bzp: 'bzp-latn-id',
  bzq: 'bzq-latn-id',
  bzr: 'bzr-latn-au',
  bzt: 'bzt-latn-001',
  bzu: 'bzu-latn-id',
  bzv: 'bzv-latn-cm',
  bzw: 'bzw-latn-zz',
  bzx: 'bzx-latn-ml',
  bzy: 'bzy-latn-ng',
  bzz: 'bzz-latn-ng',
  ca: 'ca-latn-es',
  caa: 'caa-latn-gt',
  cab: 'cab-latn-hn',
  cac: 'cac-latn-gt',
  cad: 'cad-latn-us',
  cae: 'cae-latn-sn',
  caf: 'caf-latn-ca',
  'caf-cans': 'caf-cans-ca',
  cag: 'cag-latn-py',
  cah: 'cah-latn-pe',
  caj: 'caj-latn-ar',
  cak: 'cak-latn-gt',
  cal: 'cal-latn-mp',
  cam: 'cam-latn-nc',
  can: 'can-latn-zz',
  cao: 'cao-latn-bo',
  cap: 'cap-latn-bo',
  caq: 'caq-latn-in',
  car: 'car-latn-ve',
  cas: 'cas-latn-bo',
  cav: 'cav-latn-bo',
  caw: 'caw-latn-bo',
  cax: 'cax-latn-bo',
  cay: 'cay-latn-ca',
  caz: 'caz-latn-bo',
  cbb: 'cbb-latn-co',
  cbc: 'cbc-latn-co',
  cbd: 'cbd-latn-co',
  cbg: 'cbg-latn-co',
  cbi: 'cbi-latn-ec',
  cbj: 'cbj-latn-zz',
  cbk: 'cbk-latn-ph',
  'cbk-brai': 'cbk-brai-ph',
  cbl: 'cbl-latn-mm',
  cbn: 'cbn-thai-th',
  cbo: 'cbo-latn-ng',
  cbq: 'cbq-latn-ng',
  cbr: 'cbr-latn-pe',
  cbs: 'cbs-latn-pe',
  cbt: 'cbt-latn-pe',
  cbu: 'cbu-latn-pe',
  cbv: 'cbv-latn-co',
  cbw: 'cbw-latn-ph',
  cby: 'cby-latn-co',
  ccc: 'ccc-latn-pe',
  ccd: 'ccd-latn-br',
  cce: 'cce-latn-mz',
  ccg: 'ccg-latn-ng',
  cch: 'cch-latn-ng',
  ccj: 'ccj-latn-gw',
  ccl: 'ccl-latn-tz',
  ccm: 'ccm-latn-my',
  cco: 'cco-latn-mx',
  ccp: 'ccp-cakm-bd',
  ccr: 'ccr-latn-sv',
  cde: 'cde-telu-in',
  cdf: 'cdf-latn-in',
  'cdf-beng': 'cdf-beng-in',
  cdh: 'cdh-deva-in',
  'cdh-takr': 'cdh-takr-in',
  cdi: 'cdi-gujr-in',
  cdj: 'cdj-deva-in',
  cdm: 'cdm-deva-np',
  'cdm-latn': 'cdm-latn-np',
  cdo: 'cdo-hans-cn',
  'cdo-hant': 'cdo-hant-cn',
  'cdo-latn': 'cdo-latn-cn',
  cdr: 'cdr-latn-ng',
  cdz: 'cdz-beng-in',
  ce: 'ce-cyrl-ru',
  cea: 'cea-latn-us',
  ceb: 'ceb-latn-ph',
  ceg: 'ceg-latn-py',
  cek: 'cek-latn-mm',
  cen: 'cen-latn-ng',
  cet: 'cet-latn-ng',
  cey: 'cey-latn-mm',
  cfa: 'cfa-latn-zz',
  cfd: 'cfd-latn-ng',
  cfg: 'cfg-latn-ng',
  cfm: 'cfm-latn-mm',
  'cfm-beng': 'cfm-beng-in',
  cga: 'cga-latn-pg',
  cgc: 'cgc-latn-ph',
  cgg: 'cgg-latn-ug',
  cgk: 'cgk-tibt-bt',
  ch: 'ch-latn-gu',
  chb: 'chb-latn-co',
  chd: 'chd-latn-mx',
  chf: 'chf-latn-mx',
  chg: 'chg-arab-tm',
  chh: 'chh-latn-us',
  chj: 'chj-latn-mx',
  chk: 'chk-latn-fm',
  chl: 'chl-latn-us',
  chm: 'chm-cyrl-ru',
  chn: 'chn-latn-us',
  'chn-dupl': 'chn-dupl-us',
  cho: 'cho-latn-us',
  chp: 'chp-latn-ca',
  chq: 'chq-latn-mx',
  chr: 'chr-cher-us',
  cht: 'cht-latn-pe',
  chw: 'chw-latn-mz',
  chx: 'chx-deva-np',
  chy: 'chy-latn-us',
  chz: 'chz-latn-mx',
  cia: 'cia-latn-id',
  'cia-arab': 'cia-arab-id',
  'cia-hang': 'cia-hang-id',
  cib: 'cib-latn-bj',
  cic: 'cic-latn-us',
  cie: 'cie-latn-ng',
  cih: 'cih-deva-in',
  cim: 'cim-latn-it',
  cin: 'cin-latn-br',
  cip: 'cip-latn-mx',
  cir: 'cir-latn-nc',
  ciw: 'ciw-latn-us',
  'ciw-cans': 'ciw-cans-us',
  ciy: 'ciy-latn-ve',
  cja: 'cja-arab-kh',
  cje: 'cje-latn-vn',
  cjh: 'cjh-latn-us',
  cji: 'cji-cyrl-ru',
  cjk: 'cjk-latn-ao',
  cjm: 'cjm-cham-vn',
  cjn: 'cjn-latn-pg',
  cjo: 'cjo-latn-pe',
  cjp: 'cjp-latn-cr',
  cjs: 'cjs-latn-ru',
  'cjs-cyrl': 'cjs-cyrl-ru',
  cjv: 'cjv-latn-zz',
  cjy: 'cjy-hans-cn',
  'cjy-hant': 'cjy-hant-cn',
  ckb: 'ckb-arab-iq',
  ckl: 'ckl-latn-zz',
  ckm: 'ckm-latn-hr',
  'ckm-glag': 'ckm-glag-hr',
  ckn: 'ckn-latn-mm',
  cko: 'cko-latn-zz',
  ckq: 'ckq-latn-td',
  ckr: 'ckr-latn-pg',
  cks: 'cks-latn-nc',
  ckt: 'ckt-cyrl-ru',
  cku: 'cku-latn-us',
  ckv: 'ckv-latn-tw',
  ckx: 'ckx-latn-cm',
  cky: 'cky-latn-zz',
  ckz: 'ckz-latn-gt',
  cla: 'cla-latn-zz',
  clc: 'clc-latn-ca',
  cle: 'cle-latn-mx',
  clh: 'clh-arab-pk',
  cli: 'cli-latn-gh',
  clj: 'clj-latn-mm',
  clk: 'clk-latn-in',
  'clk-tibt': 'clk-tibt-cn',
  cll: 'cll-latn-gh',
  clm: 'clm-latn-us',
  clo: 'clo-latn-mx',
  clt: 'clt-latn-mm',
  clu: 'clu-latn-ph',
  clw: 'clw-cyrl-ru',
  cly: 'cly-latn-mx',
  cma: 'cma-latn-vn',
  cme: 'cme-latn-zz',
  cmg: 'cmg-soyo-mn',
  cmi: 'cmi-latn-co',
  cml: 'cml-latn-id',
  cmo: 'cmo-latn-vn',
  'cmo-kh': 'cmo-latn-kh',
  'cmo-khmr': 'cmo-khmr-kh',
  cmr: 'cmr-latn-mm',
  cms: 'cms-latn-it',
  cmt: 'cmt-latn-za',
  cna: 'cna-tibt-in',
  cnb: 'cnb-latn-mm',
  cnc: 'cnc-latn-vn',
  cng: 'cng-latn-cn',
  cnh: 'cnh-latn-mm',
  cni: 'cni-latn-pe',
  cnk: 'cnk-latn-mm',
  cnl: 'cnl-latn-mx',
  cnp: 'cnp-hans-cn',
  'cnp-hant': 'cnp-hant-cn',
  cnq: 'cnq-latn-cm',
  cns: 'cns-latn-id',
  cnt: 'cnt-latn-mx',
  cnw: 'cnw-latn-mm',
  cnx: 'cnx-latn-gb',
  co: 'co-latn-fr',
  coa: 'coa-latn-au',
  cob: 'cob-latn-mx',
  coc: 'coc-latn-mx',
  cod: 'cod-latn-pe',
  coe: 'coe-latn-co',
  cof: 'cof-latn-ec',
  cog: 'cog-thai-th',
  coh: 'coh-latn-ke',
  coj: 'coj-latn-mx',
  cok: 'cok-latn-mx',
  col: 'col-latn-us',
  com: 'com-latn-us',
  coo: 'coo-latn-ca',
  cop: 'cop-copt-eg',
  coq: 'coq-latn-us',
  cot: 'cot-latn-pe',
  cou: 'cou-latn-sn',
  cox: 'cox-latn-pe',
  coz: 'coz-latn-mx',
  cpa: 'cpa-latn-mx',
  cpb: 'cpb-latn-pe',
  cpc: 'cpc-latn-pe',
  cpg: 'cpg-grek-gr',
  cpi: 'cpi-latn-nr',
  cpn: 'cpn-latn-gh',
  cpo: 'cpo-latn-bf',
  cps: 'cps-latn-ph',
  cpu: 'cpu-latn-pe',
  cpx: 'cpx-latn-cn',
  cpy: 'cpy-latn-pe',
  cqd: 'cqd-latn-cn',
  cr: 'cr-cans-ca',
  crb: 'crb-latn-vc',
  crc: 'crc-latn-vu',
  crd: 'crd-latn-us',
  crf: 'crf-latn-co',
  crg: 'crg-latn-ca',
  crh: 'crh-cyrl-ua',
  cri: 'cri-latn-st',
  crj: 'crj-cans-ca',
  'crj-latn': 'crj-latn-ca',
  crk: 'crk-cans-ca',
  crl: 'crl-cans-ca',
  crm: 'crm-cans-ca',
  crn: 'crn-latn-mx',
  cro: 'cro-latn-us',
  crq: 'crq-latn-ar',
  crs: 'crs-latn-sc',
  crt: 'crt-latn-ar',
  crv: 'crv-latn-in',
  crw: 'crw-latn-vn',
  crx: 'crx-latn-ca',
  'crx-cans': 'crx-cans-ca',
  cry: 'cry-latn-ng',
  crz: 'crz-latn-us',
  cs: 'cs-latn-cz',
  csa: 'csa-latn-mx',
  csb: 'csb-latn-pl',
  csh: 'csh-mymr-mm',
  'csh-latn': 'csh-latn-mm',
  csj: 'csj-latn-mm',
  csk: 'csk-latn-sn',
  csm: 'csm-latn-us',
  cso: 'cso-latn-mx',
  csp: 'csp-hans-cn',
  'csp-hant': 'csp-hant-cn',
  css: 'css-latn-us',
  cst: 'cst-latn-us',
  csv: 'csv-latn-mm',
  csw: 'csw-cans-ca',
  csy: 'csy-latn-mm',
  csz: 'csz-latn-us',
  cta: 'cta-latn-mx',
  ctc: 'ctc-latn-us',
  ctd: 'ctd-pauc-mm',
  cte: 'cte-latn-mx',
  ctg: 'ctg-beng-bd',
  'ctg-arab': 'ctg-arab-bd',
  'ctg-latn': 'ctg-latn-bd',
  cth: 'cth-latn-mm',
  ctl: 'ctl-latn-mx',
  ctm: 'ctm-latn-us',
  ctn: 'ctn-deva-np',
  cto: 'cto-latn-co',
  ctp: 'ctp-latn-mx',
  cts: 'cts-latn-ph',
  ctt: 'ctt-taml-in',
  ctu: 'ctu-latn-mx',
  ctz: 'ctz-latn-mx',
  cu: 'cu-cyrl-ru',
  'cu-glag': 'cu-glag-bg',
  cua: 'cua-latn-vn',
  cub: 'cub-latn-co',
  cuc: 'cuc-latn-mx',
  cuh: 'cuh-latn-ke',
  cui: 'cui-latn-co',
  cuj: 'cuj-latn-pe',
  cuk: 'cuk-latn-pa',
  cul: 'cul-latn-br',
  cuo: 'cuo-latn-ve',
  cup: 'cup-latn-us',
  cut: 'cut-latn-mx',
  cuu: 'cuu-lana-cn',
  cuv: 'cuv-latn-cm',
  cux: 'cux-latn-mx',
  cv: 'cv-cyrl-ru',
  cvg: 'cvg-latn-in',
  'cvg-tibt': 'cvg-tibt-in',
  cvn: 'cvn-latn-mx',
  cwa: 'cwa-latn-tz',
  cwb: 'cwb-latn-mz',
  cwe: 'cwe-latn-tz',
  cwg: 'cwg-latn-my',
  cwt: 'cwt-latn-sn',
  cy: 'cy-latn-gb',
  cya: 'cya-latn-mx',
  cyb: 'cyb-latn-bo',
  cyo: 'cyo-latn-ph',
  czh: 'czh-hans-cn',
  'czh-hant': 'czh-hant-cn',
  czk: 'czk-hebr-cz',
  czn: 'czn-latn-mx',
  czt: 'czt-latn-mm',
  da: 'da-latn-dk',
  daa: 'daa-latn-td',
  dac: 'dac-latn-pg',
  dad: 'dad-latn-zz',
  dae: 'dae-latn-cm',
  daf: 'daf-latn-ci',
  dag: 'dag-latn-zz',
  dah: 'dah-latn-zz',
  dai: 'dai-latn-td',
  daj: 'daj-latn-sd',
  dak: 'dak-latn-us',
  dal: 'dal-latn-ke',
  dam: 'dam-latn-ng',
  dao: 'dao-latn-mm',
  daq: 'daq-deva-in',
  dar: 'dar-cyrl-ru',
  das: 'das-latn-ci',
  dau: 'dau-latn-td',
  dav: 'dav-latn-ke',
  daw: 'daw-latn-ph',
  dax: 'dax-latn-au',
  daz: 'daz-latn-id',
  dba: 'dba-latn-ml',
  dbb: 'dbb-latn-ng',
  dbd: 'dbd-latn-zz',
  dbe: 'dbe-latn-id',
  dbf: 'dbf-latn-id',
  dbg: 'dbg-latn-ml',
  dbi: 'dbi-latn-ng',
  dbj: 'dbj-latn-my',
  'dbj-arab': 'dbj-arab-my',
  dbl: 'dbl-latn-au',
  dbm: 'dbm-latn-ng',
  dbn: 'dbn-latn-id',
  dbo: 'dbo-latn-ng',
  dbp: 'dbp-latn-ng',
  dbq: 'dbq-latn-zz',
  dbt: 'dbt-latn-ml',
  dbu: 'dbu-latn-ml',
  dbv: 'dbv-latn-ng',
  dbw: 'dbw-latn-ml',
  dby: 'dby-latn-pg',
  dcc: 'dcc-arab-in',
  dcr: 'dcr-latn-vi',
  dda: 'dda-latn-au',
  ddd: 'ddd-latn-ss',
  dde: 'dde-latn-cg',
  ddg: 'ddg-latn-tl',
  ddi: 'ddi-latn-pg',
  ddj: 'ddj-latn-au',
  ddn: 'ddn-latn-zz',
  ddo: 'ddo-cyrl-ru',
  ddr: 'ddr-latn-au',
  dds: 'dds-latn-ml',
  ddw: 'ddw-latn-id',
  de: 'de-latn-de',
  dec: 'dec-latn-sd',
  ded: 'ded-latn-zz',
  dee: 'dee-latn-lr',
  def: 'def-arab-ir',
  deg: 'deg-latn-ng',
  deh: 'deh-arab-pk',
  dei: 'dei-latn-id',
  dek: 'dek-latn-cm',
  del: 'del-latn-us',
  dem: 'dem-latn-id',
  den: 'den-latn-ca',
  deq: 'deq-latn-cf',
  der: 'der-beng-in',
  'der-latn': 'der-latn-in',
  des: 'des-latn-br',
  dev: 'dev-latn-pg',
  dez: 'dez-latn-cd',
  dga: 'dga-latn-zz',
  dgb: 'dgb-latn-ml',
  dgc: 'dgc-latn-ph',
  dgd: 'dgd-latn-bf',
  dge: 'dge-latn-pg',
  dgg: 'dgg-latn-pg',
  dgh: 'dgh-latn-zz',
  dgi: 'dgi-latn-zz',
  dgk: 'dgk-latn-cf',
  dgl: 'dgl-arab-zz',
  dgn: 'dgn-latn-au',
  dgr: 'dgr-latn-ca',
  dgs: 'dgs-latn-bf',
  dgt: 'dgt-latn-au',
  dgw: 'dgw-latn-au',
  dgx: 'dgx-latn-pg',
  dgz: 'dgz-latn-zz',
  dhg: 'dhg-latn-au',
  dhi: 'dhi-deva-np',
  dhl: 'dhl-latn-au',
  dhm: 'dhm-latn-ao',
  dhn: 'dhn-gujr-in',
  dho: 'dho-deva-in',
  dhr: 'dhr-latn-au',
  dhs: 'dhs-latn-tz',
  dhu: 'dhu-latn-au',
  dhv: 'dhv-latn-nc',
  dhw: 'dhw-deva-np',
  dhx: 'dhx-latn-au',
  dia: 'dia-latn-zz',
  dib: 'dib-latn-ss',
  dic: 'dic-latn-ci',
  did: 'did-latn-ss',
  dif: 'dif-latn-au',
  dig: 'dig-latn-ke',
  dih: 'dih-latn-mx',
  dii: 'dii-latn-cm',
  dij: 'dij-latn-id',
  dil: 'dil-latn-sd',
  din: 'din-latn-ss',
  'din-arab': 'din-arab-ss',
  dio: 'dio-latn-ng',
  dip: 'dip-latn-ss',
  dir: 'dir-latn-ng',
  dis: 'dis-latn-in',
  'dis-beng': 'dis-beng-in',
  diu: 'diu-latn-na',
  diw: 'diw-latn-ss',
  dix: 'dix-latn-vu',
  diy: 'diy-latn-id',
  diz: 'diz-latn-cd',
  dja: 'dja-latn-au',
  djb: 'djb-latn-au',
  djc: 'djc-latn-td',
  djd: 'djd-latn-au',
  dje: 'dje-latn-ne',
  djf: 'djf-latn-au',
  dji: 'dji-latn-au',
  djj: 'djj-latn-au',
  djk: 'djk-latn-sr',
  djm: 'djm-latn-ml',
  djn: 'djn-latn-au',
  djo: 'djo-latn-id',
  djr: 'djr-latn-au',
  dju: 'dju-latn-pg',
  djw: 'djw-latn-au',
  dka: 'dka-tibt-bt',
  dkg: 'dkg-latn-ng',
  dkk: 'dkk-latn-id',
  dkr: 'dkr-latn-my',
  dks: 'dks-latn-ss',
  dkx: 'dkx-latn-cm',
  dlg: 'dlg-cyrl-ru',
  dlm: 'dlm-latn-hr',
  dln: 'dln-latn-in',
  dma: 'dma-latn-ga',
  dmb: 'dmb-latn-ml',
  dmc: 'dmc-latn-pg',
  dmd: 'dmd-latn-au',
  dme: 'dme-latn-cm',
  dmf: 'dmf-medf-ng',
  dmg: 'dmg-latn-my',
  dmk: 'dmk-arab-pk',
  dml: 'dml-arab-pk',
  dmm: 'dmm-latn-cm',
  dmo: 'dmo-latn-cm',
  dmr: 'dmr-latn-id',
  dms: 'dms-latn-id',
  dmu: 'dmu-latn-id',
  dmv: 'dmv-latn-my',
  dmw: 'dmw-latn-au',
  dmx: 'dmx-latn-mz',
  dmy: 'dmy-latn-id',
  dna: 'dna-latn-id',
  dnd: 'dnd-latn-pg',
  dne: 'dne-latn-tz',
  dng: 'dng-cyrl-kg',
  'dng-arab': 'dng-arab-kg',
  dni: 'dni-latn-id',
  dnj: 'dnj-latn-ci',
  dnk: 'dnk-latn-id',
  dnn: 'dnn-latn-bf',
  dno: 'dno-latn-cd',
  dnr: 'dnr-latn-pg',
  dnt: 'dnt-latn-id',
  dnu: 'dnu-mymr-mm',
  dnv: 'dnv-mymr-mm',
  dnw: 'dnw-latn-id',
  dny: 'dny-latn-br',
  doa: 'doa-latn-pg',
  dob: 'dob-latn-zz',
  doc: 'doc-latn-cn',
  doe: 'doe-latn-tz',
  dof: 'dof-latn-pg',
  doh: 'doh-latn-ng',
  doi: 'doi-deva-in',
  dok: 'dok-latn-id',
  dol: 'dol-latn-pg',
  don: 'don-latn-pg',
  doo: 'doo-latn-cd',
  dop: 'dop-latn-zz',
  dor: 'dor-latn-sb',
  dos: 'dos-latn-bf',
  dot: 'dot-latn-ng',
  dov: 'dov-latn-zw',
  dow: 'dow-latn-zz',
  dox: 'dox-ethi-et',
  doy: 'doy-latn-gh',
  dpp: 'dpp-latn-my',
  drc: 'drc-latn-pt',
  dre: 'dre-tibt-np',
  drg: 'drg-latn-my',
  drh: 'drh-mong-cn',
  dri: 'dri-latn-zz',
  drl: 'drl-latn-au',
  drn: 'drn-latn-id',
  dro: 'dro-latn-my',
  drq: 'drq-deva-np',
  drs: 'drs-ethi-zz',
  drt: 'drt-latn-nl',
  dru: 'dru-latn-tw',
  dry: 'dry-deva-np',
  dsb: 'dsb-latn-de',
  dsh: 'dsh-latn-ke',
  dsi: 'dsi-latn-td',
  dsn: 'dsn-latn-id',
  dso: 'dso-orya-in',
  dsq: 'dsq-latn-ml',
  'dsq-arab': 'dsq-arab-ml',
  dta: 'dta-latn-cn',
  'dta-cyrl': 'dta-cyrl-cn',
  'dta-hans': 'dta-hans-cn',
  dtb: 'dtb-latn-my',
  dtd: 'dtd-latn-ca',
  dth: 'dth-latn-au',
  dti: 'dti-latn-ml',
  dtk: 'dtk-latn-ml',
  dtm: 'dtm-latn-ml',
  dto: 'dto-latn-ml',
  dtp: 'dtp-latn-my',
  dtr: 'dtr-latn-my',
  dts: 'dts-latn-zz',
  dtt: 'dtt-latn-ml',
  dtu: 'dtu-latn-ml',
  dty: 'dty-deva-np',
  dua: 'dua-latn-cm',
  dub: 'dub-gujr-in',
  duc: 'duc-latn-zz',
  dud: 'dud-latn-zz',
  due: 'due-latn-ph',
  duf: 'duf-latn-nc',
  dug: 'dug-latn-zz',
  duh: 'duh-deva-in',
  'duh-gujr': 'duh-gujr-in',
  dui: 'dui-latn-pg',
  duk: 'duk-latn-pg',
  dul: 'dul-latn-ph',
  dum: 'dum-latn-nl',
  dun: 'dun-latn-id',
  duo: 'duo-latn-ph',
  dup: 'dup-latn-id',
  duq: 'duq-latn-id',
  dur: 'dur-latn-cm',
  dus: 'dus-deva-np',
  duu: 'duu-latn-cn',
  duv: 'duv-latn-id',
  duw: 'duw-latn-id',
  dux: 'dux-latn-ml',
  duy: 'duy-latn-ph',
  duz: 'duz-latn-cm',
  dv: 'dv-thaa-mv',
  dva: 'dva-latn-zz',
  dwa: 'dwa-latn-ng',
  dwk: 'dwk-orya-in',
  dwr: 'dwr-latn-et',
  'dwr-ethi': 'dwr-ethi-et',
  dws: 'dws-latn-001',
  dwu: 'dwu-latn-au',
  dww: 'dww-latn-zz',
  dwy: 'dwy-latn-au',
  dwz: 'dwz-deva-np',
  dya: 'dya-latn-bf',
  dyb: 'dyb-latn-au',
  dyd: 'dyd-latn-au',
  dyg: 'dyg-latn-ph',
  dyi: 'dyi-latn-ci',
  dym: 'dym-latn-ml',
  dyn: 'dyn-latn-au',
  dyo: 'dyo-latn-sn',
  dyu: 'dyu-latn-bf',
  dyy: 'dyy-latn-au',
  dz: 'dz-tibt-bt',
  dza: 'dza-latn-ng',
  dze: 'dze-latn-au',
  dzg: 'dzg-latn-zz',
  dzl: 'dzl-tibt-bt',
  dzn: 'dzn-latn-cd',
  eaa: 'eaa-latn-au',
  ebc: 'ebc-latn-id',
  ebg: 'ebg-latn-ng',
  ebk: 'ebk-latn-ph',
  ebo: 'ebo-latn-cg',
  ebr: 'ebr-latn-ci',
  ebu: 'ebu-latn-ke',
  ecr: 'ecr-grek-gr',
  ecy: 'ecy-cprt-cy',
  ee: 'ee-latn-gh',
  efa: 'efa-latn-ng',
  efe: 'efe-latn-cd',
  efi: 'efi-latn-ng',
  ega: 'ega-latn-ci',
  egl: 'egl-latn-it',
  egm: 'egm-latn-tz',
  ego: 'ego-latn-ng',
  egy: 'egy-egyp-eg',
  ehu: 'ehu-latn-ng',
  eip: 'eip-latn-id',
  eit: 'eit-latn-pg',
  eiv: 'eiv-latn-pg',
  eja: 'eja-latn-gw',
  eka: 'eka-latn-zz',
  eke: 'eke-latn-ng',
  ekg: 'ekg-latn-id',
  eki: 'eki-latn-ng',
  ekl: 'ekl-latn-bd',
  ekm: 'ekm-latn-cm',
  eko: 'eko-latn-mz',
  'eko-arab': 'eko-arab-mz',
  ekp: 'ekp-latn-ng',
  ekr: 'ekr-latn-ng',
  eky: 'eky-kali-mm',
  el: 'el-grek-gr',
  ele: 'ele-latn-pg',
  elk: 'elk-latn-pg',
  elm: 'elm-latn-ng',
  elo: 'elo-latn-ke',
  elu: 'elu-latn-pg',
  ema: 'ema-latn-zz',
  emb: 'emb-latn-id',
  eme: 'eme-latn-gf',
  emg: 'emg-deva-np',
  emi: 'emi-latn-zz',
  emm: 'emm-latn-mx',
  emn: 'emn-latn-cm',
  emp: 'emp-latn-pa',
  ems: 'ems-latn-us',
  'ems-cyrl': 'ems-cyrl-us',
  emu: 'emu-deva-in',
  emw: 'emw-latn-id',
  emx: 'emx-latn-fr',
  emz: 'emz-latn-cm',
  en: 'en-latn-us',
  'en-shaw': 'en-shaw-gb',
  ena: 'ena-latn-pg',
  enb: 'enb-latn-ke',
  enc: 'enc-latn-vn',
  end: 'end-latn-id',
  enf: 'enf-cyrl-ru',
  enh: 'enh-cyrl-ru',
  enl: 'enl-latn-py',
  enm: 'enm-latn-gb',
  enn: 'enn-latn-zz',
  eno: 'eno-latn-id',
  enq: 'enq-latn-zz',
  enr: 'enr-latn-id',
  env: 'env-latn-ng',
  enw: 'enw-latn-ng',
  enx: 'enx-latn-py',
  eo: 'eo-latn-001',
  eot: 'eot-latn-ci',
  epi: 'epi-latn-ng',
  era: 'era-taml-in',
  erg: 'erg-latn-vu',
  erh: 'erh-latn-ng',
  eri: 'eri-latn-zz',
  erk: 'erk-latn-vu',
  err: 'err-latn-au',
  ert: 'ert-latn-id',
  erw: 'erw-latn-id',
  es: 'es-latn-es',
  ese: 'ese-latn-bo',
  esg: 'esg-gonm-in',
  esh: 'esh-arab-ir',
  esi: 'esi-latn-us',
  esm: 'esm-latn-ci',
  ess: 'ess-latn-us',
  'ess-cyrl': 'ess-cyrl-us',
  esu: 'esu-latn-us',
  esy: 'esy-latn-ph',
  et: 'et-latn-ee',
  etb: 'etb-latn-ng',
  etn: 'etn-latn-vu',
  eto: 'eto-latn-cm',
  etr: 'etr-latn-zz',
  ets: 'ets-latn-ng',
  ett: 'ett-ital-it',
  etu: 'etu-latn-zz',
  etx: 'etx-latn-zz',
  etz: 'etz-latn-id',
  eu: 'eu-latn-es',
  eve: 'eve-cyrl-ru',
  evh: 'evh-latn-ng',
  evn: 'evn-cyrl-ru',
  'evn-latn': 'evn-latn-cn',
  'evn-mong': 'evn-mong-cn',
  ewo: 'ewo-latn-cm',
  ext: 'ext-latn-es',
  eya: 'eya-latn-us',
  eyo: 'eyo-latn-ke',
  eza: 'eza-latn-zz',
  eze: 'eze-latn-ng',
  fa: 'fa-arab-ir',
  faa: 'faa-latn-zz',
  fab: 'fab-latn-zz',
  fad: 'fad-latn-pg',
  faf: 'faf-latn-sb',
  fag: 'fag-latn-zz',
  fah: 'fah-latn-ng',
  fai: 'fai-latn-zz',
  faj: 'faj-latn-pg',
  fak: 'fak-latn-cm',
  fal: 'fal-latn-cm',
  fam: 'fam-latn-ng',
  fan: 'fan-latn-gq',
  fap: 'fap-latn-sn',
  far: 'far-latn-sb',
  fau: 'fau-latn-id',
  fax: 'fax-latn-es',
  fay: 'fay-arab-ir',
  faz: 'faz-arab-ir',
  fbl: 'fbl-latn-ph',
  fer: 'fer-latn-ss',
  ff: 'ff-latn-sn',
  'ff-adlm': 'ff-adlm-gn',
  ffi: 'ffi-latn-zz',
  ffm: 'ffm-latn-ml',
  fgr: 'fgr-latn-td',
  fi: 'fi-latn-fi',
  fia: 'fia-arab-sd',
  fie: 'fie-latn-ng',
  fif: 'fif-latn-sa',
  fil: 'fil-latn-ph',
  fip: 'fip-latn-tz',
  fir: 'fir-latn-ng',
  fit: 'fit-latn-se',
  fiw: 'fiw-latn-pg',
  fj: 'fj-latn-fj',
  fkk: 'fkk-latn-ng',
  fkv: 'fkv-latn-no',
  fla: 'fla-latn-us',
  flh: 'flh-latn-id',
  fli: 'fli-latn-ng',
  fll: 'fll-latn-cm',
  fln: 'fln-latn-au',
  flr: 'flr-latn-zz',
  fly: 'fly-latn-za',
  fmp: 'fmp-latn-zz',
  fmu: 'fmu-deva-in',
  fnb: 'fnb-latn-vu',
  fng: 'fng-latn-za',
  fni: 'fni-latn-td',
  fo: 'fo-latn-fo',
  fod: 'fod-latn-zz',
  foi: 'foi-latn-pg',
  fom: 'fom-latn-cd',
  fon: 'fon-latn-bj',
  for: 'for-latn-zz',
  fos: 'fos-latn-tw',
  fpe: 'fpe-latn-zz',
  fqs: 'fqs-latn-zz',
  fr: 'fr-latn-fr',
  frc: 'frc-latn-us',
  frd: 'frd-latn-id',
  frk: 'frk-latn-de',
  frm: 'frm-latn-fr',
  fro: 'fro-latn-fr',
  frp: 'frp-latn-fr',
  frq: 'frq-latn-pg',
  frr: 'frr-latn-de',
  frs: 'frs-latn-de',
  frt: 'frt-latn-vu',
  fub: 'fub-arab-cm',
  fud: 'fud-latn-wf',
  fue: 'fue-latn-zz',
  fuf: 'fuf-latn-gn',
  fuh: 'fuh-latn-zz',
  fui: 'fui-latn-td',
  fum: 'fum-latn-ng',
  fun: 'fun-latn-br',
  fuq: 'fuq-latn-ne',
  fur: 'fur-latn-it',
  fut: 'fut-latn-vu',
  fuu: 'fuu-latn-cd',
  fuv: 'fuv-latn-ng',
  fuy: 'fuy-latn-zz',
  fvr: 'fvr-latn-sd',
  fwa: 'fwa-latn-nc',
  fwe: 'fwe-latn-na',
  fy: 'fy-latn-nl',
  ga: 'ga-latn-ie',
  gaa: 'gaa-latn-gh',
  gab: 'gab-latn-td',
  gac: 'gac-latn-in',
  'gac-deva': 'gac-deva-in',
  gad: 'gad-latn-ph',
  gae: 'gae-latn-ve',
  gaf: 'gaf-latn-zz',
  gag: 'gag-latn-md',
  gah: 'gah-latn-zz',
  gai: 'gai-latn-pg',
  gaj: 'gaj-latn-zz',
  gak: 'gak-latn-id',
  gal: 'gal-latn-tl',
  gam: 'gam-latn-zz',
  gan: 'gan-hans-cn',
  gao: 'gao-latn-pg',
  gap: 'gap-latn-pg',
  gaq: 'gaq-orya-in',
  gar: 'gar-latn-pg',
  gas: 'gas-gujr-in',
  gat: 'gat-latn-pg',
  gau: 'gau-telu-in',
  gaw: 'gaw-latn-zz',
  gax: 'gax-latn-et',
  'gax-ethi': 'gax-ethi-et',
  gay: 'gay-latn-id',
  gba: 'gba-latn-zz',
  gbb: 'gbb-latn-au',
  gbd: 'gbd-latn-au',
  gbe: 'gbe-latn-pg',
  gbf: 'gbf-latn-zz',
  gbg: 'gbg-latn-cf',
  gbh: 'gbh-latn-bj',
  gbi: 'gbi-latn-id',
  gbj: 'gbj-orya-in',
  gbk: 'gbk-deva-in',
  'gbk-takr': 'gbk-takr-in',
  gbl: 'gbl-gujr-in',
  'gbl-deva': 'gbl-deva-in',
  gbm: 'gbm-deva-in',
  gbn: 'gbn-latn-ss',
  gbp: 'gbp-latn-cf',
  gbq: 'gbq-latn-cf',
  gbr: 'gbr-latn-ng',
  gbs: 'gbs-latn-bj',
  gbu: 'gbu-latn-au',
  gbv: 'gbv-latn-cf',
  gbw: 'gbw-latn-au',
  gbx: 'gbx-latn-bj',
  gby: 'gby-latn-zz',
  gbz: 'gbz-arab-ir',
  gcc: 'gcc-latn-pg',
  gcd: 'gcd-latn-au',
  gcf: 'gcf-latn-gp',
  gcl: 'gcl-latn-gd',
  gcn: 'gcn-latn-pg',
  gcr: 'gcr-latn-gf',
  gct: 'gct-latn-ve',
  gd: 'gd-latn-gb',
  gdb: 'gdb-orya-in',
  'gdb-telu': 'gdb-telu-in',
  gdc: 'gdc-latn-au',
  gdd: 'gdd-latn-pg',
  gde: 'gde-latn-zz',
  gdf: 'gdf-latn-ng',
  gdg: 'gdg-latn-ph',
  gdh: 'gdh-latn-au',
  gdi: 'gdi-latn-cf',
  gdj: 'gdj-latn-au',
  gdk: 'gdk-latn-td',
  gdl: 'gdl-latn-et',
  'gdl-ethi': 'gdl-ethi-et',
  gdm: 'gdm-latn-td',
  gdn: 'gdn-latn-zz',
  gdo: 'gdo-cyrl-ru',
  gdq: 'gdq-latn-ye',
  gdr: 'gdr-latn-zz',
  gdt: 'gdt-latn-au',
  gdu: 'gdu-latn-ng',
  gdx: 'gdx-deva-in',
  gea: 'gea-latn-ng',
  geb: 'geb-latn-zz',
  gec: 'gec-latn-lr',
  ged: 'ged-latn-ng',
  gef: 'gef-latn-id',
  geg: 'geg-latn-ng',
  geh: 'geh-latn-ca',
  gei: 'gei-latn-id',
  gej: 'gej-latn-zz',
  gek: 'gek-latn-ng',
  gel: 'gel-latn-zz',
  geq: 'geq-latn-cf',
  ges: 'ges-latn-id',
  gev: 'gev-latn-ga',
  gew: 'gew-latn-ng',
  gex: 'gex-latn-so',
  gey: 'gey-latn-cd',
  gez: 'gez-ethi-et',
  gfk: 'gfk-latn-zz',
  gga: 'gga-latn-sb',
  ggb: 'ggb-latn-lr',
  ggd: 'ggd-latn-au',
  gge: 'gge-latn-au',
  ggg: 'ggg-arab-pk',
  ggk: 'ggk-latn-au',
  ggl: 'ggl-latn-pg',
  ggn: 'ggn-deva-np',
  ggt: 'ggt-latn-pg',
  ggu: 'ggu-latn-ci',
  ggw: 'ggw-latn-pg',
  gha: 'gha-arab-ly',
  'gha-latn': 'gha-latn-ly',
  'gha-tfng': 'gha-tfng-ly',
  ghc: 'ghc-latn-gb',
  ghe: 'ghe-deva-np',
  ghk: 'ghk-latn-mm',
  ghn: 'ghn-latn-sb',
  ghr: 'ghr-arab-pk',
  ghs: 'ghs-latn-zz',
  ght: 'ght-tibt-np',
  gia: 'gia-latn-au',
  gib: 'gib-latn-ng',
  gic: 'gic-latn-za',
  gid: 'gid-latn-cm',
  gie: 'gie-latn-ci',
  gig: 'gig-arab-pk',
  gih: 'gih-latn-au',
  gil: 'gil-latn-ki',
  gim: 'gim-latn-zz',
  gin: 'gin-cyrl-ru',
  gip: 'gip-latn-pg',
  giq: 'giq-latn-vn',
  gir: 'gir-latn-vn',
  gis: 'gis-latn-cm',
  git: 'git-latn-ca',
  gix: 'gix-latn-cd',
  giy: 'giy-latn-au',
  giz: 'giz-latn-cm',
  gjk: 'gjk-arab-pk',
  gjm: 'gjm-latn-au',
  gjn: 'gjn-latn-zz',
  gjr: 'gjr-latn-au',
  gju: 'gju-arab-pk',
  gka: 'gka-latn-pg',
  gkd: 'gkd-latn-pg',
  gke: 'gke-latn-cm',
  gkn: 'gkn-latn-zz',
  gko: 'gko-latn-au',
  gkp: 'gkp-latn-zz',
  gku: 'gku-latn-za',
  gl: 'gl-latn-es',
  glb: 'glb-latn-ng',
  glc: 'glc-latn-td',
  gld: 'gld-cyrl-ru',
  glh: 'glh-arab-af',
  glj: 'glj-latn-td',
  glk: 'glk-arab-ir',
  gll: 'gll-latn-au',
  glo: 'glo-latn-ng',
  glr: 'glr-latn-lr',
  glu: 'glu-latn-td',
  glw: 'glw-latn-ng',
  gma: 'gma-latn-au',
  gmb: 'gmb-latn-sb',
  gmd: 'gmd-latn-ng',
  gmg: 'gmg-latn-pg',
  gmh: 'gmh-latn-de',
  gmm: 'gmm-latn-zz',
  gmn: 'gmn-latn-cm',
  gmr: 'gmr-latn-au',
  gmu: 'gmu-latn-pg',
  gmv: 'gmv-ethi-zz',
  gmx: 'gmx-latn-tz',
  gmy: 'gmy-linb-gr',
  gmz: 'gmz-latn-ng',
  gn: 'gn-latn-py',
  gna: 'gna-latn-bf',
  gnb: 'gnb-latn-in',
  gnc: 'gnc-latn-es',
  gnd: 'gnd-latn-zz',
  gne: 'gne-latn-ng',
  gng: 'gng-latn-zz',
  gnh: 'gnh-latn-ng',
  gni: 'gni-latn-au',
  gnj: 'gnj-latn-ci',
  gnk: 'gnk-latn-bw',
  gnl: 'gnl-latn-au',
  gnm: 'gnm-latn-pg',
  gnn: 'gnn-latn-au',
  gnq: 'gnq-latn-my',
  gnr: 'gnr-latn-au',
  gnt: 'gnt-latn-pg',
  gnu: 'gnu-latn-pg',
  gnw: 'gnw-latn-bo',
  gnz: 'gnz-latn-cf',
  goa: 'goa-latn-ci',
  gob: 'gob-latn-co',
  goc: 'goc-latn-pg',
  god: 'god-latn-zz',
  goe: 'goe-tibt-bt',
  gof: 'gof-ethi-zz',
  gog: 'gog-latn-tz',
  goh: 'goh-latn-de',
  goi: 'goi-latn-zz',
  gok: 'gok-deva-in',
  gol: 'gol-latn-lr',
  gom: 'gom-deva-in',
  gon: 'gon-telu-in',
  goo: 'goo-latn-fj',
  gop: 'gop-latn-id',
  goq: 'goq-latn-id',
  gor: 'gor-latn-id',
  gos: 'gos-latn-nl',
  got: 'got-goth-ua',
  gou: 'gou-latn-cm',
  gov: 'gov-latn-ci',
  gow: 'gow-latn-tz',
  gox: 'gox-latn-cd',
  goy: 'goy-latn-td',
  gpa: 'gpa-latn-ng',
  gpe: 'gpe-latn-gh',
  gpn: 'gpn-latn-pg',
  gqa: 'gqa-latn-ng',
  gqn: 'gqn-latn-br',
  gqr: 'gqr-latn-td',
  gra: 'gra-deva-in',
  'gra-gujr': 'gra-gujr-in',
  grb: 'grb-latn-zz',
  grc: 'grc-cprt-cy',
  'grc-linb': 'grc-linb-gr',
  grd: 'grd-latn-ng',
  grg: 'grg-latn-pg',
  grh: 'grh-latn-ng',
  gri: 'gri-latn-sb',
  grj: 'grj-latn-lr',
  grm: 'grm-latn-my',
  grq: 'grq-latn-pg',
  grs: 'grs-latn-id',
  grt: 'grt-beng-in',
  gru: 'gru-ethi-et',
  'gru-latn': 'gru-latn-et',
  grv: 'grv-latn-lr',
  grw: 'grw-latn-zz',
  grx: 'grx-latn-pg',
  gry: 'gry-latn-lr',
  grz: 'grz-latn-pg',
  gsl: 'gsl-latn-sn',
  gsn: 'gsn-latn-pg',
  gso: 'gso-latn-cf',
  gsp: 'gsp-latn-pg',
  gsw: 'gsw-latn-ch',
  gta: 'gta-latn-br',
  gtu: 'gtu-latn-au',
  gu: 'gu-gujr-in',
  gua: 'gua-latn-ng',
  gub: 'gub-latn-br',
  guc: 'guc-latn-co',
  gud: 'gud-latn-zz',
  gue: 'gue-latn-au',
  guf: 'guf-latn-au',
  guh: 'guh-latn-co',
  gui: 'gui-latn-bo',
  guk: 'guk-latn-et',
  'guk-ethi': 'guk-ethi-et',
  gul: 'gul-latn-us',
  gum: 'gum-latn-co',
  gun: 'gun-latn-br',
  guo: 'guo-latn-co',
  gup: 'gup-latn-au',
  guq: 'guq-latn-py',
  gur: 'gur-latn-gh',
  gut: 'gut-latn-cr',
  guu: 'guu-latn-ve',
  guw: 'guw-latn-zz',
  gux: 'gux-latn-zz',
  guz: 'guz-latn-ke',
  gv: 'gv-latn-im',
  gva: 'gva-latn-py',
  gvc: 'gvc-latn-br',
  gve: 'gve-latn-pg',
  gvf: 'gvf-latn-zz',
  gvj: 'gvj-latn-br',
  gvl: 'gvl-latn-td',
  gvm: 'gvm-latn-ng',
  gvn: 'gvn-latn-au',
  gvo: 'gvo-latn-br',
  gvp: 'gvp-latn-br',
  gvr: 'gvr-deva-np',
  gvs: 'gvs-latn-zz',
  gvy: 'gvy-latn-au',
  gwa: 'gwa-latn-ci',
  gwb: 'gwb-latn-ng',
  gwc: 'gwc-arab-zz',
  gwd: 'gwd-latn-et',
  gwe: 'gwe-latn-tz',
  gwf: 'gwf-arab-pk',
  gwg: 'gwg-latn-ng',
  gwi: 'gwi-latn-ca',
  gwj: 'gwj-latn-bw',
  gwm: 'gwm-latn-au',
  gwn: 'gwn-latn-ng',
  gwr: 'gwr-latn-ug',
  gwt: 'gwt-arab-zz',
  gwu: 'gwu-latn-au',
  gww: 'gww-latn-au',
  gwx: 'gwx-latn-gh',
  gxx: 'gxx-latn-ci',
  gyb: 'gyb-latn-pg',
  gyd: 'gyd-latn-au',
  gye: 'gye-latn-ng',
  gyf: 'gyf-latn-au',
  gyg: 'gyg-latn-cf',
  gyi: 'gyi-latn-zz',
  gyl: 'gyl-latn-et',
  'gyl-ethi': 'gyl-ethi-et',
  gym: 'gym-latn-pa',
  gyn: 'gyn-latn-gy',
  gyo: 'gyo-deva-np',
  gyr: 'gyr-latn-bo',
  gyy: 'gyy-latn-au',
  gyz: 'gyz-latn-ng',
  gza: 'gza-latn-sd',
  gzi: 'gzi-arab-ir',
  gzn: 'gzn-latn-id',
  ha: 'ha-latn-ng',
  'ha-cm': 'ha-arab-cm',
  'ha-sd': 'ha-arab-sd',
  haa: 'haa-latn-us',
  hac: 'hac-arab-ir',
  had: 'had-latn-id',
  hae: 'hae-latn-et',
  hag: 'hag-latn-zz',
  hah: 'hah-latn-pg',
  hai: 'hai-latn-ca',
  haj: 'haj-latn-in',
  'haj-beng': 'haj-beng-in',
  hak: 'hak-hans-cn',
  hal: 'hal-latn-vn',
  ham: 'ham-latn-zz',
  han: 'han-latn-tz',
  hao: 'hao-latn-pg',
  hap: 'hap-latn-id',
  haq: 'haq-latn-tz',
  har: 'har-ethi-et',
  'har-arab': 'har-arab-et',
  'har-latn': 'har-latn-et',
  has: 'has-latn-ca',
  hav: 'hav-latn-cd',
  haw: 'haw-latn-us',
  hax: 'hax-latn-ca',
  hay: 'hay-latn-tz',
  haz: 'haz-arab-af',
  hba: 'hba-latn-cd',
  hbb: 'hbb-latn-zz',
  hbn: 'hbn-latn-sd',
  hbo: 'hbo-hebr-il',
  hbu: 'hbu-latn-tl',
  hch: 'hch-latn-mx',
  hdy: 'hdy-ethi-zz',
  he: 'he-hebr-il',
  hed: 'hed-latn-td',
  heg: 'heg-latn-id',
  heh: 'heh-latn-tz',
  hei: 'hei-latn-ca',
  hem: 'hem-latn-cd',
  hgm: 'hgm-latn-na',
  hgw: 'hgw-latn-pg',
  hhi: 'hhi-latn-pg',
  hhr: 'hhr-latn-sn',
  hhy: 'hhy-latn-zz',
  hi: 'hi-deva-in',
  'hi-latn': 'hi-latn-in',
  hia: 'hia-latn-zz',
  hib: 'hib-latn-pe',
  hid: 'hid-latn-us',
  hif: 'hif-latn-fj',
  hig: 'hig-latn-zz',
  hih: 'hih-latn-zz',
  hii: 'hii-takr-in',
  'hii-deva': 'hii-deva-in',
  hij: 'hij-latn-cm',
  hik: 'hik-latn-id',
  hil: 'hil-latn-ph',
  hio: 'hio-latn-bw',
  hir: 'hir-latn-br',
  hit: 'hit-xsux-tr',
  hiw: 'hiw-latn-vu',
  hix: 'hix-latn-br',
  hji: 'hji-latn-id',
  hka: 'hka-latn-tz',
  hke: 'hke-latn-cd',
  hkh: 'hkh-arab-in',
  'hkh-deva': 'hkh-deva-in',
  'hkh-latn': 'hkh-latn-in',
  hkk: 'hkk-latn-pg',
  hla: 'hla-latn-zz',
  hlb: 'hlb-deva-in',
  hld: 'hld-latn-vn',
  hlt: 'hlt-latn-mm',
  hlu: 'hlu-hluw-tr',
  hma: 'hma-latn-cn',
  hmb: 'hmb-latn-ml',
  hmd: 'hmd-plrd-cn',
  hmf: 'hmf-latn-vn',
  hmj: 'hmj-bopo-cn',
  hmm: 'hmm-latn-cn',
  hmn: 'hmn-latn-cn',
  'hmn-bopo': 'hmn-bopo-cn',
  'hmn-hmng': 'hmn-hmng-cn',
  hmp: 'hmp-latn-cn',
  hmq: 'hmq-bopo-cn',
  hmr: 'hmr-latn-in',
  hms: 'hms-latn-cn',
  hmt: 'hmt-latn-zz',
  hmu: 'hmu-latn-id',
  hmv: 'hmv-latn-vn',
  hmw: 'hmw-latn-cn',
  hmy: 'hmy-latn-cn',
  hmz: 'hmz-latn-cn',
  'hmz-plrd': 'hmz-plrd-cn',
  hna: 'hna-latn-cm',
  hnd: 'hnd-arab-pk',
  hne: 'hne-deva-in',
  hng: 'hng-latn-ao',
  hnh: 'hnh-latn-bw',
  hni: 'hni-latn-cn',
  hnj: 'hnj-hmnp-us',
  'hnj-au': 'hnj-laoo-au',
  'hnj-cn': 'hnj-laoo-cn',
  'hnj-fr': 'hnj-laoo-fr',
  'hnj-gf': 'hnj-laoo-gf',
  'hnj-la': 'hnj-laoo-la',
  'hnj-laoo': 'hnj-laoo-la',
  'hnj-mm': 'hnj-laoo-mm',
  'hnj-sr': 'hnj-laoo-sr',
  'hnj-th': 'hnj-laoo-th',
  'hnj-us': 'hnj-hmnp-us',
  'hnj-vn': 'hnj-laoo-vn',
  hnn: 'hnn-latn-ph',
  hno: 'hno-arab-pk',
  hns: 'hns-latn-sr',
  ho: 'ho-latn-pg',
  hoa: 'hoa-latn-sb',
  hob: 'hob-latn-pg',
  hoc: 'hoc-deva-in',
  hod: 'hod-latn-ng',
  hoe: 'hoe-latn-ng',
  hoh: 'hoh-arab-om',
  hoi: 'hoi-latn-us',
  hoj: 'hoj-deva-in',
  hol: 'hol-latn-ao',
  hom: 'hom-latn-ss',
  hoo: 'hoo-latn-cd',
  hop: 'hop-latn-us',
  hor: 'hor-latn-td',
  hot: 'hot-latn-zz',
  hov: 'hov-latn-id',
  how: 'how-hani-cn',
  hoy: 'hoy-deva-in',
  hpo: 'hpo-mymr-mm',
  hr: 'hr-latn-hr',
  hra: 'hra-latn-in',
  hrc: 'hrc-latn-pg',
  hre: 'hre-latn-vn',
  hrk: 'hrk-latn-id',
  hrm: 'hrm-latn-cn',
  'hrm-hmng': 'hrm-hmng-cn',
  hro: 'hro-latn-vn',
  hrp: 'hrp-latn-au',
  hrt: 'hrt-syrc-tr',
  hru: 'hru-latn-in',
  hrw: 'hrw-latn-pg',
  hrx: 'hrx-latn-br',
  hrz: 'hrz-arab-ir',
  hsb: 'hsb-latn-de',
  hsn: 'hsn-hans-cn',
  hss: 'hss-arab-om',
  ht: 'ht-latn-ht',
  hti: 'hti-latn-id',
  hto: 'hto-latn-co',
  hts: 'hts-latn-tz',
  htu: 'htu-latn-id',
  htx: 'htx-xsux-tr',
  hu: 'hu-latn-hu',
  hub: 'hub-latn-pe',
  huc: 'huc-latn-bw',
  hud: 'hud-latn-id',
  hue: 'hue-latn-mx',
  huf: 'huf-latn-pg',
  hug: 'hug-latn-pe',
  huh: 'huh-latn-cl',
  hui: 'hui-latn-zz',
  huk: 'huk-latn-id',
  hul: 'hul-latn-pg',
  hum: 'hum-latn-cd',
  hup: 'hup-latn-us',
  hur: 'hur-latn-ca',
  hus: 'hus-latn-mx',
  hut: 'hut-deva-np',
  'hut-tibt': 'hut-tibt-np',
  huu: 'huu-latn-pe',
  huv: 'huv-latn-mx',
  huw: 'huw-latn-id',
  hux: 'hux-latn-pe',
  huy: 'huy-hebr-il',
  huz: 'huz-cyrl-ru',
  hvc: 'hvc-latn-ht',
  hve: 'hve-latn-mx',
  hvk: 'hvk-latn-nc',
  hvn: 'hvn-latn-id',
  hvv: 'hvv-latn-mx',
  hwa: 'hwa-latn-ci',
  hwc: 'hwc-latn-us',
  hwo: 'hwo-latn-ng',
  hy: 'hy-armn-am',
  hya: 'hya-latn-cm',
  hyw: 'hyw-armn-am',
  hz: 'hz-latn-na',
  ia: 'ia-latn-001',
  iai: 'iai-latn-nc',
  ian: 'ian-latn-zz',
  iar: 'iar-latn-zz',
  iba: 'iba-latn-my',
  ibb: 'ibb-latn-ng',
  ibd: 'ibd-latn-au',
  ibe: 'ibe-latn-ng',
  ibg: 'ibg-latn-ph',
  ibh: 'ibh-latn-vn',
  ibl: 'ibl-latn-ph',
  ibm: 'ibm-latn-ng',
  ibn: 'ibn-latn-ng',
  ibr: 'ibr-latn-ng',
  ibu: 'ibu-latn-id',
  iby: 'iby-latn-zz',
  ica: 'ica-latn-zz',
  ich: 'ich-latn-zz',
  icr: 'icr-latn-co',
  id: 'id-latn-id',
  ida: 'ida-latn-ke',
  idb: 'idb-latn-in',
  idc: 'idc-latn-ng',
  idd: 'idd-latn-zz',
  ide: 'ide-latn-ng',
  idi: 'idi-latn-zz',
  idr: 'idr-latn-ss',
  ids: 'ids-latn-ng',
  idt: 'idt-latn-tl',
  idu: 'idu-latn-zz',
  ie: 'ie-latn-001',
  ifa: 'ifa-latn-ph',
  ifb: 'ifb-latn-ph',
  ife: 'ife-latn-tg',
  iff: 'iff-latn-vu',
  ifk: 'ifk-latn-ph',
  ifm: 'ifm-latn-cg',
  ifu: 'ifu-latn-ph',
  ify: 'ify-latn-ph',
  ig: 'ig-latn-ng',
  igb: 'igb-latn-zz',
  ige: 'ige-latn-zz',
  igg: 'igg-latn-pg',
  igl: 'igl-latn-ng',
  igm: 'igm-latn-pg',
  ign: 'ign-latn-bo',
  igo: 'igo-latn-pg',
  igs: 'igs-latn-001',
  'igs-grek': 'igs-grek-001',
  igw: 'igw-latn-ng',
  ihb: 'ihb-latn-id',
  ihi: 'ihi-latn-ng',
  ihp: 'ihp-latn-id',
  ihw: 'ihw-latn-au',
  ii: 'ii-yiii-cn',
  iin: 'iin-latn-au',
  ijc: 'ijc-latn-ng',
  ije: 'ije-latn-ng',
  ijj: 'ijj-latn-zz',
  ijn: 'ijn-latn-ng',
  ijs: 'ijs-latn-ng',
  ik: 'ik-latn-us',
  iki: 'iki-latn-ng',
  ikk: 'ikk-latn-zz',
  ikl: 'ikl-latn-ng',
  iko: 'iko-latn-ng',
  ikp: 'ikp-latn-ng',
  ikr: 'ikr-latn-au',
  ikt: 'ikt-latn-ca',
  'ikt-cans': 'ikt-cans-ca',
  ikv: 'ikv-latn-ng',
  ikw: 'ikw-latn-zz',
  ikx: 'ikx-latn-zz',
  ikz: 'ikz-latn-tz',
  ila: 'ila-latn-id',
  ilb: 'ilb-latn-zm',
  ilg: 'ilg-latn-au',
  ili: 'ili-latn-cn',
  'ili-arab': 'ili-arab-cn',
  'ili-cyrl': 'ili-cyrl-kz',
  ilk: 'ilk-latn-ph',
  ilm: 'ilm-latn-my',
  ilo: 'ilo-latn-ph',
  ilp: 'ilp-latn-ph',
  ilu: 'ilu-latn-id',
  ilv: 'ilv-latn-ng',
  imi: 'imi-latn-pg',
  iml: 'iml-latn-us',
  imn: 'imn-latn-pg',
  imo: 'imo-latn-zz',
  imr: 'imr-latn-id',
  ims: 'ims-latn-it',
  imt: 'imt-latn-ss',
  imy: 'imy-lyci-tr',
  in: 'in-latn-id',
  inb: 'inb-latn-co',
  ing: 'ing-latn-us',
  inh: 'inh-cyrl-ru',
  inj: 'inj-latn-co',
  inn: 'inn-latn-ph',
  ino: 'ino-latn-pg',
  inp: 'inp-latn-pe',
  int: 'int-mymr-mm',
  io: 'io-latn-001',
  ior: 'ior-ethi-et',
  iou: 'iou-latn-zz',
  iow: 'iow-latn-us',
  ipi: 'ipi-latn-pg',
  ipo: 'ipo-latn-pg',
  iqu: 'iqu-latn-pe',
  iqw: 'iqw-latn-ng',
  ire: 'ire-latn-id',
  irh: 'irh-latn-id',
  iri: 'iri-latn-zz',
  irk: 'irk-latn-tz',
  irn: 'irn-latn-br',
  iru: 'iru-taml-in',
  'iru-mlym': 'iru-mlym-in',
  irx: 'irx-latn-id',
  iry: 'iry-latn-ph',
  is: 'is-latn-is',
  isa: 'isa-latn-pg',
  isc: 'isc-latn-pe',
  isd: 'isd-latn-ph',
  ish: 'ish-latn-ng',
  isi: 'isi-latn-ng',
  isk: 'isk-arab-af',
  'isk-cyrl': 'isk-cyrl-tj',
  ism: 'ism-latn-id',
  isn: 'isn-latn-tz',
  iso: 'iso-latn-ng',
  ist: 'ist-latn-hr',
  isu: 'isu-latn-cm',
  it: 'it-latn-it',
  itb: 'itb-latn-ph',
  itd: 'itd-latn-id',
  ite: 'ite-latn-bo',
  iti: 'iti-latn-ph',
  itk: 'itk-hebr-it',
  itl: 'itl-cyrl-ru',
  itm: 'itm-latn-ng',
  ito: 'ito-latn-bo',
  itr: 'itr-latn-pg',
  its: 'its-latn-ng',
  itt: 'itt-latn-ph',
  itv: 'itv-latn-ph',
  itw: 'itw-latn-ng',
  itx: 'itx-latn-id',
  ity: 'ity-latn-ph',
  itz: 'itz-latn-gt',
  iu: 'iu-cans-ca',
  ium: 'ium-latn-cn',
  'ium-hani': 'ium-hani-cn',
  'ium-laoo': 'ium-laoo-la',
  'ium-thai': 'ium-thai-th',
  ivb: 'ivb-latn-ph',
  ivv: 'ivv-latn-ph',
  iw: 'iw-hebr-il',
  iwk: 'iwk-latn-ph',
  iwm: 'iwm-latn-zz',
  iwo: 'iwo-latn-id',
  iws: 'iws-latn-zz',
  ixc: 'ixc-latn-mx',
  ixl: 'ixl-latn-gt',
  iya: 'iya-latn-ng',
  iyo: 'iyo-latn-cm',
  iyx: 'iyx-latn-cg',
  izh: 'izh-latn-ru',
  izi: 'izi-latn-zz',
  izr: 'izr-latn-ng',
  izz: 'izz-latn-ng',
  ja: 'ja-jpan-jp',
  jaa: 'jaa-latn-br',
  jab: 'jab-latn-zz',
  jac: 'jac-latn-gt',
  jad: 'jad-arab-gn',
  jae: 'jae-latn-pg',
  jaf: 'jaf-latn-ng',
  jah: 'jah-latn-my',
  jaj: 'jaj-latn-sb',
  jak: 'jak-latn-my',
  jal: 'jal-latn-id',
  jam: 'jam-latn-jm',
  jan: 'jan-latn-au',
  jao: 'jao-latn-au',
  jaq: 'jaq-latn-id',
  jar: 'jar-latn-zz',
  jas: 'jas-latn-nc',
  jat: 'jat-arab-af',
  jau: 'jau-latn-id',
  jax: 'jax-latn-id',
  jay: 'jay-latn-au',
  jaz: 'jaz-latn-nc',
  jbe: 'jbe-hebr-il',
  jbi: 'jbi-latn-au',
  jbj: 'jbj-latn-id',
  jbk: 'jbk-latn-pg',
  jbm: 'jbm-latn-ng',
  jbn: 'jbn-arab-ly',
  jbo: 'jbo-latn-001',
  jbr: 'jbr-latn-id',
  jbt: 'jbt-latn-br',
  jbu: 'jbu-latn-zz',
  jbw: 'jbw-latn-au',
  jct: 'jct-cyrl-ua',
  'jct-latn': 'jct-latn-ua',
  jda: 'jda-tibt-in',
  jdg: 'jdg-arab-pk',
  jdt: 'jdt-cyrl-ru',
  'jdt-hebr': 'jdt-hebr-ru',
  'jdt-latn': 'jdt-latn-az',
  jeb: 'jeb-latn-pe',
  jee: 'jee-deva-np',
  jeh: 'jeh-latn-vn',
  'jeh-laoo': 'jeh-laoo-la',
  jei: 'jei-latn-id',
  jek: 'jek-latn-ci',
  jel: 'jel-latn-id',
  jen: 'jen-latn-zz',
  jer: 'jer-latn-ng',
  jet: 'jet-latn-pg',
  jeu: 'jeu-latn-td',
  jgb: 'jgb-latn-cd',
  jge: 'jge-geor-ge',
  'jge-hebr': 'jge-hebr-il',
  jgk: 'jgk-latn-zz',
  jgo: 'jgo-latn-cm',
  jhi: 'jhi-latn-my',
  ji: 'ji-hebr-ua',
  jia: 'jia-latn-cm',
  jib: 'jib-latn-zz',
  jic: 'jic-latn-hn',
  jid: 'jid-latn-ng',
  jie: 'jie-latn-ng',
  jig: 'jig-latn-au',
  jil: 'jil-latn-pg',
  jim: 'jim-latn-cm',
  jit: 'jit-latn-tz',
  jiu: 'jiu-latn-cn',
  jiv: 'jiv-latn-ec',
  jiy: 'jiy-latn-cn',
  jje: 'jje-hang-kr',
  jjr: 'jjr-latn-ng',
  jka: 'jka-latn-id',
  jkm: 'jkm-mymr-mm',
  'jkm-brai': 'jkm-brai-mm',
  'jkm-latn': 'jkm-latn-mm',
  jko: 'jko-latn-pg',
  jku: 'jku-latn-ng',
  jle: 'jle-latn-sd',
  jma: 'jma-latn-pg',
  jmb: 'jmb-latn-ng',
  jmc: 'jmc-latn-tz',
  jmd: 'jmd-latn-id',
  jmi: 'jmi-latn-ng',
  jml: 'jml-deva-np',
  jmn: 'jmn-latn-mm',
  jmr: 'jmr-latn-gh',
  jms: 'jms-latn-ng',
  jmw: 'jmw-latn-pg',
  jmx: 'jmx-latn-mx',
  jna: 'jna-takr-in',
  jnd: 'jnd-arab-pk',
  jng: 'jng-latn-au',
  jni: 'jni-latn-ng',
  jnj: 'jnj-latn-et',
  'jnj-ethi': 'jnj-ethi-et',
  jnl: 'jnl-deva-in',
  jns: 'jns-deva-in',
  'jns-latn': 'jns-latn-in',
  'jns-takr': 'jns-takr-in',
  job: 'job-latn-cd',
  jod: 'jod-latn-ci',
  jog: 'jog-arab-pk',
  jor: 'jor-latn-bo',
  jow: 'jow-latn-ml',
  jpa: 'jpa-hebr-ps',
  jpr: 'jpr-hebr-il',
  jqr: 'jqr-latn-pe',
  jra: 'jra-latn-zz',
  jrr: 'jrr-latn-ng',
  jrt: 'jrt-latn-ng',
  jru: 'jru-latn-ve',
  jua: 'jua-latn-br',
  jub: 'jub-latn-ng',
  jud: 'jud-latn-ci',
  juh: 'juh-latn-ng',
  jui: 'jui-latn-au',
  juk: 'juk-latn-ng',
  jul: 'jul-deva-np',
  jum: 'jum-latn-sd',
  jun: 'jun-orya-in',
  juo: 'juo-latn-ng',
  jup: 'jup-latn-br',
  jur: 'jur-latn-br',
  jut: 'jut-latn-dk',
  juu: 'juu-latn-ng',
  juw: 'juw-latn-ng',
  juy: 'juy-orya-in',
  jv: 'jv-latn-id',
  jvd: 'jvd-latn-id',
  jvn: 'jvn-latn-sr',
  jw: 'jw-latn-id',
  jwi: 'jwi-latn-gh',
  jya: 'jya-tibt-cn',
  jye: 'jye-hebr-il',
  jyy: 'jyy-latn-td',
  ka: 'ka-geor-ge',
  kaa: 'kaa-cyrl-uz',
  kab: 'kab-latn-dz',
  kac: 'kac-latn-mm',
  kad: 'kad-latn-zz',
  kag: 'kag-latn-my',
  kah: 'kah-latn-cf',
  kai: 'kai-latn-zz',
  kaj: 'kaj-latn-ng',
  kak: 'kak-latn-ph',
  kam: 'kam-latn-ke',
  kao: 'kao-latn-ml',
  kap: 'kap-cyrl-ru',
  kaq: 'kaq-latn-pe',
  kav: 'kav-latn-br',
  kaw: 'kaw-kawi-id',
  kax: 'kax-latn-id',
  kay: 'kay-latn-br',
  kba: 'kba-latn-au',
  kbb: 'kbb-latn-br',
  kbc: 'kbc-latn-br',
  kbd: 'kbd-cyrl-ru',
  kbe: 'kbe-latn-au',
  kbh: 'kbh-latn-co',
  kbi: 'kbi-latn-id',
  kbj: 'kbj-latn-cd',
  kbk: 'kbk-latn-pg',
  kbl: 'kbl-latn-td',
  kbm: 'kbm-latn-zz',
  kbn: 'kbn-latn-cf',
  kbo: 'kbo-latn-ss',
  kbp: 'kbp-latn-zz',
  kbq: 'kbq-latn-zz',
  kbr: 'kbr-latn-et',
  'kbr-ethi': 'kbr-ethi-et',
  kbs: 'kbs-latn-ga',
  kbt: 'kbt-latn-pg',
  kbu: 'kbu-arab-pk',
  kbv: 'kbv-latn-id',
  kbw: 'kbw-latn-pg',
  kbx: 'kbx-latn-zz',
  kby: 'kby-arab-ne',
  kbz: 'kbz-latn-ng',
  kca: 'kca-cyrl-ru',
  kcb: 'kcb-latn-pg',
  kcc: 'kcc-latn-ng',
  kcd: 'kcd-latn-id',
  kce: 'kce-latn-ng',
  kcf: 'kcf-latn-ng',
  kcg: 'kcg-latn-ng',
  kch: 'kch-latn-ng',
  kci: 'kci-latn-ng',
  kcj: 'kcj-latn-gw',
  kck: 'kck-latn-zw',
  kcl: 'kcl-latn-zz',
  kcm: 'kcm-latn-cf',
  kcn: 'kcn-latn-ug',
  kco: 'kco-latn-pg',
  kcp: 'kcp-latn-sd',
  kcq: 'kcq-latn-ng',
  kcs: 'kcs-latn-ng',
  kct: 'kct-latn-zz',
  kcu: 'kcu-latn-tz',
  kcv: 'kcv-latn-cd',
  kcw: 'kcw-latn-cd',
  kcz: 'kcz-latn-tz',
  kda: 'kda-latn-au',
  kdc: 'kdc-latn-tz',
  kdd: 'kdd-latn-au',
  kde: 'kde-latn-tz',
  kdf: 'kdf-latn-pg',
  kdg: 'kdg-latn-cd',
  kdh: 'kdh-latn-tg',
  kdi: 'kdi-latn-ug',
  kdj: 'kdj-latn-ug',
  kdk: 'kdk-latn-nc',
  kdl: 'kdl-latn-zz',
  kdm: 'kdm-latn-ng',
  kdn: 'kdn-latn-zw',
  kdp: 'kdp-latn-ng',
  kdq: 'kdq-beng-in',
  kdr: 'kdr-latn-lt',
  'kdr-cyrl': 'kdr-cyrl-ua',
  kdt: 'kdt-thai-th',
  kdw: 'kdw-latn-id',
  kdx: 'kdx-latn-ng',
  kdy: 'kdy-latn-id',
  kdz: 'kdz-latn-cm',
  kea: 'kea-latn-cv',
  keb: 'keb-latn-ga',
  kec: 'kec-latn-sd',
  ked: 'ked-latn-tz',
  kee: 'kee-latn-us',
  kef: 'kef-latn-tg',
  keg: 'keg-latn-sd',
  keh: 'keh-latn-pg',
  kei: 'kei-latn-id',
  kek: 'kek-latn-gt',
  kel: 'kel-latn-cd',
  kem: 'kem-latn-tl',
  ken: 'ken-latn-cm',
  keo: 'keo-latn-ug',
  ker: 'ker-latn-td',
  kes: 'kes-latn-ng',
  ket: 'ket-cyrl-ru',
  keu: 'keu-latn-tg',
  kew: 'kew-latn-pg',
  kex: 'kex-deva-in',
  'kex-gujr': 'kex-gujr-in',
  key: 'key-telu-in',
  kez: 'kez-latn-zz',
  kfa: 'kfa-knda-in',
  kfb: 'kfb-deva-in',
  kfc: 'kfc-telu-in',
  kfd: 'kfd-knda-in',
  kfe: 'kfe-taml-in',
  kff: 'kff-latn-in',
  'kff-deva': 'kff-deva-in',
  'kff-orya': 'kff-orya-in',
  'kff-telu': 'kff-telu-in',
  kfh: 'kfh-mlym-in',
  kfi: 'kfi-taml-in',
  'kfi-knda': 'kfi-knda-in',
  kfk: 'kfk-deva-in',
  'kfk-takr': 'kfk-takr-in',
  kfl: 'kfl-latn-cm',
  kfm: 'kfm-arab-ir',
  kfn: 'kfn-latn-cm',
  kfo: 'kfo-latn-ci',
  kfp: 'kfp-deva-in',
  kfq: 'kfq-deva-in',
  kfr: 'kfr-deva-in',
  kfs: 'kfs-deva-in',
  kfv: 'kfv-latn-in',
  kfw: 'kfw-latn-in',
  kfx: 'kfx-deva-in',
  'kfx-takr': 'kfx-takr-in',
  kfy: 'kfy-deva-in',
  kfz: 'kfz-latn-bf',
  kg: 'kg-latn-cd',
  kga: 'kga-latn-ci',
  kgb: 'kgb-latn-id',
  kge: 'kge-latn-id',
  kgf: 'kgf-latn-zz',
  kgj: 'kgj-deva-np',
  kgk: 'kgk-latn-br',
  kgl: 'kgl-latn-au',
  kgm: 'kgm-latn-br',
  kgo: 'kgo-latn-sd',
  kgp: 'kgp-latn-br',
  kgq: 'kgq-latn-id',
  kgr: 'kgr-latn-id',
  kgs: 'kgs-latn-au',
  kgt: 'kgt-latn-ng',
  kgu: 'kgu-latn-pg',
  kgv: 'kgv-latn-id',
  kgw: 'kgw-latn-id',
  kgx: 'kgx-latn-id',
  kgy: 'kgy-deva-np',
  kha: 'kha-latn-in',
  khb: 'khb-talu-cn',
  khc: 'khc-latn-id',
  khd: 'khd-latn-id',
  khe: 'khe-latn-id',
  khf: 'khf-thai-la',
  khg: 'khg-tibt-cn',
  khh: 'khh-latn-id',
  khj: 'khj-latn-ng',
  khl: 'khl-latn-pg',
  khn: 'khn-deva-in',
  khp: 'khp-latn-id',
  khq: 'khq-latn-ml',
  khr: 'khr-latn-in',
  'khr-deva': 'khr-deva-in',
  khs: 'khs-latn-zz',
  kht: 'kht-mymr-in',
  khu: 'khu-latn-ao',
  khv: 'khv-cyrl-ru',
  khw: 'khw-arab-pk',
  khx: 'khx-latn-cd',
  khy: 'khy-latn-cd',
  khz: 'khz-latn-zz',
  ki: 'ki-latn-ke',
  kia: 'kia-latn-td',
  kib: 'kib-latn-sd',
  kic: 'kic-latn-us',
  kid: 'kid-latn-cm',
  kie: 'kie-latn-td',
  kif: 'kif-deva-np',
  kig: 'kig-latn-id',
  kih: 'kih-latn-pg',
  kij: 'kij-latn-zz',
  kil: 'kil-latn-ng',
  kim: 'kim-cyrl-ru',
  kio: 'kio-latn-us',
  kip: 'kip-deva-np',
  kiq: 'kiq-latn-id',
  kis: 'kis-latn-pg',
  kit: 'kit-latn-pg',
  kiu: 'kiu-latn-tr',
  kiv: 'kiv-latn-tz',
  kiw: 'kiw-latn-zz',
  kix: 'kix-latn-in',
  kiy: 'kiy-latn-id',
  kiz: 'kiz-latn-tz',
  kj: 'kj-latn-na',
  kja: 'kja-latn-id',
  kjb: 'kjb-latn-gt',
  kjc: 'kjc-latn-id',
  kjd: 'kjd-latn-zz',
  kje: 'kje-latn-id',
  kjg: 'kjg-laoo-la',
  kjh: 'kjh-cyrl-ru',
  kji: 'kji-latn-sb',
  kjj: 'kjj-latn-az',
  kjk: 'kjk-latn-id',
  kjl: 'kjl-deva-np',
  kjm: 'kjm-latn-vn',
  kjn: 'kjn-latn-au',
  kjo: 'kjo-deva-in',
  kjp: 'kjp-mymr-mm',
  'kjp-thai': 'kjp-thai-th',
  kjq: 'kjq-latn-us',
  kjr: 'kjr-latn-id',
  kjs: 'kjs-latn-zz',
  kjt: 'kjt-thai-th',
  kju: 'kju-latn-us',
  kjx: 'kjx-latn-pg',
  kjy: 'kjy-latn-zz',
  kk: 'kk-cyrl-kz',
  'kk-af': 'kk-arab-af',
  'kk-arab': 'kk-arab-cn',
  'kk-cn': 'kk-arab-cn',
  'kk-ir': 'kk-arab-ir',
  'kk-mn': 'kk-arab-mn',
  kka: 'kka-latn-ng',
  kkb: 'kkb-latn-id',
  kkc: 'kkc-latn-zz',
  kkd: 'kkd-latn-ng',
  kke: 'kke-latn-gn',
  'kke-arab': 'kke-arab-gn',
  kkf: 'kkf-tibt-in',
  kkg: 'kkg-latn-ph',
  kkh: 'kkh-lana-mm',
  kki: 'kki-latn-tz',
  kkj: 'kkj-latn-cm',
  kkk: 'kkk-latn-sb',
  kkl: 'kkl-latn-id',
  kkm: 'kkm-latn-ng',
  kko: 'kko-latn-sd',
  kkp: 'kkp-latn-au',
  kkq: 'kkq-latn-cd',
  kkr: 'kkr-latn-ng',
  kks: 'kks-latn-ng',
  kkt: 'kkt-deva-np',
  kku: 'kku-latn-ng',
  kkv: 'kkv-latn-id',
  kkw: 'kkw-latn-cg',
  kkx: 'kkx-latn-id',
  kky: 'kky-latn-au',
  kkz: 'kkz-latn-ca',
  kl: 'kl-latn-gl',
  kla: 'kla-latn-us',
  klb: 'klb-latn-mx',
  klc: 'klc-latn-cm',
  kld: 'kld-latn-au',
  kle: 'kle-deva-np',
  klf: 'klf-latn-td',
  klg: 'klg-latn-ph',
  klh: 'klh-latn-pg',
  kli: 'kli-latn-id',
  klj: 'klj-arab-ir',
  klk: 'klk-latn-ng',
  kll: 'kll-latn-ph',
  klm: 'klm-latn-pg',
  kln: 'kln-latn-ke',
  klo: 'klo-latn-ng',
  klp: 'klp-latn-pg',
  klq: 'klq-latn-zz',
  klr: 'klr-deva-np',
  kls: 'kls-latn-pk',
  'kls-arab': 'kls-arab-pk',
  klt: 'klt-latn-zz',
  klu: 'klu-latn-lr',
  klv: 'klv-latn-vu',
  klw: 'klw-latn-id',
  klx: 'klx-latn-zz',
  kly: 'kly-latn-id',
  klz: 'klz-latn-id',
  km: 'km-khmr-kh',
  kma: 'kma-latn-gh',
  kmb: 'kmb-latn-ao',
  kmc: 'kmc-latn-cn',
  'kmc-hani': 'kmc-hani-cn',
  kmd: 'kmd-latn-ph',
  kme: 'kme-latn-cm',
  kmf: 'kmf-latn-pg',
  kmg: 'kmg-latn-pg',
  kmh: 'kmh-latn-zz',
  kmi: 'kmi-latn-ng',
  kmj: 'kmj-deva-in',
  kmk: 'kmk-latn-ph',
  kml: 'kml-latn-ph',
  kmm: 'kmm-latn-in',
  kmn: 'kmn-latn-pg',
  kmo: 'kmo-latn-zz',
  kmp: 'kmp-latn-cm',
  kmq: 'kmq-latn-et',
  kms: 'kms-latn-zz',
  kmt: 'kmt-latn-id',
  kmu: 'kmu-latn-zz',
  kmv: 'kmv-latn-br',
  kmw: 'kmw-latn-zz',
  kmx: 'kmx-latn-pg',
  kmy: 'kmy-latn-ng',
  kmz: 'kmz-arab-ir',
  kn: 'kn-knda-in',
  kna: 'kna-latn-ng',
  knb: 'knb-latn-ph',
  knd: 'knd-latn-id',
  kne: 'kne-latn-ph',
  knf: 'knf-latn-gw',
  kni: 'kni-latn-ng',
  knj: 'knj-latn-gt',
  knk: 'knk-latn-sl',
  'knk-arab': 'knk-arab-sl',
  knl: 'knl-latn-id',
  knm: 'knm-latn-br',
  kno: 'kno-latn-sl',
  knp: 'knp-latn-zz',
  knq: 'knq-latn-my',
  knr: 'knr-latn-pg',
  kns: 'kns-latn-my',
  'kns-thai': 'kns-thai-th',
  knt: 'knt-latn-br',
  knu: 'knu-latn-gn',
  knv: 'knv-latn-pg',
  knw: 'knw-latn-na',
  knx: 'knx-latn-id',
  kny: 'kny-latn-cd',
  knz: 'knz-latn-bf',
  ko: 'ko-kore-kr',
  koa: 'koa-latn-pg',
  koc: 'koc-latn-ng',
  kod: 'kod-latn-id',
  koe: 'koe-latn-ss',
  kof: 'kof-latn-ng',
  kog: 'kog-latn-co',
  koh: 'koh-latn-cg',
  koi: 'koi-cyrl-ru',
  kok: 'kok-deva-in',
  kol: 'kol-latn-zz',
  koo: 'koo-latn-ug',
  kop: 'kop-latn-pg',
  koq: 'koq-latn-ga',
  kos: 'kos-latn-fm',
  kot: 'kot-latn-cm',
  kou: 'kou-latn-td',
  kov: 'kov-latn-ng',
  kow: 'kow-latn-ng',
  koy: 'koy-latn-us',
  koz: 'koz-latn-zz',
  kpa: 'kpa-latn-ng',
  kpc: 'kpc-latn-co',
  kpd: 'kpd-latn-id',
  kpe: 'kpe-latn-lr',
  kpf: 'kpf-latn-zz',
  kpg: 'kpg-latn-fm',
  kph: 'kph-latn-gh',
  kpi: 'kpi-latn-id',
  kpj: 'kpj-latn-br',
  kpk: 'kpk-latn-ng',
  kpl: 'kpl-latn-cd',
  kpm: 'kpm-latn-vn',
  kpn: 'kpn-latn-br',
  kpo: 'kpo-latn-zz',
  kpq: 'kpq-latn-id',
  kpr: 'kpr-latn-zz',
  kps: 'kps-latn-id',
  kpt: 'kpt-cyrl-ru',
  kpu: 'kpu-latn-id',
  kpw: 'kpw-latn-pg',
  kpx: 'kpx-latn-zz',
  kpy: 'kpy-cyrl-ru',
  kpz: 'kpz-latn-ug',
  kqa: 'kqa-latn-pg',
  kqb: 'kqb-latn-zz',
  kqc: 'kqc-latn-pg',
  kqd: 'kqd-syrc-iq',
  kqe: 'kqe-latn-ph',
  kqf: 'kqf-latn-zz',
  kqg: 'kqg-latn-bf',
  kqh: 'kqh-latn-tz',
  kqi: 'kqi-latn-pg',
  kqj: 'kqj-latn-pg',
  kqk: 'kqk-latn-bj',
  kql: 'kql-latn-pg',
  kqm: 'kqm-latn-ci',
  kqn: 'kqn-latn-zm',
  kqo: 'kqo-latn-lr',
  kqp: 'kqp-latn-td',
  kqq: 'kqq-latn-br',
  kqr: 'kqr-latn-my',
  kqs: 'kqs-latn-zz',
  kqt: 'kqt-latn-my',
  kqu: 'kqu-latn-za',
  kqv: 'kqv-latn-id',
  kqw: 'kqw-latn-pg',
  kqx: 'kqx-latn-cm',
  kqy: 'kqy-ethi-zz',
  kqz: 'kqz-latn-za',
  kr: 'kr-latn-zz',
  kra: 'kra-deva-np',
  krb: 'krb-latn-us',
  krc: 'krc-cyrl-ru',
  krd: 'krd-latn-tl',
  kre: 'kre-latn-br',
  krf: 'krf-latn-vu',
  krh: 'krh-latn-ng',
  kri: 'kri-latn-sl',
  krj: 'krj-latn-ph',
  krk: 'krk-cyrl-ru',
  krl: 'krl-latn-ru',
  krn: 'krn-latn-lr',
  krp: 'krp-latn-ng',
  krr: 'krr-khmr-kh',
  krs: 'krs-latn-zz',
  krt: 'krt-latn-ne',
  kru: 'kru-deva-in',
  krv: 'krv-khmr-kh',
  krw: 'krw-latn-lr',
  krx: 'krx-latn-sn',
  kry: 'kry-latn-az',
  krz: 'krz-latn-id',
  ks: 'ks-arab-in',
  ksa: 'ksa-latn-ng',
  ksb: 'ksb-latn-tz',
  ksc: 'ksc-latn-ph',
  ksd: 'ksd-latn-zz',
  kse: 'kse-latn-pg',
  ksf: 'ksf-latn-cm',
  ksg: 'ksg-latn-sb',
  ksh: 'ksh-latn-de',
  ksi: 'ksi-latn-pg',
  ksj: 'ksj-latn-zz',
  ksk: 'ksk-latn-us',
  ksl: 'ksl-latn-pg',
  ksm: 'ksm-latn-ng',
  ksn: 'ksn-latn-ph',
  kso: 'kso-latn-ng',
  ksp: 'ksp-latn-cf',
  ksq: 'ksq-latn-ng',
  ksr: 'ksr-latn-zz',
  kss: 'kss-latn-lr',
  kst: 'kst-latn-bf',
  ksu: 'ksu-mymr-in',
  ksv: 'ksv-latn-cd',
  ksw: 'ksw-mymr-mm',
  'ksw-latn': 'ksw-latn-mm',
  ksx: 'ksx-latn-id',
  ksz: 'ksz-deva-in',
  kta: 'kta-latn-vn',
  ktb: 'ktb-ethi-zz',
  ktc: 'ktc-latn-ng',
  ktd: 'ktd-latn-au',
  ktf: 'ktf-latn-cd',
  ktg: 'ktg-latn-au',
  kth: 'kth-latn-td',
  kti: 'kti-latn-id',
  ktj: 'ktj-latn-ci',
  ktk: 'ktk-latn-pg',
  ktl: 'ktl-arab-ir',
  ktm: 'ktm-latn-zz',
  ktn: 'ktn-latn-br',
  kto: 'kto-latn-zz',
  ktp: 'ktp-plrd-cn',
  ktq: 'ktq-latn-ph',
  ktr: 'ktr-latn-my',
  kts: 'kts-latn-id',
  ktt: 'ktt-latn-id',
  ktu: 'ktu-latn-cd',
  ktv: 'ktv-latn-vn',
  ktw: 'ktw-latn-us',
  ktx: 'ktx-latn-br',
  kty: 'kty-latn-cd',
  ktz: 'ktz-latn-na',
  ku: 'ku-latn-tr',
  'ku-arab': 'ku-arab-iq',
  'ku-lb': 'ku-arab-lb',
  'ku-yezi': 'ku-yezi-ge',
  kub: 'kub-latn-zz',
  kuc: 'kuc-latn-id',
  kud: 'kud-latn-zz',
  kue: 'kue-latn-zz',
  kuf: 'kuf-laoo-la',
  kug: 'kug-latn-ng',
  kuh: 'kuh-latn-ng',
  kui: 'kui-latn-br',
  kuj: 'kuj-latn-zz',
  kuk: 'kuk-latn-id',
  kul: 'kul-latn-ng',
  kum: 'kum-cyrl-ru',
  kun: 'kun-latn-zz',
  kuo: 'kuo-latn-pg',
  kup: 'kup-latn-zz',
  kuq: 'kuq-latn-br',
  kus: 'kus-latn-zz',
  kut: 'kut-latn-ca',
  kuu: 'kuu-latn-us',
  kuv: 'kuv-latn-id',
  kuw: 'kuw-latn-cf',
  kux: 'kux-latn-au',
  kuy: 'kuy-latn-au',
  kuz: 'kuz-latn-cl',
  kv: 'kv-cyrl-ru',
  kva: 'kva-cyrl-ru',
  kvb: 'kvb-latn-id',
  kvc: 'kvc-latn-pg',
  kvd: 'kvd-latn-id',
  kve: 'kve-latn-my',
  kvf: 'kvf-latn-td',
  kvg: 'kvg-latn-zz',
  kvh: 'kvh-latn-id',
  kvi: 'kvi-latn-td',
  kvj: 'kvj-latn-cm',
  kvl: 'kvl-latn-mm',
  kvm: 'kvm-latn-cm',
  kvn: 'kvn-latn-co',
  kvo: 'kvo-latn-id',
  kvp: 'kvp-latn-id',
  kvq: 'kvq-mymr-mm',
  'kvq-latn': 'kvq-latn-mm',
  kvr: 'kvr-latn-id',
  kvt: 'kvt-mymr-mm',
  kvv: 'kvv-latn-id',
  kvw: 'kvw-latn-id',
  kvx: 'kvx-arab-pk',
  kvy: 'kvy-kali-mm',
  kvz: 'kvz-latn-id',
  kw: 'kw-latn-gb',
  kwa: 'kwa-latn-br',
  kwb: 'kwb-latn-ng',
  kwc: 'kwc-latn-cg',
  kwd: 'kwd-latn-sb',
  kwe: 'kwe-latn-id',
  kwf: 'kwf-latn-sb',
  kwg: 'kwg-latn-td',
  kwh: 'kwh-latn-id',
  kwi: 'kwi-latn-co',
  kwj: 'kwj-latn-zz',
  kwk: 'kwk-latn-ca',
  kwl: 'kwl-latn-ng',
  kwm: 'kwm-latn-na',
  kwn: 'kwn-latn-na',
  kwo: 'kwo-latn-zz',
  kwp: 'kwp-latn-ci',
  kwq: 'kwq-latn-zz',
  kwr: 'kwr-latn-id',
  kws: 'kws-latn-cd',
  kwt: 'kwt-latn-id',
  kwu: 'kwu-latn-cm',
  kwv: 'kwv-latn-td',
  kww: 'kww-latn-sr',
  kwy: 'kwy-latn-cd',
  kwz: 'kwz-latn-ao',
  kxa: 'kxa-latn-zz',
  kxb: 'kxb-latn-ci',
  kxc: 'kxc-ethi-zz',
  kxd: 'kxd-latn-bn',
  'kxd-arab': 'kxd-arab-bn',
  kxe: 'kxe-latn-zz',
  kxf: 'kxf-mymr-mm',
  'kxf-latn': 'kxf-latn-mm',
  kxi: 'kxi-latn-my',
  kxj: 'kxj-latn-td',
  kxk: 'kxk-mymr-mm',
  kxl: 'kxl-deva-in',
  kxm: 'kxm-thai-th',
  kxn: 'kxn-latn-my',
  kxo: 'kxo-latn-br',
  kxp: 'kxp-arab-pk',
  kxq: 'kxq-latn-id',
  kxr: 'kxr-latn-pg',
  kxt: 'kxt-latn-pg',
  kxv: 'kxv-orya-in',
  'kxv-latn': 'kxv-latn-in',
  'kxv-telu': 'kxv-telu-in',
  kxw: 'kxw-latn-zz',
  kxx: 'kxx-latn-cg',
  kxy: 'kxy-latn-vn',
  kxz: 'kxz-latn-zz',
  ky: 'ky-cyrl-kg',
  'ky-arab': 'ky-arab-cn',
  'ky-cn': 'ky-arab-cn',
  'ky-latn': 'ky-latn-tr',
  'ky-tr': 'ky-latn-tr',
  kya: 'kya-latn-tz',
  kyb: 'kyb-latn-ph',
  kyc: 'kyc-latn-pg',
  kyd: 'kyd-latn-id',
  kye: 'kye-latn-zz',
  kyf: 'kyf-latn-ci',
  kyg: 'kyg-latn-pg',
  kyh: 'kyh-latn-us',
  kyi: 'kyi-latn-my',
  kyj: 'kyj-latn-ph',
  kyk: 'kyk-latn-ph',
  kyl: 'kyl-latn-us',
  kym: 'kym-latn-cf',
  kyn: 'kyn-latn-ph',
  kyo: 'kyo-latn-id',
  kyq: 'kyq-latn-td',
  kyr: 'kyr-latn-br',
  kys: 'kys-latn-my',
  kyt: 'kyt-latn-id',
  kyu: 'kyu-kali-mm',
  'kyu-latn': 'kyu-latn-mm',
  'kyu-mymr': 'kyu-mymr-mm',
  kyv: 'kyv-deva-np',
  kyw: 'kyw-deva-in',
  'kyw-beng': 'kyw-beng-in',
  'kyw-orya': 'kyw-orya-in',
  kyx: 'kyx-latn-zz',
  kyy: 'kyy-latn-pg',
  kyz: 'kyz-latn-br',
  kza: 'kza-latn-bf',
  kzb: 'kzb-latn-id',
  kzc: 'kzc-latn-ci',
  kzd: 'kzd-latn-id',
  kze: 'kze-latn-pg',
  kzf: 'kzf-latn-id',
  kzh: 'kzh-arab-zz',
  kzi: 'kzi-latn-my',
  kzj: 'kzj-latn-my',
  kzk: 'kzk-latn-sb',
  kzl: 'kzl-latn-id',
  kzm: 'kzm-latn-id',
  kzn: 'kzn-latn-mw',
  kzo: 'kzo-latn-ga',
  kzp: 'kzp-latn-id',
  kzr: 'kzr-latn-zz',
  kzs: 'kzs-latn-my',
  kzt: 'kzt-latn-my',
  kzu: 'kzu-latn-id',
  kzv: 'kzv-latn-id',
  kzw: 'kzw-latn-br',
  kzx: 'kzx-latn-id',
  kzy: 'kzy-latn-cd',
  kzz: 'kzz-latn-id',
  la: 'la-latn-va',
  laa: 'laa-latn-ph',
  lab: 'lab-lina-gr',
  lac: 'lac-latn-mx',
  lad: 'lad-hebr-il',
  lae: 'lae-deva-in',
  'lae-tibt': 'lae-tibt-in',
  lag: 'lag-latn-tz',
  lah: 'lah-arab-pk',
  lai: 'lai-latn-mw',
  laj: 'laj-latn-ug',
  lal: 'lal-latn-cd',
  lam: 'lam-latn-zm',
  lan: 'lan-latn-ng',
  lap: 'lap-latn-td',
  laq: 'laq-latn-vn',
  lar: 'lar-latn-gh',
  las: 'las-latn-zz',
  lau: 'lau-latn-id',
  law: 'law-latn-id',
  lax: 'lax-latn-in',
  'lax-beng': 'lax-beng-in',
  laz: 'laz-latn-pg',
  lb: 'lb-latn-lu',
  lbb: 'lbb-latn-pg',
  lbc: 'lbc-lisu-cn',
  lbe: 'lbe-cyrl-ru',
  lbf: 'lbf-deva-in',
  'lbf-tibt': 'lbf-tibt-cn',
  lbi: 'lbi-latn-cm',
  lbj: 'lbj-tibt-in',
  'lbj-arab': 'lbj-arab-in',
  lbl: 'lbl-latn-ph',
  lbm: 'lbm-deva-in',
  lbn: 'lbn-latn-la',
  'lbn-laoo': 'lbn-laoo-la',
  lbo: 'lbo-laoo-la',
  'lbo-latn': 'lbo-latn-us',
  lbq: 'lbq-latn-pg',
  lbr: 'lbr-deva-np',
  lbt: 'lbt-latn-vn',
  lbu: 'lbu-latn-zz',
  lbv: 'lbv-latn-pg',
  lbw: 'lbw-latn-id',
  lbx: 'lbx-latn-id',
  lby: 'lby-latn-au',
  lbz: 'lbz-latn-au',
  lcc: 'lcc-latn-id',
  lcd: 'lcd-latn-id',
  lce: 'lce-latn-id',
  lcf: 'lcf-latn-id',
  lch: 'lch-latn-ao',
  lcl: 'lcl-latn-id',
  lcm: 'lcm-latn-zz',
  lcp: 'lcp-thai-cn',
  lcq: 'lcq-latn-id',
  lcs: 'lcs-latn-id',
  lda: 'lda-latn-ci',
  ldb: 'ldb-latn-zz',
  ldd: 'ldd-latn-ng',
  ldg: 'ldg-latn-ng',
  ldh: 'ldh-latn-ng',
  ldi: 'ldi-latn-cg',
  ldj: 'ldj-latn-ng',
  ldk: 'ldk-latn-ng',
  ldl: 'ldl-latn-ng',
  ldm: 'ldm-latn-gn',
  ldn: 'ldn-latn-001',
  ldo: 'ldo-latn-ng',
  ldp: 'ldp-latn-ng',
  ldq: 'ldq-latn-ng',
  lea: 'lea-latn-cd',
  leb: 'leb-latn-zm',
  lec: 'lec-latn-bo',
  led: 'led-latn-zz',
  lee: 'lee-latn-zz',
  lef: 'lef-latn-gh',
  leh: 'leh-latn-zm',
  lei: 'lei-latn-pg',
  lej: 'lej-latn-cd',
  lek: 'lek-latn-pg',
  lel: 'lel-latn-cd',
  lem: 'lem-latn-zz',
  len: 'len-latn-hn',
  leo: 'leo-latn-cm',
  lep: 'lep-lepc-in',
  leq: 'leq-latn-zz',
  ler: 'ler-latn-pg',
  les: 'les-latn-cd',
  let: 'let-latn-pg',
  leu: 'leu-latn-zz',
  lev: 'lev-latn-id',
  lew: 'lew-latn-id',
  lex: 'lex-latn-id',
  ley: 'ley-latn-id',
  lez: 'lez-cyrl-ru',
  lfa: 'lfa-latn-cm',
  lfn: 'lfn-latn-001',
  'lfn-cyrl': 'lfn-cyrl-001',
  lg: 'lg-latn-ug',
  lga: 'lga-latn-sb',
  lgb: 'lgb-latn-sb',
  lgg: 'lgg-latn-zz',
  lgh: 'lgh-latn-vn',
  lgi: 'lgi-latn-id',
  lgk: 'lgk-latn-vu',
  lgl: 'lgl-latn-sb',
  lgm: 'lgm-latn-cd',
  lgn: 'lgn-latn-et',
  lgo: 'lgo-latn-ss',
  lgq: 'lgq-latn-gh',
  lgr: 'lgr-latn-sb',
  lgt: 'lgt-latn-pg',
  lgu: 'lgu-latn-sb',
  lgz: 'lgz-latn-cd',
  lha: 'lha-latn-vn',
  lhh: 'lhh-latn-id',
  lhi: 'lhi-latn-cn',
  lhm: 'lhm-deva-np',
  lhn: 'lhn-latn-my',
  lhs: 'lhs-syrc-sy',
  lht: 'lht-latn-vu',
  lhu: 'lhu-latn-cn',
  li: 'li-latn-nl',
  lia: 'lia-latn-zz',
  lib: 'lib-latn-pg',
  lic: 'lic-latn-cn',
  lid: 'lid-latn-zz',
  lie: 'lie-latn-cd',
  lif: 'lif-deva-np',
  'lif-limb': 'lif-limb-in',
  lig: 'lig-latn-zz',
  lih: 'lih-latn-zz',
  lij: 'lij-latn-it',
  lik: 'lik-latn-cd',
  lil: 'lil-latn-ca',
  lio: 'lio-latn-id',
  lip: 'lip-latn-gh',
  liq: 'liq-latn-et',
  lir: 'lir-latn-lr',
  lis: 'lis-lisu-cn',
  liu: 'liu-latn-sd',
  liv: 'liv-latn-lv',
  liw: 'liw-latn-id',
  lix: 'lix-latn-id',
  liy: 'liy-latn-cf',
  liz: 'liz-latn-cd',
  lja: 'lja-latn-au',
  lje: 'lje-latn-id',
  lji: 'lji-latn-id',
  ljl: 'ljl-latn-id',
  ljp: 'ljp-latn-id',
  ljw: 'ljw-latn-au',
  ljx: 'ljx-latn-au',
  lka: 'lka-latn-tl',
  lkb: 'lkb-latn-ke',
  lkc: 'lkc-latn-vn',
  lkd: 'lkd-latn-br',
  lke: 'lke-latn-ug',
  lkh: 'lkh-tibt-bt',
  lki: 'lki-arab-ir',
  lkj: 'lkj-latn-my',
  lkl: 'lkl-latn-pg',
  lkm: 'lkm-latn-au',
  lkn: 'lkn-latn-vu',
  lko: 'lko-latn-ke',
  lkr: 'lkr-latn-ss',
  lks: 'lks-latn-ke',
  lkt: 'lkt-latn-us',
  lku: 'lku-latn-au',
  lky: 'lky-latn-ss',
  lla: 'lla-latn-ng',
  llb: 'llb-latn-mz',
  llc: 'llc-latn-gn',
  lld: 'lld-latn-it',
  lle: 'lle-latn-zz',
  llf: 'llf-latn-pg',
  llg: 'llg-latn-id',
  lli: 'lli-latn-cg',
  llj: 'llj-latn-au',
  llk: 'llk-latn-my',
  lll: 'lll-latn-pg',
  llm: 'llm-latn-id',
  lln: 'lln-latn-zz',
  llp: 'llp-latn-vu',
  llq: 'llq-latn-id',
  llu: 'llu-latn-sb',
  llx: 'llx-latn-fj',
  lma: 'lma-latn-gn',
  lmb: 'lmb-latn-vu',
  lmc: 'lmc-latn-au',
  lmd: 'lmd-latn-sd',
  lme: 'lme-latn-td',
  lmf: 'lmf-latn-id',
  lmg: 'lmg-latn-pg',
  lmh: 'lmh-deva-np',
  lmi: 'lmi-latn-cd',
  lmj: 'lmj-latn-id',
  lmk: 'lmk-latn-in',
  'lmk-mymr': 'lmk-mymr-in',
  lml: 'lml-latn-vu',
  lmn: 'lmn-telu-in',
  lmo: 'lmo-latn-it',
  lmp: 'lmp-latn-zz',
  lmq: 'lmq-latn-id',
  lmr: 'lmr-latn-id',
  lmu: 'lmu-latn-vu',
  lmv: 'lmv-latn-fj',
  lmw: 'lmw-latn-us',
  lmx: 'lmx-latn-cm',
  lmy: 'lmy-latn-id',
  ln: 'ln-latn-cd',
  lna: 'lna-latn-cf',
  lnb: 'lnb-latn-na',
  lnd: 'lnd-latn-id',
  lnh: 'lnh-latn-my',
  lni: 'lni-latn-pg',
  lnj: 'lnj-latn-au',
  lnl: 'lnl-latn-cf',
  lnm: 'lnm-latn-pg',
  lnn: 'lnn-latn-vu',
  lns: 'lns-latn-zz',
  lnu: 'lnu-latn-zz',
  lnw: 'lnw-latn-au',
  lnz: 'lnz-latn-cd',
  lo: 'lo-laoo-la',
  loa: 'loa-latn-id',
  lob: 'lob-latn-bf',
  loc: 'loc-latn-ph',
  loe: 'loe-latn-id',
  log: 'log-latn-cd',
  loh: 'loh-latn-ss',
  loi: 'loi-latn-ci',
  loj: 'loj-latn-zz',
  lok: 'lok-latn-zz',
  lol: 'lol-latn-cd',
  lom: 'lom-latn-lr',
  lon: 'lon-latn-mw',
  loo: 'loo-latn-cd',
  lop: 'lop-latn-ng',
  loq: 'loq-latn-cd',
  lor: 'lor-latn-zz',
  los: 'los-latn-zz',
  lot: 'lot-latn-ss',
  'lot-arab': 'lot-arab-ss',
  lou: 'lou-latn-us',
  low: 'low-latn-my',
  lox: 'lox-latn-id',
  loy: 'loy-deva-np',
  'loy-tibt': 'loy-tibt-np',
  loz: 'loz-latn-zm',
  lpa: 'lpa-latn-vu',
  lpe: 'lpe-latn-id',
  lpn: 'lpn-latn-mm',
  lpo: 'lpo-plrd-cn',
  'lpo-lisu': 'lpo-lisu-cn',
  lpx: 'lpx-latn-ss',
  lqr: 'lqr-latn-ss',
  lra: 'lra-latn-my',
  lrc: 'lrc-arab-ir',
  lrg: 'lrg-latn-au',
  lri: 'lri-latn-ke',
  lrk: 'lrk-arab-pk',
  lrl: 'lrl-arab-ir',
  lrm: 'lrm-latn-ke',
  lrn: 'lrn-latn-id',
  lro: 'lro-latn-sd',
  lrt: 'lrt-latn-id',
  lrv: 'lrv-latn-vu',
  lrz: 'lrz-latn-vu',
  lsa: 'lsa-arab-ir',
  lsd: 'lsd-hebr-il',
  lse: 'lse-latn-cd',
  lsi: 'lsi-latn-mm',
  lsm: 'lsm-latn-ug',
  lsr: 'lsr-latn-pg',
  lss: 'lss-arab-pk',
  lt: 'lt-latn-lt',
  ltg: 'ltg-latn-lv',
  lth: 'lth-latn-ug',
  lti: 'lti-latn-id',
  ltn: 'ltn-latn-br',
  lto: 'lto-latn-ke',
  lts: 'lts-latn-ke',
  ltu: 'ltu-latn-id',
  lu: 'lu-latn-cd',
  lua: 'lua-latn-cd',
  luc: 'luc-latn-ug',
  lud: 'lud-latn-ru',
  lue: 'lue-latn-zm',
  luf: 'luf-latn-pg',
  lui: 'lui-latn-us',
  luj: 'luj-latn-cd',
  luk: 'luk-tibt-bt',
  lul: 'lul-latn-ss',
  lum: 'lum-latn-ao',
  lun: 'lun-latn-zm',
  luo: 'luo-latn-ke',
  lup: 'lup-latn-ga',
  luq: 'luq-latn-cu',
  lur: 'lur-latn-id',
  lus: 'lus-latn-in',
  'lus-beng': 'lus-beng-bd',
  'lus-brai': 'lus-brai-in',
  lut: 'lut-latn-us',
  luu: 'luu-deva-np',
  luv: 'luv-arab-om',
  luw: 'luw-latn-cm',
  luy: 'luy-latn-ke',
  luz: 'luz-arab-ir',
  lv: 'lv-latn-lv',
  lva: 'lva-latn-tl',
  lvi: 'lvi-latn-la',
  lvk: 'lvk-latn-sb',
  lvu: 'lvu-latn-id',
  lwa: 'lwa-latn-cd',
  lwe: 'lwe-latn-id',
  lwg: 'lwg-latn-ke',
  lwh: 'lwh-latn-vn',
  lwl: 'lwl-thai-th',
  lwm: 'lwm-thai-cn',
  lwo: 'lwo-latn-ss',
  'lwo-za': 'lwo-latn-za',
  lwt: 'lwt-latn-id',
  lww: 'lww-latn-vu',
  lxm: 'lxm-latn-pg',
  lya: 'lya-tibt-bt',
  lyn: 'lyn-latn-zm',
  lzh: 'lzh-hans-cn',
  lzl: 'lzl-latn-vu',
  lzn: 'lzn-latn-mm',
  lzz: 'lzz-latn-tr',
  maa: 'maa-latn-mx',
  mab: 'mab-latn-mx',
  mad: 'mad-latn-id',
  mae: 'mae-latn-ng',
  maf: 'maf-latn-cm',
  mag: 'mag-deva-in',
  mai: 'mai-deva-in',
  maj: 'maj-latn-mx',
  mak: 'mak-latn-id',
  mam: 'mam-latn-gt',
  man: 'man-latn-gm',
  'man-gn': 'man-nkoo-gn',
  'man-nkoo': 'man-nkoo-gn',
  maq: 'maq-latn-mx',
  mas: 'mas-latn-ke',
  mat: 'mat-latn-mx',
  mau: 'mau-latn-mx',
  mav: 'mav-latn-br',
  maw: 'maw-latn-zz',
  max: 'max-latn-id',
  maz: 'maz-latn-mx',
  mba: 'mba-latn-ph',
  mbb: 'mbb-latn-ph',
  mbc: 'mbc-latn-br',
  mbd: 'mbd-latn-ph',
  mbf: 'mbf-latn-sg',
  mbh: 'mbh-latn-zz',
  mbi: 'mbi-latn-ph',
  mbj: 'mbj-latn-br',
  mbk: 'mbk-latn-pg',
  mbl: 'mbl-latn-br',
  mbm: 'mbm-latn-cg',
  mbn: 'mbn-latn-co',
  mbo: 'mbo-latn-zz',
  mbp: 'mbp-latn-co',
  mbq: 'mbq-latn-zz',
  mbr: 'mbr-latn-co',
  mbs: 'mbs-latn-ph',
  mbt: 'mbt-latn-ph',
  mbu: 'mbu-latn-zz',
  mbv: 'mbv-latn-gn',
  mbw: 'mbw-latn-zz',
  mbx: 'mbx-latn-pg',
  mby: 'mby-arab-pk',
  mbz: 'mbz-latn-mx',
  mca: 'mca-latn-py',
  mcb: 'mcb-latn-pe',
  mcc: 'mcc-latn-pg',
  mcd: 'mcd-latn-pe',
  mce: 'mce-latn-mx',
  mcf: 'mcf-latn-pe',
  mcg: 'mcg-latn-ve',
  mch: 'mch-latn-ve',
  mci: 'mci-latn-zz',
  mcj: 'mcj-latn-ng',
  mck: 'mck-latn-ao',
  mcl: 'mcl-latn-co',
  mcm: 'mcm-latn-my',
  mcn: 'mcn-latn-td',
  mco: 'mco-latn-mx',
  mcp: 'mcp-latn-zz',
  mcq: 'mcq-latn-zz',
  mcr: 'mcr-latn-zz',
  mcs: 'mcs-latn-cm',
  mct: 'mct-latn-cm',
  mcu: 'mcu-latn-zz',
  mcv: 'mcv-latn-pg',
  mcw: 'mcw-latn-td',
  mcx: 'mcx-latn-cf',
  mcy: 'mcy-latn-pg',
  mcz: 'mcz-latn-pg',
  mda: 'mda-latn-zz',
  mdb: 'mdb-latn-pg',
  mdc: 'mdc-latn-pg',
  mdd: 'mdd-latn-cm',
  mde: 'mde-arab-zz',
  mdf: 'mdf-cyrl-ru',
  mdg: 'mdg-latn-td',
  mdh: 'mdh-latn-ph',
  mdi: 'mdi-latn-cd',
  mdj: 'mdj-latn-zz',
  mdk: 'mdk-latn-cd',
  mdm: 'mdm-latn-cd',
  mdn: 'mdn-latn-cf',
  mdp: 'mdp-latn-cd',
  mdq: 'mdq-latn-cd',
  mdr: 'mdr-latn-id',
  mds: 'mds-latn-pg',
  mdt: 'mdt-latn-cg',
  mdu: 'mdu-latn-cg',
  mdv: 'mdv-latn-mx',
  mdw: 'mdw-latn-cg',
  mdx: 'mdx-ethi-zz',
  mdy: 'mdy-ethi-et',
  'mdy-latn': 'mdy-latn-et',
  mdz: 'mdz-latn-br',
  mea: 'mea-latn-cm',
  meb: 'meb-latn-pg',
  mec: 'mec-latn-au',
  med: 'med-latn-zz',
  mee: 'mee-latn-zz',
  meh: 'meh-latn-mx',
  mej: 'mej-latn-id',
  mek: 'mek-latn-zz',
  mel: 'mel-latn-my',
  mem: 'mem-latn-au',
  men: 'men-latn-sl',
  meo: 'meo-latn-my',
  'meo-arab': 'meo-arab-my',
  mep: 'mep-latn-au',
  meq: 'meq-latn-cm',
  mer: 'mer-latn-ke',
  mes: 'mes-latn-td',
  met: 'met-latn-zz',
  meu: 'meu-latn-zz',
  mev: 'mev-latn-lr',
  mew: 'mew-latn-ng',
  mey: 'mey-latn-mr',
  'mey-arab': 'mey-arab-mr',
  mez: 'mez-latn-us',
  mfa: 'mfa-arab-th',
  mfb: 'mfb-latn-id',
  mfc: 'mfc-latn-cd',
  mfd: 'mfd-latn-cm',
  mfe: 'mfe-latn-mu',
  mff: 'mff-latn-cm',
  mfg: 'mfg-latn-gn',
  'mfg-arab': 'mfg-arab-gn',
  mfh: 'mfh-latn-cm',
  mfi: 'mfi-arab-cm',
  'mfi-latn': 'mfi-latn-cm',
  mfj: 'mfj-latn-cm',
  mfk: 'mfk-latn-cm',
  mfl: 'mfl-latn-ng',
  mfm: 'mfm-latn-ng',
  mfn: 'mfn-latn-zz',
  mfo: 'mfo-latn-zz',
  mfp: 'mfp-latn-id',
  mfq: 'mfq-latn-zz',
  mfr: 'mfr-latn-au',
  mft: 'mft-latn-pg',
  mfu: 'mfu-latn-ao',
  mfv: 'mfv-latn-gw',
  mfw: 'mfw-latn-pg',
  mfx: 'mfx-latn-et',
  'mfx-ethi': 'mfx-ethi-et',
  mfy: 'mfy-latn-mx',
  mfz: 'mfz-latn-ss',
  mg: 'mg-latn-mg',
  mgb: 'mgb-latn-td',
  mgc: 'mgc-latn-ss',
  mgd: 'mgd-latn-ss',
  'mgd-arab': 'mgd-arab-ss',
  mge: 'mge-latn-td',
  mgf: 'mgf-latn-id',
  mgg: 'mgg-latn-cm',
  mgh: 'mgh-latn-mz',
  mgi: 'mgi-latn-ng',
  mgj: 'mgj-latn-ng',
  mgk: 'mgk-latn-id',
  mgl: 'mgl-latn-zz',
  mgm: 'mgm-latn-tl',
  mgn: 'mgn-latn-cf',
  mgo: 'mgo-latn-cm',
  mgp: 'mgp-deva-np',
  mgq: 'mgq-latn-tz',
  mgr: 'mgr-latn-zm',
  mgs: 'mgs-latn-tz',
  mgt: 'mgt-latn-pg',
  mgu: 'mgu-latn-pg',
  mgv: 'mgv-latn-tz',
  mgw: 'mgw-latn-tz',
  mgy: 'mgy-latn-tz',
  mgz: 'mgz-latn-tz',
  mh: 'mh-latn-mh',
  mhb: 'mhb-latn-ga',
  mhc: 'mhc-latn-mx',
  mhd: 'mhd-latn-tz',
  mhe: 'mhe-latn-my',
  mhf: 'mhf-latn-pg',
  mhg: 'mhg-latn-au',
  mhi: 'mhi-latn-zz',
  mhj: 'mhj-arab-af',
  mhk: 'mhk-latn-cm',
  mhl: 'mhl-latn-zz',
  mhm: 'mhm-latn-mz',
  mhn: 'mhn-latn-it',
  mho: 'mho-latn-zm',
  mhp: 'mhp-latn-id',
  mhq: 'mhq-latn-us',
  mhs: 'mhs-latn-id',
  mht: 'mht-latn-ve',
  mhu: 'mhu-latn-in',
  mhw: 'mhw-latn-bw',
  mhx: 'mhx-latn-mm',
  mhy: 'mhy-latn-id',
  mhz: 'mhz-latn-id',
  mi: 'mi-latn-nz',
  mia: 'mia-latn-us',
  mib: 'mib-latn-mx',
  mic: 'mic-latn-ca',
  mid: 'mid-mand-iq',
  mie: 'mie-latn-mx',
  mif: 'mif-latn-zz',
  mig: 'mig-latn-mx',
  mih: 'mih-latn-mx',
  mii: 'mii-latn-mx',
  mij: 'mij-latn-cm',
  mik: 'mik-latn-us',
  mil: 'mil-latn-mx',
  mim: 'mim-latn-mx',
  min: 'min-latn-id',
  mio: 'mio-latn-mx',
  mip: 'mip-latn-mx',
  miq: 'miq-latn-ni',
  mir: 'mir-latn-mx',
  mit: 'mit-latn-mx',
  miu: 'miu-latn-mx',
  miw: 'miw-latn-zz',
  mix: 'mix-latn-mx',
  miy: 'miy-latn-mx',
  miz: 'miz-latn-mx',
  mjb: 'mjb-latn-tl',
  mjc: 'mjc-latn-mx',
  mjd: 'mjd-latn-us',
  mje: 'mje-latn-td',
  mjg: 'mjg-latn-cn',
  mjh: 'mjh-latn-tz',
  mji: 'mji-latn-cn',
  mjj: 'mjj-latn-pg',
  mjk: 'mjk-latn-pg',
  mjl: 'mjl-deva-in',
  'mjl-takr': 'mjl-takr-in',
  mjm: 'mjm-latn-pg',
  mjn: 'mjn-latn-pg',
  mjq: 'mjq-mlym-in',
  mjr: 'mjr-mlym-in',
  mjs: 'mjs-latn-ng',
  mjt: 'mjt-deva-in',
  'mjt-beng': 'mjt-beng-bd',
  mju: 'mju-telu-in',
  mjv: 'mjv-mlym-in',
  mjw: 'mjw-latn-in',
  mjx: 'mjx-latn-bd',
  'mjx-beng': 'mjx-beng-bd',
  mjy: 'mjy-latn-us',
  mjz: 'mjz-deva-np',
  mk: 'mk-cyrl-mk',
  mka: 'mka-latn-ci',
  mkb: 'mkb-deva-in',
  mkc: 'mkc-latn-pg',
  mke: 'mke-deva-in',
  mkf: 'mkf-latn-ng',
  mki: 'mki-arab-zz',
  mkj: 'mkj-latn-fm',
  mkk: 'mkk-latn-cm',
  mkl: 'mkl-latn-zz',
  mkm: 'mkm-thai-th',
  mkn: 'mkn-latn-id',
  mko: 'mko-latn-ng',
  mkp: 'mkp-latn-zz',
  mkr: 'mkr-latn-pg',
  mks: 'mks-latn-mx',
  mkt: 'mkt-latn-nc',
  mku: 'mku-latn-gn',
  mkv: 'mkv-latn-vu',
  mkw: 'mkw-latn-zz',
  mkx: 'mkx-latn-ph',
  mky: 'mky-latn-id',
  mkz: 'mkz-latn-tl',
  ml: 'ml-mlym-in',
  mla: 'mla-latn-vu',
  mlb: 'mlb-latn-cm',
  mlc: 'mlc-latn-vn',
  mle: 'mle-latn-zz',
  mlf: 'mlf-thai-la',
  'mlf-latn': 'mlf-latn-la',
  mlh: 'mlh-latn-pg',
  mli: 'mli-latn-id',
  mlj: 'mlj-latn-td',
  mlk: 'mlk-latn-ke',
  mll: 'mll-latn-vu',
  mln: 'mln-latn-sb',
  mlo: 'mlo-latn-sn',
  mlp: 'mlp-latn-zz',
  mlq: 'mlq-latn-sn',
  'mlq-arab': 'mlq-arab-sn',
  mlr: 'mlr-latn-cm',
  mls: 'mls-latn-sd',
  mlu: 'mlu-latn-sb',
  mlv: 'mlv-latn-vu',
  mlw: 'mlw-latn-cm',
  mlx: 'mlx-latn-vu',
  mlz: 'mlz-latn-ph',
  mma: 'mma-latn-ng',
  mmb: 'mmb-latn-id',
  mmc: 'mmc-latn-mx',
  mmd: 'mmd-latn-cn',
  'mmd-hans': 'mmd-hans-cn',
  'mmd-hant': 'mmd-hant-cn',
  mme: 'mme-latn-vu',
  mmf: 'mmf-latn-ng',
  mmg: 'mmg-latn-vu',
  mmh: 'mmh-latn-br',
  mmi: 'mmi-latn-pg',
  mmm: 'mmm-latn-vu',
  mmn: 'mmn-latn-ph',
  mmo: 'mmo-latn-zz',
  mmp: 'mmp-latn-pg',
  mmq: 'mmq-latn-pg',
  mmr: 'mmr-latn-cn',
  mmt: 'mmt-latn-pg',
  mmu: 'mmu-latn-zz',
  mmv: 'mmv-latn-br',
  mmw: 'mmw-latn-vu',
  mmx: 'mmx-latn-zz',
  mmy: 'mmy-latn-td',
  mmz: 'mmz-latn-cd',
  mn: 'mn-cyrl-mn',
  'mn-cn': 'mn-mong-cn',
  'mn-mong': 'mn-mong-cn',
  mna: 'mna-latn-zz',
  mnb: 'mnb-latn-id',
  mnd: 'mnd-latn-br',
  mne: 'mne-latn-td',
  mnf: 'mnf-latn-zz',
  mng: 'mng-latn-vn',
  mnh: 'mnh-latn-cd',
  mni: 'mni-beng-in',
  mnj: 'mnj-arab-af',
  mnl: 'mnl-latn-vu',
  mnm: 'mnm-latn-pg',
  mnn: 'mnn-latn-vn',
  mnp: 'mnp-latn-cn',
  mnq: 'mnq-latn-my',
  mnr: 'mnr-latn-us',
  mns: 'mns-cyrl-ru',
  mnu: 'mnu-latn-id',
  mnv: 'mnv-latn-sb',
  mnw: 'mnw-mymr-mm',
  mnx: 'mnx-latn-id',
  mny: 'mny-latn-mz',
  mnz: 'mnz-latn-id',
  mo: 'mo-latn-ro',
  moa: 'moa-latn-zz',
  moc: 'moc-latn-ar',
  mod: 'mod-latn-us',
  moe: 'moe-latn-ca',
  mog: 'mog-latn-id',
  moh: 'moh-latn-ca',
  moi: 'moi-latn-ng',
  moj: 'moj-latn-cg',
  mok: 'mok-latn-id',
  mom: 'mom-latn-ni',
  moo: 'moo-latn-vn',
  mop: 'mop-latn-bz',
  moq: 'moq-latn-id',
  mor: 'mor-latn-sd',
  mos: 'mos-latn-bf',
  mot: 'mot-latn-co',
  mou: 'mou-latn-td',
  mov: 'mov-latn-us',
  mow: 'mow-latn-cg',
  mox: 'mox-latn-zz',
  moy: 'moy-latn-et',
  'moy-ethi': 'moy-ethi-et',
  moz: 'moz-latn-td',
  mpa: 'mpa-latn-tz',
  mpb: 'mpb-latn-au',
  mpc: 'mpc-latn-au',
  mpd: 'mpd-latn-br',
  mpe: 'mpe-latn-et',
  'mpe-ethi': 'mpe-ethi-et',
  mpg: 'mpg-latn-td',
  mph: 'mph-latn-au',
  mpi: 'mpi-latn-cm',
  mpj: 'mpj-latn-au',
  mpk: 'mpk-latn-td',
  mpl: 'mpl-latn-pg',
  mpm: 'mpm-latn-mx',
  mpn: 'mpn-latn-pg',
  mpo: 'mpo-latn-pg',
  mpp: 'mpp-latn-zz',
  mpq: 'mpq-latn-br',
  mpr: 'mpr-latn-sb',
  mps: 'mps-latn-zz',
  mpt: 'mpt-latn-zz',
  mpu: 'mpu-latn-br',
  mpv: 'mpv-latn-pg',
  mpw: 'mpw-latn-br',
  mpx: 'mpx-latn-zz',
  mpy: 'mpy-latn-id',
  mpz: 'mpz-thai-th',
  mqa: 'mqa-latn-id',
  mqb: 'mqb-latn-cm',
  mqc: 'mqc-latn-id',
  mqe: 'mqe-latn-pg',
  mqf: 'mqf-latn-id',
  mqg: 'mqg-latn-id',
  mqh: 'mqh-latn-mx',
  mqi: 'mqi-latn-id',
  mqj: 'mqj-latn-id',
  mqk: 'mqk-latn-ph',
  mql: 'mql-latn-zz',
  mqm: 'mqm-latn-pf',
  mqn: 'mqn-latn-id',
  mqo: 'mqo-latn-id',
  mqp: 'mqp-latn-id',
  mqq: 'mqq-latn-my',
  mqr: 'mqr-latn-id',
  mqs: 'mqs-latn-id',
  mqu: 'mqu-latn-ss',
  mqv: 'mqv-latn-pg',
  mqw: 'mqw-latn-pg',
  mqx: 'mqx-latn-id',
  'mqx-bugi': 'mqx-bugi-id',
  mqy: 'mqy-latn-id',
  mqz: 'mqz-latn-pg',
  mr: 'mr-deva-in',
  mra: 'mra-thai-th',
  mrb: 'mrb-latn-vu',
  mrc: 'mrc-latn-us',
  mrd: 'mrd-deva-np',
  mrf: 'mrf-latn-id',
  mrg: 'mrg-latn-in',
  'mrg-beng': 'mrg-beng-in',
  'mrg-deva': 'mrg-deva-in',
  mrh: 'mrh-latn-in',
  mrj: 'mrj-cyrl-ru',
  mrk: 'mrk-latn-nc',
  mrl: 'mrl-latn-fm',
  mrm: 'mrm-latn-vu',
  mrn: 'mrn-latn-sb',
  mro: 'mro-mroo-bd',
  mrp: 'mrp-latn-vu',
  mrq: 'mrq-latn-pf',
  mrr: 'mrr-deva-in',
  mrs: 'mrs-latn-vu',
  mrt: 'mrt-latn-ng',
  mru: 'mru-latn-cm',
  mrv: 'mrv-latn-pf',
  mrw: 'mrw-latn-ph',
  'mrw-arab': 'mrw-arab-ph',
  mrx: 'mrx-latn-id',
  mry: 'mry-latn-ph',
  mrz: 'mrz-latn-id',
  ms: 'ms-latn-my',
  'ms-cc': 'ms-arab-cc',
  msb: 'msb-latn-ph',
  msc: 'msc-latn-gn',
  mse: 'mse-latn-td',
  msf: 'msf-latn-id',
  msg: 'msg-latn-id',
  msh: 'msh-latn-mg',
  msi: 'msi-latn-my',
  msj: 'msj-latn-cd',
  msk: 'msk-latn-ph',
  msl: 'msl-latn-id',
  msm: 'msm-latn-ph',
  msn: 'msn-latn-vu',
  mso: 'mso-latn-id',
  msp: 'msp-latn-br',
  msq: 'msq-latn-nc',
  mss: 'mss-latn-id',
  msu: 'msu-latn-pg',
  msv: 'msv-latn-cm',
  msw: 'msw-latn-gw',
  msx: 'msx-latn-pg',
  msy: 'msy-latn-pg',
  msz: 'msz-latn-pg',
  mt: 'mt-latn-mt',
  mta: 'mta-latn-ph',
  mtb: 'mtb-latn-ci',
  mtc: 'mtc-latn-zz',
  mtd: 'mtd-latn-id',
  mte: 'mte-latn-sb',
  mtf: 'mtf-latn-zz',
  mtg: 'mtg-latn-id',
  mth: 'mth-latn-id',
  mti: 'mti-latn-zz',
  mtj: 'mtj-latn-id',
  mtk: 'mtk-latn-cm',
  mtl: 'mtl-latn-ng',
  mtm: 'mtm-cyrl-ru',
  mtn: 'mtn-latn-ni',
  mto: 'mto-latn-mx',
  mtp: 'mtp-latn-bo',
  mtq: 'mtq-latn-vn',
  mtr: 'mtr-deva-in',
  mts: 'mts-latn-pe',
  mtt: 'mtt-latn-vu',
  mtu: 'mtu-latn-mx',
  mtv: 'mtv-latn-pg',
  mtw: 'mtw-latn-ph',
  mtx: 'mtx-latn-mx',
  mty: 'mty-latn-pg',
  mua: 'mua-latn-cm',
  mub: 'mub-latn-td',
  muc: 'muc-latn-cm',
  mud: 'mud-cyrl-ru',
  mue: 'mue-latn-ec',
  mug: 'mug-latn-cm',
  muh: 'muh-latn-ss',
  mui: 'mui-latn-id',
  muj: 'muj-latn-td',
  muk: 'muk-tibt-np',
  mum: 'mum-latn-pg',
  muo: 'muo-latn-cm',
  muq: 'muq-latn-cn',
  mur: 'mur-latn-zz',
  mus: 'mus-latn-us',
  mut: 'mut-deva-in',
  muu: 'muu-latn-ke',
  muv: 'muv-taml-in',
  mux: 'mux-latn-pg',
  muy: 'muy-latn-cm',
  muz: 'muz-ethi-et',
  'muz-latn': 'muz-latn-et',
  mva: 'mva-latn-zz',
  mvd: 'mvd-latn-id',
  mvf: 'mvf-mong-cn',
  'mvf-phag': 'mvf-phag-cn',
  mvg: 'mvg-latn-mx',
  mvh: 'mvh-latn-td',
  mvk: 'mvk-latn-pg',
  mvl: 'mvl-latn-au',
  mvn: 'mvn-latn-zz',
  mvo: 'mvo-latn-sb',
  mvp: 'mvp-latn-id',
  mvq: 'mvq-latn-pg',
  mvr: 'mvr-latn-id',
  mvs: 'mvs-latn-id',
  mvt: 'mvt-latn-vu',
  mvu: 'mvu-latn-td',
  mvv: 'mvv-latn-my',
  mvw: 'mvw-latn-tz',
  mvx: 'mvx-latn-id',
  mvy: 'mvy-arab-pk',
  mvz: 'mvz-ethi-et',
  'mvz-arab': 'mvz-arab-et',
  mwa: 'mwa-latn-pg',
  mwb: 'mwb-latn-pg',
  mwc: 'mwc-latn-pg',
  mwe: 'mwe-latn-tz',
  mwf: 'mwf-latn-au',
  mwg: 'mwg-latn-pg',
  mwh: 'mwh-latn-pg',
  mwi: 'mwi-latn-vu',
  mwk: 'mwk-latn-ml',
  mwl: 'mwl-latn-pt',
  mwm: 'mwm-latn-td',
  mwn: 'mwn-latn-zm',
  mwo: 'mwo-latn-vu',
  mwp: 'mwp-latn-au',
  mwq: 'mwq-latn-mm',
  mwr: 'mwr-deva-in',
  mws: 'mws-latn-ke',
  mwt: 'mwt-mymr-mm',
  'mwt-thai': 'mwt-thai-th',
  mwu: 'mwu-latn-ss',
  mwv: 'mwv-latn-id',
  mww: 'mww-hmnp-us',
  mwz: 'mwz-latn-cd',
  mxa: 'mxa-latn-mx',
  mxb: 'mxb-latn-mx',
  mxc: 'mxc-latn-zw',
  mxd: 'mxd-latn-id',
  mxe: 'mxe-latn-vu',
  mxf: 'mxf-latn-cm',
  mxg: 'mxg-latn-ao',
  mxh: 'mxh-latn-cd',
  mxi: 'mxi-latn-es',
  mxj: 'mxj-latn-in',
  mxk: 'mxk-latn-pg',
  mxl: 'mxl-latn-bj',
  mxm: 'mxm-latn-zz',
  mxn: 'mxn-latn-id',
  mxo: 'mxo-latn-zm',
  mxp: 'mxp-latn-mx',
  mxq: 'mxq-latn-mx',
  mxr: 'mxr-latn-my',
  mxs: 'mxs-latn-mx',
  mxt: 'mxt-latn-mx',
  mxu: 'mxu-latn-cm',
  mxv: 'mxv-latn-mx',
  mxw: 'mxw-latn-pg',
  mxx: 'mxx-latn-ci',
  mxy: 'mxy-latn-mx',
  mxz: 'mxz-latn-id',
  my: 'my-mymr-mm',
  myb: 'myb-latn-td',
  myc: 'myc-latn-cd',
  mye: 'mye-latn-ga',
  myf: 'myf-latn-et',
  myg: 'myg-latn-cm',
  myh: 'myh-latn-us',
  myj: 'myj-latn-ss',
  myk: 'myk-latn-zz',
  myl: 'myl-latn-id',
  mym: 'mym-ethi-zz',
  myp: 'myp-latn-br',
  myr: 'myr-latn-pe',
  myu: 'myu-latn-br',
  myv: 'myv-cyrl-ru',
  myw: 'myw-latn-zz',
  myx: 'myx-latn-ug',
  myy: 'myy-latn-co',
  myz: 'myz-mand-ir',
  mza: 'mza-latn-mx',
  mzd: 'mzd-latn-cm',
  mze: 'mze-latn-pg',
  mzh: 'mzh-latn-ar',
  mzi: 'mzi-latn-mx',
  mzj: 'mzj-latn-lr',
  mzk: 'mzk-latn-zz',
  mzl: 'mzl-latn-mx',
  mzm: 'mzm-latn-zz',
  mzn: 'mzn-arab-ir',
  mzo: 'mzo-latn-br',
  mzp: 'mzp-latn-zz',
  mzq: 'mzq-latn-id',
  mzr: 'mzr-latn-br',
  mzt: 'mzt-latn-my',
  mzu: 'mzu-latn-pg',
  mzv: 'mzv-latn-cf',
  mzw: 'mzw-latn-zz',
  mzx: 'mzx-latn-gy',
  mzz: 'mzz-latn-zz',
  na: 'na-latn-nr',
  naa: 'naa-latn-id',
  nab: 'nab-latn-br',
  nac: 'nac-latn-zz',
  nae: 'nae-latn-id',
  naf: 'naf-latn-zz',
  nag: 'nag-latn-in',
  naj: 'naj-latn-gn',
  nak: 'nak-latn-zz',
  nal: 'nal-latn-pg',
  nam: 'nam-latn-au',
  nan: 'nan-hans-cn',
  nao: 'nao-deva-np',
  nap: 'nap-latn-it',
  naq: 'naq-latn-na',
  nar: 'nar-latn-ng',
  nas: 'nas-latn-zz',
  nat: 'nat-latn-ng',
  naw: 'naw-latn-gh',
  nax: 'nax-latn-pg',
  nay: 'nay-latn-au',
  naz: 'naz-latn-mx',
  nb: 'nb-latn-no',
  nba: 'nba-latn-ao',
  nbb: 'nbb-latn-ng',
  nbc: 'nbc-latn-in',
  nbd: 'nbd-latn-cd',
  nbe: 'nbe-latn-in',
  nbh: 'nbh-latn-ng',
  nbi: 'nbi-latn-in',
  nbj: 'nbj-latn-au',
  nbk: 'nbk-latn-pg',
  nbm: 'nbm-latn-cf',
  nbn: 'nbn-latn-id',
  nbo: 'nbo-latn-ng',
  nbp: 'nbp-latn-ng',
  nbq: 'nbq-latn-id',
  nbr: 'nbr-latn-ng',
  nbt: 'nbt-latn-in',
  'nbt-deva': 'nbt-deva-in',
  nbu: 'nbu-latn-in',
  nbv: 'nbv-latn-cm',
  nbw: 'nbw-latn-cd',
  nby: 'nby-latn-pg',
  nca: 'nca-latn-zz',
  ncb: 'ncb-latn-in',
  'ncb-deva': 'ncb-deva-in',
  ncc: 'ncc-latn-pg',
  ncd: 'ncd-deva-np',
  nce: 'nce-latn-zz',
  ncf: 'ncf-latn-zz',
  ncg: 'ncg-latn-ca',
  nch: 'nch-latn-mx',
  nci: 'nci-latn-mx',
  ncj: 'ncj-latn-mx',
  nck: 'nck-latn-au',
  ncl: 'ncl-latn-mx',
  ncm: 'ncm-latn-pg',
  ncn: 'ncn-latn-pg',
  nco: 'nco-latn-zz',
  ncq: 'ncq-laoo-la',
  'ncq-thai': 'ncq-thai-la',
  ncr: 'ncr-latn-cm',
  nct: 'nct-latn-in',
  'nct-beng': 'nct-beng-in',
  ncu: 'ncu-latn-zz',
  ncx: 'ncx-latn-mx',
  ncz: 'ncz-latn-us',
  nd: 'nd-latn-zw',
  nda: 'nda-latn-cg',
  ndb: 'ndb-latn-cm',
  ndc: 'ndc-latn-mz',
  ndd: 'ndd-latn-ng',
  ndf: 'ndf-cyrl-ru',
  ndg: 'ndg-latn-tz',
  ndh: 'ndh-latn-tz',
  ndi: 'ndi-latn-ng',
  ndj: 'ndj-latn-tz',
  ndk: 'ndk-latn-cd',
  ndl: 'ndl-latn-cd',
  ndm: 'ndm-latn-td',
  ndn: 'ndn-latn-cg',
  ndp: 'ndp-latn-ug',
  ndq: 'ndq-latn-ao',
  ndr: 'ndr-latn-ng',
  nds: 'nds-latn-de',
  ndt: 'ndt-latn-cd',
  ndu: 'ndu-latn-cm',
  ndv: 'ndv-latn-sn',
  ndw: 'ndw-latn-cd',
  ndx: 'ndx-latn-id',
  ndy: 'ndy-latn-cf',
  'ndy-td': 'ndy-latn-td',
  ndz: 'ndz-latn-ss',
  ne: 'ne-deva-np',
  nea: 'nea-latn-id',
  neb: 'neb-latn-zz',
  nec: 'nec-latn-id',
  ned: 'ned-latn-ng',
  nee: 'nee-latn-nc',
  neg: 'neg-cyrl-ru',
  neh: 'neh-tibt-bt',
  nei: 'nei-xsux-tr',
  nej: 'nej-latn-pg',
  nek: 'nek-latn-nc',
  nem: 'nem-latn-nc',
  nen: 'nen-latn-nc',
  neo: 'neo-latn-vn',
  neq: 'neq-latn-mx',
  ner: 'ner-latn-id',
  net: 'net-latn-pg',
  neu: 'neu-latn-001',
  new: 'new-deva-np',
  nex: 'nex-latn-zz',
  ney: 'ney-latn-ci',
  nez: 'nez-latn-us',
  nfa: 'nfa-latn-id',
  nfd: 'nfd-latn-ng',
  nfl: 'nfl-latn-sb',
  nfr: 'nfr-latn-zz',
  nfu: 'nfu-latn-cm',
  ng: 'ng-latn-na',
  nga: 'nga-latn-zz',
  ngb: 'ngb-latn-zz',
  ngc: 'ngc-latn-cd',
  ngd: 'ngd-latn-cf',
  nge: 'nge-latn-cm',
  ngg: 'ngg-latn-cf',
  ngh: 'ngh-latn-za',
  ngi: 'ngi-latn-ng',
  ngj: 'ngj-latn-cm',
  ngk: 'ngk-latn-au',
  ngl: 'ngl-latn-mz',
  ngm: 'ngm-latn-fm',
  ngn: 'ngn-latn-cm',
  ngp: 'ngp-latn-tz',
  ngq: 'ngq-latn-tz',
  ngr: 'ngr-latn-sb',
  ngs: 'ngs-latn-ng',
  ngt: 'ngt-laoo-la',
  ngu: 'ngu-latn-mx',
  ngv: 'ngv-latn-cm',
  ngw: 'ngw-latn-ng',
  ngx: 'ngx-latn-ng',
  ngy: 'ngy-latn-cm',
  ngz: 'ngz-latn-cg',
  nha: 'nha-latn-au',
  nhb: 'nhb-latn-zz',
  nhc: 'nhc-latn-mx',
  nhd: 'nhd-latn-py',
  nhe: 'nhe-latn-mx',
  nhf: 'nhf-latn-au',
  nhg: 'nhg-latn-mx',
  nhi: 'nhi-latn-mx',
  nhk: 'nhk-latn-mx',
  nhm: 'nhm-latn-mx',
  nhn: 'nhn-latn-mx',
  nho: 'nho-latn-pg',
  nhp: 'nhp-latn-mx',
  nhq: 'nhq-latn-mx',
  nhr: 'nhr-latn-bw',
  nht: 'nht-latn-mx',
  nhu: 'nhu-latn-cm',
  nhv: 'nhv-latn-mx',
  nhw: 'nhw-latn-mx',
  nhx: 'nhx-latn-mx',
  nhy: 'nhy-latn-mx',
  nhz: 'nhz-latn-mx',
  nia: 'nia-latn-id',
  nib: 'nib-latn-pg',
  nid: 'nid-latn-au',
  nie: 'nie-latn-td',
  nif: 'nif-latn-zz',
  nig: 'nig-latn-au',
  nih: 'nih-latn-tz',
  nii: 'nii-latn-zz',
  nij: 'nij-latn-id',
  nil: 'nil-latn-id',
  nim: 'nim-latn-tz',
  nin: 'nin-latn-zz',
  nio: 'nio-cyrl-ru',
  niq: 'niq-latn-ke',
  nir: 'nir-latn-id',
  nis: 'nis-latn-pg',
  nit: 'nit-telu-in',
  niu: 'niu-latn-nu',
  niv: 'niv-cyrl-ru',
  'niv-latn': 'niv-latn-ru',
  niw: 'niw-latn-pg',
  nix: 'nix-latn-cd',
  niy: 'niy-latn-zz',
  niz: 'niz-latn-zz',
  nja: 'nja-latn-ng',
  njb: 'njb-latn-in',
  njd: 'njd-latn-tz',
  njh: 'njh-latn-in',
  nji: 'nji-latn-au',
  njj: 'njj-latn-cm',
  njl: 'njl-latn-ss',
  njm: 'njm-latn-in',
  njn: 'njn-latn-in',
  njo: 'njo-latn-in',
  njr: 'njr-latn-ng',
  njs: 'njs-latn-id',
  njt: 'njt-latn-sr',
  nju: 'nju-latn-au',
  njx: 'njx-latn-cg',
  njy: 'njy-latn-cm',
  njz: 'njz-latn-in',
  'njz-beng': 'njz-beng-in',
  nka: 'nka-latn-zm',
  nkb: 'nkb-latn-in',
  nkc: 'nkc-latn-cm',
  nkd: 'nkd-latn-in',
  nke: 'nke-latn-sb',
  nkf: 'nkf-latn-in',
  nkg: 'nkg-latn-zz',
  nkh: 'nkh-latn-in',
  nki: 'nki-latn-in',
  'nki-beng': 'nki-beng-in',
  nkj: 'nkj-latn-id',
  nkk: 'nkk-latn-vu',
  nkm: 'nkm-latn-pg',
  nkn: 'nkn-latn-ao',
  nko: 'nko-latn-zz',
  nkq: 'nkq-latn-gh',
  nkr: 'nkr-latn-fm',
  nks: 'nks-latn-id',
  nkt: 'nkt-latn-tz',
  nku: 'nku-latn-ci',
  nkv: 'nkv-latn-mw',
  nkw: 'nkw-latn-cd',
  nkx: 'nkx-latn-ng',
  nkz: 'nkz-latn-ng',
  nl: 'nl-latn-nl',
  nla: 'nla-latn-cm',
  nlc: 'nlc-latn-id',
  nle: 'nle-latn-ke',
  nlg: 'nlg-latn-sb',
  nli: 'nli-arab-af',
  nlj: 'nlj-latn-cd',
  nlk: 'nlk-latn-id',
  nlm: 'nlm-arab-pk',
  nlo: 'nlo-latn-cd',
  nlq: 'nlq-latn-mm',
  nlu: 'nlu-latn-gh',
  nlv: 'nlv-latn-mx',
  nlw: 'nlw-latn-au',
  nlx: 'nlx-deva-in',
  nly: 'nly-latn-au',
  nlz: 'nlz-latn-sb',
  nma: 'nma-latn-in',
  nmb: 'nmb-latn-vu',
  nmc: 'nmc-latn-td',
  nmd: 'nmd-latn-ga',
  nme: 'nme-latn-in',
  nmf: 'nmf-latn-in',
  nmg: 'nmg-latn-cm',
  nmh: 'nmh-latn-in',
  nmi: 'nmi-latn-ng',
  nmj: 'nmj-latn-cf',
  nmk: 'nmk-latn-vu',
  nml: 'nml-latn-cm',
  nmm: 'nmm-deva-np',
  'nmm-tibt': 'nmm-tibt-np',
  nmn: 'nmn-latn-bw',
  nmo: 'nmo-latn-in',
  'nmo-beng': 'nmo-beng-in',
  nmp: 'nmp-latn-au',
  nmq: 'nmq-latn-zw',
  nmr: 'nmr-latn-cm',
  nms: 'nms-latn-vu',
  nmt: 'nmt-latn-fm',
  nmu: 'nmu-latn-us',
  nmv: 'nmv-latn-au',
  nmw: 'nmw-latn-pg',
  nmx: 'nmx-latn-pg',
  nmz: 'nmz-latn-zz',
  nn: 'nn-latn-no',
  nna: 'nna-latn-au',
  nnb: 'nnb-latn-cd',
  nnc: 'nnc-latn-td',
  nnd: 'nnd-latn-vu',
  nne: 'nne-latn-ao',
  nnf: 'nnf-latn-zz',
  nng: 'nng-latn-in',
  'nng-beng': 'nng-beng-in',
  nnh: 'nnh-latn-cm',
  nni: 'nni-latn-id',
  nnj: 'nnj-latn-et',
  nnk: 'nnk-latn-zz',
  nnl: 'nnl-latn-in',
  nnm: 'nnm-latn-zz',
  nnn: 'nnn-latn-td',
  nnp: 'nnp-wcho-in',
  nnq: 'nnq-latn-tz',
  nnr: 'nnr-latn-au',
  nnt: 'nnt-latn-us',
  nnu: 'nnu-latn-gh',
  nnv: 'nnv-latn-au',
  nnw: 'nnw-latn-bf',
  nny: 'nny-latn-au',
  nnz: 'nnz-latn-cm',
  no: 'no-latn-no',
  noa: 'noa-latn-co',
  noc: 'noc-latn-pg',
  nod: 'nod-lana-th',
  noe: 'noe-deva-in',
  nof: 'nof-latn-pg',
  nog: 'nog-cyrl-ru',
  noh: 'noh-latn-pg',
  noi: 'noi-deva-in',
  noj: 'noj-latn-co',
  nok: 'nok-latn-us',
  nom: 'nom-latn-pe',
  non: 'non-runr-se',
  nop: 'nop-latn-zz',
  noq: 'noq-latn-cd',
  nos: 'nos-yiii-cn',
  not: 'not-latn-pe',
  nou: 'nou-latn-zz',
  nov: 'nov-latn-001',
  now: 'now-latn-tz',
  noy: 'noy-latn-td',
  npb: 'npb-tibt-bt',
  npg: 'npg-latn-mm',
  nph: 'nph-latn-in',
  npl: 'npl-latn-mx',
  npn: 'npn-latn-pg',
  npo: 'npo-latn-in',
  nps: 'nps-latn-id',
  npu: 'npu-latn-in',
  npx: 'npx-latn-sb',
  npy: 'npy-latn-id',
  nqg: 'nqg-latn-bj',
  nqk: 'nqk-latn-bj',
  nql: 'nql-latn-ao',
  nqm: 'nqm-latn-id',
  nqn: 'nqn-latn-pg',
  nqo: 'nqo-nkoo-gn',
  nqq: 'nqq-latn-mm',
  nqt: 'nqt-latn-ng',
  nqy: 'nqy-latn-mm',
  nr: 'nr-latn-za',
  nra: 'nra-latn-ga',
  nrb: 'nrb-latn-zz',
  nre: 'nre-latn-in',
  nrf: 'nrf-latn-je',
  nrg: 'nrg-latn-vu',
  nri: 'nri-latn-in',
  nrk: 'nrk-latn-au',
  nrl: 'nrl-latn-au',
  nrm: 'nrm-latn-my',
  nrp: 'nrp-latn-it',
  nru: 'nru-latn-cn',
  'nru-hans': 'nru-hans-cn',
  'nru-hant': 'nru-hant-cn',
  nrx: 'nrx-latn-au',
  nrz: 'nrz-latn-pg',
  nsa: 'nsa-latn-in',
  nsb: 'nsb-latn-za',
  nsc: 'nsc-latn-ng',
  nsd: 'nsd-yiii-cn',
  nse: 'nse-latn-zm',
  nsf: 'nsf-yiii-cn',
  nsg: 'nsg-latn-tz',
  nsh: 'nsh-latn-cm',
  nsk: 'nsk-cans-ca',
  nsm: 'nsm-latn-in',
  nsn: 'nsn-latn-zz',
  nso: 'nso-latn-za',
  nsq: 'nsq-latn-us',
  nss: 'nss-latn-zz',
  nst: 'nst-tnsa-in',
  nsu: 'nsu-latn-mx',
  nsv: 'nsv-yiii-cn',
  nsw: 'nsw-latn-vu',
  nsx: 'nsx-latn-ao',
  nsy: 'nsy-latn-id',
  nsz: 'nsz-latn-us',
  ntd: 'ntd-latn-my',
  nte: 'nte-latn-mz',
  ntg: 'ntg-latn-au',
  nti: 'nti-latn-bf',
  ntj: 'ntj-latn-au',
  ntk: 'ntk-latn-tz',
  ntm: 'ntm-latn-zz',
  nto: 'nto-latn-cd',
  ntp: 'ntp-latn-mx',
  ntr: 'ntr-latn-zz',
  ntu: 'ntu-latn-sb',
  ntx: 'ntx-latn-mm',
  nty: 'nty-yiii-vn',
  ntz: 'ntz-arab-ir',
  nua: 'nua-latn-nc',
  nuc: 'nuc-latn-br',
  nud: 'nud-latn-pg',
  nue: 'nue-latn-cd',
  nuf: 'nuf-latn-cn',
  nug: 'nug-latn-au',
  nuh: 'nuh-latn-ng',
  nui: 'nui-latn-zz',
  nuj: 'nuj-latn-ug',
  nuk: 'nuk-latn-ca',
  num: 'num-latn-to',
  nun: 'nun-latn-mm',
  nuo: 'nuo-latn-vn',
  nup: 'nup-latn-zz',
  nuq: 'nuq-latn-pg',
  nur: 'nur-latn-pg',
  nus: 'nus-latn-ss',
  nut: 'nut-latn-vn',
  nuu: 'nuu-latn-cd',
  nuv: 'nuv-latn-zz',
  nuw: 'nuw-latn-fm',
  nux: 'nux-latn-zz',
  nuy: 'nuy-latn-au',
  nuz: 'nuz-latn-mx',
  nv: 'nv-latn-us',
  nvh: 'nvh-latn-vu',
  nvm: 'nvm-latn-pg',
  nvo: 'nvo-latn-cm',
  nwb: 'nwb-latn-zz',
  nwc: 'nwc-newa-np',
  'nwc-brah': 'nwc-brah-np',
  'nwc-deva': 'nwc-deva-np',
  'nwc-sidd': 'nwc-sidd-np',
  nwe: 'nwe-latn-cm',
  nwg: 'nwg-latn-au',
  nwi: 'nwi-latn-vu',
  nwm: 'nwm-latn-ss',
  nwo: 'nwo-latn-au',
  nwr: 'nwr-latn-pg',
  nww: 'nww-latn-tz',
  nwx: 'nwx-deva-np',
  nxa: 'nxa-latn-tl',
  nxd: 'nxd-latn-cd',
  nxe: 'nxe-latn-id',
  nxg: 'nxg-latn-id',
  nxi: 'nxi-latn-tz',
  nxl: 'nxl-latn-id',
  nxn: 'nxn-latn-au',
  nxo: 'nxo-latn-ga',
  nxq: 'nxq-latn-cn',
  nxr: 'nxr-latn-zz',
  nxx: 'nxx-latn-id',
  ny: 'ny-latn-mw',
  nyb: 'nyb-latn-gh',
  nyc: 'nyc-latn-cd',
  nyd: 'nyd-latn-ke',
  nye: 'nye-latn-ao',
  nyf: 'nyf-latn-ke',
  nyg: 'nyg-latn-cd',
  nyh: 'nyh-latn-au',
  nyi: 'nyi-latn-sd',
  nyj: 'nyj-latn-cd',
  nyk: 'nyk-latn-ao',
  nyl: 'nyl-thai-th',
  nym: 'nym-latn-tz',
  nyn: 'nyn-latn-ug',
  nyo: 'nyo-latn-ug',
  nyp: 'nyp-latn-ug',
  nyq: 'nyq-arab-ir',
  nyr: 'nyr-latn-mw',
  nys: 'nys-latn-au',
  nyt: 'nyt-latn-au',
  nyu: 'nyu-latn-mz',
  nyv: 'nyv-latn-au',
  nyx: 'nyx-latn-au',
  nyy: 'nyy-latn-tz',
  nza: 'nza-latn-cm',
  nzb: 'nzb-latn-ga',
  nzd: 'nzd-latn-cd',
  nzi: 'nzi-latn-gh',
  nzk: 'nzk-latn-cf',
  nzm: 'nzm-latn-in',
  nzu: 'nzu-latn-cg',
  nzy: 'nzy-latn-td',
  nzz: 'nzz-latn-ml',
  oaa: 'oaa-cyrl-ru',
  oac: 'oac-cyrl-ru',
  oar: 'oar-syrc-sy',
  oav: 'oav-geor-ge',
  obi: 'obi-latn-us',
  obk: 'obk-latn-ph',
  obl: 'obl-latn-cm',
  obm: 'obm-phnx-jo',
  obo: 'obo-latn-ph',
  obr: 'obr-mymr-mm',
  obt: 'obt-latn-fr',
  obu: 'obu-latn-ng',
  oc: 'oc-latn-fr',
  oca: 'oca-latn-pe',
  oco: 'oco-latn-gb',
  ocu: 'ocu-latn-mx',
  oda: 'oda-latn-ng',
  odk: 'odk-arab-pk',
  odt: 'odt-latn-nl',
  odu: 'odu-latn-ng',
  ofu: 'ofu-latn-ng',
  ogb: 'ogb-latn-ng',
  ogc: 'ogc-latn-zz',
  ogg: 'ogg-latn-ng',
  ogo: 'ogo-latn-ng',
  ogu: 'ogu-latn-ng',
  oht: 'oht-xsux-tr',
  oia: 'oia-latn-id',
  oie: 'oie-latn-ss',
  oin: 'oin-latn-pg',
  oj: 'oj-cans-ca',
  ojb: 'ojb-latn-ca',
  'ojb-cans': 'ojb-cans-ca',
  ojc: 'ojc-latn-ca',
  ojs: 'ojs-cans-ca',
  ojv: 'ojv-latn-sb',
  ojw: 'ojw-latn-ca',
  'ojw-cans': 'ojw-cans-ca',
  oka: 'oka-latn-ca',
  okb: 'okb-latn-ng',
  okc: 'okc-latn-cd',
  okd: 'okd-latn-ng',
  oke: 'oke-latn-ng',
  okg: 'okg-latn-au',
  oki: 'oki-latn-ke',
  okk: 'okk-latn-pg',
  okm: 'okm-hang-kr',
  oko: 'oko-hani-kr',
  okr: 'okr-latn-zz',
  oks: 'oks-latn-ng',
  oku: 'oku-latn-cm',
  okv: 'okv-latn-zz',
  okx: 'okx-latn-ng',
  okz: 'okz-khmr-kh',
  ola: 'ola-deva-np',
  'ola-tibt': 'ola-tibt-cn',
  old: 'old-latn-tz',
  ole: 'ole-tibt-bt',
  olk: 'olk-latn-au',
  olm: 'olm-latn-ng',
  olo: 'olo-latn-ru',
  olr: 'olr-latn-vu',
  olt: 'olt-latn-lt',
  olu: 'olu-latn-ao',
  om: 'om-latn-et',
  oma: 'oma-latn-us',
  omb: 'omb-latn-vu',
  omc: 'omc-latn-pe',
  omg: 'omg-latn-pe',
  omi: 'omi-latn-cd',
  omk: 'omk-cyrl-ru',
  oml: 'oml-latn-cd',
  omo: 'omo-latn-pg',
  omp: 'omp-mtei-in',
  omr: 'omr-modi-in',
  omt: 'omt-latn-ke',
  omu: 'omu-latn-pe',
  omw: 'omw-latn-pg',
  ona: 'ona-latn-ar',
  one: 'one-latn-ca',
  ong: 'ong-latn-zz',
  oni: 'oni-latn-id',
  onj: 'onj-latn-pg',
  onk: 'onk-latn-pg',
  onn: 'onn-latn-zz',
  ono: 'ono-latn-ca',
  onp: 'onp-latn-in',
  'onp-deva': 'onp-deva-in',
  onr: 'onr-latn-pg',
  ons: 'ons-latn-zz',
  ont: 'ont-latn-pg',
  onu: 'onu-latn-vu',
  onx: 'onx-latn-id',
  ood: 'ood-latn-us',
  oon: 'oon-deva-in',
  oor: 'oor-latn-za',
  opa: 'opa-latn-ng',
  opk: 'opk-latn-id',
  opm: 'opm-latn-zz',
  opo: 'opo-latn-pg',
  opt: 'opt-latn-mx',
  opy: 'opy-latn-br',
  or: 'or-orya-in',
  ora: 'ora-latn-sb',
  orc: 'orc-latn-ke',
  ore: 'ore-latn-pe',
  org: 'org-latn-ng',
  orn: 'orn-latn-my',
  oro: 'oro-latn-zz',
  orr: 'orr-latn-ng',
  ors: 'ors-latn-my',
  ort: 'ort-telu-in',
  oru: 'oru-arab-zz',
  orv: 'orv-cyrl-ru',
  orw: 'orw-latn-br',
  orx: 'orx-latn-ng',
  orz: 'orz-latn-id',
  os: 'os-cyrl-ge',
  osa: 'osa-osge-us',
  osc: 'osc-ital-it',
  'osc-latn': 'osc-latn-it',
  osi: 'osi-java-id',
  oso: 'oso-latn-ng',
  osp: 'osp-latn-es',
  ost: 'ost-latn-cm',
  osu: 'osu-latn-pg',
  osx: 'osx-latn-de',
  ota: 'ota-arab-zz',
  otb: 'otb-tibt-cn',
  otd: 'otd-latn-id',
  ote: 'ote-latn-mx',
  oti: 'oti-latn-br',
  otk: 'otk-orkh-mn',
  otl: 'otl-latn-mx',
  otm: 'otm-latn-mx',
  otn: 'otn-latn-mx',
  otq: 'otq-latn-mx',
  otr: 'otr-latn-sd',
  ots: 'ots-latn-mx',
  ott: 'ott-latn-mx',
  otu: 'otu-latn-br',
  otw: 'otw-latn-ca',
  otx: 'otx-latn-mx',
  oty: 'oty-gran-in',
  otz: 'otz-latn-mx',
  oub: 'oub-latn-lr',
  oue: 'oue-latn-pg',
  oui: 'oui-ougr-143',
  oum: 'oum-latn-pg',
  ovd: 'ovd-latn-se',
  owi: 'owi-latn-pg',
  owl: 'owl-latn-gb',
  oyd: 'oyd-latn-et',
  oym: 'oym-latn-br',
  oyy: 'oyy-latn-pg',
  ozm: 'ozm-latn-zz',
  pa: 'pa-guru-in',
  'pa-arab': 'pa-arab-pk',
  'pa-pk': 'pa-arab-pk',
  pab: 'pab-latn-br',
  pac: 'pac-latn-vn',
  pad: 'pad-latn-br',
  pae: 'pae-latn-cd',
  paf: 'paf-latn-br',
  pag: 'pag-latn-ph',
  pah: 'pah-latn-br',
  pai: 'pai-latn-ng',
  pak: 'pak-latn-br',
  pal: 'pal-phli-ir',
  'pal-phlp': 'pal-phlp-cn',
  pam: 'pam-latn-ph',
  pao: 'pao-latn-us',
  pap: 'pap-latn-cw',
  paq: 'paq-cyrl-tj',
  par: 'par-latn-us',
  pas: 'pas-latn-id',
  pau: 'pau-latn-pw',
  pav: 'pav-latn-br',
  paw: 'paw-latn-us',
  pax: 'pax-latn-br',
  pay: 'pay-latn-hn',
  paz: 'paz-latn-br',
  pbb: 'pbb-latn-co',
  pbc: 'pbc-latn-gy',
  pbe: 'pbe-latn-mx',
  pbf: 'pbf-latn-mx',
  pbg: 'pbg-latn-ve',
  pbh: 'pbh-latn-ve',
  pbi: 'pbi-latn-zz',
  pbl: 'pbl-latn-ng',
  pbm: 'pbm-latn-mx',
  pbn: 'pbn-latn-ng',
  pbo: 'pbo-latn-gw',
  pbp: 'pbp-latn-gn',
  pbr: 'pbr-latn-tz',
  pbs: 'pbs-latn-mx',
  pbt: 'pbt-arab-af',
  pbv: 'pbv-latn-in',
  pby: 'pby-latn-pg',
  pca: 'pca-latn-mx',
  pcb: 'pcb-khmr-kh',
  pcc: 'pcc-latn-cn',
  'pcc-hani': 'pcc-hani-cn',
  pcd: 'pcd-latn-fr',
  pce: 'pce-mymr-mm',
  'pce-thai': 'pce-thai-th',
  pcf: 'pcf-mlym-in',
  pcg: 'pcg-mlym-in',
  'pcg-knda': 'pcg-knda-in',
  'pcg-taml': 'pcg-taml-in',
  pch: 'pch-deva-in',
  pci: 'pci-deva-in',
  'pci-orya': 'pci-orya-in',
  pcj: 'pcj-telu-in',
  pck: 'pck-latn-in',
  pcm: 'pcm-latn-ng',
  pcn: 'pcn-latn-ng',
  pcp: 'pcp-latn-bo',
  pcw: 'pcw-latn-ng',
  pda: 'pda-latn-pg',
  pdc: 'pdc-latn-us',
  pdn: 'pdn-latn-id',
  pdo: 'pdo-latn-id',
  pdt: 'pdt-latn-ca',
  pdu: 'pdu-latn-mm',
  'pdu-mymr': 'pdu-mymr-mm',
  pea: 'pea-latn-id',
  peb: 'peb-latn-us',
  ped: 'ped-latn-zz',
  pee: 'pee-latn-id',
  peg: 'peg-orya-in',
  pei: 'pei-latn-mx',
  pek: 'pek-latn-pg',
  pel: 'pel-latn-id',
  pem: 'pem-latn-cd',
  peo: 'peo-xpeo-ir',
  pep: 'pep-latn-pg',
  peq: 'peq-latn-us',
  pev: 'pev-latn-ve',
  pex: 'pex-latn-zz',
  pey: 'pey-latn-id',
  pez: 'pez-latn-my',
  pfa: 'pfa-latn-fm',
  pfe: 'pfe-latn-cm',
  pfl: 'pfl-latn-de',
  pga: 'pga-latn-ss',
  pgd: 'pgd-khar-pk',
  pgg: 'pgg-deva-in',
  pgi: 'pgi-latn-pg',
  pgk: 'pgk-latn-vu',
  pgl: 'pgl-ogam-ie',
  pgn: 'pgn-ital-it',
  pgs: 'pgs-latn-ng',
  pgu: 'pgu-latn-id',
  phd: 'phd-deva-in',
  phg: 'phg-latn-vn',
  phh: 'phh-latn-vn',
  phk: 'phk-mymr-in',
  phl: 'phl-arab-zz',
  phm: 'phm-latn-mz',
  phn: 'phn-phnx-lb',
  pho: 'pho-laoo-la',
  phr: 'phr-arab-pk',
  pht: 'pht-thai-th',
  phv: 'phv-arab-af',
  phw: 'phw-deva-np',
  pi: 'pi-sinh-in',
  'pi-brah': 'pi-brah-in',
  'pi-deva': 'pi-deva-in',
  'pi-khar': 'pi-khar-in',
  'pi-khmr': 'pi-khmr-in',
  'pi-mymr': 'pi-mymr-in',
  'pi-thai': 'pi-thai-in',
  pia: 'pia-latn-mx',
  pib: 'pib-latn-pe',
  pic: 'pic-latn-ga',
  pid: 'pid-latn-ve',
  pif: 'pif-latn-fm',
  pig: 'pig-latn-pe',
  pih: 'pih-latn-nf',
  pij: 'pij-latn-co',
  pil: 'pil-latn-zz',
  pim: 'pim-latn-us',
  pin: 'pin-latn-pg',
  pio: 'pio-latn-co',
  pip: 'pip-latn-zz',
  pir: 'pir-latn-br',
  pis: 'pis-latn-sb',
  pit: 'pit-latn-au',
  piu: 'piu-latn-au',
  piv: 'piv-latn-sb',
  piw: 'piw-latn-tz',
  pix: 'pix-latn-pg',
  piy: 'piy-latn-ng',
  piz: 'piz-latn-nc',
  pjt: 'pjt-latn-au',
  pka: 'pka-brah-in',
  pkb: 'pkb-latn-ke',
  pkg: 'pkg-latn-pg',
  pkh: 'pkh-latn-bd',
  'pkh-deva': 'pkh-deva-bd',
  pkn: 'pkn-latn-au',
  pko: 'pko-latn-ke',
  pkp: 'pkp-latn-ck',
  pkr: 'pkr-mlym-in',
  pku: 'pku-latn-id',
  pl: 'pl-latn-pl',
  pla: 'pla-latn-zz',
  plb: 'plb-latn-vu',
  plc: 'plc-latn-ph',
  pld: 'pld-latn-gb',
  ple: 'ple-latn-id',
  plg: 'plg-latn-ar',
  plh: 'plh-latn-id',
  plj: 'plj-latn-ng',
  plk: 'plk-arab-pk',
  pll: 'pll-mymr-mm',
  pln: 'pln-latn-co',
  plo: 'plo-latn-mx',
  plr: 'plr-latn-ci',
  pls: 'pls-latn-mx',
  plu: 'plu-latn-br',
  plv: 'plv-latn-ph',
  plw: 'plw-latn-ph',
  plz: 'plz-latn-my',
  pma: 'pma-latn-vu',
  pmb: 'pmb-latn-cd',
  pmd: 'pmd-latn-au',
  pme: 'pme-latn-nc',
  pmf: 'pmf-latn-id',
  pmh: 'pmh-brah-in',
  pmi: 'pmi-latn-cn',
  pmj: 'pmj-latn-cn',
  pml: 'pml-latn-tn',
  pmm: 'pmm-latn-cm',
  pmn: 'pmn-latn-cm',
  pmo: 'pmo-latn-id',
  pmq: 'pmq-latn-mx',
  pmr: 'pmr-latn-pg',
  pms: 'pms-latn-it',
  pmt: 'pmt-latn-pf',
  pmw: 'pmw-latn-us',
  pmx: 'pmx-latn-in',
  pmy: 'pmy-latn-id',
  pmz: 'pmz-latn-mx',
  pna: 'pna-latn-my',
  pnc: 'pnc-latn-id',
  pnd: 'pnd-latn-ao',
  pne: 'pne-latn-my',
  png: 'png-latn-zz',
  pnh: 'pnh-latn-ck',
  pni: 'pni-latn-id',
  pnj: 'pnj-latn-au',
  pnk: 'pnk-latn-bo',
  pnl: 'pnl-latn-bf',
  pnm: 'pnm-latn-my',
  pnn: 'pnn-latn-zz',
  pno: 'pno-latn-pe',
  pnp: 'pnp-latn-id',
  pnq: 'pnq-latn-bf',
  pnr: 'pnr-latn-pg',
  pns: 'pns-latn-id',
  pnt: 'pnt-grek-gr',
  pnv: 'pnv-latn-au',
  pnw: 'pnw-latn-au',
  pny: 'pny-latn-cm',
  pnz: 'pnz-latn-cf',
  poc: 'poc-latn-gt',
  poe: 'poe-latn-mx',
  pof: 'pof-latn-cd',
  pog: 'pog-latn-br',
  poh: 'poh-latn-gt',
  poi: 'poi-latn-mx',
  pok: 'pok-latn-br',
  pom: 'pom-latn-us',
  pon: 'pon-latn-fm',
  poo: 'poo-latn-us',
  pop: 'pop-latn-nc',
  poq: 'poq-latn-mx',
  pos: 'pos-latn-mx',
  pot: 'pot-latn-us',
  pov: 'pov-latn-gw',
  pow: 'pow-latn-mx',
  poy: 'poy-latn-tz',
  ppa: 'ppa-deva-in',
  ppe: 'ppe-latn-pg',
  ppi: 'ppi-latn-mx',
  ppk: 'ppk-latn-id',
  ppl: 'ppl-latn-sv',
  ppm: 'ppm-latn-id',
  ppn: 'ppn-latn-pg',
  ppo: 'ppo-latn-zz',
  ppp: 'ppp-latn-cd',
  ppq: 'ppq-latn-pg',
  pps: 'pps-latn-mx',
  ppt: 'ppt-latn-pg',
  pqa: 'pqa-latn-ng',
  pqm: 'pqm-latn-ca',
  pra: 'pra-khar-pk',
  prc: 'prc-arab-af',
  prd: 'prd-arab-ir',
  pre: 'pre-latn-st',
  prf: 'prf-latn-ph',
  prg: 'prg-latn-001',
  prh: 'prh-latn-ph',
  pri: 'pri-latn-nc',
  prk: 'prk-latn-mm',
  prm: 'prm-latn-pg',
  pro: 'pro-latn-fr',
  prp: 'prp-gujr-in',
  prq: 'prq-latn-pe',
  prr: 'prr-latn-br',
  prt: 'prt-thai-th',
  pru: 'pru-latn-id',
  prw: 'prw-latn-pg',
  prx: 'prx-arab-in',
  'prx-tibt': 'prx-tibt-in',
  ps: 'ps-arab-af',
  psa: 'psa-latn-id',
  pse: 'pse-latn-id',
  psh: 'psh-arab-af',
  psi: 'psi-arab-af',
  psm: 'psm-latn-bo',
  psn: 'psn-latn-id',
  psq: 'psq-latn-pg',
  pss: 'pss-latn-zz',
  pst: 'pst-arab-pk',
  psw: 'psw-latn-vu',
  pt: 'pt-latn-br',
  pta: 'pta-latn-py',
  pth: 'pth-latn-br',
  pti: 'pti-latn-au',
  ptn: 'ptn-latn-id',
  pto: 'pto-latn-br',
  ptp: 'ptp-latn-zz',
  ptr: 'ptr-latn-vu',
  ptt: 'ptt-latn-id',
  ptu: 'ptu-latn-id',
  ptv: 'ptv-latn-vu',
  pua: 'pua-latn-mx',
  pub: 'pub-latn-in',
  puc: 'puc-latn-id',
  pud: 'pud-latn-id',
  pue: 'pue-latn-ar',
  puf: 'puf-latn-id',
  pug: 'pug-latn-bf',
  pui: 'pui-latn-co',
  puj: 'puj-latn-id',
  pum: 'pum-deva-np',
  puo: 'puo-latn-vn',
  pup: 'pup-latn-pg',
  puq: 'puq-latn-pe',
  pur: 'pur-latn-br',
  put: 'put-latn-id',
  puu: 'puu-latn-ga',
  puw: 'puw-latn-fm',
  pux: 'pux-latn-pg',
  puy: 'puy-latn-us',
  pwa: 'pwa-latn-zz',
  pwb: 'pwb-latn-ng',
  pwg: 'pwg-latn-pg',
  pwm: 'pwm-latn-ph',
  pwn: 'pwn-latn-tw',
  pwo: 'pwo-mymr-mm',
  pwr: 'pwr-deva-in',
  pww: 'pww-thai-th',
  pxm: 'pxm-latn-mx',
  pye: 'pye-latn-ci',
  pym: 'pym-latn-ng',
  pyn: 'pyn-latn-br',
  pyu: 'pyu-latn-tw',
  'pyu-hani': 'pyu-hani-tw',
  pyx: 'pyx-mymr-mm',
  pyy: 'pyy-latn-mm',
  pzh: 'pzh-latn-tw',
  pzn: 'pzn-latn-mm',
  qu: 'qu-latn-pe',
  qua: 'qua-latn-us',
  qub: 'qub-latn-pe',
  quc: 'quc-latn-gt',
  qud: 'qud-latn-ec',
  quf: 'quf-latn-pe',
  qug: 'qug-latn-ec',
  qui: 'qui-latn-us',
  quk: 'quk-latn-pe',
  qul: 'qul-latn-bo',
  qum: 'qum-latn-gt',
  qun: 'qun-latn-us',
  qup: 'qup-latn-pe',
  quq: 'quq-latn-es',
  qur: 'qur-latn-pe',
  qus: 'qus-latn-ar',
  quv: 'quv-latn-gt',
  quw: 'quw-latn-ec',
  qux: 'qux-latn-pe',
  quy: 'quy-latn-pe',
  qva: 'qva-latn-pe',
  qvc: 'qvc-latn-pe',
  qve: 'qve-latn-pe',
  qvh: 'qvh-latn-pe',
  qvi: 'qvi-latn-ec',
  qvj: 'qvj-latn-ec',
  qvl: 'qvl-latn-pe',
  qvm: 'qvm-latn-pe',
  qvn: 'qvn-latn-pe',
  qvo: 'qvo-latn-pe',
  qvp: 'qvp-latn-pe',
  qvs: 'qvs-latn-pe',
  qvw: 'qvw-latn-pe',
  qvz: 'qvz-latn-ec',
  qwa: 'qwa-latn-pe',
  qwc: 'qwc-latn-pe',
  qwh: 'qwh-latn-pe',
  qwm: 'qwm-latn-ru',
  'qwm-cyrl': 'qwm-cyrl-ru',
  'qwm-runr': 'qwm-runr-ru',
  qws: 'qws-latn-pe',
  qwt: 'qwt-latn-us',
  qxa: 'qxa-latn-pe',
  qxc: 'qxc-latn-pe',
  qxh: 'qxh-latn-pe',
  qxl: 'qxl-latn-ec',
  qxn: 'qxn-latn-pe',
  qxo: 'qxo-latn-pe',
  qxp: 'qxp-latn-pe',
  qxq: 'qxq-arab-ir',
  qxr: 'qxr-latn-ec',
  qxt: 'qxt-latn-pe',
  qxu: 'qxu-latn-pe',
  qxw: 'qxw-latn-pe',
  qya: 'qya-latn-001',
  qyp: 'qyp-latn-us',
  raa: 'raa-deva-np',
  rab: 'rab-deva-np',
  rac: 'rac-latn-id',
  rad: 'rad-latn-vn',
  raf: 'raf-deva-np',
  rag: 'rag-latn-ke',
  rah: 'rah-beng-in',
  'rah-latn': 'rah-latn-in',
  rai: 'rai-latn-zz',
  raj: 'raj-deva-in',
  rak: 'rak-latn-pg',
  ram: 'ram-latn-br',
  ran: 'ran-latn-id',
  rao: 'rao-latn-zz',
  rap: 'rap-latn-cl',
  rar: 'rar-latn-ck',
  rav: 'rav-deva-np',
  raw: 'raw-latn-mm',
  rax: 'rax-latn-ng',
  ray: 'ray-latn-pf',
  raz: 'raz-latn-id',
  rbb: 'rbb-mymr-mm',
  rbk: 'rbk-latn-ph',
  rbl: 'rbl-latn-ph',
  rbp: 'rbp-latn-au',
  rcf: 'rcf-latn-re',
  rdb: 'rdb-arab-ir',
  rea: 'rea-latn-pg',
  reb: 'reb-latn-id',
  ree: 'ree-latn-my',
  reg: 'reg-latn-tz',
  rei: 'rei-orya-in',
  'rei-telu': 'rei-telu-in',
  rej: 'rej-latn-id',
  rel: 'rel-latn-zz',
  rem: 'rem-latn-pe',
  ren: 'ren-latn-vn',
  res: 'res-latn-zz',
  ret: 'ret-latn-id',
  rey: 'rey-latn-bo',
  rga: 'rga-latn-vu',
  rgn: 'rgn-latn-it',
  rgr: 'rgr-latn-pe',
  rgs: 'rgs-latn-vn',
  rgu: 'rgu-latn-id',
  rhg: 'rhg-rohg-mm',
  rhp: 'rhp-latn-pg',
  ria: 'ria-latn-in',
  rif: 'rif-latn-ma',
  ril: 'ril-latn-mm',
  rim: 'rim-latn-tz',
  rin: 'rin-latn-ng',
  rir: 'rir-latn-id',
  rit: 'rit-latn-au',
  riu: 'riu-latn-id',
  rjg: 'rjg-latn-id',
  rji: 'rji-deva-np',
  rjs: 'rjs-deva-np',
  rka: 'rka-khmr-kh',
  rkb: 'rkb-latn-br',
  rkh: 'rkh-latn-ck',
  rki: 'rki-mymr-mm',
  rkm: 'rkm-latn-bf',
  rkt: 'rkt-beng-bd',
  rkw: 'rkw-latn-au',
  rm: 'rm-latn-ch',
  rma: 'rma-latn-ni',
  rmb: 'rmb-latn-au',
  rmc: 'rmc-latn-sk',
  rmd: 'rmd-latn-dk',
  rme: 'rme-latn-gb',
  rmf: 'rmf-latn-fi',
  rmg: 'rmg-latn-no',
  rmh: 'rmh-latn-id',
  rmi: 'rmi-armn-am',
  rmk: 'rmk-latn-pg',
  rml: 'rml-latn-pl',
  'rml-cyrl': 'rml-cyrl-by',
  rmm: 'rmm-latn-id',
  rmn: 'rmn-latn-rs',
  'rmn-cyrl': 'rmn-cyrl-bg',
  'rmn-grek': 'rmn-grek-gr',
  rmo: 'rmo-latn-ch',
  rmp: 'rmp-latn-pg',
  rmq: 'rmq-latn-es',
  rmt: 'rmt-arab-ir',
  rmu: 'rmu-latn-se',
  rmw: 'rmw-latn-gb',
  rmx: 'rmx-latn-vn',
  rmz: 'rmz-mymr-in',
  rn: 'rn-latn-bi',
  rna: 'rna-latn-zz',
  rnd: 'rnd-latn-cd',
  rng: 'rng-latn-mz',
  rnl: 'rnl-latn-in',
  rnn: 'rnn-latn-id',
  rnr: 'rnr-latn-au',
  rnw: 'rnw-latn-tz',
  ro: 'ro-latn-ro',
  rob: 'rob-latn-id',
  roc: 'roc-latn-vn',
  rod: 'rod-latn-ng',
  roe: 'roe-latn-pg',
  rof: 'rof-latn-tz',
  rog: 'rog-latn-vn',
  rol: 'rol-latn-ph',
  rom: 'rom-latn-ro',
  'rom-cyrl': 'rom-cyrl-ro',
  roo: 'roo-latn-zz',
  rop: 'rop-latn-au',
  ror: 'ror-latn-id',
  rou: 'rou-latn-td',
  row: 'row-latn-id',
  rpn: 'rpn-latn-vu',
  rpt: 'rpt-latn-pg',
  rri: 'rri-latn-sb',
  rro: 'rro-latn-zz',
  rrt: 'rrt-latn-au',
  rsk: 'rsk-cyrl-rs',
  rtc: 'rtc-latn-mm',
  rth: 'rth-latn-id',
  rtm: 'rtm-latn-fj',
  rtw: 'rtw-deva-in',
  ru: 'ru-cyrl-ru',
  rub: 'rub-latn-ug',
  ruc: 'ruc-latn-ug',
  rue: 'rue-cyrl-ua',
  ruf: 'ruf-latn-tz',
  rug: 'rug-latn-sb',
  rui: 'rui-latn-tz',
  ruk: 'ruk-latn-ng',
  ruo: 'ruo-latn-hr',
  rup: 'rup-latn-ro',
  'rup-grek': 'rup-grek-gr',
  ruq: 'ruq-latn-gr',
  rut: 'rut-cyrl-ru',
  'rut-latn': 'rut-latn-az',
  ruu: 'ruu-latn-my',
  ruy: 'ruy-latn-ng',
  ruz: 'ruz-latn-ng',
  rw: 'rw-latn-rw',
  rwa: 'rwa-latn-pg',
  rwk: 'rwk-latn-tz',
  rwl: 'rwl-latn-tz',
  rwm: 'rwm-latn-ug',
  rwo: 'rwo-latn-zz',
  rwr: 'rwr-deva-in',
  rxd: 'rxd-latn-au',
  rxw: 'rxw-latn-au',
  ryu: 'ryu-kana-jp',
  sa: 'sa-deva-in',
  saa: 'saa-latn-td',
  sab: 'sab-latn-pa',
  sac: 'sac-latn-us',
  sad: 'sad-latn-tz',
  sae: 'sae-latn-br',
  saf: 'saf-latn-gh',
  sah: 'sah-cyrl-ru',
  saj: 'saj-latn-id',
  sak: 'sak-latn-ga',
  sam: 'sam-samr-ps',
  'sam-hebr': 'sam-hebr-ps',
  'sam-syrc': 'sam-syrc-ps',
  sao: 'sao-latn-id',
  saq: 'saq-latn-ke',
  sar: 'sar-latn-bo',
  sas: 'sas-latn-id',
  sat: 'sat-olck-in',
  sau: 'sau-latn-id',
  sav: 'sav-latn-sn',
  saw: 'saw-latn-id',
  sax: 'sax-latn-vu',
  say: 'say-latn-ng',
  saz: 'saz-saur-in',
  sba: 'sba-latn-zz',
  sbb: 'sbb-latn-sb',
  sbc: 'sbc-latn-pg',
  sbd: 'sbd-latn-bf',
  sbe: 'sbe-latn-zz',
  sbg: 'sbg-latn-id',
  sbh: 'sbh-latn-pg',
  sbi: 'sbi-latn-pg',
  sbj: 'sbj-latn-td',
  sbk: 'sbk-latn-tz',
  sbl: 'sbl-latn-ph',
  sbm: 'sbm-latn-tz',
  sbn: 'sbn-arab-pk',
  sbo: 'sbo-latn-my',
  sbp: 'sbp-latn-tz',
  sbq: 'sbq-latn-pg',
  sbr: 'sbr-latn-id',
  sbs: 'sbs-latn-na',
  sbt: 'sbt-latn-id',
  sbu: 'sbu-tibt-in',
  'sbu-deva': 'sbu-deva-in',
  sbv: 'sbv-latn-it',
  sbw: 'sbw-latn-ga',
  sbx: 'sbx-latn-id',
  sby: 'sby-latn-zm',
  sbz: 'sbz-latn-cf',
  sc: 'sc-latn-it',
  scb: 'scb-latn-vn',
  sce: 'sce-latn-cn',
  'sce-arab': 'sce-arab-cn',
  scf: 'scf-latn-pa',
  scg: 'scg-latn-id',
  sch: 'sch-latn-in',
  sci: 'sci-latn-lk',
  sck: 'sck-deva-in',
  scl: 'scl-arab-zz',
  scn: 'scn-latn-it',
  sco: 'sco-latn-gb',
  scp: 'scp-deva-np',
  scs: 'scs-latn-ca',
  'scs-cans': 'scs-cans-ca',
  sct: 'sct-laoo-la',
  scu: 'scu-takr-in',
  scv: 'scv-latn-ng',
  scw: 'scw-latn-ng',
  scx: 'scx-grek-it',
  sd: 'sd-arab-pk',
  'sd-deva': 'sd-deva-in',
  'sd-in': 'sd-deva-in',
  'sd-khoj': 'sd-khoj-in',
  'sd-sind': 'sd-sind-in',
  sda: 'sda-latn-id',
  sdb: 'sdb-arab-iq',
  sdc: 'sdc-latn-it',
  sde: 'sde-latn-ng',
  sdf: 'sdf-arab-iq',
  sdg: 'sdg-arab-af',
  sdh: 'sdh-arab-ir',
  sdj: 'sdj-latn-cg',
  sdk: 'sdk-latn-pg',
  sdn: 'sdn-latn-it',
  sdo: 'sdo-latn-my',
  sdq: 'sdq-latn-id',
  sds: 'sds-arab-tn',
  sdu: 'sdu-latn-id',
  sdx: 'sdx-latn-my',
  se: 'se-latn-no',
  sea: 'sea-latn-my',
  seb: 'seb-latn-ci',
  sec: 'sec-latn-ca',
  sed: 'sed-latn-vn',
  see: 'see-latn-us',
  sef: 'sef-latn-ci',
  seg: 'seg-latn-tz',
  seh: 'seh-latn-mz',
  sei: 'sei-latn-mx',
  sej: 'sej-latn-pg',
  sek: 'sek-latn-ca',
  'sek-cans': 'sek-cans-ca',
  sel: 'sel-cyrl-ru',
  sen: 'sen-latn-bf',
  seo: 'seo-latn-pg',
  sep: 'sep-latn-bf',
  seq: 'seq-latn-bf',
  ser: 'ser-latn-us',
  ses: 'ses-latn-ml',
  set: 'set-latn-id',
  seu: 'seu-latn-id',
  sev: 'sev-latn-ci',
  sew: 'sew-latn-pg',
  sey: 'sey-latn-ec',
  sez: 'sez-latn-mm',
  sfe: 'sfe-latn-ph',
  sfm: 'sfm-plrd-cn',
  sfw: 'sfw-latn-gh',
  sg: 'sg-latn-cf',
  sga: 'sga-ogam-ie',
  sgb: 'sgb-latn-ph',
  sgc: 'sgc-latn-ke',
  sgd: 'sgd-latn-ph',
  sge: 'sge-latn-id',
  sgh: 'sgh-cyrl-tj',
  'sgh-arab': 'sgh-arab-af',
  'sgh-latn': 'sgh-latn-tj',
  sgi: 'sgi-latn-cm',
  sgj: 'sgj-deva-in',
  sgm: 'sgm-latn-ke',
  sgp: 'sgp-latn-in',
  sgr: 'sgr-arab-ir',
  sgs: 'sgs-latn-lt',
  sgt: 'sgt-tibt-bt',
  sgu: 'sgu-latn-id',
  sgw: 'sgw-ethi-zz',
  sgy: 'sgy-arab-af',
  sgz: 'sgz-latn-zz',
  sha: 'sha-latn-ng',
  shb: 'shb-latn-br',
  shc: 'shc-latn-cd',
  shd: 'shd-arab-pk',
  she: 'she-latn-et',
  shg: 'shg-latn-bw',
  shh: 'shh-latn-us',
  shi: 'shi-tfng-ma',
  shj: 'shj-latn-sd',
  shk: 'shk-latn-zz',
  shm: 'shm-arab-ir',
  shn: 'shn-mymr-mm',
  sho: 'sho-latn-ng',
  shp: 'shp-latn-pe',
  shq: 'shq-latn-zm',
  shr: 'shr-latn-cd',
  shs: 'shs-latn-ca',
  sht: 'sht-latn-us',
  shu: 'shu-arab-zz',
  shv: 'shv-arab-om',
  shw: 'shw-latn-sd',
  shy: 'shy-latn-dz',
  'shy-arab': 'shy-arab-dz',
  'shy-tfng': 'shy-tfng-dz',
  shz: 'shz-latn-ml',
  si: 'si-sinh-lk',
  sia: 'sia-cyrl-ru',
  sib: 'sib-latn-my',
  sid: 'sid-latn-et',
  sie: 'sie-latn-zm',
  sif: 'sif-latn-bf',
  sig: 'sig-latn-zz',
  sih: 'sih-latn-nc',
  sii: 'sii-latn-in',
  sij: 'sij-latn-pg',
  sik: 'sik-latn-br',
  sil: 'sil-latn-zz',
  sim: 'sim-latn-zz',
  sip: 'sip-tibt-in',
  siq: 'siq-latn-pg',
  sir: 'sir-latn-ng',
  sis: 'sis-latn-us',
  siu: 'siu-latn-pg',
  siv: 'siv-latn-pg',
  siw: 'siw-latn-pg',
  six: 'six-latn-pg',
  siy: 'siy-arab-ir',
  siz: 'siz-arab-eg',
  sja: 'sja-latn-co',
  sjb: 'sjb-latn-id',
  sjd: 'sjd-cyrl-ru',
  sje: 'sje-latn-se',
  sjg: 'sjg-latn-td',
  sjl: 'sjl-latn-in',
  sjm: 'sjm-latn-ph',
  sjp: 'sjp-deva-in',
  'sjp-beng': 'sjp-beng-in',
  sjr: 'sjr-latn-zz',
  sjt: 'sjt-cyrl-ru',
  sju: 'sju-latn-se',
  sjw: 'sjw-latn-us',
  sk: 'sk-latn-sk',
  ska: 'ska-latn-us',
  skb: 'skb-thai-th',
  skc: 'skc-latn-zz',
  skd: 'skd-latn-us',
  ske: 'ske-latn-vu',
  skf: 'skf-latn-br',
  skg: 'skg-latn-mg',
  skh: 'skh-latn-id',
  ski: 'ski-latn-id',
  skj: 'skj-deva-np',
  skm: 'skm-latn-pg',
  skn: 'skn-latn-ph',
  sko: 'sko-latn-id',
  skp: 'skp-latn-my',
  skq: 'skq-latn-bf',
  skr: 'skr-arab-pk',
  sks: 'sks-latn-zz',
  skt: 'skt-latn-cd',
  sku: 'sku-latn-vu',
  skv: 'skv-latn-id',
  skw: 'skw-latn-gy',
  skx: 'skx-latn-id',
  sky: 'sky-latn-sb',
  skz: 'skz-latn-id',
  sl: 'sl-latn-si',
  slc: 'slc-latn-co',
  sld: 'sld-latn-zz',
  slg: 'slg-latn-id',
  slh: 'slh-latn-us',
  sli: 'sli-latn-pl',
  slj: 'slj-latn-br',
  sll: 'sll-latn-zz',
  slm: 'slm-latn-ph',
  sln: 'sln-latn-us',
  slp: 'slp-latn-id',
  slq: 'slq-arab-ir',
  slr: 'slr-latn-cn',
  slu: 'slu-latn-id',
  slw: 'slw-latn-pg',
  slx: 'slx-latn-cd',
  sly: 'sly-latn-id',
  slz: 'slz-latn-id',
  sm: 'sm-latn-ws',
  sma: 'sma-latn-se',
  smb: 'smb-latn-pg',
  smc: 'smc-latn-pg',
  smd: 'smd-latn-ao',
  smf: 'smf-latn-pg',
  smg: 'smg-latn-pg',
  smh: 'smh-yiii-cn',
  smj: 'smj-latn-se',
  smk: 'smk-latn-ph',
  sml: 'sml-latn-ph',
  smn: 'smn-latn-fi',
  smp: 'smp-samr-il',
  smq: 'smq-latn-zz',
  smr: 'smr-latn-id',
  sms: 'sms-latn-fi',
  smt: 'smt-latn-in',
  smu: 'smu-khmr-kh',
  smw: 'smw-latn-id',
  smx: 'smx-latn-cd',
  smy: 'smy-arab-ir',
  smz: 'smz-latn-pg',
  sn: 'sn-latn-zw',
  snb: 'snb-latn-my',
  snc: 'snc-latn-zz',
  sne: 'sne-latn-my',
  snf: 'snf-latn-sn',
  sng: 'sng-latn-cd',
  'sng-brai': 'sng-brai-cd',
  sni: 'sni-latn-pe',
  snj: 'snj-latn-cf',
  snk: 'snk-latn-ml',
  snl: 'snl-latn-ph',
  snm: 'snm-latn-ug',
  snn: 'snn-latn-co',
  sno: 'sno-latn-us',
  snp: 'snp-latn-zz',
  snq: 'snq-latn-ga',
  snr: 'snr-latn-pg',
  sns: 'sns-latn-vu',
  snu: 'snu-latn-id',
  snv: 'snv-latn-my',
  snw: 'snw-latn-gh',
  snx: 'snx-latn-zz',
  sny: 'sny-latn-zz',
  snz: 'snz-latn-pg',
  so: 'so-latn-so',
  soa: 'soa-tavt-th',
  'soa-thai': 'soa-thai-th',
  sob: 'sob-latn-id',
  soc: 'soc-latn-cd',
  sod: 'sod-latn-cd',
  soe: 'soe-latn-cd',
  sog: 'sog-sogd-uz',
  soi: 'soi-deva-np',
  sok: 'sok-latn-zz',
  sol: 'sol-latn-pg',
  soo: 'soo-latn-cd',
  sop: 'sop-latn-cd',
  soq: 'soq-latn-zz',
  sor: 'sor-latn-td',
  sos: 'sos-latn-bf',
  sou: 'sou-thai-th',
  sov: 'sov-latn-pw',
  sow: 'sow-latn-pg',
  sox: 'sox-latn-cm',
  soy: 'soy-latn-zz',
  soz: 'soz-latn-tz',
  spb: 'spb-latn-id',
  spc: 'spc-latn-ve',
  spd: 'spd-latn-zz',
  spe: 'spe-latn-pg',
  spg: 'spg-latn-my',
  spi: 'spi-latn-id',
  spk: 'spk-latn-pg',
  spl: 'spl-latn-zz',
  spm: 'spm-latn-pg',
  spn: 'spn-latn-py',
  spo: 'spo-latn-us',
  spp: 'spp-latn-ml',
  spq: 'spq-latn-pe',
  spr: 'spr-latn-id',
  sps: 'sps-latn-zz',
  spt: 'spt-tibt-in',
  spv: 'spv-orya-in',
  sq: 'sq-latn-al',
  sqa: 'sqa-latn-ng',
  sqh: 'sqh-latn-ng',
  sqm: 'sqm-latn-cf',
  sqo: 'sqo-arab-ir',
  sqq: 'sqq-laoo-la',
  sqt: 'sqt-arab-ye',
  'sqt-latn': 'sqt-latn-ye',
  squ: 'squ-latn-ca',
  sr: 'sr-cyrl-rs',
  'sr-me': 'sr-latn-me',
  'sr-ro': 'sr-latn-ro',
  'sr-ru': 'sr-latn-ru',
  'sr-tr': 'sr-latn-tr',
  sra: 'sra-latn-pg',
  srb: 'srb-sora-in',
  sre: 'sre-latn-id',
  srf: 'srf-latn-pg',
  srg: 'srg-latn-ph',
  srh: 'srh-arab-cn',
  sri: 'sri-latn-co',
  srk: 'srk-latn-my',
  srl: 'srl-latn-id',
  srm: 'srm-latn-sr',
  srn: 'srn-latn-sr',
  sro: 'sro-latn-it',
  srq: 'srq-latn-bo',
  srr: 'srr-latn-sn',
  srs: 'srs-latn-ca',
  srt: 'srt-latn-id',
  sru: 'sru-latn-br',
  srv: 'srv-latn-ph',
  srw: 'srw-latn-id',
  srx: 'srx-deva-in',
  sry: 'sry-latn-pg',
  srz: 'srz-arab-ir',
  ss: 'ss-latn-za',
  ssb: 'ssb-latn-ph',
  ssc: 'ssc-latn-tz',
  ssd: 'ssd-latn-zz',
  sse: 'sse-latn-ph',
  'sse-arab': 'sse-arab-ph',
  ssf: 'ssf-latn-tw',
  ssg: 'ssg-latn-zz',
  ssh: 'ssh-arab-ae',
  ssj: 'ssj-latn-pg',
  ssl: 'ssl-latn-gh',
  ssm: 'ssm-latn-my',
  ssn: 'ssn-latn-ke',
  sso: 'sso-latn-pg',
  ssq: 'ssq-latn-id',
  sss: 'sss-laoo-la',
  'sss-thai': 'sss-thai-th',
  sst: 'sst-latn-pg',
  ssu: 'ssu-latn-pg',
  ssv: 'ssv-latn-vu',
  ssx: 'ssx-latn-pg',
  ssy: 'ssy-latn-er',
  ssz: 'ssz-latn-pg',
  st: 'st-latn-za',
  sta: 'sta-latn-zm',
  stb: 'stb-latn-ph',
  ste: 'ste-latn-id',
  stf: 'stf-latn-pg',
  stg: 'stg-latn-vn',
  sth: 'sth-latn-ie',
  sti: 'sti-latn-vn',
  'sti-kh': 'sti-latn-kh',
  stj: 'stj-latn-bf',
  stk: 'stk-latn-zz',
  stl: 'stl-latn-nl',
  stm: 'stm-latn-pg',
  stn: 'stn-latn-sb',
  sto: 'sto-latn-ca',
  stp: 'stp-latn-mx',
  stq: 'stq-latn-de',
  str: 'str-latn-ca',
  sts: 'sts-arab-af',
  stt: 'stt-latn-vn',
  stv: 'stv-ethi-et',
  'stv-arab': 'stv-arab-et',
  stw: 'stw-latn-fm',
  sty: 'sty-cyrl-ru',
  su: 'su-latn-id',
  sua: 'sua-latn-zz',
  sub: 'sub-latn-cd',
  suc: 'suc-latn-ph',
  sue: 'sue-latn-zz',
  sug: 'sug-latn-pg',
  sui: 'sui-latn-pg',
  suj: 'suj-latn-tz',
  suk: 'suk-latn-tz',
  suo: 'suo-latn-pg',
  suq: 'suq-latn-et',
  'suq-ethi': 'suq-ethi-et',
  sur: 'sur-latn-zz',
  sus: 'sus-latn-gn',
  sut: 'sut-latn-ni',
  suv: 'suv-latn-in',
  'suv-beng': 'suv-beng-in',
  'suv-deva': 'suv-deva-in',
  suw: 'suw-latn-tz',
  suy: 'suy-latn-br',
  suz: 'suz-deva-np',
  sv: 'sv-latn-se',
  sva: 'sva-geor-ge',
  'sva-cyrl': 'sva-cyrl-ge',
  'sva-latn': 'sva-latn-ge',
  svb: 'svb-latn-pg',
  svc: 'svc-latn-vc',
  sve: 'sve-latn-id',
  svm: 'svm-latn-it',
  svs: 'svs-latn-sb',
  sw: 'sw-latn-tz',
  swb: 'swb-arab-yt',
  swc: 'swc-latn-cd',
  swf: 'swf-latn-cd',
  swg: 'swg-latn-de',
  swi: 'swi-hani-cn',
  swj: 'swj-latn-ga',
  swk: 'swk-latn-mw',
  swm: 'swm-latn-pg',
  swo: 'swo-latn-br',
  swp: 'swp-latn-zz',
  swq: 'swq-latn-cm',
  swr: 'swr-latn-id',
  sws: 'sws-latn-id',
  swt: 'swt-latn-id',
  swu: 'swu-latn-id',
  swv: 'swv-deva-in',
  sww: 'sww-latn-vu',
  swx: 'swx-latn-br',
  swy: 'swy-latn-td',
  sxb: 'sxb-latn-ke',
  sxe: 'sxe-latn-ga',
  sxn: 'sxn-latn-id',
  sxr: 'sxr-latn-tw',
  sxs: 'sxs-latn-ng',
  sxu: 'sxu-latn-de',
  'sxu-runr': 'sxu-runr-de',
  sxw: 'sxw-latn-zz',
  sya: 'sya-latn-id',
  syb: 'syb-latn-ph',
  syc: 'syc-syrc-tr',
  syi: 'syi-latn-ga',
  syk: 'syk-latn-ng',
  syl: 'syl-beng-bd',
  sym: 'sym-latn-bf',
  syn: 'syn-syrc-ir',
  syo: 'syo-latn-kh',
  syr: 'syr-syrc-iq',
  sys: 'sys-latn-td',
  syw: 'syw-deva-np',
  syx: 'syx-latn-ga',
  sza: 'sza-latn-my',
  szb: 'szb-latn-id',
  szc: 'szc-latn-my',
  szd: 'szd-latn-my',
  szg: 'szg-latn-cd',
  szl: 'szl-latn-pl',
  szn: 'szn-latn-id',
  szp: 'szp-latn-id',
  szv: 'szv-latn-cm',
  szw: 'szw-latn-id',
  szy: 'szy-latn-tw',
  ta: 'ta-taml-in',
  taa: 'taa-latn-us',
  tab: 'tab-cyrl-ru',
  tac: 'tac-latn-mx',
  tad: 'tad-latn-id',
  tae: 'tae-latn-br',
  taf: 'taf-latn-br',
  tag: 'tag-latn-sd',
  taj: 'taj-deva-np',
  tak: 'tak-latn-ng',
  tal: 'tal-latn-zz',
  tan: 'tan-latn-zz',
  tao: 'tao-latn-tw',
  tap: 'tap-latn-cd',
  taq: 'taq-latn-zz',
  tar: 'tar-latn-mx',
  tas: 'tas-latn-vn',
  tau: 'tau-latn-us',
  tav: 'tav-latn-co',
  taw: 'taw-latn-pg',
  tax: 'tax-latn-td',
  tay: 'tay-latn-tw',
  'tay-hans': 'tay-hans-tw',
  'tay-hant': 'tay-hant-tw',
  taz: 'taz-latn-sd',
  tba: 'tba-latn-br',
  tbc: 'tbc-latn-zz',
  tbd: 'tbd-latn-zz',
  tbe: 'tbe-latn-sb',
  tbf: 'tbf-latn-zz',
  tbg: 'tbg-latn-zz',
  tbh: 'tbh-latn-au',
  tbi: 'tbi-latn-sd',
  tbj: 'tbj-latn-pg',
  tbk: 'tbk-tagb-ph',
  'tbk-hano': 'tbk-hano-ph',
  'tbk-latn': 'tbk-latn-ph',
  tbl: 'tbl-latn-ph',
  tbm: 'tbm-latn-cd',
  tbn: 'tbn-latn-co',
  tbo: 'tbo-latn-zz',
  tbp: 'tbp-latn-id',
  tbs: 'tbs-latn-pg',
  tbt: 'tbt-latn-cd',
  tbu: 'tbu-latn-mx',
  tbv: 'tbv-latn-pg',
  tbw: 'tbw-latn-ph',
  tbx: 'tbx-latn-pg',
  tby: 'tby-latn-id',
  tbz: 'tbz-latn-zz',
  tca: 'tca-latn-br',
  tcb: 'tcb-latn-us',
  tcc: 'tcc-latn-tz',
  tcd: 'tcd-latn-gh',
  tce: 'tce-latn-ca',
  tcf: 'tcf-latn-mx',
  tcg: 'tcg-latn-id',
  tch: 'tch-latn-tc',
  tci: 'tci-latn-zz',
  tck: 'tck-latn-ga',
  tcm: 'tcm-latn-id',
  tcn: 'tcn-tibt-np',
  tco: 'tco-mymr-mm',
  tcp: 'tcp-latn-mm',
  tcq: 'tcq-latn-id',
  tcs: 'tcs-latn-au',
  tcu: 'tcu-latn-mx',
  tcw: 'tcw-latn-mx',
  tcx: 'tcx-taml-in',
  tcy: 'tcy-knda-in',
  tcz: 'tcz-latn-in',
  tda: 'tda-tfng-ne',
  'tda-arab': 'tda-arab-ne',
  'tda-latn': 'tda-latn-ne',
  tdb: 'tdb-deva-in',
  'tdb-beng': 'tdb-beng-in',
  'tdb-kthi': 'tdb-kthi-in',
  tdc: 'tdc-latn-co',
  tdd: 'tdd-tale-cn',
  tde: 'tde-latn-ml',
  tdg: 'tdg-deva-np',
  tdh: 'tdh-deva-np',
  tdi: 'tdi-latn-id',
  tdj: 'tdj-latn-id',
  tdk: 'tdk-latn-ng',
  tdl: 'tdl-latn-ng',
  tdm: 'tdm-latn-gy',
  tdn: 'tdn-latn-id',
  tdo: 'tdo-latn-ng',
  tdq: 'tdq-latn-ng',
  tdr: 'tdr-latn-vn',
  tds: 'tds-latn-id',
  tdt: 'tdt-latn-tl',
  tdu: 'tdu-latn-my',
  tdv: 'tdv-latn-ng',
  tdx: 'tdx-latn-mg',
  tdy: 'tdy-latn-ph',
  te: 'te-telu-in',
  tea: 'tea-latn-my',
  teb: 'teb-latn-ec',
  tec: 'tec-latn-ke',
  ted: 'ted-latn-zz',
  tee: 'tee-latn-mx',
  teg: 'teg-latn-ga',
  teh: 'teh-latn-ar',
  tei: 'tei-latn-pg',
  tek: 'tek-latn-cd',
  tem: 'tem-latn-sl',
  ten: 'ten-latn-co',
  teo: 'teo-latn-ug',
  tep: 'tep-latn-mx',
  teq: 'teq-latn-sd',
  ter: 'ter-latn-br',
  tes: 'tes-java-id',
  tet: 'tet-latn-tl',
  teu: 'teu-latn-ug',
  tev: 'tev-latn-id',
  tew: 'tew-latn-us',
  tex: 'tex-latn-ss',
  tey: 'tey-latn-sd',
  tfi: 'tfi-latn-zz',
  tfn: 'tfn-latn-us',
  tfo: 'tfo-latn-id',
  tfr: 'tfr-latn-pa',
  tft: 'tft-latn-id',
  tg: 'tg-cyrl-tj',
  'tg-arab': 'tg-arab-pk',
  'tg-pk': 'tg-arab-pk',
  tga: 'tga-latn-ke',
  tgb: 'tgb-latn-my',
  tgc: 'tgc-latn-zz',
  tgd: 'tgd-latn-ng',
  tge: 'tge-deva-np',
  tgf: 'tgf-tibt-bt',
  tgh: 'tgh-latn-tt',
  tgi: 'tgi-latn-pg',
  tgj: 'tgj-latn-in',
  tgn: 'tgn-latn-ph',
  tgo: 'tgo-latn-zz',
  tgp: 'tgp-latn-vu',
  tgq: 'tgq-latn-my',
  tgs: 'tgs-latn-vu',
  tgt: 'tgt-latn-ph',
  'tgt-hano': 'tgt-hano-ph',
  'tgt-tagb': 'tgt-tagb-ph',
  tgu: 'tgu-latn-zz',
  tgv: 'tgv-latn-br',
  tgw: 'tgw-latn-ci',
  tgx: 'tgx-latn-ca',
  tgy: 'tgy-latn-ss',
  tgz: 'tgz-latn-au',
  th: 'th-thai-th',
  thd: 'thd-latn-au',
  the: 'the-deva-np',
  thf: 'thf-deva-np',
  thh: 'thh-latn-mx',
  thi: 'thi-tale-la',
  thk: 'thk-latn-ke',
  thl: 'thl-deva-np',
  thm: 'thm-thai-th',
  thp: 'thp-latn-ca',
  'thp-dupl': 'thp-dupl-ca',
  thq: 'thq-deva-np',
  thr: 'thr-deva-np',
  ths: 'ths-deva-np',
  tht: 'tht-latn-ca',
  thu: 'thu-latn-ss',
  thv: 'thv-latn-dz',
  'thv-arab': 'thv-arab-dz',
  'thv-tfng': 'thv-tfng-dz',
  thy: 'thy-latn-ng',
  thz: 'thz-latn-ne',
  'thz-tfng': 'thz-tfng-ne',
  ti: 'ti-ethi-et',
  tic: 'tic-latn-sd',
  tif: 'tif-latn-zz',
  tig: 'tig-ethi-er',
  tih: 'tih-latn-my',
  tii: 'tii-latn-cd',
  tij: 'tij-deva-np',
  tik: 'tik-latn-zz',
  til: 'til-latn-us',
  tim: 'tim-latn-zz',
  tin: 'tin-cyrl-ru',
  tio: 'tio-latn-zz',
  tip: 'tip-latn-id',
  tiq: 'tiq-latn-bf',
  tis: 'tis-latn-ph',
  tit: 'tit-latn-co',
  tiu: 'tiu-latn-ph',
  tiv: 'tiv-latn-ng',
  tiw: 'tiw-latn-au',
  tix: 'tix-latn-us',
  tiy: 'tiy-latn-ph',
  tja: 'tja-latn-lr',
  tjg: 'tjg-latn-id',
  tji: 'tji-latn-cn',
  tjj: 'tjj-latn-au',
  tjl: 'tjl-mymr-mm',
  tjn: 'tjn-latn-ci',
  tjo: 'tjo-arab-dz',
  tjp: 'tjp-latn-au',
  tjs: 'tjs-latn-cn',
  tju: 'tju-latn-au',
  tjw: 'tjw-latn-au',
  tk: 'tk-latn-tm',
  tka: 'tka-latn-br',
  tkb: 'tkb-deva-in',
  tkd: 'tkd-latn-tl',
  tke: 'tke-latn-mz',
  tkf: 'tkf-latn-br',
  tkg: 'tkg-latn-mg',
  tkl: 'tkl-latn-tk',
  tkp: 'tkp-latn-sb',
  tkq: 'tkq-latn-ng',
  tkr: 'tkr-latn-az',
  tks: 'tks-arab-ir',
  tkt: 'tkt-deva-np',
  tku: 'tku-latn-mx',
  tkv: 'tkv-latn-pg',
  tkw: 'tkw-latn-sb',
  tkx: 'tkx-latn-id',
  tkz: 'tkz-latn-vn',
  tl: 'tl-latn-ph',
  tla: 'tla-latn-mx',
  tlb: 'tlb-latn-id',
  tlc: 'tlc-latn-mx',
  tld: 'tld-latn-id',
  tlf: 'tlf-latn-zz',
  tlg: 'tlg-latn-id',
  tli: 'tli-latn-us',
  'tli-cyrl': 'tli-cyrl-us',
  tlj: 'tlj-latn-ug',
  tlk: 'tlk-latn-id',
  tll: 'tll-latn-cd',
  tlm: 'tlm-latn-vu',
  tln: 'tln-latn-id',
  tlp: 'tlp-latn-mx',
  tlq: 'tlq-latn-mm',
  tlr: 'tlr-latn-sb',
  tls: 'tls-latn-vu',
  tlt: 'tlt-latn-id',
  tlu: 'tlu-latn-id',
  tlv: 'tlv-latn-id',
  tlx: 'tlx-latn-zz',
  tly: 'tly-latn-az',
  tma: 'tma-latn-td',
  tmb: 'tmb-latn-vu',
  tmc: 'tmc-latn-td',
  tmd: 'tmd-latn-pg',
  tme: 'tme-latn-br',
  tmf: 'tmf-latn-py',
  tmg: 'tmg-latn-id',
  tmh: 'tmh-latn-ne',
  tmi: 'tmi-latn-vu',
  tmj: 'tmj-latn-id',
  tmk: 'tmk-deva-np',
  tml: 'tml-latn-id',
  tmm: 'tmm-latn-vn',
  tmn: 'tmn-latn-id',
  tmo: 'tmo-latn-my',
  tmq: 'tmq-latn-pg',
  tmr: 'tmr-syrc-il',
  tmt: 'tmt-latn-vu',
  tmu: 'tmu-latn-id',
  tmv: 'tmv-latn-cd',
  tmw: 'tmw-latn-my',
  tmy: 'tmy-latn-zz',
  tmz: 'tmz-latn-ve',
  tn: 'tn-latn-za',
  tna: 'tna-latn-bo',
  tnb: 'tnb-latn-co',
  tnc: 'tnc-latn-co',
  tnd: 'tnd-latn-co',
  tng: 'tng-latn-td',
  tnh: 'tnh-latn-zz',
  tni: 'tni-latn-id',
  tnk: 'tnk-latn-vu',
  tnl: 'tnl-latn-vu',
  tnm: 'tnm-latn-id',
  tnn: 'tnn-latn-vu',
  tno: 'tno-latn-bo',
  tnp: 'tnp-latn-vu',
  tnq: 'tnq-latn-pr',
  tnr: 'tnr-latn-sn',
  tns: 'tns-latn-pg',
  tnt: 'tnt-latn-id',
  tnv: 'tnv-cakm-bd',
  tnw: 'tnw-latn-id',
  tnx: 'tnx-latn-sb',
  tny: 'tny-latn-tz',
  to: 'to-latn-to',
  tob: 'tob-latn-ar',
  toc: 'toc-latn-mx',
  tod: 'tod-latn-gn',
  tof: 'tof-latn-zz',
  tog: 'tog-latn-mw',
  toh: 'toh-latn-mz',
  toi: 'toi-latn-zm',
  toj: 'toj-latn-mx',
  tok: 'tok-latn-001',
  tol: 'tol-latn-us',
  tom: 'tom-latn-id',
  too: 'too-latn-mx',
  top: 'top-latn-mx',
  toq: 'toq-latn-zz',
  tor: 'tor-latn-cd',
  tos: 'tos-latn-mx',
  tou: 'tou-latn-vn',
  tov: 'tov-arab-ir',
  tow: 'tow-latn-us',
  tox: 'tox-latn-pw',
  toy: 'toy-latn-id',
  toz: 'toz-latn-cm',
  tpa: 'tpa-latn-pg',
  tpc: 'tpc-latn-mx',
  tpe: 'tpe-latn-bd',
  'tpe-beng': 'tpe-beng-bd',
  tpf: 'tpf-latn-id',
  tpg: 'tpg-latn-id',
  tpi: 'tpi-latn-pg',
  tpj: 'tpj-latn-py',
  tpk: 'tpk-latn-br',
  tpl: 'tpl-latn-mx',
  tpm: 'tpm-latn-zz',
  tpn: 'tpn-latn-br',
  tpp: 'tpp-latn-mx',
  tpr: 'tpr-latn-br',
  tpt: 'tpt-latn-mx',
  tpu: 'tpu-khmr-kh',
  tpv: 'tpv-latn-mp',
  tpx: 'tpx-latn-mx',
  tpy: 'tpy-latn-br',
  tpz: 'tpz-latn-zz',
  tqb: 'tqb-latn-br',
  tql: 'tql-latn-vu',
  tqm: 'tqm-latn-pg',
  tqn: 'tqn-latn-us',
  tqo: 'tqo-latn-zz',
  tqp: 'tqp-latn-pg',
  tqt: 'tqt-latn-mx',
  tqu: 'tqu-latn-sb',
  tqw: 'tqw-latn-us',
  tr: 'tr-latn-tr',
  tra: 'tra-arab-af',
  trb: 'trb-latn-pg',
  trc: 'trc-latn-mx',
  tre: 'tre-latn-id',
  trf: 'trf-latn-tt',
  trg: 'trg-hebr-il',
  trh: 'trh-latn-pg',
  tri: 'tri-latn-sr',
  trj: 'trj-latn-td',
  trl: 'trl-latn-gb',
  trm: 'trm-arab-af',
  trn: 'trn-latn-bo',
  tro: 'tro-latn-in',
  trp: 'trp-latn-in',
  'trp-beng': 'trp-beng-in',
  trq: 'trq-latn-mx',
  trr: 'trr-latn-pe',
  trs: 'trs-latn-mx',
  trt: 'trt-latn-id',
  tru: 'tru-latn-tr',
  trv: 'trv-latn-tw',
  trw: 'trw-arab-pk',
  trx: 'trx-latn-my',
  try: 'try-latn-in',
  trz: 'trz-latn-br',
  ts: 'ts-latn-za',
  tsa: 'tsa-latn-cg',
  tsb: 'tsb-latn-et',
  tsc: 'tsc-latn-mz',
  tsd: 'tsd-grek-gr',
  tsf: 'tsf-deva-np',
  tsg: 'tsg-latn-ph',
  tsh: 'tsh-latn-cm',
  tsi: 'tsi-latn-ca',
  tsj: 'tsj-tibt-bt',
  tsl: 'tsl-latn-vn',
  tsp: 'tsp-latn-bf',
  tsr: 'tsr-latn-vu',
  tst: 'tst-latn-ml',
  tsu: 'tsu-latn-tw',
  tsv: 'tsv-latn-ga',
  tsw: 'tsw-latn-zz',
  tsx: 'tsx-latn-pg',
  tsz: 'tsz-latn-mx',
  tt: 'tt-cyrl-ru',
  ttb: 'ttb-latn-ng',
  ttc: 'ttc-latn-gt',
  ttd: 'ttd-latn-zz',
  tte: 'tte-latn-zz',
  ttf: 'ttf-latn-cm',
  tth: 'tth-laoo-la',
  tti: 'tti-latn-id',
  ttj: 'ttj-latn-ug',
  ttk: 'ttk-latn-co',
  ttl: 'ttl-latn-zm',
  ttm: 'ttm-latn-ca',
  ttn: 'ttn-latn-id',
  tto: 'tto-laoo-la',
  ttp: 'ttp-latn-id',
  ttr: 'ttr-latn-zz',
  tts: 'tts-thai-th',
  ttt: 'ttt-latn-az',
  ttu: 'ttu-latn-pg',
  ttv: 'ttv-latn-pg',
  ttw: 'ttw-latn-my',
  tty: 'tty-latn-id',
  tua: 'tua-latn-pg',
  tub: 'tub-latn-us',
  tuc: 'tuc-latn-pg',
  tud: 'tud-latn-br',
  tue: 'tue-latn-co',
  tuf: 'tuf-latn-co',
  tug: 'tug-latn-td',
  tuh: 'tuh-latn-zz',
  tui: 'tui-latn-cm',
  tuj: 'tuj-latn-id',
  tul: 'tul-latn-zz',
  tum: 'tum-latn-mw',
  tun: 'tun-latn-us',
  tuo: 'tuo-latn-br',
  tuq: 'tuq-latn-zz',
  tus: 'tus-latn-ca',
  tuu: 'tuu-latn-us',
  tuv: 'tuv-latn-ke',
  tux: 'tux-latn-br',
  tuy: 'tuy-latn-ke',
  tuz: 'tuz-latn-bf',
  tva: 'tva-latn-sb',
  tvd: 'tvd-latn-zz',
  tve: 'tve-latn-id',
  tvk: 'tvk-latn-vu',
  tvl: 'tvl-latn-tv',
  tvm: 'tvm-latn-id',
  tvn: 'tvn-mymr-mm',
  tvo: 'tvo-latn-id',
  tvs: 'tvs-latn-ke',
  tvt: 'tvt-latn-in',
  tvu: 'tvu-latn-zz',
  tvw: 'tvw-latn-id',
  tvx: 'tvx-latn-tw',
  twa: 'twa-latn-us',
  twb: 'twb-latn-ph',
  twd: 'twd-latn-nl',
  twe: 'twe-latn-id',
  twf: 'twf-latn-us',
  twg: 'twg-latn-id',
  twh: 'twh-latn-zz',
  twl: 'twl-latn-mz',
  twm: 'twm-deva-in',
  twn: 'twn-latn-cm',
  two: 'two-latn-bw',
  twp: 'twp-latn-pg',
  twq: 'twq-latn-ne',
  twr: 'twr-latn-mx',
  twt: 'twt-latn-br',
  twu: 'twu-latn-id',
  tww: 'tww-latn-pg',
  twx: 'twx-latn-mz',
  twy: 'twy-latn-id',
  txa: 'txa-latn-my',
  txe: 'txe-latn-id',
  txg: 'txg-tang-cn',
  txi: 'txi-latn-br',
  txj: 'txj-latn-ng',
  txm: 'txm-latn-id',
  txn: 'txn-latn-id',
  txo: 'txo-toto-in',
  txq: 'txq-latn-id',
  txs: 'txs-latn-id',
  txt: 'txt-latn-id',
  txu: 'txu-latn-br',
  txx: 'txx-latn-my',
  txy: 'txy-latn-mg',
  ty: 'ty-latn-pf',
  tya: 'tya-latn-zz',
  tye: 'tye-latn-ng',
  tyh: 'tyh-latn-vn',
  tyi: 'tyi-latn-cg',
  tyj: 'tyj-latn-vn',
  tyl: 'tyl-latn-vn',
  tyn: 'tyn-latn-id',
  typ: 'typ-latn-au',
  tyr: 'tyr-tavt-vn',
  tys: 'tys-latn-vn',
  tyt: 'tyt-latn-vn',
  'tyt-tavt': 'tyt-tavt-vn',
  tyu: 'tyu-latn-bw',
  tyv: 'tyv-cyrl-ru',
  tyx: 'tyx-latn-cg',
  tyy: 'tyy-latn-ng',
  tyz: 'tyz-latn-vn',
  tzh: 'tzh-latn-mx',
  tzj: 'tzj-latn-gt',
  tzl: 'tzl-latn-001',
  tzm: 'tzm-latn-ma',
  tzn: 'tzn-latn-id',
  tzo: 'tzo-latn-mx',
  tzx: 'tzx-latn-pg',
  uam: 'uam-latn-br',
  uar: 'uar-latn-pg',
  uba: 'uba-latn-ng',
  ubi: 'ubi-latn-td',
  ubl: 'ubl-latn-ph',
  ubr: 'ubr-latn-pg',
  ubu: 'ubu-latn-zz',
  uda: 'uda-latn-ng',
  ude: 'ude-cyrl-ru',
  udg: 'udg-mlym-in',
  udi: 'udi-aghb-ru',
  udj: 'udj-latn-id',
  udl: 'udl-latn-cm',
  udm: 'udm-cyrl-ru',
  udu: 'udu-latn-sd',
  ues: 'ues-latn-id',
  ufi: 'ufi-latn-pg',
  ug: 'ug-arab-cn',
  'ug-cyrl': 'ug-cyrl-kz',
  'ug-kz': 'ug-cyrl-kz',
  'ug-mn': 'ug-cyrl-mn',
  uga: 'uga-ugar-sy',
  ugb: 'ugb-latn-au',
  uge: 'uge-latn-sb',
  ugh: 'ugh-cyrl-ru',
  ugo: 'ugo-thai-th',
  uha: 'uha-latn-ng',
  uhn: 'uhn-latn-id',
  uis: 'uis-latn-pg',
  uiv: 'uiv-latn-cm',
  uji: 'uji-latn-ng',
  uk: 'uk-cyrl-ua',
  uka: 'uka-latn-id',
  ukg: 'ukg-latn-pg',
  ukh: 'ukh-latn-cf',
  uki: 'uki-orya-in',
  ukk: 'ukk-latn-mm',
  ukp: 'ukp-latn-ng',
  ukq: 'ukq-latn-ng',
  uku: 'uku-latn-ng',
  ukv: 'ukv-latn-ss',
  ukw: 'ukw-latn-ng',
  uky: 'uky-latn-au',
  ula: 'ula-latn-ng',
  ulb: 'ulb-latn-ng',
  ulc: 'ulc-cyrl-ru',
  ule: 'ule-latn-ar',
  ulf: 'ulf-latn-id',
  uli: 'uli-latn-fm',
  ulk: 'ulk-latn-au',
  ulm: 'ulm-latn-id',
  uln: 'uln-latn-pg',
  ulu: 'ulu-latn-id',
  ulw: 'ulw-latn-ni',
  uma: 'uma-latn-us',
  umb: 'umb-latn-ao',
  umd: 'umd-latn-au',
  umg: 'umg-latn-au',
  umi: 'umi-latn-my',
  umm: 'umm-latn-ng',
  umn: 'umn-latn-mm',
  umo: 'umo-latn-br',
  ump: 'ump-latn-au',
  umr: 'umr-latn-au',
  ums: 'ums-latn-id',
  una: 'una-latn-pg',
  und: 'en-latn-us',
  'und-002': 'en-latn-ng',
  'und-003': 'en-latn-us',
  'und-005': 'pt-latn-br',
  'und-009': 'en-latn-au',
  'und-011': 'en-latn-ng',
  'und-013': 'es-latn-mx',
  'und-014': 'sw-latn-tz',
  'und-015': 'ar-arab-eg',
  'und-017': 'sw-latn-cd',
  'und-018': 'en-latn-za',
  'und-019': 'en-latn-us',
  'und-021': 'en-latn-us',
  'und-029': 'es-latn-cu',
  'und-030': 'zh-hans-cn',
  'und-034': 'hi-deva-in',
  'und-035': 'id-latn-id',
  'und-039': 'it-latn-it',
  'und-053': 'en-latn-au',
  'und-054': 'en-latn-pg',
  'und-057': 'en-latn-gu',
  'und-061': 'sm-latn-ws',
  'und-142': 'zh-hans-cn',
  'und-143': 'uz-latn-uz',
  'und-145': 'ar-arab-sa',
  'und-150': 'ru-cyrl-ru',
  'und-151': 'ru-cyrl-ru',
  'und-154': 'en-latn-gb',
  'und-155': 'de-latn-de',
  'und-202': 'en-latn-ng',
  'und-419': 'es-latn-419',
  'und-ad': 'ca-latn-ad',
  'und-adlm': 'ff-adlm-gn',
  'und-ae': 'ar-arab-ae',
  'und-af': 'fa-arab-af',
  'und-aghb': 'udi-aghb-ru',
  'und-ahom': 'aho-ahom-in',
  'und-al': 'sq-latn-al',
  'und-am': 'hy-armn-am',
  'und-ao': 'pt-latn-ao',
  'und-aq': 'und-latn-aq',
  'und-ar': 'es-latn-ar',
  'und-arab': 'ar-arab-eg',
  'und-arab-cc': 'ms-arab-cc',
  'und-arab-cn': 'ug-arab-cn',
  'und-arab-gb': 'ur-arab-gb',
  'und-arab-id': 'ms-arab-id',
  'und-arab-in': 'ur-arab-in',
  'und-arab-kh': 'cja-arab-kh',
  'und-arab-mm': 'rhg-arab-mm',
  'und-arab-mn': 'kk-arab-mn',
  'und-arab-mu': 'ur-arab-mu',
  'und-arab-ng': 'ha-arab-ng',
  'und-arab-pk': 'ur-arab-pk',
  'und-arab-tg': 'apd-arab-tg',
  'und-arab-th': 'mfa-arab-th',
  'und-arab-tj': 'fa-arab-tj',
  'und-arab-tr': 'apc-arab-tr',
  'und-arab-yt': 'swb-arab-yt',
  'und-armi': 'arc-armi-ir',
  'und-armn': 'hy-armn-am',
  'und-as': 'sm-latn-as',
  'und-at': 'de-latn-at',
  'und-avst': 'ae-avst-ir',
  'und-aw': 'nl-latn-aw',
  'und-ax': 'sv-latn-ax',
  'und-az': 'az-latn-az',
  'und-ba': 'bs-latn-ba',
  'und-bali': 'ban-bali-id',
  'und-bamu': 'bax-bamu-cm',
  'und-bass': 'bsq-bass-lr',
  'und-batk': 'bbc-batk-id',
  'und-bd': 'bn-beng-bd',
  'und-be': 'nl-latn-be',
  'und-beng': 'bn-beng-bd',
  'und-bf': 'fr-latn-bf',
  'und-bg': 'bg-cyrl-bg',
  'und-bh': 'ar-arab-bh',
  'und-bhks': 'sa-bhks-in',
  'und-bi': 'rn-latn-bi',
  'und-bj': 'fr-latn-bj',
  'und-bl': 'fr-latn-bl',
  'und-bn': 'ms-latn-bn',
  'und-bo': 'es-latn-bo',
  'und-bopo': 'zh-bopo-tw',
  'und-bq': 'pap-latn-bq',
  'und-br': 'pt-latn-br',
  'und-brah': 'pka-brah-in',
  'und-brai': 'fr-brai-fr',
  'und-bt': 'dz-tibt-bt',
  'und-bugi': 'bug-bugi-id',
  'und-buhd': 'bku-buhd-ph',
  'und-bv': 'und-latn-bv',
  'und-by': 'be-cyrl-by',
  'und-cakm': 'ccp-cakm-bd',
  'und-cans': 'iu-cans-ca',
  'und-cari': 'xcr-cari-tr',
  'und-cd': 'sw-latn-cd',
  'und-cf': 'fr-latn-cf',
  'und-cg': 'fr-latn-cg',
  'und-ch': 'de-latn-ch',
  'und-cham': 'cjm-cham-vn',
  'und-cher': 'chr-cher-us',
  'und-chrs': 'xco-chrs-uz',
  'und-ci': 'fr-latn-ci',
  'und-cl': 'es-latn-cl',
  'und-cm': 'fr-latn-cm',
  'und-cn': 'zh-hans-cn',
  'und-co': 'es-latn-co',
  'und-copt': 'cop-copt-eg',
  'und-cp': 'und-latn-cp',
  'und-cpmn': 'und-cpmn-cy',
  'und-cpmn-cy': 'und-cpmn-cy',
  'und-cprt': 'grc-cprt-cy',
  'und-cr': 'es-latn-cr',
  'und-cu': 'es-latn-cu',
  'und-cv': 'pt-latn-cv',
  'und-cw': 'pap-latn-cw',
  'und-cy': 'el-grek-cy',
  'und-cyrl': 'ru-cyrl-ru',
  'und-cyrl-al': 'mk-cyrl-al',
  'und-cyrl-ba': 'sr-cyrl-ba',
  'und-cyrl-ge': 'ab-cyrl-ge',
  'und-cyrl-gr': 'mk-cyrl-gr',
  'und-cyrl-md': 'uk-cyrl-md',
  'und-cyrl-ro': 'bg-cyrl-ro',
  'und-cyrl-sk': 'uk-cyrl-sk',
  'und-cyrl-tr': 'kbd-cyrl-tr',
  'und-cyrl-xk': 'sr-cyrl-xk',
  'und-cz': 'cs-latn-cz',
  'und-de': 'de-latn-de',
  'und-deva': 'hi-deva-in',
  'und-deva-bt': 'ne-deva-bt',
  'und-deva-fj': 'hif-deva-fj',
  'und-deva-mu': 'bho-deva-mu',
  'und-deva-pk': 'btv-deva-pk',
  'und-diak': 'dv-diak-mv',
  'und-dj': 'aa-latn-dj',
  'und-dk': 'da-latn-dk',
  'und-do': 'es-latn-do',
  'und-dogr': 'doi-dogr-in',
  'und-dupl': 'fr-dupl-fr',
  'und-dz': 'ar-arab-dz',
  'und-ea': 'es-latn-ea',
  'und-ec': 'es-latn-ec',
  'und-ee': 'et-latn-ee',
  'und-eg': 'ar-arab-eg',
  'und-egyp': 'egy-egyp-eg',
  'und-eh': 'ar-arab-eh',
  'und-elba': 'sq-elba-al',
  'und-elym': 'arc-elym-ir',
  'und-er': 'ti-ethi-er',
  'und-es': 'es-latn-es',
  'und-et': 'am-ethi-et',
  'und-ethi': 'am-ethi-et',
  'und-eu': 'en-latn-ie',
  'und-ez': 'de-latn-ez',
  'und-fi': 'fi-latn-fi',
  'und-fo': 'fo-latn-fo',
  'und-fr': 'fr-latn-fr',
  'und-ga': 'fr-latn-ga',
  'und-ge': 'ka-geor-ge',
  'und-geor': 'ka-geor-ge',
  'und-gf': 'fr-latn-gf',
  'und-gh': 'ak-latn-gh',
  'und-gl': 'kl-latn-gl',
  'und-glag': 'cu-glag-bg',
  'und-gn': 'fr-latn-gn',
  'und-gong': 'wsg-gong-in',
  'und-gonm': 'esg-gonm-in',
  'und-goth': 'got-goth-ua',
  'und-gp': 'fr-latn-gp',
  'und-gq': 'es-latn-gq',
  'und-gr': 'el-grek-gr',
  'und-gran': 'sa-gran-in',
  'und-grek': 'el-grek-gr',
  'und-grek-tr': 'bgx-grek-tr',
  'und-gs': 'und-latn-gs',
  'und-gt': 'es-latn-gt',
  'und-gujr': 'gu-gujr-in',
  'und-guru': 'pa-guru-in',
  'und-gw': 'pt-latn-gw',
  'und-hanb': 'zh-hanb-tw',
  'und-hang': 'ko-hang-kr',
  'und-hani': 'zh-hani-cn',
  'und-hano': 'hnn-hano-ph',
  'und-hans': 'zh-hans-cn',
  'und-hant': 'zh-hant-tw',
  'und-hant-ca': 'yue-hant-ca',
  'und-hebr': 'he-hebr-il',
  'und-hebr-se': 'yi-hebr-se',
  'und-hebr-ua': 'yi-hebr-ua',
  'und-hebr-us': 'yi-hebr-us',
  'und-hira': 'ja-hira-jp',
  'und-hk': 'zh-hant-hk',
  'und-hluw': 'hlu-hluw-tr',
  'und-hm': 'und-latn-hm',
  'und-hmng': 'hnj-hmng-la',
  'und-hmnp': 'hnj-hmnp-us',
  'und-hn': 'es-latn-hn',
  'und-hr': 'hr-latn-hr',
  'und-ht': 'ht-latn-ht',
  'und-hu': 'hu-latn-hu',
  'und-hung': 'hu-hung-hu',
  'und-ic': 'es-latn-ic',
  'und-id': 'id-latn-id',
  'und-il': 'he-hebr-il',
  'und-in': 'hi-deva-in',
  'und-iq': 'ar-arab-iq',
  'und-ir': 'fa-arab-ir',
  'und-is': 'is-latn-is',
  'und-it': 'it-latn-it',
  'und-ital': 'ett-ital-it',
  'und-jamo': 'ko-jamo-kr',
  'und-java': 'jv-java-id',
  'und-jo': 'ar-arab-jo',
  'und-jp': 'ja-jpan-jp',
  'und-jpan': 'ja-jpan-jp',
  'und-kali': 'eky-kali-mm',
  'und-kana': 'ja-kana-jp',
  'und-kawi': 'kaw-kawi-id',
  'und-ke': 'sw-latn-ke',
  'und-kg': 'ky-cyrl-kg',
  'und-kh': 'km-khmr-kh',
  'und-khar': 'pra-khar-pk',
  'und-khmr': 'km-khmr-kh',
  'und-khoj': 'sd-khoj-in',
  'und-kits': 'zkt-kits-cn',
  'und-km': 'ar-arab-km',
  'und-knda': 'kn-knda-in',
  'und-kore': 'ko-kore-kr',
  'und-kp': 'ko-kore-kp',
  'und-kr': 'ko-kore-kr',
  'und-kthi': 'bho-kthi-in',
  'und-kw': 'ar-arab-kw',
  'und-kz': 'ru-cyrl-kz',
  'und-la': 'lo-laoo-la',
  'und-lana': 'nod-lana-th',
  'und-laoo': 'lo-laoo-la',
  'und-laoo-au': 'hnj-laoo-au',
  'und-laoo-cn': 'hnj-laoo-cn',
  'und-laoo-fr': 'hnj-laoo-fr',
  'und-laoo-gf': 'hnj-laoo-gf',
  'und-laoo-mm': 'hnj-laoo-mm',
  'und-laoo-sr': 'hnj-laoo-sr',
  'und-laoo-th': 'hnj-laoo-th',
  'und-laoo-us': 'hnj-laoo-us',
  'und-laoo-vn': 'hnj-laoo-vn',
  'und-latn-af': 'tk-latn-af',
  'und-latn-am': 'ku-latn-am',
  'und-latn-cn': 'za-latn-cn',
  'und-latn-cy': 'tr-latn-cy',
  'und-latn-dz': 'fr-latn-dz',
  'und-latn-et': 'en-latn-et',
  'und-latn-ge': 'ku-latn-ge',
  'und-latn-ir': 'tk-latn-ir',
  'und-latn-km': 'fr-latn-km',
  'und-latn-ma': 'fr-latn-ma',
  'und-latn-mk': 'sq-latn-mk',
  'und-latn-mm': 'kac-latn-mm',
  'und-latn-mo': 'pt-latn-mo',
  'und-latn-mr': 'fr-latn-mr',
  'und-latn-ru': 'krl-latn-ru',
  'und-latn-sy': 'fr-latn-sy',
  'und-latn-tn': 'fr-latn-tn',
  'und-latn-tw': 'trv-latn-tw',
  'und-latn-ua': 'pl-latn-ua',
  'und-lb': 'ar-arab-lb',
  'und-lepc': 'lep-lepc-in',
  'und-li': 'de-latn-li',
  'und-limb': 'lif-limb-in',
  'und-lina': 'lab-lina-gr',
  'und-linb': 'grc-linb-gr',
  'und-lisu': 'lis-lisu-cn',
  'und-lk': 'si-sinh-lk',
  'und-ls': 'st-latn-ls',
  'und-lt': 'lt-latn-lt',
  'und-lu': 'fr-latn-lu',
  'und-lv': 'lv-latn-lv',
  'und-ly': 'ar-arab-ly',
  'und-lyci': 'xlc-lyci-tr',
  'und-lydi': 'xld-lydi-tr',
  'und-ma': 'ar-arab-ma',
  'und-mahj': 'hi-mahj-in',
  'und-maka': 'mak-maka-id',
  'und-mand': 'myz-mand-ir',
  'und-mani': 'xmn-mani-cn',
  'und-marc': 'bo-marc-cn',
  'und-mc': 'fr-latn-mc',
  'und-md': 'ro-latn-md',
  'und-me': 'sr-latn-me',
  'und-medf': 'dmf-medf-ng',
  'und-mend': 'men-mend-sl',
  'und-merc': 'xmr-merc-sd',
  'und-mero': 'xmr-mero-sd',
  'und-mf': 'fr-latn-mf',
  'und-mg': 'mg-latn-mg',
  'und-mk': 'mk-cyrl-mk',
  'und-ml': 'bm-latn-ml',
  'und-mlym': 'ml-mlym-in',
  'und-mm': 'my-mymr-mm',
  'und-mn': 'mn-cyrl-mn',
  'und-mo': 'zh-hant-mo',
  'und-modi': 'mr-modi-in',
  'und-mong': 'mn-mong-cn',
  'und-mq': 'fr-latn-mq',
  'und-mr': 'ar-arab-mr',
  'und-mroo': 'mro-mroo-bd',
  'und-mt': 'mt-latn-mt',
  'und-mtei': 'mni-mtei-in',
  'und-mu': 'mfe-latn-mu',
  'und-mult': 'skr-mult-pk',
  'und-mv': 'dv-thaa-mv',
  'und-mx': 'es-latn-mx',
  'und-my': 'ms-latn-my',
  'und-mymr': 'my-mymr-mm',
  'und-mymr-in': 'kht-mymr-in',
  'und-mymr-th': 'mnw-mymr-th',
  'und-mz': 'pt-latn-mz',
  'und-na': 'af-latn-na',
  'und-nagm': 'unr-nagm-in',
  'und-nand': 'sa-nand-in',
  'und-narb': 'xna-narb-sa',
  'und-nbat': 'arc-nbat-jo',
  'und-nc': 'fr-latn-nc',
  'und-ne': 'ha-latn-ne',
  'und-newa': 'new-newa-np',
  'und-ni': 'es-latn-ni',
  'und-nkoo': 'man-nkoo-gn',
  'und-nl': 'nl-latn-nl',
  'und-no': 'nb-latn-no',
  'und-np': 'ne-deva-np',
  'und-nshu': 'zhx-nshu-cn',
  'und-ogam': 'sga-ogam-ie',
  'und-olck': 'sat-olck-in',
  'und-om': 'ar-arab-om',
  'und-orkh': 'otk-orkh-mn',
  'und-orya': 'or-orya-in',
  'und-osge': 'osa-osge-us',
  'und-osma': 'so-osma-so',
  'und-ougr': 'oui-ougr-143',
  'und-pa': 'es-latn-pa',
  'und-palm': 'arc-palm-sy',
  'und-pauc': 'ctd-pauc-mm',
  'und-pe': 'es-latn-pe',
  'und-perm': 'kv-perm-ru',
  'und-pf': 'fr-latn-pf',
  'und-pg': 'tpi-latn-pg',
  'und-ph': 'fil-latn-ph',
  'und-phag': 'lzh-phag-cn',
  'und-phli': 'pal-phli-ir',
  'und-phlp': 'pal-phlp-cn',
  'und-phnx': 'phn-phnx-lb',
  'und-pk': 'ur-arab-pk',
  'und-pl': 'pl-latn-pl',
  'und-plrd': 'hmd-plrd-cn',
  'und-pm': 'fr-latn-pm',
  'und-pr': 'es-latn-pr',
  'und-prti': 'xpr-prti-ir',
  'und-ps': 'ar-arab-ps',
  'und-pt': 'pt-latn-pt',
  'und-pw': 'pau-latn-pw',
  'und-py': 'gn-latn-py',
  'und-qa': 'ar-arab-qa',
  'und-qo': 'en-latn-dg',
  'und-re': 'fr-latn-re',
  'und-rjng': 'rej-rjng-id',
  'und-ro': 'ro-latn-ro',
  'und-rohg': 'rhg-rohg-mm',
  'und-rs': 'sr-cyrl-rs',
  'und-ru': 'ru-cyrl-ru',
  'und-runr': 'non-runr-se',
  'und-rw': 'rw-latn-rw',
  'und-sa': 'ar-arab-sa',
  'und-samr': 'smp-samr-il',
  'und-sarb': 'xsa-sarb-ye',
  'und-saur': 'saz-saur-in',
  'und-sc': 'fr-latn-sc',
  'und-sd': 'ar-arab-sd',
  'und-se': 'sv-latn-se',
  'und-sgnw': 'ase-sgnw-us',
  'und-shaw': 'en-shaw-gb',
  'und-shrd': 'sa-shrd-in',
  'und-si': 'sl-latn-si',
  'und-sidd': 'sa-sidd-in',
  'und-sind': 'sd-sind-in',
  'und-sinh': 'si-sinh-lk',
  'und-sj': 'nb-latn-sj',
  'und-sk': 'sk-latn-sk',
  'und-sm': 'it-latn-sm',
  'und-sn': 'fr-latn-sn',
  'und-so': 'so-latn-so',
  'und-sogd': 'sog-sogd-uz',
  'und-sogo': 'sog-sogo-uz',
  'und-sora': 'srb-sora-in',
  'und-soyo': 'cmg-soyo-mn',
  'und-sr': 'nl-latn-sr',
  'und-st': 'pt-latn-st',
  'und-sund': 'su-sund-id',
  'und-sv': 'es-latn-sv',
  'und-sy': 'ar-arab-sy',
  'und-sylo': 'syl-sylo-bd',
  'und-syrc': 'syr-syrc-iq',
  'und-tagb': 'tbw-tagb-ph',
  'und-takr': 'doi-takr-in',
  'und-tale': 'tdd-tale-cn',
  'und-talu': 'khb-talu-cn',
  'und-taml': 'ta-taml-in',
  'und-tang': 'txg-tang-cn',
  'und-tavt': 'blt-tavt-vn',
  'und-td': 'fr-latn-td',
  'und-telu': 'te-telu-in',
  'und-tf': 'fr-latn-tf',
  'und-tfng': 'zgh-tfng-ma',
  'und-tg': 'fr-latn-tg',
  'und-tglg': 'fil-tglg-ph',
  'und-th': 'th-thai-th',
  'und-thaa': 'dv-thaa-mv',
  'und-thai': 'th-thai-th',
  'und-thai-cn': 'lcp-thai-cn',
  'und-thai-kh': 'kdt-thai-kh',
  'und-thai-la': 'kdt-thai-la',
  'und-tibt': 'bo-tibt-cn',
  'und-tirh': 'mai-tirh-in',
  'und-tj': 'tg-cyrl-tj',
  'und-tk': 'tkl-latn-tk',
  'und-tl': 'pt-latn-tl',
  'und-tm': 'tk-latn-tm',
  'und-tn': 'ar-arab-tn',
  'und-tnsa': 'nst-tnsa-in',
  'und-to': 'to-latn-to',
  'und-toto': 'txo-toto-in',
  'und-tr': 'tr-latn-tr',
  'und-tv': 'tvl-latn-tv',
  'und-tw': 'zh-hant-tw',
  'und-tz': 'sw-latn-tz',
  'und-ua': 'uk-cyrl-ua',
  'und-ug': 'sw-latn-ug',
  'und-ugar': 'uga-ugar-sy',
  'und-uy': 'es-latn-uy',
  'und-uz': 'uz-latn-uz',
  'und-va': 'it-latn-va',
  'und-vaii': 'vai-vaii-lr',
  'und-ve': 'es-latn-ve',
  'und-vith': 'sq-vith-al',
  'und-vn': 'vi-latn-vn',
  'und-vu': 'bi-latn-vu',
  'und-wara': 'hoc-wara-in',
  'und-wcho': 'nnp-wcho-in',
  'und-wf': 'fr-latn-wf',
  'und-ws': 'sm-latn-ws',
  'und-xk': 'sq-latn-xk',
  'und-xpeo': 'peo-xpeo-ir',
  'und-xsux': 'akk-xsux-iq',
  'und-ye': 'ar-arab-ye',
  'und-yezi': 'ku-yezi-ge',
  'und-yiii': 'ii-yiii-cn',
  'und-yt': 'fr-latn-yt',
  'und-zanb': 'cmg-zanb-mn',
  'und-zw': 'sn-latn-zw',
  une: 'une-latn-ng',
  ung: 'ung-latn-au',
  uni: 'uni-latn-pg',
  unk: 'unk-latn-br',
  unm: 'unm-latn-us',
  unn: 'unn-latn-au',
  unr: 'unr-beng-in',
  'unr-deva': 'unr-deva-np',
  'unr-np': 'unr-deva-np',
  unu: 'unu-latn-pg',
  unx: 'unx-beng-in',
  unz: 'unz-latn-id',
  uok: 'uok-latn-zz',
  uon: 'uon-latn-tw',
  upi: 'upi-latn-pg',
  upv: 'upv-latn-vu',
  ur: 'ur-arab-pk',
  ura: 'ura-latn-pe',
  urb: 'urb-latn-br',
  urc: 'urc-latn-au',
  ure: 'ure-latn-bo',
  urf: 'urf-latn-au',
  urg: 'urg-latn-pg',
  urh: 'urh-latn-ng',
  uri: 'uri-latn-zz',
  urk: 'urk-thai-th',
  urm: 'urm-latn-pg',
  urn: 'urn-latn-id',
  uro: 'uro-latn-pg',
  urp: 'urp-latn-br',
  urr: 'urr-latn-vu',
  urt: 'urt-latn-zz',
  uru: 'uru-latn-br',
  urv: 'urv-latn-pg',
  urw: 'urw-latn-zz',
  urx: 'urx-latn-pg',
  ury: 'ury-latn-id',
  urz: 'urz-latn-br',
  usa: 'usa-latn-zz',
  ush: 'ush-arab-pk',
  usi: 'usi-latn-bd',
  'usi-beng': 'usi-beng-bd',
  usk: 'usk-latn-cm',
  usp: 'usp-latn-gt',
  uss: 'uss-latn-ng',
  usu: 'usu-latn-pg',
  uta: 'uta-latn-ng',
  ute: 'ute-latn-us',
  uth: 'uth-latn-zz',
  utp: 'utp-latn-sb',
  utr: 'utr-latn-zz',
  utu: 'utu-latn-pg',
  uum: 'uum-grek-ge',
  'uum-cyrl': 'uum-cyrl-ge',
  uur: 'uur-latn-vu',
  uve: 'uve-latn-nc',
  uvh: 'uvh-latn-zz',
  uvl: 'uvl-latn-zz',
  uwa: 'uwa-latn-au',
  uya: 'uya-latn-ng',
  uz: 'uz-latn-uz',
  'uz-af': 'uz-arab-af',
  'uz-arab': 'uz-arab-af',
  'uz-cn': 'uz-cyrl-cn',
  uzs: 'uzs-arab-af',
  vaa: 'vaa-taml-in',
  vae: 'vae-latn-cf',
  vaf: 'vaf-arab-ir',
  vag: 'vag-latn-zz',
  vah: 'vah-deva-in',
  vai: 'vai-vaii-lr',
  vaj: 'vaj-latn-na',
  val: 'val-latn-pg',
  vam: 'vam-latn-pg',
  van: 'van-latn-zz',
  vao: 'vao-latn-vu',
  vap: 'vap-latn-in',
  var: 'var-latn-mx',
  vas: 'vas-deva-in',
  'vas-gujr': 'vas-gujr-in',
  vau: 'vau-latn-cd',
  vav: 'vav-deva-in',
  'vav-gujr': 'vav-gujr-in',
  vay: 'vay-deva-np',
  vbb: 'vbb-latn-id',
  vbk: 'vbk-latn-ph',
  ve: 've-latn-za',
  vec: 'vec-latn-it',
  vem: 'vem-latn-ng',
  veo: 'veo-latn-us',
  vep: 'vep-latn-ru',
  ver: 'ver-latn-ng',
  vgr: 'vgr-arab-pk',
  vi: 'vi-latn-vn',
  vic: 'vic-latn-sx',
  vid: 'vid-latn-tz',
  vif: 'vif-latn-cg',
  vig: 'vig-latn-bf',
  vil: 'vil-latn-ar',
  vin: 'vin-latn-tz',
  vit: 'vit-latn-ng',
  viv: 'viv-latn-zz',
  vka: 'vka-latn-au',
  vkj: 'vkj-latn-td',
  vkk: 'vkk-latn-id',
  vkl: 'vkl-latn-id',
  vkm: 'vkm-latn-br',
  vkn: 'vkn-latn-ng',
  vko: 'vko-latn-id',
  vkp: 'vkp-latn-in',
  'vkp-deva': 'vkp-deva-in',
  vkt: 'vkt-latn-id',
  vku: 'vku-latn-au',
  vkz: 'vkz-latn-ng',
  vlp: 'vlp-latn-vu',
  vls: 'vls-latn-be',
  vma: 'vma-latn-au',
  vmb: 'vmb-latn-au',
  vmc: 'vmc-latn-mx',
  vmd: 'vmd-knda-in',
  vme: 'vme-latn-id',
  vmf: 'vmf-latn-de',
  vmg: 'vmg-latn-pg',
  vmh: 'vmh-arab-ir',
  vmi: 'vmi-latn-au',
  vmj: 'vmj-latn-mx',
  vmk: 'vmk-latn-mz',
  vml: 'vml-latn-au',
  vmm: 'vmm-latn-mx',
  vmp: 'vmp-latn-mx',
  vmq: 'vmq-latn-mx',
  vmr: 'vmr-latn-mz',
  vms: 'vms-latn-id',
  vmu: 'vmu-latn-au',
  vmw: 'vmw-latn-mz',
  vmx: 'vmx-latn-mx',
  vmy: 'vmy-latn-mx',
  vmz: 'vmz-latn-mx',
  vnk: 'vnk-latn-sb',
  vnm: 'vnm-latn-vu',
  vnp: 'vnp-latn-vu',
  vo: 'vo-latn-001',
  vor: 'vor-latn-ng',
  vot: 'vot-latn-ru',
  vra: 'vra-latn-vu',
  vro: 'vro-latn-ee',
  vrs: 'vrs-latn-sb',
  vrt: 'vrt-latn-vu',
  vto: 'vto-latn-id',
  vum: 'vum-latn-ga',
  vun: 'vun-latn-tz',
  vut: 'vut-latn-zz',
  vwa: 'vwa-latn-cn',
  'vwa-mymr': 'vwa-mymr-cn',
  wa: 'wa-latn-be',
  waa: 'waa-latn-us',
  wab: 'wab-latn-pg',
  wac: 'wac-latn-us',
  wad: 'wad-latn-id',
  wae: 'wae-latn-ch',
  waf: 'waf-latn-br',
  wag: 'wag-latn-pg',
  wah: 'wah-latn-id',
  wai: 'wai-latn-id',
  waj: 'waj-latn-zz',
  wal: 'wal-ethi-et',
  wam: 'wam-latn-us',
  wan: 'wan-latn-zz',
  wap: 'wap-latn-gy',
  waq: 'waq-latn-au',
  war: 'war-latn-ph',
  was: 'was-latn-us',
  wat: 'wat-latn-pg',
  wau: 'wau-latn-br',
  wav: 'wav-latn-ng',
  waw: 'waw-latn-br',
  wax: 'wax-latn-pg',
  way: 'way-latn-sr',
  waz: 'waz-latn-pg',
  wba: 'wba-latn-ve',
  wbb: 'wbb-latn-id',
  wbe: 'wbe-latn-id',
  wbf: 'wbf-latn-bf',
  wbh: 'wbh-latn-tz',
  wbi: 'wbi-latn-tz',
  wbj: 'wbj-latn-tz',
  wbk: 'wbk-arab-af',
  wbl: 'wbl-latn-pk',
  'wbl-arab': 'wbl-arab-af',
  'wbl-cyrl': 'wbl-cyrl-tj',
  wbm: 'wbm-latn-cn',
  wbp: 'wbp-latn-au',
  wbq: 'wbq-telu-in',
  wbr: 'wbr-deva-in',
  wbt: 'wbt-latn-au',
  wbv: 'wbv-latn-au',
  wbw: 'wbw-latn-id',
  wca: 'wca-latn-br',
  wci: 'wci-latn-zz',
  wdd: 'wdd-latn-ga',
  wdg: 'wdg-latn-pg',
  wdj: 'wdj-latn-au',
  wdk: 'wdk-latn-au',
  wdt: 'wdt-latn-ca',
  wdu: 'wdu-latn-au',
  wdy: 'wdy-latn-au',
  wec: 'wec-latn-ci',
  wed: 'wed-latn-pg',
  weg: 'weg-latn-au',
  weh: 'weh-latn-cm',
  wei: 'wei-latn-pg',
  wem: 'wem-latn-bj',
  weo: 'weo-latn-id',
  wep: 'wep-latn-de',
  wer: 'wer-latn-zz',
  wes: 'wes-latn-cm',
  wet: 'wet-latn-id',
  weu: 'weu-latn-mm',
  wew: 'wew-latn-id',
  wfg: 'wfg-latn-id',
  wga: 'wga-latn-au',
  wgb: 'wgb-latn-pg',
  wgg: 'wgg-latn-au',
  wgi: 'wgi-latn-zz',
  wgo: 'wgo-latn-id',
  wgu: 'wgu-latn-au',
  wgy: 'wgy-latn-au',
  wha: 'wha-latn-id',
  whg: 'whg-latn-zz',
  whk: 'whk-latn-id',
  whu: 'whu-latn-id',
  wib: 'wib-latn-zz',
  wic: 'wic-latn-us',
  wie: 'wie-latn-au',
  wif: 'wif-latn-au',
  wig: 'wig-latn-au',
  wih: 'wih-latn-au',
  wii: 'wii-latn-pg',
  wij: 'wij-latn-au',
  wik: 'wik-latn-au',
  wil: 'wil-latn-au',
  wim: 'wim-latn-au',
  win: 'win-latn-us',
  wir: 'wir-latn-br',
  wiu: 'wiu-latn-zz',
  wiv: 'wiv-latn-zz',
  wiy: 'wiy-latn-us',
  wja: 'wja-latn-zz',
  wji: 'wji-latn-zz',
  wka: 'wka-latn-tz',
  wkd: 'wkd-latn-id',
  wkr: 'wkr-latn-au',
  wkw: 'wkw-latn-au',
  wky: 'wky-latn-au',
  wla: 'wla-latn-pg',
  wlg: 'wlg-latn-au',
  wlh: 'wlh-latn-tl',
  wli: 'wli-latn-id',
  wlm: 'wlm-latn-gb',
  wlo: 'wlo-arab-id',
  wlr: 'wlr-latn-vu',
  wls: 'wls-latn-wf',
  wlu: 'wlu-latn-au',
  wlv: 'wlv-latn-ar',
  wlw: 'wlw-latn-id',
  wlx: 'wlx-latn-gh',
  wma: 'wma-latn-ng',
  wmb: 'wmb-latn-au',
  wmc: 'wmc-latn-pg',
  wmd: 'wmd-latn-br',
  wme: 'wme-deva-np',
  wmh: 'wmh-latn-tl',
  wmi: 'wmi-latn-au',
  wmm: 'wmm-latn-id',
  wmn: 'wmn-latn-nc',
  wmo: 'wmo-latn-zz',
  wms: 'wms-latn-id',
  wmt: 'wmt-latn-au',
  wmw: 'wmw-latn-mz',
  'wmw-arab': 'wmw-arab-mz',
  wmx: 'wmx-latn-pg',
  wnb: 'wnb-latn-pg',
  wnc: 'wnc-latn-zz',
  wnd: 'wnd-latn-au',
  wne: 'wne-arab-pk',
  wng: 'wng-latn-id',
  wni: 'wni-arab-km',
  wnk: 'wnk-latn-id',
  wnm: 'wnm-latn-au',
  wnn: 'wnn-latn-au',
  wno: 'wno-latn-id',
  wnp: 'wnp-latn-pg',
  wnu: 'wnu-latn-zz',
  wnw: 'wnw-latn-us',
  wny: 'wny-latn-au',
  wo: 'wo-latn-sn',
  woa: 'woa-latn-au',
  wob: 'wob-latn-zz',
  woc: 'woc-latn-pg',
  wod: 'wod-latn-id',
  woe: 'woe-latn-fm',
  wof: 'wof-latn-gm',
  'wof-arab': 'wof-arab-gm',
  wog: 'wog-latn-pg',
  woi: 'woi-latn-id',
  wok: 'wok-latn-cm',
  wom: 'wom-latn-ng',
  won: 'won-latn-cd',
  woo: 'woo-latn-id',
  wor: 'wor-latn-id',
  wos: 'wos-latn-zz',
  wow: 'wow-latn-id',
  wpc: 'wpc-latn-ve',
  wrb: 'wrb-latn-au',
  wrg: 'wrg-latn-au',
  wrh: 'wrh-latn-au',
  wri: 'wri-latn-au',
  wrk: 'wrk-latn-au',
  wrl: 'wrl-latn-au',
  wrm: 'wrm-latn-au',
  wro: 'wro-latn-au',
  wrp: 'wrp-latn-id',
  wrr: 'wrr-latn-au',
  wrs: 'wrs-latn-zz',
  wru: 'wru-latn-id',
  wrv: 'wrv-latn-pg',
  wrw: 'wrw-latn-au',
  wrx: 'wrx-latn-id',
  wrz: 'wrz-latn-au',
  wsa: 'wsa-latn-id',
  wsg: 'wsg-gong-in',
  wsi: 'wsi-latn-vu',
  wsk: 'wsk-latn-zz',
  wsr: 'wsr-latn-pg',
  wss: 'wss-latn-gh',
  wsu: 'wsu-latn-br',
  wsv: 'wsv-arab-af',
  wtf: 'wtf-latn-pg',
  wth: 'wth-latn-au',
  wti: 'wti-latn-et',
  wtk: 'wtk-latn-pg',
  wtm: 'wtm-deva-in',
  wtw: 'wtw-latn-id',
  'wtw-bugi': 'wtw-bugi-id',
  wua: 'wua-latn-au',
  wub: 'wub-latn-au',
  wud: 'wud-latn-tg',
  wul: 'wul-latn-id',
  wum: 'wum-latn-ga',
  wun: 'wun-latn-tz',
  wur: 'wur-latn-au',
  wut: 'wut-latn-pg',
  wuu: 'wuu-hans-cn',
  wuv: 'wuv-latn-zz',
  wux: 'wux-latn-au',
  wuy: 'wuy-latn-id',
  wwa: 'wwa-latn-zz',
  wwb: 'wwb-latn-au',
  wwo: 'wwo-latn-vu',
  wwr: 'wwr-latn-au',
  www: 'www-latn-cm',
  wxw: 'wxw-latn-au',
  wyb: 'wyb-latn-au',
  wyi: 'wyi-latn-au',
  wym: 'wym-latn-pl',
  wyn: 'wyn-latn-us',
  wyr: 'wyr-latn-br',
  wyy: 'wyy-latn-fj',
  xaa: 'xaa-latn-es',
  xab: 'xab-latn-ng',
  xai: 'xai-latn-br',
  xaj: 'xaj-latn-br',
  xak: 'xak-latn-ve',
  xal: 'xal-cyrl-ru',
  xam: 'xam-latn-za',
  xan: 'xan-ethi-et',
  xao: 'xao-latn-vn',
  xar: 'xar-latn-pg',
  xas: 'xas-cyrl-ru',
  xat: 'xat-latn-br',
  xau: 'xau-latn-id',
  xav: 'xav-latn-br',
  xaw: 'xaw-latn-us',
  xay: 'xay-latn-id',
  xbb: 'xbb-latn-au',
  xbd: 'xbd-latn-au',
  xbe: 'xbe-latn-au',
  xbg: 'xbg-latn-au',
  xbi: 'xbi-latn-zz',
  xbj: 'xbj-latn-au',
  xbm: 'xbm-latn-fr',
  xbn: 'xbn-latn-my',
  xbp: 'xbp-latn-au',
  xbr: 'xbr-latn-id',
  xbw: 'xbw-latn-br',
  xby: 'xby-latn-au',
  xch: 'xch-latn-us',
  xco: 'xco-chrs-uz',
  xcr: 'xcr-cari-tr',
  xda: 'xda-latn-au',
  xdk: 'xdk-latn-au',
  xdo: 'xdo-latn-ao',
  xdq: 'xdq-cyrl-ru',
  xdy: 'xdy-latn-id',
  xed: 'xed-latn-cm',
  xeg: 'xeg-latn-za',
  xem: 'xem-latn-id',
  xer: 'xer-latn-br',
  xes: 'xes-latn-zz',
  xet: 'xet-latn-br',
  xeu: 'xeu-latn-pg',
  xgb: 'xgb-latn-ci',
  xgd: 'xgd-latn-au',
  xgg: 'xgg-latn-au',
  xgi: 'xgi-latn-au',
  xgm: 'xgm-latn-au',
  xgu: 'xgu-latn-au',
  xgw: 'xgw-latn-au',
  xh: 'xh-latn-za',
  xhe: 'xhe-arab-pk',
  xhm: 'xhm-khmr-kh',
  xhv: 'xhv-latn-vn',
  xii: 'xii-latn-za',
  xin: 'xin-latn-gt',
  xir: 'xir-latn-br',
  xis: 'xis-orya-in',
  xiy: 'xiy-latn-br',
  xjb: 'xjb-latn-au',
  xjt: 'xjt-latn-au',
  xka: 'xka-arab-pk',
  xkb: 'xkb-latn-bj',
  xkc: 'xkc-arab-ir',
  xkd: 'xkd-latn-id',
  xke: 'xke-latn-id',
  xkg: 'xkg-latn-ml',
  xkj: 'xkj-arab-ir',
  xkl: 'xkl-latn-id',
  xkn: 'xkn-latn-id',
  xkp: 'xkp-arab-ir',
  xkq: 'xkq-latn-id',
  xkr: 'xkr-latn-br',
  xks: 'xks-latn-id',
  xkt: 'xkt-latn-gh',
  xku: 'xku-latn-cg',
  xkv: 'xkv-latn-bw',
  xkw: 'xkw-latn-id',
  xkx: 'xkx-latn-pg',
  xky: 'xky-latn-my',
  xkz: 'xkz-latn-bt',
  xla: 'xla-latn-zz',
  xlc: 'xlc-lyci-tr',
  xld: 'xld-lydi-tr',
  xly: 'xly-elym-ir',
  xma: 'xma-latn-so',
  xmb: 'xmb-latn-cm',
  xmc: 'xmc-latn-mz',
  xmd: 'xmd-latn-cm',
  xmf: 'xmf-geor-ge',
  xmg: 'xmg-latn-cm',
  xmh: 'xmh-latn-au',
  xmj: 'xmj-latn-cm',
  xmm: 'xmm-latn-id',
  xmn: 'xmn-mani-cn',
  xmo: 'xmo-latn-br',
  xmp: 'xmp-latn-au',
  xmq: 'xmq-latn-au',
  xmr: 'xmr-merc-sd',
  xmt: 'xmt-latn-id',
  xmu: 'xmu-latn-au',
  xmv: 'xmv-latn-mg',
  xmw: 'xmw-latn-mg',
  xmx: 'xmx-latn-id',
  xmy: 'xmy-latn-au',
  xmz: 'xmz-latn-id',
  xna: 'xna-narb-sa',
  xnb: 'xnb-latn-tw',
  xni: 'xni-latn-au',
  xnj: 'xnj-latn-tz',
  xnk: 'xnk-latn-au',
  xnm: 'xnm-latn-au',
  xnn: 'xnn-latn-ph',
  xnq: 'xnq-latn-mz',
  xnr: 'xnr-deva-in',
  xnt: 'xnt-latn-us',
  xnu: 'xnu-latn-au',
  xny: 'xny-latn-au',
  xnz: 'xnz-latn-eg',
  'xnz-arab': 'xnz-arab-eg',
  xoc: 'xoc-latn-ng',
  xod: 'xod-latn-id',
  xog: 'xog-latn-ug',
  xoi: 'xoi-latn-pg',
  xok: 'xok-latn-br',
  xom: 'xom-latn-sd',
  'xom-ethi': 'xom-ethi-et',
  xon: 'xon-latn-zz',
  xoo: 'xoo-latn-br',
  xop: 'xop-latn-pg',
  xor: 'xor-latn-br',
  xow: 'xow-latn-pg',
  xpa: 'xpa-latn-au',
  xpb: 'xpb-latn-au',
  xpd: 'xpd-latn-au',
  xpf: 'xpf-latn-au',
  xpg: 'xpg-grek-tr',
  xph: 'xph-latn-au',
  xpi: 'xpi-ogam-gb',
  xpj: 'xpj-latn-au',
  xpk: 'xpk-latn-br',
  xpl: 'xpl-latn-au',
  xpm: 'xpm-cyrl-ru',
  xpn: 'xpn-latn-br',
  xpo: 'xpo-latn-mx',
  xpq: 'xpq-latn-us',
  xpr: 'xpr-prti-ir',
  xpt: 'xpt-latn-au',
  xpv: 'xpv-latn-au',
  xpw: 'xpw-latn-au',
  xpx: 'xpx-latn-au',
  xpz: 'xpz-latn-au',
  xra: 'xra-latn-br',
  xrb: 'xrb-latn-zz',
  xrd: 'xrd-latn-au',
  xre: 'xre-latn-br',
  xrg: 'xrg-latn-au',
  xri: 'xri-latn-br',
  xrm: 'xrm-cyrl-ru',
  xrn: 'xrn-cyrl-ru',
  xrr: 'xrr-latn-it',
  xru: 'xru-latn-au',
  xrw: 'xrw-latn-pg',
  xsa: 'xsa-sarb-ye',
  xsb: 'xsb-latn-ph',
  xse: 'xse-latn-id',
  xsh: 'xsh-latn-ng',
  xsi: 'xsi-latn-zz',
  xsm: 'xsm-latn-zz',
  xsn: 'xsn-latn-ng',
  xsp: 'xsp-latn-pg',
  xsq: 'xsq-latn-mz',
  xsr: 'xsr-deva-np',
  xss: 'xss-cyrl-ru',
  xsu: 'xsu-latn-ve',
  xsy: 'xsy-latn-tw',
  xta: 'xta-latn-mx',
  xtb: 'xtb-latn-mx',
  xtc: 'xtc-latn-sd',
  xtd: 'xtd-latn-mx',
  xte: 'xte-latn-id',
  xth: 'xth-latn-au',
  xti: 'xti-latn-mx',
  xtj: 'xtj-latn-mx',
  xtl: 'xtl-latn-mx',
  xtm: 'xtm-latn-mx',
  xtn: 'xtn-latn-mx',
  xtp: 'xtp-latn-mx',
  xts: 'xts-latn-mx',
  xtt: 'xtt-latn-mx',
  xtu: 'xtu-latn-mx',
  xtv: 'xtv-latn-au',
  xtw: 'xtw-latn-br',
  xty: 'xty-latn-mx',
  xub: 'xub-taml-in',
  'xub-knda': 'xub-knda-in',
  'xub-mlym': 'xub-mlym-in',
  xud: 'xud-latn-au',
  xuj: 'xuj-taml-in',
  xul: 'xul-latn-au',
  xum: 'xum-latn-it',
  'xum-ital': 'xum-ital-it',
  xun: 'xun-latn-au',
  xuo: 'xuo-latn-td',
  xut: 'xut-latn-au',
  xuu: 'xuu-latn-na',
  xve: 'xve-ital-it',
  xvi: 'xvi-arab-af',
  xvn: 'xvn-latn-es',
  xvo: 'xvo-latn-it',
  xvs: 'xvs-latn-it',
  xwa: 'xwa-latn-br',
  xwd: 'xwd-latn-au',
  xwe: 'xwe-latn-zz',
  xwj: 'xwj-latn-au',
  xwk: 'xwk-latn-au',
  xwl: 'xwl-latn-bj',
  xwo: 'xwo-cyrl-ru',
  xwr: 'xwr-latn-id',
  xwt: 'xwt-latn-au',
  xww: 'xww-latn-au',
  xxb: 'xxb-latn-gh',
  xxk: 'xxk-latn-id',
  xxm: 'xxm-latn-au',
  xxr: 'xxr-latn-br',
  xxt: 'xxt-latn-id',
  xya: 'xya-latn-au',
  xyb: 'xyb-latn-au',
  xyj: 'xyj-latn-au',
  xyk: 'xyk-latn-au',
  xyl: 'xyl-latn-br',
  xyt: 'xyt-latn-au',
  xyy: 'xyy-latn-au',
  xzh: 'xzh-marc-cn',
  xzp: 'xzp-latn-mx',
  yaa: 'yaa-latn-pe',
  yab: 'yab-latn-br',
  yac: 'yac-latn-id',
  yad: 'yad-latn-pe',
  yae: 'yae-latn-ve',
  yaf: 'yaf-latn-cd',
  yag: 'yag-latn-cl',
  yai: 'yai-cyrl-tj',
  yaj: 'yaj-latn-cf',
  yak: 'yak-latn-us',
  yal: 'yal-latn-gn',
  'yal-arab': 'yal-arab-gn',
  yam: 'yam-latn-zz',
  yan: 'yan-latn-ni',
  yao: 'yao-latn-mz',
  yap: 'yap-latn-fm',
  yaq: 'yaq-latn-mx',
  yar: 'yar-latn-ve',
  yas: 'yas-latn-zz',
  yat: 'yat-latn-zz',
  yau: 'yau-latn-ve',
  yav: 'yav-latn-cm',
  yaw: 'yaw-latn-br',
  yax: 'yax-latn-ao',
  yay: 'yay-latn-zz',
  yaz: 'yaz-latn-zz',
  yba: 'yba-latn-zz',
  ybb: 'ybb-latn-cm',
  ybe: 'ybe-latn-cn',
  'ybe-ougr': 'ybe-ougr-cn',
  ybh: 'ybh-deva-np',
  ybi: 'ybi-deva-np',
  ybj: 'ybj-latn-ng',
  ybl: 'ybl-latn-ng',
  ybm: 'ybm-latn-pg',
  ybn: 'ybn-latn-br',
  ybo: 'ybo-latn-pg',
  ybx: 'ybx-latn-pg',
  yby: 'yby-latn-zz',
  ycl: 'ycl-latn-cn',
  ycn: 'ycn-latn-co',
  yda: 'yda-latn-au',
  yde: 'yde-latn-pg',
  ydg: 'ydg-arab-pk',
  ydk: 'ydk-latn-pg',
  yea: 'yea-mlym-in',
  'yea-knda': 'yea-knda-in',
  yec: 'yec-latn-de',
  yee: 'yee-latn-pg',
  yei: 'yei-latn-cm',
  yej: 'yej-grek-il',
  yel: 'yel-latn-cd',
  yer: 'yer-latn-zz',
  yes: 'yes-latn-ng',
  yet: 'yet-latn-id',
  yeu: 'yeu-telu-in',
  yev: 'yev-latn-pg',
  yey: 'yey-latn-bw',
  yga: 'yga-latn-au',
  ygi: 'ygi-latn-au',
  ygl: 'ygl-latn-pg',
  ygm: 'ygm-latn-pg',
  ygp: 'ygp-plrd-cn',
  ygr: 'ygr-latn-zz',
  ygu: 'ygu-latn-au',
  ygw: 'ygw-latn-zz',
  yhd: 'yhd-hebr-il',
  yi: 'yi-hebr-001',
  yia: 'yia-latn-au',
  yig: 'yig-yiii-cn',
  yih: 'yih-hebr-de',
  yii: 'yii-latn-au',
  yij: 'yij-latn-au',
  yil: 'yil-latn-au',
  yim: 'yim-latn-in',
  yir: 'yir-latn-id',
  yis: 'yis-latn-pg',
  yiv: 'yiv-yiii-cn',
  yka: 'yka-latn-ph',
  'yka-arab': 'yka-arab-ph',
  ykg: 'ykg-cyrl-ru',
  yki: 'yki-latn-id',
  ykk: 'ykk-latn-pg',
  ykm: 'ykm-latn-pg',
  yko: 'yko-latn-zz',
  ykr: 'ykr-latn-pg',
  yky: 'yky-latn-cf',
  yla: 'yla-latn-pg',
  ylb: 'ylb-latn-pg',
  yle: 'yle-latn-zz',
  ylg: 'ylg-latn-zz',
  yli: 'yli-latn-id',
  yll: 'yll-latn-zz',
  ylr: 'ylr-latn-au',
  ylu: 'ylu-latn-pg',
  yly: 'yly-latn-nc',
  ymb: 'ymb-latn-pg',
  yme: 'yme-latn-pe',
  ymg: 'ymg-latn-cd',
  ymk: 'ymk-latn-mz',
  'ymk-arab': 'ymk-arab-mz',
  yml: 'yml-latn-zz',
  ymm: 'ymm-latn-so',
  ymn: 'ymn-latn-id',
  ymo: 'ymo-latn-pg',
  ymp: 'ymp-latn-pg',
  yna: 'yna-plrd-cn',
  ynd: 'ynd-latn-au',
  yng: 'yng-latn-cd',
  ynk: 'ynk-cyrl-ru',
  ynl: 'ynl-latn-pg',
  ynq: 'ynq-latn-ng',
  yns: 'yns-latn-cd',
  ynu: 'ynu-latn-co',
  yo: 'yo-latn-ng',
  yob: 'yob-latn-pg',
  yog: 'yog-latn-ph',
  yoi: 'yoi-jpan-jp',
  yok: 'yok-latn-us',
  yol: 'yol-latn-gb',
  yom: 'yom-latn-cd',
  yon: 'yon-latn-zz',
  yot: 'yot-latn-ng',
  yoy: 'yoy-thai-th',
  yra: 'yra-latn-pg',
  yrb: 'yrb-latn-zz',
  yre: 'yre-latn-zz',
  yrk: 'yrk-cyrl-ru',
  yrl: 'yrl-latn-br',
  yrm: 'yrm-latn-au',
  yro: 'yro-latn-br',
  yrs: 'yrs-latn-id',
  yrw: 'yrw-latn-pg',
  yry: 'yry-latn-au',
  ysd: 'ysd-yiii-cn',
  ysn: 'ysn-yiii-cn',
  ysp: 'ysp-yiii-cn',
  ysr: 'ysr-cyrl-ru',
  yss: 'yss-latn-zz',
  ysy: 'ysy-plrd-cn',
  ytw: 'ytw-latn-pg',
  yty: 'yty-latn-au',
  yua: 'yua-latn-mx',
  yub: 'yub-latn-au',
  yuc: 'yuc-latn-us',
  yud: 'yud-hebr-il',
  yue: 'yue-hant-hk',
  'yue-cn': 'yue-hans-cn',
  'yue-hans': 'yue-hans-cn',
  yuf: 'yuf-latn-us',
  yug: 'yug-cyrl-ru',
  yui: 'yui-latn-co',
  yuj: 'yuj-latn-zz',
  yul: 'yul-latn-cf',
  yum: 'yum-latn-us',
  yun: 'yun-latn-ng',
  yup: 'yup-latn-co',
  yuq: 'yuq-latn-bo',
  yur: 'yur-latn-us',
  yut: 'yut-latn-zz',
  yuw: 'yuw-latn-zz',
  yux: 'yux-cyrl-ru',
  yuz: 'yuz-latn-bo',
  yva: 'yva-latn-id',
  yvt: 'yvt-latn-ve',
  ywa: 'ywa-latn-pg',
  ywg: 'ywg-latn-au',
  ywn: 'ywn-latn-br',
  ywq: 'ywq-plrd-cn',
  'ywq-yiii': 'ywq-yiii-cn',
  ywr: 'ywr-latn-au',
  ywu: 'ywu-plrd-cn',
  'ywu-yiii': 'ywu-yiii-cn',
  yww: 'yww-latn-au',
  yxa: 'yxa-latn-au',
  yxg: 'yxg-latn-au',
  yxl: 'yxl-latn-au',
  yxm: 'yxm-latn-au',
  yxu: 'yxu-latn-au',
  yxy: 'yxy-latn-au',
  yyr: 'yyr-latn-au',
  yyu: 'yyu-latn-pg',
  za: 'za-latn-cn',
  zaa: 'zaa-latn-mx',
  zab: 'zab-latn-mx',
  zac: 'zac-latn-mx',
  zad: 'zad-latn-mx',
  zae: 'zae-latn-mx',
  zaf: 'zaf-latn-mx',
  zag: 'zag-latn-sd',
  zah: 'zah-latn-ng',
  zaj: 'zaj-latn-tz',
  zak: 'zak-latn-tz',
  zam: 'zam-latn-mx',
  zao: 'zao-latn-mx',
  zap: 'zap-latn-mx',
  zaq: 'zaq-latn-mx',
  zar: 'zar-latn-mx',
  zas: 'zas-latn-mx',
  zat: 'zat-latn-mx',
  zau: 'zau-tibt-in',
  'zau-arab': 'zau-arab-in',
  zav: 'zav-latn-mx',
  zaw: 'zaw-latn-mx',
  zax: 'zax-latn-mx',
  zay: 'zay-latn-et',
  'zay-ethi': 'zay-ethi-et',
  zaz: 'zaz-latn-ng',
  zba: 'zba-arab-001',
  zbc: 'zbc-latn-my',
  zbe: 'zbe-latn-my',
  zbt: 'zbt-latn-id',
  zbu: 'zbu-latn-ng',
  zbw: 'zbw-latn-my',
  zca: 'zca-latn-mx',
  zch: 'zch-hani-cn',
  zdj: 'zdj-arab-km',
  zea: 'zea-latn-nl',
  zeg: 'zeg-latn-pg',
  zeh: 'zeh-hani-cn',
  zen: 'zen-tfng-mr',
  'zen-arab': 'zen-arab-mr',
  zga: 'zga-latn-tz',
  zgb: 'zgb-hani-cn',
  zgh: 'zgh-tfng-ma',
  zgm: 'zgm-hani-cn',
  zgn: 'zgn-hani-cn',
  zgr: 'zgr-latn-pg',
  zh: 'zh-hans-cn',
  'zh-au': 'zh-hant-au',
  'zh-bn': 'zh-hant-bn',
  'zh-bopo': 'zh-bopo-tw',
  'zh-gb': 'zh-hant-gb',
  'zh-gf': 'zh-hant-gf',
  'zh-hanb': 'zh-hanb-tw',
  'zh-hant': 'zh-hant-tw',
  'zh-hk': 'zh-hant-hk',
  'zh-id': 'zh-hant-id',
  'zh-mo': 'zh-hant-mo',
  'zh-pa': 'zh-hant-pa',
  'zh-pf': 'zh-hant-pf',
  'zh-ph': 'zh-hant-ph',
  'zh-sr': 'zh-hant-sr',
  'zh-th': 'zh-hant-th',
  'zh-tw': 'zh-hant-tw',
  'zh-us': 'zh-hant-us',
  'zh-vn': 'zh-hant-vn',
  zhd: 'zhd-hani-cn',
  'zhd-latn': 'zhd-latn-vn',
  zhi: 'zhi-latn-ng',
  zhn: 'zhn-latn-cn',
  'zhn-hani': 'zhn-hani-cn',
  zhw: 'zhw-latn-cm',
  zhx: 'zhx-nshu-cn',
  zia: 'zia-latn-zz',
  zik: 'zik-latn-pg',
  zil: 'zil-latn-gn',
  zim: 'zim-latn-td',
  zin: 'zin-latn-tz',
  ziw: 'ziw-latn-tz',
  ziz: 'ziz-latn-ng',
  zka: 'zka-latn-id',
  zkb: 'zkb-cyrl-ru',
  zkd: 'zkd-latn-mm',
  zko: 'zko-cyrl-ru',
  zkp: 'zkp-latn-br',
  zkt: 'zkt-kits-cn',
  zku: 'zku-latn-au',
  zkz: 'zkz-cyrl-ru',
  zla: 'zla-latn-cd',
  zlj: 'zlj-hani-cn',
  'zlj-latn': 'zlj-latn-cn',
  zlm: 'zlm-latn-tg',
  zln: 'zln-hani-cn',
  zlq: 'zlq-hani-cn',
  zma: 'zma-latn-au',
  zmb: 'zmb-latn-cd',
  zmc: 'zmc-latn-au',
  zmd: 'zmd-latn-au',
  zme: 'zme-latn-au',
  zmf: 'zmf-latn-cd',
  zmg: 'zmg-latn-au',
  zmh: 'zmh-latn-pg',
  zmi: 'zmi-latn-my',
  zmj: 'zmj-latn-au',
  zmk: 'zmk-latn-au',
  zml: 'zml-latn-au',
  zmm: 'zmm-latn-au',
  zmn: 'zmn-latn-ga',
  zmo: 'zmo-latn-sd',
  zmp: 'zmp-latn-cd',
  zmq: 'zmq-latn-cd',
  zmr: 'zmr-latn-au',
  zms: 'zms-latn-cd',
  zmt: 'zmt-latn-au',
  zmu: 'zmu-latn-au',
  zmv: 'zmv-latn-au',
  zmw: 'zmw-latn-cd',
  zmx: 'zmx-latn-cg',
  zmy: 'zmy-latn-au',
  zmz: 'zmz-latn-cd',
  zna: 'zna-latn-td',
  zne: 'zne-latn-zz',
  zng: 'zng-latn-vn',
  znk: 'znk-latn-au',
  zns: 'zns-latn-ng',
  zoc: 'zoc-latn-mx',
  zoh: 'zoh-latn-mx',
  zom: 'zom-latn-in',
  zoo: 'zoo-latn-mx',
  zoq: 'zoq-latn-mx',
  zor: 'zor-latn-mx',
  zos: 'zos-latn-mx',
  zpa: 'zpa-latn-mx',
  zpb: 'zpb-latn-mx',
  zpc: 'zpc-latn-mx',
  zpd: 'zpd-latn-mx',
  zpe: 'zpe-latn-mx',
  zpf: 'zpf-latn-mx',
  zpg: 'zpg-latn-mx',
  zph: 'zph-latn-mx',
  zpi: 'zpi-latn-mx',
  zpj: 'zpj-latn-mx',
  zpk: 'zpk-latn-mx',
  zpl: 'zpl-latn-mx',
  zpm: 'zpm-latn-mx',
  zpn: 'zpn-latn-mx',
  zpo: 'zpo-latn-mx',
  zpp: 'zpp-latn-mx',
  zpq: 'zpq-latn-mx',
  zpr: 'zpr-latn-mx',
  zps: 'zps-latn-mx',
  zpt: 'zpt-latn-mx',
  zpu: 'zpu-latn-mx',
  zpv: 'zpv-latn-mx',
  zpw: 'zpw-latn-mx',
  zpx: 'zpx-latn-mx',
  zpy: 'zpy-latn-mx',
  zpz: 'zpz-latn-mx',
  zqe: 'zqe-hani-cn',
  'zqe-latn': 'zqe-latn-cn',
  zrn: 'zrn-latn-td',
  zro: 'zro-latn-ec',
  zrp: 'zrp-hebr-fr',
  zrs: 'zrs-latn-id',
  zsa: 'zsa-latn-pg',
  zsr: 'zsr-latn-mx',
  zsu: 'zsu-latn-pg',
  zte: 'zte-latn-mx',
  ztg: 'ztg-latn-mx',
  ztl: 'ztl-latn-mx',
  ztm: 'ztm-latn-mx',
  ztn: 'ztn-latn-mx',
  ztp: 'ztp-latn-mx',
  ztq: 'ztq-latn-mx',
  zts: 'zts-latn-mx',
  ztt: 'ztt-latn-mx',
  ztu: 'ztu-latn-mx',
  ztx: 'ztx-latn-mx',
  zty: 'zty-latn-mx',
  zu: 'zu-latn-za',
  zua: 'zua-latn-ng',
  zuh: 'zuh-latn-pg',
  zum: 'zum-arab-om',
  zun: 'zun-latn-us',
  zuy: 'zuy-latn-cm',
  zyg: 'zyg-hani-cn',
  zyj: 'zyj-latn-cn',
  'zyj-hani': 'zyj-hani-cn',
  zyn: 'zyn-hani-cn',
  zyp: 'zyp-latn-mm',
  zza: 'zza-latn-tr',
  zzj: 'zzj-hani-cn'
};

/***/ }),

/***/ "./node_modules/bcp-47-normalize/lib/many.js":
/*!***************************************************!*\
  !*** ./node_modules/bcp-47-normalize/lib/many.js ***!
  \***************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   many: function() { return /* binding */ many; }
/* harmony export */ });
/**
 * @typedef {'script'|'region'|'variants'} Field
 */

/**
 * @type {{region: Record<string, Array<string>>}}
 */
const many = {
  region: {
    172: ['ru', 'am', 'az', 'by', 'ge', 'kg', 'kz', 'md', 'tj', 'tm', 'ua', 'uz'],
    200: ['cz', 'sk'],
    530: ['cw', 'sx', 'bq'],
    532: ['cw', 'sx', 'bq'],
    536: ['sa', 'iq'],
    582: ['fm', 'mh', 'mp', 'pw'],
    810: ['ru', 'am', 'az', 'by', 'ee', 'ge', 'kz', 'kg', 'lv', 'lt', 'md', 'tj', 'tm', 'ua', 'uz'],
    830: ['je', 'gg'],
    890: ['rs', 'me', 'si', 'hr', 'mk', 'ba'],
    891: ['rs', 'me'],
    an: ['cw', 'sx', 'bq'],
    cs: ['rs', 'me'],
    fq: ['aq', 'tf'],
    nt: ['sa', 'iq'],
    pc: ['fm', 'mh', 'mp', 'pw'],
    su: ['ru', 'am', 'az', 'by', 'ee', 'ge', 'kz', 'kg', 'lv', 'lt', 'md', 'tj', 'tm', 'ua', 'uz'],
    yu: ['rs', 'me'],
    '062': ['034', '143'],
    ant: ['cw', 'sx', 'bq'],
    scg: ['rs', 'me'],
    ntz: ['sa', 'iq'],
    sun: ['ru', 'am', 'az', 'by', 'ee', 'ge', 'kz', 'kg', 'lv', 'lt', 'md', 'tj', 'tm', 'ua', 'uz'],
    yug: ['rs', 'me']
  }
};

/***/ }),

/***/ "./node_modules/bcp-47-normalize/lib/matches.js":
/*!******************************************************!*\
  !*** ./node_modules/bcp-47-normalize/lib/matches.js ***!
  \******************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   matches: function() { return /* binding */ matches; }
/* harmony export */ });
/**
 * @typedef Change
 * @property {string} from
 * @property {string} to
 */

/**
 * @type {Array<Change>}
 */
const matches = [{
  from: 'in',
  to: 'id'
}, {
  from: 'iw',
  to: 'he'
}, {
  from: 'ji',
  to: 'yi'
}, {
  from: 'jw',
  to: 'jv'
}, {
  from: 'mo',
  to: 'ro'
}, {
  from: 'scc',
  to: 'sr'
}, {
  from: 'scr',
  to: 'hr'
}, {
  from: 'aam',
  to: 'aas'
}, {
  from: 'adp',
  to: 'dz'
}, {
  from: 'aue',
  to: 'ktz'
}, {
  from: 'ayx',
  to: 'nun'
}, {
  from: 'bgm',
  to: 'bcg'
}, {
  from: 'bjd',
  to: 'drl'
}, {
  from: 'ccq',
  to: 'rki'
}, {
  from: 'cjr',
  to: 'mom'
}, {
  from: 'cka',
  to: 'cmr'
}, {
  from: 'cmk',
  to: 'xch'
}, {
  from: 'coy',
  to: 'pij'
}, {
  from: 'cqu',
  to: 'quh'
}, {
  from: 'drh',
  to: 'mn'
}, {
  from: 'drw',
  to: 'fa-af'
}, {
  from: 'gav',
  to: 'dev'
}, {
  from: 'gfx',
  to: 'vaj'
}, {
  from: 'ggn',
  to: 'gvr'
}, {
  from: 'gti',
  to: 'nyc'
}, {
  from: 'guv',
  to: 'duz'
}, {
  from: 'hrr',
  to: 'jal'
}, {
  from: 'ibi',
  to: 'opa'
}, {
  from: 'ilw',
  to: 'gal'
}, {
  from: 'jeg',
  to: 'oyb'
}, {
  from: 'kgc',
  to: 'tdf'
}, {
  from: 'kgh',
  to: 'kml'
}, {
  from: 'koj',
  to: 'kwv'
}, {
  from: 'krm',
  to: 'bmf'
}, {
  from: 'ktr',
  to: 'dtp'
}, {
  from: 'kvs',
  to: 'gdj'
}, {
  from: 'kwq',
  to: 'yam'
}, {
  from: 'kxe',
  to: 'tvd'
}, {
  from: 'kzj',
  to: 'dtp'
}, {
  from: 'kzt',
  to: 'dtp'
}, {
  from: 'lii',
  to: 'raq'
}, {
  from: 'lmm',
  to: 'rmx'
}, {
  from: 'meg',
  to: 'cir'
}, {
  from: 'mst',
  to: 'mry'
}, {
  from: 'mwj',
  to: 'vaj'
}, {
  from: 'myt',
  to: 'mry'
}, {
  from: 'nad',
  to: 'xny'
}, {
  from: 'ncp',
  to: 'kdz'
}, {
  from: 'nnx',
  to: 'ngv'
}, {
  from: 'nts',
  to: 'pij'
}, {
  from: 'oun',
  to: 'vaj'
}, {
  from: 'pcr',
  to: 'adx'
}, {
  from: 'pmc',
  to: 'huw'
}, {
  from: 'pmu',
  to: 'phr'
}, {
  from: 'ppa',
  to: 'bfy'
}, {
  from: 'ppr',
  to: 'lcq'
}, {
  from: 'pry',
  to: 'prt'
}, {
  from: 'puz',
  to: 'pub'
}, {
  from: 'sca',
  to: 'hle'
}, {
  from: 'skk',
  to: 'oyb'
}, {
  from: 'tdu',
  to: 'dtp'
}, {
  from: 'thc',
  to: 'tpo'
}, {
  from: 'thx',
  to: 'oyb'
}, {
  from: 'tie',
  to: 'ras'
}, {
  from: 'tkk',
  to: 'twm'
}, {
  from: 'tlw',
  to: 'weo'
}, {
  from: 'tmp',
  to: 'tyj'
}, {
  from: 'tne',
  to: 'kak'
}, {
  from: 'tnf',
  to: 'fa-af'
}, {
  from: 'tsf',
  to: 'taj'
}, {
  from: 'uok',
  to: 'ema'
}, {
  from: 'xba',
  to: 'cax'
}, {
  from: 'xia',
  to: 'acn'
}, {
  from: 'xkh',
  to: 'waw'
}, {
  from: 'xsj',
  to: 'suj'
}, {
  from: 'ybd',
  to: 'rki'
}, {
  from: 'yma',
  to: 'lrr'
}, {
  from: 'ymt',
  to: 'mtm'
}, {
  from: 'yos',
  to: 'zom'
}, {
  from: 'yuu',
  to: 'yug'
}, {
  from: 'asd',
  to: 'snz'
}, {
  from: 'dit',
  to: 'dif'
}, {
  from: 'llo',
  to: 'ngt'
}, {
  from: 'myd',
  to: 'aog'
}, {
  from: 'nns',
  to: 'nbr'
}, {
  from: 'agp',
  to: 'apf'
}, {
  from: 'ais',
  to: 'ami'
}, {
  from: 'ajt',
  to: 'aeb'
}, {
  from: 'baz',
  to: 'nvo'
}, {
  from: 'bhk',
  to: 'fbl'
}, {
  from: 'bic',
  to: 'bir'
}, {
  from: 'bjq',
  to: 'bzc'
}, {
  from: 'bkb',
  to: 'ebk'
}, {
  from: 'blg',
  to: 'iba'
}, {
  from: 'btb',
  to: 'beb'
}, {
  from: 'daf',
  to: 'dnj'
}, {
  from: 'dap',
  to: 'njz'
}, {
  from: 'djl',
  to: 'dze'
}, {
  from: 'dkl',
  to: 'aqd'
}, {
  from: 'drr',
  to: 'kzk'
}, {
  from: 'dud',
  to: 'uth'
}, {
  from: 'duj',
  to: 'dwu'
}, {
  from: 'dwl',
  to: 'dbt'
}, {
  from: 'elp',
  to: 'amq'
}, {
  from: 'gbc',
  to: 'wny'
}, {
  from: 'ggo',
  to: 'esg'
}, {
  from: 'ggr',
  to: 'gtu'
}, {
  from: 'gio',
  to: 'aou'
}, {
  from: 'gli',
  to: 'kzk'
}, {
  from: 'ill',
  to: 'ilm'
}, {
  from: 'izi',
  to: 'eza'
}, {
  from: 'jar',
  to: 'jgk'
}, {
  from: 'kdv',
  to: 'zkd'
}, {
  from: 'kgd',
  to: 'ncq'
}, {
  from: 'kpp',
  to: 'jkm'
}, {
  from: 'kxl',
  to: 'kru'
}, {
  from: 'kzh',
  to: 'dgl'
}, {
  from: 'lak',
  to: 'ksp'
}, {
  from: 'leg',
  to: 'enl'
}, {
  from: 'mgx',
  to: 'jbk'
}, {
  from: 'mnt',
  to: 'wnn'
}, {
  from: 'mof',
  to: 'xnt'
}, {
  from: 'mwd',
  to: 'dmw'
}, {
  from: 'nbf',
  to: 'nru'
}, {
  from: 'nbx',
  to: 'ekc'
}, {
  from: 'nln',
  to: 'azd'
}, {
  from: 'nlr',
  to: 'nrk'
}, {
  from: 'noo',
  to: 'dtd'
}, {
  from: 'nxu',
  to: 'bpp'
}, {
  from: 'pat',
  to: 'kxr'
}, {
  from: 'rmr',
  to: 'emx'
}, {
  from: 'sap',
  to: 'aqt'
}, {
  from: 'sgl',
  to: 'isk'
}, {
  from: 'smd',
  to: 'kmb'
}, {
  from: 'snb',
  to: 'iba'
}, {
  from: 'sul',
  to: 'sgd'
}, {
  from: 'sum',
  to: 'ulw'
}, {
  from: 'tgg',
  to: 'bjp'
}, {
  from: 'thw',
  to: 'ola'
}, {
  from: 'tid',
  to: 'itd'
}, {
  from: 'unp',
  to: 'wro'
}, {
  from: 'wgw',
  to: 'wgb'
}, {
  from: 'wit',
  to: 'nol'
}, {
  from: 'wiw',
  to: 'nwo'
}, {
  from: 'xrq',
  to: 'dmw'
}, {
  from: 'yen',
  to: 'ynq'
}, {
  from: 'yiy',
  to: 'yrm'
}, {
  from: 'zir',
  to: 'scv'
}, {
  from: 'sgn-br',
  to: 'bzs'
}, {
  from: 'sgn-co',
  to: 'csn'
}, {
  from: 'sgn-de',
  to: 'gsg'
}, {
  from: 'sgn-dk',
  to: 'dsl'
}, {
  from: 'sgn-fr',
  to: 'fsl'
}, {
  from: 'sgn-gb',
  to: 'bfi'
}, {
  from: 'sgn-gr',
  to: 'gss'
}, {
  from: 'sgn-ie',
  to: 'isg'
}, {
  from: 'sgn-it',
  to: 'ise'
}, {
  from: 'sgn-jp',
  to: 'jsl'
}, {
  from: 'sgn-mx',
  to: 'mfs'
}, {
  from: 'sgn-ni',
  to: 'ncs'
}, {
  from: 'sgn-nl',
  to: 'dse'
}, {
  from: 'sgn-no',
  to: 'nsi'
}, {
  from: 'sgn-pt',
  to: 'psr'
}, {
  from: 'sgn-se',
  to: 'swl'
}, {
  from: 'sgn-us',
  to: 'ase'
}, {
  from: 'sgn-za',
  to: 'sfs'
}, {
  from: 'sgn-es',
  to: 'ssp'
}, {
  from: 'zh-cmn',
  to: 'zh'
}, {
  from: 'zh-cmn-hans',
  to: 'zh-hans'
}, {
  from: 'zh-cmn-hant',
  to: 'zh-hant'
}, {
  from: 'zh-gan',
  to: 'gan'
}, {
  from: 'zh-wuu',
  to: 'wuu'
}, {
  from: 'zh-yue',
  to: 'yue'
}, {
  from: 'no-bokmal',
  to: 'nb'
}, {
  from: 'no-nynorsk',
  to: 'nn'
}, {
  from: 'aa-saaho',
  to: 'ssy'
}, {
  from: 'sh',
  to: 'sr-latn'
}, {
  from: 'cnr',
  to: 'sr-me'
}, {
  from: 'tl',
  to: 'fil'
}, {
  from: 'aju',
  to: 'jrb'
}, {
  from: 'als',
  to: 'sq'
}, {
  from: 'arb',
  to: 'ar'
}, {
  from: 'ayr',
  to: 'ay'
}, {
  from: 'azj',
  to: 'az'
}, {
  from: 'bcc',
  to: 'bal'
}, {
  from: 'bcl',
  to: 'bik'
}, {
  from: 'bxk',
  to: 'luy'
}, {
  from: 'bxr',
  to: 'bua'
}, {
  from: 'cld',
  to: 'syr'
}, {
  from: 'cmn',
  to: 'zh'
}, {
  from: 'cwd',
  to: 'cr'
}, {
  from: 'dgo',
  to: 'doi'
}, {
  from: 'dhd',
  to: 'mwr'
}, {
  from: 'dik',
  to: 'din'
}, {
  from: 'diq',
  to: 'zza'
}, {
  from: 'lbk',
  to: 'bnc'
}, {
  from: 'ekk',
  to: 'et'
}, {
  from: 'emk',
  to: 'man'
}, {
  from: 'esk',
  to: 'ik'
}, {
  from: 'fat',
  to: 'ak'
}, {
  from: 'fuc',
  to: 'ff'
}, {
  from: 'gaz',
  to: 'om'
}, {
  from: 'gbo',
  to: 'grb'
}, {
  from: 'gno',
  to: 'gon'
}, {
  from: 'gug',
  to: 'gn'
}, {
  from: 'gya',
  to: 'gba'
}, {
  from: 'hdn',
  to: 'hai'
}, {
  from: 'hea',
  to: 'hmn'
}, {
  from: 'ike',
  to: 'iu'
}, {
  from: 'kmr',
  to: 'ku'
}, {
  from: 'knc',
  to: 'kr'
}, {
  from: 'kng',
  to: 'kg'
}, {
  from: 'knn',
  to: 'kok'
}, {
  from: 'kpv',
  to: 'kv'
}, {
  from: 'lvs',
  to: 'lv'
}, {
  from: 'mhr',
  to: 'chm'
}, {
  from: 'mup',
  to: 'raj'
}, {
  from: 'khk',
  to: 'mn'
}, {
  from: 'npi',
  to: 'ne'
}, {
  from: 'ojg',
  to: 'oj'
}, {
  from: 'ory',
  to: 'or'
}, {
  from: 'pbu',
  to: 'ps'
}, {
  from: 'pes',
  to: 'fa'
}, {
  from: 'plt',
  to: 'mg'
}, {
  from: 'pnb',
  to: 'lah'
}, {
  from: 'quz',
  to: 'qu'
}, {
  from: 'rmy',
  to: 'rom'
}, {
  from: 'spy',
  to: 'kln'
}, {
  from: 'src',
  to: 'sc'
}, {
  from: 'swh',
  to: 'sw'
}, {
  from: 'ttq',
  to: 'tmh'
}, {
  from: 'tw',
  to: 'ak'
}, {
  from: 'umu',
  to: 'del'
}, {
  from: 'uzn',
  to: 'uz'
}, {
  from: 'xpe',
  to: 'kpe'
}, {
  from: 'xsl',
  to: 'den'
}, {
  from: 'ydd',
  to: 'yi'
}, {
  from: 'zai',
  to: 'zap'
}, {
  from: 'zsm',
  to: 'ms'
}, {
  from: 'zyb',
  to: 'za'
}, {
  from: 'him',
  to: 'srx'
}, {
  from: 'mnk',
  to: 'man'
}, {
  from: 'bh',
  to: 'bho'
}, {
  from: 'prs',
  to: 'fa-af'
}, {
  from: 'swc',
  to: 'sw-cd'
}, {
  from: 'aar',
  to: 'aa'
}, {
  from: 'abk',
  to: 'ab'
}, {
  from: 'ave',
  to: 'ae'
}, {
  from: 'afr',
  to: 'af'
}, {
  from: 'aka',
  to: 'ak'
}, {
  from: 'amh',
  to: 'am'
}, {
  from: 'arg',
  to: 'an'
}, {
  from: 'ara',
  to: 'ar'
}, {
  from: 'asm',
  to: 'as'
}, {
  from: 'ava',
  to: 'av'
}, {
  from: 'aym',
  to: 'ay'
}, {
  from: 'aze',
  to: 'az'
}, {
  from: 'bak',
  to: 'ba'
}, {
  from: 'bel',
  to: 'be'
}, {
  from: 'bul',
  to: 'bg'
}, {
  from: 'bih',
  to: 'bho'
}, {
  from: 'bis',
  to: 'bi'
}, {
  from: 'bam',
  to: 'bm'
}, {
  from: 'ben',
  to: 'bn'
}, {
  from: 'bod',
  to: 'bo'
}, {
  from: 'bre',
  to: 'br'
}, {
  from: 'bos',
  to: 'bs'
}, {
  from: 'cat',
  to: 'ca'
}, {
  from: 'che',
  to: 'ce'
}, {
  from: 'cha',
  to: 'ch'
}, {
  from: 'cos',
  to: 'co'
}, {
  from: 'cre',
  to: 'cr'
}, {
  from: 'ces',
  to: 'cs'
}, {
  from: 'chu',
  to: 'cu'
}, {
  from: 'chv',
  to: 'cv'
}, {
  from: 'cym',
  to: 'cy'
}, {
  from: 'dan',
  to: 'da'
}, {
  from: 'deu',
  to: 'de'
}, {
  from: 'div',
  to: 'dv'
}, {
  from: 'dzo',
  to: 'dz'
}, {
  from: 'ewe',
  to: 'ee'
}, {
  from: 'ell',
  to: 'el'
}, {
  from: 'eng',
  to: 'en'
}, {
  from: 'epo',
  to: 'eo'
}, {
  from: 'spa',
  to: 'es'
}, {
  from: 'est',
  to: 'et'
}, {
  from: 'eus',
  to: 'eu'
}, {
  from: 'fas',
  to: 'fa'
}, {
  from: 'ful',
  to: 'ff'
}, {
  from: 'fin',
  to: 'fi'
}, {
  from: 'fij',
  to: 'fj'
}, {
  from: 'fao',
  to: 'fo'
}, {
  from: 'fra',
  to: 'fr'
}, {
  from: 'fry',
  to: 'fy'
}, {
  from: 'gle',
  to: 'ga'
}, {
  from: 'gla',
  to: 'gd'
}, {
  from: 'glg',
  to: 'gl'
}, {
  from: 'grn',
  to: 'gn'
}, {
  from: 'guj',
  to: 'gu'
}, {
  from: 'glv',
  to: 'gv'
}, {
  from: 'hau',
  to: 'ha'
}, {
  from: 'heb',
  to: 'he'
}, {
  from: 'hin',
  to: 'hi'
}, {
  from: 'hmo',
  to: 'ho'
}, {
  from: 'hrv',
  to: 'hr'
}, {
  from: 'hat',
  to: 'ht'
}, {
  from: 'hun',
  to: 'hu'
}, {
  from: 'hye',
  to: 'hy'
}, {
  from: 'her',
  to: 'hz'
}, {
  from: 'ina',
  to: 'ia'
}, {
  from: 'ind',
  to: 'id'
}, {
  from: 'ile',
  to: 'ie'
}, {
  from: 'ibo',
  to: 'ig'
}, {
  from: 'iii',
  to: 'ii'
}, {
  from: 'ipk',
  to: 'ik'
}, {
  from: 'ido',
  to: 'io'
}, {
  from: 'isl',
  to: 'is'
}, {
  from: 'ita',
  to: 'it'
}, {
  from: 'iku',
  to: 'iu'
}, {
  from: 'jpn',
  to: 'ja'
}, {
  from: 'jav',
  to: 'jv'
}, {
  from: 'kat',
  to: 'ka'
}, {
  from: 'kon',
  to: 'kg'
}, {
  from: 'kik',
  to: 'ki'
}, {
  from: 'kua',
  to: 'kj'
}, {
  from: 'kaz',
  to: 'kk'
}, {
  from: 'kal',
  to: 'kl'
}, {
  from: 'khm',
  to: 'km'
}, {
  from: 'kan',
  to: 'kn'
}, {
  from: 'kor',
  to: 'ko'
}, {
  from: 'kau',
  to: 'kr'
}, {
  from: 'kas',
  to: 'ks'
}, {
  from: 'kur',
  to: 'ku'
}, {
  from: 'kom',
  to: 'kv'
}, {
  from: 'cor',
  to: 'kw'
}, {
  from: 'kir',
  to: 'ky'
}, {
  from: 'lat',
  to: 'la'
}, {
  from: 'ltz',
  to: 'lb'
}, {
  from: 'lug',
  to: 'lg'
}, {
  from: 'lim',
  to: 'li'
}, {
  from: 'lin',
  to: 'ln'
}, {
  from: 'lao',
  to: 'lo'
}, {
  from: 'lit',
  to: 'lt'
}, {
  from: 'lub',
  to: 'lu'
}, {
  from: 'lav',
  to: 'lv'
}, {
  from: 'mlg',
  to: 'mg'
}, {
  from: 'mah',
  to: 'mh'
}, {
  from: 'mri',
  to: 'mi'
}, {
  from: 'mkd',
  to: 'mk'
}, {
  from: 'mal',
  to: 'ml'
}, {
  from: 'mon',
  to: 'mn'
}, {
  from: 'mol',
  to: 'ro'
}, {
  from: 'mar',
  to: 'mr'
}, {
  from: 'msa',
  to: 'ms'
}, {
  from: 'mlt',
  to: 'mt'
}, {
  from: 'mya',
  to: 'my'
}, {
  from: 'nau',
  to: 'na'
}, {
  from: 'nob',
  to: 'nb'
}, {
  from: 'nde',
  to: 'nd'
}, {
  from: 'nep',
  to: 'ne'
}, {
  from: 'ndo',
  to: 'ng'
}, {
  from: 'nld',
  to: 'nl'
}, {
  from: 'nno',
  to: 'nn'
}, {
  from: 'nor',
  to: 'no'
}, {
  from: 'nbl',
  to: 'nr'
}, {
  from: 'nav',
  to: 'nv'
}, {
  from: 'nya',
  to: 'ny'
}, {
  from: 'oci',
  to: 'oc'
}, {
  from: 'oji',
  to: 'oj'
}, {
  from: 'orm',
  to: 'om'
}, {
  from: 'ori',
  to: 'or'
}, {
  from: 'oss',
  to: 'os'
}, {
  from: 'pan',
  to: 'pa'
}, {
  from: 'pli',
  to: 'pi'
}, {
  from: 'pol',
  to: 'pl'
}, {
  from: 'pus',
  to: 'ps'
}, {
  from: 'por',
  to: 'pt'
}, {
  from: 'que',
  to: 'qu'
}, {
  from: 'roh',
  to: 'rm'
}, {
  from: 'run',
  to: 'rn'
}, {
  from: 'ron',
  to: 'ro'
}, {
  from: 'rus',
  to: 'ru'
}, {
  from: 'kin',
  to: 'rw'
}, {
  from: 'san',
  to: 'sa'
}, {
  from: 'srd',
  to: 'sc'
}, {
  from: 'snd',
  to: 'sd'
}, {
  from: 'sme',
  to: 'se'
}, {
  from: 'sag',
  to: 'sg'
}, {
  from: 'hbs',
  to: 'sr-latn'
}, {
  from: 'sin',
  to: 'si'
}, {
  from: 'slk',
  to: 'sk'
}, {
  from: 'slv',
  to: 'sl'
}, {
  from: 'smo',
  to: 'sm'
}, {
  from: 'sna',
  to: 'sn'
}, {
  from: 'som',
  to: 'so'
}, {
  from: 'sqi',
  to: 'sq'
}, {
  from: 'srp',
  to: 'sr'
}, {
  from: 'ssw',
  to: 'ss'
}, {
  from: 'sot',
  to: 'st'
}, {
  from: 'sun',
  to: 'su'
}, {
  from: 'swe',
  to: 'sv'
}, {
  from: 'swa',
  to: 'sw'
}, {
  from: 'tam',
  to: 'ta'
}, {
  from: 'tel',
  to: 'te'
}, {
  from: 'tgk',
  to: 'tg'
}, {
  from: 'tha',
  to: 'th'
}, {
  from: 'tir',
  to: 'ti'
}, {
  from: 'tuk',
  to: 'tk'
}, {
  from: 'tgl',
  to: 'fil'
}, {
  from: 'tsn',
  to: 'tn'
}, {
  from: 'ton',
  to: 'to'
}, {
  from: 'tur',
  to: 'tr'
}, {
  from: 'tso',
  to: 'ts'
}, {
  from: 'tat',
  to: 'tt'
}, {
  from: 'twi',
  to: 'ak'
}, {
  from: 'tah',
  to: 'ty'
}, {
  from: 'uig',
  to: 'ug'
}, {
  from: 'ukr',
  to: 'uk'
}, {
  from: 'urd',
  to: 'ur'
}, {
  from: 'uzb',
  to: 'uz'
}, {
  from: 'ven',
  to: 've'
}, {
  from: 'vie',
  to: 'vi'
}, {
  from: 'vol',
  to: 'vo'
}, {
  from: 'wln',
  to: 'wa'
}, {
  from: 'wol',
  to: 'wo'
}, {
  from: 'xho',
  to: 'xh'
}, {
  from: 'yid',
  to: 'yi'
}, {
  from: 'yor',
  to: 'yo'
}, {
  from: 'zha',
  to: 'za'
}, {
  from: 'zho',
  to: 'zh'
}, {
  from: 'zul',
  to: 'zu'
}, {
  from: 'alb',
  to: 'sq'
}, {
  from: 'arm',
  to: 'hy'
}, {
  from: 'baq',
  to: 'eu'
}, {
  from: 'bur',
  to: 'my'
}, {
  from: 'chi',
  to: 'zh'
}, {
  from: 'cze',
  to: 'cs'
}, {
  from: 'dut',
  to: 'nl'
}, {
  from: 'fre',
  to: 'fr'
}, {
  from: 'geo',
  to: 'ka'
}, {
  from: 'ger',
  to: 'de'
}, {
  from: 'gre',
  to: 'el'
}, {
  from: 'ice',
  to: 'is'
}, {
  from: 'mac',
  to: 'mk'
}, {
  from: 'mao',
  to: 'mi'
}, {
  from: 'may',
  to: 'ms'
}, {
  from: 'per',
  to: 'fa'
}, {
  from: 'rum',
  to: 'ro'
}, {
  from: 'slo',
  to: 'sk'
}, {
  from: 'tib',
  to: 'bo'
}, {
  from: 'wel',
  to: 'cy'
}, {
  from: 'und-aaland',
  to: 'und-ax'
}, {
  from: 'hy-arevmda',
  to: 'hyw'
}, {
  from: 'und-arevmda',
  to: 'und'
}, {
  from: 'und-arevela',
  to: 'und'
}, {
  from: 'und-lojban',
  to: 'und'
}, {
  from: 'und-saaho',
  to: 'und'
}, {
  from: 'und-bokmal',
  to: 'und'
}, {
  from: 'und-nynorsk',
  to: 'und'
}, {
  from: 'und-hakka',
  to: 'und'
}, {
  from: 'und-xiang',
  to: 'und'
}, {
  from: 'und-hepburn-heploc',
  to: 'und-alalc97'
}];

/***/ }),

/***/ "./node_modules/bcp-47/lib/normal.js":
/*!*******************************************!*\
  !*** ./node_modules/bcp-47/lib/normal.js ***!
  \*******************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normal: function() { return /* binding */ normal; }
/* harmony export */ });
/** @type {Record<string, string|null>} */
const normal = {
  'en-gb-oed': 'en-GB-oxendict',
  'i-ami': 'ami',
  'i-bnn': 'bnn',
  'i-default': null,
  'i-enochian': null,
  'i-hak': 'hak',
  'i-klingon': 'tlh',
  'i-lux': 'lb',
  'i-mingo': null,
  'i-navajo': 'nv',
  'i-pwn': 'pwn',
  'i-tao': 'tao',
  'i-tay': 'tay',
  'i-tsu': 'tsu',
  'sgn-be-fr': 'sfb',
  'sgn-be-nl': 'vgt',
  'sgn-ch-de': 'sgg',
  'art-lojban': 'jbo',
  'cel-gaulish': null,
  'no-bok': 'nb',
  'no-nyn': 'nn',
  'zh-guoyu': 'cmn',
  'zh-hakka': 'hak',
  'zh-min': null,
  'zh-min-nan': 'nan',
  'zh-xiang': 'hsn'
};

/***/ }),

/***/ "./node_modules/bcp-47/lib/parse.js":
/*!******************************************!*\
  !*** ./node_modules/bcp-47/lib/parse.js ***!
  \******************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parse: function() { return /* binding */ parse; }
/* harmony export */ });
/* harmony import */ var is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! is-alphanumerical */ "./node_modules/is-alphanumerical/index.js");
/* harmony import */ var is_alphabetical__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! is-alphabetical */ "./node_modules/is-alphabetical/index.js");
/* harmony import */ var is_decimal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! is-decimal */ "./node_modules/is-decimal/index.js");
/* harmony import */ var _regular_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./regular.js */ "./node_modules/bcp-47/lib/regular.js");
/* harmony import */ var _normal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./normal.js */ "./node_modules/bcp-47/lib/normal.js");
/**
 * @callback Warning
 * @param {string} reason
 * @param {number} code
 * @param {number} offset
 * @returns {void}
 *
 * @typedef Options
 * @property {boolean} [normalize=true]
 * @property {boolean} [forgiving=false]
 * @property {Warning} [warning]
 *
 * @typedef Extension
 * @property {string} singleton
 * @property {Array<string>} extensions
 *
 * @typedef Schema
 * @property {string|null|undefined} language
 * @property {Array<string>} extendedLanguageSubtags
 * @property {string|null|undefined} script
 * @property {string|null|undefined} region
 * @property {Array<string>} variants
 * @property {Array<Extension>} extensions
 * @property {Array<string>} privateuse
 * @property {string|null|undefined} irregular
 * @property {string|null|undefined} regular
 */






const own = {}.hasOwnProperty;

/**
 * Parse a BCP 47 language tag.
 *
 * @param {string} tag
 * @param {Options} [options]
 * @returns {Schema}
 */
function parse(tag) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const result = empty();
  const source = String(tag);
  const value = source.toLowerCase();
  let index = 0;

  // Check input.
  if (tag === null || tag === undefined) {
    throw new Error('Expected string, got `' + tag + '`');
  }

  // Let’s start.
  // First: the edge cases.
  if (own.call(_normal_js__WEBPACK_IMPORTED_MODULE_0__.normal, value)) {
    const replacement = _normal_js__WEBPACK_IMPORTED_MODULE_0__.normal[value];
    if ((options.normalize === undefined || options.normalize === null || options.normalize) && typeof replacement === 'string') {
      return parse(replacement);
    }
    result[_regular_js__WEBPACK_IMPORTED_MODULE_1__.regular.includes(value) ? 'regular' : 'irregular'] = source;
    return result;
  }

  // Now, to actually parse, eat what could be a language.
  while ((0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index)) && index < 9) index++;

  // A language.
  if (index > 1 /* Min 639. */ && index < 9 /* Max subtag. */) {
    // 5 and up is a subtag.
    // 4 is the size of reserved languages.
    // 3 an ISO 639-2 or ISO 639-3.
    // 2 is an ISO 639-1.
    // <https://github.com/wooorm/iso-639-2>
    // <https://github.com/wooorm/iso-639-3>
    result.language = source.slice(0, index);
    if (index < 4 /* Max 639. */) {
      let groups = 0;
      while (value.charCodeAt(index) === 45 /* `-` */ && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 1)) && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 2)) && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 3)) && !(0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 4))) {
        if (groups > 2 /* Max extended language subtag count. */) {
          return fail(index, 3, 'Too many extended language subtags, expected at most 3 subtags');
        }

        // Extended language subtag.
        result.extendedLanguageSubtags.push(source.slice(index + 1, index + 4));
        index += 4;
        groups++;
      }
    }

    // ISO 15924 script.
    // <https://github.com/wooorm/iso-15924>
    if (value.charCodeAt(index) === 45 /* `-` */ && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 1)) && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 2)) && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 3)) && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 4)) && !(0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 5))) {
      result.script = source.slice(index + 1, index + 5);
      index += 5;
    }
    if (value.charCodeAt(index) === 45 /* `-` */) {
      // ISO 3166-1 region.
      // <https://github.com/wooorm/iso-3166>
      if ((0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 1)) && (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 2)) && !(0,is_alphabetical__WEBPACK_IMPORTED_MODULE_2__.isAlphabetical)(value.charCodeAt(index + 3))) {
        result.region = source.slice(index + 1, index + 3);
        index += 3;
      }
      // UN M49 region.
      // <https://github.com/wooorm/un-m49>
      else if ((0,is_decimal__WEBPACK_IMPORTED_MODULE_3__.isDecimal)(value.charCodeAt(index + 1)) && (0,is_decimal__WEBPACK_IMPORTED_MODULE_3__.isDecimal)(value.charCodeAt(index + 2)) && (0,is_decimal__WEBPACK_IMPORTED_MODULE_3__.isDecimal)(value.charCodeAt(index + 3)) && !(0,is_decimal__WEBPACK_IMPORTED_MODULE_3__.isDecimal)(value.charCodeAt(index + 4))) {
        result.region = source.slice(index + 1, index + 4);
        index += 4;
      }
    }
    while (value.charCodeAt(index) === 45 /* `-` */) {
      const start = index + 1;
      let offset = start;
      while ((0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(offset))) {
        if (offset - start > 7 /* Max variant. */) {
          return fail(offset, 1, 'Too long variant, expected at most 8 characters');
        }
        offset++;
      }
      if (
      // Long variant.
      offset - start > 4 /* Min alpha numeric variant. */ ||
      // Short variant.
      offset - start > 3 /* Min variant. */ && (0,is_decimal__WEBPACK_IMPORTED_MODULE_3__.isDecimal)(value.charCodeAt(start))) {
        result.variants.push(source.slice(start, offset));
        index = offset;
      }
      // Something else.
      else {
        break;
      }
    }

    // Extensions.
    while (value.charCodeAt(index) === 45 /* `-` */) {
      // Exit if this isn’t an extension.
      if (value.charCodeAt(index + 1) === 120 /* `x` */ || !(0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(index + 1)) || value.charCodeAt(index + 2) !== 45 /* `-` */ || !(0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(index + 3))) {
        break;
      }
      let offset = index + 2;
      let groups = 0;
      while (value.charCodeAt(offset) === 45 /* `-` */ && (0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(offset + 1)) && (0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(offset + 2))) {
        const start = offset + 1;
        offset = start + 2;
        groups++;
        while ((0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(offset))) {
          if (offset - start > 7 /* Max extension. */) {
            return fail(offset, 2, 'Too long extension, expected at most 8 characters');
          }
          offset++;
        }
      }
      if (!groups) {
        return fail(offset, 4, 'Empty extension, extensions must have at least 2 characters of content');
      }
      result.extensions.push({
        singleton: source.charAt(index + 1),
        extensions: source.slice(index + 3, offset).split('-')
      });
      index = offset;
    }
  }
  // Not a language.
  else {
    index = 0;
  }

  // Private use.
  if (index === 0 && value.charCodeAt(index) === 120 /* `x` */ || value.charCodeAt(index) === 45 /* `-` */ && value.charCodeAt(index + 1) === 120 /* `x` */) {
    index = index ? index + 2 : 1;
    let offset = index;
    while (value.charCodeAt(offset) === 45 /* `-` */ && (0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(offset + 1))) {
      const start = index + 1;
      offset = start;
      while ((0,is_alphanumerical__WEBPACK_IMPORTED_MODULE_4__.isAlphanumerical)(value.charCodeAt(offset))) {
        if (offset - start > 7 /* Max private use. */) {
          return fail(offset, 5, 'Too long private-use area, expected at most 8 characters');
        }
        offset++;
      }
      result.privateuse.push(source.slice(index + 1, offset));
      index = offset;
    }
  }
  if (index !== source.length) {
    return fail(index, 6, 'Found superfluous content after tag');
  }
  return result;

  /**
   * Create an empty results object.
   *
   * @param {number} offset
   * @param {number} code
   * @param {string} reason
   * @returns {Schema}
   */
  function fail(offset, code, reason) {
    if (options.warning) options.warning(reason, code, offset);
    return options.forgiving ? result : empty();
  }
}

/**
 * Create an empty results object.
 *
 * @returns {Schema}
 */
function empty() {
  return {
    language: null,
    extendedLanguageSubtags: [],
    script: null,
    region: null,
    variants: [],
    extensions: [],
    privateuse: [],
    irregular: null,
    regular: null
  };
}

/***/ }),

/***/ "./node_modules/bcp-47/lib/regular.js":
/*!********************************************!*\
  !*** ./node_modules/bcp-47/lib/regular.js ***!
  \********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   regular: function() { return /* binding */ regular; }
/* harmony export */ });
/** @type {Array<string>} */
const regular = ['art-lojban', 'cel-gaulish', 'no-bok', 'no-nyn', 'zh-guoyu', 'zh-hakka', 'zh-min', 'zh-min-nan', 'zh-xiang'];

/***/ }),

/***/ "./node_modules/bcp-47/lib/stringify.js":
/*!**********************************************!*\
  !*** ./node_modules/bcp-47/lib/stringify.js ***!
  \**********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   stringify: function() { return /* binding */ stringify; }
/* harmony export */ });
/**
 * @typedef {Partial<import('./parse.js').Schema>} Schema
 * @typedef {Partial<import('./parse.js').Extension>} Extension
 */

/**
 * Compile a language schema to a BCP 47 language tag.
 *
 * @param {Schema} schema
 * @returns {string}
 */
function stringify() {
  let schema = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  /** @type {Array<string>} */
  let result = [];
  if (schema.irregular) {
    return schema.irregular;
  }
  if (schema.regular) {
    return schema.regular;
  }
  if (schema.language) {
    result = result.concat(schema.language, schema.extendedLanguageSubtags || [], schema.script || [], schema.region || [], schema.variants || []);
    const values = schema.extensions || [];
    let index = -1;
    while (++index < values.length) {
      const value = values[index];
      if (value.singleton && value.extensions && value.extensions.length > 0) {
        result.push(value.singleton, ...value.extensions);
      }
    }
  }
  if (schema.privateuse && schema.privateuse.length > 0) {
    result.push('x', ...schema.privateuse);
  }
  return result.join('-');
}

/***/ }),

/***/ "./node_modules/is-alphabetical/index.js":
/*!***********************************************!*\
  !*** ./node_modules/is-alphabetical/index.js ***!
  \***********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isAlphabetical: function() { return /* binding */ isAlphabetical; }
/* harmony export */ });
/**
 * Check if the given character code, or the character code at the first
 * character, is alphabetical.
 *
 * @param {string|number} character
 * @returns {boolean} Whether `character` is alphabetical.
 */
function isAlphabetical(character) {
  const code = typeof character === 'string' ? character.charCodeAt(0) : character;
  return code >= 97 && code <= 122 /* a-z */ || code >= 65 && code <= 90 /* A-Z */;
}

/***/ }),

/***/ "./node_modules/is-alphanumerical/index.js":
/*!*************************************************!*\
  !*** ./node_modules/is-alphanumerical/index.js ***!
  \*************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isAlphanumerical: function() { return /* binding */ isAlphanumerical; }
/* harmony export */ });
/* harmony import */ var is_alphabetical__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! is-alphabetical */ "./node_modules/is-alphabetical/index.js");
/* harmony import */ var is_decimal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! is-decimal */ "./node_modules/is-decimal/index.js");



/**
 * Check if the given character code, or the character code at the first
 * character, is alphanumerical.
 *
 * @param {string|number} character
 * @returns {boolean} Whether `character` is alphanumerical.
 */
function isAlphanumerical(character) {
  return (0,is_alphabetical__WEBPACK_IMPORTED_MODULE_0__.isAlphabetical)(character) || (0,is_decimal__WEBPACK_IMPORTED_MODULE_1__.isDecimal)(character);
}

/***/ }),

/***/ "./node_modules/is-decimal/index.js":
/*!******************************************!*\
  !*** ./node_modules/is-decimal/index.js ***!
  \******************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isDecimal: function() { return /* binding */ isDecimal; }
/* harmony export */ });
/**
 * Check if the given character code, or the character code at the first
 * character, is decimal.
 *
 * @param {string|number} character
 * @returns {boolean} Whether `character` is a decimal
 */
function isDecimal(character) {
  const code = typeof character === 'string' ? character.charCodeAt(0) : character;
  return code >= 48 && code <= 57; /* 0-9 */
}

/***/ }),

/***/ "./src/core/Debug.js":
/*!***************************!*\
  !*** ./src/core/Debug.js ***!
  \***************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _EventBus_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventBus.js */ "./src/core/EventBus.js");
/* harmony import */ var _events_Events_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./events/Events.js */ "./src/core/events/Events.js");
/* harmony import */ var _FactoryMaker_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FactoryMaker.js */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



const LOG_LEVEL_NONE = 0;
const LOG_LEVEL_FATAL = 1;
const LOG_LEVEL_ERROR = 2;
const LOG_LEVEL_WARNING = 3;
const LOG_LEVEL_INFO = 4;
const LOG_LEVEL_DEBUG = 5;

/**
 * @module Debug
 * @param {object} config
 * @ignore
 */
function Debug(config) {
  config = config || {};
  const context = this.context;
  const eventBus = (0,_EventBus_js__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  const settings = config.settings;
  const logFn = [];
  let instance, showLogTimestamp, showCalleeName, startTime;
  function setup() {
    showLogTimestamp = true;
    showCalleeName = true;
    startTime = new Date().getTime();
    if (typeof window !== 'undefined' && window.console) {
      logFn[LOG_LEVEL_FATAL] = getLogFn(window.console.error);
      logFn[LOG_LEVEL_ERROR] = getLogFn(window.console.error);
      logFn[LOG_LEVEL_WARNING] = getLogFn(window.console.warn);
      logFn[LOG_LEVEL_INFO] = getLogFn(window.console.info);
      logFn[LOG_LEVEL_DEBUG] = getLogFn(window.console.debug);
    }
  }
  function getLogFn(fn) {
    if (fn && fn.bind) {
      return fn.bind(window.console);
    }
    // if not define, return the default function for reporting logs
    return window.console.log.bind(window.console);
  }

  /**
   * Retrieves a logger which can be used to write logging information in browser console.
   * @param {object} instance Object for which the logger is created. It is used
   * to include calle object information in log messages.
   * @memberof module:Debug
   * @returns {Logger}
   * @instance
   */
  function getLogger(instance) {
    return {
      fatal: fatal.bind(instance),
      error: error.bind(instance),
      warn: warn.bind(instance),
      info: info.bind(instance),
      debug: debug.bind(instance)
    };
  }

  /**
   * Prepends a timestamp in milliseconds to each log message.
   * @param {boolean} value Set to true if you want to see a timestamp in each log message.
   * @default LOG_LEVEL_WARNING
   * @memberof module:Debug
   * @instance
   */
  function setLogTimestampVisible(value) {
    showLogTimestamp = value;
  }

  /**
   * Prepends the callee object name, and media type if available, to each log message.
   * @param {boolean} value Set to true if you want to see the callee object name and media type in each log message.
   * @default true
   * @memberof module:Debug
   * @instance
   */
  function setCalleeNameVisible(value) {
    showCalleeName = value;
  }
  function fatal() {
    for (var _len = arguments.length, params = new Array(_len), _key = 0; _key < _len; _key++) {
      params[_key] = arguments[_key];
    }
    doLog(LOG_LEVEL_FATAL, this, ...params);
  }
  function error() {
    for (var _len2 = arguments.length, params = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      params[_key2] = arguments[_key2];
    }
    doLog(LOG_LEVEL_ERROR, this, ...params);
  }
  function warn() {
    for (var _len3 = arguments.length, params = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      params[_key3] = arguments[_key3];
    }
    doLog(LOG_LEVEL_WARNING, this, ...params);
  }
  function info() {
    for (var _len4 = arguments.length, params = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      params[_key4] = arguments[_key4];
    }
    doLog(LOG_LEVEL_INFO, this, ...params);
  }
  function debug() {
    for (var _len5 = arguments.length, params = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      params[_key5] = arguments[_key5];
    }
    doLog(LOG_LEVEL_DEBUG, this, ...params);
  }
  function doLog(level, _this) {
    let message = '';
    let logTime = null;
    if (showLogTimestamp) {
      logTime = new Date().getTime();
      message += '[' + (logTime - startTime) + ']';
    }
    if (showCalleeName && _this && _this.getClassName) {
      message += '[' + _this.getClassName() + ']';
      if (_this.getType) {
        message += '[' + _this.getType() + ']';
      }
    }
    if (message.length > 0) {
      message += ' ';
    }
    for (var _len6 = arguments.length, params = new Array(_len6 > 2 ? _len6 - 2 : 0), _key6 = 2; _key6 < _len6; _key6++) {
      params[_key6 - 2] = arguments[_key6];
    }
    Array.apply(null, params).forEach(function (item) {
      message += item + ' ';
    });

    // log to console if the log level is high enough
    if (logFn[level] && settings && settings.get().debug.logLevel >= level) {
      logFn[level](message);
    }

    // send log event regardless of log level
    if (settings && settings.get().debug.dispatchEvent) {
      eventBus.trigger(_events_Events_js__WEBPACK_IMPORTED_MODULE_1__["default"].LOG, {
        message: message,
        level: level
      });
    }
  }
  instance = {
    getLogger: getLogger,
    setLogTimestampVisible: setLogTimestampVisible,
    setCalleeNameVisible: setCalleeNameVisible
  };
  setup();
  return instance;
}
Debug.__dashjs_factory_name = 'Debug';
const factory = _FactoryMaker_js__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(Debug);
factory.LOG_LEVEL_NONE = LOG_LEVEL_NONE;
factory.LOG_LEVEL_FATAL = LOG_LEVEL_FATAL;
factory.LOG_LEVEL_ERROR = LOG_LEVEL_ERROR;
factory.LOG_LEVEL_WARNING = LOG_LEVEL_WARNING;
factory.LOG_LEVEL_INFO = LOG_LEVEL_INFO;
factory.LOG_LEVEL_DEBUG = LOG_LEVEL_DEBUG;
_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_2__["default"].updateSingletonFactory(Debug.__dashjs_factory_name, factory);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/core/EventBus.js":
/*!******************************!*\
  !*** ./src/core/EventBus.js ***!
  \******************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents.js */ "./src/streaming/MediaPlayerEvents.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


const EVENT_PRIORITY_LOW = 0;
const EVENT_PRIORITY_HIGH = 5000;
function EventBus() {
  let handlers = {};
  function _commonOn(type, listener, scope) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    let executeOnlyOnce = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
    if (!type) {
      throw new Error('event type cannot be null or undefined');
    }
    if (!listener || typeof listener !== 'function') {
      throw new Error('listener must be a function: ' + listener);
    }
    let priority = options.priority || EVENT_PRIORITY_LOW;
    if (getHandlerIdx(type, listener, scope) >= 0) {
      return;
    }
    handlers[type] = handlers[type] || [];
    const handler = {
      callback: listener,
      scope,
      priority,
      executeOnlyOnce
    };
    if (scope && scope.getStreamId) {
      handler.streamId = scope.getStreamId();
    }
    if (scope && scope.getType) {
      handler.mediaType = scope.getType();
    }
    if (options && options.mode) {
      handler.mode = options.mode;
    }
    const inserted = handlers[type].some((item, idx) => {
      if (item && priority > item.priority) {
        handlers[type].splice(idx, 0, handler);
        return true;
      }
    });
    if (!inserted) {
      handlers[type].push(handler);
    }
  }
  function on(type, listener, scope) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    _commonOn(type, listener, scope, options);
  }
  function once(type, listener, scope) {
    let options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    _commonOn(type, listener, scope, options, true);
  }
  function off(type, listener, scope) {
    if (!type || !listener || !handlers[type]) {
      return;
    }
    const idx = getHandlerIdx(type, listener, scope);
    if (idx < 0) {
      return;
    }
    handlers[type][idx] = null;
  }
  function trigger(type) {
    let payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    let filters = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    if (!type || !handlers[type]) {
      return;
    }
    payload = payload || {};
    if (payload.hasOwnProperty('type')) {
      throw new Error('\'type\' is a reserved word for event dispatching');
    }
    payload.type = type;
    if (filters.streamId) {
      payload.streamId = filters.streamId;
    }
    if (filters.mediaType) {
      payload.mediaType = filters.mediaType;
    }
    const handlersToRemove = [];
    handlers[type].filter(handler => {
      if (!handler) {
        return false;
      }
      if (filters.streamId && handler.streamId && handler.streamId !== filters.streamId) {
        return false;
      }
      if (filters.mediaType && handler.mediaType && handler.mediaType !== filters.mediaType) {
        return false;
      }
      // This is used for dispatching DASH events. By default we use the onStart mode. Consequently we filter everything that has a non matching mode and the onReceive events for handlers that did not specify a mode.
      if (filters.mode && handler.mode && handler.mode !== filters.mode || !handler.mode && filters.mode && filters.mode === _streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT_MODE_ON_RECEIVE) {
        return false;
      }
      return true;
    }).forEach(handler => {
      handler && handler.callback.call(handler.scope, payload);
      if (handler.executeOnlyOnce) {
        handlersToRemove.push(handler);
      }
    });
    handlersToRemove.forEach(handler => {
      off(type, handler.callback, handler.scope);
    });
  }
  function getHandlerIdx(type, listener, scope) {
    let idx = -1;
    if (!handlers[type]) {
      return idx;
    }
    handlers[type].some((item, index) => {
      if (item && item.callback === listener && (!scope || scope === item.scope)) {
        idx = index;
        return true;
      }
    });
    return idx;
  }
  function reset() {
    handlers = {};
  }
  const instance = {
    on,
    once,
    off,
    trigger,
    reset
  };
  return instance;
}
EventBus.__dashjs_factory_name = 'EventBus';
const factory = _FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(EventBus);
factory.EVENT_PRIORITY_LOW = EVENT_PRIORITY_LOW;
factory.EVENT_PRIORITY_HIGH = EVENT_PRIORITY_HIGH;
_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].updateSingletonFactory(EventBus.__dashjs_factory_name, factory);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/core/FactoryMaker.js":
/*!**********************************!*\
  !*** ./src/core/FactoryMaker.js ***!
  \**********************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @module FactoryMaker
 * @ignore
 */
const FactoryMaker = function () {
  let instance;
  let singletonContexts = [];
  const singletonFactories = {};
  const classFactories = {};
  function extend(name, childInstance, override, context) {
    if (!context[name] && childInstance) {
      context[name] = {
        instance: childInstance,
        override: override
      };
    }
  }

  /**
   * Use this method from your extended object.  this.factory is injected into your object.
   * this.factory.getSingletonInstance(this.context, 'VideoModel')
   * will return the video model for use in the extended object.
   *
   * @param {Object} context - injected into extended object as this.context
   * @param {string} className - string name found in all dash.js objects
   * with name __dashjs_factory_name Will be at the bottom. Will be the same as the object's name.
   * @returns {*} Context aware instance of specified singleton name.
   * @memberof module:FactoryMaker
   * @instance
   */
  function getSingletonInstance(context, className) {
    for (const i in singletonContexts) {
      const obj = singletonContexts[i];
      if (obj.context === context && obj.name === className) {
        return obj.instance;
      }
    }
    return null;
  }

  /**
   * Use this method to add an singleton instance to the system.  Useful for unit testing to mock objects etc.
   *
   * @param {Object} context
   * @param {string} className
   * @param {Object} instance
   * @memberof module:FactoryMaker
   * @instance
   */
  function setSingletonInstance(context, className, instance) {
    for (const i in singletonContexts) {
      const obj = singletonContexts[i];
      if (obj.context === context && obj.name === className) {
        singletonContexts[i].instance = instance;
        return;
      }
    }
    singletonContexts.push({
      name: className,
      context: context,
      instance: instance
    });
  }

  /**
   * Use this method to remove all singleton instances associated with a particular context.
   *
   * @param {Object} context
   * @memberof module:FactoryMaker
   * @instance
   */
  function deleteSingletonInstances(context) {
    singletonContexts = singletonContexts.filter(x => x.context !== context);
  }

  /*------------------------------------------------------------------------------------------*/

  // Factories storage Management

  /*------------------------------------------------------------------------------------------*/

  function getFactoryByName(name, factoriesArray) {
    return factoriesArray[name];
  }
  function updateFactory(name, factory, factoriesArray) {
    if (name in factoriesArray) {
      factoriesArray[name] = factory;
    }
  }

  /*------------------------------------------------------------------------------------------*/

  // Class Factories Management

  /*------------------------------------------------------------------------------------------*/

  function updateClassFactory(name, factory) {
    updateFactory(name, factory, classFactories);
  }
  function getClassFactoryByName(name) {
    return getFactoryByName(name, classFactories);
  }
  function getClassFactory(classConstructor) {
    let factory = getFactoryByName(classConstructor.__dashjs_factory_name, classFactories);
    if (!factory) {
      factory = function (context) {
        if (context === undefined) {
          context = {};
        }
        return {
          create: function () {
            return merge(classConstructor, context, arguments);
          }
        };
      };
      classFactories[classConstructor.__dashjs_factory_name] = factory; // store factory
    }
    return factory;
  }

  /*------------------------------------------------------------------------------------------*/

  // Singleton Factory MAangement

  /*------------------------------------------------------------------------------------------*/

  function updateSingletonFactory(name, factory) {
    updateFactory(name, factory, singletonFactories);
  }
  function getSingletonFactoryByName(name) {
    return getFactoryByName(name, singletonFactories);
  }
  function getSingletonFactory(classConstructor) {
    let factory = getFactoryByName(classConstructor.__dashjs_factory_name, singletonFactories);
    if (!factory) {
      factory = function (context) {
        let instance;
        if (context === undefined) {
          context = {};
        }
        return {
          getInstance: function () {
            // If we don't have an instance yet check for one on the context
            if (!instance) {
              instance = getSingletonInstance(context, classConstructor.__dashjs_factory_name);
            }
            // If there's no instance on the context then create one
            if (!instance) {
              instance = merge(classConstructor, context, arguments);
              singletonContexts.push({
                name: classConstructor.__dashjs_factory_name,
                context: context,
                instance: instance
              });
            }
            return instance;
          }
        };
      };
      singletonFactories[classConstructor.__dashjs_factory_name] = factory; // store factory
    }
    return factory;
  }
  function merge(classConstructor, context, args) {
    let classInstance;
    const className = classConstructor.__dashjs_factory_name;
    const extensionObject = context[className];
    if (extensionObject) {
      let extension = extensionObject.instance;
      if (extensionObject.override) {
        //Override public methods in parent but keep parent.

        classInstance = classConstructor.apply({
          context
        }, args);
        extension = extension.apply({
          context,
          factory: instance,
          parent: classInstance
        }, args);
        for (const prop in extension) {
          if (classInstance.hasOwnProperty(prop)) {
            classInstance[prop] = extension[prop];
          }
        }
      } else {
        //replace parent object completely with new object. Same as dijon.

        return extension.apply({
          context,
          factory: instance
        }, args);
      }
    } else {
      // Create new instance of the class
      classInstance = classConstructor.apply({
        context
      }, args);
    }

    // Add getClassName function to class instance prototype (used by Debug)
    classInstance.getClassName = function () {
      return className;
    };
    return classInstance;
  }
  instance = {
    extend: extend,
    getSingletonInstance: getSingletonInstance,
    setSingletonInstance: setSingletonInstance,
    deleteSingletonInstances: deleteSingletonInstances,
    getSingletonFactory: getSingletonFactory,
    getSingletonFactoryByName: getSingletonFactoryByName,
    updateSingletonFactory: updateSingletonFactory,
    getClassFactory: getClassFactory,
    getClassFactoryByName: getClassFactoryByName,
    updateClassFactory: updateClassFactory
  };
  return instance;
}();
/* harmony default export */ __webpack_exports__["default"] = (FactoryMaker);

/***/ }),

/***/ "./src/core/Settings.js":
/*!******************************!*\
  !*** ./src/core/Settings.js ***!
  \******************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ "./src/core/Utils.js");
/* harmony import */ var _core_Debug_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/Debug.js */ "./src/core/Debug.js");
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest.js */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _EventBus_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./EventBus.js */ "./src/core/EventBus.js");
/* harmony import */ var _events_Events_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./events/Events.js */ "./src/core/events/Events.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */








/** @module Settings
 * @description Define the configuration parameters of Dash.js MediaPlayer.
 * @see {@link module:Settings~PlayerSettings PlayerSettings} for further information about the supported configuration properties.
 */

/**
 * @typedef {Object} PlayerSettings
 * @property {module:Settings~DebugSettings} [debug]
 * Debug related settings.
 * @property {module:Settings~ErrorSettings} [errors]
 * Error related settings
 * @property {module:Settings~StreamingSettings} [streaming]
 * Streaming related settings.
 * @example
 *
 * // Full settings object
 * settings = {
 *        debug: {
 *            logLevel: Debug.LOG_LEVEL_WARNING,
 *            dispatchEvent: false
 *        },
 *        streaming: {
 *            abandonLoadTimeout: 10000,
 *            wallclockTimeUpdateInterval: 100,
 *            manifestUpdateRetryInterval: 100,
 *            liveUpdateTimeThresholdInMilliseconds: 0,
 *            cacheInitSegments: false,
 *            applyServiceDescription: true,
 *            applyProducerReferenceTime: true,
 *            applyContentSteering: true,
 *            enableManifestDurationMismatchFix: true,
 *            parseInbandPrft: false,
 *            enableManifestTimescaleMismatchFix: false,
 *            capabilities: {
 *               filterUnsupportedEssentialProperties: true,
 *               supportedEssentialProperties: [
 *                   { schemeIdUri: Constants.FONT_DOWNLOAD_DVB_SCHEME },
 *                   { schemeIdUri: Constants.COLOUR_PRIMARIES_SCHEME_ID_URI, value: /1|5|6|7/ },
 *                   { schemeIdUri: Constants.URL_QUERY_INFO_SCHEME },
 *                   { schemeIdUri: Constants.EXT_URL_QUERY_INFO_SCHEME },
 *                   { schemeIdUri: Constants.MATRIX_COEFFICIENTS_SCHEME_ID_URI, value: /0|1|5|6/ },
 *                   { schemeIdUri: Constants.TRANSFER_CHARACTERISTICS_SCHEME_ID_URI, value: /1|6|13|14|15/ },
 *                   ...Constants.THUMBNAILS_SCHEME_ID_URIS.map(ep => { return { 'schemeIdUri': ep }; })
 *               ],
 *               useMediaCapabilitiesApi: true,
 *               filterVideoColorimetryEssentialProperties: false,
 *               filterHDRMetadataFormatEssentialProperties: false
 *            },
 *            events: {
 *              eventControllerRefreshDelay: 100,
 *              deleteEventMessageDataTimeout: 10000
 *            }
 *            timeShiftBuffer: {
 *                calcFromSegmentTimeline: false,
 *                fallbackToSegmentTimeline: true
 *            },
 *            metrics: {
 *              maxListDepth: 100
 *            },
 *            delay: {
 *                liveDelayFragmentCount: NaN,
 *                liveDelay: NaN,
 *                useSuggestedPresentationDelay: true
 *            },
 *            protection: {
 *                keepProtectionMediaKeys: false,
 *                ignoreEmeEncryptedEvent: false,
 *                detectPlayreadyMessageFormat: true,
 *                ignoreKeyStatuses: false
 *            },
 *            buffer: {
 *                enableSeekDecorrelationFix: false,
 *                fastSwitchEnabled: true,
 *                flushBufferAtTrackSwitch: false,
 *                reuseExistingSourceBuffers: true,
 *                bufferPruningInterval: 10,
 *                bufferToKeep: 20,
 *                bufferTimeAtTopQuality: 30,
 *                bufferTimeAtTopQualityLongForm: 60,
 *                initialBufferLevel: NaN,
 *                bufferTimeDefault: 18,
 *                longFormContentDurationThreshold: 600,
 *                stallThreshold: 0.3,
 *                lowLatencyStallThreshold: 0.3,
 *                useAppendWindow: true,
 *                setStallState: true,
 *                avoidCurrentTimeRangePruning: false,
 *                useChangeType: true,
 *                mediaSourceDurationInfinity: true,
 *                resetSourceBuffersForTrackSwitch: false,
 *                syntheticStallEvents: {
 *                    enabled: false,
 *                    ignoreReadyState: false
 *                }
 *            },
 *            gaps: {
 *                jumpGaps: true,
 *                jumpLargeGaps: true,
 *                smallGapLimit: 1.5,
 *                threshold: 0.3,
 *                enableSeekFix: true,
 *                enableStallFix: false,
 *                stallSeek: 0.1
 *            },
 *            utcSynchronization: {
 *                enabled: true,
 *                useManifestDateHeaderTimeSource: true,
 *                backgroundAttempts: 2,
 *                timeBetweenSyncAttempts: 30,
 *                maximumTimeBetweenSyncAttempts: 600,
 *                minimumTimeBetweenSyncAttempts: 2,
 *                timeBetweenSyncAttemptsAdjustmentFactor: 2,
 *                maximumAllowedDrift: 100,
 *                enableBackgroundSyncAfterSegmentDownloadError: true,
 *                defaultTimingSource: {
 *                    scheme: 'urn:mpeg:dash:utc:http-xsdate:2014',
 *                    value: 'http://time.akamai.com/?iso&ms'
 *                }
 *            },
 *            scheduling: {
 *                defaultTimeout: 500,
 *                lowLatencyTimeout: 0,
 *                scheduleWhilePaused: true
 *            },
 *            text: {
 *                defaultEnabled: true,
 *                dispatchForManualRendering: false,
 *                extendSegmentedCues: true,
 *                imsc: {
 *                    displayForcedOnlyMode: false,
 *                    enableRollUp: true
 *                },
 *                webvtt: {
 *                    customRenderingEnabled: false
 *                }
 *            },
 *            liveCatchup: {
 *                maxDrift: NaN,
 *                playbackRate: {min: NaN, max: NaN},
 *                playbackBufferMin: 0.5,
 *                enabled: null,
 *                mode: Constants.LIVE_CATCHUP_MODE_DEFAULT
 *            },
 *            lastBitrateCachingInfo: { enabled: true, ttl: 360000 },
 *            lastMediaSettingsCachingInfo: { enabled: true, ttl: 360000 },
 *            saveLastMediaSettingsForCurrentStreamingSession: true,
 *            cacheLoadThresholds: { video: 10, audio: 5 },
 *            trackSwitchMode: {
 *                audio: Constants.TRACK_SWITCH_MODE_ALWAYS_REPLACE,
 *                video: Constants.TRACK_SWITCH_MODE_NEVER_REPLACE
 *            },
 *            ignoreSelectionPriority: false,
 *            prioritizeRoleMain: true,
 *            assumeDefaultRoleAsMain: true,
 *            selectionModeForInitialTrack: Constants.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY,
 *            fragmentRequestTimeout: 20000,
 *            fragmentRequestProgressTimeout: -1,
 *            manifestRequestTimeout: 10000,
 *            retryIntervals: {
 *                [HTTPRequest.MPD_TYPE]: 500,
 *                [HTTPRequest.XLINK_EXPANSION_TYPE]: 500,
 *                [HTTPRequest.MEDIA_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.INIT_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.INDEX_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.LICENSE]: 1000,
 *                [HTTPRequest.OTHER_TYPE]: 1000,
 *                lowLatencyReductionFactor: 10
 *            },
 *            retryAttempts: {
 *                [HTTPRequest.MPD_TYPE]: 3,
 *                [HTTPRequest.XLINK_EXPANSION_TYPE]: 1,
 *                [HTTPRequest.MEDIA_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.INIT_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.INDEX_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.LICENSE]: 3,
 *                [HTTPRequest.OTHER_TYPE]: 3,
 *                lowLatencyMultiplyFactor: 5
 *            },
 *             abr: {
 *                 limitBitrateByPortal: false,
 *                 usePixelRatioInLimitBitrateByPortal: false,
 *                rules: {
 *                     throughputRule: {
 *                         active: true
 *                     },
 *                     bolaRule: {
 *                         active: true
 *                     },
 *                     insufficientBufferRule: {
 *                         active: true,
 *                         parameters: {
 *                             throughputSafetyFactor: 0.7,
 *                             segmentIgnoreCount: 2
 *                         }
 *                     },
 *                     switchHistoryRule: {
 *                         active: true,
 *                         parameters: {
 *                             sampleSize: 8,
 *                             switchPercentageThreshold: 0.075
 *                         }
 *                     },
 *                     droppedFramesRule: {
 *                         active: true,
 *                         parameters: {
 *                             minimumSampleSize: 375,
 *                             droppedFramesPercentageThreshold: 0.15
 *                         }
 *                     },
 *                     abandonRequestsRule: {
 *                         active: true,
 *                         parameters: {
 *                             abandonDurationMultiplier: 1.8,
 *                             minSegmentDownloadTimeThresholdInMs: 500,
 *                             minThroughputSamplesThreshold: 6
 *                         }
 *                     },
 *                     l2ARule: {
 *                         active: false
 *                     },
 *                     loLPRule: {
 *                         active: false
 *                     }
 *                 },
 *                 throughput: {
 *                     averageCalculationMode: Constants.THROUGHPUT_CALCULATION_MODES.EWMA,
 *                     lowLatencyDownloadTimeCalculationMode: Constants.LOW_LATENCY_DOWNLOAD_TIME_CALCULATION_MODE.MOOF_PARSING,
 *                     useResourceTimingApi: true,
 *                     useNetworkInformationApi: {
 *                         xhr: false,
 *                         fetch: false
 *                     },
 *                     useDeadTimeLatency: true,
 *                     bandwidthSafetyFactor: 0.9,
 *                     sampleSettings: {
 *                         live: 3,
 *                         vod: 4,
 *                         enableSampleSizeAdjustment: true,
 *                         decreaseScale: 0.7,
 *                         increaseScale: 1.3,
 *                         maxMeasurementsToKeep: 20,
 *                         averageLatencySampleAmount: 4,
 *                     },
 *                     ewma: {
 *                         throughputSlowHalfLifeSeconds: 8,
 *                         throughputFastHalfLifeSeconds: 3,
 *                         latencySlowHalfLifeCount: 2,
 *                         latencyFastHalfLifeCount: 1,
 *                         weightDownloadTimeMultiplicationFactor: 0.0015
 *                     }
 *                 },
 *                 maxBitrate: {
 *                     audio: -1,
 *                     video: -1
 *                 },
 *                 minBitrate: {
 *                     audio: -1,
 *                     video: -1
 *                 },
 *                 initialBitrate: {
 *                     audio: -1,
 *                     video: -1
 *                 },
 *                 autoSwitchBitrate: {
 *                     audio: true,
 *                     video: true
 *                 }
 *             },
 *            cmcd: {
 *                enabled: false,
 *                sid: null,
 *                cid: null,
 *                rtp: null,
 *                rtpSafetyFactor: 5,
 *                mode: Constants.CMCD_MODE_QUERY,
 *                enabledKeys: ['br', 'd', 'ot', 'tb' , 'bl', 'dl', 'mtp', 'nor', 'nrr', 'su' , 'bs', 'rtp' , 'cid', 'pr', 'sf', 'sid', 'st', 'v']
 *                includeInRequests: ['segment', 'mpd'],
 *                version: 1
 *            },
 *            cmsd: {
 *                enabled: false,
 *                abr: {
 *                    applyMb: false,
 *                    etpWeightRatio: 0
 *                }
 *            },
 *            defaultSchemeIdUri: {
 *                viewpoint: '',
 *                audioChannelConfiguration: 'urn:mpeg:mpegB:cicp:ChannelConfiguration',
 *                role: 'urn:mpeg:dash:role:2011',
 *                accessibility: 'urn:mpeg:dash:role:2011'
 *            }
 *          },
 *          errors: {
 *            recoverAttempts: {
 *                mediaErrorDecode: 5
 *             }
 *          }
 * }
 */

/**
 * @typedef {Object} TimeShiftBuffer
 * @property {boolean} [calcFromSegmentTimeline=false]
 * Enable calculation of the DVR window for SegmentTimeline manifests based on the entries in \<SegmentTimeline\>.
 *  * @property {boolean} [fallbackToSegmentTimeline=true]
 * In case the MPD uses \<SegmentTimeline\ and no segment is found within the DVR window the DVR window is calculated based on the entries in \<SegmentTimeline\>.
 */

/**
 * @typedef {Object} EventSettings
 * @property {number} [eventControllerRefreshDelay=100]
 * Interval timer used by the EventController to check if events need to be triggered or removed.
 * @property {number} [deleteEventMessageDataTimeout=10000]
 * If this value is larger than -1 the EventController will delete the message data attributes of events after they have been started and dispatched to the application.
 * This is to save memory in case events have a long duration and need to be persisted in the EventController.
 * This parameter defines the time in milliseconds between the start of an event and when the message data is deleted.
 * If an event is dispatched for the second time (e.g. when the user seeks back) the message data will not be included in the dispatched event if it has been deleted already.
 * Set this value to -1 to not delete any message data.
 */

/**
 * @typedef {Object} LiveDelay
 * @property {number} [liveDelayFragmentCount=NaN]
 * Changing this value will lower or increase live stream latency.
 *
 * The detected segment duration will be multiplied by this value to define a time in seconds to delay a live stream from the live edge.
 *
 * Lowering this value will lower latency but may decrease the player's ability to build a stable buffer.
 * @property {number} [liveDelay=NaN]
 * Equivalent in seconds of setLiveDelayFragmentCount.
 *
 * Lowering this value will lower latency but may decrease the player's ability to build a stable buffer.
 *
 * This value should be less than the manifest duration by a couple of segment durations to avoid playback issues.
 *
 * If set, this parameter will take precedence over setLiveDelayFragmentCount and manifest info.
 * @property {boolean} [useSuggestedPresentationDelay=true]
 * Set to true if you would like to overwrite the default live delay and honor the SuggestedPresentationDelay attribute in by the manifest.
 */

/**
 * @typedef {Object} Buffer
 * @property {boolean} [enableSeekDecorrelationFix=false]
 * Enables a workaround for playback start on some devices, e.g. WebOS 4.9.
 * It is necessary because some browsers do not support setting currentTime on video element to a value that is outside of current buffer.
 *
 * If you experience unexpected seeking triggered by BufferController, you can try setting this value to false.

 * @property {boolean} [fastSwitchEnabled=true]
 * When enabled, after an ABR up-switch in quality, instead of requesting and appending the next fragment at the end of the current buffer range it is requested and appended closer to the current time.
 *
 * When enabled, The maximum time to render a higher quality is current time + (1.5 * fragment duration).
 *
 * Note, When ABR down-switch is detected, we appended the lower quality at the end of the buffer range to preserve the
 * higher quality media for as long as possible.
 *
 * If enabled, it should be noted there are a few cases when the client will not replace inside buffer range but rather just append at the end.
 * 1. When the buffer level is less than one fragment duration.
 * 2. The client is in an Abandonment State due to recent fragment abandonment event.
 *
 * Known issues:
 * 1. In IE11 with auto switching off, if a user switches to a quality they can not download in time the fragment may be appended in the same range as the playhead or even in the past, in IE11 it may cause a stutter or stall in playback.
 * @property {boolean} [flushBufferAtTrackSwitch=false]
 * When enabled, after a track switch and in case buffer is being replaced, the video element is flushed (seek at current playback time) once a segment of the new track is appended in buffer in order to force video decoder to play new track.
 *
 * This can be required on some devices like GoogleCast devices to make track switching functional.
 *
 * Otherwise, track switching will be effective only once after previous buffered track is fully consumed.
 * @property {boolean} [reuseExistingSourceBuffers=true]
 * Enable reuse of existing MediaSource Sourcebuffers during period transition.
 * @property {number} [bufferPruningInterval=10]
 * The interval of pruning buffer in seconds.
 * @property {number} [bufferToKeep=20]
 * This value influences the buffer pruning logic.
 *
 * Allows you to modify the buffer that is kept in source buffer in seconds.
 * 0|-----------bufferToPrune-----------|-----bufferToKeep-----|currentTime|
 * @property {number} [bufferTimeDefault=18]
 * The time that the internal buffer target will be set to when not playing at the top quality.
 * @property {number} [bufferTimeAtTopQuality=30]
 * The time that the internal buffer target will be set to once playing the top quality.
 *
 * If there are multiple bitrates in your adaptation, and the media is playing at the highest bitrate, then we try to build a larger buffer at the top quality to increase stability and to maintain media quality.
 * @property {number} [bufferTimeAtTopQualityLongForm=60]
 * The time that the internal buffer target will be set to once playing the top quality for long form content.
 * @property {number} [longFormContentDurationThreshold=600]
 * The threshold which defines if the media is considered long form content.
 *
 * This will directly affect the buffer targets when playing back at the top quality.
 * @property {number} [initialBufferLevel=NaN]
 * Initial buffer level before playback starts
 * @property {number} [stallThreshold=0.3]
 * Stall threshold used in BufferController.js to determine whether a track should still be changed and which buffer range to prune.
 * @property {number} [lowLatencyStallThreshold=0.3]
 * Low Latency stall threshold used in BufferController.js to determine whether a track should still be changed and which buffer range to prune.
 * @property {boolean} [useAppendWindow=true]
 * Specifies if the appendWindow attributes of the MSE SourceBuffers should be set according to content duration from manifest.
 * @property {boolean} [setStallState=true]
 * Specifies if we fire manual waiting events once the stall threshold is reached.
 * @property {module:Settings~SyntheticStallSettings} [syntheticStallEvents]
 * Specifies if manual stall events are to be fired once the stall threshold is reached.
 * @property {boolean} [avoidCurrentTimeRangePruning=false]
 * Avoids pruning of the buffered range that contains the current playback time.
 *
 * That buffered range is likely to have been enqueued for playback. Pruning it causes a flush and reenqueue in WPE and WebKitGTK based browsers. This stresses the video decoder and can cause stuttering on embedded platforms.
 * @property {boolean} [useChangeType=true]
 * If this flag is set to true then dash.js will use the MSE v.2 API call "changeType()" before switching to a different codec family.
 * Note that some platforms might not implement the changeType function. dash.js is checking for the availability before trying to call it.
 * @property {boolean} [mediaSourceDurationInfinity=true]
 * If this flag is set to true then dash.js will allow `Infinity` to be set as the MediaSource duration otherwise the duration will be set to `Math.pow(2,32)` instead of `Infinity` to allow appending segments indefinitely.
 * Some platforms such as WebOS 4.x have issues with seeking when duration is set to `Infinity`, setting this flag to false resolve this.
 * @property {boolean} [resetSourceBuffersForTrackSwitch=false]
 * When switching to a track that is not compatible with the currently active MSE SourceBuffers, MSE will be reset. This happens when we switch codecs on a system
 * that does not properly implement "changeType()", such as webOS 4.0 and before.
 */

/**
 * @typedef {Object} module:Settings~AudioVideoSettings
 * @property {number|boolean|string} [audio]
 * Configuration for audio media type of tracks.
 * @property {number|boolean|string} [video]
 * Configuration for video media type of tracks.
 */

/**
 * @typedef {Object} module:Settings~SyntheticStallSettings
 * @property {boolean} [enabled]
 * Enables manual stall events and sets the playback rate to 0 once the stall threshold is reached.
 * @property {boolean} [ignoreReadyState]
 * Ignore the media element's ready state when entering or exiting a stall.
 * Enable this when either of these scenarios still occur with synthetic stalls enabled:
 * - If the buffer is empty, but playback is not stalled.
 * - If playback resumes, but a playing event isn't reported.
 */

/**
 * @typedef {Object} DebugSettings
 * @property {number} [logLevel=dashjs.Debug.LOG_LEVEL_WARNING]
 * Sets up the log level. The levels are cumulative.
 *
 * For example, if you set the log level to dashjs.Debug.LOG_LEVEL_WARNING all warnings, errors and fatals will be logged.
 *
 * Possible values.
 *
 * - dashjs.Debug.LOG_LEVEL_NONE
 * No message is written in the browser console.
 *
 * - dashjs.Debug.LOG_LEVEL_FATAL
 * Log fatal errors.
 * An error is considered fatal when it causes playback to fail completely.
 *
 * - dashjs.Debug.LOG_LEVEL_ERROR
 * Log error messages.
 *
 * - dashjs.Debug.LOG_LEVEL_WARNING
 * Log warning messages.
 *
 * - dashjs.Debug.LOG_LEVEL_INFO
 * Log info messages.
 *
 * - dashjs.Debug.LOG_LEVEL_DEBUG
 * Log debug messages.
 * @property {boolean} [dispatchEvent=false]
 * Enable to trigger a Events.LOG event whenever log output is generated.
 *
 * Note this will be dispatched regardless of log level.
 */

/**
 * @typedef {Object} module:Settings~ErrorSettings
 * @property {object} [recoverAttempts={mediaErrorDecode: 5}]
 * Defines the maximum number of recover attempts for specific media errors.
 *
 * For mediaErrorDecode the player will reset the MSE and skip the blacklisted segment that caused the decode error. The resulting gap will be handled by the GapController.
 */

/**
 * @typedef {Object} CachingInfoSettings
 * @property {boolean} [enable]
 * Enable or disable the caching feature.
 * @property {number} [ttl]
 * Time to live.
 *
 * A value defined in milliseconds representing how log to cache the settings for.
 */

/**
 * @typedef {Object} Gaps
 * @property {boolean} [jumpGaps=true]
 * Sets whether player should jump small gaps (discontinuities) in the buffer.
 * @property {boolean} [jumpLargeGaps=true]
 * Sets whether player should jump large gaps (discontinuities) in the buffer.
 * @property {number} [smallGapLimit=1.5]
 * Time in seconds for a gap to be considered small.
 * @property {number} [threshold=0.3]
 * Threshold at which the gap handling is executed. If currentRangeEnd - currentTime < threshold the gap jump will be triggered.
 * For live stream the jump might be delayed to keep a consistent live edge.
 * Note that the amount of buffer at which platforms automatically stall might differ.
 * @property {boolean} [enableSeekFix=true]
 * Enables the adjustment of the seek target once no valid segment request could be generated for a specific seek time. This can happen if the user seeks to a position for which there is a gap in the timeline.
 * @property {boolean} [enableStallFix=false]
 * If playback stalled in a buffered range this fix will perform a seek by the value defined in stallSeek to trigger playback again.
 * @property {number} [stallSeek=0.1]
 * Value to be used in case enableStallFix is set to true
 */

/**
 * @typedef {Object} UtcSynchronizationSettings
 * @property {boolean} [enabled=true]
 * Enables or disables the UTC clock synchronization
 * @property {boolean} [useManifestDateHeaderTimeSource=true]
 * Allows you to enable the use of the Date Header, if exposed with CORS, as a timing source for live edge detection.
 *
 * The use of the date header will happen only after the other timing source that take precedence fail or are omitted as described.
 * @property {number} [backgroundAttempts=2]
 * Number of synchronization attempts to perform in the background after an initial synchronization request has been done. This is used to verify that the derived client-server offset is correct.
 *
 * The background requests are async and done in parallel to the start of the playback.
 *
 * This value is also used to perform a resync after 404 errors on segments.
 * @property {number} [timeBetweenSyncAttempts=30]
 * The time in seconds between two consecutive sync attempts.
 *
 * Note: This value is used as an initial starting value. The internal value of the TimeSyncController is adjusted during playback based on the drift between two consecutive synchronization attempts.
 *
 * Note: A sync is only performed after an MPD update. In case the @minimumUpdatePeriod is larger than this value the sync will be delayed until the next MPD update.
 * @property {number} [maximumTimeBetweenSyncAttempts=600]
 * The maximum time in seconds between two consecutive sync attempts.
 *
 * @property {number} [minimumTimeBetweenSyncAttempts=2]
 * The minimum time in seconds between two consecutive sync attempts.
 *
 * @property {number} [timeBetweenSyncAttemptsAdjustmentFactor=2]
 * The factor used to multiply or divide the timeBetweenSyncAttempts parameter after a sync. The maximumAllowedDrift defines whether this value is used as a factor or a dividend.
 *
 * @property {number} [maximumAllowedDrift=100]
 * The maximum allowed drift specified in milliseconds between two consecutive synchronization attempts.
 *
 * @property {boolean} [enableBackgroundSyncAfterSegmentDownloadError=true]
 * Enables or disables the background sync after the player ran into a segment download error.
 *
 * @property {object} [defaultTimingSource={scheme:'urn:mpeg:dash:utc:http-xsdate:2014',value: 'http://time.akamai.com/?iso&ms'}]
 * The default timing source to be used. The timing sources in the MPD take precedence over this one.
 */

/**
 * @typedef {Object} Scheduling
 * @property {number} [defaultTimeout=500]
 * Default timeout between two consecutive segment scheduling attempts
 * @property {number} [lowLatencyTimeout=0]
 * Default timeout between two consecutive low-latency segment scheduling attempts
 * @property {boolean} [scheduleWhilePaused=true]
 * Set to true if you would like dash.js to keep downloading fragments in the background when the video element is paused.
 */

/**
 * @typedef {Object} Text
 * @property {boolean} [defaultEnabled=true]
 * Enable/disable subtitle rendering by default.
 * @property {boolean} [dispatchForManualRendering=false]
 * Enable/disable firing of CueEnter/CueExt events. This will disable the display of subtitles and should be used when you want to have full control about rendering them.
 * @property {boolean} [extendSegmentedCues=true]
 * Enable/disable patching of segmented cues in order to merge as a single cue by extending cue end time.
 * @property {boolean} [imsc.displayForcedOnlyMode=false]
 * Enable/disable forced only mode in IMSC captions.
 * When true, only those captions where itts:forcedDisplay="true" will be displayed.
 * @property {boolean} [imsc.enableRollUp=true]
 * Enable/disable rollUp style display of IMSC captions.
 * @property {object} [webvtt.customRenderingEnabled=false]
 * Enables the custom rendering for WebVTT captions. For details refer to the "Subtitles and Captions" sample section of dash.js.
 * Custom WebVTT rendering requires the external library vtt.js that can be found in the contrib folder.
 */

/**
 * @typedef {Object} LiveCatchupSettings
 * @property {number} [maxDrift=NaN]
 * Use this method to set the maximum latency deviation allowed before dash.js to do a seeking to live position.
 *
 * In low latency mode, when the difference between the measured latency and the target one, as an absolute number, is higher than the one sets with this method, then dash.js does a seek to live edge position minus the target live delay.
 *
 * LowLatencyMaxDriftBeforeSeeking should be provided in seconds.
 *
 * If 0, then seeking operations won't be used for fixing latency deviations.
 *
 * Note: Catch-up mechanism is only applied when playing low latency live streams.
 * @property {number} [playbackRate={min: NaN, max: NaN}]
 * Use this parameter to set the minimum and maximum catch up rates, as percentages, for low latency live streams.
 *
 * In low latency mode, when measured latency is higher/lower than the target one, dash.js increases/decreases playback rate respectively up to (+/-) the percentage defined with this method until target is reached.
 *
 * Valid values for min catch up rate are in the range -0.5 to 0 (-50% to 0% playback rate decrease)
 *
 * Valid values for max catch up rate are in the range 0 to 1 (0% to 100% playback rate increase).
 *
 * Set min and max to NaN to turn off live catch up feature.
 *
 * These playback rate limits take precedence over any PlaybackRate values in ServiceDescription elements in an MPD. If only one of the min/max properties is given a value, the property without a value will not fall back to a ServiceDescription value. Its default value of NaN will be used.
 *
 * Note: Catch-up mechanism is only applied when playing low latency live streams.
 * @property {number} [playbackBufferMin=0.5]
 * Use this parameter to specify the minimum buffer which is used for LoL+ based playback rate reduction.
 *
 *
 * @property {boolean} [enabled=null]
 * Use this parameter to enable the catchup mode for non low-latency streams.
 *
 * @property {string} [mode="liveCatchupModeDefault"]
 * Use this parameter to switch between different catchup modes.
 *
 * Options: "liveCatchupModeDefault" or "liveCatchupModeLOLP".
 *
 * Note: Catch-up mechanism is automatically applied when playing low latency live streams.
 */

/**
 * @typedef {Object} RequestTypeSettings
 * @property {number} [MPD]
 * Manifest type of requests.
 * @property {number} [XLinkExpansion]
 * XLink expansion type of requests.
 * @property {number} [InitializationSegment]
 * Request to retrieve an initialization segment.
 * @property {number} [IndexSegment]
 * Request to retrieve an index segment (SegmentBase).
 * @property {number} [MediaSegment]
 * Request to retrieve a media segment (video/audio/image/text chunk).
 * @property {number} [BitstreamSwitchingSegment]
 * Bitrate stream switching type of request.
 * @property {number} [FragmentInfoSegment]
 * Request to retrieve a FragmentInfo segment (specific to Smooth Streaming live streams).
 * @property {number} [other]
 * Other type of request.
 * @property {number} [lowLatencyReductionFactor]
 * For low latency mode, values of type of request are divided by lowLatencyReductionFactor.
 *
 * Note: It's not type of request.
 * @property {number} [lowLatencyMultiplyFactor]
 * For low latency mode, values of type of request are multiplied by lowLatencyMultiplyFactor.
 *
 * Note: It's not type of request.
 */

/**
 * @typedef {Object} Protection
 * @property {boolean} [keepProtectionMediaKeys=false]
 * Set the value for the ProtectionController and MediaKeys life cycle.
 *
 * If true, the ProtectionController and then created MediaKeys and MediaKeySessions will be preserved during the MediaPlayer lifetime.
 * @property {boolean} [ignoreEmeEncryptedEvent=false]
 * If set to true the player will ignore "encrypted" and "needkey" events thrown by the EME.
 *
 * @property {boolean} [detectPlayreadyMessageFormat=true]
 * If set to true the player will use the raw unwrapped message from the Playready CDM
 *
 * @property {boolean} [ignoreKeyStatuses=false]
 * If set to true the player will ignore the status of a key and try to play the corresponding track regardless whether the key is usable or not.
 */

/**
 * @typedef {Object} Capabilities
 * @property {boolean} [filterUnsupportedEssentialProperties=true]
 * Enable to filter all the AdaptationSets and Representations which contain an unsupported \<EssentialProperty\> element.
 * @property {Array.<string>} [supportedEssentialProperties]
 * List of supported \<EssentialProperty\> elements
 * @property {boolean} [useMediaCapabilitiesApi=true]
 * Enable to use the MediaCapabilities API to check whether codecs are supported. If disabled MSE.isTypeSupported will be used instead.
 * @property {boolean} [filterVideoColorimetryEssentialProperties=false]
 * Enable dash.js to query MediaCapabilities API for signalled Colorimetry EssentialProperties (per schemeIdUris: 'urn:mpeg:mpegB:cicp:ColourPrimaries', 'urn:mpeg:mpegB:cicp:TransferCharacteristics').
 * If disabled, registered properties per supportedEssentialProperties will be allowed without any further checking (including 'urn:mpeg:mpegB:cicp:MatrixCoefficients').
 * @property {boolean} [filterHDRMetadataFormatEssentialProperties=false]
 * Enable dash.js to query MediaCapabilities API for signalled HDR-MetadataFormat EssentialProperty (per schemeIdUri:'urn:dvb:dash:hdr-dmi').
 */

/**
 * @typedef {Object} AbrSettings
 * @property {boolean} [limitBitrateByPortal=false]
 * If true, the size of the video portal will limit the max chosen video resolution.
 * @property {boolean} [usePixelRatioInLimitBitrateByPortal=false]
 * Sets whether to take into account the device's pixel ratio when defining the portal dimensions.
 *
 * Useful on, for example, retina displays.
 * @property {module:Settings~AbrRules} [rules]
 * Enable/Disable individual ABR rules. Note that if the throughputRule and the bolaRule are activated at the same time we switch to a dynamic mode.
 * In the dynamic mode either ThroughputRule or BolaRule are active but not both at the same time.
 *
 * l2ARule and loLPRule are ABR rules that are designed for low latency streams. They are tested as standalone rules meaning the other rules should be deactivated when choosing these rules.
 * @property {module:Settings~ThroughputSettings} [throughput]
 * Settings related to throughput calculation
 * @property {module:Settings~AudioVideoSettings} [maxBitrate={audio: -1, video: -1}]
 * The maximum bitrate that the ABR algorithms will choose. This value is specified in kbps.
 *
 * Use -1 for no limit.
 * @property {module:Settings~AudioVideoSettings} [minBitrate={audio: -1, video: -1}]
 * The minimum bitrate that the ABR algorithms will choose. This value is specified in kbps.
 *
 * Use -1 for no limit.
 * @property {module:Settings~AudioVideoSettings} [initialBitrate={audio: -1, video: -1}]
 * Explicitly set the starting bitrate for audio or video. This value is specified in kbps.
 *
 * Use -1 to let the player decide.
 * @property {module:Settings~AudioVideoSettings} [autoSwitchBitrate={audio: true, video: true}]
 * Indicates whether the player should enable ABR algorithms to switch the bitrate.
 */

/**
 * @typedef {Object} AbrRules
 * @property {module:Settings~ThroughputRule} [throughputRule]
 * Configuration of the Throughput rule
 * @property {module:Settings~BolaRule} [bolaRule]
 * Configuration of the BOLA rule
 * @property {module:Settings~InsufficientBufferRule} [insufficientBufferRule]
 * Configuration of the Insufficient Buffer rule
 * @property {module:Settings~SwitchHistoryRule} [switchHistoryRule]
 * Configuration of the Switch History rule
 * @property {module:Settings~DroppedFramesRule} [droppedFramesRule]
 * Configuration of the Dropped Frames rule
 * @property {module:Settings~AbandonRequestsRule} [abandonRequestsRule]
 * Configuration of the Abandon Requests rule
 * @property {module:Settings~L2ARule} [l2ARule]
 * Configuration of the L2A rule
 * @property {module:Settings~LoLPRule} [loLPRule]
 * Configuration of the LoLP rule
 */

/**
 * @typedef {Object} ThroughputRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 */

/**
 * @typedef {Object} BolaRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 */

/**
 * @typedef {Object} InsufficientBufferRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 * @property {object} [parameters={throughputSafetyFactor=0.7, segmentIgnoreCount=2}]
 * Configures the rule specific parameters.
 *
 * - `throughputSafetyFactor`: The safety factor that is applied to the derived throughput, see example in the Description.
 * - `segmentIgnoreCount`: This rule is not taken into account until the first segmentIgnoreCount media segments have been appended to the buffer.
 */

/**
 * @typedef {Object} SwitchHistoryRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 * @property {object} [parameters={sampleSize=8, switchPercentageThreshold=0.075}]
 * Configures the rule specific parameters.
 *
 * - `sampleSize`: Number of switch requests ("no switch", because of the selected Representation is already playing or "actual switches") required before the rule is applied
 * - `switchPercentageThreshold`: Ratio of actual quality drops compared to no drops before a quality down-switch is triggered
 */

/**
 * @typedef {Object} DroppedFramesRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 * @property {object} [parameters={minimumSampleSize=375, droppedFramesPercentageThreshold=0.15}]
 * Configures the rule specific parameters.
 *
 * - `minimumSampleSize`: Sum of rendered and dropped frames required for each Representation before the rule kicks in.
 * - `droppedFramesPercentageThreshold`: Minimum percentage of dropped frames to trigger a quality down switch. Values are defined in the range of 0 - 1.
 */

/**
 * @typedef {Object} AbandonRequestsRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 * @property {object} [parameters={abandonDurationMultiplier=1.8, minSegmentDownloadTimeThresholdInMs=500, minThroughputSamplesThreshold=6}]
 * Configures the rule specific parameters.
 *
 * - `abandonDurationMultiplier`: Factor to multiply with the segment duration to compare against the estimated remaining download time of the current segment. See code example above.
 * - `minSegmentDownloadTimeThresholdInMs`: The AbandonRequestRule only kicks if the download time of the current segment exceeds this value.
 * - `minThroughputSamplesThreshold`: Minimum throughput samples (equivalent to number of progress events) required before the AbandonRequestRule kicks in.
 */

/**
 * @typedef {Object} L2ARule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 */

/**
 * @typedef {Object} LoLPRule
 * @property {boolean} [active=true]
 * Enable or disable the rule
 */

/**
 * @typedef {Object} ThroughputSettings
 * @property {string} [averageCalculationMode=Constants.THROUGHPUT_CALCULATION_MODES.EWMA]
 * Defines the default mode for calculating the throughput based on the samples collected during playback.
 *
 * For arithmetic and harmonic mean calculations we use a sliding window with the values defined in "sampleSettings"
 *
 * For exponential weighted moving average calculation the default values can be changed in "ewma"
 * @property {string} [lowLatencyDownloadTimeCalculationMode=Constants.LOW_LATENCY_DOWNLOAD_TIME_CALCULATION_MODE.MOOF_PARSING]
 * Defines the effective download time estimation method we use for low latency streams that utilize the Fetch API and chunked transfer coding
 * @property {boolean} [useResourceTimingApi=true]
 * If set to true the ResourceTimingApi is used to derive the download time and the number of downloaded bytes.
 * This option has no effect for low latency streaming as the download time equals the segment duration in most of the cases and therefor does not provide reliable values
 * @property {object} [useNetworkInformationApi = { xhr=false, fetch=false}]
 * If set to true the NetworkInformationApi is used to derive the current throughput. Browser support is limited, only available in Chrome and Edge.
 * Applies to standard (XHR requests) and/or low latency streaming (Fetch API requests).
 * @property {boolean} [useDeadTimeLatency=true]
 * If true, only the download portion will be considered part of the download bitrate and latency will be regarded as static.
 *
 * If false, the reciprocal of the whole transfer time will be used.
 * @property {number} [bandwidthSafetyFactor=0.9]
 * Standard ABR throughput rules multiply the throughput by this value.
 *
 * It should be between 0 and 1, with lower values giving less rebuffering (but also lower quality)
 * @property {object} [sampleSettings = {live=3,vod=4,enableSampleSizeAdjustment=true,decreaseScale=0.7,increaseScale=1.3,maxMeasurementsToKeep=20,averageLatencySampleAmount=4}]
 * When deriving the throughput based on the arithmetic or harmonic mean these settings define:
 * - `live`: Number of throughput samples to use (sample size) for live streams
 * - `vod`: Number of throughput samples to use (sample size) for VoD streams
 * - `enableSampleSizeAdjustment`: Adjust the sample sizes if throughput samples vary a lot
 * - `decreaseScale`: Increase sample size by one if the ratio of current and previous sample is below or equal this value
 * - `increaseScale`: Increase sample size by one if the ratio of current and previous sample is higher or equal this value
 * - `maxMeasurementsToKeep`: Number of samples to keep before sliding samples out of the window
 * - `averageLatencySampleAmount`: Number of latency samples to use (sample size)
 * @property {object} [ewma={throughputSlowHalfLifeSeconds=8,throughputFastHalfLifeSeconds=3,latencySlowHalfLifeCount=2,latencyFastHalfLifeCount=1, weightDownloadTimeMultiplicationFactor=0.0015}]
 * When deriving the throughput based on the exponential weighted moving average these settings define:
 * - `throughputSlowHalfLifeSeconds`: Number by which the weight of the current throughput measurement is divided, see ThroughputModel._updateEwmaValues
 * - `throughputFastHalfLifeSeconds`: Number by which the weight of the current throughput measurement is divided, see ThroughputModel._updateEwmaValues
 * - `latencySlowHalfLifeCount`: Number by which the weight of the current latency is divided, see ThroughputModel._updateEwmaValues
 * - `latencyFastHalfLifeCount`: Number by which the weight of the current latency is divided, see ThroughputModel._updateEwmaValues
 * - `weightDownloadTimeMultiplicationFactor`: This value is multiplied with the download time in milliseconds to derive the weight for the EWMA calculation.
 */

/**
 * @typedef {Object} CmcdSettings
 * @property {boolean} [applyParametersFromMpd=true]
 * Set to true if dash.js should use the CMCD parameters defined in the MPD.
 * @property {boolean} [enable=false]
 * Enable or disable the CMCD reporting.
 * @property {string} [sid]
 * GUID identifying the current playback session.
 *
 * Should be in UUID format.
 *
 * If not specified a UUID will be automatically generated.
 * @property {string} [cid]
 * A unique string to identify the current content.
 *
 * If not specified it will be a hash of the MPD url.
 * @property {number} [rtp]
 * The requested maximum throughput that the client considers sufficient for delivery of the asset.
 *
 * If not specified this value will be dynamically calculated in the CMCDModel based on the current buffer level.
 * @property {number} [rtpSafetyFactor=5]
 * This value is used as a factor for the rtp value calculation: rtp = minBandwidth * rtpSafetyFactor
 *
 * If not specified this value defaults to 5. Note that this value is only used when no static rtp value is defined.
 * @property {number} [mode="query"]
 * The method to use to attach cmcd metrics to the requests. 'query' to use query parameters, 'header' to use http headers.
 *
 * If not specified this value defaults to 'query'.
 * @property {Array.<string>} [enabledKeys]
 * This value is used to specify the desired CMCD parameters. Parameters not included in this list are not reported.
 * @property {Array.<string>} [includeInRequests]
 * Specifies which HTTP GET requests shall carry parameters.
 *
 * If not specified this value defaults to ['segment', 'mpd].
 * @property {number} [version=1]
 * The version of the CMCD to use.
 *
 * If not specified this value defaults to 1.
 */

/**
 * @typedef {Object} module:Settings~CmsdSettings
 * @property {boolean} [enabled=false]
 * Enable or disable the CMSD response headers parsing.
 * @property {module:Settings~CmsdAbrSettings} [abr]
 * Sets additional ABR rules based on CMSD response headers.
 */

/**
 * @typedef {Object} CmsdAbrSettings
 * @property {boolean} [applyMb=false]
 * Set to true if dash.js should apply CMSD maximum suggested bitrate in ABR logic.
 * @property {number} [etpWeightRatio=0]
 * Sets the weight ratio (between 0 and 1) that shall be applied on CMSD estimated throuhgput compared to measured throughput when calculating throughput.
 */

/**
 * @typedef {Object} Metrics
 * @property {number} [metricsMaxListDepth=100]
 * Maximum number of metrics that are persisted per type.
 */

/**
 * @typedef {Object} StreamingSettings
 * @property {number} [abandonLoadTimeout=10000]
 * A timeout value in seconds, which during the ABRController will block switch-up events.
 *
 * This will only take effect after an abandoned fragment event occurs.
 * @property {number} [wallclockTimeUpdateInterval=100]
 * How frequently the wallclockTimeUpdated internal event is triggered (in milliseconds).
 * @property {number} [manifestUpdateRetryInterval=100]
 * For live streams, set the interval-frequency in milliseconds at which dash.js will check if the current manifest is still processed before downloading the next manifest once the minimumUpdatePeriod time has.
 * @property {number} [liveUpdateTimeThresholdInMilliseconds=0]
 * For live streams, postpone syncing time updates until the threshold is passed. Increase if problems occurs during live streams on low end devices.
 * @property {boolean} [cacheInitSegments=false]
 * Enables the caching of init segments to avoid requesting the init segments before each representation switch.
 * @property {boolean} [applyServiceDescription=true]
 * Set to true if dash.js should use the parameters defined in ServiceDescription elements
 * @property {boolean} [applyProducerReferenceTime=true]
 * Set to true if dash.js should use the parameters defined in ProducerReferenceTime elements in combination with ServiceDescription elements.
 * @property {boolean} [applyContentSteering=true]
 * Set to true if dash.js should apply content steering during playback.
 * @property {boolean} [enableManifestDurationMismatchFix=true]
 * For multi-period streams, overwrite the manifest mediaPresentationDuration attribute with the sum of period durations if the manifest mediaPresentationDuration is greater than the sum of period durations
 * @property {boolean} [enableManifestTimescaleMismatchFix=false]
 * Overwrite the manifest segments base information timescale attributes with the timescale set in initialization segments
 * @property {boolean} [parseInbandPrft=false]
 * Set to true if dash.js should parse inband prft boxes (ProducerReferenceTime) and trigger events.
 * @property {module:Settings~Metrics} metrics Metric settings
 * @property {module:Settings~LiveDelay} delay Live Delay settings
 * @property {module:Settings~EventSettings} events Event settings
 * @property {module:Settings~TimeShiftBuffer} timeShiftBuffer TimeShiftBuffer settings
 * @property {module:Settings~Protection} protection DRM related settings
 * @property {module:Settings~Capabilities} capabilities Capability related settings
 * @property {module:Settings~Buffer}  buffer Buffer related settings
 * @property {module:Settings~Gaps}  gaps Gap related settings
 * @property {module:Settings~UtcSynchronizationSettings} utcSynchronization Settings related to UTC clock synchronization
 * @property {module:Settings~Scheduling} scheduling Settings related to segment scheduling
 * @property {module:Settings~Text} text Settings related to Subtitles and captions
 * @property {module:Settings~LiveCatchupSettings} liveCatchup  Settings related to live catchup.
 * @property {module:Settings~CachingInfoSettings} [lastBitrateCachingInfo={enabled: true, ttl: 360000}]
 * Set to false if you would like to disable the last known bit rate from being stored during playback and used to set the initial bit rate for subsequent playback within the expiration window.
 *
 * The default expiration is one hour, defined in milliseconds.
 *
 * If expired, the default initial bit rate (closest to 1000 kbps) will be used for that session and a new bit rate will be stored during that session.
 * @property {module:Settings~CachingInfoSettings} [lastMediaSettingsCachingInfo={enabled: true, ttl: 360000}]
 * Set to false if you would like to disable the last media settings from being stored to localStorage during playback and used to set the initial track for subsequent playback within the expiration window.
 *
 * The default expiration is one hour, defined in milliseconds.
 * @property {boolean} [saveLastMediaSettingsForCurrentStreamingSession=true]
 * Set to true if dash.js should save media settings from last selected track for incoming track selection during current streaming session.
 * @property {module:Settings~AudioVideoSettings} [cacheLoadThresholds={video: 10, audio: 5}]
 * For a given media type, the threshold which defines if the response to a fragment request is coming from browser cache or not.
 * @property {module:Settings~AudioVideoSettings} [trackSwitchMode={video: "neverReplace", audio: "alwaysReplace"}]
 * For a given media type defines if existing segments in the buffer should be overwritten once the track is switched. For instance if the user switches the audio language the existing segments in the audio buffer will be replaced when setting this value to "alwaysReplace".
 *
 * Possible values
 *
 * - Constants.TRACK_SWITCH_MODE_ALWAYS_REPLACE
 * Replace existing segments in the buffer
 *
 * - Constants.TRACK_SWITCH_MODE_NEVER_REPLACE
 * Do not replace existing segments in the buffer
 *
 * @property {} [ignoreSelectionPriority: false]
 * provides the option to disregard any signalled selectionPriority attribute. If disabled and if no initial media settings are set, track selection is accomplished as defined by selectionModeForInitialTrack.
 *
 * @property {} [prioritizeRoleMain: true]
 * provides the option to disable prioritization of AdaptationSets with their Role set to Main
 *
 * @property {} [assumeDefaultRoleAsMain: true]
 * when no Role descriptor is present, assume main per default
 * 
 * @property {string} [selectionModeForInitialTrack="highestEfficiency"]
 * Sets the selection mode for the initial track. This mode defines how the initial track will be selected if no initial media settings are set. If initial media settings are set this parameter will be ignored. Available options are:
 *
 * Possible values
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_BITRATE
 * This mode makes the player select the track with a highest bitrate.
 *
 * - Constants.TRACK_SELECTION_MODE_FIRST_TRACK
 * This mode makes the player select the first track found in the manifest.
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY
 * This mode makes the player select the track with the lowest bitrate per pixel average.
 *
 * - Constants.TRACK_SELECTION_MODE_WIDEST_RANGE
 * This mode makes the player select the track with a widest range of bitrates.
 *
 *
 * @property {number} [fragmentRequestTimeout=20000]
 * Time in milliseconds before timing out on loading a media fragment.
 *
 * @property {number} [fragmentRequestProgressTimeout=-1]
 * Time in milliseconds before timing out on loading progress of a media fragment.
 *
 * @property {number} [manifestRequestTimeout=10000]
 * Time in milliseconds before timing out on loading a manifest.
 *
 * Fragments that timeout are retried as if they failed.
 * @property {module:Settings~RequestTypeSettings} [retryIntervals]
 * Time in milliseconds of which to reload a failed file load attempt.
 *
 * For low latency mode these values are divided by lowLatencyReductionFactor.
 * @property {module:Settings~RequestTypeSettings} [retryAttempts]
 * Total number of retry attempts that will occur on a file load before it fails.
 *
 * For low latency mode these values are multiplied by lowLatencyMultiplyFactor.
 * @property {module:Settings~AbrSettings} abr
 * Adaptive Bitrate algorithm related settings.
 * @property {module:Settings~CmcdSettings} cmcd
 * Settings related to Common Media Client Data reporting.
 * @property {module:Settings~CmsdSettings} cmsd
 * Settings related to Common Media Server Data parsing.
 * @property {module:Settings~defaultSchemeIdUri} defaultSchemeIdUri
 * Default schemeIdUri for descriptor type elements
 * These strings are used when not provided with setInitialMediaSettingsFor()
 */

/**
 * @class
 * @ignore
 */
function Settings() {
  let instance;
  const context = this.context;
  const eventBus = (0,_EventBus_js__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
  const DISPATCH_KEY_MAP = {
    'streaming.delay.liveDelay': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_LIVE_DELAY,
    'streaming.delay.liveDelayFragmentCount': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT,
    'streaming.liveCatchup.enabled': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_CATCHUP_ENABLED,
    'streaming.liveCatchup.playbackRate.min': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_PLAYBACK_RATE_MIN,
    'streaming.liveCatchup.playbackRate.max': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_PLAYBACK_RATE_MAX,
    'streaming.abr.rules.throughputRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.bolaRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.insufficientBufferRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.switchHistoryRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.droppedFramesRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.abandonRequestsRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.l2ARule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.rules.loLPRule.active': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_ABR_ACTIVE_RULES,
    'streaming.abr.maxBitrate.video': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_MAX_BITRATE,
    'streaming.abr.maxBitrate.audio': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_MAX_BITRATE,
    'streaming.abr.minBitrate.video': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_MIN_BITRATE,
    'streaming.abr.minBitrate.audio': _events_Events_js__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_MIN_BITRATE
  };

  /**
   * @const {PlayerSettings} defaultSettings
   * @ignore
   */
  const defaultSettings = {
    debug: {
      logLevel: _core_Debug_js__WEBPACK_IMPORTED_MODULE_2__["default"].LOG_LEVEL_WARNING,
      dispatchEvent: false
    },
    streaming: {
      abandonLoadTimeout: 10000,
      wallclockTimeUpdateInterval: 100,
      manifestUpdateRetryInterval: 100,
      liveUpdateTimeThresholdInMilliseconds: 0,
      cacheInitSegments: false,
      applyServiceDescription: true,
      applyProducerReferenceTime: true,
      applyContentSteering: true,
      enableManifestDurationMismatchFix: true,
      parseInbandPrft: false,
      enableManifestTimescaleMismatchFix: false,
      capabilities: {
        filterUnsupportedEssentialProperties: true,
        supportedEssentialProperties: [{
          schemeIdUri: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].FONT_DOWNLOAD_DVB_SCHEME
        }, {
          schemeIdUri: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].COLOUR_PRIMARIES_SCHEME_ID_URI,
          value: /1|5|6|7/
        }, {
          schemeIdUri: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].URL_QUERY_INFO_SCHEME
        }, {
          schemeIdUri: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].EXT_URL_QUERY_INFO_SCHEME
        }, {
          schemeIdUri: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].MATRIX_COEFFICIENTS_SCHEME_ID_URI,
          value: /0|1|5|6/
        }, {
          schemeIdUri: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].TRANSFER_CHARACTERISTICS_SCHEME_ID_URI,
          value: /1|6|13|14|15/
        }, ..._streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].THUMBNAILS_SCHEME_ID_URIS.map(ep => {
          return {
            'schemeIdUri': ep
          };
        })],
        useMediaCapabilitiesApi: true,
        filterVideoColorimetryEssentialProperties: false,
        filterHDRMetadataFormatEssentialProperties: false
      },
      events: {
        eventControllerRefreshDelay: 100,
        deleteEventMessageDataTimeout: 10000
      },
      timeShiftBuffer: {
        calcFromSegmentTimeline: false,
        fallbackToSegmentTimeline: true
      },
      metrics: {
        maxListDepth: 100
      },
      delay: {
        liveDelayFragmentCount: NaN,
        liveDelay: NaN,
        useSuggestedPresentationDelay: true
      },
      protection: {
        keepProtectionMediaKeys: false,
        ignoreEmeEncryptedEvent: false,
        detectPlayreadyMessageFormat: true,
        ignoreKeyStatuses: false
      },
      buffer: {
        enableSeekDecorrelationFix: false,
        fastSwitchEnabled: null,
        flushBufferAtTrackSwitch: false,
        reuseExistingSourceBuffers: true,
        bufferPruningInterval: 10,
        bufferToKeep: 20,
        bufferTimeAtTopQuality: 30,
        bufferTimeAtTopQualityLongForm: 60,
        initialBufferLevel: NaN,
        bufferTimeDefault: 18,
        longFormContentDurationThreshold: 600,
        stallThreshold: 0.3,
        lowLatencyStallThreshold: 0.3,
        useAppendWindow: true,
        setStallState: true,
        avoidCurrentTimeRangePruning: false,
        useChangeType: true,
        mediaSourceDurationInfinity: true,
        resetSourceBuffersForTrackSwitch: false,
        syntheticStallEvents: {
          enabled: false,
          ignoreReadyState: false
        }
      },
      gaps: {
        jumpGaps: true,
        jumpLargeGaps: true,
        smallGapLimit: 1.5,
        threshold: 0.3,
        enableSeekFix: true,
        enableStallFix: false,
        stallSeek: 0.1
      },
      utcSynchronization: {
        enabled: true,
        useManifestDateHeaderTimeSource: true,
        backgroundAttempts: 2,
        timeBetweenSyncAttempts: 30,
        maximumTimeBetweenSyncAttempts: 600,
        minimumTimeBetweenSyncAttempts: 2,
        timeBetweenSyncAttemptsAdjustmentFactor: 2,
        maximumAllowedDrift: 100,
        enableBackgroundSyncAfterSegmentDownloadError: true,
        defaultTimingSource: {
          scheme: 'urn:mpeg:dash:utc:http-xsdate:2014',
          value: 'https://time.akamai.com/?iso&ms'
        }
      },
      scheduling: {
        defaultTimeout: 500,
        lowLatencyTimeout: 0,
        scheduleWhilePaused: true
      },
      text: {
        defaultEnabled: true,
        dispatchForManualRendering: false,
        extendSegmentedCues: true,
        imsc: {
          displayForcedOnlyMode: false,
          enableRollUp: true
        },
        webvtt: {
          customRenderingEnabled: false
        }
      },
      liveCatchup: {
        maxDrift: NaN,
        playbackRate: {
          min: NaN,
          max: NaN
        },
        playbackBufferMin: 0.5,
        enabled: null,
        mode: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].LIVE_CATCHUP_MODE_DEFAULT
      },
      lastBitrateCachingInfo: {
        enabled: true,
        ttl: 360000
      },
      lastMediaSettingsCachingInfo: {
        enabled: true,
        ttl: 360000
      },
      saveLastMediaSettingsForCurrentStreamingSession: true,
      cacheLoadThresholds: {
        video: 10,
        audio: 5
      },
      trackSwitchMode: {
        audio: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH_MODE_ALWAYS_REPLACE,
        video: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH_MODE_NEVER_REPLACE
      },
      ignoreSelectionPriority: false,
      prioritizeRoleMain: true,
      assumeDefaultRoleAsMain: true,
      selectionModeForInitialTrack: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY,
      fragmentRequestTimeout: 20000,
      fragmentRequestProgressTimeout: -1,
      manifestRequestTimeout: 10000,
      retryIntervals: {
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MPD_TYPE]: 500,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.XLINK_EXPANSION_TYPE]: 500,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MEDIA_SEGMENT_TYPE]: 1000,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INIT_SEGMENT_TYPE]: 1000,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 1000,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INDEX_SEGMENT_TYPE]: 1000,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 1000,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.LICENSE]: 1000,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.OTHER_TYPE]: 1000,
        lowLatencyReductionFactor: 10
      },
      retryAttempts: {
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MPD_TYPE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.XLINK_EXPANSION_TYPE]: 1,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MEDIA_SEGMENT_TYPE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INIT_SEGMENT_TYPE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INDEX_SEGMENT_TYPE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.LICENSE]: 3,
        [_streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.OTHER_TYPE]: 3,
        lowLatencyMultiplyFactor: 5
      },
      abr: {
        limitBitrateByPortal: false,
        usePixelRatioInLimitBitrateByPortal: false,
        enableSupplementalPropertyAdaptationSetSwitching: true,
        rules: {
          throughputRule: {
            active: true
          },
          bolaRule: {
            active: true
          },
          insufficientBufferRule: {
            active: true,
            parameters: {
              throughputSafetyFactor: 0.7,
              segmentIgnoreCount: 2
            }
          },
          switchHistoryRule: {
            active: true,
            parameters: {
              sampleSize: 8,
              switchPercentageThreshold: 0.075
            }
          },
          droppedFramesRule: {
            active: false,
            parameters: {
              minimumSampleSize: 375,
              droppedFramesPercentageThreshold: 0.15
            }
          },
          abandonRequestsRule: {
            active: true,
            parameters: {
              abandonDurationMultiplier: 1.8,
              minSegmentDownloadTimeThresholdInMs: 500,
              minThroughputSamplesThreshold: 6
            }
          },
          l2ARule: {
            active: false
          },
          loLPRule: {
            active: false
          }
        },
        throughput: {
          averageCalculationMode: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].THROUGHPUT_CALCULATION_MODES.EWMA,
          lowLatencyDownloadTimeCalculationMode: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].LOW_LATENCY_DOWNLOAD_TIME_CALCULATION_MODE.MOOF_PARSING,
          useResourceTimingApi: true,
          useNetworkInformationApi: {
            xhr: false,
            fetch: false
          },
          useDeadTimeLatency: true,
          bandwidthSafetyFactor: 0.9,
          sampleSettings: {
            live: 3,
            vod: 4,
            enableSampleSizeAdjustment: true,
            decreaseScale: 0.7,
            increaseScale: 1.3,
            maxMeasurementsToKeep: 20,
            averageLatencySampleAmount: 4
          },
          ewma: {
            throughputSlowHalfLifeSeconds: 8,
            throughputFastHalfLifeSeconds: 3,
            latencySlowHalfLifeCount: 2,
            latencyFastHalfLifeCount: 1,
            weightDownloadTimeMultiplicationFactor: 0.0015
          }
        },
        maxBitrate: {
          audio: -1,
          video: -1
        },
        minBitrate: {
          audio: -1,
          video: -1
        },
        initialBitrate: {
          audio: -1,
          video: -1
        },
        autoSwitchBitrate: {
          audio: true,
          video: true
        }
      },
      cmcd: {
        applyParametersFromMpd: true,
        enabled: false,
        sid: null,
        cid: null,
        rtp: null,
        rtpSafetyFactor: 5,
        mode: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].CMCD_MODE_QUERY,
        enabledKeys: _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_3__["default"].CMCD_AVAILABLE_KEYS,
        includeInRequests: ['segment', 'mpd'],
        version: 1
      },
      cmsd: {
        enabled: false,
        abr: {
          applyMb: false,
          etpWeightRatio: 0
        }
      },
      defaultSchemeIdUri: {
        viewpoint: '',
        audioChannelConfiguration: 'urn:mpeg:mpegB:cicp:ChannelConfiguration',
        role: 'urn:mpeg:dash:role:2011',
        accessibility: 'urn:mpeg:dash:role:2011'
      }
    },
    errors: {
      recoverAttempts: {
        mediaErrorDecode: 5
      }
    }
  };
  let settings = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(defaultSettings);

  //Merge in the settings. If something exists in the new config that doesn't match the schema of the default config,
  //regard it as an error and log it.
  function mixinSettings(source, dest, path) {
    for (let n in source) {
      if (source.hasOwnProperty(n)) {
        if (dest.hasOwnProperty(n)) {
          if (typeof source[n] === 'object' && !(source[n] instanceof RegExp) && !(source[n] instanceof Array) && source[n] !== null) {
            mixinSettings(source[n], dest[n], path.slice() + n + '.');
          } else {
            dest[n] = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(source[n]);
            if (DISPATCH_KEY_MAP[path + n]) {
              eventBus.trigger(DISPATCH_KEY_MAP[path + n]);
            }
          }
        } else {
          console.error('Settings parameter ' + path + n + ' is not supported');
        }
      }
    }
  }

  /**
   * Return the settings object. Don't copy/store this object, you won't get updates.
   * @func
   * @instance
   */
  function get() {
    return settings;
  }

  /**
   * @func
   * @instance
   * @param {object} settingsObj - This should be a partial object of the Settings.Schema type. That is, fields defined should match the path (e.g.
   * settingsObj.streaming.abr.autoSwitchBitrate.audio -> defaultSettings.streaming.abr.autoSwitchBitrate.audio). Where an element's path does
   * not match it is ignored, and a warning is logged.
   *
   * Use to change the settings object. Any new values defined will overwrite the settings and anything undefined will not change.
   * Implementers of new settings should add it in an approriate namespace to the defaultSettings object and give it a default value (that is not undefined).
   *
   */
  function update(settingsObj) {
    if (typeof settingsObj === 'object') {
      mixinSettings(settingsObj, settings, '');
    }
  }

  /**
   * Resets the settings object. Everything is set to its default value.
   * @func
   * @instance
   *
   */
  function reset() {
    settings = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(defaultSettings);
  }
  instance = {
    get,
    update,
    reset
  };
  return instance;
}
Settings.__dashjs_factory_name = 'Settings';
let factory = _FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(Settings);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/core/Utils.js":
/*!***************************!*\
  !*** ./src/core/Utils.js ***!
  \***************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var path_browserify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! path-browserify */ "./node_modules/path-browserify/index.js");
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ua-parser-js */ "./node_modules/ua-parser-js/src/ua-parser.js");
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */




class Utils {
  static mixin(dest, source, copy) {
    let s;
    let empty = {};
    if (dest) {
      for (let name in source) {
        if (source.hasOwnProperty(name)) {
          s = source[name];
          if (!(name in dest) || dest[name] !== s && (!(name in empty) || empty[name] !== s)) {
            if (typeof dest[name] === 'object' && dest[name] !== null) {
              dest[name] = Utils.mixin(dest[name], s, copy);
            } else {
              dest[name] = copy(s);
            }
          }
        }
      }
    }
    return dest;
  }
  static clone(src) {
    if (!src || typeof src !== 'object') {
      return src; // anything
    }
    if (src instanceof RegExp) {
      return new RegExp(src);
    }
    let r;
    if (src instanceof Array) {
      // array
      r = [];
      for (let i = 0, l = src.length; i < l; ++i) {
        if (i in src) {
          r.push(Utils.clone(src[i]));
        }
      }
    } else {
      r = {};
    }
    return Utils.mixin(r, src, Utils.clone);
  }
  static addAdditionalQueryParameterToUrl(url, params) {
    try {
      if (!params || params.length === 0) {
        return url;
      }
      let updatedUrl = url;
      params.forEach(_ref => {
        let {
          key,
          value
        } = _ref;
        const separator = updatedUrl.includes('?') ? '&' : '?';
        updatedUrl += `${separator}${encodeURIComponent(key)}=${encodeURIComponent(value)}`;
      });
      return updatedUrl;
    } catch (e) {
      return url;
    }
  }
  static removeQueryParameterFromUrl(url, queryParameter) {
    if (!url || !queryParameter) {
      return url;
    }
    // Parse the URL
    const parsedUrl = new URL(url);

    // Get the search parameters
    const params = new URLSearchParams(parsedUrl.search);
    if (!params || params.size === 0 || !params.has(queryParameter)) {
      return url;
    }

    // Remove the queryParameter
    params.delete(queryParameter);

    // Manually reconstruct the query string without re-encoding
    const queryString = Array.from(params.entries()).map(_ref2 => {
      let [key, value] = _ref2;
      return `${key}=${value}`;
    }).join('&');

    // Reconstruct the URL
    const baseUrl = `${parsedUrl.origin}${parsedUrl.pathname}`;
    return queryString ? `${baseUrl}?${queryString}` : baseUrl;
  }
  static parseHttpHeaders(headerStr) {
    let headers = {};
    if (!headerStr) {
      return headers;
    }

    // Trim headerStr to fix a MS Edge bug with xhr.getAllResponseHeaders method
    // which send a string starting with a "\n" character
    let headerPairs = headerStr.trim().split('\u000d\u000a');
    for (let i = 0, ilen = headerPairs.length; i < ilen; i++) {
      let headerPair = headerPairs[i];
      let index = headerPair.indexOf('\u003a\u0020');
      if (index > 0) {
        headers[headerPair.substring(0, index)] = headerPair.substring(index + 2);
      }
    }
    return headers;
  }

  /**
   * Parses query parameters from a string and returns them as an array of key-value pairs.
   * @param {string} queryParamString - A string containing the query parameters.
   * @return {Array<{key: string, value: string}>} An array of objects representing the query parameters.
   */
  static parseQueryParams(queryParamString) {
    const params = [];
    const searchParams = new URLSearchParams(queryParamString);
    for (const [key, value] of searchParams.entries()) {
      params.push({
        key: decodeURIComponent(key),
        value: decodeURIComponent(value)
      });
    }
    return params;
  }
  static generateUuid() {
    let dt = new Date().getTime();
    const uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
      const r = (dt + Math.random() * 16) % 16 | 0;
      dt = Math.floor(dt / 16);
      return (c == 'x' ? r : r & 0x3 | 0x8).toString(16);
    });
    return uuid;
  }
  static generateHashCode(string) {
    let hash = 0;
    if (string.length === 0) {
      return hash;
    }
    for (let i = 0; i < string.length; i++) {
      const chr = string.charCodeAt(i);
      hash = (hash << 5) - hash + chr;
      hash |= 0;
    }
    return hash;
  }

  /**
   * Compares both urls and returns a relative url (target relative to original)
   * @param {string} originalUrl
   * @param {string} targetUrl
   * @return {string|*}
   */
  static getRelativeUrl(originalUrl, targetUrl) {
    try {
      const original = new URL(originalUrl);
      const target = new URL(targetUrl);

      // Unify the protocol to compare the origins
      original.protocol = target.protocol;
      if (original.origin !== target.origin) {
        return targetUrl;
      }

      // Use the relative path implementation of the path library. We need to cut off the actual filename in the end to get the relative path
      let relativePath = path_browserify__WEBPACK_IMPORTED_MODULE_0__.relative(original.pathname.substr(0, original.pathname.lastIndexOf('/')), target.pathname.substr(0, target.pathname.lastIndexOf('/')));

      // In case the relative path is empty (both path are equal) return the filename only. Otherwise add a slash in front of the filename
      const startIndexOffset = relativePath.length === 0 ? 1 : 0;
      relativePath += target.pathname.substr(target.pathname.lastIndexOf('/') + startIndexOffset, target.pathname.length - 1);

      // Build the other candidate, e.g. the 'host relative' path that starts with "/", and return the shortest of the two candidates.
      if (target.pathname.length < relativePath.length) {
        return target.pathname;
      }
      return relativePath;
    } catch (e) {
      return targetUrl;
    }
  }
  static getHostFromUrl(urlString) {
    try {
      const url = new URL(urlString);
      return url.host;
    } catch (e) {
      return null;
    }
  }
  static parseUserAgent() {
    let ua = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
    try {
      const uaString = ua === null ? typeof navigator !== 'undefined' ? navigator.userAgent.toLowerCase() : '' : '';
      return (0,ua_parser_js__WEBPACK_IMPORTED_MODULE_1__.UAParser)(uaString);
    } catch (e) {
      return {};
    }
  }

  /**
   * Checks for existence of "http" or "https" in a string
   * @param string
   * @returns {boolean}
   */
  static stringHasProtocol(string) {
    return /(http(s?)):\/\//i.test(string);
  }
  static bufferSourceToDataView(bufferSource) {
    return Utils.toDataView(bufferSource, DataView);
  }
  static bufferSourceToInt8(bufferSource) {
    return Utils.toDataView(bufferSource, Uint8Array);
  }
  static uint8ArrayToString(uint8Array) {
    const decoder = new TextDecoder('utf-8');
    return decoder.decode(uint8Array);
  }
  static bufferSourceToHex(data) {
    const arr = Utils.bufferSourceToInt8(data);
    let hex = '';
    for (let value of arr) {
      value = value.toString(16);
      if (value.length === 1) {
        value = '0' + value;
      }
      hex += value;
    }
    return hex;
  }
  static toDataView(bufferSource, Type) {
    const buffer = Utils.getArrayBuffer(bufferSource);
    let bytesPerElement = 1;
    if ('BYTES_PER_ELEMENT' in DataView) {
      bytesPerElement = DataView.BYTES_PER_ELEMENT;
    }
    const dataEnd = ((bufferSource.byteOffset || 0) + bufferSource.byteLength) / bytesPerElement;
    const rawStart = (bufferSource.byteOffset || 0) / bytesPerElement;
    const start = Math.floor(Math.max(0, Math.min(rawStart, dataEnd)));
    const end = Math.floor(Math.min(start + Math.max(Infinity, 0), dataEnd));
    return new Type(buffer, start, end - start);
  }
  static getArrayBuffer(view) {
    if (view instanceof ArrayBuffer) {
      return view;
    } else {
      return view.buffer;
    }
  }
  static getCodecFamily(codecString) {
    const {
      base,
      profile
    } = Utils._getCodecParts(codecString);
    switch (base) {
      case 'mp4a':
        switch (profile) {
          case '69':
          case '6b':
          case '40.34':
            return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.MP3;
          case '66':
          case '67':
          case '68':
          case '40.2':
          case '40.02':
          case '40.5':
          case '40.05':
          case '40.29':
          case '40.42':
            return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.AAC;
          case 'a5':
            return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.AC3;
          case 'e6':
            return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.EC3;
          case 'b2':
            return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.DTSX;
          case 'a9':
            return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.DTSC;
        }
        break;
      case 'avc1':
      case 'avc3':
        return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.AVC;
      case 'hvc1':
      case 'hvc3':
        return _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_2__["default"].CODEC_FAMILIES.HEVC;
      default:
        return base;
    }
    return base;
  }
  static _getCodecParts(codecString) {
    const [base, ...rest] = codecString.split('.');
    const profile = rest.join('.');
    return {
      base,
      profile
    };
  }
}
/* harmony default export */ __webpack_exports__["default"] = (Utils);

/***/ }),

/***/ "./src/core/errors/Errors.js":
/*!***********************************!*\
  !*** ./src/core/errors/Errors.js ***!
  \***********************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ErrorsBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ErrorsBase.js */ "./src/core/errors/ErrorsBase.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * Errors declaration
 * @class
 */
class Errors extends _ErrorsBase_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super();

    /**
     * Error code returned when a manifest parsing error occurs
     */
    this.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE = 10;

    /**
     * Error code returned when a manifest loading error occurs
     */
    this.MANIFEST_LOADER_LOADING_FAILURE_ERROR_CODE = 11;

    /**
     * Error code returned when a xlink loading error occurs
     */
    this.XLINK_LOADER_LOADING_FAILURE_ERROR_CODE = 12;

    /**
     * Error code returned when no segment ranges could be determined from the sidx box
     */
    this.SEGMENT_BASE_LOADER_ERROR_CODE = 15;

    /**
     * Error code returned when the time synchronization failed
     */
    this.TIME_SYNC_FAILED_ERROR_CODE = 16;

    /**
     * Error code returned when loading a fragment failed
     */
    this.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE = 17;

    /**
     * Error code returned when the FragmentLoader did not receive a request object
     */
    this.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE = 18;

    /**
     * Error code returned when the BaseUrl resolution failed
     */
    this.URL_RESOLUTION_FAILED_GENERIC_ERROR_CODE = 19;

    /**
     * Error code returned when the append operation in the SourceBuffer failed
     */
    this.APPEND_ERROR_CODE = 20;

    /**
     * Error code returned when the remove operation in the SourceBuffer failed
     */
    this.REMOVE_ERROR_CODE = 21;

    /**
     * Error code returned when updating the internal objects after loading an MPD failed
     */
    this.DATA_UPDATE_FAILED_ERROR_CODE = 22;

    /**
     * Error code returned when MediaSource is not supported by the browser
     */
    this.CAPABILITY_MEDIASOURCE_ERROR_CODE = 23;

    /**
     * Error code returned when Protected contents are not supported
     */
    this.CAPABILITY_MEDIAKEYS_ERROR_CODE = 24;

    /**
     * Error code returned when loading the manifest failed
     */
    this.DOWNLOAD_ERROR_ID_MANIFEST_CODE = 25;

    /**
     * Error code returned when loading the sidx failed
     */
    this.DOWNLOAD_ERROR_ID_SIDX_CODE = 26;

    /**
     * Error code returned when loading the media content failed
     */
    this.DOWNLOAD_ERROR_ID_CONTENT_CODE = 27;

    /**
     * Error code returned when loading the init segment failed
     */
    this.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE = 28;

    /**
     * Error code returned when loading the XLink content failed
     */
    this.DOWNLOAD_ERROR_ID_XLINK_CODE = 29;

    /**
     * Error code returned when parsing the MPD resulted in a logical error
     */
    this.MANIFEST_ERROR_ID_PARSE_CODE = 31;

    /**
     * Error code returned when no stream (period) has been detected in the manifest
     */
    this.MANIFEST_ERROR_ID_NOSTREAMS_CODE = 32;

    /**
     * Error code returned when something wrong has happened during parsing and appending subtitles (TTML or VTT)
     */
    this.TIMED_TEXT_ERROR_ID_PARSE_CODE = 33;

    /**
     * Error code returned when a 'muxed' media type has been detected in the manifest. This type is not supported
     */

    this.MANIFEST_ERROR_ID_MULTIPLEXED_CODE = 34;

    /**
     * Error code returned when a media source type is not supported
     */
    this.MEDIASOURCE_TYPE_UNSUPPORTED_CODE = 35;

    /**
     * Error code returned when the available Adaptation Sets can not be selected because the corresponding key ids have an invalid key status
     * @type {number}
     */
    this.NO_SUPPORTED_KEY_IDS = 36;
    this.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE = 'parsing failed for ';
    this.MANIFEST_LOADER_LOADING_FAILURE_ERROR_MESSAGE = 'Failed loading manifest: ';
    this.XLINK_LOADER_LOADING_FAILURE_ERROR_MESSAGE = 'Failed loading Xlink element: ';
    this.SEGMENTS_UPDATE_FAILED_ERROR_MESSAGE = 'Segments update failed';
    this.SEGMENTS_UNAVAILABLE_ERROR_MESSAGE = 'no segments are available yet';
    this.SEGMENT_BASE_LOADER_ERROR_MESSAGE = 'error loading segment ranges from sidx';
    this.TIME_SYNC_FAILED_ERROR_MESSAGE = 'Failed to synchronize client and server time';
    this.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE = 'request is null';
    this.URL_RESOLUTION_FAILED_GENERIC_ERROR_MESSAGE = 'Failed to resolve a valid URL';
    this.APPEND_ERROR_MESSAGE = 'chunk is not defined';
    this.REMOVE_ERROR_MESSAGE = 'Removing data from the SourceBuffer';
    this.DATA_UPDATE_FAILED_ERROR_MESSAGE = 'Data update failed';
    this.CAPABILITY_MEDIASOURCE_ERROR_MESSAGE = 'mediasource is not supported';
    this.CAPABILITY_MEDIAKEYS_ERROR_MESSAGE = 'mediakeys is not supported';
    this.TIMED_TEXT_ERROR_MESSAGE_PARSE = 'parsing error :';
    this.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE = 'Error creating source buffer of type : ';
    this.NO_SUPPORTED_KEY_IDS_MESSAGE = 'All possible Adaptation Sets have an invalid key status';
  }
}
let errors = new Errors();
/* harmony default export */ __webpack_exports__["default"] = (errors);

/***/ }),

/***/ "./src/core/errors/ErrorsBase.js":
/*!***************************************!*\
  !*** ./src/core/errors/ErrorsBase.js ***!
  \***************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @class
 * @ignore
 */
class ErrorsBase {
  extend(errors, config) {
    if (!errors) {
      return;
    }
    let override = config ? config.override : false;
    let publicOnly = config ? config.publicOnly : false;
    for (const err in errors) {
      if (!errors.hasOwnProperty(err) || this[err] && !override) {
        continue;
      }
      if (publicOnly && errors[err].indexOf('public_') === -1) {
        continue;
      }
      this[err] = errors[err];
    }
  }
}
/* harmony default export */ __webpack_exports__["default"] = (ErrorsBase);

/***/ }),

/***/ "./src/core/events/CoreEvents.js":
/*!***************************************!*\
  !*** ./src/core/events/CoreEvents.js ***!
  \***************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _EventsBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventsBase.js */ "./src/core/events/EventsBase.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * These are internal events that should not be needed at the player level.
 * If you find and event in here that you would like access to from MediaPlayer level
 * please add an issue at https://github.com/Dash-Industry-Forum/dash.js/issues/new
 * @class
 * @ignore
 */
class CoreEvents extends _EventsBase_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super();
    this.ATTEMPT_BACKGROUND_SYNC = 'attemptBackgroundSync';
    this.BUFFERING_COMPLETED = 'bufferingCompleted';
    this.BUFFER_CLEARED = 'bufferCleared';
    this.BYTES_APPENDED_END_FRAGMENT = 'bytesAppendedEndFragment';
    this.BUFFER_REPLACEMENT_STARTED = 'bufferReplacementStarted';
    this.CHECK_FOR_EXISTENCE_COMPLETED = 'checkForExistenceCompleted';
    this.CMSD_STATIC_HEADER = 'cmsdStaticHeader';
    this.CURRENT_TRACK_CHANGED = 'currentTrackChanged';
    this.DATA_UPDATE_COMPLETED = 'dataUpdateCompleted';
    this.INBAND_EVENTS = 'inbandEvents';
    this.INITIAL_STREAM_SWITCH = 'initialStreamSwitch';
    this.INIT_FRAGMENT_LOADED = 'initFragmentLoaded';
    this.INIT_FRAGMENT_NEEDED = 'initFragmentNeeded';
    this.INTERNAL_MANIFEST_LOADED = 'internalManifestLoaded';
    this.ORIGINAL_MANIFEST_LOADED = 'originalManifestLoaded';
    this.LOADING_COMPLETED = 'loadingCompleted';
    this.LOADING_PROGRESS = 'loadingProgress';
    this.LOADING_DATA_PROGRESS = 'loadingDataProgress';
    this.LOADING_ABANDONED = 'loadingAborted';
    this.MANIFEST_UPDATED = 'manifestUpdated';
    this.MEDIA_FRAGMENT_LOADED = 'mediaFragmentLoaded';
    this.MEDIA_FRAGMENT_NEEDED = 'mediaFragmentNeeded';
    this.MEDIAINFO_UPDATED = 'mediaInfoUpdated';
    this.QUOTA_EXCEEDED = 'quotaExceeded';
    this.SEGMENT_LOCATION_BLACKLIST_ADD = 'segmentLocationBlacklistAdd';
    this.SEGMENT_LOCATION_BLACKLIST_CHANGED = 'segmentLocationBlacklistChanged';
    this.SERVICE_LOCATION_BASE_URL_BLACKLIST_ADD = 'serviceLocationBlacklistAdd';
    this.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED = 'serviceLocationBlacklistChanged';
    this.SERVICE_LOCATION_LOCATION_BLACKLIST_ADD = 'serviceLocationLocationBlacklistAdd';
    this.SERVICE_LOCATION_LOCATION_BLACKLIST_CHANGED = 'serviceLocationLocationBlacklistChanged';
    this.SET_FRAGMENTED_TEXT_AFTER_DISABLED = 'setFragmentedTextAfterDisabled';
    this.SET_NON_FRAGMENTED_TEXT = 'setNonFragmentedText';
    this.SOURCE_BUFFER_ERROR = 'sourceBufferError';
    this.STREAMS_COMPOSED = 'streamsComposed';
    this.STREAM_BUFFERING_COMPLETED = 'streamBufferingCompleted';
    this.STREAM_REQUESTING_COMPLETED = 'streamRequestingCompleted';
    this.TEXT_TRACKS_QUEUE_INITIALIZED = 'textTracksQueueInitialized';
    this.TIME_SYNCHRONIZATION_COMPLETED = 'timeSynchronizationComplete';
    this.UPDATE_TIME_SYNC_OFFSET = 'updateTimeSyncOffset';
    this.URL_RESOLUTION_FAILED = 'urlResolutionFailed';
    this.VIDEO_CHUNK_RECEIVED = 'videoChunkReceived';
    this.WALLCLOCK_TIME_UPDATED = 'wallclockTimeUpdated';
    this.XLINK_ELEMENT_LOADED = 'xlinkElementLoaded';
    this.XLINK_READY = 'xlinkReady';
    this.SEEK_TARGET = 'seekTarget';
    this.SETTING_UPDATED_LIVE_DELAY = 'settingUpdatedLiveDelay';
    this.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT = 'settingUpdatedLiveDelayFragmentCount';
    this.SETTING_UPDATED_CATCHUP_ENABLED = 'settingUpdatedCatchupEnabled';
    this.SETTING_UPDATED_PLAYBACK_RATE_MIN = 'settingUpdatedPlaybackRateMin';
    this.SETTING_UPDATED_PLAYBACK_RATE_MAX = 'settingUpdatedPlaybackRateMax';
    this.SETTING_UPDATED_ABR_ACTIVE_RULES = 'settingUpdatedAbrActiveRules';
    this.SETTING_UPDATED_MAX_BITRATE = 'settingUpdatedMaxBitrate';
    this.SETTING_UPDATED_MIN_BITRATE = 'settingUpdatedMinBitrate';
  }
}
/* harmony default export */ __webpack_exports__["default"] = (CoreEvents);

/***/ }),

/***/ "./src/core/events/Events.js":
/*!***********************************!*\
  !*** ./src/core/events/Events.js ***!
  \***********************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CoreEvents_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CoreEvents.js */ "./src/core/events/CoreEvents.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @class
 * @ignore
 */

class Events extends _CoreEvents_js__WEBPACK_IMPORTED_MODULE_0__["default"] {}
let events = new Events();
/* harmony default export */ __webpack_exports__["default"] = (events);

/***/ }),

/***/ "./src/core/events/EventsBase.js":
/*!***************************************!*\
  !*** ./src/core/events/EventsBase.js ***!
  \***************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @class
 * @ignore
 */
class EventsBase {
  extend(events, config) {
    if (!events) {
      return;
    }
    let override = config ? config.override : false;
    let publicOnly = config ? config.publicOnly : false;
    for (const evt in events) {
      if (!events.hasOwnProperty(evt) || this[evt] && !override) {
        continue;
      }
      if (publicOnly && events[evt].indexOf('public_') === -1) {
        continue;
      }
      this[evt] = events[evt];
    }
  }
}
/* harmony default export */ __webpack_exports__["default"] = (EventsBase);

/***/ }),

/***/ "./src/dash/DashHandler.js":
/*!*********************************!*\
  !*** ./src/dash/DashHandler.js ***!
  \*********************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_vo_FragmentRequest_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../streaming/vo/FragmentRequest.js */ "./src/streaming/vo/FragmentRequest.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest.js */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents.js */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _utils_SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/SegmentsUtils.js */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






const DEFAULT_ADJUST_SEEK_TIME_THRESHOLD = 0.5;
const SEGMENT_START_TIME_DELTA = 0.001;
function DashHandler(config) {
  config = config || {};
  const eventBus = config.eventBus;
  const debug = config.debug;
  const urlUtils = config.urlUtils;
  const type = config.type;
  const streamInfo = config.streamInfo;
  const segmentsController = config.segmentsController;
  const timelineConverter = config.timelineConverter;
  const baseURLController = config.baseURLController;
  let instance, logger, lastSegment, isDynamicManifest, mediaHasFinished;
  function setup() {
    logger = debug.getLogger(instance);
    resetInitialSettings();
    eventBus.on(_streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_3__["default"].DYNAMIC_TO_STATIC, _onDynamicToStatic, instance);
  }
  function initialize(isDynamic) {
    isDynamicManifest = isDynamic;
    mediaHasFinished = false;
    segmentsController.initialize(isDynamic);
  }
  function getStreamId() {
    return streamInfo.id;
  }
  function getType() {
    return type;
  }
  function getStreamInfo() {
    return streamInfo;
  }
  function resetInitialSettings() {
    lastSegment = null;
  }
  function reset() {
    resetInitialSettings();
    eventBus.off(_streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_3__["default"].DYNAMIC_TO_STATIC, _onDynamicToStatic, instance);
  }
  function _setRequestUrl(request, destination, representation) {
    const baseURL = baseURLController.resolve(representation.path);
    let url,
      serviceLocation,
      queryParams = {};
    if (!baseURL || destination === baseURL.url || !urlUtils.isRelative(destination)) {
      url = destination;
    } else {
      url = baseURL.url;
      serviceLocation = baseURL.serviceLocation;
      queryParams = baseURL.queryParams;
      if (destination) {
        url = urlUtils.resolve(destination, url);
      }
    }
    if (urlUtils.isRelative(url)) {
      return false;
    }
    request.url = url;
    request.serviceLocation = serviceLocation;
    request.queryParams = queryParams;
    return true;
  }
  function getInitRequest(mediaInfo, representation) {
    if (!representation) {
      return null;
    }
    return _generateInitRequest(mediaInfo, representation, getType());
  }
  function _generateInitRequest(mediaInfo, representation, mediaType) {
    const request = new _streaming_vo_FragmentRequest_js__WEBPACK_IMPORTED_MODULE_0__["default"]();
    const period = representation.adaptation.period;
    const presentationStartTime = period.start;
    request.mediaType = mediaType;
    request.type = _streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.INIT_SEGMENT_TYPE;
    request.range = representation.range;
    request.availabilityStartTime = timelineConverter.calcAvailabilityStartTimeFromPresentationTime(presentationStartTime, representation, isDynamicManifest);
    request.availabilityEndTime = timelineConverter.calcAvailabilityEndTimeFromPresentationTime(presentationStartTime + period.duration, representation, isDynamicManifest);
    request.representation = representation;
    if (_setRequestUrl(request, representation.initialization, representation)) {
      request.url = (0,_utils_SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_5__.processUriTemplate)(request.url, undefined, undefined, undefined, representation.bandwidth);
      return request;
    }
  }
  function _getRequestForSegment(mediaInfo, segment) {
    if (segment === null || segment === undefined) {
      return null;
    }
    const request = new _streaming_vo_FragmentRequest_js__WEBPACK_IMPORTED_MODULE_0__["default"]();
    const representation = segment.representation;
    const bandwidth = representation.bandwidth;
    const url = (0,_utils_SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_5__.processUriTemplate)(segment.media, representation.id, segment.replacementNumber, undefined, bandwidth, segment.replacementTime);
    request.mediaType = getType();
    request.bandwidth = representation.bandwidth;
    request.type = _streaming_vo_metrics_HTTPRequest_js__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.MEDIA_SEGMENT_TYPE;
    request.range = segment.mediaRange;
    request.startTime = segment.presentationStartTime;
    request.mediaStartTime = segment.mediaStartTime;
    request.duration = segment.duration;
    request.timescale = representation.timescale;
    request.availabilityStartTime = segment.availabilityStartTime;
    request.availabilityEndTime = segment.availabilityEndTime;
    request.availabilityTimeComplete = representation.availabilityTimeComplete;
    request.wallStartTime = segment.wallStartTime;
    request.index = segment.index;
    request.adaptationIndex = representation.adaptation.index;
    request.representation = representation;
    if (_setRequestUrl(request, url, representation)) {
      return request;
    }
  }
  function isLastSegmentRequested(representation, bufferingTime) {
    if (!representation || !lastSegment) {
      return false;
    }

    // Either transition from dynamic to static was done or no next static segment found
    if (mediaHasFinished) {
      return true;
    }

    // Period is endless
    if (!isFinite(representation.adaptation.period.duration)) {
      return false;
    }

    // we are replacing existing stuff in the buffer for instance after a track switch
    if (lastSegment.presentationStartTime + lastSegment.duration > bufferingTime) {
      return false;
    }

    // Additional segment references may be added to the last period.
    // Additional periods may be added to the end of the MPD.
    // Segment references SHALL NOT be added to any period other than the last period.
    // An MPD update MAY combine adding segment references to the last period with adding of new periods. An MPD update that adds content MAY be combined with an MPD update that removes content.
    // The index of the last requested segment is higher than the number of available segments.
    // For SegmentTimeline and SegmentTemplate the index does not include the startNumber.
    // For SegmentList the index includes the startnumber which is why the numberOfSegments includes this as well
    if (representation.mediaFinishedInformation && !isNaN(representation.mediaFinishedInformation.numberOfSegments) && !isNaN(lastSegment.index) && lastSegment.index >= representation.mediaFinishedInformation.numberOfSegments - 1) {
      // For static manifests and Template addressing we can compare the index against the number of available segments
      if (!isDynamicManifest || representation.segmentInfoType === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SEGMENT_TEMPLATE) {
        return true;
      }
      // For SegmentList we need to check if the next period is signaled
      else if (isDynamicManifest && representation.segmentInfoType === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SEGMENT_LIST && representation.adaptation.period.nextPeriodId) {
        return true;
      }
    }

    // For dynamic SegmentTimeline manifests we need to check if the next period is already signaled and the segment we fetched before is the last one that is signaled.
    // We can not simply use the index, as numberOfSegments might have decreased after an MPD update
    return !!(isDynamicManifest && representation.adaptation.period.nextPeriodId && representation.segmentInfoType === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SEGMENT_TIMELINE && representation.mediaFinishedInformation && !isNaN(representation.mediaFinishedInformation.mediaTimeOfLastSignaledSegment) && lastSegment && !isNaN(lastSegment.mediaStartTime) && !isNaN(lastSegment.duration) && lastSegment.mediaStartTime + lastSegment.duration >= representation.mediaFinishedInformation.mediaTimeOfLastSignaledSegment - 0.05);
  }
  function getSegmentRequestForTime(mediaInfo, representation, time) {
    let request = null;
    if (!representation || !representation.segmentInfoType) {
      return request;
    }
    const segment = segmentsController.getSegmentByTime(representation, time);
    if (segment) {
      lastSegment = segment;
      logger.debug('Index for time ' + time + ' is ' + segment.index);
      request = _getRequestForSegment(mediaInfo, segment);
    }
    return request;
  }

  /**
   * This function returns the next segment request without modifying any internal variables. Any class (e.g CMCD Model) that needs information about the upcoming request should use this method.
   * @param {object} mediaInfo
   * @param {object} representation
   * @return {FragmentRequest|null}
   */
  function getNextSegmentRequestIdempotent(mediaInfo, representation) {
    let request = null;
    let indexToRequest = lastSegment ? lastSegment.index + 1 : 0;
    const segment = segmentsController.getSegmentByIndex(representation, indexToRequest, lastSegment ? lastSegment.mediaStartTime : -1);
    if (!segment) {
      return null;
    }
    request = _getRequestForSegment(mediaInfo, segment);
    return request;
  }

  /**
   * Main function to get the next segment request.
   * @param {object} mediaInfo
   * @param {object} representation
   * @return {FragmentRequest|null}
   */
  function getNextSegmentRequest(mediaInfo, representation) {
    if (!representation || !representation.segmentInfoType) {
      return null;
    }
    let indexToRequest = lastSegment ? lastSegment.index + 1 : 0;
    if (representation && lastSegment && representation.endNumber && lastSegment.replacementNumber && lastSegment.replacementNumber >= representation.endNumber) {
      mediaHasFinished = true;
      return null;
    }
    return _getRequest(mediaInfo, representation, indexToRequest);
  }
  function repeatSegmentRequest(mediaInfo, representation) {
    if (!representation || !representation.segmentInfoType) {
      return null;
    }
    let indexToRequest = lastSegment ? lastSegment.index : 0;
    return _getRequest(mediaInfo, representation, indexToRequest);
  }
  function _getRequest(mediaInfo, representation, indexToRequest) {
    let request = null;
    const segment = segmentsController.getSegmentByIndex(representation, indexToRequest, lastSegment ? lastSegment.mediaStartTime : -1);

    // No segment found
    if (!segment) {
      // Dynamic manifest there might be something available in the next iteration
      if (isDynamicManifest && !mediaHasFinished) {
        logger.debug(getType() + ' No segment found at index: ' + indexToRequest + '. Wait for next loop');
        return null;
      } else {
        mediaHasFinished = true;
      }
    } else {
      request = _getRequestForSegment(mediaInfo, segment);
      lastSegment = segment;
    }
    return request;
  }

  /**
   * This function returns a time larger than the current time for which we can generate a request.
   * This is useful in scenarios in which the user seeks into a gap in a dynamic Timeline manifest. We will not find a valid request then and need to adjust the seektime.
   * @param {number} time
   * @param {object} mediaInfo
   * @param {object} representation
   * @param {number} targetThreshold
   * @return {number}
   */
  function getValidTimeAheadOfTargetTime(time, mediaInfo, representation, targetThreshold) {
    try {
      if (isNaN(time) || !mediaInfo || !representation) {
        return NaN;
      }
      if (time < 0) {
        time = 0;
      }
      if (isNaN(targetThreshold)) {
        targetThreshold = DEFAULT_ADJUST_SEEK_TIME_THRESHOLD;
      }
      if (getSegmentRequestForTime(mediaInfo, representation, time)) {
        return time;
      }
      if (representation.adaptation.period.start + representation.adaptation.period.duration < time) {
        return NaN;
      }

      // If we have a duration look until the end of the duration, otherwise maximum 30 seconds
      const end = isFinite(representation.adaptation.period.duration) ? representation.adaptation.period.start + representation.adaptation.period.duration : time + 30;
      let currentUpperTime = Math.min(time + targetThreshold, end);
      let adjustedTime = NaN;
      let targetRequest = null;
      while (currentUpperTime <= end) {
        let upperRequest = null;
        if (currentUpperTime <= end) {
          upperRequest = getSegmentRequestForTime(mediaInfo, representation, currentUpperTime);
        }
        if (upperRequest) {
          adjustedTime = currentUpperTime;
          targetRequest = upperRequest;
          break;
        }
        currentUpperTime += targetThreshold;
      }
      if (targetRequest) {
        const requestEndTime = targetRequest.startTime + targetRequest.duration;

        // Keep the original start time in case it is covered by a segment
        if (time > targetRequest.startTime && requestEndTime - time > targetThreshold) {
          return time;
        }
        if (!isNaN(targetRequest.startTime) && time < targetRequest.startTime && adjustedTime > targetRequest.startTime) {
          // Apply delta to segment start time to get around rounding issues
          return targetRequest.startTime + SEGMENT_START_TIME_DELTA;
        }
        return Math.min(requestEndTime - targetThreshold, adjustedTime);
      }
      return adjustedTime;
    } catch (e) {
      return NaN;
    }
  }
  function getCurrentIndex() {
    return lastSegment ? lastSegment.index : -1;
  }
  function _onDynamicToStatic() {
    logger.debug('Dynamic stream complete');
    mediaHasFinished = true;
  }
  instance = {
    getCurrentIndex,
    getInitRequest,
    getNextSegmentRequest,
    getNextSegmentRequestIdempotent,
    getSegmentRequestForTime,
    getStreamId,
    getStreamInfo,
    getType,
    getValidTimeAheadOfTargetTime,
    initialize,
    isLastSegmentRequested,
    repeatSegmentRequest,
    reset
  };
  setup();
  return instance;
}
DashHandler.__dashjs_factory_name = 'DashHandler';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(DashHandler));

/***/ }),

/***/ "./src/dash/constants/DashConstants.js":
/*!*********************************************!*\
  !*** ./src/dash/constants/DashConstants.js ***!
  \*********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES, LOSS OF USE, DATA, OR
 *  PROFITS, OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Dash constants declaration
 * @ignore
 */
/* harmony default export */ __webpack_exports__["default"] = ({
  ACCESSIBILITY: 'Accessibility',
  ADAPTATION_SET: 'AdaptationSet',
  ADAPTATION_SETS: 'adaptationSets',
  ADAPTATION_SET_SWITCHING_SCHEME_ID_URI: 'urn:mpeg:dash:adaptation-set-switching:2016',
  ADD: 'add',
  ASSET_IDENTIFIER: 'AssetIdentifier',
  AUDIO_CHANNEL_CONFIGURATION: 'AudioChannelConfiguration',
  AUDIO_SAMPLING_RATE: 'audioSamplingRate',
  AVAILABILITY_END_TIME: 'availabilityEndTime',
  AVAILABILITY_START_TIME: 'availabilityStartTime',
  AVAILABILITY_TIME_COMPLETE: 'availabilityTimeComplete',
  AVAILABILITY_TIME_OFFSET: 'availabilityTimeOffset',
  BANDWITH: 'bandwidth',
  BASE_URL: 'BaseURL',
  BITSTREAM_SWITCHING: 'BitstreamSwitching',
  BITSTREAM_SWITCHING_MINUS: 'bitstreamSwitching',
  BYTE_RANGE: 'byteRange',
  CAPTION: 'caption',
  CENC_DEFAULT_KID: 'cenc:default_KID',
  CLIENT_DATA_REPORTING: 'ClientDataReporting',
  CLIENT_REQUIREMENT: 'clientRequirement',
  CMCD_PARAMETERS: 'CMCDParameters',
  CODECS: 'codecs',
  CODEC_PRIVATE_DATA: 'codecPrivateData',
  CODING_DEPENDENCY: 'codingDependency',
  CONTENT_COMPONENT: 'ContentComponent',
  CONTENT_PROTECTION: 'ContentProtection',
  CONTENT_STEERING: 'ContentSteering',
  CONTENT_STEERING_RESPONSE: {
    VERSION: 'VERSION',
    TTL: 'TTL',
    RELOAD_URI: 'RELOAD-URI',
    PATHWAY_PRIORITY: 'PATHWAY-PRIORITY',
    PATHWAY_CLONES: 'PATHWAY-CLONES',
    BASE_ID: 'BASE-ID',
    ID: 'ID',
    URI_REPLACEMENT: 'URI-REPLACEMENT',
    HOST: 'HOST',
    PARAMS: 'PARAMS'
  },
  CONTENT_TYPE: 'contentType',
  DEFAULT_SERVICE_LOCATION: 'defaultServiceLocation',
  DEPENDENCY_ID: 'dependencyId',
  DURATION: 'duration',
  DVB_PRIORITY: 'dvb:priority',
  DVB_WEIGHT: 'dvb:weight',
  DVB_URL: 'dvb:url',
  DVB_MIMETYPE: 'dvb:mimeType',
  DVB_FONTFAMILY: 'dvb:fontFamily',
  DYNAMIC: 'dynamic',
  END_NUMBER: 'endNumber',
  ESSENTIAL_PROPERTY: 'EssentialProperty',
  EVENT: 'Event',
  EVENT_STREAM: 'EventStream',
  FORCED_SUBTITLE: 'forced-subtitle',
  FRAMERATE: 'frameRate',
  FRAME_PACKING: 'FramePacking',
  GROUP_LABEL: 'GroupLabel',
  HEIGHT: 'height',
  ID: 'id',
  INBAND: 'inband',
  INBAND_EVENT_STREAM: 'InbandEventStream',
  INDEX: 'index',
  INDEX_RANGE: 'indexRange',
  INITIALIZATION: 'Initialization',
  INITIALIZATION_MINUS: 'initialization',
  LA_URL: 'Laurl',
  LA_URL_LOWER_CASE: 'laurl',
  LABEL: 'Label',
  LANG: 'lang',
  LOCATION: 'Location',
  MAIN: 'main',
  MAXIMUM_SAP_PERIOD: 'maximumSAPPeriod',
  MAX_PLAYOUT_RATE: 'maxPlayoutRate',
  MAX_SEGMENT_DURATION: 'maxSegmentDuration',
  MAX_SUBSEGMENT_DURATION: 'maxSubsegmentDuration',
  MEDIA: 'media',
  MEDIA_PRESENTATION_DURATION: 'mediaPresentationDuration',
  MEDIA_RANGE: 'mediaRange',
  MEDIA_STREAM_STRUCTURE_ID: 'mediaStreamStructureId',
  METRICS: 'Metrics',
  METRICS_MINUS: 'metrics',
  MIME_TYPE: 'mimeType',
  MINIMUM_UPDATE_PERIOD: 'minimumUpdatePeriod',
  MIN_BUFFER_TIME: 'minBufferTime',
  MP4_PROTECTION_SCHEME: 'urn:mpeg:dash:mp4protection:2011',
  MPD: 'MPD',
  MPD_TYPE: 'mpd',
  MPD_PATCH_TYPE: 'mpdpatch',
  ORIGINAL_MPD_ID: 'mpdId',
  ORIGINAL_PUBLISH_TIME: 'originalPublishTime',
  PATCH_LOCATION: 'PatchLocation',
  PERIOD: 'Period',
  PRESENTATION_TIME: 'presentationTime',
  PRESENTATION_TIME_OFFSET: 'presentationTimeOffset',
  PRO: 'pro',
  PRODUCER_REFERENCE_TIME: 'ProducerReferenceTime',
  PRODUCER_REFERENCE_TIME_TYPE: {
    ENCODER: 'encoder',
    CAPTURED: 'captured',
    APPLICATION: 'application'
  },
  PROFILES: 'profiles',
  PSSH: 'pssh',
  PUBLISH_TIME: 'publishTime',
  QUALITY_RANKING: 'qualityRanking',
  QUERY_BEFORE_START: 'queryBeforeStart',
  QUERY_PART: '$querypart$',
  RANGE: 'range',
  RATING: 'Rating',
  REF: 'ref',
  REF_ID: 'refId',
  REMOVE: 'remove',
  REPLACE: 'replace',
  REPORTING: 'Reporting',
  REPRESENTATION: 'Representation',
  REPRESENTATION_INDEX: 'RepresentationIndex',
  ROBUSTNESS: 'robustness',
  ROLE: 'Role',
  S: 'S',
  SAR: 'sar',
  SCAN_TYPE: 'scanType',
  SEGMENT_ALIGNMENT: 'segmentAlignment',
  SEGMENT_BASE: 'SegmentBase',
  SEGMENT_LIST: 'SegmentList',
  SEGMENT_PROFILES: 'segmentProfiles',
  SEGMENT_TEMPLATE: 'SegmentTemplate',
  SEGMENT_TIMELINE: 'SegmentTimeline',
  SEGMENT_TYPE: 'segment',
  SEGMENT_URL: 'SegmentURL',
  SERVICE_DESCRIPTION: 'ServiceDescription',
  SERVICE_DESCRIPTION_LATENCY: 'Latency',
  SERVICE_DESCRIPTION_OPERATING_BANDWIDTH: 'OperatingBandwidth',
  SERVICE_DESCRIPTION_OPERATING_QUALITY: 'OperatingQuality',
  SERVICE_DESCRIPTION_PLAYBACK_RATE: 'PlaybackRate',
  SERVICE_DESCRIPTION_SCOPE: 'Scope',
  SERVICE_LOCATION: 'serviceLocation',
  SERVICE_LOCATIONS: 'serviceLocations',
  SOURCE_URL: 'sourceURL',
  START: 'start',
  START_NUMBER: 'startNumber',
  START_WITH_SAP: 'startWithSAP',
  STATIC: 'static',
  STEERING_TYPE: 'steering',
  SUBSET: 'Subset',
  SUBTITLE: 'subtitle',
  SUB_REPRESENTATION: 'SubRepresentation',
  SUB_SEGMENT_ALIGNMENT: 'subsegmentAlignment',
  SUGGESTED_PRESENTATION_DELAY: 'suggestedPresentationDelay',
  SUPPLEMENTAL_PROPERTY: 'SupplementalProperty',
  SUPPLEMENTAL_CODECS: 'scte214:supplementalCodecs',
  TIMESCALE: 'timescale',
  TIMESHIFT_BUFFER_DEPTH: 'timeShiftBufferDepth',
  TTL: 'ttl',
  TYPE: 'type',
  UTC_TIMING: 'UTCTiming',
  VALUE: 'value',
  VIEWPOINT: 'Viewpoint',
  WALL_CLOCK_TIME: 'wallClockTime',
  WIDTH: 'width'
});

/***/ }),

/***/ "./src/dash/controllers/RepresentationController.js":
/*!**********************************************************!*\
  !*** ./src/dash/controllers/RepresentationController.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../streaming/MediaPlayerEvents.js */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _utils_SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/SegmentsUtils.js */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function RepresentationController(config) {
  config = config || {};
  const eventBus = config.eventBus;
  const events = config.events;
  const abrController = config.abrController;
  const dashMetrics = config.dashMetrics;
  const playbackController = config.playbackController;
  const timelineConverter = config.timelineConverter;
  const type = config.type;
  const streamInfo = config.streamInfo;
  const segmentsController = config.segmentsController;
  const isDynamic = config.isDynamic;
  let instance, voAvailableRepresentations, currentVoRepresentation;
  function setup() {
    resetInitialSettings();
    eventBus.on(_streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_2__["default"].MANIFEST_VALIDITY_CHANGED, onManifestValidityChanged, instance);
  }
  function getStreamId() {
    return streamInfo.id;
  }
  function getType() {
    return type;
  }
  function checkConfig() {
    if (!abrController || !dashMetrics || !playbackController || !timelineConverter) {
      throw new Error(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_0__["default"].MISSING_CONFIG_ERROR);
    }
  }
  function getCurrentRepresentation() {
    return currentVoRepresentation;
  }
  function resetInitialSettings() {
    currentVoRepresentation = null;
    voAvailableRepresentations = [];
  }
  function reset() {
    eventBus.off(_streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_2__["default"].MANIFEST_VALIDITY_CHANGED, onManifestValidityChanged, instance);
    resetInitialSettings();
  }
  function updateData(availableRepresentations, isFragmented, selectedRepresentationId) {
    return new Promise((resolve, reject) => {
      voAvailableRepresentations = availableRepresentations;
      const selectedRepresentation = getRepresentationById(selectedRepresentationId);
      _setCurrentVoRepresentation(selectedRepresentation);
      if (type !== _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO && type !== _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO && (type !== _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT || !isFragmented)) {
        endDataUpdate();
        resolve();
        return;
      }
      const promises = [];
      for (let i = 0, ln = voAvailableRepresentations.length; i < ln; i++) {
        const currentRep = voAvailableRepresentations[i];
        promises.push(_updateRepresentation(currentRep));
      }
      Promise.all(promises).then(() => {
        _onAllRepresentationsUpdated();
        resolve();
      }).catch(e => {
        reject(e);
      });
    });
  }
  function _onAllRepresentationsUpdated() {
    abrController.setPlaybackQuality(type, streamInfo, currentVoRepresentation);
    const dvrInfo = dashMetrics.getCurrentDVRInfo(type);
    if (dvrInfo) {
      dashMetrics.updateManifestUpdateInfo({
        latency: dvrInfo.range.end - playbackController.getTime()
      });
    }
    endDataUpdate();
  }
  function _updateRepresentation(currentRep) {
    return new Promise((resolve, reject) => {
      const hasInitialization = currentRep.hasInitialization();
      const hasSegments = currentRep.hasSegments();

      // If representation has initialization and segments information we are done
      // otherwise, it means that a request has to be made to get initialization and/or segments information
      const promises = [];
      promises.push(segmentsController.updateInitData(currentRep, hasInitialization));
      promises.push(segmentsController.updateSegmentData(currentRep, hasSegments));
      Promise.all(promises).then(data => {
        if (data[0] && !data[0].error) {
          currentRep = _onInitLoaded(currentRep, data[0]);
        }
        if (data[1] && !data[1].error) {
          currentRep = _onSegmentsLoaded(currentRep, data[1]);
        }
        currentRep.fragmentDuration = currentRep.segmentDuration ? currentRep.segmentDuration : currentRep.segments && currentRep.segments.length > 0 ? currentRep.segments[0].duration : NaN;
        _setMediaFinishedInformation(currentRep);
        _onRepresentationUpdated(currentRep);
        resolve();
      }).catch(e => {
        reject(e);
      });
    });
  }
  function _setMediaFinishedInformation(representation) {
    representation.mediaFinishedInformation = segmentsController.getMediaFinishedInformation(representation);
  }
  function _onInitLoaded(representation, e) {
    if (!e || e.error || !e.representation) {
      return representation;
    }
    return e.representation;
  }
  function _onSegmentsLoaded(representation, e) {
    if (!e || e.error) {
      return;
    }
    const fragments = e.segments;
    const segments = [];
    let count = 0;
    let i, len, s, seg;
    for (i = 0, len = fragments ? fragments.length : 0; i < len; i++) {
      s = fragments[i];
      seg = (0,_utils_SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_3__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, s.startTime, s.duration, s.timescale, s.media, s.mediaRange, count);
      if (seg) {
        segments.push(seg);
        seg = null;
        count++;
      }
    }
    if (segments.length > 0) {
      representation.segments = segments;
    }
    return representation;
  }
  function _addRepresentationSwitch(currentRepresentation) {
    checkConfig();
    const now = new Date();
    const currentVideoTimeMs = playbackController.getTime() * 1000;
    if (currentRepresentation) {
      dashMetrics.addRepresentationSwitch(currentRepresentation.adaptation.type, now, currentVideoTimeMs, currentRepresentation.id);
    }
    eventBus.trigger(_streaming_MediaPlayerEvents_js__WEBPACK_IMPORTED_MODULE_2__["default"].REPRESENTATION_SWITCH, {
      mediaType: type,
      streamId: streamInfo.id,
      currentRepresentation
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }
  function getRepresentationById(id) {
    if (!voAvailableRepresentations || voAvailableRepresentations.length === 0) {
      return null;
    }
    const reps = voAvailableRepresentations.filter(rep => {
      return rep.id === id;
    });
    if (reps.length > 0) {
      return reps[0];
    }
    return null;
  }
  function endDataUpdate(error) {
    eventBus.trigger(events.DATA_UPDATE_COMPLETED, {
      currentRepresentation: currentVoRepresentation,
      error: error
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }
  function _onRepresentationUpdated(r) {
    let manifestUpdateInfo = dashMetrics.getCurrentManifestUpdate();
    let alreadyAdded = false;
    let repInfo;
    if (manifestUpdateInfo) {
      for (let i = 0; i < manifestUpdateInfo.representationInfo.length; i++) {
        repInfo = manifestUpdateInfo.representationInfo[i];
        if (repInfo.index === r.index && repInfo.mediaType === getType()) {
          alreadyAdded = true;
          break;
        }
      }
      if (!alreadyAdded) {
        dashMetrics.addManifestUpdateRepresentationInfo(r, getType());
      }
    }
  }

  /**
   * We get the new selected Representation which will not hold the ranges and the segment references in case of SegmentBase.
   * In any case use the id to find the right Representation instance in our array of Representations.
   * @param newRep
   */
  function prepareQualityChange(newRep) {
    const voRepresentations = voAvailableRepresentations.filter(rep => {
      return rep.id === newRep.id;
    });
    if (voRepresentations.length > 0) {
      _setCurrentVoRepresentation(voRepresentations[0]);
    }
  }
  function _setCurrentVoRepresentation(value) {
    if (!currentVoRepresentation || currentVoRepresentation.id !== value.id) {
      _addRepresentationSwitch(value);
    }
    currentVoRepresentation = value;
  }
  function onManifestValidityChanged(e) {
    if (e.newDuration) {
      const representation = getCurrentRepresentation();
      if (representation && representation.adaptation.period) {
        const period = representation.adaptation.period;
        period.duration = e.newDuration;
      }
    }
  }
  instance = {
    getCurrentRepresentation,
    getRepresentationById,
    getStreamId,
    getType,
    prepareQualityChange,
    reset,
    updateData
  };
  setup();
  return instance;
}
RepresentationController.__dashjs_factory_name = 'RepresentationController';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(RepresentationController));

/***/ }),

/***/ "./src/dash/controllers/SegmentsController.js":
/*!****************************************************!*\
  !*** ./src/dash/controllers/SegmentsController.js ***!
  \****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _utils_TimelineSegmentsGetter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/TimelineSegmentsGetter.js */ "./src/dash/utils/TimelineSegmentsGetter.js");
/* harmony import */ var _utils_TemplateSegmentsGetter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/TemplateSegmentsGetter.js */ "./src/dash/utils/TemplateSegmentsGetter.js");
/* harmony import */ var _utils_ListSegmentsGetter_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/ListSegmentsGetter.js */ "./src/dash/utils/ListSegmentsGetter.js");
/* harmony import */ var _utils_SegmentBaseGetter_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/SegmentBaseGetter.js */ "./src/dash/utils/SegmentBaseGetter.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */





function SegmentsController(config) {
  config = config || {};
  const context = this.context;
  const dashConstants = config.dashConstants;
  const type = config.type;
  const segmentBaseController = config.segmentBaseController;
  let instance, getters;
  function setup() {
    getters = {};
  }
  function initialize(isDynamic) {
    getters[dashConstants.SEGMENT_TIMELINE] = (0,_utils_TimelineSegmentsGetter_js__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_TEMPLATE] = (0,_utils_TemplateSegmentsGetter_js__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_LIST] = (0,_utils_ListSegmentsGetter_js__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_BASE] = (0,_utils_SegmentBaseGetter_js__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create(config, isDynamic);
  }
  function updateInitData(voRepresentation, hasInitialization) {
    if (hasInitialization) {
      return Promise.resolve();
    }
    return segmentBaseController.getSegmentBaseInitSegment({
      representation: voRepresentation,
      mediaType: type
    });
  }
  function updateSegmentData(voRepresentation, hasSegments) {
    if (hasSegments) {
      return Promise.resolve();
    }
    return segmentBaseController.getSegmentList({
      mimeType: voRepresentation.mimeType,
      representation: voRepresentation,
      mediaType: type
    });
  }
  function getSegmentsGetter(representation) {
    return representation ? representation.segments ? getters[dashConstants.SEGMENT_BASE] : getters[representation.segmentInfoType] : null;
  }
  function getSegmentByIndex(representation, index, lastSegmentTime) {
    const getter = getSegmentsGetter(representation);
    return getter ? getter.getSegmentByIndex(representation, index, lastSegmentTime) : null;
  }
  function getSegmentByTime(representation, time) {
    const getter = getSegmentsGetter(representation);
    return getter ? getter.getSegmentByTime(representation, time) : null;
  }
  function getMediaFinishedInformation(representation) {
    const getter = getSegmentsGetter(representation);
    return getter ? getter.getMediaFinishedInformation(representation) : {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
  }
  instance = {
    initialize,
    updateInitData,
    updateSegmentData,
    getSegmentByIndex,
    getSegmentByTime,
    getMediaFinishedInformation
  };
  setup();
  return instance;
}
SegmentsController.__dashjs_factory_name = 'SegmentsController';
const factory = _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SegmentsController);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/models/DashManifestModel.js":
/*!**********************************************!*\
  !*** ./src/dash/models/DashManifestModel.js ***!
  \**********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _vo_AdaptationSet_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../vo/AdaptationSet.js */ "./src/dash/vo/AdaptationSet.js");
/* harmony import */ var _vo_BaseURL_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../vo/BaseURL.js */ "./src/dash/vo/BaseURL.js");
/* harmony import */ var _vo_CMCDParameters_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../vo/CMCDParameters.js */ "./src/dash/vo/CMCDParameters.js");
/* harmony import */ var _vo_ClientDataReporting_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vo/ClientDataReporting.js */ "./src/dash/vo/ClientDataReporting.js");
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _vo_ContentProtection_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vo/ContentProtection.js */ "./src/dash/vo/ContentProtection.js");
/* harmony import */ var _vo_ContentSteering_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vo/ContentSteering.js */ "./src/dash/vo/ContentSteering.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _streaming_vo_DashJSError_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../streaming/vo/DashJSError.js */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_Debug_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../core/Debug.js */ "./src/core/Debug.js");
/* harmony import */ var _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../vo/DescriptorType.js */ "./src/dash/vo/DescriptorType.js");
/* harmony import */ var _core_errors_Errors_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/errors/Errors.js */ "./src/core/errors/Errors.js");
/* harmony import */ var _vo_Event_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../vo/Event.js */ "./src/dash/vo/Event.js");
/* harmony import */ var _vo_EventStream_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../vo/EventStream.js */ "./src/dash/vo/EventStream.js");
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_Mpd_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../vo/Mpd.js */ "./src/dash/vo/Mpd.js");
/* harmony import */ var _vo_MpdLocation_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../vo/MpdLocation.js */ "./src/dash/vo/MpdLocation.js");
/* harmony import */ var _streaming_utils_ObjectUtils_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../streaming/utils/ObjectUtils.js */ "./src/streaming/utils/ObjectUtils.js");
/* harmony import */ var _vo_PatchLocation_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../vo/PatchLocation.js */ "./src/dash/vo/PatchLocation.js");
/* harmony import */ var _vo_Period_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../vo/Period.js */ "./src/dash/vo/Period.js");
/* harmony import */ var _vo_ProducerReferenceTime_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../vo/ProducerReferenceTime.js */ "./src/dash/vo/ProducerReferenceTime.js");
/* harmony import */ var _vo_Representation_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../vo/Representation.js */ "./src/dash/vo/Representation.js");
/* harmony import */ var _streaming_utils_URLUtils_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../streaming/utils/URLUtils.js */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _vo_UTCTiming_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../vo/UTCTiming.js */ "./src/dash/vo/UTCTiming.js");
/* harmony import */ var _core_Utils_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../core/Utils.js */ "./src/core/Utils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

























function DashManifestModel() {
  let instance, logger, errHandler, BASE64;
  const context = this.context;
  const urlUtils = (0,_streaming_utils_URLUtils_js__WEBPACK_IMPORTED_MODULE_22__["default"])(context).getInstance();
  const isInteger = Number.isInteger || function (value) {
    return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
  };
  function setup() {
    logger = (0,_core_Debug_js__WEBPACK_IMPORTED_MODULE_9__["default"])(context).getInstance().getLogger(instance);
  }
  function getIsTypeOf(adaptation, type) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }
    if (!type) {
      throw new Error('type is not defined');
    }

    // Check for thumbnail images
    if (adaptation.Representation && adaptation.Representation.length) {
      const essentialProperties = getEssentialPropertiesForRepresentation(adaptation.Representation[0]);
      if (essentialProperties && essentialProperties.some(essentialProperty => _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].THUMBNAILS_SCHEME_ID_URIS.indexOf(essentialProperty.schemeIdUri) >= 0)) {
        return type === _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].IMAGE;
      }
    }

    // Check ContentComponent.contentType
    if (adaptation.ContentComponent && adaptation.ContentComponent.length > 0) {
      if (adaptation.ContentComponent.length > 1) {
        return type === _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].MUXED;
      } else if (adaptation.ContentComponent[0].contentType === type) {
        return true;
      }
    }
    const mimeTypeRegEx = type === _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].TEXT ? new RegExp('(ttml|vtt|wvtt|stpp)') : new RegExp(type);

    // Check codecs
    if (adaptation.Representation && adaptation.Representation.length) {
      const codecs = adaptation.Representation[0].codecs;
      if (mimeTypeRegEx.test(codecs)) {
        return true;
      }
    }

    // Check Adaptation's mimeType
    if (adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MIME_TYPE)) {
      return mimeTypeRegEx.test(adaptation.mimeType);
    }

    // Check Representation's mimeType
    if (adaptation.Representation) {
      let representation;
      for (let i = 0; i < adaptation.Representation.length; i++) {
        representation = adaptation.Representation[i];
        if (representation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MIME_TYPE)) {
          return mimeTypeRegEx.test(representation.mimeType);
        }
      }
    }
    return false;
  }
  function getIsFragmented(adaptation) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }
    if (adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TEMPLATE) || adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE) || adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_LIST) || adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_BASE)) {
      return true;
    }
    if (adaptation.Representation && adaptation.Representation.length > 0) {
      const representation = adaptation.Representation[0];
      if (representation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TEMPLATE) || representation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE) || representation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_LIST) || representation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_BASE)) {
        return true;
      }
    }
    return false;
  }
  function getIsAudio(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].AUDIO);
  }
  function getIsVideo(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].VIDEO);
  }
  function getIsText(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].TEXT);
  }
  function getIsMuxed(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].MUXED);
  }
  function getIsImage(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].IMAGE);
  }
  function getProducerReferenceTimesForAdaptation(adaptation) {
    const prtArray = adaptation && adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRODUCER_REFERENCE_TIME) ? adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRODUCER_REFERENCE_TIME] : [];

    // ProducerReferenceTime elements can also be contained in Representations
    const representationsArray = adaptation && adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].REPRESENTATION) ? adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].REPRESENTATION] : [];
    representationsArray.forEach(rep => {
      if (rep.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRODUCER_REFERENCE_TIME)) {
        prtArray.push(...rep[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRODUCER_REFERENCE_TIME]);
      }
    });
    const prtsForAdaptation = [];

    // Unlikely to have multiple ProducerReferenceTimes.
    prtArray.forEach(prt => {
      const entry = new _vo_ProducerReferenceTime_js__WEBPACK_IMPORTED_MODULE_20__["default"]();
      if (prt.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID)) {
        entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID] = parseInt(prt[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID]);
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }
      if (prt.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].WALL_CLOCK_TIME)) {
        entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].WALL_CLOCK_TIME] = prt[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].WALL_CLOCK_TIME];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }
      if (prt.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME)) {
        entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME] = prt[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }
      if (prt.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].INBAND)) {
        entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].INBAND] = prt[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].INBAND] !== 'false';
      }
      if (prt.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TYPE)) {
        entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TYPE] = prt[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TYPE];
      }

      // Not interested in other attributes for now
      // UTC element contained must be same as that in the MPD
      prtsForAdaptation.push(entry);
    });
    return prtsForAdaptation;
  }
  function getLanguageForAdaptation(adaptation) {
    let lang = '';
    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].LANG)) {
      lang = adaptation.lang;
    }
    return lang;
  }
  function getViewpointForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VIEWPOINT) || !adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VIEWPOINT].length) {
      return [];
    }
    return adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VIEWPOINT].map(viewpoint => {
      const vp = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      vp.init(viewpoint);
      return vp;
    });
  }
  function getRolesForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ROLE) || !adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ROLE].length) {
      return [];
    }
    return adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ROLE].map(role => {
      // conceal misspelled "Main" from earlier MPEG-DASH editions (fixed with 6th edition)
      if (role.schemeIdUri === _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].DASH_ROLE_SCHEME_ID && role.value === 'Main') {
        role.value = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MAIN;
      }
      const r = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      r.init(role);
      return r;
    });
  }
  function getAccessibilityForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ACCESSIBILITY) || !adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ACCESSIBILITY].length) {
      return [];
    }
    return adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ACCESSIBILITY].map(accessibility => {
      const a = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      a.init(accessibility);
      return a;
    });
  }
  function getAudioChannelConfigurationForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO_CHANNEL_CONFIGURATION) || !adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO_CHANNEL_CONFIGURATION].length) {
      return [];
    }
    return adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO_CHANNEL_CONFIGURATION].map(audioChanCfg => {
      const acc = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      acc.init(audioChanCfg);
      return acc;
    });
  }
  function getAudioChannelConfigurationForRepresentation(representation) {
    if (!representation || !representation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO_CHANNEL_CONFIGURATION) || !representation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO_CHANNEL_CONFIGURATION].length) {
      return [];
    }
    return representation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AUDIO_CHANNEL_CONFIGURATION].map(audioChanCfg => {
      const acc = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      acc.init(audioChanCfg);
      return acc;
    });
  }
  function getRepresentationSortFunction() {
    return (a, b) => a.bandwidth - b.bandwidth;
  }
  function processAdaptation(realAdaptation) {
    if (realAdaptation && realAdaptation.Representation) {
      realAdaptation.Representation.sort(getRepresentationSortFunction());
    }
    return realAdaptation;
  }
  function getRealAdaptations(manifest, periodIndex) {
    return manifest && manifest.Period && isInteger(periodIndex) ? manifest.Period[periodIndex] ? manifest.Period[periodIndex].AdaptationSet : [] : [];
  }
  function getRealPeriods(manifest) {
    return manifest && manifest.Period ? manifest.Period : [];
  }
  function getRealPeriodForIndex(index, manifest) {
    const realPeriods = getRealPeriods(manifest);
    if (realPeriods.length > 0 && isInteger(index)) {
      return realPeriods[index];
    } else {
      return null;
    }
  }
  function getAdaptationForId(id, manifest, periodIndex) {
    const realAdaptations = getRealAdaptations(manifest, periodIndex);
    let i, len;
    for (i = 0, len = realAdaptations.length; i < len; i++) {
      if (realAdaptations[i].hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID) && realAdaptations[i].id === id) {
        return realAdaptations[i];
      }
    }
    return null;
  }
  function getAdaptationForIndex(index, manifest, periodIndex) {
    const realAdaptations = getRealAdaptations(manifest, periodIndex);
    if (realAdaptations.length > 0 && isInteger(index)) {
      return realAdaptations[index];
    } else {
      return null;
    }
  }
  function getIndexForAdaptation(realAdaptation, manifest, periodIndex) {
    if (!realAdaptation) {
      return -1;
    }
    const realAdaptations = getRealAdaptations(manifest, periodIndex);
    for (let i = 0; i < realAdaptations.length; i++) {
      let objectUtils = (0,_streaming_utils_ObjectUtils_js__WEBPACK_IMPORTED_MODULE_17__["default"])(context).getInstance();
      if (objectUtils.areEqual(realAdaptations[i], realAdaptation)) {
        return i;
      }
    }
    return -1;
  }
  function getAdaptationsForType(manifest, periodIndex, type) {
    const realAdaptations = getRealAdaptations(manifest, periodIndex);
    let i, len;
    const adaptations = [];
    for (i = 0, len = realAdaptations.length; i < len; i++) {
      if (getIsTypeOf(realAdaptations[i], type)) {
        adaptations.push(processAdaptation(realAdaptations[i]));
      }
    }
    return adaptations;
  }
  function getCodec(adaptation, representationIndex, addResolutionInfo) {
    let codec = null;
    if (adaptation && adaptation.Representation && adaptation.Representation.length > 0) {
      const representation = isInteger(representationIndex) && representationIndex >= 0 && representationIndex < adaptation.Representation.length ? adaptation.Representation[representationIndex] : adaptation.Representation[0];
      if (representation) {
        codec = representation.mimeType + ';codecs="' + representation.codecs + '"';
        if (addResolutionInfo && representation.width !== undefined) {
          codec += ';width="' + representation.width + '";height="' + representation.height + '"';
        }
      }
    }

    // If the codec contains a profiles parameter we remove it. Otherwise, it will cause problems when checking for codec capabilities of the platform
    if (codec) {
      codec = codec.replace(/\sprofiles=[^;]*/g, '');
    }
    return codec;
  }
  function getMimeType(adaptation) {
    return adaptation && adaptation.Representation && adaptation.Representation.length > 0 ? adaptation.Representation[0].mimeType : null;
  }
  function getSegmentAlignment(adaptation) {
    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_ALIGNMENT)) {
      return adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_ALIGNMENT] === 'true';
    }
    return false;
  }
  function getSubSegmentAlignment(adaptation) {
    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUB_SEGMENT_ALIGNMENT)) {
      return adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUB_SEGMENT_ALIGNMENT] === 'true';
    }
    return false;
  }
  function getLabelsForAdaptation(adaptation) {
    if (!adaptation || !adaptation.Label) {
      return [];
    }
    const labelArray = [];
    for (let i = 0; i < adaptation.Label.length; i++) {
      labelArray.push({
        lang: adaptation.Label[i].lang,
        text: adaptation.Label[i].__text || adaptation.Label[i]
      });
    }
    return labelArray;
  }
  function isPeriodEncrypted(period) {
    const contentProtectionElements = getContentProtectionByPeriod(period);
    return contentProtectionElements && contentProtectionElements.length > 0;
  }
  function getContentProtectionByManifest(manifest) {
    let protectionElements = [];
    if (!manifest) {
      return protectionElements;
    }
    const mpdElements = _getContentProtectionFromElement(manifest);
    protectionElements = protectionElements.concat(mpdElements);
    if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PERIOD) && manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PERIOD].length > 0) {
      manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PERIOD].forEach(period => {
        const curr = getContentProtectionByPeriod(period);
        protectionElements = protectionElements.concat(curr);
      });
    }
    return protectionElements;
  }
  function getContentProtectionByPeriod(period) {
    let protectionElements = [];
    if (!period) {
      return protectionElements;
    }
    const periodProtectionElements = _getContentProtectionFromElement(period);
    protectionElements = protectionElements.concat(periodProtectionElements);
    if (period.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ADAPTATION_SET) && period[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ADAPTATION_SET].length > 0) {
      period[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ADAPTATION_SET].forEach(as => {
        const curr = _getContentProtectionFromElement(as);
        protectionElements = protectionElements.concat(curr);
      });
    }
    return protectionElements;
  }
  function getContentProtectionByAdaptation(adaptation) {
    return _getContentProtectionFromElement(adaptation);
  }
  function _getContentProtectionFromElement(element) {
    if (!element || !element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CONTENT_PROTECTION) || element.ContentProtection.length === 0) {
      return [];
    }
    return element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CONTENT_PROTECTION].map(contentProtectionData => {
      const contentProtection = new _vo_ContentProtection_js__WEBPACK_IMPORTED_MODULE_5__["default"]();
      contentProtection.init(contentProtectionData);
      return contentProtection;
    });
  }
  function getIsDynamic(manifest) {
    let isDynamic = false;
    if (manifest && manifest.hasOwnProperty('type')) {
      isDynamic = manifest.type === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DYNAMIC;
    }
    return isDynamic;
  }
  function getId(manifest) {
    return manifest && manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID] || null;
  }
  function hasProfile(manifest, profile) {
    let has = false;
    if (manifest && manifest.profiles && manifest.profiles.length > 0) {
      has = manifest.profiles.indexOf(profile) !== -1;
    }
    return has;
  }
  function getDuration(manifest) {
    let mpdDuration;
    //@mediaPresentationDuration specifies the duration of the entire Media Presentation.
    //If the attribute is not present, the duration of the Media Presentation is unknown.
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MEDIA_PRESENTATION_DURATION)) {
      mpdDuration = manifest.mediaPresentationDuration;
    } else if (manifest && manifest.type == 'dynamic') {
      mpdDuration = Number.POSITIVE_INFINITY;
    } else {
      mpdDuration = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
    }
    return mpdDuration;
  }
  function getBandwidth(representation) {
    return representation && representation.bandwidth ? representation.bandwidth : NaN;
  }
  function getFramerate(realRepresentation) {
    if (!realRepresentation) {
      return null;
    }
    const frameRate = realRepresentation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].FRAMERATE];
    if (!frameRate) {
      return null;
    }
    if (typeof frameRate === 'string' && frameRate.includes('/')) {
      const [numerator, denominator] = frameRate.split('/').map(value => parseInt(value, 10));
      if (!isNaN(numerator) && !isNaN(denominator) && denominator !== 0) {
        return numerator / denominator;
      }
    }
    return parseInt(frameRate);
  }
  function getManifestUpdatePeriod(manifest) {
    let latencyOfLastUpdate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    let delay = NaN;
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MINIMUM_UPDATE_PERIOD)) {
      delay = manifest.minimumUpdatePeriod;
    }
    return isNaN(delay) ? delay : Math.max(delay - latencyOfLastUpdate, 1);
  }
  function getPublishTime(manifest) {
    return manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PUBLISH_TIME) ? new Date(manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PUBLISH_TIME]) : null;
  }
  function getRepresentationCount(adaptation) {
    return adaptation && adaptation.Representation ? adaptation.Representation.length : 0;
  }
  function getBitrateListForAdaptation(realAdaptation) {
    const processedRealAdaptation = processAdaptation(realAdaptation);
    const realRepresentations = processedRealAdaptation && processedRealAdaptation.Representation ? processedRealAdaptation.Representation : [];
    return realRepresentations.map(realRepresentation => {
      return {
        bandwidth: realRepresentation.bandwidth,
        width: realRepresentation.width || 0,
        height: realRepresentation.height || 0,
        scanType: realRepresentation.scanType || null,
        id: realRepresentation.id || null
      };
    });
  }
  function getSelectionPriority(realAdaption) {
    try {
      const priority = realAdaption && typeof realAdaption.selectionPriority !== 'undefined' ? parseInt(realAdaption.selectionPriority) : 1;
      return isNaN(priority) ? 1 : priority;
    } catch (e) {
      return 1;
    }
  }

  // propertyType is one of { DashConstants.ESSENTIAL_PROPERTY, DashConstants.SUPPLEMENTAL_PROPERTY }
  function _getProperties(propertyType, element) {
    if (!element || !element.hasOwnProperty(propertyType) || !element[propertyType].length) {
      return [];
    }
    return element[propertyType].map(property => {
      const s = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      s.init(property);
      return s;
    });
  }
  function _getPropertiesCommonToAllRepresentations(propertyType, repr) {
    if (!repr || !repr.length) {
      return [];
    }
    let propertiesOfFirstRepresentation = repr[0][propertyType] || [];
    if (propertiesOfFirstRepresentation.length === 0) {
      return [];
    }
    if (repr.length === 1) {
      return propertiesOfFirstRepresentation;
    }

    // now, only return properties present on all Representations
    // repr.legth is always >= 2
    return propertiesOfFirstRepresentation.filter(prop => {
      return repr.slice(1).every(currRep => {
        return currRep.hasOwnProperty(propertyType) && currRep[propertyType].some(e => {
          return e.schemeIdUri === prop.schemeIdUri && e.value === prop.value;
        });
      });
    });
  }
  function _getCombinedPropertiesForAdaptationSet(propertyType, adaptation) {
    if (!adaptation) {
      return [];
    }
    let allProperties = _getPropertiesCommonToAllRepresentations(propertyType, adaptation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].REPRESENTATION]);
    if (adaptation.hasOwnProperty(propertyType) && adaptation[propertyType].length) {
      allProperties.push(...adaptation[propertyType]);
    }
    // we don't check whether there are duplicates on AdaptationSets and Representations

    return allProperties.map(essentialProperty => {
      const s = new _vo_DescriptorType_js__WEBPACK_IMPORTED_MODULE_10__["default"]();
      s.init(essentialProperty);
      return s;
    });
  }
  function getEssentialPropertiesForAdaptationSet(adaptation) {
    return _getProperties(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ESSENTIAL_PROPERTY, adaptation);
  }
  function getCombinedEssentialPropertiesForAdaptationSet(adaptation) {
    return _getCombinedPropertiesForAdaptationSet(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ESSENTIAL_PROPERTY, adaptation);
  }
  function getEssentialPropertiesForRepresentation(realRepresentation) {
    return _getProperties(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ESSENTIAL_PROPERTY, realRepresentation);
  }
  function getSupplementalPropertiesForAdaptationSet(adaptation) {
    return _getProperties(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUPPLEMENTAL_PROPERTY, adaptation);
  }
  function getCombinedSupplementalPropertiesForAdaptationSet(adaptation) {
    return _getCombinedPropertiesForAdaptationSet(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUPPLEMENTAL_PROPERTY, adaptation);
  }
  function getSupplementalPropertiesForRepresentation(representation) {
    return _getProperties(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUPPLEMENTAL_PROPERTY, representation);
  }
  function getRepresentationFor(index, adaptation) {
    return adaptation && adaptation.Representation && adaptation.Representation.length > 0 && isInteger(index) ? adaptation.Representation[index] : null;
  }
  function getRealAdaptationFor(voAdaptation) {
    if (voAdaptation && voAdaptation.period && isInteger(voAdaptation.period.index)) {
      const periodArray = voAdaptation.period.mpd.manifest.Period[voAdaptation.period.index];
      if (periodArray && periodArray.AdaptationSet && isInteger(voAdaptation.index)) {
        return processAdaptation(periodArray.AdaptationSet[voAdaptation.index]);
      }
    }
  }
  function getRepresentationsForAdaptation(voAdaptation, mediaInfo) {
    const voRepresentations = [];
    const processedRealAdaptation = getRealAdaptationFor(voAdaptation);
    let segmentInfo, baseUrl;
    if (processedRealAdaptation && processedRealAdaptation.Representation) {
      // TODO: TO BE REMOVED. We should get just the baseUrl elements that affects to the representations
      // that we are processing. Making it works properly will require much further changes and given
      // parsing base Urls parameters is needed for our ultra low latency examples, we will
      // keep this "tricky" code until the real (and good) solution comes
      if (voAdaptation && voAdaptation.period && isInteger(voAdaptation.period.index)) {
        const baseUrls = getBaseURLsFromElement(voAdaptation.period.mpd.manifest);
        if (baseUrls) {
          baseUrl = baseUrls[0];
        }
      }
      for (let i = 0, len = processedRealAdaptation.Representation.length; i < len; ++i) {
        const realRepresentation = processedRealAdaptation.Representation[i];
        const voRepresentation = new _vo_Representation_js__WEBPACK_IMPORTED_MODULE_21__["default"]();
        voRepresentation.index = i;
        voRepresentation.adaptation = voAdaptation;
        voRepresentation.mediaInfo = mediaInfo;
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID)) {
          voRepresentation.id = realRepresentation.id;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CODECS)) {
          voRepresentation.codecs = realRepresentation.codecs;
          voRepresentation.codecFamily = _core_Utils_js__WEBPACK_IMPORTED_MODULE_24__["default"].getCodecFamily(voRepresentation.codecs);
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MIME_TYPE)) {
          voRepresentation.mimeType = realRepresentation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MIME_TYPE];
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CODEC_PRIVATE_DATA)) {
          voRepresentation.codecPrivateData = realRepresentation.codecPrivateData;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].BANDWITH)) {
          voRepresentation.bandwidth = realRepresentation.bandwidth;
          voRepresentation.bitrateInKbit = realRepresentation.bandwidth / 1000;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].WIDTH)) {
          voRepresentation.width = realRepresentation.width;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].HEIGHT)) {
          voRepresentation.height = realRepresentation.height;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SCAN_TYPE)) {
          voRepresentation.scanType = realRepresentation.scanType;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].FRAMERATE)) {
          voRepresentation.frameRate = getFramerate(realRepresentation);
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].QUALITY_RANKING)) {
          voRepresentation.qualityRanking = realRepresentation[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].QUALITY_RANKING];
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MAX_PLAYOUT_RATE)) {
          voRepresentation.maxPlayoutRate = realRepresentation.maxPlayoutRate;
        }
        if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_BASE)) {
          segmentInfo = realRepresentation.SegmentBase;
          voRepresentation.segmentInfoType = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_BASE;
        } else if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_LIST)) {
          segmentInfo = realRepresentation.SegmentList;
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE)) {
            voRepresentation.segmentInfoType = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE;
          } else {
            voRepresentation.segmentInfoType = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_LIST;
          }
        } else if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TEMPLATE)) {
          segmentInfo = realRepresentation.SegmentTemplate;
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE)) {
            voRepresentation.segmentInfoType = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE;
          } else {
            voRepresentation.segmentInfoType = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TEMPLATE;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].INITIALIZATION_MINUS)) {
            voRepresentation.initialization = segmentInfo.initialization.split('$Bandwidth$').join(realRepresentation.bandwidth).split('$RepresentationID$').join(realRepresentation.id);
          }
        } else {
          voRepresentation.segmentInfoType = _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].BASE_URL;
        }
        voRepresentation.essentialProperties = getEssentialPropertiesForRepresentation(realRepresentation);
        voRepresentation.supplementalProperties = getSupplementalPropertiesForRepresentation(realRepresentation);
        if (segmentInfo) {
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].INITIALIZATION)) {
            const initialization = segmentInfo.Initialization;
            if (initialization.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SOURCE_URL)) {
              voRepresentation.initialization = initialization.sourceURL;
            }
            if (initialization.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].RANGE)) {
              voRepresentation.range = initialization.range;
              // initialization source url will be determined from
              // BaseURL when resolved at load time.
            }
          } else if (getIsText(processedRealAdaptation) && getIsFragmented(processedRealAdaptation) && processedRealAdaptation.mimeType && processedRealAdaptation.mimeType.indexOf('application/mp4') === -1) {
            voRepresentation.range = 0;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TIMESCALE)) {
            voRepresentation.timescale = segmentInfo.timescale;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DURATION)) {
            // TODO according to the spec @maxSegmentDuration specifies the maximum duration of any Segment in any Representation in the Media Presentation
            // It is also said that for a SegmentTimeline any @d value shall not exceed the value of MPD@maxSegmentDuration, but nothing is said about
            // SegmentTemplate @duration attribute. We need to find out if @maxSegmentDuration should be used instead of calculated duration if the the duration
            // exceeds @maxSegmentDuration
            voRepresentation.segmentDuration = segmentInfo.duration / voRepresentation.timescale;
          } else if (realRepresentation.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TEMPLATE)) {
            segmentInfo = realRepresentation.SegmentTemplate;
            if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SEGMENT_TIMELINE)) {
              voRepresentation.segmentDuration = calcSegmentDuration(segmentInfo.SegmentTimeline) / voRepresentation.timescale;
            }
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MEDIA)) {
            voRepresentation.media = segmentInfo.media;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].START_NUMBER)) {
            voRepresentation.startNumber = parseInt(segmentInfo.startNumber);
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].INDEX_RANGE)) {
            voRepresentation.indexRange = segmentInfo.indexRange;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME_OFFSET)) {
            voRepresentation.presentationTimeOffset = segmentInfo.presentationTimeOffset / voRepresentation.timescale;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_TIME_OFFSET)) {
            voRepresentation.availabilityTimeOffset = segmentInfo.availabilityTimeOffset;
          } else if (baseUrl && baseUrl.availabilityTimeOffset !== undefined) {
            voRepresentation.availabilityTimeOffset = baseUrl.availabilityTimeOffset;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_TIME_COMPLETE)) {
            voRepresentation.availabilityTimeComplete = segmentInfo.availabilityTimeComplete !== 'false';
          } else if (baseUrl && baseUrl.availabilityTimeComplete !== undefined) {
            voRepresentation.availabilityTimeComplete = baseUrl.availabilityTimeComplete;
          }
          if (segmentInfo.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].END_NUMBER)) {
            voRepresentation.endNumber = segmentInfo[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].END_NUMBER];
          }
        }
        voRepresentation.mseTimeOffset = calcMseTimeOffset(voRepresentation);
        voRepresentation.path = [voAdaptation.period.index, voAdaptation.index, i];
        if (!isNaN(voRepresentation.width) && !isNaN(voRepresentation.height) && !isNaN(voRepresentation.frameRate)) {
          voRepresentation.pixelsPerSecond = Math.max(1, voRepresentation.width * voRepresentation.height * voRepresentation.frameRate);
          if (!isNaN(voRepresentation.bandwidth)) {
            voRepresentation.bitsPerPixel = voRepresentation.bandwidth / voRepresentation.pixelsPerSecond;
          }
        }
        voRepresentations.push(voRepresentation);
      }
    }
    return voRepresentations;
  }
  function calcSegmentDuration(segmentTimeline) {
    if (!segmentTimeline || !segmentTimeline.S) {
      return NaN;
    }
    let s0 = segmentTimeline.S[0];
    let s1 = segmentTimeline.S[1];
    return s0.hasOwnProperty('d') ? s0.d : s1.t - s0.t;
  }
  function calcMseTimeOffset(representation) {
    // The MSEOffset is offset from AST for media. It is Period@start - presentationTimeOffset
    const presentationOffset = representation.presentationTimeOffset;
    const periodStart = representation.adaptation.period.start;
    return periodStart - presentationOffset;
  }
  function getAdaptationsForPeriod(voPeriod) {
    const realPeriod = voPeriod && isInteger(voPeriod.index) ? voPeriod.mpd.manifest.Period[voPeriod.index] : null;
    const voAdaptations = [];
    let voAdaptationSet, realAdaptationSet, i;
    if (realPeriod && realPeriod.AdaptationSet) {
      for (i = 0; i < realPeriod.AdaptationSet.length; i++) {
        realAdaptationSet = realPeriod.AdaptationSet[i];
        voAdaptationSet = new _vo_AdaptationSet_js__WEBPACK_IMPORTED_MODULE_0__["default"]();
        if (realAdaptationSet.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID)) {
          voAdaptationSet.id = realAdaptationSet.id;
        }
        voAdaptationSet.index = i;
        voAdaptationSet.period = voPeriod;
        if (getIsMuxed(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].MUXED;
        } else if (getIsAudio(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].AUDIO;
        } else if (getIsVideo(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].VIDEO;
        } else if (getIsText(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].TEXT;
        } else if (getIsImage(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].IMAGE;
        } else {
          logger.warn('Unknown Adaptation stream type');
        }
        voAdaptations.push(voAdaptationSet);
      }
    }
    return voAdaptations;
  }
  function getRegularPeriods(mpd) {
    const isDynamic = mpd ? getIsDynamic(mpd.manifest) : false;
    const voPeriods = [];
    let realPreviousPeriod = null;
    let realPeriod = null;
    let voPreviousPeriod = null;
    let voPeriod = null;
    let len, i;
    for (i = 0, len = mpd && mpd.manifest && mpd.manifest.Period ? mpd.manifest.Period.length : 0; i < len; i++) {
      realPeriod = mpd.manifest.Period[i];

      // If the attribute @start is present in the Period, then the
      // Period is a regular Period and the PeriodStart is equal
      // to the value of this attribute.
      if (realPeriod.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].START)) {
        voPeriod = new _vo_Period_js__WEBPACK_IMPORTED_MODULE_19__["default"]();
        voPeriod.start = realPeriod.start;
      }
      // If the @start attribute is absent, but the previous Period element contains a @duration attribute then this new Period is also a regular Period. The start time of the new Period PeriodStart is the sum of the start time of the previous Period PeriodStart and the value of the attribute @duration of the previous Period.
      else if (realPreviousPeriod !== null && realPreviousPeriod.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DURATION) && voPreviousPeriod !== null) {
        voPeriod = new _vo_Period_js__WEBPACK_IMPORTED_MODULE_19__["default"]();
        voPeriod.start = parseFloat((voPreviousPeriod.start + voPreviousPeriod.duration).toFixed(5));
      }
      // If (i) @start attribute is absent, and (ii) the Period element is the first in the MPD, and (iii) the MPD@type is 'static', then the PeriodStart time shall be set to zero.
      else if (i === 0 && !isDynamic) {
        voPeriod = new _vo_Period_js__WEBPACK_IMPORTED_MODULE_19__["default"]();
        voPeriod.start = 0;
      }

      // The Period extends until the PeriodStart of the next Period.
      // The difference between the PeriodStart time of a Period and
      // the PeriodStart time of the following Period.
      if (voPreviousPeriod !== null && isNaN(voPreviousPeriod.duration)) {
        if (voPeriod !== null) {
          voPreviousPeriod.duration = parseFloat((voPeriod.start - voPreviousPeriod.start).toFixed(5));
        } else {
          logger.warn('First period duration could not be calculated because lack of start and duration period properties. This will cause timing issues during playback');
        }
      }
      if (voPeriod !== null) {
        voPeriod.id = getPeriodId(realPeriod, i);
        voPeriod.index = i;
        voPeriod.mpd = mpd;
        voPeriod.isEncrypted = isPeriodEncrypted(realPeriod);
        if (realPeriod.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DURATION)) {
          voPeriod.duration = realPeriod.duration;
        }
        if (voPreviousPeriod) {
          voPreviousPeriod.nextPeriodId = voPeriod.id;
        }
        voPeriods.push(voPeriod);
        realPreviousPeriod = realPeriod;
        voPreviousPeriod = voPeriod;
      }
      realPeriod = null;
      voPeriod = null;
    }
    if (voPeriods.length === 0) {
      return voPeriods;
    }

    // The last Period extends until the end of the Media Presentation.
    // The difference between the PeriodStart time of the last Period
    // and the mpd duration
    if (voPreviousPeriod !== null && isNaN(voPreviousPeriod.duration)) {
      voPreviousPeriod.duration = parseFloat((getEndTimeForLastPeriod(voPreviousPeriod) - voPreviousPeriod.start).toFixed(5));
    }
    return voPeriods;
  }
  function getPeriodId(realPeriod, i) {
    if (!realPeriod) {
      throw new Error('Period cannot be null or undefined');
    }
    let id = _vo_Period_js__WEBPACK_IMPORTED_MODULE_19__["default"].DEFAULT_ID + '_' + i;
    if (realPeriod.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID) && realPeriod.id.toString().length > 0 && realPeriod.id !== '__proto__') {
      id = realPeriod.id.toString();
    }
    return id;
  }
  function getMpd(manifest) {
    const mpd = new _vo_Mpd_js__WEBPACK_IMPORTED_MODULE_15__["default"]();
    if (manifest) {
      mpd.manifest = manifest;
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_START_TIME)) {
        mpd.availabilityStartTime = new Date(manifest.availabilityStartTime.getTime());
      } else {
        if (manifest.loadedTime) {
          mpd.availabilityStartTime = new Date(manifest.loadedTime.getTime());
        }
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_END_TIME)) {
        mpd.availabilityEndTime = new Date(manifest.availabilityEndTime.getTime());
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MINIMUM_UPDATE_PERIOD)) {
        mpd.minimumUpdatePeriod = manifest.minimumUpdatePeriod;
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MEDIA_PRESENTATION_DURATION)) {
        mpd.mediaPresentationDuration = manifest.mediaPresentationDuration;
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUGGESTED_PRESENTATION_DELAY)) {
        mpd.suggestedPresentationDelay = manifest.suggestedPresentationDelay;
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TIMESHIFT_BUFFER_DEPTH)) {
        mpd.timeShiftBufferDepth = manifest.timeShiftBufferDepth;
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].MAX_SEGMENT_DURATION)) {
        mpd.maxSegmentDuration = manifest.maxSegmentDuration;
      }
      if (manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PUBLISH_TIME)) {
        mpd.publishTime = new Date(manifest.publishTime);
      }
    }
    return mpd;
  }
  function checkConfig() {
    if (!errHandler || !errHandler.hasOwnProperty('error')) {
      throw new Error(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].MISSING_CONFIG_ERROR);
    }
  }
  function getEndTimeForLastPeriod(voPeriod) {
    checkConfig();
    const isDynamic = getIsDynamic(voPeriod.mpd.manifest);
    let periodEnd;
    if (voPeriod.mpd.manifest.mediaPresentationDuration) {
      periodEnd = voPeriod.mpd.manifest.mediaPresentationDuration;
    } else if (voPeriod.duration) {
      periodEnd = voPeriod.duration;
    } else if (isDynamic) {
      periodEnd = Number.POSITIVE_INFINITY;
    } else {
      errHandler.error(new _streaming_vo_DashJSError_js__WEBPACK_IMPORTED_MODULE_8__["default"](_core_errors_Errors_js__WEBPACK_IMPORTED_MODULE_11__["default"].MANIFEST_ERROR_ID_PARSE_CODE, 'Must have @mediaPresentationDuration on MPD or an explicit @duration on the last period.', voPeriod));
    }
    return periodEnd;
  }
  function getEventsForPeriod(period) {
    const manifest = period && period.mpd && period.mpd.manifest ? period.mpd.manifest : null;
    const periodArray = manifest ? manifest.Period : null;
    const eventStreams = periodArray && period && isInteger(period.index) ? periodArray[period.index].EventStream : null;
    const events = [];
    let i, j;
    if (eventStreams) {
      for (i = 0; i < eventStreams.length; i++) {
        const eventStream = new _vo_EventStream_js__WEBPACK_IMPORTED_MODULE_13__["default"]();
        eventStream.period = period;
        eventStream.timescale = 1;
        if (eventStreams[i].hasOwnProperty(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SCHEME_ID_URI)) {
          eventStream.schemeIdUri = eventStreams[i][_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SCHEME_ID_URI];
        } else {
          throw new Error('Invalid EventStream. SchemeIdUri has to be set');
        }
        if (eventStreams[i].hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TIMESCALE)) {
          eventStream.timescale = eventStreams[i][_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TIMESCALE];
        }
        if (eventStreams[i].hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VALUE)) {
          eventStream.value = eventStreams[i][_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VALUE];
        }
        if (eventStreams[i].hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME_OFFSET)) {
          eventStream.presentationTimeOffset = eventStreams[i][_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME_OFFSET];
        }
        for (j = 0; eventStreams[i].Event && j < eventStreams[i].Event.length; j++) {
          const currentMpdEvent = eventStreams[i].Event[j];
          const event = new _vo_Event_js__WEBPACK_IMPORTED_MODULE_12__["default"]();
          event.presentationTime = 0;
          event.eventStream = eventStream;
          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PRESENTATION_TIME)) {
            event.presentationTime = currentMpdEvent.presentationTime;
          }
          const presentationTimeOffset = eventStream.presentationTimeOffset ? eventStream.presentationTimeOffset / eventStream.timescale : 0;
          event.calculatedPresentationTime = event.presentationTime / eventStream.timescale + period.start - presentationTimeOffset;
          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DURATION)) {
            event.duration = currentMpdEvent.duration / eventStream.timescale;
          }
          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID)) {
            event.id = parseInt(currentMpdEvent.id);
          } else {
            event.id = null;
          }
          if (currentMpdEvent.Signal && currentMpdEvent.Signal.Binary) {
            // toString is used to manage both regular and namespaced tags
            event.messageData = BASE64.decodeArray(currentMpdEvent.Signal.Binary.toString());
          } else {
            // From Cor.1: 'NOTE: this attribute is an alternative
            // to specifying a complete XML element(s) in the Event.
            // It is useful when an event leans itself to a compact
            // string representation'.
            event.messageData = currentMpdEvent.messageData || currentMpdEvent.__cdata || currentMpdEvent.__text;
          }
          events.push(event);
        }
      }
    }
    return events;
  }
  function getEventStreams(inbandStreams, representation, period) {
    const eventStreams = [];
    let i;
    if (!inbandStreams) {
      return eventStreams;
    }
    for (i = 0; i < inbandStreams.length; i++) {
      const eventStream = new _vo_EventStream_js__WEBPACK_IMPORTED_MODULE_13__["default"]();
      eventStream.timescale = 1;
      eventStream.representation = representation;
      if (inbandStreams[i].hasOwnProperty(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SCHEME_ID_URI)) {
        eventStream.schemeIdUri = inbandStreams[i].schemeIdUri;
      } else {
        throw new Error('Invalid EventStream. SchemeIdUri has to be set');
      }
      if (inbandStreams[i].hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TIMESCALE)) {
        eventStream.timescale = inbandStreams[i].timescale;
      }
      if (inbandStreams[i].hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VALUE)) {
        eventStream.value = inbandStreams[i].value;
      }
      eventStreams.push(eventStream);
      eventStream.period = period;
    }
    return eventStreams;
  }
  function getEventStreamForAdaptationSet(manifest, adaptation, period) {
    let inbandStreams, periodArray, adaptationArray;
    if (manifest && manifest.Period && adaptation && adaptation.period && isInteger(adaptation.period.index)) {
      periodArray = manifest.Period[adaptation.period.index];
      if (periodArray && periodArray.AdaptationSet && isInteger(adaptation.index)) {
        adaptationArray = periodArray.AdaptationSet[adaptation.index];
        if (adaptationArray) {
          inbandStreams = adaptationArray.InbandEventStream;
        }
      }
    }
    return getEventStreams(inbandStreams, null, period);
  }
  function getEventStreamForRepresentation(manifest, representation, period) {
    let inbandStreams, periodArray, adaptationArray, representationArray;
    if (manifest && manifest.Period && representation && representation.adaptation && representation.adaptation.period && isInteger(representation.adaptation.period.index)) {
      periodArray = manifest.Period[representation.adaptation.period.index];
      if (periodArray && periodArray.AdaptationSet && isInteger(representation.adaptation.index)) {
        adaptationArray = periodArray.AdaptationSet[representation.adaptation.index];
        if (adaptationArray && adaptationArray.Representation && isInteger(representation.index)) {
          representationArray = adaptationArray.Representation[representation.index];
          if (representationArray) {
            inbandStreams = representationArray.InbandEventStream;
          }
        }
      }
    }
    return getEventStreams(inbandStreams, representation, period);
  }
  function getUTCTimingSources(manifest) {
    const isDynamic = getIsDynamic(manifest);
    const hasAST = manifest ? manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_START_TIME) : false;
    const utcTimingsArray = manifest ? manifest.UTCTiming : null;
    const utcTimingEntries = [];

    // do not bother synchronizing the clock unless MPD is live,
    // or it is static and has availabilityStartTime attribute
    if (isDynamic || hasAST) {
      if (utcTimingsArray) {
        // the order is important here - 23009-1 states that the order
        // in the manifest "indicates relative preference, first having
        // the highest, and the last the lowest priority".
        utcTimingsArray.forEach(function (utcTiming) {
          const entry = new _vo_UTCTiming_js__WEBPACK_IMPORTED_MODULE_23__["default"]();
          if (utcTiming.hasOwnProperty(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].SCHEME_ID_URI)) {
            entry.schemeIdUri = utcTiming.schemeIdUri;
          } else {
            // entries of type DescriptorType with no schemeIdUri
            // are meaningless. let's just ignore this entry and
            // move on.
            return;
          }

          // this is (incorrectly) interpreted as a number - schema
          // defines it as a string
          if (utcTiming.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].VALUE)) {
            entry.value = utcTiming.value.toString();
          } else {
            // without a value, there's not a lot we can do with
            // this entry. let's just ignore this one and move on
            return;
          }

          // we're not interested in the optional id or any other
          // attributes which might be attached to the entry

          utcTimingEntries.push(entry);
        });
      }
    }
    return utcTimingEntries;
  }
  function getBaseURLsFromElement(node) {
    const baseUrls = [];
    // if node.BaseURL and node.baseUri are undefined entries
    // will be [undefined] which entries.some will just skip
    const entries = node.BaseURL || [node.baseUri];
    let earlyReturn = false;
    entries.some(entry => {
      if (entry) {
        const baseUrl = new _vo_BaseURL_js__WEBPACK_IMPORTED_MODULE_1__["default"]();
        let text = entry.__text || entry;
        if (urlUtils.isRelative(text)) {
          // it doesn't really make sense to have relative and
          // absolute URLs at the same level, or multiple
          // relative URLs at the same level, so assume we are
          // done from this level of the MPD
          earlyReturn = true;

          // deal with the specific case where the MPD@BaseURL
          // is specified and is relative. when no MPD@BaseURL
          // entries exist, that case is handled by the
          // [node.baseUri] in the entries definition.
          if (node.baseUri) {
            text = urlUtils.resolve(text, node.baseUri);
          }
        }
        baseUrl.url = text;

        // serviceLocation is optional, but we need it in order
        // to blacklist correctly. if it's not available, use
        // anything unique since there's no relationship to any
        // other BaseURL and, in theory, the url should be
        // unique so use this instead.
        if (entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATION) && entry.serviceLocation.length) {
          baseUrl.serviceLocation = entry.serviceLocation;
        } else {
          baseUrl.serviceLocation = text;
        }
        if (entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DVB_PRIORITY)) {
          baseUrl.dvbPriority = entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DVB_PRIORITY];
        }
        if (entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DVB_WEIGHT)) {
          baseUrl.dvbWeight = entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DVB_WEIGHT];
        }
        if (entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_TIME_OFFSET)) {
          baseUrl.availabilityTimeOffset = entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_TIME_OFFSET];
        }
        if (entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_TIME_COMPLETE)) {
          baseUrl.availabilityTimeComplete = entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_TIME_COMPLETE] !== 'false';
        }
        /* NOTE: byteRange currently unused
         */

        baseUrls.push(baseUrl);
        return earlyReturn;
      }
    });
    return baseUrls;
  }
  function getContentSteering(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CONTENT_STEERING)) {
      // Only one ContentSteering element is supported on MPD level
      const element = manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CONTENT_STEERING][0];
      return _createContentSteeringInstance(element);
    }
    return undefined;
  }
  function _createContentSteeringInstance(element) {
    const entry = new _vo_ContentSteering_js__WEBPACK_IMPORTED_MODULE_6__["default"]();
    entry.serverUrl = element.__text;
    if (element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DEFAULT_SERVICE_LOCATION)) {
      entry.defaultServiceLocation = element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].DEFAULT_SERVICE_LOCATION];
      entry.defaultServiceLocationArray = entry.defaultServiceLocation.split(' ');
    }
    if (element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].QUERY_BEFORE_START)) {
      entry.queryBeforeStart = element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].QUERY_BEFORE_START].toLowerCase() === 'true';
    }
    if (element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CLIENT_REQUIREMENT)) {
      entry.clientRequirement = element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CLIENT_REQUIREMENT].toLowerCase() !== 'false';
    }
    return entry;
  }
  function _createClientDataReportingInstance(element) {
    const entry = new _vo_ClientDataReporting_js__WEBPACK_IMPORTED_MODULE_3__["default"]();
    if (element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CMCD_PARAMETERS) && element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CMCD_PARAMETERS].schemeIdUri === _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_4__["default"].CTA_5004_2023_SCHEME) {
      entry.cmcdParameters = new _vo_CMCDParameters_js__WEBPACK_IMPORTED_MODULE_2__["default"]();
      entry.cmcdParameters.init(element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CMCD_PARAMETERS]);
    }
    if (element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATIONS) && element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATIONS] !== '') {
      entry.serviceLocations = element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATIONS];
      entry.serviceLocationsArray = entry.serviceLocations.toString().split(' ');
    }
    if (element.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ADAPTATION_SETS) && element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ADAPTATION_SETS] !== '') {
      entry.adaptationSets = element[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ADAPTATION_SETS];
      entry.adaptationSetsArray = entry.adaptationSets.toString().split(' ');
    }
    return entry;
  }
  function getLocation(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].LOCATION)) {
      return manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].LOCATION].map(entry => {
        const text = entry.__text || entry;
        const serviceLocation = entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATION) ? entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATION] : null;
        return new _vo_MpdLocation_js__WEBPACK_IMPORTED_MODULE_16__["default"](text, serviceLocation);
      });
    }
    return [];
  }
  function getPatchLocation(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PATCH_LOCATION)) {
      return manifest[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].PATCH_LOCATION].map(entry => {
        const text = entry.__text || entry;
        const serviceLocation = entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATION) ? entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_LOCATION] : null;
        let ttl = entry.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TTL) ? parseFloat(entry[_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].TTL]) * 1000 : NaN;
        return new _vo_PatchLocation_js__WEBPACK_IMPORTED_MODULE_18__["default"](text, serviceLocation, ttl);
      });
    }
    return [];
  }
  function getSuggestedPresentationDelay(mpd) {
    return mpd && mpd.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SUGGESTED_PRESENTATION_DELAY) ? mpd.suggestedPresentationDelay : null;
  }
  function getAvailabilityStartTime(mpd) {
    return mpd && mpd.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].AVAILABILITY_START_TIME) && mpd.availabilityStartTime !== null ? mpd.availabilityStartTime.getTime() : null;
  }
  function getServiceDescriptions(manifest) {
    const serviceDescriptions = [];
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_DESCRIPTION)) {
      for (const sd of manifest.ServiceDescription) {
        // Convert each of the properties defined in
        let id = null,
          schemeIdUri = null,
          latency = null,
          playbackRate = null,
          operatingQuality = null,
          operatingBandwidth = null,
          contentSteering = null,
          clientDataReporting = null;
        for (const prop in sd) {
          if (sd.hasOwnProperty(prop)) {
            if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].ID) {
              id = sd[prop];
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_DESCRIPTION_SCOPE) {
              schemeIdUri = sd[prop].schemeIdUri;
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_DESCRIPTION_LATENCY) {
              latency = {
                target: parseInt(sd[prop].target),
                max: parseInt(sd[prop].max),
                min: parseInt(sd[prop].min),
                referenceId: parseInt(sd[prop].referenceId)
              };
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_DESCRIPTION_PLAYBACK_RATE) {
              playbackRate = {
                max: parseFloat(sd[prop].max),
                min: parseFloat(sd[prop].min)
              };
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_DESCRIPTION_OPERATING_QUALITY) {
              operatingQuality = {
                mediaType: sd[prop].mediaType,
                max: parseInt(sd[prop].max),
                min: parseInt(sd[prop].min),
                target: parseInt(sd[prop].target),
                type: sd[prop].type,
                maxQualityDifference: parseInt(sd[prop].maxQualityDifference)
              };
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].SERVICE_DESCRIPTION_OPERATING_BANDWIDTH) {
              operatingBandwidth = {
                mediaType: sd[prop].mediaType,
                max: parseInt(sd[prop].max),
                min: parseInt(sd[prop].min),
                target: parseInt(sd[prop].target)
              };
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CONTENT_STEERING) {
              let element = sd[prop];
              element = Array.isArray(element) ? element.at(element.length - 1) : element;
              contentSteering = _createContentSteeringInstance(element);
            } else if (prop === _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_7__["default"].CLIENT_DATA_REPORTING) {
              clientDataReporting = _createClientDataReportingInstance(sd[prop]);
            }
          }
        }
        serviceDescriptions.push({
          id,
          schemeIdUri,
          latency,
          playbackRate,
          operatingQuality,
          operatingBandwidth,
          contentSteering,
          clientDataReporting
        });
      }
    }
    return serviceDescriptions;
  }
  function setConfig(config) {
    if (!config) {
      return;
    }
    if (config.errHandler) {
      errHandler = config.errHandler;
    }
    if (config.BASE64) {
      BASE64 = config.BASE64;
    }
  }
  instance = {
    getAccessibilityForAdaptation,
    getAdaptationForId,
    getAdaptationForIndex,
    getAdaptationsForPeriod,
    getAdaptationsForType,
    getAudioChannelConfigurationForAdaptation,
    getAudioChannelConfigurationForRepresentation,
    getAvailabilityStartTime,
    getBandwidth,
    getBaseURLsFromElement,
    getBitrateListForAdaptation,
    getCodec,
    getCombinedEssentialPropertiesForAdaptationSet,
    getCombinedSupplementalPropertiesForAdaptationSet,
    getContentProtectionByAdaptation,
    getContentProtectionByManifest,
    getContentProtectionByPeriod,
    getContentSteering,
    getDuration,
    getEssentialPropertiesForAdaptationSet,
    getEssentialPropertiesForRepresentation,
    getEventStreamForAdaptationSet,
    getEventStreamForRepresentation,
    getEventsForPeriod,
    getFramerate,
    getId,
    getIndexForAdaptation,
    getIsDynamic,
    getIsFragmented,
    getIsText,
    getIsTypeOf,
    getLabelsForAdaptation,
    getLanguageForAdaptation,
    getLocation,
    getManifestUpdatePeriod,
    getMimeType,
    getMpd,
    getPatchLocation,
    getProducerReferenceTimesForAdaptation,
    getPublishTime,
    getRealPeriodForIndex,
    getRealPeriods,
    getRegularPeriods,
    getRepresentationCount,
    getRepresentationFor,
    getRepresentationSortFunction,
    getRepresentationsForAdaptation,
    getRolesForAdaptation,
    getSegmentAlignment,
    getSelectionPriority,
    getServiceDescriptions,
    getSubSegmentAlignment,
    getSuggestedPresentationDelay,
    getSupplementalPropertiesForAdaptationSet,
    getSupplementalPropertiesForRepresentation,
    getUTCTimingSources,
    getViewpointForAdaptation,
    hasProfile,
    isPeriodEncrypted,
    setConfig
  };
  setup();
  return instance;
}
DashManifestModel.__dashjs_factory_name = 'DashManifestModel';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_14__["default"].getSingletonFactory(DashManifestModel));

/***/ }),

/***/ "./src/dash/parser/DashParser.js":
/*!***************************************!*\
  !*** ./src/dash/parser/DashParser.js ***!
  \***************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _objectiron_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./objectiron.js */ "./src/dash/parser/objectiron.js");
/* harmony import */ var _matchers_DurationMatcher_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./matchers/DurationMatcher.js */ "./src/dash/parser/matchers/DurationMatcher.js");
/* harmony import */ var _matchers_DateTimeMatcher_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./matchers/DateTimeMatcher.js */ "./src/dash/parser/matchers/DateTimeMatcher.js");
/* harmony import */ var _matchers_NumericMatcher_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./matchers/NumericMatcher.js */ "./src/dash/parser/matchers/NumericMatcher.js");
/* harmony import */ var _matchers_LangMatcher_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./matchers/LangMatcher.js */ "./src/dash/parser/matchers/LangMatcher.js");
/* harmony import */ var _maps_RepresentationBaseValuesMap_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./maps/RepresentationBaseValuesMap.js */ "./src/dash/parser/maps/RepresentationBaseValuesMap.js");
/* harmony import */ var _maps_SegmentValuesMap_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./maps/SegmentValuesMap.js */ "./src/dash/parser/maps/SegmentValuesMap.js");
/* harmony import */ var _externals_tXml_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../externals/tXml.js */ "./externals/tXml.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */











// List of node that shall be represented as arrays
const arrayNodes = [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].BASE_URL, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_PROTECTION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_CHANNEL_CONFIGURATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_COMPONENT, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LABEL, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].S, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_URL, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT_STREAM, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LOCATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].METRICS, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REPORTING, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].PATCH_LOCATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REPLACE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ADD, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REMOVE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].UTC_TIMING, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND_EVENT_STREAM, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCER_REFERENCE_TIME, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_STEERING];
function DashParser(config) {
  config = config || {};
  const context = this.context;
  const debug = config.debug;
  let instance, logger, matchers, objectIron;
  function setup() {
    logger = debug.getLogger(instance);
    matchers = [new _matchers_DurationMatcher_js__WEBPACK_IMPORTED_MODULE_3__["default"](), new _matchers_DateTimeMatcher_js__WEBPACK_IMPORTED_MODULE_4__["default"](), new _matchers_NumericMatcher_js__WEBPACK_IMPORTED_MODULE_5__["default"](), new _matchers_LangMatcher_js__WEBPACK_IMPORTED_MODULE_6__["default"]()];
    objectIron = (0,_objectiron_js__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
      adaptationset: new _maps_RepresentationBaseValuesMap_js__WEBPACK_IMPORTED_MODULE_7__["default"](),
      period: new _maps_SegmentValuesMap_js__WEBPACK_IMPORTED_MODULE_8__["default"]()
    });
  }
  function getIron() {
    return objectIron;
  }
  function parse(data) {
    let manifest;
    const startTime = window.performance.now();
    manifest = parseXml(data);
    if (!manifest) {
      throw new Error('failed to parse the manifest');
    }

    // handle full MPD and Patch ironing separately
    if (manifest.Patch) {
      manifest = manifest.Patch; // drop root reference
      // apply iron to patch operations individually
      if (manifest.add) {
        manifest.add.forEach(operand => objectIron.run(operand));
      }
      if (manifest.replace) {
        manifest.replace.forEach(operand => objectIron.run(operand));
      }
      // note that we don't need to iron remove as they contain no children
    } else {
      manifest = manifest.MPD; // drop root reference
      objectIron.run(manifest);
    }
    const parsedTime = window.performance.now();
    logger.info('Parsing complete: ' + (parsedTime - startTime).toPrecision(3) + 'ms');
    manifest.protocol = 'DASH';
    return manifest;
  }
  function parseXml(data) {
    try {
      let root = _externals_tXml_js__WEBPACK_IMPORTED_MODULE_9__.parse(data, {
        parseNode: true,
        attrMatchers: matchers,
        nodesAsArray: arrayNodes
      });
      let ret = {};
      // If root element is xml node, then get first child node as root
      if (root.tagName.toLowerCase().indexOf('xml') !== -1) {
        for (let key in root) {
          if (Array.isArray(root[key])) {
            ret[key] = root[key][0];
            break;
          } else if (typeof root[key] === 'object') {
            ret[key] = root[key];
            break;
          }
        }
      } else {
        ret[root.tagName] = root;
        delete root.tagName;
      }
      return ret;
    } catch (e) {
      return null;
    }
  }
  instance = {
    getIron: getIron,
    parseXml: parseXml,
    parse: parse
  };
  setup();
  return instance;
}
DashParser.__dashjs_factory_name = 'DashParser';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(DashParser));

/***/ }),

/***/ "./src/dash/parser/maps/CommonProperty.js":
/*!************************************************!*\
  !*** ./src/dash/parser/maps/CommonProperty.js ***!
  \************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc a property belonging to a MapNode
 * @ignore
 */

class CommonProperty {
  constructor(name) {
    const getDefaultMergeForName = n => n && n.length && n.charAt(0) === n.charAt(0).toUpperCase();
    this._name = name;
    this._merge = getDefaultMergeForName(name);
  }
  get name() {
    return this._name;
  }
  get merge() {
    return this._merge;
  }
}
/* harmony default export */ __webpack_exports__["default"] = (CommonProperty);

/***/ }),

/***/ "./src/dash/parser/maps/MapNode.js":
/*!*****************************************!*\
  !*** ./src/dash/parser/maps/MapNode.js ***!
  \*****************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CommonProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CommonProperty.js */ "./src/dash/parser/maps/CommonProperty.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc a node at some level in a ValueMap
 */

class MapNode {
  constructor(name, properties, children) {
    this._name = name || '';
    this._properties = [];
    this._children = children || [];
    if (Array.isArray(properties)) {
      properties.forEach(p => {
        this._properties.push(new _CommonProperty_js__WEBPACK_IMPORTED_MODULE_0__["default"](p));
      });
    }
  }
  get name() {
    return this._name;
  }
  get children() {
    return this._children;
  }
  get properties() {
    return this._properties;
  }
}
/* harmony default export */ __webpack_exports__["default"] = (MapNode);

/***/ }),

/***/ "./src/dash/parser/maps/RepresentationBaseValuesMap.js":
/*!*************************************************************!*\
  !*** ./src/dash/parser/maps/RepresentationBaseValuesMap.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _MapNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MapNode.js */ "./src/dash/parser/maps/MapNode.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc a RepresentationBaseValuesMap type for input to objectiron
 */


class RepresentationBaseValuesMap extends _MapNode_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    const commonProperties = [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].WIDTH, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].HEIGHT, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SAR, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].FRAMERATE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_SAMPLING_RATE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_PROFILES, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].MAXIMUM_SAP_PERIOD, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].START_WITH_SAP, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_PLAYOUT_RATE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CODING_DEPENDENCY, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SCAN_TYPE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].FRAME_PACKING, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_CHANNEL_CONFIGURATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_PROTECTION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND_EVENT_STREAM];
    super(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, commonProperties, [new _MapNode_js__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, commonProperties, [new _MapNode_js__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SUB_REPRESENTATION, commonProperties)])]);
  }
}
/* harmony default export */ __webpack_exports__["default"] = (RepresentationBaseValuesMap);

/***/ }),

/***/ "./src/dash/parser/maps/SegmentValuesMap.js":
/*!**************************************************!*\
  !*** ./src/dash/parser/maps/SegmentValuesMap.js ***!
  \**************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _MapNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MapNode.js */ "./src/dash/parser/maps/MapNode.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc a SegmentValuesMap type for input to objectiron
 */


class SegmentValuesMap extends _MapNode_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    const commonProperties = [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST];
    super(_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD, commonProperties, [new _MapNode_js__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, commonProperties, [new _MapNode_js__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, commonProperties)])]);
  }
}
/* harmony default export */ __webpack_exports__["default"] = (SegmentValuesMap);

/***/ }),

/***/ "./src/dash/parser/matchers/BaseMatcher.js":
/*!*************************************************!*\
  !*** ./src/dash/parser/matchers/BaseMatcher.js ***!
  \*************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a base type for matching and converting types in manifest to
 * something more useful
 * @ignore
 */
class BaseMatcher {
  constructor(test, converter) {
    this._test = test;
    this._converter = converter;
  }
  get test() {
    return this._test;
  }
  get converter() {
    return this._converter;
  }
}
/* harmony default export */ __webpack_exports__["default"] = (BaseMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/DateTimeMatcher.js":
/*!*****************************************************!*\
  !*** ./src/dash/parser/matchers/DateTimeMatcher.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher.js */ "./src/dash/parser/matchers/BaseMatcher.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc matches and converts xs:datetime to Date
 */

const SECONDS_IN_MIN = 60;
const MINUTES_IN_HOUR = 60;
const MILLISECONDS_IN_SECONDS = 1000;
const datetimeRegex = /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})(?::([0-9]*)(\.[0-9]*)?)?(?:([+-])([0-9]{2})(?::?)([0-9]{2}))?/;
class DateTimeMatcher extends _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super((tagName, attrName, value) => datetimeRegex.test(value), str => {
      const match = datetimeRegex.exec(str);
      let utcDate;

      // If the string does not contain a timezone offset different browsers can interpret it either
      // as UTC or as a local time so we have to parse the string manually to normalize the given date value for
      // all browsers
      utcDate = Date.UTC(parseInt(match[1], 10), parseInt(match[2], 10) - 1,
      // months start from zero
      parseInt(match[3], 10), parseInt(match[4], 10), parseInt(match[5], 10), match[6] && parseInt(match[6], 10) || 0, match[7] && parseFloat(match[7]) * MILLISECONDS_IN_SECONDS || 0);

      // If the date has timezone offset take it into account as well
      if (match[9] && match[10]) {
        const timezoneOffset = parseInt(match[9], 10) * MINUTES_IN_HOUR + parseInt(match[10], 10);
        utcDate += (match[8] === '+' ? -1 : +1) * timezoneOffset * SECONDS_IN_MIN * MILLISECONDS_IN_SECONDS;
      }
      return new Date(utcDate);
    });
  }
}
/* harmony default export */ __webpack_exports__["default"] = (DateTimeMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/DurationMatcher.js":
/*!*****************************************************!*\
  !*** ./src/dash/parser/matchers/DurationMatcher.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher.js */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc matches and converts xs:duration to seconds
 */



const durationRegex = /^([-])?P(([\d.]*)Y)?(([\d.]*)M)?(([\d.]*)D)?T?(([\d.]*)H)?(([\d.]*)M)?(([\d.]*)S)?/;
const SECONDS_IN_YEAR = 365 * 24 * 60 * 60;
const SECONDS_IN_MONTH = 30 * 24 * 60 * 60;
const SECONDS_IN_DAY = 24 * 60 * 60;
const SECONDS_IN_HOUR = 60 * 60;
const SECONDS_IN_MIN = 60;
class DurationMatcher extends _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super((tagName, attrName, value) => {
      const attributeList = [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].MIN_BUFFER_TIME, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].MEDIA_PRESENTATION_DURATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].MINIMUM_UPDATE_PERIOD, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].TIMESHIFT_BUFFER_DEPTH, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].MAX_SEGMENT_DURATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].MAX_SUBSEGMENT_DURATION, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].SUGGESTED_PRESENTATION_DELAY, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].START, _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_1__["default"].START_TIME, _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_2__["default"].DURATION];
      const len = attributeList.length;
      for (let i = 0; i < len; i++) {
        if (attrName === attributeList[i]) {
          return durationRegex.test(value);
        }
      }
      return false;
    }, str => {
      //str = "P10Y10M10DT10H10M10.1S";
      const match = durationRegex.exec(str);
      let result = parseFloat(match[3] || 0) * SECONDS_IN_YEAR + parseFloat(match[5] || 0) * SECONDS_IN_MONTH + parseFloat(match[7] || 0) * SECONDS_IN_DAY + parseFloat(match[9] || 0) * SECONDS_IN_HOUR + parseFloat(match[11] || 0) * SECONDS_IN_MIN + parseFloat(match[13] || 0);
      if (match[1] !== undefined) {
        result = -result;
      }
      return result;
    });
  }
}
/* harmony default export */ __webpack_exports__["default"] = (DurationMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/LangMatcher.js":
/*!*************************************************!*\
  !*** ./src/dash/parser/matchers/LangMatcher.js ***!
  \*************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher.js */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bcp-47-normalize */ "./node_modules/bcp-47-normalize/lib/index.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc Matches and converts any ISO 639 language tag to BCP-47 language tags
 */



class LangMatcher extends _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super((tagName, attr /*, value*/) => {
      const stringAttrsInElements = {
        [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET]: [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LANG],
        [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION]: [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LANG],
        [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_COMPONENT]: [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LANG],
        [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LABEL]: [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LANG],
        [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].GROUP_LABEL]: [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]
        // still missing from 23009-1: Preselection@lang, ProgramInformation@lang
      };
      if (stringAttrsInElements.hasOwnProperty(tagName)) {
        let attrNames = stringAttrsInElements[tagName];
        if (attrNames !== undefined) {
          return attrNames.indexOf(attr) >= 0;
        } else {
          return false;
        }
      }
      return false;
    }, str => {
      let lang = (0,bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2__.bcp47Normalize)(str);
      if (lang) {
        return lang;
      }
      return String(str);
    });
  }
}
/* harmony default export */ __webpack_exports__["default"] = (LangMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/NumericMatcher.js":
/*!****************************************************!*\
  !*** ./src/dash/parser/matchers/NumericMatcher.js ***!
  \****************************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher.js */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants.js */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * @classdesc Matches and converts xs:numeric to float
 */


const numericRegex = /^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$/;
const StringAttributeList = [_constants_DashConstants_js__WEBPACK_IMPORTED_MODULE_1__["default"].ID];
class NumericMatcher extends _BaseMatcher_js__WEBPACK_IMPORTED_MODULE_0__["default"] {
  constructor() {
    super((tagName, attrName, value) => numericRegex.test(value) && StringAttributeList.indexOf(attrName) === -1, str => parseFloat(str));
  }
}
/* harmony default export */ __webpack_exports__["default"] = (NumericMatcher);

/***/ }),

/***/ "./src/dash/parser/objectiron.js":
/*!***************************************!*\
  !*** ./src/dash/parser/objectiron.js ***!
  \***************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

function ObjectIron(mappers) {
  function mergeValues(parentItem, childItem) {
    for (let name in parentItem) {
      if (!childItem.hasOwnProperty(name)) {
        childItem[name] = parentItem[name];
      }
    }
  }
  function mapProperties(properties, parent, child) {
    for (let i = 0, len = properties.length; i < len; ++i) {
      const property = properties[i];
      if (parent[property.name]) {
        if (child[property.name]) {
          // check to see if we should merge
          if (property.merge) {
            const parentValue = parent[property.name];
            const childValue = child[property.name];

            // complex objects; merge properties
            if (typeof parentValue === 'object' && typeof childValue === 'object') {
              mergeValues(parentValue, childValue);
            }
            // simple objects; merge them together
            else {
              child[property.name] = parentValue + childValue;
            }
          }
        } else {
          // just add the property
          child[property.name] = parent[property.name];
        }
      }
    }
  }
  function mapItem(item, node) {
    for (let i = 0, len = item.children.length; i < len; ++i) {
      const childItem = item.children[i];
      const array = node[childItem.name];
      if (array) {
        for (let v = 0, len2 = array.length; v < len2; ++v) {
          const childNode = array[v];
          mapProperties(item.properties, node, childNode);
          mapItem(childItem, childNode);
        }
      }
    }
  }
  function run(source) {
    if (source === null || typeof source !== 'object') {
      return source;
    }
    if (source.Period && 'period' in mappers) {
      const periodMapper = mappers.period;
      const periods = source.Period;
      for (let i = 0, len = periods.length; i < len; ++i) {
        const period = periods[i];
        mapItem(periodMapper, period);
        if ('adaptationset' in mappers) {
          const adaptationSets = period.AdaptationSet;
          if (adaptationSets) {
            const adaptationSetMapper = mappers.adaptationset;
            for (let i = 0, len = adaptationSets.length; i < len; ++i) {
              mapItem(adaptationSetMapper, adaptationSets[i]);
            }
          }
        }
      }
    }
    return source;
  }
  return {
    run: run
  };
}
ObjectIron.__dashjs_factory_name = 'ObjectIron';
const factory = _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ObjectIron);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/utils/ListSegmentsGetter.js":
/*!**********************************************!*\
  !*** ./src/dash/utils/ListSegmentsGetter.js ***!
  \**********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils.js */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function ListSegmentsGetter(config, isDynamic) {
  config = config || {};
  const timelineConverter = config.timelineConverter;
  let instance;
  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }
  function getMediaFinishedInformation(representation) {
    const mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
    if (!representation) {
      return mediaFinishedInformation;
    }
    const list = representation.adaptation.period.mpd.manifest.Period[representation.adaptation.period.index].AdaptationSet[representation.adaptation.index].Representation[representation.index].SegmentList;
    const startNumber = representation && !isNaN(representation.startNumber) ? representation.startNumber : 1;
    const offset = Math.max(startNumber - 1, 0);
    mediaFinishedInformation.numberOfSegments = offset + list.SegmentURL.length;
    return mediaFinishedInformation;
  }
  function getSegmentByIndex(representation, index) {
    checkConfig();
    if (!representation) {
      return null;
    }
    const list = representation.adaptation.period.mpd.manifest.Period[representation.adaptation.period.index].AdaptationSet[representation.adaptation.index].Representation[representation.index].SegmentList;
    const len = list.SegmentURL.length;
    const startNumber = representation && !isNaN(representation.startNumber) ? representation.startNumber : 1;
    const offsetToSubtract = Math.max(startNumber - 1, 0);
    const relativeIndex = Math.max(index - offsetToSubtract, 0);
    let segment = null;
    if (relativeIndex < len) {
      const s = list.SegmentURL[relativeIndex];
      segment = (0,_SegmentsUtils_js__WEBPACK_IMPORTED_MODULE_2__.getIndexBasedSegment)(timelineConverter, isDynamic, representation, index);
      if (segment) {
        segment.replacementTime = (startNumber + index - 1) * representation.segmentDuration;
        segment.media = s.media ? s.media : '';
        segment.mediaRange = s.mediaRange;
        segment.indexRange = s.indexRange;
      }
    }
    return segment;
  }
  function getSegmentByTime(representation, requestedTime) {
    checkConfig();
    if (!representation) {
      return null;
    }
    const duration = representation.segmentDuration;
    if (isNaN(duration)) {
      return null;
    }
    const periodTime = timelineConverter.calcPeriodRelativeTimeFromMpdRelativeTime(representation, requestedTime);
    const index = Math.floor(periodTime / duration);
    return getSegmentByIndex(representation, index);
  }
  instance = {
    getSegmentByIndex,
    getSegmentByTime,
    getMediaFinishedInformation
  };
  return instance;
}
ListSegmentsGetter.__dashjs_factory_name = 'ListSegmentsGetter';
const factory = _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ListSegmentsGetter);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/utils/SegmentBaseGetter.js":
/*!*********************************************!*\
  !*** ./src/dash/utils/SegmentBaseGetter.js ***!
  \*********************************************/
/***/ (function(__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker.js */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants.js */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



function SegmentBaseGetter(config) {
  config = config || {};
  const timelineConverter = config.timelineConverter;
  let instance;
  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants_js__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }
  function getMediaFinishedInformation(representation) {
    const mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
    if (!representation || !representation.segments) {
      return mediaFinishedInformation;
    }
    mediaFinishedInformation.numberOfSegments = representation.segments.length;
    return mediaFinishedInformation;
  }
  function getSegmentByIndex(representation, index) {
    checkConfig();
    if (!representation) {
      return null;
    }
    const len = representation.segments ? representation.segments.length : -1;
    let seg;
    if (index < len) {
      seg = representation.segments[index];
      if