(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["dashjs"] = factory();
	else
		root["dashjs"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_OBJECT.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_OBJECT.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_OBJECT: function() { return /* binding */ CMCD_OBJECT; }
/* harmony export */ });
/**
 * CMCD object header name.
 *
 * @group CMCD
 *
 * @beta
 */
var CMCD_OBJECT = 'CMCD-Object';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_PARAM.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_PARAM.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_PARAM: function() { return /* binding */ CMCD_PARAM; }
/* harmony export */ });
/**
 * CMCD parameter name.
 *
 * @group CMCD
 *
 * @beta
 */
var CMCD_PARAM = 'CMCD';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_REQUEST.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_REQUEST.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_REQUEST: function() { return /* binding */ CMCD_REQUEST; }
/* harmony export */ });
/**
 * CMCD request header name.
 *
 * @group CMCD
 *
 * @beta
 */
var CMCD_REQUEST = 'CMCD-Request';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_SESSION.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_SESSION.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_SESSION: function() { return /* binding */ CMCD_SESSION; }
/* harmony export */ });
/**
 * CMCD session header name.
 *
 * @group CMCD
 *
 * @beta
 */
var CMCD_SESSION = 'CMCD-Session';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_STATUS.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CMCD_STATUS.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMCD_STATUS: function() { return /* binding */ CMCD_STATUS; }
/* harmony export */ });
/**
 * CMCD status header name.
 *
 * @group CMCD
 *
 * @beta
 */
var CMCD_STATUS = 'CMCD-Status';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdFormatters.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdFormatters.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdFormatters: function() { return /* binding */ CmcdFormatters; }
/* harmony export */ });
/* harmony import */ var _utils_urlToRelativePath_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/urlToRelativePath.js */ "./node_modules/@svta/common-media-library/dist/utils/urlToRelativePath.js");

var toRounded = function toRounded(value) {
  return Math.round(value);
};
var toUrlSafe = function toUrlSafe(value, options) {
  if (options === null || options === void 0 ? void 0 : options.baseUrl) {
    value = (0,_utils_urlToRelativePath_js__WEBPACK_IMPORTED_MODULE_0__.urlToRelativePath)(value, options.baseUrl);
  }
  return encodeURIComponent(value);
};
var toHundred = function toHundred(value) {
  return toRounded(value / 100) * 100;
};
/**
 * The default formatters for CMCD values.
 *
 * @group CMCD
 *
 * @beta
 */
var CmcdFormatters = {
  /**
   * Bitrate (kbps) rounded integer
   */
  br: toRounded,
  /**
   * Duration (milliseconds) rounded integer
   */
  d: toRounded,
  /**
   * Buffer Length (milliseconds) rounded nearest 100ms
   */
  bl: toHundred,
  /**
   * Deadline (milliseconds) rounded nearest 100ms
   */
  dl: toHundred,
  /**
   * Measured Throughput (kbps) rounded nearest 100kbps
   */
  mtp: toHundred,
  /**
   * Next Object Request URL encoded
   */
  nor: toUrlSafe,
  /**
   * Requested maximum throughput (kbps) rounded nearest 100kbps
   */
  rtp: toHundred,
  /**
   * Top Bitrate (kbps) rounded integer
   */
  tb: toRounded
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdHeaderField: function() { return /* binding */ CmcdHeaderField; }
/* harmony export */ });
/* harmony import */ var _CMCD_OBJECT_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CMCD_OBJECT.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_OBJECT.js");
/* harmony import */ var _CMCD_REQUEST_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CMCD_REQUEST.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_REQUEST.js");
/* harmony import */ var _CMCD_SESSION_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CMCD_SESSION.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_SESSION.js");
/* harmony import */ var _CMCD_STATUS_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CMCD_STATUS.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CMCD_STATUS.js");




/**
 * CMCD header fields.
 *
 * @group CMCD
 *
 * @enum
 *
 * @beta
 */
var CmcdHeaderField = {
  /**
   * keys whose values vary with the object being requested.
   */
  OBJECT: _CMCD_OBJECT_js__WEBPACK_IMPORTED_MODULE_0__.CMCD_OBJECT,
  /**
   * keys whose values vary with each request.
   */
  REQUEST: _CMCD_REQUEST_js__WEBPACK_IMPORTED_MODULE_1__.CMCD_REQUEST,
  /**
   * keys whose values are expected to be invariant over the life of the session.
   */
  SESSION: _CMCD_SESSION_js__WEBPACK_IMPORTED_MODULE_2__.CMCD_SESSION,
  /**
   * keys whose values do not vary with every request or object.
   */
  STATUS: _CMCD_STATUS_js__WEBPACK_IMPORTED_MODULE_3__.CMCD_STATUS
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderMap.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderMap.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdHeaderMap: function() { return /* binding */ CmcdHeaderMap; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ "./node_modules/@babel/runtime/helpers/esm/defineProperty.js");
/* harmony import */ var _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CmcdHeaderField.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js");


/**
 * The map of CMCD header fields to official CMCD keys.
 *
 * @internal
 *
 * @group CMCD
 */
var CmcdHeaderMap = (0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__["default"])({}, _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_1__.CmcdHeaderField.OBJECT, ['br', 'd', 'ot', 'tb']), _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_1__.CmcdHeaderField.REQUEST, ['bl', 'dl', 'mtp', 'nor', 'nrr', 'su']), _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_1__.CmcdHeaderField.SESSION, ['cid', 'pr', 'sf', 'sid', 'st', 'v']), _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_1__.CmcdHeaderField.STATUS, ['bs', 'rtp']);

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdObjectType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdObjectType.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdObjectType: function() { return /* binding */ CmcdObjectType; }
/* harmony export */ });
/* harmony import */ var _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmObjectType.js */ "./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js");

/**
 * Common Media Client Data Object Type
 *
 * @group CMCD
 *
 * @beta
 *
 * @enum
 */
var CmcdObjectType = _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__.CmObjectType;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamType.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdStreamType: function() { return /* binding */ CmcdStreamType; }
/* harmony export */ });
/* harmony import */ var _cta_CmStreamType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmStreamType.js */ "./node_modules/@svta/common-media-library/dist/cta/CmStreamType.js");

/**
 * Common Media Client Data Stream Type
 *
 * @group CMCD
 *
 * @enum
 *
 * @beta
 */
var CmcdStreamType = _cta_CmStreamType_js__WEBPACK_IMPORTED_MODULE_0__.CmStreamType;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamingFormat.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/CmcdStreamingFormat.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmcdStreamingFormat: function() { return /* binding */ CmcdStreamingFormat; }
/* harmony export */ });
/* harmony import */ var _cta_CmStreamingFormat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmStreamingFormat.js */ "./node_modules/@svta/common-media-library/dist/cta/CmStreamingFormat.js");

/**
 * Common Media Client Data Streaming Format
 *
 * @group CMCD
 *
 * @enum
 *
 * @beta
 */
var CmcdStreamingFormat = _cta_CmStreamingFormat_js__WEBPACK_IMPORTED_MODULE_0__.CmStreamingFormat;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/encodeCmcd.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/encodeCmcd.js ***!
  \*************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   encodeCmcd: function() { return /* binding */ encodeCmcd; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _structuredfield_encodeSfDict_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../structuredfield/encodeSfDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/encodeSfDict.js");
/* harmony import */ var _utils_processCmcd_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/processCmcd.js */ "./node_modules/@svta/common-media-library/dist/cmcd/utils/processCmcd.js");



/**
 * Encode a CMCD object to a string.
 *
 * @param cmcd - The CMCD object to encode.
 * @param options - Options for encoding.
 *
 * @returns The encoded CMCD string.
 *
 * @group CMCD
 *
 * @beta
 */
function encodeCmcd(cmcd) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  if (!cmcd) {
    return '';
  }
  return (0,_structuredfield_encodeSfDict_js__WEBPACK_IMPORTED_MODULE_1__.encodeSfDict)((0,_utils_processCmcd_js__WEBPACK_IMPORTED_MODULE_2__.processCmcd)(cmcd, options), Object.assign({
    whitespace: false
  }, options));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/toCmcdHeaders.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/toCmcdHeaders.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toCmcdHeaders: function() { return /* binding */ toCmcdHeaders; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.find.js */ "./node_modules/core-js/modules/es.array.find.js");
/* harmony import */ var core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_find_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CmcdHeaderField.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderField.js");
/* harmony import */ var _CmcdHeaderMap_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./CmcdHeaderMap.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdHeaderMap.js");
/* harmony import */ var _encodeCmcd_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./encodeCmcd.js */ "./node_modules/@svta/common-media-library/dist/cmcd/encodeCmcd.js");










/**
 * Convert a CMCD data object to request headers
 *
 * @param cmcd - The CMCD data object to convert.
 * @param options - Options for encoding the CMCD object.
 *
 * @returns The CMCD header shards.
 *
 * @group CMCD
 *
 * @beta
 */
function toCmcdHeaders(cmcd) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var result = {};
  if (!cmcd) {
    return result;
  }
  var entries = Object.entries(cmcd);
  var headerMap = Object.entries(_CmcdHeaderMap_js__WEBPACK_IMPORTED_MODULE_8__.CmcdHeaderMap).concat(Object.entries((options === null || options === void 0 ? void 0 : options.customHeaderMap) || {}));
  var shards = entries.reduce(function (acc, entry) {
    var _a, _b;
    var _entry = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(entry, 2),
      key = _entry[0],
      value = _entry[1];
    var field = ((_a = headerMap.find(function (entry) {
      return entry[1].includes(key);
    })) === null || _a === void 0 ? void 0 : _a[0]) || _CmcdHeaderField_js__WEBPACK_IMPORTED_MODULE_7__.CmcdHeaderField.REQUEST;
    (_b = acc[field]) !== null && _b !== void 0 ? _b : acc[field] = {};
    acc[field][key] = value;
    return acc;
  }, {});
  return Object.entries(shards).reduce(function (acc, _ref) {
    var _ref2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref, 2),
      field = _ref2[0],
      value = _ref2[1];
    acc[field] = (0,_encodeCmcd_js__WEBPACK_IMPORTED_MODULE_9__.encodeCmcd)(value, options);
    return acc;
  }, result);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmcd/utils/processCmcd.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmcd/utils/processCmcd.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processCmcd: function() { return /* binding */ processCmcd; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
/* harmony import */ var core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_filter_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.sort.js */ "./node_modules/core-js/modules/es.array.sort.js");
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _cta_utils_isTokenField_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../cta/utils/isTokenField.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/isTokenField.js");
/* harmony import */ var _cta_utils_isValid_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../cta/utils/isValid.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/isValid.js");
/* harmony import */ var _structuredfield_SfToken_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../structuredfield/SfToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js");
/* harmony import */ var _CmcdFormatters_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../CmcdFormatters.js */ "./node_modules/@svta/common-media-library/dist/cmcd/CmcdFormatters.js");











/**
 * Internal CMCD processing function.
 *
 * @param obj - The CMCD object to process.
 * @param map - The mapping function to use.
 * @param options - Options for encoding.
 *
 * @internal
 *
 * @group CMCD
 */
function processCmcd(obj, options) {
  var results = {};
  if (obj == null || (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(obj) !== 'object') {
    return results;
  }
  var keys = Object.keys(obj).sort();
  var formatters = Object.assign({}, _CmcdFormatters_js__WEBPACK_IMPORTED_MODULE_10__.CmcdFormatters, options === null || options === void 0 ? void 0 : options.formatters);
  var filter = options === null || options === void 0 ? void 0 : options.filter;
  keys.forEach(function (key) {
    if (filter === null || filter === void 0 ? void 0 : filter(key)) {
      return;
    }
    var value = obj[key];
    var formatter = formatters[key];
    if (formatter) {
      value = formatter(value, options);
    }
    // Version should only be reported if not equal to 1.
    if (key === 'v' && value === 1) {
      return;
    }
    // Playback rate should only be sent if not equal to 1.
    if (key == 'pr' && value === 1) {
      return;
    }
    // ignore invalid values
    if (!(0,_cta_utils_isValid_js__WEBPACK_IMPORTED_MODULE_8__.isValid)(value)) {
      return;
    }
    if ((0,_cta_utils_isTokenField_js__WEBPACK_IMPORTED_MODULE_7__.isTokenField)(key) && typeof value === 'string') {
      value = new _structuredfield_SfToken_js__WEBPACK_IMPORTED_MODULE_9__.SfToken(value);
    }
    results[key] = value;
  });
  return results;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/CMSD_DYNAMIC.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/CMSD_DYNAMIC.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMSD_DYNAMIC: function() { return /* binding */ CMSD_DYNAMIC; }
/* harmony export */ });
/**
 * CMSD dynamic header name.
 *
 * @group CMSD
 *
 * @beta
 */
var CMSD_DYNAMIC = 'CMSD-Dynamic';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/CMSD_STATIC.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/CMSD_STATIC.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CMSD_STATIC: function() { return /* binding */ CMSD_STATIC; }
/* harmony export */ });
/**
 * CMSD static header name.
 *
 * @group CMSD
 *
 * @beta
 */
var CMSD_STATIC = 'CMSD-Static';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/CmsdObjectType.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/CmsdObjectType.js ***!
  \*****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmsdObjectType: function() { return /* binding */ CmsdObjectType; }
/* harmony export */ });
/* harmony import */ var _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cta/CmObjectType.js */ "./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js");

/**
 * Common Media Server Data Object Type
 *
 * @group CMSD
 *
 * @enum
 *
 * @beta
 */
var CmsdObjectType = _cta_CmObjectType_js__WEBPACK_IMPORTED_MODULE_0__.CmObjectType;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdDynamic.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdDynamic.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeCmsdDynamic: function() { return /* binding */ decodeCmsdDynamic; }
/* harmony export */ });
/* harmony import */ var _structuredfield_decodeSfList_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../structuredfield/decodeSfList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfList.js");

/**
 * Decode a CMSD dynamic string to an object.
 *
 * @param cmsd - The CMSD string to decode.
 *
 * @returns The decoded CMSD object.
 *
 * @group CMSD
 *
 * @beta
 */
function decodeCmsdDynamic(cmsd) {
  if (!cmsd) {
    return [];
  }
  var sfDict = (0,_structuredfield_decodeSfList_js__WEBPACK_IMPORTED_MODULE_0__.decodeSfList)(cmsd);
  return sfDict;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdStatic.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cmsd/decodeCmsdStatic.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeCmsdStatic: function() { return /* binding */ decodeCmsdStatic; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../cta/utils/symbolToStr.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js");
/* harmony import */ var _structuredfield_decodeSfDict_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../structuredfield/decodeSfDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfDict.js");






/**
 * Decode a CMSD Static dict string to an object.
 *
 * @param cmsd - The CMSD string to decode.
 *
 * @returns The decoded CMSD object.
 *
 * @group CMSD
 *
 * @beta
 */
function decodeCmsdStatic(cmsd) {
  if (!cmsd) {
    return {};
  }
  return Object.entries((0,_structuredfield_decodeSfDict_js__WEBPACK_IMPORTED_MODULE_5__.decodeSfDict)(cmsd)).reduce(function (acc, _ref) {
    var _ref2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_1__["default"])(_ref, 2),
      key = _ref2[0],
      item = _ref2[1];
    var value = item.value;
    acc[key] = (0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(value) === 'symbol' ? (0,_cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_4__.symbolToStr)(value) : value;
    return acc;
  }, {});
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionScreen.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/CaptionScreen.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CaptionScreen: function() { return /* binding */ CaptionScreen; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
/* harmony import */ var core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_splice_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.json.stringify.js */ "./node_modules/core-js/modules/es.json.stringify.js");
/* harmony import */ var core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./CaptionsLogger.js */ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionsLogger.js");
/* harmony import */ var _Row_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Row.js */ "./node_modules/@svta/common-media-library/dist/cta/608/Row.js");
/* harmony import */ var _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils/NR_ROWS.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/NR_ROWS.js");
/* harmony import */ var _VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./VerboseLevel.js */ "./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js");







/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




/**
 * Keep a CTA-608 screen of 32x15 styled characters
 *
 * @group CTA-608
 * @beta
 */
var CaptionScreen = /*#__PURE__*/function () {
  function CaptionScreen() {
    var logger = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_7__.CaptionsLogger();
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, CaptionScreen);
    this.rows = [];
    this.currRow = _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS - 1;
    this.nrRollUpRows = null;
    this.lastOutputScreen = null;
    for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
      this.rows.push(new _Row_js__WEBPACK_IMPORTED_MODULE_8__.Row(logger));
    }
    this.logger = logger;
  }
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(CaptionScreen, [{
    key: "reset",
    value: function reset() {
      for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
        this.rows[i].clear();
      }
      this.currRow = _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS - 1;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      var equal = true;
      for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
        if (!this.rows[i].equals(other.rows[i])) {
          equal = false;
          break;
        }
      }
      return equal;
    }
  }, {
    key: "copy",
    value: function copy(other) {
      for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
        this.rows[i].copy(other.rows[i]);
      }
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      var empty = true;
      for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
        if (!this.rows[i].isEmpty()) {
          empty = false;
          break;
        }
      }
      return empty;
    }
  }, {
    key: "backSpace",
    value: function backSpace() {
      var row = this.rows[this.currRow];
      row.backSpace();
    }
  }, {
    key: "clearToEndOfRow",
    value: function clearToEndOfRow() {
      var row = this.rows[this.currRow];
      row.clearToEndOfRow();
    }
    /**
     * Insert a character (without styling) in the current row.
     */
  }, {
    key: "insertChar",
    value: function insertChar(char) {
      var row = this.rows[this.currRow];
      row.insertChar(char);
    }
  }, {
    key: "setPen",
    value: function setPen(styles) {
      var row = this.rows[this.currRow];
      row.setPenStyles(styles);
    }
  }, {
    key: "moveCursor",
    value: function moveCursor(relPos) {
      var row = this.rows[this.currRow];
      row.moveCursor(relPos);
    }
  }, {
    key: "setCursor",
    value: function setCursor(absPos) {
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__.VerboseLevel.INFO, 'setCursor: ' + absPos);
      var row = this.rows[this.currRow];
      row.setCursor(absPos);
    }
  }, {
    key: "setPAC",
    value: function setPAC(pacData) {
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__.VerboseLevel.INFO, function () {
        return 'pacData = ' + JSON.stringify(pacData);
      });
      var newRow = pacData.row - 1;
      if (this.nrRollUpRows && newRow < this.nrRollUpRows - 1) {
        newRow = this.nrRollUpRows - 1;
      }
      // Make sure this only affects Roll-up Captions by checking this.nrRollUpRows
      if (this.nrRollUpRows && this.currRow !== newRow) {
        // clear all rows first
        for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
          this.rows[i].clear();
        }
        // Copy this.nrRollUpRows rows from lastOutputScreen and place it in the newRow location
        // topRowIndex - the start of rows to copy (inclusive index)
        var topRowIndex = this.currRow + 1 - this.nrRollUpRows;
        // We only copy if the last position was already shown.
        // We use the cueStartTime value to check this.
        var lastOutputScreen = this.lastOutputScreen;
        if (lastOutputScreen) {
          var prevLineTime = lastOutputScreen.rows[topRowIndex].cueStartTime;
          var time = this.logger.time;
          if (prevLineTime !== null && time !== null && prevLineTime < time) {
            for (var _i = 0; _i < this.nrRollUpRows; _i++) {
              this.rows[newRow - this.nrRollUpRows + _i + 1].copy(lastOutputScreen.rows[topRowIndex + _i]);
            }
          }
        }
      }
      this.currRow = newRow;
      var row = this.rows[this.currRow];
      if (pacData.indent !== null) {
        var indent = pacData.indent;
        var prevPos = Math.max(indent - 1, 0);
        row.setCursor(pacData.indent);
        pacData.color = row.chars[prevPos].penState.foreground;
      }
      var styles = {
        foreground: pacData.color,
        underline: pacData.underline,
        italics: pacData.italics,
        background: 'black',
        flash: false
      };
      this.setPen(styles);
    }
    /**
     * Set background/extra foreground, but first do back_space, and then insert space (backwards compatibility).
     */
  }, {
    key: "setBkgData",
    value: function setBkgData(bkgData) {
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__.VerboseLevel.INFO, function () {
        return 'bkgData = ' + JSON.stringify(bkgData);
      });
      this.backSpace();
      this.setPen(bkgData);
      this.insertChar(0x20); // Space
    }
  }, {
    key: "setRollUpRows",
    value: function setRollUpRows(nrRows) {
      this.nrRollUpRows = nrRows;
    }
  }, {
    key: "rollUp",
    value: function rollUp() {
      var _this = this;
      if (this.nrRollUpRows === null) {
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__.VerboseLevel.DEBUG, 'roll_up but nrRollUpRows not set yet');
        return; // Not properly setup
      }
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__.VerboseLevel.TEXT, function () {
        return _this.getDisplayText();
      });
      var topRowIndex = this.currRow + 1 - this.nrRollUpRows;
      var topRow = this.rows.splice(topRowIndex, 1)[0];
      topRow.clear();
      this.rows.splice(this.currRow, 0, topRow);
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_10__.VerboseLevel.INFO, 'Rolling up');
    }
    /**
     * Get all non-empty rows with as unicode text.
     */
  }, {
    key: "getDisplayText",
    value: function getDisplayText(asOneRow) {
      asOneRow = asOneRow || false;
      var displayText = [];
      var text = '';
      var rowNr = -1;
      for (var i = 0; i < _utils_NR_ROWS_js__WEBPACK_IMPORTED_MODULE_9__.NR_ROWS; i++) {
        var rowText = this.rows[i].getTextString();
        if (rowText) {
          rowNr = i + 1;
          if (asOneRow) {
            displayText.push('Row ' + rowNr + ": '" + rowText + "'");
          } else {
            displayText.push(rowText.trim());
          }
        }
      }
      if (displayText.length > 0) {
        if (asOneRow) {
          text = '[' + displayText.join(' | ') + ']';
        } else {
          text = displayText.join('\n');
        }
      }
      return text;
    }
  }, {
    key: "getTextAndFormat",
    value: function getTextAndFormat() {
      return this.rows;
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionsLogger.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/CaptionsLogger.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CaptionsLogger: function() { return /* binding */ CaptionsLogger; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _VerboseLevel_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./VerboseLevel.js */ "./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js");



/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * CaptionsLogger. To be removed in the future.
 *
 * @group CTA-608
 * @beta
 */
var CaptionsLogger = /*#__PURE__*/function () {
  function CaptionsLogger() {
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, CaptionsLogger);
    this.time = null;
    this.verboseLevel = _VerboseLevel_js__WEBPACK_IMPORTED_MODULE_3__.VerboseLevel.ERROR;
  }
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(CaptionsLogger, [{
    key: "log",
    value: function log(severity, msg) {
      if (this.verboseLevel >= severity) {
        var m = typeof msg === 'function' ? msg() : msg;
        console.log("".concat(this.time, " [").concat(severity, "] ").concat(m));
      }
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/Cta608Channel.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/Cta608Channel.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cta608Channel: function() { return /* binding */ Cta608Channel; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.json.stringify.js */ "./node_modules/core-js/modules/es.json.stringify.js");
/* harmony import */ var core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _CaptionScreen_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CaptionScreen.js */ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionScreen.js");
/* harmony import */ var _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CaptionsLogger.js */ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionsLogger.js");
/* harmony import */ var _VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./VerboseLevel.js */ "./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js");



/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



/**
 * CTA-608 Channel
 *
 * @group CTA-608
 * @beta
 */
var Cta608Channel = /*#__PURE__*/function () {
  function Cta608Channel(channelNumber, outputFilter) {
    var logger = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_4__.CaptionsLogger();
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, Cta608Channel);
    this.chNr = channelNumber;
    this.outputFilter = outputFilter;
    this.mode = null;
    this.displayedMemory = new _CaptionScreen_js__WEBPACK_IMPORTED_MODULE_3__.CaptionScreen(logger);
    this.nonDisplayedMemory = new _CaptionScreen_js__WEBPACK_IMPORTED_MODULE_3__.CaptionScreen(logger);
    this.lastOutputScreen = new _CaptionScreen_js__WEBPACK_IMPORTED_MODULE_3__.CaptionScreen(logger);
    this.writeScreen = this.displayedMemory;
    this.mode = null;
    this.cueStartTime = null; // Keeps track of where a cue started.
    this.logger = logger;
    this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'new Cea608Channel(' + this.chNr + ')');
  }
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(Cta608Channel, [{
    key: "reset",
    value: function reset() {
      var _a, _b;
      this.mode = null;
      this.displayedMemory.reset();
      this.nonDisplayedMemory.reset();
      this.lastOutputScreen.reset();
      (_b = (_a = this.outputFilter) === null || _a === void 0 ? void 0 : _a.reset) === null || _b === void 0 ? void 0 : _b.call(_a);
      this.writeScreen = this.displayedMemory;
      this.mode = null;
      this.cueStartTime = null;
    }
  }, {
    key: "setPAC",
    value: function setPAC(pacData) {
      this.writeScreen.setPAC(pacData);
    }
  }, {
    key: "setBkgData",
    value: function setBkgData(bkgData) {
      this.writeScreen.setBkgData(bkgData);
    }
  }, {
    key: "setMode",
    value: function setMode(newMode) {
      if (newMode === this.mode) {
        return;
      }
      this.mode = newMode;
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, function () {
        return 'MODE=' + newMode;
      });
      if (this.mode === 'MODE_POP-ON') {
        this.writeScreen = this.nonDisplayedMemory;
      } else {
        this.writeScreen = this.displayedMemory;
        this.writeScreen.reset();
      }
      if (this.mode !== 'MODE_ROLL-UP') {
        this.displayedMemory.setRollUpRows(null);
        this.nonDisplayedMemory.setRollUpRows(null);
      }
      this.mode = newMode;
    }
  }, {
    key: "insertChars",
    value: function insertChars(chars) {
      var _this = this;
      for (var i = 0; i < chars.length; i++) {
        this.writeScreen.insertChar(chars[i]);
      }
      var screen = this.writeScreen === this.displayedMemory ? 'DISP' : 'NON_DISP';
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, function () {
        return screen + ': ' + _this.writeScreen.getDisplayText(true);
      });
      if (this.mode === 'MODE_PAINT-ON' || this.mode === 'MODE_ROLL-UP') {
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.TEXT, function () {
          return 'DISPLAYED: ' + _this.displayedMemory.getDisplayText(true);
        });
        this.outputDataUpdate();
      }
    }
  }, {
    key: "ccRCL",
    value: function ccRCL() {
      // Resume Caption Loading (switch mode to Pop On)
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'RCL - Resume Caption Loading');
      this.setMode('MODE_POP-ON');
    }
  }, {
    key: "ccBS",
    value: function ccBS() {
      // BackSpace
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'BS - BackSpace');
      if (this.mode === 'MODE_TEXT') {
        return;
      }
      this.writeScreen.backSpace();
      if (this.writeScreen === this.displayedMemory) {
        this.outputDataUpdate();
      }
    }
  }, {
    key: "ccAOF",
    value: function ccAOF() {
      // Reserved (formerly Alarm Off)
    }
  }, {
    key: "ccAON",
    value: function ccAON() {
      // Reserved (formerly Alarm On)
    }
  }, {
    key: "ccDER",
    value: function ccDER() {
      // Delete to End of Row
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'DER- Delete to End of Row');
      this.writeScreen.clearToEndOfRow();
      this.outputDataUpdate();
    }
  }, {
    key: "ccRU",
    value: function ccRU(nrRows) {
      // Roll-Up Captions-2,3,or 4 Rows
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'RU(' + nrRows + ') - Roll Up');
      this.writeScreen = this.displayedMemory;
      this.setMode('MODE_ROLL-UP');
      this.writeScreen.setRollUpRows(nrRows);
    }
  }, {
    key: "ccFON",
    value: function ccFON() {
      // Flash On
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'FON - Flash On');
      this.writeScreen.setPen({
        flash: true
      });
    }
  }, {
    key: "ccRDC",
    value: function ccRDC() {
      // Resume Direct Captioning (switch mode to PaintOn)
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'RDC - Resume Direct Captioning');
      this.setMode('MODE_PAINT-ON');
    }
  }, {
    key: "ccTR",
    value: function ccTR() {
      // Text Restart in text mode (not supported, however)
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'TR');
      this.setMode('MODE_TEXT');
    }
  }, {
    key: "ccRTD",
    value: function ccRTD() {
      // Resume Text Display in Text mode (not supported, however)
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'RTD');
      this.setMode('MODE_TEXT');
    }
  }, {
    key: "ccEDM",
    value: function ccEDM() {
      // Erase Displayed Memory
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'EDM - Erase Displayed Memory');
      this.displayedMemory.reset();
      this.outputDataUpdate(true);
    }
  }, {
    key: "ccCR",
    value: function ccCR() {
      // Carriage Return
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'CR - Carriage Return');
      this.writeScreen.rollUp();
      this.outputDataUpdate(true);
    }
  }, {
    key: "ccENM",
    value: function ccENM() {
      // Erase Non-Displayed Memory
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'ENM - Erase Non-displayed Memory');
      this.nonDisplayedMemory.reset();
    }
  }, {
    key: "ccEOC",
    value: function ccEOC() {
      var _this2 = this;
      // End of Caption (Flip Memories)
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'EOC - End Of Caption');
      if (this.mode === 'MODE_POP-ON') {
        var tmp = this.displayedMemory;
        this.displayedMemory = this.nonDisplayedMemory;
        this.nonDisplayedMemory = tmp;
        this.writeScreen = this.nonDisplayedMemory;
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.TEXT, function () {
          return 'DISP: ' + _this2.displayedMemory.getDisplayText();
        });
      }
      this.outputDataUpdate(true);
    }
  }, {
    key: "ccTO",
    value: function ccTO(nrCols) {
      // Tab Offset 1,2, or 3 columns
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'TO(' + nrCols + ') - Tab Offset');
      this.writeScreen.moveCursor(nrCols);
    }
  }, {
    key: "ccMIDROW",
    value: function ccMIDROW(secondByte) {
      // Parse MIDROW command
      var styles = {
        flash: false
      };
      styles.underline = secondByte % 2 === 1;
      styles.italics = secondByte >= 0x2e;
      if (!styles.italics) {
        var colorIndex = Math.floor(secondByte / 2) - 0x10;
        var colors = ['white', 'green', 'blue', 'cyan', 'red', 'yellow', 'magenta'];
        styles.foreground = colors[colorIndex];
      } else {
        styles.foreground = 'white';
      }
      this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_5__.VerboseLevel.INFO, 'MIDROW: ' + JSON.stringify(styles));
      this.writeScreen.setPen(styles);
    }
  }, {
    key: "outputDataUpdate",
    value: function outputDataUpdate() {
      var dispatch = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      var time = this.logger.time;
      if (time === null) {
        return;
      }
      if (this.outputFilter) {
        if (this.cueStartTime === null && !this.displayedMemory.isEmpty()) {
          // Start of a new cue
          this.cueStartTime = time;
        } else {
          if (!this.displayedMemory.equals(this.lastOutputScreen)) {
            this.outputFilter.newCue(this.cueStartTime, time, this.lastOutputScreen);
            if (dispatch && this.outputFilter.dispatchCue) {
              this.outputFilter.dispatchCue();
            }
            this.cueStartTime = this.displayedMemory.isEmpty() ? null : time;
          }
        }
        this.lastOutputScreen.copy(this.displayedMemory);
      }
    }
  }, {
    key: "cueSplitAtTime",
    value: function cueSplitAtTime(t) {
      if (this.outputFilter) {
        if (!this.displayedMemory.isEmpty()) {
          if (this.outputFilter.newCue) {
            this.outputFilter.newCue(this.cueStartTime, t, this.displayedMemory);
          }
          this.cueStartTime = t;
        }
      }
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/Cta608Parser.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/Cta608Parser.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Cta608Parser: function() { return /* binding */ Cta608Parser; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
/* harmony import */ var core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_keys_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CaptionsLogger.js */ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionsLogger.js");
/* harmony import */ var _Cta608Channel_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Cta608Channel.js */ "./node_modules/@svta/common-media-library/dist/cta/608/Cta608Channel.js");
/* harmony import */ var _VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./VerboseLevel.js */ "./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js");
/* harmony import */ var _utils_backgroundColors_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/backgroundColors.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/backgroundColors.js");
/* harmony import */ var _utils_createCmdHistory_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils/createCmdHistory.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/createCmdHistory.js");
/* harmony import */ var _utils_getCharForByte_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils/getCharForByte.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/getCharForByte.js");
/* harmony import */ var _utils_hasCmdRepeated_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils/hasCmdRepeated.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/hasCmdRepeated.js");
/* harmony import */ var _utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./utils/numArrayToHexArray.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/numArrayToHexArray.js");
/* harmony import */ var _utils_rowsHighCh1_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./utils/rowsHighCh1.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsHighCh1.js");
/* harmony import */ var _utils_rowsHighCh2_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./utils/rowsHighCh2.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsHighCh2.js");
/* harmony import */ var _utils_rowsLowCh1_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./utils/rowsLowCh1.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsLowCh1.js");
/* harmony import */ var _utils_rowsLowCh2_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./utils/rowsLowCh2.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsLowCh2.js");
/* harmony import */ var _utils_setLastCmd_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./utils/setLastCmd.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/setLastCmd.js");




/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */













/**
 * CEA-608 caption parser.
 *
 * @group CTA-608
 * @beta
 */
var Cta608Parser = /*#__PURE__*/function () {
  function Cta608Parser(field, out1, out2) {
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, Cta608Parser);
    this.currentChannel = 0;
    this.cmdHistory = (0,_utils_createCmdHistory_js__WEBPACK_IMPORTED_MODULE_8__.createCmdHistory)();
    this.lastTime = null;
    var logger = this.logger = new _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_4__.CaptionsLogger();
    this.channels = [null, new _Cta608Channel_js__WEBPACK_IMPORTED_MODULE_5__.Cta608Channel(field, out1, logger), new _Cta608Channel_js__WEBPACK_IMPORTED_MODULE_5__.Cta608Channel(field + 1, out2, logger)];
  }
  /**
   * Add data for time t in forms of list of bytes (unsigned ints). The bytes are treated as pairs.
   *
   * @param time - The time in milliseconds
   * @param byteList - The list of bytes
   */
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(Cta608Parser, [{
    key: "addData",
    value: function addData(time, byteList) {
      var _this = this;
      this.lastTime = time;
      this.logger.time = time;
      var _loop = function _loop(i) {
          var a = byteList[i] & 0x7f;
          var b = byteList[i + 1] & 0x7f;
          var cmdFound = false;
          var charsFound = null;
          if (_this.lastTime !== null) {
            time = _this.lastTime + 0.5 * i * 1001 / 30000;
            _this.logger.time = time;
          }
          if (a === 0 && b === 0) {
            return 0; // continue
          } else {
            _this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.DATA, function () {
              return '[' + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)([byteList[i], byteList[i + 1]]) + '] -> (' + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)([a, b]) + ')';
            });
          }
          var cmdHistory = _this.cmdHistory;
          var isControlCode = a >= 0x10 && a <= 0x1f;
          if (isControlCode) {
            // Skip redundant control codes
            if ((0,_utils_hasCmdRepeated_js__WEBPACK_IMPORTED_MODULE_10__.hasCmdRepeated)(a, b, cmdHistory)) {
              (0,_utils_setLastCmd_js__WEBPACK_IMPORTED_MODULE_16__.setLastCmd)(null, null, cmdHistory);
              _this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.DEBUG, function () {
                return 'Repeated command (' + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)([a, b]) + ') is dropped';
              });
              return 0; // continue
            }
            (0,_utils_setLastCmd_js__WEBPACK_IMPORTED_MODULE_16__.setLastCmd)(a, b, _this.cmdHistory);
            cmdFound = _this.parseCmd(a, b);
            if (!cmdFound) {
              cmdFound = _this.parseMidrow(a, b);
            }
            if (!cmdFound) {
              cmdFound = _this.parsePAC(a, b);
            }
            if (!cmdFound) {
              cmdFound = _this.parseBackgroundAttributes(a, b);
            }
          } else {
            (0,_utils_setLastCmd_js__WEBPACK_IMPORTED_MODULE_16__.setLastCmd)(null, null, cmdHistory);
          }
          if (!cmdFound) {
            charsFound = _this.parseChars(a, b);
            if (charsFound.length) {
              var currChNr = _this.currentChannel;
              if (currChNr && currChNr > 0) {
                var channel = _this.channels[currChNr];
                channel.insertChars(charsFound);
              } else {
                _this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.WARNING, 'No channel found yet. TEXT-MODE?');
              }
            }
          }
          if (!cmdFound && !charsFound) {
            _this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.WARNING, function () {
              return "Couldn't parse cleaned data " + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)([a, b]) + ' orig: ' + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)([byteList[i], byteList[i + 1]]);
            });
          }
        },
        _ret;
      for (var i = 0; i < byteList.length; i += 2) {
        _ret = _loop(i);
        if (_ret === 0) continue;
      }
    }
    /**
     * Parse Command.
     *
     * @param a - The first byte
     * @param b - The second byte
     * @returns True if a command was found
     */
  }, {
    key: "parseCmd",
    value: function parseCmd(a, b) {
      var cond1 = (a === 0x14 || a === 0x1c || a === 0x15 || a === 0x1d) && b >= 0x20 && b <= 0x2f;
      var cond2 = (a === 0x17 || a === 0x1f) && b >= 0x21 && b <= 0x23;
      if (!(cond1 || cond2)) {
        return false;
      }
      var chNr = a === 0x14 || a === 0x15 || a === 0x17 ? 1 : 2;
      var channel = this.channels[chNr];
      if (a === 0x14 || a === 0x15 || a === 0x1c || a === 0x1d) {
        if (b === 0x20) {
          channel.ccRCL();
        } else if (b === 0x21) {
          channel.ccBS();
        } else if (b === 0x22) {
          channel.ccAOF();
        } else if (b === 0x23) {
          channel.ccAON();
        } else if (b === 0x24) {
          channel.ccDER();
        } else if (b === 0x25) {
          channel.ccRU(2);
        } else if (b === 0x26) {
          channel.ccRU(3);
        } else if (b === 0x27) {
          channel.ccRU(4);
        } else if (b === 0x28) {
          channel.ccFON();
        } else if (b === 0x29) {
          channel.ccRDC();
        } else if (b === 0x2a) {
          channel.ccTR();
        } else if (b === 0x2b) {
          channel.ccRTD();
        } else if (b === 0x2c) {
          channel.ccEDM();
        } else if (b === 0x2d) {
          channel.ccCR();
        } else if (b === 0x2e) {
          channel.ccENM();
        } else if (b === 0x2f) {
          channel.ccEOC();
        }
      } else {
        // a == 0x17 || a == 0x1F
        channel.ccTO(b - 0x20);
      }
      this.currentChannel = chNr;
      return true;
    }
    /**
     * Parse midrow styling command
     *
     * @param a - The first byte
     * @param b - The second byte
     * @returns `true` if midrow styling command was found
     */
  }, {
    key: "parseMidrow",
    value: function parseMidrow(a, b) {
      var chNr = 0;
      if ((a === 0x11 || a === 0x19) && b >= 0x20 && b <= 0x2f) {
        if (a === 0x11) {
          chNr = 1;
        } else {
          chNr = 2;
        }
        if (chNr !== this.currentChannel) {
          this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.ERROR, 'Mismatch channel in midrow parsing');
          return false;
        }
        var channel = this.channels[chNr];
        if (!channel) {
          return false;
        }
        channel.ccMIDROW(b);
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.DEBUG, function () {
          return 'MIDROW (' + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)([a, b]) + ')';
        });
        return true;
      }
      return false;
    }
    /**
     * Parse Preable Access Codes (Table 53).
     *
     * @param a - The first byte
     * @param b - The second byte
     * @returns A Boolean that tells if PAC found
     */
  }, {
    key: "parsePAC",
    value: function parsePAC(a, b) {
      var row;
      var case1 = (a >= 0x11 && a <= 0x17 || a >= 0x19 && a <= 0x1f) && b >= 0x40 && b <= 0x7f;
      var case2 = (a === 0x10 || a === 0x18) && b >= 0x40 && b <= 0x5f;
      if (!(case1 || case2)) {
        return false;
      }
      var chNr = a <= 0x17 ? 1 : 2;
      if (b >= 0x40 && b <= 0x5f) {
        row = chNr === 1 ? _utils_rowsLowCh1_js__WEBPACK_IMPORTED_MODULE_14__.rowsLowCh1[a] : _utils_rowsLowCh2_js__WEBPACK_IMPORTED_MODULE_15__.rowsLowCh2[a];
      } else {
        // 0x60 <= b <= 0x7F
        row = chNr === 1 ? _utils_rowsHighCh1_js__WEBPACK_IMPORTED_MODULE_12__.rowsHighCh1[a] : _utils_rowsHighCh2_js__WEBPACK_IMPORTED_MODULE_13__.rowsHighCh2[a];
      }
      var channel = this.channels[chNr];
      if (!channel) {
        return false;
      }
      channel.setPAC(this.interpretPAC(row, b));
      this.currentChannel = chNr;
      return true;
    }
    /**
     * Interpret the second byte of the pac, and return the information.
     *
     * @param row - The row number
     * @param byte - The second byte
     * @returns pacData with style parameters
     */
  }, {
    key: "interpretPAC",
    value: function interpretPAC(row, byte) {
      var pacIndex;
      var pacData = {
        color: null,
        italics: false,
        indent: null,
        underline: false,
        row: row
      };
      if (byte > 0x5f) {
        pacIndex = byte - 0x60;
      } else {
        pacIndex = byte - 0x40;
      }
      pacData.underline = (pacIndex & 1) === 1;
      if (pacIndex <= 0xd) {
        pacData.color = ['white', 'green', 'blue', 'cyan', 'red', 'yellow', 'magenta', 'white'][Math.floor(pacIndex / 2)];
      } else if (pacIndex <= 0xf) {
        pacData.italics = true;
        pacData.color = 'white';
      } else {
        pacData.indent = Math.floor((pacIndex - 0x10) / 2) * 4;
      }
      return pacData; // Note that row has zero offset. The spec uses 1.
    }
    /**
     * Parse characters.
     *
     * @param a - The first byte
     * @param b - The second byte
     * @returns An array with 1 to 2 codes corresponding to chars, if found. null otherwise.
     */
  }, {
    key: "parseChars",
    value: function parseChars(a, b) {
      var channelNr;
      var charCodes = [];
      var charCode1 = null;
      if (a >= 0x19) {
        channelNr = 2;
        charCode1 = a - 8;
      } else {
        channelNr = 1;
        charCode1 = a;
      }
      if (charCode1 >= 0x11 && charCode1 <= 0x13) {
        // Special character
        var oneCode;
        if (charCode1 === 0x11) {
          oneCode = b + 0x50;
        } else if (charCode1 === 0x12) {
          oneCode = b + 0x70;
        } else {
          oneCode = b + 0x90;
        }
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.INFO, function () {
          return "Special char '" + (0,_utils_getCharForByte_js__WEBPACK_IMPORTED_MODULE_9__.getCharForByte)(oneCode) + "' in channel " + channelNr;
        });
        charCodes = [oneCode];
      } else if (a >= 0x20 && a <= 0x7f) {
        charCodes = b === 0 ? [a] : [a, b];
      }
      if (charCodes) {
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_6__.VerboseLevel.DEBUG, function () {
          return 'Char codes =  ' + (0,_utils_numArrayToHexArray_js__WEBPACK_IMPORTED_MODULE_11__.numArrayToHexArray)(charCodes).join(',');
        });
      }
      return charCodes;
    }
    /**
     * Parse extended background attributes as well as new foreground color black.
     *
     * @param a - The first byte
     * @param b - The second byte
     * @returns True if background attributes are found
     */
  }, {
    key: "parseBackgroundAttributes",
    value: function parseBackgroundAttributes(a, b) {
      var case1 = (a === 0x10 || a === 0x18) && b >= 0x20 && b <= 0x2f;
      var case2 = (a === 0x17 || a === 0x1f) && b >= 0x2d && b <= 0x2f;
      if (!(case1 || case2)) {
        return false;
      }
      var index;
      var bkgData = {};
      if (a === 0x10 || a === 0x18) {
        index = Math.floor((b - 0x20) / 2);
        bkgData.background = _utils_backgroundColors_js__WEBPACK_IMPORTED_MODULE_7__.backgroundColors[index];
        if (b % 2 === 1) {
          bkgData.background = bkgData.background + '_semi';
        }
      } else if (b === 0x2d) {
        bkgData.background = 'transparent';
      } else {
        bkgData.foreground = 'black';
        if (b === 0x2f) {
          bkgData.underline = true;
        }
      }
      var chNr = a <= 0x17 ? 1 : 2;
      var channel = this.channels[chNr];
      channel.setBkgData(bkgData);
      return true;
    }
    /**
     * Reset state of parser and its channels.
     */
  }, {
    key: "reset",
    value: function reset() {
      for (var i = 0; i < Object.keys(this.channels).length; i++) {
        var channel = this.channels[i];
        if (channel) {
          channel.reset();
        }
      }
      (0,_utils_setLastCmd_js__WEBPACK_IMPORTED_MODULE_16__.setLastCmd)(null, null, this.cmdHistory);
    }
    /**
     * Trigger the generation of a cue, and the start of a new one if displayScreens are not empty.
     */
  }, {
    key: "cueSplitAtTime",
    value: function cueSplitAtTime(t) {
      for (var i = 0; i < this.channels.length; i++) {
        var channel = this.channels[i];
        if (channel) {
          channel.cueSplitAtTime(t);
        }
      }
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/PenState.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/PenState.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PenState: function() { return /* binding */ PenState; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");


/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * Pen state.
 *
 * @group CTA-608
 * @beta
 */
var PenState = /*#__PURE__*/function () {
  function PenState() {
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, PenState);
    this.foreground = 'white';
    this.underline = false;
    this.italics = false;
    this.background = 'black';
    this.flash = false;
  }
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(PenState, [{
    key: "reset",
    value: function reset() {
      this.foreground = 'white';
      this.underline = false;
      this.italics = false;
      this.background = 'black';
      this.flash = false;
    }
  }, {
    key: "setStyles",
    value: function setStyles(styles) {
      var attribs = ['foreground', 'underline', 'italics', 'background', 'flash'];
      for (var i = 0; i < attribs.length; i++) {
        var style = attribs[i];
        if (Object.prototype.hasOwnProperty.call(styles, style)) {
          this[style] = styles[style];
        }
      }
    }
  }, {
    key: "isDefault",
    value: function isDefault() {
      return this.foreground === 'white' && !this.underline && !this.italics && this.background === 'black' && !this.flash;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return this.foreground === other.foreground && this.underline === other.underline && this.italics === other.italics && this.background === other.background && this.flash === other.flash;
    }
  }, {
    key: "copy",
    value: function copy(newPenState) {
      this.foreground = newPenState.foreground;
      this.underline = newPenState.underline;
      this.italics = newPenState.italics;
      this.background = newPenState.background;
      this.flash = newPenState.flash;
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/Row.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/Row.js ***!
  \*********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Row: function() { return /* binding */ Row; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./CaptionsLogger.js */ "./node_modules/@svta/common-media-library/dist/cta/608/CaptionsLogger.js");
/* harmony import */ var _PenState_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./PenState.js */ "./node_modules/@svta/common-media-library/dist/cta/608/PenState.js");
/* harmony import */ var _StyledUnicodeChar_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./StyledUnicodeChar.js */ "./node_modules/@svta/common-media-library/dist/cta/608/StyledUnicodeChar.js");
/* harmony import */ var _VerboseLevel_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./VerboseLevel.js */ "./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js");
/* harmony import */ var _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils/NR_COLS.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/NR_COLS.js");
/* harmony import */ var _utils_getCharForByte_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./utils/getCharForByte.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/getCharForByte.js");






/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






/**
 * CTA-608 row consisting of NR_COLS instances of StyledUnicodeChar.
 *
 * @group CTA-608
 * @beta
 */
var Row = /*#__PURE__*/function () {
  function Row() {
    var logger = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new _CaptionsLogger_js__WEBPACK_IMPORTED_MODULE_6__.CaptionsLogger();
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, Row);
    this.chars = [];
    this.cueStartTime = null;
    this.pos = 0;
    this.currPenState = new _PenState_js__WEBPACK_IMPORTED_MODULE_7__.PenState();
    for (var i = 0; i < _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS; i++) {
      this.chars.push(new _StyledUnicodeChar_js__WEBPACK_IMPORTED_MODULE_8__.StyledUnicodeChar());
    }
    this.logger = logger;
  }
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(Row, [{
    key: "equals",
    value: function equals(other) {
      for (var i = 0; i < _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS; i++) {
        if (!this.chars[i].equals(other.chars[i])) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: "copy",
    value: function copy(other) {
      for (var i = 0; i < _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS; i++) {
        this.chars[i].copy(other.chars[i]);
      }
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      var empty = true;
      for (var i = 0; i < _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS; i++) {
        if (!this.chars[i].isEmpty()) {
          empty = false;
          break;
        }
      }
      return empty;
    }
    /**
     *  Set the cursor to a valid column.
     */
  }, {
    key: "setCursor",
    value: function setCursor(absPos) {
      if (this.pos !== absPos) {
        this.pos = absPos;
      }
      if (this.pos < 0) {
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_9__.VerboseLevel.DEBUG, 'Negative cursor position ' + this.pos);
        this.pos = 0;
      } else if (this.pos > _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS) {
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_9__.VerboseLevel.DEBUG, 'Too large cursor position ' + this.pos);
        this.pos = _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS;
      }
    }
    /**
     * Move the cursor relative to current position.
     */
  }, {
    key: "moveCursor",
    value: function moveCursor(relPos) {
      var newPos = this.pos + relPos;
      if (relPos > 1) {
        for (var i = this.pos + 1; i < newPos + 1; i++) {
          this.chars[i].setPenState(this.currPenState);
        }
      }
      this.setCursor(newPos);
    }
    /**
     * Backspace, move one step back and clear character.
     */
  }, {
    key: "backSpace",
    value: function backSpace() {
      this.moveCursor(-1);
      this.chars[this.pos].setChar(' ', this.currPenState);
    }
  }, {
    key: "insertChar",
    value: function insertChar(byte) {
      var _this = this;
      if (byte >= 0x90) {
        // Extended char
        this.backSpace();
      }
      var char = (0,_utils_getCharForByte_js__WEBPACK_IMPORTED_MODULE_11__.getCharForByte)(byte);
      if (this.pos >= _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS) {
        this.logger.log(_VerboseLevel_js__WEBPACK_IMPORTED_MODULE_9__.VerboseLevel.ERROR, function () {
          return 'Cannot insert ' + byte.toString(16) + ' (' + char + ') at position ' + _this.pos + '. Skipping it!';
        });
        return;
      }
      this.chars[this.pos].setChar(char, this.currPenState);
      this.moveCursor(1);
    }
  }, {
    key: "clearFromPos",
    value: function clearFromPos(startPos) {
      var i;
      for (i = startPos; i < _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS; i++) {
        this.chars[i].reset();
      }
    }
  }, {
    key: "clear",
    value: function clear() {
      this.clearFromPos(0);
      this.pos = 0;
      this.currPenState.reset();
    }
  }, {
    key: "clearToEndOfRow",
    value: function clearToEndOfRow() {
      this.clearFromPos(this.pos);
    }
  }, {
    key: "getTextString",
    value: function getTextString() {
      var chars = [];
      var empty = true;
      for (var i = 0; i < _utils_NR_COLS_js__WEBPACK_IMPORTED_MODULE_10__.NR_COLS; i++) {
        var char = this.chars[i].uchar;
        if (char !== ' ') {
          empty = false;
        }
        chars.push(char);
      }
      if (empty) {
        return '';
      } else {
        return chars.join('');
      }
    }
  }, {
    key: "setPenStyles",
    value: function setPenStyles(styles) {
      this.currPenState.setStyles(styles);
      var currChar = this.chars[this.pos];
      currChar.setPenState(this.currPenState);
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/StyledUnicodeChar.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/StyledUnicodeChar.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StyledUnicodeChar: function() { return /* binding */ StyledUnicodeChar; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _PenState_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PenState.js */ "./node_modules/@svta/common-media-library/dist/cta/608/PenState.js");


/**
 *
 * This code was ported from the dash.js project at:
 *   https://github.com/Dash-Industry-Forum/dash.js/blob/development/externals/cea608-parser.js
 *   https://github.com/Dash-Industry-Forum/dash.js/commit/8269b26a761e0853bb21d78780ed945144ecdd4d#diff-71bc295a2d6b6b7093a1d3290d53a4b2
 *
 * The original copyright appears below:
 *
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Unicode character with styling and background.
 *
 * @group CTA-608
 * @beta
 */
var StyledUnicodeChar = /*#__PURE__*/function () {
  function StyledUnicodeChar() {
    (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_0__["default"])(this, StyledUnicodeChar);
    this.uchar = ' ';
    this.penState = new _PenState_js__WEBPACK_IMPORTED_MODULE_2__.PenState();
  }
  return (0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_1__["default"])(StyledUnicodeChar, [{
    key: "reset",
    value: function reset() {
      this.uchar = ' ';
      this.penState.reset();
    }
  }, {
    key: "setChar",
    value: function setChar(uchar, newPenState) {
      this.uchar = uchar;
      this.penState.copy(newPenState);
    }
  }, {
    key: "setPenState",
    value: function setPenState(newPenState) {
      this.penState.copy(newPenState);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return this.uchar === other.uchar && this.penState.equals(other.penState);
    }
  }, {
    key: "copy",
    value: function copy(newChar) {
      this.uchar = newChar.uchar;
      this.penState.copy(newChar.penState);
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return this.uchar === ' ' && this.penState.isDefault();
    }
  }]);
}();

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/VerboseLevel.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   VerboseLevel: function() { return /* binding */ VerboseLevel; }
/* harmony export */ });
/**
 * Logging levels for the CTA-608 parser.
 *
 * @group CTA-608
 *
 * @enum
 *
 * @beta
 */
var VerboseLevel = {
  ERROR: 0,
  TEXT: 1,
  WARNING: 2,
  INFO: 2,
  DEBUG: 3,
  DATA: 3
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/extractCta608DataFromSample.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/extractCta608DataFromSample.js ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   extractCta608DataFromSample: function() { return /* binding */ extractCta608DataFromSample; }
/* harmony export */ });
/* harmony import */ var _utils_seiHelpers_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/seiHelpers.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/seiHelpers.js");

/**
 * Extracts CEA-608 data from a given sample.
 *
 * @param raw - The DataView with media data
 * @param startPos - The start position within the DataView
 * @param sampleSize - The size of the sample in bytes
 * @returns fieldData array containing field 1 and field 2 data arrays
 *
 * @group CTA-608
 * @beta
 */
function extractCta608DataFromSample(raw, startPos, sampleSize) {
  var nalSize = 0;
  var nalType = 0;
  var fieldData = [[], []];
  for (var cursor = startPos; cursor < startPos + sampleSize - 5; cursor++) {
    nalSize = raw.getUint32(cursor);
    nalType = raw.getUint8(cursor + 4) & 0x1F;
    // Make sure that we don't go out of bounds
    if (cursor + 5 + nalSize > startPos + sampleSize) {
      break;
    }
    // Only process Supplemental Enhancement Information (SEI) NAL units
    if ((0,_utils_seiHelpers_js__WEBPACK_IMPORTED_MODULE_0__.isSeiNalUnitType)(nalType)) {
      if (cursor + 5 + nalSize <= raw.byteLength) {
        var seiData = (0,_utils_seiHelpers_js__WEBPACK_IMPORTED_MODULE_0__.getSeiData)(raw, cursor + 5, cursor + 5 + nalSize);
        (0,_utils_seiHelpers_js__WEBPACK_IMPORTED_MODULE_0__.parseCta608DataFromSei)(seiData, fieldData);
      }
    }
    // Jump to the next NAL unit
    cursor += nalSize + 3;
  }
  return fieldData;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/NR_COLS.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/NR_COLS.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NR_COLS: function() { return /* binding */ NR_COLS; }
/* harmony export */ });
var NR_COLS = 100;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/NR_ROWS.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/NR_ROWS.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   NR_ROWS: function() { return /* binding */ NR_ROWS; }
/* harmony export */ });
var NR_ROWS = 15;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/backgroundColors.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/backgroundColors.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   backgroundColors: function() { return /* binding */ backgroundColors; }
/* harmony export */ });
var backgroundColors = ['white', 'green', 'blue', 'cyan', 'red', 'yellow', 'magenta', 'black', 'transparent'];

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/createCmdHistory.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/createCmdHistory.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCmdHistory: function() { return /* binding */ createCmdHistory; }
/* harmony export */ });
function createCmdHistory() {
  return {
    a: null,
    b: null
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/getCharForByte.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/getCharForByte.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCharForByte: function() { return /* binding */ getCharForByte; }
/* harmony export */ });
/* harmony import */ var _specialCea608CharsCodes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./specialCea608CharsCodes.js */ "./node_modules/@svta/common-media-library/dist/cta/608/utils/specialCea608CharsCodes.js");

var getCharForByte = function getCharForByte(byte) {
  return String.fromCharCode(_specialCea608CharsCodes_js__WEBPACK_IMPORTED_MODULE_0__.specialCea608CharsCodes[byte] || byte);
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/hasCmdRepeated.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/hasCmdRepeated.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasCmdRepeated: function() { return /* binding */ hasCmdRepeated; }
/* harmony export */ });
function hasCmdRepeated(a, b, cmdHistory) {
  return cmdHistory.a === a && cmdHistory.b === b;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/numArrayToHexArray.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/numArrayToHexArray.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   numArrayToHexArray: function() { return /* binding */ numArrayToHexArray; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2__);



var numArrayToHexArray = function numArrayToHexArray(numArray) {
  var hexArray = [];
  for (var j = 0; j < numArray.length; j++) {
    hexArray.push(numArray[j].toString(16));
  }
  return hexArray;
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsHighCh1.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsHighCh1.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rowsHighCh1: function() { return /* binding */ rowsHighCh1; }
/* harmony export */ });
var rowsHighCh1 = {
  17: 2,
  18: 4,
  21: 6,
  22: 8,
  23: 10,
  19: 13,
  20: 15
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsHighCh2.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsHighCh2.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rowsHighCh2: function() { return /* binding */ rowsHighCh2; }
/* harmony export */ });
var rowsHighCh2 = {
  25: 2,
  26: 4,
  29: 6,
  30: 8,
  31: 10,
  27: 13,
  28: 15
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsLowCh1.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsLowCh1.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rowsLowCh1: function() { return /* binding */ rowsLowCh1; }
/* harmony export */ });
// Tables to look up row from PAC data
var rowsLowCh1 = {
  17: 1,
  18: 3,
  21: 5,
  22: 7,
  23: 9,
  16: 11,
  19: 12,
  20: 14
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsLowCh2.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/rowsLowCh2.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rowsLowCh2: function() { return /* binding */ rowsLowCh2; }
/* harmony export */ });
var rowsLowCh2 = {
  25: 1,
  26: 3,
  29: 5,
  30: 7,
  31: 9,
  24: 11,
  27: 12,
  28: 14
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/seiHelpers.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/seiHelpers.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getSeiData: function() { return /* binding */ getSeiData; },
/* harmony export */   isCCType: function() { return /* binding */ isCCType; },
/* harmony export */   isCea608Sei: function() { return /* binding */ isCea608Sei; },
/* harmony export */   isNonEmptyCCData: function() { return /* binding */ isNonEmptyCCData; },
/* harmony export */   isSeiNalUnitType: function() { return /* binding */ isSeiNalUnitType; },
/* harmony export */   parseCta608DataFromSei: function() { return /* binding */ parseCta608DataFromSei; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_35__);
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_36___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_36__);





































function getSeiData(raw, startPos, endPos) {
  var data = [];
  for (var cursor = startPos; cursor < endPos; cursor++) {
    if (cursor + 2 < endPos && raw.getUint8(cursor) === 0x00 && raw.getUint8(cursor + 1) === 0x00 && raw.getUint8(cursor + 2) === 0x03) {
      data.push(0x00);
      data.push(0x00);
      cursor += 2;
    } else {
      data.push(raw.getUint8(cursor));
    }
  }
  return new DataView(new Uint8Array(data).buffer);
}
function isCea608Sei(payloadType, payloadSize, sei, pos) {
  if (payloadType !== 4 || payloadSize < 8) {
    return false;
  }
  var countryCode = sei.getUint8(pos);
  if (countryCode !== 0xB5) {
    return false;
  }
  var providerCode = sei.getUint16(pos + 1);
  if (providerCode !== 0x0031) {
    return false;
  }
  var userIdentifier = sei.getUint32(pos + 3);
  if (userIdentifier !== 0x47413934) {
    return false;
  }
  var userDataTypeCode = sei.getUint8(pos + 7);
  if (userDataTypeCode !== 0x03) {
    return false;
  }
  return true;
}
function isCCType(type) {
  return type === 0 || type === 1;
}
function isNonEmptyCCData(ccData1, ccData2) {
  return (ccData1 & 0x7F) > 0 || (ccData2 & 0x7F) > 0;
}
function isSeiNalUnitType(unitType) {
  return unitType === 0x06;
}
function parseCta608DataFromSei(sei, fieldData) {
  var cursor = 0;
  while (cursor < sei.byteLength) {
    var payloadType = 0;
    var payloadSize = 0;
    var now = void 0;
    do {
      payloadType += now = sei.getUint8(cursor++);
    } while (now === 0xFF);
    do {
      payloadSize += now = sei.getUint8(cursor++);
    } while (now === 0xFF);
    if (isCea608Sei(payloadType, payloadSize, sei, cursor)) {
      var pos = cursor + 10;
      var ccCount = pos + (sei.getUint8(pos - 2) & 0x1F) * 3;
      for (var i = pos; i < ccCount; i += 3) {
        var byte = sei.getUint8(i);
        if (byte & 0x04) {
          var ccType = byte & 0x03;
          if (isCCType(ccType)) {
            var ccData1 = sei.getUint8(i + 1);
            var ccData2 = sei.getUint8(i + 2);
            if (isNonEmptyCCData(ccData1, ccData2)) {
              fieldData[ccType].push(ccData1, ccData2);
            }
          }
        }
      }
    }
    cursor += payloadSize;
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/setLastCmd.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/setLastCmd.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setLastCmd: function() { return /* binding */ setLastCmd; }
/* harmony export */ });
function setLastCmd(a, b, cmdHistory) {
  cmdHistory.a = a;
  cmdHistory.b = b;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/608/utils/specialCea608CharsCodes.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/608/utils/specialCea608CharsCodes.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   specialCea608CharsCodes: function() { return /* binding */ specialCea608CharsCodes; }
/* harmony export */ });
/**
 *  Exceptions from regular ASCII. CodePoints are mapped to UTF-16 codes
 */
var specialCea608CharsCodes = {
  42: 225,
  // lowercase a, acute accent
  92: 233,
  // lowercase e, acute accent
  94: 237,
  // lowercase i, acute accent
  95: 243,
  // lowercase o, acute accent
  96: 250,
  // lowercase u, acute accent
  123: 231,
  // lowercase c with cedilla
  124: 247,
  // division symbol
  125: 209,
  // uppercase N tilde
  126: 241,
  // lowercase n tilde
  127: 9608,
  // Full block
  // THIS BLOCK INCLUDES THE 16 EXTENDED (TWO-BYTE) LINE 21 CHARACTERS
  // THAT COME FROM HI BYTE=0x11 AND LOW BETWEEN 0x30 AND 0x3F
  // THIS MEANS THAT \x50 MUST BE ADDED TO THE VALUES
  128: 174,
  // Registered symbol (R)
  129: 176,
  // degree sign
  130: 189,
  // 1/2 symbolOutputFilter
  131: 191,
  // Inverted (open) question mark
  132: 8482,
  // Trademark symbol (TM)
  133: 162,
  // Cents symbol
  134: 163,
  // Pounds sterling
  135: 9834,
  // Music 8'th note
  136: 224,
  // lowercase a, grave accent
  137: 32,
  // transparent space (regular)
  138: 232,
  // lowercase e, grave accent
  139: 226,
  // lowercase a, circumflex accent
  140: 234,
  // lowercase e, circumflex accent
  141: 238,
  // lowercase i, circumflex accent
  142: 244,
  // lowercase o, circumflex accent
  143: 251,
  // lowercase u, circumflex accent
  // THIS BLOCK INCLUDES THE 32 EXTENDED (TWO-BYTE) LINE 21 CHARACTERS
  // THAT COME FROM HI BYTE=0x12 AND LOW BETWEEN 0x20 AND 0x3F
  144: 193,
  // capital letter A with acute
  145: 201,
  // capital letter E with acute
  146: 211,
  // capital letter O with acute
  147: 218,
  // capital letter U with acute
  148: 220,
  // capital letter U with diaresis
  149: 252,
  // lowercase letter U with diaeresis
  150: 8216,
  // opening single quote
  151: 161,
  // inverted exclamation mark
  152: 42,
  // asterisk
  153: 8217,
  // closing single quote
  154: 9473,
  // box drawings heavy horizontal
  155: 169,
  // copyright sign
  156: 8480,
  // Service mark
  157: 8226,
  // (round) bullet
  158: 8220,
  // Left double quotation mark
  159: 8221,
  // Right double quotation mark
  160: 192,
  // uppercase A, grave accent
  161: 194,
  // uppercase A, circumflex
  162: 199,
  // uppercase C with cedilla
  163: 200,
  // uppercase E, grave accent
  164: 202,
  // uppercase E, circumflex
  165: 203,
  // capital letter E with diaresis
  166: 235,
  // lowercase letter e with diaresis
  167: 206,
  // uppercase I, circumflex
  168: 207,
  // uppercase I, with diaresis
  169: 239,
  // lowercase i, with diaresis
  170: 212,
  // uppercase O, circumflex
  171: 217,
  // uppercase U, grave accent
  172: 249,
  // lowercase u, grave accent
  173: 219,
  // uppercase U, circumflex
  174: 171,
  // left-pointing double angle quotation mark
  175: 187,
  // right-pointing double angle quotation mark
  // THIS BLOCK INCLUDES THE 32 EXTENDED (TWO-BYTE) LINE 21 CHARACTERS
  // THAT COME FROM HI BYTE=0x13 AND LOW BETWEEN 0x20 AND 0x3F
  176: 195,
  // Uppercase A, tilde
  177: 227,
  // Lowercase a, tilde
  178: 205,
  // Uppercase I, acute accent
  179: 204,
  // Uppercase I, grave accent
  180: 236,
  // Lowercase i, grave accent
  181: 210,
  // Uppercase O, grave accent
  182: 242,
  // Lowercase o, grave accent
  183: 213,
  // Uppercase O, tilde
  184: 245,
  // Lowercase o, tilde
  185: 123,
  // Open curly brace
  186: 125,
  // Closing curly brace
  187: 92,
  // Backslash
  188: 94,
  // Caret
  189: 95,
  // Underscore
  190: 124,
  // Pipe (vertical line)
  191: 8764,
  // Tilde operator
  192: 196,
  // Uppercase A, umlaut
  193: 228,
  // Lowercase A, umlaut
  194: 214,
  // Uppercase O, umlaut
  195: 246,
  // Lowercase o, umlaut
  196: 223,
  // Esszett (sharp S)
  197: 165,
  // Yen symbolOutputFilter
  198: 164,
  // Generic currency sign
  199: 9475,
  // Box drawings heavy vertical
  200: 197,
  // Uppercase A, ring
  201: 229,
  // Lowercase A, ring
  202: 216,
  // Uppercase O, stroke
  203: 248,
  // Lowercase o, strok
  204: 9487,
  // Box drawings heavy down and right
  205: 9491,
  // Box drawings heavy down and left
  206: 9495,
  // Box drawings heavy up and right
  207: 9499 // Box drawings heavy up and left
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/CmObjectType.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmObjectType: function() { return /* binding */ CmObjectType; }
/* harmony export */ });
/**
 * Common Media Object Type
 *
 * @internal
 */
var CmObjectType = {
  /**
   * text file, such as a manifest or playlist
   */
  MANIFEST: 'm',
  /**
   * audio only
   */
  AUDIO: 'a',
  /**
   * video only
   */
  VIDEO: 'v',
  /**
   * muxed audio and video
   */
  MUXED: 'av',
  /**
   * init segment
   */
  INIT: 'i',
  /**
   * caption or subtitle
   */
  CAPTION: 'c',
  /**
   * ISOBMFF timed text track
   */
  TIMED_TEXT: 'tt',
  /**
   * cryptographic key, license or certificate.
   */
  KEY: 'k',
  /**
   * other
   */
  OTHER: 'o'
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/CmStreamType.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/CmStreamType.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmStreamType: function() { return /* binding */ CmStreamType; }
/* harmony export */ });
/**
 * Common Media Stream Type
 *
 * @internal
 */
var CmStreamType = {
  /**
   *  All segments are available – e.g., VOD
   */
  VOD: 'v',
  /**
   * Segments become available over time – e.g., LIVE
   */
  LIVE: 'l'
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/CmStreamingFormat.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/CmStreamingFormat.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CmStreamingFormat: function() { return /* binding */ CmStreamingFormat; }
/* harmony export */ });
/**
 * Common Media Streaming Format
 *
 * @internal
 */
var CmStreamingFormat = {
  /**
   * MPEG DASH
   */
  DASH: 'd',
  /**
   * HTTP Live Streaming (HLS)
   */
  HLS: 'h',
  /**
   * Smooth Streaming
   */
  SMOOTH: 's',
  /**
   * Other
   */
  OTHER: 'o'
};

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/utils/isTokenField.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/utils/isTokenField.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isTokenField: function() { return /* binding */ isTokenField; }
/* harmony export */ });
/**
 * Checks if the given key is a token field.
 *
 * @param key - The key to check.
 *
 * @returns `true` if the key is a token field.
 *
 * @internal
 */
function isTokenField(key) {
  return key === 'ot' || key === 'sf' || key === 'st';
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/utils/isValid.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/utils/isValid.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isValid: function() { return /* binding */ isValid; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_number_is_finite_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.is-finite.js */ "./node_modules/core-js/modules/es.number.is-finite.js");
/* harmony import */ var core_js_modules_es_number_is_finite_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_is_finite_js__WEBPACK_IMPORTED_MODULE_0__);

/**
 * Checks if the given value is valid
 *
 * @param value - The value to check.
 *
 * @returns `true` if the key is a value is valid.
 *
 * @internal
 */
function isValid(value) {
  if (typeof value === 'number') {
    return Number.isFinite(value);
  }
  return value != null && value !== '' && value !== false;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js ***!
  \*******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   symbolToStr: function() { return /* binding */ symbolToStr; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_4__);





/**
 * Converts a symbol to a string.
 *
 * @param symbol - The symbol to convert.
 *
 * @returns The string representation of the symbol.
 *
 * @internal
 */
function symbolToStr(symbol) {
  return symbol.description || symbol.toString().slice(7, -1);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/dash/processUriTemplate.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/dash/processUriTemplate.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   processUriTemplate: function() { return /* binding */ processUriTemplate; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_pad_start_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.pad-start.js */ "./node_modules/core-js/modules/es.string.pad-start.js");
/* harmony import */ var core_js_modules_es_string_pad_start_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_pad_start_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_4__);





var TOKENS = /\$(RepresentationID|Number|SubNumber|Bandwidth|Time)?(?:%0([0-9]+)([diouxX]))?\$/g;
/**
 * Process a URI template used in `SegmentTemplate` nodes.
 *
 * @param uriTemplate - URI template to process.
 * @param representationId - Representation ID.
 * @param number - Number.
 * @param subNumber - Sub-number.
 * @param bandwidth - Bandwidth.
 * @param time - Time. Should be passed as a number unless the value is larger than `MAX_SAFE_INTEGER`, then it should be provided as a string. If the value is a string all format tags will be ignored.
 *
 * @returns Processed URI template.
 *
 * @group DASH
 * @beta
 *
 * @example
 * {@includeCode ../../test/dash/processUriTemplate.test.ts#example}
 */
function processUriTemplate(uriTemplate, representationId, number, subNumber, bandwidth, time) {
  var uri = uriTemplate.replace(TOKENS, function (match, name, widthStr, format) {
    var value;
    switch (name) {
      case undefined:
        // $$ case
        return '$';
      case 'RepresentationID':
        value = representationId;
        break;
      case 'Number':
        value = number;
        break;
      case 'SubNumber':
        value = subNumber;
        break;
      case 'Bandwidth':
        value = bandwidth;
        break;
      case 'Time':
        if (typeof time === 'string') {
          return time;
        }
        value = time ? Math.round(time) : time;
        break;
      default:
        value = null;
    }
    if (value == null) {
      return match;
    }
    var valueString;
    switch (format) {
      case undefined: // Happens if there is no format specifier.
      case 'd':
      case 'i':
      case 'u':
        valueString = value.toString();
        break;
      case 'o':
        valueString = value.toString(8);
        break;
      case 'x':
        valueString = value.toString(16);
        break;
      case 'X':
        valueString = value.toString(16).toUpperCase();
        break;
      default:
        valueString = value.toString();
        break;
    }
    var width = parseInt(widthStr, 10) || 1;
    return valueString.padStart(width, '0');
  });
  return uri;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/getId3Frames.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/getId3Frames.js ***!
  \**************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getId3Frames: function() { return /* binding */ getId3Frames; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _util_decodeId3Frame_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./util/decodeId3Frame.js */ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3Frame.js");
/* harmony import */ var _util_getId3FrameData_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./util/getId3FrameData.js */ "./node_modules/@svta/common-media-library/dist/id3/util/getId3FrameData.js");
/* harmony import */ var _util_isId3Footer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./util/isId3Footer.js */ "./node_modules/@svta/common-media-library/dist/id3/util/isId3Footer.js");
/* harmony import */ var _util_isId3Header_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./util/isId3Header.js */ "./node_modules/@svta/common-media-library/dist/id3/util/isId3Header.js");
/* harmony import */ var _util_readId3Size_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./util/readId3Size.js */ "./node_modules/@svta/common-media-library/dist/id3/util/readId3Size.js");






var HEADER_FOOTER_SIZE = 10;
var FRAME_SIZE = 10;
/**
 * Returns an array of ID3 frames found in all the ID3 tags in the id3Data
 *
 * @param id3Data - The ID3 data containing one or more ID3 tags
 *
 * @returns Array of ID3 frame objects
 *
 * @group ID3
 *
 * @beta
 */
function getId3Frames(id3Data) {
  var offset = 0;
  var frames = [];
  while ((0,_util_isId3Header_js__WEBPACK_IMPORTED_MODULE_4__.isId3Header)(id3Data, offset)) {
    var size = (0,_util_readId3Size_js__WEBPACK_IMPORTED_MODULE_5__.readId3Size)(id3Data, offset + 6);
    if (id3Data[offset + 5] >> 6 & 1) {
      // skip extended header
      offset += HEADER_FOOTER_SIZE;
    }
    // skip past ID3 header
    offset += HEADER_FOOTER_SIZE;
    var end = offset + size;
    // loop through frames in the ID3 tag
    while (offset + FRAME_SIZE < end) {
      var frameData = (0,_util_getId3FrameData_js__WEBPACK_IMPORTED_MODULE_2__.getId3FrameData)(id3Data.subarray(offset));
      var frame = (0,_util_decodeId3Frame_js__WEBPACK_IMPORTED_MODULE_1__.decodeId3Frame)(frameData);
      if (frame) {
        frames.push(frame);
      }
      // skip frame header and frame data
      offset += frameData.size + HEADER_FOOTER_SIZE;
    }
    if ((0,_util_isId3Footer_js__WEBPACK_IMPORTED_MODULE_3__.isId3Footer)(id3Data, offset)) {
      offset += HEADER_FOOTER_SIZE;
    }
  }
  return frames;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3Frame.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/decodeId3Frame.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeId3Frame: function() { return /* binding */ decodeId3Frame; }
/* harmony export */ });
/* harmony import */ var _decodeId3ImageFrame_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./decodeId3ImageFrame.js */ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3ImageFrame.js");
/* harmony import */ var _decodeId3PrivFrame_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./decodeId3PrivFrame.js */ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3PrivFrame.js");
/* harmony import */ var _decodeId3TextFrame_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./decodeId3TextFrame.js */ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3TextFrame.js");
/* harmony import */ var _decodeId3UrlFrame_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./decodeId3UrlFrame.js */ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3UrlFrame.js");




/**
 * Decode an ID3 frame.
 *
 * @param frame - the ID3 frame
 *
 * @returns The decoded ID3 frame
 *
 * @internal
 *
 * @group ID3
 */
function decodeId3Frame(frame) {
  if (frame.type === 'PRIV') {
    return (0,_decodeId3PrivFrame_js__WEBPACK_IMPORTED_MODULE_1__.decodeId3PrivFrame)(frame);
  } else if (frame.type[0] === 'W') {
    return (0,_decodeId3UrlFrame_js__WEBPACK_IMPORTED_MODULE_3__.decodeId3UrlFrame)(frame);
  } else if (frame.type === 'APIC') {
    return (0,_decodeId3ImageFrame_js__WEBPACK_IMPORTED_MODULE_0__.decodeId3ImageFrame)(frame);
  }
  return (0,_decodeId3TextFrame_js__WEBPACK_IMPORTED_MODULE_2__.decodeId3TextFrame)(frame);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3ImageFrame.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/decodeId3ImageFrame.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeId3ImageFrame: function() { return /* binding */ decodeId3ImageFrame; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/utf8ArrayToStr.js */ "./node_modules/@svta/common-media-library/dist/utils/utf8ArrayToStr.js");
/* harmony import */ var _toArrayBuffer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./toArrayBuffer.js */ "./node_modules/@svta/common-media-library/dist/id3/util/toArrayBuffer.js");
/* harmony import */ var _utf8_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utf8.js */ "./node_modules/@svta/common-media-library/dist/id3/util/utf8.js");





function decodeId3ImageFrame(frame) {
  var metadataFrame = {
    key: frame.type,
    description: '',
    data: '',
    mimeType: null,
    pictureType: null
  };
  var utf8Encoding = 0x03;
  if (frame.size < 2) {
    return undefined;
  }
  if (frame.data[0] !== utf8Encoding) {
    console.log('Ignore frame with unrecognized character ' + 'encoding');
    return undefined;
  }
  var mimeTypeEndIndex = frame.data.subarray(1).indexOf(0);
  if (mimeTypeEndIndex === -1) {
    return undefined;
  }
  var mimeType = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_2__.utf8ArrayToStr)((0,_utf8_js__WEBPACK_IMPORTED_MODULE_4__.toUint8)(frame.data, 1, mimeTypeEndIndex));
  var pictureType = frame.data[2 + mimeTypeEndIndex];
  var descriptionEndIndex = frame.data.subarray(3 + mimeTypeEndIndex).indexOf(0);
  if (descriptionEndIndex === -1) {
    return undefined;
  }
  var description = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_2__.utf8ArrayToStr)((0,_utf8_js__WEBPACK_IMPORTED_MODULE_4__.toUint8)(frame.data, 3 + mimeTypeEndIndex, descriptionEndIndex));
  var data;
  if (mimeType === '-->') {
    data = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_2__.utf8ArrayToStr)((0,_utf8_js__WEBPACK_IMPORTED_MODULE_4__.toUint8)(frame.data, 4 + mimeTypeEndIndex + descriptionEndIndex));
  } else {
    data = (0,_toArrayBuffer_js__WEBPACK_IMPORTED_MODULE_3__.toArrayBuffer)(frame.data.subarray(4 + mimeTypeEndIndex + descriptionEndIndex));
  }
  metadataFrame.mimeType = mimeType;
  metadataFrame.pictureType = pictureType;
  metadataFrame.description = description;
  metadataFrame.data = data;
  return metadataFrame;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3PrivFrame.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/decodeId3PrivFrame.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeId3PrivFrame: function() { return /* binding */ decodeId3PrivFrame; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35__);
/* harmony import */ var _utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../utils/utf8ArrayToStr.js */ "./node_modules/@svta/common-media-library/dist/utils/utf8ArrayToStr.js");





































/**
 * Decode an ID3 PRIV frame.
 *
 * @param frame - the ID3 PRIV frame
 *
 * @returns The decoded ID3 PRIV frame
 *
 * @internal
 *
 * @group ID3
 */
function decodeId3PrivFrame(frame) {
  /*
  Format: <text string>\0<binary data>
  */
  if (frame.size < 2) {
    return undefined;
  }
  var owner = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_36__.utf8ArrayToStr)(frame.data, true);
  var privateData = new Uint8Array(frame.data.subarray(owner.length + 1));
  return {
    key: frame.type,
    info: owner,
    data: privateData.buffer
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3TextFrame.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/decodeId3TextFrame.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeId3TextFrame: function() { return /* binding */ decodeId3TextFrame; }
/* harmony export */ });
/* harmony import */ var _utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/utf8ArrayToStr.js */ "./node_modules/@svta/common-media-library/dist/utils/utf8ArrayToStr.js");

/**
 * Decodes an ID3 text frame
 *
 * @param frame - the ID3 text frame
 *
 * @returns The decoded ID3 text frame
 *
 * @internal
 *
 * @group ID3
 */
function decodeId3TextFrame(frame) {
  if (frame.size < 2) {
    return undefined;
  }
  if (frame.type === 'TXXX') {
    /*
    Format:
    [0]   = {Text Encoding}
    [1-?] = {Description}\0{Value}
    */
    var index = 1;
    var description = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__.utf8ArrayToStr)(frame.data.subarray(index), true);
    index += description.length + 1;
    var value = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__.utf8ArrayToStr)(frame.data.subarray(index));
    return {
      key: frame.type,
      info: description,
      data: value
    };
  }
  /*
  Format:
  [0]   = {Text Encoding}
  [1-?] = {Value}
  */
  var text = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__.utf8ArrayToStr)(frame.data.subarray(1));
  return {
    key: frame.type,
    info: '',
    data: text
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/decodeId3UrlFrame.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/decodeId3UrlFrame.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeId3UrlFrame: function() { return /* binding */ decodeId3UrlFrame; }
/* harmony export */ });
/* harmony import */ var _utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/utf8ArrayToStr.js */ "./node_modules/@svta/common-media-library/dist/utils/utf8ArrayToStr.js");

/**
 * Decode a URL frame
 *
 * @param frame - the ID3 URL frame
 *
 * @returns The decoded ID3 URL frame
 *
 * @internal
 *
 * @group ID3
 */
function decodeId3UrlFrame(frame) {
  if (frame.type === 'WXXX') {
    /*
    Format:
    [0]   = {Text Encoding}
    [1-?] = {Description}\0{URL}
    */
    if (frame.size < 2) {
      return undefined;
    }
    var index = 1;
    var description = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__.utf8ArrayToStr)(frame.data.subarray(index), true);
    index += description.length + 1;
    var value = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__.utf8ArrayToStr)(frame.data.subarray(index));
    return {
      key: frame.type,
      info: description,
      data: value
    };
  }
  /*
  Format:
  [0-?] = {URL}
  */
  var url = (0,_utils_utf8ArrayToStr_js__WEBPACK_IMPORTED_MODULE_0__.utf8ArrayToStr)(frame.data);
  return {
    key: frame.type,
    info: '',
    data: url
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/getId3FrameData.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/getId3FrameData.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getId3FrameData: function() { return /* binding */ getId3FrameData; }
/* harmony export */ });
/* harmony import */ var _readId3Size_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./readId3Size.js */ "./node_modules/@svta/common-media-library/dist/id3/util/readId3Size.js");

/**
 * Returns the data of an ID3 frame.
 *
 * @param data - The data to read from
 *
 * @returns The data of the ID3 frame
 *
 * @internal
 *
 * @group ID3
 */
function getId3FrameData(data) {
  /*
  Frame ID       $xx xx xx xx (four characters)
  Size           $xx xx xx xx
  Flags          $xx xx
  */
  var type = String.fromCharCode(data[0], data[1], data[2], data[3]);
  var size = (0,_readId3Size_js__WEBPACK_IMPORTED_MODULE_0__.readId3Size)(data, 4);
  // skip frame id, size, and flags
  var offset = 10;
  return {
    type: type,
    size: size,
    data: data.subarray(offset, offset + size)
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/isId3Footer.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/isId3Footer.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isId3Footer: function() { return /* binding */ isId3Footer; }
/* harmony export */ });
/**
 * Returns true if an ID3 footer can be found at offset in data
 *
 * @param data - The data to search in
 * @param offset - The offset at which to start searching
 *
 * @returns `true` if an ID3 footer is found
 *
 * @internal
 *
 * @group ID3
 */
function isId3Footer(data, offset) {
  /*
   * The footer is a copy of the header, but with a different identifier
   */
  if (offset + 10 <= data.length) {
    // look for '3DI' identifier
    if (data[offset] === 0x33 && data[offset + 1] === 0x44 && data[offset + 2] === 0x49) {
      // check version is within range
      if (data[offset + 3] < 0xff && data[offset + 4] < 0xff) {
        // check size is within range
        if (data[offset + 6] < 0x80 && data[offset + 7] < 0x80 && data[offset + 8] < 0x80 && data[offset + 9] < 0x80) {
          return true;
        }
      }
    }
  }
  return false;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/isId3Header.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/isId3Header.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isId3Header: function() { return /* binding */ isId3Header; }
/* harmony export */ });
/**
 * Returns true if an ID3 header can be found at offset in data
 *
 * @param data - The data to search in
 * @param offset - The offset at which to start searching
 *
 * @returns `true` if an ID3 header is found
 *
 * @internal
 *
 * @group ID3
 */
function isId3Header(data, offset) {
  /*
   * http://id3.org/id3v2.3.0
   * [0]     = 'I'
   * [1]     = 'D'
   * [2]     = '3'
   * [3,4]   = {Version}
   * [5]     = {Flags}
   * [6-9]   = {ID3 Size}
   *
   * An ID3v2 tag can be detected with the following pattern:
   *  $49 44 33 yy yy xx zz zz zz zz
   * Where yy is less than $FF, xx is the 'flags' byte and zz is less than $80
   */
  if (offset + 10 <= data.length) {
    // look for 'ID3' identifier
    if (data[offset] === 0x49 && data[offset + 1] === 0x44 && data[offset + 2] === 0x33) {
      // check version is within range
      if (data[offset + 3] < 0xff && data[offset + 4] < 0xff) {
        // check size is within range
        if (data[offset + 6] < 0x80 && data[offset + 7] < 0x80 && data[offset + 8] < 0x80 && data[offset + 9] < 0x80) {
          return true;
        }
      }
    }
  }
  return false;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/readId3Size.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/readId3Size.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   readId3Size: function() { return /* binding */ readId3Size; }
/* harmony export */ });
/**
 * Read ID3 size
 *
 * @param data - The data to read from
 * @param offset - The offset at which to start reading
 *
 * @returns The size
 *
 * @internal
 *
 * @group ID3
 */
function readId3Size(data, offset) {
  var size = 0;
  size = (data[offset] & 0x7f) << 21;
  size |= (data[offset + 1] & 0x7f) << 14;
  size |= (data[offset + 2] & 0x7f) << 7;
  size |= data[offset + 3] & 0x7f;
  return size;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/toArrayBuffer.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/toArrayBuffer.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toArrayBuffer: function() { return /* binding */ toArrayBuffer; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35__);




































function toArrayBuffer(view) {
  if (view instanceof ArrayBuffer) {
    return view;
  } else {
    if (view.byteOffset == 0 && view.byteLength == view.buffer.byteLength) {
      // This is a TypedArray over the whole buffer.
      return view.buffer;
    }
    // This is a 'view' on the buffer.  Create a new buffer that only contains
    // the data.  Note that since this isn't an ArrayBuffer, the 'new' call
    // will allocate a new buffer to hold the copy.
    return new Uint8Array(view).buffer;
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/id3/util/utf8.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/id3/util/utf8.js ***!
  \***********************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   toUint8: function() { return /* binding */ toUint8; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_35__);




































function toUint8(data) {
  var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var length = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Infinity;
  return view(data, offset, length, Uint8Array);
}
function view(data, offset, length, Type) {
  var buffer = unsafeGetArrayBuffer(data);
  var bytesPerElement = 1;
  if ('BYTES_PER_ELEMENT' in Type) {
    bytesPerElement = Type.BYTES_PER_ELEMENT;
  }
  // Absolute end of the |data| view within |buffer|.
  var dataOffset = isArrayBufferView(data) ? data.byteOffset : 0;
  var dataEnd = (dataOffset + data.byteLength) / bytesPerElement;
  // Absolute start of the result within |buffer|.
  var rawStart = (dataOffset + offset) / bytesPerElement;
  var start = Math.floor(Math.max(0, Math.min(rawStart, dataEnd)));
  // Absolute end of the result within |buffer|.
  var end = Math.floor(Math.min(start + Math.max(length, 0), dataEnd));
  return new Type(buffer, start, end - start);
}
function unsafeGetArrayBuffer(view) {
  if (view instanceof ArrayBuffer) {
    return view;
  } else {
    return view.buffer;
  }
}
function isArrayBufferView(obj) {
  return obj && obj.buffer instanceof ArrayBuffer && obj.byteLength !== undefined && obj.byteOffset !== undefined;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js":
/*!********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js ***!
  \********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SfItem: function() { return /* binding */ SfItem; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2__);



/**
 * Structured Field Item
 *
 * @group Structured Field
 *
 * @beta
 */
var SfItem = /*#__PURE__*/(0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_0__["default"])(function SfItem(value, params) {
  (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__["default"])(this, SfItem);
  if (Array.isArray(value)) {
    value = value.map(function (v) {
      return v instanceof SfItem ? v : new SfItem(v);
    });
  }
  this.value = value;
  this.params = params;
});

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   SfToken: function() { return /* binding */ SfToken; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/createClass */ "./node_modules/@babel/runtime/helpers/esm/createClass.js");
/* harmony import */ var _babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/classCallCheck */ "./node_modules/@babel/runtime/helpers/esm/classCallCheck.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
/* harmony import */ var core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
/* harmony import */ var core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_symbol_description_js__WEBPACK_IMPORTED_MODULE_3__);




/**
 * A class to represent structured field tokens when `Symbol` is not available.
 *
 * @group Structured Field
 *
 * @beta
 */
var SfToken = /*#__PURE__*/(0,_babel_runtime_helpers_createClass__WEBPACK_IMPORTED_MODULE_0__["default"])(function SfToken(description) {
  (0,_babel_runtime_helpers_classCallCheck__WEBPACK_IMPORTED_MODULE_1__["default"])(this, SfToken);
  this.description = description;
});

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfDict.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfDict.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeSfDict: function() { return /* binding */ decodeSfDict; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _parse_parseDict_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse/parseDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDict.js");
/* harmony import */ var _parse_parseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parse/parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _utils_DICT_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/DICT.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js");




/**
 * Decode a structured field string into a structured field dictionary
 *
 * @param input - The structured field string to decode
 * @returns The structured field dictionary
 *
 * @group Structured Field
 *
 * @beta
 */
function decodeSfDict(input, options) {
  try {
    var _parseDict = (0,_parse_parseDict_js__WEBPACK_IMPORTED_MODULE_1__.parseDict)(input.trim(), options),
      src = _parseDict.src,
      value = _parseDict.value;
    if (src !== '') {
      throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_3__.DICT);
    }
    return value;
  } catch (cause) {
    throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(input, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_3__.DICT, cause);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfList.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/decodeSfList.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   decodeSfList: function() { return /* binding */ decodeSfList; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _parse_parseError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse/parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parse_parseList_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parse/parseList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseList.js");
/* harmony import */ var _utils_LIST_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/LIST.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js");




/**
 * Decode a structured field string into a structured field list
 *
 * @param input - The structured field string to decode
 * @returns The structured field list
 *
 * @group Structured Field
 *
 * @beta
 */
function decodeSfList(input, options) {
  try {
    var _parseList = (0,_parse_parseList_js__WEBPACK_IMPORTED_MODULE_2__.parseList)(input.trim(), options),
      src = _parseList.src,
      value = _parseList.value;
    if (src !== '') {
      throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_1__.parseError)(src, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_3__.LIST);
    }
    return value;
  } catch (cause) {
    throw (0,_parse_parseError_js__WEBPACK_IMPORTED_MODULE_1__.parseError)(input, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_3__.LIST, cause);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/encodeSfDict.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/encodeSfDict.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   encodeSfDict: function() { return /* binding */ encodeSfDict; }
/* harmony export */ });
/* harmony import */ var _serialize_serializeDict_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./serialize/serializeDict.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDict.js");

/**
 * Encode an object into a structured field dictionary
 *
 * @param value - The structured field dictionary to encode
 * @param options - Encoding options
 *
 * @returns The structured field string
 *
 * @group Structured Field
 *
 * @beta
 */
function encodeSfDict(value, options) {
  return (0,_serialize_serializeDict_js__WEBPACK_IMPORTED_MODULE_0__.serializeDict)(value, options);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parsedValue: function() { return /* binding */ parsedValue; }
/* harmony export */ });
function parsedValue(value, src) {
  return {
    value: value,
    src: src
  };
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js ***!
  \*********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseBareItem: function() { return /* binding */ parseBareItem; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/BARE_ITEM.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js");
/* harmony import */ var _parseBoolean_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseBoolean.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBoolean.js");
/* harmony import */ var _parseByteSequence_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseByteSequence.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseByteSequence.js");
/* harmony import */ var _parseDate_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseDate.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDate.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./parseIntegerOrDecimal.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js");
/* harmony import */ var _parseString_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./parseString.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseString.js");
/* harmony import */ var _parseToken_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./parseToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseToken.js");










// 4.2.3.1.  Parsing a Bare Item
//
// Given an ASCII string as input_string, return a bare Item.
// input_string is modified to remove the parsed value.
//
// 1.  If the first character of input_string is a "-" or a DIGIT,
//     return the result of running Parsing an Integer or Decimal
//     (Section 4.2.4) with input_string.
//
// 2.  If the first character of input_string is a DQUOTE, return the
//     result of running Parsing a String (Section 4.2.5) with
//     input_string.
//
// 3.  If the first character of input_string is ":", return the result
//     of running Parsing a Byte Sequence (Section 4.2.7) with
//     input_string.
//
// 4.  If the first character of input_string is "?", return the result
//     of running Parsing a Boolean (Section 4.2.8) with input_string.
//
// 5.  If the first character of input_string is an ALPHA or "*", return
//     the result of running Parsing a Token (Section 4.2.6) with
//     input_string.
//
// 6.  If the first character of input_string is "@", return the result
//     of running Parsing a Date (Section 4.2.9) with input_string.
//
// 7.  Otherwise, the item type is unrecognized; fail parsing.
function parseBareItem(src, options) {
  var first = src[0];
  if (first === "\"") {
    return (0,_parseString_js__WEBPACK_IMPORTED_MODULE_8__.parseString)(src);
  }
  if (/^[-0-9]/.test(first)) {
    return (0,_parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_7__.parseIntegerOrDecimal)(src);
  }
  if (first === "?") {
    return (0,_parseBoolean_js__WEBPACK_IMPORTED_MODULE_3__.parseBoolean)(src);
  }
  if (first === ":") {
    return (0,_parseByteSequence_js__WEBPACK_IMPORTED_MODULE_4__.parseByteSequence)(src);
  }
  if (/^[a-zA-Z*]/.test(first)) {
    return (0,_parseToken_js__WEBPACK_IMPORTED_MODULE_9__.parseToken)(src, options);
  }
  if (first === "@") {
    return (0,_parseDate_js__WEBPACK_IMPORTED_MODULE_5__.parseDate)(src);
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_6__.parseError)(src, _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_2__.BARE_ITEM);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBoolean.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBoolean.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseBoolean: function() { return /* binding */ parseBoolean; }
/* harmony export */ });
/* harmony import */ var _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/BOOLEAN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");



// 4.2.8.  Parsing a Boolean
//
// Given an ASCII string as input_string, return a Boolean. input_string
// is modified to remove the parsed value.
//
// 1.  If the first character of input_string is not "?", fail parsing.
//
// 2.  Discard the first character of input_string.
//
// 3.  If the first character of input_string matches "1", discard the
//     first character, and return true.
//
// 4.  If the first character of input_string matches "0", discard the
//     first character, and return false.
//
// 5.  No value has matched; fail parsing.
function parseBoolean(src) {
  var i = 0;
  if (src[i] !== '?') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
  }
  i++;
  if (src[i] === '1') {
    return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(true, src.substring(++i));
  }
  if (src[i] === '0') {
    return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(false, src.substring(++i));
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_2__.parseError)(src, _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseByteSequence.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseByteSequence.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseByteSequence: function() { return /* binding */ parseByteSequence; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_base64decode_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/base64decode.js */ "./node_modules/@svta/common-media-library/dist/utils/base64decode.js");
/* harmony import */ var _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/BYTES.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");







// 4.2.7.  Parsing a Byte Sequence
//
// Given an ASCII string as input_string, return a Byte Sequence.
// input_string is modified to remove the parsed value.
//
// 1.  If the first character of input_string is not ":", fail parsing.
//
// 2.  Discard the first character of input_string.
//
// 3.  If there is not a ":" character before the end of input_string,
//     fail parsing.
//
// 4.  Let b64_content be the result of consuming content of
//     input_string up to but not including the first instance of the
//     character ":".
//
// 5.  Consume the ":" character at the beginning of input_string.
//
// 6.  If b64_content contains a character not included in ALPHA, DIGIT,
//     "+", "/" and "=", fail parsing.
//
// 7.  Let binary_content be the result of Base 64 Decoding [RFC4648]
//     b64_content, synthesizing padding if necessary (note the
//     requirements about recipient behavior below).
//
// 8.  Return binary_content.
//
// Because some implementations of base64 do not allow rejection of
// encoded data that is not properly "=" padded (see [RFC4648],
// Section 3.2), parsers SHOULD NOT fail when "=" padding is not
// present, unless they cannot be configured to do so.
//
// Because some implementations of base64 do not allow rejection of
// encoded data that has non-zero pad bits (see [RFC4648], Section 3.5),
// parsers SHOULD NOT fail when non-zero pad bits are present, unless
// they cannot be configured to do so.
//
// This specification does not relax the requirements in [RFC4648],
// Section 3.1 and 3.3; therefore, parsers MUST fail on characters
// outside the base64 alphabet, and on line feeds in encoded data.
function parseByteSequence(src) {
  if (src[0] !== ':') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_6__.parseError)(src, _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_4__.BYTES);
  }
  src = src.substring(1);
  if (src.includes(':') === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_6__.parseError)(src, _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_4__.BYTES);
  }
  var re = /(^.*?)(:)/g;
  var b64_content = re.exec(src)[1];
  src = src.substring(re.lastIndex);
  // pass b64_content char check step 6
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_5__.parsedValue)((0,_utils_base64decode_js__WEBPACK_IMPORTED_MODULE_3__.base64decode)(b64_content), src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDate.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDate.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseDate: function() { return /* binding */ parseDate; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_number_is_integer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.is-integer.js */ "./node_modules/core-js/modules/es.number.is-integer.js");
/* harmony import */ var core_js_modules_es_number_is_integer_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_is_integer_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_DATE_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/DATE.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DATE.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseIntegerOrDecimal.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js");





// 4.2.9.  Parsing a Date
//
// Given an ASCII string as input_string, return a Date. input_string is
// modified to remove the parsed value.
//
// 1.  If the first character of input_string is not "@", fail parsing.
//
// 2.  Discard the first character of input_string.
//
// 3.  Let output_date be the result of running Parsing an Integer or
//     Decimal (Section 4.2.4) with input_string.
//
// 4.  If output_date is a Decimal, fail parsing.
//
// 5.  Return output_date.
function parseDate(src) {
  var i = 0;
  if (src[i] !== '@') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_DATE_js__WEBPACK_IMPORTED_MODULE_1__.DATE);
  }
  i++;
  var date = (0,_parseIntegerOrDecimal_js__WEBPACK_IMPORTED_MODULE_4__.parseIntegerOrDecimal)(src.substring(i));
  if (Number.isInteger(date.value) === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_3__.parseError)(src, _utils_DATE_js__WEBPACK_IMPORTED_MODULE_1__.DATE);
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_2__.parsedValue)(new Date(date.value * 1000), date.src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDict.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseDict.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseDict: function() { return /* binding */ parseDict; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _utils_DICT_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/DICT.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseItemOrInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js");
/* harmony import */ var _parseKey_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./parseKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js");
/* harmony import */ var _parseParameters_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./parseParameters.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js");








// 4.2.2.  Parsing a Dictionary
//
// Given an ASCII string as input_string, return an ordered map whose
// values are (item_or_inner_list, parameters) tuples. input_string is
// modified to remove the parsed value.
//
// 1.  Let dictionary be an empty, ordered map.
//
// 2.  While input_string is not empty:
//
//     1.  Let this_key be the result of running Parsing a Key
//         (Section 4.2.3.3) with input_string.
//
//     2.  If the first character of input_string is "=":
//
//         1.  Consume the first character of input_string.
//
//         2.  Let member be the result of running Parsing an Item or
//             Inner List (Section 4.2.1.1) with input_string.
//
//     3.  Otherwise:
//
//         1.  Let value be Boolean true.
//
//         2.  Let parameters be the result of running Parsing
//             Parameters Section 4.2.3.2 with input_string.
//
//         3.  Let member be the tuple (value, parameters).
//
//     4.  Add name this_key with value member to dictionary.  If
//         dictionary already contains a name this_key (comparing
//         character-for-character), overwrite its value.
//
//     5.  Discard any leading OWS characters from input_string.
//
//     6.  If input_string is empty, return dictionary.
//
//     7.  Consume the first character of input_string; if it is not
//         ",", fail parsing.
//
//     8.  Discard any leading OWS characters from input_string.
//
//     9.  If input_string is empty, there is a trailing comma; fail
//         parsing.
//
// 3.  No structured data has been found; return dictionary (which is
//     empty).
//
// Note that when duplicate Dictionary keys are encountered, this has
// the effect of ignoring all but the last instance.
function parseDict(src, options) {
  var value = {};
  while (src.length > 0) {
    var member = void 0;
    var parsedKey = (0,_parseKey_js__WEBPACK_IMPORTED_MODULE_6__.parseKey)(src);
    var key = parsedKey.value;
    src = parsedKey.src;
    if (src[0] === '=') {
      var parsedItemOrInnerList = (0,_parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_5__.parseItemOrInnerList)(src.substring(1), options);
      member = parsedItemOrInnerList.value;
      src = parsedItemOrInnerList.src;
    } else {
      var parsedParameters = (0,_parseParameters_js__WEBPACK_IMPORTED_MODULE_7__.parseParameters)(src, options);
      member = new _SfItem_js__WEBPACK_IMPORTED_MODULE_1__.SfItem(true, parsedParameters.value);
      src = parsedParameters.src;
    }
    value[key] = member;
    src = src.trim();
    if (src.length === 0) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src);
    }
    if (src[0] !== ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(src, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_2__.DICT);
    }
    src = src.substring(1).trim();
    if (src.length === 0 || src[0] === ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(src, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_2__.DICT);
    }
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseError: function() { return /* binding */ parseError; }
/* harmony export */ });
/* harmony import */ var _utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/throwError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js");

function parseError(src, type, cause) {
  return (0,_utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__.throwError)('parse', src, type, cause);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseInnerList.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseInnerList.js ***!
  \**********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseInnerList: function() { return /* binding */ parseInnerList; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _utils_INNER_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/INNER.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INNER.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseItem_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./parseItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js");
/* harmony import */ var _parseParameters_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./parseParameters.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js");








// 4.2.1.2.  Parsing an Inner List
//
// Given an ASCII string as input_string, return the tuple (inner_list,
// parameters), where inner_list is an array of (bare_item, parameters)
// tuples. input_string is modified to remove the parsed value.
//
// 1.  Consume the first character of input_string; if it is not "(",
//     fail parsing.
//
// 2.  Let inner_list be an empty array.
//
// 3.  While input_string is not empty:
//
//     1.  Discard any leading SP characters from input_string.
//
//     2.  If the first character of input_string is ")":
//
//         1.  Consume the first character of input_string.
//
//         2.  Let parameters be the result of running Parsing
//             Parameters (Section 4.2.3.2) with input_string.
//
//         3.  Return the tuple (inner_list, parameters).
//
//     3.  Let item be the result of running Parsing an Item
//         (Section 4.2.3) with input_string.
//
//     4.  Append item to inner_list.
//
//     5.  If the first character of input_string is not SP or ")", fail
//         parsing.
//
// 4.  The end of the inner list was not found; fail parsing.
function parseInnerList(src, options) {
  if (src[0] !== '(') {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_INNER_js__WEBPACK_IMPORTED_MODULE_3__.INNER);
  }
  src = src.substring(1);
  var innerList = [];
  while (src.length > 0) {
    src = src.trim();
    if (src[0] === ')') {
      src = src.substring(1);
      var parsedParameters = (0,_parseParameters_js__WEBPACK_IMPORTED_MODULE_7__.parseParameters)(src, options);
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_4__.parsedValue)(new _SfItem_js__WEBPACK_IMPORTED_MODULE_2__.SfItem(innerList, parsedParameters.value), parsedParameters.src);
    }
    var parsedItem = (0,_parseItem_js__WEBPACK_IMPORTED_MODULE_6__.parseItem)(src, options);
    innerList.push(parsedItem.value);
    src = parsedItem.src;
    if (src[0] !== ' ' && src[0] !== ')') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_INNER_js__WEBPACK_IMPORTED_MODULE_3__.INNER);
    }
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_INNER_js__WEBPACK_IMPORTED_MODULE_3__.INNER);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseIntegerOrDecimal.js ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseIntegerOrDecimal: function() { return /* binding */ parseIntegerOrDecimal; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_INTEGER_DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/INTEGER_DECIMAL.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER_DECIMAL.js");
/* harmony import */ var _utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/isInvalidInt.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");





// 4.2.4.  Parsing an Integer or Decimal
//
// Given an ASCII string as input_string, return an Integer or Decimal.
// input_string is modified to remove the parsed value.
//
// NOTE: This algorithm parses both Integers (Section 3.3.1) and
// Decimals (Section 3.3.2), and returns the corresponding structure.
//
// 1.   Let type be "integer".
//
// 2.   Let sign be 1.
//
// 3.   Let input_number be an empty string.
//
// 4.   If the first character of input_string is "-", consume it and
//      set sign to -1.
//
// 5.   If input_string is empty, there is an empty integer; fail
//      parsing.
//
// 6.   If the first character of input_string is not a DIGIT, fail
//      parsing.
//
// 7.   While input_string is not empty:
//
//      1.  Let char be the result of consuming the first character of
//          input_string.
//
//      2.  If char is a DIGIT, append it to input_number.
//
//      3.  Else, if type is "integer" and char is ".":
//
//          1.  If input_number contains more than 12 characters, fail
//              parsing.
//
//          2.  Otherwise, append char to input_number and set type to
//              "decimal".
//
//      4.  Otherwise, prepend char to input_string, and exit the loop.
//
//      5.  If type is "integer" and input_number contains more than 15
//          characters, fail parsing.
//
//      6.  If type is "decimal" and input_number contains more than 16
//          characters, fail parsing.
//
// 8.   If type is "integer":
//
//      1.  Parse input_number as an integer and let output_number be
//          the product of the result and sign.
//
//      2.  If output_number is outside the range -999,999,999,999,999
//          to 999,999,999,999,999 inclusive, fail parsing.
//
// 9.   Otherwise:
//
//      1.  If the final character of input_number is ".", fail parsing.
//
//      2.  If the number of characters after "." in input_number is
//          greater than three, fail parsing.
//
//      3.  Parse input_number as a decimal number and let output_number
//          be the product of the result and sign.
//
// 10.  Return output_number.
function parseIntegerOrDecimal(src) {
  var orig = src;
  var sign = 1;
  var num = '';
  var value;
  var i = 0;
  var error = (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(orig, _utils_INTEGER_DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__.INTEGER_DECIMAL);
  if (src[i] === '-') {
    sign = -1;
    src = src.substring(1);
  }
  if (src.length <= 0) {
    throw error;
  }
  var re_integer = /^(\d+)?/g;
  var result_integer = re_integer.exec(src);
  if (result_integer[0].length === 0) {
    throw error;
  }
  num += result_integer[1];
  src = src.substring(re_integer.lastIndex);
  if (src[0] === '.') {
    // decimal
    if (num.length > 12) {
      throw error;
    }
    var re_decimal = /^(\.\d+)?/g;
    var result_decimal = re_decimal.exec(src);
    src = src.substring(re_decimal.lastIndex);
    // 9.2.  If the number of characters after "." in input_number is greater than three, fail parsing.
    if (result_decimal[0].length === 0 || result_decimal[1].length > 4) {
      throw error;
    }
    num += result_decimal[1];
    // 7.6.  If type is "decimal" and input_number contains more than 16 characters, fail parsing.
    if (num.length > 16) {
      throw error;
    }
    value = parseFloat(num) * sign;
  } else {
    // integer
    // 7.5.  If type is "integer" and input_number contains more than 15 characters, fail parsing.
    if (num.length > 15) {
      throw error;
    }
    value = parseInt(num) * sign;
    if ((0,_utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_2__.isInvalidInt)(value)) {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(num, _utils_INTEGER_DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__.INTEGER_DECIMAL);
    }
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseItem: function() { return /* binding */ parseItem; }
/* harmony export */ });
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseBareItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js");
/* harmony import */ var _parseParameters_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseParameters.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js");




// 4.2.3.  Parsing an Item
//
// Given an ASCII string as input_string, return a (bare_item,
// parameters) tuple. input_string is modified to remove the parsed
// value.
//
// 1.  Let bare_item be the result of running Parsing a Bare Item
//     (Section 4.2.3.1) with input_string.
//
// 2.  Let parameters be the result of running Parsing Parameters
//     (Section 4.2.3.2) with input_string.
//
// 3.  Return the tuple (bare_item, parameters).
function parseItem(src, options) {
  var parsedBareItem = (0,_parseBareItem_js__WEBPACK_IMPORTED_MODULE_2__.parseBareItem)(src, options);
  src = parsedBareItem.src;
  var parsedParameters = (0,_parseParameters_js__WEBPACK_IMPORTED_MODULE_3__.parseParameters)(src, options);
  src = parsedParameters.src;
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(new _SfItem_js__WEBPACK_IMPORTED_MODULE_0__.SfItem(parsedBareItem.value, parsedParameters.value), src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseItemOrInnerList: function() { return /* binding */ parseItemOrInnerList; }
/* harmony export */ });
/* harmony import */ var _parseInnerList_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./parseInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseInnerList.js");
/* harmony import */ var _parseItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parseItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItem.js");


// 4.2.1.1.  Parsing an Item or Inner List
//
// Given an ASCII string as input_string, return the tuple
// (item_or_inner_list, parameters), where item_or_inner_list can be
// either a single bare item, or an array of (bare_item, parameters)
// tuples. input_string is modified to remove the parsed value.
//
// 1.  If the first character of input_string is "(", return the result
//     of running Parsing an Inner List (Section 4.2.1.2) with
//     input_string.
//
// 2.  Return the result of running Parsing an Item (Section 4.2.3) with
//     input_string.
function parseItemOrInnerList(src, options) {
  if (src[0] === '(') {
    return (0,_parseInnerList_js__WEBPACK_IMPORTED_MODULE_0__.parseInnerList)(src, options);
  }
  return (0,_parseItem_js__WEBPACK_IMPORTED_MODULE_1__.parseItem)(src, options);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js ***!
  \****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseKey: function() { return /* binding */ parseKey; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_KEY_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/KEY.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");





// 4.2.3.3.  Parsing a Key
//
// Given an ASCII string as input_string, return a key. input_string is
// modified to remove the parsed value.
//
// 1.  If the first character of input_string is not lcalpha or "*",
//     fail parsing.
//
// 2.  Let output_string be an empty string.
//
// 3.  While input_string is not empty:
//
//     1.  If the first character of input_string is not one of lcalpha,
//         DIGIT, "_", "-", ".", or "*", return output_string.
//
//     2.  Let char be the result of consuming the first character of
//         input_string.
//
//     3.  Append char to output_string.
//
// 4.  Return output_string.
function parseKey(src) {
  var i = 0;
  if (/^[a-z*]$/.test(src[i]) === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(src, _utils_KEY_js__WEBPACK_IMPORTED_MODULE_2__.KEY);
  }
  var value = '';
  while (src.length > i) {
    if (/^[a-z0-9_\-.*]$/.test(src[i]) === false) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src.substring(i));
    }
    value += src[i];
    i++;
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src.substring(i));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseList.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseList.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseList: function() { return /* binding */ parseList; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
/* harmony import */ var core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_push_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_LIST_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/LIST.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");
/* harmony import */ var _parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseItemOrInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseItemOrInnerList.js");






// 4.2.1.  Parsing a List
//
// Given an ASCII string as input_string, return an array of
// (item_or_inner_list, parameters) tuples. input_string is modified to
// remove the parsed value.
//
// 1.  Let members be an empty array.
//
// 2.  While input_string is not empty:
//
//     1.  Append the result of running Parsing an Item or Inner List
//         (Section 4.2.1.1) with input_string to members.
//
//     2.  Discard any leading OWS characters from input_string.
//
//     3.  If input_string is empty, return members.
//
//     4.  Consume the first character of input_string; if it is not
//         ",", fail parsing.
//
//     5.  Discard any leading OWS characters from input_string.
//
//     6.  If input_string is empty, there is a trailing comma; fail
//         parsing.
//
// 3.  No structured data has been found; return members (which is
//     empty).
function parseList(src, options) {
  var value = [];
  while (src.length > 0) {
    var parsedItemOrInnerList = (0,_parseItemOrInnerList_js__WEBPACK_IMPORTED_MODULE_5__.parseItemOrInnerList)(src, options);
    value.push(parsedItemOrInnerList.value);
    src = parsedItemOrInnerList.src.trim();
    if (src.length === 0) {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src);
    }
    if (src[0] !== ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(src, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_2__.LIST);
    }
    src = src.substring(1).trim();
    if (src.length === 0 || src[0] === ',') {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_4__.parseError)(src, _utils_LIST_js__WEBPACK_IMPORTED_MODULE_2__.LIST);
    }
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_3__.parsedValue)(value, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseParameters.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseParameters: function() { return /* binding */ parseParameters; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseBareItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./parseBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseBareItem.js");
/* harmony import */ var _parseKey_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./parseKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseKey.js");




// 4.2.3.2.  Parsing Parameters
//
// Given an ASCII string as input_string, return an ordered map whose
// values are bare Items. input_string is modified to remove the parsed
// value.
//
// 1.  Let parameters be an empty, ordered map.
//
// 2.  While input_string is not empty:
//
//     1.  If the first character of input_string is not ";", exit the
//         loop.
//
//     2.  Consume a ";" character from the beginning of input_string.
//
//     3.  Discard any leading SP characters from input_string.
//
//     4.  let param_name be the result of running Parsing a Key
//         (Section 4.2.3.3) with input_string.
//
//     5.  Let param_value be Boolean true.
//
//     6.  If the first character of input_string is "=":
//
//         1.  Consume the "=" character at the beginning of
//             input_string.
//
//         2.  Let param_value be the result of running Parsing a Bare
//             Item (Section 4.2.3.1) with input_string.
//
//     7.  Append key param_name with value param_value to parameters.
//         If parameters already contains a name param_name (comparing
//         character-for-character), overwrite its value.
//
// 3.  Return parameters.
//
// Note that when duplicate Parameter keys are encountered, this has the
// effect of ignoring all but the last instance.
function parseParameters(src, options) {
  var parameters = undefined;
  while (src.length > 0) {
    if (src[0] !== ';') {
      break;
    }
    src = src.substring(1).trim();
    var parsedKey = (0,_parseKey_js__WEBPACK_IMPORTED_MODULE_3__.parseKey)(src);
    var key = parsedKey.value;
    var value = true;
    src = parsedKey.src;
    if (src[0] === '=') {
      src = src.substring(1);
      var parsedBareItem = (0,_parseBareItem_js__WEBPACK_IMPORTED_MODULE_2__.parseBareItem)(src, options);
      value = parsedBareItem.value;
      src = parsedBareItem.src;
    }
    // initialize as object when params exists
    if (parameters == null) {
      parameters = {};
    }
    // override if param_name exists
    parameters[key] = value;
  }
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_1__.parsedValue)(parameters, src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseString.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseString.js ***!
  \*******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseString: function() { return /* binding */ parseString; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_STRING_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/STRING.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js");
/* harmony import */ var _utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/STRING_REGEX.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");






// 4.2.5.  Parsing a String
//
// Given an ASCII string as input_string, return an unquoted String.
// input_string is modified to remove the parsed value.
//
// 1.  Let output_string be an empty string.
//
// 2.  If the first character of input_string is not DQUOTE, fail
//     parsing.
//
// 3.  Discard the first character of input_string.
//
// 4.  While input_string is not empty:
//
//     1.  Let char be the result of consuming the first character of
//         input_string.
//
//     2.  If char is a backslash ("\"):
//
//         1.  If input_string is now empty, fail parsing.
//
//         2.  Let next_char be the result of consuming the first
//             character of input_string.
//
//         3.  If next_char is not DQUOTE or "\", fail parsing.
//
//         4.  Append next_char to output_string.
//
//     3.  Else, if char is DQUOTE, return output_string.
//
//     4.  Else, if char is in the range %x00-1f or %x7f (i.e., is not
//         in VCHAR or SP), fail parsing.
//
//     5.  Else, append char to output_string.
//
// 5.  Reached the end of input_string without finding a closing DQUOTE;
//     fail parsing.
function parseString(src) {
  var output = '';
  var i = 0;
  if (src[i] !== "\"") {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_2__.STRING);
  }
  i++;
  while (src.length > i) {
    if (src[i] === "\\") {
      if (src.length <= i + 1) {
        throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_2__.STRING);
      }
      i++;
      if (src[i] !== "\"" && src[i] !== "\\") {
        throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_2__.STRING);
      }
      output += src[i];
    } else if (src[i] === "\"") {
      return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_4__.parsedValue)(output, src.substring(++i));
    } else if (_utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_3__.STRING_REGEX.test(src[i])) {
      throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_2__.STRING);
    } else {
      output += src[i];
    }
    i++;
  }
  throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_2__.STRING);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseToken.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseToken.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   parseToken: function() { return /* binding */ parseToken; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _SfToken_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../SfToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js");
/* harmony import */ var _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/TOKEN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js");
/* harmony import */ var _ParsedValue_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ParsedValue.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/ParsedValue.js");
/* harmony import */ var _parseError_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./parseError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/parse/parseError.js");






// 4.2.6.  Parsing a Token
//
// Given an ASCII string as input_string, return a Token. input_string
// is modified to remove the parsed value.
//
// 1.  If the first character of input_string is not ALPHA or "*", fail
//     parsing.
//
// 2.  Let output_string be an empty string.
//
// 3.  While input_string is not empty:
//
//     1.  If the first character of input_string is not in tchar, ":"
//         or "/", return output_string.
//
//     2.  Let char be the result of consuming the first character of
//         input_string.
//
//     3.  Append char to output_string.
//
// 4.  Return output_string.
function parseToken(src, options) {
  if (/^[a-zA-Z*]$/.test(src[0]) === false) {
    throw (0,_parseError_js__WEBPACK_IMPORTED_MODULE_5__.parseError)(src, _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_3__.TOKEN);
  }
  var re = /^([!#$%&'*+\-.^_`|~\w:/]+)/g;
  var value = re.exec(src)[1];
  src = src.substring(re.lastIndex);
  return (0,_ParsedValue_js__WEBPACK_IMPORTED_MODULE_4__.parsedValue)((options === null || options === void 0 ? void 0 : options.useSymbol) === false ? new _SfToken_js__WEBPACK_IMPORTED_MODULE_2__.SfToken(value) : Symbol.for(value), src);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js ***!
  \*****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeBareItem: function() { return /* binding */ serializeBareItem; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_number_is_finite_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.number.is-finite.js */ "./node_modules/core-js/modules/es.number.is-finite.js");
/* harmony import */ var core_js_modules_es_number_is_finite_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_is_finite_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_number_is_integer_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.number.is-integer.js */ "./node_modules/core-js/modules/es.number.is-integer.js");
/* harmony import */ var core_js_modules_es_number_is_integer_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_is_integer_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_35__);
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_36___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_36__);
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_37___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_37__);
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_38___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_38__);
/* harmony import */ var _SfToken_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../SfToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfToken.js");
/* harmony import */ var _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../utils/BARE_ITEM.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js");
/* harmony import */ var _serializeBoolean_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./serializeBoolean.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBoolean.js");
/* harmony import */ var _serializeByteSequence_js__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./serializeByteSequence.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeByteSequence.js");
/* harmony import */ var _serializeDate_js__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./serializeDate.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDate.js");
/* harmony import */ var _serializeDecimal_js__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./serializeDecimal.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDecimal.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");
/* harmony import */ var _serializeInteger_js__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./serializeInteger.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js");
/* harmony import */ var _serializeString_js__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./serializeString.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeString.js");
/* harmony import */ var _serializeToken_js__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./serializeToken.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeToken.js");

















































// 4.1.3.1.  Serializing a Bare Item
//
// Given an Item as input_item, return an ASCII string suitable for use
// in a HTTP field value.
//
// 1.  If input_item is an Integer, return the result of running
//     Serializing an Integer (Section 4.1.4) with input_item.
//
// 2.  If input_item is a Decimal, return the result of running
//     Serializing a Decimal (Section 4.1.5) with input_item.
//
// 3.  If input_item is a String, return the result of running
//     Serializing a String (Section 4.1.6) with input_item.
//
// 4.  If input_item is a Token, return the result of running
//     Serializing a Token (Section 4.1.7) with input_item.
//
// 5.  If input_item is a Boolean, return the result of running
//     Serializing a Boolean (Section 4.1.9) with input_item.
//
// 6.  If input_item is a Byte Sequence, return the result of running
//     Serializing a Byte Sequence (Section 4.1.8) with input_item.
//
// 7.  If input_item is a Date, return the result of running Serializing
//     a Date (Section 4.1.10) with input_item.
//
// 8.  Otherwise, fail serialization.
function serializeBareItem(value) {
  switch ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {
    case 'number':
      if (!Number.isFinite(value)) {
        throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_45__.serializeError)(value, _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_40__.BARE_ITEM);
      }
      if (Number.isInteger(value)) {
        return (0,_serializeInteger_js__WEBPACK_IMPORTED_MODULE_46__.serializeInteger)(value);
      }
      return (0,_serializeDecimal_js__WEBPACK_IMPORTED_MODULE_44__.serializeDecimal)(value);
    case 'string':
      return (0,_serializeString_js__WEBPACK_IMPORTED_MODULE_47__.serializeString)(value);
    case 'symbol':
      return (0,_serializeToken_js__WEBPACK_IMPORTED_MODULE_48__.serializeToken)(value);
    case 'boolean':
      return (0,_serializeBoolean_js__WEBPACK_IMPORTED_MODULE_41__.serializeBoolean)(value);
    case 'object':
      if (value instanceof Date) {
        return (0,_serializeDate_js__WEBPACK_IMPORTED_MODULE_43__.serializeDate)(value);
      }
      if (value instanceof Uint8Array) {
        return (0,_serializeByteSequence_js__WEBPACK_IMPORTED_MODULE_42__.serializeByteSequence)(value);
      }
      if (value instanceof _SfToken_js__WEBPACK_IMPORTED_MODULE_39__.SfToken) {
        return (0,_serializeToken_js__WEBPACK_IMPORTED_MODULE_48__.serializeToken)(value);
      }
    default:
      // fail
      throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_45__.serializeError)(value, _utils_BARE_ITEM_js__WEBPACK_IMPORTED_MODULE_40__.BARE_ITEM);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBoolean.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBoolean.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeBoolean: function() { return /* binding */ serializeBoolean; }
/* harmony export */ });
/* harmony import */ var _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/BOOLEAN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");


// 4.1.9.  Serializing a Boolean
//
// Given a Boolean as input_boolean, return an ASCII string suitable for
// use in a HTTP field value.
//
// 1.  If input_boolean is not a boolean, fail serialization.
//
// 2.  Let output be an empty string.
//
// 3.  Append "?" to output.
//
// 4.  If input_boolean is true, append "1" to output.
//
// 5.  If input_boolean is false, append "0" to output.
//
// 6.  Return output.
function serializeBoolean(value) {
  if (typeof value !== 'boolean') {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_1__.serializeError)(value, _utils_BOOLEAN_js__WEBPACK_IMPORTED_MODULE_0__.BOOLEAN);
  }
  return value ? '?1' : '?0';
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeByteSequence.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeByteSequence.js ***!
  \*********************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeByteSequence: function() { return /* binding */ serializeByteSequence; }
/* harmony export */ });
/* harmony import */ var _utils_base64encode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/base64encode.js */ "./node_modules/@svta/common-media-library/dist/utils/base64encode.js");
/* harmony import */ var _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/BYTES.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");



// 4.1.8.  Serializing a Byte Sequence
//
// Given a Byte Sequence as input_bytes, return an ASCII string suitable
// for use in a HTTP field value.
//
// 1.  If input_bytes is not a sequence of bytes, fail serialization.
//
// 2.  Let output be an empty string.
//
// 3.  Append ":" to output.
//
// 4.  Append the result of base64-encoding input_bytes as per
//     [RFC4648], Section 4, taking account of the requirements below.
//
// 5.  Append ":" to output.
//
// 6.  Return output.
//
// The encoded data is required to be padded with "=", as per [RFC4648],
// Section 3.2.
//
// Likewise, encoded data SHOULD have pad bits set to zero, as per
// [RFC4648], Section 3.5, unless it is not possible to do so due to
// implementation constraints.
function serializeByteSequence(value) {
  if (ArrayBuffer.isView(value) === false) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_2__.serializeError)(value, _utils_BYTES_js__WEBPACK_IMPORTED_MODULE_1__.BYTES);
  }
  return ":".concat((0,_utils_base64encode_js__WEBPACK_IMPORTED_MODULE_0__.base64encode)(value), ":");
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDate.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDate.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeDate: function() { return /* binding */ serializeDate; }
/* harmony export */ });
/* harmony import */ var _serializeInteger_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./serializeInteger.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js");

// 4.1.10.  Serializing a Date
//
// Given a Date as input_integer, return an ASCII string suitable for
// use in an HTTP field value.
// 1.  Let output be "@".
// 2.  Append to output the result of running Serializing an Integer
//     with input_date (Section 4.1.4).
// 3.  Return output.
function serializeDate(value) {
  return "@".concat((0,_serializeInteger_js__WEBPACK_IMPORTED_MODULE_0__.serializeInteger)(value.getTime() / 1000));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDecimal.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDecimal.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeDecimal: function() { return /* binding */ serializeDecimal; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
/* harmony import */ var core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_includes_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _utils_roundToEven_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/roundToEven.js */ "./node_modules/@svta/common-media-library/dist/utils/roundToEven.js");
/* harmony import */ var _utils_DECIMAL_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/DECIMAL.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");







// 4.1.5.  Serializing a Decimal
//
// Given a decimal number as input_decimal, return an ASCII string
// suitable for use in a HTTP field value.
//
// 1.   If input_decimal is not a decimal number, fail serialization.
//
// 2.   If input_decimal has more than three significant digits to the
//      right of the decimal point, round it to three decimal places,
//      rounding the final digit to the nearest value, or to the even
//      value if it is equidistant.
//
// 3.   If input_decimal has more than 12 significant digits to the left
//      of the decimal point after rounding, fail serialization.
//
// 4.   Let output be an empty string.
//
// 5.   If input_decimal is less than (but not equal to) 0, append "-"
//      to output.
//
// 6.   Append input_decimal's integer component represented in base 10
//      (using only decimal digits) to output; if it is zero, append
//      "0".
//
// 7.   Append "." to output.
//
// 8.   If input_decimal's fractional component is zero, append "0" to
//      output.
//
// 9.   Otherwise, append the significant digits of input_decimal's
//      fractional component represented in base 10 (using only decimal
//      digits) to output.
//
// 10.  Return output.
function serializeDecimal(value) {
  var roundedValue = (0,_utils_roundToEven_js__WEBPACK_IMPORTED_MODULE_4__.roundToEven)(value, 3); // round to 3 decimal places
  if (Math.floor(Math.abs(roundedValue)).toString().length > 12) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_6__.serializeError)(value, _utils_DECIMAL_js__WEBPACK_IMPORTED_MODULE_5__.DECIMAL);
  }
  var stringValue = roundedValue.toString();
  return stringValue.includes('.') ? stringValue : "".concat(stringValue, ".0");
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDict.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeDict.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeDict: function() { return /* binding */ serializeDict; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.from.js */ "./node_modules/core-js/modules/es.array.from.js");
/* harmony import */ var core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_from_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_map_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.map.js */ "./node_modules/core-js/modules/es.map.js");
/* harmony import */ var core_js_modules_es_map_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_map_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _utils_DICT_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/DICT.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");
/* harmony import */ var _serializeInnerList_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./serializeInnerList.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInnerList.js");
/* harmony import */ var _serializeItem_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./serializeItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js");
/* harmony import */ var _serializeKey_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./serializeKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js");
/* harmony import */ var _serializeParams_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./serializeParams.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js");


















// 4.1.2.  Serializing a Dictionary
//
// Given an ordered Dictionary as input_dictionary (each member having a
// member_name and a tuple value of (member_value, parameters)), return
// an ASCII string suitable for use in a HTTP field value.
//
// 1.  Let output be an empty string.
//
// 2.  For each member_name with a value of (member_value, parameters)
//     in input_dictionary:
//
//     1.  Append the result of running Serializing a Key
//         (Section 4.1.1.3) with member's member_name to output.
//
//     2.  If member_value is Boolean true:
//
//         1.  Append the result of running Serializing Parameters
//             (Section 4.1.1.2) with parameters to output.
//
//     3.  Otherwise:
//
//         1.  Append "=" to output.
//
//         2.  If member_value is an array, append the result of running
//             Serializing an Inner List (Section 4.1.1.1) with
//             (member_value, parameters) to output.
//
//         3.  Otherwise, append the result of running Serializing an
//             Item (Section 4.1.3) with (member_value, parameters) to
//             output.
//
//     4.  If more members remain in input_dictionary:
//
//         1.  Append "," to output.
//
//         2.  Append a single SP to output.
//
// 3.  Return output.
function serializeDict(dict) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
    whitespace: true
  };
  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_1__["default"])(dict) !== 'object') {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_13__.serializeError)(dict, _utils_DICT_js__WEBPACK_IMPORTED_MODULE_12__.DICT);
  }
  var entries = dict instanceof Map ? dict.entries() : Object.entries(dict);
  var optionalWhiteSpace = (options === null || options === void 0 ? void 0 : options.whitespace) ? ' ' : '';
  return Array.from(entries).map(function (_ref) {
    var _ref2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref, 2),
      key = _ref2[0],
      item = _ref2[1];
    if (item instanceof _SfItem_js__WEBPACK_IMPORTED_MODULE_11__.SfItem === false) {
      item = new _SfItem_js__WEBPACK_IMPORTED_MODULE_11__.SfItem(item);
    }
    var output = (0,_serializeKey_js__WEBPACK_IMPORTED_MODULE_16__.serializeKey)(key);
    if (item.value === true) {
      output += (0,_serializeParams_js__WEBPACK_IMPORTED_MODULE_17__.serializeParams)(item.params);
    } else {
      output += '=';
      if (Array.isArray(item.value)) {
        output += (0,_serializeInnerList_js__WEBPACK_IMPORTED_MODULE_14__.serializeInnerList)(item);
      } else {
        output += (0,_serializeItem_js__WEBPACK_IMPORTED_MODULE_15__.serializeItem)(item);
      }
    }
    return output;
  }).join(",".concat(optionalWhiteSpace));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeError: function() { return /* binding */ serializeError; }
/* harmony export */ });
/* harmony import */ var _utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/throwError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js");

function serializeError(src, type, cause) {
  return (0,_utils_throwError_js__WEBPACK_IMPORTED_MODULE_0__.throwError)('serialize', src, type, cause);
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInnerList.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInnerList.js ***!
  \******************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeInnerList: function() { return /* binding */ serializeInnerList; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _serializeItem_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./serializeItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js");
/* harmony import */ var _serializeParams_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serializeParams.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js");





// 4.1.1.1.  Serializing an Inner List
//
// Given an array of (member_value, parameters) tuples as inner_list,
// and parameters as list_parameters, return an ASCII string suitable
// for use in a HTTP field value.
//
// 1.  Let output be the string "(".
//
// 2.  For each (member_value, parameters) of inner_list:
//
//     1.  Append the result of running Serializing an Item
//         (Section 4.1.3) with (member_value, parameters) to output.
//
//     2.  If more values remain in inner_list, append a single SP to
//         output.
//
// 3.  Append ")" to output.
//
// 4.  Append the result of running Serializing Parameters
//     (Section 4.1.1.2) with list_parameters to output.
//
// 5.  Return output.
function serializeInnerList(value) {
  return "(".concat(value.value.map(_serializeItem_js__WEBPACK_IMPORTED_MODULE_3__.serializeItem).join(' '), ")").concat((0,_serializeParams_js__WEBPACK_IMPORTED_MODULE_4__.serializeParams)(value.params));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js":
/*!****************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeInteger.js ***!
  \****************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeInteger: function() { return /* binding */ serializeInteger; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
/* harmony import */ var core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_to_string_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_INTEGER_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/INTEGER.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js");
/* harmony import */ var _utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/isInvalidInt.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");





// 4.1.4.  Serializing an Integer
//
// Given an Integer as input_integer, return an ASCII string suitable
// for use in a HTTP field value.
//
// 1.  If input_integer is not an integer in the range of
//     -999,999,999,999,999 to 999,999,999,999,999 inclusive, fail
//     serialization.
//
// 2.  Let output be an empty string.
//
// 3.  If input_integer is less than (but not equal to) 0, append "-" to
//     output.
//
// 4.  Append input_integer's numeric value represented in base 10 using
//     only decimal digits to output.
//
// 5.  Return output.
function serializeInteger(value) {
  if ((0,_utils_isInvalidInt_js__WEBPACK_IMPORTED_MODULE_3__.isInvalidInt)(value)) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_4__.serializeError)(value, _utils_INTEGER_js__WEBPACK_IMPORTED_MODULE_2__.INTEGER);
  }
  return value.toString();
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js":
/*!*************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeItem.js ***!
  \*************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeItem: function() { return /* binding */ serializeItem; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SfItem_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SfItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/SfItem.js");
/* harmony import */ var _serializeBareItem_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./serializeBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js");
/* harmony import */ var _serializeParams_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./serializeParams.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js");




// 4.1.3.  Serializing an Item
//
// Given an Item as bare_item and Parameters as item_parameters, return
// an ASCII string suitable for use in a HTTP field value.
//
// 1.  Let output be an empty string.
//
// 2.  Append the result of running Serializing a Bare Item
//     Section 4.1.3.1 with bare_item to output.
//
// 3.  Append the result of running Serializing Parameters
//     Section 4.1.1.2 with item_parameters to output.
//
// 4.  Return output.
function serializeItem(value) {
  if (value instanceof _SfItem_js__WEBPACK_IMPORTED_MODULE_1__.SfItem) {
    return "".concat((0,_serializeBareItem_js__WEBPACK_IMPORTED_MODULE_2__.serializeBareItem)(value.value)).concat((0,_serializeParams_js__WEBPACK_IMPORTED_MODULE_3__.serializeParams)(value.params));
  } else {
    return (0,_serializeBareItem_js__WEBPACK_IMPORTED_MODULE_2__.serializeBareItem)(value);
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js ***!
  \************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeKey: function() { return /* binding */ serializeKey; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_KEY_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/KEY.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");




// 4.1.1.3.  Serializing a Key
//
// Given a key as input_key, return an ASCII string suitable for use in
// a HTTP field value.
//
// 1.  Convert input_key into a sequence of ASCII characters; if
//     conversion fails, fail serialization.
//
// 2.  If input_key contains characters not in lcalpha, DIGIT, "_", "-",
//     ".", or "*" fail serialization.
//
// 3.  If the first character of input_key is not lcalpha or "*", fail
//     serialization.
//
// 4.  Let output be an empty string.
//
// 5.  Append input_key to output.
//
// 6.  Return output.
function serializeKey(value) {
  if (/^[a-z*][a-z0-9\-_.*]*$/.test(value) === false) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_3__.serializeError)(value, _utils_KEY_js__WEBPACK_IMPORTED_MODULE_2__.KEY);
  }
  return value;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeParams.js ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeParams: function() { return /* binding */ serializeParams; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/slicedToArray */ "./node_modules/@babel/runtime/helpers/esm/slicedToArray.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.object.entries.js */ "./node_modules/core-js/modules/es.object.entries.js");
/* harmony import */ var core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_entries_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _serializeBareItem_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serializeBareItem.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeBareItem.js");
/* harmony import */ var _serializeKey_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./serializeKey.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeKey.js");







// 4.1.1.2.  Serializing Parameters
//
// Given an ordered Dictionary as input_parameters (each member having a
// param_name and a param_value), return an ASCII string suitable for
// use in a HTTP field value.
//
// 1.  Let output be an empty string.
//
// 2.  For each param_name with a value of param_value in
//     input_parameters:
//
//     1.  Append ";" to output.
//
//     2.  Append the result of running Serializing a Key
//         (Section 4.1.1.3) with param_name to output.
//
//     3.  If param_value is not Boolean true:
//
//         1.  Append "=" to output.
//
//         2.  Append the result of running Serializing a bare Item
//             (Section 4.1.3.1) with param_value to output.
//
// 3.  Return output.
function serializeParams(params) {
  if (params == null) {
    return '';
  }
  return Object.entries(params).map(function (_ref) {
    var _ref2 = (0,_babel_runtime_helpers_slicedToArray__WEBPACK_IMPORTED_MODULE_0__["default"])(_ref, 2),
      key = _ref2[0],
      value = _ref2[1];
    if (value === true) {
      return ";".concat((0,_serializeKey_js__WEBPACK_IMPORTED_MODULE_6__.serializeKey)(key)); // omit true
    }
    return ";".concat((0,_serializeKey_js__WEBPACK_IMPORTED_MODULE_6__.serializeKey)(key), "=").concat((0,_serializeBareItem_js__WEBPACK_IMPORTED_MODULE_5__.serializeBareItem)(value));
  }).join('');
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeString.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeString.js ***!
  \***************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeString: function() { return /* binding */ serializeString; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_STRING_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/STRING.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js");
/* harmony import */ var _utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/STRING_REGEX.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");






// 4.1.6.  Serializing a String
//
// Given a String as input_string, return an ASCII string suitable for
// use in a HTTP field value.
//
// 1.  Convert input_string into a sequence of ASCII characters; if
//     conversion fails, fail serialization.
//
// 2.  If input_string contains characters in the range %x00-1f or %x7f
//     (i.e., not in VCHAR or SP), fail serialization.
//
// 3.  Let output be the string DQUOTE.
//
// 4.  For each character char in input_string:
//
//     1.  If char is "\" or DQUOTE:
//
//         1.  Append "\" to output.
//
//     2.  Append char to output.
//
// 5.  Append DQUOTE to output.
//
// 6.  Return output.
function serializeString(value) {
  if (_utils_STRING_REGEX_js__WEBPACK_IMPORTED_MODULE_4__.STRING_REGEX.test(value)) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_5__.serializeError)(value, _utils_STRING_js__WEBPACK_IMPORTED_MODULE_3__.STRING);
  }
  return "\"".concat(value.replace(/\\/g, "\\\\").replace(/"/g, "\\\""), "\"");
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeToken.js":
/*!**************************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeToken.js ***!
  \**************************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   serializeToken: function() { return /* binding */ serializeToken; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
/* harmony import */ var core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_test_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../cta/utils/symbolToStr.js */ "./node_modules/@svta/common-media-library/dist/cta/utils/symbolToStr.js");
/* harmony import */ var _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/TOKEN.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js");
/* harmony import */ var _serializeError_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./serializeError.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/serialize/serializeError.js");





function serializeToken(token) {
  var value = (0,_cta_utils_symbolToStr_js__WEBPACK_IMPORTED_MODULE_2__.symbolToStr)(token);
  if (/^([a-zA-Z*])([!#$%&'*+\-.^_`|~\w:/]*)$/.test(value) === false) {
    throw (0,_serializeError_js__WEBPACK_IMPORTED_MODULE_4__.serializeError)(value, _utils_TOKEN_js__WEBPACK_IMPORTED_MODULE_3__.TOKEN);
  }
  return value;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js":
/*!*****************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/BARE_ITEM.js ***!
  \*****************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BARE_ITEM: function() { return /* binding */ BARE_ITEM; }
/* harmony export */ });
var BARE_ITEM = 'Bare Item';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/BOOLEAN.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BOOLEAN: function() { return /* binding */ BOOLEAN; }
/* harmony export */ });
var BOOLEAN = 'Boolean';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/BYTES.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   BYTES: function() { return /* binding */ BYTES; }
/* harmony export */ });
var BYTES = 'Byte Sequence';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DATE.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/DATE.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DATE: function() { return /* binding */ DATE; }
/* harmony export */ });
var DATE = 'Date';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DECIMAL: function() { return /* binding */ DECIMAL; }
/* harmony export */ });
var DECIMAL = 'Decimal';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/DICT.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DICT: function() { return /* binding */ DICT; }
/* harmony export */ });
var DICT = 'Dict';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INNER.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/INNER.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INNER: function() { return /* binding */ INNER; }
/* harmony export */ });
var INNER = 'Inner List';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INTEGER: function() { return /* binding */ INTEGER; }
/* harmony export */ });
var INTEGER = 'Integer';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER_DECIMAL.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER_DECIMAL.js ***!
  \***********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   INTEGER_DECIMAL: function() { return /* binding */ INTEGER_DECIMAL; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DECIMAL.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/DECIMAL.js");
/* harmony import */ var _INTEGER_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./INTEGER.js */ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/INTEGER.js");



var INTEGER_DECIMAL = "".concat(_INTEGER_js__WEBPACK_IMPORTED_MODULE_2__.INTEGER, " or ").concat(_DECIMAL_js__WEBPACK_IMPORTED_MODULE_1__.DECIMAL);

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/KEY.js ***!
  \***********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   KEY: function() { return /* binding */ KEY; }
/* harmony export */ });
var KEY = 'Key';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/LIST.js ***!
  \************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LIST: function() { return /* binding */ LIST; }
/* harmony export */ });
var LIST = 'List';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING.js ***!
  \**************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRING: function() { return /* binding */ STRING; }
/* harmony export */ });
var STRING = 'String';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/STRING_REGEX.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   STRING_REGEX: function() { return /* binding */ STRING_REGEX; }
/* harmony export */ });
var STRING_REGEX = /[\x00-\x1f\x7f]+/;

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/TOKEN.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TOKEN: function() { return /* binding */ TOKEN; }
/* harmony export */ });
var TOKEN = 'Token';

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/isInvalidInt.js ***!
  \********************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isInvalidInt: function() { return /* binding */ isInvalidInt; }
/* harmony export */ });
function isInvalidInt(value) {
  return value < -999999999999999 || 999999999999999 < value;
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js":
/*!******************************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/structuredfield/utils/throwError.js ***!
  \******************************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   throwError: function() { return /* binding */ throwError; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/esm/typeof.js");
/* harmony import */ var core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
/* harmony import */ var core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_error_cause_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
/* harmony import */ var core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_concat_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.json.stringify.js */ "./node_modules/core-js/modules/es.json.stringify.js");
/* harmony import */ var core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_json_stringify_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_map_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.map.js */ "./node_modules/core-js/modules/es.map.js");
/* harmony import */ var core_js_modules_es_map_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_map_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_set_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.set.js */ "./node_modules/core-js/modules/es.set.js");
/* harmony import */ var core_js_modules_es_set_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_set_difference_v2_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.set.difference.v2.js */ "./node_modules/core-js/modules/es.set.difference.v2.js");
/* harmony import */ var core_js_modules_es_set_difference_v2_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_difference_v2_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_set_intersection_v2_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.set.intersection.v2.js */ "./node_modules/core-js/modules/es.set.intersection.v2.js");
/* harmony import */ var core_js_modules_es_set_intersection_v2_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_intersection_v2_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_set_is_disjoint_from_v2_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.set.is-disjoint-from.v2.js */ "./node_modules/core-js/modules/es.set.is-disjoint-from.v2.js");
/* harmony import */ var core_js_modules_es_set_is_disjoint_from_v2_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_is_disjoint_from_v2_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_set_is_subset_of_v2_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.set.is-subset-of.v2.js */ "./node_modules/core-js/modules/es.set.is-subset-of.v2.js");
/* harmony import */ var core_js_modules_es_set_is_subset_of_v2_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_is_subset_of_v2_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_set_is_superset_of_v2_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.set.is-superset-of.v2.js */ "./node_modules/core-js/modules/es.set.is-superset-of.v2.js");
/* harmony import */ var core_js_modules_es_set_is_superset_of_v2_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_is_superset_of_v2_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_set_symmetric_difference_v2_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.set.symmetric-difference.v2.js */ "./node_modules/core-js/modules/es.set.symmetric-difference.v2.js");
/* harmony import */ var core_js_modules_es_set_symmetric_difference_v2_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_symmetric_difference_v2_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_set_union_v2_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.set.union.v2.js */ "./node_modules/core-js/modules/es.set.union.v2.js");
/* harmony import */ var core_js_modules_es_set_union_v2_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_set_union_v2_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_16__);

















function format(value) {
  if (Array.isArray(value)) {
    return JSON.stringify(value);
  }
  if (value instanceof Map) {
    return 'Map{}';
  }
  if (value instanceof Set) {
    return 'Set{}';
  }
  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__["default"])(value) === 'object') {
    return JSON.stringify(value);
  }
  return String(value);
}
function throwError(action, src, type, cause) {
  return new Error("failed to ".concat(action, " \"").concat(format(src), "\" as ").concat(type), {
    cause: cause
  });
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/base64decode.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/base64decode.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   base64decode: function() { return /* binding */ base64decode; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
/* harmony import */ var core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_map_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
/* harmony import */ var core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_constructor_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
/* harmony import */ var core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_detached_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
/* harmony import */ var core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_buffer_transfer_to_fixed_length_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
/* harmony import */ var core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_uint8_array_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
/* harmony import */ var core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_at_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
/* harmony import */ var core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_copy_within_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
/* harmony import */ var core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_every_js__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
/* harmony import */ var core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_fill_js__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
/* harmony import */ var core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_filter_js__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
/* harmony import */ var core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_js__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_index_js__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_js__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
/* harmony import */ var core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_find_last_index_js__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
/* harmony import */ var core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_for_each_js__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
/* harmony import */ var core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_includes_js__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_index_of_js__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
/* harmony import */ var core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_iterator_js__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
/* harmony import */ var core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_join_js__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
/* harmony import */ var core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_23___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_last_index_of_js__WEBPACK_IMPORTED_MODULE_23__);
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
/* harmony import */ var core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_24___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_map_js__WEBPACK_IMPORTED_MODULE_24__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_25___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_js__WEBPACK_IMPORTED_MODULE_25__);
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
/* harmony import */ var core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_26___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reduce_right_js__WEBPACK_IMPORTED_MODULE_26__);
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
/* harmony import */ var core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_27___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_reverse_js__WEBPACK_IMPORTED_MODULE_27__);
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
/* harmony import */ var core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_28___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_set_js__WEBPACK_IMPORTED_MODULE_28__);
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
/* harmony import */ var core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_29___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_slice_js__WEBPACK_IMPORTED_MODULE_29__);
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
/* harmony import */ var core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_30___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_some_js__WEBPACK_IMPORTED_MODULE_30__);
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
/* harmony import */ var core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_31___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_sort_js__WEBPACK_IMPORTED_MODULE_31__);
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
/* harmony import */ var core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_32___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_subarray_js__WEBPACK_IMPORTED_MODULE_32__);
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_locale_string_js__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
/* harmony import */ var core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_34___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_reversed_js__WEBPACK_IMPORTED_MODULE_34__);
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
/* harmony import */ var core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_35___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_sorted_js__WEBPACK_IMPORTED_MODULE_35__);
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
/* harmony import */ var core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_36___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_to_string_js__WEBPACK_IMPORTED_MODULE_36__);
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/* harmony import */ var core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_37___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_typed_array_with_js__WEBPACK_IMPORTED_MODULE_37__);
/* harmony import */ var core_js_modules_web_atob_js__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! core-js/modules/web.atob.js */ "./node_modules/core-js/modules/web.atob.js");
/* harmony import */ var core_js_modules_web_atob_js__WEBPACK_IMPORTED_MODULE_38___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_atob_js__WEBPACK_IMPORTED_MODULE_38__);
/* harmony import */ var core_js_modules_web_dom_exception_constructor_js__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! core-js/modules/web.dom-exception.constructor.js */ "./node_modules/core-js/modules/web.dom-exception.constructor.js");
/* harmony import */ var core_js_modules_web_dom_exception_constructor_js__WEBPACK_IMPORTED_MODULE_39___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_exception_constructor_js__WEBPACK_IMPORTED_MODULE_39__);
/* harmony import */ var core_js_modules_web_dom_exception_stack_js__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! core-js/modules/web.dom-exception.stack.js */ "./node_modules/core-js/modules/web.dom-exception.stack.js");
/* harmony import */ var core_js_modules_web_dom_exception_stack_js__WEBPACK_IMPORTED_MODULE_40___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_exception_stack_js__WEBPACK_IMPORTED_MODULE_40__);
/* harmony import */ var core_js_modules_web_dom_exception_to_string_tag_js__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! core-js/modules/web.dom-exception.to-string-tag.js */ "./node_modules/core-js/modules/web.dom-exception.to-string-tag.js");
/* harmony import */ var core_js_modules_web_dom_exception_to_string_tag_js__WEBPACK_IMPORTED_MODULE_41___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_exception_to_string_tag_js__WEBPACK_IMPORTED_MODULE_41__);










































/**
 * Decodes a base64 encoded string into binary data
 *
 * @param str - The base64 encoded string to decode
 * @returns The decoded binary data
 *
 * @group Utils
 *
 * @beta
 */
function base64decode(str) {
  return new Uint8Array((0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(atob(str)).map(function (a) {
    return a.charCodeAt(0);
  }));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/base64encode.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/base64encode.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   base64encode: function() { return /* binding */ base64encode; }
/* harmony export */ });
/* harmony import */ var _babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/toConsumableArray */ "./node_modules/@babel/runtime/helpers/esm/toConsumableArray.js");
/* harmony import */ var core_js_modules_web_btoa_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.btoa.js */ "./node_modules/core-js/modules/web.btoa.js");
/* harmony import */ var core_js_modules_web_btoa_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_btoa_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_exception_constructor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-exception.constructor.js */ "./node_modules/core-js/modules/web.dom-exception.constructor.js");
/* harmony import */ var core_js_modules_web_dom_exception_constructor_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_exception_constructor_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_exception_stack_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-exception.stack.js */ "./node_modules/core-js/modules/web.dom-exception.stack.js");
/* harmony import */ var core_js_modules_web_dom_exception_stack_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_exception_stack_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_exception_to_string_tag_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-exception.to-string-tag.js */ "./node_modules/core-js/modules/web.dom-exception.to-string-tag.js");
/* harmony import */ var core_js_modules_web_dom_exception_to_string_tag_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_exception_to_string_tag_js__WEBPACK_IMPORTED_MODULE_4__);





/**
 * Encodes binary data to base64
 *
 * @param binary - The binary data to encode
 * @returns The base64 encoded string
 *
 * @group Utils
 *
 * @beta
 */
function base64encode(binary) {
  return btoa(String.fromCharCode.apply(String, (0,_babel_runtime_helpers_toConsumableArray__WEBPACK_IMPORTED_MODULE_0__["default"])(binary)));
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/roundToEven.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/roundToEven.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   roundToEven: function() { return /* binding */ roundToEven; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_number_epsilon_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.number.epsilon.js */ "./node_modules/core-js/modules/es.number.epsilon.js");
/* harmony import */ var core_js_modules_es_number_epsilon_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_number_epsilon_js__WEBPACK_IMPORTED_MODULE_0__);

/**
 * This implements the rounding procedure described in step 2 of the "Serializing a Decimal" specification.
 * This rounding style is known as "even rounding", "banker's rounding", or "commercial rounding".
 *
 * @param value - The value to round
 * @param precision - The number of decimal places to round to
 * @returns The rounded value
 *
 * @group Utils
 *
 * @beta
 */
function roundToEven(value, precision) {
  if (value < 0) {
    return -roundToEven(-value, precision);
  }
  var decimalShift = Math.pow(10, precision);
  var isEquidistant = Math.abs(value * decimalShift % 1 - 0.5) < Number.EPSILON;
  if (isEquidistant) {
    // If the tail of the decimal place is 'equidistant' we round to the nearest even value
    var flooredValue = Math.floor(value * decimalShift);
    return (flooredValue % 2 === 0 ? flooredValue : flooredValue + 1) / decimalShift;
  } else {
    // Otherwise, proceed as normal
    return Math.round(value * decimalShift) / decimalShift;
  }
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/urlToRelativePath.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/urlToRelativePath.js ***!
  \*********************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   urlToRelativePath: function() { return /* binding */ urlToRelativePath; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
/* harmony import */ var core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_join_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
/* harmony import */ var core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_slice_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
/* harmony import */ var core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_to_string_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.string.iterator.js */ "./node_modules/core-js/modules/es.string.iterator.js");
/* harmony import */ var core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_url_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.url.js */ "./node_modules/core-js/modules/web.url.js");
/* harmony import */ var core_js_modules_web_url_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var core_js_modules_web_url_to_json_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! core-js/modules/web.url.to-json.js */ "./node_modules/core-js/modules/web.url.to-json.js");
/* harmony import */ var core_js_modules_web_url_to_json_js__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_to_json_js__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var core_js_modules_web_url_search_params_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! core-js/modules/web.url-search-params.js */ "./node_modules/core-js/modules/web.url-search-params.js");
/* harmony import */ var core_js_modules_web_url_search_params_js__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_js__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! core-js/modules/web.url-search-params.delete.js */ "./node_modules/core-js/modules/web.url-search-params.delete.js");
/* harmony import */ var core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_delete_js__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! core-js/modules/web.url-search-params.has.js */ "./node_modules/core-js/modules/web.url-search-params.has.js");
/* harmony import */ var core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_has_js__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! core-js/modules/web.url-search-params.size.js */ "./node_modules/core-js/modules/web.url-search-params.size.js");
/* harmony import */ var core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_url_search_params_size_js__WEBPACK_IMPORTED_MODULE_11__);












/**
 * Constructs a relative path from a URL.
 *
 * @param url - The destination URL
 * @param base - The base URL
 * @returns The relative path
 *
 * @group Utils
 *
 * @beta
 */
function urlToRelativePath(url, base) {
  var to = new URL(url);
  var from = new URL(base);
  if (to.origin !== from.origin) {
    return url;
  }
  var toPath = to.pathname.split('/').slice(1);
  var fromPath = from.pathname.split('/').slice(1, -1);
  // remove common parents
  while (toPath[0] === fromPath[0]) {
    toPath.shift();
    fromPath.shift();
  }
  // add back paths
  while (fromPath.length) {
    fromPath.shift();
    toPath.unshift('..');
  }
  return toPath.join('/');
}

/***/ }),

/***/ "./node_modules/@svta/common-media-library/dist/utils/utf8ArrayToStr.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@svta/common-media-library/dist/utils/utf8ArrayToStr.js ***!
  \******************************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   utf8ArrayToStr: function() { return /* binding */ utf8ArrayToStr; }
/* harmony export */ });
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/* harmony import */ var core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_replace_js__WEBPACK_IMPORTED_MODULE_1__);


// http://stackoverflow.com/questions/8936984/uint8array-to-string-in-javascript/22373197
// http://www.onicos.com/staff/iz/amuse/javascript/expert/utf.txt
/* utf.js - UTF-8 <=> UTF-16 convertion
 *
 * Copyright (C) 1999 Masanao Izumo <iz@onicos.co.jp>
 * Version: 1.0
 * LastModified: Dec 25 1999
 * This library is free.  You can redistribute it and/or modify it.
 */
/**
 * Converts a UTF-8 array to a string.
 *
 * @param array - The UTF-8 array to convert
 *
 * @returns The string
 *
 * @group Utils
 *
 * @beta
 */
function utf8ArrayToStr(array) {
  var exitOnNull = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  if (typeof TextDecoder !== 'undefined') {
    var decoder = new TextDecoder('utf-8');
    var decoded = decoder.decode(array);
    if (exitOnNull) {
      // grab up to the first null
      var idx = decoded.indexOf('\0');
      return idx !== -1 ? decoded.substring(0, idx) : decoded;
    }
    // remove any null characters
    return decoded.replace(/\0/g, '');
  }
  var len = array.length;
  var c;
  var char2;
  var char3;
  var out = '';
  var i = 0;
  while (i < len) {
    c = array[i++];
    if (c === 0x00 && exitOnNull) {
      return out;
    } else if (c === 0x00 || c === 0x03) {
      // If the character is 3 (END_OF_TEXT) or 0 (NULL) then skip it
      continue;
    }
    switch (c >> 4) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        // 0xxxxxxx
        out += String.fromCharCode(c);
        break;
      case 12:
      case 13:
        // 110x xxxx   10xx xxxx
        char2 = array[i++];
        out += String.fromCharCode((c & 0x1f) << 6 | char2 & 0x3f);
        break;
      case 14:
        // 1110 xxxx  10xx xxxx  10xx xxxx
        char2 = array[i++];
        char3 = array[i++];
        out += String.fromCharCode((c & 0x0f) << 12 | (char2 & 0x3f) << 6 | (char3 & 0x3f) << 0);
        break;
      default:
    }
  }
  return out;
}

/***/ }),

/***/ "./node_modules/base64-js/index.js":
/*!*****************************************!*\
  !*** ./node_modules/base64-js/index.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";


__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
__webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
__webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
__webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
__webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
__webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
__webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
__webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
__webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
__webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
__webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
__webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
__webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
__webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
__webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
__webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
__webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
__webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
__webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
exports.byteLength = byteLength;
exports.toByteArray = toByteArray;
exports.fromByteArray = fromByteArray;
var lookup = [];
var revLookup = [];
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i];
  revLookup[code.charCodeAt(i)] = i;
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62;
revLookup['_'.charCodeAt(0)] = 63;
function getLens(b64) {
  var len = b64.length;
  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4');
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=');
  if (validLen === -1) validLen = len;
  var placeHoldersLen = validLen === len ? 0 : 4 - validLen % 4;
  return [validLen, placeHoldersLen];
}

// base64 is 4/3 + up to two characters of the original data
function byteLength(b64) {
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}
function _byteLength(b64, validLen, placeHoldersLen) {
  return (validLen + placeHoldersLen) * 3 / 4 - placeHoldersLen;
}
function toByteArray(b64) {
  var tmp;
  var lens = getLens(b64);
  var validLen = lens[0];
  var placeHoldersLen = lens[1];
  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen));
  var curByte = 0;

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0 ? validLen - 4 : validLen;
  var i;
  for (i = 0; i < len; i += 4) {
    tmp = revLookup[b64.charCodeAt(i)] << 18 | revLookup[b64.charCodeAt(i + 1)] << 12 | revLookup[b64.charCodeAt(i + 2)] << 6 | revLookup[b64.charCodeAt(i + 3)];
    arr[curByte++] = tmp >> 16 & 0xFF;
    arr[curByte++] = tmp >> 8 & 0xFF;
    arr[curByte++] = tmp & 0xFF;
  }
  if (placeHoldersLen === 2) {
    tmp = revLookup[b64.charCodeAt(i)] << 2 | revLookup[b64.charCodeAt(i + 1)] >> 4;
    arr[curByte++] = tmp & 0xFF;
  }
  if (placeHoldersLen === 1) {
    tmp = revLookup[b64.charCodeAt(i)] << 10 | revLookup[b64.charCodeAt(i + 1)] << 4 | revLookup[b64.charCodeAt(i + 2)] >> 2;
    arr[curByte++] = tmp >> 8 & 0xFF;
    arr[curByte++] = tmp & 0xFF;
  }
  return arr;
}
function tripletToBase64(num) {
  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F];
}
function encodeChunk(uint8, start, end) {
  var tmp;
  var output = [];
  for (var i = start; i < end; i += 3) {
    tmp = (uint8[i] << 16 & 0xFF0000) + (uint8[i + 1] << 8 & 0xFF00) + (uint8[i + 2] & 0xFF);
    output.push(tripletToBase64(tmp));
  }
  return output.join('');
}
function fromByteArray(uint8) {
  var tmp;
  var len = uint8.length;
  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
  var parts = [];
  var maxChunkLength = 16383; // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, i + maxChunkLength > len2 ? len2 : i + maxChunkLength));
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1];
    parts.push(lookup[tmp >> 2] + lookup[tmp << 4 & 0x3F] + '==');
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1];
    parts.push(lookup[tmp >> 10] + lookup[tmp >> 4 & 0x3F] + lookup[tmp << 2 & 0x3F] + '=');
  }
  return parts.join('');
}

/***/ }),

/***/ "./node_modules/buffer/index.js":
/*!**************************************!*\
  !*** ./node_modules/buffer/index.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
__webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
__webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
__webpack_require__(/*! core-js/modules/es.array.copy-within.js */ "./node_modules/core-js/modules/es.array.copy-within.js");
__webpack_require__(/*! core-js/modules/es.array.fill.js */ "./node_modules/core-js/modules/es.array.fill.js");
__webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
__webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
__webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
__webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
__webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
__webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
__webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
__webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
__webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
__webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
__webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
__webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
__webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
__webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
__webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
__webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
__webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
__webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
__webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
__webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
__webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
__webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
__webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
__webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
var base64 = __webpack_require__(/*! base64-js */ "./node_modules/base64-js/index.js");
var ieee754 = __webpack_require__(/*! ieee754 */ "./node_modules/ieee754/index.js");
var customInspectSymbol = typeof Symbol === 'function' && typeof Symbol['for'] === 'function' // eslint-disable-line dot-notation
? Symbol['for']('nodejs.util.inspect.custom') // eslint-disable-line dot-notation
: null;
exports.Buffer = Buffer;
exports.SlowBuffer = SlowBuffer;
exports.INSPECT_MAX_BYTES = 50;
var K_MAX_LENGTH = 0x7fffffff;
exports.kMaxLength = K_MAX_LENGTH;

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport();
if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' && typeof console.error === 'function') {
  console.error('This browser lacks typed array (Uint8Array) support which is required by ' + '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.');
}
function typedArraySupport() {
  // Can typed array instances can be augmented?
  try {
    var arr = new Uint8Array(1);
    var proto = {
      foo: function foo() {
        return 42;
      }
    };
    Object.setPrototypeOf(proto, Uint8Array.prototype);
    Object.setPrototypeOf(arr, proto);
    return arr.foo() === 42;
  } catch (e) {
    return false;
  }
}
Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function get() {
    if (!Buffer.isBuffer(this)) return undefined;
    return this.buffer;
  }
});
Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function get() {
    if (!Buffer.isBuffer(this)) return undefined;
    return this.byteOffset;
  }
});
function createBuffer(length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"');
  }
  // Return an augmented `Uint8Array` instance
  var buf = new Uint8Array(length);
  Object.setPrototypeOf(buf, Buffer.prototype);
  return buf;
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer(arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError('The "string" argument must be of type string. Received type number');
    }
    return allocUnsafe(arg);
  }
  return from(arg, encodingOrOffset, length);
}
Buffer.poolSize = 8192; // not used by this implementation

function from(value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset);
  }
  if (ArrayBuffer.isView(value)) {
    return fromArrayView(value);
  }
  if (value == null) {
    throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + _typeof(value));
  }
  if (isInstance(value, ArrayBuffer) || value && isInstance(value.buffer, ArrayBuffer)) {
    return fromArrayBuffer(value, encodingOrOffset, length);
  }
  if (typeof SharedArrayBuffer !== 'undefined' && (isInstance(value, SharedArrayBuffer) || value && isInstance(value.buffer, SharedArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length);
  }
  if (typeof value === 'number') {
    throw new TypeError('The "value" argument must not be of type number. Received type number');
  }
  var valueOf = value.valueOf && value.valueOf();
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length);
  }
  var b = fromObject(value);
  if (b) return b;
  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null && typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length);
  }
  throw new TypeError('The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' + 'or Array-like Object. Received type ' + _typeof(value));
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length);
};

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype);
Object.setPrototypeOf(Buffer, Uint8Array);
function assertSize(size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number');
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"');
  }
}
function alloc(size, fill, encoding) {
  assertSize(size);
  if (size <= 0) {
    return createBuffer(size);
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpreted as a start offset.
    return typeof encoding === 'string' ? createBuffer(size).fill(fill, encoding) : createBuffer(size).fill(fill);
  }
  return createBuffer(size);
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding);
};
function allocUnsafe(size) {
  assertSize(size);
  return createBuffer(size < 0 ? 0 : checked(size) | 0);
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size);
};
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size);
};
function fromString(string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8';
  }
  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding);
  }
  var length = byteLength(string, encoding) | 0;
  var buf = createBuffer(length);
  var actual = buf.write(string, encoding);
  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual);
  }
  return buf;
}
function fromArrayLike(array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0;
  var buf = createBuffer(length);
  for (var i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255;
  }
  return buf;
}
function fromArrayView(arrayView) {
  if (isInstance(arrayView, Uint8Array)) {
    var copy = new Uint8Array(arrayView);
    return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength);
  }
  return fromArrayLike(arrayView);
}
function fromArrayBuffer(array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds');
  }
  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds');
  }
  var buf;
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array);
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset);
  } else {
    buf = new Uint8Array(array, byteOffset, length);
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype);
  return buf;
}
function fromObject(obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0;
    var buf = createBuffer(len);
    if (buf.length === 0) {
      return buf;
    }
    obj.copy(buf, 0, 0, len);
    return buf;
  }
  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0);
    }
    return fromArrayLike(obj);
  }
  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data);
  }
}
function checked(length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' + 'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes');
  }
  return length | 0;
}
function SlowBuffer(length) {
  if (+length != length) {
    // eslint-disable-line eqeqeq
    length = 0;
  }
  return Buffer.alloc(+length);
}
Buffer.isBuffer = function isBuffer(b) {
  return b != null && b._isBuffer === true && b !== Buffer.prototype; // so Buffer.isBuffer(Buffer.prototype) will be false
};
Buffer.compare = function compare(a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength);
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength);
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array');
  }
  if (a === b) return 0;
  var x = a.length;
  var y = b.length;
  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break;
    }
  }
  if (x < y) return -1;
  if (y < x) return 1;
  return 0;
};
Buffer.isEncoding = function isEncoding(encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true;
    default:
      return false;
  }
};
Buffer.concat = function concat(list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers');
  }
  if (list.length === 0) {
    return Buffer.alloc(0);
  }
  var i;
  if (length === undefined) {
    length = 0;
    for (i = 0; i < list.length; ++i) {
      length += list[i].length;
    }
  }
  var buffer = Buffer.allocUnsafe(length);
  var pos = 0;
  for (i = 0; i < list.length; ++i) {
    var buf = list[i];
    if (isInstance(buf, Uint8Array)) {
      if (pos + buf.length > buffer.length) {
        Buffer.from(buf).copy(buffer, pos);
      } else {
        Uint8Array.prototype.set.call(buffer, buf, pos);
      }
    } else if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers');
    } else {
      buf.copy(buffer, pos);
    }
    pos += buf.length;
  }
  return buffer;
};
function byteLength(string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length;
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength;
  }
  if (typeof string !== 'string') {
    throw new TypeError('The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' + 'Received type ' + _typeof(string));
  }
  var len = string.length;
  var mustMatch = arguments.length > 2 && arguments[2] === true;
  if (!mustMatch && len === 0) return 0;

  // Use a for loop to avoid recursion
  var loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len;
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length;
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2;
      case 'hex':
        return len >>> 1;
      case 'base64':
        return base64ToBytes(string).length;
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length; // assume utf8
        }
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
}
Buffer.byteLength = byteLength;
function slowToString(encoding, start, end) {
  var loweredCase = false;

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0;
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return '';
  }
  if (end === undefined || end > this.length) {
    end = this.length;
  }
  if (end <= 0) {
    return '';
  }

  // Force coercion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0;
  start >>>= 0;
  if (end <= start) {
    return '';
  }
  if (!encoding) encoding = 'utf8';
  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end);
      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end);
      case 'ascii':
        return asciiSlice(this, start, end);
      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end);
      case 'base64':
        return base64Slice(this, start, end);
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end);
      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
        encoding = (encoding + '').toLowerCase();
        loweredCase = true;
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true;
function swap(b, n, m) {
  var i = b[n];
  b[n] = b[m];
  b[m] = i;
}
Buffer.prototype.swap16 = function swap16() {
  var len = this.length;
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits');
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1);
  }
  return this;
};
Buffer.prototype.swap32 = function swap32() {
  var len = this.length;
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits');
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3);
    swap(this, i + 1, i + 2);
  }
  return this;
};
Buffer.prototype.swap64 = function swap64() {
  var len = this.length;
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits');
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7);
    swap(this, i + 1, i + 6);
    swap(this, i + 2, i + 5);
    swap(this, i + 3, i + 4);
  }
  return this;
};
Buffer.prototype.toString = function toString() {
  var length = this.length;
  if (length === 0) return '';
  if (arguments.length === 0) return utf8Slice(this, 0, length);
  return slowToString.apply(this, arguments);
};
Buffer.prototype.toLocaleString = Buffer.prototype.toString;
Buffer.prototype.equals = function equals(b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer');
  if (this === b) return true;
  return Buffer.compare(this, b) === 0;
};
Buffer.prototype.inspect = function inspect() {
  var str = '';
  var max = exports.INSPECT_MAX_BYTES;
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim();
  if (this.length > max) str += ' ... ';
  return '<Buffer ' + str + '>';
};
if (customInspectSymbol) {
  Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect;
}
Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength);
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('The "target" argument must be one of type Buffer or Uint8Array. ' + 'Received type ' + _typeof(target));
  }
  if (start === undefined) {
    start = 0;
  }
  if (end === undefined) {
    end = target ? target.length : 0;
  }
  if (thisStart === undefined) {
    thisStart = 0;
  }
  if (thisEnd === undefined) {
    thisEnd = this.length;
  }
  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index');
  }
  if (thisStart >= thisEnd && start >= end) {
    return 0;
  }
  if (thisStart >= thisEnd) {
    return -1;
  }
  if (start >= end) {
    return 1;
  }
  start >>>= 0;
  end >>>= 0;
  thisStart >>>= 0;
  thisEnd >>>= 0;
  if (this === target) return 0;
  var x = thisEnd - thisStart;
  var y = end - start;
  var len = Math.min(x, y);
  var thisCopy = this.slice(thisStart, thisEnd);
  var targetCopy = target.slice(start, end);
  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i];
      y = targetCopy[i];
      break;
    }
  }
  if (x < y) return -1;
  if (y < x) return 1;
  return 0;
};

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1;

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset;
    byteOffset = 0;
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff;
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000;
  }
  byteOffset = +byteOffset; // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : buffer.length - 1;
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
  if (byteOffset >= buffer.length) {
    if (dir) return -1;else byteOffset = buffer.length - 1;
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0;else return -1;
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding);
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1;
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir);
  } else if (typeof val === 'number') {
    val = val & 0xFF; // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset);
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset);
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir);
  }
  throw new TypeError('val must be string, number or Buffer');
}
function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
  var indexSize = 1;
  var arrLength = arr.length;
  var valLength = val.length;
  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase();
    if (encoding === 'ucs2' || encoding === 'ucs-2' || encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1;
      }
      indexSize = 2;
      arrLength /= 2;
      valLength /= 2;
      byteOffset /= 2;
    }
  }
  function read(buf, i) {
    if (indexSize === 1) {
      return buf[i];
    } else {
      return buf.readUInt16BE(i * indexSize);
    }
  }
  var i;
  if (dir) {
    var foundIndex = -1;
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i;
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize;
      } else {
        if (foundIndex !== -1) i -= i - foundIndex;
        foundIndex = -1;
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
    for (i = byteOffset; i >= 0; i--) {
      var found = true;
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false;
          break;
        }
      }
      if (found) return i;
    }
  }
  return -1;
}
Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1;
};
Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true);
};
Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false);
};
function hexWrite(buf, string, offset, length) {
  offset = Number(offset) || 0;
  var remaining = buf.length - offset;
  if (!length) {
    length = remaining;
  } else {
    length = Number(length);
    if (length > remaining) {
      length = remaining;
    }
  }
  var strLen = string.length;
  if (length > strLen / 2) {
    length = strLen / 2;
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16);
    if (numberIsNaN(parsed)) return i;
    buf[offset + i] = parsed;
  }
  return i;
}
function utf8Write(buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length);
}
function asciiWrite(buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length);
}
function base64Write(buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length);
}
function ucs2Write(buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length);
}
Buffer.prototype.write = function write(string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8';
    length = this.length;
    offset = 0;
    // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset;
    length = this.length;
    offset = 0;
    // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset >>> 0;
    if (isFinite(length)) {
      length = length >>> 0;
      if (encoding === undefined) encoding = 'utf8';
    } else {
      encoding = length;
      length = undefined;
    }
  } else {
    throw new Error('Buffer.write(string, encoding, offset[, length]) is no longer supported');
  }
  var remaining = this.length - offset;
  if (length === undefined || length > remaining) length = remaining;
  if (string.length > 0 && (length < 0 || offset < 0) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds');
  }
  if (!encoding) encoding = 'utf8';
  var loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length);
      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length);
      case 'ascii':
      case 'latin1':
      case 'binary':
        return asciiWrite(this, string, offset, length);
      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length);
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length);
      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding);
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
};
Buffer.prototype.toJSON = function toJSON() {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  };
};
function base64Slice(buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf);
  } else {
    return base64.fromByteArray(buf.slice(start, end));
  }
}
function utf8Slice(buf, start, end) {
  end = Math.min(buf.length, end);
  var res = [];
  var i = start;
  while (i < end) {
    var firstByte = buf[i];
    var codePoint = null;
    var bytesPerSequence = firstByte > 0xEF ? 4 : firstByte > 0xDF ? 3 : firstByte > 0xBF ? 2 : 1;
    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint;
      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte;
          }
          break;
        case 2:
          secondByte = buf[i + 1];
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | secondByte & 0x3F;
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint;
            }
          }
          break;
        case 3:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | thirdByte & 0x3F;
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint;
            }
          }
          break;
        case 4:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          fourthByte = buf[i + 3];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | fourthByte & 0x3F;
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint;
            }
          }
      }
    }
    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD;
      bytesPerSequence = 1;
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000;
      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
      codePoint = 0xDC00 | codePoint & 0x3FF;
    }
    res.push(codePoint);
    i += bytesPerSequence;
  }
  return decodeCodePointsArray(res);
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000;
function decodeCodePointsArray(codePoints) {
  var len = codePoints.length;
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints); // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = '';
  var i = 0;
  while (i < len) {
    res += String.fromCharCode.apply(String, codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH));
  }
  return res;
}
function asciiSlice(buf, start, end) {
  var ret = '';
  end = Math.min(buf.length, end);
  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F);
  }
  return ret;
}
function latin1Slice(buf, start, end) {
  var ret = '';
  end = Math.min(buf.length, end);
  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i]);
  }
  return ret;
}
function hexSlice(buf, start, end) {
  var len = buf.length;
  if (!start || start < 0) start = 0;
  if (!end || end < 0 || end > len) end = len;
  var out = '';
  for (var i = start; i < end; ++i) {
    out += hexSliceLookupTable[buf[i]];
  }
  return out;
}
function utf16leSlice(buf, start, end) {
  var bytes = buf.slice(start, end);
  var res = '';
  // If bytes.length is odd, the last 8 bits must be ignored (same as node.js)
  for (var i = 0; i < bytes.length - 1; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
  }
  return res;
}
Buffer.prototype.slice = function slice(start, end) {
  var len = this.length;
  start = ~~start;
  end = end === undefined ? len : ~~end;
  if (start < 0) {
    start += len;
    if (start < 0) start = 0;
  } else if (start > len) {
    start = len;
  }
  if (end < 0) {
    end += len;
    if (end < 0) end = 0;
  } else if (end > len) {
    end = len;
  }
  if (end < start) end = start;
  var newBuf = this.subarray(start, end);
  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(newBuf, Buffer.prototype);
  return newBuf;
};

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset(offset, ext, length) {
  if (offset % 1 !== 0 || offset < 0) throw new RangeError('offset is not uint');
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length');
}
Buffer.prototype.readUintLE = Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);
  var val = this[offset];
  var mul = 1;
  var i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }
  return val;
};
Buffer.prototype.readUintBE = Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length);
  }
  var val = this[offset + --byteLength];
  var mul = 1;
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul;
  }
  return val;
};
Buffer.prototype.readUint8 = Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 1, this.length);
  return this[offset];
};
Buffer.prototype.readUint16LE = Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] | this[offset + 1] << 8;
};
Buffer.prototype.readUint16BE = Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] << 8 | this[offset + 1];
};
Buffer.prototype.readUint32LE = Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return (this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16) + this[offset + 3] * 0x1000000;
};
Buffer.prototype.readUint32BE = Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return this[offset] * 0x1000000 + (this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3]);
};
Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);
  var val = this[offset];
  var mul = 1;
  var i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }
  mul *= 0x80;
  if (val >= mul) val -= Math.pow(2, 8 * byteLength);
  return val;
};
Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);
  var i = byteLength;
  var mul = 1;
  var val = this[offset + --i];
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul;
  }
  mul *= 0x80;
  if (val >= mul) val -= Math.pow(2, 8 * byteLength);
  return val;
};
Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 1, this.length);
  if (!(this[offset] & 0x80)) return this[offset];
  return (0xff - this[offset] + 1) * -1;
};
Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  var val = this[offset] | this[offset + 1] << 8;
  return val & 0x8000 ? val | 0xFFFF0000 : val;
};
Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 2, this.length);
  var val = this[offset + 1] | this[offset] << 8;
  return val & 0x8000 ? val | 0xFFFF0000 : val;
};
Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return this[offset] | this[offset + 1] << 8 | this[offset + 2] << 16 | this[offset + 3] << 24;
};
Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return this[offset] << 24 | this[offset + 1] << 16 | this[offset + 2] << 8 | this[offset + 3];
};
Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return ieee754.read(this, offset, true, 23, 4);
};
Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 4, this.length);
  return ieee754.read(this, offset, false, 23, 4);
};
Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 8, this.length);
  return ieee754.read(this, offset, true, 52, 8);
};
Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
  offset = offset >>> 0;
  if (!noAssert) checkOffset(offset, 8, this.length);
  return ieee754.read(this, offset, false, 52, 8);
};
function checkInt(buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance');
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds');
  if (offset + ext > buf.length) throw new RangeError('Index out of range');
}
Buffer.prototype.writeUintLE = Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }
  var mul = 1;
  var i = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = value / mul & 0xFF;
  }
  return offset + byteLength;
};
Buffer.prototype.writeUintBE = Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  byteLength = byteLength >>> 0;
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }
  var i = byteLength - 1;
  var mul = 1;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = value / mul & 0xFF;
  }
  return offset + byteLength;
};
Buffer.prototype.writeUint8 = Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
  this[offset] = value & 0xff;
  return offset + 1;
};
Buffer.prototype.writeUint16LE = Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  this[offset] = value & 0xff;
  this[offset + 1] = value >>> 8;
  return offset + 2;
};
Buffer.prototype.writeUint16BE = Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  this[offset] = value >>> 8;
  this[offset + 1] = value & 0xff;
  return offset + 2;
};
Buffer.prototype.writeUint32LE = Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  this[offset + 3] = value >>> 24;
  this[offset + 2] = value >>> 16;
  this[offset + 1] = value >>> 8;
  this[offset] = value & 0xff;
  return offset + 4;
};
Buffer.prototype.writeUint32BE = Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  this[offset] = value >>> 24;
  this[offset + 1] = value >>> 16;
  this[offset + 2] = value >>> 8;
  this[offset + 3] = value & 0xff;
  return offset + 4;
};
Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1);
    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }
  var i = 0;
  var mul = 1;
  var sub = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = (value / mul >> 0) - sub & 0xFF;
  }
  return offset + byteLength;
};
Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1);
    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }
  var i = byteLength - 1;
  var mul = 1;
  var sub = 0;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = (value / mul >> 0) - sub & 0xFF;
  }
  return offset + byteLength;
};
Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
  if (value < 0) value = 0xff + value + 1;
  this[offset] = value & 0xff;
  return offset + 1;
};
Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
  this[offset] = value & 0xff;
  this[offset + 1] = value >>> 8;
  return offset + 2;
};
Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
  this[offset] = value >>> 8;
  this[offset + 1] = value & 0xff;
  return offset + 2;
};
Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
  this[offset] = value & 0xff;
  this[offset + 1] = value >>> 8;
  this[offset + 2] = value >>> 16;
  this[offset + 3] = value >>> 24;
  return offset + 4;
};
Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
  if (value < 0) value = 0xffffffff + value + 1;
  this[offset] = value >>> 24;
  this[offset + 1] = value >>> 16;
  this[offset + 2] = value >>> 8;
  this[offset + 3] = value & 0xff;
  return offset + 4;
};
function checkIEEE754(buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range');
  if (offset < 0) throw new RangeError('Index out of range');
}
function writeFloat(buf, value, offset, littleEndian, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38);
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4);
  return offset + 4;
}
Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert);
};
Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert);
};
function writeDouble(buf, value, offset, littleEndian, noAssert) {
  value = +value;
  offset = offset >>> 0;
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308);
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8);
  return offset + 8;
}
Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert);
};
Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert);
};

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy(target, targetStart, start, end) {
  if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer');
  if (!start) start = 0;
  if (!end && end !== 0) end = this.length;
  if (targetStart >= target.length) targetStart = target.length;
  if (!targetStart) targetStart = 0;
  if (end > 0 && end < start) end = start;

  // Copy 0 bytes; we're done
  if (end === start) return 0;
  if (target.length === 0 || this.length === 0) return 0;

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds');
  }
  if (start < 0 || start >= this.length) throw new RangeError('Index out of range');
  if (end < 0) throw new RangeError('sourceEnd out of bounds');

  // Are we oob?
  if (end > this.length) end = this.length;
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start;
  }
  var len = end - start;
  if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
    // Use built-in when available, missing from IE11
    this.copyWithin(targetStart, start, end);
  } else {
    Uint8Array.prototype.set.call(target, this.subarray(start, end), targetStart);
  }
  return len;
};

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill(val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start;
      start = 0;
      end = this.length;
    } else if (typeof end === 'string') {
      encoding = end;
      end = this.length;
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string');
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding);
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0);
      if (encoding === 'utf8' && code < 128 || encoding === 'latin1') {
        // Fast path: If `val` fits into a single byte, use that numeric value.
        val = code;
      }
    }
  } else if (typeof val === 'number') {
    val = val & 255;
  } else if (typeof val === 'boolean') {
    val = Number(val);
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index');
  }
  if (end <= start) {
    return this;
  }
  start = start >>> 0;
  end = end === undefined ? this.length : end >>> 0;
  if (!val) val = 0;
  var i;
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val;
    }
  } else {
    var bytes = Buffer.isBuffer(val) ? val : Buffer.from(val, encoding);
    var len = bytes.length;
    if (len === 0) {
      throw new TypeError('The value "' + val + '" is invalid for argument "value"');
    }
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len];
    }
  }
  return this;
};

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g;
function base64clean(str) {
  // Node takes equal signs as end of the Base64 encoding
  str = str.split('=')[0];
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = str.trim().replace(INVALID_BASE64_RE, '');
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return '';
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '=';
  }
  return str;
}
function utf8ToBytes(string, units) {
  units = units || Infinity;
  var codePoint;
  var length = string.length;
  var leadSurrogate = null;
  var bytes = [];
  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i);

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue;
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue;
        }

        // valid lead
        leadSurrogate = codePoint;
        continue;
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
        leadSurrogate = codePoint;
        continue;
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
    }
    leadSurrogate = null;

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break;
      bytes.push(codePoint);
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break;
      bytes.push(codePoint >> 0x6 | 0xC0, codePoint & 0x3F | 0x80);
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break;
      bytes.push(codePoint >> 0xC | 0xE0, codePoint >> 0x6 & 0x3F | 0x80, codePoint & 0x3F | 0x80);
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break;
      bytes.push(codePoint >> 0x12 | 0xF0, codePoint >> 0xC & 0x3F | 0x80, codePoint >> 0x6 & 0x3F | 0x80, codePoint & 0x3F | 0x80);
    } else {
      throw new Error('Invalid code point');
    }
  }
  return bytes;
}
function asciiToBytes(str) {
  var byteArray = [];
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF);
  }
  return byteArray;
}
function utf16leToBytes(str, units) {
  var c, hi, lo;
  var byteArray = [];
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break;
    c = str.charCodeAt(i);
    hi = c >> 8;
    lo = c % 256;
    byteArray.push(lo);
    byteArray.push(hi);
  }
  return byteArray;
}
function base64ToBytes(str) {
  return base64.toByteArray(base64clean(str));
}
function blitBuffer(src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if (i + offset >= dst.length || i >= src.length) break;
    dst[i + offset] = src[i];
  }
  return i;
}

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
function isInstance(obj, type) {
  return obj instanceof type || obj != null && obj.constructor != null && obj.constructor.name != null && obj.constructor.name === type.name;
}
function numberIsNaN(obj) {
  // For IE11 support
  return obj !== obj; // eslint-disable-line no-self-compare
}

// Create lookup table for `toString('hex')`
// See: https://github.com/feross/buffer/issues/219
var hexSliceLookupTable = function () {
  var alphabet = '0123456789abcdef';
  var table = new Array(256);
  for (var i = 0; i < 16; ++i) {
    var i16 = i * 16;
    for (var j = 0; j < 16; ++j) {
      table[i16 + j] = alphabet[i] + alphabet[j];
    }
  }
  return table;
}();

/***/ }),

/***/ "./node_modules/codem-isoboxer/dist/iso_boxer.js":
/*!*******************************************************!*\
  !*** ./node_modules/codem-isoboxer/dist/iso_boxer.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/core-js/modules/es.array.iterator.js");
__webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.constructor.js */ "./node_modules/core-js/modules/es.array-buffer.constructor.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.detached.js */ "./node_modules/core-js/modules/es.array-buffer.detached.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.transfer.js */ "./node_modules/core-js/modules/es.array-buffer.transfer.js");
__webpack_require__(/*! core-js/modules/es.array-buffer.transfer-to-fixed-length.js */ "./node_modules/core-js/modules/es.array-buffer.transfer-to-fixed-length.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.flags.js */ "./node_modules/core-js/modules/es.regexp.flags.js");
__webpack_require__(/*! core-js/modules/es.typed-array.uint8-array.js */ "./node_modules/core-js/modules/es.typed-array.uint8-array.js");
__webpack_require__(/*! core-js/modules/es.typed-array.at.js */ "./node_modules/core-js/modules/es.typed-array.at.js");
__webpack_require__(/*! core-js/modules/es.typed-array.copy-within.js */ "./node_modules/core-js/modules/es.typed-array.copy-within.js");
__webpack_require__(/*! core-js/modules/es.typed-array.every.js */ "./node_modules/core-js/modules/es.typed-array.every.js");
__webpack_require__(/*! core-js/modules/es.typed-array.fill.js */ "./node_modules/core-js/modules/es.typed-array.fill.js");
__webpack_require__(/*! core-js/modules/es.typed-array.filter.js */ "./node_modules/core-js/modules/es.typed-array.filter.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find.js */ "./node_modules/core-js/modules/es.typed-array.find.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-index.js */ "./node_modules/core-js/modules/es.typed-array.find-index.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-last.js */ "./node_modules/core-js/modules/es.typed-array.find-last.js");
__webpack_require__(/*! core-js/modules/es.typed-array.find-last-index.js */ "./node_modules/core-js/modules/es.typed-array.find-last-index.js");
__webpack_require__(/*! core-js/modules/es.typed-array.for-each.js */ "./node_modules/core-js/modules/es.typed-array.for-each.js");
__webpack_require__(/*! core-js/modules/es.typed-array.includes.js */ "./node_modules/core-js/modules/es.typed-array.includes.js");
__webpack_require__(/*! core-js/modules/es.typed-array.index-of.js */ "./node_modules/core-js/modules/es.typed-array.index-of.js");
__webpack_require__(/*! core-js/modules/es.typed-array.iterator.js */ "./node_modules/core-js/modules/es.typed-array.iterator.js");
__webpack_require__(/*! core-js/modules/es.typed-array.join.js */ "./node_modules/core-js/modules/es.typed-array.join.js");
__webpack_require__(/*! core-js/modules/es.typed-array.last-index-of.js */ "./node_modules/core-js/modules/es.typed-array.last-index-of.js");
__webpack_require__(/*! core-js/modules/es.typed-array.map.js */ "./node_modules/core-js/modules/es.typed-array.map.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reduce.js */ "./node_modules/core-js/modules/es.typed-array.reduce.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reduce-right.js */ "./node_modules/core-js/modules/es.typed-array.reduce-right.js");
__webpack_require__(/*! core-js/modules/es.typed-array.reverse.js */ "./node_modules/core-js/modules/es.typed-array.reverse.js");
__webpack_require__(/*! core-js/modules/es.typed-array.set.js */ "./node_modules/core-js/modules/es.typed-array.set.js");
__webpack_require__(/*! core-js/modules/es.typed-array.slice.js */ "./node_modules/core-js/modules/es.typed-array.slice.js");
__webpack_require__(/*! core-js/modules/es.typed-array.some.js */ "./node_modules/core-js/modules/es.typed-array.some.js");
__webpack_require__(/*! core-js/modules/es.typed-array.sort.js */ "./node_modules/core-js/modules/es.typed-array.sort.js");
__webpack_require__(/*! core-js/modules/es.typed-array.subarray.js */ "./node_modules/core-js/modules/es.typed-array.subarray.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-locale-string.js */ "./node_modules/core-js/modules/es.typed-array.to-locale-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-reversed.js */ "./node_modules/core-js/modules/es.typed-array.to-reversed.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-sorted.js */ "./node_modules/core-js/modules/es.typed-array.to-sorted.js");
__webpack_require__(/*! core-js/modules/es.typed-array.to-string.js */ "./node_modules/core-js/modules/es.typed-array.to-string.js");
__webpack_require__(/*! core-js/modules/es.typed-array.with.js */ "./node_modules/core-js/modules/es.typed-array.with.js");
/*! codem-isoboxer v0.3.10 https://github.com/madebyhiro/codem-isoboxer/blob/master/LICENSE.txt */
var ISOBoxer = {};
ISOBoxer.parseBuffer = function (arrayBuffer) {
  return new ISOFile(arrayBuffer).parse();
};
ISOBoxer.addBoxProcessor = function (type, parser) {
  if (typeof type !== 'string' || typeof parser !== 'function') {
    return;
  }
  ISOBox.prototype._boxProcessors[type] = parser;
};
ISOBoxer.createFile = function () {
  return new ISOFile();
};

// See ISOBoxer.append() for 'pos' parameter syntax
ISOBoxer.createBox = function (type, parent, pos) {
  var newBox = ISOBox.create(type);
  if (parent) {
    parent.append(newBox, pos);
  }
  return newBox;
};

// See ISOBoxer.append() for 'pos' parameter syntax
ISOBoxer.createFullBox = function (type, parent, pos) {
  var newBox = ISOBoxer.createBox(type, parent, pos);
  newBox.version = 0;
  newBox.flags = 0;
  return newBox;
};
ISOBoxer.Utils = {};
ISOBoxer.Utils.dataViewToString = function (dataView, encoding) {
  var impliedEncoding = encoding || 'utf-8';
  if (typeof TextDecoder !== 'undefined') {
    return new TextDecoder(impliedEncoding).decode(dataView);
  }
  var a = [];
  var i = 0;
  if (impliedEncoding === 'utf-8') {
    /* The following algorithm is essentially a rewrite of the UTF8.decode at
    http://bannister.us/weblog/2007/simple-base64-encodedecode-javascript/
    */

    while (i < dataView.byteLength) {
      var c = dataView.getUint8(i++);
      if (c < 0x80) {
        // 1-byte character (7 bits)
      } else if (c < 0xe0) {
        // 2-byte character (11 bits)
        c = (c & 0x1f) << 6;
        c |= dataView.getUint8(i++) & 0x3f;
      } else if (c < 0xf0) {
        // 3-byte character (16 bits)
        c = (c & 0xf) << 12;
        c |= (dataView.getUint8(i++) & 0x3f) << 6;
        c |= dataView.getUint8(i++) & 0x3f;
      } else {
        // 4-byte character (21 bits)
        c = (c & 0x7) << 18;
        c |= (dataView.getUint8(i++) & 0x3f) << 12;
        c |= (dataView.getUint8(i++) & 0x3f) << 6;
        c |= dataView.getUint8(i++) & 0x3f;
      }
      a.push(String.fromCharCode(c));
    }
  } else {
    // Just map byte-by-byte (probably wrong)
    while (i < dataView.byteLength) {
      a.push(String.fromCharCode(dataView.getUint8(i++)));
    }
  }
  return a.join('');
};
ISOBoxer.Utils.utf8ToByteArray = function (string) {
  // Only UTF-8 encoding is supported by TextEncoder
  var u, i;
  if (typeof TextEncoder !== 'undefined') {
    u = new TextEncoder().encode(string);
  } else {
    u = [];
    for (i = 0; i < string.length; ++i) {
      var c = string.charCodeAt(i);
      if (c < 0x80) {
        u.push(c);
      } else if (c < 0x800) {
        u.push(0xC0 | c >> 6);
        u.push(0x80 | 63 & c);
      } else if (c < 0x10000) {
        u.push(0xE0 | c >> 12);
        u.push(0x80 | 63 & c >> 6);
        u.push(0x80 | 63 & c);
      } else {
        u.push(0xF0 | c >> 18);
        u.push(0x80 | 63 & c >> 12);
        u.push(0x80 | 63 & c >> 6);
        u.push(0x80 | 63 & c);
      }
    }
  }
  return u;
};

// Method to append a box in the list of child boxes
// The 'pos' parameter can be either:
//   - (number) a position index at which to insert the new box
//   - (string) the type of the box after which to insert the new box
//   - (object) the box after which to insert the new box
ISOBoxer.Utils.appendBox = function (parent, box, pos) {
  box._offset = parent._cursor.offset;
  box._root = parent._root ? parent._root : parent;
  box._raw = parent._raw;
  box._parent = parent;
  if (pos === -1) {
    // The new box is a sub-box of the parent but not added in boxes array,
    // for example when the new box is set as an entry (see dref and stsd for example)
    return;
  }
  if (pos === undefined || pos === null) {
    parent.boxes.push(box);
    return;
  }
  var index = -1,
    type;
  if (typeof pos === "number") {
    index = pos;
  } else {
    if (typeof pos === "string") {
      type = pos;
    } else if (_typeof(pos) === "object" && pos.type) {
      type = pos.type;
    } else {
      parent.boxes.push(box);
      return;
    }
    for (var i = 0; i < parent.boxes.length; i++) {
      if (type === parent.boxes[i].type) {
        index = i + 1;
        break;
      }
    }
  }
  parent.boxes.splice(index, 0, box);
};
if (true) {
  exports.parseBuffer = ISOBoxer.parseBuffer;
  exports.addBoxProcessor = ISOBoxer.addBoxProcessor;
  exports.createFile = ISOBoxer.createFile;
  exports.createBox = ISOBoxer.createBox;
  exports.createFullBox = ISOBoxer.createFullBox;
  exports.Utils = ISOBoxer.Utils;
}
ISOBoxer.Cursor = function (initialOffset) {
  this.offset = typeof initialOffset == 'undefined' ? 0 : initialOffset;
};
var ISOFile = function ISOFile(arrayBuffer) {
  this._cursor = new ISOBoxer.Cursor();
  this.boxes = [];
  if (arrayBuffer) {
    this._raw = new DataView(arrayBuffer);
  }
};
ISOFile.prototype.fetch = function (type) {
  var result = this.fetchAll(type, true);
  return result.length ? result[0] : null;
};
ISOFile.prototype.fetchAll = function (type, returnEarly) {
  var result = [];
  ISOFile._sweep.call(this, type, result, returnEarly);
  return result;
};
ISOFile.prototype.parse = function () {
  this._cursor.offset = 0;
  this.boxes = [];
  while (this._cursor.offset < this._raw.byteLength) {
    var box = ISOBox.parse(this);

    // Box could not be parsed
    if (typeof box.type === 'undefined') break;
    this.boxes.push(box);
  }
  return this;
};
ISOFile._sweep = function (type, result, returnEarly) {
  if (this.type && this.type == type) result.push(this);
  for (var box in this.boxes) {
    if (result.length && returnEarly) return;
    ISOFile._sweep.call(this.boxes[box], type, result, returnEarly);
  }
};
ISOFile.prototype.write = function () {
  var length = 0,
    i;
  for (i = 0; i < this.boxes.length; i++) {
    length += this.boxes[i].getLength(false);
  }
  var bytes = new Uint8Array(length);
  this._rawo = new DataView(bytes.buffer);
  this.bytes = bytes;
  this._cursor.offset = 0;
  for (i = 0; i < this.boxes.length; i++) {
    this.boxes[i].write();
  }
  return bytes.buffer;
};
ISOFile.prototype.append = function (box, pos) {
  ISOBoxer.Utils.appendBox(this, box, pos);
};
var ISOBox = function ISOBox() {
  this._cursor = new ISOBoxer.Cursor();
};
ISOBox.parse = function (parent) {
  var newBox = new ISOBox();
  newBox._offset = parent._cursor.offset;
  newBox._root = parent._root ? parent._root : parent;
  newBox._raw = parent._raw;
  newBox._parent = parent;
  newBox._parseBox();
  parent._cursor.offset = newBox._raw.byteOffset + newBox._raw.byteLength;
  return newBox;
};
ISOBox.create = function (type) {
  var newBox = new ISOBox();
  newBox.type = type;
  newBox.boxes = [];
  return newBox;
};
ISOBox.prototype._boxContainers = ['dinf', 'edts', 'mdia', 'meco', 'mfra', 'minf', 'moof', 'moov', 'mvex', 'stbl', 'strk', 'traf', 'trak', 'tref', 'udta', 'vttc', 'sinf', 'schi', 'encv', 'enca', 'meta', 'grpl', 'prsl'];
ISOBox.prototype._boxProcessors = {};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Generic read/write functions

ISOBox.prototype._procField = function (name, type, size) {
  if (this._parsing) {
    this[name] = this._readField(type, size);
  } else {
    this._writeField(type, size, this[name]);
  }
};
ISOBox.prototype._procFieldArray = function (name, length, type, size) {
  var i;
  if (this._parsing) {
    this[name] = [];
    for (i = 0; i < length; i++) {
      this[name][i] = this._readField(type, size);
    }
  } else {
    for (i = 0; i < this[name].length; i++) {
      this._writeField(type, size, this[name][i]);
    }
  }
};
ISOBox.prototype._procFullBox = function () {
  this._procField('version', 'uint', 8);
  this._procField('flags', 'uint', 24);
};
ISOBox.prototype._procEntries = function (name, length, fn) {
  var i;
  if (this._parsing) {
    this[name] = [];
    for (i = 0; i < length; i++) {
      this[name].push({});
      fn.call(this, this[name][i]);
    }
  } else {
    for (i = 0; i < length; i++) {
      fn.call(this, this[name][i]);
    }
  }
};
ISOBox.prototype._procSubEntries = function (entry, name, length, fn) {
  var i;
  if (this._parsing) {
    entry[name] = [];
    for (i = 0; i < length; i++) {
      entry[name].push({});
      fn.call(this, entry[name][i]);
    }
  } else {
    for (i = 0; i < length; i++) {
      fn.call(this, entry[name][i]);
    }
  }
};
ISOBox.prototype._procEntryField = function (entry, name, type, size) {
  if (this._parsing) {
    entry[name] = this._readField(type, size);
  } else {
    this._writeField(type, size, entry[name]);
  }
};
ISOBox.prototype._procSubBoxes = function (name, length) {
  var i;
  if (this._parsing) {
    this[name] = [];
    for (i = 0; i < length; i++) {
      this[name].push(ISOBox.parse(this));
    }
  } else {
    for (i = 0; i < length; i++) {
      if (this._rawo) {
        this[name][i].write();
      } else {
        this.size += this[name][i].getLength();
      }
    }
  }
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Read/parse functions

ISOBox.prototype._readField = function (type, size) {
  switch (type) {
    case 'uint':
      return this._readUint(size);
    case 'int':
      return this._readInt(size);
    case 'template':
      return this._readTemplate(size);
    case 'string':
      return size === -1 ? this._readTerminatedString() : this._readString(size);
    case 'data':
      return this._readData(size);
    case 'utf8':
      return this._readUTF8String();
    case 'utf8string':
      return this._readUTF8TerminatedString();
    default:
      return -1;
  }
};
ISOBox.prototype._readInt = function (size) {
  var result = null,
    offset = this._cursor.offset - this._raw.byteOffset;
  switch (size) {
    case 8:
      result = this._raw.getInt8(offset);
      break;
    case 16:
      result = this._raw.getInt16(offset);
      break;
    case 32:
      result = this._raw.getInt32(offset);
      break;
    case 64:
      // Warning: JavaScript cannot handle 64-bit integers natively.
      // This will give unexpected results for integers >= 2^53
      var s1 = this._raw.getInt32(offset);
      var s2 = this._raw.getInt32(offset + 4);
      result = s1 * Math.pow(2, 32) + s2;
      break;
  }
  this._cursor.offset += size >> 3;
  return result;
};
ISOBox.prototype._readUint = function (size) {
  var result = null,
    offset = this._cursor.offset - this._raw.byteOffset,
    s1,
    s2;
  switch (size) {
    case 8:
      result = this._raw.getUint8(offset);
      break;
    case 16:
      result = this._raw.getUint16(offset);
      break;
    case 24:
      s1 = this._raw.getUint16(offset);
      s2 = this._raw.getUint8(offset + 2);
      result = (s1 << 8) + s2;
      break;
    case 32:
      result = this._raw.getUint32(offset);
      break;
    case 64:
      // Warning: JavaScript cannot handle 64-bit integers natively.
      // This will give unexpected results for integers >= 2^53
      s1 = this._raw.getUint32(offset);
      s2 = this._raw.getUint32(offset + 4);
      result = s1 * Math.pow(2, 32) + s2;
      break;
  }
  this._cursor.offset += size >> 3;
  return result;
};
ISOBox.prototype._readString = function (length) {
  var str = '';
  for (var c = 0; c < length; c++) {
    var char = this._readUint(8);
    str += String.fromCharCode(char);
  }
  return str;
};
ISOBox.prototype._readTemplate = function (size) {
  var pre = this._readUint(size / 2);
  var post = this._readUint(size / 2);
  return pre + post / Math.pow(2, size / 2);
};
ISOBox.prototype._readTerminatedString = function () {
  var str = '';
  while (this._cursor.offset - this._offset < this._raw.byteLength) {
    var char = this._readUint(8);
    if (char === 0) break;
    str += String.fromCharCode(char);
  }
  return str;
};
ISOBox.prototype._readData = function (size) {
  var length = size > 0 ? size : this._raw.byteLength - (this._cursor.offset - this._offset);
  if (length > 0) {
    var data = new Uint8Array(this._raw.buffer, this._cursor.offset, length);
    this._cursor.offset += length;
    return data;
  } else {
    return null;
  }
};
ISOBox.prototype._readUTF8String = function () {
  var length = this._raw.byteLength - (this._cursor.offset - this._offset);
  var data = null;
  if (length > 0) {
    data = new DataView(this._raw.buffer, this._cursor.offset, length);
    this._cursor.offset += length;
  }
  return data ? ISOBoxer.Utils.dataViewToString(data) : data;
};
ISOBox.prototype._readUTF8TerminatedString = function () {
  var length = this._raw.byteLength - (this._cursor.offset - this._offset);
  var data = null;
  if (length > 0) {
    data = new DataView(this._raw.buffer, this._cursor.offset, length);
    var l;
    for (l = 0; l < length; l++) if (data.getUint8(l) === 0) break;

    // remap the Dataview with the actual length
    data = new DataView(this._raw.buffer, this._cursor.offset, l);
    this._cursor.offset += Math.min(l + 1, length);
  }
  return data ? ISOBoxer.Utils.dataViewToString(data) : data;
};
ISOBox.prototype._parseBox = function () {
  this._parsing = true;
  this._cursor.offset = this._offset;

  // return immediately if there are not enough bytes to read the header
  if (this._offset + 8 > this._raw.buffer.byteLength) {
    this._root._incomplete = true;
    return;
  }
  this._procField('size', 'uint', 32);
  this._procField('type', 'string', 4);
  if (this.size === 1) {
    this._procField('largesize', 'uint', 64);
  }
  if (this.type === 'uuid') {
    this._procFieldArray('usertype', 16, 'uint', 8);
  }
  switch (this.size) {
    case 0:
      // Size zero indicates last box in the file. Consume remaining buffer.
      this._raw = new DataView(this._raw.buffer, this._offset);
      break;
    case 1:
      if (this._offset + this.size > this._raw.buffer.byteLength) {
        this._incomplete = true;
        this._root._incomplete = true;
      } else {
        this._raw = new DataView(this._raw.buffer, this._offset, this.largesize);
      }
      break;
    default:
      if (this._offset + this.size > this._raw.buffer.byteLength) {
        this._incomplete = true;
        this._root._incomplete = true;
      } else {
        this._raw = new DataView(this._raw.buffer, this._offset, this.size);
      }
  }

  // additional parsing
  if (!this._incomplete) {
    if (this._boxProcessors[this.type]) {
      this._boxProcessors[this.type].call(this);
    }
    if (this._boxContainers.indexOf(this.type) !== -1) {
      this._parseContainerBox();
    } else {
      // Unknown box => read and store box content
      this._data = this._readData();
    }
  }
};
ISOBox.prototype._parseFullBox = function () {
  this.version = this._readUint(8);
  this.flags = this._readUint(24);
};
ISOBox.prototype._parseContainerBox = function () {
  this.boxes = [];
  while (this._cursor.offset - this._raw.byteOffset < this._raw.byteLength) {
    this.boxes.push(ISOBox.parse(this));
  }
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Write functions

ISOBox.prototype.append = function (box, pos) {
  ISOBoxer.Utils.appendBox(this, box, pos);
};
ISOBox.prototype.getLength = function () {
  this._parsing = false;
  this._rawo = null;
  this.size = 0;
  this._procField('size', 'uint', 32);
  this._procField('type', 'string', 4);
  if (this.size === 1) {
    this._procField('largesize', 'uint', 64);
  }
  if (this.type === 'uuid') {
    this._procFieldArray('usertype', 16, 'uint', 8);
  }
  if (this._boxProcessors[this.type]) {
    this._boxProcessors[this.type].call(this);
  }
  if (this._boxContainers.indexOf(this.type) !== -1) {
    for (var i = 0; i < this.boxes.length; i++) {
      this.size += this.boxes[i].getLength();
    }
  }
  if (this._data) {
    this._writeData(this._data);
  }
  return this.size;
};
ISOBox.prototype.write = function () {
  this._parsing = false;
  this._cursor.offset = this._parent._cursor.offset;
  switch (this.size) {
    case 0:
      this._rawo = new DataView(this._parent._rawo.buffer, this._cursor.offset, this.parent._rawo.byteLength - this._cursor.offset);
      break;
    case 1:
      this._rawo = new DataView(this._parent._rawo.buffer, this._cursor.offset, this.largesize);
      break;
    default:
      this._rawo = new DataView(this._parent._rawo.buffer, this._cursor.offset, this.size);
  }
  this._procField('size', 'uint', 32);
  this._procField('type', 'string', 4);
  if (this.size === 1) {
    this._procField('largesize', 'uint', 64);
  }
  if (this.type === 'uuid') {
    this._procFieldArray('usertype', 16, 'uint', 8);
  }
  if (this._boxProcessors[this.type]) {
    this._boxProcessors[this.type].call(this);
  }
  if (this._boxContainers.indexOf(this.type) !== -1) {
    for (var i = 0; i < this.boxes.length; i++) {
      this.boxes[i].write();
    }
  }
  if (this._data) {
    this._writeData(this._data);
  }
  this._parent._cursor.offset += this.size;
  return this.size;
};
ISOBox.prototype._writeInt = function (size, value) {
  if (this._rawo) {
    var offset = this._cursor.offset - this._rawo.byteOffset;
    switch (size) {
      case 8:
        this._rawo.setInt8(offset, value);
        break;
      case 16:
        this._rawo.setInt16(offset, value);
        break;
      case 32:
        this._rawo.setInt32(offset, value);
        break;
      case 64:
        // Warning: JavaScript cannot handle 64-bit integers natively.
        // This will give unexpected results for integers >= 2^53
        var s1 = Math.floor(value / Math.pow(2, 32));
        var s2 = value - s1 * Math.pow(2, 32);
        this._rawo.setUint32(offset, s1);
        this._rawo.setUint32(offset + 4, s2);
        break;
    }
    this._cursor.offset += size >> 3;
  } else {
    this.size += size >> 3;
  }
};
ISOBox.prototype._writeUint = function (size, value) {
  if (this._rawo) {
    var offset = this._cursor.offset - this._rawo.byteOffset,
      s1,
      s2;
    switch (size) {
      case 8:
        this._rawo.setUint8(offset, value);
        break;
      case 16:
        this._rawo.setUint16(offset, value);
        break;
      case 24:
        s1 = (value & 0xFFFF00) >> 8;
        s2 = value & 0x0000FF;
        this._rawo.setUint16(offset, s1);
        this._rawo.setUint8(offset + 2, s2);
        break;
      case 32:
        this._rawo.setUint32(offset, value);
        break;
      case 64:
        // Warning: JavaScript cannot handle 64-bit integers natively.
        // This will give unexpected results for integers >= 2^53
        s1 = Math.floor(value / Math.pow(2, 32));
        s2 = value - s1 * Math.pow(2, 32);
        this._rawo.setUint32(offset, s1);
        this._rawo.setUint32(offset + 4, s2);
        break;
    }
    this._cursor.offset += size >> 3;
  } else {
    this.size += size >> 3;
  }
};
ISOBox.prototype._writeString = function (size, str) {
  for (var c = 0; c < size; c++) {
    this._writeUint(8, str.charCodeAt(c));
  }
};
ISOBox.prototype._writeTerminatedString = function (str) {
  if (str.length === 0) {
    return;
  }
  for (var c = 0; c < str.length; c++) {
    this._writeUint(8, str.charCodeAt(c));
  }
  this._writeUint(8, 0);
};
ISOBox.prototype._writeTemplate = function (size, value) {
  var pre = Math.floor(value);
  var post = (value - pre) * Math.pow(2, size / 2);
  this._writeUint(size / 2, pre);
  this._writeUint(size / 2, post);
};
ISOBox.prototype._writeData = function (data) {
  var i;
  //data to copy
  if (data) {
    if (this._rawo) {
      //Array and Uint8Array has also to be managed
      if (data instanceof Array) {
        var offset = this._cursor.offset - this._rawo.byteOffset;
        for (var i = 0; i < data.length; i++) {
          this._rawo.setInt8(offset + i, data[i]);
        }
        this._cursor.offset += data.length;
      }
      if (data instanceof Uint8Array) {
        this._root.bytes.set(data, this._cursor.offset);
        this._cursor.offset += data.length;
      }
    } else {
      //nothing to copy only size to compute
      this.size += data.length;
    }
  }
};
ISOBox.prototype._writeUTF8String = function (string) {
  var u = ISOBoxer.Utils.utf8ToByteArray(string);
  if (this._rawo) {
    var dataView = new DataView(this._rawo.buffer, this._cursor.offset, u.length);
    for (var i = 0; i < u.length; i++) {
      dataView.setUint8(i, u[i]);
    }
  } else {
    this.size += u.length;
  }
};
ISOBox.prototype._writeField = function (type, size, value) {
  switch (type) {
    case 'uint':
      this._writeUint(size, value);
      break;
    case 'int':
      this._writeInt(size, value);
      break;
    case 'template':
      this._writeTemplate(size, value);
      break;
    case 'string':
      if (size == -1) {
        this._writeTerminatedString(value);
      } else {
        this._writeString(size, value);
      }
      break;
    case 'data':
      this._writeData(value);
      break;
    case 'utf8':
      this._writeUTF8String(value);
      break;
    default:
      break;
  }
};

// ISO/IEC 14496-12:202x - 12.2.8 Audio rendering indication box
ISOBox.prototype._boxProcessors['ardi'] = function () {
  this._procFullBox();
  this._procField('audio_rendering_indication', 'uint', 8);
};

// ISO/IEC 14496-15:2014 - avc1/2/3/4, hev1, hvc1, encv
ISOBox.prototype._boxProcessors['avc1'] = ISOBox.prototype._boxProcessors['avc2'] = ISOBox.prototype._boxProcessors['avc3'] = ISOBox.prototype._boxProcessors['avc4'] = ISOBox.prototype._boxProcessors['hvc1'] = ISOBox.prototype._boxProcessors['hev1'] = ISOBox.prototype._boxProcessors['encv'] = function () {
  // SampleEntry fields
  this._procFieldArray('reserved1', 6, 'uint', 8);
  this._procField('data_reference_index', 'uint', 16);
  // VisualSampleEntry fields
  this._procField('pre_defined1', 'uint', 16);
  this._procField('reserved2', 'uint', 16);
  this._procFieldArray('pre_defined2', 3, 'uint', 32);
  this._procField('width', 'uint', 16);
  this._procField('height', 'uint', 16);
  this._procField('horizresolution', 'template', 32);
  this._procField('vertresolution', 'template', 32);
  this._procField('reserved3', 'uint', 32);
  this._procField('frame_count', 'uint', 16);
  this._procFieldArray('compressorname', 32, 'uint', 8);
  this._procField('depth', 'uint', 16);
  this._procField('pre_defined3', 'int', 16);
  // Codec-specific fields
  this._procField('config', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.6.1.3 Composition Time To Sample Box
ISOBox.prototype._boxProcessors['ctts'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procEntries('entries', this.entry_count, function (entry) {
    this._procEntryField(entry, 'sample_count', 'uint', 32);
    this._procEntryField(entry, 'sample_offset', this.version === 1 ? 'int' : 'uint', 32);
  });
};

// ISO/IEC 14496-12:2012 - 8.7.2 Data Reference Box
ISOBox.prototype._boxProcessors['dref'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procSubBoxes('entries', this.entry_count);
};

// ISO/IEC 14496-12:202x - 8.4.6 Extended language tag
ISOBox.prototype._boxProcessors['elng'] = function () {
  this._procFullBox();
  this._procField('extended_language', 'utf8string');
};

// ISO/IEC 14496-12:2012 - 8.6.6 Edit List Box
ISOBox.prototype._boxProcessors['elst'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procEntries('entries', this.entry_count, function (entry) {
    this._procEntryField(entry, 'segment_duration', 'uint', this.version === 1 ? 64 : 32);
    this._procEntryField(entry, 'media_time', 'int', this.version === 1 ? 64 : 32);
    this._procEntryField(entry, 'media_rate_integer', 'int', 16);
    this._procEntryField(entry, 'media_rate_fraction', 'int', 16);
  });
};

// ISO/IEC 23009-1:2014 - 5.10.3.3 Event Message Box
ISOBox.prototype._boxProcessors['emsg'] = function () {
  this._procFullBox();
  if (this.version == 1) {
    this._procField('timescale', 'uint', 32);
    this._procField('presentation_time', 'uint', 64);
    this._procField('event_duration', 'uint', 32);
    this._procField('id', 'uint', 32);
    this._procField('scheme_id_uri', 'string', -1);
    this._procField('value', 'string', -1);
  } else {
    this._procField('scheme_id_uri', 'string', -1);
    this._procField('value', 'string', -1);
    this._procField('timescale', 'uint', 32);
    this._procField('presentation_time_delta', 'uint', 32);
    this._procField('event_duration', 'uint', 32);
    this._procField('id', 'uint', 32);
  }
  this._procField('message_data', 'data', -1);
};
// ISO/IEC 14496-12:2012 - 8.1.2 Free Space Box
ISOBox.prototype._boxProcessors['free'] = ISOBox.prototype._boxProcessors['skip'] = function () {
  this._procField('data', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.12.2 Original Format Box
ISOBox.prototype._boxProcessors['frma'] = function () {
  this._procField('data_format', 'uint', 32);
};
// ISO/IEC 14496-12:2012 - 4.3 File Type Box / 8.16.2 Segment Type Box
ISOBox.prototype._boxProcessors['ftyp'] = ISOBox.prototype._boxProcessors['styp'] = function () {
  this._procField('major_brand', 'string', 4);
  this._procField('minor_version', 'uint', 32);
  var nbCompatibleBrands = -1;
  if (this._parsing) {
    nbCompatibleBrands = (this._raw.byteLength - (this._cursor.offset - this._raw.byteOffset)) / 4;
  }
  this._procFieldArray('compatible_brands', nbCompatibleBrands, 'string', 4);
};

// ISO/IEC 14496-12:2012 - 8.4.3 Handler Reference Box
ISOBox.prototype._boxProcessors['hdlr'] = function () {
  this._procFullBox();
  this._procField('pre_defined', 'uint', 32);
  this._procField('handler_type', 'string', 4);
  this._procFieldArray('reserved', 3, 'uint', 32);
  this._procField('name', 'string', -1);
};

// ISO/IEC 14496-12:2012 - 9.1.4.1 Identified media data box
ISOBox.prototype._boxProcessors['imda'] = function () {
  this._procField('imda_identifier', 'uint', 32);
  // until the end of the box
  this._procField('data', 'data', -1);
};

// ISO/IEC 14496-12:202x - 8.10.4 Track kind box
ISOBox.prototype._boxProcessors['kind'] = function () {
  this._procFullBox();
  this._procField('schemeURI', 'utf8string');
  this._procField('value', 'utf8string');
};

// ISO/IEC 14496-12:202x - 8.10.5 Label box
ISOBox.prototype._boxProcessors['labl'] = function () {
  this._procFullBox();
  this.is_group_label = (this.flags & 0x1) != 0;
  this._procField('label_id', 'uint', 16);
  this._procField('language', 'utf8string');
  this._procField('label', 'utf8string');
};

// ISO/IEC 14496-12:2012 - 8.1.1 Media Data Box
ISOBox.prototype._boxProcessors['mdat'] = function () {
  this._procField('data', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.4.2 Media Header Box
ISOBox.prototype._boxProcessors['mdhd'] = function () {
  this._procFullBox();
  this._procField('creation_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('modification_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('timescale', 'uint', 32);
  this._procField('duration', 'uint', this.version == 1 ? 64 : 32);
  if (!this._parsing && typeof this.language === 'string') {
    // In case of writing and language has been set as a string, then convert it into char codes array
    this.language = this.language.charCodeAt(0) - 0x60 << 10 | this.language.charCodeAt(1) - 0x60 << 5 | this.language.charCodeAt(2) - 0x60;
  }
  this._procField('language', 'uint', 16);
  if (this._parsing) {
    this.language = String.fromCharCode((this.language >> 10 & 0x1F) + 0x60, (this.language >> 5 & 0x1F) + 0x60, (this.language & 0x1F) + 0x60);
  }
  this._procField('pre_defined', 'uint', 16);
};

// ISO/IEC 14496-12:2012 - 8.8.2 Movie Extends Header Box
ISOBox.prototype._boxProcessors['mehd'] = function () {
  this._procFullBox();
  this._procField('fragment_duration', 'uint', this.version == 1 ? 64 : 32);
};

// ISO/IEC 14496-12:202x - 8.11.1 Meta box
ISOBox.prototype._boxProcessors['meta'] = function () {
  this._procFullBox();

  /* rest of the boxes will be read by _parseContainerBox */
};

// ISO/IEC 14496-12:2012 - 8.8.5 Movie Fragment Header Box
ISOBox.prototype._boxProcessors['mfhd'] = function () {
  this._procFullBox();
  this._procField('sequence_number', 'uint', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.11 Movie Fragment Random Access Box
ISOBox.prototype._boxProcessors['mfro'] = function () {
  this._procFullBox();
  this._procField('mfra_size', 'uint', 32); // Called mfra_size to distinguish from the normal "size" attribute of a box
};

// ISO/IEC 14496-12:2012 - 8.5.2.2 mp4a box (use AudioSampleEntry definition and naming)
ISOBox.prototype._boxProcessors['mp4a'] = ISOBox.prototype._boxProcessors['enca'] = function () {
  // SampleEntry fields
  this._procFieldArray('reserved1', 6, 'uint', 8);
  this._procField('data_reference_index', 'uint', 16);
  // AudioSampleEntry fields
  this._procFieldArray('reserved2', 2, 'uint', 32);
  this._procField('channelcount', 'uint', 16);
  this._procField('samplesize', 'uint', 16);
  this._procField('pre_defined', 'uint', 16);
  this._procField('reserved3', 'uint', 16);
  this._procField('samplerate', 'template', 32);
  // ESDescriptor fields
  this._procField('esds', 'data', -1);
};

// ISO/IEC 14496-12:2012 - 8.2.2 Movie Header Box
ISOBox.prototype._boxProcessors['mvhd'] = function () {
  this._procFullBox();
  this._procField('creation_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('modification_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('timescale', 'uint', 32);
  this._procField('duration', 'uint', this.version == 1 ? 64 : 32);
  this._procField('rate', 'template', 32);
  this._procField('volume', 'template', 16);
  this._procField('reserved1', 'uint', 16);
  this._procFieldArray('reserved2', 2, 'uint', 32);
  this._procFieldArray('matrix', 9, 'template', 32);
  this._procFieldArray('pre_defined', 6, 'uint', 32);
  this._procField('next_track_ID', 'uint', 32);
};

// ISO/IEC 14496-30:2014 - WebVTT Cue Payload Box.
ISOBox.prototype._boxProcessors['payl'] = function () {
  this._procField('cue_text', 'utf8');
};

// ISO/IEC 14496-12:2012 - 8.16.5 Producer Reference Time
ISOBox.prototype._boxProcessors['prft'] = function () {
  this._procFullBox();
  this._procField('reference_track_ID', 'uint', 32);
  this._procField('ntp_timestamp_sec', 'uint', 32);
  this._procField('ntp_timestamp_frac', 'uint', 32);
  this._procField('media_time', 'uint', this.version == 1 ? 64 : 32);
};

// ISO/IEC 14496-12:202x - 8.18.4.1 Preselection group box
ISOBox.prototype._boxProcessors['prsl'] = function () {
  this._procFullBox();
  this._procField('group_id', 'uint', 32);
  this._procField('num_entities_in_group', 'uint', 32);
  this._procEntries('entities', this.num_entities_in_group, function (entry) {
    this._procEntryField(entry, 'entity_id', 'uint', 32);
  });
  if (this.flags & 0x1000) this._procField('preselection_tag', 'utf8string');
  if (this.flags & 0x2000) this._procField('selection_priority', 'uint', 8);
  if (this.flags & 0x4000) this._procField('interleaving_tag', 'utf8string');

  /* rest of the boxes will be read by _parseContainerBox */
};

//ISO/IEC 23001-7:2011 - 8.1 Protection System Specific Header Box
ISOBox.prototype._boxProcessors['pssh'] = function () {
  this._procFullBox();
  this._procFieldArray('SystemID', 16, 'uint', 8);
  this._procField('DataSize', 'uint', 32);
  this._procFieldArray('Data', this.DataSize, 'uint', 8);
};
// ISO/IEC 14496-12:2012 - 8.12.5 Scheme Type Box
ISOBox.prototype._boxProcessors['schm'] = function () {
  this._procFullBox();
  this._procField('scheme_type', 'uint', 32);
  this._procField('scheme_version', 'uint', 32);
  if (this.flags & 0x000001) {
    this._procField('scheme_uri', 'string', -1);
  }
};
// ISO/IEC 14496-12:2012 - 8.6.4.1 sdtp box 
ISOBox.prototype._boxProcessors['sdtp'] = function () {
  this._procFullBox();
  var sample_count = -1;
  if (this._parsing) {
    sample_count = this._raw.byteLength - (this._cursor.offset - this._raw.byteOffset);
  }
  this._procFieldArray('sample_dependency_table', sample_count, 'uint', 8);
};

// ISO/IEC 14496-12:2012 - 8.16.3 Segment Index Box
ISOBox.prototype._boxProcessors['sidx'] = function () {
  this._procFullBox();
  this._procField('reference_ID', 'uint', 32);
  this._procField('timescale', 'uint', 32);
  this._procField('earliest_presentation_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('first_offset', 'uint', this.version == 1 ? 64 : 32);
  this._procField('reserved', 'uint', 16);
  this._procField('reference_count', 'uint', 16);
  this._procEntries('references', this.reference_count, function (entry) {
    if (!this._parsing) {
      entry.reference = (entry.reference_type & 0x00000001) << 31;
      entry.reference |= entry.referenced_size & 0x7FFFFFFF;
      entry.sap = (entry.starts_with_SAP & 0x00000001) << 31;
      entry.sap |= (entry.SAP_type & 0x00000003) << 28;
      entry.sap |= entry.SAP_delta_time & 0x0FFFFFFF;
    }
    this._procEntryField(entry, 'reference', 'uint', 32);
    this._procEntryField(entry, 'subsegment_duration', 'uint', 32);
    this._procEntryField(entry, 'sap', 'uint', 32);
    if (this._parsing) {
      entry.reference_type = entry.reference >> 31 & 0x00000001;
      entry.referenced_size = entry.reference & 0x7FFFFFFF;
      entry.starts_with_SAP = entry.sap >> 31 & 0x00000001;
      entry.SAP_type = entry.sap >> 28 & 0x00000007;
      entry.SAP_delta_time = entry.sap & 0x0FFFFFFF;
    }
  });
};

// ISO/IEC 14496-12:2012 - 8.4.5.3 Sound Media Header Box
ISOBox.prototype._boxProcessors['smhd'] = function () {
  this._procFullBox();
  this._procField('balance', 'uint', 16);
  this._procField('reserved', 'uint', 16);
};

// ISO/IEC 14496-12:2012 - 8.16.4 Subsegment Index Box
ISOBox.prototype._boxProcessors['ssix'] = function () {
  this._procFullBox();
  this._procField('subsegment_count', 'uint', 32);
  this._procEntries('subsegments', this.subsegment_count, function (subsegment) {
    this._procEntryField(subsegment, 'ranges_count', 'uint', 32);
    this._procSubEntries(subsegment, 'ranges', subsegment.ranges_count, function (range) {
      this._procEntryField(range, 'level', 'uint', 8);
      this._procEntryField(range, 'range_size', 'uint', 24);
    });
  });
};

// ISO/IEC 14496-12:2012 - 8.5.2 Sample Description Box
ISOBox.prototype._boxProcessors['stsd'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procSubBoxes('entries', this.entry_count);
};

// ISO/IEC 14496-30:2014 - WebVTT Cue Settings Box.
ISOBox.prototype._boxProcessors['sttg'] = function () {
  this._procField('settings', 'utf8');
};

// ISO/IEC 14496-12:2012 - 8.6.1.2 Decoding Time To Sample Box
ISOBox.prototype._boxProcessors['stts'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procEntries('entries', this.entry_count, function (entry) {
    this._procEntryField(entry, 'sample_count', 'uint', 32);
    this._procEntryField(entry, 'sample_delta', 'uint', 32);
  });
};

// ISO/IEC 14496-12:2015 - 8.7.7 Sub-Sample Information Box
ISOBox.prototype._boxProcessors['subs'] = function () {
  this._procFullBox();
  this._procField('entry_count', 'uint', 32);
  this._procEntries('entries', this.entry_count, function (entry) {
    this._procEntryField(entry, 'sample_delta', 'uint', 32);
    this._procEntryField(entry, 'subsample_count', 'uint', 16);
    this._procSubEntries(entry, 'subsamples', entry.subsample_count, function (subsample) {
      this._procEntryField(subsample, 'subsample_size', 'uint', this.version === 1 ? 32 : 16);
      this._procEntryField(subsample, 'subsample_priority', 'uint', 8);
      this._procEntryField(subsample, 'discardable', 'uint', 8);
      this._procEntryField(subsample, 'codec_specific_parameters', 'uint', 32);
    });
  });
};

//ISO/IEC 23001-7:2011 - 8.2 Track Encryption Box
ISOBox.prototype._boxProcessors['tenc'] = function () {
  this._procFullBox();
  this._procField('default_IsEncrypted', 'uint', 24);
  this._procField('default_IV_size', 'uint', 8);
  this._procFieldArray('default_KID', 16, 'uint', 8);
};

// ISO/IEC 14496-12:2012 - 8.8.12 Track Fragmnent Decode Time
ISOBox.prototype._boxProcessors['tfdt'] = function () {
  this._procFullBox();
  this._procField('baseMediaDecodeTime', 'uint', this.version == 1 ? 64 : 32);
};

// ISO/IEC 14496-12:2012 - 8.8.7 Track Fragment Header Box
ISOBox.prototype._boxProcessors['tfhd'] = function () {
  this._procFullBox();
  this._procField('track_ID', 'uint', 32);
  if (this.flags & 0x01) this._procField('base_data_offset', 'uint', 64);
  if (this.flags & 0x02) this._procField('sample_description_offset', 'uint', 32);
  if (this.flags & 0x08) this._procField('default_sample_duration', 'uint', 32);
  if (this.flags & 0x10) this._procField('default_sample_size', 'uint', 32);
  if (this.flags & 0x20) this._procField('default_sample_flags', 'uint', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.10 Track Fragment Random Access Box
ISOBox.prototype._boxProcessors['tfra'] = function () {
  this._procFullBox();
  this._procField('track_ID', 'uint', 32);
  if (!this._parsing) {
    this.reserved = 0;
    this.reserved |= (this.length_size_of_traf_num & 0x00000030) << 4;
    this.reserved |= (this.length_size_of_trun_num & 0x0000000C) << 2;
    this.reserved |= this.length_size_of_sample_num & 0x00000003;
  }
  this._procField('reserved', 'uint', 32);
  if (this._parsing) {
    this.length_size_of_traf_num = (this.reserved & 0x00000030) >> 4;
    this.length_size_of_trun_num = (this.reserved & 0x0000000C) >> 2;
    this.length_size_of_sample_num = this.reserved & 0x00000003;
  }
  this._procField('number_of_entry', 'uint', 32);
  this._procEntries('entries', this.number_of_entry, function (entry) {
    this._procEntryField(entry, 'time', 'uint', this.version === 1 ? 64 : 32);
    this._procEntryField(entry, 'moof_offset', 'uint', this.version === 1 ? 64 : 32);
    this._procEntryField(entry, 'traf_number', 'uint', (this.length_size_of_traf_num + 1) * 8);
    this._procEntryField(entry, 'trun_number', 'uint', (this.length_size_of_trun_num + 1) * 8);
    this._procEntryField(entry, 'sample_number', 'uint', (this.length_size_of_sample_num + 1) * 8);
  });
};

// ISO/IEC 14496-12:2012 - 8.3.2 Track Header Box
ISOBox.prototype._boxProcessors['tkhd'] = function () {
  this._procFullBox();
  this._procField('creation_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('modification_time', 'uint', this.version == 1 ? 64 : 32);
  this._procField('track_ID', 'uint', 32);
  this._procField('reserved1', 'uint', 32);
  this._procField('duration', 'uint', this.version == 1 ? 64 : 32);
  this._procFieldArray('reserved2', 2, 'uint', 32);
  this._procField('layer', 'uint', 16);
  this._procField('alternate_group', 'uint', 16);
  this._procField('volume', 'template', 16);
  this._procField('reserved3', 'uint', 16);
  this._procFieldArray('matrix', 9, 'template', 32);
  this._procField('width', 'template', 32);
  this._procField('height', 'template', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.3 Track Extends Box
ISOBox.prototype._boxProcessors['trex'] = function () {
  this._procFullBox();
  this._procField('track_ID', 'uint', 32);
  this._procField('default_sample_description_index', 'uint', 32);
  this._procField('default_sample_duration', 'uint', 32);
  this._procField('default_sample_size', 'uint', 32);
  this._procField('default_sample_flags', 'uint', 32);
};

// ISO/IEC 14496-12:2012 - 8.8.8 Track Run Box
// Note: the 'trun' box has a direct relation to the 'tfhd' box for defaults.
// These defaults are not set explicitly here, but are left to resolve for the user.
ISOBox.prototype._boxProcessors['trun'] = function () {
  this._procFullBox();
  this._procField('sample_count', 'uint', 32);
  if (this.flags & 0x1) this._procField('data_offset', 'int', 32);
  if (this.flags & 0x4) this._procField('first_sample_flags', 'uint', 32);
  this._procEntries('samples', this.sample_count, function (sample) {
    if (this.flags & 0x100) this._procEntryField(sample, 'sample_duration', 'uint', 32);
    if (this.flags & 0x200) this._procEntryField(sample, 'sample_size', 'uint', 32);
    if (this.flags & 0x400) this._procEntryField(sample, 'sample_flags', 'uint', 32);
    if (this.flags & 0x800) this._procEntryField(sample, 'sample_composition_time_offset', this.version === 1 ? 'int' : 'uint', 32);
  });
};

// ISO/IEC 14496-12:2012 - 8.7.2 Data Reference Box
ISOBox.prototype._boxProcessors['url '] = ISOBox.prototype._boxProcessors['urn '] = function () {
  this._procFullBox();
  if (this.type === 'urn ') {
    this._procField('name', 'string', -1);
  }
  this._procField('location', 'string', -1);
};

// ISO/IEC 14496-30:2014 - WebVTT Source Label Box
ISOBox.prototype._boxProcessors['vlab'] = function () {
  this._procField('source_label', 'utf8');
};

// ISO/IEC 14496-12:2012 - 8.4.5.2 Video Media Header Box
ISOBox.prototype._boxProcessors['vmhd'] = function () {
  this._procFullBox();
  this._procField('graphicsmode', 'uint', 16);
  this._procFieldArray('opcolor', 3, 'uint', 16);
};

// ISO/IEC 14496-30:2014 - WebVTT Configuration Box
ISOBox.prototype._boxProcessors['vttC'] = function () {
  this._procField('config', 'utf8');
};

// ISO/IEC 14496-30:2014 - WebVTT Empty Sample Box
ISOBox.prototype._boxProcessors['vtte'] = function () {
  // Nothing should happen here.
};

/***/ }),

/***/ "./node_modules/events/events.js":
/*!***************************************!*\
  !*** ./node_modules/events/events.js ***!
  \***************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.number.is-nan.js */ "./node_modules/core-js/modules/es.number.is-nan.js");
__webpack_require__(/*! core-js/modules/es.object.get-own-property-names.js */ "./node_modules/core-js/modules/es.object.get-own-property-names.js");
__webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
__webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/core-js/modules/es.promise.js");
__webpack_require__(/*! core-js/modules/es.reflect.apply.js */ "./node_modules/core-js/modules/es.reflect.apply.js");
__webpack_require__(/*! core-js/modules/es.reflect.own-keys.js */ "./node_modules/core-js/modules/es.reflect.own-keys.js");
__webpack_require__(/*! core-js/modules/es.reflect.to-string-tag.js */ "./node_modules/core-js/modules/es.reflect.to-string-tag.js");
var R = (typeof Reflect === "undefined" ? "undefined" : _typeof(Reflect)) === 'object' ? Reflect : null;
var ReflectApply = R && typeof R.apply === 'function' ? R.apply : function ReflectApply(target, receiver, args) {
  return Function.prototype.apply.call(target, receiver, args);
};
var ReflectOwnKeys;
if (R && typeof R.ownKeys === 'function') {
  ReflectOwnKeys = R.ownKeys;
} else if (Object.getOwnPropertySymbols) {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target).concat(Object.getOwnPropertySymbols(target));
  };
} else {
  ReflectOwnKeys = function ReflectOwnKeys(target) {
    return Object.getOwnPropertyNames(target);
  };
}
function ProcessEmitWarning(warning) {
  if (console && console.warn) console.warn(warning);
}
var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
  return value !== value;
};
function EventEmitter() {
  EventEmitter.init.call(this);
}
module.exports = EventEmitter;
module.exports.once = once;

// Backwards-compat with node 0.10.x
EventEmitter.EventEmitter = EventEmitter;
EventEmitter.prototype._events = undefined;
EventEmitter.prototype._eventsCount = 0;
EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
var defaultMaxListeners = 10;
function checkListener(listener) {
  if (typeof listener !== 'function') {
    throw new TypeError('The "listener" argument must be of type Function. Received type ' + _typeof(listener));
  }
}
Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
  enumerable: true,
  get: function get() {
    return defaultMaxListeners;
  },
  set: function set(arg) {
    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
      throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
    }
    defaultMaxListeners = arg;
  }
});
EventEmitter.init = function () {
  if (this._events === undefined || this._events === Object.getPrototypeOf(this)._events) {
    this._events = Object.create(null);
    this._eventsCount = 0;
  }
  this._maxListeners = this._maxListeners || undefined;
};

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
  if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
  }
  this._maxListeners = n;
  return this;
};
function _getMaxListeners(that) {
  if (that._maxListeners === undefined) return EventEmitter.defaultMaxListeners;
  return that._maxListeners;
}
EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
  return _getMaxListeners(this);
};
EventEmitter.prototype.emit = function emit(type) {
  var args = [];
  for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
  var doError = type === 'error';
  var events = this._events;
  if (events !== undefined) doError = doError && events.error === undefined;else if (!doError) return false;

  // If there is no 'error' event listener then throw.
  if (doError) {
    var er;
    if (args.length > 0) er = args[0];
    if (er instanceof Error) {
      // Note: The comments on the `throw` lines are intentional, they show
      // up in Node's output if this results in an unhandled exception.
      throw er; // Unhandled 'error' event
    }
    // At least give some kind of context to the user
    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
    err.context = er;
    throw err; // Unhandled 'error' event
  }
  var handler = events[type];
  if (handler === undefined) return false;
  if (typeof handler === 'function') {
    ReflectApply(handler, this, args);
  } else {
    var len = handler.length;
    var listeners = arrayClone(handler, len);
    for (var i = 0; i < len; ++i) ReflectApply(listeners[i], this, args);
  }
  return true;
};
function _addListener(target, type, listener, prepend) {
  var m;
  var events;
  var existing;
  checkListener(listener);
  events = target._events;
  if (events === undefined) {
    events = target._events = Object.create(null);
    target._eventsCount = 0;
  } else {
    // To avoid recursion in the case that type === "newListener"! Before
    // adding it to the listeners, first emit "newListener".
    if (events.newListener !== undefined) {
      target.emit('newListener', type, listener.listener ? listener.listener : listener);

      // Re-assign `events` because a newListener handler could have caused the
      // this._events to be assigned to a new object
      events = target._events;
    }
    existing = events[type];
  }
  if (existing === undefined) {
    // Optimize the case of one listener. Don't need the extra array object.
    existing = events[type] = listener;
    ++target._eventsCount;
  } else {
    if (typeof existing === 'function') {
      // Adding the second element, need to change to array.
      existing = events[type] = prepend ? [listener, existing] : [existing, listener];
      // If we've already got an array, just append.
    } else if (prepend) {
      existing.unshift(listener);
    } else {
      existing.push(listener);
    }

    // Check for listener leak
    m = _getMaxListeners(target);
    if (m > 0 && existing.length > m && !existing.warned) {
      existing.warned = true;
      // No error code for this since it is a Warning
      // eslint-disable-next-line no-restricted-syntax
      var w = new Error('Possible EventEmitter memory leak detected. ' + existing.length + ' ' + String(type) + ' listeners ' + 'added. Use emitter.setMaxListeners() to ' + 'increase limit');
      w.name = 'MaxListenersExceededWarning';
      w.emitter = target;
      w.type = type;
      w.count = existing.length;
      ProcessEmitWarning(w);
    }
  }
  return target;
}
EventEmitter.prototype.addListener = function addListener(type, listener) {
  return _addListener(this, type, listener, false);
};
EventEmitter.prototype.on = EventEmitter.prototype.addListener;
EventEmitter.prototype.prependListener = function prependListener(type, listener) {
  return _addListener(this, type, listener, true);
};
function onceWrapper() {
  if (!this.fired) {
    this.target.removeListener(this.type, this.wrapFn);
    this.fired = true;
    if (arguments.length === 0) return this.listener.call(this.target);
    return this.listener.apply(this.target, arguments);
  }
}
function _onceWrap(target, type, listener) {
  var state = {
    fired: false,
    wrapFn: undefined,
    target: target,
    type: type,
    listener: listener
  };
  var wrapped = onceWrapper.bind(state);
  wrapped.listener = listener;
  state.wrapFn = wrapped;
  return wrapped;
}
EventEmitter.prototype.once = function once(type, listener) {
  checkListener(listener);
  this.on(type, _onceWrap(this, type, listener));
  return this;
};
EventEmitter.prototype.prependOnceListener = function prependOnceListener(type, listener) {
  checkListener(listener);
  this.prependListener(type, _onceWrap(this, type, listener));
  return this;
};

// Emits a 'removeListener' event if and only if the listener was removed.
EventEmitter.prototype.removeListener = function removeListener(type, listener) {
  var list, events, position, i, originalListener;
  checkListener(listener);
  events = this._events;
  if (events === undefined) return this;
  list = events[type];
  if (list === undefined) return this;
  if (list === listener || list.listener === listener) {
    if (--this._eventsCount === 0) this._events = Object.create(null);else {
      delete events[type];
      if (events.removeListener) this.emit('removeListener', type, list.listener || listener);
    }
  } else if (typeof list !== 'function') {
    position = -1;
    for (i = list.length - 1; i >= 0; i--) {
      if (list[i] === listener || list[i].listener === listener) {
        originalListener = list[i].listener;
        position = i;
        break;
      }
    }
    if (position < 0) return this;
    if (position === 0) list.shift();else {
      spliceOne(list, position);
    }
    if (list.length === 1) events[type] = list[0];
    if (events.removeListener !== undefined) this.emit('removeListener', type, originalListener || listener);
  }
  return this;
};
EventEmitter.prototype.off = EventEmitter.prototype.removeListener;
EventEmitter.prototype.removeAllListeners = function removeAllListeners(type) {
  var listeners, events, i;
  events = this._events;
  if (events === undefined) return this;

  // not listening for removeListener, no need to emit
  if (events.removeListener === undefined) {
    if (arguments.length === 0) {
      this._events = Object.create(null);
      this._eventsCount = 0;
    } else if (events[type] !== undefined) {
      if (--this._eventsCount === 0) this._events = Object.create(null);else delete events[type];
    }
    return this;
  }

  // emit removeListener for all listeners on all events
  if (arguments.length === 0) {
    var keys = Object.keys(events);
    var key;
    for (i = 0; i < keys.length; ++i) {
      key = keys[i];
      if (key === 'removeListener') continue;
      this.removeAllListeners(key);
    }
    this.removeAllListeners('removeListener');
    this._events = Object.create(null);
    this._eventsCount = 0;
    return this;
  }
  listeners = events[type];
  if (typeof listeners === 'function') {
    this.removeListener(type, listeners);
  } else if (listeners !== undefined) {
    // LIFO order
    for (i = listeners.length - 1; i >= 0; i--) {
      this.removeListener(type, listeners[i]);
    }
  }
  return this;
};
function _listeners(target, type, unwrap) {
  var events = target._events;
  if (events === undefined) return [];
  var evlistener = events[type];
  if (evlistener === undefined) return [];
  if (typeof evlistener === 'function') return unwrap ? [evlistener.listener || evlistener] : [evlistener];
  return unwrap ? unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
}
EventEmitter.prototype.listeners = function listeners(type) {
  return _listeners(this, type, true);
};
EventEmitter.prototype.rawListeners = function rawListeners(type) {
  return _listeners(this, type, false);
};
EventEmitter.listenerCount = function (emitter, type) {
  if (typeof emitter.listenerCount === 'function') {
    return emitter.listenerCount(type);
  } else {
    return listenerCount.call(emitter, type);
  }
};
EventEmitter.prototype.listenerCount = listenerCount;
function listenerCount(type) {
  var events = this._events;
  if (events !== undefined) {
    var evlistener = events[type];
    if (typeof evlistener === 'function') {
      return 1;
    } else if (evlistener !== undefined) {
      return evlistener.length;
    }
  }
  return 0;
}
EventEmitter.prototype.eventNames = function eventNames() {
  return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
};
function arrayClone(arr, n) {
  var copy = new Array(n);
  for (var i = 0; i < n; ++i) copy[i] = arr[i];
  return copy;
}
function spliceOne(list, index) {
  for (; index + 1 < list.length; index++) list[index] = list[index + 1];
  list.pop();
}
function unwrapListeners(arr) {
  var ret = new Array(arr.length);
  for (var i = 0; i < ret.length; ++i) {
    ret[i] = arr[i].listener || arr[i];
  }
  return ret;
}
function once(emitter, name) {
  return new Promise(function (resolve, reject) {
    function errorListener(err) {
      emitter.removeListener(name, resolver);
      reject(err);
    }
    function resolver() {
      if (typeof emitter.removeListener === 'function') {
        emitter.removeListener('error', errorListener);
      }
      resolve([].slice.call(arguments));
    }
    ;
    eventTargetAgnosticAddListener(emitter, name, resolver, {
      once: true
    });
    if (name !== 'error') {
      addErrorHandlerIfEventEmitter(emitter, errorListener, {
        once: true
      });
    }
  });
}
function addErrorHandlerIfEventEmitter(emitter, handler, flags) {
  if (typeof emitter.on === 'function') {
    eventTargetAgnosticAddListener(emitter, 'error', handler, flags);
  }
}
function eventTargetAgnosticAddListener(emitter, name, listener, flags) {
  if (typeof emitter.on === 'function') {
    if (flags.once) {
      emitter.once(name, listener);
    } else {
      emitter.on(name, listener);
    }
  } else if (typeof emitter.addEventListener === 'function') {
    // EventTarget does not have `error` event semantics like Node
    // EventEmitters, we do not listen for `error` events here.
    emitter.addEventListener(name, function wrapListener(arg) {
      // IE does not have builtin `{ once: true }` support so we
      // have to do it manually.
      if (flags.once) {
        emitter.removeEventListener(name, wrapListener);
      }
      listener(arg);
    });
  } else {
    throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + _typeof(emitter));
  }
}

/***/ }),

/***/ "./node_modules/fast-deep-equal/index.js":
/*!***********************************************!*\
  !*** ./node_modules/fast-deep-equal/index.js ***!
  \***********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


// do not edit .js files directly - edit src/index.jst
var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.constructor.js */ "./node_modules/core-js/modules/es.regexp.constructor.js");
__webpack_require__(/*! core-js/modules/es.regexp.dot-all.js */ "./node_modules/core-js/modules/es.regexp.dot-all.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.regexp.flags.js */ "./node_modules/core-js/modules/es.regexp.flags.js");
__webpack_require__(/*! core-js/modules/es.regexp.sticky.js */ "./node_modules/core-js/modules/es.regexp.sticky.js");
__webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
module.exports = function equal(a, b) {
  if (a === b) return true;
  if (a && b && _typeof(a) == 'object' && _typeof(b) == 'object') {
    if (a.constructor !== b.constructor) return false;
    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;) if (!equal(a[i], b[i])) return false;
      return true;
    }
    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;
    for (i = length; i-- !== 0;) if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;
    for (i = length; i-- !== 0;) {
      var key = keys[i];
      if (!equal(a[key], b[key])) return false;
    }
    return true;
  }

  // true if both NaN, false otherwise
  return a !== a && b !== b;
};

/***/ }),

/***/ "./node_modules/ieee754/index.js":
/*!***************************************!*\
  !*** ./node_modules/ieee754/index.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, exports) {

/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = -7;
  var i = isLE ? nBytes - 1 : 0;
  var d = isLE ? -1 : 1;
  var s = buffer[offset + i];
  i += d;
  e = s & (1 << -nBits) - 1;
  s >>= -nBits;
  nBits += eLen;
  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}
  m = e & (1 << -nBits) - 1;
  e >>= -nBits;
  nBits += mLen;
  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}
  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m ? NaN : (s ? -1 : 1) * Infinity;
  } else {
    m = m + Math.pow(2, mLen);
    e = e - eBias;
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen);
};
exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt = mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0;
  var i = isLE ? 0 : nBytes - 1;
  var d = isLE ? 1 : -1;
  var s = value < 0 || value === 0 && 1 / value < 0 ? 1 : 0;
  value = Math.abs(value);
  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0;
    e = eMax;
  } else {
    e = Math.floor(Math.log(value) / Math.LN2);
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }
    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * Math.pow(2, 1 - eBias);
    }
    if (value * c >= 2) {
      e++;
      c /= 2;
    }
    if (e + eBias >= eMax) {
      m = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m = (value * c - 1) * Math.pow(2, mLen);
      e = e + eBias;
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e = 0;
    }
  }
  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}
  e = e << mLen | m;
  eLen += mLen;
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}
  buffer[offset + i - d] |= s * 128;
};

/***/ }),

/***/ "./node_modules/imsc/node_modules/sax/lib/sax.js":
/*!*******************************************************!*\
  !*** ./node_modules/imsc/node_modules/sax/lib/sax.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
__webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.json.stringify.js */ "./node_modules/core-js/modules/es.json.stringify.js");
__webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
__webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
__webpack_require__(/*! core-js/modules/es.string.from-code-point.js */ "./node_modules/core-js/modules/es.string.from-code-point.js");
__webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
__webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
__webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
__webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
;
(function (sax) {
  // wrapper for non-node envs
  sax.parser = function (strict, opt) {
    return new SAXParser(strict, opt);
  };
  sax.SAXParser = SAXParser;
  sax.SAXStream = SAXStream;
  sax.createStream = createStream;

  // When we pass the MAX_BUFFER_LENGTH position, start checking for buffer overruns.
  // When we check, schedule the next check for MAX_BUFFER_LENGTH - (max(buffer lengths)),
  // since that's the earliest that a buffer overrun could occur.  This way, checks are
  // as rare as required, but as often as necessary to ensure never crossing this bound.
  // Furthermore, buffers are only tested at most once per write(), so passing a very
  // large string into write() might have undesirable effects, but this is manageable by
  // the caller, so it is assumed to be safe.  Thus, a call to write() may, in the extreme
  // edge case, result in creating at most one complete copy of the string passed in.
  // Set to Infinity to have unlimited buffers.
  sax.MAX_BUFFER_LENGTH = 64 * 1024;
  var buffers = ['comment', 'sgmlDecl', 'textNode', 'tagName', 'doctype', 'procInstName', 'procInstBody', 'entity', 'attribName', 'attribValue', 'cdata', 'script'];
  sax.EVENTS = ['text', 'processinginstruction', 'sgmldeclaration', 'doctype', 'comment', 'opentagstart', 'attribute', 'opentag', 'closetag', 'opencdata', 'cdata', 'closecdata', 'error', 'end', 'ready', 'script', 'opennamespace', 'closenamespace'];
  function SAXParser(strict, opt) {
    if (!(this instanceof SAXParser)) {
      return new SAXParser(strict, opt);
    }
    var parser = this;
    clearBuffers(parser);
    parser.q = parser.c = '';
    parser.bufferCheckPosition = sax.MAX_BUFFER_LENGTH;
    parser.opt = opt || {};
    parser.opt.lowercase = parser.opt.lowercase || parser.opt.lowercasetags;
    parser.looseCase = parser.opt.lowercase ? 'toLowerCase' : 'toUpperCase';
    parser.tags = [];
    parser.closed = parser.closedRoot = parser.sawRoot = false;
    parser.tag = parser.error = null;
    parser.strict = !!strict;
    parser.noscript = !!(strict || parser.opt.noscript);
    parser.state = S.BEGIN;
    parser.strictEntities = parser.opt.strictEntities;
    parser.ENTITIES = parser.strictEntities ? Object.create(sax.XML_ENTITIES) : Object.create(sax.ENTITIES);
    parser.attribList = [];

    // namespaces form a prototype chain.
    // it always points at the current tag,
    // which protos to its parent tag.
    if (parser.opt.xmlns) {
      parser.ns = Object.create(rootNS);
    }

    // mostly just for error reporting
    parser.trackPosition = parser.opt.position !== false;
    if (parser.trackPosition) {
      parser.position = parser.line = parser.column = 0;
    }
    emit(parser, 'onready');
  }
  if (!Object.create) {
    Object.create = function (o) {
      function F() {}
      F.prototype = o;
      var newf = new F();
      return newf;
    };
  }
  if (!Object.keys) {
    Object.keys = function (o) {
      var a = [];
      for (var i in o) if (o.hasOwnProperty(i)) a.push(i);
      return a;
    };
  }
  function checkBufferLength(parser) {
    var maxAllowed = Math.max(sax.MAX_BUFFER_LENGTH, 10);
    var maxActual = 0;
    for (var i = 0, l = buffers.length; i < l; i++) {
      var len = parser[buffers[i]].length;
      if (len > maxAllowed) {
        // Text/cdata nodes can get big, and since they're buffered,
        // we can get here under normal conditions.
        // Avoid issues by emitting the text node now,
        // so at least it won't get any bigger.
        switch (buffers[i]) {
          case 'textNode':
            closeText(parser);
            break;
          case 'cdata':
            emitNode(parser, 'oncdata', parser.cdata);
            parser.cdata = '';
            break;
          case 'script':
            emitNode(parser, 'onscript', parser.script);
            parser.script = '';
            break;
          default:
            error(parser, 'Max buffer length exceeded: ' + buffers[i]);
        }
      }
      maxActual = Math.max(maxActual, len);
    }
    // schedule the next check for the earliest possible buffer overrun.
    var m = sax.MAX_BUFFER_LENGTH - maxActual;
    parser.bufferCheckPosition = m + parser.position;
  }
  function clearBuffers(parser) {
    for (var i = 0, l = buffers.length; i < l; i++) {
      parser[buffers[i]] = '';
    }
  }
  function flushBuffers(parser) {
    closeText(parser);
    if (parser.cdata !== '') {
      emitNode(parser, 'oncdata', parser.cdata);
      parser.cdata = '';
    }
    if (parser.script !== '') {
      emitNode(parser, 'onscript', parser.script);
      parser.script = '';
    }
  }
  SAXParser.prototype = {
    end: function end() {
      _end(this);
    },
    write: write,
    resume: function resume() {
      this.error = null;
      return this;
    },
    close: function close() {
      return this.write(null);
    },
    flush: function flush() {
      flushBuffers(this);
    }
  };
  var Stream;
  try {
    Stream = (__webpack_require__(/*! stream */ "./node_modules/stream-browserify/index.js").Stream);
  } catch (ex) {
    Stream = function Stream() {};
  }
  var streamWraps = sax.EVENTS.filter(function (ev) {
    return ev !== 'error' && ev !== 'end';
  });
  function createStream(strict, opt) {
    return new SAXStream(strict, opt);
  }
  function SAXStream(strict, opt) {
    if (!(this instanceof SAXStream)) {
      return new SAXStream(strict, opt);
    }
    Stream.apply(this);
    this._parser = new SAXParser(strict, opt);
    this.writable = true;
    this.readable = true;
    var me = this;
    this._parser.onend = function () {
      me.emit('end');
    };
    this._parser.onerror = function (er) {
      me.emit('error', er);

      // if didn't throw, then means error was handled.
      // go ahead and clear error, so we can write again.
      me._parser.error = null;
    };
    this._decoder = null;
    streamWraps.forEach(function (ev) {
      Object.defineProperty(me, 'on' + ev, {
        get: function get() {
          return me._parser['on' + ev];
        },
        set: function set(h) {
          if (!h) {
            me.removeAllListeners(ev);
            me._parser['on' + ev] = h;
            return h;
          }
          me.on(ev, h);
        },
        enumerable: true,
        configurable: false
      });
    });
  }
  SAXStream.prototype = Object.create(Stream.prototype, {
    constructor: {
      value: SAXStream
    }
  });
  SAXStream.prototype.write = function (data) {
    if (typeof Buffer === 'function' && typeof Buffer.isBuffer === 'function' && Buffer.isBuffer(data)) {
      if (!this._decoder) {
        var SD = (__webpack_require__(/*! string_decoder */ "./node_modules/string_decoder/lib/string_decoder.js").StringDecoder);
        this._decoder = new SD('utf8');
      }
      data = this._decoder.write(data);
    }
    this._parser.write(data.toString());
    this.emit('data', data);
    return true;
  };
  SAXStream.prototype.end = function (chunk) {
    if (chunk && chunk.length) {
      this.write(chunk);
    }
    this._parser.end();
    return true;
  };
  SAXStream.prototype.on = function (ev, handler) {
    var me = this;
    if (!me._parser['on' + ev] && streamWraps.indexOf(ev) !== -1) {
      me._parser['on' + ev] = function () {
        var args = arguments.length === 1 ? [arguments[0]] : Array.apply(null, arguments);
        args.splice(0, 0, ev);
        me.emit.apply(me, args);
      };
    }
    return Stream.prototype.on.call(me, ev, handler);
  };

  // character classes and tokens
  var whitespace = '\r\n\t ';

  // this really needs to be replaced with character classes.
  // XML allows all manner of ridiculous numbers and digits.
  var number = '0124356789';
  var letter = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';

  // (Letter | "_" | ":")
  var quote = '\'"';
  var attribEnd = whitespace + '>';
  var CDATA = '[CDATA[';
  var DOCTYPE = 'DOCTYPE';
  var XML_NAMESPACE = 'http://www.w3.org/XML/1998/namespace';
  var XMLNS_NAMESPACE = 'http://www.w3.org/2000/xmlns/';
  var rootNS = {
    xml: XML_NAMESPACE,
    xmlns: XMLNS_NAMESPACE
  };

  // turn all the string character sets into character class objects.
  whitespace = charClass(whitespace);
  number = charClass(number);
  letter = charClass(letter);

  // http://www.w3.org/TR/REC-xml/#NT-NameStartChar
  // This implementation works on strings, a single character at a time
  // as such, it cannot ever support astral-plane characters (10000-EFFFF)
  // without a significant breaking change to either this  parser, or the
  // JavaScript language.  Implementation of an emoji-capable xml parser
  // is left as an exercise for the reader.
  var nameStart = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;
  var nameBody = /[:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040\.\d-]/;
  var entityStart = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD]/;
  var entityBody = /[#:_A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\u00B7\u0300-\u036F\u203F-\u2040\.\d-]/;
  quote = charClass(quote);
  attribEnd = charClass(attribEnd);
  function charClass(str) {
    return str.split('').reduce(function (s, c) {
      s[c] = true;
      return s;
    }, {});
  }
  function isRegExp(c) {
    return Object.prototype.toString.call(c) === '[object RegExp]';
  }
  function is(charclass, c) {
    return isRegExp(charclass) ? !!c.match(charclass) : charclass[c];
  }
  function not(charclass, c) {
    return !is(charclass, c);
  }
  var S = 0;
  sax.STATE = {
    BEGIN: S++,
    // leading byte order mark or whitespace
    BEGIN_WHITESPACE: S++,
    // leading whitespace
    TEXT: S++,
    // general stuff
    TEXT_ENTITY: S++,
    // &amp and such.
    OPEN_WAKA: S++,
    // <
    SGML_DECL: S++,
    // <!BLARG
    SGML_DECL_QUOTED: S++,
    // <!BLARG foo "bar
    DOCTYPE: S++,
    // <!DOCTYPE
    DOCTYPE_QUOTED: S++,
    // <!DOCTYPE "//blah
    DOCTYPE_DTD: S++,
    // <!DOCTYPE "//blah" [ ...
    DOCTYPE_DTD_QUOTED: S++,
    // <!DOCTYPE "//blah" [ "foo
    COMMENT_STARTING: S++,
    // <!-
    COMMENT: S++,
    // <!--
    COMMENT_ENDING: S++,
    // <!-- blah -
    COMMENT_ENDED: S++,
    // <!-- blah --
    CDATA: S++,
    // <![CDATA[ something
    CDATA_ENDING: S++,
    // ]
    CDATA_ENDING_2: S++,
    // ]]
    PROC_INST: S++,
    // <?hi
    PROC_INST_BODY: S++,
    // <?hi there
    PROC_INST_ENDING: S++,
    // <?hi "there" ?
    OPEN_TAG: S++,
    // <strong
    OPEN_TAG_SLASH: S++,
    // <strong /
    ATTRIB: S++,
    // <a
    ATTRIB_NAME: S++,
    // <a foo
    ATTRIB_NAME_SAW_WHITE: S++,
    // <a foo _
    ATTRIB_VALUE: S++,
    // <a foo=
    ATTRIB_VALUE_QUOTED: S++,
    // <a foo="bar
    ATTRIB_VALUE_CLOSED: S++,
    // <a foo="bar"
    ATTRIB_VALUE_UNQUOTED: S++,
    // <a foo=bar
    ATTRIB_VALUE_ENTITY_Q: S++,
    // <foo bar="&quot;"
    ATTRIB_VALUE_ENTITY_U: S++,
    // <foo bar=&quot
    CLOSE_TAG: S++,
    // </a
    CLOSE_TAG_SAW_WHITE: S++,
    // </a   >
    SCRIPT: S++,
    // <script> ...
    SCRIPT_ENDING: S++ // <script> ... <
  };
  sax.XML_ENTITIES = {
    'amp': '&',
    'gt': '>',
    'lt': '<',
    'quot': '"',
    'apos': "'"
  };
  sax.ENTITIES = {
    'amp': '&',
    'gt': '>',
    'lt': '<',
    'quot': '"',
    'apos': "'",
    'AElig': 198,
    'Aacute': 193,
    'Acirc': 194,
    'Agrave': 192,
    'Aring': 197,
    'Atilde': 195,
    'Auml': 196,
    'Ccedil': 199,
    'ETH': 208,
    'Eacute': 201,
    'Ecirc': 202,
    'Egrave': 200,
    'Euml': 203,
    'Iacute': 205,
    'Icirc': 206,
    'Igrave': 204,
    'Iuml': 207,
    'Ntilde': 209,
    'Oacute': 211,
    'Ocirc': 212,
    'Ograve': 210,
    'Oslash': 216,
    'Otilde': 213,
    'Ouml': 214,
    'THORN': 222,
    'Uacute': 218,
    'Ucirc': 219,
    'Ugrave': 217,
    'Uuml': 220,
    'Yacute': 221,
    'aacute': 225,
    'acirc': 226,
    'aelig': 230,
    'agrave': 224,
    'aring': 229,
    'atilde': 227,
    'auml': 228,
    'ccedil': 231,
    'eacute': 233,
    'ecirc': 234,
    'egrave': 232,
    'eth': 240,
    'euml': 235,
    'iacute': 237,
    'icirc': 238,
    'igrave': 236,
    'iuml': 239,
    'ntilde': 241,
    'oacute': 243,
    'ocirc': 244,
    'ograve': 242,
    'oslash': 248,
    'otilde': 245,
    'ouml': 246,
    'szlig': 223,
    'thorn': 254,
    'uacute': 250,
    'ucirc': 251,
    'ugrave': 249,
    'uuml': 252,
    'yacute': 253,
    'yuml': 255,
    'copy': 169,
    'reg': 174,
    'nbsp': 160,
    'iexcl': 161,
    'cent': 162,
    'pound': 163,
    'curren': 164,
    'yen': 165,
    'brvbar': 166,
    'sect': 167,
    'uml': 168,
    'ordf': 170,
    'laquo': 171,
    'not': 172,
    'shy': 173,
    'macr': 175,
    'deg': 176,
    'plusmn': 177,
    'sup1': 185,
    'sup2': 178,
    'sup3': 179,
    'acute': 180,
    'micro': 181,
    'para': 182,
    'middot': 183,
    'cedil': 184,
    'ordm': 186,
    'raquo': 187,
    'frac14': 188,
    'frac12': 189,
    'frac34': 190,
    'iquest': 191,
    'times': 215,
    'divide': 247,
    'OElig': 338,
    'oelig': 339,
    'Scaron': 352,
    'scaron': 353,
    'Yuml': 376,
    'fnof': 402,
    'circ': 710,
    'tilde': 732,
    'Alpha': 913,
    'Beta': 914,
    'Gamma': 915,
    'Delta': 916,
    'Epsilon': 917,
    'Zeta': 918,
    'Eta': 919,
    'Theta': 920,
    'Iota': 921,
    'Kappa': 922,
    'Lambda': 923,
    'Mu': 924,
    'Nu': 925,
    'Xi': 926,
    'Omicron': 927,
    'Pi': 928,
    'Rho': 929,
    'Sigma': 931,
    'Tau': 932,
    'Upsilon': 933,
    'Phi': 934,
    'Chi': 935,
    'Psi': 936,
    'Omega': 937,
    'alpha': 945,
    'beta': 946,
    'gamma': 947,
    'delta': 948,
    'epsilon': 949,
    'zeta': 950,
    'eta': 951,
    'theta': 952,
    'iota': 953,
    'kappa': 954,
    'lambda': 955,
    'mu': 956,
    'nu': 957,
    'xi': 958,
    'omicron': 959,
    'pi': 960,
    'rho': 961,
    'sigmaf': 962,
    'sigma': 963,
    'tau': 964,
    'upsilon': 965,
    'phi': 966,
    'chi': 967,
    'psi': 968,
    'omega': 969,
    'thetasym': 977,
    'upsih': 978,
    'piv': 982,
    'ensp': 8194,
    'emsp': 8195,
    'thinsp': 8201,
    'zwnj': 8204,
    'zwj': 8205,
    'lrm': 8206,
    'rlm': 8207,
    'ndash': 8211,
    'mdash': 8212,
    'lsquo': 8216,
    'rsquo': 8217,
    'sbquo': 8218,
    'ldquo': 8220,
    'rdquo': 8221,
    'bdquo': 8222,
    'dagger': 8224,
    'Dagger': 8225,
    'bull': 8226,
    'hellip': 8230,
    'permil': 8240,
    'prime': 8242,
    'Prime': 8243,
    'lsaquo': 8249,
    'rsaquo': 8250,
    'oline': 8254,
    'frasl': 8260,
    'euro': 8364,
    'image': 8465,
    'weierp': 8472,
    'real': 8476,
    'trade': 8482,
    'alefsym': 8501,
    'larr': 8592,
    'uarr': 8593,
    'rarr': 8594,
    'darr': 8595,
    'harr': 8596,
    'crarr': 8629,
    'lArr': 8656,
    'uArr': 8657,
    'rArr': 8658,
    'dArr': 8659,
    'hArr': 8660,
    'forall': 8704,
    'part': 8706,
    'exist': 8707,
    'empty': 8709,
    'nabla': 8711,
    'isin': 8712,
    'notin': 8713,
    'ni': 8715,
    'prod': 8719,
    'sum': 8721,
    'minus': 8722,
    'lowast': 8727,
    'radic': 8730,
    'prop': 8733,
    'infin': 8734,
    'ang': 8736,
    'and': 8743,
    'or': 8744,
    'cap': 8745,
    'cup': 8746,
    'int': 8747,
    'there4': 8756,
    'sim': 8764,
    'cong': 8773,
    'asymp': 8776,
    'ne': 8800,
    'equiv': 8801,
    'le': 8804,
    'ge': 8805,
    'sub': 8834,
    'sup': 8835,
    'nsub': 8836,
    'sube': 8838,
    'supe': 8839,
    'oplus': 8853,
    'otimes': 8855,
    'perp': 8869,
    'sdot': 8901,
    'lceil': 8968,
    'rceil': 8969,
    'lfloor': 8970,
    'rfloor': 8971,
    'lang': 9001,
    'rang': 9002,
    'loz': 9674,
    'spades': 9824,
    'clubs': 9827,
    'hearts': 9829,
    'diams': 9830
  };
  Object.keys(sax.ENTITIES).forEach(function (key) {
    var e = sax.ENTITIES[key];
    var s = typeof e === 'number' ? String.fromCharCode(e) : e;
    sax.ENTITIES[key] = s;
  });
  for (var s in sax.STATE) {
    sax.STATE[sax.STATE[s]] = s;
  }

  // shorthand
  S = sax.STATE;
  function emit(parser, event, data) {
    parser[event] && parser[event](data);
  }
  function emitNode(parser, nodeType, data) {
    if (parser.textNode) closeText(parser);
    emit(parser, nodeType, data);
  }
  function closeText(parser) {
    parser.textNode = textopts(parser.opt, parser.textNode);
    if (parser.textNode) emit(parser, 'ontext', parser.textNode);
    parser.textNode = '';
  }
  function textopts(opt, text) {
    if (opt.trim) text = text.trim();
    if (opt.normalize) text = text.replace(/\s+/g, ' ');
    return text;
  }
  function error(parser, er) {
    closeText(parser);
    if (parser.trackPosition) {
      er += '\nLine: ' + parser.line + '\nColumn: ' + parser.column + '\nChar: ' + parser.c;
    }
    er = new Error(er);
    parser.error = er;
    emit(parser, 'onerror', er);
    return parser;
  }
  function _end(parser) {
    if (parser.sawRoot && !parser.closedRoot) strictFail(parser, 'Unclosed root tag');
    if (parser.state !== S.BEGIN && parser.state !== S.BEGIN_WHITESPACE && parser.state !== S.TEXT) {
      error(parser, 'Unexpected end');
    }
    closeText(parser);
    parser.c = '';
    parser.closed = true;
    emit(parser, 'onend');
    SAXParser.call(parser, parser.strict, parser.opt);
    return parser;
  }
  function strictFail(parser, message) {
    if (_typeof(parser) !== 'object' || !(parser instanceof SAXParser)) {
      throw new Error('bad call to strictFail');
    }
    if (parser.strict) {
      error(parser, message);
    }
  }
  function newTag(parser) {
    if (!parser.strict) parser.tagName = parser.tagName[parser.looseCase]();
    var parent = parser.tags[parser.tags.length - 1] || parser;
    var tag = parser.tag = {
      name: parser.tagName,
      attributes: {}
    };

    // will be overridden if tag contails an xmlns="foo" or xmlns:foo="bar"
    if (parser.opt.xmlns) {
      tag.ns = parent.ns;
    }
    parser.attribList.length = 0;
    emitNode(parser, 'onopentagstart', tag);
  }
  function qname(name, attribute) {
    var i = name.indexOf(':');
    var qualName = i < 0 ? ['', name] : name.split(':');
    var prefix = qualName[0];
    var local = qualName[1];

    // <x "xmlns"="http://foo">
    if (attribute && name === 'xmlns') {
      prefix = 'xmlns';
      local = '';
    }
    return {
      prefix: prefix,
      local: local
    };
  }
  function attrib(parser) {
    if (!parser.strict) {
      parser.attribName = parser.attribName[parser.looseCase]();
    }
    if (parser.attribList.indexOf(parser.attribName) !== -1 || parser.tag.attributes.hasOwnProperty(parser.attribName)) {
      parser.attribName = parser.attribValue = '';
      return;
    }
    if (parser.opt.xmlns) {
      var qn = qname(parser.attribName, true);
      var prefix = qn.prefix;
      var local = qn.local;
      if (prefix === 'xmlns') {
        // namespace binding attribute. push the binding into scope
        if (local === 'xml' && parser.attribValue !== XML_NAMESPACE) {
          strictFail(parser, 'xml: prefix must be bound to ' + XML_NAMESPACE + '\n' + 'Actual: ' + parser.attribValue);
        } else if (local === 'xmlns' && parser.attribValue !== XMLNS_NAMESPACE) {
          strictFail(parser, 'xmlns: prefix must be bound to ' + XMLNS_NAMESPACE + '\n' + 'Actual: ' + parser.attribValue);
        } else {
          var tag = parser.tag;
          var parent = parser.tags[parser.tags.length - 1] || parser;
          if (tag.ns === parent.ns) {
            tag.ns = Object.create(parent.ns);
          }
          tag.ns[local] = parser.attribValue;
        }
      }

      // defer onattribute events until all attributes have been seen
      // so any new bindings can take effect. preserve attribute order
      // so deferred events can be emitted in document order
      parser.attribList.push([parser.attribName, parser.attribValue]);
    } else {
      // in non-xmlns mode, we can emit the event right away
      parser.tag.attributes[parser.attribName] = parser.attribValue;
      emitNode(parser, 'onattribute', {
        name: parser.attribName,
        value: parser.attribValue
      });
    }
    parser.attribName = parser.attribValue = '';
  }
  function openTag(parser, selfClosing) {
    if (parser.opt.xmlns) {
      // emit namespace binding events
      var tag = parser.tag;

      // add namespace info to tag
      var qn = qname(parser.tagName);
      tag.prefix = qn.prefix;
      tag.local = qn.local;
      tag.uri = tag.ns[qn.prefix] || '';
      if (tag.prefix && !tag.uri) {
        strictFail(parser, 'Unbound namespace prefix: ' + JSON.stringify(parser.tagName));
        tag.uri = qn.prefix;
      }
      var parent = parser.tags[parser.tags.length - 1] || parser;
      if (tag.ns && parent.ns !== tag.ns) {
        Object.keys(tag.ns).forEach(function (p) {
          emitNode(parser, 'onopennamespace', {
            prefix: p,
            uri: tag.ns[p]
          });
        });
      }

      // handle deferred onattribute events
      // Note: do not apply default ns to attributes:
      //   http://www.w3.org/TR/REC-xml-names/#defaulting
      for (var i = 0, l = parser.attribList.length; i < l; i++) {
        var nv = parser.attribList[i];
        var name = nv[0];
        var value = nv[1];
        var qualName = qname(name, true);
        var prefix = qualName.prefix;
        var local = qualName.local;
        var uri = prefix === '' ? '' : tag.ns[prefix] || '';
        var a = {
          name: name,
          value: value,
          prefix: prefix,
          local: local,
          uri: uri
        };

        // if there's any attributes with an undefined namespace,
        // then fail on them now.
        if (prefix && prefix !== 'xmlns' && !uri) {
          strictFail(parser, 'Unbound namespace prefix: ' + JSON.stringify(prefix));
          a.uri = prefix;
        }
        parser.tag.attributes[name] = a;
        emitNode(parser, 'onattribute', a);
      }
      parser.attribList.length = 0;
    }
    parser.tag.isSelfClosing = !!selfClosing;

    // process the tag
    parser.sawRoot = true;
    parser.tags.push(parser.tag);
    emitNode(parser, 'onopentag', parser.tag);
    if (!selfClosing) {
      // special case for <script> in non-strict mode.
      if (!parser.noscript && parser.tagName.toLowerCase() === 'script') {
        parser.state = S.SCRIPT;
      } else {
        parser.state = S.TEXT;
      }
      parser.tag = null;
      parser.tagName = '';
    }
    parser.attribName = parser.attribValue = '';
    parser.attribList.length = 0;
  }
  function closeTag(parser) {
    if (!parser.tagName) {
      strictFail(parser, 'Weird empty close tag.');
      parser.textNode += '</>';
      parser.state = S.TEXT;
      return;
    }
    if (parser.script) {
      if (parser.tagName !== 'script') {
        parser.script += '</' + parser.tagName + '>';
        parser.tagName = '';
        parser.state = S.SCRIPT;
        return;
      }
      emitNode(parser, 'onscript', parser.script);
      parser.script = '';
    }

    // first make sure that the closing tag actually exists.
    // <a><b></c></b></a> will close everything, otherwise.
    var t = parser.tags.length;
    var tagName = parser.tagName;
    if (!parser.strict) {
      tagName = tagName[parser.looseCase]();
    }
    var closeTo = tagName;
    while (t--) {
      var close = parser.tags[t];
      if (close.name !== closeTo) {
        // fail the first time in strict mode
        strictFail(parser, 'Unexpected close tag');
      } else {
        break;
      }
    }

    // didn't find it.  we already failed for strict, so just abort.
    if (t < 0) {
      strictFail(parser, 'Unmatched closing tag: ' + parser.tagName);
      parser.textNode += '</' + parser.tagName + '>';
      parser.state = S.TEXT;
      return;
    }
    parser.tagName = tagName;
    var s = parser.tags.length;
    while (s-- > t) {
      var tag = parser.tag = parser.tags.pop();
      parser.tagName = parser.tag.name;
      emitNode(parser, 'onclosetag', parser.tagName);
      var x = {};
      for (var i in tag.ns) {
        x[i] = tag.ns[i];
      }
      var parent = parser.tags[parser.tags.length - 1] || parser;
      if (parser.opt.xmlns && tag.ns !== parent.ns) {
        // remove namespace bindings introduced by tag
        Object.keys(tag.ns).forEach(function (p) {
          var n = tag.ns[p];
          emitNode(parser, 'onclosenamespace', {
            prefix: p,
            uri: n
          });
        });
      }
    }
    if (t === 0) parser.closedRoot = true;
    parser.tagName = parser.attribValue = parser.attribName = '';
    parser.attribList.length = 0;
    parser.state = S.TEXT;
  }
  function parseEntity(parser) {
    var entity = parser.entity;
    var entityLC = entity.toLowerCase();
    var num;
    var numStr = '';
    if (parser.ENTITIES[entity]) {
      return parser.ENTITIES[entity];
    }
    if (parser.ENTITIES[entityLC]) {
      return parser.ENTITIES[entityLC];
    }
    entity = entityLC;
    if (entity.charAt(0) === '#') {
      if (entity.charAt(1) === 'x') {
        entity = entity.slice(2);
        num = parseInt(entity, 16);
        numStr = num.toString(16);
      } else {
        entity = entity.slice(1);
        num = parseInt(entity, 10);
        numStr = num.toString(10);
      }
    }
    entity = entity.replace(/^0+/, '');
    if (numStr.toLowerCase() !== entity) {
      strictFail(parser, 'Invalid character entity');
      return '&' + parser.entity + ';';
    }
    return String.fromCodePoint(num);
  }
  function beginWhiteSpace(parser, c) {
    if (c === '<') {
      parser.state = S.OPEN_WAKA;
      parser.startTagPosition = parser.position;
    } else if (not(whitespace, c)) {
      // have to process this as a text node.
      // weird, but happens.
      strictFail(parser, 'Non-whitespace before first tag.');
      parser.textNode = c;
      parser.state = S.TEXT;
    }
  }
  function charAt(chunk, i) {
    var result = '';
    if (i < chunk.length) {
      result = chunk.charAt(i);
    }
    return result;
  }
  function write(chunk) {
    var parser = this;
    if (this.error) {
      throw this.error;
    }
    if (parser.closed) {
      return error(parser, 'Cannot write after close. Assign an onready handler.');
    }
    if (chunk === null) {
      return _end(parser);
    }
    if (_typeof(chunk) === 'object') {
      chunk = chunk.toString();
    }
    var i = 0;
    var c = '';
    while (true) {
      c = charAt(chunk, i++);
      parser.c = c;
      if (!c) {
        break;
      }
      if (parser.trackPosition) {
        parser.position++;
        if (c === '\n') {
          parser.line++;
          parser.column = 0;
        } else {
          parser.column++;
        }
      }
      switch (parser.state) {
        case S.BEGIN:
          parser.state = S.BEGIN_WHITESPACE;
          if (c === "\uFEFF") {
            continue;
          }
          beginWhiteSpace(parser, c);
          continue;
        case S.BEGIN_WHITESPACE:
          beginWhiteSpace(parser, c);
          continue;
        case S.TEXT:
          if (parser.sawRoot && !parser.closedRoot) {
            var starti = i - 1;
            while (c && c !== '<' && c !== '&') {
              c = charAt(chunk, i++);
              if (c && parser.trackPosition) {
                parser.position++;
                if (c === '\n') {
                  parser.line++;
                  parser.column = 0;
                } else {
                  parser.column++;
                }
              }
            }
            parser.textNode += chunk.substring(starti, i - 1);
          }
          if (c === '<' && !(parser.sawRoot && parser.closedRoot && !parser.strict)) {
            parser.state = S.OPEN_WAKA;
            parser.startTagPosition = parser.position;
          } else {
            if (not(whitespace, c) && (!parser.sawRoot || parser.closedRoot)) {
              strictFail(parser, 'Text data outside of root node.');
            }
            if (c === '&') {
              parser.state = S.TEXT_ENTITY;
            } else {
              parser.textNode += c;
            }
          }
          continue;
        case S.SCRIPT:
          // only non-strict
          if (c === '<') {
            parser.state = S.SCRIPT_ENDING;
          } else {
            parser.script += c;
          }
          continue;
        case S.SCRIPT_ENDING:
          if (c === '/') {
            parser.state = S.CLOSE_TAG;
          } else {
            parser.script += '<' + c;
            parser.state = S.SCRIPT;
          }
          continue;
        case S.OPEN_WAKA:
          // either a /, ?, !, or text is coming next.
          if (c === '!') {
            parser.state = S.SGML_DECL;
            parser.sgmlDecl = '';
          } else if (is(whitespace, c)) {
            // wait for it...
          } else if (is(nameStart, c)) {
            parser.state = S.OPEN_TAG;
            parser.tagName = c;
          } else if (c === '/') {
            parser.state = S.CLOSE_TAG;
            parser.tagName = '';
          } else if (c === '?') {
            parser.state = S.PROC_INST;
            parser.procInstName = parser.procInstBody = '';
          } else {
            strictFail(parser, 'Unencoded <');
            // if there was some whitespace, then add that in.
            if (parser.startTagPosition + 1 < parser.position) {
              var pad = parser.position - parser.startTagPosition;
              c = new Array(pad).join(' ') + c;
            }
            parser.textNode += '<' + c;
            parser.state = S.TEXT;
          }
          continue;
        case S.SGML_DECL:
          if ((parser.sgmlDecl + c).toUpperCase() === CDATA) {
            emitNode(parser, 'onopencdata');
            parser.state = S.CDATA;
            parser.sgmlDecl = '';
            parser.cdata = '';
          } else if (parser.sgmlDecl + c === '--') {
            parser.state = S.COMMENT;
            parser.comment = '';
            parser.sgmlDecl = '';
          } else if ((parser.sgmlDecl + c).toUpperCase() === DOCTYPE) {
            parser.state = S.DOCTYPE;
            if (parser.doctype || parser.sawRoot) {
              strictFail(parser, 'Inappropriately located doctype declaration');
            }
            parser.doctype = '';
            parser.sgmlDecl = '';
          } else if (c === '>') {
            emitNode(parser, 'onsgmldeclaration', parser.sgmlDecl);
            parser.sgmlDecl = '';
            parser.state = S.TEXT;
          } else if (is(quote, c)) {
            parser.state = S.SGML_DECL_QUOTED;
            parser.sgmlDecl += c;
          } else {
            parser.sgmlDecl += c;
          }
          continue;
        case S.SGML_DECL_QUOTED:
          if (c === parser.q) {
            parser.state = S.SGML_DECL;
            parser.q = '';
          }
          parser.sgmlDecl += c;
          continue;
        case S.DOCTYPE:
          if (c === '>') {
            parser.state = S.TEXT;
            emitNode(parser, 'ondoctype', parser.doctype);
            parser.doctype = true; // just remember that we saw it.
          } else {
            parser.doctype += c;
            if (c === '[') {
              parser.state = S.DOCTYPE_DTD;
            } else if (is(quote, c)) {
              parser.state = S.DOCTYPE_QUOTED;
              parser.q = c;
            }
          }
          continue;
        case S.DOCTYPE_QUOTED:
          parser.doctype += c;
          if (c === parser.q) {
            parser.q = '';
            parser.state = S.DOCTYPE;
          }
          continue;
        case S.DOCTYPE_DTD:
          parser.doctype += c;
          if (c === ']') {
            parser.state = S.DOCTYPE;
          } else if (is(quote, c)) {
            parser.state = S.DOCTYPE_DTD_QUOTED;
            parser.q = c;
          }
          continue;
        case S.DOCTYPE_DTD_QUOTED:
          parser.doctype += c;
          if (c === parser.q) {
            parser.state = S.DOCTYPE_DTD;
            parser.q = '';
          }
          continue;
        case S.COMMENT:
          if (c === '-') {
            parser.state = S.COMMENT_ENDING;
          } else {
            parser.comment += c;
          }
          continue;
        case S.COMMENT_ENDING:
          if (c === '-') {
            parser.state = S.COMMENT_ENDED;
            parser.comment = textopts(parser.opt, parser.comment);
            if (parser.comment) {
              emitNode(parser, 'oncomment', parser.comment);
            }
            parser.comment = '';
          } else {
            parser.comment += '-' + c;
            parser.state = S.COMMENT;
          }
          continue;
        case S.COMMENT_ENDED:
          if (c !== '>') {
            strictFail(parser, 'Malformed comment');
            // allow <!-- blah -- bloo --> in non-strict mode,
            // which is a comment of " blah -- bloo "
            parser.comment += '--' + c;
            parser.state = S.COMMENT;
          } else {
            parser.state = S.TEXT;
          }
          continue;
        case S.CDATA:
          if (c === ']') {
            parser.state = S.CDATA_ENDING;
          } else {
            parser.cdata += c;
          }
          continue;
        case S.CDATA_ENDING:
          if (c === ']') {
            parser.state = S.CDATA_ENDING_2;
          } else {
            parser.cdata += ']' + c;
            parser.state = S.CDATA;
          }
          continue;
        case S.CDATA_ENDING_2:
          if (c === '>') {
            if (parser.cdata) {
              emitNode(parser, 'oncdata', parser.cdata);
            }
            emitNode(parser, 'onclosecdata');
            parser.cdata = '';
            parser.state = S.TEXT;
          } else if (c === ']') {
            parser.cdata += ']';
          } else {
            parser.cdata += ']]' + c;
            parser.state = S.CDATA;
          }
          continue;
        case S.PROC_INST:
          if (c === '?') {
            parser.state = S.PROC_INST_ENDING;
          } else if (is(whitespace, c)) {
            parser.state = S.PROC_INST_BODY;
          } else {
            parser.procInstName += c;
          }
          continue;
        case S.PROC_INST_BODY:
          if (!parser.procInstBody && is(whitespace, c)) {
            continue;
          } else if (c === '?') {
            parser.state = S.PROC_INST_ENDING;
          } else {
            parser.procInstBody += c;
          }
          continue;
        case S.PROC_INST_ENDING:
          if (c === '>') {
            emitNode(parser, 'onprocessinginstruction', {
              name: parser.procInstName,
              body: parser.procInstBody
            });
            parser.procInstName = parser.procInstBody = '';
            parser.state = S.TEXT;
          } else {
            parser.procInstBody += '?' + c;
            parser.state = S.PROC_INST_BODY;
          }
          continue;
        case S.OPEN_TAG:
          if (is(nameBody, c)) {
            parser.tagName += c;
          } else {
            newTag(parser);
            if (c === '>') {
              openTag(parser);
            } else if (c === '/') {
              parser.state = S.OPEN_TAG_SLASH;
            } else {
              if (not(whitespace, c)) {
                strictFail(parser, 'Invalid character in tag name');
              }
              parser.state = S.ATTRIB;
            }
          }
          continue;
        case S.OPEN_TAG_SLASH:
          if (c === '>') {
            openTag(parser, true);
            closeTag(parser);
          } else {
            strictFail(parser, 'Forward-slash in opening tag not followed by >');
            parser.state = S.ATTRIB;
          }
          continue;
        case S.ATTRIB:
          // haven't read the attribute name yet.
          if (is(whitespace, c)) {
            continue;
          } else if (c === '>') {
            openTag(parser);
          } else if (c === '/') {
            parser.state = S.OPEN_TAG_SLASH;
          } else if (is(nameStart, c)) {
            parser.attribName = c;
            parser.attribValue = '';
            parser.state = S.ATTRIB_NAME;
          } else {
            strictFail(parser, 'Invalid attribute name');
          }
          continue;
        case S.ATTRIB_NAME:
          if (c === '=') {
            parser.state = S.ATTRIB_VALUE;
          } else if (c === '>') {
            strictFail(parser, 'Attribute without value');
            parser.attribValue = parser.attribName;
            attrib(parser);
            openTag(parser);
          } else if (is(whitespace, c)) {
            parser.state = S.ATTRIB_NAME_SAW_WHITE;
          } else if (is(nameBody, c)) {
            parser.attribName += c;
          } else {
            strictFail(parser, 'Invalid attribute name');
          }
          continue;
        case S.ATTRIB_NAME_SAW_WHITE:
          if (c === '=') {
            parser.state = S.ATTRIB_VALUE;
          } else if (is(whitespace, c)) {
            continue;
          } else {
            strictFail(parser, 'Attribute without value');
            parser.tag.attributes[parser.attribName] = '';
            parser.attribValue = '';
            emitNode(parser, 'onattribute', {
              name: parser.attribName,
              value: ''
            });
            parser.attribName = '';
            if (c === '>') {
              openTag(parser);
            } else if (is(nameStart, c)) {
              parser.attribName = c;
              parser.state = S.ATTRIB_NAME;
            } else {
              strictFail(parser, 'Invalid attribute name');
              parser.state = S.ATTRIB;
            }
          }
          continue;
        case S.ATTRIB_VALUE:
          if (is(whitespace, c)) {
            continue;
          } else if (is(quote, c)) {
            parser.q = c;
            parser.state = S.ATTRIB_VALUE_QUOTED;
          } else {
            strictFail(parser, 'Unquoted attribute value');
            parser.state = S.ATTRIB_VALUE_UNQUOTED;
            parser.attribValue = c;
          }
          continue;
        case S.ATTRIB_VALUE_QUOTED:
          if (c !== parser.q) {
            if (c === '&') {
              parser.state = S.ATTRIB_VALUE_ENTITY_Q;
            } else {
              parser.attribValue += c;
            }
            continue;
          }
          attrib(parser);
          parser.q = '';
          parser.state = S.ATTRIB_VALUE_CLOSED;
          continue;
        case S.ATTRIB_VALUE_CLOSED:
          if (is(whitespace, c)) {
            parser.state = S.ATTRIB;
          } else if (c === '>') {
            openTag(parser);
          } else if (c === '/') {
            parser.state = S.OPEN_TAG_SLASH;
          } else if (is(nameStart, c)) {
            strictFail(parser, 'No whitespace between attributes');
            parser.attribName = c;
            parser.attribValue = '';
            parser.state = S.ATTRIB_NAME;
          } else {
            strictFail(parser, 'Invalid attribute name');
          }
          continue;
        case S.ATTRIB_VALUE_UNQUOTED:
          if (not(attribEnd, c)) {
            if (c === '&') {
              parser.state = S.ATTRIB_VALUE_ENTITY_U;
            } else {
              parser.attribValue += c;
            }
            continue;
          }
          attrib(parser);
          if (c === '>') {
            openTag(parser);
          } else {
            parser.state = S.ATTRIB;
          }
          continue;
        case S.CLOSE_TAG:
          if (!parser.tagName) {
            if (is(whitespace, c)) {
              continue;
            } else if (not(nameStart, c)) {
              if (parser.script) {
                parser.script += '</' + c;
                parser.state = S.SCRIPT;
              } else {
                strictFail(parser, 'Invalid tagname in closing tag.');
              }
            } else {
              parser.tagName = c;
            }
          } else if (c === '>') {
            closeTag(parser);
          } else if (is(nameBody, c)) {
            parser.tagName += c;
          } else if (parser.script) {
            parser.script += '</' + parser.tagName;
            parser.tagName = '';
            parser.state = S.SCRIPT;
          } else {
            if (not(whitespace, c)) {
              strictFail(parser, 'Invalid tagname in closing tag');
            }
            parser.state = S.CLOSE_TAG_SAW_WHITE;
          }
          continue;
        case S.CLOSE_TAG_SAW_WHITE:
          if (is(whitespace, c)) {
            continue;
          }
          if (c === '>') {
            closeTag(parser);
          } else {
            strictFail(parser, 'Invalid characters in closing tag');
          }
          continue;
        case S.TEXT_ENTITY:
        case S.ATTRIB_VALUE_ENTITY_Q:
        case S.ATTRIB_VALUE_ENTITY_U:
          var returnState;
          var buffer;
          switch (parser.state) {
            case S.TEXT_ENTITY:
              returnState = S.TEXT;
              buffer = 'textNode';
              break;
            case S.ATTRIB_VALUE_ENTITY_Q:
              returnState = S.ATTRIB_VALUE_QUOTED;
              buffer = 'attribValue';
              break;
            case S.ATTRIB_VALUE_ENTITY_U:
              returnState = S.ATTRIB_VALUE_UNQUOTED;
              buffer = 'attribValue';
              break;
          }
          if (c === ';') {
            parser[buffer] += parseEntity(parser);
            parser.entity = '';
            parser.state = returnState;
          } else if (is(parser.entity.length ? entityBody : entityStart, c)) {
            parser.entity += c;
          } else {
            strictFail(parser, 'Invalid character in entity name');
            parser[buffer] += '&' + parser.entity + c;
            parser.entity = '';
            parser.state = returnState;
          }
          continue;
        default:
          throw new Error(parser, 'Unknown state: ' + parser.state);
      }
    } // while

    if (parser.position >= parser.bufferCheckPosition) {
      checkBufferLength(parser);
    }
    return parser;
  }

  /*! http://mths.be/fromcodepoint v0.1.0 by @mathias */
  if (!String.fromCodePoint) {
    (function () {
      var stringFromCharCode = String.fromCharCode;
      var floor = Math.floor;
      var fromCodePoint = function fromCodePoint() {
        var MAX_SIZE = 0x4000;
        var codeUnits = [];
        var highSurrogate;
        var lowSurrogate;
        var index = -1;
        var length = arguments.length;
        if (!length) {
          return '';
        }
        var result = '';
        while (++index < length) {
          var codePoint = Number(arguments[index]);
          if (!isFinite(codePoint) ||
          // `NaN`, `+Infinity`, or `-Infinity`
          codePoint < 0 ||
          // not a valid Unicode code point
          codePoint > 0x10FFFF ||
          // not a valid Unicode code point
          floor(codePoint) !== codePoint // not an integer
          ) {
            throw RangeError('Invalid code point: ' + codePoint);
          }
          if (codePoint <= 0xFFFF) {
            // BMP code point
            codeUnits.push(codePoint);
          } else {
            // Astral code point; split in surrogate halves
            // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
            codePoint -= 0x10000;
            highSurrogate = (codePoint >> 10) + 0xD800;
            lowSurrogate = codePoint % 0x400 + 0xDC00;
            codeUnits.push(highSurrogate, lowSurrogate);
          }
          if (index + 1 === length || codeUnits.length > MAX_SIZE) {
            result += stringFromCharCode.apply(null, codeUnits);
            codeUnits.length = 0;
          }
        }
        return result;
      };
      if (Object.defineProperty) {
        Object.defineProperty(String, 'fromCodePoint', {
          value: fromCodePoint,
          configurable: true,
          writable: true
        });
      } else {
        String.fromCodePoint = fromCodePoint;
      }
    })();
  }
})( false ? 0 : exports);

/***/ }),

/***/ "./node_modules/imsc/src/main/js/doc.js":
/*!**********************************************!*\
  !*** ./node_modules/imsc/src/main/js/doc.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
__webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module imscDoc
 */

;
(function (imscDoc, sax, imscNames, imscStyles, imscUtils) {
  /**
   * Allows a client to provide callbacks to handle children of the <metadata> element
   * @typedef {Object} MetadataHandler
   * @property {?OpenTagCallBack} onOpenTag
   * @property {?CloseTagCallBack} onCloseTag
   * @property {?TextCallBack} onText
   */

  /**
   * Called when the opening tag of an element node is encountered.
   * @callback OpenTagCallBack
   * @param {string} ns Namespace URI of the element
   * @param {string} name Local name of the element
   * @param {Object[]} attributes List of attributes, each consisting of a
   *                              `uri`, `name` and `value`
   */

  /**
   * Called when the closing tag of an element node is encountered.
   * @callback CloseTagCallBack
   */

  /**
   * Called when a text node is encountered.
   * @callback TextCallBack
   * @param {string} contents Contents of the text node
   */

  /**
   * Parses an IMSC1 document into an opaque in-memory representation that exposes
   * a single method <pre>getMediaTimeEvents()</pre> that returns a list of time
   * offsets (in seconds) of the ISD, i.e. the points in time where the visual
   * representation of the document change. `metadataHandler` allows the caller to
   * be called back when nodes are present in <metadata> elements. 
   * 
   * @param {string} xmlstring XML document
   * @param {?module:imscUtils.ErrorHandler} errorHandler Error callback
   * @param {?MetadataHandler} metadataHandler Callback for <Metadata> elements
   * @returns {Object} Opaque in-memory representation of an IMSC1 document
   */

  imscDoc.fromXML = function (xmlstring, errorHandler, metadataHandler) {
    var p = sax.parser(true, {
      xmlns: true
    });
    var estack = [];
    var xmllangstack = [];
    var xmlspacestack = [];
    var metadata_depth = 0;
    var doc = null;
    p.onclosetag = function (node) {
      if (estack[0] instanceof Region) {
        /* merge referenced styles */

        if (doc.head !== null && doc.head.styling !== null) {
          mergeReferencedStyles(doc.head.styling, estack[0].styleRefs, estack[0].styleAttrs, errorHandler);
        }
        delete estack[0].styleRefs;
      } else if (estack[0] instanceof Styling) {
        /* flatten chained referential styling */

        for (var sid in estack[0].styles) {
          if (!estack[0].styles.hasOwnProperty(sid)) continue;
          mergeChainedStyles(estack[0], estack[0].styles[sid], errorHandler);
        }
      } else if (estack[0] instanceof P || estack[0] instanceof Span) {
        /* merge anonymous spans */

        if (estack[0].contents.length > 1) {
          var cs = [estack[0].contents[0]];
          var c;
          for (c = 1; c < estack[0].contents.length; c++) {
            if (estack[0].contents[c] instanceof AnonymousSpan && cs[cs.length - 1] instanceof AnonymousSpan) {
              cs[cs.length - 1].text += estack[0].contents[c].text;
            } else {
              cs.push(estack[0].contents[c]);
            }
          }
          estack[0].contents = cs;
        }

        // remove redundant nested anonymous spans (9.3.3(1)(c))

        if (estack[0] instanceof Span && estack[0].contents.length === 1 && estack[0].contents[0] instanceof AnonymousSpan) {
          estack[0].text = estack[0].contents[0].text;
          delete estack[0].contents;
        }
      } else if (estack[0] instanceof ForeignElement) {
        if (estack[0].node.uri === imscNames.ns_tt && estack[0].node.local === 'metadata') {
          /* leave the metadata element */

          metadata_depth--;
        } else if (metadata_depth > 0 && metadataHandler && 'onCloseTag' in metadataHandler) {
          /* end of child of metadata element */

          metadataHandler.onCloseTag();
        }
      }

      // TODO: delete stylerefs?

      // maintain the xml:space stack

      xmlspacestack.shift();

      // maintain the xml:lang stack

      xmllangstack.shift();

      // prepare for the next element

      estack.shift();
    };
    p.ontext = function (str) {
      if (estack[0] === undefined) {

        /* ignoring text outside of elements */
      } else if (estack[0] instanceof Span || estack[0] instanceof P) {
        /* ignore children text nodes in ruby container spans */

        if (estack[0] instanceof Span) {
          var ruby = estack[0].styleAttrs[imscStyles.byName.ruby.qname];
          if (ruby === 'container' || ruby === 'textContainer' || ruby === 'baseContainer') {
            return;
          }
        }

        /* create an anonymous span */

        var s = new AnonymousSpan();
        s.initFromText(doc, estack[0], str, xmllangstack[0], xmlspacestack[0], errorHandler);
        estack[0].contents.push(s);
      } else if (estack[0] instanceof ForeignElement && metadata_depth > 0 && metadataHandler && 'onText' in metadataHandler) {
        /* text node within a child of metadata element */

        metadataHandler.onText(str);
      }
    };
    p.onopentag = function (node) {
      // maintain the xml:space stack

      var xmlspace = node.attributes["xml:space"];
      if (xmlspace) {
        xmlspacestack.unshift(xmlspace.value);
      } else {
        if (xmlspacestack.length === 0) {
          xmlspacestack.unshift("default");
        } else {
          xmlspacestack.unshift(xmlspacestack[0]);
        }
      }

      /* maintain the xml:lang stack */

      var xmllang = node.attributes["xml:lang"];
      if (xmllang) {
        xmllangstack.unshift(xmllang.value);
      } else {
        if (xmllangstack.length === 0) {
          xmllangstack.unshift("");
        } else {
          xmllangstack.unshift(xmllangstack[0]);
        }
      }

      /* process the element */

      if (node.uri === imscNames.ns_tt) {
        if (node.local === 'tt') {
          if (doc !== null) {
            reportFatal(errorHandler, "Two <tt> elements at (" + this.line + "," + this.column + ")");
          }
          doc = new TT();
          doc.initFromNode(node, xmllangstack[0], errorHandler);
          estack.unshift(doc);
        } else if (node.local === 'head') {
          if (!(estack[0] instanceof TT)) {
            reportFatal(errorHandler, "Parent of <head> element is not <tt> at (" + this.line + "," + this.column + ")");
          }
          estack.unshift(doc.head);
        } else if (node.local === 'styling') {
          if (!(estack[0] instanceof Head)) {
            reportFatal(errorHandler, "Parent of <styling> element is not <head> at (" + this.line + "," + this.column + ")");
          }
          estack.unshift(doc.head.styling);
        } else if (node.local === 'style') {
          var s;
          if (estack[0] instanceof Styling) {
            s = new Style();
            s.initFromNode(node, errorHandler);

            /* ignore <style> element missing @id */

            if (!s.id) {
              reportError(errorHandler, "<style> element missing @id attribute");
            } else {
              doc.head.styling.styles[s.id] = s;
            }
            estack.unshift(s);
          } else if (estack[0] instanceof Region) {
            /* nested styles can be merged with specified styles
             * immediately, with lower priority
             * (see 8.4.4.2(3) at TTML1 )
             */

            s = new Style();
            s.initFromNode(node, errorHandler);
            mergeStylesIfNotPresent(s.styleAttrs, estack[0].styleAttrs);
            estack.unshift(s);
          } else {
            reportFatal(errorHandler, "Parent of <style> element is not <styling> or <region> at (" + this.line + "," + this.column + ")");
          }
        } else if (node.local === 'initial') {
          var ini;
          if (estack[0] instanceof Styling) {
            ini = new Initial();
            ini.initFromNode(node, errorHandler);
            for (var qn in ini.styleAttrs) {
              if (!ini.styleAttrs.hasOwnProperty(qn)) continue;
              doc.head.styling.initials[qn] = ini.styleAttrs[qn];
            }
            estack.unshift(ini);
          } else {
            reportFatal(errorHandler, "Parent of <initial> element is not <styling> at (" + this.line + "," + this.column + ")");
          }
        } else if (node.local === 'layout') {
          if (!(estack[0] instanceof Head)) {
            reportFatal(errorHandler, "Parent of <layout> element is not <head> at " + this.line + "," + this.column + ")");
          }
          estack.unshift(doc.head.layout);
        } else if (node.local === 'region') {
          if (!(estack[0] instanceof Layout)) {
            reportFatal(errorHandler, "Parent of <region> element is not <layout> at " + this.line + "," + this.column + ")");
          }
          var r = new Region();
          r.initFromNode(doc, node, xmllangstack[0], errorHandler);
          if (!r.id || r.id in doc.head.layout.regions) {
            reportError(errorHandler, "Ignoring <region> with duplicate or missing @id at " + this.line + "," + this.column + ")");
          } else {
            doc.head.layout.regions[r.id] = r;
          }
          estack.unshift(r);
        } else if (node.local === 'body') {
          if (!(estack[0] instanceof TT)) {
            reportFatal(errorHandler, "Parent of <body> element is not <tt> at " + this.line + "," + this.column + ")");
          }
          if (doc.body !== null) {
            reportFatal(errorHandler, "Second <body> element at " + this.line + "," + this.column + ")");
          }
          var b = new Body();
          b.initFromNode(doc, node, xmllangstack[0], errorHandler);
          doc.body = b;
          estack.unshift(b);
        } else if (node.local === 'div') {
          if (!(estack[0] instanceof Div || estack[0] instanceof Body)) {
            reportFatal(errorHandler, "Parent of <div> element is not <body> or <div> at " + this.line + "," + this.column + ")");
          }
          var d = new Div();
          d.initFromNode(doc, estack[0], node, xmllangstack[0], errorHandler);

          /* transform smpte:backgroundImage to TTML2 image element */

          var bi = d.styleAttrs[imscStyles.byName.backgroundImage.qname];
          if (bi) {
            d.contents.push(new Image(bi));
            delete d.styleAttrs[imscStyles.byName.backgroundImage.qname];
          }
          estack[0].contents.push(d);
          estack.unshift(d);
        } else if (node.local === 'image') {
          if (!(estack[0] instanceof Div)) {
            reportFatal(errorHandler, "Parent of <image> element is not <div> at " + this.line + "," + this.column + ")");
          }
          var img = new Image();
          img.initFromNode(doc, estack[0], node, xmllangstack[0], errorHandler);
          estack[0].contents.push(img);
          estack.unshift(img);
        } else if (node.local === 'p') {
          if (!(estack[0] instanceof Div)) {
            reportFatal(errorHandler, "Parent of <p> element is not <div> at " + this.line + "," + this.column + ")");
          }
          var p = new P();
          p.initFromNode(doc, estack[0], node, xmllangstack[0], errorHandler);
          estack[0].contents.push(p);
          estack.unshift(p);
        } else if (node.local === 'span') {
          if (!(estack[0] instanceof Span || estack[0] instanceof P)) {
            reportFatal(errorHandler, "Parent of <span> element is not <span> or <p> at " + this.line + "," + this.column + ")");
          }
          var ns = new Span();
          ns.initFromNode(doc, estack[0], node, xmllangstack[0], xmlspacestack[0], errorHandler);
          estack[0].contents.push(ns);
          estack.unshift(ns);
        } else if (node.local === 'br') {
          if (!(estack[0] instanceof Span || estack[0] instanceof P)) {
            reportFatal(errorHandler, "Parent of <br> element is not <span> or <p> at " + this.line + "," + this.column + ")");
          }
          var nb = new Br();
          nb.initFromNode(doc, estack[0], node, xmllangstack[0], errorHandler);
          estack[0].contents.push(nb);
          estack.unshift(nb);
        } else if (node.local === 'set') {
          if (!(estack[0] instanceof Span || estack[0] instanceof P || estack[0] instanceof Div || estack[0] instanceof Body || estack[0] instanceof Region || estack[0] instanceof Br)) {
            reportFatal(errorHandler, "Parent of <set> element is not a content element or a region at " + this.line + "," + this.column + ")");
          }
          var st = new Set();
          st.initFromNode(doc, estack[0], node, errorHandler);
          estack[0].sets.push(st);
          estack.unshift(st);
        } else {
          /* element in the TT namespace, but not a content element */

          estack.unshift(new ForeignElement(node));
        }
      } else {
        /* ignore elements not in the TTML namespace unless in metadata element */

        estack.unshift(new ForeignElement(node));
      }

      /* handle metadata callbacks */

      if (estack[0] instanceof ForeignElement) {
        if (node.uri === imscNames.ns_tt && node.local === 'metadata') {
          /* enter the metadata element */

          metadata_depth++;
        } else if (metadata_depth > 0 && metadataHandler && 'onOpenTag' in metadataHandler) {
          /* start of child of metadata element */

          var attrs = [];
          for (var a in node.attributes) {
            attrs[node.attributes[a].uri + " " + node.attributes[a].local] = {
              uri: node.attributes[a].uri,
              local: node.attributes[a].local,
              value: node.attributes[a].value
            };
          }
          metadataHandler.onOpenTag(node.uri, node.local, attrs);
        }
      }
    };

    // parse the document

    p.write(xmlstring).close();

    // all referential styling has been flatten, so delete styles

    delete doc.head.styling.styles;

    // create default region if no regions specified

    var hasRegions = false;

    /* AFAIK the only way to determine whether an object has members */

    for (var i in doc.head.layout.regions) {
      if (doc.head.layout.regions.hasOwnProperty(i)) {
        hasRegions = true;
        break;
      }
    }
    if (!hasRegions) {
      /* create default region */

      var dr = Region.prototype.createDefaultRegion(doc.lang);
      doc.head.layout.regions[dr.id] = dr;
    }

    /* resolve desired timing for regions */

    for (var region_i in doc.head.layout.regions) {
      if (!doc.head.layout.regions.hasOwnProperty(region_i)) continue;
      resolveTiming(doc, doc.head.layout.regions[region_i], null, null);
    }

    /* resolve desired timing for content elements */

    if (doc.body) {
      resolveTiming(doc, doc.body, null, null);
    }

    /* remove undefined spans in ruby containers */

    if (doc.body) {
      cleanRubyContainers(doc.body);
    }
    return doc;
  };
  function cleanRubyContainers(element) {
    if (!('contents' in element)) return;
    var rubyval = 'styleAttrs' in element ? element.styleAttrs[imscStyles.byName.ruby.qname] : null;
    var isrubycontainer = element.kind === 'span' && (rubyval === "container" || rubyval === "textContainer" || rubyval === "baseContainer");
    for (var i = element.contents.length - 1; i >= 0; i--) {
      if (isrubycontainer && !('styleAttrs' in element.contents[i] && imscStyles.byName.ruby.qname in element.contents[i].styleAttrs)) {
        /* prune undefined <span> in ruby containers */

        delete element.contents[i];
      } else {
        cleanRubyContainers(element.contents[i]);
      }
    }
  }
  function resolveTiming(doc, element, prev_sibling, parent) {
    /* are we in a seq container? */

    var isinseq = parent && parent.timeContainer === "seq";

    /* determine implicit begin */

    var implicit_begin = 0; /* default */

    if (parent) {
      if (isinseq && prev_sibling) {
        /*
         * if seq time container, offset from the previous sibling end
         */

        implicit_begin = prev_sibling.end;
      } else {
        implicit_begin = parent.begin;
      }
    }

    /* compute desired begin */

    element.begin = element.explicit_begin ? element.explicit_begin + implicit_begin : implicit_begin;

    /* determine implicit end */

    var implicit_end = element.begin;
    var s = null;
    if ("sets" in element) {
      for (var set_i = 0; set_i < element.sets.length; set_i++) {
        resolveTiming(doc, element.sets[set_i], s, element);
        if (element.timeContainer === "seq") {
          implicit_end = element.sets[set_i].end;
        } else {
          implicit_end = Math.max(implicit_end, element.sets[set_i].end);
        }
        s = element.sets[set_i];
      }
    }
    if (!('contents' in element)) {
      /* anonymous spans and regions and <set> and <br>s and spans with only children text nodes */

      if (isinseq) {
        /* in seq container, implicit duration is zero */

        implicit_end = element.begin;
      } else {
        /* in par container, implicit duration is indefinite */

        implicit_end = Number.POSITIVE_INFINITY;
      }
    } else if ("contents" in element) {
      for (var content_i = 0; content_i < element.contents.length; content_i++) {
        resolveTiming(doc, element.contents[content_i], s, element);
        if (element.timeContainer === "seq") {
          implicit_end = element.contents[content_i].end;
        } else {
          implicit_end = Math.max(implicit_end, element.contents[content_i].end);
        }
        s = element.contents[content_i];
      }
    }

    /* determine desired end */
    /* it is never made really clear in SMIL that the explicit end is offset by the implicit begin */

    if (element.explicit_end !== null && element.explicit_dur !== null) {
      element.end = Math.min(element.begin + element.explicit_dur, implicit_begin + element.explicit_end);
    } else if (element.explicit_end === null && element.explicit_dur !== null) {
      element.end = element.begin + element.explicit_dur;
    } else if (element.explicit_end !== null && element.explicit_dur === null) {
      element.end = implicit_begin + element.explicit_end;
    } else {
      element.end = implicit_end;
    }
    delete element.explicit_begin;
    delete element.explicit_dur;
    delete element.explicit_end;
    doc._registerEvent(element);
  }
  function ForeignElement(node) {
    this.node = node;
  }
  function TT() {
    this.events = [];
    this.head = new Head();
    this.body = null;
  }
  TT.prototype.initFromNode = function (node, xmllang, errorHandler) {
    /* compute cell resolution */

    var cr = extractCellResolution(node, errorHandler);
    this.cellLength = {
      'h': new imscUtils.ComputedLength(0, 1 / cr.h),
      'w': new imscUtils.ComputedLength(1 / cr.w, 0)
    };

    /* extract frame rate and tick rate */

    var frtr = extractFrameAndTickRate(node, errorHandler);
    this.effectiveFrameRate = frtr.effectiveFrameRate;
    this.tickRate = frtr.tickRate;

    /* extract aspect ratio */

    this.aspectRatio = extractAspectRatio(node, errorHandler);

    /* check timebase */

    var attr = findAttribute(node, imscNames.ns_ttp, "timeBase");
    if (attr !== null && attr !== "media") {
      reportFatal(errorHandler, "Unsupported time base");
    }

    /* retrieve extent */

    var e = extractExtent(node, errorHandler);
    if (e === null) {
      this.pxLength = {
        'h': null,
        'w': null
      };
    } else {
      if (e.h.unit !== "px" || e.w.unit !== "px") {
        reportFatal(errorHandler, "Extent on TT must be in px or absent");
      }
      this.pxLength = {
        'h': new imscUtils.ComputedLength(0, 1 / e.h.value),
        'w': new imscUtils.ComputedLength(1 / e.w.value, 0)
      };
    }

    /** set root container dimensions to (1, 1) arbitrarily
      * the root container is mapped to actual dimensions at rendering
    **/

    this.dimensions = {
      'h': new imscUtils.ComputedLength(0, 1),
      'w': new imscUtils.ComputedLength(1, 0)
    };

    /* xml:lang */

    this.lang = xmllang;
  };

  /* register a temporal events */
  TT.prototype._registerEvent = function (elem) {
    /* skip if begin is not < then end */

    if (elem.end <= elem.begin) return;

    /* index the begin time of the event */

    var b_i = indexOf(this.events, elem.begin);
    if (!b_i.found) {
      this.events.splice(b_i.index, 0, elem.begin);
    }

    /* index the end time of the event */

    if (elem.end !== Number.POSITIVE_INFINITY) {
      var e_i = indexOf(this.events, elem.end);
      if (!e_i.found) {
        this.events.splice(e_i.index, 0, elem.end);
      }
    }
  };

  /*
   * Retrieves the range of ISD times covered by the document
   * 
   * @returns {Array} Array of two elements: min_begin_time and max_begin_time
   * 
   */
  TT.prototype.getMediaTimeRange = function () {
    return [this.events[0], this.events[this.events.length - 1]];
  };

  /*
   * Returns list of ISD begin times  
   * 
   * @returns {Array}
   */
  TT.prototype.getMediaTimeEvents = function () {
    return this.events;
  };

  /*
   * Represents a TTML Head element
   */

  function Head() {
    this.styling = new Styling();
    this.layout = new Layout();
  }

  /*
   * Represents a TTML Styling element
   */

  function Styling() {
    this.styles = {};
    this.initials = {};
  }

  /*
   * Represents a TTML Style element
   */

  function Style() {
    this.id = null;
    this.styleAttrs = null;
    this.styleRefs = null;
  }
  Style.prototype.initFromNode = function (node, errorHandler) {
    this.id = elementGetXMLID(node);
    this.styleAttrs = elementGetStyles(node, errorHandler);
    this.styleRefs = elementGetStyleRefs(node);
  };

  /*
   * Represents a TTML initial element
   */

  function Initial() {
    this.styleAttrs = null;
  }
  Initial.prototype.initFromNode = function (node, errorHandler) {
    this.styleAttrs = {};
    for (var i in node.attributes) {
      if (node.attributes[i].uri === imscNames.ns_itts || node.attributes[i].uri === imscNames.ns_ebutts || node.attributes[i].uri === imscNames.ns_tts) {
        var qname = node.attributes[i].uri + " " + node.attributes[i].local;
        this.styleAttrs[qname] = node.attributes[i].value;
      }
    }
  };

  /*
   * Represents a TTML Layout element
   * 
   */

  function Layout() {
    this.regions = {};
  }

  /*
   * Represents a TTML image element
   */

  function Image(src, type) {
    ContentElement.call(this, 'image');
    this.src = src;
    this.type = type;
  }
  Image.prototype.initFromNode = function (doc, parent, node, xmllang, errorHandler) {
    this.src = 'src' in node.attributes ? node.attributes.src.value : null;
    if (!this.src) {
      reportError(errorHandler, "Invalid image@src attribute");
    }
    this.type = 'type' in node.attributes ? node.attributes.type.value : null;
    if (!this.type) {
      reportError(errorHandler, "Invalid image@type attribute");
    }
    StyledElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    AnimatedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    LayoutElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    this.lang = xmllang;
  };

  /*
   * TTML element utility functions
   * 
   */

  function ContentElement(kind) {
    this.kind = kind;
  }
  function IdentifiedElement(id) {
    this.id = id;
  }
  IdentifiedElement.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    this.id = elementGetXMLID(node);
  };
  function LayoutElement(id) {
    this.regionID = id;
  }
  LayoutElement.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    this.regionID = elementGetRegionID(node);
  };
  function StyledElement(styleAttrs) {
    this.styleAttrs = styleAttrs;
  }
  StyledElement.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    this.styleAttrs = elementGetStyles(node, errorHandler);
    if (doc.head !== null && doc.head.styling !== null) {
      mergeReferencedStyles(doc.head.styling, elementGetStyleRefs(node), this.styleAttrs, errorHandler);
    }
  };
  function AnimatedElement(sets) {
    this.sets = sets;
  }
  AnimatedElement.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    this.sets = [];
  };
  function ContainerElement(contents) {
    this.contents = contents;
  }
  ContainerElement.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    this.contents = [];
  };
  function TimedElement(explicit_begin, explicit_end, explicit_dur) {
    this.explicit_begin = explicit_begin;
    this.explicit_end = explicit_end;
    this.explicit_dur = explicit_dur;
  }
  TimedElement.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    var t = processTiming(doc, parent, node, errorHandler);
    this.explicit_begin = t.explicit_begin;
    this.explicit_end = t.explicit_end;
    this.explicit_dur = t.explicit_dur;
    this.timeContainer = elementGetTimeContainer(node, errorHandler);
  };

  /*
   * Represents a TTML body element
   */

  function Body() {
    ContentElement.call(this, 'body');
  }
  Body.prototype.initFromNode = function (doc, node, xmllang, errorHandler) {
    StyledElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    AnimatedElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    LayoutElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    ContainerElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    this.lang = xmllang;
  };

  /*
   * Represents a TTML div element
   */

  function Div() {
    ContentElement.call(this, 'div');
  }
  Div.prototype.initFromNode = function (doc, parent, node, xmllang, errorHandler) {
    StyledElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    AnimatedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    LayoutElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    ContainerElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    this.lang = xmllang;
  };

  /*
   * Represents a TTML p element
   */

  function P() {
    ContentElement.call(this, 'p');
  }
  P.prototype.initFromNode = function (doc, parent, node, xmllang, errorHandler) {
    StyledElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    AnimatedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    LayoutElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    ContainerElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    this.lang = xmllang;
  };

  /*
   * Represents a TTML span element
   */

  function Span() {
    ContentElement.call(this, 'span');
  }
  Span.prototype.initFromNode = function (doc, parent, node, xmllang, xmlspace, errorHandler) {
    StyledElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    AnimatedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    LayoutElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    ContainerElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    this.space = xmlspace;
    this.lang = xmllang;
  };

  /*
   * Represents a TTML anonymous span element
   */

  function AnonymousSpan() {
    ContentElement.call(this, 'span');
  }
  AnonymousSpan.prototype.initFromText = function (doc, parent, text, xmllang, xmlspace, errorHandler) {
    TimedElement.prototype.initFromNode.call(this, doc, parent, null, errorHandler);
    this.text = text;
    this.space = xmlspace;
    this.lang = xmllang;
  };

  /*
   * Represents a TTML br element
   */

  function Br() {
    ContentElement.call(this, 'br');
  }
  Br.prototype.initFromNode = function (doc, parent, node, xmllang, errorHandler) {
    LayoutElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    this.lang = xmllang;
  };

  /*
   * Represents a TTML Region element
   * 
   */

  function Region() {}
  Region.prototype.createDefaultRegion = function (xmllang) {
    var r = new Region();
    IdentifiedElement.call(r, '');
    StyledElement.call(r, {});
    AnimatedElement.call(r, []);
    TimedElement.call(r, 0, Number.POSITIVE_INFINITY, null);
    this.lang = xmllang;
    return r;
  };
  Region.prototype.initFromNode = function (doc, node, xmllang, errorHandler) {
    IdentifiedElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    TimedElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);
    AnimatedElement.prototype.initFromNode.call(this, doc, null, node, errorHandler);

    /* add specified styles */

    this.styleAttrs = elementGetStyles(node, errorHandler);

    /* remember referential styles for merging after nested styling is processed*/

    this.styleRefs = elementGetStyleRefs(node);

    /* xml:lang */

    this.lang = xmllang;
  };

  /*
   * Represents a TTML Set element
   * 
   */

  function Set() {}
  Set.prototype.initFromNode = function (doc, parent, node, errorHandler) {
    TimedElement.prototype.initFromNode.call(this, doc, parent, node, errorHandler);
    var styles = elementGetStyles(node, errorHandler);
    this.qname = null;
    this.value = null;
    for (var qname in styles) {
      if (!styles.hasOwnProperty(qname)) continue;
      if (this.qname) {
        reportError(errorHandler, "More than one style specified on set");
        break;
      }
      this.qname = qname;
      this.value = styles[qname];
    }
  };

  /*
   * Utility functions
   * 
   */

  function elementGetXMLID(node) {
    return node && 'xml:id' in node.attributes ? node.attributes['xml:id'].value || null : null;
  }
  function elementGetRegionID(node) {
    return node && 'region' in node.attributes ? node.attributes.region.value : '';
  }
  function elementGetTimeContainer(node, errorHandler) {
    var tc = node && 'timeContainer' in node.attributes ? node.attributes.timeContainer.value : null;
    if (!tc || tc === "par") {
      return "par";
    } else if (tc === "seq") {
      return "seq";
    } else {
      reportError(errorHandler, "Illegal value of timeContainer (assuming 'par')");
      return "par";
    }
  }
  function elementGetStyleRefs(node) {
    return node && 'style' in node.attributes ? node.attributes.style.value.split(" ") : [];
  }
  function elementGetStyles(node, errorHandler) {
    var s = {};
    if (node !== null) {
      for (var i in node.attributes) {
        var qname = node.attributes[i].uri + " " + node.attributes[i].local;
        var sa = imscStyles.byQName[qname];
        if (sa !== undefined) {
          var val = sa.parse(node.attributes[i].value);
          if (val !== null) {
            s[qname] = val;

            /* TODO: consider refactoring errorHandler into parse and compute routines */

            if (sa === imscStyles.byName.zIndex) {
              reportWarning(errorHandler, "zIndex attribute present but not used by IMSC1 since regions do not overlap");
            }
          } else {
            reportError(errorHandler, "Cannot parse styling attribute " + qname + " --> " + node.attributes[i].value);
          }
        }
      }
    }
    return s;
  }
  function findAttribute(node, ns, name) {
    for (var i in node.attributes) {
      if (node.attributes[i].uri === ns && node.attributes[i].local === name) {
        return node.attributes[i].value;
      }
    }
    return null;
  }
  function extractAspectRatio(node, errorHandler) {
    var ar = findAttribute(node, imscNames.ns_ittp, "aspectRatio");
    if (ar === null) {
      ar = findAttribute(node, imscNames.ns_ttp, "displayAspectRatio");
    }
    var rslt = null;
    if (ar !== null) {
      var ASPECT_RATIO_RE = /(\d+)\s+(\d+)/;
      var m = ASPECT_RATIO_RE.exec(ar);
      if (m !== null) {
        var w = parseInt(m[1]);
        var h = parseInt(m[2]);
        if (w !== 0 && h !== 0) {
          rslt = w / h;
        } else {
          reportError(errorHandler, "Illegal aspectRatio values (ignoring)");
        }
      } else {
        reportError(errorHandler, "Malformed aspectRatio attribute (ignoring)");
      }
    }
    return rslt;
  }

  /*
   * Returns the cellResolution attribute from a node
   * 
   */
  function extractCellResolution(node, errorHandler) {
    var cr = findAttribute(node, imscNames.ns_ttp, "cellResolution");

    // initial value

    var h = 15;
    var w = 32;
    if (cr !== null) {
      var CELL_RESOLUTION_RE = /(\d+) (\d+)/;
      var m = CELL_RESOLUTION_RE.exec(cr);
      if (m !== null) {
        w = parseInt(m[1]);
        h = parseInt(m[2]);
      } else {
        reportWarning(errorHandler, "Malformed cellResolution value (using initial value instead)");
      }
    }
    return {
      'w': w,
      'h': h
    };
  }
  function extractFrameAndTickRate(node, errorHandler) {
    // subFrameRate is ignored per IMSC1 specification

    // extract frame rate

    var fps_attr = findAttribute(node, imscNames.ns_ttp, "frameRate");

    // initial value

    var fps = 30;

    // match variable

    var m;
    if (fps_attr !== null) {
      var FRAME_RATE_RE = /(\d+)/;
      m = FRAME_RATE_RE.exec(fps_attr);
      if (m !== null) {
        fps = parseInt(m[1]);
      } else {
        reportWarning(errorHandler, "Malformed frame rate attribute (using initial value instead)");
      }
    }

    // extract frame rate multiplier

    var frm_attr = findAttribute(node, imscNames.ns_ttp, "frameRateMultiplier");

    // initial value

    var frm = 1;
    if (frm_attr !== null) {
      var FRAME_RATE_MULT_RE = /(\d+) (\d+)/;
      m = FRAME_RATE_MULT_RE.exec(frm_attr);
      if (m !== null) {
        frm = parseInt(m[1]) / parseInt(m[2]);
      } else {
        reportWarning(errorHandler, "Malformed frame rate multiplier attribute (using initial value instead)");
      }
    }
    var efps = frm * fps;

    // extract tick rate

    var tr = 1;
    var trattr = findAttribute(node, imscNames.ns_ttp, "tickRate");
    if (trattr === null) {
      if (fps_attr !== null) tr = efps;
    } else {
      var TICK_RATE_RE = /(\d+)/;
      m = TICK_RATE_RE.exec(trattr);
      if (m !== null) {
        tr = parseInt(m[1]);
      } else {
        reportWarning(errorHandler, "Malformed tick rate attribute (using initial value instead)");
      }
    }
    return {
      effectiveFrameRate: efps,
      tickRate: tr
    };
  }
  function extractExtent(node, errorHandler) {
    var attr = findAttribute(node, imscNames.ns_tts, "extent");
    if (attr === null) return null;
    var s = attr.split(" ");
    if (s.length !== 2) {
      reportWarning(errorHandler, "Malformed extent (ignoring)");
      return null;
    }
    var w = imscUtils.parseLength(s[0]);
    var h = imscUtils.parseLength(s[1]);
    if (!h || !w) {
      reportWarning(errorHandler, "Malformed extent values (ignoring)");
      return null;
    }
    return {
      'h': h,
      'w': w
    };
  }
  function parseTimeExpression(tickRate, effectiveFrameRate, str) {
    var CLOCK_TIME_FRACTION_RE = /^(\d{2,}):(\d\d):(\d\d(?:\.\d+)?)$/;
    var CLOCK_TIME_FRAMES_RE = /^(\d{2,}):(\d\d):(\d\d)\:(\d{2,})$/;
    var OFFSET_FRAME_RE = /^(\d+(?:\.\d+)?)f$/;
    var OFFSET_TICK_RE = /^(\d+(?:\.\d+)?)t$/;
    var OFFSET_MS_RE = /^(\d+(?:\.\d+)?)ms$/;
    var OFFSET_S_RE = /^(\d+(?:\.\d+)?)s$/;
    var OFFSET_H_RE = /^(\d+(?:\.\d+)?)h$/;
    var OFFSET_M_RE = /^(\d+(?:\.\d+)?)m$/;
    var m;
    var r = null;
    if ((m = OFFSET_FRAME_RE.exec(str)) !== null) {
      if (effectiveFrameRate !== null) {
        r = parseFloat(m[1]) / effectiveFrameRate;
      }
    } else if ((m = OFFSET_TICK_RE.exec(str)) !== null) {
      if (tickRate !== null) {
        r = parseFloat(m[1]) / tickRate;
      }
    } else if ((m = OFFSET_MS_RE.exec(str)) !== null) {
      r = parseFloat(m[1]) / 1000.0;
    } else if ((m = OFFSET_S_RE.exec(str)) !== null) {
      r = parseFloat(m[1]);
    } else if ((m = OFFSET_H_RE.exec(str)) !== null) {
      r = parseFloat(m[1]) * 3600.0;
    } else if ((m = OFFSET_M_RE.exec(str)) !== null) {
      r = parseFloat(m[1]) * 60.0;
    } else if ((m = CLOCK_TIME_FRACTION_RE.exec(str)) !== null) {
      r = parseInt(m[1]) * 3600 + parseInt(m[2]) * 60 + parseFloat(m[3]);
    } else if ((m = CLOCK_TIME_FRAMES_RE.exec(str)) !== null) {
      /* this assumes that HH:MM:SS is a clock-time-with-fraction */

      if (effectiveFrameRate !== null) {
        r = parseInt(m[1]) * 3600 + parseInt(m[2]) * 60 + parseInt(m[3]) + (m[4] === null ? 0 : parseInt(m[4]) / effectiveFrameRate);
      }
    }
    return r;
  }
  function processTiming(doc, parent, node, errorHandler) {
    /* determine explicit begin */

    var explicit_begin = null;
    if (node && 'begin' in node.attributes) {
      explicit_begin = parseTimeExpression(doc.tickRate, doc.effectiveFrameRate, node.attributes.begin.value);
      if (explicit_begin === null) {
        reportWarning(errorHandler, "Malformed begin value " + node.attributes.begin.value + " (using 0)");
      }
    }

    /* determine explicit duration */

    var explicit_dur = null;
    if (node && 'dur' in node.attributes) {
      explicit_dur = parseTimeExpression(doc.tickRate, doc.effectiveFrameRate, node.attributes.dur.value);
      if (explicit_dur === null) {
        reportWarning(errorHandler, "Malformed dur value " + node.attributes.dur.value + " (ignoring)");
      }
    }

    /* determine explicit end */

    var explicit_end = null;
    if (node && 'end' in node.attributes) {
      explicit_end = parseTimeExpression(doc.tickRate, doc.effectiveFrameRate, node.attributes.end.value);
      if (explicit_end === null) {
        reportWarning(errorHandler, "Malformed end value (ignoring)");
      }
    }
    return {
      explicit_begin: explicit_begin,
      explicit_end: explicit_end,
      explicit_dur: explicit_dur
    };
  }
  function mergeChainedStyles(styling, style, errorHandler) {
    while (style.styleRefs.length > 0) {
      var sref = style.styleRefs.pop();
      if (!(sref in styling.styles)) {
        reportError(errorHandler, "Non-existant style id referenced");
        continue;
      }
      mergeChainedStyles(styling, styling.styles[sref], errorHandler);
      mergeStylesIfNotPresent(styling.styles[sref].styleAttrs, style.styleAttrs);
    }
  }
  function mergeReferencedStyles(styling, stylerefs, styleattrs, errorHandler) {
    for (var i = stylerefs.length - 1; i >= 0; i--) {
      var sref = stylerefs[i];
      if (!(sref in styling.styles)) {
        reportError(errorHandler, "Non-existant style id referenced");
        continue;
      }
      mergeStylesIfNotPresent(styling.styles[sref].styleAttrs, styleattrs);
    }
  }
  function mergeStylesIfNotPresent(from_styles, into_styles) {
    for (var sname in from_styles) {
      if (!from_styles.hasOwnProperty(sname)) continue;
      if (sname in into_styles) continue;
      into_styles[sname] = from_styles[sname];
    }
  }

  /* TODO: validate style format at parsing */

  /*
   * ERROR HANDLING UTILITY FUNCTIONS
   * 
   */

  function reportInfo(errorHandler, msg) {
    if (errorHandler && errorHandler.info && errorHandler.info(msg)) throw msg;
  }
  function reportWarning(errorHandler, msg) {
    if (errorHandler && errorHandler.warn && errorHandler.warn(msg)) throw msg;
  }
  function reportError(errorHandler, msg) {
    if (errorHandler && errorHandler.error && errorHandler.error(msg)) throw msg;
  }
  function reportFatal(errorHandler, msg) {
    if (errorHandler && errorHandler.fatal) errorHandler.fatal(msg);
    throw msg;
  }

  /*
   * Binary search utility function
   * 
   * @typedef {Object} BinarySearchResult
   * @property {boolean} found Was an exact match found?
   * @property {number} index Position of the exact match or insert position
   * 
   * @returns {BinarySearchResult}
   */

  function indexOf(arr, searchval) {
    var min = 0;
    var max = arr.length - 1;
    var cur;
    while (min <= max) {
      cur = Math.floor((min + max) / 2);
      var curval = arr[cur];
      if (curval < searchval) {
        min = cur + 1;
      } else if (curval > searchval) {
        max = cur - 1;
      } else {
        return {
          found: true,
          index: cur
        };
      }
    }
    return {
      found: false,
      index: min
    };
  }
})( false ? 0 : exports, typeof sax === 'undefined' ? __webpack_require__(/*! sax */ "./node_modules/imsc/node_modules/sax/lib/sax.js") : sax, typeof imscNames === 'undefined' ? __webpack_require__(/*! ./names */ "./node_modules/imsc/src/main/js/names.js") : imscNames, typeof imscStyles === 'undefined' ? __webpack_require__(/*! ./styles */ "./node_modules/imsc/src/main/js/styles.js") : imscStyles, typeof imscUtils === 'undefined' ? __webpack_require__(/*! ./utils */ "./node_modules/imsc/src/main/js/utils.js") : imscUtils);

/***/ }),

/***/ "./node_modules/imsc/src/main/js/html.js":
/*!***********************************************!*\
  !*** ./node_modules/imsc/src/main/js/html.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.array.includes.js */ "./node_modules/core-js/modules/es.array.includes.js");
__webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
__webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
__webpack_require__(/*! core-js/modules/es.math.sign.js */ "./node_modules/core-js/modules/es.math.sign.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
__webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
__webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/core-js/modules/es.string.includes.js");
__webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
__webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module imscHTML
 */

var browserIsFirefox = /firefox/i.test(navigator.userAgent);
;
(function (imscHTML, imscNames, imscStyles) {
  /**
   * Function that maps <pre>smpte:background</pre> URIs to URLs resolving to image resource
   * @callback IMGResolver
   * @param {string} <pre>smpte:background</pre> URI
   * @return {string} PNG resource URL
   */

  /**
   * Renders an ISD object (returned by <pre>generateISD()</pre>) into a 
   * parent element, that must be attached to the DOM. The ISD will be rendered
   * into a child <pre>div</pre>
   * with heigh and width equal to the clientHeight and clientWidth of the element,
   * unless explicitly specified otherwise by the caller. Images URIs specified 
   * by <pre>smpte:background</pre> attributes are mapped to image resource URLs
   * by an <pre>imgResolver</pre> function. The latter takes the value of <code>smpte:background</code>
   * attribute and an <code>img</code> DOM element as input, and is expected to
   * set the <code>src</code> attribute of the <code>img</code> to the absolute URI of the image.
   * <pre>displayForcedOnlyMode</pre> sets the (boolean)
   * value of the IMSC1 displayForcedOnlyMode parameter. The function returns
   * an opaque object that should passed in <code>previousISDState</code> when this function
   * is called for the next ISD, otherwise <code>previousISDState</code> should be set to 
   * <code>null</code>.
   * 
   * @param {Object} isd ISD to be rendered
   * @param {Object} element Element into which the ISD is rendered
   * @param {?IMGResolver} imgResolver Resolve <pre>smpte:background</pre> URIs into URLs.
   * @param {?number} eheight Height (in pixel) of the child <div>div</div> or null 
   *                  to use clientHeight of the parent element
   * @param {?number} ewidth Width (in pixel) of the child <div>div</div> or null
   *                  to use clientWidth of the parent element
   * @param {?boolean} displayForcedOnlyMode Value of the IMSC1 displayForcedOnlyMode parameter,
   *                   or false if null         
   * @param {?module:imscUtils.ErrorHandler} errorHandler Error callback
   * @param {Object} previousISDState State saved during processing of the previous ISD, or null if initial call
   * @param {?boolean} enableRollUp Enables roll-up animations (see CEA 708)
   * @return {Object} ISD state to be provided when this funtion is called for the next ISD
   */

  imscHTML.render = function (isd, element, imgResolver, eheight, ewidth, displayForcedOnlyMode, errorHandler, previousISDState, enableRollUp) {
    /* maintain aspect ratio if specified */

    var height = eheight || element.clientHeight;
    var width = ewidth || element.clientWidth;
    if (isd.aspectRatio !== null) {
      var twidth = height * isd.aspectRatio;
      if (twidth > width) {
        height = Math.round(width / isd.aspectRatio);
      } else {
        width = twidth;
      }
    }
    var rootcontainer = document.createElement("div");
    rootcontainer.style.position = "relative";
    rootcontainer.style.width = width + "px";
    rootcontainer.style.height = height + "px";
    rootcontainer.style.margin = "auto";
    rootcontainer.style.top = 0;
    rootcontainer.style.bottom = 0;
    rootcontainer.style.left = 0;
    rootcontainer.style.right = 0;
    rootcontainer.style.zIndex = 0;
    var context = {
      h: height,
      w: width,
      regionH: null,
      regionW: null,
      imgResolver: imgResolver,
      displayForcedOnlyMode: displayForcedOnlyMode || false,
      isd: isd,
      errorHandler: errorHandler,
      previousISDState: previousISDState,
      enableRollUp: enableRollUp || false,
      currentISDState: {},
      flg: null,
      /* current fillLineGap value if active, null otherwise */
      lp: null,
      /* current linePadding value if active, null otherwise */
      mra: null,
      /* current multiRowAlign value if active, null otherwise */
      ipd: null,
      /* inline progression direction (lr, rl, tb) */
      bpd: null,
      /* block progression direction (lr, rl, tb) */
      ruby: null,
      /* is ruby present in a <p> */
      textEmphasis: null,
      /* is textEmphasis present in a <p> */
      rubyReserve: null /* is rubyReserve applicable to a <p> */
    };
    element.appendChild(rootcontainer);
    if ("contents" in isd) {
      for (var i = 0; i < isd.contents.length; i++) {
        processElement(context, rootcontainer, isd.contents[i], isd);
      }
    }
    return context.currentISDState;
  };
  function processElement(context, dom_parent, isd_element, isd_parent) {
    var e;
    if (isd_element.kind === 'region') {
      e = document.createElement("div");
      e.style.position = "absolute";
    } else if (isd_element.kind === 'body') {
      e = document.createElement("div");
    } else if (isd_element.kind === 'div') {
      e = document.createElement("div");
    } else if (isd_element.kind === 'image') {
      e = document.createElement("img");
      if (context.imgResolver !== null && isd_element.src !== null) {
        var uri = context.imgResolver(isd_element.src, e);
        if (uri) e.src = uri;
        e.height = context.regionH;
        e.width = context.regionW;
      }
    } else if (isd_element.kind === 'p') {
      e = document.createElement("p");
    } else if (isd_element.kind === 'span') {
      if (isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "container") {
        e = document.createElement("ruby");
        context.ruby = true;
      } else if (isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "base") {
        e = document.createElement("span"); // rb element is deprecated in HTML
      } else if (isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "text") {
        e = document.createElement("rt");
      } else if (isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "baseContainer") {
        e = document.createElement("rbc");
      } else if (isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "textContainer") {
        e = document.createElement("rtc");
      } else if (isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "delimiter") {
        /* ignore rp */

        return;
      } else {
        e = document.createElement("span");
      }

      //e.textContent = isd_element.text;
    } else if (isd_element.kind === 'br') {
      e = document.createElement("br");
    }
    if (!e) {
      reportError(context.errorHandler, "Error processing ISD element kind: " + isd_element.kind);
      return;
    }

    /* set language */

    if (isd_element.lang) {
      if (isd_element.kind === 'region' || isd_element.lang !== isd_parent.lang) {
        e.lang = isd_element.lang;
      }
    }

    /* add to parent */

    dom_parent.appendChild(e);

    /* override UA default margin */
    /* TODO: should apply to <p> only */

    e.style.margin = "0";

    /* determine ipd and bpd */

    if (isd_element.kind === "region") {
      var wdir = isd_element.styleAttrs[imscStyles.byName.writingMode.qname];
      if (wdir === "lrtb" || wdir === "lr") {
        context.ipd = "lr";
        context.bpd = "tb";
      } else if (wdir === "rltb" || wdir === "rl") {
        context.ipd = "rl";
        context.bpd = "tb";
      } else if (wdir === "tblr") {
        context.ipd = "tb";
        context.bpd = "lr";
      } else if (wdir === "tbrl" || wdir === "tb") {
        context.ipd = "tb";
        context.bpd = "rl";
      }
    } else if (isd_element.kind === "p" && context.bpd === "tb") {
      var pdir = isd_element.styleAttrs[imscStyles.byName.direction.qname];
      context.ipd = pdir === "ltr" ? "lr" : "rl";
    }

    /* tranform TTML styles to CSS styles */

    for (var i = 0; i < STYLING_MAP_DEFS.length; i++) {
      var sm = STYLING_MAP_DEFS[i];
      var attr = isd_element.styleAttrs[sm.qname];
      if (attr !== undefined && sm.map !== null) {
        sm.map(context, e, isd_element, attr);
      }
    }
    var proc_e = e;

    /* do we have linePadding ? */

    var lp = isd_element.styleAttrs[imscStyles.byName.linePadding.qname];
    if (lp && !lp.isZero()) {
      var plength = lp.toUsedLength(context.w, context.h);
      if (plength > 0) {
        /* apply padding to the <p> so that line padding does not cause line wraps */

        var padmeasure = Math.ceil(plength) + "px";
        if (context.bpd === "tb") {
          proc_e.style.paddingLeft = padmeasure;
          proc_e.style.paddingRight = padmeasure;
        } else {
          proc_e.style.paddingTop = padmeasure;
          proc_e.style.paddingBottom = padmeasure;
        }
        context.lp = lp;
      }
    }

    // do we have multiRowAlign?

    var mra = isd_element.styleAttrs[imscStyles.byName.multiRowAlign.qname];
    if (mra && mra !== "auto") {
      /* create inline block to handle multirowAlign */

      var s = document.createElement("span");
      s.style.display = "inline-block";
      s.style.textAlign = mra;
      e.appendChild(s);
      proc_e = s;
      context.mra = mra;
    }

    /* do we have rubyReserve? */

    var rr = isd_element.styleAttrs[imscStyles.byName.rubyReserve.qname];
    if (rr && rr[0] !== "none") {
      context.rubyReserve = rr;
    }

    /* remember we are filling line gaps */

    if (isd_element.styleAttrs[imscStyles.byName.fillLineGap.qname]) {
      context.flg = true;
    }
    if (isd_element.kind === "span" && isd_element.text) {
      var te = isd_element.styleAttrs[imscStyles.byName.textEmphasis.qname];
      if (te && te.style !== "none") {
        context.textEmphasis = true;
      }
      if (imscStyles.byName.textCombine.qname in isd_element.styleAttrs && isd_element.styleAttrs[imscStyles.byName.textCombine.qname] === "all") {
        /* ignore tate-chu-yoku since line break cannot happen within */
        e.textContent = isd_element.text;
        e._isd_element = isd_element;
        if (te) {
          applyTextEmphasis(context, e, isd_element, te);
        }
        ;
      } else {
        // wrap characters in spans to find the line wrap locations

        var cbuf = '';
        for (var j = 0; j < isd_element.text.length; j++) {
          cbuf += isd_element.text.charAt(j);
          var cc = isd_element.text.charCodeAt(j);
          if (cc < 0xD800 || cc > 0xDBFF || j === isd_element.text.length - 1) {
            /* wrap the character(s) in a span unless it is a high surrogate */

            var span = document.createElement("span");
            span.textContent = cbuf;

            /* apply textEmphasis */

            if (te) {
              applyTextEmphasis(context, span, isd_element, te);
            }
            ;
            e.appendChild(span);
            cbuf = '';

            //For the sake of merging these back together, record what isd element generated it.
            span._isd_element = isd_element;
          }
        }
      }
    }

    /* process the children of the ISD element */

    if ("contents" in isd_element) {
      for (var k = 0; k < isd_element.contents.length; k++) {
        processElement(context, proc_e, isd_element.contents[k], isd_element);
      }
    }

    /* list of lines */

    var linelist = [];

    /* paragraph processing */
    /* TODO: linePadding only supported for horizontal scripts */

    if (isd_element.kind === "p") {
      constructLineList(context, proc_e, linelist, null);

      /* apply rubyReserve */

      if (context.rubyReserve) {
        applyRubyReserve(linelist, context);
        context.rubyReserve = null;
      }

      /* apply tts:rubyPosition="outside" */

      if (context.ruby || context.rubyReserve) {
        applyRubyPosition(linelist, context);
        context.ruby = null;
      }

      /* apply text emphasis "outside" position */

      if (context.textEmphasis) {
        applyTextEmphasisOutside(linelist, context);
        context.textEmphasis = null;
      }

      /* insert line breaks for multirowalign */

      if (context.mra) {
        applyMultiRowAlign(linelist);
        context.mra = null;
      }

      /* add linepadding */

      if (context.lp) {
        applyLinePadding(linelist, context.lp.toUsedLength(context.w, context.h), context);
        context.lp = null;
      }
      mergeSpans(linelist, context); // The earlier we can do this the less processing there will be.

      /* fill line gaps linepadding */

      if (context.flg) {
        var par_edges = rect2edges(proc_e.getBoundingClientRect(), context);
        applyFillLineGap(linelist, par_edges.before, par_edges.after, context, proc_e);
        context.flg = null;
      }
    }

    /* region processing */

    if (isd_element.kind === "region") {
      /* perform roll up if needed */
      if (context.bpd === "tb" && context.enableRollUp && isd_element.contents.length > 0 && isd_element.styleAttrs[imscStyles.byName.displayAlign.qname] === 'after') {
        /* build line list */
        constructLineList(context, proc_e, linelist, null);

        /* horrible hack, perhaps default region id should be underscore everywhere? */

        var rid = isd_element.id === '' ? '_' : isd_element.id;
        var rb = new RegionPBuffer(rid, linelist);
        context.currentISDState[rb.id] = rb;
        if (context.previousISDState && rb.id in context.previousISDState && context.previousISDState[rb.id].plist.length > 0 && rb.plist.length > 1 && rb.plist[rb.plist.length - 2].text === context.previousISDState[rb.id].plist[context.previousISDState[rb.id].plist.length - 1].text) {
          var body_elem = e.firstElementChild;
          var h = rb.plist[rb.plist.length - 1].after - rb.plist[rb.plist.length - 1].before;
          body_elem.style.bottom = "-" + h + "px";
          body_elem.style.transition = "transform 0.4s";
          body_elem.style.position = "relative";
          body_elem.style.transform = "translateY(-" + h + "px)";
        }
      }
    }
  }
  function mergeSpans(lineList, context) {
    for (var i = 0; i < lineList.length; i++) {
      var line = lineList[i];
      for (var j = 1; j < line.elements.length;) {
        var previous = line.elements[j - 1];
        var span = line.elements[j];
        if (spanMerge(previous.node, span.node, context)) {
          //removed from DOM by spanMerge(), remove from the list too.
          line.elements.splice(j, 1);
          continue;
        } else {
          j++;
        }
      }
    }

    // Copy backgroundColor to each span so that fillLineGap will apply padding to elements with the right background
    var thisNode, ancestorBackgroundColor;
    var clearTheseBackgrounds = [];
    for (var l = 0; l < lineList.length; l++) {
      for (var el = 0; el < lineList[l].elements.length; el++) {
        thisNode = lineList[l].elements[el].node;
        ancestorBackgroundColor = getSpanAncestorColor(thisNode, clearTheseBackgrounds, false);
        if (ancestorBackgroundColor) {
          thisNode.style.backgroundColor = ancestorBackgroundColor;
        }
      }
    }
    for (var bi = 0; bi < clearTheseBackgrounds.length; bi++) {
      clearTheseBackgrounds[bi].style.backgroundColor = "";
    }
  }
  function getSpanAncestorColor(element, ancestorList, isAncestor) {
    if (element.style.backgroundColor) {
      if (isAncestor && !ancestorList.includes(element)) {
        ancestorList.push(element);
      }
      return element.style.backgroundColor;
    } else {
      if (element.parentElement.nodeName === "SPAN" || element.parentElement.nodeName === "RUBY" || element.parentElement.nodeName === "RBC" || element.parentElement.nodeName === "RTC" || element.parentElement.nodeName === "RT") {
        return getSpanAncestorColor(element.parentElement, ancestorList, true);
      }
    }
    return undefined;
  }
  function spanMerge(first, second, context) {
    if (first.tagName === "SPAN" && second.tagName === "SPAN" && first._isd_element === second._isd_element) {
      if (!first._isd_element) {
        /* we should never get here since every span should have a source ISD element */
        reportError(context.errorHandler, "Internal error: HTML span is not linked to a source element; cannot merge spans.");
        return false;
      }
      first.textContent += second.textContent;
      for (var i = 0; i < second.style.length; i++) {
        var styleName = second.style[i];
        if (styleName.indexOf("border") >= 0 || styleName.indexOf("padding") >= 0 || styleName.indexOf("margin") >= 0) {
          first.style[styleName] = second.style[styleName];
        }
      }
      second.parentElement.removeChild(second);
      return true;
    }
    return false;
  }
  function applyLinePadding(lineList, lp, context) {
    if (lineList === null) return;
    for (var i = 0; i < lineList.length; i++) {
      var l = lineList[i].elements.length;
      var pospadpxlen = Math.ceil(lp) + "px";
      var negpadpxlen = "-" + Math.ceil(lp) + "px";
      if (l !== 0) {
        var se = lineList[i].elements[lineList[i].start_elem];
        var ee = lineList[i].elements[lineList[i].end_elem];
        if (se === ee) {
          // Check to see if there's any background at all
          var elementBoundingRect = se.node.getBoundingClientRect();
          if (elementBoundingRect.width == 0 || elementBoundingRect.height == 0) {
            // There's no background on this line, move on.
            continue;
          }
        }

        // Start element
        if (context.ipd === "lr") {
          se.node.style.marginLeft = negpadpxlen;
          se.node.style.paddingLeft = pospadpxlen;
        } else if (context.ipd === "rl") {
          se.node.style.paddingRight = pospadpxlen;
          se.node.style.marginRight = negpadpxlen;
        } else if (context.ipd === "tb") {
          se.node.style.paddingTop = pospadpxlen;
          se.node.style.marginTop = negpadpxlen;
        }

        // End element
        if (context.ipd === "lr") {
          // Firefox has a problem with line-breaking when a negative margin is applied.
          // The positioning will be wrong but don't apply when on firefox.
          // https://bugzilla.mozilla.org/show_bug.cgi?id=1502610
          if (!browserIsFirefox) {
            ee.node.style.marginRight = negpadpxlen;
          }
          ee.node.style.paddingRight = pospadpxlen;
        } else if (context.ipd === "rl") {
          ee.node.style.paddingLeft = pospadpxlen;
          if (!browserIsFirefox) {
            ee.node.style.marginLeft = negpadpxlen;
          }
        } else if (context.ipd === "tb") {
          ee.node.style.paddingBottom = pospadpxlen;
          ee.node.style.marginBottom = negpadpxlen;
        }
      }
    }
  }
  function applyMultiRowAlign(lineList) {
    /* apply an explicit br to all but the last line */

    for (var i = 0; i < lineList.length - 1; i++) {
      var l = lineList[i].elements.length;
      if (l !== 0 && lineList[i].br === false) {
        var br = document.createElement("br");
        var lastnode = lineList[i].elements[l - 1].node;
        lastnode.parentElement.insertBefore(br, lastnode.nextSibling);
      }
    }
  }
  function applyTextEmphasisOutside(lineList, context) {
    /* supports "outside" only */

    for (var i = 0; i < lineList.length; i++) {
      for (var j = 0; j < lineList[i].te.length; j++) {
        /* skip if position already set */

        if (lineList[i].te[j].style[TEXTEMPHASISPOSITION_PROP] && lineList[i].te[j].style[TEXTEMPHASISPOSITION_PROP] !== "none") continue;
        var pos;
        if (context.bpd === "tb") {
          pos = i === 0 ? "left over" : "left under";
        } else {
          if (context.bpd === "rl") {
            pos = i === 0 ? "right under" : "left under";
          } else {
            pos = i === 0 ? "left under" : "right under";
          }
        }
        lineList[i].te[j].style[TEXTEMPHASISPOSITION_PROP] = pos;
      }
    }
  }
  function applyRubyPosition(lineList, context) {
    for (var i = 0; i < lineList.length; i++) {
      for (var j = 0; j < lineList[i].rbc.length; j++) {
        /* skip if ruby-position already set */

        if (lineList[i].rbc[j].style[RUBYPOSITION_PROP]) continue;
        var pos;
        if (RUBYPOSITION_ISWK) {
          /* WebKit exception */

          pos = i === 0 ? "before" : "after";
        } else if (context.bpd === "tb") {
          pos = i === 0 ? "over" : "under";
        } else {
          if (context.bpd === "rl") {
            pos = i === 0 ? "over" : "under";
          } else {
            pos = i === 0 ? "under" : "over";
          }
        }
        lineList[i].rbc[j].style[RUBYPOSITION_PROP] = pos;
      }
    }
  }
  function applyRubyReserve(lineList, context) {
    for (var i = 0; i < lineList.length; i++) {
      var ruby = document.createElement("ruby");
      var rb = document.createElement("span"); // rb element is deprecated in HTML
      rb.textContent = "\u200B";
      ruby.appendChild(rb);
      var rt1;
      var rt2;
      var fs = context.rubyReserve[1].toUsedLength(context.w, context.h) + "px";
      if (context.rubyReserve[0] === "both" || context.rubyReserve[0] === "outside" && lineList.length == 1) {
        rt1 = document.createElement("rtc");
        rt1.style[RUBYPOSITION_PROP] = RUBYPOSITION_ISWK ? "after" : "under";
        rt1.textContent = "\u200B";
        rt1.style.fontSize = fs;
        rt2 = document.createElement("rtc");
        rt2.style[RUBYPOSITION_PROP] = RUBYPOSITION_ISWK ? "before" : "over";
        rt2.textContent = "\u200B";
        rt2.style.fontSize = fs;
        ruby.appendChild(rt1);
        ruby.appendChild(rt2);
      } else {
        rt1 = document.createElement("rtc");
        rt1.textContent = "\u200B";
        rt1.style.fontSize = fs;
        var pos;
        if (context.rubyReserve[0] === "after" || context.rubyReserve[0] === "outside" && i > 0) {
          pos = RUBYPOSITION_ISWK ? "after" : context.bpd === "tb" || context.bpd === "rl" ? "under" : "over";
        } else {
          pos = RUBYPOSITION_ISWK ? "before" : context.bpd === "tb" || context.bpd === "rl" ? "over" : "under";
        }
        rt1.style[RUBYPOSITION_PROP] = pos;
        ruby.appendChild(rt1);
      }

      /* add in front of the first ruby element of the line, if it exists */

      var sib = null;
      for (var j = 0; j < lineList[i].rbc.length; j++) {
        if (lineList[i].rbc[j].localName === 'ruby') {
          sib = lineList[i].rbc[j];

          /* copy specified style properties from the sibling ruby container */

          for (var k = 0; k < sib.style.length; k++) {
            ruby.style.setProperty(sib.style.item(k), sib.style.getPropertyValue(sib.style.item(k)));
          }
          break;
        }
      }

      /* otherwise add before first span */

      sib = sib || lineList[i].elements[0].node;
      sib.parentElement.insertBefore(ruby, sib);
    }
  }
  function applyFillLineGap(lineList, par_before, par_after, context, element) {
    /* positive for BPD = lr and tb, negative for BPD = rl */
    var s = Math.sign(par_after - par_before);
    for (var i = 0; i <= lineList.length; i++) {
      /* compute frontier between lines */

      var frontier;
      if (i === 0) {
        frontier = Math.round(par_before);
      } else if (i === lineList.length) {
        frontier = Math.round(par_after);
      } else {
        frontier = Math.round((lineList[i - 1].after + lineList[i].before) / 2);
      }
      var padding;
      var l, thisNode;

      /* before line */
      if (i > 0) {
        if (lineList[i - 1]) {
          for (l = 0; l < lineList[i - 1].elements.length; l++) {
            thisNode = lineList[i - 1].elements[l];
            padding = s * (frontier - thisNode.after) + "px";
            if (context.bpd === "lr") {
              thisNode.node.style.paddingRight = padding;
            } else if (context.bpd === "rl") {
              thisNode.node.style.paddingLeft = padding;
            } else if (context.bpd === "tb") {
              thisNode.node.style.paddingBottom = padding;
            }
          }
        }
      }

      /* after line */
      if (i < lineList.length) {
        for (l = 0; l < lineList[i].elements.length; l++) {
          thisNode = lineList[i].elements[l];
          padding = s * (thisNode.before - frontier) + "px";
          if (context.bpd === "lr") {
            thisNode.node.style.paddingLeft = padding;
          } else if (context.bpd === "rl") {
            thisNode.node.style.paddingRight = padding;
          } else if (context.bpd === "tb") {
            thisNode.node.style.paddingTop = padding;
          }
        }
      }
    }
  }
  function RegionPBuffer(id, lineList) {
    this.id = id;
    this.plist = lineList;
  }
  function rect2edges(rect, context) {
    var edges = {
      before: null,
      after: null,
      start: null,
      end: null
    };
    if (context.bpd === "tb") {
      edges.before = rect.top;
      edges.after = rect.bottom;
      if (context.ipd === "lr") {
        edges.start = rect.left;
        edges.end = rect.right;
      } else {
        edges.start = rect.right;
        edges.end = rect.left;
      }
    } else if (context.bpd === "lr") {
      edges.before = rect.left;
      edges.after = rect.right;
      edges.start = rect.top;
      edges.end = rect.bottom;
    } else if (context.bpd === "rl") {
      edges.before = rect.right;
      edges.after = rect.left;
      edges.start = rect.top;
      edges.end = rect.bottom;
    }
    return edges;
  }
  function constructLineList(context, element, llist, bgcolor) {
    if (element.localName === "rt" || element.localName === "rtc") {
      /* skip ruby annotations */

      return;
    }
    var curbgcolor = element.style.backgroundColor || bgcolor;
    if (element.childElementCount === 0) {
      if (element.localName === 'span' || element.localName === 'rb') {
        var r = element.getBoundingClientRect();
        var edges = rect2edges(r, context);
        if (llist.length === 0 || !isSameLine(edges.before, edges.after, llist[llist.length - 1].before, llist[llist.length - 1].after)) {
          llist.push({
            before: edges.before,
            after: edges.after,
            start: edges.start,
            end: edges.end,
            start_elem: 0,
            end_elem: 0,
            elements: [],
            rbc: [],
            te: [],
            text: "",
            br: false
          });
        } else {
          /* positive for BPD = lr and tb, negative for BPD = rl */
          var bpd_dir = Math.sign(edges.after - edges.before);

          /* positive for IPD = lr and tb, negative for IPD = rl */
          var ipd_dir = Math.sign(edges.end - edges.start);

          /* check if the line height has increased */

          if (bpd_dir * (edges.before - llist[llist.length - 1].before) < 0) {
            llist[llist.length - 1].before = edges.before;
          }
          if (bpd_dir * (edges.after - llist[llist.length - 1].after) > 0) {
            llist[llist.length - 1].after = edges.after;
          }
          if (ipd_dir * (edges.start - llist[llist.length - 1].start) < 0) {
            llist[llist.length - 1].start = edges.start;
            llist[llist.length - 1].start_elem = llist[llist.length - 1].elements.length;
          }
          if (ipd_dir * (edges.end - llist[llist.length - 1].end) > 0) {
            llist[llist.length - 1].end = edges.end;
            llist[llist.length - 1].end_elem = llist[llist.length - 1].elements.length;
          }
        }
        llist[llist.length - 1].text += element.textContent;
        llist[llist.length - 1].elements.push({
          node: element,
          bgcolor: curbgcolor,
          before: edges.before,
          after: edges.after
        });
      } else if (element.localName === 'br' && llist.length !== 0) {
        llist[llist.length - 1].br = true;
      }
    } else {
      var child = element.firstChild;
      while (child) {
        if (child.nodeType === Node.ELEMENT_NODE) {
          constructLineList(context, child, llist, curbgcolor);
          if (child.localName === 'ruby' || child.localName === 'rtc') {
            /* remember non-empty ruby and rtc elements so that tts:rubyPosition can be applied */

            if (llist.length > 0) {
              llist[llist.length - 1].rbc.push(child);
            }
          } else if (child.localName === 'span' && child.style[TEXTEMPHASISSTYLE_PROP] && child.style[TEXTEMPHASISSTYLE_PROP] !== "none") {
            /* remember non-empty span elements with textEmphasis */

            if (llist.length > 0) {
              llist[llist.length - 1].te.push(child);
            }
          }
        }
        child = child.nextSibling;
      }
    }
  }
  function isSameLine(before1, after1, before2, after2) {
    return after1 < after2 && before1 > before2 || after2 <= after1 && before2 >= before1;
  }
  function applyTextEmphasis(context, dom_element, isd_element, attr) {
    /* ignore color (not used in IMSC 1.1) */

    if (attr.style === "none") {
      /* text-emphasis is not inherited and the default is none, so nothing to do */

      return;
    } else if (attr.style === "auto") {
      dom_element.style[TEXTEMPHASISSTYLE_PROP] = "filled";
    } else {
      dom_element.style[TEXTEMPHASISSTYLE_PROP] = attr.style + " " + attr.symbol;
    }

    /* ignore "outside" position (set in postprocessing) */

    if (attr.position === "before" || attr.position === "after") {
      var pos;
      if (context.bpd === "tb") {
        pos = attr.position === "before" ? "left over" : "left under";
      } else {
        if (context.bpd === "rl") {
          pos = attr.position === "before" ? "right under" : "left under";
        } else {
          pos = attr.position === "before" ? "left under" : "right under";
        }
      }
      dom_element.style[TEXTEMPHASISPOSITION_PROP] = pos;
    }
  }
  function HTMLStylingMapDefinition(qName, mapFunc) {
    this.qname = qName;
    this.map = mapFunc;
  }
  var STYLING_MAP_DEFS = [new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling backgroundColor", function (context, dom_element, isd_element, attr) {
    /* skip if transparent */
    if (attr[3] === 0) return;
    dom_element.style.backgroundColor = "rgba(" + attr[0].toString() + "," + attr[1].toString() + "," + attr[2].toString() + "," + (attr[3] / 255).toString() + ")";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling color", function (context, dom_element, isd_element, attr) {
    dom_element.style.color = "rgba(" + attr[0].toString() + "," + attr[1].toString() + "," + attr[2].toString() + "," + (attr[3] / 255).toString() + ")";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling direction", function (context, dom_element, isd_element, attr) {
    dom_element.style.direction = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling display", function (context, dom_element, isd_element, attr) {}), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling displayAlign", function (context, dom_element, isd_element, attr) {
    /* see https://css-tricks.com/snippets/css/a-guide-to-flexbox/ */

    /* TODO: is this affected by writing direction? */

    dom_element.style.display = "flex";
    dom_element.style.flexDirection = "column";
    if (attr === "before") {
      dom_element.style.justifyContent = "flex-start";
    } else if (attr === "center") {
      dom_element.style.justifyContent = "center";
    } else if (attr === "after") {
      dom_element.style.justifyContent = "flex-end";
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling extent", function (context, dom_element, isd_element, attr) {
    /* TODO: this is super ugly */

    context.regionH = attr.h.toUsedLength(context.w, context.h);
    context.regionW = attr.w.toUsedLength(context.w, context.h);

    /* 
     * CSS height/width are measured against the content rectangle,
     * whereas TTML height/width include padding
     */

    var hdelta = 0;
    var wdelta = 0;
    var p = isd_element.styleAttrs["http://www.w3.org/ns/ttml#styling padding"];
    if (!p) {

      /* error */
    } else {
      hdelta = p[0].toUsedLength(context.w, context.h) + p[2].toUsedLength(context.w, context.h);
      wdelta = p[1].toUsedLength(context.w, context.h) + p[3].toUsedLength(context.w, context.h);
    }
    dom_element.style.height = context.regionH - hdelta + "px";
    dom_element.style.width = context.regionW - wdelta + "px";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling fontFamily", function (context, dom_element, isd_element, attr) {
    var rslt = [];

    /* per IMSC1 */

    for (var i = 0; i < attr.length; i++) {
      attr[i] = attr[i].trim();
      if (attr[i] === "monospaceSerif") {
        rslt.push("Courier New");
        rslt.push('"Liberation Mono"');
        rslt.push("Courier");
        rslt.push("monospace");
      } else if (attr[i] === "proportionalSansSerif") {
        rslt.push("Arial");
        rslt.push("Helvetica");
        rslt.push('"Liberation Sans"');
        rslt.push("sans-serif");
      } else if (attr[i] === "monospace") {
        rslt.push("monospace");
      } else if (attr[i] === "sansSerif") {
        rslt.push("sans-serif");
      } else if (attr[i] === "serif") {
        rslt.push("serif");
      } else if (attr[i] === "monospaceSansSerif") {
        rslt.push("Consolas");
        rslt.push("monospace");
      } else if (attr[i] === "proportionalSerif") {
        rslt.push("serif");
      } else {
        rslt.push(attr[i]);
      }
    }

    // prune later duplicates we may have inserted 
    if (rslt.length > 0) {
      var unique = [rslt[0]];
      for (var fi = 1; fi < rslt.length; fi++) {
        if (unique.indexOf(rslt[fi]) == -1) {
          unique.push(rslt[fi]);
        }
      }
      rslt = unique;
    }
    dom_element.style.fontFamily = rslt.join(",");
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling shear", function (context, dom_element, isd_element, attr) {
    /* return immediately if tts:shear is 0% since CSS transforms are not inherited*/

    if (attr === 0) return;
    var angle = attr * -0.9;

    /* context.bpd is needed since writing mode is not inherited and sets the inline progression */

    if (context.bpd === "tb") {
      dom_element.style.transform = "skewX(" + angle + "deg)";
    } else {
      dom_element.style.transform = "skewY(" + angle + "deg)";
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling fontSize", function (context, dom_element, isd_element, attr) {
    dom_element.style.fontSize = attr.toUsedLength(context.w, context.h) + "px";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling fontStyle", function (context, dom_element, isd_element, attr) {
    dom_element.style.fontStyle = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling fontWeight", function (context, dom_element, isd_element, attr) {
    dom_element.style.fontWeight = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling lineHeight", function (context, dom_element, isd_element, attr) {
    if (attr === "normal") {
      dom_element.style.lineHeight = "normal";
    } else {
      dom_element.style.lineHeight = attr.toUsedLength(context.w, context.h) + "px";
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling opacity", function (context, dom_element, isd_element, attr) {
    dom_element.style.opacity = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling origin", function (context, dom_element, isd_element, attr) {
    dom_element.style.top = attr.h.toUsedLength(context.w, context.h) + "px";
    dom_element.style.left = attr.w.toUsedLength(context.w, context.h) + "px";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling overflow", function (context, dom_element, isd_element, attr) {
    dom_element.style.overflow = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling padding", function (context, dom_element, isd_element, attr) {
    /* attr: top,left,bottom,right*/

    /* style: top right bottom left*/

    var rslt = [];
    rslt[0] = attr[0].toUsedLength(context.w, context.h) + "px";
    rslt[1] = attr[3].toUsedLength(context.w, context.h) + "px";
    rslt[2] = attr[2].toUsedLength(context.w, context.h) + "px";
    rslt[3] = attr[1].toUsedLength(context.w, context.h) + "px";
    dom_element.style.padding = rslt.join(" ");
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling position", function (context, dom_element, isd_element, attr) {
    dom_element.style.top = attr.h.toUsedLength(context.w, context.h) + "px";
    dom_element.style.left = attr.w.toUsedLength(context.w, context.h) + "px";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling rubyAlign", function (context, dom_element, isd_element, attr) {
    dom_element.style.rubyAlign = attr === "spaceAround" ? "space-around" : "center";
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling rubyPosition", function (context, dom_element, isd_element, attr) {
    /* skip if "outside", which is handled by applyRubyPosition() */

    if (attr === "before" || attr === "after") {
      var pos;
      if (RUBYPOSITION_ISWK) {
        /* WebKit exception */

        pos = attr;
      } else if (context.bpd === "tb") {
        pos = attr === "before" ? "over" : "under";
      } else {
        if (context.bpd === "rl") {
          pos = attr === "before" ? "over" : "under";
        } else {
          pos = attr === "before" ? "under" : "over";
        }
      }

      /* apply position to the parent dom_element, i.e. ruby or rtc */

      dom_element.parentElement.style[RUBYPOSITION_PROP] = pos;
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling showBackground", null), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling textAlign", function (context, dom_element, isd_element, attr) {
    var ta;

    /* handle UAs that do not understand start or end */

    if (attr === "start") {
      ta = context.ipd === "rl" ? "right" : "left";
    } else if (attr === "end") {
      ta = context.ipd === "rl" ? "left" : "right";
    } else {
      ta = attr;
    }
    dom_element.style.textAlign = ta;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling textDecoration", function (context, dom_element, isd_element, attr) {
    dom_element.style.textDecoration = attr.join(" ").replace("lineThrough", "line-through");
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling textOutline", function (context, dom_element, isd_element, attr) {

    /* defer to tts:textShadow */
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling textShadow", function (context, dom_element, isd_element, attr) {
    var txto = isd_element.styleAttrs[imscStyles.byName.textOutline.qname];
    if (attr === "none" && txto === "none") {
      dom_element.style.textShadow = "";
    } else {
      var s = [];
      if (txto !== "none") {
        /* emulate text outline */

        var to_color = "rgba(" + txto.color[0].toString() + "," + txto.color[1].toString() + "," + txto.color[2].toString() + "," + (txto.color[3] / 255).toString() + ")";
        s.push("1px 1px 1px " + to_color);
        s.push("-1px 1px 1px " + to_color);
        s.push("1px -1px 1px " + to_color);
        s.push("-1px -1px 1px " + to_color);
      }

      /* add text shadow */

      if (attr !== "none") {
        for (var i = 0; i < attr.length; i++) {
          s.push(attr[i].x_off.toUsedLength(context.w, context.h) + "px " + attr[i].y_off.toUsedLength(context.w, context.h) + "px " + attr[i].b_radius.toUsedLength(context.w, context.h) + "px " + "rgba(" + attr[i].color[0].toString() + "," + attr[i].color[1].toString() + "," + attr[i].color[2].toString() + "," + (attr[i].color[3] / 255).toString() + ")");
        }
      }
      dom_element.style.textShadow = s.join(",");
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling textCombine", function (context, dom_element, isd_element, attr) {
    dom_element.style.textCombineUpright = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling textEmphasis", function (context, dom_element, isd_element, attr) {

    /* applied as part of HTML document construction */
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling unicodeBidi", function (context, dom_element, isd_element, attr) {
    var ub;
    if (attr === 'bidiOverride') {
      ub = "bidi-override";
    } else {
      ub = attr;
    }
    dom_element.style.unicodeBidi = ub;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling visibility", function (context, dom_element, isd_element, attr) {
    dom_element.style.visibility = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling wrapOption", function (context, dom_element, isd_element, attr) {
    if (attr === "wrap") {
      if (isd_element.space === "preserve") {
        dom_element.style.whiteSpace = "pre-wrap";
      } else {
        dom_element.style.whiteSpace = "normal";
      }
    } else {
      if (isd_element.space === "preserve") {
        dom_element.style.whiteSpace = "pre";
      } else {
        dom_element.style.whiteSpace = "noWrap";
      }
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling writingMode", function (context, dom_element, isd_element, attr) {
    var wm;
    if (attr === "lrtb" || attr === "lr") {
      dom_element.style.writingMode = "horizontal-tb";
    } else if (attr === "rltb" || attr === "rl") {
      dom_element.style.writingMode = "horizontal-tb";
    } else if (attr === "tblr") {
      dom_element.style.writingMode = "vertical-lr";
    } else if (attr === "tbrl" || attr === "tb") {
      dom_element.style.writingMode = "vertical-rl";
    }
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml#styling zIndex", function (context, dom_element, isd_element, attr) {
    dom_element.style.zIndex = attr;
  }), new HTMLStylingMapDefinition("http://www.w3.org/ns/ttml/profile/imsc1#styling forcedDisplay", function (context, dom_element, isd_element, attr) {
    if (context.displayForcedOnlyMode && attr === false) {
      dom_element.style.visibility = "hidden";
    }
  })];
  var STYLMAP_BY_QNAME = {};
  for (var i = 0; i < STYLING_MAP_DEFS.length; i++) {
    STYLMAP_BY_QNAME[STYLING_MAP_DEFS[i].qname] = STYLING_MAP_DEFS[i];
  }

  /* CSS property names */

  var RUBYPOSITION_ISWK = "webkitRubyPosition" in window.getComputedStyle(document.documentElement);
  var RUBYPOSITION_PROP = RUBYPOSITION_ISWK ? "webkitRubyPosition" : "rubyPosition";
  var TEXTEMPHASISSTYLE_PROP = "webkitTextEmphasisStyle" in window.getComputedStyle(document.documentElement) ? "webkitTextEmphasisStyle" : "textEmphasisStyle";
  var TEXTEMPHASISPOSITION_PROP = "webkitTextEmphasisPosition" in window.getComputedStyle(document.documentElement) ? "webkitTextEmphasisPosition" : "textEmphasisPosition";

  /* error utilities */

  function reportError(errorHandler, msg) {
    if (errorHandler && errorHandler.error && errorHandler.error(msg)) throw msg;
  }
})( false ? 0 : exports, typeof imscNames === 'undefined' ? __webpack_require__(/*! ./names */ "./node_modules/imsc/src/main/js/names.js") : imscNames, typeof imscStyles === 'undefined' ? __webpack_require__(/*! ./styles */ "./node_modules/imsc/src/main/js/styles.js") : imscStyles, typeof imscUtils === 'undefined' ? __webpack_require__(/*! ./utils */ "./node_modules/imsc/src/main/js/utils.js") : imscUtils);

/***/ }),

/***/ "./node_modules/imsc/src/main/js/isd.js":
/*!**********************************************!*\
  !*** ./node_modules/imsc/src/main/js/isd.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
__webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
__webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module imscISD
 */

;
(function (imscISD, imscNames, imscStyles, imscUtils) {
  // wrapper for non-node envs

  /** 
   * Creates a canonical representation of an IMSC1 document returned by <pre>imscDoc.fromXML()</pre>
   * at a given absolute offset in seconds. This offset does not have to be one of the values returned
   * by <pre>getMediaTimeEvents()</pre>.
   * 
   * @param {Object} tt IMSC1 document
   * @param {number} offset Absolute offset (in seconds)
   * @param {?module:imscUtils.ErrorHandler} errorHandler Error callback
   * @returns {Object} Opaque in-memory representation of an ISD
   */

  imscISD.generateISD = function (tt, offset, errorHandler) {
    /* TODO check for tt and offset validity */

    /* create the ISD object from the IMSC1 doc */

    var isd = new ISD(tt);

    /* context */

    var context = {

      /*rubyfs: []*/ /* font size of the nearest textContainer or container */
    };

    /* Filter body contents - Only process what we need within the offset and discard regions not applicable to the content */
    var body = {};
    var activeRegions = {};

    /* gather any regions that might have showBackground="always" and show a background */
    var initialShowBackground = tt.head.styling.initials[imscStyles.byName.showBackground.qname];
    var initialbackgroundColor = tt.head.styling.initials[imscStyles.byName.backgroundColor.qname];
    for (var layout_child in tt.head.layout.regions) {
      if (tt.head.layout.regions.hasOwnProperty(layout_child)) {
        var region = tt.head.layout.regions[layout_child];
        var showBackground = region.styleAttrs[imscStyles.byName.showBackground.qname] || initialShowBackground;
        var backgroundColor = region.styleAttrs[imscStyles.byName.backgroundColor.qname] || initialbackgroundColor;
        activeRegions[region.id] = (showBackground === 'always' || showBackground === undefined) && backgroundColor !== undefined && !(offset < region.begin || offset >= region.end);
      }
    }

    /* If the body specifies a region, catch it, since no filtered content will */
    /* likely specify the region. */
    if (tt.body && tt.body.regionID) {
      activeRegions[tt.body.regionID] = true;
    }
    function filter(offset, element) {
      function offsetFilter(element) {
        return !(offset < element.begin || offset >= element.end);
      }
      if (element.contents) {
        var clone = {};
        for (var prop in element) {
          if (element.hasOwnProperty(prop)) {
            clone[prop] = element[prop];
          }
        }
        clone.contents = [];
        element.contents.filter(offsetFilter).forEach(function (el) {
          var filteredElement = filter(offset, el);
          if (filteredElement.regionID) {
            activeRegions[filteredElement.regionID] = true;
          }
          if (filteredElement !== null) {
            clone.contents.push(filteredElement);
          }
        });
        return clone;
      } else {
        return element;
      }
    }
    if (tt.body !== null) {
      body = filter(offset, tt.body);
    } else {
      body = null;
    }

    /* rewritten TTML will always have a default - this covers it. because the region is defaulted to "" */
    if (activeRegions[""] !== undefined) {
      activeRegions[""] = true;
    }

    /* process regions */
    for (var regionID in activeRegions) {
      if (activeRegions[regionID]) {
        /* post-order traversal of the body tree per [construct intermediate document] */

        var c = isdProcessContentElement(tt, offset, tt.head.layout.regions[regionID], body, null, '', tt.head.layout.regions[regionID], errorHandler, context);
        if (c !== null) {
          /* add the region to the ISD */

          isd.contents.push(c.element);
        }
      }
    }
    return isd;
  };

  /* set of styles not applicable to ruby container spans */

  var _rcs_na_styles = [imscStyles.byName.color.qname, imscStyles.byName.textCombine.qname, imscStyles.byName.textDecoration.qname, imscStyles.byName.textEmphasis.qname, imscStyles.byName.textOutline.qname, imscStyles.byName.textShadow.qname];
  function isdProcessContentElement(doc, offset, region, body, parent, inherited_region_id, elem, errorHandler, context) {
    /* prune if temporally inactive */

    if (offset < elem.begin || offset >= elem.end) {
      return null;
    }

    /* 
     * set the associated region as specified by the regionID attribute, or the 
     * inherited associated region otherwise
     */

    var associated_region_id = 'regionID' in elem && elem.regionID !== '' ? elem.regionID : inherited_region_id;

    /* prune the element if either:
     * - the element is not terminal and the associated region is neither the default
     *   region nor the parent region (this allows children to be associated with a 
     *   region later on)
     * - the element is terminal and the associated region is not the parent region
     */

    /* TODO: improve detection of terminal elements since <region> has no contents */

    if (parent !== null /* are we in the region element */ && associated_region_id !== region.id && (!('contents' in elem) || 'contents' in elem && elem.contents.length === 0 || associated_region_id !== '')) return null;

    /* create an ISD element, including applying specified styles */

    var isd_element = new ISDContentElement(elem);

    /* apply set (animation) styling */

    if ("sets" in elem) {
      for (var i = 0; i < elem.sets.length; i++) {
        if (offset < elem.sets[i].begin || offset >= elem.sets[i].end) continue;
        isd_element.styleAttrs[elem.sets[i].qname] = elem.sets[i].value;
      }
    }

    /* 
     * keep track of specified styling attributes so that we
     * can compute them later
     */

    var spec_attr = {};
    for (var qname in isd_element.styleAttrs) {
      if (!isd_element.styleAttrs.hasOwnProperty(qname)) continue;
      spec_attr[qname] = true;

      /* special rule for tts:writingMode (section 7.29.1 of XSL)
       * direction is set consistently with writingMode only
       * if writingMode sets inline-direction to LTR or RTL  
       */

      if (isd_element.kind === 'region' && qname === imscStyles.byName.writingMode.qname && !(imscStyles.byName.direction.qname in isd_element.styleAttrs)) {
        var wm = isd_element.styleAttrs[qname];
        if (wm === "lrtb" || wm === "lr") {
          isd_element.styleAttrs[imscStyles.byName.direction.qname] = "ltr";
        } else if (wm === "rltb" || wm === "rl") {
          isd_element.styleAttrs[imscStyles.byName.direction.qname] = "rtl";
        }
      }
    }

    /* inherited styling */

    if (parent !== null) {
      for (var j = 0; j < imscStyles.all.length; j++) {
        var sa = imscStyles.all[j];

        /* textDecoration has special inheritance rules */

        if (sa.qname === imscStyles.byName.textDecoration.qname) {
          /* handle both textDecoration inheritance and specification */

          var ps = parent.styleAttrs[sa.qname];
          var es = isd_element.styleAttrs[sa.qname];
          var outs = [];
          if (es === undefined) {
            outs = ps;
          } else if (es.indexOf("none") === -1) {
            if (es.indexOf("noUnderline") === -1 && ps.indexOf("underline") !== -1 || es.indexOf("underline") !== -1) {
              outs.push("underline");
            }
            if (es.indexOf("noLineThrough") === -1 && ps.indexOf("lineThrough") !== -1 || es.indexOf("lineThrough") !== -1) {
              outs.push("lineThrough");
            }
            if (es.indexOf("noOverline") === -1 && ps.indexOf("overline") !== -1 || es.indexOf("overline") !== -1) {
              outs.push("overline");
            }
          } else {
            outs.push("none");
          }
          isd_element.styleAttrs[sa.qname] = outs;
        } else if (sa.qname === imscStyles.byName.fontSize.qname && !(sa.qname in isd_element.styleAttrs) && isd_element.kind === 'span' && isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "textContainer") {
          /* special inheritance rule for ruby text container font size */

          var ruby_fs = parent.styleAttrs[imscStyles.byName.fontSize.qname];
          isd_element.styleAttrs[sa.qname] = new imscUtils.ComputedLength(0.5 * ruby_fs.rw, 0.5 * ruby_fs.rh);
        } else if (sa.qname === imscStyles.byName.fontSize.qname && !(sa.qname in isd_element.styleAttrs) && isd_element.kind === 'span' && isd_element.styleAttrs[imscStyles.byName.ruby.qname] === "text") {
          /* special inheritance rule for ruby text font size */

          var parent_fs = parent.styleAttrs[imscStyles.byName.fontSize.qname];
          if (parent.styleAttrs[imscStyles.byName.ruby.qname] === "textContainer") {
            isd_element.styleAttrs[sa.qname] = parent_fs;
          } else {
            isd_element.styleAttrs[sa.qname] = new imscUtils.ComputedLength(0.5 * parent_fs.rw, 0.5 * parent_fs.rh);
          }
        } else if (sa.inherit && sa.qname in parent.styleAttrs && !(sa.qname in isd_element.styleAttrs)) {
          isd_element.styleAttrs[sa.qname] = parent.styleAttrs[sa.qname];
        }
      }
    }

    /* initial value styling */

    for (var k = 0; k < imscStyles.all.length; k++) {
      var ivs = imscStyles.all[k];

      /* skip if value is already specified */

      if (ivs.qname in isd_element.styleAttrs) continue;

      /* skip tts:position if tts:origin is specified */

      if (ivs.qname === imscStyles.byName.position.qname && imscStyles.byName.origin.qname in isd_element.styleAttrs) continue;

      /* skip tts:origin if tts:position is specified */

      if (ivs.qname === imscStyles.byName.origin.qname && imscStyles.byName.position.qname in isd_element.styleAttrs) continue;

      /* determine initial value */

      var iv = doc.head.styling.initials[ivs.qname] || ivs.initial;
      if (iv === null) {
        /* skip processing if no initial value defined */

        continue;
      }

      /* apply initial value to elements other than region only if non-inherited */

      if (isd_element.kind === 'region' || ivs.inherit === false && iv !== null) {
        var piv = ivs.parse(iv);
        if (piv !== null) {
          isd_element.styleAttrs[ivs.qname] = piv;

          /* keep track of the style as specified */

          spec_attr[ivs.qname] = true;
        } else {
          reportError(errorHandler, "Invalid initial value for '" + ivs.qname + "' on element '" + isd_element.kind);
        }
      }
    }

    /* compute styles (only for non-inherited styles) */
    /* TODO: get rid of spec_attr */

    for (var z = 0; z < imscStyles.all.length; z++) {
      var cs = imscStyles.all[z];
      if (!(cs.qname in spec_attr)) continue;
      if (cs.compute !== null) {
        var cstyle = cs.compute(/*doc, parent, element, attr, context*/
        doc, parent, isd_element, isd_element.styleAttrs[cs.qname], context);
        if (cstyle !== null) {
          isd_element.styleAttrs[cs.qname] = cstyle;
        } else {
          /* if the style cannot be computed, replace it by its initial value */

          isd_element.styleAttrs[cs.qname] = cs.compute(/*doc, parent, element, attr, context*/
          doc, parent, isd_element, cs.parse(cs.initial), context);
          reportError(errorHandler, "Style '" + cs.qname + "' on element '" + isd_element.kind + "' cannot be computed");
        }
      }
    }

    /* prune if tts:display is none */

    if (isd_element.styleAttrs[imscStyles.byName.display.qname] === "none") return null;

    /* process contents of the element */

    var contents = null;
    if (parent === null) {
      /* we are processing the region */

      if (body === null) {
        /* if there is no body, still process the region but with empty content */

        contents = [];
      } else {
        /*use the body element as contents */

        contents = [body];
      }
    } else if ('contents' in elem) {
      contents = elem.contents;
    }
    for (var x = 0; contents !== null && x < contents.length; x++) {
      var c = isdProcessContentElement(doc, offset, region, body, isd_element, associated_region_id, contents[x], errorHandler, context);

      /* 
       * keep child element only if they are non-null and their region match 
       * the region of this element
       */

      if (c !== null) {
        isd_element.contents.push(c.element);
      }
    }

    /* remove styles that are not applicable */

    for (var qnameb in isd_element.styleAttrs) {
      if (!isd_element.styleAttrs.hasOwnProperty(qnameb)) continue;

      /* true if not applicable */

      var na = false;

      /* special applicability of certain style properties to ruby container spans */
      /* TODO: in the future ruby elements should be translated to elements instead of kept as spans */

      if (isd_element.kind === 'span') {
        var rsp = isd_element.styleAttrs[imscStyles.byName.ruby.qname];
        na = (rsp === 'container' || rsp === 'textContainer' || rsp === 'baseContainer') && _rcs_na_styles.indexOf(qnameb) !== -1;
        if (!na) {
          na = rsp !== 'container' && qnameb === imscStyles.byName.rubyAlign.qname;
        }
        if (!na) {
          na = !(rsp === 'textContainer' || rsp === 'text') && qnameb === imscStyles.byName.rubyPosition.qname;
        }
      }

      /* normal applicability */

      if (!na) {
        var da = imscStyles.byQName[qnameb];
        if ("applies" in da) {
          na = da.applies.indexOf(isd_element.kind) === -1;
        }
      }
      if (na) {
        delete isd_element.styleAttrs[qnameb];
      }
    }

    /* trim whitespace around explicit line breaks */

    var ruby = isd_element.styleAttrs[imscStyles.byName.ruby.qname];
    if (isd_element.kind === 'p' || isd_element.kind === 'span' && (ruby === "textContainer" || ruby === "text")) {
      var elist = [];
      constructSpanList(isd_element, elist);
      collapseLWSP(elist);
      pruneEmptySpans(isd_element);
    }

    /* keep element if:
     * * contains a background image
     * * <br/>
     * * if there are children
     * * if it is an image
     * * if <span> and has text
     * * if region and showBackground = always
     */

    if (isd_element.kind === 'div' && imscStyles.byName.backgroundImage.qname in isd_element.styleAttrs || isd_element.kind === 'br' || isd_element.kind === 'image' || 'contents' in isd_element && isd_element.contents.length > 0 || isd_element.kind === 'span' && isd_element.text !== null || isd_element.kind === 'region' && isd_element.styleAttrs[imscStyles.byName.showBackground.qname] === 'always') {
      return {
        region_id: associated_region_id,
        element: isd_element
      };
    }
    return null;
  }
  function collapseLWSP(elist) {
    function isPrevCharLWSP(prev_element) {
      return prev_element.kind === 'br' || /[\r\n\t ]$/.test(prev_element.text);
    }
    function isNextCharLWSP(next_element) {
      return next_element.kind === 'br' || next_element.space === "preserve" && /^[\r\n]/.test(next_element.text);
    }

    /* collapse spaces and remove leading LWSPs */

    var element;
    for (var i = 0; i < elist.length;) {
      element = elist[i];
      if (element.kind === "br" || element.space === "preserve") {
        i++;
        continue;
      }
      var trimmed_text = element.text.replace(/[\t\r\n ]+/g, ' ');
      if (/^[ ]/.test(trimmed_text)) {
        if (i === 0 || isPrevCharLWSP(elist[i - 1])) {
          trimmed_text = trimmed_text.substring(1);
        }
      }
      element.text = trimmed_text;
      if (trimmed_text.length === 0) {
        elist.splice(i, 1);
      } else {
        i++;
      }
    }

    /* remove trailing LWSPs */

    for (i = 0; i < elist.length; i++) {
      element = elist[i];
      if (element.kind === "br" || element.space === "preserve") {
        i++;
        continue;
      }
      if (/[ ]$/.test(element.text)) {
        if (i === elist.length - 1 || isNextCharLWSP(elist[i + 1])) {
          element.text = element.text.slice(0, -1);
        }
      }
    }
  }
  function constructSpanList(element, elist) {
    if (!("contents" in element)) {
      return;
    }
    for (var i = 0; i < element.contents.length; i++) {
      var child = element.contents[i];
      var ruby = child.styleAttrs[imscStyles.byName.ruby.qname];
      if (child.kind === 'span' && (ruby === "textContainer" || ruby === "text")) {
        /* skip ruby text and text containers, which are handled on their own */

        continue;
      } else if ('contents' in child) {
        constructSpanList(child, elist);
      } else if (child.kind === 'span' && child.text.length !== 0 || child.kind === 'br') {
        /* skip empty spans */

        elist.push(child);
      }
    }
  }
  function pruneEmptySpans(element) {
    if (element.kind === 'br') {
      return false;
    } else if ('text' in element) {
      return element.text.length === 0;
    } else if ('contents' in element) {
      var i = element.contents.length;
      while (i--) {
        if (pruneEmptySpans(element.contents[i])) {
          element.contents.splice(i, 1);
        }
      }
      return element.contents.length === 0;
    }
  }
  function ISD(tt) {
    this.contents = [];
    this.aspectRatio = tt.aspectRatio;
    this.lang = tt.lang;
  }
  function ISDContentElement(ttelem) {
    /* assume the element is a region if it does not have a kind */

    this.kind = ttelem.kind || 'region';

    /* copy lang */

    this.lang = ttelem.lang;

    /* copy id */

    if (ttelem.id) {
      this.id = ttelem.id;
    }

    /* deep copy of style attributes */
    this.styleAttrs = {};
    for (var sname in ttelem.styleAttrs) {
      if (!ttelem.styleAttrs.hasOwnProperty(sname)) continue;
      this.styleAttrs[sname] = ttelem.styleAttrs[sname];
    }

    /* copy src and type if image */

    if ('src' in ttelem) {
      this.src = ttelem.src;
    }
    if ('type' in ttelem) {
      this.type = ttelem.type;
    }

    /* TODO: clean this! 
     * TODO: ISDElement and document element should be better tied together */

    if ('text' in ttelem) {
      this.text = ttelem.text;
    } else if (this.kind === 'region' || 'contents' in ttelem) {
      this.contents = [];
    }
    if ('space' in ttelem) {
      this.space = ttelem.space;
    }
  }

  /*
   * ERROR HANDLING UTILITY FUNCTIONS
   * 
   */

  function reportInfo(errorHandler, msg) {
    if (errorHandler && errorHandler.info && errorHandler.info(msg)) throw msg;
  }
  function reportWarning(errorHandler, msg) {
    if (errorHandler && errorHandler.warn && errorHandler.warn(msg)) throw msg;
  }
  function reportError(errorHandler, msg) {
    if (errorHandler && errorHandler.error && errorHandler.error(msg)) throw msg;
  }
  function reportFatal(errorHandler, msg) {
    if (errorHandler && errorHandler.fatal) errorHandler.fatal(msg);
    throw msg;
  }
})( false ? 0 : exports, typeof imscNames === 'undefined' ? __webpack_require__(/*! ./names */ "./node_modules/imsc/src/main/js/names.js") : imscNames, typeof imscStyles === 'undefined' ? __webpack_require__(/*! ./styles */ "./node_modules/imsc/src/main/js/styles.js") : imscStyles, typeof imscUtils === 'undefined' ? __webpack_require__(/*! ./utils */ "./node_modules/imsc/src/main/js/utils.js") : imscUtils);

/***/ }),

/***/ "./node_modules/imsc/src/main/js/main.js":
/*!***********************************************!*\
  !*** ./node_modules/imsc/src/main/js/main.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

exports.generateISD = __webpack_require__(/*! ./isd */ "./node_modules/imsc/src/main/js/isd.js").generateISD;
exports.fromXML = __webpack_require__(/*! ./doc */ "./node_modules/imsc/src/main/js/doc.js").fromXML;
exports.renderHTML = __webpack_require__(/*! ./html */ "./node_modules/imsc/src/main/js/html.js").render;

/***/ }),

/***/ "./node_modules/imsc/src/main/js/names.js":
/*!************************************************!*\
  !*** ./node_modules/imsc/src/main/js/names.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports) {

/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module imscNames
 */

;
(function (imscNames) {
  // wrapper for non-node envs

  imscNames.ns_tt = "http://www.w3.org/ns/ttml";
  imscNames.ns_tts = "http://www.w3.org/ns/ttml#styling";
  imscNames.ns_ttp = "http://www.w3.org/ns/ttml#parameter";
  imscNames.ns_xml = "http://www.w3.org/XML/1998/namespace";
  imscNames.ns_itts = "http://www.w3.org/ns/ttml/profile/imsc1#styling";
  imscNames.ns_ittp = "http://www.w3.org/ns/ttml/profile/imsc1#parameter";
  imscNames.ns_smpte = "http://www.smpte-ra.org/schemas/2052-1/2010/smpte-tt";
  imscNames.ns_ebutts = "urn:ebu:tt:style";
})( false ? 0 : exports);

/***/ }),

/***/ "./node_modules/imsc/src/main/js/styles.js":
/*!*************************************************!*\
  !*** ./node_modules/imsc/src/main/js/styles.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.math.sign.js */ "./node_modules/core-js/modules/es.math.sign.js");
__webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/core-js/modules/es.string.trim.js");
/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module imscStyles
 */

;
(function (imscStyles, imscNames, imscUtils) {
  // wrapper for non-node envs

  function StylingAttributeDefinition(ns, name, initialValue, appliesTo, isInherit, isAnimatable, parseFunc, computeFunc) {
    this.name = name;
    this.ns = ns;
    this.qname = ns + " " + name;
    this.inherit = isInherit;
    this.animatable = isAnimatable;
    this.initial = initialValue;
    this.applies = appliesTo;
    this.parse = parseFunc;
    this.compute = computeFunc;
  }
  imscStyles.all = [new StylingAttributeDefinition(imscNames.ns_tts, "backgroundColor", "transparent", ['body', 'div', 'p', 'region', 'span'], false, true, imscUtils.parseColor, null), new StylingAttributeDefinition(imscNames.ns_tts, "color", "white", ['span'], true, true, imscUtils.parseColor, null), new StylingAttributeDefinition(imscNames.ns_tts, "direction", "ltr", ['p', 'span'], true, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "display", "auto", ['body', 'div', 'p', 'region', 'span'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "displayAlign", "before", ['region'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "extent", "auto", ['tt', 'region'], false, true, function (str) {
    if (str === "auto") {
      return str;
    } else {
      var s = str.split(" ");
      if (s.length !== 2) return null;
      var w = imscUtils.parseLength(s[0]);
      var h = imscUtils.parseLength(s[1]);
      if (!h || !w) return null;
      return {
        'h': h,
        'w': w
      };
    }
  }, function (doc, parent, element, attr, context) {
    var h;
    var w;
    if (attr === "auto") {
      h = new imscUtils.ComputedLength(0, 1);
    } else {
      h = imscUtils.toComputedLength(attr.h.value, attr.h.unit, null, doc.dimensions.h, null, doc.pxLength.h);
      if (h === null) {
        return null;
      }
    }
    if (attr === "auto") {
      w = new imscUtils.ComputedLength(1, 0);
    } else {
      w = imscUtils.toComputedLength(attr.w.value, attr.w.unit, null, doc.dimensions.w, null, doc.pxLength.w);
      if (w === null) {
        return null;
      }
    }
    return {
      'h': h,
      'w': w
    };
  }), new StylingAttributeDefinition(imscNames.ns_tts, "fontFamily", "default", ['span', 'p'], true, true, function (str) {
    var ffs = str.split(",");
    var rslt = [];
    for (var i = 0; i < ffs.length; i++) {
      ffs[i] = ffs[i].trim();
      if (ffs[i].charAt(0) !== "'" && ffs[i].charAt(0) !== '"') {
        if (ffs[i] === "default") {
          /* per IMSC1 */

          rslt.push("monospaceSerif");
        } else {
          rslt.push(ffs[i]);
        }
      } else {
        rslt.push(ffs[i]);
      }
    }
    return rslt;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "shear", "0%", ['p'], true, true, imscUtils.parseLength, function (doc, parent, element, attr) {
    var fs;
    if (attr.unit === "%") {
      fs = Math.abs(attr.value) > 100 ? Math.sign(attr.value) * 100 : attr.value;
    } else {
      return null;
    }
    return fs;
  }), new StylingAttributeDefinition(imscNames.ns_tts, "fontSize", "1c", ['span', 'p'], true, true, imscUtils.parseLength, function (doc, parent, element, attr, context) {
    var fs;
    fs = imscUtils.toComputedLength(attr.value, attr.unit, parent !== null ? parent.styleAttrs[imscStyles.byName.fontSize.qname] : doc.cellLength.h, parent !== null ? parent.styleAttrs[imscStyles.byName.fontSize.qname] : doc.cellLength.h, doc.cellLength.h, doc.pxLength.h);
    return fs;
  }), new StylingAttributeDefinition(imscNames.ns_tts, "fontStyle", "normal", ['span', 'p'], true, true, function (str) {
    /* TODO: handle font style */

    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "fontWeight", "normal", ['span', 'p'], true, true, function (str) {
    /* TODO: handle font weight */

    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "lineHeight", "normal", ['p'], true, true, function (str) {
    if (str === "normal") {
      return str;
    } else {
      return imscUtils.parseLength(str);
    }
  }, function (doc, parent, element, attr, context) {
    var lh;
    if (attr === "normal") {
      /* inherit normal per https://github.com/w3c/ttml1/issues/220 */

      lh = attr;
    } else {
      lh = imscUtils.toComputedLength(attr.value, attr.unit, element.styleAttrs[imscStyles.byName.fontSize.qname], element.styleAttrs[imscStyles.byName.fontSize.qname], doc.cellLength.h, doc.pxLength.h);
      if (lh === null) {
        return null;
      }
    }

    /* TODO: create a Length constructor */

    return lh;
  }), new StylingAttributeDefinition(imscNames.ns_tts, "opacity", 1.0, ['region'], false, true, parseFloat, null), new StylingAttributeDefinition(imscNames.ns_tts, "origin", "auto", ['region'], false, true, function (str) {
    if (str === "auto") {
      return str;
    } else {
      var s = str.split(" ");
      if (s.length !== 2) return null;
      var w = imscUtils.parseLength(s[0]);
      var h = imscUtils.parseLength(s[1]);
      if (!h || !w) return null;
      return {
        'h': h,
        'w': w
      };
    }
  }, function (doc, parent, element, attr, context) {
    var h;
    var w;
    if (attr === "auto") {
      h = new imscUtils.ComputedLength(0, 0);
    } else {
      h = imscUtils.toComputedLength(attr.h.value, attr.h.unit, null, doc.dimensions.h, null, doc.pxLength.h);
      if (h === null) {
        return null;
      }
    }
    if (attr === "auto") {
      w = new imscUtils.ComputedLength(0, 0);
    } else {
      w = imscUtils.toComputedLength(attr.w.value, attr.w.unit, null, doc.dimensions.w, null, doc.pxLength.w);
      if (w === null) {
        return null;
      }
    }
    return {
      'h': h,
      'w': w
    };
  }), new StylingAttributeDefinition(imscNames.ns_tts, "overflow", "hidden", ['region'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "padding", "0px", ['region'], false, true, function (str) {
    var s = str.split(" ");
    if (s.length > 4) return null;
    var r = [];
    for (var i = 0; i < s.length; i++) {
      var l = imscUtils.parseLength(s[i]);
      if (!l) return null;
      r.push(l);
    }
    return r;
  }, function (doc, parent, element, attr, context) {
    var padding;

    /* TODO: make sure we are in region */

    /*
     * expand padding shortcuts to 
     * [before, end, after, start]
     * 
     */

    if (attr.length === 1) {
      padding = [attr[0], attr[0], attr[0], attr[0]];
    } else if (attr.length === 2) {
      padding = [attr[0], attr[1], attr[0], attr[1]];
    } else if (attr.length === 3) {
      padding = [attr[0], attr[1], attr[2], attr[1]];
    } else if (attr.length === 4) {
      padding = [attr[0], attr[1], attr[2], attr[3]];
    } else {
      return null;
    }

    /* TODO: take into account tts:direction */

    /* 
     * transform [before, end, after, start] according to writingMode to 
     * [top,left,bottom,right]
     * 
     */

    var dir = element.styleAttrs[imscStyles.byName.writingMode.qname];
    if (dir === "lrtb" || dir === "lr") {
      padding = [padding[0], padding[3], padding[2], padding[1]];
    } else if (dir === "rltb" || dir === "rl") {
      padding = [padding[0], padding[1], padding[2], padding[3]];
    } else if (dir === "tblr") {
      padding = [padding[3], padding[0], padding[1], padding[2]];
    } else if (dir === "tbrl" || dir === "tb") {
      padding = [padding[3], padding[2], padding[1], padding[0]];
    } else {
      return null;
    }
    var out = [];
    for (var i = 0; i < padding.length; i++) {
      if (padding[i].value === 0) {
        out[i] = new imscUtils.ComputedLength(0, 0);
      } else {
        out[i] = imscUtils.toComputedLength(padding[i].value, padding[i].unit, element.styleAttrs[imscStyles.byName.fontSize.qname], i === 0 || i === 2 ? element.styleAttrs[imscStyles.byName.extent.qname].h : element.styleAttrs[imscStyles.byName.extent.qname].w, i === 0 || i === 2 ? doc.cellLength.h : doc.cellLength.w, i === 0 || i === 2 ? doc.pxLength.h : doc.pxLength.w);
        if (out[i] === null) return null;
      }
    }
    return out;
  }), new StylingAttributeDefinition(imscNames.ns_tts, "position", "top left", ['region'], false, true, function (str) {
    return imscUtils.parsePosition(str);
  }, function (doc, parent, element, attr) {
    var h;
    var w;
    h = imscUtils.toComputedLength(attr.v.offset.value, attr.v.offset.unit, null, new imscUtils.ComputedLength(-element.styleAttrs[imscStyles.byName.extent.qname].h.rw, doc.dimensions.h.rh - element.styleAttrs[imscStyles.byName.extent.qname].h.rh), null, doc.pxLength.h);
    if (h === null) return null;
    if (attr.v.edge === "bottom") {
      h = new imscUtils.ComputedLength(-h.rw - element.styleAttrs[imscStyles.byName.extent.qname].h.rw, doc.dimensions.h.rh - h.rh - element.styleAttrs[imscStyles.byName.extent.qname].h.rh);
    }
    w = imscUtils.toComputedLength(attr.h.offset.value, attr.h.offset.unit, null, new imscUtils.ComputedLength(doc.dimensions.w.rw - element.styleAttrs[imscStyles.byName.extent.qname].w.rw, -element.styleAttrs[imscStyles.byName.extent.qname].w.rh), null, doc.pxLength.w);
    if (h === null) return null;
    if (attr.h.edge === "right") {
      w = new imscUtils.ComputedLength(doc.dimensions.w.rw - w.rw - element.styleAttrs[imscStyles.byName.extent.qname].w.rw, -w.rh - element.styleAttrs[imscStyles.byName.extent.qname].w.rh);
    }
    return {
      'h': h,
      'w': w
    };
  }), new StylingAttributeDefinition(imscNames.ns_tts, "ruby", "none", ['span'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "rubyAlign", "center", ['span'], true, true, function (str) {
    if (!(str === "center" || str === "spaceAround")) {
      return null;
    }
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "rubyPosition", "outside", ['span'], true, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "rubyReserve", "none", ['p'], true, true, function (str) {
    var s = str.split(" ");
    var r = [null, null];
    if (s.length === 0 || s.length > 2) return null;
    if (s[0] === "none" || s[0] === "both" || s[0] === "after" || s[0] === "before" || s[0] === "outside") {
      r[0] = s[0];
    } else {
      return null;
    }
    if (s.length === 2 && s[0] !== "none") {
      var l = imscUtils.parseLength(s[1]);
      if (l) {
        r[1] = l;
      } else {
        return null;
      }
    }
    return r;
  }, function (doc, parent, element, attr, context) {
    if (attr[0] === "none") {
      return attr;
    }
    var fs = null;
    if (attr[1] === null) {
      fs = new imscUtils.ComputedLength(element.styleAttrs[imscStyles.byName.fontSize.qname].rw * 0.5, element.styleAttrs[imscStyles.byName.fontSize.qname].rh * 0.5);
    } else {
      fs = imscUtils.toComputedLength(attr[1].value, attr[1].unit, element.styleAttrs[imscStyles.byName.fontSize.qname], element.styleAttrs[imscStyles.byName.fontSize.qname], doc.cellLength.h, doc.pxLength.h);
    }
    if (fs === null) return null;
    return [attr[0], fs];
  }), new StylingAttributeDefinition(imscNames.ns_tts, "showBackground", "always", ['region'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "textAlign", "start", ['p'], true, true, function (str) {
    return str;
  }, function (doc, parent, element, attr, context) {
    /* Section 7.16.9 of XSL */

    if (attr === "left") {
      return "start";
    } else if (attr === "right") {
      return "end";
    } else {
      return attr;
    }
  }), new StylingAttributeDefinition(imscNames.ns_tts, "textCombine", "none", ['span'], true, true, function (str) {
    if (str === "none" || str === "all") {
      return str;
    }
    return null;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "textDecoration", "none", ['span'], true, true, function (str) {
    return str.split(" ");
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "textEmphasis", "none", ['span'], true, true, function (str) {
    var e = str.split(" ");
    var rslt = {
      style: null,
      symbol: null,
      color: null,
      position: null
    };
    for (var i = 0; i < e.length; i++) {
      if (e[i] === "none" || e[i] === "auto") {
        rslt.style = e[i];
      } else if (e[i] === "filled" || e[i] === "open") {
        rslt.style = e[i];
      } else if (e[i] === "circle" || e[i] === "dot" || e[i] === "sesame") {
        rslt.symbol = e[i];
      } else if (e[i] === "current") {
        rslt.color = e[i];
      } else if (e[i] === "outside" || e[i] === "before" || e[i] === "after") {
        rslt.position = e[i];
      } else {
        rslt.color = imscUtils.parseColor(e[i]);
        if (rslt.color === null) return null;
      }
    }
    if (rslt.style == null && rslt.symbol == null) {
      rslt.style = "auto";
    } else {
      rslt.symbol = rslt.symbol || "circle";
      rslt.style = rslt.style || "filled";
    }
    rslt.position = rslt.position || "outside";
    rslt.color = rslt.color || "current";
    return rslt;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "textOutline", "none", ['span'], true, true, function (str) {
    /*
     * returns {c: <color>?, thichness: <length>} | "none"
     * 
     */

    if (str === "none") {
      return str;
    } else {
      var r = {};
      var s = str.split(" ");
      if (s.length === 0 || s.length > 2) return null;
      var c = imscUtils.parseColor(s[0]);
      r.color = c;
      if (c !== null) s.shift();
      if (s.length !== 1) return null;
      var l = imscUtils.parseLength(s[0]);
      if (!l) return null;
      r.thickness = l;
      return r;
    }
  }, function (doc, parent, element, attr, context) {
    /*
     * returns {color: <color>, thickness: <norm length>}
     * 
     */

    if (attr === "none") return attr;
    var rslt = {};
    if (attr.color === null) {
      rslt.color = element.styleAttrs[imscStyles.byName.color.qname];
    } else {
      rslt.color = attr.color;
    }
    rslt.thickness = imscUtils.toComputedLength(attr.thickness.value, attr.thickness.unit, element.styleAttrs[imscStyles.byName.fontSize.qname], element.styleAttrs[imscStyles.byName.fontSize.qname], doc.cellLength.h, doc.pxLength.h);
    if (rslt.thickness === null) return null;
    return rslt;
  }), new StylingAttributeDefinition(imscNames.ns_tts, "textShadow", "none", ['span'], true, true, imscUtils.parseTextShadow, function (doc, parent, element, attr) {
    /*
     * returns [{x_off: <length>, y_off: <length>, b_radius: <length>, color: <color>}*] or "none"
     * 
     */

    if (attr === "none") return attr;
    var r = [];
    for (var i = 0; i < attr.length; i++) {
      var shadow = {};
      shadow.x_off = imscUtils.toComputedLength(attr[i][0].value, attr[i][0].unit, null, element.styleAttrs[imscStyles.byName.fontSize.qname], null, doc.pxLength.w);
      if (shadow.x_off === null) return null;
      shadow.y_off = imscUtils.toComputedLength(attr[i][1].value, attr[i][1].unit, null, element.styleAttrs[imscStyles.byName.fontSize.qname], null, doc.pxLength.h);
      if (shadow.y_off === null) return null;
      if (attr[i][2] === null) {
        shadow.b_radius = 0;
      } else {
        shadow.b_radius = imscUtils.toComputedLength(attr[i][2].value, attr[i][2].unit, null, element.styleAttrs[imscStyles.byName.fontSize.qname], null, doc.pxLength.h);
        if (shadow.b_radius === null) return null;
      }
      if (attr[i][3] === null) {
        shadow.color = element.styleAttrs[imscStyles.byName.color.qname];
      } else {
        shadow.color = attr[i][3];
      }
      r.push(shadow);
    }
    return r;
  }), new StylingAttributeDefinition(imscNames.ns_tts, "unicodeBidi", "normal", ['span', 'p'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "visibility", "visible", ['body', 'div', 'p', 'region', 'span'], true, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "wrapOption", "wrap", ['span'], true, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "writingMode", "lrtb", ['region'], false, true, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_tts, "zIndex", "auto", ['region'], false, true, function (str) {
    var rslt;
    if (str === 'auto') {
      rslt = str;
    } else {
      rslt = parseInt(str);
      if (isNaN(rslt)) {
        rslt = null;
      }
    }
    return rslt;
  }, null), new StylingAttributeDefinition(imscNames.ns_ebutts, "linePadding", "0c", ['p'], true, false, imscUtils.parseLength, function (doc, parent, element, attr, context) {
    return imscUtils.toComputedLength(attr.value, attr.unit, null, null, doc.cellLength.w, null);
  }), new StylingAttributeDefinition(imscNames.ns_ebutts, "multiRowAlign", "auto", ['p'], true, false, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_smpte, "backgroundImage", null, ['div'], false, false, function (str) {
    return str;
  }, null), new StylingAttributeDefinition(imscNames.ns_itts, "forcedDisplay", "false", ['body', 'div', 'p', 'region', 'span'], true, true, function (str) {
    return str === 'true' ? true : false;
  }, null), new StylingAttributeDefinition(imscNames.ns_itts, "fillLineGap", "false", ['p'], true, true, function (str) {
    return str === 'true' ? true : false;
  }, null)];

  /* TODO: allow null parse function */

  imscStyles.byQName = {};
  for (var i in imscStyles.all) {
    imscStyles.byQName[imscStyles.all[i].qname] = imscStyles.all[i];
  }
  imscStyles.byName = {};
  for (var j in imscStyles.all) {
    imscStyles.byName[imscStyles.all[j].name] = imscStyles.all[j];
  }
})( false ? 0 : exports, typeof imscNames === 'undefined' ? __webpack_require__(/*! ./names */ "./node_modules/imsc/src/main/js/names.js") : imscNames, typeof imscUtils === 'undefined' ? __webpack_require__(/*! ./utils */ "./node_modules/imsc/src/main/js/utils.js") : imscUtils);

/***/ }),

/***/ "./node_modules/imsc/src/main/js/utils.js":
/*!************************************************!*\
  !*** ./node_modules/imsc/src/main/js/utils.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/core-js/modules/es.string.match.js");
/* 
 * Copyright (c) 2016, Pierre-Anthony Lemieux <pal@sandflow.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module imscUtils
 */

;
(function (imscUtils) {
  // wrapper for non-node envs

  /* Documents the error handler interface */

  /**
   * @classdesc Generic interface for handling events. The interface exposes four
   * methods:
   * * <pre>info</pre>: unusual event that does not result in an inconsistent state
   * * <pre>warn</pre>: unexpected event that should not result in an inconsistent state
   * * <pre>error</pre>: unexpected event that may result in an inconsistent state
   * * <pre>fatal</pre>: unexpected event that results in an inconsistent state
   *   and termination of processing
   * Each method takes a single <pre>string</pre> describing the event as argument,
   * and returns a single <pre>boolean</pre>, which terminates processing if <pre>true</pre>.
   *
   * @name ErrorHandler
   * @class
   */

  /*
   * Parses a TTML color expression
   * 
   */

  var HEX_COLOR_RE = /#([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})?/;
  var DEC_COLOR_RE = /rgb\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/;
  var DEC_COLORA_RE = /rgba\(\s*(\d+),\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*\)/;
  var NAMED_COLOR = {
    transparent: [0, 0, 0, 0],
    black: [0, 0, 0, 255],
    silver: [192, 192, 192, 255],
    gray: [128, 128, 128, 255],
    white: [255, 255, 255, 255],
    maroon: [128, 0, 0, 255],
    red: [255, 0, 0, 255],
    purple: [128, 0, 128, 255],
    fuchsia: [255, 0, 255, 255],
    magenta: [255, 0, 255, 255],
    green: [0, 128, 0, 255],
    lime: [0, 255, 0, 255],
    olive: [128, 128, 0, 255],
    yellow: [255, 255, 0, 255],
    navy: [0, 0, 128, 255],
    blue: [0, 0, 255, 255],
    teal: [0, 128, 128, 255],
    aqua: [0, 255, 255, 255],
    cyan: [0, 255, 255, 255]
  };
  imscUtils.parseColor = function (str) {
    var m;
    var r = null;
    var nc = NAMED_COLOR[str.toLowerCase()];
    if (nc !== undefined) {
      r = nc;
    } else if ((m = HEX_COLOR_RE.exec(str)) !== null) {
      r = [parseInt(m[1], 16), parseInt(m[2], 16), parseInt(m[3], 16), m[4] !== undefined ? parseInt(m[4], 16) : 255];
    } else if ((m = DEC_COLOR_RE.exec(str)) !== null) {
      r = [parseInt(m[1]), parseInt(m[2]), parseInt(m[3]), 255];
    } else if ((m = DEC_COLORA_RE.exec(str)) !== null) {
      r = [parseInt(m[1]), parseInt(m[2]), parseInt(m[3]), parseInt(m[4])];
    }
    return r;
  };
  var LENGTH_RE = /^((?:\+|\-)?\d*(?:\.\d+)?)(px|em|c|%|rh|rw)$/;
  imscUtils.parseLength = function (str) {
    var m;
    var r = null;
    if ((m = LENGTH_RE.exec(str)) !== null) {
      r = {
        value: parseFloat(m[1]),
        unit: m[2]
      };
    }
    return r;
  };
  imscUtils.parseTextShadow = function (str) {
    var shadows = str.match(/([^\(,\)]|\([^\)]+\))+/g);
    var r = [];
    for (var i = 0; i < shadows.length; i++) {
      var shadow = shadows[i].split(" ");
      if (shadow.length === 1 && shadow[0] === "none") {
        return "none";
      } else if (shadow.length > 1 && shadow.length < 5) {
        var out_shadow = [null, null, null, null];

        /* x offset */

        var l = imscUtils.parseLength(shadow.shift());
        if (l === null) return null;
        out_shadow[0] = l;

        /* y offset */

        l = imscUtils.parseLength(shadow.shift());
        if (l === null) return null;
        out_shadow[1] = l;

        /* is there a third component */

        if (shadow.length === 0) {
          r.push(out_shadow);
          continue;
        }
        l = imscUtils.parseLength(shadow[0]);
        if (l !== null) {
          out_shadow[2] = l;
          shadow.shift();
        }
        if (shadow.length === 0) {
          r.push(out_shadow);
          continue;
        }
        var c = imscUtils.parseColor(shadow[0]);
        if (c === null) return null;
        out_shadow[3] = c;
        r.push(out_shadow);
      }
    }
    return r;
  };
  imscUtils.parsePosition = function (str) {
    /* see https://www.w3.org/TR/ttml2/#style-value-position */

    var s = str.split(" ");
    var isKeyword = function isKeyword(str) {
      return str === "center" || str === "left" || str === "top" || str === "bottom" || str === "right";
    };
    if (s.length > 4) {
      return null;
    }

    /* initial clean-up pass */

    for (var j = 0; j < s.length; j++) {
      if (!isKeyword(s[j])) {
        var l = imscUtils.parseLength(s[j]);
        if (l === null) return null;
        s[j] = l;
      }
    }

    /* position default */

    var pos = {
      h: {
        edge: "left",
        offset: {
          value: 50,
          unit: "%"
        }
      },
      v: {
        edge: "top",
        offset: {
          value: 50,
          unit: "%"
        }
      }
    };

    /* update position */

    for (var i = 0; i < s.length;) {
      /* extract the current component */

      var comp = s[i++];
      if (isKeyword(comp)) {
        /* we have a keyword */

        var offset = {
          value: 0,
          unit: "%"
        };

        /* peek at the next component */

        if (s.length !== 2 && i < s.length && !isKeyword(s[i])) {
          /* followed by an offset */

          offset = s[i++];
        }

        /* skip if center */

        if (comp === "right") {
          pos.h.edge = comp;
          pos.h.offset = offset;
        } else if (comp === "bottom") {
          pos.v.edge = comp;
          pos.v.offset = offset;
        } else if (comp === "left") {
          pos.h.offset = offset;
        } else if (comp === "top") {
          pos.v.offset = offset;
        }
      } else if (s.length === 1 || s.length === 2) {
        /* we have a bare value */

        if (i === 1) {
          /* assign it to left edge if first bare value */

          pos.h.offset = comp;
        } else {
          /* assign it to top edge if second bare value */

          pos.v.offset = comp;
        }
      } else {
        /* error condition */

        return null;
      }
    }
    return pos;
  };
  imscUtils.ComputedLength = function (rw, rh) {
    this.rw = rw;
    this.rh = rh;
  };
  imscUtils.ComputedLength.prototype.toUsedLength = function (width, height) {
    return width * this.rw + height * this.rh;
  };
  imscUtils.ComputedLength.prototype.isZero = function () {
    return this.rw === 0 && this.rh === 0;
  };

  /**
   * Computes a specified length to a root container relative length
   * 
   * @param {number} lengthVal Length value to be computed
   * @param {string} lengthUnit Units of the length value
   * @param {number} emScale length of 1em, or null if em is not allowed
   * @param {number} percentScale length to which , or null if perecentage is not allowed
   * @param {number} cellScale length of 1c, or null if c is not allowed
   * @param {number} pxScale length of 1px, or null if px is not allowed
   * @param {number} direction 0 if the length is computed in the horizontal direction, 1 if the length is computed in the vertical direction
   * @return {number} Computed length
   */
  imscUtils.toComputedLength = function (lengthVal, lengthUnit, emLength, percentLength, cellLength, pxLength) {
    if (lengthUnit === "%" && percentLength) {
      return new imscUtils.ComputedLength(percentLength.rw * lengthVal / 100, percentLength.rh * lengthVal / 100);
    } else if (lengthUnit === "em" && emLength) {
      return new imscUtils.ComputedLength(emLength.rw * lengthVal, emLength.rh * lengthVal);
    } else if (lengthUnit === "c" && cellLength) {
      return new imscUtils.ComputedLength(lengthVal * cellLength.rw, lengthVal * cellLength.rh);
    } else if (lengthUnit === "px" && pxLength) {
      return new imscUtils.ComputedLength(lengthVal * pxLength.rw, lengthVal * pxLength.rh);
    } else if (lengthUnit === "rh") {
      return new imscUtils.ComputedLength(0, lengthVal / 100);
    } else if (lengthUnit === "rw") {
      return new imscUtils.ComputedLength(lengthVal / 100, 0);
    } else {
      return null;
    }
  };
})( false ? 0 : exports);

/***/ }),

/***/ "./node_modules/inherits/inherits_browser.js":
/*!***************************************************!*\
  !*** ./node_modules/inherits/inherits_browser.js ***!
  \***************************************************/
/***/ (function(module) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor;
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor;
      var TempCtor = function TempCtor() {};
      TempCtor.prototype = superCtor.prototype;
      ctor.prototype = new TempCtor();
      ctor.prototype.constructor = ctor;
    }
  };
}

/***/ }),

/***/ "./node_modules/path-browserify/index.js":
/*!***********************************************!*\
  !*** ./node_modules/path-browserify/index.js ***!
  \***********************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// 'path' module extracted from Node.js v8.11.1 (only the posix part)
// transplited with Babel

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.json.stringify.js */ "./node_modules/core-js/modules/es.json.stringify.js");
function assertPath(path) {
  if (typeof path !== 'string') {
    throw new TypeError('Path must be a string. Received ' + JSON.stringify(path));
  }
}

// Resolves . and .. elements in a path with directory names
function normalizeStringPosix(path, allowAboveRoot) {
  var res = '';
  var lastSegmentLength = 0;
  var lastSlash = -1;
  var dots = 0;
  var code;
  for (var i = 0; i <= path.length; ++i) {
    if (i < path.length) code = path.charCodeAt(i);else if (code === 47 /*/*/) break;else code = 47 /*/*/;
    if (code === 47 /*/*/) {
      if (lastSlash === i - 1 || dots === 1) {
        // NOOP
      } else if (lastSlash !== i - 1 && dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 /*.*/ || res.charCodeAt(res.length - 2) !== 46 /*.*/) {
          if (res.length > 2) {
            var lastSlashIndex = res.lastIndexOf('/');
            if (lastSlashIndex !== res.length - 1) {
              if (lastSlashIndex === -1) {
                res = '';
                lastSegmentLength = 0;
              } else {
                res = res.slice(0, lastSlashIndex);
                lastSegmentLength = res.length - 1 - res.lastIndexOf('/');
              }
              lastSlash = i;
              dots = 0;
              continue;
            }
          } else if (res.length === 2 || res.length === 1) {
            res = '';
            lastSegmentLength = 0;
            lastSlash = i;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          if (res.length > 0) res += '/..';else res = '..';
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) res += '/' + path.slice(lastSlash + 1, i);else res = path.slice(lastSlash + 1, i);
        lastSegmentLength = i - lastSlash - 1;
      }
      lastSlash = i;
      dots = 0;
    } else if (code === 46 /*.*/ && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
function _format(sep, pathObject) {
  var dir = pathObject.dir || pathObject.root;
  var base = pathObject.base || (pathObject.name || '') + (pathObject.ext || '');
  if (!dir) {
    return base;
  }
  if (dir === pathObject.root) {
    return dir + base;
  }
  return dir + sep + base;
}
var posix = {
  // path.resolve([from ...], to)
  resolve: function resolve() {
    var resolvedPath = '';
    var resolvedAbsolute = false;
    var cwd;
    for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
      var path;
      if (i >= 0) path = arguments[i];else {
        if (cwd === undefined) cwd = process.cwd();
        path = cwd;
      }
      assertPath(path);

      // Skip empty entries
      if (path.length === 0) {
        continue;
      }
      resolvedPath = path + '/' + resolvedPath;
      resolvedAbsolute = path.charCodeAt(0) === 47 /*/*/;
    }

    // At this point the path should be resolved to a full absolute path, but
    // handle relative paths to be safe (might happen when process.cwd() fails)

    // Normalize the path
    resolvedPath = normalizeStringPosix(resolvedPath, !resolvedAbsolute);
    if (resolvedAbsolute) {
      if (resolvedPath.length > 0) return '/' + resolvedPath;else return '/';
    } else if (resolvedPath.length > 0) {
      return resolvedPath;
    } else {
      return '.';
    }
  },
  normalize: function normalize(path) {
    assertPath(path);
    if (path.length === 0) return '.';
    var isAbsolute = path.charCodeAt(0) === 47 /*/*/;
    var trailingSeparator = path.charCodeAt(path.length - 1) === 47 /*/*/;

    // Normalize the path
    path = normalizeStringPosix(path, !isAbsolute);
    if (path.length === 0 && !isAbsolute) path = '.';
    if (path.length > 0 && trailingSeparator) path += '/';
    if (isAbsolute) return '/' + path;
    return path;
  },
  isAbsolute: function isAbsolute(path) {
    assertPath(path);
    return path.length > 0 && path.charCodeAt(0) === 47 /*/*/;
  },
  join: function join() {
    if (arguments.length === 0) return '.';
    var joined;
    for (var i = 0; i < arguments.length; ++i) {
      var arg = arguments[i];
      assertPath(arg);
      if (arg.length > 0) {
        if (joined === undefined) joined = arg;else joined += '/' + arg;
      }
    }
    if (joined === undefined) return '.';
    return posix.normalize(joined);
  },
  relative: function relative(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return '';
    from = posix.resolve(from);
    to = posix.resolve(to);
    if (from === to) return '';

    // Trim any leading backslashes
    var fromStart = 1;
    for (; fromStart < from.length; ++fromStart) {
      if (from.charCodeAt(fromStart) !== 47 /*/*/) break;
    }
    var fromEnd = from.length;
    var fromLen = fromEnd - fromStart;

    // Trim any leading backslashes
    var toStart = 1;
    for (; toStart < to.length; ++toStart) {
      if (to.charCodeAt(toStart) !== 47 /*/*/) break;
    }
    var toEnd = to.length;
    var toLen = toEnd - toStart;

    // Compare paths to find the longest common path from root
    var length = fromLen < toLen ? fromLen : toLen;
    var lastCommonSep = -1;
    var i = 0;
    for (; i <= length; ++i) {
      if (i === length) {
        if (toLen > length) {
          if (to.charCodeAt(toStart + i) === 47 /*/*/) {
            // We get here if `from` is the exact base path for `to`.
            // For example: from='/foo/bar'; to='/foo/bar/baz'
            return to.slice(toStart + i + 1);
          } else if (i === 0) {
            // We get here if `from` is the root
            // For example: from='/'; to='/foo'
            return to.slice(toStart + i);
          }
        } else if (fromLen > length) {
          if (from.charCodeAt(fromStart + i) === 47 /*/*/) {
            // We get here if `to` is the exact base path for `from`.
            // For example: from='/foo/bar/baz'; to='/foo/bar'
            lastCommonSep = i;
          } else if (i === 0) {
            // We get here if `to` is the root.
            // For example: from='/foo'; to='/'
            lastCommonSep = 0;
          }
        }
        break;
      }
      var fromCode = from.charCodeAt(fromStart + i);
      var toCode = to.charCodeAt(toStart + i);
      if (fromCode !== toCode) break;else if (fromCode === 47 /*/*/) lastCommonSep = i;
    }
    var out = '';
    // Generate the relative path based on the path difference between `to`
    // and `from`
    for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
      if (i === fromEnd || from.charCodeAt(i) === 47 /*/*/) {
        if (out.length === 0) out += '..';else out += '/..';
      }
    }

    // Lastly, append the rest of the destination (`to`) path that comes after
    // the common path parts
    if (out.length > 0) return out + to.slice(toStart + lastCommonSep);else {
      toStart += lastCommonSep;
      if (to.charCodeAt(toStart) === 47 /*/*/) ++toStart;
      return to.slice(toStart);
    }
  },
  _makeLong: function _makeLong(path) {
    return path;
  },
  dirname: function dirname(path) {
    assertPath(path);
    if (path.length === 0) return '.';
    var code = path.charCodeAt(0);
    var hasRoot = code === 47 /*/*/;
    var end = -1;
    var matchedSlash = true;
    for (var i = path.length - 1; i >= 1; --i) {
      code = path.charCodeAt(i);
      if (code === 47 /*/*/) {
        if (!matchedSlash) {
          end = i;
          break;
        }
      } else {
        // We saw the first non-path separator
        matchedSlash = false;
      }
    }
    if (end === -1) return hasRoot ? '/' : '.';
    if (hasRoot && end === 1) return '//';
    return path.slice(0, end);
  },
  basename: function basename(path, ext) {
    if (ext !== undefined && typeof ext !== 'string') throw new TypeError('"ext" argument must be a string');
    assertPath(path);
    var start = 0;
    var end = -1;
    var matchedSlash = true;
    var i;
    if (ext !== undefined && ext.length > 0 && ext.length <= path.length) {
      if (ext.length === path.length && ext === path) return '';
      var extIdx = ext.length - 1;
      var firstNonSlashEnd = -1;
      for (i = path.length - 1; i >= 0; --i) {
        var code = path.charCodeAt(i);
        if (code === 47 /*/*/) {
          // If we reached a path separator that was not part of a set of path
          // separators at the end of the string, stop now
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else {
          if (firstNonSlashEnd === -1) {
            // We saw the first non-path separator, remember this index in case
            // we need it if the extension ends up not matching
            matchedSlash = false;
            firstNonSlashEnd = i + 1;
          }
          if (extIdx >= 0) {
            // Try to match the explicit extension
            if (code === ext.charCodeAt(extIdx)) {
              if (--extIdx === -1) {
                // We matched the extension, so mark this as the end of our path
                // component
                end = i;
              }
            } else {
              // Extension does not match, so our result is the entire path
              // component
              extIdx = -1;
              end = firstNonSlashEnd;
            }
          }
        }
      }
      if (start === end) end = firstNonSlashEnd;else if (end === -1) end = path.length;
      return path.slice(start, end);
    } else {
      for (i = path.length - 1; i >= 0; --i) {
        if (path.charCodeAt(i) === 47 /*/*/) {
          // If we reached a path separator that was not part of a set of path
          // separators at the end of the string, stop now
          if (!matchedSlash) {
            start = i + 1;
            break;
          }
        } else if (end === -1) {
          // We saw the first non-path separator, mark this as the end of our
          // path component
          matchedSlash = false;
          end = i + 1;
        }
      }
      if (end === -1) return '';
      return path.slice(start, end);
    }
  },
  extname: function extname(path) {
    assertPath(path);
    var startDot = -1;
    var startPart = 0;
    var end = -1;
    var matchedSlash = true;
    // Track the state of characters (if any) we see before our first dot and
    // after any path separator we find
    var preDotState = 0;
    for (var i = path.length - 1; i >= 0; --i) {
      var code = path.charCodeAt(i);
      if (code === 47 /*/*/) {
        // If we reached a path separator that was not part of a set of path
        // separators at the end of the string, stop now
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        // We saw the first non-path separator, mark this as the end of our
        // extension
        matchedSlash = false;
        end = i + 1;
      }
      if (code === 46 /*.*/) {
        // If this is our first dot, mark it as the start of our extension
        if (startDot === -1) startDot = i;else if (preDotState !== 1) preDotState = 1;
      } else if (startDot !== -1) {
        // We saw a non-dot and non-path separator before our dot, so we should
        // have a good chance at having a non-empty extension
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 ||
    // We saw a non-dot character immediately before the dot
    preDotState === 0 ||
    // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      return '';
    }
    return path.slice(startDot, end);
  },
  format: function format(pathObject) {
    if (pathObject === null || _typeof(pathObject) !== 'object') {
      throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + _typeof(pathObject));
    }
    return _format('/', pathObject);
  },
  parse: function parse(path) {
    assertPath(path);
    var ret = {
      root: '',
      dir: '',
      base: '',
      ext: '',
      name: ''
    };
    if (path.length === 0) return ret;
    var code = path.charCodeAt(0);
    var isAbsolute = code === 47 /*/*/;
    var start;
    if (isAbsolute) {
      ret.root = '/';
      start = 1;
    } else {
      start = 0;
    }
    var startDot = -1;
    var startPart = 0;
    var end = -1;
    var matchedSlash = true;
    var i = path.length - 1;

    // Track the state of characters (if any) we see before our first dot and
    // after any path separator we find
    var preDotState = 0;

    // Get non-dir info
    for (; i >= start; --i) {
      code = path.charCodeAt(i);
      if (code === 47 /*/*/) {
        // If we reached a path separator that was not part of a set of path
        // separators at the end of the string, stop now
        if (!matchedSlash) {
          startPart = i + 1;
          break;
        }
        continue;
      }
      if (end === -1) {
        // We saw the first non-path separator, mark this as the end of our
        // extension
        matchedSlash = false;
        end = i + 1;
      }
      if (code === 46 /*.*/) {
        // If this is our first dot, mark it as the start of our extension
        if (startDot === -1) startDot = i;else if (preDotState !== 1) preDotState = 1;
      } else if (startDot !== -1) {
        // We saw a non-dot and non-path separator before our dot, so we should
        // have a good chance at having a non-empty extension
        preDotState = -1;
      }
    }
    if (startDot === -1 || end === -1 ||
    // We saw a non-dot character immediately before the dot
    preDotState === 0 ||
    // The (right-most) trimmed path component is exactly '..'
    preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
      if (end !== -1) {
        if (startPart === 0 && isAbsolute) ret.base = ret.name = path.slice(1, end);else ret.base = ret.name = path.slice(startPart, end);
      }
    } else {
      if (startPart === 0 && isAbsolute) {
        ret.name = path.slice(1, startDot);
        ret.base = path.slice(1, end);
      } else {
        ret.name = path.slice(startPart, startDot);
        ret.base = path.slice(startPart, end);
      }
      ret.ext = path.slice(startDot, end);
    }
    if (startPart > 0) ret.dir = path.slice(0, startPart - 1);else if (isAbsolute) ret.dir = '/';
    return ret;
  },
  sep: '/',
  delimiter: ':',
  win32: null,
  posix: null
};
posix.posix = posix;
module.exports = posix;

/***/ }),

/***/ "./node_modules/stream-browserify/index.js":
/*!*************************************************!*\
  !*** ./node_modules/stream-browserify/index.js ***!
  \*************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

module.exports = Stream;
var EE = (__webpack_require__(/*! events */ "./node_modules/events/events.js").EventEmitter);
var inherits = __webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js");
inherits(Stream, EE);
Stream.Readable = __webpack_require__(/*! readable-stream/lib/_stream_readable.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_readable.js");
Stream.Writable = __webpack_require__(/*! readable-stream/lib/_stream_writable.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_writable.js");
Stream.Duplex = __webpack_require__(/*! readable-stream/lib/_stream_duplex.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js");
Stream.Transform = __webpack_require__(/*! readable-stream/lib/_stream_transform.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_transform.js");
Stream.PassThrough = __webpack_require__(/*! readable-stream/lib/_stream_passthrough.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_passthrough.js");
Stream.finished = __webpack_require__(/*! readable-stream/lib/internal/streams/end-of-stream.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/end-of-stream.js");
Stream.pipeline = __webpack_require__(/*! readable-stream/lib/internal/streams/pipeline.js */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/pipeline.js");

// Backwards-compat with node 0.4.x
Stream.Stream = Stream;

// old-style streams.  Note that the pipe method (the only relevant
// part of this class) is overridden in the Readable class.

function Stream() {
  EE.call(this);
}
Stream.prototype.pipe = function (dest, options) {
  var source = this;
  function ondata(chunk) {
    if (dest.writable) {
      if (false === dest.write(chunk) && source.pause) {
        source.pause();
      }
    }
  }
  source.on('data', ondata);
  function ondrain() {
    if (source.readable && source.resume) {
      source.resume();
    }
  }
  dest.on('drain', ondrain);

  // If the 'end' option is not supplied, dest.end() will be called when
  // source gets the 'end' or 'close' events.  Only dest.end() once.
  if (!dest._isStdio && (!options || options.end !== false)) {
    source.on('end', onend);
    source.on('close', onclose);
  }
  var didOnEnd = false;
  function onend() {
    if (didOnEnd) return;
    didOnEnd = true;
    dest.end();
  }
  function onclose() {
    if (didOnEnd) return;
    didOnEnd = true;
    if (typeof dest.destroy === 'function') dest.destroy();
  }

  // don't leave dangling pipes when there are errors.
  function onerror(er) {
    cleanup();
    if (EE.listenerCount(this, 'error') === 0) {
      throw er; // Unhandled stream error in pipe.
    }
  }
  source.on('error', onerror);
  dest.on('error', onerror);

  // remove all the event listeners that were added.
  function cleanup() {
    source.removeListener('data', ondata);
    dest.removeListener('drain', ondrain);
    source.removeListener('end', onend);
    source.removeListener('close', onclose);
    source.removeListener('error', onerror);
    dest.removeListener('error', onerror);
    source.removeListener('end', cleanup);
    source.removeListener('close', cleanup);
    dest.removeListener('close', cleanup);
  }
  source.on('end', cleanup);
  source.on('close', cleanup);
  dest.on('close', cleanup);
  dest.emit('pipe', source);

  // Allow for unix-like usage: A.pipe(B).pipe(C)
  return dest;
};

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js ***!
  \***************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
__webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
__webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}
var codes = {};
function createErrorType(code, message, Base) {
  if (!Base) {
    Base = Error;
  }
  function getMessage(arg1, arg2, arg3) {
    if (typeof message === 'string') {
      return message;
    } else {
      return message(arg1, arg2, arg3);
    }
  }
  var NodeError = /*#__PURE__*/
  function (_Base) {
    _inheritsLoose(NodeError, _Base);
    function NodeError(arg1, arg2, arg3) {
      return _Base.call(this, getMessage(arg1, arg2, arg3)) || this;
    }
    return NodeError;
  }(Base);
  NodeError.prototype.name = Base.name;
  NodeError.prototype.code = code;
  codes[code] = NodeError;
} // https://github.com/nodejs/node/blob/v10.8.0/lib/internal/errors.js

function oneOf(expected, thing) {
  if (Array.isArray(expected)) {
    var len = expected.length;
    expected = expected.map(function (i) {
      return String(i);
    });
    if (len > 2) {
      return "one of ".concat(thing, " ").concat(expected.slice(0, len - 1).join(', '), ", or ") + expected[len - 1];
    } else if (len === 2) {
      return "one of ".concat(thing, " ").concat(expected[0], " or ").concat(expected[1]);
    } else {
      return "of ".concat(thing, " ").concat(expected[0]);
    }
  } else {
    return "of ".concat(thing, " ").concat(String(expected));
  }
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/startsWith

function startsWith(str, search, pos) {
  return str.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/endsWith

function endsWith(str, search, this_len) {
  if (this_len === undefined || this_len > str.length) {
    this_len = str.length;
  }
  return str.substring(this_len - search.length, this_len) === search;
} // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/includes

function includes(str, search, start) {
  if (typeof start !== 'number') {
    start = 0;
  }
  if (start + search.length > str.length) {
    return false;
  } else {
    return str.indexOf(search, start) !== -1;
  }
}
createErrorType('ERR_INVALID_OPT_VALUE', function (name, value) {
  return 'The value "' + value + '" is invalid for option "' + name + '"';
}, TypeError);
createErrorType('ERR_INVALID_ARG_TYPE', function (name, expected, actual) {
  // determiner: 'must be' or 'must not be'
  var determiner;
  if (typeof expected === 'string' && startsWith(expected, 'not ')) {
    determiner = 'must not be';
    expected = expected.replace(/^not /, '');
  } else {
    determiner = 'must be';
  }
  var msg;
  if (endsWith(name, ' argument')) {
    // For cases like 'first argument'
    msg = "The ".concat(name, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  } else {
    var type = includes(name, '.') ? 'property' : 'argument';
    msg = "The \"".concat(name, "\" ").concat(type, " ").concat(determiner, " ").concat(oneOf(expected, 'type'));
  }
  msg += ". Received type ".concat(_typeof(actual));
  return msg;
}, TypeError);
createErrorType('ERR_STREAM_PUSH_AFTER_EOF', 'stream.push() after EOF');
createErrorType('ERR_METHOD_NOT_IMPLEMENTED', function (name) {
  return 'The ' + name + ' method is not implemented';
});
createErrorType('ERR_STREAM_PREMATURE_CLOSE', 'Premature close');
createErrorType('ERR_STREAM_DESTROYED', function (name) {
  return 'Cannot call ' + name + ' after a stream was destroyed';
});
createErrorType('ERR_MULTIPLE_CALLBACK', 'Callback called multiple times');
createErrorType('ERR_STREAM_CANNOT_PIPE', 'Cannot pipe, not readable');
createErrorType('ERR_STREAM_WRITE_AFTER_END', 'write after end');
createErrorType('ERR_STREAM_NULL_VALUES', 'May not write null values to stream', TypeError);
createErrorType('ERR_UNKNOWN_ENCODING', function (arg) {
  return 'Unknown encoding: ' + arg;
}, TypeError);
createErrorType('ERR_STREAM_UNSHIFT_AFTER_END_EVENT', 'stream.unshift() after end event');
module.exports.codes = codes;

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js ***!
  \*******************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a duplex stream is just a stream that is both readable and writable.
// Since JS doesn't have multiple prototypal inheritance, this class
// prototypally inherits from Readable, and then parasitically from
// Writable.



/*<replacement>*/
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
var objectKeys = Object.keys || function (obj) {
  var keys = [];
  for (var key in obj) keys.push(key);
  return keys;
};
/*</replacement>*/

module.exports = Duplex;
var Readable = __webpack_require__(/*! ./_stream_readable */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_readable.js");
var Writable = __webpack_require__(/*! ./_stream_writable */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_writable.js");
__webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js")(Duplex, Readable);
{
  // Allow the keys array to be GC'ed.
  var keys = objectKeys(Writable.prototype);
  for (var v = 0; v < keys.length; v++) {
    var method = keys[v];
    if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
  }
}
function Duplex(options) {
  if (!(this instanceof Duplex)) return new Duplex(options);
  Readable.call(this, options);
  Writable.call(this, options);
  this.allowHalfOpen = true;
  if (options) {
    if (options.readable === false) this.readable = false;
    if (options.writable === false) this.writable = false;
    if (options.allowHalfOpen === false) {
      this.allowHalfOpen = false;
      this.once('end', onend);
    }
  }
}
Object.defineProperty(Duplex.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._writableState.highWaterMark;
  }
});
Object.defineProperty(Duplex.prototype, 'writableBuffer', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._writableState && this._writableState.getBuffer();
  }
});
Object.defineProperty(Duplex.prototype, 'writableLength', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._writableState.length;
  }
});

// the no-half-open enforcer
function onend() {
  // If the writable side ended, then we're ok.
  if (this._writableState.ended) return;

  // no more data can be written.
  // But allow more writes to happen in this tick.
  process.nextTick(onEndNT, this);
}
function onEndNT(self) {
  self.end();
}
Object.defineProperty(Duplex.prototype, 'destroyed', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    if (this._readableState === undefined || this._writableState === undefined) {
      return false;
    }
    return this._readableState.destroyed && this._writableState.destroyed;
  },
  set: function set(value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (this._readableState === undefined || this._writableState === undefined) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
    this._writableState.destroyed = value;
  }
});

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_passthrough.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_passthrough.js ***!
  \************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a passthrough stream.
// basically just the most minimal sort of Transform stream.
// Every written chunk gets output as-is.



module.exports = PassThrough;
var Transform = __webpack_require__(/*! ./_stream_transform */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_transform.js");
__webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js")(PassThrough, Transform);
function PassThrough(options) {
  if (!(this instanceof PassThrough)) return new PassThrough(options);
  Transform.call(this, options);
}
PassThrough.prototype._transform = function (chunk, encoding, cb) {
  cb(null, chunk);
};

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_readable.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_readable.js ***!
  \*********************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



__webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
__webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
__webpack_require__(/*! core-js/modules/es.symbol.async-iterator.js */ "./node_modules/core-js/modules/es.symbol.async-iterator.js");
__webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
__webpack_require__(/*! core-js/modules/es.array.join.js */ "./node_modules/core-js/modules/es.array.join.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.splice.js */ "./node_modules/core-js/modules/es.array.splice.js");
__webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/web.self.js */ "./node_modules/core-js/modules/web.self.js");
module.exports = Readable;

/*<replacement>*/
var Duplex;
/*</replacement>*/

Readable.ReadableState = ReadableState;

/*<replacement>*/
var EE = (__webpack_require__(/*! events */ "./node_modules/events/events.js").EventEmitter);
var EElistenerCount = function EElistenerCount(emitter, type) {
  return emitter.listeners(type).length;
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(/*! ./internal/streams/stream */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/stream-browser.js");
/*</replacement>*/

var Buffer = (__webpack_require__(/*! buffer */ "./node_modules/buffer/index.js").Buffer);
var OurUint8Array = (typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}

/*<replacement>*/
var debugUtil = __webpack_require__(/*! util */ "?19e6");
var debug;
if (debugUtil && debugUtil.debuglog) {
  debug = debugUtil.debuglog('stream');
} else {
  debug = function debug() {};
}
/*</replacement>*/

var BufferList = __webpack_require__(/*! ./internal/streams/buffer_list */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/buffer_list.js");
var destroyImpl = __webpack_require__(/*! ./internal/streams/destroy */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/destroy.js");
var _require = __webpack_require__(/*! ./internal/streams/state */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/state.js"),
  getHighWaterMark = _require.getHighWaterMark;
var _require$codes = (__webpack_require__(/*! ../errors */ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js").codes),
  ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
  ERR_STREAM_PUSH_AFTER_EOF = _require$codes.ERR_STREAM_PUSH_AFTER_EOF,
  ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED,
  ERR_STREAM_UNSHIFT_AFTER_END_EVENT = _require$codes.ERR_STREAM_UNSHIFT_AFTER_END_EVENT;

// Lazy loaded to improve the startup performance.
var StringDecoder;
var createReadableStreamAsyncIterator;
var from;
__webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js")(Readable, Stream);
var errorOrDestroy = destroyImpl.errorOrDestroy;
var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];
function prependListener(emitter, event, fn) {
  // Sadly this is not cacheable as some libraries bundle their own
  // event emitter implementation with them.
  if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn);

  // This is a hack to make sure that our error handler is attached before any
  // userland ones.  NEVER DO THIS. This is here only because this code needs
  // to continue to work with older versions of Node.js that do not include
  // the prependListener() method. The goal is to eventually remove this hack.
  if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (Array.isArray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
}
function ReadableState(options, stream, isDuplex) {
  Duplex = Duplex || __webpack_require__(/*! ./_stream_duplex */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js");
  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream.
  // These options can be provided separately as readableXXX and writableXXX.
  if (typeof isDuplex !== 'boolean') isDuplex = stream instanceof Duplex;

  // object stream flag. Used to make read(n) ignore n and to
  // make all the buffer merging and length checks go away
  this.objectMode = !!options.objectMode;
  if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

  // the point at which it stops calling _read() to fill the buffer
  // Note: 0 is a valid value, means "don't call _read preemptively ever"
  this.highWaterMark = getHighWaterMark(this, options, 'readableHighWaterMark', isDuplex);

  // A linked list is used to store data chunks instead of an array because the
  // linked list can remove elements from the beginning faster than
  // array.shift()
  this.buffer = new BufferList();
  this.length = 0;
  this.pipes = null;
  this.pipesCount = 0;
  this.flowing = null;
  this.ended = false;
  this.endEmitted = false;
  this.reading = false;

  // a flag to be able to tell if the event 'readable'/'data' is emitted
  // immediately, or on a later tick.  We set this to true at first, because
  // any actions that shouldn't happen until "later" should generally also
  // not happen before the first read call.
  this.sync = true;

  // whenever we return null, then we set a flag to say
  // that we're awaiting a 'readable' event emission.
  this.needReadable = false;
  this.emittedReadable = false;
  this.readableListening = false;
  this.resumeScheduled = false;
  this.paused = true;

  // Should close be emitted on destroy. Defaults to true.
  this.emitClose = options.emitClose !== false;

  // Should .destroy() be called after 'end' (and potentially 'finish')
  this.autoDestroy = !!options.autoDestroy;

  // has it been destroyed
  this.destroyed = false;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // the number of writers that are awaiting a drain event in .pipe()s
  this.awaitDrain = 0;

  // if true, a maybeReadMore has been scheduled
  this.readingMore = false;
  this.decoder = null;
  this.encoding = null;
  if (options.encoding) {
    if (!StringDecoder) StringDecoder = (__webpack_require__(/*! string_decoder/ */ "./node_modules/string_decoder/lib/string_decoder.js").StringDecoder);
    this.decoder = new StringDecoder(options.encoding);
    this.encoding = options.encoding;
  }
}
function Readable(options) {
  Duplex = Duplex || __webpack_require__(/*! ./_stream_duplex */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js");
  if (!(this instanceof Readable)) return new Readable(options);

  // Checking for a Stream.Duplex instance is faster here instead of inside
  // the ReadableState constructor, at least with V8 6.5
  var isDuplex = this instanceof Duplex;
  this._readableState = new ReadableState(options, this, isDuplex);

  // legacy
  this.readable = true;
  if (options) {
    if (typeof options.read === 'function') this._read = options.read;
    if (typeof options.destroy === 'function') this._destroy = options.destroy;
  }
  Stream.call(this);
}
Object.defineProperty(Readable.prototype, 'destroyed', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    if (this._readableState === undefined) {
      return false;
    }
    return this._readableState.destroyed;
  },
  set: function set(value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._readableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._readableState.destroyed = value;
  }
});
Readable.prototype.destroy = destroyImpl.destroy;
Readable.prototype._undestroy = destroyImpl.undestroy;
Readable.prototype._destroy = function (err, cb) {
  cb(err);
};

// Manually shove something into the read() buffer.
// This returns true if the highWaterMark has not been hit yet,
// similar to how Writable.write() returns true if you should
// write() some more.
Readable.prototype.push = function (chunk, encoding) {
  var state = this._readableState;
  var skipChunkCheck;
  if (!state.objectMode) {
    if (typeof chunk === 'string') {
      encoding = encoding || state.defaultEncoding;
      if (encoding !== state.encoding) {
        chunk = Buffer.from(chunk, encoding);
        encoding = '';
      }
      skipChunkCheck = true;
    }
  } else {
    skipChunkCheck = true;
  }
  return readableAddChunk(this, chunk, encoding, false, skipChunkCheck);
};

// Unshift should *always* be something directly out of read()
Readable.prototype.unshift = function (chunk) {
  return readableAddChunk(this, chunk, null, true, false);
};
function readableAddChunk(stream, chunk, encoding, addToFront, skipChunkCheck) {
  debug('readableAddChunk', chunk);
  var state = stream._readableState;
  if (chunk === null) {
    state.reading = false;
    onEofChunk(stream, state);
  } else {
    var er;
    if (!skipChunkCheck) er = chunkInvalid(state, chunk);
    if (er) {
      errorOrDestroy(stream, er);
    } else if (state.objectMode || chunk && chunk.length > 0) {
      if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer.prototype) {
        chunk = _uint8ArrayToBuffer(chunk);
      }
      if (addToFront) {
        if (state.endEmitted) errorOrDestroy(stream, new ERR_STREAM_UNSHIFT_AFTER_END_EVENT());else addChunk(stream, state, chunk, true);
      } else if (state.ended) {
        errorOrDestroy(stream, new ERR_STREAM_PUSH_AFTER_EOF());
      } else if (state.destroyed) {
        return false;
      } else {
        state.reading = false;
        if (state.decoder && !encoding) {
          chunk = state.decoder.write(chunk);
          if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore(stream, state);
        } else {
          addChunk(stream, state, chunk, false);
        }
      }
    } else if (!addToFront) {
      state.reading = false;
      maybeReadMore(stream, state);
    }
  }

  // We can push more data if we are below the highWaterMark.
  // Also, if we have no data yet, we can stand some more bytes.
  // This is to work around cases where hwm=0, such as the repl.
  return !state.ended && (state.length < state.highWaterMark || state.length === 0);
}
function addChunk(stream, state, chunk, addToFront) {
  if (state.flowing && state.length === 0 && !state.sync) {
    state.awaitDrain = 0;
    stream.emit('data', chunk);
  } else {
    // update the buffer info.
    state.length += state.objectMode ? 1 : chunk.length;
    if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);
    if (state.needReadable) emitReadable(stream);
  }
  maybeReadMore(stream, state);
}
function chunkInvalid(state, chunk) {
  var er;
  if (!_isUint8Array(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
    er = new ERR_INVALID_ARG_TYPE('chunk', ['string', 'Buffer', 'Uint8Array'], chunk);
  }
  return er;
}
Readable.prototype.isPaused = function () {
  return this._readableState.flowing === false;
};

// backwards compatibility.
Readable.prototype.setEncoding = function (enc) {
  if (!StringDecoder) StringDecoder = (__webpack_require__(/*! string_decoder/ */ "./node_modules/string_decoder/lib/string_decoder.js").StringDecoder);
  var decoder = new StringDecoder(enc);
  this._readableState.decoder = decoder;
  // If setEncoding(null), decoder.encoding equals utf8
  this._readableState.encoding = this._readableState.decoder.encoding;

  // Iterate over current buffer to convert already stored Buffers:
  var p = this._readableState.buffer.head;
  var content = '';
  while (p !== null) {
    content += decoder.write(p.data);
    p = p.next;
  }
  this._readableState.buffer.clear();
  if (content !== '') this._readableState.buffer.push(content);
  this._readableState.length = content.length;
  return this;
};

// Don't raise the hwm > 1GB
var MAX_HWM = 0x40000000;
function computeNewHighWaterMark(n) {
  if (n >= MAX_HWM) {
    // TODO(ronag): Throw ERR_VALUE_OUT_OF_RANGE.
    n = MAX_HWM;
  } else {
    // Get the next highest power of 2 to prevent increasing hwm excessively in
    // tiny amounts
    n--;
    n |= n >>> 1;
    n |= n >>> 2;
    n |= n >>> 4;
    n |= n >>> 8;
    n |= n >>> 16;
    n++;
  }
  return n;
}

// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function howMuchToRead(n, state) {
  if (n <= 0 || state.length === 0 && state.ended) return 0;
  if (state.objectMode) return 1;
  if (n !== n) {
    // Only flow one buffer at a time
    if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
  }
  // If we're asking for more than the current hwm, then raise the hwm.
  if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
  if (n <= state.length) return n;
  // Don't have enough
  if (!state.ended) {
    state.needReadable = true;
    return 0;
  }
  return state.length;
}

// you can override either this method, or the async _read(n) below.
Readable.prototype.read = function (n) {
  debug('read', n);
  n = parseInt(n, 10);
  var state = this._readableState;
  var nOrig = n;
  if (n !== 0) state.emittedReadable = false;

  // if we're doing read(0) to trigger a readable event, but we
  // already have a bunch of data in the buffer, then just trigger
  // the 'readable' event and move on.
  if (n === 0 && state.needReadable && ((state.highWaterMark !== 0 ? state.length >= state.highWaterMark : state.length > 0) || state.ended)) {
    debug('read: emitReadable', state.length, state.ended);
    if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
    return null;
  }
  n = howMuchToRead(n, state);

  // if we've ended, and we're now clear, then finish it up.
  if (n === 0 && state.ended) {
    if (state.length === 0) endReadable(this);
    return null;
  }

  // All the actual chunk generation logic needs to be
  // *below* the call to _read.  The reason is that in certain
  // synthetic stream cases, such as passthrough streams, _read
  // may be a completely synchronous operation which may change
  // the state of the read buffer, providing enough data when
  // before there was *not* enough.
  //
  // So, the steps are:
  // 1. Figure out what the state of things will be after we do
  // a read from the buffer.
  //
  // 2. If that resulting state will trigger a _read, then call _read.
  // Note that this may be asynchronous, or synchronous.  Yes, it is
  // deeply ugly to write APIs this way, but that still doesn't mean
  // that the Readable class should behave improperly, as streams are
  // designed to be sync/async agnostic.
  // Take note if the _read call is sync or async (ie, if the read call
  // has returned yet), so that we know whether or not it's safe to emit
  // 'readable' etc.
  //
  // 3. Actually pull the requested chunks out of the buffer and return.

  // if we need a readable event, then we need to do some reading.
  var doRead = state.needReadable;
  debug('need readable', doRead);

  // if we currently have less than the highWaterMark, then also read some
  if (state.length === 0 || state.length - n < state.highWaterMark) {
    doRead = true;
    debug('length less than watermark', doRead);
  }

  // however, if we've ended, then there's no point, and if we're already
  // reading, then it's unnecessary.
  if (state.ended || state.reading) {
    doRead = false;
    debug('reading or ended', doRead);
  } else if (doRead) {
    debug('do read');
    state.reading = true;
    state.sync = true;
    // if the length is currently zero, then we *need* a readable event.
    if (state.length === 0) state.needReadable = true;
    // call internal read method
    this._read(state.highWaterMark);
    state.sync = false;
    // If _read pushed data synchronously, then `reading` will be false,
    // and we need to re-evaluate how much data we can return to the user.
    if (!state.reading) n = howMuchToRead(nOrig, state);
  }
  var ret;
  if (n > 0) ret = fromList(n, state);else ret = null;
  if (ret === null) {
    state.needReadable = state.length <= state.highWaterMark;
    n = 0;
  } else {
    state.length -= n;
    state.awaitDrain = 0;
  }
  if (state.length === 0) {
    // If we have nothing in the buffer, then we want to know
    // as soon as we *do* get something into the buffer.
    if (!state.ended) state.needReadable = true;

    // If we tried to read() past the EOF, then emit end on the next tick.
    if (nOrig !== n && state.ended) endReadable(this);
  }
  if (ret !== null) this.emit('data', ret);
  return ret;
};
function onEofChunk(stream, state) {
  debug('onEofChunk');
  if (state.ended) return;
  if (state.decoder) {
    var chunk = state.decoder.end();
    if (chunk && chunk.length) {
      state.buffer.push(chunk);
      state.length += state.objectMode ? 1 : chunk.length;
    }
  }
  state.ended = true;
  if (state.sync) {
    // if we are sync, wait until next tick to emit the data.
    // Otherwise we risk emitting data in the flow()
    // the readable code triggers during a read() call
    emitReadable(stream);
  } else {
    // emit 'readable' now to make sure it gets picked up.
    state.needReadable = false;
    if (!state.emittedReadable) {
      state.emittedReadable = true;
      emitReadable_(stream);
    }
  }
}

// Don't emit readable right away in sync mode, because this can trigger
// another read() call => stack overflow.  This way, it might trigger
// a nextTick recursion warning, but that's not so bad.
function emitReadable(stream) {
  var state = stream._readableState;
  debug('emitReadable', state.needReadable, state.emittedReadable);
  state.needReadable = false;
  if (!state.emittedReadable) {
    debug('emitReadable', state.flowing);
    state.emittedReadable = true;
    process.nextTick(emitReadable_, stream);
  }
}
function emitReadable_(stream) {
  var state = stream._readableState;
  debug('emitReadable_', state.destroyed, state.length, state.ended);
  if (!state.destroyed && (state.length || state.ended)) {
    stream.emit('readable');
    state.emittedReadable = false;
  }

  // The stream needs another readable event if
  // 1. It is not flowing, as the flow mechanism will take
  //    care of it.
  // 2. It is not ended.
  // 3. It is below the highWaterMark, so we can schedule
  //    another readable later.
  state.needReadable = !state.flowing && !state.ended && state.length <= state.highWaterMark;
  flow(stream);
}

// at this point, the user has presumably seen the 'readable' event,
// and called read() to consume some data.  that may have triggered
// in turn another _read(n) call, in which case reading = true if
// it's in progress.
// However, if we're not ended, or reading, and the length < hwm,
// then go ahead and try to read some more preemptively.
function maybeReadMore(stream, state) {
  if (!state.readingMore) {
    state.readingMore = true;
    process.nextTick(maybeReadMore_, stream, state);
  }
}
function maybeReadMore_(stream, state) {
  // Attempt to read more data if we should.
  //
  // The conditions for reading more data are (one of):
  // - Not enough data buffered (state.length < state.highWaterMark). The loop
  //   is responsible for filling the buffer with enough data if such data
  //   is available. If highWaterMark is 0 and we are not in the flowing mode
  //   we should _not_ attempt to buffer any extra data. We'll get more data
  //   when the stream consumer calls read() instead.
  // - No data in the buffer, and the stream is in flowing mode. In this mode
  //   the loop below is responsible for ensuring read() is called. Failing to
  //   call read here would abort the flow and there's no other mechanism for
  //   continuing the flow if the stream consumer has just subscribed to the
  //   'data' event.
  //
  // In addition to the above conditions to keep reading data, the following
  // conditions prevent the data from being read:
  // - The stream has ended (state.ended).
  // - There is already a pending 'read' operation (state.reading). This is a
  //   case where the the stream has called the implementation defined _read()
  //   method, but they are processing the call asynchronously and have _not_
  //   called push() with new data. In this case we skip performing more
  //   read()s. The execution ends in this method again after the _read() ends
  //   up calling push() with more data.
  while (!state.reading && !state.ended && (state.length < state.highWaterMark || state.flowing && state.length === 0)) {
    var len = state.length;
    debug('maybeReadMore read 0');
    stream.read(0);
    if (len === state.length)
      // didn't get any data, stop spinning.
      break;
  }
  state.readingMore = false;
}

// abstract method.  to be overridden in specific implementation classes.
// call cb(er, data) where data is <= n in length.
// for virtual (non-string, non-buffer) streams, "length" is somewhat
// arbitrary, and perhaps not very meaningful.
Readable.prototype._read = function (n) {
  errorOrDestroy(this, new ERR_METHOD_NOT_IMPLEMENTED('_read()'));
};
Readable.prototype.pipe = function (dest, pipeOpts) {
  var src = this;
  var state = this._readableState;
  switch (state.pipesCount) {
    case 0:
      state.pipes = dest;
      break;
    case 1:
      state.pipes = [state.pipes, dest];
      break;
    default:
      state.pipes.push(dest);
      break;
  }
  state.pipesCount += 1;
  debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);
  var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;
  var endFn = doEnd ? onend : unpipe;
  if (state.endEmitted) process.nextTick(endFn);else src.once('end', endFn);
  dest.on('unpipe', onunpipe);
  function onunpipe(readable, unpipeInfo) {
    debug('onunpipe');
    if (readable === src) {
      if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
        unpipeInfo.hasUnpiped = true;
        cleanup();
      }
    }
  }
  function onend() {
    debug('onend');
    dest.end();
  }

  // when the dest drains, it reduces the awaitDrain counter
  // on the source.  This would be more elegant with a .once()
  // handler in flow(), but adding and removing repeatedly is
  // too slow.
  var ondrain = pipeOnDrain(src);
  dest.on('drain', ondrain);
  var cleanedUp = false;
  function cleanup() {
    debug('cleanup');
    // cleanup event handlers once the pipe is broken
    dest.removeListener('close', onclose);
    dest.removeListener('finish', onfinish);
    dest.removeListener('drain', ondrain);
    dest.removeListener('error', onerror);
    dest.removeListener('unpipe', onunpipe);
    src.removeListener('end', onend);
    src.removeListener('end', unpipe);
    src.removeListener('data', ondata);
    cleanedUp = true;

    // if the reader is waiting for a drain event from this
    // specific writer, then it would cause it to never start
    // flowing again.
    // So, if this is awaiting a drain, then we just call it now.
    // If we don't know, then assume that we are waiting for one.
    if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
  }
  src.on('data', ondata);
  function ondata(chunk) {
    debug('ondata');
    var ret = dest.write(chunk);
    debug('dest.write', ret);
    if (ret === false) {
      // If the user unpiped during `dest.write()`, it is possible
      // to get stuck in a permanently paused state if that write
      // also returned false.
      // => Check whether `dest` is still a piping destination.
      if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
        debug('false write response, pause', state.awaitDrain);
        state.awaitDrain++;
      }
      src.pause();
    }
  }

  // if the dest has an error, then stop piping into it.
  // however, don't suppress the throwing behavior for this.
  function onerror(er) {
    debug('onerror', er);
    unpipe();
    dest.removeListener('error', onerror);
    if (EElistenerCount(dest, 'error') === 0) errorOrDestroy(dest, er);
  }

  // Make sure our error handler is attached before userland ones.
  prependListener(dest, 'error', onerror);

  // Both close and finish should trigger unpipe, but only once.
  function onclose() {
    dest.removeListener('finish', onfinish);
    unpipe();
  }
  dest.once('close', onclose);
  function onfinish() {
    debug('onfinish');
    dest.removeListener('close', onclose);
    unpipe();
  }
  dest.once('finish', onfinish);
  function unpipe() {
    debug('unpipe');
    src.unpipe(dest);
  }

  // tell the dest that it's being piped to
  dest.emit('pipe', src);

  // start the flow if it hasn't been started already.
  if (!state.flowing) {
    debug('pipe resume');
    src.resume();
  }
  return dest;
};
function pipeOnDrain(src) {
  return function pipeOnDrainFunctionResult() {
    var state = src._readableState;
    debug('pipeOnDrain', state.awaitDrain);
    if (state.awaitDrain) state.awaitDrain--;
    if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
      state.flowing = true;
      flow(src);
    }
  };
}
Readable.prototype.unpipe = function (dest) {
  var state = this._readableState;
  var unpipeInfo = {
    hasUnpiped: false
  };

  // if we're not piping anywhere, then do nothing.
  if (state.pipesCount === 0) return this;

  // just one destination.  most common case.
  if (state.pipesCount === 1) {
    // passed in one, but it's not the right one.
    if (dest && dest !== state.pipes) return this;
    if (!dest) dest = state.pipes;

    // got a match.
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;
    if (dest) dest.emit('unpipe', this, unpipeInfo);
    return this;
  }

  // slow case. multiple pipe destinations.

  if (!dest) {
    // remove all.
    var dests = state.pipes;
    var len = state.pipesCount;
    state.pipes = null;
    state.pipesCount = 0;
    state.flowing = false;
    for (var i = 0; i < len; i++) dests[i].emit('unpipe', this, {
      hasUnpiped: false
    });
    return this;
  }

  // try to find the right one.
  var index = indexOf(state.pipes, dest);
  if (index === -1) return this;
  state.pipes.splice(index, 1);
  state.pipesCount -= 1;
  if (state.pipesCount === 1) state.pipes = state.pipes[0];
  dest.emit('unpipe', this, unpipeInfo);
  return this;
};

// set up data events if they are asked for
// Ensure readable listeners eventually get something
Readable.prototype.on = function (ev, fn) {
  var res = Stream.prototype.on.call(this, ev, fn);
  var state = this._readableState;
  if (ev === 'data') {
    // update readableListening so that resume() may be a no-op
    // a few lines down. This is needed to support once('readable').
    state.readableListening = this.listenerCount('readable') > 0;

    // Try start flowing on next tick if stream isn't explicitly paused
    if (state.flowing !== false) this.resume();
  } else if (ev === 'readable') {
    if (!state.endEmitted && !state.readableListening) {
      state.readableListening = state.needReadable = true;
      state.flowing = false;
      state.emittedReadable = false;
      debug('on readable', state.length, state.reading);
      if (state.length) {
        emitReadable(this);
      } else if (!state.reading) {
        process.nextTick(nReadingNextTick, this);
      }
    }
  }
  return res;
};
Readable.prototype.addListener = Readable.prototype.on;
Readable.prototype.removeListener = function (ev, fn) {
  var res = Stream.prototype.removeListener.call(this, ev, fn);
  if (ev === 'readable') {
    // We need to check if there is someone still listening to
    // readable and reset the state. However this needs to happen
    // after readable has been emitted but before I/O (nextTick) to
    // support once('readable', fn) cycles. This means that calling
    // resume within the same tick will have no
    // effect.
    process.nextTick(updateReadableListening, this);
  }
  return res;
};
Readable.prototype.removeAllListeners = function (ev) {
  var res = Stream.prototype.removeAllListeners.apply(this, arguments);
  if (ev === 'readable' || ev === undefined) {
    // We need to check if there is someone still listening to
    // readable and reset the state. However this needs to happen
    // after readable has been emitted but before I/O (nextTick) to
    // support once('readable', fn) cycles. This means that calling
    // resume within the same tick will have no
    // effect.
    process.nextTick(updateReadableListening, this);
  }
  return res;
};
function updateReadableListening(self) {
  var state = self._readableState;
  state.readableListening = self.listenerCount('readable') > 0;
  if (state.resumeScheduled && !state.paused) {
    // flowing needs to be set to true now, otherwise
    // the upcoming resume will not flow.
    state.flowing = true;

    // crude way to check if we should resume
  } else if (self.listenerCount('data') > 0) {
    self.resume();
  }
}
function nReadingNextTick(self) {
  debug('readable nexttick read 0');
  self.read(0);
}

// pause() and resume() are remnants of the legacy readable stream API
// If the user uses them, then switch into old mode.
Readable.prototype.resume = function () {
  var state = this._readableState;
  if (!state.flowing) {
    debug('resume');
    // we flow only if there is no one listening
    // for readable, but we still have to call
    // resume()
    state.flowing = !state.readableListening;
    resume(this, state);
  }
  state.paused = false;
  return this;
};
function resume(stream, state) {
  if (!state.resumeScheduled) {
    state.resumeScheduled = true;
    process.nextTick(resume_, stream, state);
  }
}
function resume_(stream, state) {
  debug('resume', state.reading);
  if (!state.reading) {
    stream.read(0);
  }
  state.resumeScheduled = false;
  stream.emit('resume');
  flow(stream);
  if (state.flowing && !state.reading) stream.read(0);
}
Readable.prototype.pause = function () {
  debug('call pause flowing=%j', this._readableState.flowing);
  if (this._readableState.flowing !== false) {
    debug('pause');
    this._readableState.flowing = false;
    this.emit('pause');
  }
  this._readableState.paused = true;
  return this;
};
function flow(stream) {
  var state = stream._readableState;
  debug('flow', state.flowing);
  while (state.flowing && stream.read() !== null);
}

// wrap an old-style stream as the async data source.
// This is *not* part of the readable stream interface.
// It is an ugly unfortunate mess of history.
Readable.prototype.wrap = function (stream) {
  var _this = this;
  var state = this._readableState;
  var paused = false;
  stream.on('end', function () {
    debug('wrapped end');
    if (state.decoder && !state.ended) {
      var chunk = state.decoder.end();
      if (chunk && chunk.length) _this.push(chunk);
    }
    _this.push(null);
  });
  stream.on('data', function (chunk) {
    debug('wrapped data');
    if (state.decoder) chunk = state.decoder.write(chunk);

    // don't skip over falsy values in objectMode
    if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;
    var ret = _this.push(chunk);
    if (!ret) {
      paused = true;
      stream.pause();
    }
  });

  // proxy all the other methods.
  // important when wrapping filters and duplexes.
  for (var i in stream) {
    if (this[i] === undefined && typeof stream[i] === 'function') {
      this[i] = function methodWrap(method) {
        return function methodWrapReturnFunction() {
          return stream[method].apply(stream, arguments);
        };
      }(i);
    }
  }

  // proxy certain important events.
  for (var n = 0; n < kProxyEvents.length; n++) {
    stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
  }

  // when we try to consume some more bytes, simply unpause the
  // underlying stream.
  this._read = function (n) {
    debug('wrapped _read', n);
    if (paused) {
      paused = false;
      stream.resume();
    }
  };
  return this;
};
if (typeof Symbol === 'function') {
  Readable.prototype[Symbol.asyncIterator] = function () {
    if (createReadableStreamAsyncIterator === undefined) {
      createReadableStreamAsyncIterator = __webpack_require__(/*! ./internal/streams/async_iterator */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/async_iterator.js");
    }
    return createReadableStreamAsyncIterator(this);
  };
}
Object.defineProperty(Readable.prototype, 'readableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._readableState.highWaterMark;
  }
});
Object.defineProperty(Readable.prototype, 'readableBuffer', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._readableState && this._readableState.buffer;
  }
});
Object.defineProperty(Readable.prototype, 'readableFlowing', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._readableState.flowing;
  },
  set: function set(state) {
    if (this._readableState) {
      this._readableState.flowing = state;
    }
  }
});

// exposed for testing purposes only.
Readable._fromList = fromList;
Object.defineProperty(Readable.prototype, 'readableLength', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._readableState.length;
  }
});

// Pluck off n bytes from an array of buffers.
// Length is the combined lengths of all the buffers in the list.
// This function is designed to be inlinable, so please take care when making
// changes to the function body.
function fromList(n, state) {
  // nothing buffered
  if (state.length === 0) return null;
  var ret;
  if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
    // read it all, truncate the list
    if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.first();else ret = state.buffer.concat(state.length);
    state.buffer.clear();
  } else {
    // read part of list
    ret = state.buffer.consume(n, state.decoder);
  }
  return ret;
}
function endReadable(stream) {
  var state = stream._readableState;
  debug('endReadable', state.endEmitted);
  if (!state.endEmitted) {
    state.ended = true;
    process.nextTick(endReadableNT, state, stream);
  }
}
function endReadableNT(state, stream) {
  debug('endReadableNT', state.endEmitted, state.length);

  // Check that we didn't get one last unshift.
  if (!state.endEmitted && state.length === 0) {
    state.endEmitted = true;
    stream.readable = false;
    stream.emit('end');
    if (state.autoDestroy) {
      // In case of duplex streams we need a way to detect
      // if the writable side is ready for autoDestroy as well
      var wState = stream._writableState;
      if (!wState || wState.autoDestroy && wState.finished) {
        stream.destroy();
      }
    }
  }
}
if (typeof Symbol === 'function') {
  Readable.from = function (iterable, opts) {
    if (from === undefined) {
      from = __webpack_require__(/*! ./internal/streams/from */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/from-browser.js");
    }
    return from(Readable, iterable, opts);
  };
}
function indexOf(xs, x) {
  for (var i = 0, l = xs.length; i < l; i++) {
    if (xs[i] === x) return i;
  }
  return -1;
}

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_transform.js":
/*!**********************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_transform.js ***!
  \**********************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// a transform stream is a readable/writable stream where you do
// something with the data.  Sometimes it's called a "filter",
// but that's not a great name for it, since that implies a thing where
// some bits pass through, and others are simply ignored.  (That would
// be a valid example of a transform, of course.)
//
// While the output is causally related to the input, it's not a
// necessarily symmetric or synchronous transformation.  For example,
// a zlib stream might take multiple plain-text writes(), and then
// emit a single compressed chunk some time in the future.
//
// Here's how this works:
//
// The Transform stream has all the aspects of the readable and writable
// stream classes.  When you write(chunk), that calls _write(chunk,cb)
// internally, and returns false if there's a lot of pending writes
// buffered up.  When you call read(), that calls _read(n) until
// there's enough pending readable data buffered up.
//
// In a transform stream, the written data is placed in a buffer.  When
// _read(n) is called, it transforms the queued up data, calling the
// buffered _write cb's as it consumes chunks.  If consuming a single
// written chunk would result in multiple output chunks, then the first
// outputted bit calls the readcb, and subsequent chunks just go into
// the read buffer, and will cause it to emit 'readable' if necessary.
//
// This way, back-pressure is actually determined by the reading side,
// since _read has to be called to start processing a new chunk.  However,
// a pathological inflate type of transform can cause excessive buffering
// here.  For example, imagine a stream where every byte of input is
// interpreted as an integer from 0-255, and then results in that many
// bytes of output.  Writing the 4 bytes {ff,ff,ff,ff} would result in
// 1kb of data being output.  In this case, you could write a very small
// amount of input, and end up with a very large amount of output.  In
// such a pathological inflating mechanism, there'd be no way to tell
// the system to stop doing the transform.  A single 4MB write could
// cause the system to run out of memory.
//
// However, even in such a pathological case, only a single written chunk
// would be consumed, and then the rest would wait (un-transformed) until
// the results of the previous transformed chunk were consumed.



__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
module.exports = Transform;
var _require$codes = (__webpack_require__(/*! ../errors */ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js").codes),
  ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED,
  ERR_MULTIPLE_CALLBACK = _require$codes.ERR_MULTIPLE_CALLBACK,
  ERR_TRANSFORM_ALREADY_TRANSFORMING = _require$codes.ERR_TRANSFORM_ALREADY_TRANSFORMING,
  ERR_TRANSFORM_WITH_LENGTH_0 = _require$codes.ERR_TRANSFORM_WITH_LENGTH_0;
var Duplex = __webpack_require__(/*! ./_stream_duplex */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js");
__webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js")(Transform, Duplex);
function afterTransform(er, data) {
  var ts = this._transformState;
  ts.transforming = false;
  var cb = ts.writecb;
  if (cb === null) {
    return this.emit('error', new ERR_MULTIPLE_CALLBACK());
  }
  ts.writechunk = null;
  ts.writecb = null;
  if (data != null)
    // single equals check for both `null` and `undefined`
    this.push(data);
  cb(er);
  var rs = this._readableState;
  rs.reading = false;
  if (rs.needReadable || rs.length < rs.highWaterMark) {
    this._read(rs.highWaterMark);
  }
}
function Transform(options) {
  if (!(this instanceof Transform)) return new Transform(options);
  Duplex.call(this, options);
  this._transformState = {
    afterTransform: afterTransform.bind(this),
    needTransform: false,
    transforming: false,
    writecb: null,
    writechunk: null,
    writeencoding: null
  };

  // start out asking for a readable event once data is transformed.
  this._readableState.needReadable = true;

  // we have implemented the _read method, and done the other things
  // that Readable wants before the first _read call, so unset the
  // sync guard flag.
  this._readableState.sync = false;
  if (options) {
    if (typeof options.transform === 'function') this._transform = options.transform;
    if (typeof options.flush === 'function') this._flush = options.flush;
  }

  // When the writable side finishes, then flush out anything remaining.
  this.on('prefinish', prefinish);
}
function prefinish() {
  var _this = this;
  if (typeof this._flush === 'function' && !this._readableState.destroyed) {
    this._flush(function (er, data) {
      done(_this, er, data);
    });
  } else {
    done(this, null, null);
  }
}
Transform.prototype.push = function (chunk, encoding) {
  this._transformState.needTransform = false;
  return Duplex.prototype.push.call(this, chunk, encoding);
};

// This is the part where you do stuff!
// override this function in implementation classes.
// 'chunk' is an input chunk.
//
// Call `push(newChunk)` to pass along transformed output
// to the readable side.  You may call 'push' zero or more times.
//
// Call `cb(err)` when you are done with this chunk.  If you pass
// an error, then that'll put the hurt on the whole operation.  If you
// never call cb(), then you'll never get another chunk.
Transform.prototype._transform = function (chunk, encoding, cb) {
  cb(new ERR_METHOD_NOT_IMPLEMENTED('_transform()'));
};
Transform.prototype._write = function (chunk, encoding, cb) {
  var ts = this._transformState;
  ts.writecb = cb;
  ts.writechunk = chunk;
  ts.writeencoding = encoding;
  if (!ts.transforming) {
    var rs = this._readableState;
    if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
  }
};

// Doesn't matter what the args are here.
// _transform does all the work.
// That we got here means that the readable side wants more data.
Transform.prototype._read = function (n) {
  var ts = this._transformState;
  if (ts.writechunk !== null && !ts.transforming) {
    ts.transforming = true;
    this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
  } else {
    // mark that we need a transform, so that any data that comes in
    // will get processed, now that we've asked for it.
    ts.needTransform = true;
  }
};
Transform.prototype._destroy = function (err, cb) {
  Duplex.prototype._destroy.call(this, err, function (err2) {
    cb(err2);
  });
};
function done(stream, er, data) {
  if (er) return stream.emit('error', er);
  if (data != null)
    // single equals check for both `null` and `undefined`
    stream.push(data);

  // TODO(BridgeAR): Write a test for these two error cases
  // if there's nothing in the write buffer, then that means
  // that nothing more will ever be provided
  if (stream._writableState.length) throw new ERR_TRANSFORM_WITH_LENGTH_0();
  if (stream._transformState.transforming) throw new ERR_TRANSFORM_ALREADY_TRANSFORMING();
  return stream.push(null);
}

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_writable.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_writable.js ***!
  \*********************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// A bit simpler than readable streams.
// Implement an async ._write(chunk, encoding, cb), and it'll handle all
// the drain event emission and buffering.



__webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
__webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
__webpack_require__(/*! core-js/modules/es.symbol.has-instance.js */ "./node_modules/core-js/modules/es.symbol.has-instance.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.function.has-instance.js */ "./node_modules/core-js/modules/es.function.has-instance.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/web.self.js */ "./node_modules/core-js/modules/web.self.js");
module.exports = Writable;

/* <replacement> */
function WriteReq(chunk, encoding, cb) {
  this.chunk = chunk;
  this.encoding = encoding;
  this.callback = cb;
  this.next = null;
}

// It seems a linked list but it is not
// there will be only 2 of these for each stream
function CorkedRequest(state) {
  var _this = this;
  this.next = null;
  this.entry = null;
  this.finish = function () {
    onCorkedFinish(_this, state);
  };
}
/* </replacement> */

/*<replacement>*/
var Duplex;
/*</replacement>*/

Writable.WritableState = WritableState;

/*<replacement>*/
var internalUtil = {
  deprecate: __webpack_require__(/*! util-deprecate */ "./node_modules/util-deprecate/browser.js")
};
/*</replacement>*/

/*<replacement>*/
var Stream = __webpack_require__(/*! ./internal/streams/stream */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/stream-browser.js");
/*</replacement>*/

var Buffer = (__webpack_require__(/*! buffer */ "./node_modules/buffer/index.js").Buffer);
var OurUint8Array = (typeof __webpack_require__.g !== 'undefined' ? __webpack_require__.g : typeof window !== 'undefined' ? window : typeof self !== 'undefined' ? self : {}).Uint8Array || function () {};
function _uint8ArrayToBuffer(chunk) {
  return Buffer.from(chunk);
}
function _isUint8Array(obj) {
  return Buffer.isBuffer(obj) || obj instanceof OurUint8Array;
}
var destroyImpl = __webpack_require__(/*! ./internal/streams/destroy */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/destroy.js");
var _require = __webpack_require__(/*! ./internal/streams/state */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/state.js"),
  getHighWaterMark = _require.getHighWaterMark;
var _require$codes = (__webpack_require__(/*! ../errors */ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js").codes),
  ERR_INVALID_ARG_TYPE = _require$codes.ERR_INVALID_ARG_TYPE,
  ERR_METHOD_NOT_IMPLEMENTED = _require$codes.ERR_METHOD_NOT_IMPLEMENTED,
  ERR_MULTIPLE_CALLBACK = _require$codes.ERR_MULTIPLE_CALLBACK,
  ERR_STREAM_CANNOT_PIPE = _require$codes.ERR_STREAM_CANNOT_PIPE,
  ERR_STREAM_DESTROYED = _require$codes.ERR_STREAM_DESTROYED,
  ERR_STREAM_NULL_VALUES = _require$codes.ERR_STREAM_NULL_VALUES,
  ERR_STREAM_WRITE_AFTER_END = _require$codes.ERR_STREAM_WRITE_AFTER_END,
  ERR_UNKNOWN_ENCODING = _require$codes.ERR_UNKNOWN_ENCODING;
var errorOrDestroy = destroyImpl.errorOrDestroy;
__webpack_require__(/*! inherits */ "./node_modules/inherits/inherits_browser.js")(Writable, Stream);
function nop() {}
function WritableState(options, stream, isDuplex) {
  Duplex = Duplex || __webpack_require__(/*! ./_stream_duplex */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js");
  options = options || {};

  // Duplex streams are both readable and writable, but share
  // the same options object.
  // However, some cases require setting options to different
  // values for the readable and the writable sides of the duplex stream,
  // e.g. options.readableObjectMode vs. options.writableObjectMode, etc.
  if (typeof isDuplex !== 'boolean') isDuplex = stream instanceof Duplex;

  // object stream flag to indicate whether or not this stream
  // contains buffers or objects.
  this.objectMode = !!options.objectMode;
  if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

  // the point at which write() starts returning false
  // Note: 0 is a valid value, means that we always return false if
  // the entire buffer is not flushed immediately on write()
  this.highWaterMark = getHighWaterMark(this, options, 'writableHighWaterMark', isDuplex);

  // if _final has been called
  this.finalCalled = false;

  // drain event flag.
  this.needDrain = false;
  // at the start of calling end()
  this.ending = false;
  // when end() has been called, and returned
  this.ended = false;
  // when 'finish' is emitted
  this.finished = false;

  // has it been destroyed
  this.destroyed = false;

  // should we decode strings into buffers before passing to _write?
  // this is here so that some node-core streams can optimize string
  // handling at a lower level.
  var noDecode = options.decodeStrings === false;
  this.decodeStrings = !noDecode;

  // Crypto is kind of old and crusty.  Historically, its default string
  // encoding is 'binary' so we have to make this configurable.
  // Everything else in the universe uses 'utf8', though.
  this.defaultEncoding = options.defaultEncoding || 'utf8';

  // not an actual buffer we keep track of, but a measurement
  // of how much we're waiting to get pushed to some underlying
  // socket or file.
  this.length = 0;

  // a flag to see when we're in the middle of a write.
  this.writing = false;

  // when true all writes will be buffered until .uncork() call
  this.corked = 0;

  // a flag to be able to tell if the onwrite cb is called immediately,
  // or on a later tick.  We set this to true at first, because any
  // actions that shouldn't happen until "later" should generally also
  // not happen before the first write call.
  this.sync = true;

  // a flag to know if we're processing previously buffered items, which
  // may call the _write() callback in the same tick, so that we don't
  // end up in an overlapped onwrite situation.
  this.bufferProcessing = false;

  // the callback that's passed to _write(chunk,cb)
  this.onwrite = function (er) {
    onwrite(stream, er);
  };

  // the callback that the user supplies to write(chunk,encoding,cb)
  this.writecb = null;

  // the amount that is being written when _write is called.
  this.writelen = 0;
  this.bufferedRequest = null;
  this.lastBufferedRequest = null;

  // number of pending user-supplied write callbacks
  // this must be 0 before 'finish' can be emitted
  this.pendingcb = 0;

  // emit prefinish if the only thing we're waiting for is _write cbs
  // This is relevant for synchronous Transform streams
  this.prefinished = false;

  // True if the error was already emitted and should not be thrown again
  this.errorEmitted = false;

  // Should close be emitted on destroy. Defaults to true.
  this.emitClose = options.emitClose !== false;

  // Should .destroy() be called after 'finish' (and potentially 'end')
  this.autoDestroy = !!options.autoDestroy;

  // count buffered requests
  this.bufferedRequestCount = 0;

  // allocate the first CorkedRequest, there is always
  // one allocated and free to use, and we maintain at most two
  this.corkedRequestsFree = new CorkedRequest(this);
}
WritableState.prototype.getBuffer = function getBuffer() {
  var current = this.bufferedRequest;
  var out = [];
  while (current) {
    out.push(current);
    current = current.next;
  }
  return out;
};
(function () {
  try {
    Object.defineProperty(WritableState.prototype, 'buffer', {
      get: internalUtil.deprecate(function writableStateBufferGetter() {
        return this.getBuffer();
      }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
    });
  } catch (_) {}
})();

// Test _writableState for inheritance to account for Duplex streams,
// whose prototype chain only points to Readable.
var realHasInstance;
if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
  realHasInstance = Function.prototype[Symbol.hasInstance];
  Object.defineProperty(Writable, Symbol.hasInstance, {
    value: function value(object) {
      if (realHasInstance.call(this, object)) return true;
      if (this !== Writable) return false;
      return object && object._writableState instanceof WritableState;
    }
  });
} else {
  realHasInstance = function realHasInstance(object) {
    return object instanceof this;
  };
}
function Writable(options) {
  Duplex = Duplex || __webpack_require__(/*! ./_stream_duplex */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/_stream_duplex.js");

  // Writable ctor is applied to Duplexes, too.
  // `realHasInstance` is necessary because using plain `instanceof`
  // would return false, as no `_writableState` property is attached.

  // Trying to use the custom `instanceof` for Writable here will also break the
  // Node.js LazyTransform implementation, which has a non-trivial getter for
  // `_writableState` that would lead to infinite recursion.

  // Checking for a Stream.Duplex instance is faster here instead of inside
  // the WritableState constructor, at least with V8 6.5
  var isDuplex = this instanceof Duplex;
  if (!isDuplex && !realHasInstance.call(Writable, this)) return new Writable(options);
  this._writableState = new WritableState(options, this, isDuplex);

  // legacy.
  this.writable = true;
  if (options) {
    if (typeof options.write === 'function') this._write = options.write;
    if (typeof options.writev === 'function') this._writev = options.writev;
    if (typeof options.destroy === 'function') this._destroy = options.destroy;
    if (typeof options.final === 'function') this._final = options.final;
  }
  Stream.call(this);
}

// Otherwise people can pipe Writable streams, which is just wrong.
Writable.prototype.pipe = function () {
  errorOrDestroy(this, new ERR_STREAM_CANNOT_PIPE());
};
function writeAfterEnd(stream, cb) {
  var er = new ERR_STREAM_WRITE_AFTER_END();
  // TODO: defer error events consistently everywhere, not just the cb
  errorOrDestroy(stream, er);
  process.nextTick(cb, er);
}

// Checks that a user-supplied chunk is valid, especially for the particular
// mode the stream is in. Currently this means that `null` is never accepted
// and undefined/non-string values are only allowed in object mode.
function validChunk(stream, state, chunk, cb) {
  var er;
  if (chunk === null) {
    er = new ERR_STREAM_NULL_VALUES();
  } else if (typeof chunk !== 'string' && !state.objectMode) {
    er = new ERR_INVALID_ARG_TYPE('chunk', ['string', 'Buffer'], chunk);
  }
  if (er) {
    errorOrDestroy(stream, er);
    process.nextTick(cb, er);
    return false;
  }
  return true;
}
Writable.prototype.write = function (chunk, encoding, cb) {
  var state = this._writableState;
  var ret = false;
  var isBuf = !state.objectMode && _isUint8Array(chunk);
  if (isBuf && !Buffer.isBuffer(chunk)) {
    chunk = _uint8ArrayToBuffer(chunk);
  }
  if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }
  if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;
  if (typeof cb !== 'function') cb = nop;
  if (state.ending) writeAfterEnd(this, cb);else if (isBuf || validChunk(this, state, chunk, cb)) {
    state.pendingcb++;
    ret = writeOrBuffer(this, state, isBuf, chunk, encoding, cb);
  }
  return ret;
};
Writable.prototype.cork = function () {
  this._writableState.corked++;
};
Writable.prototype.uncork = function () {
  var state = this._writableState;
  if (state.corked) {
    state.corked--;
    if (!state.writing && !state.corked && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
  }
};
Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
  // node::ParseEncoding() requires lower case.
  if (typeof encoding === 'string') encoding = encoding.toLowerCase();
  if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new ERR_UNKNOWN_ENCODING(encoding);
  this._writableState.defaultEncoding = encoding;
  return this;
};
Object.defineProperty(Writable.prototype, 'writableBuffer', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._writableState && this._writableState.getBuffer();
  }
});
function decodeChunk(state, chunk, encoding) {
  if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
    chunk = Buffer.from(chunk, encoding);
  }
  return chunk;
}
Object.defineProperty(Writable.prototype, 'writableHighWaterMark', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._writableState.highWaterMark;
  }
});

// if we're already writing something, then just put this
// in the queue, and wait our turn.  Otherwise, call _write
// If we return false, then we need a drain event, so set that flag.
function writeOrBuffer(stream, state, isBuf, chunk, encoding, cb) {
  if (!isBuf) {
    var newChunk = decodeChunk(state, chunk, encoding);
    if (chunk !== newChunk) {
      isBuf = true;
      encoding = 'buffer';
      chunk = newChunk;
    }
  }
  var len = state.objectMode ? 1 : chunk.length;
  state.length += len;
  var ret = state.length < state.highWaterMark;
  // we must ensure that previous needDrain will not be reset to false.
  if (!ret) state.needDrain = true;
  if (state.writing || state.corked) {
    var last = state.lastBufferedRequest;
    state.lastBufferedRequest = {
      chunk: chunk,
      encoding: encoding,
      isBuf: isBuf,
      callback: cb,
      next: null
    };
    if (last) {
      last.next = state.lastBufferedRequest;
    } else {
      state.bufferedRequest = state.lastBufferedRequest;
    }
    state.bufferedRequestCount += 1;
  } else {
    doWrite(stream, state, false, len, chunk, encoding, cb);
  }
  return ret;
}
function doWrite(stream, state, writev, len, chunk, encoding, cb) {
  state.writelen = len;
  state.writecb = cb;
  state.writing = true;
  state.sync = true;
  if (state.destroyed) state.onwrite(new ERR_STREAM_DESTROYED('write'));else if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
  state.sync = false;
}
function onwriteError(stream, state, sync, er, cb) {
  --state.pendingcb;
  if (sync) {
    // defer the callback if we are being called synchronously
    // to avoid piling up things on the stack
    process.nextTick(cb, er);
    // this can emit finish, and it will always happen
    // after error
    process.nextTick(finishMaybe, stream, state);
    stream._writableState.errorEmitted = true;
    errorOrDestroy(stream, er);
  } else {
    // the caller expect this to happen before if
    // it is async
    cb(er);
    stream._writableState.errorEmitted = true;
    errorOrDestroy(stream, er);
    // this can emit finish, but finish must
    // always follow error
    finishMaybe(stream, state);
  }
}
function onwriteStateUpdate(state) {
  state.writing = false;
  state.writecb = null;
  state.length -= state.writelen;
  state.writelen = 0;
}
function onwrite(stream, er) {
  var state = stream._writableState;
  var sync = state.sync;
  var cb = state.writecb;
  if (typeof cb !== 'function') throw new ERR_MULTIPLE_CALLBACK();
  onwriteStateUpdate(state);
  if (er) onwriteError(stream, state, sync, er, cb);else {
    // Check if we're actually ready to finish, but don't emit yet
    var finished = needFinish(state) || stream.destroyed;
    if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
      clearBuffer(stream, state);
    }
    if (sync) {
      process.nextTick(afterWrite, stream, state, finished, cb);
    } else {
      afterWrite(stream, state, finished, cb);
    }
  }
}
function afterWrite(stream, state, finished, cb) {
  if (!finished) onwriteDrain(stream, state);
  state.pendingcb--;
  cb();
  finishMaybe(stream, state);
}

// Must force callback to be called on nextTick, so that we don't
// emit 'drain' before the write() consumer gets the 'false' return
// value, and has a chance to attach a 'drain' listener.
function onwriteDrain(stream, state) {
  if (state.length === 0 && state.needDrain) {
    state.needDrain = false;
    stream.emit('drain');
  }
}

// if there's something in the buffer waiting, then process it
function clearBuffer(stream, state) {
  state.bufferProcessing = true;
  var entry = state.bufferedRequest;
  if (stream._writev && entry && entry.next) {
    // Fast case, write everything using _writev()
    var l = state.bufferedRequestCount;
    var buffer = new Array(l);
    var holder = state.corkedRequestsFree;
    holder.entry = entry;
    var count = 0;
    var allBuffers = true;
    while (entry) {
      buffer[count] = entry;
      if (!entry.isBuf) allBuffers = false;
      entry = entry.next;
      count += 1;
    }
    buffer.allBuffers = allBuffers;
    doWrite(stream, state, true, state.length, buffer, '', holder.finish);

    // doWrite is almost always async, defer these to save a bit of time
    // as the hot path ends with doWrite
    state.pendingcb++;
    state.lastBufferedRequest = null;
    if (holder.next) {
      state.corkedRequestsFree = holder.next;
      holder.next = null;
    } else {
      state.corkedRequestsFree = new CorkedRequest(state);
    }
    state.bufferedRequestCount = 0;
  } else {
    // Slow case, write chunks one-by-one
    while (entry) {
      var chunk = entry.chunk;
      var encoding = entry.encoding;
      var cb = entry.callback;
      var len = state.objectMode ? 1 : chunk.length;
      doWrite(stream, state, false, len, chunk, encoding, cb);
      entry = entry.next;
      state.bufferedRequestCount--;
      // if we didn't call the onwrite immediately, then
      // it means that we need to wait until it does.
      // also, that means that the chunk and cb are currently
      // being processed, so move the buffer counter past them.
      if (state.writing) {
        break;
      }
    }
    if (entry === null) state.lastBufferedRequest = null;
  }
  state.bufferedRequest = entry;
  state.bufferProcessing = false;
}
Writable.prototype._write = function (chunk, encoding, cb) {
  cb(new ERR_METHOD_NOT_IMPLEMENTED('_write()'));
};
Writable.prototype._writev = null;
Writable.prototype.end = function (chunk, encoding, cb) {
  var state = this._writableState;
  if (typeof chunk === 'function') {
    cb = chunk;
    chunk = null;
    encoding = null;
  } else if (typeof encoding === 'function') {
    cb = encoding;
    encoding = null;
  }
  if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

  // .end() fully uncorks
  if (state.corked) {
    state.corked = 1;
    this.uncork();
  }

  // ignore unnecessary end() calls.
  if (!state.ending) endWritable(this, state, cb);
  return this;
};
Object.defineProperty(Writable.prototype, 'writableLength', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    return this._writableState.length;
  }
});
function needFinish(state) {
  return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
}
function callFinal(stream, state) {
  stream._final(function (err) {
    state.pendingcb--;
    if (err) {
      errorOrDestroy(stream, err);
    }
    state.prefinished = true;
    stream.emit('prefinish');
    finishMaybe(stream, state);
  });
}
function prefinish(stream, state) {
  if (!state.prefinished && !state.finalCalled) {
    if (typeof stream._final === 'function' && !state.destroyed) {
      state.pendingcb++;
      state.finalCalled = true;
      process.nextTick(callFinal, stream, state);
    } else {
      state.prefinished = true;
      stream.emit('prefinish');
    }
  }
}
function finishMaybe(stream, state) {
  var need = needFinish(state);
  if (need) {
    prefinish(stream, state);
    if (state.pendingcb === 0) {
      state.finished = true;
      stream.emit('finish');
      if (state.autoDestroy) {
        // In case of duplex streams we need a way to detect
        // if the readable side is ready for autoDestroy as well
        var rState = stream._readableState;
        if (!rState || rState.autoDestroy && rState.endEmitted) {
          stream.destroy();
        }
      }
    }
  }
  return need;
}
function endWritable(stream, state, cb) {
  state.ending = true;
  finishMaybe(stream, state);
  if (cb) {
    if (state.finished) process.nextTick(cb);else stream.once('finish', cb);
  }
  state.ended = true;
  stream.writable = false;
}
function onCorkedFinish(corkReq, state, err) {
  var entry = corkReq.entry;
  corkReq.entry = null;
  while (entry) {
    var cb = entry.callback;
    state.pendingcb--;
    cb(err);
    entry = entry.next;
  }

  // reuse the free corkReq.
  state.corkedRequestsFree.next = corkReq;
}
Object.defineProperty(Writable.prototype, 'destroyed', {
  // making it explicit this property is not enumerable
  // because otherwise some prototype manipulation in
  // userland will fail
  enumerable: false,
  get: function get() {
    if (this._writableState === undefined) {
      return false;
    }
    return this._writableState.destroyed;
  },
  set: function set(value) {
    // we ignore the value if the stream
    // has not been initialized yet
    if (!this._writableState) {
      return;
    }

    // backward compatibility, the user is explicitly
    // managing destroyed
    this._writableState.destroyed = value;
  }
});
Writable.prototype.destroy = destroyImpl.destroy;
Writable.prototype._undestroy = destroyImpl.undestroy;
Writable.prototype._destroy = function (err, cb) {
  cb(err);
};

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/async_iterator.js":
/*!************************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/async_iterator.js ***!
  \************************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
__webpack_require__(/*! core-js/modules/es.symbol.description.js */ "./node_modules/core-js/modules/es.symbol.description.js");
__webpack_require__(/*! core-js/modules/es.symbol.async-iterator.js */ "./node_modules/core-js/modules/es.symbol.async-iterator.js");
__webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
__webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
__webpack_require__(/*! core-js/modules/es.object.get-prototype-of.js */ "./node_modules/core-js/modules/es.object.get-prototype-of.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/core-js/modules/es.promise.js");
var _Object$setPrototypeO;
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var finished = __webpack_require__(/*! ./end-of-stream */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/end-of-stream.js");
var kLastResolve = Symbol('lastResolve');
var kLastReject = Symbol('lastReject');
var kError = Symbol('error');
var kEnded = Symbol('ended');
var kLastPromise = Symbol('lastPromise');
var kHandlePromise = Symbol('handlePromise');
var kStream = Symbol('stream');
function createIterResult(value, done) {
  return {
    value: value,
    done: done
  };
}
function readAndResolve(iter) {
  var resolve = iter[kLastResolve];
  if (resolve !== null) {
    var data = iter[kStream].read();
    // we defer if data is null
    // we can be expecting either 'end' or
    // 'error'
    if (data !== null) {
      iter[kLastPromise] = null;
      iter[kLastResolve] = null;
      iter[kLastReject] = null;
      resolve(createIterResult(data, false));
    }
  }
}
function onReadable(iter) {
  // we wait for the next tick, because it might
  // emit an error with process.nextTick
  process.nextTick(readAndResolve, iter);
}
function wrapForNext(lastPromise, iter) {
  return function (resolve, reject) {
    lastPromise.then(function () {
      if (iter[kEnded]) {
        resolve(createIterResult(undefined, true));
        return;
      }
      iter[kHandlePromise](resolve, reject);
    }, reject);
  };
}
var AsyncIteratorPrototype = Object.getPrototypeOf(function () {});
var ReadableStreamAsyncIteratorPrototype = Object.setPrototypeOf((_Object$setPrototypeO = {
  get stream() {
    return this[kStream];
  },
  next: function next() {
    var _this = this;
    // if we have detected an error in the meanwhile
    // reject straight away
    var error = this[kError];
    if (error !== null) {
      return Promise.reject(error);
    }
    if (this[kEnded]) {
      return Promise.resolve(createIterResult(undefined, true));
    }
    if (this[kStream].destroyed) {
      // We need to defer via nextTick because if .destroy(err) is
      // called, the error will be emitted via nextTick, and
      // we cannot guarantee that there is no error lingering around
      // waiting to be emitted.
      return new Promise(function (resolve, reject) {
        process.nextTick(function () {
          if (_this[kError]) {
            reject(_this[kError]);
          } else {
            resolve(createIterResult(undefined, true));
          }
        });
      });
    }

    // if we have multiple next() calls
    // we will wait for the previous Promise to finish
    // this logic is optimized to support for await loops,
    // where next() is only called once at a time
    var lastPromise = this[kLastPromise];
    var promise;
    if (lastPromise) {
      promise = new Promise(wrapForNext(lastPromise, this));
    } else {
      // fast path needed to support multiple this.push()
      // without triggering the next() queue
      var data = this[kStream].read();
      if (data !== null) {
        return Promise.resolve(createIterResult(data, false));
      }
      promise = new Promise(this[kHandlePromise]);
    }
    this[kLastPromise] = promise;
    return promise;
  }
}, _defineProperty(_Object$setPrototypeO, Symbol.asyncIterator, function () {
  return this;
}), _defineProperty(_Object$setPrototypeO, "return", function _return() {
  var _this2 = this;
  // destroy(err, cb) is a private API
  // we can guarantee we have that here, because we control the
  // Readable class this is attached to
  return new Promise(function (resolve, reject) {
    _this2[kStream].destroy(null, function (err) {
      if (err) {
        reject(err);
        return;
      }
      resolve(createIterResult(undefined, true));
    });
  });
}), _Object$setPrototypeO), AsyncIteratorPrototype);
var createReadableStreamAsyncIterator = function createReadableStreamAsyncIterator(stream) {
  var _Object$create;
  var iterator = Object.create(ReadableStreamAsyncIteratorPrototype, (_Object$create = {}, _defineProperty(_Object$create, kStream, {
    value: stream,
    writable: true
  }), _defineProperty(_Object$create, kLastResolve, {
    value: null,
    writable: true
  }), _defineProperty(_Object$create, kLastReject, {
    value: null,
    writable: true
  }), _defineProperty(_Object$create, kError, {
    value: null,
    writable: true
  }), _defineProperty(_Object$create, kEnded, {
    value: stream._readableState.endEmitted,
    writable: true
  }), _defineProperty(_Object$create, kHandlePromise, {
    value: function value(resolve, reject) {
      var data = iterator[kStream].read();
      if (data) {
        iterator[kLastPromise] = null;
        iterator[kLastResolve] = null;
        iterator[kLastReject] = null;
        resolve(createIterResult(data, false));
      } else {
        iterator[kLastResolve] = resolve;
        iterator[kLastReject] = reject;
      }
    },
    writable: true
  }), _Object$create));
  iterator[kLastPromise] = null;
  finished(stream, function (err) {
    if (err && err.code !== 'ERR_STREAM_PREMATURE_CLOSE') {
      var reject = iterator[kLastReject];
      // reject if we are waiting for data in the Promise
      // returned by next() and store the error
      if (reject !== null) {
        iterator[kLastPromise] = null;
        iterator[kLastResolve] = null;
        iterator[kLastReject] = null;
        reject(err);
      }
      iterator[kError] = err;
      return;
    }
    var resolve = iterator[kLastResolve];
    if (resolve !== null) {
      iterator[kLastPromise] = null;
      iterator[kLastResolve] = null;
      iterator[kLastReject] = null;
      resolve(createIterResult(undefined, true));
    }
    iterator[kEnded] = true;
  });
  stream.on('readable', onReadable.bind(null, iterator));
  return iterator;
};
module.exports = createReadableStreamAsyncIterator;

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/buffer_list.js":
/*!*********************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/buffer_list.js ***!
  \*********************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.symbol.js */ "./node_modules/core-js/modules/es.symbol.js");
__webpack_require__(/*! core-js/modules/es.symbol.to-primitive.js */ "./node_modules/core-js/modules/es.symbol.to-primitive.js");
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.filter.js */ "./node_modules/core-js/modules/es.array.filter.js");
__webpack_require__(/*! core-js/modules/es.array.push.js */ "./node_modules/core-js/modules/es.array.push.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.date.to-primitive.js */ "./node_modules/core-js/modules/es.date.to-primitive.js");
__webpack_require__(/*! core-js/modules/es.number.constructor.js */ "./node_modules/core-js/modules/es.number.constructor.js");
__webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptor.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptor.js");
__webpack_require__(/*! core-js/modules/es.object.get-own-property-descriptors.js */ "./node_modules/core-js/modules/es.object.get-own-property-descriptors.js");
__webpack_require__(/*! core-js/modules/es.object.keys.js */ "./node_modules/core-js/modules/es.object.keys.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }
  return keys;
}
function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }
  return target;
}
function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}
function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
var _require = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js"),
  Buffer = _require.Buffer;
var _require2 = __webpack_require__(/*! util */ "?3e83"),
  inspect = _require2.inspect;
var custom = inspect && inspect.custom || 'inspect';
function copyBuffer(src, target, offset) {
  Buffer.prototype.copy.call(src, target, offset);
}
module.exports = /*#__PURE__*/function () {
  function BufferList() {
    _classCallCheck(this, BufferList);
    this.head = null;
    this.tail = null;
    this.length = 0;
  }
  _createClass(BufferList, [{
    key: "push",
    value: function push(v) {
      var entry = {
        data: v,
        next: null
      };
      if (this.length > 0) this.tail.next = entry;else this.head = entry;
      this.tail = entry;
      ++this.length;
    }
  }, {
    key: "unshift",
    value: function unshift(v) {
      var entry = {
        data: v,
        next: this.head
      };
      if (this.length === 0) this.tail = entry;
      this.head = entry;
      ++this.length;
    }
  }, {
    key: "shift",
    value: function shift() {
      if (this.length === 0) return;
      var ret = this.head.data;
      if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
      --this.length;
      return ret;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.head = this.tail = null;
      this.length = 0;
    }
  }, {
    key: "join",
    value: function join(s) {
      if (this.length === 0) return '';
      var p = this.head;
      var ret = '' + p.data;
      while (p = p.next) ret += s + p.data;
      return ret;
    }
  }, {
    key: "concat",
    value: function concat(n) {
      if (this.length === 0) return Buffer.alloc(0);
      var ret = Buffer.allocUnsafe(n >>> 0);
      var p = this.head;
      var i = 0;
      while (p) {
        copyBuffer(p.data, ret, i);
        i += p.data.length;
        p = p.next;
      }
      return ret;
    }

    // Consumes a specified amount of bytes or characters from the buffered data.
  }, {
    key: "consume",
    value: function consume(n, hasStrings) {
      var ret;
      if (n < this.head.data.length) {
        // `slice` is the same for buffers and strings.
        ret = this.head.data.slice(0, n);
        this.head.data = this.head.data.slice(n);
      } else if (n === this.head.data.length) {
        // First chunk is a perfect match.
        ret = this.shift();
      } else {
        // Result spans more than one buffer.
        ret = hasStrings ? this._getString(n) : this._getBuffer(n);
      }
      return ret;
    }
  }, {
    key: "first",
    value: function first() {
      return this.head.data;
    }

    // Consumes a specified amount of characters from the buffered data.
  }, {
    key: "_getString",
    value: function _getString(n) {
      var p = this.head;
      var c = 1;
      var ret = p.data;
      n -= ret.length;
      while (p = p.next) {
        var str = p.data;
        var nb = n > str.length ? str.length : n;
        if (nb === str.length) ret += str;else ret += str.slice(0, n);
        n -= nb;
        if (n === 0) {
          if (nb === str.length) {
            ++c;
            if (p.next) this.head = p.next;else this.head = this.tail = null;
          } else {
            this.head = p;
            p.data = str.slice(nb);
          }
          break;
        }
        ++c;
      }
      this.length -= c;
      return ret;
    }

    // Consumes a specified amount of bytes from the buffered data.
  }, {
    key: "_getBuffer",
    value: function _getBuffer(n) {
      var ret = Buffer.allocUnsafe(n);
      var p = this.head;
      var c = 1;
      p.data.copy(ret);
      n -= p.data.length;
      while (p = p.next) {
        var buf = p.data;
        var nb = n > buf.length ? buf.length : n;
        buf.copy(ret, ret.length - n, 0, nb);
        n -= nb;
        if (n === 0) {
          if (nb === buf.length) {
            ++c;
            if (p.next) this.head = p.next;else this.head = this.tail = null;
          } else {
            this.head = p;
            p.data = buf.slice(nb);
          }
          break;
        }
        ++c;
      }
      this.length -= c;
      return ret;
    }

    // Make sure the linked list only shows the minimal necessary information.
  }, {
    key: custom,
    value: function value(_, options) {
      return inspect(this, _objectSpread(_objectSpread({}, options), {}, {
        // Only inspect one level.
        depth: 0,
        // It should not recurse.
        customInspect: false
      }));
    }
  }]);
  return BufferList;
}();

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/destroy.js":
/*!*****************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/destroy.js ***!
  \*****************************************************************************************************/
/***/ (function(module) {

"use strict";


// undocumented cb() API, needed for core, not for public API
function destroy(err, cb) {
  var _this = this;
  var readableDestroyed = this._readableState && this._readableState.destroyed;
  var writableDestroyed = this._writableState && this._writableState.destroyed;
  if (readableDestroyed || writableDestroyed) {
    if (cb) {
      cb(err);
    } else if (err) {
      if (!this._writableState) {
        process.nextTick(emitErrorNT, this, err);
      } else if (!this._writableState.errorEmitted) {
        this._writableState.errorEmitted = true;
        process.nextTick(emitErrorNT, this, err);
      }
    }
    return this;
  }

  // we set destroyed to true before firing error callbacks in order
  // to make it re-entrance safe in case destroy() is called within callbacks

  if (this._readableState) {
    this._readableState.destroyed = true;
  }

  // if this is a duplex stream mark the writable part as destroyed as well
  if (this._writableState) {
    this._writableState.destroyed = true;
  }
  this._destroy(err || null, function (err) {
    if (!cb && err) {
      if (!_this._writableState) {
        process.nextTick(emitErrorAndCloseNT, _this, err);
      } else if (!_this._writableState.errorEmitted) {
        _this._writableState.errorEmitted = true;
        process.nextTick(emitErrorAndCloseNT, _this, err);
      } else {
        process.nextTick(emitCloseNT, _this);
      }
    } else if (cb) {
      process.nextTick(emitCloseNT, _this);
      cb(err);
    } else {
      process.nextTick(emitCloseNT, _this);
    }
  });
  return this;
}
function emitErrorAndCloseNT(self, err) {
  emitErrorNT(self, err);
  emitCloseNT(self);
}
function emitCloseNT(self) {
  if (self._writableState && !self._writableState.emitClose) return;
  if (self._readableState && !self._readableState.emitClose) return;
  self.emit('close');
}
function undestroy() {
  if (this._readableState) {
    this._readableState.destroyed = false;
    this._readableState.reading = false;
    this._readableState.ended = false;
    this._readableState.endEmitted = false;
  }
  if (this._writableState) {
    this._writableState.destroyed = false;
    this._writableState.ended = false;
    this._writableState.ending = false;
    this._writableState.finalCalled = false;
    this._writableState.prefinished = false;
    this._writableState.finished = false;
    this._writableState.errorEmitted = false;
  }
}
function emitErrorNT(self, err) {
  self.emit('error', err);
}
function errorOrDestroy(stream, err) {
  // We have tests that rely on errors being emitted
  // in the same tick, so changing this is semver major.
  // For now when you opt-in to autoDestroy we allow
  // the error to be emitted nextTick. In a future
  // semver major update we should change the default to this.

  var rState = stream._readableState;
  var wState = stream._writableState;
  if (rState && rState.autoDestroy || wState && wState.autoDestroy) stream.destroy(err);else stream.emit('error', err);
}
module.exports = {
  destroy: destroy,
  undestroy: undestroy,
  errorOrDestroy: errorOrDestroy
};

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/end-of-stream.js":
/*!***********************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/end-of-stream.js ***!
  \***********************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Ported from https://github.com/mafintosh/end-of-stream with
// permission from the author, Mathias Buus (@mafintosh).



var ERR_STREAM_PREMATURE_CLOSE = (__webpack_require__(/*! ../../../errors */ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js").codes).ERR_STREAM_PREMATURE_CLOSE;
function once(callback) {
  var called = false;
  return function () {
    if (called) return;
    called = true;
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    callback.apply(this, args);
  };
}
function noop() {}
function isRequest(stream) {
  return stream.setHeader && typeof stream.abort === 'function';
}
function eos(stream, opts, callback) {
  if (typeof opts === 'function') return eos(stream, null, opts);
  if (!opts) opts = {};
  callback = once(callback || noop);
  var readable = opts.readable || opts.readable !== false && stream.readable;
  var writable = opts.writable || opts.writable !== false && stream.writable;
  var onlegacyfinish = function onlegacyfinish() {
    if (!stream.writable) onfinish();
  };
  var writableEnded = stream._writableState && stream._writableState.finished;
  var onfinish = function onfinish() {
    writable = false;
    writableEnded = true;
    if (!readable) callback.call(stream);
  };
  var readableEnded = stream._readableState && stream._readableState.endEmitted;
  var onend = function onend() {
    readable = false;
    readableEnded = true;
    if (!writable) callback.call(stream);
  };
  var onerror = function onerror(err) {
    callback.call(stream, err);
  };
  var onclose = function onclose() {
    var err;
    if (readable && !readableEnded) {
      if (!stream._readableState || !stream._readableState.ended) err = new ERR_STREAM_PREMATURE_CLOSE();
      return callback.call(stream, err);
    }
    if (writable && !writableEnded) {
      if (!stream._writableState || !stream._writableState.ended) err = new ERR_STREAM_PREMATURE_CLOSE();
      return callback.call(stream, err);
    }
  };
  var onrequest = function onrequest() {
    stream.req.on('finish', onfinish);
  };
  if (isRequest(stream)) {
    stream.on('complete', onfinish);
    stream.on('abort', onclose);
    if (stream.req) onrequest();else stream.on('request', onrequest);
  } else if (writable && !stream._writableState) {
    // legacy streams
    stream.on('end', onlegacyfinish);
    stream.on('close', onlegacyfinish);
  }
  stream.on('end', onend);
  stream.on('finish', onfinish);
  if (opts.error !== false) stream.on('error', onerror);
  stream.on('close', onclose);
  return function () {
    stream.removeListener('complete', onfinish);
    stream.removeListener('abort', onclose);
    stream.removeListener('request', onrequest);
    if (stream.req) stream.req.removeListener('finish', onfinish);
    stream.removeListener('end', onlegacyfinish);
    stream.removeListener('close', onlegacyfinish);
    stream.removeListener('finish', onfinish);
    stream.removeListener('end', onend);
    stream.removeListener('error', onerror);
    stream.removeListener('close', onclose);
  };
}
module.exports = eos;

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/from-browser.js":
/*!**********************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/from-browser.js ***!
  \**********************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
module.exports = function () {
  throw new Error('Readable.from is not available in the browser');
};

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/pipeline.js":
/*!******************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/pipeline.js ***!
  \******************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";
// Ported from https://github.com/mafintosh/pump with
// permission from the author, Mathias Buus (@mafintosh).



__webpack_require__(/*! core-js/modules/es.array.map.js */ "./node_modules/core-js/modules/es.array.map.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/core-js/modules/web.dom-collections.for-each.js");
var eos;
function once(callback) {
  var called = false;
  return function () {
    if (called) return;
    called = true;
    callback.apply(void 0, arguments);
  };
}
var _require$codes = (__webpack_require__(/*! ../../../errors */ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js").codes),
  ERR_MISSING_ARGS = _require$codes.ERR_MISSING_ARGS,
  ERR_STREAM_DESTROYED = _require$codes.ERR_STREAM_DESTROYED;
function noop(err) {
  // Rethrow the error if it exists to avoid swallowing it
  if (err) throw err;
}
function isRequest(stream) {
  return stream.setHeader && typeof stream.abort === 'function';
}
function destroyer(stream, reading, writing, callback) {
  callback = once(callback);
  var closed = false;
  stream.on('close', function () {
    closed = true;
  });
  if (eos === undefined) eos = __webpack_require__(/*! ./end-of-stream */ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/end-of-stream.js");
  eos(stream, {
    readable: reading,
    writable: writing
  }, function (err) {
    if (err) return callback(err);
    closed = true;
    callback();
  });
  var destroyed = false;
  return function (err) {
    if (closed) return;
    if (destroyed) return;
    destroyed = true;

    // request.destroy just do .end - .abort is what we want
    if (isRequest(stream)) return stream.abort();
    if (typeof stream.destroy === 'function') return stream.destroy();
    callback(err || new ERR_STREAM_DESTROYED('pipe'));
  };
}
function call(fn) {
  fn();
}
function pipe(from, to) {
  return from.pipe(to);
}
function popCallback(streams) {
  if (!streams.length) return noop;
  if (typeof streams[streams.length - 1] !== 'function') return noop;
  return streams.pop();
}
function pipeline() {
  for (var _len = arguments.length, streams = new Array(_len), _key = 0; _key < _len; _key++) {
    streams[_key] = arguments[_key];
  }
  var callback = popCallback(streams);
  if (Array.isArray(streams[0])) streams = streams[0];
  if (streams.length < 2) {
    throw new ERR_MISSING_ARGS('streams');
  }
  var error;
  var destroys = streams.map(function (stream, i) {
    var reading = i < streams.length - 1;
    var writing = i > 0;
    return destroyer(stream, reading, writing, function (err) {
      if (!error) error = err;
      if (err) destroys.forEach(call);
      if (reading) return;
      destroys.forEach(call);
      callback(error);
    });
  });
  return streams.reduce(pipe);
}
module.exports = pipeline;

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/state.js":
/*!***************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/state.js ***!
  \***************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";


var ERR_INVALID_OPT_VALUE = (__webpack_require__(/*! ../../../errors */ "./node_modules/stream-browserify/node_modules/readable-stream/errors-browser.js").codes).ERR_INVALID_OPT_VALUE;
function highWaterMarkFrom(options, isDuplex, duplexKey) {
  return options.highWaterMark != null ? options.highWaterMark : isDuplex ? options[duplexKey] : null;
}
function getHighWaterMark(state, options, duplexKey, isDuplex) {
  var hwm = highWaterMarkFrom(options, isDuplex, duplexKey);
  if (hwm != null) {
    if (!(isFinite(hwm) && Math.floor(hwm) === hwm) || hwm < 0) {
      var name = isDuplex ? duplexKey : 'highWaterMark';
      throw new ERR_INVALID_OPT_VALUE(name, hwm);
    }
    return Math.floor(hwm);
  }

  // Default value
  return state.objectMode ? 16 : 16 * 1024;
}
module.exports = {
  getHighWaterMark: getHighWaterMark
};

/***/ }),

/***/ "./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/stream-browser.js":
/*!************************************************************************************************************!*\
  !*** ./node_modules/stream-browserify/node_modules/readable-stream/lib/internal/streams/stream-browser.js ***!
  \************************************************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

module.exports = __webpack_require__(/*! events */ "./node_modules/events/events.js").EventEmitter;

/***/ }),

/***/ "./node_modules/string_decoder/lib/string_decoder.js":
/*!***********************************************************!*\
  !*** ./node_modules/string_decoder/lib/string_decoder.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

"use strict";
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.



/*<replacement>*/
__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.slice.js */ "./node_modules/core-js/modules/es.array.slice.js");
__webpack_require__(/*! core-js/modules/es.object.to-string.js */ "./node_modules/core-js/modules/es.object.to-string.js");
__webpack_require__(/*! core-js/modules/es.regexp.to-string.js */ "./node_modules/core-js/modules/es.regexp.to-string.js");
var Buffer = (__webpack_require__(/*! safe-buffer */ "./node_modules/string_decoder/node_modules/safe-buffer/index.js").Buffer);
/*</replacement>*/

var isEncoding = Buffer.isEncoding || function (encoding) {
  encoding = '' + encoding;
  switch (encoding && encoding.toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
    case 'raw':
      return true;
    default:
      return false;
  }
};
function _normalizeEncoding(enc) {
  if (!enc) return 'utf8';
  var retried;
  while (true) {
    switch (enc) {
      case 'utf8':
      case 'utf-8':
        return 'utf8';
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return 'utf16le';
      case 'latin1':
      case 'binary':
        return 'latin1';
      case 'base64':
      case 'ascii':
      case 'hex':
        return enc;
      default:
        if (retried) return; // undefined
        enc = ('' + enc).toLowerCase();
        retried = true;
    }
  }
}
;

// Do not cache `Buffer.isEncoding` when checking encoding names as some
// modules monkey-patch it to support additional encodings
function normalizeEncoding(enc) {
  var nenc = _normalizeEncoding(enc);
  if (typeof nenc !== 'string' && (Buffer.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
  return nenc || enc;
}

// StringDecoder provides an interface for efficiently splitting a series of
// buffers into a series of JS strings without breaking apart multi-byte
// characters.
exports.StringDecoder = StringDecoder;
function StringDecoder(encoding) {
  this.encoding = normalizeEncoding(encoding);
  var nb;
  switch (this.encoding) {
    case 'utf16le':
      this.text = utf16Text;
      this.end = utf16End;
      nb = 4;
      break;
    case 'utf8':
      this.fillLast = utf8FillLast;
      nb = 4;
      break;
    case 'base64':
      this.text = base64Text;
      this.end = base64End;
      nb = 3;
      break;
    default:
      this.write = simpleWrite;
      this.end = simpleEnd;
      return;
  }
  this.lastNeed = 0;
  this.lastTotal = 0;
  this.lastChar = Buffer.allocUnsafe(nb);
}
StringDecoder.prototype.write = function (buf) {
  if (buf.length === 0) return '';
  var r;
  var i;
  if (this.lastNeed) {
    r = this.fillLast(buf);
    if (r === undefined) return '';
    i = this.lastNeed;
    this.lastNeed = 0;
  } else {
    i = 0;
  }
  if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
  return r || '';
};
StringDecoder.prototype.end = utf8End;

// Returns only complete characters in a Buffer
StringDecoder.prototype.text = utf8Text;

// Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
StringDecoder.prototype.fillLast = function (buf) {
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
  this.lastNeed -= buf.length;
};

// Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
// continuation byte. If an invalid byte is detected, -2 is returned.
function utf8CheckByte(byte) {
  if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
  return byte >> 6 === 0x02 ? -1 : -2;
}

// Checks at most 3 bytes at the end of a Buffer in order to detect an
// incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
// needed to complete the UTF-8 character (if applicable) are returned.
function utf8CheckIncomplete(self, buf, i) {
  var j = buf.length - 1;
  if (j < i) return 0;
  var nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 1;
    return nb;
  }
  if (--j < i || nb === -2) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) self.lastNeed = nb - 2;
    return nb;
  }
  if (--j < i || nb === -2) return 0;
  nb = utf8CheckByte(buf[j]);
  if (nb >= 0) {
    if (nb > 0) {
      if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
    }
    return nb;
  }
  return 0;
}

// Validates as many continuation bytes for a multi-byte UTF-8 character as
// needed or are available. If we see a non-continuation byte where we expect
// one, we "replace" the validated continuation bytes we've seen so far with
// a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
// behavior. The continuation byte check is included three times in the case
// where all of the continuation bytes for a character exist in the same buffer.
// It is also done this way as a slight performance increase instead of using a
// loop.
function utf8CheckExtraBytes(self, buf, p) {
  if ((buf[0] & 0xC0) !== 0x80) {
    self.lastNeed = 0;
    return "\uFFFD";
  }
  if (self.lastNeed > 1 && buf.length > 1) {
    if ((buf[1] & 0xC0) !== 0x80) {
      self.lastNeed = 1;
      return "\uFFFD";
    }
    if (self.lastNeed > 2 && buf.length > 2) {
      if ((buf[2] & 0xC0) !== 0x80) {
        self.lastNeed = 2;
        return "\uFFFD";
      }
    }
  }
}

// Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
function utf8FillLast(buf) {
  var p = this.lastTotal - this.lastNeed;
  var r = utf8CheckExtraBytes(this, buf, p);
  if (r !== undefined) return r;
  if (this.lastNeed <= buf.length) {
    buf.copy(this.lastChar, p, 0, this.lastNeed);
    return this.lastChar.toString(this.encoding, 0, this.lastTotal);
  }
  buf.copy(this.lastChar, p, 0, buf.length);
  this.lastNeed -= buf.length;
}

// Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
// partial character, the character's bytes are buffered until the required
// number of bytes are available.
function utf8Text(buf, i) {
  var total = utf8CheckIncomplete(this, buf, i);
  if (!this.lastNeed) return buf.toString('utf8', i);
  this.lastTotal = total;
  var end = buf.length - (total - this.lastNeed);
  buf.copy(this.lastChar, 0, end);
  return buf.toString('utf8', i, end);
}

// For UTF-8, a replacement character is added when ending on a partial
// character.
function utf8End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + "\uFFFD";
  return r;
}

// UTF-16LE typically needs two bytes per character, but even if we have an even
// number of bytes available, we need to check if we end on a leading/high
// surrogate. In that case, we need to wait for the next two bytes in order to
// decode the last character properly.
function utf16Text(buf, i) {
  if ((buf.length - i) % 2 === 0) {
    var r = buf.toString('utf16le', i);
    if (r) {
      var c = r.charCodeAt(r.length - 1);
      if (c >= 0xD800 && c <= 0xDBFF) {
        this.lastNeed = 2;
        this.lastTotal = 4;
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
        return r.slice(0, -1);
      }
    }
    return r;
  }
  this.lastNeed = 1;
  this.lastTotal = 2;
  this.lastChar[0] = buf[buf.length - 1];
  return buf.toString('utf16le', i, buf.length - 1);
}

// For UTF-16LE we do not explicitly append special replacement characters if we
// end on a partial character, we simply let v8 handle that.
function utf16End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) {
    var end = this.lastTotal - this.lastNeed;
    return r + this.lastChar.toString('utf16le', 0, end);
  }
  return r;
}
function base64Text(buf, i) {
  var n = (buf.length - i) % 3;
  if (n === 0) return buf.toString('base64', i);
  this.lastNeed = 3 - n;
  this.lastTotal = 3;
  if (n === 1) {
    this.lastChar[0] = buf[buf.length - 1];
  } else {
    this.lastChar[0] = buf[buf.length - 2];
    this.lastChar[1] = buf[buf.length - 1];
  }
  return buf.toString('base64', i, buf.length - n);
}
function base64End(buf) {
  var r = buf && buf.length ? this.write(buf) : '';
  if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
  return r;
}

// Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
function simpleWrite(buf) {
  return buf.toString(this.encoding);
}
function simpleEnd(buf) {
  return buf && buf.length ? this.write(buf) : '';
}

/***/ }),

/***/ "./node_modules/string_decoder/node_modules/safe-buffer/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/string_decoder/node_modules/safe-buffer/index.js ***!
  \***********************************************************************/
/***/ (function(module, exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
__webpack_require__(/*! core-js/modules/es.array.fill.js */ "./node_modules/core-js/modules/es.array.fill.js");
/* eslint-disable node/no-deprecated-api */
var buffer = __webpack_require__(/*! buffer */ "./node_modules/buffer/index.js");
var Buffer = buffer.Buffer;

// alternative to using Object.keys for old browsers
function copyProps(src, dst) {
  for (var key in src) {
    dst[key] = src[key];
  }
}
if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
  module.exports = buffer;
} else {
  // Copy properties from require('buffer')
  copyProps(buffer, exports);
  exports.Buffer = SafeBuffer;
}
function SafeBuffer(arg, encodingOrOffset, length) {
  return Buffer(arg, encodingOrOffset, length);
}

// Copy static methods from Buffer
copyProps(Buffer, SafeBuffer);
SafeBuffer.from = function (arg, encodingOrOffset, length) {
  if (typeof arg === 'number') {
    throw new TypeError('Argument must not be a number');
  }
  return Buffer(arg, encodingOrOffset, length);
};
SafeBuffer.alloc = function (size, fill, encoding) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number');
  }
  var buf = Buffer(size);
  if (fill !== undefined) {
    if (typeof encoding === 'string') {
      buf.fill(fill, encoding);
    } else {
      buf.fill(fill);
    }
  } else {
    buf.fill(0);
  }
  return buf;
};
SafeBuffer.allocUnsafe = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number');
  }
  return Buffer(size);
};
SafeBuffer.allocUnsafeSlow = function (size) {
  if (typeof size !== 'number') {
    throw new TypeError('Argument must be a number');
  }
  return buffer.SlowBuffer(size);
};

/***/ }),

/***/ "./node_modules/ua-parser-js/src/ua-parser.js":
/*!****************************************************!*\
  !*** ./node_modules/ua-parser-js/src/ua-parser.js ***!
  \****************************************************/
/***/ (function(module, exports, __webpack_require__) {

/* module decorator */ module = __webpack_require__.nmd(module);
var __WEBPACK_AMD_DEFINE_RESULT__;var _typeof = __webpack_require__(/*! @babel/runtime/helpers/typeof */ "./node_modules/@babel/runtime/helpers/typeof.js");
__webpack_require__(/*! core-js/modules/es.array.concat.js */ "./node_modules/core-js/modules/es.array.concat.js");
__webpack_require__(/*! core-js/modules/es.function.name.js */ "./node_modules/core-js/modules/es.function.name.js");
__webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/core-js/modules/es.regexp.exec.js");
__webpack_require__(/*! core-js/modules/es.regexp.test.js */ "./node_modules/core-js/modules/es.regexp.test.js");
__webpack_require__(/*! core-js/modules/es.string.replace.js */ "./node_modules/core-js/modules/es.string.replace.js");
/////////////////////////////////////////////////////////////////////////////////
/* UAParser.js v1.0.38
   Copyright © 2012-2021 Faisal Salman <f@faisalman.com>
   MIT License */ /*
                  Detect Browser, Engine, OS, CPU, and Device type/model from User-Agent data.
                  Supports browser & node.js environment. 
                  Demo   : https://faisalman.github.io/ua-parser-js
                  Source : https://github.com/faisalman/ua-parser-js */
/////////////////////////////////////////////////////////////////////////////////

(function (window, undefined) {
  'use strict';

  //////////////
  // Constants
  /////////////
  var LIBVERSION = '1.0.38',
    EMPTY = '',
    UNKNOWN = '?',
    FUNC_TYPE = 'function',
    UNDEF_TYPE = 'undefined',
    OBJ_TYPE = 'object',
    STR_TYPE = 'string',
    MAJOR = 'major',
    MODEL = 'model',
    NAME = 'name',
    TYPE = 'type',
    VENDOR = 'vendor',
    VERSION = 'version',
    ARCHITECTURE = 'architecture',
    CONSOLE = 'console',
    MOBILE = 'mobile',
    TABLET = 'tablet',
    SMARTTV = 'smarttv',
    WEARABLE = 'wearable',
    EMBEDDED = 'embedded',
    UA_MAX_LENGTH = 500;
  var AMAZON = 'Amazon',
    APPLE = 'Apple',
    ASUS = 'ASUS',
    BLACKBERRY = 'BlackBerry',
    BROWSER = 'Browser',
    CHROME = 'Chrome',
    EDGE = 'Edge',
    FIREFOX = 'Firefox',
    GOOGLE = 'Google',
    HUAWEI = 'Huawei',
    LG = 'LG',
    MICROSOFT = 'Microsoft',
    MOTOROLA = 'Motorola',
    OPERA = 'Opera',
    SAMSUNG = 'Samsung',
    SHARP = 'Sharp',
    SONY = 'Sony',
    XIAOMI = 'Xiaomi',
    ZEBRA = 'Zebra',
    FACEBOOK = 'Facebook',
    CHROMIUM_OS = 'Chromium OS',
    MAC_OS = 'Mac OS';

  ///////////
  // Helper
  //////////

  var extend = function extend(regexes, extensions) {
      var mergedRegexes = {};
      for (var i in regexes) {
        if (extensions[i] && extensions[i].length % 2 === 0) {
          mergedRegexes[i] = extensions[i].concat(regexes[i]);
        } else {
          mergedRegexes[i] = regexes[i];
        }
      }
      return mergedRegexes;
    },
    enumerize = function enumerize(arr) {
      var enums = {};
      for (var i = 0; i < arr.length; i++) {
        enums[arr[i].toUpperCase()] = arr[i];
      }
      return enums;
    },
    has = function has(str1, str2) {
      return _typeof(str1) === STR_TYPE ? lowerize(str2).indexOf(lowerize(str1)) !== -1 : false;
    },
    lowerize = function lowerize(str) {
      return str.toLowerCase();
    },
    majorize = function majorize(version) {
      return _typeof(version) === STR_TYPE ? version.replace(/[^\d\.]/g, EMPTY).split('.')[0] : undefined;
    },
    trim = function trim(str, len) {
      if (_typeof(str) === STR_TYPE) {
        str = str.replace(/^\s\s*/, EMPTY);
        return _typeof(len) === UNDEF_TYPE ? str : str.substring(0, UA_MAX_LENGTH);
      }
    };

  ///////////////
  // Map helper
  //////////////

  var rgxMapper = function rgxMapper(ua, arrays) {
      var i = 0,
        j,
        k,
        p,
        q,
        matches,
        match;

      // loop through all regexes maps
      while (i < arrays.length && !matches) {
        var regex = arrays[i],
          // even sequence (0,2,4,..)
          props = arrays[i + 1]; // odd sequence (1,3,5,..)
        j = k = 0;

        // try matching uastring with regexes
        while (j < regex.length && !matches) {
          if (!regex[j]) {
            break;
          }
          matches = regex[j++].exec(ua);
          if (!!matches) {
            for (p = 0; p < props.length; p++) {
              match = matches[++k];
              q = props[p];
              // check if given property is actually array
              if (_typeof(q) === OBJ_TYPE && q.length > 0) {
                if (q.length === 2) {
                  if (_typeof(q[1]) == FUNC_TYPE) {
                    // assign modified match
                    this[q[0]] = q[1].call(this, match);
                  } else {
                    // assign given value, ignore regex match
                    this[q[0]] = q[1];
                  }
                } else if (q.length === 3) {
                  // check whether function or regex
                  if (_typeof(q[1]) === FUNC_TYPE && !(q[1].exec && q[1].test)) {
                    // call function (usually string mapper)
                    this[q[0]] = match ? q[1].call(this, match, q[2]) : undefined;
                  } else {
                    // sanitize match using given regex
                    this[q[0]] = match ? match.replace(q[1], q[2]) : undefined;
                  }
                } else if (q.length === 4) {
                  this[q[0]] = match ? q[3].call(this, match.replace(q[1], q[2])) : undefined;
                }
              } else {
                this[q] = match ? match : undefined;
              }
            }
          }
        }
        i += 2;
      }
    },
    strMapper = function strMapper(str, map) {
      for (var i in map) {
        // check if current value is array
        if (_typeof(map[i]) === OBJ_TYPE && map[i].length > 0) {
          for (var j = 0; j < map[i].length; j++) {
            if (has(map[i][j], str)) {
              return i === UNKNOWN ? undefined : i;
            }
          }
        } else if (has(map[i], str)) {
          return i === UNKNOWN ? undefined : i;
        }
      }
      return str;
    };

  ///////////////
  // String map
  //////////////

  // Safari < 3.0
  var oldSafariMap = {
      '1.0': '/8',
      '1.2': '/1',
      '1.3': '/3',
      '2.0': '/412',
      '2.0.2': '/416',
      '2.0.3': '/417',
      '2.0.4': '/419',
      '?': '/'
    },
    windowsVersionMap = {
      'ME': '4.90',
      'NT 3.11': 'NT3.51',
      'NT 4.0': 'NT4.0',
      '2000': 'NT 5.0',
      'XP': ['NT 5.1', 'NT 5.2'],
      'Vista': 'NT 6.0',
      '7': 'NT 6.1',
      '8': 'NT 6.2',
      '8.1': 'NT 6.3',
      '10': ['NT 6.4', 'NT 10.0'],
      'RT': 'ARM'
    };

  //////////////
  // Regex map
  /////////////

  var regexes = {
    browser: [[/\b(?:crmo|crios)\/([\w\.]+)/i // Chrome for Android/iOS
    ], [VERSION, [NAME, 'Chrome']], [/edg(?:e|ios|a)?\/([\w\.]+)/i // Microsoft Edge
    ], [VERSION, [NAME, 'Edge']], [
    // Presto based
    /(opera mini)\/([-\w\.]+)/i,
    // Opera Mini
    /(opera [mobiletab]{3,6})\b.+version\/([-\w\.]+)/i,
    // Opera Mobi/Tablet
    /(opera)(?:.+version\/|[\/ ]+)([\w\.]+)/i // Opera
    ], [NAME, VERSION], [/opios[\/ ]+([\w\.]+)/i // Opera mini on iphone >= 8.0
    ], [VERSION, [NAME, OPERA + ' Mini']], [/\bop(?:rg)?x\/([\w\.]+)/i // Opera GX
    ], [VERSION, [NAME, OPERA + ' GX']], [/\bopr\/([\w\.]+)/i // Opera Webkit
    ], [VERSION, [NAME, OPERA]], [
    // Mixed
    /\bb[ai]*d(?:uhd|[ub]*[aekoprswx]{5,6})[\/ ]?([\w\.]+)/i // Baidu
    ], [VERSION, [NAME, 'Baidu']], [/(kindle)\/([\w\.]+)/i,
    // Kindle
    /(lunascape|maxthon|netfront|jasmine|blazer)[\/ ]?([\w\.]*)/i,
    // Lunascape/Maxthon/Netfront/Jasmine/Blazer
    // Trident based
    /(avant|iemobile|slim)\s?(?:browser)?[\/ ]?([\w\.]*)/i,
    // Avant/IEMobile/SlimBrowser
    /(?:ms|\()(ie) ([\w\.]+)/i,
    // Internet Explorer

    // Webkit/KHTML based                                               // Flock/RockMelt/Midori/Epiphany/Silk/Skyfire/Bolt/Iron/Iridium/PhantomJS/Bowser/QupZilla/Falkon
    /(flock|rockmelt|midori|epiphany|silk|skyfire|bolt|iron|vivaldi|iridium|phantomjs|bowser|quark|qupzilla|falkon|rekonq|puffin|brave|whale(?!.+naver)|qqbrowserlite|qq|duckduckgo)\/([-\w\.]+)/i,
    // Rekonq/Puffin/Brave/Whale/QQBrowserLite/QQ, aka ShouQ
    /(heytap|ovi)browser\/([\d\.]+)/i,
    // Heytap/Ovi
    /(weibo)__([\d\.]+)/i // Weibo
    ], [NAME, VERSION], [/\bddg\/([\w\.]+)/i // DuckDuckGo
    ], [VERSION, [NAME, 'DuckDuckGo']], [/(?:\buc? ?browser|(?:juc.+)ucweb)[\/ ]?([\w\.]+)/i // UCBrowser
    ], [VERSION, [NAME, 'UC' + BROWSER]], [/microm.+\bqbcore\/([\w\.]+)/i,
    // WeChat Desktop for Windows Built-in Browser
    /\bqbcore\/([\w\.]+).+microm/i, /micromessenger\/([\w\.]+)/i // WeChat
    ], [VERSION, [NAME, 'WeChat']], [/konqueror\/([\w\.]+)/i // Konqueror
    ], [VERSION, [NAME, 'Konqueror']], [/trident.+rv[: ]([\w\.]{1,9})\b.+like gecko/i // IE11
    ], [VERSION, [NAME, 'IE']], [/ya(?:search)?browser\/([\w\.]+)/i // Yandex
    ], [VERSION, [NAME, 'Yandex']], [/slbrowser\/([\w\.]+)/i // Smart Lenovo Browser
    ], [VERSION, [NAME, 'Smart Lenovo ' + BROWSER]], [/(avast|avg)\/([\w\.]+)/i // Avast/AVG Secure Browser
    ], [[NAME, /(.+)/, '$1 Secure ' + BROWSER], VERSION], [/\bfocus\/([\w\.]+)/i // Firefox Focus
    ], [VERSION, [NAME, FIREFOX + ' Focus']], [/\bopt\/([\w\.]+)/i // Opera Touch
    ], [VERSION, [NAME, OPERA + ' Touch']], [/coc_coc\w+\/([\w\.]+)/i // Coc Coc Browser
    ], [VERSION, [NAME, 'Coc Coc']], [/dolfin\/([\w\.]+)/i // Dolphin
    ], [VERSION, [NAME, 'Dolphin']], [/coast\/([\w\.]+)/i // Opera Coast
    ], [VERSION, [NAME, OPERA + ' Coast']], [/miuibrowser\/([\w\.]+)/i // MIUI Browser
    ], [VERSION, [NAME, 'MIUI ' + BROWSER]], [/fxios\/([-\w\.]+)/i // Firefox for iOS
    ], [VERSION, [NAME, FIREFOX]], [/\bqihu|(qi?ho?o?|360)browser/i // 360
    ], [[NAME, '360 ' + BROWSER]], [/(oculus|sailfish|huawei|vivo)browser\/([\w\.]+)/i], [[NAME, /(.+)/, '$1 ' + BROWSER], VERSION], [
    // Oculus/Sailfish/HuaweiBrowser/VivoBrowser
    /samsungbrowser\/([\w\.]+)/i // Samsung Internet
    ], [VERSION, [NAME, SAMSUNG + ' Internet']], [/(comodo_dragon)\/([\w\.]+)/i // Comodo Dragon
    ], [[NAME, /_/g, ' '], VERSION], [/metasr[\/ ]?([\d\.]+)/i // Sogou Explorer
    ], [VERSION, [NAME, 'Sogou Explorer']], [/(sogou)mo\w+\/([\d\.]+)/i // Sogou Mobile
    ], [[NAME, 'Sogou Mobile'], VERSION], [/(electron)\/([\w\.]+) safari/i,
    // Electron-based App
    /(tesla)(?: qtcarbrowser|\/(20\d\d\.[-\w\.]+))/i,
    // Tesla
    /m?(qqbrowser|2345Explorer)[\/ ]?([\w\.]+)/i // QQBrowser/2345 Browser
    ], [NAME, VERSION], [/(lbbrowser)/i,
    // LieBao Browser
    /\[(linkedin)app\]/i // LinkedIn App for iOS & Android
    ], [NAME], [
    // WebView
    /((?:fban\/fbios|fb_iab\/fb4a)(?!.+fbav)|;fbav\/([\w\.]+);)/i // Facebook App for iOS & Android
    ], [[NAME, FACEBOOK], VERSION], [/(Klarna)\/([\w\.]+)/i,
    // Klarna Shopping Browser for iOS & Android
    /(kakao(?:talk|story))[\/ ]([\w\.]+)/i,
    // Kakao App
    /(naver)\(.*?(\d+\.[\w\.]+).*\)/i,
    // Naver InApp
    /safari (line)\/([\w\.]+)/i,
    // Line App for iOS
    /\b(line)\/([\w\.]+)\/iab/i,
    // Line App for Android
    /(alipay)client\/([\w\.]+)/i,
    // Alipay
    /(twitter)(?:and| f.+e\/([\w\.]+))/i,
    // Twitter
    /(chromium|instagram|snapchat)[\/ ]([-\w\.]+)/i // Chromium/Instagram/Snapchat
    ], [NAME, VERSION], [/\bgsa\/([\w\.]+) .*safari\//i // Google Search Appliance on iOS
    ], [VERSION, [NAME, 'GSA']], [/musical_ly(?:.+app_?version\/|_)([\w\.]+)/i // TikTok
    ], [VERSION, [NAME, 'TikTok']], [/headlesschrome(?:\/([\w\.]+)| )/i // Chrome Headless
    ], [VERSION, [NAME, CHROME + ' Headless']], [/ wv\).+(chrome)\/([\w\.]+)/i // Chrome WebView
    ], [[NAME, CHROME + ' WebView'], VERSION], [/droid.+ version\/([\w\.]+)\b.+(?:mobile safari|safari)/i // Android Browser
    ], [VERSION, [NAME, 'Android ' + BROWSER]], [/(chrome|omniweb|arora|[tizenoka]{5} ?browser)\/v?([\w\.]+)/i // Chrome/OmniWeb/Arora/Tizen/Nokia
    ], [NAME, VERSION], [/version\/([\w\.\,]+) .*mobile\/\w+ (safari)/i // Mobile Safari
    ], [VERSION, [NAME, 'Mobile Safari']], [/version\/([\w(\.|\,)]+) .*(mobile ?safari|safari)/i // Safari & Safari Mobile
    ], [VERSION, NAME], [/webkit.+?(mobile ?safari|safari)(\/[\w\.]+)/i // Safari < 3.0
    ], [NAME, [VERSION, strMapper, oldSafariMap]], [/(webkit|khtml)\/([\w\.]+)/i], [NAME, VERSION], [
    // Gecko based
    /(navigator|netscape\d?)\/([-\w\.]+)/i // Netscape
    ], [[NAME, 'Netscape'], VERSION], [/mobile vr; rv:([\w\.]+)\).+firefox/i // Firefox Reality
    ], [VERSION, [NAME, FIREFOX + ' Reality']], [/ekiohf.+(flow)\/([\w\.]+)/i,
    // Flow
    /(swiftfox)/i,
    // Swiftfox
    /(icedragon|iceweasel|camino|chimera|fennec|maemo browser|minimo|conkeror|klar)[\/ ]?([\w\.\+]+)/i,
    // IceDragon/Iceweasel/Camino/Chimera/Fennec/Maemo/Minimo/Conkeror/Klar
    /(seamonkey|k-meleon|icecat|iceape|firebird|phoenix|palemoon|basilisk|waterfox)\/([-\w\.]+)$/i,
    // Firefox/SeaMonkey/K-Meleon/IceCat/IceApe/Firebird/Phoenix
    /(firefox)\/([\w\.]+)/i,
    // Other Firefox-based
    /(mozilla)\/([\w\.]+) .+rv\:.+gecko\/\d+/i,
    // Mozilla

    // Other
    /(polaris|lynx|dillo|icab|doris|amaya|w3m|netsurf|sleipnir|obigo|mosaic|(?:go|ice|up)[\. ]?browser)[-\/ ]?v?([\w\.]+)/i,
    // Polaris/Lynx/Dillo/iCab/Doris/Amaya/w3m/NetSurf/Sleipnir/Obigo/Mosaic/Go/ICE/UP.Browser
    /(links) \(([\w\.]+)/i,
    // Links
    /panasonic;(viera)/i // Panasonic Viera
    ], [NAME, VERSION], [/(cobalt)\/([\w\.]+)/i // Cobalt
    ], [NAME, [VERSION, /master.|lts./, ""]]],
    cpu: [[/(?:(amd|x(?:(?:86|64)[-_])?|wow|win)64)[;\)]/i // AMD64 (x64)
    ], [[ARCHITECTURE, 'amd64']], [/(ia32(?=;))/i // IA32 (quicktime)
    ], [[ARCHITECTURE, lowerize]], [/((?:i[346]|x)86)[;\)]/i // IA32 (x86)
    ], [[ARCHITECTURE, 'ia32']], [/\b(aarch64|arm(v?8e?l?|_?64))\b/i // ARM64
    ], [[ARCHITECTURE, 'arm64']], [/\b(arm(?:v[67])?ht?n?[fl]p?)\b/i // ARMHF
    ], [[ARCHITECTURE, 'armhf']], [
    // PocketPC mistakenly identified as PowerPC
    /windows (ce|mobile); ppc;/i], [[ARCHITECTURE, 'arm']], [/((?:ppc|powerpc)(?:64)?)(?: mac|;|\))/i // PowerPC
    ], [[ARCHITECTURE, /ower/, EMPTY, lowerize]], [/(sun4\w)[;\)]/i // SPARC
    ], [[ARCHITECTURE, 'sparc']], [/((?:avr32|ia64(?=;))|68k(?=\))|\barm(?=v(?:[1-7]|[5-7]1)l?|;|eabi)|(?=atmel )avr|(?:irix|mips|sparc)(?:64)?\b|pa-risc)/i
    // IA64, 68K, ARM/64, AVR/32, IRIX/64, MIPS/64, SPARC/64, PA-RISC
    ], [[ARCHITECTURE, lowerize]]],
    device: [[
    //////////////////////////
    // MOBILES & TABLETS
    /////////////////////////

    // Samsung
    /\b(sch-i[89]0\d|shw-m380s|sm-[ptx]\w{2,4}|gt-[pn]\d{2,4}|sgh-t8[56]9|nexus 10)/i], [MODEL, [VENDOR, SAMSUNG], [TYPE, TABLET]], [/\b((?:s[cgp]h|gt|sm)-\w+|sc[g-]?[\d]+a?|galaxy nexus)/i, /samsung[- ]([-\w]+)/i, /sec-(sgh\w+)/i], [MODEL, [VENDOR, SAMSUNG], [TYPE, MOBILE]], [
    // Apple
    /(?:\/|\()(ip(?:hone|od)[\w, ]*)(?:\/|;)/i // iPod/iPhone
    ], [MODEL, [VENDOR, APPLE], [TYPE, MOBILE]], [/\((ipad);[-\w\),; ]+apple/i,
    // iPad
    /applecoremedia\/[\w\.]+ \((ipad)/i, /\b(ipad)\d\d?,\d\d?[;\]].+ios/i], [MODEL, [VENDOR, APPLE], [TYPE, TABLET]], [/(macintosh);/i], [MODEL, [VENDOR, APPLE]], [
    // Sharp
    /\b(sh-?[altvz]?\d\d[a-ekm]?)/i], [MODEL, [VENDOR, SHARP], [TYPE, MOBILE]], [
    // Huawei
    /\b((?:ag[rs][23]?|bah2?|sht?|btv)-a?[lw]\d{2})\b(?!.+d\/s)/i], [MODEL, [VENDOR, HUAWEI], [TYPE, TABLET]], [/(?:huawei|honor)([-\w ]+)[;\)]/i, /\b(nexus 6p|\w{2,4}e?-[atu]?[ln][\dx][012359c][adn]?)\b(?!.+d\/s)/i], [MODEL, [VENDOR, HUAWEI], [TYPE, MOBILE]], [
    // Xiaomi
    /\b(poco[\w ]+|m2\d{3}j\d\d[a-z]{2})(?: bui|\))/i,
    // Xiaomi POCO
    /\b; (\w+) build\/hm\1/i,
    // Xiaomi Hongmi 'numeric' models
    /\b(hm[-_ ]?note?[_ ]?(?:\d\w)?) bui/i,
    // Xiaomi Hongmi
    /\b(redmi[\-_ ]?(?:note|k)?[\w_ ]+)(?: bui|\))/i,
    // Xiaomi Redmi
    /oid[^\)]+; (m?[12][0-389][01]\w{3,6}[c-y])( bui|; wv|\))/i,
    // Xiaomi Redmi 'numeric' models
    /\b(mi[-_ ]?(?:a\d|one|one[_ ]plus|note lte|max|cc)?[_ ]?(?:\d?\w?)[_ ]?(?:plus|se|lite)?)(?: bui|\))/i // Xiaomi Mi
    ], [[MODEL, /_/g, ' '], [VENDOR, XIAOMI], [TYPE, MOBILE]], [/oid[^\)]+; (2\d{4}(283|rpbf)[cgl])( bui|\))/i,
    // Redmi Pad
    /\b(mi[-_ ]?(?:pad)(?:[\w_ ]+))(?: bui|\))/i // Mi Pad tablets
    ], [[MODEL, /_/g, ' '], [VENDOR, XIAOMI], [TYPE, TABLET]], [
    // OPPO
    /; (\w+) bui.+ oppo/i, /\b(cph[12]\d{3}|p(?:af|c[al]|d\w|e[ar])[mt]\d0|x9007|a101op)\b/i], [MODEL, [VENDOR, 'OPPO'], [TYPE, MOBILE]], [/\b(opd2\d{3}a?) bui/i], [MODEL, [VENDOR, 'OPPO'], [TYPE, TABLET]], [
    // Vivo
    /vivo (\w+)(?: bui|\))/i, /\b(v[12]\d{3}\w?[at])(?: bui|;)/i], [MODEL, [VENDOR, 'Vivo'], [TYPE, MOBILE]], [
    // Realme
    /\b(rmx[1-3]\d{3})(?: bui|;|\))/i], [MODEL, [VENDOR, 'Realme'], [TYPE, MOBILE]], [
    // Motorola
    /\b(milestone|droid(?:[2-4x]| (?:bionic|x2|pro|razr))?:?( 4g)?)\b[\w ]+build\//i, /\bmot(?:orola)?[- ](\w*)/i, /((?:moto[\w\(\) ]+|xt\d{3,4}|nexus 6)(?= bui|\)))/i], [MODEL, [VENDOR, MOTOROLA], [TYPE, MOBILE]], [/\b(mz60\d|xoom[2 ]{0,2}) build\//i], [MODEL, [VENDOR, MOTOROLA], [TYPE, TABLET]], [
    // LG
    /((?=lg)?[vl]k\-?\d{3}) bui| 3\.[-\w; ]{10}lg?-([06cv9]{3,4})/i], [MODEL, [VENDOR, LG], [TYPE, TABLET]], [/(lm(?:-?f100[nv]?|-[\w\.]+)(?= bui|\))|nexus [45])/i, /\blg[-e;\/ ]+((?!browser|netcast|android tv)\w+)/i, /\blg-?([\d\w]+) bui/i], [MODEL, [VENDOR, LG], [TYPE, MOBILE]], [
    // Lenovo
    /(ideatab[-\w ]+)/i, /lenovo ?(s[56]000[-\w]+|tab(?:[\w ]+)|yt[-\d\w]{6}|tb[-\d\w]{6})/i], [MODEL, [VENDOR, 'Lenovo'], [TYPE, TABLET]], [
    // Nokia
    /(?:maemo|nokia).*(n900|lumia \d+)/i, /nokia[-_ ]?([-\w\.]*)/i], [[MODEL, /_/g, ' '], [VENDOR, 'Nokia'], [TYPE, MOBILE]], [
    // Google
    /(pixel c)\b/i // Google Pixel C
    ], [MODEL, [VENDOR, GOOGLE], [TYPE, TABLET]], [/droid.+; (pixel[\daxl ]{0,6})(?: bui|\))/i // Google Pixel
    ], [MODEL, [VENDOR, GOOGLE], [TYPE, MOBILE]], [
    // Sony
    /droid.+ (a?\d[0-2]{2}so|[c-g]\d{4}|so[-gl]\w+|xq-a\w[4-7][12])(?= bui|\).+chrome\/(?![1-6]{0,1}\d\.))/i], [MODEL, [VENDOR, SONY], [TYPE, MOBILE]], [/sony tablet [ps]/i, /\b(?:sony)?sgp\w+(?: bui|\))/i], [[MODEL, 'Xperia Tablet'], [VENDOR, SONY], [TYPE, TABLET]], [
    // OnePlus
    / (kb2005|in20[12]5|be20[12][59])\b/i, /(?:one)?(?:plus)? (a\d0\d\d)(?: b|\))/i], [MODEL, [VENDOR, 'OnePlus'], [TYPE, MOBILE]], [
    // Amazon
    /(alexa)webm/i, /(kf[a-z]{2}wi|aeo[c-r]{2})( bui|\))/i,
    // Kindle Fire without Silk / Echo Show
    /(kf[a-z]+)( bui|\)).+silk\//i // Kindle Fire HD
    ], [MODEL, [VENDOR, AMAZON], [TYPE, TABLET]], [/((?:sd|kf)[0349hijorstuw]+)( bui|\)).+silk\//i // Fire Phone
    ], [[MODEL, /(.+)/g, 'Fire Phone $1'], [VENDOR, AMAZON], [TYPE, MOBILE]], [
    // BlackBerry
    /(playbook);[-\w\),; ]+(rim)/i // BlackBerry PlayBook
    ], [MODEL, VENDOR, [TYPE, TABLET]], [/\b((?:bb[a-f]|st[hv])100-\d)/i, /\(bb10; (\w+)/i // BlackBerry 10
    ], [MODEL, [VENDOR, BLACKBERRY], [TYPE, MOBILE]], [
    // Asus
    /(?:\b|asus_)(transfo[prime ]{4,10} \w+|eeepc|slider \w+|nexus 7|padfone|p00[cj])/i], [MODEL, [VENDOR, ASUS], [TYPE, TABLET]], [/ (z[bes]6[027][012][km][ls]|zenfone \d\w?)\b/i], [MODEL, [VENDOR, ASUS], [TYPE, MOBILE]], [
    // HTC
    /(nexus 9)/i // HTC Nexus 9
    ], [MODEL, [VENDOR, 'HTC'], [TYPE, TABLET]], [/(htc)[-;_ ]{1,2}([\w ]+(?=\)| bui)|\w+)/i,
    // HTC

    // ZTE
    /(zte)[- ]([\w ]+?)(?: bui|\/|\))/i, /(alcatel|geeksphone|nexian|panasonic(?!(?:;|\.))|sony(?!-bra))[-_ ]?([-\w]*)/i // Alcatel/GeeksPhone/Nexian/Panasonic/Sony
    ], [VENDOR, [MODEL, /_/g, ' '], [TYPE, MOBILE]], [
    // Acer
    /droid.+; ([ab][1-7]-?[0178a]\d\d?)/i], [MODEL, [VENDOR, 'Acer'], [TYPE, TABLET]], [
    // Meizu
    /droid.+; (m[1-5] note) bui/i, /\bmz-([-\w]{2,})/i], [MODEL, [VENDOR, 'Meizu'], [TYPE, MOBILE]], [
    // Ulefone
    /; ((?:power )?armor(?:[\w ]{0,8}))(?: bui|\))/i], [MODEL, [VENDOR, 'Ulefone'], [TYPE, MOBILE]], [
    // MIXED
    /(blackberry|benq|palm(?=\-)|sonyericsson|acer|asus|dell|meizu|motorola|polytron|infinix|tecno)[-_ ]?([-\w]*)/i,
    // BlackBerry/BenQ/Palm/Sony-Ericsson/Acer/Asus/Dell/Meizu/Motorola/Polytron
    /(hp) ([\w ]+\w)/i,
    // HP iPAQ
    /(asus)-?(\w+)/i,
    // Asus
    /(microsoft); (lumia[\w ]+)/i,
    // Microsoft Lumia
    /(lenovo)[-_ ]?([-\w]+)/i,
    // Lenovo
    /(jolla)/i,
    // Jolla
    /(oppo) ?([\w ]+) bui/i // OPPO
    ], [VENDOR, MODEL, [TYPE, MOBILE]], [/(kobo)\s(ereader|touch)/i,
    // Kobo
    /(archos) (gamepad2?)/i,
    // Archos
    /(hp).+(touchpad(?!.+tablet)|tablet)/i,
    // HP TouchPad
    /(kindle)\/([\w\.]+)/i,
    // Kindle
    /(nook)[\w ]+build\/(\w+)/i,
    // Nook
    /(dell) (strea[kpr\d ]*[\dko])/i,
    // Dell Streak
    /(le[- ]+pan)[- ]+(\w{1,9}) bui/i,
    // Le Pan Tablets
    /(trinity)[- ]*(t\d{3}) bui/i,
    // Trinity Tablets
    /(gigaset)[- ]+(q\w{1,9}) bui/i,
    // Gigaset Tablets
    /(vodafone) ([\w ]+)(?:\)| bui)/i // Vodafone
    ], [VENDOR, MODEL, [TYPE, TABLET]], [/(surface duo)/i // Surface Duo
    ], [MODEL, [VENDOR, MICROSOFT], [TYPE, TABLET]], [/droid [\d\.]+; (fp\du?)(?: b|\))/i // Fairphone
    ], [MODEL, [VENDOR, 'Fairphone'], [TYPE, MOBILE]], [/(u304aa)/i // AT&T
    ], [MODEL, [VENDOR, 'AT&T'], [TYPE, MOBILE]], [/\bsie-(\w*)/i // Siemens
    ], [MODEL, [VENDOR, 'Siemens'], [TYPE, MOBILE]], [/\b(rct\w+) b/i // RCA Tablets
    ], [MODEL, [VENDOR, 'RCA'], [TYPE, TABLET]], [/\b(venue[\d ]{2,7}) b/i // Dell Venue Tablets
    ], [MODEL, [VENDOR, 'Dell'], [TYPE, TABLET]], [/\b(q(?:mv|ta)\w+) b/i // Verizon Tablet
    ], [MODEL, [VENDOR, 'Verizon'], [TYPE, TABLET]], [/\b(?:barnes[& ]+noble |bn[rt])([\w\+ ]*) b/i // Barnes & Noble Tablet
    ], [MODEL, [VENDOR, 'Barnes & Noble'], [TYPE, TABLET]], [/\b(tm\d{3}\w+) b/i], [MODEL, [VENDOR, 'NuVision'], [TYPE, TABLET]], [/\b(k88) b/i // ZTE K Series Tablet
    ], [MODEL, [VENDOR, 'ZTE'], [TYPE, TABLET]], [/\b(nx\d{3}j) b/i // ZTE Nubia
    ], [MODEL, [VENDOR, 'ZTE'], [TYPE, MOBILE]], [/\b(gen\d{3}) b.+49h/i // Swiss GEN Mobile
    ], [MODEL, [VENDOR, 'Swiss'], [TYPE, MOBILE]], [/\b(zur\d{3}) b/i // Swiss ZUR Tablet
    ], [MODEL, [VENDOR, 'Swiss'], [TYPE, TABLET]], [/\b((zeki)?tb.*\b) b/i // Zeki Tablets
    ], [MODEL, [VENDOR, 'Zeki'], [TYPE, TABLET]], [/\b([yr]\d{2}) b/i, /\b(dragon[- ]+touch |dt)(\w{5}) b/i // Dragon Touch Tablet
    ], [[VENDOR, 'Dragon Touch'], MODEL, [TYPE, TABLET]], [/\b(ns-?\w{0,9}) b/i // Insignia Tablets
    ], [MODEL, [VENDOR, 'Insignia'], [TYPE, TABLET]], [/\b((nxa|next)-?\w{0,9}) b/i // NextBook Tablets
    ], [MODEL, [VENDOR, 'NextBook'], [TYPE, TABLET]], [/\b(xtreme\_)?(v(1[045]|2[015]|[3469]0|7[05])) b/i // Voice Xtreme Phones
    ], [[VENDOR, 'Voice'], MODEL, [TYPE, MOBILE]], [/\b(lvtel\-)?(v1[12]) b/i // LvTel Phones
    ], [[VENDOR, 'LvTel'], MODEL, [TYPE, MOBILE]], [/\b(ph-1) /i // Essential PH-1
    ], [MODEL, [VENDOR, 'Essential'], [TYPE, MOBILE]], [/\b(v(100md|700na|7011|917g).*\b) b/i // Envizen Tablets
    ], [MODEL, [VENDOR, 'Envizen'], [TYPE, TABLET]], [/\b(trio[-\w\. ]+) b/i // MachSpeed Tablets
    ], [MODEL, [VENDOR, 'MachSpeed'], [TYPE, TABLET]], [/\btu_(1491) b/i // Rotor Tablets
    ], [MODEL, [VENDOR, 'Rotor'], [TYPE, TABLET]], [/(shield[\w ]+) b/i // Nvidia Shield Tablets
    ], [MODEL, [VENDOR, 'Nvidia'], [TYPE, TABLET]], [/(sprint) (\w+)/i // Sprint Phones
    ], [VENDOR, MODEL, [TYPE, MOBILE]], [/(kin\.[onetw]{3})/i // Microsoft Kin
    ], [[MODEL, /\./g, ' '], [VENDOR, MICROSOFT], [TYPE, MOBILE]], [/droid.+; (cc6666?|et5[16]|mc[239][23]x?|vc8[03]x?)\)/i // Zebra
    ], [MODEL, [VENDOR, ZEBRA], [TYPE, TABLET]], [/droid.+; (ec30|ps20|tc[2-8]\d[kx])\)/i], [MODEL, [VENDOR, ZEBRA], [TYPE, MOBILE]], [
    ///////////////////
    // SMARTTVS
    ///////////////////

    /smart-tv.+(samsung)/i // Samsung
    ], [VENDOR, [TYPE, SMARTTV]], [/hbbtv.+maple;(\d+)/i], [[MODEL, /^/, 'SmartTV'], [VENDOR, SAMSUNG], [TYPE, SMARTTV]], [/(nux; netcast.+smarttv|lg (netcast\.tv-201\d|android tv))/i // LG SmartTV
    ], [[VENDOR, LG], [TYPE, SMARTTV]], [/(apple) ?tv/i // Apple TV
    ], [VENDOR, [MODEL, APPLE + ' TV'], [TYPE, SMARTTV]], [/crkey/i // Google Chromecast
    ], [[MODEL, CHROME + 'cast'], [VENDOR, GOOGLE], [TYPE, SMARTTV]], [/droid.+aft(\w+)( bui|\))/i // Fire TV
    ], [MODEL, [VENDOR, AMAZON], [TYPE, SMARTTV]], [/\(dtv[\);].+(aquos)/i, /(aquos-tv[\w ]+)\)/i // Sharp
    ], [MODEL, [VENDOR, SHARP], [TYPE, SMARTTV]], [/(bravia[\w ]+)( bui|\))/i // Sony
    ], [MODEL, [VENDOR, SONY], [TYPE, SMARTTV]], [/(mitv-\w{5}) bui/i // Xiaomi
    ], [MODEL, [VENDOR, XIAOMI], [TYPE, SMARTTV]], [/Hbbtv.*(technisat) (.*);/i // TechniSAT
    ], [VENDOR, MODEL, [TYPE, SMARTTV]], [/\b(roku)[\dx]*[\)\/]((?:dvp-)?[\d\.]*)/i,
    // Roku
    /hbbtv\/\d+\.\d+\.\d+ +\([\w\+ ]*; *([\w\d][^;]*);([^;]*)/i // HbbTV devices
    ], [[VENDOR, trim], [MODEL, trim], [TYPE, SMARTTV]], [/\b(android tv|smart[- ]?tv|opera tv|tv; rv:)\b/i // SmartTV from Unidentified Vendors
    ], [[TYPE, SMARTTV]], [
    ///////////////////
    // CONSOLES
    ///////////////////

    /(ouya)/i,
    // Ouya
    /(nintendo) ([wids3utch]+)/i // Nintendo
    ], [VENDOR, MODEL, [TYPE, CONSOLE]], [/droid.+; (shield) bui/i // Nvidia
    ], [MODEL, [VENDOR, 'Nvidia'], [TYPE, CONSOLE]], [/(playstation [345portablevi]+)/i // Playstation
    ], [MODEL, [VENDOR, SONY], [TYPE, CONSOLE]], [/\b(xbox(?: one)?(?!; xbox))[\); ]/i // Microsoft Xbox
    ], [MODEL, [VENDOR, MICROSOFT], [TYPE, CONSOLE]], [
    ///////////////////
    // WEARABLES
    ///////////////////

    /((pebble))app/i // Pebble
    ], [VENDOR, MODEL, [TYPE, WEARABLE]], [/(watch)(?: ?os[,\/]|\d,\d\/)[\d\.]+/i // Apple Watch
    ], [MODEL, [VENDOR, APPLE], [TYPE, WEARABLE]], [/droid.+; (glass) \d/i // Google Glass
    ], [MODEL, [VENDOR, GOOGLE], [TYPE, WEARABLE]], [/droid.+; (wt63?0{2,3})\)/i], [MODEL, [VENDOR, ZEBRA], [TYPE, WEARABLE]], [/(quest( \d| pro)?)/i // Oculus Quest
    ], [MODEL, [VENDOR, FACEBOOK], [TYPE, WEARABLE]], [
    ///////////////////
    // EMBEDDED
    ///////////////////

    /(tesla)(?: qtcarbrowser|\/[-\w\.]+)/i // Tesla
    ], [VENDOR, [TYPE, EMBEDDED]], [/(aeobc)\b/i // Echo Dot
    ], [MODEL, [VENDOR, AMAZON], [TYPE, EMBEDDED]], [
    ////////////////////
    // MIXED (GENERIC)
    ///////////////////

    /droid .+?; ([^;]+?)(?: bui|; wv\)|\) applew).+? mobile safari/i // Android Phones from Unidentified Vendors
    ], [MODEL, [TYPE, MOBILE]], [/droid .+?; ([^;]+?)(?: bui|\) applew).+?(?! mobile) safari/i // Android Tablets from Unidentified Vendors
    ], [MODEL, [TYPE, TABLET]], [/\b((tablet|tab)[;\/]|focus\/\d(?!.+mobile))/i // Unidentifiable Tablet
    ], [[TYPE, TABLET]], [/(phone|mobile(?:[;\/]| [ \w\/\.]*safari)|pda(?=.+windows ce))/i // Unidentifiable Mobile
    ], [[TYPE, MOBILE]], [/(android[-\w\. ]{0,9});.+buil/i // Generic Android Device
    ], [MODEL, [VENDOR, 'Generic']]],
    engine: [[/windows.+ edge\/([\w\.]+)/i // EdgeHTML
    ], [VERSION, [NAME, EDGE + 'HTML']], [/webkit\/537\.36.+chrome\/(?!27)([\w\.]+)/i // Blink
    ], [VERSION, [NAME, 'Blink']], [/(presto)\/([\w\.]+)/i,
    // Presto
    /(webkit|trident|netfront|netsurf|amaya|lynx|w3m|goanna)\/([\w\.]+)/i,
    // WebKit/Trident/NetFront/NetSurf/Amaya/Lynx/w3m/Goanna
    /ekioh(flow)\/([\w\.]+)/i,
    // Flow
    /(khtml|tasman|links)[\/ ]\(?([\w\.]+)/i,
    // KHTML/Tasman/Links
    /(icab)[\/ ]([23]\.[\d\.]+)/i,
    // iCab
    /\b(libweb)/i], [NAME, VERSION], [/rv\:([\w\.]{1,9})\b.+(gecko)/i // Gecko
    ], [VERSION, NAME]],
    os: [[
    // Windows
    /microsoft (windows) (vista|xp)/i // Windows (iTunes)
    ], [NAME, VERSION], [/(windows (?:phone(?: os)?|mobile))[\/ ]?([\d\.\w ]*)/i // Windows Phone
    ], [NAME, [VERSION, strMapper, windowsVersionMap]], [/windows nt 6\.2; (arm)/i,
    // Windows RT
    /windows[\/ ]?([ntce\d\. ]+\w)(?!.+xbox)/i, /(?:win(?=3|9|n)|win 9x )([nt\d\.]+)/i], [[VERSION, strMapper, windowsVersionMap], [NAME, 'Windows']], [
    // iOS/macOS
    /ip[honead]{2,4}\b(?:.*os ([\w]+) like mac|; opera)/i,
    // iOS
    /(?:ios;fbsv\/|iphone.+ios[\/ ])([\d\.]+)/i, /cfnetwork\/.+darwin/i], [[VERSION, /_/g, '.'], [NAME, 'iOS']], [/(mac os x) ?([\w\. ]*)/i, /(macintosh|mac_powerpc\b)(?!.+haiku)/i // Mac OS
    ], [[NAME, MAC_OS], [VERSION, /_/g, '.']], [
    // Mobile OSes
    /droid ([\w\.]+)\b.+(android[- ]x86|harmonyos)/i // Android-x86/HarmonyOS
    ], [VERSION, NAME], [
    // Android/WebOS/QNX/Bada/RIM/Maemo/MeeGo/Sailfish OS
    /(android|webos|qnx|bada|rim tablet os|maemo|meego|sailfish)[-\/ ]?([\w\.]*)/i, /(blackberry)\w*\/([\w\.]*)/i,
    // Blackberry
    /(tizen|kaios)[\/ ]([\w\.]+)/i,
    // Tizen/KaiOS
    /\((series40);/i // Series 40
    ], [NAME, VERSION], [/\(bb(10);/i // BlackBerry 10
    ], [VERSION, [NAME, BLACKBERRY]], [/(?:symbian ?os|symbos|s60(?=;)|series60)[-\/ ]?([\w\.]*)/i // Symbian
    ], [VERSION, [NAME, 'Symbian']], [/mozilla\/[\d\.]+ \((?:mobile|tablet|tv|mobile; [\w ]+); rv:.+ gecko\/([\w\.]+)/i // Firefox OS
    ], [VERSION, [NAME, FIREFOX + ' OS']], [/web0s;.+rt(tv)/i, /\b(?:hp)?wos(?:browser)?\/([\w\.]+)/i // WebOS
    ], [VERSION, [NAME, 'webOS']], [/watch(?: ?os[,\/]|\d,\d\/)([\d\.]+)/i // watchOS
    ], [VERSION, [NAME, 'watchOS']], [
    // Google Chromecast
    /crkey\/([\d\.]+)/i // Google Chromecast
    ], [VERSION, [NAME, CHROME + 'cast']], [/(cros) [\w]+(?:\)| ([\w\.]+)\b)/i // Chromium OS
    ], [[NAME, CHROMIUM_OS], VERSION], [
    // Smart TVs
    /panasonic;(viera)/i,
    // Panasonic Viera
    /(netrange)mmh/i,
    // Netrange
    /(nettv)\/(\d+\.[\w\.]+)/i,
    // NetTV

    // Console
    /(nintendo|playstation) ([wids345portablevuch]+)/i,
    // Nintendo/Playstation
    /(xbox); +xbox ([^\);]+)/i,
    // Microsoft Xbox (360, One, X, S, Series X, Series S)

    // Other
    /\b(joli|palm)\b ?(?:os)?\/?([\w\.]*)/i,
    // Joli/Palm
    /(mint)[\/\(\) ]?(\w*)/i,
    // Mint
    /(mageia|vectorlinux)[; ]/i,
    // Mageia/VectorLinux
    /([kxln]?ubuntu|debian|suse|opensuse|gentoo|arch(?= linux)|slackware|fedora|mandriva|centos|pclinuxos|red ?hat|zenwalk|linpus|raspbian|plan 9|minix|risc os|contiki|deepin|manjaro|elementary os|sabayon|linspire)(?: gnu\/linux)?(?: enterprise)?(?:[- ]linux)?(?:-gnu)?[-\/ ]?(?!chrom|package)([-\w\.]*)/i,
    // Ubuntu/Debian/SUSE/Gentoo/Arch/Slackware/Fedora/Mandriva/CentOS/PCLinuxOS/RedHat/Zenwalk/Linpus/Raspbian/Plan9/Minix/RISCOS/Contiki/Deepin/Manjaro/elementary/Sabayon/Linspire
    /(hurd|linux) ?([\w\.]*)/i,
    // Hurd/Linux
    /(gnu) ?([\w\.]*)/i,
    // GNU
    /\b([-frentopcghs]{0,5}bsd|dragonfly)[\/ ]?(?!amd|[ix346]{1,2}86)([\w\.]*)/i,
    // FreeBSD/NetBSD/OpenBSD/PC-BSD/GhostBSD/DragonFly
    /(haiku) (\w+)/i // Haiku
    ], [NAME, VERSION], [/(sunos) ?([\w\.\d]*)/i // Solaris
    ], [[NAME, 'Solaris'], VERSION], [/((?:open)?solaris)[-\/ ]?([\w\.]*)/i,
    // Solaris
    /(aix) ((\d)(?=\.|\)| )[\w\.])*/i,
    // AIX
    /\b(beos|os\/2|amigaos|morphos|openvms|fuchsia|hp-ux|serenityos)/i,
    // BeOS/OS2/AmigaOS/MorphOS/OpenVMS/Fuchsia/HP-UX/SerenityOS
    /(unix) ?([\w\.]*)/i // UNIX
    ], [NAME, VERSION]]
  };

  /////////////////
  // Constructor
  ////////////////

  var _UAParser = function UAParser(ua, extensions) {
    if (_typeof(ua) === OBJ_TYPE) {
      extensions = ua;
      ua = undefined;
    }
    if (!(this instanceof _UAParser)) {
      return new _UAParser(ua, extensions).getResult();
    }
    var _navigator = _typeof(window) !== UNDEF_TYPE && window.navigator ? window.navigator : undefined;
    var _ua = ua || (_navigator && _navigator.userAgent ? _navigator.userAgent : EMPTY);
    var _uach = _navigator && _navigator.userAgentData ? _navigator.userAgentData : undefined;
    var _rgxmap = extensions ? extend(regexes, extensions) : regexes;
    var _isSelfNav = _navigator && _navigator.userAgent == _ua;
    this.getBrowser = function () {
      var _browser = {};
      _browser[NAME] = undefined;
      _browser[VERSION] = undefined;
      rgxMapper.call(_browser, _ua, _rgxmap.browser);
      _browser[MAJOR] = majorize(_browser[VERSION]);
      // Brave-specific detection
      if (_isSelfNav && _navigator && _navigator.brave && _typeof(_navigator.brave.isBrave) == FUNC_TYPE) {
        _browser[NAME] = 'Brave';
      }
      return _browser;
    };
    this.getCPU = function () {
      var _cpu = {};
      _cpu[ARCHITECTURE] = undefined;
      rgxMapper.call(_cpu, _ua, _rgxmap.cpu);
      return _cpu;
    };
    this.getDevice = function () {
      var _device = {};
      _device[VENDOR] = undefined;
      _device[MODEL] = undefined;
      _device[TYPE] = undefined;
      rgxMapper.call(_device, _ua, _rgxmap.device);
      if (_isSelfNav && !_device[TYPE] && _uach && _uach.mobile) {
        _device[TYPE] = MOBILE;
      }
      // iPadOS-specific detection: identified as Mac, but has some iOS-only properties
      if (_isSelfNav && _device[MODEL] == 'Macintosh' && _navigator && _typeof(_navigator.standalone) !== UNDEF_TYPE && _navigator.maxTouchPoints && _navigator.maxTouchPoints > 2) {
        _device[MODEL] = 'iPad';
        _device[TYPE] = TABLET;
      }
      return _device;
    };
    this.getEngine = function () {
      var _engine = {};
      _engine[NAME] = undefined;
      _engine[VERSION] = undefined;
      rgxMapper.call(_engine, _ua, _rgxmap.engine);
      return _engine;
    };
    this.getOS = function () {
      var _os = {};
      _os[NAME] = undefined;
      _os[VERSION] = undefined;
      rgxMapper.call(_os, _ua, _rgxmap.os);
      if (_isSelfNav && !_os[NAME] && _uach && _uach.platform && _uach.platform != 'Unknown') {
        _os[NAME] = _uach.platform.replace(/chrome os/i, CHROMIUM_OS).replace(/macos/i, MAC_OS); // backward compatibility
      }
      return _os;
    };
    this.getResult = function () {
      return {
        ua: this.getUA(),
        browser: this.getBrowser(),
        engine: this.getEngine(),
        os: this.getOS(),
        device: this.getDevice(),
        cpu: this.getCPU()
      };
    };
    this.getUA = function () {
      return _ua;
    };
    this.setUA = function (ua) {
      _ua = _typeof(ua) === STR_TYPE && ua.length > UA_MAX_LENGTH ? trim(ua, UA_MAX_LENGTH) : ua;
      return this;
    };
    this.setUA(_ua);
    return this;
  };
  _UAParser.VERSION = LIBVERSION;
  _UAParser.BROWSER = enumerize([NAME, VERSION, MAJOR]);
  _UAParser.CPU = enumerize([ARCHITECTURE]);
  _UAParser.DEVICE = enumerize([MODEL, VENDOR, TYPE, CONSOLE, MOBILE, SMARTTV, TABLET, WEARABLE, EMBEDDED]);
  _UAParser.ENGINE = _UAParser.OS = enumerize([NAME, VERSION]);

  ///////////
  // Export
  //////////

  // check js environment
  if (( false ? 0 : _typeof(exports)) !== UNDEF_TYPE) {
    // nodejs env
    if (( false ? 0 : _typeof(module)) !== UNDEF_TYPE && module.exports) {
      exports = module.exports = _UAParser;
    }
    exports.UAParser = _UAParser;
  } else {
    // requirejs env (optional)
    if (( false ? 0 : _typeof(__webpack_require__.amdD)) === FUNC_TYPE && __webpack_require__.amdO) {
      !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () {
        return _UAParser;
      }).call(exports, __webpack_require__, exports, module),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (_typeof(window) !== UNDEF_TYPE) {
      // browser env
      window.UAParser = _UAParser;
    }
  }

  // jQuery/Zepto specific (optional)
  // Note:
  //   In AMD env the global scope should be kept clean, but jQuery is an exception.
  //   jQuery always exports to global scope, unless jQuery.noConflict(true) is used,
  //   and we should catch that.
  var $ = _typeof(window) !== UNDEF_TYPE && (window.jQuery || window.Zepto);
  if ($ && !$.ua) {
    var parser = new _UAParser();
    $.ua = parser.getResult();
    $.ua.get = function () {
      return parser.getUA();
    };
    $.ua.set = function (ua) {
      parser.setUA(ua);
      var result = parser.getResult();
      for (var prop in result) {
        $.ua[prop] = result[prop];
      }
    };
  }
})((typeof window === "undefined" ? "undefined" : _typeof(window)) === 'object' ? window : this);

/***/ }),

/***/ "./node_modules/util-deprecate/browser.js":
/*!************************************************!*\
  !*** ./node_modules/util-deprecate/browser.js ***!
  \************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

__webpack_require__(/*! core-js/modules/es.error.cause.js */ "./node_modules/core-js/modules/es.error.cause.js");
/**
 * Module exports.
 */

module.exports = deprecate;

/**
 * Mark that a method should not be used.
 * Returns a modified function which warns once by default.
 *
 * If `localStorage.noDeprecation = true` is set, then it is a no-op.
 *
 * If `localStorage.throwDeprecation = true` is set, then deprecated functions
 * will throw an Error when invoked.
 *
 * If `localStorage.traceDeprecation = true` is set, then deprecated functions
 * will invoke `console.trace()` instead of `console.error()`.
 *
 * @param {Function} fn - the function to deprecate
 * @param {String} msg - the string to print to the console when `fn` is invoked
 * @returns {Function} a new "deprecated" version of `fn`
 * @api public
 */

function deprecate(fn, msg) {
  if (config('noDeprecation')) {
    return fn;
  }
  var warned = false;
  function deprecated() {
    if (!warned) {
      if (config('throwDeprecation')) {
        throw new Error(msg);
      } else if (config('traceDeprecation')) {
        console.trace(msg);
      } else {
        console.warn(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }
  return deprecated;
}

/**
 * Checks `localStorage` for boolean values for the given `name`.
 *
 * @param {String} name
 * @returns {Boolean}
 * @api private
 */

function config(name) {
  // accessing global.localStorage can trigger a DOMException in sandboxed iframes
  try {
    if (!__webpack_require__.g.localStorage) return false;
  } catch (_) {
    return false;
  }
  var val = __webpack_require__.g.localStorage[name];
  if (null == val) return false;
  return String(val).toLowerCase() === 'true';
}

/***/ }),

/***/ "?3e83":
/*!**********************!*\
  !*** util (ignored) ***!
  \**********************/
/***/ (function() {

/* (ignored) */

/***/ }),

/***/ "?19e6":
/*!**********************!*\
  !*** util (ignored) ***!
  \**********************/
/***/ (function() {

/* (ignored) */

/***/ }),

/***/ "./node_modules/core-js/internals/a-callable.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/internals/a-callable.js ***!
  \******************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var isCallable = __webpack_require__(/*! ../internals/is-callable */ "./node_modules/core-js/internals/is-callable.js");
var tryToString = __webpack_require__(/*! ../internals/try-to-string */ "./node_modules/core-js/internals/try-to-string.js");

var $TypeError = TypeError;

// `Assert: IsCallable(argument) is true`
module.exports = function (argument) {
  if (isCallable(argument)) return argument;
  throw new $TypeError(tryToString(argument) + ' is not a function');
};


/***/ }),

/***/ "./node_modules/core-js/internals/a-constructor.js":
/*!*********************************************************!*\
  !*** ./node_modules/core-js/internals/a-constructor.js ***!
  \*********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var isConstructor = __webpack_require__(/*! ../internals/is-constructor */ "./node_modules/core-js/internals/is-constructor.js");
var tryToString = __webpack_require__(/*! ../internals/try-to-string */ "./node_modules/core-js/internals/try-to-string.js");

var $TypeError = TypeError;

// `Assert: IsConstructor(argument) is true`
module.exports = function (argument) {
  if (isConstructor(argument)) return argument;
  throw new $TypeError(tryToString(argument) + ' is not a constructor');
};


/***/ }),

/***/ "./node_modules/core-js/internals/a-possible-prototype.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/internals/a-possible-prototype.js ***!
  \****************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var isPossiblePrototype = __webpack_require__(/*! ../internals/is-possible-prototype */ "./node_modules/core-js/internals/is-possible-prototype.js");

var $String = String;
var $TypeError = TypeError;

module.exports = function (argument) {
  if (isPossiblePrototype(argument)) return argument;
  throw new $TypeError("Can't set " + $String(argument) + ' as a prototype');
};


/***/ }),

/***/ "./node_modules/core-js/internals/a-set.js":
/*!*************************************************!*\
  !*** ./node_modules/core-js/internals/a-set.js ***!
  \*************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var has = (__webpack_require__(/*! ../internals/set-helpers */ "./node_modules/core-js/internals/set-helpers.js").has);

// Perform ? RequireInternalSlot(M, [[SetData]])
module.exports = function (it) {
  has(it);
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/internals/add-to-unscopables.js":
/*!**************************************************************!*\
  !*** ./node_modules/core-js/internals/add-to-unscopables.js ***!
  \**************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "./node_modules/core-js/internals/well-known-symbol.js");
var create = __webpack_require__(/*! ../internals/object-create */ "./node_modules/core-js/internals/object-create.js");
var defineProperty = (__webpack_require__(/*! ../internals/object-define-property */ "./node_modules/core-js/internals/object-define-property.js").f);

var UNSCOPABLES = wellKnownSymbol('unscopables');
var ArrayPrototype = Array.prototype;

// Array.prototype[@@unscopables]
// https://tc39.es/ecma262/#sec-array.prototype-@@unscopables
if (ArrayPrototype[UNSCOPABLES] === undefined) {
  defineProperty(ArrayPrototype, UNSCOPABLES, {
    configurable: true,
    value: create(null)
  });
}

// add a key to Array.prototype[@@unscopables]
module.exports = function (key) {
  ArrayPrototype[UNSCOPABLES][key] = true;
};


/***/ }),

/***/ "./node_modules/core-js/internals/advance-string-index.js":
/*!****************************************************************!*\
  !*** ./node_modules/core-js/internals/advance-string-index.js ***!
  \****************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var charAt = (__webpack_require__(/*! ../internals/string-multibyte */ "./node_modules/core-js/internals/string-multibyte.js").charAt);

// `AdvanceStringIndex` abstract operation
// https://tc39.es/ecma262/#sec-advancestringindex
module.exports = function (S, index, unicode) {
  return index + (unicode ? charAt(S, index).length : 1);
};


/***/ }),

/***/ "./node_modules/core-js/internals/an-instance.js":
/*!*******************************************************!*\
  !*** ./node_modules/core-js/internals/an-instance.js ***!
  \*******************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var isPrototypeOf = __webpack_require__(/*! ../internals/object-is-prototype-of */ "./node_modules/core-js/internals/object-is-prototype-of.js");

var $TypeError = TypeError;

module.exports = function (it, Prototype) {
  if (isPrototypeOf(Prototype, it)) return it;
  throw new $TypeError('Incorrect invocation');
};


/***/ }),

/***/ "./node_modules/core-js/internals/an-object.js":
/*!*****************************************************!*\
  !*** ./node_modules/core-js/internals/an-object.js ***!
  \*****************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var isObject = __webpack_require__(/*! ../internals/is-object */ "./node_modules/core-js/internals/is-object.js");

var $String = String;
var $TypeError = TypeError;

// `Assert: Type(argument) is Object`
module.exports = function (argument) {
  if (isObject(argument)) return argument;
  throw new $TypeError($String(argument) + ' is not an object');
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-basic-detection.js":
/*!************************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-basic-detection.js ***!
  \************************************************************************/
/***/ (function(module) {

"use strict";

// eslint-disable-next-line es/no-typed-arrays -- safe
module.exports = typeof ArrayBuffer != 'undefined' && typeof DataView != 'undefined';


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-byte-length.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-byte-length.js ***!
  \********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var globalThis = __webpack_require__(/*! ../internals/global-this */ "./node_modules/core-js/internals/global-this.js");
var uncurryThisAccessor = __webpack_require__(/*! ../internals/function-uncurry-this-accessor */ "./node_modules/core-js/internals/function-uncurry-this-accessor.js");
var classof = __webpack_require__(/*! ../internals/classof-raw */ "./node_modules/core-js/internals/classof-raw.js");

var ArrayBuffer = globalThis.ArrayBuffer;
var TypeError = globalThis.TypeError;

// Includes
// - Perform ? RequireInternalSlot(O, [[ArrayBufferData]]).
// - If IsSharedArrayBuffer(O) is true, throw a TypeError exception.
module.exports = ArrayBuffer && uncurryThisAccessor(ArrayBuffer.prototype, 'byteLength', 'get') || function (O) {
  if (classof(O) !== 'ArrayBuffer') throw new TypeError('ArrayBuffer expected');
  return O.byteLength;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-is-detached.js":
/*!********************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-is-detached.js ***!
  \********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var globalThis = __webpack_require__(/*! ../internals/global-this */ "./node_modules/core-js/internals/global-this.js");
var uncurryThis = __webpack_require__(/*! ../internals/function-uncurry-this-clause */ "./node_modules/core-js/internals/function-uncurry-this-clause.js");
var arrayBufferByteLength = __webpack_require__(/*! ../internals/array-buffer-byte-length */ "./node_modules/core-js/internals/array-buffer-byte-length.js");

var ArrayBuffer = globalThis.ArrayBuffer;
var ArrayBufferPrototype = ArrayBuffer && ArrayBuffer.prototype;
var slice = ArrayBufferPrototype && uncurryThis(ArrayBufferPrototype.slice);

module.exports = function (O) {
  if (arrayBufferByteLength(O) !== 0) return false;
  if (!slice) return false;
  try {
    slice(O, 0, 0);
    return false;
  } catch (error) {
    return true;
  }
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-non-extensible.js":
/*!***********************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-non-extensible.js ***!
  \***********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

// FF26- bug: ArrayBuffers are non-extensible, but Object.isExtensible does not report it
var fails = __webpack_require__(/*! ../internals/fails */ "./node_modules/core-js/internals/fails.js");

module.exports = fails(function () {
  if (typeof ArrayBuffer == 'function') {
    var buffer = new ArrayBuffer(8);
    // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe
    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', { value: 8 });
  }
});


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-not-detached.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-not-detached.js ***!
  \*********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var isDetached = __webpack_require__(/*! ../internals/array-buffer-is-detached */ "./node_modules/core-js/internals/array-buffer-is-detached.js");

var $TypeError = TypeError;

module.exports = function (it) {
  if (isDetached(it)) throw new $TypeError('ArrayBuffer is detached');
  return it;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-transfer.js":
/*!*****************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-transfer.js ***!
  \*****************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var globalThis = __webpack_require__(/*! ../internals/global-this */ "./node_modules/core-js/internals/global-this.js");
var uncurryThis = __webpack_require__(/*! ../internals/function-uncurry-this */ "./node_modules/core-js/internals/function-uncurry-this.js");
var uncurryThisAccessor = __webpack_require__(/*! ../internals/function-uncurry-this-accessor */ "./node_modules/core-js/internals/function-uncurry-this-accessor.js");
var toIndex = __webpack_require__(/*! ../internals/to-index */ "./node_modules/core-js/internals/to-index.js");
var notDetached = __webpack_require__(/*! ../internals/array-buffer-not-detached */ "./node_modules/core-js/internals/array-buffer-not-detached.js");
var arrayBufferByteLength = __webpack_require__(/*! ../internals/array-buffer-byte-length */ "./node_modules/core-js/internals/array-buffer-byte-length.js");
var detachTransferable = __webpack_require__(/*! ../internals/detach-transferable */ "./node_modules/core-js/internals/detach-transferable.js");
var PROPER_STRUCTURED_CLONE_TRANSFER = __webpack_require__(/*! ../internals/structured-clone-proper-transfer */ "./node_modules/core-js/internals/structured-clone-proper-transfer.js");

var structuredClone = globalThis.structuredClone;
var ArrayBuffer = globalThis.ArrayBuffer;
var DataView = globalThis.DataView;
var min = Math.min;
var ArrayBufferPrototype = ArrayBuffer.prototype;
var DataViewPrototype = DataView.prototype;
var slice = uncurryThis(ArrayBufferPrototype.slice);
var isResizable = uncurryThisAccessor(ArrayBufferPrototype, 'resizable', 'get');
var maxByteLength = uncurryThisAccessor(ArrayBufferPrototype, 'maxByteLength', 'get');
var getInt8 = uncurryThis(DataViewPrototype.getInt8);
var setInt8 = uncurryThis(DataViewPrototype.setInt8);

module.exports = (PROPER_STRUCTURED_CLONE_TRANSFER || detachTransferable) && function (arrayBuffer, newLength, preserveResizability) {
  var byteLength = arrayBufferByteLength(arrayBuffer);
  var newByteLength = newLength === undefined ? byteLength : toIndex(newLength);
  var fixedLength = !isResizable || !isResizable(arrayBuffer);
  var newBuffer;
  notDetached(arrayBuffer);
  if (PROPER_STRUCTURED_CLONE_TRANSFER) {
    arrayBuffer = structuredClone(arrayBuffer, { transfer: [arrayBuffer] });
    if (byteLength === newByteLength && (preserveResizability || fixedLength)) return arrayBuffer;
  }
  if (byteLength >= newByteLength && (!preserveResizability || fixedLength)) {
    newBuffer = slice(arrayBuffer, 0, newByteLength);
  } else {
    var options = preserveResizability && !fixedLength && maxByteLength ? { maxByteLength: maxByteLength(arrayBuffer) } : undefined;
    newBuffer = new ArrayBuffer(newByteLength, options);
    var a = new DataView(arrayBuffer);
    var b = new DataView(newBuffer);
    var copyLength = min(newByteLength, byteLength);
    for (var i = 0; i < copyLength; i++) setInt8(b, i, getInt8(a, i));
  }
  if (!PROPER_STRUCTURED_CLONE_TRANSFER) detachTransferable(arrayBuffer);
  return newBuffer;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer-view-core.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer-view-core.js ***!
  \******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var NATIVE_ARRAY_BUFFER = __webpack_require__(/*! ../internals/array-buffer-basic-detection */ "./node_modules/core-js/internals/array-buffer-basic-detection.js");
var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "./node_modules/core-js/internals/descriptors.js");
var globalThis = __webpack_require__(/*! ../internals/global-this */ "./node_modules/core-js/internals/global-this.js");
var isCallable = __webpack_require__(/*! ../internals/is-callable */ "./node_modules/core-js/internals/is-callable.js");
var isObject = __webpack_require__(/*! ../internals/is-object */ "./node_modules/core-js/internals/is-object.js");
var hasOwn = __webpack_require__(/*! ../internals/has-own-property */ "./node_modules/core-js/internals/has-own-property.js");
var classof = __webpack_require__(/*! ../internals/classof */ "./node_modules/core-js/internals/classof.js");
var tryToString = __webpack_require__(/*! ../internals/try-to-string */ "./node_modules/core-js/internals/try-to-string.js");
var createNonEnumerableProperty = __webpack_require__(/*! ../internals/create-non-enumerable-property */ "./node_modules/core-js/internals/create-non-enumerable-property.js");
var defineBuiltIn = __webpack_require__(/*! ../internals/define-built-in */ "./node_modules/core-js/internals/define-built-in.js");
var defineBuiltInAccessor = __webpack_require__(/*! ../internals/define-built-in-accessor */ "./node_modules/core-js/internals/define-built-in-accessor.js");
var isPrototypeOf = __webpack_require__(/*! ../internals/object-is-prototype-of */ "./node_modules/core-js/internals/object-is-prototype-of.js");
var getPrototypeOf = __webpack_require__(/*! ../internals/object-get-prototype-of */ "./node_modules/core-js/internals/object-get-prototype-of.js");
var setPrototypeOf = __webpack_require__(/*! ../internals/object-set-prototype-of */ "./node_modules/core-js/internals/object-set-prototype-of.js");
var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "./node_modules/core-js/internals/well-known-symbol.js");
var uid = __webpack_require__(/*! ../internals/uid */ "./node_modules/core-js/internals/uid.js");
var InternalStateModule = __webpack_require__(/*! ../internals/internal-state */ "./node_modules/core-js/internals/internal-state.js");

var enforceInternalState = InternalStateModule.enforce;
var getInternalState = InternalStateModule.get;
var Int8Array = globalThis.Int8Array;
var Int8ArrayPrototype = Int8Array && Int8Array.prototype;
var Uint8ClampedArray = globalThis.Uint8ClampedArray;
var Uint8ClampedArrayPrototype = Uint8ClampedArray && Uint8ClampedArray.prototype;
var TypedArray = Int8Array && getPrototypeOf(Int8Array);
var TypedArrayPrototype = Int8ArrayPrototype && getPrototypeOf(Int8ArrayPrototype);
var ObjectPrototype = Object.prototype;
var TypeError = globalThis.TypeError;

var TO_STRING_TAG = wellKnownSymbol('toStringTag');
var TYPED_ARRAY_TAG = uid('TYPED_ARRAY_TAG');
var TYPED_ARRAY_CONSTRUCTOR = 'TypedArrayConstructor';
// Fixing native typed arrays in Opera Presto crashes the browser, see #595
var NATIVE_ARRAY_BUFFER_VIEWS = NATIVE_ARRAY_BUFFER && !!setPrototypeOf && classof(globalThis.opera) !== 'Opera';
var TYPED_ARRAY_TAG_REQUIRED = false;
var NAME, Constructor, Prototype;

var TypedArrayConstructorsList = {
  Int8Array: 1,
  Uint8Array: 1,
  Uint8ClampedArray: 1,
  Int16Array: 2,
  Uint16Array: 2,
  Int32Array: 4,
  Uint32Array: 4,
  Float32Array: 4,
  Float64Array: 8
};

var BigIntArrayConstructorsList = {
  BigInt64Array: 8,
  BigUint64Array: 8
};

var isView = function isView(it) {
  if (!isObject(it)) return false;
  var klass = classof(it);
  return klass === 'DataView'
    || hasOwn(TypedArrayConstructorsList, klass)
    || hasOwn(BigIntArrayConstructorsList, klass);
};

var getTypedArrayConstructor = function (it) {
  var proto = getPrototypeOf(it);
  if (!isObject(proto)) return;
  var state = getInternalState(proto);
  return (state && hasOwn(state, TYPED_ARRAY_CONSTRUCTOR)) ? state[TYPED_ARRAY_CONSTRUCTOR] : getTypedArrayConstructor(proto);
};

var isTypedArray = function (it) {
  if (!isObject(it)) return false;
  var klass = classof(it);
  return hasOwn(TypedArrayConstructorsList, klass)
    || hasOwn(BigIntArrayConstructorsList, klass);
};

var aTypedArray = function (it) {
  if (isTypedArray(it)) return it;
  throw new TypeError('Target is not a typed array');
};

var aTypedArrayConstructor = function (C) {
  if (isCallable(C) && (!setPrototypeOf || isPrototypeOf(TypedArray, C))) return C;
  throw new TypeError(tryToString(C) + ' is not a typed array constructor');
};

var exportTypedArrayMethod = function (KEY, property, forced, options) {
  if (!DESCRIPTORS) return;
  if (forced) for (var ARRAY in TypedArrayConstructorsList) {
    var TypedArrayConstructor = globalThis[ARRAY];
    if (TypedArrayConstructor && hasOwn(TypedArrayConstructor.prototype, KEY)) try {
      delete TypedArrayConstructor.prototype[KEY];
    } catch (error) {
      // old WebKit bug - some methods are non-configurable
      try {
        TypedArrayConstructor.prototype[KEY] = property;
      } catch (error2) { /* empty */ }
    }
  }
  if (!TypedArrayPrototype[KEY] || forced) {
    defineBuiltIn(TypedArrayPrototype, KEY, forced ? property
      : NATIVE_ARRAY_BUFFER_VIEWS && Int8ArrayPrototype[KEY] || property, options);
  }
};

var exportTypedArrayStaticMethod = function (KEY, property, forced) {
  var ARRAY, TypedArrayConstructor;
  if (!DESCRIPTORS) return;
  if (setPrototypeOf) {
    if (forced) for (ARRAY in TypedArrayConstructorsList) {
      TypedArrayConstructor = globalThis[ARRAY];
      if (TypedArrayConstructor && hasOwn(TypedArrayConstructor, KEY)) try {
        delete TypedArrayConstructor[KEY];
      } catch (error) { /* empty */ }
    }
    if (!TypedArray[KEY] || forced) {
      // V8 ~ Chrome 49-50 `%TypedArray%` methods are non-writable non-configurable
      try {
        return defineBuiltIn(TypedArray, KEY, forced ? property : NATIVE_ARRAY_BUFFER_VIEWS && TypedArray[KEY] || property);
      } catch (error) { /* empty */ }
    } else return;
  }
  for (ARRAY in TypedArrayConstructorsList) {
    TypedArrayConstructor = globalThis[ARRAY];
    if (TypedArrayConstructor && (!TypedArrayConstructor[KEY] || forced)) {
      defineBuiltIn(TypedArrayConstructor, KEY, property);
    }
  }
};

for (NAME in TypedArrayConstructorsList) {
  Constructor = globalThis[NAME];
  Prototype = Constructor && Constructor.prototype;
  if (Prototype) enforceInternalState(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
  else NATIVE_ARRAY_BUFFER_VIEWS = false;
}

for (NAME in BigIntArrayConstructorsList) {
  Constructor = globalThis[NAME];
  Prototype = Constructor && Constructor.prototype;
  if (Prototype) enforceInternalState(Prototype)[TYPED_ARRAY_CONSTRUCTOR] = Constructor;
}

// WebKit bug - typed arrays constructors prototype is Object.prototype
if (!NATIVE_ARRAY_BUFFER_VIEWS || !isCallable(TypedArray) || TypedArray === Function.prototype) {
  // eslint-disable-next-line no-shadow -- safe
  TypedArray = function TypedArray() {
    throw new TypeError('Incorrect invocation');
  };
  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
    if (globalThis[NAME]) setPrototypeOf(globalThis[NAME], TypedArray);
  }
}

if (!NATIVE_ARRAY_BUFFER_VIEWS || !TypedArrayPrototype || TypedArrayPrototype === ObjectPrototype) {
  TypedArrayPrototype = TypedArray.prototype;
  if (NATIVE_ARRAY_BUFFER_VIEWS) for (NAME in TypedArrayConstructorsList) {
    if (globalThis[NAME]) setPrototypeOf(globalThis[NAME].prototype, TypedArrayPrototype);
  }
}

// WebKit bug - one more object in Uint8ClampedArray prototype chain
if (NATIVE_ARRAY_BUFFER_VIEWS && getPrototypeOf(Uint8ClampedArrayPrototype) !== TypedArrayPrototype) {
  setPrototypeOf(Uint8ClampedArrayPrototype, TypedArrayPrototype);
}

if (DESCRIPTORS && !hasOwn(TypedArrayPrototype, TO_STRING_TAG)) {
  TYPED_ARRAY_TAG_REQUIRED = true;
  defineBuiltInAccessor(TypedArrayPrototype, TO_STRING_TAG, {
    configurable: true,
    get: function () {
      return isObject(this) ? this[TYPED_ARRAY_TAG] : undefined;
    }
  });
  for (NAME in TypedArrayConstructorsList) if (globalThis[NAME]) {
    createNonEnumerableProperty(globalThis[NAME], TYPED_ARRAY_TAG, NAME);
  }
}

module.exports = {
  NATIVE_ARRAY_BUFFER_VIEWS: NATIVE_ARRAY_BUFFER_VIEWS,
  TYPED_ARRAY_TAG: TYPED_ARRAY_TAG_REQUIRED && TYPED_ARRAY_TAG,
  aTypedArray: aTypedArray,
  aTypedArrayConstructor: aTypedArrayConstructor,
  exportTypedArrayMethod: exportTypedArrayMethod,
  exportTypedArrayStaticMethod: exportTypedArrayStaticMethod,
  getTypedArrayConstructor: getTypedArrayConstructor,
  isView: isView,
  isTypedArray: isTypedArray,
  TypedArray: TypedArray,
  TypedArrayPrototype: TypedArrayPrototype
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-buffer.js":
/*!********************************************************!*\
  !*** ./node_modules/core-js/internals/array-buffer.js ***!
  \********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var globalThis = __webpack_require__(/*! ../internals/global-this */ "./node_modules/core-js/internals/global-this.js");
var uncurryThis = __webpack_require__(/*! ../internals/function-uncurry-this */ "./node_modules/core-js/internals/function-uncurry-this.js");
var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "./node_modules/core-js/internals/descriptors.js");
var NATIVE_ARRAY_BUFFER = __webpack_require__(/*! ../internals/array-buffer-basic-detection */ "./node_modules/core-js/internals/array-buffer-basic-detection.js");
var FunctionName = __webpack_require__(/*! ../internals/function-name */ "./node_modules/core-js/internals/function-name.js");
var createNonEnumerableProperty = __webpack_require__(/*! ../internals/create-non-enumerable-property */ "./node_modules/core-js/internals/create-non-enumerable-property.js");
var defineBuiltInAccessor = __webpack_require__(/*! ../internals/define-built-in-accessor */ "./node_modules/core-js/internals/define-built-in-accessor.js");
var defineBuiltIns = __webpack_require__(/*! ../internals/define-built-ins */ "./node_modules/core-js/internals/define-built-ins.js");
var fails = __webpack_require__(/*! ../internals/fails */ "./node_modules/core-js/internals/fails.js");
var anInstance = __webpack_require__(/*! ../internals/an-instance */ "./node_modules/core-js/internals/an-instance.js");
var toIntegerOrInfinity = __webpack_require__(/*! ../internals/to-integer-or-infinity */ "./node_modules/core-js/internals/to-integer-or-infinity.js");
var toLength = __webpack_require__(/*! ../internals/to-length */ "./node_modules/core-js/internals/to-length.js");
var toIndex = __webpack_require__(/*! ../internals/to-index */ "./node_modules/core-js/internals/to-index.js");
var fround = __webpack_require__(/*! ../internals/math-fround */ "./node_modules/core-js/internals/math-fround.js");
var IEEE754 = __webpack_require__(/*! ../internals/ieee754 */ "./node_modules/core-js/internals/ieee754.js");
var getPrototypeOf = __webpack_require__(/*! ../internals/object-get-prototype-of */ "./node_modules/core-js/internals/object-get-prototype-of.js");
var setPrototypeOf = __webpack_require__(/*! ../internals/object-set-prototype-of */ "./node_modules/core-js/internals/object-set-prototype-of.js");
var arrayFill = __webpack_require__(/*! ../internals/array-fill */ "./node_modules/core-js/internals/array-fill.js");
var arraySlice = __webpack_require__(/*! ../internals/array-slice */ "./node_modules/core-js/internals/array-slice.js");
var inheritIfRequired = __webpack_require__(/*! ../internals/inherit-if-required */ "./node_modules/core-js/internals/inherit-if-required.js");
var copyConstructorProperties = __webpack_require__(/*! ../internals/copy-constructor-properties */ "./node_modules/core-js/internals/copy-constructor-properties.js");
var setToStringTag = __webpack_require__(/*! ../internals/set-to-string-tag */ "./node_modules/core-js/internals/set-to-string-tag.js");
var InternalStateModule = __webpack_require__(/*! ../internals/internal-state */ "./node_modules/core-js/internals/internal-state.js");

var PROPER_FUNCTION_NAME = FunctionName.PROPER;
var CONFIGURABLE_FUNCTION_NAME = FunctionName.CONFIGURABLE;
var ARRAY_BUFFER = 'ArrayBuffer';
var DATA_VIEW = 'DataView';
var PROTOTYPE = 'prototype';
var WRONG_LENGTH = 'Wrong length';
var WRONG_INDEX = 'Wrong index';
var getInternalArrayBufferState = InternalStateModule.getterFor(ARRAY_BUFFER);
var getInternalDataViewState = InternalStateModule.getterFor(DATA_VIEW);
var setInternalState = InternalStateModule.set;
var NativeArrayBuffer = globalThis[ARRAY_BUFFER];
var $ArrayBuffer = NativeArrayBuffer;
var ArrayBufferPrototype = $ArrayBuffer && $ArrayBuffer[PROTOTYPE];
var $DataView = globalThis[DATA_VIEW];
var DataViewPrototype = $DataView && $DataView[PROTOTYPE];
var ObjectPrototype = Object.prototype;
var Array = globalThis.Array;
var RangeError = globalThis.RangeError;
var fill = uncurryThis(arrayFill);
var reverse = uncurryThis([].reverse);

var packIEEE754 = IEEE754.pack;
var unpackIEEE754 = IEEE754.unpack;

var packInt8 = function (number) {
  return [number & 0xFF];
};

var packInt16 = function (number) {
  return [number & 0xFF, number >> 8 & 0xFF];
};

var packInt32 = function (number) {
  return [number & 0xFF, number >> 8 & 0xFF, number >> 16 & 0xFF, number >> 24 & 0xFF];
};

var unpackInt32 = function (buffer) {
  return buffer[3] << 24 | buffer[2] << 16 | buffer[1] << 8 | buffer[0];
};

var packFloat32 = function (number) {
  return packIEEE754(fround(number), 23, 4);
};

var packFloat64 = function (number) {
  return packIEEE754(number, 52, 8);
};

var addGetter = function (Constructor, key, getInternalState) {
  defineBuiltInAccessor(Constructor[PROTOTYPE], key, {
    configurable: true,
    get: function () {
      return getInternalState(this)[key];
    }
  });
};

var get = function (view, count, index, isLittleEndian) {
  var store = getInternalDataViewState(view);
  var intIndex = toIndex(index);
  var boolIsLittleEndian = !!isLittleEndian;
  if (intIndex + count > store.byteLength) throw new RangeError(WRONG_INDEX);
  var bytes = store.bytes;
  var start = intIndex + store.byteOffset;
  var pack = arraySlice(bytes, start, start + count);
  return boolIsLittleEndian ? pack : reverse(pack);
};

var set = function (view, count, index, conversion, value, isLittleEndian) {
  var store = getInternalDataViewState(view);
  var intIndex = toIndex(index);
  var pack = conversion(+value);
  var boolIsLittleEndian = !!isLittleEndian;
  if (intIndex + count > store.byteLength) throw new RangeError(WRONG_INDEX);
  var bytes = store.bytes;
  var start = intIndex + store.byteOffset;
  for (var i = 0; i < count; i++) bytes[start + i] = pack[boolIsLittleEndian ? i : count - i - 1];
};

if (!NATIVE_ARRAY_BUFFER) {
  $ArrayBuffer = function ArrayBuffer(length) {
    anInstance(this, ArrayBufferPrototype);
    var byteLength = toIndex(length);
    setInternalState(this, {
      type: ARRAY_BUFFER,
      bytes: fill(Array(byteLength), 0),
      byteLength: byteLength
    });
    if (!DESCRIPTORS) {
      this.byteLength = byteLength;
      this.detached = false;
    }
  };

  ArrayBufferPrototype = $ArrayBuffer[PROTOTYPE];

  $DataView = function DataView(buffer, byteOffset, byteLength) {
    anInstance(this, DataViewPrototype);
    anInstance(buffer, ArrayBufferPrototype);
    var bufferState = getInternalArrayBufferState(buffer);
    var bufferLength = bufferState.byteLength;
    var offset = toIntegerOrInfinity(byteOffset);
    if (offset < 0 || offset > bufferLength) throw new RangeError('Wrong offset');
    byteLength = byteLength === undefined ? bufferLength - offset : toLength(byteLength);
    if (offset + byteLength > bufferLength) throw new RangeError(WRONG_LENGTH);
    setInternalState(this, {
      type: DATA_VIEW,
      buffer: buffer,
      byteLength: byteLength,
      byteOffset: offset,
      bytes: bufferState.bytes
    });
    if (!DESCRIPTORS) {
      this.buffer = buffer;
      this.byteLength = byteLength;
      this.byteOffset = offset;
    }
  };

  DataViewPrototype = $DataView[PROTOTYPE];

  if (DESCRIPTORS) {
    addGetter($ArrayBuffer, 'byteLength', getInternalArrayBufferState);
    addGetter($DataView, 'buffer', getInternalDataViewState);
    addGetter($DataView, 'byteLength', getInternalDataViewState);
    addGetter($DataView, 'byteOffset', getInternalDataViewState);
  }

  defineBuiltIns(DataViewPrototype, {
    getInt8: function getInt8(byteOffset) {
      return get(this, 1, byteOffset)[0] << 24 >> 24;
    },
    getUint8: function getUint8(byteOffset) {
      return get(this, 1, byteOffset)[0];
    },
    getInt16: function getInt16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : false);
      return (bytes[1] << 8 | bytes[0]) << 16 >> 16;
    },
    getUint16: function getUint16(byteOffset /* , littleEndian */) {
      var bytes = get(this, 2, byteOffset, arguments.length > 1 ? arguments[1] : false);
      return bytes[1] << 8 | bytes[0];
    },
    getInt32: function getInt32(byteOffset /* , littleEndian */) {
      return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : false));
    },
    getUint32: function getUint32(byteOffset /* , littleEndian */) {
      return unpackInt32(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : false)) >>> 0;
    },
    getFloat32: function getFloat32(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 4, byteOffset, arguments.length > 1 ? arguments[1] : false), 23);
    },
    getFloat64: function getFloat64(byteOffset /* , littleEndian */) {
      return unpackIEEE754(get(this, 8, byteOffset, arguments.length > 1 ? arguments[1] : false), 52);
    },
    setInt8: function setInt8(byteOffset, value) {
      set(this, 1, byteOffset, packInt8, value);
    },
    setUint8: function setUint8(byteOffset, value) {
      set(this, 1, byteOffset, packInt8, value);
    },
    setInt16: function setInt16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : false);
    },
    setUint16: function setUint16(byteOffset, value /* , littleEndian */) {
      set(this, 2, byteOffset, packInt16, value, arguments.length > 2 ? arguments[2] : false);
    },
    setInt32: function setInt32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : false);
    },
    setUint32: function setUint32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packInt32, value, arguments.length > 2 ? arguments[2] : false);
    },
    setFloat32: function setFloat32(byteOffset, value /* , littleEndian */) {
      set(this, 4, byteOffset, packFloat32, value, arguments.length > 2 ? arguments[2] : false);
    },
    setFloat64: function setFloat64(byteOffset, value /* , littleEndian */) {
      set(this, 8, byteOffset, packFloat64, value, arguments.length > 2 ? arguments[2] : false);
    }
  });
} else {
  var INCORRECT_ARRAY_BUFFER_NAME = PROPER_FUNCTION_NAME && NativeArrayBuffer.name !== ARRAY_BUFFER;
  /* eslint-disable no-new, sonarjs/inconsistent-function-call -- required for testing */
  if (!fails(function () {
    NativeArrayBuffer(1);
  }) || !fails(function () {
    new NativeArrayBuffer(-1);
  }) || fails(function () {
    new NativeArrayBuffer();
    new NativeArrayBuffer(1.5);
    new NativeArrayBuffer(NaN);
    return NativeArrayBuffer.length !== 1 || INCORRECT_ARRAY_BUFFER_NAME && !CONFIGURABLE_FUNCTION_NAME;
  })) {
    /* eslint-enable no-new, sonarjs/inconsistent-function-call -- required for testing */
    $ArrayBuffer = function ArrayBuffer(length) {
      anInstance(this, ArrayBufferPrototype);
      return inheritIfRequired(new NativeArrayBuffer(toIndex(length)), this, $ArrayBuffer);
    };

    $ArrayBuffer[PROTOTYPE] = ArrayBufferPrototype;

    ArrayBufferPrototype.constructor = $ArrayBuffer;

    copyConstructorProperties($ArrayBuffer, NativeArrayBuffer);
  } else if (INCORRECT_ARRAY_BUFFER_NAME && CONFIGURABLE_FUNCTION_NAME) {
    createNonEnumerableProperty(NativeArrayBuffer, 'name', ARRAY_BUFFER);
  }

  // WebKit bug - the same parent prototype for typed arrays and data view
  if (setPrototypeOf && getPrototypeOf(DataViewPrototype) !== ObjectPrototype) {
    setPrototypeOf(DataViewPrototype, ObjectPrototype);
  }

  // iOS Safari 7.x bug
  var testView = new $DataView(new $ArrayBuffer(2));
  var $setInt8 = uncurryThis(DataViewPrototype.setInt8);
  testView.setInt8(0, 2147483648);
  testView.setInt8(1, 2147483649);
  if (testView.getInt8(0) || !testView.getInt8(1)) defineBuiltIns(DataViewPrototype, {
    setInt8: function setInt8(byteOffset, value) {
      $setInt8(this, byteOffset, value << 24 >> 24);
    },
    setUint8: function setUint8(byteOffset, value) {
      $setInt8(this, byteOffset, value << 24 >> 24);
    }
  }, { unsafe: true });
}

setToStringTag($ArrayBuffer, ARRAY_BUFFER);
setToStringTag($DataView, DATA_VIEW);

module.exports = {
  ArrayBuffer: $ArrayBuffer,
  DataView: $DataView
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-copy-within.js":
/*!*************************************************************!*\
  !*** ./node_modules/core-js/internals/array-copy-within.js ***!
  \*************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var toObject = __webpack_require__(/*! ../internals/to-object */ "./node_modules/core-js/internals/to-object.js");
var toAbsoluteIndex = __webpack_require__(/*! ../internals/to-absolute-index */ "./node_modules/core-js/internals/to-absolute-index.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");
var deletePropertyOrThrow = __webpack_require__(/*! ../internals/delete-property-or-throw */ "./node_modules/core-js/internals/delete-property-or-throw.js");

var min = Math.min;

// `Array.prototype.copyWithin` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.copywithin
// eslint-disable-next-line es/no-array-prototype-copywithin -- safe
module.exports = [].copyWithin || function copyWithin(target /* = 0 */, start /* = 0, end = @length */) {
  var O = toObject(this);
  var len = lengthOfArrayLike(O);
  var to = toAbsoluteIndex(target, len);
  var from = toAbsoluteIndex(start, len);
  var end = arguments.length > 2 ? arguments[2] : undefined;
  var count = min((end === undefined ? len : toAbsoluteIndex(end, len)) - from, len - to);
  var inc = 1;
  if (from < to && to < from + count) {
    inc = -1;
    from += count - 1;
    to += count - 1;
  }
  while (count-- > 0) {
    if (from in O) O[to] = O[from];
    else deletePropertyOrThrow(O, to);
    to += inc;
    from += inc;
  } return O;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-fill.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/internals/array-fill.js ***!
  \******************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var toObject = __webpack_require__(/*! ../internals/to-object */ "./node_modules/core-js/internals/to-object.js");
var toAbsoluteIndex = __webpack_require__(/*! ../internals/to-absolute-index */ "./node_modules/core-js/internals/to-absolute-index.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");

// `Array.prototype.fill` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.fill
module.exports = function fill(value /* , start = 0, end = @length */) {
  var O = toObject(this);
  var length = lengthOfArrayLike(O);
  var argumentsLength = arguments.length;
  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-for-each.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/internals/array-for-each.js ***!
  \**********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var $forEach = (__webpack_require__(/*! ../internals/array-iteration */ "./node_modules/core-js/internals/array-iteration.js").forEach);
var arrayMethodIsStrict = __webpack_require__(/*! ../internals/array-method-is-strict */ "./node_modules/core-js/internals/array-method-is-strict.js");

var STRICT_METHOD = arrayMethodIsStrict('forEach');

// `Array.prototype.forEach` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.foreach
module.exports = !STRICT_METHOD ? function forEach(callbackfn /* , thisArg */) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
} : [].forEach;


/***/ }),

/***/ "./node_modules/core-js/internals/array-from-constructor-and-list.js":
/*!***************************************************************************!*\
  !*** ./node_modules/core-js/internals/array-from-constructor-and-list.js ***!
  \***************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");

module.exports = function (Constructor, list, $length) {
  var index = 0;
  var length = arguments.length > 2 ? $length : lengthOfArrayLike(list);
  var result = new Constructor(length);
  while (length > index) result[index] = list[index++];
  return result;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-from.js":
/*!******************************************************!*\
  !*** ./node_modules/core-js/internals/array-from.js ***!
  \******************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var bind = __webpack_require__(/*! ../internals/function-bind-context */ "./node_modules/core-js/internals/function-bind-context.js");
var call = __webpack_require__(/*! ../internals/function-call */ "./node_modules/core-js/internals/function-call.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "./node_modules/core-js/internals/to-object.js");
var callWithSafeIterationClosing = __webpack_require__(/*! ../internals/call-with-safe-iteration-closing */ "./node_modules/core-js/internals/call-with-safe-iteration-closing.js");
var isArrayIteratorMethod = __webpack_require__(/*! ../internals/is-array-iterator-method */ "./node_modules/core-js/internals/is-array-iterator-method.js");
var isConstructor = __webpack_require__(/*! ../internals/is-constructor */ "./node_modules/core-js/internals/is-constructor.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");
var createProperty = __webpack_require__(/*! ../internals/create-property */ "./node_modules/core-js/internals/create-property.js");
var getIterator = __webpack_require__(/*! ../internals/get-iterator */ "./node_modules/core-js/internals/get-iterator.js");
var getIteratorMethod = __webpack_require__(/*! ../internals/get-iterator-method */ "./node_modules/core-js/internals/get-iterator-method.js");

var $Array = Array;

// `Array.from` method implementation
// https://tc39.es/ecma262/#sec-array.from
module.exports = function from(arrayLike /* , mapfn = undefined, thisArg = undefined */) {
  var O = toObject(arrayLike);
  var IS_CONSTRUCTOR = isConstructor(this);
  var argumentsLength = arguments.length;
  var mapfn = argumentsLength > 1 ? arguments[1] : undefined;
  var mapping = mapfn !== undefined;
  if (mapping) mapfn = bind(mapfn, argumentsLength > 2 ? arguments[2] : undefined);
  var iteratorMethod = getIteratorMethod(O);
  var index = 0;
  var length, result, step, iterator, next, value;
  // if the target is not iterable or it's an array with the default iterator - use a simple case
  if (iteratorMethod && !(this === $Array && isArrayIteratorMethod(iteratorMethod))) {
    result = IS_CONSTRUCTOR ? new this() : [];
    iterator = getIterator(O, iteratorMethod);
    next = iterator.next;
    for (;!(step = call(next, iterator)).done; index++) {
      value = mapping ? callWithSafeIterationClosing(iterator, mapfn, [step.value, index], true) : step.value;
      createProperty(result, index, value);
    }
  } else {
    length = lengthOfArrayLike(O);
    result = IS_CONSTRUCTOR ? new this(length) : $Array(length);
    for (;length > index; index++) {
      value = mapping ? mapfn(O[index], index) : O[index];
      createProperty(result, index, value);
    }
  }
  result.length = index;
  return result;
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-includes.js":
/*!**********************************************************!*\
  !*** ./node_modules/core-js/internals/array-includes.js ***!
  \**********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "./node_modules/core-js/internals/to-indexed-object.js");
var toAbsoluteIndex = __webpack_require__(/*! ../internals/to-absolute-index */ "./node_modules/core-js/internals/to-absolute-index.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject($this);
    var length = lengthOfArrayLike(O);
    if (length === 0) return !IS_INCLUDES && -1;
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el !== el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value !== value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

module.exports = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod(false)
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-iteration-from-last.js":
/*!*********************************************************************!*\
  !*** ./node_modules/core-js/internals/array-iteration-from-last.js ***!
  \*********************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var bind = __webpack_require__(/*! ../internals/function-bind-context */ "./node_modules/core-js/internals/function-bind-context.js");
var IndexedObject = __webpack_require__(/*! ../internals/indexed-object */ "./node_modules/core-js/internals/indexed-object.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "./node_modules/core-js/internals/to-object.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");

// `Array.prototype.{ findLast, findLastIndex }` methods implementation
var createMethod = function (TYPE) {
  var IS_FIND_LAST_INDEX = TYPE === 1;
  return function ($this, callbackfn, that) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var index = lengthOfArrayLike(self);
    var boundFunction = bind(callbackfn, that);
    var value, result;
    while (index-- > 0) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (result) switch (TYPE) {
        case 0: return value; // findLast
        case 1: return index; // findLastIndex
      }
    }
    return IS_FIND_LAST_INDEX ? -1 : undefined;
  };
};

module.exports = {
  // `Array.prototype.findLast` method
  // https://github.com/tc39/proposal-array-find-from-last
  findLast: createMethod(0),
  // `Array.prototype.findLastIndex` method
  // https://github.com/tc39/proposal-array-find-from-last
  findLastIndex: createMethod(1)
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-iteration.js":
/*!***********************************************************!*\
  !*** ./node_modules/core-js/internals/array-iteration.js ***!
  \***********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var bind = __webpack_require__(/*! ../internals/function-bind-context */ "./node_modules/core-js/internals/function-bind-context.js");
var uncurryThis = __webpack_require__(/*! ../internals/function-uncurry-this */ "./node_modules/core-js/internals/function-uncurry-this.js");
var IndexedObject = __webpack_require__(/*! ../internals/indexed-object */ "./node_modules/core-js/internals/indexed-object.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "./node_modules/core-js/internals/to-object.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");
var arraySpeciesCreate = __webpack_require__(/*! ../internals/array-species-create */ "./node_modules/core-js/internals/array-species-create.js");

var push = uncurryThis([].push);

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
var createMethod = function (TYPE) {
  var IS_MAP = TYPE === 1;
  var IS_FILTER = TYPE === 2;
  var IS_SOME = TYPE === 3;
  var IS_EVERY = TYPE === 4;
  var IS_FIND_INDEX = TYPE === 6;
  var IS_FILTER_REJECT = TYPE === 7;
  var NO_HOLES = TYPE === 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject($this);
    var self = IndexedObject(O);
    var length = lengthOfArrayLike(self);
    var boundFunction = bind(callbackfn, that);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push(target, value);      // filter
        } else switch (TYPE) {
          case 4: return false;             // every
          case 7: push(target, value);      // filterReject
        }
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

module.exports = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod(6),
  // `Array.prototype.filterReject` method
  // https://github.com/tc39/proposal-array-filtering
  filterReject: createMethod(7)
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-last-index-of.js":
/*!***************************************************************!*\
  !*** ./node_modules/core-js/internals/array-last-index-of.js ***!
  \***************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

/* eslint-disable es/no-array-prototype-lastindexof -- safe */
var apply = __webpack_require__(/*! ../internals/function-apply */ "./node_modules/core-js/internals/function-apply.js");
var toIndexedObject = __webpack_require__(/*! ../internals/to-indexed-object */ "./node_modules/core-js/internals/to-indexed-object.js");
var toIntegerOrInfinity = __webpack_require__(/*! ../internals/to-integer-or-infinity */ "./node_modules/core-js/internals/to-integer-or-infinity.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");
var arrayMethodIsStrict = __webpack_require__(/*! ../internals/array-method-is-strict */ "./node_modules/core-js/internals/array-method-is-strict.js");

var min = Math.min;
var $lastIndexOf = [].lastIndexOf;
var NEGATIVE_ZERO = !!$lastIndexOf && 1 / [1].lastIndexOf(1, -0) < 0;
var STRICT_METHOD = arrayMethodIsStrict('lastIndexOf');
var FORCED = NEGATIVE_ZERO || !STRICT_METHOD;

// `Array.prototype.lastIndexOf` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.lastindexof
module.exports = FORCED ? function lastIndexOf(searchElement /* , fromIndex = @[*-1] */) {
  // convert -0 to +0
  if (NEGATIVE_ZERO) return apply($lastIndexOf, this, arguments) || 0;
  var O = toIndexedObject(this);
  var length = lengthOfArrayLike(O);
  if (length === 0) return -1;
  var index = length - 1;
  if (arguments.length > 1) index = min(index, toIntegerOrInfinity(arguments[1]));
  if (index < 0) index = length + index;
  for (;index >= 0; index--) if (index in O && O[index] === searchElement) return index || 0;
  return -1;
} : $lastIndexOf;


/***/ }),

/***/ "./node_modules/core-js/internals/array-method-has-species-support.js":
/*!****************************************************************************!*\
  !*** ./node_modules/core-js/internals/array-method-has-species-support.js ***!
  \****************************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var fails = __webpack_require__(/*! ../internals/fails */ "./node_modules/core-js/internals/fails.js");
var wellKnownSymbol = __webpack_require__(/*! ../internals/well-known-symbol */ "./node_modules/core-js/internals/well-known-symbol.js");
var V8_VERSION = __webpack_require__(/*! ../internals/environment-v8-version */ "./node_modules/core-js/internals/environment-v8-version.js");

var SPECIES = wellKnownSymbol('species');

module.exports = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION >= 51 || !fails(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[SPECIES] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-method-is-strict.js":
/*!******************************************************************!*\
  !*** ./node_modules/core-js/internals/array-method-is-strict.js ***!
  \******************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var fails = __webpack_require__(/*! ../internals/fails */ "./node_modules/core-js/internals/fails.js");

module.exports = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails(function () {
    // eslint-disable-next-line no-useless-call -- required for testing
    method.call(null, argument || function () { return 1; }, 1);
  });
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-reduce.js":
/*!********************************************************!*\
  !*** ./node_modules/core-js/internals/array-reduce.js ***!
  \********************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var aCallable = __webpack_require__(/*! ../internals/a-callable */ "./node_modules/core-js/internals/a-callable.js");
var toObject = __webpack_require__(/*! ../internals/to-object */ "./node_modules/core-js/internals/to-object.js");
var IndexedObject = __webpack_require__(/*! ../internals/indexed-object */ "./node_modules/core-js/internals/indexed-object.js");
var lengthOfArrayLike = __webpack_require__(/*! ../internals/length-of-array-like */ "./node_modules/core-js/internals/length-of-array-like.js");

var $TypeError = TypeError;

var REDUCE_EMPTY = 'Reduce of empty array with no initial value';

// `Array.prototype.{ reduce, reduceRight }` methods implementation
var createMethod = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    var O = toObject(that);
    var self = IndexedObject(O);
    var length = lengthOfArrayLike(O);
    aCallable(callbackfn);
    if (length === 0 && argumentsLength < 2) throw new $TypeError(REDUCE_EMPTY);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw new $TypeError(REDUCE_EMPTY);
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

module.exports = {
  // `Array.prototype.reduce` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduce
  left: createMethod(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
  right: createMethod(true)
};


/***/ }),

/***/ "./node_modules/core-js/internals/array-set-length.js":
/*!************************************************************!*\
  !*** ./node_modules/core-js/internals/array-set-length.js ***!
  \************************************************************/
/***/ (function(module, __unused_webpack_exports, __webpack_require__) {

"use strict";

var DESCRIPTORS = __webpack_require__(/*! ../internals/descriptors */ "./node_modules/core-js/internals/descriptors.js");
var isArray = __webpack_require__(/*! ../internals/is-array */ "./node_modules/core-js/internals/is-array.js");

var $TypeError = TypeError;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor = Object.getOwnPropertyDescript