/**
 * Inject http Body
 *  @param {string} [name] properties name in body object
 */
export declare function Body(): ParameterDecorator;
/**
 * Inject value from body
 *
 * @param {string} [name] The name of the body parameter
 */
export declare function BodyProp(name?: string): ParameterDecorator;
/**
 * Inject http request
 */
export declare function Request(): ParameterDecorator;
/**
 * Inject value from request
 *
 * @param {name} [name] The name of the request parameter
 */
export declare function RequestProp(name?: string): ParameterDecorator;
/**
 * Inject value from Path
 *
 * @param {string} [name] The name of the path parameter
 */
export declare function Path(name?: string): ParameterDecorator;
/**
 * Inject value from query string
 *
 * @param {string} [name] The name of the query parameter
 */
export declare function Query(name?: string): ParameterDecorator;
/**
 * Inject all query values in a single object
 */
export declare function Queries(): ParameterDecorator;
/**
 * Inject value from Http header
 *
 * @param {string} [name] The name of the header parameter
 */
export declare function Header(name?: string): ParameterDecorator;
/**
 * Mark parameter as manually injected, which will not be generated
 */
export declare function Inject(): ParameterDecorator;
/**
 * Inject uploaded file
 *
 * @param {string} [name] The name of the uploaded file parameter
 */
export declare function UploadedFile(name?: string): ParameterDecorator;
/**
 * Inject uploaded files
 *
 * @param {string} [name] The name of the uploaded files parameter
 */
export declare function UploadedFiles(name?: string): ParameterDecorator;
/**
 * Inject uploaded files
 *
 * @param {string} [name] The name of the uploaded files parameter
 */
export declare function FormField(name?: string): ParameterDecorator;
/**
 * Overrides the default media type of request body.
 * Can be used on specific method.
 * Can't be used on controller level.
 *
 * @link https://swagger.io/docs/specification/describing-request-body/
 */
export declare function Consumes(value: string): MethodDecorator;
