import { createUniqueId } from 'solid-js'
import { useStyles } from '../styles/use-styles'

export function TanStackLogo() {
  const id = createUniqueId()
  const styles = useStyles()
  return (
    <svg
      class={styles().logo}
      xmlns="http://www.w3.org/2000/svg"
      enable-background="new 0 0 634 633"
      viewBox="0 0 634 633"
    >
      <g transform="translate(1)">
        <linearGradient
          id={`a-${id}`}
          x1="-641.486"
          x2="-641.486"
          y1="856.648"
          y2="855.931"
          gradientTransform="matrix(633 0 0 -633 406377 542258)"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stop-color="#6bdaff"></stop>
          <stop offset="0.319" stop-color="#f9ffb5"></stop>
          <stop offset="0.706" stop-color="#ffa770"></stop>
          <stop offset="1" stop-color="#ff7373"></stop>
        </linearGradient>
        <circle
          cx="316.5"
          cy="316.5"
          r="316.5"
          fill={`url(#a-${id})`}
          fill-rule="evenodd"
          clip-rule="evenodd"
        ></circle>
        <defs>
          <filter
            id={`b-${id}`}
            width="454"
            height="396.9"
            x="-137.5"
            y="412"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`c-${id}`}
          width="454"
          height="396.9"
          x="-137.5"
          y="412"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#b-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <ellipse
          cx="89.5"
          cy="610.5"
          fill="#015064"
          fill-rule="evenodd"
          stroke="#00CFE2"
          stroke-width="25"
          clip-rule="evenodd"
          mask={`url(#c-${id})`}
          rx="214.5"
          ry="186"
        ></ellipse>
        <defs>
          <filter
            id={`d-${id}`}
            width="454"
            height="396.9"
            x="316.5"
            y="412"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`e-${id}`}
          width="454"
          height="396.9"
          x="316.5"
          y="412"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#d-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <ellipse
          cx="543.5"
          cy="610.5"
          fill="#015064"
          fill-rule="evenodd"
          stroke="#00CFE2"
          stroke-width="25"
          clip-rule="evenodd"
          mask={`url(#e-${id})`}
          rx="214.5"
          ry="186"
        ></ellipse>
        <defs>
          <filter
            id={`f-${id}`}
            width="454"
            height="396.9"
            x="-137.5"
            y="450"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`g-${id}`}
          width="454"
          height="396.9"
          x="-137.5"
          y="450"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#f-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <ellipse
          cx="89.5"
          cy="648.5"
          fill="#015064"
          fill-rule="evenodd"
          stroke="#00A8B8"
          stroke-width="25"
          clip-rule="evenodd"
          mask={`url(#g-${id})`}
          rx="214.5"
          ry="186"
        ></ellipse>
        <defs>
          <filter
            id={`h-${id}`}
            width="454"
            height="396.9"
            x="316.5"
            y="450"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`i-${id}`}
          width="454"
          height="396.9"
          x="316.5"
          y="450"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#h-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <ellipse
          cx="543.5"
          cy="648.5"
          fill="#015064"
          fill-rule="evenodd"
          stroke="#00A8B8"
          stroke-width="25"
          clip-rule="evenodd"
          mask={`url(#i-${id})`}
          rx="214.5"
          ry="186"
        ></ellipse>
        <defs>
          <filter
            id={`j-${id}`}
            width="454"
            height="396.9"
            x="-137.5"
            y="486"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`k-${id}`}
          width="454"
          height="396.9"
          x="-137.5"
          y="486"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#j-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <ellipse
          cx="89.5"
          cy="684.5"
          fill="#015064"
          fill-rule="evenodd"
          stroke="#007782"
          stroke-width="25"
          clip-rule="evenodd"
          mask={`url(#k-${id})`}
          rx="214.5"
          ry="186"
        ></ellipse>
        <defs>
          <filter
            id={`l-${id}`}
            width="454"
            height="396.9"
            x="316.5"
            y="486"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`m-${id}`}
          width="454"
          height="396.9"
          x="316.5"
          y="486"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#l-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <ellipse
          cx="543.5"
          cy="684.5"
          fill="#015064"
          fill-rule="evenodd"
          stroke="#007782"
          stroke-width="25"
          clip-rule="evenodd"
          mask={`url(#m-${id})`}
          rx="214.5"
          ry="186"
        ></ellipse>
        <defs>
          <filter
            id={`n-${id}`}
            width="176.9"
            height="129.3"
            x="272.2"
            y="308"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`o-${id}`}
          width="176.9"
          height="129.3"
          x="272.2"
          y="308"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#n-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <g mask={`url(#o-${id})`}>
          <path
            fill="none"
            stroke="#000"
            stroke-linecap="round"
            stroke-linejoin="bevel"
            stroke-width="11"
            d="M436 403.2l-5 28.6m-140-90.3l-10.9 62m52.8-19.4l-4.3 27.1"
          ></path>
          <linearGradient
            id={`p-${id}`}
            x1="-645.656"
            x2="-646.499"
            y1="854.878"
            y2="854.788"
            gradientTransform="matrix(-184.159 -32.4722 11.4608 -64.9973 -128419.844 34938.836)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#ee2700"></stop>
            <stop offset="1" stop-color="#ff008e"></stop>
          </linearGradient>
          <path
            fill={`url(#p-${id})`}
            fill-rule="evenodd"
            d="M344.1 363l97.7 17.2c5.8 2.1 8.2 6.2 7.1 12.1-1 5.9-4.7 9.2-11 9.9l-106-18.7-57.5-59.2c-3.2-4.8-2.9-9.1.8-12.8 3.7-3.7 8.3-4.4 13.7-2.1l55.2 53.6z"
            clip-rule="evenodd"
          ></path>
          <path
            fill="#D8D8D8"
            fill-rule="evenodd"
            stroke="#FFF"
            stroke-linecap="round"
            stroke-linejoin="bevel"
            stroke-width="7"
            d="M428.3 384.5l.9-6.5m-33.9 1.5l.9-6.5m-34 .5l.9-6.1m-38.9-16.1l4.2-3.9m-25.2-16.1l4.2-3.9"
            clip-rule="evenodd"
          ></path>
        </g>
        <defs>
          <filter
            id={`q-${id}`}
            width="280.6"
            height="317.4"
            x="73.2"
            y="113.9"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`r-${id}`}
          width="280.6"
          height="317.4"
          x="73.2"
          y="113.9"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#q-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <g mask={`url(#r-${id})`}>
          <linearGradient
            id={`s-${id}`}
            x1="-646.8"
            x2="-646.8"
            y1="854.844"
            y2="853.844"
            gradientTransform="matrix(-100.1751 48.8587 -97.9753 -200.879 19124.773 203538.61)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#a17500"></stop>
            <stop offset="1" stop-color="#5d2100"></stop>
          </linearGradient>
          <path
            fill={`url(#s-${id})`}
            fill-rule="evenodd"
            d="M192.3 203c8.1 37.3 14 73.6 17.8 109.1 3.8 35.4 2.8 75.2-2.9 119.2l61.2-16.7c-15.6-59-25.2-97.9-28.6-116.6-3.4-18.7-10.8-51.8-22.2-99.6l-25.3 4.6"
            clip-rule="evenodd"
          ></path>
          <linearGradient
            id={`t-${id}`}
            x1="-635.467"
            x2="-635.467"
            y1="852.115"
            y2="851.115"
            gradientTransform="matrix(92.6873 4.8575 2.0257 -38.6535 57323.695 36176.047)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#2f8a00"></stop>
            <stop offset="1" stop-color="#90ff57"></stop>
          </linearGradient>
          <path
            fill={`url(#t-${id})`}
            fill-rule="evenodd"
            stroke="#2F8A00"
            stroke-width="13"
            d="M195 183.9s-12.6-22.1-36.5-29.9c-15.9-5.2-34.4-1.5-55.5 11.1 15.9 14.3 29.5 22.6 40.7 24.9 16.8 3.6 51.3-6.1 51.3-6.1z"
            clip-rule="evenodd"
          ></path>
          <linearGradient
            id={`u-${id}`}
            x1="-636.573"
            x2="-636.573"
            y1="855.444"
            y2="854.444"
            gradientTransform="matrix(109.9945 5.7646 6.3597 -121.3507 64719.133 107659.336)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#2f8a00"></stop>
            <stop offset="1" stop-color="#90ff57"></stop>
          </linearGradient>
          <path
            fill={`url(#u-${id})`}
            fill-rule="evenodd"
            stroke="#2F8A00"
            stroke-width="13"
            d="M194.9 184.5s-47.5-8.5-83.2 15.7c-23.8 16.2-34.3 49.3-31.6 99.3 30.3-27.8 52.1-48.5 65.2-61.9 19.8-20 49.6-53.1 49.6-53.1z"
            clip-rule="evenodd"
          ></path>
          <linearGradient
            id={`v-${id}`}
            x1="-632.145"
            x2="-632.145"
            y1="854.174"
            y2="853.174"
            gradientTransform="matrix(62.9558 3.2994 3.5021 -66.8246 37035.367 59284.227)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#2f8a00"></stop>
            <stop offset="1" stop-color="#90ff57"></stop>
          </linearGradient>
          <path
            fill={`url(#v-${id})`}
            fill-rule="evenodd"
            stroke="#2F8A00"
            stroke-width="13"
            d="M195 183.9c-.8-21.9 6-38 20.6-48.2 14.6-10.2 29.8-15.3 45.5-15.3-6.1 21.4-14.5 35.8-25.2 43.4-10.7 7.5-24.4 14.2-40.9 20.1z"
            clip-rule="evenodd"
          ></path>
          <linearGradient
            id={`w-${id}`}
            x1="-638.224"
            x2="-638.224"
            y1="853.801"
            y2="852.801"
            gradientTransform="matrix(152.4666 7.9904 3.0934 -59.0251 94939.86 55646.855)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#2f8a00"></stop>
            <stop offset="1" stop-color="#90ff57"></stop>
          </linearGradient>
          <path
            fill={`url(#w-${id})`}
            fill-rule="evenodd"
            stroke="#2F8A00"
            stroke-width="13"
            d="M194.9 184.5c31.9-30 64.1-39.7 96.7-29 32.6 10.7 50.8 30.4 54.6 59.1-35.2-5.5-60.4-9.6-75.8-12.1-15.3-2.6-40.5-8.6-75.5-18z"
            clip-rule="evenodd"
          ></path>
          <linearGradient
            id={`x-${id}`}
            x1="-637.723"
            x2="-637.723"
            y1="855.103"
            y2="854.103"
            gradientTransform="matrix(136.467 7.1519 5.2165 -99.5377 82830.875 89859.578)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#2f8a00"></stop>
            <stop offset="1" stop-color="#90ff57"></stop>
          </linearGradient>
          <path
            fill={`url(#x-${id})`}
            fill-rule="evenodd"
            stroke="#2F8A00"
            stroke-width="13"
            d="M194.9 184.5c35.8-7.6 65.6-.2 89.2 22 23.6 22.2 37.7 49 42.3 80.3-39.8-9.7-68.3-23.8-85.5-42.4-17.2-18.5-32.5-38.5-46-59.9z"
            clip-rule="evenodd"
          ></path>
          <linearGradient
            id={`y-${id}`}
            x1="-631.79"
            x2="-631.79"
            y1="855.872"
            y2="854.872"
            gradientTransform="matrix(60.8683 3.19 8.7771 -167.4773 31110.818 145537.61)"
            gradientUnits="userSpaceOnUse"
          >
            <stop offset="0" stop-color="#2f8a00"></stop>
            <stop offset="1" stop-color="#90ff57"></stop>
          </linearGradient>
          <path
            fill={`url(#y-${id})`}
            fill-rule="evenodd"
            stroke="#2F8A00"
            stroke-width="13"
            d="M194.9 184.5c-33.6 13.8-53.6 35.7-60.1 65.6-6.5 29.9-3.6 63.1 8.7 99.6 27.4-40.3 43.2-69.6 47.4-88 4.2-18.3 5.5-44.1 4-77.2z"
            clip-rule="evenodd"
          ></path>
          <path
            fill="none"
            stroke="#2F8A00"
            stroke-linecap="round"
            stroke-width="8"
            d="M196.5 182.3c-14.8 21.6-25.1 41.4-30.8 59.4-5.7 18-9.4 33-11.1 45.1"
          ></path>
          <path
            fill="none"
            stroke="#2F8A00"
            stroke-linecap="round"
            stroke-width="8"
            d="M194.8 185.7c-24.4 1.7-43.8 9-58.1 21.8-14.3 12.8-24.7 25.4-31.3 37.8m99.1-68.9c29.7-6.7 52-8.4 67-5 15 3.4 26.9 8.7 35.8 15.9m-110.8-5.9c20.3 9.9 38.2 20.5 53.9 31.9 15.7 11.4 27.4 22.1 35.1 32"
          ></path>
        </g>
        <defs>
          <filter
            id={`z-${id}`}
            width="532"
            height="633"
            x="50.5"
            y="399"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`A-${id}`}
          width="532"
          height="633"
          x="50.5"
          y="399"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#z-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <linearGradient
          id={`B-${id}`}
          x1="-641.104"
          x2="-641.278"
          y1="856.577"
          y2="856.183"
          gradientTransform="matrix(532 0 0 -633 341484.5 542657)"
          gradientUnits="userSpaceOnUse"
        >
          <stop offset="0" stop-color="#fff400"></stop>
          <stop offset="1" stop-color="#3c8700"></stop>
        </linearGradient>
        <ellipse
          cx="316.5"
          cy="715.5"
          fill={`url(#B-${id})`}
          fill-rule="evenodd"
          clip-rule="evenodd"
          mask={`url(#A-${id})`}
          rx="266"
          ry="316.5"
        ></ellipse>
        <defs>
          <filter
            id={`C-${id}`}
            width="288"
            height="283"
            x="391"
            y="-24"
            filterUnits="userSpaceOnUse"
          >
            <feColorMatrix values="1 0 0 0 0 0 1 0 0 0 0 0 1 0 0 0 0 0 1 0"></feColorMatrix>
          </filter>
        </defs>
        <mask
          id={`D-${id}`}
          width="288"
          height="283"
          x="391"
          y="-24"
          maskUnits="userSpaceOnUse"
        >
          <g filter={`url(#C-${id})`}>
            <circle
              cx="316.5"
              cy="316.5"
              r="316.5"
              fill="#FFF"
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
          </g>
        </mask>
        <g mask={`url(#D-${id})`}>
          <g transform="translate(397 -24)">
            <linearGradient
              id={`E-${id}`}
              x1="-1036.672"
              x2="-1036.672"
              y1="880.018"
              y2="879.018"
              gradientTransform="matrix(227 0 0 -227 235493 199764)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffdf00"></stop>
              <stop offset="1" stop-color="#ff9d00"></stop>
            </linearGradient>
            <circle
              cx="168.5"
              cy="113.5"
              r="113.5"
              fill={`url(#E-${id})`}
              fill-rule="evenodd"
              clip-rule="evenodd"
            ></circle>
            <linearGradient
              id={`F-${id}`}
              x1="-1017.329"
              x2="-1018.602"
              y1="658.003"
              y2="657.998"
              gradientTransform="matrix(30 0 0 -1 30558 771)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#F-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M30 113H0"
            ></path>
            <linearGradient
              id={`G-${id}`}
              x1="-1014.501"
              x2="-1015.774"
              y1="839.985"
              y2="839.935"
              gradientTransform="matrix(26.5 0 0 -5.5 26925 4696.5)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#G-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M33.5 79.5L7 74"
            ></path>
            <linearGradient
              id={`H-${id}`}
              x1="-1016.59"
              x2="-1017.862"
              y1="852.671"
              y2="852.595"
              gradientTransform="matrix(29 0 0 -8 29523 6971)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#H-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M34 146l-29 8"
            ></path>
            <linearGradient
              id={`I-${id}`}
              x1="-1011.984"
              x2="-1013.257"
              y1="863.523"
              y2="863.229"
              gradientTransform="matrix(24 0 0 -13 24339 11407)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#I-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M45 177l-24 13"
            ></path>
            <linearGradient
              id={`J-${id}`}
              x1="-1006.673"
              x2="-1007.946"
              y1="869.279"
              y2="868.376"
              gradientTransform="matrix(20 0 0 -19 20205 16720)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#J-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M67 204l-20 19"
            ></path>
            <linearGradient
              id={`K-${id}`}
              x1="-992.85"
              x2="-993.317"
              y1="871.258"
              y2="870.258"
              gradientTransform="matrix(13.8339 0 0 -22.8467 13825.796 20131.938)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#K-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M94.4 227l-13.8 22.8"
            ></path>
            <linearGradient
              id={`L-${id}`}
              x1="-953.835"
              x2="-953.965"
              y1="871.9"
              y2="870.9"
              gradientTransform="matrix(7.5 0 0 -24.5 7278 21605)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#L-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M127.5 243.5L120 268"
            ></path>
            <linearGradient
              id={`M-${id}`}
              x1="244.504"
              x2="244.496"
              y1="871.898"
              y2="870.898"
              gradientTransform="matrix(.5 0 0 -24.5 45.5 21614)"
              gradientUnits="userSpaceOnUse"
            >
              <stop offset="0" stop-color="#ffa400"></stop>
              <stop offset="1" stop-color="#ff5e00"></stop>
            </linearGradient>
            <path
              fill="none"
              stroke={`url(#M-${id})`}
              stroke-linecap="round"
              stroke-linejoin="bevel"
              stroke-width="12"
              d="M167.5 252.5l.5 24.5"
            ></path>
          </g>
        </g>
      </g>
    </svg>
  )
}
