export declare const tokens: {
    readonly colors: {
        readonly inherit: "inherit";
        readonly current: "currentColor";
        readonly transparent: "transparent";
        readonly black: "#000000";
        readonly white: "#ffffff";
        readonly neutral: {
            readonly 50: "#f9fafb";
            readonly 100: "#f2f4f7";
            readonly 200: "#eaecf0";
            readonly 300: "#d0d5dd";
            readonly 400: "#98a2b3";
            readonly 500: "#667085";
            readonly 600: "#475467";
            readonly 700: "#344054";
            readonly 800: "#1d2939";
            readonly 900: "#101828";
        };
        readonly darkGray: {
            readonly 50: "#525c7a";
            readonly 100: "#49536e";
            readonly 200: "#414962";
            readonly 300: "#394056";
            readonly 400: "#313749";
            readonly 500: "#292e3d";
            readonly 600: "#212530";
            readonly 700: "#191c24";
            readonly 800: "#111318";
            readonly 900: "#0b0d10";
        };
        readonly gray: {
            readonly 50: "#f9fafb";
            readonly 100: "#f2f4f7";
            readonly 200: "#eaecf0";
            readonly 300: "#d0d5dd";
            readonly 400: "#98a2b3";
            readonly 500: "#667085";
            readonly 600: "#475467";
            readonly 700: "#344054";
            readonly 800: "#1d2939";
            readonly 900: "#101828";
        };
        readonly blue: {
            readonly 25: "#F5FAFF";
            readonly 50: "#EFF8FF";
            readonly 100: "#D1E9FF";
            readonly 200: "#B2DDFF";
            readonly 300: "#84CAFF";
            readonly 400: "#53B1FD";
            readonly 500: "#2E90FA";
            readonly 600: "#1570EF";
            readonly 700: "#175CD3";
            readonly 800: "#1849A9";
            readonly 900: "#194185";
        };
        readonly green: {
            readonly 25: "#F6FEF9";
            readonly 50: "#ECFDF3";
            readonly 100: "#D1FADF";
            readonly 200: "#A6F4C5";
            readonly 300: "#6CE9A6";
            readonly 400: "#32D583";
            readonly 500: "#12B76A";
            readonly 600: "#039855";
            readonly 700: "#027A48";
            readonly 800: "#05603A";
            readonly 900: "#054F31";
        };
        readonly red: {
            readonly 50: "#fef2f2";
            readonly 100: "#fee2e2";
            readonly 200: "#fecaca";
            readonly 300: "#fca5a5";
            readonly 400: "#f87171";
            readonly 500: "#ef4444";
            readonly 600: "#dc2626";
            readonly 700: "#b91c1c";
            readonly 800: "#991b1b";
            readonly 900: "#7f1d1d";
            readonly 950: "#450a0a";
        };
        readonly yellow: {
            readonly 25: "#FFFCF5";
            readonly 50: "#FFFAEB";
            readonly 100: "#FEF0C7";
            readonly 200: "#FEDF89";
            readonly 300: "#FEC84B";
            readonly 400: "#FDB022";
            readonly 500: "#F79009";
            readonly 600: "#DC6803";
            readonly 700: "#B54708";
            readonly 800: "#93370D";
            readonly 900: "#7A2E0E";
        };
        readonly purple: {
            readonly 25: "#FAFAFF";
            readonly 50: "#F4F3FF";
            readonly 100: "#EBE9FE";
            readonly 200: "#D9D6FE";
            readonly 300: "#BDB4FE";
            readonly 400: "#9B8AFB";
            readonly 500: "#7A5AF8";
            readonly 600: "#6938EF";
            readonly 700: "#5925DC";
            readonly 800: "#4A1FB8";
            readonly 900: "#3E1C96";
        };
        readonly teal: {
            readonly 25: "#F6FEFC";
            readonly 50: "#F0FDF9";
            readonly 100: "#CCFBEF";
            readonly 200: "#99F6E0";
            readonly 300: "#5FE9D0";
            readonly 400: "#2ED3B7";
            readonly 500: "#15B79E";
            readonly 600: "#0E9384";
            readonly 700: "#107569";
            readonly 800: "#125D56";
            readonly 900: "#134E48";
        };
        readonly pink: {
            readonly 25: "#fdf2f8";
            readonly 50: "#fce7f3";
            readonly 100: "#fbcfe8";
            readonly 200: "#f9a8d4";
            readonly 300: "#f472b6";
            readonly 400: "#ec4899";
            readonly 500: "#db2777";
            readonly 600: "#be185d";
            readonly 700: "#9d174d";
            readonly 800: "#831843";
            readonly 900: "#500724";
        };
        readonly cyan: {
            readonly 25: "#ecfeff";
            readonly 50: "#cffafe";
            readonly 100: "#a5f3fc";
            readonly 200: "#67e8f9";
            readonly 300: "#22d3ee";
            readonly 400: "#06b6d4";
            readonly 500: "#0891b2";
            readonly 600: "#0e7490";
            readonly 700: "#155e75";
            readonly 800: "#164e63";
            readonly 900: "#083344";
        };
    };
    readonly alpha: {
        readonly 100: "ff";
        readonly 90: "e5";
        readonly 80: "cc";
        readonly 70: "b3";
        readonly 60: "99";
        readonly 50: "80";
        readonly 40: "66";
        readonly 30: "4d";
        readonly 20: "33";
        readonly 10: "1a";
        readonly 0: "00";
    };
    readonly font: {
        readonly size: {
            readonly '2xs': "calc(var(--tsrd-font-size) * 0.625)";
            readonly xs: "calc(var(--tsrd-font-size) * 0.75)";
            readonly sm: "calc(var(--tsrd-font-size) * 0.875)";
            readonly md: "var(--tsrd-font-size)";
            readonly lg: "calc(var(--tsrd-font-size) * 1.125)";
            readonly xl: "calc(var(--tsrd-font-size) * 1.25)";
            readonly '2xl': "calc(var(--tsrd-font-size) * 1.5)";
            readonly '3xl': "calc(var(--tsrd-font-size) * 1.875)";
            readonly '4xl': "calc(var(--tsrd-font-size) * 2.25)";
            readonly '5xl': "calc(var(--tsrd-font-size) * 3)";
            readonly '6xl': "calc(var(--tsrd-font-size) * 3.75)";
            readonly '7xl': "calc(var(--tsrd-font-size) * 4.5)";
            readonly '8xl': "calc(var(--tsrd-font-size) * 6)";
            readonly '9xl': "calc(var(--tsrd-font-size) * 8)";
        };
        readonly lineHeight: {
            readonly '3xs': "calc(var(--tsrd-font-size) * 0.75)";
            readonly '2xs': "calc(var(--tsrd-font-size) * 0.875)";
            readonly xs: "calc(var(--tsrd-font-size) * 1)";
            readonly sm: "calc(var(--tsrd-font-size) * 1.25)";
            readonly md: "calc(var(--tsrd-font-size) * 1.5)";
            readonly lg: "calc(var(--tsrd-font-size) * 1.75)";
            readonly xl: "calc(var(--tsrd-font-size) * 2)";
            readonly '2xl': "calc(var(--tsrd-font-size) * 2.25)";
            readonly '3xl': "calc(var(--tsrd-font-size) * 2.5)";
            readonly '4xl': "calc(var(--tsrd-font-size) * 2.75)";
            readonly '5xl': "calc(var(--tsrd-font-size) * 3)";
            readonly '6xl': "calc(var(--tsrd-font-size) * 3.25)";
            readonly '7xl': "calc(var(--tsrd-font-size) * 3.5)";
            readonly '8xl': "calc(var(--tsrd-font-size) * 3.75)";
            readonly '9xl': "calc(var(--tsrd-font-size) * 4)";
        };
        readonly weight: {
            readonly thin: "100";
            readonly extralight: "200";
            readonly light: "300";
            readonly normal: "400";
            readonly medium: "500";
            readonly semibold: "600";
            readonly bold: "700";
            readonly extrabold: "800";
            readonly black: "900";
        };
        readonly fontFamily: {
            readonly sans: "ui-sans-serif, Inter, system-ui, sans-serif, sans-serif";
            readonly mono: "ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, 'Liberation Mono', 'Courier New', monospace";
        };
    };
    readonly breakpoints: {
        readonly xs: "320px";
        readonly sm: "640px";
        readonly md: "768px";
        readonly lg: "1024px";
        readonly xl: "1280px";
        readonly '2xl': "1536px";
    };
    readonly border: {
        readonly radius: {
            readonly none: "0px";
            readonly xs: "calc(var(--tsrd-font-size) * 0.125)";
            readonly sm: "calc(var(--tsrd-font-size) * 0.25)";
            readonly md: "calc(var(--tsrd-font-size) * 0.375)";
            readonly lg: "calc(var(--tsrd-font-size) * 0.5)";
            readonly xl: "calc(var(--tsrd-font-size) * 0.75)";
            readonly '2xl': "calc(var(--tsrd-font-size) * 1)";
            readonly '3xl': "calc(var(--tsrd-font-size) * 1.5)";
            readonly full: "9999px";
        };
    };
    readonly size: {
        readonly 0: "0px";
        readonly 0.25: "calc(var(--tsrd-font-size) * 0.0625)";
        readonly 0.5: "calc(var(--tsrd-font-size) * 0.125)";
        readonly 1: "calc(var(--tsrd-font-size) * 0.25)";
        readonly 1.5: "calc(var(--tsrd-font-size) * 0.375)";
        readonly 2: "calc(var(--tsrd-font-size) * 0.5)";
        readonly 2.5: "calc(var(--tsrd-font-size) * 0.625)";
        readonly 3: "calc(var(--tsrd-font-size) * 0.75)";
        readonly 3.5: "calc(var(--tsrd-font-size) * 0.875)";
        readonly 4: "calc(var(--tsrd-font-size) * 1)";
        readonly 4.5: "calc(var(--tsrd-font-size) * 1.125)";
        readonly 5: "calc(var(--tsrd-font-size) * 1.25)";
        readonly 5.5: "calc(var(--tsrd-font-size) * 1.375)";
        readonly 6: "calc(var(--tsrd-font-size) * 1.5)";
        readonly 6.5: "calc(var(--tsrd-font-size) * 1.625)";
        readonly 7: "calc(var(--tsrd-font-size) * 1.75)";
        readonly 8: "calc(var(--tsrd-font-size) * 2)";
        readonly 9: "calc(var(--tsrd-font-size) * 2.25)";
        readonly 10: "calc(var(--tsrd-font-size) * 2.5)";
        readonly 11: "calc(var(--tsrd-font-size) * 2.75)";
        readonly 12: "calc(var(--tsrd-font-size) * 3)";
        readonly 14: "calc(var(--tsrd-font-size) * 3.5)";
        readonly 16: "calc(var(--tsrd-font-size) * 4)";
        readonly 20: "calc(var(--tsrd-font-size) * 5)";
        readonly 24: "calc(var(--tsrd-font-size) * 6)";
        readonly 28: "calc(var(--tsrd-font-size) * 7)";
        readonly 32: "calc(var(--tsrd-font-size) * 8)";
        readonly 36: "calc(var(--tsrd-font-size) * 9)";
        readonly 40: "calc(var(--tsrd-font-size) * 10)";
        readonly 44: "calc(var(--tsrd-font-size) * 11)";
        readonly 48: "calc(var(--tsrd-font-size) * 12)";
        readonly 52: "calc(var(--tsrd-font-size) * 13)";
        readonly 56: "calc(var(--tsrd-font-size) * 14)";
        readonly 60: "calc(var(--tsrd-font-size) * 15)";
        readonly 64: "calc(var(--tsrd-font-size) * 16)";
        readonly 72: "calc(var(--tsrd-font-size) * 18)";
        readonly 80: "calc(var(--tsrd-font-size) * 20)";
        readonly 96: "calc(var(--tsrd-font-size) * 24)";
    };
    readonly shadow: {
        readonly xs: (_?: string) => "0 1px 2px 0 rgb(0 0 0 / 0.05)";
        readonly sm: (color?: string) => `0 1px 3px 0 ${string}, 0 1px 2px -1px ${string}`;
        readonly md: (color?: string) => `0 4px 6px -1px ${string}, 0 2px 4px -2px ${string}`;
        readonly lg: (color?: string) => `0 10px 15px -3px ${string}, 0 4px 6px -4px ${string}`;
        readonly xl: (color?: string) => `0 20px 25px -5px ${string}, 0 8px 10px -6px ${string}`;
        readonly '2xl': (color?: string) => `0 25px 50px -12px ${string}`;
        readonly inner: (color?: string) => `inset 0 2px 4px 0 ${string}`;
        readonly none: () => "none";
    };
    readonly zIndices: {
        readonly hide: -1;
        readonly auto: "auto";
        readonly base: 0;
        readonly docked: 10;
        readonly dropdown: 1000;
        readonly sticky: 1100;
        readonly banner: 1200;
        readonly overlay: 1300;
        readonly modal: 1400;
        readonly popover: 1500;
        readonly skipLink: 1600;
        readonly toast: 1700;
        readonly tooltip: 1800;
    };
};
