import type { Encoding } from './Encoding.js';
/**
 * Converts a DataView to a string.
 *
 * @param dataView - The DataView to convert.
 * @param encoding - The encoding to use.
 * @returns The string representation of the DataView.
 *
 * @group Utils
 *
 * @beta
 *
 * @example
 * {@includeCode ../../test/utils/dataViewToString.test.ts#example}
 */
export declare function dataViewToString(dataView: DataView, encoding?: Encoding): string;
//# sourceMappingURL=dataViewToString.d.ts.map