/**
 * Parse a UrnBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed UrnBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function urn(view) {
    return {
        ...view.readFullBox(),
        name: view.readString(-1),
        location: view.readString(-1),
    };
}
;
//# sourceMappingURL=urn.js.map