/**
 * Parse a TrackExtendsBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackExtendsBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function trex(view) {
    return {
        ...view.readFullBox(),
        trackId: view.readUint(4),
        defaultSampleDescriptionIndex: view.readUint(4),
        defaultSampleDuration: view.readUint(4),
        defaultSampleSize: view.readUint(4),
        defaultSampleFlags: view.readUint(4),
    };
}
;
//# sourceMappingURL=trex.js.map