/**
 * Parse a TrackFragmentHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackFragmentHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function tfhd(view) {
    const { version, flags } = view.readFullBox();
    return {
        version,
        flags,
        trackId: view.readUint(4),
        baseDataOffset: flags & 0x01 ? view.readUint(8) : undefined,
        sampleDescriptionOffset: flags & 0x02 ? view.readUint(4) : undefined,
        defaultSampleDuration: flags & 0x08 ? view.readUint(4) : undefined,
        defaultSampleSize: flags & 0x10 ? view.readUint(4) : undefined,
        defaultSampleFlags: flags & 0x20 ? view.readUint(4) : undefined,
    };
}
;
//# sourceMappingURL=tfhd.js.map