/**
 * Parse a TrackFragmentDecodeTimeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackFragmentDecodeTimeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function tfdt(view) {
    const { version, flags } = view.readFullBox();
    return {
        version,
        flags,
        baseMediaDecodeTime: view.readUint((version == 1) ? 8 : 4),
    };
}
;
//# sourceMappingURL=tfdt.js.map