/**
 * Parse a SyncSampleBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SyncSampleBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function stss(view) {
    const { version, flags } = view.readFullBox();
    const entryCount = view.readUint(4);
    return {
        version,
        flags,
        entryCount,
        entries: view.readEntries(entryCount, () => ({
            sampleNumber: view.readUint(4),
        })),
    };
}
;
//# sourceMappingURL=stss.js.map