import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Segment index reference
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type Reference = {
    reference: number;
    subsegmentDuration: number;
    sap: number;
    referenceType: number;
    referencedSize: number;
    startsWithSap: number;
    sapType: number;
    sapDeltaTime: number;
};
/**
 * ISO/IEC 14496-12:2012 - 8.16.3 Segment Index Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SegmentIndexBox = FullBox & {
    referenceId: number;
    timescale: number;
    earliestPresentationTime: number;
    firstOffset: number;
    reserved: number;
    references: Reference[];
};
/**
 * Parse a SegmentIndexBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SegmentIndexBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function sidx(view: IsoView): SegmentIndexBox;
//# sourceMappingURL=sidx.d.ts.map