import { UINT } from '../fields/UINT.js';
//
/**
 * Parse a SampleDependencyTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SampleDependencyTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function sdtp(view) {
    return {
        ...view.readFullBox(),
        sampleDependencyTable: view.readArray(UINT, 1, view.bytesRemaining),
    };
}
;
//# sourceMappingURL=sdtp.js.map