import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.12.5 Scheme Type Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SchemeTypeBox = FullBox & {
    schemeType: number;
    schemeVersion: number;
    schemeUri?: string;
};
/**
 * Parse a SchemeTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SchemeTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function schm(view: IsoView): SchemeTypeBox;
//# sourceMappingURL=schm.d.ts.map