import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.16.5 Producer Reference Time
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type ProducerReferenceTimeBox = FullBox & {
    referenceTrackId: number;
    ntpTimestampSec: number;
    ntpTimestampFrac: number;
    mediaTime: number;
};
/**
 * Parse a ProducerReferenceTimeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed ProducerReferenceTimeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function prft(view: IsoView): ProducerReferenceTimeBox;
//# sourceMappingURL=prft.d.ts.map