/**
 * Parse a MovieFragmentRandomAccessBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MovieFragmentRandomAccessBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function mfro(view) {
    return {
        ...view.readFullBox(),
        mfra_size: view.readUint(4),
    };
}
;
//# sourceMappingURL=mfro.js.map