import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.1.1 Media Data Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type MediaDataBox = {
    data: Uint8Array;
};
/**
 * Parse a MediaDataBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MediaDataBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function mdat(view: IsoView): MediaDataBox;
//# sourceMappingURL=mdat.d.ts.map