import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:202x - 8.10.5 Label box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type LabelBox = FullBox & {
    isGroupLabel: boolean;
    labelId: number;
    language: string;
    label: string;
};
/**
 * Parse a LabelBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed LabelBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function labl(view: IsoView): LabelBox;
//# sourceMappingURL=labl.d.ts.map