/**
 * Parse a TrackKinBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackKindBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function kind(view) {
    return {
        ...view.readFullBox(),
        schemeUri: view.readUtf8(-1),
        value: view.readUtf8(-1),
    };
}
;
//# sourceMappingURL=kind.js.map