import { UINT } from '../fields/UINT.js';
/**
 * Parse a HandlerReferenceBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed HandlerReferenceBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function hdlr(view) {
    return {
        ...view.readFullBox(),
        preDefined: view.readUint(4),
        handlerType: view.readString(4),
        reserved: view.readArray(UINT, 4, 3),
        name: view.readString(-1),
    };
}
;
//# sourceMappingURL=hdlr.js.map