import { STRING } from '../fields/STRING.js';
/**
 * Parse a FileTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed FileTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function ftyp(view) {
    const size = 4;
    const majorBrand = view.readString(4);
    const minorVersion = view.readUint(4);
    const length = view.bytesRemaining / size;
    const compatibleBrands = view.readArray(STRING, size, length);
    return {
        majorBrand,
        minorVersion,
        compatibleBrands,
    };
}
//# sourceMappingURL=ftyp.js.map