import type { IsoView } from '../IsoView.js';
import type { TypeBox } from '../TypeBox.js';
/**
 * ISO/IEC 14496-12:2012 - 4.3 File Type Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type FileTypeBox = TypeBox;
/**
 * Parse a FileTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed FileTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function ftyp(view: IsoView): FileTypeBox;
//# sourceMappingURL=ftyp.d.ts.map