import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.1.2 Free Space Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type FreeSpaceBox = {
    data: Uint8Array;
};
/**
 * Parse a Box from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function free(view: IsoView): FreeSpaceBox;
//# sourceMappingURL=free.d.ts.map