/**
 * Parse a CompositionTimeToSampleBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed CompositionTimeToSampleBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function ctts(view) {
    const { version, flags } = view.readFullBox();
    const read = version === 1 ? view.readInt : view.readUint;
    const entryCount = view.readUint(4);
    const entries = view.readEntries(entryCount, () => ({
        sampleCount: view.readUint(4),
        sampleOffset: read(4),
    }));
    return {
        version,
        flags,
        entryCount,
        entries,
    };
}
;
//# sourceMappingURL=ctts.js.map