import { createIsoView } from './createIsoView.js';
/**
 * Parse boxes from an IsoView
 *
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The parsed boxes
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function parseBoxes(raw, config) {
    const boxes = [];
    for (const box of createIsoView(raw, config)) {
        boxes.push(box);
    }
    return boxes;
}
//# sourceMappingURL=parseBoxes.js.map