import { findBox } from './findBox.js';
/**
 * Find a box from an IsoView that matches a given type
 *
 * @param type - The type of box to find
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The first box that matches the type
 *
 * @group ISOBMFF
 *
 * @beta
 */
export function findBoxByType(type, raw, config = {}) {
    return findBox(raw, config, box => box.type === type);
}
//# sourceMappingURL=findBoxByType.js.map