import { createIsoView } from './createIsoView.js';
function filter(iterator, recursive, fn, boxes = []) {
    for (const box of iterator) {
        if (fn(box)) {
            boxes.push(box);
        }
        if (recursive && Array.isArray(box.boxes)) {
            filter(box.boxes, recursive, fn, boxes);
        }
    }
    return boxes;
}
/**
 * Filters boxes based on the given filter function.
 *
 * @param raw - The raw boxes to filter.
 * @param config - The box parser configuration.
 * @param fn - The filter function.
 * @returns The filtered boxes.
 *
 * @group ISOBMFF
 * @beta
 */
export function filterBoxes(raw, config, fn) {
    return filter(createIsoView(raw, { ...config, recursive: false }), !!config.recursive, fn);
}
//# sourceMappingURL=filterBoxes.js.map