import type { KeySystemConfiguration } from '../common/KeySystemConfiguration.js';
import type { MediaCapability } from '../common/MediaCapability.js';
/**
 * Filters and returns the supported key system configuration for a given system string.
 *
 * @param keySystemString - Key system string such as 'com.widevine.alpha'
 * @param configs - An array of key system configurations.
 * @returns The first supported configuration or null if none are supported.
 *
 * @group DRM
 * @beta
 */
export declare function getSupportedKeySystemConfiguration(keySystemString: string, configs: KeySystemConfiguration[]): {
    supportedAudio: MediaCapability[];
    supportedVideo: MediaCapability[];
};
//# sourceMappingURL=getSupportedKeySystemConfiguration.d.ts.map