import type { ContentProtection } from '../common/ContentProtection.js';
/**
 * Parse a standard common encryption PSSH which contains a simple
 * base64-encoding of the init data
 *
 * @param cpData - The ContentProtection element that may contain PSSH data.
 * @param BASE64 - The BASE64 reference.
 * @returns init data as an ArrayBuffer, or null if not found.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/cenc/parseInitDataFromContentProtection.test.ts#example}
 */
export declare function parseInitDataFromContentProtection(cpData: ContentProtection, BASE64: {
    decodeArray: (input: string) => Uint8Array;
}): ArrayBuffer | null;
//# sourceMappingURL=parseInitDataFromContentProtection.d.ts.map