import { CBCS } from '../common/CBCS.js';
import { CENC } from '../common/CENC.js';
import { MP4_PROTECTION_SCHEME } from '../common/MP4_PROTECTION_SCHEME.js';
/**
 * Finds and returns the ContentProtection element for MP4 Common Encryption.
 *
 * @param cpArray - Array of ContentProtection elements.
 * @returns The Common Encryption content protection element, or null if not found.
 *
 * @group DRM
 * @beta
 *
 * @example
 * {@includeCode ../../../test/drm/cenc/findCencContentProtection.test.ts#example}
 */
export function findCencContentProtection(cpArray) {
    var _a;
    if (!cpArray) {
        return null;
    }
    for (const cp of cpArray) {
        if (((_a = cp.schemeIdUri) === null || _a === void 0 ? void 0 : _a.toLowerCase()) === MP4_PROTECTION_SCHEME &&
            cp.value &&
            (cp.value.toLowerCase() === CENC ||
                cp.value.toLowerCase() === CBCS)) {
            return cp;
        }
    }
    return null;
}
//# sourceMappingURL=findCencContentProtection.js.map