import { audioGroupsToSwitchingSets } from './audioGroupsToSwitchingSets.js';
import { subtitleGroupsToSwitchingSets } from './subtitleGroupsToSwitchingSets.js';
import { videoPlaylistsToSwitchingSets } from './videoPlaylistsToSwitchingSets.js';
import { parseHlsManifest } from '../../../utils/hls/parseHlsManifest.js';
import { addMetadataToHls } from '../../../utils/manifest/addMetadataToHls.js';
export function mapHlsToHam(manifest) {
    var _a, _b;
    const mainManifestParsed = parseHlsManifest(manifest.manifest);
    const manifestHls = addMetadataToHls(manifest, mainManifestParsed);
    const selectionSets = [];
    const manifestPlaylists = manifestHls.ancillaryManifests
        ? [...manifestHls.ancillaryManifests]
        : [];
    const audioSwitchingSets = audioGroupsToSwitchingSets((_a = mainManifestParsed.mediaGroups) === null || _a === void 0 ? void 0 : _a.AUDIO, manifestPlaylists);
    const subtitleSwitchingSets = subtitleGroupsToSwitchingSets((_b = mainManifestParsed.mediaGroups) === null || _b === void 0 ? void 0 : _b.SUBTITLES, manifestPlaylists);
    const videoSwitchingSets = videoPlaylistsToSwitchingSets(mainManifestParsed.playlists, manifestPlaylists);
    let selectionSetId = 0;
    if (audioSwitchingSets.length > 0) {
        selectionSets.push({
            id: (selectionSetId++).toString(),
            switchingSets: audioSwitchingSets,
        });
    }
    if (subtitleSwitchingSets.length > 0) {
        selectionSets.push({
            id: (selectionSetId++).toString(),
            switchingSets: subtitleSwitchingSets,
        });
    }
    if (videoSwitchingSets.length > 0) {
        selectionSets.push({
            id: (selectionSetId++).toString(),
            switchingSets: videoSwitchingSets,
        });
    }
    let presentationId = 0;
    return [
        { id: (presentationId++).toString(), selectionSets: selectionSets },
    ];
}
//# sourceMappingURL=mapHlsToHam.js.map