"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.vmhd = vmhd;
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse a VideoMediaHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed VideoMediaHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function vmhd(view) {
    return {
        ...view.readFullBox(),
        graphicsmode: view.readUint(2),
        opcolor: view.readArray(UINT_js_1.UINT, 2, 3),
    };
}
;
//# sourceMappingURL=vmhd.js.map