"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tkhd = tkhd;
const TEMPLATE_js_1 = require("../fields/TEMPLATE.js");
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse a TrackHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function tkhd(view) {
    const { version, flags } = view.readFullBox();
    const size = version === 1 ? 8 : 4;
    return {
        version,
        flags,
        creationTime: view.readUint(size),
        modificationTime: view.readUint(size),
        trackId: view.readUint(4),
        reserved1: view.readUint(4),
        duration: view.readUint(size),
        reserved2: view.readArray(UINT_js_1.UINT, 4, 2),
        layer: view.readUint(2),
        alternateGroup: view.readUint(2),
        volume: view.readTemplate(2),
        reserved3: view.readUint(2),
        matrix: view.readArray(TEMPLATE_js_1.TEMPLATE, 4, 9),
        width: view.readTemplate(4),
        height: view.readTemplate(4),
    };
}
;
//# sourceMappingURL=tkhd.js.map