import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.3.2 Track Header Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type TrackHeaderBox = FullBox & {
    creationTime: number;
    modificationTime: number;
    trackId: number;
    reserved1: number;
    duration: number;
    reserved2: number[];
    layer: number;
    alternateGroup: number;
    volume: number;
    reserved3: number;
    matrix: number[];
    width: number;
    height: number;
};
/**
 * Parse a TrackHeaderBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackHeaderBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function tkhd(view: IsoView): TrackHeaderBox;
//# sourceMappingURL=tkhd.d.ts.map