"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.tenc = tenc;
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse a TrackEncryptionBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed TrackEncryptionBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function tenc(view) {
    return {
        ...view.readFullBox(),
        defaultIsEncrypted: view.readUint(3),
        defaultIvSize: view.readUint(1),
        defaultKid: view.readArray(UINT_js_1.UINT, 1, 16),
    };
}
;
//# sourceMappingURL=tenc.js.map