import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * Sub sample
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SubSample = {
    subsampleSize: number;
    subsamplePriority: number;
    discardable: number;
    codecSpecificParameters: number;
};
/**
 * Sub sample entry
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SubSampleEntry = {
    sampleDelta: number;
    subsampleCount: number;
    subsamples: SubSample[];
};
/**
 * ISO/IEC 14496-12:2015 - 8.7.7 Sub-Sample Information Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SubSampleInformationBox = FullBox & {
    entryCount: number;
    entries: SubSampleEntry[];
};
/**
 * Parse a SubSampleInformationBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SubSampleInformationBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function subs(view: IsoView): SubSampleInformationBox;
//# sourceMappingURL=subs.d.ts.map