import type { BoxParser } from '../BoxParser.js';
import { type TypeBox } from '../TypeBox.js';
/**
 * ISO/IEC 14496-12:2012 - 8.16.2 Segment Type Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SegmentTypeBox = TypeBox;
/**
 * Parse a SegmentTypeBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SegmentTypeBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare const styp: BoxParser<SegmentTypeBox>;
//# sourceMappingURL=styp.d.ts.map