"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ssix = ssix;
/**
 * Parse a SubsegmentIndexBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed SubsegmentIndexBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function ssix(view) {
    const { version, flags } = view.readFullBox();
    const subsegmentCount = view.readUint(4);
    const subsegments = view.readEntries(subsegmentCount, () => {
        const rangesCount = view.readUint(4);
        const ranges = view.readEntries(rangesCount, () => ({
            level: view.readUint(1),
            rangeSize: view.readUint(3),
        }));
        return { rangesCount, ranges };
    });
    return {
        version,
        flags,
        subsegmentCount,
        subsegments,
    };
}
;
//# sourceMappingURL=ssix.js.map