import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.2.2 Movie Header Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type MovieHeaderBox = {
    version: number;
    flags: number;
    creationTime: number;
    modificationTime: number;
    timescale: number;
    duration: number;
    rate: number;
    volume: number;
    reserved1: number;
    reserved2: number[];
    matrix: number[];
    preDefined: number[];
    nextTrackId: number;
};
/**
 * Parse a Box from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function mvhd(view: IsoView): MovieHeaderBox;
//# sourceMappingURL=mvhd.d.ts.map