"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mp4a = mp4a;
const UINT_js_1 = require("../fields/UINT.js");
/**
 * Parse an AudioSampleEntry from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed AudioSampleEntry
 *
 * @group ISOBMFF
 *
 * @beta
 */
function mp4a(view) {
    const { readArray, readUint, readTemplate, readData } = view;
    return {
        reserved1: readArray(UINT_js_1.UINT, 1, 6),
        dataReferenceIndex: readUint(2),
        reserved2: readArray(UINT_js_1.UINT, 4, 2),
        channelcount: readUint(2),
        samplesize: readUint(2),
        preDefined: readUint(2),
        reserved3: readUint(2),
        samplerate: readTemplate(4),
        esds: readData(-1),
    };
}
;
//# sourceMappingURL=mp4a.js.map