"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mfro = mfro;
/**
 * Parse a MovieFragmentRandomAccessBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed MovieFragmentRandomAccessBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function mfro(view) {
    return {
        ...view.readFullBox(),
        mfra_size: view.readUint(4),
    };
}
;
//# sourceMappingURL=mfro.js.map