import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2012 - 8.4.3 Handler Reference Box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type HandlerReferenceBox = {
    preDefined: number;
    handlerType: string;
    reserved: number[];
    name: string;
};
/**
 * Parse a HandlerReferenceBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed HandlerReferenceBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function hdlr(view: IsoView): HandlerReferenceBox;
//# sourceMappingURL=hdlr.d.ts.map