"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.elng = elng;
/**
 * Parse a ExtendedLanguageBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed ExtendedLanguageBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
function elng(view) {
    return {
        ...view.readFullBox(),
        extendedLanguage: view.readUtf8(-1),
    };
}
;
//# sourceMappingURL=elng.js.map