import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:2015 - 8.5.2.2 Sample Entry
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type SampleEntry = {
    reserved1: number[];
    dataReferenceIndex: number;
};
/**
 * ISO/IEC 14496-15:2014 - 12.1.3.1 avc1/2/3/4, hev1, hvc1, encv
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type VisualSampleEntry = SampleEntry & {
    preDefined1: number;
    reserved2: number;
    preDefined2: number[];
    width: number;
    height: number;
    horizresolution: number;
    vertresolution: number;
    reserved3: number;
    frameCount: number;
    compressorName: number[];
    depth: number;
    preDefined3: number;
    config: Uint8Array;
};
/**
 * Parse a VisualSampleEntryBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed VisualSampleEntryBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function avc1(view: IsoView): VisualSampleEntry;
//# sourceMappingURL=avc1.d.ts.map