import type { FullBox } from '../FullBox.js';
import type { IsoView } from '../IsoView.js';
/**
 * ISO/IEC 14496-12:202x - 12.2.8 Audio rendering indication box
 *
 * @group ISOBMFF
 *
 * @beta
 */
export type AudioRenderingIndicationBox = FullBox & {
    audioRenderingIndication: number;
};
/**
 * Parse a AudioRenderingIndicationBox from an IsoView
 *
 * @param view - The IsoView to read data from
 *
 * @returns A parsed AudioRenderingIndicationBox
 *
 * @group ISOBMFF
 *
 * @beta
 */
export declare function ardi(view: IsoView): AudioRenderingIndicationBox;
//# sourceMappingURL=ardi.d.ts.map