"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseBoxes = parseBoxes;
const createIsoView_js_1 = require("./createIsoView.js");
/**
 * Parse boxes from an IsoView
 *
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The parsed boxes
 *
 * @group ISOBMFF
 *
 * @beta
 */
function parseBoxes(raw, config) {
    const boxes = [];
    for (const box of (0, createIsoView_js_1.createIsoView)(raw, config)) {
        boxes.push(box);
    }
    return boxes;
}
//# sourceMappingURL=parseBoxes.js.map