"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findBoxByType = findBoxByType;
const findBox_js_1 = require("./findBox.js");
/**
 * Find a box from an IsoView that matches a given type
 *
 * @param type - The type of box to find
 * @param raw - The raw ISO data
 * @param config - The configuration for the IsoView
 *
 * @returns The first box that matches the type
 *
 * @group ISOBMFF
 *
 * @beta
 */
function findBoxByType(type, raw, config = {}) {
    return (0, findBox_js_1.findBox)(raw, config, box => box.type === type);
}
//# sourceMappingURL=findBoxByType.js.map