"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isId3TimestampFrame = exports.ID3_SCHEME_ID_URI = exports.getId3Timestamp = exports.getId3Frames = exports.getId3Data = exports.canParseId3 = void 0;
/**
 * @groupDescription ID3
 * A collection of tools for working with ID3v2 tags.
 *
 * @see {@link https://mutagen-specs.readthedocs.io/en/latest/id3/id3v2.4.0-structure.html | ID3v2.4.0 Structure}
 * @see {@link https://mutagen-specs.readthedocs.io/en/latest/id3/id3v2.4.0-frames.html | ID3v2.4.0 Frames}
 *
 * @packageDocumentation
 */
var canParseId3_js_1 = require("./id3/canParseId3.js");
Object.defineProperty(exports, "canParseId3", { enumerable: true, get: function () { return canParseId3_js_1.canParseId3; } });
var getId3Data_js_1 = require("./id3/getId3Data.js");
Object.defineProperty(exports, "getId3Data", { enumerable: true, get: function () { return getId3Data_js_1.getId3Data; } });
var getId3Frames_js_1 = require("./id3/getId3Frames.js");
Object.defineProperty(exports, "getId3Frames", { enumerable: true, get: function () { return getId3Frames_js_1.getId3Frames; } });
var getId3Timestamp_js_1 = require("./id3/getId3Timestamp.js");
Object.defineProperty(exports, "getId3Timestamp", { enumerable: true, get: function () { return getId3Timestamp_js_1.getId3Timestamp; } });
var ID3_SCHEME_ID_URI_js_1 = require("./id3/ID3_SCHEME_ID_URI.js");
Object.defineProperty(exports, "ID3_SCHEME_ID_URI", { enumerable: true, get: function () { return ID3_SCHEME_ID_URI_js_1.ID3_SCHEME_ID_URI; } });
var isId3TimestampFrame_js_1 = require("./id3/isId3TimestampFrame.js");
Object.defineProperty(exports, "isId3TimestampFrame", { enumerable: true, get: function () { return isId3TimestampFrame_js_1.isId3TimestampFrame; } });
//# sourceMappingURL=id3.js.map